#!/bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_CODFlags='src/lib/perl5/COD/CIF/Data/CODFlags.pm'
INPUT_Manage='src/lib/perl5/COD/CIF/Tags/Manage.pm'
#END DEPEND--------------------------------------------------------------------

perl <<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2022-01-27 18:20:01 +0200 (Thu, 27 Jan 2022) $
#$Revision: 9140 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.8.1/tests/shtests/has_unmodelled_solvent_molecules_002.sh $
#------------------------------------------------------------------------------
#* Unit test for the COD::CIF::Data::CODFlags::has_unmodelled_solvent_molecules()
#* subroutine. Test the way the '_smtbx_masks_void_count_electrons'
#* data item is handled.
#**

use strict;
use warnings;

use COD::CIF::Data::CODFlags qw( has_unmodelled_solvent_molecules );
use COD::CIF::Tags::Manage qw( new_datablock );

my @data_blocks;
my $data_block;

# Contains no data about unmodelled solvent molecules.
$data_block = new_datablock( '[NO]_empty' );
push @data_blocks, $data_block;

$data_block = new_datablock( '[YES]_0_platon_squeeze_electrons' );
$data_block->{'values'}{'_smtbx_masks_void_count_electrons'} = [ '0' ];
push @data_blocks, $data_block;

$data_block = new_datablock( '[YES]_30_platon_squeeze_electrons' );
$data_block->{'values'}{'_smtbx_masks_void_count_electrons'} = [ '30' ];
push @data_blocks, $data_block;

$data_block = new_datablock( '[YES]_?_platon_squeeze_electrons' );
$data_block->{'values'}{'_smtbx_masks_void_count_electrons'} = [ '?' ];
push @data_blocks, $data_block;

print "Output\tData block name\n";
for my $test_case (@data_blocks) {
    print has_unmodelled_solvent_molecules($test_case) . "\t" . $test_case->{'name'} . "\n";
}

END_SCRIPT
