/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2018 Univ. Grenoble Alpes, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/


#ifndef STARTIMAGING3D_H
#define STARTIMAGING3D_H

#include <Action.h>

#include <ImageAcquisitionComponent.h>

/**
* @ingroup group_sdk_actions_ImageAcquisition
*
* @brief
* Generic action to start a 3D acquisition process
*
**/
class StartImaging3DAction : public camitk::Action {

public:

    /// Default Constructor
    StartImaging3DAction(camitk::ActionExtension*);

    /// Default Destructor
    virtual ~StartImaging3DAction();

public slots:
    /** this method is automatically called when the action is triggered.
      * Call getTargets() method to get the list of components to use.
      * \note getTargets() is automatically filtered so that it only contains compatible components,
      * i.e., instances of StartImaging3D (or a subclass).
      */
    virtual ApplyStatus apply();

private:
    /// helper method to simplify the target component processing
    virtual void process(camitk::ImageAcquisitionComponent*);


};

#endif // STARTIMAGING3D_H

