//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Instrument/AlphaScanEditor.h
//! @brief     Defines class AlphaScanEditor
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_INSTRUMENT_ALPHASCANEDITOR_H
#define BORNAGAIN_GUI_VIEW_INSTRUMENT_ALPHASCANEDITOR_H

#include <QGroupBox>

class DistributionPlot;
class DistributionSelector;
class GrazingScanItem;
class SphericalAxisForm;

//! Editor for scanning inclination angles

class AlphaScanEditor : public QGroupBox {
    Q_OBJECT
public:
    AlphaScanEditor(QWidget* parent, GrazingScanItem* item, bool allow_distr);

    void updateIndicators();

signals:
    void dataChanged();

private slots:
    void onAxisTypeSelected(int index);
    void updatePlot();

private:
    DistributionSelector* m_selector;
    SphericalAxisForm* m_form;
    GrazingScanItem* m_item;
    DistributionPlot* m_plot;
};

#endif // BORNAGAIN_GUI_VIEW_INSTRUMENT_ALPHASCANEDITOR_H
