//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Job/FitSuiteItem.h
//! @brief     Defines class FitSuiteItem
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_JOB_FITSUITEITEM_H
#define BORNAGAIN_GUI_MODEL_JOB_FITSUITEITEM_H

#include <QXmlStreamReader>

class FitParameterContainerItem;
class MinimizerContainerItem;

class FitSuiteItem : public QObject {
    Q_OBJECT
public:
    explicit FitSuiteItem();

    FitParameterContainerItem* createFitParametersContainerItem();
    FitParameterContainerItem* fitParameterContainerItem();

    MinimizerContainerItem* createMinimizerContainerItem();
    MinimizerContainerItem* minimizerContainerItem();

    int updateInterval() const;
    void setUpdateInterval(int interval);

    int iterationCount() const;
    void setIterationCount(int count);

    double chi2() const;
    void setChi2(double chi2);

    void writeTo(QXmlStreamWriter* w) const;
    void readFrom(QXmlStreamReader* r);

signals:
    void iterationCountChanged(int count);
    void updateIntervalChanged(int interval);

private:
    int m_updateInterval;
    int m_iterCount;
    double m_chi2;
    std::unique_ptr<MinimizerContainerItem> m_minimizerContainer;
    std::unique_ptr<FitParameterContainerItem> m_fitContainer;
};

#endif // BORNAGAIN_GUI_MODEL_JOB_FITSUITEITEM_H
