#include "Bdef.h"

void zgupk4amxamn(MatInf)
MATINFO  *MatInf;
/*
 * Unpacks the distance and max/min matrices for the max or min operation
 */
{
   int m, n, lda, ldd, i, j;
   DCOMPLEX *A;
   short *Ad;

   m = MatInf->M;
   n = MatInf->N;
   A = (DCOMPLEX *) MatInf->A;
   lda = MatInf->lda;
   Ad = (short *) MatInf->B;
   ldd = (MatInf->ldb) * (sizeof(int) / sizeof(short));

   for (j=0; j < n; j++)
   {
/*
 *    Unpack column of max/min's
 */
      i = pvm_upkdcplx((double *) A, m, 1);
      Mpvmerror(i, "pvm_upkdcplx", __LINE__, __FILE__);
/*
 *    Unpack corresponding column of distances
 */
      i = pvm_upkshort(Ad, m, 1);
      Mpvmerror(i, "pvm_upkshort", __LINE__, __FILE__);
/*
 *    Update pointers to max/min and distance
 */
      A += lda;
      Ad += ldd;
   }
}
