//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_24.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot24(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[24] = {2.543799658568947e-02,2.291023164926246e-01,6.372902787326692e-01,1.251740632362747e+00,2.075112909852380e+00,
    3.111052455147712e+00,4.364283076935299e+00,5.840733271323610e+00,7.547704680023458e+00,9.494095330026482e+00,1.169069592605607e+01,1.415058618728575e+01,
    1.688967192852710e+01,1.992742587524246e+01,2.328793282487991e+01,2.700140605647238e+01,3.110646470904661e+01,3.565370351632816e+01,4.071159818554305e+01,
    4.637697955754001e+01,5.279543252728354e+01,6.020666696305724e+01,6.906860197530438e+01,8.055628081995049e+01};
  constexpr double aw[24] = {3.110010303779634e-01,2.539615426647586e-01,1.692044719456415e-01,9.182229707928535e-02,4.047967698460383e-02,
    1.444496157498107e-02,4.153004911977566e-03,9.563923198194101e-04,1.751504318011728e-04,2.528599027748500e-05,2.847258691734871e-06,2.468658993669740e-07,
    1.622514135895753e-08,7.930467495165331e-10,2.815296537838210e-11,7.046932581545919e-13,1.197589865479171e-14,1.315159622658434e-16,8.730159601186705e-19,
    3.188387323505206e-21,5.564577468902242e-24,3.685036080150508e-27,5.984612693314022e-31,7.935551460773836e-36};
  constexpr double x[9216] = {  2.054737563136536e-03, -2.094562714673068e-05,  1.599713715613638e-07, -1.084574219912362e-09,  6.881786680973879e-12,
 -4.183365428266447e-14,  2.466370546073325e-16, -1.420434724372305e-18,  8.026877322734496e-21, -4.463728781584769e-23,  2.447330398953701e-25, -1.324520211816894e-27,
  1.844399518383118e-02, -1.865033698560047e-04,  1.401406733535115e-06, -9.243654720621435e-09,  5.623505117577527e-11, -3.216783291911322e-13,  1.742052185745600e-15,
 -8.926791691744026e-18,  4.295245939720174e-20, -1.904979762477717e-22,  7.457959551901994e-25, -2.268609290987141e-27,  5.096378104582430e-02, -5.070486567020802e-04,
  3.685836621132125e-06, -2.295228679151268e-08,  1.272512878785127e-10, -6.283849187476171e-13,  2.674146095608333e-15, -8.741019982425973e-18,  1.015183253656012e-20,
  1.523024522839518e-22, -1.807988339095910e-24,  1.342875476256174e-26,  9.909999277780748e-02, -9.620828152640551e-04,  6.644416023756932e-06, -3.767531199559770e-08,
  1.764621799290891e-10, -6.211455820263807e-13,  8.562722364250899e-16,  9.853014031646945e-18, -1.172874724340364e-19,  7.995976446346456e-22, -3.858190902813305e-24,
  1.073521719221445e-26,  1.620898653484059e-01, -1.522427911650481e-03,  9.790237373527546e-06, -4.815203233659220e-08,  1.637534978948518e-10, -1.053426622896144e-13,
 -3.741088220227669e-15,  3.534521684055462e-17, -1.895188931344990e-19,  5.012074163443563e-22,  2.071801381584666e-24, -3.697401953311915e-26,  2.389320283777056e-01,
 -2.152016184621459e-03,  1.258796366734860e-05, -4.981601110180421e-08,  7.109035380824985e-11,  8.041443444615039e-13, -8.302110460673642e-15,  3.954729798712757e-17,
 -3.483026550021392e-20, -1.129522461002109e-21,  1.070403462000627e-23, -4.721975576264995e-26,  3.283998948008626e-01, -2.810121856854966e-03,  1.453131433934291e-05,
 -4.007886349937455e-08, -8.683669419158741e-11,  1.695123772897184e-12, -8.873173223628889e-15,  4.851686862543685e-18,  2.846090812918672e-19, -2.268378506037624e-21,
  5.772882942300516e-24,  4.750178248483708e-26,  4.290583504327710e-01, -3.453910649742021e-03,  1.521771755550499e-05, -1.914804616553849e-08, -2.647887427503695e-10,
  2.054559744902693e-12, -3.399247897130246e-15, -5.222545170142345e-17,  4.502946420602371e-19, -7.845849896459200e-22, -1.328225332234116e-23,  1.185941375899729e-25,
  5.392836910765642e-01, -4.041160610420263e-03,  1.440957126443556e-05,  9.844261798753772e-09, -4.018424189122643e-10,  1.551855532328199e-12,  6.165598337293030e-15,
 -8.715197748708014e-17,  1.996333998668767e-19,  2.509973963147659e-21, -2.143681783563318e-23,  4.412247151061001e-27,  6.572867210927694e-01, -4.532992653270107e-03,
  1.207310548963543e-05,  4.145841939007985e-08, -4.437683766327212e-10,  2.539050273252523e-13,  1.447304256021802e-14, -6.310565925868042e-17, -3.368786788159779e-19,
  3.923189561890770e-21, -8.361779953546503e-25, -1.705884927151294e-25,  7.811388833796334e-01, -4.896441900620849e-03,  8.388682684790314e-06,  6.918152283140486e-08,
 -3.645033326784676e-10, -1.356811537635998e-12,  1.603217374680016e-14,  1.333279785129998e-17, -6.823564781351304e-19,  1.143804124619532e-21,  2.703044147708218e-23,
 -1.211924833262740e-25,  9.088012345807164e-01, -5.106702733180583e-03,  3.730208136593215e-06,  8.698722876814370e-08, -1.781940331932888e-10, -2.588913373464592e-12,
  9.001685820953842e-15,  9.058967166258959e-17, -4.664701108139777e-19, -3.368255472615946e-21,  2.445226122366650e-23,  1.261668222732180e-25,  1.038156010814997e+00,
 -5.148892417017772e-03, -1.384314042476740e-06,  9.083418634456582e-08,  6.344172784520441e-11, -2.877698099377996e-12, -3.188561688663315e-15,  1.106520359600766e-16,
  1.677412845911463e-19, -4.703485523505592e-21, -9.072885523346797e-24,  2.125318022095706e-25,  1.167040449050808e+00, -5.019200802491266e-03, -6.364732422709201e-06,
  7.971520048365173e-08,  2.881531181663681e-10, -2.075507399890252e-12, -1.373574973421702e-14,  5.693445941002326e-17,  6.624725312499175e-19, -1.269584508678241e-21,
 -3.171152321612685e-23,  4.349645158081054e-28,  1.293282439344114e+00, -4.725326789097557e-03, -1.063323428528096e-05,  5.596947507382363e-08,  4.285791834681338e-10,
 -5.374938813148673e-13, -1.676040678974747e-14, -3.058806352242755e-17,  5.851212673978539e-19,  3.156947615662912e-21, -1.556225197443672e-23, -1.936137615121343e-25,
  1.414737486854937e+00, -4.286145080659885e-03, -1.370905122101049e-05,  2.475180968190470e-08,  4.464305842307665e-10,  1.051235843477275e-12, -1.107939412299052e-14,
 -8.777968430351977e-17,  5.168463448094910e-20,  3.895423644711903e-21,  1.565089963935202e-23, -1.004690184779775e-25,  1.529326364677486e+00, -3.730597294397672e-03,
 -1.528047716210193e-05, -7.227798561942007e-09,  3.459201825893894e-10,  2.019903038086245e-12, -8.040539284097113e-16, -7.862361747673976e-17, -4.160802641896463e-19,
  7.875097494053960e-22,  2.214803494894529e-23,  9.753979414836028e-26,  1.635072745419859e+00, -3.095856763195815e-03, -1.525268586277176e-05, -3.338036635245645e-08,
  1.709522212207899e-10,  2.042881874107723e-12,  7.642591569994917e-15, -2.151257033906549e-17, -4.341156580766998e-19, -2.168098521966014e-21,  2.400903606906626e-24,
  1.078922041192837e-25,  1.730140018940942e+00, -2.424872426338672e-03, -1.376314907659030e-05, -4.889179705175937e-08, -1.295635344319949e-11,  1.276957104495467e-12,
  9.896179723439073e-15,  3.222497344037470e-17, -1.046217777496825e-19, -2.044712848962435e-21, -1.241542483696054e-23, -1.937208645610038e-26,  1.812866445165983e+00,
 -1.763449320264969e-03, -1.116129087509337e-05, -5.190758584674916e-08, -1.447462584170091e-10,  2.337160360081170e-13,  6.236753093011422e-15,  4.518934390850420e-17,
  1.775392057782087e-19, -5.075212448603034e-23, -7.007962239586911e-24, -6.131334897721129e-26,  1.881797768431228e+00, -1.157066240283800e-03, -7.954661733401314e-06,
 -4.391792859922257e-08, -1.911653292476822e-10, -5.320721737559039e-13,  6.442305335726100e-16,  2.191502637512921e-17,  1.826407193901997e-19,  9.916304596762445e-22,
  3.178244599535413e-24, -4.463155638883937e-27,  1.935716473446038e+00, -6.476599526083667e-04, -4.729458645857365e-06, -2.922764319243639e-08, -1.577264266138939e-10,
 -7.315274789693466e-13, -2.682068399816101e-15, -5.046660465135732e-18,  3.018512418309726e-20,  4.526366952142864e-22,  3.559944306563721e-24,  2.115478622300140e-26,
  1.973667268433580e+00, -2.706130747608820e-04, -2.057656336743779e-06, -1.365076591355871e-08, -8.284025886149348e-11, -4.672961217215964e-13, -2.454303102382475e-15,
 -1.187961189398568e-17, -5.148547419432284e-20, -1.847344387257755e-22, -3.930057579716750e-25,  1.425853358490085e-27,  1.994983614050621e+00, -5.212026484462409e-05,
 -4.051341474893779e-07, -2.789843594527286e-09, -1.793461946679147e-11, -1.101121425070321e-13, -6.532388171341228e-16, -3.768815943243233e-18, -2.122295607698899e-20,
 -1.168638321354492e-22, -6.296232772043877e-25, -3.317244017177509e-27,  1.973434730178026e-03, -1.971610545354237e-05,  1.475905282954043e-07, -9.808504216988071e-10,
  6.101228885157232e-12, -3.636402583359717e-14,  2.102321844685934e-16, -1.187504668723212e-18,  6.582959568321505e-21, -3.592006786775052e-23,  1.932916746575529e-25,
 -1.027069347218313e-27,  1.771972266209117e-02, -1.757209900836309e-04,  1.295676266881592e-06, -8.393173066340353e-09,  5.020010769281022e-11, -2.827192983246829e-13,
  1.510353672939237e-15, -7.656475449672757e-18,  3.660777230590374e-20, -1.626257875488498e-22,  6.488707028903737e-25, -2.124343458212565e-27,  4.899286306440730e-02,
 -4.786299940486657e-04,  3.422221639167613e-06, -2.101340317981967e-08,  1.153057694203562e-10, -5.671010915479866e-13,  2.434676683602156e-15, -8.341301146049897e-18,
  1.446569362244184e-20,  9.075020772936115e-23, -1.294044861194865e-24,  1.007295537066225e-26,  9.535517537579147e-02, -9.106888407879388e-04,  6.208846548543819e-06,
 -3.495009733006309e-08,  1.642650374573242e-10, -5.976829909885724e-13,  1.083732351320017e-15,  6.531539785764906e-18, -9.116340328737438e-20,  6.549851118315631e-22,
 -3.368153855114529e-24,  1.133317206675712e-26,  1.561532005776126e-01, -1.446372959457097e-03,  9.228048882968368e-06, -4.555338519962585e-08,  1.608254772878654e-10,
 -1.839209177957321e-13, -2.833517406901124e-15,  2.958233661816442e-17, -1.703430609782752e-19,  5.550997387014407e-22,  7.059861066043774e-25, -2.555187233414128e-26,
  2.305216138649208e-01, -2.053683153417023e-03,  1.199749289750183e-05, -4.856035452640856e-08,  8.526962754726124e-11,  6.180209205989925e-13, -7.215937441106083e-15,
  3.786069709031957e-17, -6.828632488320338e-20, -7.427923987147082e-22,  8.642906317051195e-24, -4.581962453580016e-26,  3.173888323666545e-01, -2.695816245453199e-03,
  1.404311312481264e-05, -4.120853766701671e-08, -5.504777199961744e-11,  1.484753158957686e-12, -8.621758567983418e-15,  1.270076076553896e-17,  2.075343309818769e-19,
 -2.003618869614366e-21,  7.280160247680403e-24,  2.211265324580691e-26,  4.154846384624966e-01, -3.333156946270243e-03,  1.496386164445599e-05, -2.306083736979620e-08,
 -2.246235228622534e-10,  1.957028793693390e-12, -4.664747630953648e-15, -3.836047750092254e-17,  4.137126639024437e-19, -1.215058621451424e-21, -8.342927224800613e-24,
  1.047298623731268e-25,  5.233501988022842e-01, -3.925518409883889e-03,  1.449017356842729e-05,  3.670304233413092e-09, -3.695191617803511e-10,  1.671346300654256e-12,
  3.827188696354039e-15, -7.948233452711841e-17,  2.747164559624238e-19,  1.668464130252835e-21, -2.036388005253400e-23,  4.212888487541367e-26,  6.393509012598864e-01,
 -4.434538004735328e-03,  1.252823177898465e-05,  3.441700200018122e-08, -4.353656132914995e-10,  5.789663123822428e-13,  1.257626684294848e-14, -7.164651263683552e-17,
 -1.979560060910829e-19,  3.750616952698998e-21, -7.503547974644256e-24, -1.310405061992659e-25,  7.616924499791632e-01, -4.826112797030290e-03,  9.183041104274540e-06,
  6.315336871231548e-08, -3.877741670705165e-10, -9.699817124620962e-13,  1.610741038764559e-14, -7.646259939630478e-18, -6.231114760522352e-19,  2.106729617213011e-21,
  2.086597906094722e-23, -1.554758657337013e-25,  8.884406444940091e-01, -5.072738004616441e-03,  4.755279875290440e-06,  8.373446699598037e-08, -2.276156061472839e-10,
 -2.344226584322340e-12,  1.131239228047142e-14,  7.392102404458671e-17, -5.689547102444537e-19, -2.298021425080238e-21,  2.857885956199311e-23,  6.033884196017953e-26,
  1.017545214087518e+00, -5.155594028110529e-03, -2.901232495641581e-07,  9.138572670506970e-08,  5.375933052564420e-12, -2.916596444704163e-12, -4.100354050805686e-17,
  1.132591422378627e-16, -5.812783362065782e-21, -4.874226718653059e-21,  6.162853299535879e-25,  2.235507773200597e-25,  1.146867974825695e+00, -5.066217222878254e-03,
 -5.381913588878021e-06,  8.397624225993227e-08,  2.434876868582787e-10, -2.383690874202952e-12, -1.185340710791322e-14,  7.715879660304852e-17,  5.941336954245766e-19,
 -2.516319280523323e-21, -3.009198303183996e-23,  7.348500651002126e-26,  1.274215417436093e+00, -4.807590515309799e-03, -9.920883225880372e-06,  6.271863558456835e-08,
  4.137487978868311e-10, -9.478051279240768e-13, -1.733860523347441e-14, -1.018244048828824e-17,  6.855374881204145e-19,  2.367061737530869e-21, -2.381376121406143e-23,
 -1.773401041311643e-25,  1.397375616263044e+00, -4.394506474559742e-03, -1.336852742397274e-05,  3.204761863445944e-08,  4.645986929201551e-10,  7.561569667328137e-13,
 -1.349218212917505e-14, -8.377083883924351e-17,  2.019702606295280e-19,  4.416258419104628e-21,  9.976826462090956e-24, -1.571806947217641e-25,  1.514159075420605e+00,
 -3.853090896119773e-03, -1.533267477709803e-05, -1.371714808999247e-09,  3.859393104103182e-10,  1.972716171735227e-12, -3.186391405133449e-15, -9.130559220142675e-17,
 -3.708097414083392e-19,  1.752342514666247e-21,  2.588966270466328e-23,  6.950134534225010e-26,  1.622442808305198e+00, -3.219430839884909e-03, -1.563545889099028e-05,
 -3.030853773036935e-08,  2.135868745614284e-10,  2.217434869406434e-12,  6.834210761910188e-15, -3.662470648536206e-17, -5.092079699578106e-19, -1.967632945179317e-21,
  7.854590860586189e-24,  1.396966983399574e-25,  1.720216600765001e+00, -2.537325923030476e-03, -1.435020903810785e-05, -4.888158188127854e-08,  1.502870162890475e-11,
  1.524843219109451e-12,  1.073985101677921e-14,  2.760213299928665e-17, -1.873256429218095e-19, -2.552708480975653e-21, -1.282581786367074e-23,  2.428623045105047e-27,
  1.805630067209419e+00, -1.855270172099900e-03, -1.179789574625182e-05, -5.417755697875792e-08, -1.384693243122429e-10,  3.992199539437067e-13,  7.580900140163587e-15,
  5.078174384124269e-17,  1.699792452254888e-19, -3.890879339354060e-22, -1.000909735534859e-23, -7.505155023159739e-26,  1.877038816654223e+00, -1.222864393899568e-03,
 -8.500376595008877e-06, -4.706064439449076e-08, -2.015988977941215e-10, -5.085529125911439e-13,  1.345213013897845e-15,  2.835471451277935e-17,  2.205579000408932e-19,
  1.112303745838744e-21,  2.785699482257869e-24, -1.405504291554801e-26,  1.933047878934556e+00, -6.869425851106020e-04, -5.095826364420096e-06, -3.187185370973393e-08,
 -1.730114867150177e-10, -7.974675633725345e-13, -2.807195392524728e-15, -3.790630570152989e-18,  4.928032485891948e-20,  6.150649117855202e-22,  4.597599295278514e-24,
  2.611340844968533e-26,  1.972550823400925e+00, -2.877528264274126e-04, -2.229737292223175e-06, -1.505429436914265e-08, -9.280314562116467e-11, -5.303833672472357e-13,
 -2.811018312102117e-15, -1.363644097594664e-17, -5.839998900293879e-20, -1.987765080372892e-22, -2.973912029613614e-25,  3.037485686785863e-27,  1.994768431702015e+00,
 -5.550030182218262e-05, -4.404095288576615e-07, -3.095304583571019e-09, -2.030260107471207e-11, -1.271370069693112e-13, -7.689423968089949e-16, -4.520425404466747e-18,
 -2.592087711956218e-20, -1.452258539754651e-22, -7.952880400032509e-25, -4.253347215459153e-27,  1.896859484360092e-03, -1.858085605983458e-05,  1.363828990808937e-07,
 -8.887857524795183e-10,  5.421828971666989e-12, -3.169479459585679e-14,  1.797469685502399e-16, -9.961317487469404e-19,  5.418773216852260e-21, -2.902094938422304e-23,
  1.533159115161604e-25, -8.000214631459769e-28,  1.703695036683409e-02, -1.657452151165257e-04,  1.199596991846157e-06, -7.633307505444624e-09,  4.489150352978031e-11,
 -2.489162471781144e-13,  1.311527182553627e-15, -6.573869452917499e-18,  3.119840728111937e-20, -1.384846001279459e-22,  5.596340390165496e-25, -1.926436266823872e-27,
  4.713154478224939e-02, -4.522303428760491e-04,  3.180765937597144e-06, -1.925615065813605e-08,  1.045294338329632e-10, -5.114165382887360e-13,  2.208025574253990e-15,
 -7.835299522108706e-18,  1.690031922762652e-20,  4.704081632097489e-23, -9.102538283530989e-25,  7.485240654629622e-27,  9.180916724195143e-02, -8.626518919924473e-04,
  5.804825087302741e-06, -3.241601630269772e-08,  1.525846724195549e-10, -5.697875821490944e-13,  1.229139296496498e-15,  3.966553251162417e-18, -6.988924818307363e-20,
  5.301753714936231e-22, -2.875109096740519e-24,  1.095889689518974e-26,  1.505119568244552e-01, -1.374691688564467e-03,  8.696714893147033e-06, -4.301302903658428e-08,
  1.565310030217675e-10, -2.425830225530211e-13, -2.078494512349535e-15,  2.445451727167145e-17, -1.500964525804853e-19,  5.636366693766166e-22, -2.146770031401111e-25,
 -1.669575105568444e-26,  2.224951844578703e-01, -1.960010033886830e-03,  1.142333291461082e-05, -4.710621102315375e-08,  9.598271642657206e-11,  4.572902736700403e-13,
 -6.189997010092406e-15,  3.531053069573041e-17, -8.927979756949870e-20, -4.362619724659701e-22,  6.715805212450103e-24, -4.142422376318043e-26,  3.068271070918592e-01,
 -2.585462138823216e-03,  1.354426996652460e-05, -4.186285070764042e-08, -2.738952252286260e-11,  1.282784254339393e-12, -8.183595569566236e-15,  1.824551284473202e-17,
  1.408248153211819e-19, -1.698949257333270e-21,  7.816596249644671e-24,  3.330530358600202e-27,  4.023895974546748e-01, -3.214611137448160e-03,  1.466683873871949e-05,
 -2.634811077525901e-08, -1.866819357173940e-10,  1.833639212088957e-12, -5.560482155383308e-15, -2.587725504429960e-17,  3.650259421332734e-19, -1.461966399701390e-21,
 -4.141220355323876e-24,  8.573522640466918e-26,  5.078801083733374e-01, -3.809518786756715e-03,  1.449986061127039e-05, -1.970334436420381e-09, -3.353486271528919e-10,
  1.737536118087508e-12,  1.732688698194155e-15, -6.988345313572573e-17,  3.206412767720839e-19,  8.990701522425213e-22, -1.792968706725305e-23,  6.633067976389928e-26,
  6.218156507514431e-01, -4.332777570712451e-03,  1.289987405279947e-05,  2.755949287174674e-08, -4.209336556726664e-10,  8.561301039483059e-13,  1.050130402317490e-14,
 -7.588917998697004e-17, -6.960779487827470e-20,  3.348169283775660e-21, -1.229275799596277e-23, -8.637190818319783e-26,  7.425395764268746e-01, -4.749723919504316e-03,
  9.903082764143739e-06,  5.681467665014272e-08, -4.033366919865723e-10, -5.881506781517093e-13,  1.562663200449918e-14, -2.622499379464839e-17, -5.339454294452285e-19,
  2.799244139099658e-21,  1.366656956516087e-23, -1.683015772360921e-25,  8.682320487956200e-01, -5.030741886688694e-03,  5.736744806803709e-06,  7.973295821725452e-08,
 -2.716284387320147e-10, -2.050017492768204e-12,  1.311644949657085e-14,  5.461543202211098e-17, -6.306497349738525e-19, -1.121828734287329e-21,  2.973842992252270e-23,
 -7.114609120382258e-27,  9.969251375438903e-01, -5.153531465201044e-03,  8.050993742826727e-07,  9.100610851203177e-08, -5.270975946334789e-11, -2.879707968619537e-12,
  3.101413809458235e-15,  1.102894550229843e-16, -1.784912824278029e-19, -4.655483470454527e-21,  1.020885796094135e-23,  2.082121541027630e-25,  1.126523466111657e+00,
 -5.105179163142324e-03, -4.352445070989688e-06,  8.747596991853133e-08,  1.931547661207124e-10, -2.640190729996905e-12, -9.442020592973325e-15,  9.449696202420733e-17,
  4.828522846044423e-19, -3.634226118074569e-21, -2.529489715507143e-23,  1.431284683633537e-25,  1.254831244654276e+00, -4.883836134789044e-03, -9.129238659361461e-06,
  6.916430659147074e-08,  3.906214566221818e-10, -1.364802252188145e-12, -1.730517850289877e-14,  1.291966939748337e-17,  7.518167860201727e-19,  1.268859112064964e-21,
 -3.079352383580458e-23, -1.357922577792521e-25,  1.379586309317529e+00, -4.499789006259139e-03, -1.293891459647995e-05,  3.958380657694375e-08,  4.762981229810558e-10,
  4.050772217571252e-13, -1.572291606037700e-14, -7.470148220130180e-17,  3.663283354456628e-19,  4.661349157135090e-21,  1.907692697194296e-24, -2.078287866129625e-25,
  1.498501436904005e+00, -3.975710194032116e-03, -1.531079907899062e-05,  5.113901155756454e-09,  4.244151629495480e-10,  1.864288821749415e-12, -5.898130958465731e-15,
 -1.019570237441618e-16, -2.884588465835045e-19,  2.836625152408362e-21,  2.798096281186587e-23,  2.234341125413641e-26,  1.609312700686296e+00, -3.345907798661990e-03,
 -1.597716566328642e-05, -2.652782895619111e-08,  2.594829327591049e-10,  2.367245754244336e-12,  5.570449498280392e-15, -5.397953802596852e-17, -5.728275648271334e-19,
 -1.521984174867931e-21,  1.462628510498592e-23,  1.668348419495636e-25,  1.709833987670996e+00, -2.654467413457881e-03, -1.493429281746473e-05, -4.838289351089011e-08,
  4.816185797231470e-11,  1.791108151879783e-12,  1.141427137697929e-14,  2.003906015438483e-17, -2.883527879286809e-19, -3.054738004380195e-21, -1.203473863409958e-23,
  3.552696981106374e-26,  1.798016050406448e+00, -1.952290850976994e-03, -1.246102263110318e-05, -5.631881117513901e-08, -1.285472251435965e-10,  5.988229987464612e-13,
  9.076244472677801e-15,  5.591300417198508e-17,  1.479346529162113e-19, -8.593135323609000e-22, -1.359237395663916e-23, -8.738841903484838e-26,  1.872007698027075e+00,
 -1.293181912694453e-03, -9.084787011520730e-06, -5.036555630081815e-08, -2.113785149437310e-10, -4.659053442571021e-13,  2.244119984644246e-15,  3.607332828219093e-17,
  2.624233075221254e-19,  1.207535082271453e-21,  1.871692578229932e-24, -2.837991681415996e-26,  1.930216085046705e+00, -7.292873402268613e-04, -5.495435988133074e-06,
 -3.477132549599920e-08, -1.896421494501693e-10, -8.659139211377421e-13, -2.887660201494284e-15, -1.821547847723889e-18,  7.502418324231838e-20,  8.235299525089367e-22,
  5.865501047080982e-24,  3.157859697700221e-26,  1.971362955442068e+00, -3.063394040084312e-04, -2.419660217439584e-06, -1.662780530933643e-08, -1.041175045227288e-10,
 -6.026475122893206e-13, -3.220092302965103e-15, -1.562173247990157e-17, -6.573201681702008e-20, -2.073441377962659e-22, -1.129851255664526e-25,  5.515748629005112e-27,
  1.994539140639660e+00, -5.917787496400237e-05, -4.795895137851983e-07, -3.441535607620859e-09, -2.304064545266982e-11, -1.472092770420187e-13, -9.079588122441401e-16,
 -5.440068892908470e-18, -3.176973158269107e-20, -1.811156681815977e-22, -1.008063474505880e-24, -5.471336692311648e-27,  1.824652659117325e-03, -1.753102654478876e-05,
  1.262177812302585e-07, -8.068824086322962e-10,  4.828910443750669e-12, -2.769689801342443e-14,  1.541338848046455e-16, -8.383289919644807e-19,  4.476426358914747e-21,
 -2.353773323567484e-23,  1.221115741307179e-25, -6.259029727676330e-28,  1.639259968000366e-02, -1.565029949971595e-04,  1.112147975048040e-06, -6.953220428174209e-09,
  4.021359961153534e-11, -2.195400576162919e-13,  1.140716106170996e-15, -5.651129199554420e-18,  2.659604496628703e-20, -1.177312477756564e-22,  4.796138052424008e-25,
 -1.709788397149716e-27,  4.537209133583848e-02, -4.276808376134052e-04,  2.959398546006132e-06, -1.766270057247583e-08,  9.481358035328794e-11, -4.609941448198455e-13,
  1.996416558777714e-15, -7.273814704956256e-18,  1.801205230882855e-20,  1.659665896250935e-23, -6.263248897232163e-25,  5.510031276044895e-27,  8.844903072212426e-02,
 -8.177286125397432e-04,  5.430110245013112e-06, -3.006419132636689e-08,  1.414916762821261e-10, -5.391913313578619e-13,  1.311608863177979e-15,  2.014211847458689e-18,
 -5.275894016823552e-20,  4.245745108426598e-22, -2.411591195838943e-24,  1.004936129658229e-26,  1.451491281192311e-01, -1.307140403598434e-03,  8.195417249769338e-06,
 -4.054983334709742e-08,  1.512332409676957e-10, -2.847742654422088e-13, -1.457980340636512e-15,  1.997311979751279e-17, -1.301177711971639e-19,  5.424549047681780e-22,
 -7.962475936772080e-25, -1.007656738260121e-26,  2.148343752866383e-01, -1.870857717115891e-03,  1.086754929228860e-05, -4.550506269291362e-08,  1.037212833308606e-10,
  3.202591033094856e-13, -5.243311081862651e-15,  3.225066901999914e-17, -1.005741349922056e-19, -2.024238556100606e-22,  5.018870502204101e-24, -3.556852654745460e-26,
  2.966987772462575e-01, -2.479122964477352e-03,  1.304009892909076e-05, -4.210632683970010e-08, -3.654119766348313e-12,  1.092963321395034e-12, -7.618395794610914e-15,
  2.183368583423192e-17,  8.528727975243389e-20, -1.387515901036116e-21,  7.662280172892432e-24, -9.426134431358699e-27,  3.897637517963118e-01, -3.098589175447743e-03,
  1.433392604065852e-05, -2.904911357848989e-08, -1.513957451613720e-10,  1.692763218664925e-12, -6.129612803490625e-15, -1.506346966127280e-17,  3.102676974367880e-19,
 -1.558206359107498e-21, -8.208356965021236e-25,  6.517227002458810e-26,  4.928737559733895e-01, -3.693703040228913e-03,  1.444517545568827e-05, -7.056291361171977e-09,
 -3.003344536742169e-10,  1.756824349933120e-12, -7.648734648965670e-17, -5.923750226566563e-17,  3.408425063898793e-19,  2.445579317844831e-22, -1.471031086630077e-23,
  7.812319204241977e-26,  6.046928731597376e-01, -4.228368829902115e-03,  1.319078575780515e-05,  2.097450329631116e-08, -4.014636984119064e-10,  1.082518745331704e-12,
  8.362627204330758e-15, -7.628963142348629e-17,  4.127897027594860e-20,  2.793514874289159e-21, -1.512283551198448e-23, -4.290410387293478e-26,  7.237032920936587e-01,
 -4.667882623468714e-03,  1.054581562584790e-05,  5.028727942636151e-08, -4.114183628144051e-10, -2.237573270926771e-13,  1.466894248696805e-14, -4.160784692390387e-17,
 -4.251135836156889e-19,  3.198478508350818e-21,  6.344439395823608e-24, -1.616050198421987e-25,  8.482068205999693e-01, -4.981097631665903e-03,  6.666167688640954e-06,
  7.507648276263409e-08, -3.093688870599512e-10, -1.719181493565798e-12,  1.435870690536544e-14,  3.401631469835132e-17, -6.498690298894069e-19,  4.295508945673309e-23,
  2.806220698301294e-23, -6.721730547595358e-26,  9.763307837652292e-01, -5.142741059774953e-03,  1.890227869261521e-06,  8.970707972080707e-08, -1.093134241699530e-10,
 -2.769013813522354e-12,  6.085021927304307e-15,  1.019923422343740e-16, -3.366182909773594e-19, -4.073866799042957e-21,  1.858613008542281e-23,  1.690678082745124e-25,
  1.106039827296979e+00, -5.135751427552174e-03, -3.285970453235253e-06,  9.013263267415455e-08,  1.383076718544334e-10, -2.833429796336407e-12, -6.600771773639283e-15,
  1.076730501726522e-16,  3.354896220068216e-19, -4.502292293922500e-21, -1.770035875035918e-23,  1.990129472307597e-25,  1.235155235863748e+00, -4.953446128609340e-03,
 -8.262740732174427e-06,  7.517348794467210e-08,  3.592156677749660e-10, -1.773033520597463e-12, -1.660150437223869e-14,  3.746027545410204e-17,  7.740412668595486e-19,
 -6.484790173196981e-23, -3.541973274775125e-23, -7.107945817558361e-26,  1.361383322566526e+00, -4.601270268139992e-03, -1.241798524180925e-05,  4.724820087862753e-08,
  4.804642489720804e-10,  4.107306615607376e-15, -1.762521746941160e-14, -6.029792829054568e-17,  5.331970090677479e-19,  4.542997140879149e-21, -8.081331461235164e-24,
 -2.428306783576678e-25,  1.482354178641652e+00, -4.097832899624881e-03, -1.520748558705154e-05,  1.219415069928934e-08,  4.600491873361373e-10,  1.687535160333935e-12,
 -8.865259330282279e-15, -1.093369333111463e-16, -1.661196627283065e-19,  3.957420428268640e-21,  2.757896691358000e-23, -4.347159059862094e-26,  1.595671523167595e+00,
 -3.474924237698841e-03, -1.626900483259407e-05, -2.199063060216031e-08,  3.080314261603947e-10,  2.480681845006696e-12,  3.795048703382547e-15, -7.305904764481712e-17,
 -6.152650196090701e-19, -7.843910437073411e-22,  2.236924227774867e-23,  1.826160546242256e-25,  1.698973514438585e+00, -2.776248214808339e-03, -1.550903318277437e-05,
 -4.731067158962515e-08,  8.676306298261709e-11,  2.070636260010969e-12,  1.182900965353100e-14,  8.963121588024430e-18, -4.064994828477996e-19, -3.492367145571009e-21,
 -9.514786091180329e-24,  8.109417412293595e-26,  1.790003182348829e+00, -2.054716310022193e-03, -1.314875386088207e-05, -5.826737816340622e-08, -1.142630267688794e-10,
  8.359420418728614e-13,  1.070264015478332e-14,  6.003931947560349e-17,  1.062600342847008e-19, -1.482704455824111e-21, -1.763587661183331e-23, -9.538055301441593e-26,
  1.866685703924923e+00, -1.368335937832952e-03, -9.709763062360631e-06, -5.381887005327908e-08, -2.200711424368229e-10, -3.989362859252345e-13,  3.378361302828740e-15,
  4.517810013085175e-17,  3.068918485214089e-19,  1.251910496060117e-21,  1.986180921017219e-25, -4.878493177889559e-26,  1.927208291500476e+00, -7.749727751388025e-04,
 -5.931481275930893e-06, -3.794792371658543e-08, -2.076560731755397e-10, -9.355294366547572e-13, -2.900256697722481e-15,  1.101677795329911e-18,  1.092443512038685e-19,
  1.087593258898656e-21,  7.378396827331255e-24,  3.715933137558061e-26,  1.970097578325238e+00, -3.265240844248881e-04, -2.629600927453664e-06, -1.839446106771949e-08,
 -1.169799647509674e-10, -6.854232321284684e-13, -3.688074091912628e-15, -1.784492734667659e-17, -7.321041325492946e-20, -2.060174380439321e-22,  2.064727795277479e-25,
  9.252475632257966e-27,  1.994294484998248e+00, -6.318628355513159e-05, -5.232009830375183e-07, -3.834977333731397e-09, -2.621569951523296e-11, -1.709493460259822e-13,
 -1.075552115243241e-15, -6.569301668379468e-18, -3.907764787879619e-20, -2.266901575844860e-22, -1.282219426739565e-24, -7.060161016874123e-27,  1.756488514769798e-03,
 -1.655874201885691e-05,  1.169811177113073e-07, -7.338580540086858e-10,  4.310143737234109e-12, -2.426392710308754e-14,  1.325451475264775e-16, -7.077496836467716e-19,
  3.710738453728666e-21, -1.916204811315046e-23,  9.764852580435409e-26, -4.917680206712568e-28,  1.578386863678344e-02, -1.479289519752120e-04,  1.032429614480558e-06,
 -6.343493867205739e-09,  3.608423444265793e-11, -1.939692665883797e-13,  9.937879197136582e-16, -4.864309660259656e-18,  2.268549376463259e-20, -9.998744720339399e-23,
  4.091427942696776e-25, -1.494872276701612e-27,  4.370741150235231e-02, -4.048283537154487e-04,  2.756252233204838e-06, -1.621690709226324e-08,  8.605667877787697e-11,
 -4.154586271632941e-13,  1.800877098950030e-15, -6.692259162007447e-18,  1.821266327550080e-20, -4.078289139268958e-24, -4.182947075848822e-25,  4.015566781289166e-27,
  8.526276642370664e-02, -7.756931344043600e-04,  5.082572868489997e-06, -2.788486886340021e-08,  1.310262756305887e-10, -5.072132413031003e-13,  1.346540766820001e-15,
  5.527085778835451e-19, -3.910702228633397e-20,  3.366243747024900e-22, -1.994363057020110e-24,  8.892355764406634e-27,  1.400486688819276e-01, -1.243482766457864e-03,
  7.723144030875888e-06, -3.817738467252084e-08,  1.452307834782040e-10, -3.135075264997864e-13, -9.541383665719015e-16,  1.611488457655144e-17, -1.112554356060900e-19,
  5.032630024979031e-22, -1.128628640589576e-24, -5.303487453917683e-27,  2.075214072387287e-01, -1.786072909727809e-03,  1.033163582942740e-05, -4.380081757054255e-08,
  1.089393119586460e-10,  2.048867641165236e-13, -4.386186030823488e-15,  2.895149506739234e-17, -1.046082298430109e-19, -3.112853873065159e-23,  3.591581660908088e-24,
 -2.930618473843496e-26,  2.869877275974694e-01, -2.376822672839818e-03,  1.253516196725117e-05, -4.199964017801439e-08,  1.642765609127884e-11,  9.177222769509684e-13,
 -6.975936898992771e-15,  2.382184891234822e-17,  4.072930050244902e-20, -1.091922142284920e-21,  7.061217658936846e-24, -1.715938613845939e-26,  3.775964753686823e-01,
 -2.985350783779204e-03,  1.397189367372927e-05, -3.120872028560047e-08, -1.190401738744126e-10,  1.541661187133025e-12, -6.420837481359487e-15, -6.033513782518919e-18,
  2.542183715921548e-19, -1.539593596034372e-21,  1.608472946835174e-24,  4.556241383955665e-26,  4.783294185297446e-01, -3.578559362524630e-03,  1.433282554543208e-05,
 -1.158119216499144e-08, -2.653442843539505e-10,  1.736321582257982e-12, -1.581886717301189e-15, -4.829643574377482e-17,  3.398951248974027e-19, -2.739688635517184e-22,
 -1.120407892357272e-23,  7.980935463001797e-26,  5.879918925666792e-01, -4.121943253121586e-03,  1.340468709295450e-05,  1.473446954342195e-08, -3.779781675753127e-10,
  1.257826417963833e-12,  6.259278737564261e-15, -7.347937519405933e-17,  1.306088409122670e-19,  2.162467926027970e-21, -1.615492387027530e-23, -5.245376913997595e-27,
  7.052041582039938e-01, -4.581214432754104e-03,  1.110967995203496e-05,  4.368749036415869e-08, -4.124748175103579e-10,  1.128876518202428e-13,  1.333105220048887e-14,
 -5.333377576971296e-17, -3.070654918806088e-19,  3.315563216714823e-21, -3.301450794085716e-25, -1.397192254730404e-25,  8.283946724811141e-01, -4.924251257394026e-03,
  7.536312843275761e-06,  6.987051693503943e-08, -3.402413892639080e-10, -1.365483958355095e-12,  1.502176143547600e-14,  1.345520019768550e-17, -6.289666620360467e-19,
  1.091579851347292e-21,  2.403435324113229e-23, -1.131069083997258e-25,  9.557968334553422e-01, -5.123347182868572e-03,  2.954419487833652e-06,  8.752390497821784e-08,
 -1.630088225241701e-10, -2.590051111674154e-12,  8.769057523762352e-15,  8.903112753842073e-17, -4.682435631796660e-19, -3.197324222381808e-21,  2.482720131567360e-23,
  1.123947764061055e-25,  1.085451143507413e+00, -5.157679562687081e-03, -2.192996420917238e-06,  9.188464416058217e-08,  8.030471089884971e-11, -2.954611255302134e-12,
 -3.460864789712278e-15,  1.156966140964725e-16,  1.628829765504859e-19, -5.023468523543190e-21, -8.114184776183491e-24,  2.324658723109929e-25,  1.215215094893567e+00,
 -5.015844854068003e-03, -7.327413404228257e-06,  8.061601175728458e-08,  3.198700163284904e-10, -2.156096099529439e-12, -1.520817540700700e-14,  6.191404546048336e-17,
  7.456588106234817e-19, -1.521150050617198e-21, -3.680197651800851e-23,  1.022558806481301e-26,  1.342783328908471e+00, -4.698215695936698e-03, -1.180495548225583e-05,
  5.491276530831878e-08,  4.761901830573464e-10, -4.370816125139464e-13, -1.905066806790539e-14, -4.070248528043829e-17,  6.883018292068280e-19,  4.001006620581767e-21,
 -1.909206265421482e-23, -2.528578745439442e-25,  1.465720633968965e+00, -4.218779846967312e-03, -1.501591759658501e-05,  1.981233308916517e-08,  4.914217336602174e-10,
  1.437570172398810e-12, -1.197820783481578e-14, -1.121654676356941e-16, -4.462699314869033e-21,  4.999519922032736e-21,  2.394056225075374e-23, -1.237160177994644e-25,
  1.581509974143003e+00, -3.606044242909122e-03, -1.650167009997359e-05, -1.666100576413791e-08,  3.583785917790874e-10,  2.544970848367397e-12,  1.470834130451373e-15,
 -9.301086072934601e-17, -6.254520082514590e-19,  2.717323948524352e-22,  3.041247554826147e-23,  1.791286358733057e-25,  1.687616819030579e+00, -2.902564545060240e-03,
 -1.606701523594359e-05, -4.557567838007327e-08,  1.310269802715423e-10,  2.355955592359749e-12,  1.187848597164974e-14, -6.121991083034538e-18, -5.380700820745180e-19,
 -3.785473008873840e-21, -4.721502972183714e-24,  1.385720649514324e-25,  1.781569466642160e+00, -2.162732890436275e-03, -1.385833314280714e-05, -5.994730181611251e-08,
 -9.483762500840523e-11,  1.113308460577096e-12,  1.242230270655419e-14,  6.244119401877575e-17,  3.916650970432812e-20, -2.272688358570371e-21, -2.185934341815718e-23,
 -9.474367948950391e-26,  1.861052828462439e+00, -1.448657782988576e-03, -1.037696413602669e-05, -5.739898216123339e-08, -2.271306857608429e-10, -3.015244657924739e-13,
  4.787595438283314e-15,  5.571663004653126e-17,  3.515180658323410e-19,  1.209318379305687e-21, -2.530594269805661e-24, -7.658643432341262e-26,  1.924010531011718e+00,
 -8.243040546296598e-04, -6.407420996849176e-06, -4.142386945307177e-08, -2.270580221551677e-10, -1.004332110970140e-12, -2.814157105671276e-15,  5.284203261834302e-18,
  1.541182932117374e-19,  1.416964088483431e-21,  9.126203168638849e-24,  4.208914771295295e-26,  1.968747964059352e+00, -3.484767184779262e-04, -2.862032970478237e-06,
 -2.038079220301377e-08, -1.316154364320291e-10, -7.802044094773306e-13, -4.221628895268507e-15, -2.030385065843632e-17, -8.036706677160394e-20, -1.881379346452753e-22,
  7.278107370565550e-25,  1.479887375156915e-26,  1.994033066768741e+00, -6.756337027796583e-05, -5.718549651148156e-07, -4.283248123452734e-09, -2.990848174048826e-11,
 -1.991190971080436e-13, -1.278300451459270e-15, -7.960899742405271e-18, -4.824169022478857e-20, -2.847631246971381e-22, -1.636539983267833e-24, -9.137350953073583e-27,
  1.692071079210802e-03, -1.565698169540724e-05,  1.085731226946430e-07, -6.686116479547297e-10,  3.855137590626317e-12, -2.130784089153140e-14,  1.142920014424709e-16,
 -5.993298872822296e-19,  3.086296216365891e-21, -1.565638481188171e-23,  7.838974531973690e-26, -3.879785295293170e-28,  1.520820307514434e-02, -1.399644744911964e-04,
  9.596478295563476e-07, -5.795930173241282e-09,  3.243273619119584e-11, -1.716739499894231e-13,  8.672310103969902e-16, -4.192933051673926e-18,  1.936523082530548e-20,
 -8.487660462525720e-23,  3.478704725579163e-25, -1.292969628470905e-27,  4.213099787030735e-02, -3.835339565251936e-04,  2.569644022238542e-06, -1.490418779669624e-08,
  7.816487808307427e-11, -3.744205618362903e-13,  1.621609915470545e-15, -6.114708335726839e-18,  1.780398662135738e-20, -1.763039475057233e-23, -2.674710572553368e-25,
  2.893760865850526e-27,  8.223924511397633e-02, -7.363361455548726e-04,  4.760203900193586e-06, -2.586784382697495e-08,  1.212057488712972e-10, -4.748412982437275e-13,
  1.346213029398039e-15, -5.194731669057059e-19, -2.833346437159101e-20,  2.643154350589866e-22, -1.630005339915426e-24,  7.669116834083589e-27,  1.351954617704188e-01,
 -1.183491109783939e-03,  7.278747026990040e-06, -3.590495115042165e-08,  1.387661790281547e-10, -3.313781267753550e-13, -5.501048115771162e-16,  1.283548649849556e-17,
 -9.399691723046550e-20,  4.545193213482622e-22, -1.284470961246924e-24, -1.991190517198129e-27,  2.005391351090680e-01, -1.705492355234103e-03,  9.816601627237035e-06,
 -4.203045747469957e-08,  1.120480686867198e-10,  1.089676337611075e-13, -3.622393517578307e-15,  2.561141493174584e-17, -1.034372167023739e-19,  8.854746574171708e-23,
  2.436002073460581e-24, -2.330045474600256e-26,  2.776778155992046e-01, -2.278551554535054e-03,  1.203332019550044e-05, -4.159882975059628e-08,  3.316251872095644e-11,
  7.584167987949485e-13, -6.296208224912844e-15,  2.454918793530848e-17,  6.309247146688281e-21, -8.259491931112444e-22,  6.209552709290604e-24, -2.100431835458690e-26,
  3.658762079788722e-01, -2.875103743182965e-03,  1.358695142982380e-05, -3.287511160112449e-08, -8.975709971408750e-11,  1.386402402673057e-12, -6.484108645374813e-15,
  1.230688461724341e-18,  2.003860410931152e-19, -1.440413426418598e-21,  3.225767579386416e-24,  2.844299176647207e-26,  4.642435276855928e-01, -3.464522205416746e-03,
  1.416951627513896e-05, -1.555138985735466e-08, -2.311007392670371e-10,  1.683345722655334e-12, -2.783973814621630e-15, -3.765728879851307e-17,  3.228013016125837e-19,
 -6.531211124324822e-22, -7.794803664804868e-24,  7.418738932883787e-26,  5.717195718070424e-01, -4.014099350412034e-03,  1.354606953904852e-05,  8.895543039218516e-09,
 -3.514833337226896e-10,  1.383899792002991e-12,  4.271183288905870e-15, -6.817891159072137e-17,  1.968559639791773e-19,  1.520910811327261e-21, -1.571030512814155e-23,
  2.393477233699806e-26,  6.870602175764793e-01, -4.490351904817805e-03,  1.159446163780779e-05,  3.712281269559362e-08, -4.071438446413479e-10,  4.139123165860520e-13,
  1.171799966237647e-14, -6.126416613927861e-17, -1.893455787015930e-19,  3.188180771613034e-21, -5.808701802371367e-24, -1.081936012532978e-25,  8.088234253880860e-01,
 -4.860701463292502e-03,  8.341258358272673e-06,  6.422785335399830e-08, -3.639269059886102e-10, -1.002672388407399e-12,  1.512390109939459e-14, -5.867770894847121e-18,
 -5.736539456328998e-19,  1.943856155747460e-21,  1.837675080431544e-23, -1.409293975866831e-25,  9.353572995651628e-01, -5.095558876433186e-03,  3.987387347088793e-06,
  8.451360631223245e-08, -2.125125245442642e-10, -2.351471725475893e-12,  1.103626904870870e-14,  7.240588704738890e-17, -5.644517454799798e-19, -2.124290866369189e-21,
  2.834620236797448e-23,  4.688131176213677e-26,  1.064792345432630e+00, -5.170795743079073e-03, -1.084633070563426e-06,  9.269337863668721e-08,  2.064660648365515e-11,
 -2.998377802648774e-12, -1.759043916728632e-16,  1.179729844318456e-16, -2.130072925012138e-20, -5.139665254110482e-21,  2.346656424895247e-24,  2.382635384255708e-25,
  1.195040722030489e+00, -5.070510991082002e-03, -6.330799278662441e-06,  8.536976236580202e-08,  2.732522366070235e-10, -2.497653594830889e-12, -1.315077239208242e-14,
  8.461724962425618e-17,  6.647422866825817e-19, -2.958515450846433e-21, -3.442758241766337e-23,  9.771567623063997e-26,  1.323805941982859e+00, -4.789890830827608e-03,
 -1.110065793222088e-05,  6.243669204702007e-08,  4.627974840662964e-10, -9.053574975689157e-13, -1.986150098127704e-14, -1.654120843012686e-17,  8.159423625517622e-19,
  3.018788141690770e-21, -2.985942260812288e-23, -2.309237810348996e-25,  1.448606957089414e+00, -4.337820450707844e-03, -1.473009782629211e-05,  2.788840655911420e-08,
  5.170446213951477e-10,  1.112562070443440e-12, -1.509253421546365e-14, -1.092558875155721e-16,  1.912153047154239e-19,  5.822977643516642e-21,  1.660389638848244e-23,
 -2.097947691450794e-25,  1.566820646940970e+00, -3.738755976752690e-03, -1.666551444769386e-05, -1.051876094387444e-08,  4.094084419971341e-10,  2.546775392123318e-12,
 -1.410440408328024e-15, -1.126189730211668e-16, -5.919314263132574e-19,  1.639046410622186e-21,  3.773023372825002e-23,  1.484099309083502e-25,  1.675746080016940e+00,
 -3.033248978921523e-03, -1.659973992803451e-05, -4.308689916421473e-08,  1.809724505458534e-10,  2.636909698142753e-12,  1.144534257683078e-14, -2.554406236068571e-17,
 -6.761050181880738e-19, -3.833385179927003e-21,  2.807752613032571e-24,  2.046182233069261e-25,  1.772692211704792e+00, -2.276501021471281e-03, -1.458601629309201e-05,
 -6.126977982062303e-08, -6.944809799440121e-11,  1.432483761731087e-12,  1.417465336383473e-14,  6.220871109698771e-17, -5.936714790693136e-20, -3.227291694001726e-21,
 -2.576260092267297e-23, -7.977415444211929e-26,  1.855087715813642e+00, -1.534490841795699e-03, -1.108773374567941e-05, -6.107452022585696e-08, -2.318790500831719e-10,
 -1.665909439033287e-13,  6.511505671662670e-15,  6.763506042318202e-17,  3.923292755543863e-19,  1.030681908490285e-21, -6.664509702856156e-24, -1.127365370184374e-25,
  1.920607558610532e+00, -8.776150782539244e-04, -6.926979583648313e-06, -4.522109964516453e-08, -2.478049878649302e-10, -1.069489353696477e-12, -2.588962186441210e-15,
  1.110630411544489e-17,  2.121562423330063e-19,  1.820119329354169e-21,  1.105313088952041e-23,  4.501621512101974e-26,  1.967306663567600e+00, -3.723882823236966e-04,
 -3.119770866782906e-06, -2.261717549444970e-08, -1.482802923064252e-10, -8.886422276065833e-13, -4.827111312247457e-15, -2.297694585606191e-17, -8.643967149804213e-20,
 -1.438301317869461e-22,  1.546616817748306e-24,  2.292125763253822e-26,  1.993753326183322e+00, -7.235225489607879e-05, -6.262621898964881e-07, -4.795388842706863e-09,
 -3.421665455845202e-11, -2.326575565391662e-13, -1.524453903345833e-15, -9.682121663194387e-18, -5.977508311251883e-20, -3.590134613685584e-22, -2.095767759846148e-24,
 -1.185785069119176e-26,  1.631130946765094e-03, -1.481947292269740e-05,  1.009062806017426e-07, -6.101951755794730e-10,  3.455107115885983e-12, -1.875554760783494e-14,
  9.881282172340971e-17, -5.090131696258034e-19,  2.575225135242270e-21, -1.283700272286281e-23,  6.316616466121560e-26, -3.073248666209953e-28,  1.466327117091480e-02,
 -1.325569285892209e-04,  8.931004624177296e-07, -5.303382049077291e-09,  2.919823331931642e-11, -1.522019365842883e-13,  7.580636749250763e-16, -3.619556963168765e-18,
  1.654693629007362e-20, -7.204418067090952e-23,  2.950863947611795e-25, -1.109612285018844e-27,  4.063687291222323e-02, -3.636715001799923e-04,  2.398057172798321e-06,
 -1.371139951988677e-08,  7.105211504994515e-11, -3.374927410669750e-13,  1.458265493244775e-15, -5.556967877264527e-18,  1.700495947359930e-20, -2.604694642893735e-23,
 -1.594362694259625e-25,  2.057931797336575e-27,  7.936814344378308e-02, -6.994639132786429e-04,  4.461117799595803e-06, -2.400277767130097e-08,  1.120303420952883e-10,
 -4.428008240853374e-13,  1.320318866665831e-15, -1.285843187900050e-18, -1.991361572626914e-20,  2.055106596838797e-22, -1.318848375884062e-24,  6.487182444470884e-27,
  1.305752811243986e-01, -1.126947334595302e-03,  6.860988452736781e-06, -3.373831385404501e-08,  1.320340084625964e-10, -3.405930504488759e-13, -2.304334201236736e-16,
  1.007934510521350e-17, -7.857349893632593e-20,  4.021050477491553e-22, -1.320279810233325e-24,  2.051278348288068e-28,  1.938710802070142e-01, -1.628946390975107e-03,
  9.323050019882579e-06, -4.022474002005759e-08,  1.134142153651417e-10,  3.026516576114249e-14, -2.951011603291093e-15,  2.236932688533935e-17, -9.872767163403520e-20,
  1.671196619370699e-22,  1.531802677577426e-24, -1.792149781442117e-26,  2.687529951816280e-01, -2.184271615981142e-03,  1.153779243902111e-05, -4.095485923544217e-08,
  4.687544969644836e-11,  6.155533369135966e-13, -5.610143314941520e-15,  2.432143521928513e-17, -1.918142358665239e-20, -5.965266603478590e-22,  5.254099525825996e-24,
 -2.204548013929464e-26,  3.545906539630930e-01, -2.768008498525058e-03,  1.318472110782266e-05, -3.409783194175472e-08, -6.357890161928825e-11,  1.231874934552160e-12,
 -6.367481519767057e-15,  6.840450276982587e-18,  1.511154056363318e-19, -1.290689106522023e-21,  4.159187061933094e-24,  1.454161188605481e-26,  4.506108838176595e-01,
 -3.351972867925766e-03,  1.396181224491701e-05, -1.898363446720279e-08, -1.981814522760863e-10,  1.605021029920325e-12, -3.697690431604248e-15, -2.775779545296057e-17,
  2.944387843474014e-19, -9.023797721497069e-22, -4.742507246423222e-24,  6.401330857620059e-26,  5.558804554247424e-01, -3.905397274955659e-03,  1.362000332951100e-05,
  3.498167638598846e-09, -3.229310057404349e-10,  1.464258221767785e-12,  2.457745638059347e-15, -6.112229699785992e-17,  2.406116207009759e-19,  9.200707182879192e-22,
 -1.418747469750808e-23,  4.374547697158014e-26,  6.692869872848917e-01, -4.395924334351034e-03,  1.200117063970131e-05,  3.068942321129068e-08, -3.961953205274774e-10,
  6.739791042282229e-13,  9.934660006207899e-15, -6.554037112935685e-17, -7.980668900261892e-20,  2.870969120252985e-21, -9.792528080331166e-24, -7.266252886692753e-26,
  7.895188193891033e-01, -4.790988843941981e-03,  9.076457494559522e-06,  5.826422453772442e-08, -3.803743541655832e-10, -6.436752385823707e-13,  1.471406656604624e-14,
 -2.297556142685970e-17, -4.919770448788965e-19,  2.550911701114845e-21,  1.191004787329802e-23, -1.500229546528976e-25,  9.150451990956753e-01, -5.059664405427774e-03,
  4.979645859546563e-06,  8.075221349387204e-08, -2.567398575084921e-10, -2.064376708141099e-12,  1.280084062852330e-14,  5.334153675432971e-17, -6.201975922039203e-19,
 -9.686592301236890e-22,  2.896110801471516e-23, -1.810104589886474e-26,  1.044098854952415e+00, -5.175022463053911e-03,  2.769293554881731e-08,  9.254487405060578e-08,
 -3.909672347424667e-11, -2.963207423200380e-12,  3.090227379007527e-15,  1.143692961750642e-16, -2.021513544111026e-19, -4.840783042437861e-21,  1.243273046545922e-23,
  2.157112825324735e-25,  1.174663973167938e+00, -5.116989215785865e-03, -5.281831613561212e-06,  8.932587241904820e-08,  2.203468624953074e-10, -2.782544706613128e-12,
 -1.050153515209093e-14,  1.039290240465274e-16,  5.347109643134206e-19, -4.224861475314112e-21, -2.829785416562202e-23,  1.787755218043698e-25,  1.304473689008472e+00,
 -4.875574797123486e-03, -1.030767079996557e-05,  6.967059200611708e-08,  4.399017013109097e-10, -1.384549221814947e-12, -1.994452967145651e-14,  1.105817829439321e-17,
  9.007955331001889e-19,  1.635336761673366e-21, -3.890170077138119e-23, -1.744861841693116e-25,  1.431022313847676e+00, -4.454180395540524e-03, -1.434513293034774e-05,
  3.631842461360153e-08,  5.354302727895808e-10,  7.145205095828604e-13, -1.803371860451746e-14, -9.967430774043808e-17,  4.103497238445797e-19,  6.278197705904631e-21,
  5.578222391149328e-24, -2.890275027512341e-25,  1.551598337671819e+00, -3.872469780090457e-03, -1.675076447494132e-05, -3.563690861915273e-09,  4.597392325545399e-10,
  2.473009657989809e-12, -4.817940255191895e-15, -1.303135650697305e-16, -5.043302178625898e-19,  3.262550558022190e-21,  4.297837160264148e-23,  8.431025404443930e-26,
  1.663344288556311e+00, -3.168061741323050e-03, -1.709762143110221e-05, -3.975479846303028e-08,  2.363864209297567e-10,  2.900444038810368e-12,  1.040672995798583e-14,
 -4.934696247667991e-17, -8.097324434713278e-19, -3.520928015986025e-21,  1.330761467054840e-23,  2.720530690829268e-25,  1.763348151212411e+00, -2.396146690747530e-03,
 -1.532691374959653e-05, -6.213268131985620e-08, -3.725700801906064e-11,  1.793248273383012e-12,  1.587097935290951e-14,  5.824478685976186e-17, -1.948670226521646e-19,
 -4.319137226458442e-21, -2.856707396342096e-23, -4.360139814819750e-26,  1.848767617741101e+00, -1.626187554584525e-03, -1.184296900093759e-05, -6.480207874665015e-08,
 -2.334872414590497e-10,  1.386142654884964e-14,  8.586202305120266e-15,  8.072137915525644e-17,  4.233269211181396e-19,  6.523680302077900e-22, -1.257559507961474e-23,
 -1.572514941876050e-25,  1.916982732493314e+00, -9.352705776365092e-04, -7.494138533098434e-06, -4.936035341414987e-08, -2.697867036489167e-10, -1.127061879670613e-12,
 -2.172458334447519e-15,  1.903290549596471e-17,  2.861170117064431e-19,  2.301881229275397e-21,  1.302587982274324e-23,  4.371446183806540e-26,  1.965765416425761e+00,
 -3.984737986616945e-04, -3.406019385704071e-06, -2.513836190153610e-08, -1.672653892520694e-10, -1.012530024068025e-12, -5.509871733703516e-15, -2.581176584353396e-17,
 -9.023275288424988e-20, -5.864259946280318e-23,  2.798161907703606e-24,  3.466923775724301e-26,  1.993453518896860e+00, -7.760220503835930e-05, -6.872519096854180e-07,
 -5.382164633930389e-09, -3.925880362274974e-11, -2.727263367895142e-13, -1.824397070345449e-15, -1.181897333709198e-17, -7.434306918366967e-20, -4.542594975957812e-22,
 -2.692484697573942e-24, -1.542505952408138e-26,  1.573422470931589e-03, -1.404059995186195e-05,  9.390365465310337e-08, -5.577901809969884e-10,  3.102603174311483e-12,
 -1.654616650565054e-14,  8.564800937052245e-17, -4.335376866516182e-19,  2.155494848175852e-21, -1.056114634593134e-23,  5.108456797177479e-26, -2.443889232914323e-28,
  1.414694092191633e-02, -1.256589704002070e-04,  8.321655653843401e-07, -4.859607522403979e-09,  2.632822006326166e-11, -1.351670631446997e-13,  6.637549074689369e-16,
 -3.129366893294159e-18,  1.415449437998225e-20, -6.116775805637085e-23,  2.499203590912379e-25, -9.468243835429793e-28,  3.921954038282892e-02, -3.451263646919992e-04,
  2.240124654199054e-06, -1.262671474700951e-08,  6.463995470904798e-11, -3.043009267720473e-13,  1.310139839596115e-15, -5.028877942433347e-18,  1.597248976528822e-20,
 -3.080917930104938e-23, -8.317188895705867e-26,  1.439719853189385e-27,  7.663988361064795e-02, -6.648972938943024e-04,  4.183552672482405e-06, -2.227943208647437e-08,
  1.034879414304082e-10, -4.116107366784420e-13,  1.276436728358699e-15, -1.814347679740383e-18, -1.339900515138052e-20,  1.581383974085205e-22, -1.057651519440412e-24,
  5.404726288194801e-27,  1.261747535060168e-01, -1.073643471985555e-03,  6.468578436781902e-06, -3.168047408048121e-08,  1.251882904412954e-10, -3.430079021666326e-13,
  1.869108206336126e-17,  7.786458983525095e-18, -6.504190930550024e-20,  3.499289813655913e-22, -1.278569800956596e-24,  1.575470427762703e-27,  1.875014499446656e-01,
 -1.556261907636911e-03,  8.851248980825915e-06, -3.840891165860789e-08,  1.133601895175317e-10, -3.339407288863932e-14, -2.367920196872042e-15,  1.931667098277718e-17,
 -9.178556037155221e-20,  2.140309430470714e-22,  8.471754030594074e-25, -1.333416170667148e-26,  2.601974200026906e-01, -2.093921470334399e-03,  1.105121736844231e-05,
 -4.011344908133346e-08,  5.789480551876378e-11,  4.889940999823861e-13, -4.940686586294182e-15,  2.340270055236129e-17, -3.710616717373753e-20, -4.056267177551151e-22,
  4.297013785012675e-24, -2.121759454485768e-26,  3.437269620583552e-01, -2.664182900190964e-03,  1.277022989160390e-05, -3.492622316032922e-08, -4.045143822608252e-11,
  1.081858444332605e-12, -6.114999261905196e-15,  1.096586200786753e-17,  1.077685405522435e-19, -1.114868498921244e-21,  4.555046374200133e-24,  3.993156396860730e-27,
  4.374248656594696e-01, -3.241241082706262e-03,  1.371602622994025e-05, -2.190280162256850e-08, -1.670260613045928e-10,  1.507983337752946e-12, -4.348113957226152e-15,
 -1.888683829488734e-17,  2.591851874999615e-19, -1.039296203252545e-21, -2.193508163260222e-24,  5.165874985773455e-26,  5.404769311905836e-01, -3.796354929836024e-03,
  1.363195520511481e-05, -1.431808114216875e-09, -2.931899952456492e-10,  1.503603864055701e-12,  8.583368776698571e-16, -5.299828601241110e-17,  2.640189752994932e-19,
  3.948914012317139e-22, -1.199203523826262e-23,  5.467760729740918e-26,  6.518974903877633e-01, -4.298548536546408e-03,  1.233189404295771e-05,  2.447046159528553e-08,
 -3.804811620845766e-10,  8.901934525320240e-13,  8.078741783069775e-15, -6.652173265784873e-17,  1.582215618476372e-20,  2.425735781552419e-21, -1.221608132357175e-23,
 -3.797450844608426e-26,  7.705043682161904e-01, -4.715684817972858e-03,  9.738748905316110e-06,  5.209418435873313e-08, -3.897774145814540e-10, -2.999485968760387e-13,
  1.386473160666243e-14, -3.717042183099741e-17, -3.931515395306112e-19,  2.896424100316111e-21,  5.421033422944813e-24, -1.424731093410516e-25,  8.948922503903144e-01,
 -5.016023992592744e-03,  5.922718266924809e-06,  7.633123492586194e-08, -2.948459093696750e-10, -1.741500697403342e-12,  1.401289253315711e-14,  3.315823080305522e-17,
 -6.345691691635473e-19,  1.564563431803817e-22,  2.688530892797367e-23, -7.420970576113625e-26,  1.023406220685684e+00, -5.170373872473670e-03,  1.132538413813572e-06,
  9.145031656342498e-08, -9.736427497209897e-11, -2.851502007188043e-12,  6.176593958336406e-15,  1.052260043344344e-16, -3.652894299754243e-19, -4.165919073897138e-21,
  2.096752343043340e-23,  1.687503050994393e-25,  1.154118374696334e+00, -5.154900605861699e-03, -4.190645900658760e-06,  9.239354338124219e-08,  1.624206801166184e-10,
 -2.997875825591908e-12, -7.376299221703770e-15,  1.184044130582826e-16,  3.643227294721560e-19, -5.179404465332902e-21, -1.897549821870609e-23,  2.409217031987184e-25,
  1.284811927987863e+00, -4.954574594566277e-03, -9.430390750726580e-06,  7.646164814937812e-08,  4.074661343773941e-10, -1.856201795393838e-12, -1.922471523053083e-14,
  4.051163249914732e-17,  9.300207475664014e-19, -5.052577711576241e-23, -4.475289484457581e-23, -8.697336845041232e-26,  1.412979037177963e+00, -4.567051608871398e-03,
 -1.385751764229399e-05,  4.497519677161018e-08,  5.451750875658358e-10,  2.499142600058661e-13, -2.060662779671466e-14, -8.290985793606597e-17,  6.371402219706233e-19,
  6.228032419188288e-21, -8.504126762572638e-24, -3.461212434451278e-25,  1.535840356916050e+00, -4.006518192110220e-03, -1.674778542899244e-05,  4.180263922843755e-09,
  5.077386481917566e-10,  2.311890615209535e-12, -8.672603100236695e-15, -1.442354063979238e-16, -3.552790686026473e-19,  5.029120609143558e-21,  4.462546513227924e-23,
 -1.511435369422398e-26,  1.650395554976270e+00, -3.306682151702219e-03, -1.755002907877181e-05, -3.549549822623948e-08,  2.967653840093644e-10,  3.130584138990119e-12,
  8.644073111480550e-15, -7.715920539254309e-17, -9.238532181724367e-19, -2.731165665874844e-21,  2.659827927622353e-23,  3.291547289545425e-25,  1.753513601205288e+00,
 -2.521751640462765e-03, -1.607483053495467e-05, -6.242063807222774e-08,  2.544811358039679e-12,  2.192865754973398e-12,  1.738956837366827e-14,  4.929788659396156e-17,
 -3.712383514138856e-19, -5.483471687036527e-21, -2.917988775672993e-23,  2.099566927462263e-26,  1.842068365525859e+00, -1.724105217161946e-03, -1.264296113786399e-05,
 -6.852366412538562e-08, -2.309582588348871e-10,  2.486012937171139e-13,  1.103880718441421e-14,  9.453211698429851e-17,  4.359573662711085e-19, -3.709343763340316e-24,
 -2.060080904514066e-23, -2.083257288277727e-25,  1.913117886700659e+00, -9.976680954090038e-04, -8.113114792818294e-06, -5.385990263543386e-08, -2.928004793453218e-10,
 -1.171690967966378e-12, -1.498160536160147e-15,  2.961875188039929e-17,  3.788104136968742e-19,  2.859443706353440e-21,  1.478725613493585e-23,  3.471035356351013e-26,
  1.964115048086101e+00, -4.269756782736181e-04, -3.724429434989667e-06, -2.798404942113589e-08, -1.888985915172744e-10, -1.153767080340894e-12, -6.273170250729913e-15,
 -2.870814379725581e-17, -8.992115671883575e-20,  8.831087492956232e-23,  4.671536741541334e-24,  5.145245643429684e-26,  1.993131689359540e+00, -8.336967319213148e-05,
 -7.557947555912859e-07, -6.056438273729534e-09, -4.517944734806393e-11, -3.207677539394600e-13, -2.191248722402918e-15, -1.448179383716796e-17, -9.281012102655382e-20,
 -5.768189677544775e-22, -3.469528414582245e-24, -2.010409861282539e-26,  1.518721296675648e-03, -1.331532517976113e-05,  8.749745274400978e-08, -5.106882232602236e-10,
  2.791290943816010e-12, -1.462882638364730e-14,  7.442015341937122e-17, -3.702707937796890e-19,  1.809624654218572e-21, -8.717440606387710e-24,  4.145949203524075e-26,
 -1.950805627353063e-28,  1.365726020525926e-02, -1.192279457372098e-04,  7.762912984407039e-07, -4.459146091229539e-09,  2.377733870390261e-11, -1.202391976632443e-13,
  5.821561046026980e-16, -2.709805182261689e-18,  1.212275477723256e-20, -5.196081798400061e-23,  2.114625937439362e-25, -8.045691325195825e-28,  3.787394151382786e-02,
 -3.277943193699971e-04,  2.094614079967214e-06, -1.163950204673603e-08,  5.885725831072348e-11, -2.744905619767194e-13,  1.176316289579154e-15, -4.536031360897531e-18,
  1.481741239232057e-20, -3.301306589516575e-23, -3.032302746932560e-26,  9.859018948962967e-28,  7.404557696900711e-02, -6.324707514579407e-04,  3.925868009252768e-06,
 -2.068783634764817e-08,  9.555772746568506e-11, -3.816293472345861e-13,  1.220432478234099e-15, -2.159745653015287e-18, -8.412887980673442e-21,  1.202973546457006e-22,
 -8.413694160222111e-25,  4.448001253520086e-27,  1.219813165425769e-01, -1.023381976894482e-03,  6.100204710107872e-06, -2.973224828323928e-08,  1.183491105645214e-10,
 -3.401669667104094e-13,  2.093974692984669e-16,  5.896958610069867e-18, -5.334584906764068e-20,  3.004376857276709e-22, -1.190352439969208e-24,  2.353055937252704e-27,
  1.814151466597304e-01, -1.487264779509324e-03,  8.401193065227384e-06, -3.660340142916347e-08,  1.121661331093876e-10, -8.405832649219840e-14, -1.866974672793860e-15,
  1.650827845935521e-17, -8.360114556591401e-20,  2.373507828276841e-22,  3.462298068971541e-25, -9.569493334578882e-27,  2.519955281372767e-01, -2.007420727046393e-03,
  1.057571635002760e-05, -3.911511557412187e-08,  6.654125354109027e-11,  3.781344019579855e-13, -4.304003711106096e-15,  2.201303858720510e-17, -4.883530584181108e-20,
 -2.519036107101327e-22,  3.403413567745185e-24, -1.926688456165018e-26,  3.332718863129935e-01, -2.563706929397312e-03,  1.234792037353655e-05, -3.540821183643614e-08,
 -2.025513738108962e-11,  9.391368607098204e-13, -5.765456520317297e-15,  1.380765171410452e-17,  7.093299228110902e-20, -9.315552459538204e-22,  4.556453715792912e-24,
 -3.450846149884116e-27,  4.246776319719796e-01, -3.132607383961586e-03,  1.343813455948316e-05, -2.433977459899018e-08, -1.379480821610185e-10,  1.398184768095652e-12,
 -4.766551225337363e-15, -1.120426040810140e-17,  2.207046810140108e-19, -1.085342212504564e-21, -2.015191406499028e-25,  3.894710441078636e-26,  5.255094043715581e-01,
 -3.687445472348254e-03,  1.358762193542527e-05, -5.881639379610167e-09, -2.630271391720205e-10,  1.507361161839707e-12, -5.058297625271917e-16, -4.440999478234154e-17,
  2.701951262170590e-19, -3.517636430013363e-23, -9.486518284260312e-24,  5.811696356338177e-26,  6.349023220629196e-01, -4.198820874521525e-03,  1.258963331712686e-05,
  1.853509737574282e-08, -3.608886407137231e-10,  1.061866413587875e-12,  6.235661163563176e-15, -6.471521062084722e-17,  9.403598989271580e-20,  1.913000861675255e-21,
 -1.319977742615984e-23, -7.679797991524455e-27,  7.518012579548748e-01, -4.635380665654113e-03,  1.032632005864373e-05,  4.582745536685784e-08, -3.925400873319813e-10,
  1.899160858308522e-14,  1.266373213653647e-14, -4.805304710198918e-17, -2.864420709766735e-19,  2.993080664486006e-21, -4.403600469812925e-25, -1.222527405845497e-25,
  8.749286025265295e-01, -4.965061072232113e-03,  6.809298442156659e-06,  7.135360759819950e-08, -3.262494365155225e-10, -1.396332261765828e-12,  1.465932145331046e-14,
  1.314248159525709e-17, -6.104899954124317e-19,  1.153204913389653e-21,  2.265144943119175e-23, -1.154442952639647e-25,  1.002749753004036e+00, -5.156954710134959e-03,
  2.218742016963843e-06,  8.944527839339419e-08, -1.526806723820310e-10, -2.669361148825657e-12,  8.937959502595052e-15,  9.131251681530727e-17, -4.985372202145225e-19,
 -3.196564816154713e-21,  2.703523213588250e-23,  1.050712417651908e-25,  1.133438800137781e+00, -5.183951318138226e-03, -3.068337618245201e-06,  9.450414409454071e-08,
  1.009674529822810e-10, -3.133982730215863e-12, -3.926710478092257e-15,  1.269544189864116e-16,  1.668713431723016e-19, -5.714249836982211e-21, -7.522901055657949e-24,
  2.743215254561009e-25,  1.264848706987473e+00, -5.026239712810861e-03, -8.475039323272734e-06,  8.265949101362173e-08,  3.658373748071513e-10, -2.300634282046819e-12,
 -1.767651127639098e-14,  6.989204345695859e-17,  8.953369517966321e-19, -1.886243454892731e-21, -4.623868572362872e-23,  2.184130470519224e-26,  1.394492738198736e+00,
 -4.675604451391740e-03, -1.326540262275004e-05,  5.371036818373866e-08,  5.450525175790240e-10, -2.699945473609572e-13, -2.260960249586543e-14, -5.903006108850836e-17,
  8.514688759621510e-19,  5.574292310460554e-21, -2.432810894046837e-23, -3.658710395018424e-25,  1.519546836784505e+00, -4.140158284265312e-03, -1.664739393953363e-05,
  1.266128174661612e-08,  5.515620249255281e-10,  2.054179889445168e-12, -1.284070370703776e-14, -1.523664938003264e-16, -1.425883350294818e-19,  6.764459991090377e-21,
  4.119295045840107e-23, -1.451417779200394e-25,  1.636885448565441e+00, -3.448700620237088e-03, -1.794538503665630e-05, -3.023588249209224e-08,  3.612590258061210e-10,
  3.308692954663214e-12,  6.056579774642916e-15, -1.080612557096211e-16, -9.994245901017960e-19, -1.366015379528095e-21,  4.188469973033637e-23,  3.598037520346251e-25,
  1.743164658946391e+00, -2.653342300477244e-03, -1.682211192605477e-05, -6.200594382243789e-08,  5.067968964025468e-11,  2.625246704544252e-12,  1.857232975396269e-14,
  3.403785348068250e-17, -5.891936246873584e-19, -6.605699003067816e-21, -2.621100707965331e-23,  1.199545375337467e-25,  1.834964361414148e+00, -1.828600386811569e-03,
 -1.348720386832051e-05, -7.216389720882173e-08, -2.231143959359043e-10,  5.468656086554731e-13,  1.387975296256860e-14,  1.083027107838984e-16,  4.186395230880764e-19,
 -1.026725355171518e-21, -3.093533978493739e-23, -2.610857585242855e-25,  1.908993196332127e+00, -1.065239722966771e-03, -8.788321282221557e-06, -5.873382658801951e-08,
 -3.165191839802330e-10, -1.196225875133096e-12, -4.828233429978876e-16,  4.350457386504156e-17,  4.927190698556484e-19,  3.476193038042984e-21,  1.589179367955513e-23,
  1.284454074734054e-26,  1.962345352796453e+00, -4.581675367953520e-04, -4.079161037702354e-06, -3.119948893252049e-08, -2.135462669666096e-10, -1.314289914193832e-12,
 -7.116520432369666e-15, -3.149388915226682e-17, -8.277562353566366e-20,  3.268433175908742e-22,  7.427146952811445e-24,  7.511334946390596e-26,  1.992785639645397e+00,
 -8.971953592479867e-05, -8.330305961647936e-07, -6.833633820273481e-09, -5.215536631648661e-11, -3.785793969742172e-13, -2.641641094919799e-15, -1.781257916000027e-17,
 -1.163019973278616e-19, -7.349778542071018e-22, -4.483031448508572e-24, -2.623666593559826e-26,  1.466822186208522e-03, -1.263912098375229e-05,  8.162780796484212e-08,
 -4.682745473559929e-10,  2.515768106925753e-12, -1.296088902132987e-14,  6.481829257806587e-17, -3.170800356939009e-19,  1.523690311248603e-21, -7.218641891118817e-24,
  3.376263391784299e-26, -1.562986699970527e-28,  1.319243908358158e-02, -1.132253648824380e-04,  7.249872023823435e-07, -4.097212842295808e-09,  2.150634580021057e-11,
 -1.071357815443959e-13,  5.114425907375569e-16, -2.350240941550863e-18,  1.039623083273611e-20, -4.417281164744785e-23,  1.788326274431716e-25, -6.816707586681127e-28,
  3.659541552287675e-02, -3.115805011246698e-04,  1.960414041491763e-06, -1.074021272042598e-08,  5.363974748530845e-11, -2.477306023362141e-13,  1.055765736110425e-15,
 -4.081045375816415e-18,  1.361659326605306e-20, -3.346342813223340e-23,  5.401760143500299e-27,  6.554538502014120e-28,  7.157697151804067e-02, -6.020314016679686e-04,
  3.686540737265857e-06, -1.921840301885063e-08,  8.821300495723666e-11, -3.530912847577502e-13,  1.156797508324931e-15, -2.365794631546448e-18, -4.643116096596700e-21,
  9.030460248384239e-23, -6.642727677457184e-25,  3.623484599071714e-27,  1.179831770264133e-01, -9.759758111878614e-04,  5.754555764930261e-06, -2.789276338120057e-08,
  1.116084452265093e-10, -3.333432775577947e-13,  3.521750367878997e-16,  4.353964965549690e-18, -4.336094284698716e-20,  2.550266637722278e-22, -1.077549741031044e-24,
  2.718905452786442e-27,  1.755977676565715e-01, -1.421781831895053e-03,  7.972657248802418e-06, -3.482447534467542e-08,  1.100728048843244e-10, -1.236132673532830e-13,
 -1.440897079187762e-15,  1.397166208949318e-17, -7.490010867906695e-20,  2.437125426036936e-22, -6.370279321703786e-27, -6.578789592490251e-27,  2.441321102068511e-01,
 -1.924673883244820e-03,  1.011295487681067e-05, -3.799536014530135e-08,  7.311996136028430e-11,  2.820506251546839e-13, -3.710702223577095e-15,  2.032987069717990e-17,
 -5.565122783847772e-20, -1.320071481353591e-22,  2.609777352976827e-24, -1.675115400126691e-26,  3.232119283406263e-01, -2.466627290661450e-03,  1.192167318478249e-05,
 -3.558941461322752e-08, -2.823595325482235e-12,  8.056320300621412e-13, -5.351857289925206e-15,  1.557571208114372e-17,  4.062629704416058e-20, -7.539199794929732e-22,
  4.290435455059998e-24, -8.247737532617617e-27,  4.123603125446674e-01, -3.026306054159044e-03,  1.313371665855233e-05, -2.632954270213510e-08, -1.111497989761057e-10,
  1.280784895873843e-12, -4.987261431253895e-15, -4.765287187278746e-18,  1.818675524555491e-19, -1.062704642973294e-21,  1.247216196712879e-24,  2.712586405151797e-26,
  5.109764794389967e-01, -3.579096074061082e-03,  1.349278326629053e-05, -9.849960667525746e-09, -2.330970016424754e-10,  1.481272850102290e-12, -1.628945789801405e-15,
 -3.585225805038156e-17,  2.627125691605122e-19, -3.638053769362507e-22, -6.961437439031160e-24,  5.588112602235954e-26,  6.183097449749007e-01, -4.097310621186409e-03,
  1.277813468045390e-05,  1.293829986055195e-08, -3.382995137803781e-10,  1.190177987905319e-12,  4.475388478859252e-15, -6.070627388320025e-17,  1.533881149350243e-19,
  1.385771756526239e-21, -1.298818865912761e-23,  1.612875840196337e-26,  7.334282887347635e-01, -4.550677024419167e-03,  1.083863040868983e-05,  3.956589130569207e-08,
 -3.892348755539510e-10,  3.058387697189521e-13,  1.120603640114987e-14, -5.550863854356846e-17, -1.802338590755111e-19,  2.875738949633772e-21, -5.221915258356590e-24,
 -9.420974914839986e-26,  8.551826019658315e-01, -4.907252449146395e-03,  7.633362376557433e-06,  6.592940515826246e-08, -3.506392615609985e-10, -1.042255848482345e-12,
  1.476123917886841e-14, -5.564535846933007e-18, -5.539668987136486e-19,  1.949458016080334e-21,  1.699092536405023e-23, -1.388254023476846e-25,  9.821641679986340e-01,
 -5.134956907306240e-03,  3.275706283043977e-06,  8.658778052613125e-08, -2.037254283364043e-10, -2.426070493033584e-12,  1.125559984999756e-14,  7.373462982619587e-17,
 -5.932213637562638e-19, -2.043317134637536e-21,  3.011185705314399e-23,  3.448333150777597e-26,  1.112661116234741e+00, -5.203939147905325e-03, -1.926676705524540e-06,
  9.561428268701408e-08,  3.763562670961127e-11, -3.185155256810696e-12, -3.284302218099328e-16,  1.289686170959946e-16, -4.132312820082836e-20, -5.771386491489287e-21,
  4.662559422571878e-24,  2.738502193193432e-25,  1.244614565315117e+00, -5.089976507245182e-03, -7.449596171094170e-06,  8.812246004577939e-08,  3.157572611969519e-10,
 -2.698224709829097e-12, -1.533115554911498e-14,  9.710330131225714e-17,  7.946815560435179e-19, -3.682558657449465e-21, -4.273649402099393e-23,  1.369660692248485e-25,
  1.375582364453870e+00, -4.779001924913388e-03, -1.256882825932519e-05,  6.235802214531408e-08,  5.341091139921008e-10, -8.292022641703211e-13, -2.385233852403394e-14,
 -2.879135281705846e-17,  1.030784200478550e-18,  4.283969554682976e-21, -3.997624843689479e-23, -3.367207383497276e-25,  1.502721023372368e+00, -4.272576663048749e-03,
 -1.644121106376552e-05,  2.179674183537745e-08,  5.892166170446204e-10,  1.694528285621389e-12, -1.713205341603965e-14, -1.527300169614828e-16,  1.286640965260464e-19,
  8.241681155594257e-21,  3.159143809320479e-23, -2.926189629973821e-25,  1.622801367409016e+00, -3.593611685283441e-03, -1.827132840817764e-05, -2.391954365047795e-08,
  4.286225556269284e-10,  3.414095257638254e-12,  2.578214544291863e-15, -1.404753024914626e-16, -1.014625624246116e-18,  6.256130984456993e-22,  5.759149172068205e-23,
  3.450546905518015e-25,  1.732277448423898e+00, -2.790877547150715e-03, -1.755950610253283e-05, -6.075052817044863e-08,  1.077072120310948e-10,  3.080062142273266e-12,
  1.922430864924406e-14,  1.118892908797984e-17, -8.442641419754182e-19, -7.511323507092693e-21, -1.808390578818818e-23,  2.552949945478038e-25,  1.827428595723307e+00,
 -1.940021617887215e-03, -1.437416717585784e-05, -7.562707209745897e-08, -2.085926668326080e-10,  9.178399271665028e-13,  1.709238561891590e-14,  1.208456223325956e-16,
  3.565042345095230e-19, -2.508132418454182e-21, -4.346416505790919e-23, -3.060296135340481e-25,  1.904587036585836e+00, -1.138453430280952e-03, -9.524303379339549e-06,
 -6.398971153142141e-08, -3.404511960610356e-10, -1.191294391541624e-12,  9.757341896727754e-16,  6.139705837313592e-17,  6.293466993120455e-19,  4.112561816856826e-21,
  1.562183386070947e-23, -2.915976295165280e-26,  1.960444960198118e+00, -4.923585446720266e-04, -4.474953669882441e-06, -3.483610057908442e-08, -2.416129510608468e-10,
 -1.495954576367844e-12, -8.033215163918468e-15, -3.389012559743538e-17, -6.478533993189205e-20,  6.989435329017955e-22,  1.141682381383530e-23,  1.079663433338306e-25,
  1.992412892840399e+00, -9.672658007154526e-05, -9.203026201317708e-07, -7.732314552444614e-09, -6.040362893987693e-11, -4.484101018010171e-13, -3.196734762168097e-15,
 -2.199458658325747e-17, -1.462870242597130e-19, -9.395939538100144e-22, -5.806114926646839e-24, -3.425540233423287e-26,  1.417537099090618e-03, -1.200791057538659e-05,
  7.624173872475366e-08, -4.300143992980335e-10,  2.271415067863595e-12, -1.150651035168374e-14,  5.658538080295719e-17, -2.722321063911791e-19,  1.286558699483680e-21,
 -5.996143120682825e-24,  2.758508712185575e-26, -1.256822080477948e-28,  1.275083408017648e-02, -1.076164423755969e-04,  6.778166486428526e-07, -3.769607829702078e-09,
  1.948123426933689e-11, -9.561466897395818e-14,  4.500638053021456e-16, -2.041681222805624e-18,  8.927836049554245e-21, -3.758717625869156e-23,  1.512156902708188e-25,
 -5.763926081251991e-28,  3.537966399912226e-02, -2.963984967874065e-04,  1.836521757907422e-06, -9.920274918456134e-09,  4.892951315734493e-11, -2.237153286414345e-13,
  9.474161962685698e-16, -3.664495875737141e-18,  1.242204726077041e-20, -3.274651968751274e-23,  2.870970078398367e-26,  4.170051053780117e-28,  6.922640314294227e-02,
 -5.734380921886779e-04,  3.464160133394517e-06, -1.786200386884338e-08,  8.142337037478380e-11, -3.261370130339157e-13,  1.088929051705538e-15, -2.467188221508293e-18,
 -1.833969363139782e-21,  6.670819513919172e-23, -5.206255521277067e-25,  2.926098472139547e-27,  1.141692690175030e-01, -9.312483637170727e-04,  5.430338602817725e-06,
 -2.615986521111301e-08,  1.050352010816481e-10, -3.235767459709290e-13,  4.559826193609514e-16,  3.105228359766710e-18, -3.492656768082443e-20,  2.143600882174890e-22,
 -9.551318866275109e-25,  2.809333309676374e-27,  1.700355981904868e-01, -1.359642408376769e-03,  7.565243214756755e-06, -3.308483927787370e-08,  1.072850465869716e-10,
 -1.537630656826057e-13, -1.081930228111615e-15,  1.171466596792693e-17, -6.619411945440182e-20,  2.383934933542667e-22, -2.427929507267254e-25, -4.271918862750868e-27,
  2.365923629093777e-01, -1.845573734661946e-03,  9.664201070760237e-06, -3.678496154872902e-08,  7.791545734358920e-11,  1.996196679094256e-13, -3.166976493161577e-15,
  1.849174824586706e-17, -5.869489600710961e-20, -4.156773592060597e-23,  1.931813471529545e-24, -1.406129795362208e-26,  3.135334616274465e-01, -2.372961785136979e-03,
  1.149483866600726e-05, -3.551251922145829e-08,  1.204058229799912e-11,  6.825438861820816e-13, -4.901385240302781e-15,  1.647384992734959e-17,  1.647815925495001e-20,
 -5.904858949587963e-22,  3.861766019968520e-24, -1.093396083051824e-26,  4.004631865810495e-01, -2.922528467323421e-03,  1.280791592081091e-05, -2.790955127417577e-08,
 -8.673860131015816e-11,  1.160112166806831e-12, -5.044882935959997e-15,  4.541295325583153e-19,  1.447670446898928e-19, -9.920805255234001e-22,  2.209669040094173e-24,
  1.692653870687958e-26,  4.968751445178561e-01, -3.471687772318643e-03,  1.335317629371602e-05, -1.334495757847866e-08, -2.039389529506833e-10,  1.431067855537487e-12,
 -2.517438432218516e-15, -2.770402964995457e-17,  2.451820982847164e-19, -5.946485893457231e-22, -4.624857372819475e-24,  4.984858049536741e-26,  6.021258084782485e-01,
 -3.994554678657935e-03,  1.290172039311868e-05,  7.721204635254526e-09, -3.135564934161516e-10,  1.277787206880820e-12,  2.851125305379971e-15, -5.509819676606273e-17,
  1.941455743906912e-19,  8.858412809871775e-22, -1.188769892470047e-23,  3.269742004077754e-26,  7.154018569944141e-01, -4.462174133107627e-03,  1.127630227471608e-05,
  3.340114121330774e-08, -3.805575131649101e-10,  5.555750416580182e-13,  9.586281532778255e-15, -5.966757654930502e-17, -8.138358146650431e-20,  2.593034329252774e-21,
 -8.686531592113276e-24, -6.313738946007019e-26,  8.356806000249464e-01, -4.843117772143507e-03,  8.390228102361511e-06,  6.017157655430735e-08, -3.679643627358823e-10,
 -6.917896998056250e-13,  1.436867045387335e-14, -2.204956297202565e-17, -4.730534503311916e-19,  2.504054578204252e-21,  1.069865078560555e-23, -1.443933756721595e-25,
  9.616832493730273e-01, -5.104654045837372e-03,  4.293650168713435e-06,  8.295534226870958e-08, -2.493896082011707e-10, -2.133365956545265e-12,  1.304501637098236e-14,
  5.380879660410145e-17, -6.449212360605396e-19, -8.289075268043012e-22,  3.011592663127135e-23, -3.302832098542299e-26,  1.091821807574249e+00, -5.214757677232370e-03,
 -7.777925399463525e-07,  9.570762225178795e-08, -2.585538122257238e-11, -3.150043667384583e-12,  3.233334716096762e-15,  1.243811088112411e-16, -2.428976381106969e-19,
 -5.351547940892520e-21,  1.608310640741334e-23,  2.401389414278232e-25,  1.224142278740133e+00, -5.145261738950137e-03, -6.363656893927457e-06,  9.272384288472881e-08,
  2.583478092361600e-10, -3.030806129662802e-12, -1.227845017095648e-14,  1.200957573768035e-16,  6.330849784434576e-19, -5.239509632562445e-21, -3.435305938594264e-23,
  2.407655282770725e-25,  1.356270197892049e+00, -4.876415551792903e-03, -1.176990612814841e-05,  7.073978683359482e-08,  5.117550342413780e-10, -1.407474196414794e-12,
 -2.417588283349140e-14,  6.324860059061223e-18,  1.152832731909359e-18,  2.409028275573901e-21, -5.317049099581725e-23, -2.543840203214243e-25,  1.485369543358968e+00,
 -4.402897417662885e-03, -1.612204328846808e-05,  3.147155000804595e-08,  6.186526957019290e-10,  1.232789166158237e-12, -2.130466832586391e-14, -1.436494677297621e-16,
  4.446111207829901e-19,  9.204481482948025e-21,  1.550224413234858e-23, -4.358266158342810e-25,  1.608132932980044e+00, -3.740808660947622e-03, -1.851495478542955e-05,
 -1.651336843153571e-08,  4.971858214800701e-10,  3.425141242997193e-12, -1.802923225090026e-15, -1.721096431252872e-16, -9.471330633176752e-19,  3.214988773031249e-21,
  7.130734189923276e-23,  2.665932974086955e-25,  1.720828416835056e+00, -2.934235480104187e-03, -1.827605835197509e-05, -5.850928598673085e-08,  1.739308112898569e-10,
  3.541897917938923e-12,  1.911786257408713e-14, -2.026890215588191e-17, -1.124559845967613e-18, -7.962933156553820e-21, -3.283858150862176e-24,  4.215366440683512e-25,
  1.819432696848713e+00, -2.058700246234999e-03, -1.530103576776617e-05, -7.879423945600656e-08, -1.858533553787263e-10,  1.369854340618473e-12,  2.061965530257675e-14,
  1.304466309711673e-16,  2.315891964847910e-19, -4.524688203791058e-21, -5.752187034833946e-23, -3.273876429344136e-25,  1.899875837686110e+00, -1.217813765621184e-03,
 -1.032564366580693e-05, -6.962563817722272e-08, -3.638913019671053e-10, -1.144830611151104e-12,  2.999896438580410e-15,  8.402201277157495e-17,  7.881724430886917e-19,
  4.693181458750230e-21,  1.288764514416510e-23, -1.009511832642260e-25,  1.958401183352099e+00, -5.298983691076914e-04, -4.917203873434549e-06, -3.895206235892487e-08,
 -2.735379768255373e-10, -1.700346442404219e-12, -9.006694148082072e-15, -3.546252189370614e-17, -3.014882238361881e-20,  1.262841991800277e-21,  1.710387374361286e-23,
  1.527419942177657e-25,  1.992010649893246e+00, -1.044772916639258e-04, -1.019199192753488e-06, -8.774906095812874e-09, -7.019180356285688e-11, -5.330838243319906e-13,
 -3.883542323466508e-15, -2.726491737553754e-17, -1.846819077075533e-19, -1.204859717727602e-21, -7.533118829208882e-24, -4.469271231174896e-26,  1.370693493267245e-03,
 -1.141801655489628e-05,  7.129225961426473e-08, -3.954415229648807e-10,  2.054271153513399e-12, -1.023547110517022e-14,  4.950826690003064e-17, -2.343134063044241e-19,
  1.089295560435375e-21, -4.995791060658398e-24,  2.260901818959444e-26, -1.014266401318535e-28,  1.233093418072765e-02, -1.023696930821083e-04,  6.343902968200976e-07,
 -3.472638416834247e-09,  1.767248735599651e-11, -8.546806924291038e-14,  3.967010236133106e-16, -1.776521240725571e-18,  7.677712744454612e-21, -3.201833092433982e-23,
  1.278789408191012e-25, -4.867921325102577e-28,  3.422271876971639e-02, -2.821695192834085e-04,  1.722031948512413e-06, -9.171995821538934e-09,  4.467450294736546e-11,
 -2.021647729522449e-13,  8.501999362704850e-16, -3.285598171620160e-18,  1.126776237932148e-20, -3.128555481332746e-23,  4.310033906313099e-26,  2.467154519630534e-28,
  6.698675044850190e-02, -5.465605267703364e-04,  3.257422015327636e-06, -1.661001548133645e-08,  7.515635214283725e-11, -3.008362413506255e-13,  1.019359937681094e-15,
 -2.491229594179506e-18,  2.220584400577844e-22,  4.827903219072253e-23, -4.050661421011779e-25,  2.344607764315337e-27,  1.105292125206277e-01, -8.890332466856926e-04,
  5.126292040504028e-06, -2.453045229345859e-08,  9.867952125847006e-11, -3.117092280205172e-13,  5.283908546968264e-16,  2.103917072995646e-18, -2.786762768902469e-20,
  1.786119481207967e-22, -8.329036359084379e-25,  2.724156670751841e-27,  1.647155988790558e-01, -1.300679595760812e-03,  7.178418748773525e-06, -3.139418414188371e-08,
  1.039754872243978e-10, -1.760247668980270e-13, -7.822996880243231e-16,  9.731560284495630e-18, -5.782701223523521e-20,  2.254696622590719e-22, -3.908175866966272e-25,
 -2.542845889715044e-27,  2.293619298176069e-01, -1.770004333796096e-03,  9.230380259539331e-06, -3.551033261142974e-08,  8.118861471853834e-11,  1.296123401296888e-13,
 -2.675628271742926e-15,  1.660331888396966e-17, -5.894241220438301e-20,  2.411101333230524e-23,  1.371145537952722e-24, -1.145198799320215e-26,  3.042228388941414e-01,
 -2.282703404968863e-03,  1.107027453733417e-05, -3.521689662747063e-08,  2.455271865406496e-11,  5.704868391485102e-13, -4.435723972142472e-15,  1.668987567372142e-17,
 -2.118837179321081e-21, -4.460600573594858e-22,  3.351534795527807e-24, -1.203867241417442e-26,  3.889758472040648e-01, -2.821426670629140e-03,  1.246541879781434e-05,
 -2.911831615089187e-08, -6.474353221561969e-11,  1.039678683969901e-12, -4.972551530096492e-15,  4.533595062244018e-18,  1.107988896626522e-19, -8.913738492906862e-22,
  2.765519237524172e-24,  8.668759274955343e-27,  4.832009545594205e-01, -3.365556238678019e-03,  1.317439185159941e-05, -1.638254076534219e-08, -1.759801200919377e-10,
  1.362206404534736e-12, -3.186758285186628e-15, -2.023226891202379e-17,  2.209527585855602e-19, -7.380705194608663e-22, -2.605696515370125e-24,  4.170678250335786e-26,
  5.863544862837655e-01, -3.891053621217064e-03,  1.296512740603372e-05,  2.911953002330028e-09, -2.874377003947751e-10,  1.328429509607234e-12,  1.399510218438687e-15,
 -4.846404528280533e-17,  2.178544430742368e-19,  4.424171527031264e-22, -1.021352497436786e-23,  4.232234838963429e-26,  6.977359748632436e-01, -4.370463048924068e-03,
  1.164098805753565e-05,  2.741304127072873e-08, -3.672817948373502e-10,  7.653869423522997e-13,  7.892656143895256e-15, -6.085021344401002e-17,  5.124397044183146e-21,
  2.199047229392057e-21, -1.079359945529634e-23, -3.308456702617070e-26,  8.164468030930938e-01, -4.773208728908993e-03,  9.076565908997420e-06,  5.419195755132114e-08,
 -3.784101614251376e-10, -3.559748817250114e-13,  1.355342399461661e-14, -3.567467868238508e-17, -3.767203019001425e-19,  2.806814811818552e-21,  4.510803210748992e-24,
 -1.346509408539598e-25,  9.413395362996281e-01, -5.066393951859236e-03,  5.263821252235829e-06,  7.864125071734208e-08, -2.888162243580526e-10, -1.804557194018515e-12,
  1.425988774613750e-14,  3.292244836704771e-17, -6.535903627940189e-19,  3.291034819644365e-22,  2.737572559894593e-23, -8.908087713350547e-26,  1.070957589764406e+00,
 -5.216397839214320e-03,  3.661546317448901e-07,  9.479531150788802e-08, -8.780343479169227e-11, -3.031702979601971e-12,  6.579225398106558e-15,  1.136697838630830e-16,
 -4.215718132952902e-19, -4.513137361408514e-21,  2.539337979815757e-23,  1.793387646100964e-25,  1.203466553293987e+00, -5.191654684051874e-03, -5.228218367817126e-06,
  9.635764992946137e-08,  1.950682944885258e-10, -3.283030751041691e-12, -8.662266309579512e-15,  1.370935664251883e-16,  4.225117841827964e-19, -6.376938878836536e-21,
 -2.196557393265228e-23,  3.164678136099898e-25,  1.336581786846707e+00, -4.967042437252965e-03, -1.087293090775053e-05,  7.867128224828384e-08,  4.778395123170809e-10,
 -1.981336634711978e-12, -2.347232336608668e-14,  4.417278359441216e-17,  1.198892374732859e-18,  9.355282100210970e-23, -6.165499398209910e-23, -1.244421900265011e-25,
  1.467502632631161e+00, -4.530193169348867e-03, -1.568427403800603e-05,  4.153812345553459e-08,  6.378791822643670e-10,  6.751281055113360e-13, -2.507722794744320e-14,
 -1.240401762700655e-16,  7.821791679783054e-19,  9.405027656478873e-21, -6.286557135095378e-24, -5.467848160032050e-25,  1.592872401797574e+00, -3.889580523811486e-03,
 -1.866313701193088e-05, -8.014422234304846e-09,  5.648484272775121e-10,  3.320744564267349e-12, -7.024862689244761e-15, -1.999949005022143e-16, -7.775770441682172e-19,
  6.262134025873484e-21,  7.992485607254346e-23,  1.121155711355162e-25,  1.708794685365158e+00, -3.083199539082235e-03, -1.895905473021136e-05, -5.513502915934378e-08,
  2.492889467685844e-10,  3.989585031278628e-12,  1.800347998749496e-14, -6.082738278200585e-17, -1.408639100353094e-18, -7.670453522108765e-21,  1.922354503904836e-23,
  6.016786907303073e-25,  1.810947022534425e+00, -2.184938944895934e-03, -1.626341393715095e-05, -8.152057358777029e-08, -1.532080691477283e-10,  1.909226480448914e-12,
  2.434809656503127e-14,  1.347791306745642e-16,  2.383448216488362e-20, -7.110520932497463e-21, -7.158815074175318e-23, -3.019650750151994e-25,  1.894833938785083e+00,
 -1.303861634555167e-03, -1.119682549211841e-05, -7.562630684430967e-08, -3.858619731118645e-10, -1.041592244182502e-12,  5.731664157975079e-15,  1.120358808302781e-16,
  9.650691028326804e-19,  5.089935105997334e-21,  6.126036855676986e-24, -2.142907244786474e-25,  1.956199845712707e+00, -5.711827639314452e-04, -5.412049466344941e-06,
 -4.361280912564370e-08, -3.097873081400117e-10, -1.928484456480305e-12, -1.000529471868187e-14, -3.555374193868732e-17,  2.939496292690037e-20,  2.097777962346965e-21,
  2.507654779651625e-23,  2.123177567126111e-25,  1.991575738581614e+00, -1.130720173972006e-04, -1.131605457752636e-06, -9.988604615045721e-09, -8.185099633913340e-11,
 -6.361599190006160e-13, -4.736656173835471e-15, -3.393095810283311e-17, -2.339881144388478e-19, -1.549238288904654e-21, -9.783912475923910e-24, -5.817305258105418e-26,
  1.326132818489165e-03, -1.086611605860675e-05,  6.673761915252139e-08, -3.641484629724805e-10,  1.860931966280149e-12, -9.122223260407882e-15,  4.340965435861806e-17,
 -2.021673463357223e-19,  9.247052265675763e-22, -4.174690164981078e-24,  1.858631613194360e-26, -8.214812485513531e-29,  1.193134835171937e-02, -9.745657706759214e-05,
  5.943604163061231e-07, -3.203052638384637e-09,  1.605444415342609e-11, -7.651742397709897e-14,  3.502315637351882e-16, -1.548330250793999e-18,  6.612177211863950e-21,
 -2.730828906824326e-23,  1.081754469450816e-25, -4.109333271111417e-28,  3.312091289083492e-02, -2.688216682698617e-04,  1.616126829702075e-06, -8.488472036402577e-09,
  4.082800993706076e-11, -1.828242195437959e-13,  7.630843110967151e-16, -2.942698653818471e-18,  1.017477456752043e-20, -2.938292450658944e-23,  5.115751505502338e-26,
  1.265471773726515e-28,  6.485139300038781e-02, -5.212784376157247e-04,  3.065122528490051e-06, -1.545434208286023e-08,  6.937863416528790e-11, -2.772063540452580e-13,
  9.499451068399710e-16, -2.459249322758175e-18,  1.691957667146960e-21,  3.399159002429869e-23, -3.127971325227076e-25,  1.865036305710034e-27,  1.070532731661813e-01,
 -8.491740004711295e-04,  4.841196401380200e-06, -2.300074611792033e-08,  9.257642579034709e-11, -2.984159835002192e-13,  5.757379842966941e-16,  1.308835020441566e-18,
 -2.200884722125448e-20,  1.476428852300090e-22, -7.169369490155639e-25,  2.534431308995729e-27,  1.596253888040259e-01, -1.244731159017194e-03,  6.811550949353008e-06,
 -2.975967145037925e-08,  1.002882618862630e-10, -1.917318704365290e-13, -5.345249161376186e-16,  8.007755062816501e-18, -5.001475128687330e-20,  2.080001102504689e-22,
 -4.735135346670287e-25, -1.285484037369470e-27,  2.224269311898519e-01, -1.697843529269881e-03,  8.812125040190055e-06, -3.419391157794173e-08,  8.317527025275962e-11,
  7.076399786769594e-14, -2.236941081392451e-15,  1.474069275269412e-17, -5.720203606283082e-20,  6.959923959980490e-23,  9.205956319808121e-25, -9.073763352548201e-27,
  2.952664837078415e-01, -2.195824111020655e-03,  1.065038705701956e-05, -3.473840085017181e-08,  3.493563504685315e-11,  4.696156618743117e-13, -3.971592329345148e-15,
  1.638997482670774e-17, -1.589226426377780e-20, -3.226573041844589e-22,  2.818685164977533e-24, -1.203360259641574e-26,  3.778873513995130e-01, -2.723117071236233e-03,
  1.211044894325123e-05, -2.999429828824432e-08, -4.513114109018654e-11,  9.222325128193974e-13, -4.800641148258142e-15,  7.587702199456658e-18,  8.077415051201341e-20,
 -7.751155938962283e-22,  3.001581618177881e-24,  2.376002906556890e-27,  4.699482099196245e-01, -3.260993289758096e-03,  1.296179237386853e-05, -1.898460375258251e-08,
 -1.495426781347459e-10,  1.279699944157605e-12, -3.658392806132144e-15, -1.360359096555617e-17,  1.929247368134527e-19, -8.081976409060853e-22, -9.655363170786979e-25,
  3.281486122452878e-26,  5.709978274441296e-01, -3.787268982442154e-03,  1.297335827165912e-05, -1.473123564576610e-09, -2.606390204619126e-10,  1.346533586873618e-12,
  1.419695277199903e-16, -4.131298108976877e-17,  2.268906034612495e-19,  7.258952297463099e-23, -8.251276355402736e-24,  4.599362406047312e-26,  6.804423224459597e-01,
 -4.276117991747754e-03,  1.193522241439276e-05,  2.166870843410721e-08, -3.502174316768321e-10,  9.344536564576961e-13,  6.202438976742716e-15, -5.950526740112420e-17,
  7.624174378718961e-20,  1.746234462523626e-21, -1.165664425385199e-23, -6.970084010779554e-27,  7.975031659403728e-01, -4.698098343277149e-03,  9.690363346020249e-06,
  4.809774972716512e-08, -3.823643877960412e-10, -4.394728881520184e-14,  1.240113546944746e-14, -4.608945169169984e-17, -2.738060544990557e-19,  2.874269563067965e-21,
 -9.847504387693925e-25, -1.136768560468415e-25,  9.211640439993928e-01, -5.020589780553046e-03,  6.178659883797249e-06,  7.375032798470202e-08, -3.214224680452533e-10,
 -1.453603029707845e-12,  1.489214734322587e-14,  1.239999985568445e-17, -6.230960648244849e-19,  1.332894665987067e-21,  2.252919203644474e-23, -1.281273255984270e-25,
  1.050105021609903e+00, -5.208946856936941e-03,  1.493298993486446e-06,  9.291501624405544e-08, -1.466091659214993e-10, -2.837275684246339e-12,  9.550170755692447e-15,
  9.779008962936618e-17, -5.640587895482313e-19, -3.361618648989341e-21,  3.161556500675820e-23,  1.016879254456815e-25,  1.182623674487899e+00, -5.228807262233539e-03,
 -4.055399775893140e-06,  9.894349197288068e-08,  1.276466396609314e-10, -3.443551395659357e-12, -4.669920019366462e-15,  1.467993635579556e-16,  1.806120298934846e-19,
 -6.963471583132984e-21, -7.103581193769010e-24,  3.517346663225860e-25,  1.316545808492821e+00, -5.050122898704730e-03, -9.884408420336502e-06,  8.596959106518540e-08,
  4.327019613094453e-10, -2.525509266031736e-12, -2.170131754558593e-14,  8.210725767020264e-17,  1.156964743701626e-18, -2.436159311861409e-21, -6.365100139377492e-23,
  3.712427974135945e-26,  1.449134314490592e+00, -4.653499220491145e-03, -1.512424359204930e-05,  5.181838416647896e-08,  6.450978213420737e-10,  3.473541924179526e-14,
 -2.814966165615370e-14, -9.369003003779399e-17,  1.110244957613053e-18,  8.652445847687267e-21, -3.170582275356907e-23, -5.962797979881166e-25,  1.577015083883888e+00,
 -4.039111695032932e-03, -1.870292792911183e-05,  1.543359659670887e-09,  6.291101965785058e-10,  3.082368390568760e-12, -1.293474658254527e-14, -2.206473540475851e-16,
 -4.939662941796227e-19,  9.495162656202312e-21,  8.004768119363745e-23, -1.181013079745537e-25,  1.696154455981185e+00, -3.237444438293633e-03, -1.959403597826580e-05,
 -5.048526979022944e-08,  3.332361423291828e-10,  4.395888406316133e-12,  1.562910354886419e-14, -1.101187636834200e-16, -1.664090763359058e-18, -6.321570668748845e-21,
  4.940788866413693e-23,  7.639368113547831e-25,  1.801940801830050e+00, -2.318997801853477e-03, -1.725500235640952e-05, -8.363339511946511e-08, -1.088749495371483e-10,
  2.538695867268708e-12,  2.809002333182726e-14,  1.308688052971628e-16, -2.866878108089186e-19, -1.021634682348144e-20, -8.296080536065247e-23, -1.994881807209216e-25,
  1.889433445249257e+00, -1.397172784781045e-03, -1.214204409382755e-05, -8.195814753700491e-08, -4.050453629846902e-10, -8.627280602727083e-13,  9.328784148099001e-15,
  1.458761357026850e-16,  1.150043417914513e-18,  5.101454559356393e-21, -6.768073519603491e-24, -3.816914274130191e-25,  1.953825084360204e+00, -6.166598543786007e-04,
 -5.966458737666223e-06, -4.889134606719608e-08, -3.508380317108106e-10, -2.180374117715278e-12, -1.097478522000699e-14, -3.319166998193234e-17,  1.254130070712131e-19,
  3.308962415942660e-21,  3.604126019169330e-23,  2.890205857554081e-25,  1.991104552932522e+00, -1.226275863116922e-04, -1.259767202716207e-06, -1.140652167571875e-08,
 -9.579254931706154e-11, -7.621409335075514e-13, -5.800503026738467e-15, -4.239175738509938e-17, -2.974648913426873e-19, -1.996555880214759e-21, -1.270711917868193e-23,
 -7.536618119299138e-26,  1.283709177646833e-03, -1.034920156544413e-05,  6.254064464289975e-08, -3.357783672492977e-10,  1.688464012320066e-12, -8.145109956636976e-15,
  3.814162665785249e-17, -1.748446933749723e-19,  7.869713774118391e-22, -3.498752072387113e-24,  1.532240419859182e-26, -6.678293824277720e-29,  1.155079439332549e-02,
 -9.285118686577127e-05,  5.574159498980802e-07, -2.957981939096221e-09,  1.460475945579189e-11, -6.860907515815135e-14,  3.096985346511399e-16, -1.351669216249658e-18,
  5.702787726495386e-21, -2.332326931427868e-23,  9.154092326645696e-26, -3.470108670548489e-28,  3.207085444270923e-02, -2.562892666356913e-04,  1.518067138523373e-06,
 -7.863508055532561e-09,  3.734817779111408e-11, -1.654631138753113e-13,  6.850908980048527e-16, -2.633626259797373e-18,  9.154915609331717e-21, -2.725214937106556e-23,
  5.477303454857637e-26,  4.287786663497906e-29,  6.281417277625312e-02, -4.974808082407509e-04,  2.886151765074987e-06, -1.438742151276172e-08,  6.405695244796234e-11,
 -2.552268129356356e-13,  8.820117622406635e-16, -2.387789178826946e-18,  2.709102662128676e-21,  2.299962657627732e-23, -2.396567748592111e-25,  1.472717266210572e-27,
  1.037323232075489e-01, -8.115237329443175e-04,  4.573880292941242e-06, -2.156650801100605e-08,  8.674886051025914e-11, -2.842333686634147e-13,  6.032862276945035e-16,
  6.842734834218238e-19, -1.718364985675261e-20,  1.211262523640872e-22, -6.106848852501407e-25,  2.289146235942307e-27,  1.547532253693201e-01, -1.191640232840126e-03,
  6.463933964877569e-06, -2.818636031258559e-08,  9.634259428708770e-11, -2.020439302537883e-13, -3.316153027831150e-16,  6.523342404653279e-18, -4.287867842888348e-20,
  1.882123204179489e-22, -5.094559448181130e-25, -4.026826227884304e-28,  2.157739843942093e-01, -1.628965123738981e-03,  8.409820557144547e-06, -3.285456534335412e-08,
  8.408605793960708e-11,  2.182599273334346e-14, -1.849405189748358e-15,  1.295668119292251e-17, -5.412404426196330e-20,  9.907151713403929e-23,  5.681085969179910e-25,
 -7.002227741936702e-27,  2.866509676531544e-01, -2.112278274374097e-03,  1.023717366167506e-05, -3.410931627126260e-08,  4.341159879976216e-11,  3.797370307150977e-13,
 -3.521389802542347e-15,  1.571630582511964e-17, -2.560458610936814e-20, -2.203271267345468e-22,  2.303128798922364e-24, -1.131007534206388e-26,  3.671863551980149e-01,
 -2.627684120177202e-03,  1.174677337911492e-05, -3.057502221196200e-08, -2.782003267704007e-11,  8.098337209454453e-13, -4.556027641490147e-15,  9.749296240046603e-18,
  5.504294457414988e-20, -6.544064331171054e-22,  3.001178230684504e-24, -2.117837578987222e-27,  4.571101277090520e-01, -3.158248973798901e-03,  1.272044985624984e-05,
 -2.117742245754035e-08, -1.248540559275048e-10,  1.187998242759878e-12, -3.957274588784455e-15, -7.900306754727462e-18,  1.634587488049941e-19, -8.205327888958217e-22,
  2.856612891976505e-25,  2.415877149060454e-26,  5.560561159015918e-01, -3.683621673972355e-03,  1.293154771568993e-05, -5.428095919446350e-09, -2.337637314787402e-10,
  1.336880365694473e-12, -9.131852825116475e-16, -3.407040533188727e-17,  2.240512390994031e-19, -2.169778720266906e-22, -6.234108957442890e-24,  4.505323320688505e-26,
  6.635303283113815e-01, -4.179689903442393e-03,  1.216226744632521e-05,  1.622226927481425e-08, -3.301730715861137e-10,  1.063648974136649e-12,  4.579255311189907e-15,
 -5.614989402686320e-17,  1.306991861087962e-19,  1.280306275170595e-21, -1.149049623829478e-23,  1.351567999593064e-26,  7.788693270233923e-01, -4.618370711619499e-03,
  1.023085149960767e-05,  4.198860367246971e-08, -3.803763048491421e-10,  2.372989280565467e-13,  1.100341263620092e-14, -5.321259304750525e-17, -1.721765649798657e-19,
  2.742627216462061e-21, -5.396435260215064e-24, -8.616100024150361e-26,  9.011860222804502e-01, -4.967709995537452e-03,  7.031911015437265e-06,  6.839448950986161e-08,
 -3.469037246094724e-10, -1.094227935012411e-12,  1.496858776830203e-14, -6.608888975026967e-18, -5.603179023423765e-19,  2.114072647825171e-21,  1.638541004563584e-23,
 -1.479550186419615e-25,  1.029300126630838e+00, -5.192584649184255e-03,  2.592374898886543e-06,  9.012865182390351e-08, -2.008518339451379e-10, -2.577356657451787e-12,
  1.201918551044763e-14,  7.805528515352024e-17, -6.614569421167443e-19, -2.031832351854025e-21,  3.427229178528574e-23,  1.929551641311888e-26,  1.161651120822040e+00,
 -5.256471719725988e-03, -2.858112424145600e-06,  1.004301867085490e-07,  5.799015952212777e-11, -3.505884638859360e-12, -5.165251298835824e-16,  1.485435009285583e-16,
 -7.144941356961750e-20, -6.937827056473189e-21,  8.309683488475591e-24,  3.413304890137561e-25,  1.296193860922125e+00, -5.124957949208182e-03, -8.812990127396687e-06,
  9.246129816479293e-08,  3.771908929511923e-10, -3.014667734093006e-12, -1.890064871144132e-14,  1.172417131621421e-16,  1.024284603075988e-18, -4.899404422017796e-21,
 -5.827750404407448e-23,  2.060629568797739e-25,  1.430282515390076e+00, -4.771830609988533e-03, -1.444059182533695e-05,  6.210798370519809e-08,  6.388460555803200e-10,
 -6.680438709485937e-13, -3.023080774584219e-14, -5.347437633870822e-17,  1.392603618979966e-18,  6.863163028975540e-21, -5.750247154512379e-23, -5.609846217362989e-25,
  1.560559755156713e+00, -4.188485354156390e-03, -1.862203911513348e-05,  1.208330639886706e-08,  6.871449854649200e-10,  2.696348380536453e-12, -1.927845816336498e-14,
 -2.303820667128691e-16, -9.649404751327200e-20,  1.251168954664886e-20,  6.868326293769780e-23, -4.051507416788663e-25,  1.682887473703808e+00, -3.396522570332092e-03,
 -2.016490437300463e-05, -4.443092815256440e-08,  4.246232101279635e-10,  4.727774660852592e-12,  1.176916444676092e-14, -1.665614937821216e-16, -1.847661440481489e-18,
 -3.637771409915948e-21,  8.549731611252813e-23,  8.611996802224409e-25,  1.792382338033680e+00, -2.461077734766557e-03, -1.826725755216353e-05, -8.493135094258853e-08,
 -5.106950046575122e-11,  3.255428577898936e-12,  3.156597199313250e-14,  1.151555944089674e-16, -7.158507354609574e-19, -1.365667928852002e-20, -8.750442337028078e-23,
  1.401034711866141e-26,  1.883644095427426e+00, -1.498354526059329e-03, -1.316495223552483e-05, -8.856327939384920e-08, -4.197079664259387e-10, -5.854973561748066e-13,
  1.395556366264723e-14,  1.855271701405477e-16,  1.324207936261520e-18,  4.431591335004152e-21, -2.840990597653290e-23, -6.130459587480774e-25,  1.951259126650322e+00,
 -6.668371455132415e-04, -6.588321586385289e-06, -5.486823186680713e-08, -3.971518921310673e-10, -2.454347209123392e-12, -1.182792341901518e-14, -2.696781600625297e-17,
  2.737892750854037e-19,  5.031454672215572e-21,  5.076927090226265e-23,  3.831314717544589e-25,  1.990592981040272e+00, -1.332805022286180e-04, -1.406370213108121e-06,
 -1.306913267778811e-08, -1.125294873785069e-10, -9.167423574468691e-13, -7.132280559251158e-15, -5.316558820929699e-17, -3.793432585146607e-19, -2.577161707089285e-21,
 -1.647966540125438e-23, -9.685685641446520e-26,  1.243288134988026e-03, -9.864546573209804e-06,  5.866817769076530e-08, -3.100180387383944e-10,  1.534333483828092e-12,
 -7.285725336698670e-15,  3.358041437609130e-17, -1.515641169576158e-19,  6.713753482114514e-22, -2.940812427149958e-24,  1.266386996211692e-26, -5.451329373428417e-29,
  1.118808896839741e-02, -8.852997162953179e-05,  5.232782154259761e-07, -2.734891899523442e-09,  1.330394338632906e-11, -6.161060118287685e-14,  2.742852903314674e-16,
 -1.181936381636018e-18,  4.925531049864075e-21, -1.995052890169671e-23,  7.748623338773858e-26, -2.934238123300534e-28,  3.106940284104515e-02, -2.445122650317504e-04,
  1.427184087996535e-06, -7.291542438564000e-09,  3.419753156032011e-11, -1.498736178993216e-13,  6.153063067201133e-16, -2.355940801476154e-18,  8.213557842294793e-21,
 -2.504202055581676e-23,  5.531559465343547e-26, -1.461235940011463e-29,  6.086935862316766e-02, -4.750651474461582e-04,  2.719487388611210e-06, -1.340221896666311e-08,
  5.915873714945724e-11, -2.348503297517328e-13,  8.164793309457588e-16, -2.289579521040051e-18,  3.379244506729371e-21,  1.461053207736723e-23, -1.821220371374254e-25,
  1.153408219919946e-27,  1.005578040542811e-01, -7.759447141909610e-04,  4.323225056893431e-06, -2.022321145022006e-08,  8.121022913515252e-11, -2.695828540040605e-13,
  6.153706515002204e-16,  1.996432776649230e-19, -1.323923358376032e-20,  9.863514694109951e-23, -5.158280526909906e-25,  2.020670856086092e-27,  1.500879818054978e-01,
 -1.141255810849418e-03,  6.134811943583319e-06, -2.667757886769062e-08,  9.223614768625648e-11, -2.079597843281249e-13, -1.671809404563647e-16,  5.255679246299194e-18,
 -3.647232353178750e-20,  1.676725358747458e-22, -5.132293037997219e-25,  1.893465033665237e-28,  2.093902163949801e-01, -1.563240688904963e-03,  8.023644956502112e-06,
 -3.150798801170966e-08,  8.410710934083508e-11, -1.839856148306982e-14, -1.510301574222149e-15,  1.128559269105276e-17, -5.021775741034068e-20,  1.161701449431472e-22,
  2.994930639059535e-25, -5.262481295970845e-27,  2.783630744205722e-01, -2.032005776204028e-03,  9.832265536604495e-06, -3.335841679216213e-08,  5.019634308248851e-11,
  3.004050509800615e-13, -3.093875288779812e-15,  1.478687569324678e-17, -3.199523278417683e-20, -1.378417794142153e-22,  1.829435653005565e-24, -1.017449615498377e-26,
  3.568612342816541e-01, -2.535183908436365e-03,  1.137771789665624e-05, -3.089641427600173e-08, -1.269375422012278e-11,  7.039429109049934e-13, -4.261765924809632e-15,
  1.115665894403134e-17,  3.361365935274030e-20, -5.371961240225086e-22,  2.837786311178027e-24, -5.081748951956576e-27,  4.446790039216033e-01, -3.057534079630200e-03,
  1.245510198003830e-05, -2.299023284493315e-08, -1.020588155301066e-10,  1.090933049862466e-12, -4.109667322633902e-15, -3.138112468151117e-18,  1.343597098030112e-19,
 -7.902168706228676e-22,  1.173369385458054e-24,  1.637007520780949e-26,  5.415280343360600e-01, -3.580491401815756e-03,  1.284484687879579e-05, -8.955915441156529e-09,
 -2.073184098303236e-10,  1.304317588759815e-12, -1.768276907930298e-15, -2.707005274411965e-17,  2.122201743212416e-19, -4.277275196887123e-22, -4.333653898480190e-24,
  4.091649646714922e-26,  6.470072732599883e-01, -4.081701249097714e-03,  1.232595797487354e-05,  1.111512978453691e-08, -3.079258070007784e-10,  1.155196796286185e-12,
  3.071916254642485e-15, -5.131731989662917e-17,  1.687035405080916e-19,  8.372325720816785e-22, -1.055926064282536e-23,  2.778987538890584e-26,  7.605625834601455e-01,
 -4.534611457642517e-03,  1.069840030550675e-05,  3.595438244079016e-08, -3.731130299018498e-10,  4.829683768654933e-13,  9.450830610944452e-15, -5.719104614066610e-17,
 -7.816196399543088e-20,  2.459645299984147e-21, -8.536694120058071e-24, -5.656747945491240e-26,  8.814327556110787e-01, -4.908267666600312e-03,  7.818682911260333e-06,
  6.268837405877352e-08, -3.652209685651578e-10, -7.391539976098715e-13,  1.454478526868178e-14, -2.320771986135964e-17, -4.740003426718985e-19,  2.637599876698520e-21,
  9.780314738308335e-24, -1.494693606533040e-25,  1.008578033650451e+00, -5.167577918648318e-03,  3.652988583443699e-06,  8.651901771553049e-08, -2.493499467901292e-10,
 -2.265119569908552e-12,  1.389929359351582e-14,  5.598317413059655e-17, -7.099338044511679e-19, -6.670470060085655e-22,  3.341558927616185e-23, -5.626398376230940e-26,
  1.140587152083981e+00, -5.274505523162710e-03, -1.649695347662574e-06,  1.007978207285172e-07, -1.191690652874000e-11, -3.468856758326498e-12,  3.573760135384153e-15,
  1.423537483329879e-16, -3.117201658852475e-19, -6.317877862648703e-21,  2.229924578042119e-23,  2.881513030252145e-25,  1.275560186947184e+00, -5.190925868609590e-03,
 -7.669310535504384e-06,  9.799053970436566e-08,  3.126456800203962e-10, -3.425364842104010e-12, -1.518860787620879e-14,  1.467673967538781e-16,  8.085550211736774e-19,
 -7.003062947584130e-21, -4.582165081228274e-23,  3.544473118471878e-25,  1.410969107340548e+00, -4.884201668938144e-03, -1.363453657025957e-05,  7.218279688160594e-08,
  6.181354366067033e-10, -1.406303731827271e-12, -3.107049658425098e-14, -5.448330606063233e-18,  1.592600856354593e-18,  4.100817566400344e-21, -7.966710895391337e-23,
 -4.310093513431352e-25,  1.543509048493664e+00, -4.336690840707023e-03, -1.840938135783503e-05,  2.348170879155124e-08,  7.359226453780822e-10,  2.156342271004633e-12,
 -2.570112017513640e-14, -2.257731589293668e-16,  3.982636606875786e-19,  1.481256964746280e-20,  4.414411724786457e-23, -7.085326017241742e-25,  1.668975540847161e+00,
 -3.559851714793645e-03, -2.065414626327929e-05, -3.686687302462647e-08,  5.215905906363792e-10,  4.947493237328420e-12,  6.263139978578867e-15, -2.270474544698699e-16,
 -1.907881225286062e-18,  5.434149421277391e-22,  1.233827893338855e-22,  8.356595370495780e-25,  1.782239283447557e+00, -2.611301170022260e-03, -1.928905164784638e-05,
 -8.518538869321090e-08,  2.186068413718432e-11,  4.048637368850122e-12,  3.439093444463108e-14,  8.371317038012598e-17, -1.269515788167003e-18, -1.705126917804369e-20,
 -7.964890471439436e-23,  3.679152710134101e-25,  1.877433145097039e+00, -1.608040104520808e-03, -1.426832599572374e-05, -9.535223421237361e-08, -4.276224633301234e-10,
 -1.833001875730499e-13,  1.976566029498621e-14,  2.301774706997149e-16,  1.456044092912588e-18,  2.672981711499617e-21, -6.167830622474184e-23, -9.090165937679438e-25,
  1.948482037384740e+00, -7.222892506568901e-04, -7.286537434379299e-06, -6.163101794080804e-08, -4.491328203851326e-10, -2.746106306152698e-12, -1.243014013193774e-14,
 -1.488169645459618e-17,  4.958178584154444e-19,  7.430231612300770e-21,  6.994947357794539e-23,  4.899903131752416e-25,  1.990036318726086e+00, -1.451908468126554e-04,
 -1.574639257579684e-06, -1.502611570605539e-08, -1.327041316177635e-10, -1.107242923292198e-12, -8.805767847321796e-15, -6.692500909797152e-17, -4.850796877177798e-19,
 -3.328913563953905e-21, -2.129728746053234e-23, -1.228449777519499e-25,  1.204745653100601e-03, -9.409675475635148e-06,  5.509058666529059e-08, -2.865920306234361e-10,
  1.396346673041851e-12, -6.528387682282421e-15,  2.962215034217994e-17, -1.316807548344362e-19,  5.740740546198725e-22, -2.479183590876101e-24,  1.048889157535446e-26,
 -4.471367745277470e-29,  1.084213866964893e-02, -8.447149342365935e-05,  4.916971567897831e-07, -2.531539773405655e-09,  1.213496850874486e-11, -5.540771697623107e-14,
  2.432938599874488e-16, -1.035237117888268e-18,  4.260116831730840e-21, -1.709555372092080e-23,  6.558720772758786e-26, -2.488285782979955e-28,  3.011364740703948e-02,
 -2.334357073404865e-04,  1.342872164210181e-06, -6.767581257772369e-09,  3.134253945780655e-11, -1.358689801981168e-13,  5.528871442047405e-16, -2.107106154547260e-18,
  7.351600223717995e-21, -2.285489834985543e-23,  5.375543002413077e-26, -5.385415177357621e-29,  5.901161351785696e-02, -4.539368138337538e-04,  2.564188388353956e-06,
 -1.249221210719199e-08,  5.465255786576585e-11, -2.160114670752952e-13,  7.539546049337768e-16, -2.174339630355022e-18,  3.785588080657119e-21,  8.260329289871749e-24,
 -1.372778613080735e-25,  8.937459800425481e-28,  9.752169048541599e-02, -7.423079432495376e-04,  4.088167379338449e-06, -1.896617751740197e-08,  7.596647980563482e-11,
 -2.547916084511630e-13,  6.155358925161770e-16, -1.710114411982051e-19, -1.003906789102184e-20,  7.970000251308755e-23, -4.329096009141109e-25,  1.748919663155508e-27,
  1.456191230576404e-01, -1.093433068130447e-03,  5.823397838870921e-06, -2.523524434278452e-08,  8.804809001353945e-11, -2.103326662433255e-13, -3.548219455015398e-17,
  4.181206083206613e-18, -3.080248368370679e-20,  1.474329875903671e-22, -4.960593942553361e-25,  5.593554708948949e-28,  2.032632695963515e-01, -1.500541075784548e-03,
  7.653605146099701e-06, -3.016708324325588e-08,  8.340133965261934e-11, -5.103149130182713e-14, -1.216159828505162e-15,  9.747424368281672e-18, -4.587176027096598e-20,
  1.239580850850997e-22,  1.001997567695300e-25, -3.848496418970122e-27,  2.703898521698970e-01, -1.954934771417288e-03,  9.436968962345928e-06, -3.251110627241959e-08,
  5.549483505305893e-11,  2.310006380252056e-13, -2.694826901873231e-15,  1.369690161863746e-17, -3.574477685175186e-20, -7.323661517689817e-23,  1.410450009678868e-24,
 -8.855221984551908e-27,  3.469001904982412e-01, -2.445647611426550e-03,  1.100618922054812e-05, -3.099233264362767e-08,  3.881386377353301e-13,  6.055136155423643e-13,
 -3.937074385360489e-15,  1.194430450416409e-17,  1.625839471483130e-20, -4.287474766951952e-22,  2.571990850227789e-24, -6.824226176638319e-27,  4.326463649287133e-01,
 -2.959022931677118e-03,  1.217012413487182e-05, -2.445400507874262e-08, -8.123119127379749e-11,  9.917065437171721e-13, -4.141545842024356e-15,  7.165771904283485e-19,
  1.069116461714433e-19, -7.309089906353195e-22,  1.744020670380090e-24,  9.780623094385126e-27,  5.274108286125021e-01, -3.478216934976179e-03,  1.271832603523422e-05,
 -1.206686911131071e-08, -1.817139378788409e-10,  1.253535454742101e-12, -2.433697217071547e-15, -2.055541097789467e-17,  1.941205350684360e-19, -5.667462529280924e-22,
 -2.661393840598269e-24,  3.487695818895954e-26,  6.308784124424440e-01, -3.982642035343900e-03,  1.243055275275147e-05,  6.376676901557968e-09, -2.841977383567783e-10,
  1.212315196777793e-12,  1.714575149092066e-15, -4.551550713073480e-17,  1.915627234930159e-19,  4.421788863256184e-22, -9.132814215739082e-24,  3.612519947724536e-26,
  7.425979023575373e-01, -4.447399120126230e-03,  1.109439122570695e-05,  3.007362426589545e-08, -3.613162947495555e-10,  6.903688367101092e-13,  7.827280814139174e-15,
 -5.834573483207285e-17,  3.716403692600880e-21,  2.076860978970329e-21, -1.039817371592713e-23, -2.855117837446501e-26,  8.619294066153097e-01, -4.842809502967666e-03,
  8.535455107107376e-06,  5.674528969565879e-08, -3.765744121537592e-10, -3.995008093914957e-13,  1.369735622435199e-14, -3.679367064615649e-17, -3.735640128255821e-19,
  2.900314357400750e-21,  3.454436421189573e-24, -1.359486179318918e-25,  9.879726451001950e-01, -5.134272243085187e-03,  4.665844277451756e-06,  8.218561069420623e-08,
 -2.912028661476580e-10, -1.915306405001819e-12,  1.514696747989272e-14,  3.313303931990647e-17, -7.106598574546576e-19,  6.011086652087352e-22,  2.955677298065226e-23,
 -1.159630537959791e-25,  1.119470384018696e+00, -5.282873267696307e-03, -4.435362234998413e-07,  1.000581256280723e-07, -8.012017387260863e-11, -3.336586249547308e-12,
  7.387186466308263e-15,  1.289351970167119e-16, -5.202617433305511e-19, -5.195685351395933e-21,  3.318370023521949e-23,  2.023518690659645e-25,  1.254681334823312e+00,
 -5.247497095455574e-03, -6.465731033655313e-06,  1.024264529910367e-07,  2.408400639856030e-10, -3.737898652804196e-12, -1.075712351758753e-14,  1.682862754125202e-16,
  5.275298477412122e-19, -8.489838930521993e-21, -2.777033976603403e-23,  4.566999263050565e-25,  1.391219868186618e+00, -4.989647455053383e-03, -1.271006129695079e-05,
  8.180749260699890e-08,  5.825703444924731e-10, -2.147953880835004e-12, -3.049195440052356e-14,  4.722820204559750e-17,  1.678817197956947e-18,  5.928141376695869e-22,
 -9.415986119668484e-23, -2.154845506986706e-25,  1.525869806267443e+00, -4.482635549231252e-03, -1.805564345046412e-05,  3.556585458641184e-08,  7.723787413037656e-10,
  1.465599033323692e-12, -3.176212906171142e-14, -2.042218692273973e-16,  9.550310691099292e-19,  1.587276773566773e-20,  6.960690796635632e-24, -9.689951100927603e-25,
  1.654403076024145e+00, -3.726705060146776e-03, -2.104319044537546e-05, -2.772394255315679e-08,  6.214932172108993e-10,  5.014675622065635e-12, -9.387827594231316e-16,
 -2.867646708153541e-16, -1.791011751159532e-18,  6.168446464671156e-21,  1.563805443794107e-22,  6.307093914553572e-25,  1.771478996730948e+00, -2.769690086872128e-03,
 -2.030635835606120e-05, -8.414228310221296e-08,  1.112509085400266e-10,  4.896968605292911e-12,  3.606971745282911e-14,  3.269195332734460e-17, -1.935571026379982e-18,
 -1.977557386204562e-20, -5.288901944849271e-23,  8.723756124965828e-25,  1.870765280343530e+00, -1.726880032933198e-03, -1.545363583320468e-05, -1.021954602652250e-07,
 -4.259951468000392e-10,  3.737501909618382e-13,  2.687352687463752e-14,  2.777502888661449e-16,  1.497332419675388e-18, -6.924623549991293e-22, -1.090828871996521e-22,
 -1.249892951403801e-24,  1.945471433722257e+00, -7.836662830707157e-04, -8.071091637647077e-06, -6.927283503317222e-08, -5.070615433809155e-10, -3.047369496473674e-12,
 -1.258038511837839e-14,  5.848385523000690e-18,  8.191565754651125e-19,  1.069121854315430e-20,  9.386691031524379e-23,  5.947914620611728e-25,  1.989429165850629e+00,
 -1.585470708591173e-04, -1.768462038616510e-06, -1.733869356233476e-08, -1.571237176314072e-10, -1.342939085124211e-12, -1.091623580109602e-14, -8.454050692403850e-17,
 -6.216345216385584e-19, -4.297437369844837e-21, -2.734531402227298e-23, -1.525127491885514e-25,  1.167967143013326e-03, -8.982337071753760e-06,  5.178134462888998e-08,
 -2.652576158821560e-10,  1.272599972115148e-12, -5.859704620990065e-15,  2.617941279199786e-17, -1.146611209210368e-19,  4.919236476492488e-22, -2.096548331441022e-24,
  8.699636018618432e-27, -3.691462622470323e-29,  1.051193200476907e-02, -8.065621157340300e-05,  4.624480687888526e-07, -2.345937842208806e-09,  1.108293404201456e-11,
 -4.990165050702848e-14,  2.161267211756342e-16, -9.082748111805355e-19,  3.689365277653231e-21, -1.467970268683100e-23,  5.547203739581214e-26, -2.122019446837175e-28,
  2.920088796516427e-02, -2.230092506909168e-04,  1.264582681093547e-06, -6.287138289419504e-09,  2.875320806592973e-11, -1.232818385519087e-13,  4.970609272697569e-16,
 -1.884609547525724e-18,  6.566876076229861e-21, -2.076078966627068e-23,  5.075149526079786e-26, -8.119685078571490e-29,  5.723596443023280e-02, -4.340083894640110e-04,
  2.419389049799634e-06, -1.165137030954351e-08,  5.050841800615552e-11, -1.986332072738828e-13,  6.948066137195964e-16, -2.049429712456111e-18,  3.992994614070186e-21,
  3.490142855336520e-24, -1.027783179657511e-25,  6.811675602084272e-28,  9.461645662807792e-02, -7.104926999322037e-04,  3.867700462804235e-06, -1.779068008738262e-08,
  7.101781161349192e-11, -2.401099728503768e-13,  6.066584274104006e-16, -4.495506726906381e-19, -7.463734041670637e-21,  6.384406661023004e-23, -3.618153719336324e-25,
  1.484215825724145e-27,  1.413366806607832e-01, -1.048033547884012e-03,  5.528888658034288e-06, -2.386013653528074e-08,  8.384184861705850e-11, -2.098859668798799e-13,
  6.856296806847265e-17,  3.276670972483344e-18, -2.584547035147735e-20,  1.281528528174475e-22, -4.664853071799240e-25,  7.606928724616584e-28,  1.973813021886404e-01,
 -1.440737656869448e-03,  7.299568104425699e-06, -2.884232285557658e-08,  8.211009894763475e-11, -7.710592169126149e-14, -9.631079321073886e-16,  8.351391458589317e-18,
 -4.137472881974006e-20,  1.249273377669574e-22, -4.365332603865857e-26, -2.738160575881899e-27,  2.627186554885094e-01, -1.880984129296238e-03,  9.052304619339484e-06,
 -3.158961482219883e-08,  5.949847695207739e-11,  1.707956329329445e-13, -2.327650339043342e-15,  1.252103483632915e-17, -3.745605156542672e-20, -2.421399235587906e-23,
  1.050449580222046e-24, -7.515822883671464e-27,  3.372913449839536e-01, -2.359084736461330e-03,  1.063470181177454e-05, -3.089425960024516e-08,  1.158084863276246e-11,
  5.150823400913966e-13, -3.597532414498814e-15,  1.223686393796745e-17,  2.600118082934823e-21, -3.321732307212746e-22,  2.250722442285283e-24, -7.652427224622615e-27,
  4.210031074342543e-01, -2.862856353358130e-03,  1.186951494670697e-05, -2.560041819733633e-08, -6.238750959704965e-11,  8.929129933334192e-13, -4.077440573334286e-15,
  3.730951258235806e-18,  8.194313136595012e-20, -6.541921394110813e-22,  2.053300328028527e-24,  4.490463630340457e-27,  5.137004697139447e-01, -3.377097078768242e-03,
  1.255689561649831e-05, -1.477708329266272e-08, -1.572703905054101e-10,  1.188902528624625e-12, -2.925479635358596e-15, -1.468766267109482e-17,  1.721532027432373e-19,
 -6.445054983149734e-22, -1.276800823023664e-24,  2.799235610139609e-26,  6.151471110858410e-01, -3.882966979470516e-03,  1.248059610949642e-05,  2.025298644246009e-09,
 -2.596395321428123e-10,  1.238876747259996e-12,  5.278698787188005e-16, -3.919811763365350e-17,  2.013009181078299e-19,  1.099409944097862e-22, -7.455729451895433e-24,
  3.934908182944380e-26,  7.249879644503049e-01, -4.357297621468312e-03,  1.142107554323407e-05,  2.441267498447584e-08, -3.457623467569178e-10,  8.586990100908461e-13,
  6.205920827830892e-15, -5.711281997120350e-17,  7.076188890935438e-20,  1.643201641424903e-21, -1.111067179194781e-23, -4.666744231413136e-27,  8.426989032659412e-01,
 -4.771905009476153e-03,  9.180040614117987e-06,  5.067366698853134e-08, -3.813670801015059e-10, -8.438059421380461e-14,  1.251559745685270e-14, -4.706179589643078e-17,
 -2.680494448985661e-19,  2.925311861620089e-21, -2.029827993950358e-24, -1.120389466629402e-25,  9.675163402458673e-01, -5.093082568293114e-03,  5.622916760473589e-06,
  7.723993698458911e-08, -3.258117434107646e-10, -1.543188339427874e-12,  1.576113515344580e-14,  1.095555261522684e-17, -6.690897958414380e-19,  1.668351611577283e-21,
  2.352428466457919e-23, -1.545383026357790e-25,  1.098339361419311e+00, -5.281645563219187e-03,  7.473020716385126e-07,  9.825317343402456e-08, -1.447969704871061e-10,
 -3.118016086098266e-12,  1.073809433383200e-14,  1.095659373900358e-16, -6.815375991673472e-19, -3.720002684182274e-21,  3.984478258952697e-23,  9.886739619029010e-26,
  1.233595764042263e+00, -5.294246730143656e-03, -5.216000950772874e-06,  1.056694356615429e-07,  1.638906899254402e-10, -3.937906957755216e-12, -5.856016868781722e-15,
  1.801030751352834e-16,  2.069015262912829e-19, -9.182396404361262e-21, -6.575019835142471e-24,  4.954023304363837e-25,  1.371064353835443e+00, -5.087246247192024e-03,
 -1.167398958872577e-05,  9.074574281332110e-08,  5.324316729113670e-10, -2.857828152580963e-12, -2.841951395919931e-14,  1.005509171008660e-16,  1.630776368327531e-18,
 -3.285943984166392e-21, -9.779403346011167e-23,  5.618241644575776e-26,  1.507653375960349e+00, -4.625161499551896e-03, -1.755387685202372e-05,  4.811511717847441e-08,
  7.936247241066767e-10,  6.386705631262940e-13, -3.696670110883087e-14, -1.645512595363260e-16,  1.520674819616541e-18,  1.524409798075933e-20, -3.949271653054353e-23,
 -1.118848563870999e-24,  1.639157706392508e+00, -3.896204686460084e-03, -2.131291641986941e-05, -1.698177060525346e-08,  7.208786010060954e-10,  4.889565190888813e-12,
 -9.728291325448708e-15, -3.392686149514184e-16, -1.450617061289791e-18,  1.287106127183788e-20,  1.756880031918592e-22,  2.103657622012366e-25,  1.760068992756298e+00,
 -2.936141773083423e-03, -2.130200077968913e-05, -8.153154192198996e-08,  2.178821481761268e-10,  5.765956934314132e-12,  3.600850604992266e-14, -4.095979797910373e-17,
 -2.674718760588789e-18, -2.094602297997278e-20, -1.069753663985099e-24,  1.497522263493693e-24,  1.863602572653614e+00, -1.855529563077458e-03, -1.672050924352352e-05,
 -1.089137985236570e-07, -4.114127930321623e-10,  1.117397369087772e-12,  3.531093537788724e-14,  3.243102969856856e-16,  1.379688063469893e-18, -6.256421294264526e-21,
 -1.715270131710760e-22, -1.579290056267519e-24,  1.942202165436104e+00, -8.517027710664441e-04, -8.953107678737114e-06, -7.788968988215802e-08, -5.709980455491098e-10,
 -3.343988774335485e-12, -1.198631670521246e-14,  3.899692439303984e-17,  1.278162603065282e-18,  1.499393686092460e-20,  1.217793255860047e-22,  6.638381573620127e-25,
  1.988765301285534e+00, -1.735719000265671e-04, -1.992544988803823e-06, -2.008262524367384e-08, -1.868063860746323e-10, -1.635733017614082e-12, -1.358670376830393e-14,
 -1.071329096023917e-16, -7.977305884439250e-19, -5.534502024042192e-21, -3.472902245218417e-23, -1.827526129338862e-25,  1.132846613870038e-03, -8.580481223344006e-06,
  4.871666310498830e-08, -2.458004915548418e-10,  1.161437792969727e-12, -5.268213469603770e-15,  2.317839768536294e-17, -1.000630749244442e-19,  4.223378604795651e-22,
 -1.779130806797727e-24,  7.215865579008223e-27, -3.078451894406955e-29,  1.019653219439914e-02, -7.706629154291712e-05,  4.353287311187047e-07, -2.176321745240890e-09,
  1.013477840674848e-11, -4.500692222726669e-14,  1.922713657097347e-16, -7.982600929733872e-19,  3.198669769548485e-21, -1.263842411600373e-23,  4.680487201131631e-26,
 -1.829607368310727e-28,  2.832861726216125e-02, -2.131867342721304e-04,  1.191818015153690e-06, -5.846181410059966e-09,  2.640271146468918e-11, -1.119625360409487e-13,
  4.471242139737208e-16, -1.686043307723410e-18,  5.855108284862255e-21, -1.880864757161867e-23,  4.670290132874160e-26, -1.022565148329951e-28,  5.553777459749973e-02,
 -4.151991006826526e-04,  2.284293198478312e-06, -1.087413015636777e-08,  4.669793435630548e-11, -1.826319291407502e-13,  6.392249983545803e-16, -1.920381688617922e-18,
  4.051362804358850e-21, -7.600967206729291e-26, -7.682366762348071e-26,  5.032360977725702e-28,  9.183504374017272e-02, -6.803860918798819e-04,  3.660874088808485e-06,
 -1.669202635367492e-08,  6.636005977409654e-11, -2.257261815569471e-13,  5.910535829725970e-16, -6.542860047041061e-19, -5.410807208117360e-21,  5.060178018846880e-23,
 -3.021593912186827e-25,  1.228676209645635e-27,  1.372312270929700e-01, -1.004925238488186e-03,  5.250477683251768e-06, -2.255212974015136e-08,  7.966755050737729e-11,
 -2.072288156395150e-13,  1.493992613173086e-16,  2.519898085977584e-18, -2.155948879410451e-20,  1.101920989695285e-22, -4.310434435007093e-25,  8.308918858141808e-28,
  1.917329840002444e-01, -1.383703334560675e-03,  6.961288052454135e-06, -2.754207724599963e-08,  8.035501992744732e-11, -9.755991754957061e-14, -7.471324304817828e-16,
  7.098801824972895e-18, -3.693536815607388e-20,  1.210360520848068e-22, -1.448487380461578e-25, -1.905509555544306e-27,  2.553371782000661e-01, -1.810065569795878e-03,
  8.679044308197440e-06, -3.061323038982046e-08,  6.238344884527107e-11,  1.190031203008903e-13, -1.993918538792062e-15,  1.131597925271716e-17, -3.764768698539151e-20,
  1.156630809302017e-23,  7.476341194606178e-25, -6.272059698580684e-27,  3.280228187449506e-01, -2.275486143411679e-03,  1.026540753482363e-05, -3.063112750141374e-08,
  2.104684477480133e-11,  4.328521058276166e-13, -3.255413060356764e-15,  1.214544646771332e-17, -7.819679451187804e-21, -2.489735775612898e-22,  1.907840532516946e-24,
 -7.851471536266565e-27,  4.097396264175053e-01, -2.769144700379844e-03,  1.155689293616984e-05, -2.646102867797079e-08, -4.549793256988719e-11,  7.965831393503385e-13,
 -3.939689037641680e-15,  5.992476529487323e-18,  5.990640987093226e-20, -5.693874226294271e-22,  2.157399443094881e-24,  4.321592202728056e-28,  5.003918106291220e-01,
 -3.277392209683015e-03,  1.236524462224053e-05, -1.710712886612539e-08, -1.342246415390203e-10,  1.114356734829597e-12, -3.263154548524822e-15, -9.557566759843472e-18,
  1.483097401022168e-19, -6.730068697434930e-22, -1.989952658087067e-25,  2.103506330982506e-26,  5.998149894129744e-01, -3.783093732446963e-03,  1.248079319848382e-05,
 -1.930385291105859e-09, -2.348204395509743e-10,  1.239104644192307e-12, -4.792903144665222e-16, -3.274732772481907e-17,  2.003085643971011e-19, -1.536421885684966e-22,
 -5.729348219367293e-24,  3.855450631613045e-26,  7.077432355474772e-01, -4.264849900960789e-03,  1.168142593984541e-05,  1.902542335804032e-08, -3.272269342672064e-10,
  9.887586669746038e-13,  4.646744108690635e-15, -5.398777463229606e-17,  1.219217652543027e-19,  1.200492254394726e-21, -1.089127789479989e-23,  1.365849646844197e-26,
  8.237618685932713e-01, -4.696136104910754e-03,  9.751509289537060e-06,  4.457414892324602e-08, -3.801622839149627e-10,  1.993082322368313e-13,  1.109344767388064e-14,
 -5.397921409574350e-17, -1.653117937996138e-19,  2.753919103610077e-21, -6.325997391109085e-24, -8.275648589517019e-26,  9.472397188404413e-01, -5.044482549802540e-03,
  6.517566329517791e-06,  7.180065301630472e-08, -3.528802364589279e-10, -1.163597807016628e-12,  1.577838319543629e-14, -9.326454770033952e-18, -5.937911629607619e-19,
  2.466965985666977e-21,  1.628843038671412e-23, -1.707790574085749e-25,  1.077232141510912e+00, -5.270995022515260e-03,  1.910429850830773e-06,  9.545253906176962e-08,
 -2.043448750686810e-10, -2.826064675793203e-12,  1.348271218574271e-14,  8.592824519425502e-17, -7.860064823934258e-19, -2.070495792883378e-21,  4.186552194281586e-23,
 -5.937869916497452e-27,  1.212343406973979e+00, -5.330864053247743e-03, -3.934853262322273e-06,  1.076557094614119e-07,  8.413814770897388e-11, -4.017494777543412e-12,
 -7.702495269362341e-16,  1.814265982200406e-16, -1.231729409327946e-19, -9.013424961838203e-21,  1.480268602326201e-23,  4.651963203697633e-25,  1.350535680119392e+00,
 -5.176142126323019e-03, -1.053593057763786e-05,  9.877139970255812e-08,  4.687123904619569e-10, -3.500350574849265e-12, -2.489661378968921e-14,  1.500979645573938e-16,
  1.443433127762474e-18, -7.064153030615063e-21, -8.905261585852809e-23,  3.386986234027553e-25,  1.488875830309717e+00, -4.763066472574561e-03, -1.690004612537865e-05,
  6.086563424502784e-08,  7.971834475860057e-10, -2.978269472564493e-13, -4.081310836713034e-14, -1.075109801847419e-16,  2.029066320519337e-18,  1.267178717294895e-20,
 -8.898200722534040e-23, -1.098996825579801e-24,  1.623230876861652e+00, -4.067319730505566e-03, -2.144431634001429e-05, -4.681386497554956e-09,  8.155405389014629e-10,
  4.537323413994305e-12, -1.979830471356350e-14, -3.769101850207273e-16, -8.600662120069602e-19,  1.991253570420351e-20,  1.718075931340523e-22, -4.170654788028296e-25,
  1.747977492857071e+00, -3.110402962743881e-03, -2.225550646877944e-05, -7.707649219275612e-08,  3.416974995257926e-10,  6.606033167556556e-12,  3.355074285589867e-14,
 -1.384833990441784e-16, -3.411889319062555e-18, -1.947608043797537e-20,  7.934285171102289e-23,  2.150529899124096e-24,  1.855904493457420e+00, -1.994631390354258e-03,
 -1.806607517306043e-05, -1.152684001396754e-07, -3.798299684485812e-10,  2.078558119327504e-12,  4.496561268708852e-14,  3.633918022391123e-16,  1.013508638531530e-18,
 -1.458192239902558e-20, -2.462626297345983e-22, -1.784282084860569e-24,  1.938645958922702e+00, -9.272268312859701e-04, -9.944856203302910e-06, -8.757586584028664e-08,
 -6.406399622456078e-10, -3.613401781919743e-12, -1.023360377611895e-14,  8.953213733483541e-17,  1.912689704651357e-18,  2.045017021001547e-20,  1.508058715966919e-22,
  6.309085432997573e-25,  1.988037531522995e+00, -1.905296439892488e-04, -2.252609795832955e-06, -2.335203602281290e-08, -2.230405581780147e-10, -2.000889243002907e-12,
 -1.697576620690823e-14, -1.361324741327755e-16, -1.023987021790622e-18, -7.092187692582530e-21, -4.332422574010633e-23, -2.056896332216062e-25,  1.099285910425319e-03,
 -8.202238246956498e-06,  4.587517358080240e-08, -2.280311022556073e-10,  1.061417044530110e-12, -4.744083197917022e-15,  2.055659255474670e-17, -8.751989552437534e-20,
  3.631717318337522e-22, -1.516113737506515e-24,  5.968844590715931e-27, -2.613586495190838e-29,  9.895070691040666e-03, -7.368543529651332e-05,  4.101568962135366e-07,
 -2.021123073031989e-09,  9.279032674649368e-12, -4.064946631951073e-14,  1.712871750666057e-16, -7.028363776553354e-19,  2.775510321251408e-21, -1.092026761944655e-23,
  3.926140087110839e-26, -1.612262187202238e-28,  2.749450502247266e-02, -2.039257917942534e-04,  1.124126448954837e-06, -5.441084660526532e-09,  2.426705342053706e-11,
 -1.017775063702674e-13,  4.024388153015659e-16, -1.509162228754530e-18,  5.210485207809621e-21, -1.703642396606249e-23,  4.175763576418127e-26, -1.230674115222607e-28,
  5.391271802477771e-02, -3.974342837789001e-04,  2.158168751994296e-06, -1.015536878463217e-08,  4.319442997464246e-11, -1.679211504124519e-13,  5.872649186875715e-16,
 -1.791334477900168e-18,  3.998217643564037e-21, -2.753343711220102e-24, -5.818603851687943e-26,  3.460129788094227e-28,  8.917082980024733e-02, -6.518826046268033e-04,
  3.466793837811973e-06, -1.566561741251676e-08,  6.198581081225809e-11, -2.117786987865164e-13,  5.705673498323485e-16, -8.005165768438159e-19, -3.794344681124268e-21,
  3.952241062104791e-23, -2.536506877563199e-25,  9.755267868417770e-28,  1.332938499988749e-01, -9.639825632844868e-04,  4.987364133534133e-06, -2.131038809325538e-08,
  7.556415736913011e-11, -2.028709584940097e-13,  2.108708056066511e-16,  1.890208841090005e-18, -1.789413901621572e-20,  9.367724112178733e-23, -3.950003116192154e-25,
  7.895308086201276e-28,  1.863074887262121e-01, -1.329313347578274e-03,  6.638429840963541e-06, -2.627291554579357e-08,  7.823993655443326e-11, -1.132354744395273e-13,
 -5.642668422290480e-16,  5.985316144565476e-18, -3.270082976817757e-20,  1.137524702268799e-22, -2.151577879101795e-25, -1.332669109185755e-27,  2.482334781973919e-01,
 -1.742085517573745e-03,  8.317744762826201e-06, -2.959854949305827e-08,  6.430993422514536e-11,  7.481568846183293e-14, -1.693836565001189e-15,  1.012316732649570e-17,
 -3.675649820334880e-20,  3.628028340635309e-23,  4.957912588720543e-25, -5.212544507740604e-27,  3.190828016415502e-01, -2.194826821584414e-03,  9.900126747911566e-06,
 -3.022925169180722e-08,  2.894995421509693e-11,  3.587670144458777e-13, -2.920090120108747e-15,  1.176586223605424e-17, -1.549208869949039e-20, -1.795376523003530e-22,
  1.565216355362843e-24, -7.682370556599081e-27,  3.988459309482504e-01, -2.677970883977128e-03,  1.123550205887352e-05, -2.706661894236297e-08, -3.049716288821263e-11,
  7.042423513249381e-13, -3.748024478432238e-15,  7.598148334005663e-18,  4.095755906946428e-20, -4.836654831359244e-22,  2.106784284470652e-24, -2.581031419856490e-27,
  4.874787362181308e-01, -3.179326238229911e-03,  1.214779497612838e-05, -1.908076283320489e-08, -1.127396639440311e-10,  1.033343572060889e-12, -3.467967018066700e-15,
 -5.199151437798610e-18,  1.241432842070163e-19, -6.644240009781516e-22,  5.803931477972716e-25,  1.448256572386654e-26,  5.848820727702576e-01, -3.683402038629229e-03,
  1.243590077671002e-05, -5.490179379038556e-09, -2.102239311000232e-10,  1.217316279446159e-12, -1.307605136617812e-15, -2.646691508524208e-17,  1.910531566566670e-19,
 -3.498016230683648e-22, -4.105682893192936e-24,  3.485440193699340e-26,  6.908720610636955e-01, -4.170572739084346e-03,  1.187898805884052e-05,  1.395354760108524e-08,
 -3.064565495242200e-10,  1.082618463321056e-12,  3.195613032384163e-15, -4.947744852047662e-17,  1.574803163581959e-19,  7.809170735876507e-22, -9.997965443903809e-24,
  2.595252699631551e-26,  8.051365904899069e-01, -4.616087481246096e-03,  1.025008047204316e-05,  3.853738407158449e-08, -3.736388241989118e-10,  4.469058868994032e-13,
  9.522487402463690e-15, -5.773835780861110e-17, -7.152157669784466e-20,  2.436983564487724e-21, -9.301440567641886e-24, -5.270068985721111e-26,  9.271713888819391e-01,
 -4.988993206834055e-03,  7.344596003136332e-06,  6.598884227017370e-08, -3.723972663762440e-10, -7.901112559481996e-13,  1.526538640247832e-14, -2.679578929742406e-17,
 -4.950679343409602e-19,  2.968012635502275e-21,  8.791889701505970e-24, -1.670158242283075e-25,  1.056185898708156e+00, -5.251189621181525e-03,  3.034437070229717e-06,
  9.174919830279337e-08, -2.574503716027211e-10, -2.476507254759321e-12,  1.552765945522285e-14,  5.990440234648953e-17, -8.307244542310430e-19, -4.294444004311703e-22,
  3.951828499801675e-23, -9.759702297807496e-26,  1.190965199202880e+00, -5.357158624304413e-03, -2.637557594997871e-06,  1.083598316311387e-07,  4.011311647770057e-12,
 -3.975761591368844e-12,  4.206773452049757e-15,  1.724463478016552e-16, -4.322674592370960e-19, -8.034943310540906e-21,  3.345229308562376e-23,  3.736238651368675e-25,
  1.329670216065484e+00, -5.255566577980741e-03, -9.308088663040132e-06,  1.056797962658481e-07,  3.930965046301441e-10, -4.042475689071489e-12, -2.009015376259707e-14,
  1.915651541783052e-16,  1.129295147117605e-18, -1.025238526951004e-20, -6.859312656016300e-23,  5.804023416428238e-25,  1.469558094550120e+00, -4.895129260228999e-03,
 -1.609350033137284e-05,  7.351881043874672e-08,  7.812275387668251e-10, -1.305733473320426e-12, -4.285124682705829e-14, -3.606072085959906e-17,  2.409959612517373e-18,
  8.195479996776450e-21, -1.332275877449798e-22, -8.787331969785118e-25,  1.606618455119936e+00, -4.238870429761276e-03, -2.141930000028115e-05,  9.063781684020843e-09,
  9.006674887540023e-10,  3.933120943870392e-12, -3.062014788821432e-14, -3.916851570136297e-16, -2.591230387731643e-20,  2.619938840136620e-20,  1.369697130936784e-22,
 -1.178885872919777e-24,  1.735174079888486e+00, -3.292043426462044e-03, -2.314312386907089e-05, -7.051016509488103e-08,  4.814898453445418e-10,  7.351762005157916e-12,
  2.804476691966836e-14, -2.580741293554639e-16, -4.031541138011180e-18, -1.424204542043075e-20,  1.860990433459993e-22,  2.660116402259195e-24,  1.847628009106652e+00,
 -2.144792630920430e-03, -1.948418827229054e-05, -1.209509566614972e-07, -3.266262641219231e-10,  3.282940477324283e-12,  5.550127083157388e-14,  3.853696870616868e-16,
  2.922859160657532e-19, -2.600194626837195e-20, -3.239977597690982e-22, -1.678373598823392e-24,  1.934771024782084e+00, -1.011169150843671e-03, -1.105969345337102e-05,
 -9.841660823199221e-08, -7.151222171113264e-10, -3.821286014626985e-12, -6.750541081690497e-15,  1.637332217511248e-16,  2.763717793914654e-18,  2.698453639580528e-20,
  1.740927628357383e-22,  3.780404235294240e-25,  1.987237506588865e+00, -2.097352790027705e-04, -2.555642122508276e-06, -2.726432937149922e-08, -2.674614577257624e-10,
 -2.457999194619523e-12, -2.128709259962818e-14, -1.733374991895481e-16, -1.312704332684841e-18, -9.008335511969403e-21, -5.247455594823915e-23, -2.039670319588043e-25,
  1.067194028142465e-03, -7.845900686676023e-06,  4.323764990507670e-08, -2.117814872511294e-10,  9.712770464306238e-13, -4.278867271560332e-15,  1.826084702587513e-17,
 -7.672778686887969e-20,  3.126217660543119e-22, -1.299315131224467e-24,  4.894165801849808e-27, -2.297144541091544e-29,  9.606741338315824e-03, -7.049873050596827e-05,
  3.867680834857200e-07, -1.878945621359480e-09,  8.505608603020526e-12, -3.676504364903710e-14,  1.527941666176594e-16, -6.200206159702791e-19,  2.408981559517503e-21,
 -9.487180693720297e-24,  3.248682774824896e-26, -1.483929039797938e-28,  2.669638347484058e-02, -1.951875029901148e-04,  1.061097558448303e-06, -5.068585461999613e-09,
  2.232476083873024e-11, -9.260776764173340e-14,  3.624266040125654e-16, -1.351928341312812e-18,  4.625867149035514e-21, -1.548197123042292e-23,  3.575583202741700e-26,
 -1.520002582283839e-28,  5.235675603797882e-02, -3.806448929281090e-04,  2.040342598531113e-06, -9.490376290371183e-09,  3.997296207406539e-11, -1.544143301528034e-13,
  5.388808104273078e-16, -1.665399544834507e-18,  3.860463062383469e-21, -4.821335414417711e-24, -4.634158292903924e-26,  1.906740583883538e-28,  8.661760088041044e-02,
 -6.248836605281246e-04,  3.284619681453161e-06, -1.470699286309987e-08,  5.788529185048516e-11, -1.983665296525010e-13,  5.466534173744890e-16, -9.010495144829188e-19,
 -2.544522372929579e-21,  3.015754029601207e-23, -2.165581037360935e-25,  7.050555845632857e-28,  1.295161265948153e-01, -9.250863018864987e-04,  4.738760677858885e-06,
 -2.013352908366155e-08,  7.156131261194291e-11, -1.972366454930148e-13,  2.562657029835853e-16,  1.368570978269886e-18, -1.479810878014408e-20,  7.853487295494088e-23,
 -3.632618419450611e-25,  6.318530088550389e-28,  1.810944832832977e-01, -1.277445904157994e-03,  6.330588920120342e-06, -2.503987514011681e-08,  7.585278243922329e-11,
 -1.248813368594162e-13, -4.107248052133005e-16,  5.002642306578915e-18, -2.877374307349516e-20,  1.040840979677421e-22, -2.660175005241183e-25, -1.025453293396134e-27,
  2.413959953809813e-01, -1.676946697706223e-03,  7.968778403787594e-06, -2.855973480014778e-08,  6.542200524145854e-11,  3.743341648063786e-14, -1.426633674549089e-15,
  8.971251398908138e-18, -3.514635254673033e-20,  5.177970807358211e-23,  2.849218837471191e-25, -4.426131091348649e-27,  3.104596107653118e-01, -2.117068416156168e-03,
  9.540379678452219e-06, -2.971234656878653e-08,  3.545084451264750e-11,  2.925766054738271e-13, -2.598475746579744e-15,  1.117812898660419e-17, -2.090919129323758e-20,
 -1.236055582073346e-22,  1.233477850823374e-24, -7.399990661873440e-27,  3.883117480430864e-01, -2.589393321379327e-03,  1.090822407584345e-05, -2.744670739775665e-08,
 -1.729390989587105e-11,  6.169753307512805e-13, -3.519430478946985e-15,  8.646197946762513e-18,  2.502860061149451e-20, -4.023719483484823e-22,  1.941527912521254e-24,
 -4.834136496212668e-27,  4.749543045883715e-01, -3.083088879137767e-03,  1.190867005604357e-05, -2.072382641466807e-08, -9.291466938336889e-11,  9.487924385058145e-13,
 -3.561484299837482e-15, -1.603655969607609e-18,  1.007790268069798e-19, -6.302616563068721e-22,  1.084306294862504e-24,  8.519436868476272e-27,  5.703469434726269e-01,
 -3.584233703893290e-03,  1.235063437331278e-05, -8.660936484466509e-09, -1.862479405750376e-10,  1.177719024535538e-12, -1.965189115468720e-15, -2.058348646999727e-17,
  1.758598913461520e-19, -4.849088788754762e-22, -2.691056468868824e-24,  2.918300292969550e-26,  6.743807789074727e-01, -4.074952750152760e-03,  1.201773756608195e-05,
  9.227168367987900e-09, -2.841464046236571e-10,  1.143281477195810e-12,  1.884485355812467e-15, -4.406307482992602e-17,  1.786917362267698e-19,  4.061435142212178e-22,
 -8.693832595078593e-24,  3.239714277742637e-26,  7.868390282102339e-01, -4.532337915567351e-03,  1.067699342377342e-05,  3.264253183992660e-08, -3.625472623646604e-10,
  6.558652678745184e-13,  7.886424926583786e-15, -5.869918625091493e-17,  9.030031294643265e-21,  2.026847017334589e-21, -1.100766135138312e-23, -2.559644893795280e-26,
  9.073378003199499e-01, -4.927171339470030e-03,  8.100254208628022e-06,  5.992368825342483e-08, -3.846053967811275e-10, -4.344347297992256e-13,  1.430977866045136e-14,
 -4.087462784566221e-17, -3.836195697512587e-19,  3.177379689425156e-21,  1.814836016290867e-24, -1.481189690057780e-25,  1.035236560500663e+00, -5.222583819731413e-03,
  4.109144736183431e-06,  8.725451543294413e-08, -3.031335614617168e-10, -2.086723059266940e-12,  1.683261373640210e-14,  3.336918508331867e-17, -8.189704146644556e-19,
  1.043337527042390e-21,  3.362152069714667e-23, -1.660819162564753e-25,  1.169502592758947e+00, -5.373062721562480e-03, -1.339456352043076e-06,  1.077949866369141e-07,
 -7.411236255343599e-11, -3.818677419718709e-12,  8.800147049170404e-15,  1.542738852295814e-16, -6.938131525814480e-19, -6.405394080255224e-21,  4.703963860195391e-23,
  2.386960660400487e-25,  1.308507194644379e+00, -5.324858040245072e-03, -8.004941588207752e-06,  1.112982392936958e-07,  3.078794160152802e-10, -4.456548624585961e-12,
 -1.427936067029491e-14,  2.213209599212378e-16,  7.174739593012812e-19, -1.243217403497215e-20, -3.926396632165031e-23,  7.353984695928927e-25,  1.449725965849564e+00,
 -5.020138214895637e-03, -1.513732010387379e-05,  8.575347227784684e-08,  7.447928388858826e-10, -2.337331302986994e-12, -4.274467187173306e-14,  4.468064440051175e-17,
  2.600713664411120e-18,  2.200842823506463e-21, -1.635324827934643e-22, -4.717307024180108e-25,  1.589321306837272e+00, -4.409539086235393e-03, -2.122161418834072e-05,
  2.406011316431049e-08,  9.710960729996315e-10,  3.067444017093801e-12, -4.145026650332583e-14, -3.764813248132750e-16,  1.001293304374272e-18,  3.041220328855078e-20,
  6.815780173945405e-23, -1.932711812513764e-24,  1.721630457336349e+00, -3.480430541109977e-03, -2.393805955757019e-05, -6.159619993135587e-08,  6.345933712142333e-10,
  7.923128836031412e-12,  1.894707754675205e-14, -3.936161741618966e-16, -4.381323831418003e-18, -4.383561325277979e-21,  3.077579950356026e-22,  2.783784294123342e-24,
  1.838727781066996e+00, -2.306555146835983e-03, -2.096454465148853e-05, -1.255756570017839e-07, -2.467716760251108e-10,  4.744554305288177e-12,  6.626321189374387e-14,
  3.771079249806570e-16, -8.936005468693835e-19, -4.029104597525564e-20, -3.855640009065848e-22, -1.001710857877950e-24,  1.930541631094752e+00, -1.104571065943811e-03,
 -1.231189033015404e-05, -1.104770216644532e-07, -7.927410857854386e-10, -3.917344720307677e-12, -7.720966105684817e-16,  2.690830668659277e-16,  3.863145697196781e-18,
  3.412340560384021e-20,  1.780376423635843e-22, -2.873291028479998e-25,  1.986355495241238e+00, -2.315657783654495e-04, -2.910207294158981e-06, -3.196649049040910e-08,
 -3.221493308070062e-10, -3.032192116339928e-12, -2.678037419129642e-14, -2.209548777314137e-16, -1.676848631805927e-18, -1.127471061180990e-20, -6.040030564199295e-23,
 -1.419547010223404e-25,  1.036486496987301e-03, -7.509907164184935e-06,  4.078676578787304e-08, -1.969025717784060e-10,  8.899139492983650e-13, -3.865298956878558e-15,
  1.624574975521771e-17, -6.743645405249008e-20,  2.691319289429382e-22, -1.123209092600701e-24,  3.921274611487421e-27, -2.159125902463020e-29,  9.330795099832685e-03,
 -6.749251631944383e-05,  3.650136391696898e-07, -1.748544796935287e-09,  7.805615834788334e-12, -3.329790662921652e-14,  1.364631830596837e-16, -5.481597051623940e-19,
  2.089272521110766e-21, -8.317123386758327e-24,  2.601826589273046e-26, -1.482061380186886e-28,  2.593223420223372e-02, -1.869360800457828e-04,  1.002358085252042e-06,
 -4.725746503029451e-09,  2.055660599507301e-11, -8.434755539289128e-14,  3.265630992270633e-16, -1.212555979971544e-18,  4.092535978623215e-21, -1.419826149344640e-23,
  2.806070068680389e-26, -2.030342330829178e-28,  5.086611572507210e-02, -3.647670477781983e-04,  1.930195807459887e-06, -8.874828095067775e-09,  3.701030115768582e-11,
 -1.420269783308220e-13,  4.939505474279011e-16, -1.544986134207211e-18,  3.655095716651753e-21, -6.557778241625256e-24, -4.181055230789902e-26,  7.286724036894428e-30,
  8.416952425795035e-02, -5.992971908636387e-04,  3.113564118458355e-06, -1.381186273343654e-08,  5.404707098906328e-11, -1.855578564715009e-13,  5.204357036416989e-16,
 -9.667199549094857e-19, -1.608111749523888e-21,  2.202501021273773e-23, -1.924601742503579e-25,  3.754508153477494e-28,  1.258900984969958e-01, -8.881234587503437e-04,
  4.503899154498810e-06, -1.901975967610107e-08,  6.768092156734256e-11, -1.906774253475397e-13,  2.883614676713044e-16,  9.375130946904527e-19, -1.222639919859817e-20,
  6.448126447426875e-23, -3.417140505170857e-25,  3.151069696019762e-28,  1.760841149319794e-01, -1.227982667917232e-03,  6.037308254687014e-06, -2.384670142328069e-08,
  7.326740443559310e-11, -1.331585035410657e-13, -2.829932974269763e-16,  4.139694911256173e-18, -2.522886880198054e-20,  9.256389820430620e-23, -3.100644631040210e-25,
 -1.037412599002356e-27,  2.348135636871198e-01, -1.614549497733741e-03,  7.632361006548786e-06, -2.750877055737024e-08,  6.584797903787919e-11,  6.083251340209204e-15,
 -1.190890446219881e-15,  7.878221403553525e-18, -3.312266482273972e-20,  5.942991256350985e-23,  1.004170299975787e-25, -4.041143938082325e-27,  3.021417392095574e-01,
 -2.042161505509366e-03,  9.187417212680592e-06, -2.910160420600027e-08,  4.070368743015126e-11,  2.338896443960168e-13, -2.295460185379781e-15,  1.044672733789858e-17,
 -2.454881683564798e-20, -8.072318539763514e-23,  9.114499475460739e-25, -7.294975473849264e-27,  3.781266149515236e-01, -2.503448766270588e-03,  1.057759593782527e-05,
 -2.762919946668499e-08, -5.779044164991548e-12,  5.354917656271270e-13, -3.268197476929193e-15,  9.229885265100527e-18,  1.188466412491609e-20, -3.295314823479371e-22,
  1.686776120469653e-24, -6.726679625182145e-27,  4.628108789659867e-01, -2.988838123205874e-03,  1.165167546359521e-05, -2.206330748611399e-08, -7.479541840060722e-11,
  8.631217544457549e-13, -3.564585198073714e-15,  1.267247506574863e-18,  7.894566114332525e-20, -5.810329683677935e-22,  1.337146601024955e-24,  3.022532488454901e-27,
  5.562068913946895e-01, -3.485893240741173e-03,  1.222959181846014e-05, -1.145521582378290e-08, -1.632086733084414e-10,  1.124257530956425e-12, -2.465499974392427e-15,
 -1.525365798067985e-17,  1.567571378706553e-19, -5.688569922083760e-22, -1.557754789297979e-24,  2.212658825297562e-26,  6.582738461692603e-01, -3.978443481646146e-03,
  1.210194693964198e-05,  4.865800593774140e-09, -2.609250454410848e-10,  1.174361262294464e-12,  7.325090950586608e-16, -3.817528041822602e-17,  1.874038007442129e-19,
  8.758564821244913e-23, -7.226423602025028e-24,  3.345168525766185e-26,  7.688828514521574e-01, -4.445452678544275e-03,  1.103436392835560e-05,  2.695644058748850e-08,
 -3.476699011423832e-10,  8.255135281574838e-13,  6.257245893423278e-15, -5.732952816131336e-17,  7.386222455518572e-20,  1.570803514910876e-21, -1.163844496025190e-23,
 -4.199418134617253e-27,  8.877631248208788e-01, -4.859598122569658e-03,  8.782188946812111e-06,  5.371873957235549e-08, -3.899591678993723e-10, -1.060151993352949e-13,
  1.301065176849664e-14, -5.131856593178267e-17, -2.694281408750371e-19,  3.127379531609380e-21, -4.112040638260810e-24, -1.203832494180782e-25,  1.014418482476914e+00,
 -5.185607925280443e-03,  5.125792704110015e-06,  8.209271741674214e-08, -3.407676390768904e-10, -1.674446065583166e-12,  1.740746206713943e-14,  8.007476103155389e-18,
 -7.590958401796901e-19,  2.227949881628691e-21,  2.531016678244618e-23, -2.071533595737039e-25,  1.147997066980849e+00, -5.378630094318502e-03, -5.551055585630135e-08,
  1.060110967938101e-07, -1.480378038444486e-10, -3.558346319700668e-12,  1.277701648381938e-14,  1.287633734778727e-16, -8.884153445535099e-19, -4.358691235864625e-21,
  5.416577174333314e-23,  8.396116501195313e-26,  1.287088251239515e+00, -5.383478398560745e-03, -6.642802073243735e-06,  1.154947901453173e-07,  2.158349718383046e-10,
 -4.722717838982243e-12, -7.830015815542762e-15,  2.368807627381044e-16,  2.496458415985701e-19, -1.333512111613372e-20, -5.597526418500719e-24,  7.745505118461867e-25,
  1.429410013995875e+00, -5.136921937480719e-03, -1.403849994549642e-05,  9.724104067871170e-08,  6.879375729279196e-10, -3.338759321116941e-12, -4.032577576291563e-14,
  1.278769574821724e-16,  2.558554475443773e-18, -4.605313204718068e-21, -1.728994978283504e-22,  5.873598573784418e-26,  1.571345811818283e+00, -4.577888682314074e-03,
 -2.083782778787453e-05,  4.003088437167015e-08,  1.021666089388651e-09,  1.950786683789418e-12, -5.137584191628121e-14, -3.265740812035302e-16,  2.122997348975941e-18,
  3.125325442806920e-20, -3.016254023702042e-23, -2.486592121780269e-24,  1.707321304647736e+00, -3.674706841860130e-03, -2.461099462282109e-05, -5.015433163337085e-08,
  7.966283563530303e-10,  8.229705773795065e-12,  5.957571376525673e-15, -5.337329506125940e-16, -4.288842134987610e-18,  1.027650120814287e-20,  4.214157139856081e-22,
  2.254647773178188e-24,  1.829156499491598e+00, -2.480358466850764e-03, -2.249172168496814e-05, -1.286749541908409e-07, -1.351449185535542e-10,  6.456899984698462e-12,
  7.618222867212449e-14,  3.222637800514748e-16, -2.628959677363821e-18, -5.621399115609935e-20, -3.994015809461487e-22,  5.372236464227052e-25,  1.925917648077654e+00,
 -1.208590658314785e-03, -1.371629880614116e-05, -1.237858330027400e-07, -8.705858157974648e-10, -3.830310729785845e-12,  8.687157628397768e-15,  4.136893690640025e-16,
  5.213747154066238e-18,  4.065318037802856e-20,  1.385688016766374e-22, -1.650129922347791e-24,  1.985380109276856e+00, -2.564742995990642e-04, -3.326851903801383e-06,
 -3.764316967820249e-08, -3.897545786096334e-10, -3.755617393540709e-12, -3.378274139826921e-14, -2.815843808894493e-16, -2.127354527986470e-18, -1.377193542929351e-20,
 -6.307543369590491e-23,  5.030652579100012e-26,  1.007084826138181e-03, -7.192828045471364e-06,  3.850688247736791e-08, -1.832618369196736e-10,  8.163588790074232e-13,
 -3.497122756421430e-15,  1.447222639194462e-17, -5.944278995607163e-20,  2.312900424803192e-22, -9.854786505580591e-25,  2.956939273278687e-27, -2.275296870597579e-29,
  9.066535295429922e-03, -6.465426371090243e-05,  3.447590265895877e-07, -1.628809746684435e-09,  7.171203535365702e-12, -3.019968688629512e-14,  1.220070503023926e-16,
 -4.859057534649644e-19,  1.806983521711241e-21, -7.410896620536579e-24,  1.914821645267189e-26, -1.682938458557766e-28,  2.520017618280106e-02, -1.791385852969725e-04,
  9.475682404940519e-07, -4.409921860954673e-09,  1.894535445795109e-11, -7.690312621392620e-14,  2.943695835369758e-16, -1.089575242041142e-18,  3.599236400309972e-21,
 -1.327868190385864e-23,  1.721455518312706e-26, -3.002459070654505e-28,  4.943727011246056e-02, -3.497416180334921e-04,  1.827159168249538e-06, -8.304757954953246e-09,
  3.428487303246999e-11, -1.306782934426622e-13,  4.522906107698287e-16, -1.432126497425155e-18,  3.388373584560984e-21, -8.292812956705845e-24, -4.683500285683748e-26,
 -2.539341659049831e-28,  8.182112320653862e-02, -5.750372242087633e-04,  2.952889989228480e-06, -1.297612950541410e-08,  5.045859877295743e-11, -1.733973522321264e-13,
  4.927558693763981e-16, -1.006953779539375e-18, -9.509066406701179e-22,  1.453321406132171e-23, -1.855119938188013e-25, -9.089509440432918e-29,  1.224082471572150e-01,
 -8.529870921136552e-04,  4.282034800324098e-06, -1.796698913945394e-08,  6.393848636553880e-11, -1.834839052727686e-13,  3.094646888781982e-16,  5.807902977723384e-19,
 -1.014905662133534e-20,  5.094397519863647e-23, -3.393321134001629e-25, -2.617884982107277e-28,  1.712669967081216e-01, -1.180809119423365e-03,  5.758092532272466e-06,
 -2.269605952895743e-08,  7.054524607124536e-11, -1.386476416127782e-13, -1.779010246063899e-16,  3.383199820017371e-18, -2.213163546479650e-20,  7.915109421049813e-23,
 -3.639321065457584e-25, -1.501971440780045e-27,  2.284754180912766e-01, -1.554793120496795e-03,  7.308576350269313e-06, -2.645570962233082e-08,  6.570108762949520e-11,
 -1.996881254200392e-14, -9.848140515794358e-16,  6.852955321324404e-18, -3.095377681565748e-20,  5.987628183642359e-23, -7.976416012734264e-26, -4.275252385894613e-27,
  2.941178962160310e-01, -1.970047636854552e-03,  8.842250455168794e-06, -2.841581832034159e-08,  4.485379375426848e-11,  1.822174825960507e-13, -2.014340050878692e-15,
  9.621073494496785e-18, -2.687658568694810e-20, -5.076326632660604e-23,  5.832523207388922e-25, -7.755638371919292e-27,  3.682799604219164e-01, -2.420154985544177e-03,
  1.024583061733603e-05, -2.764015871458531e-08,  4.167534365675788e-12,  4.601887316444833e-13, -3.006130464064504e-15,  9.432793297117751e-18,  1.159463607287113e-21,
 -2.685588393075759e-22,  1.346676003729033e-24, -8.823107993820335e-27,  4.510402494395227e-01, -2.896702820784444e-03,  1.138029006193981e-05, -2.312656596268274e-08,
 -5.838421496192098e-11,  7.782640186327345e-13, -3.496804526476128e-15,  3.469321378055277e-18,  5.900877267332803e-20, -5.264827547222855e-22,  1.350381241545017e-24,
 -2.480548275054388e-27,  5.424580608581565e-01, -3.388649062008827e-03,  1.207719241887023e-05, -1.389002366676069e-08, -1.413469902210208e-10,  1.060507828487465e-12,
 -2.825529244636407e-15, -1.057535187539375e-17,  1.353700584183574e-19, -6.140515019411798e-22, -7.627565460448754e-25,  1.377286031264535e-26,  6.425539753584341e-01,
 -3.881463529832661e-03,  1.213606495133296e-05,  8.795016419056294e-10, -2.373450920192652e-10,  1.179793227971009e-12, -2.523491038826129e-16, -3.218086021600774e-17,
  1.857018139021082e-19, -1.728474784125353e-22, -5.824327651555425e-24,  2.945584424860936e-26,  7.512795074629051e-01, -4.355977119078269e-03,  1.132503469613942e-05,
  2.153342344802336e-08, -3.297863245809480e-10,  9.567408293394752e-13,  4.692969335117635e-15, -5.415107477639577e-17,  1.220303083406648e-19,  1.106215895279194e-21,
 -1.149106076375064e-23,  9.488703848078937e-27,  8.684691801569947e-01, -4.786868233798337e-03,  9.389361354311710e-06,  4.747889158246604e-08, -3.890779045253157e-10,
  1.881258002352422e-13,  1.146966976191527e-14, -5.818047162573708e-17, -1.609990897143762e-19,  2.865808847570929e-21, -8.748805991972082e-24, -9.060090484063584e-26,
  9.937641684812177e-01, -5.140756219509996e-03,  6.077160106089037e-06,  7.639525101312888e-08, -3.700744560345568e-10, -1.256640707456233e-12,  1.730494189697900e-14,
 -1.482313142035539e-17, -6.629226686597819e-19,  3.051848848510626e-21,  1.577384365768652e-23, -2.224943551844068e-25,  1.126489651444085e+00, -5.374031206996287e-03,
  1.200119644552925e-06,  1.030909840722657e-07, -2.158633740364426e-10, -3.211775849537505e-12,  1.596380129363477e-14,  9.824612415450765e-17, -1.005854248644216e-18,
 -2.163679810975720e-21,  5.447982155321980e-23, -6.746967972805317e-26,  1.265456903762598e+00, -5.431025591732248e-03, -5.239288313528700e-06,  1.181845701627597e-07,
  1.200414395364924e-10, -4.830587049711574e-12, -1.157608393594937e-15,  2.372110692907617e-16, -2.263639176838061e-19, -1.289322980312190e-20,  2.708689793226800e-23,
  6.917322331761547e-25,  1.408645357620877e+00, -5.244380657914658e-03, -1.280793564577709e-05,  1.076626369523577e-07,  6.118212165968671e-10, -4.254560153827351e-12,
 -3.563335103600622e-14,  2.057781915445258e-16,  2.270400281796633e-18, -1.130493438224475e-20, -1.580556745203274e-22,  6.095362710988887e-25,  1.552704289854406e+00,
 -4.742389413879635e-03, -2.025831485673438e-05,  5.661971589133176e-08,  1.047654989440382e-09,  6.167402222100804e-13, -5.940259831131578e-14, -2.410886625208187e-16,
  3.199228575755335e-18,  2.777696521878524e-20, -1.448425792683800e-22, -2.647961175727242e-24,  1.692225212066240e+00, -3.873772990563600e-03, -2.513092805282118e-05,
 -3.608911093187012e-08,  9.613635214315509e-10,  8.178307375619456e-12, -1.082850993791736e-14, -6.616284067049297e-16, -3.594547405570518e-18,  2.877654195581248e-20,
  4.935470978688219e-22,  8.760744180504655e-25,  1.818865380655357e+00, -2.666494923195372e-03, -2.404420378312699e-05, -1.297019553580325e-07,  1.295024962499619e-11,
  8.382069507590163e-12,  8.370208784051511e-14,  2.027602844291477e-16, -4.928415967223405e-18, -7.102941433246321e-20, -3.223461097577807e-22,  3.148433840862933e-24,
  1.920854075077552e+00, -1.324505295573186e-03, -1.528778473512332e-05, -1.383124325487444e-07, -9.440655660325264e-10, -3.462580036842872e-12,  2.283286479370627e-14,
  6.048375682700784e-16,  6.754007548553698e-18,  4.412001685043587e-20,  1.713963232895579e-23, -4.077349731964904e-24,  1.984297963997638e+00, -2.850080088570476e-04,
 -3.818615456145239e-06, -4.452701953039877e-08, -4.736551805306081e-10, -4.669183356664825e-12, -4.269811001667720e-14, -3.580689206133786e-16, -2.667078287828336e-18,
 -1.614215482755300e-20, -5.214619217168480e-23,  5.056946345650149e-25,  9.789160028009958e-04, -6.893352699977190e-06,  3.638386240547683e-08, -1.707413139741151e-10,
  7.497591280204809e-13, -3.168957770053803e-15,  1.290626391223663e-17, -5.258833707926922e-20,  1.976907272599201e-22, -8.883618923078587e-25,  1.862806665879039e-27,
 -2.773100592723997e-29,  8.813313289967597e-03, -6.197246869104452e-05,  3.258823163700220e-07, -1.518747854202528e-09,  6.595422196335144e-12, -2.742848956200453e-14,
  1.091720766834017e-16, -4.322183212580238e-19,  1.552083198989409e-21, -6.805690935856664e-24,  1.073145365517844e-26, -2.207636368312131e-28,  2.449845490338172e-02,
 -1.717646769353523e-04,  8.964183917537557e-07, -4.118726976104580e-09,  1.747553488034439e-11, -7.019177628877937e-14,  2.654028557152399e-16, -9.819437302891106e-19,
  3.130012921961623e-21, -1.289978052658766e-23,  4.283519904054125e-28, -4.796513331052041e-28,  4.806691993367132e-02, -3.355138424498741e-04,  1.730709046673280e-06,
 -7.776532143503010e-09,  3.177667094950329e-11, -1.202925503608376e-13,  4.136614450093624e-16, -1.328864816430362e-18,  3.052461707535407e-21, -1.049727764133382e-23,
 -6.638198869255700e-26, -6.662305953591049e-28,  7.956725339750283e-02, -5.520234932095008e-04,  2.801908073464724e-06, -1.219590259012681e-08,  4.710661345902541e-11,
 -1.619125544772159e-13,  4.642035021235518e-16, -1.030462553002840e-18, -5.639287947816787e-22,  6.843385849878839e-24, -2.042220948653307e-25, -8.127781107737959e-28,
  1.190634700424009e-01, -8.195761141703745e-04,  4.072449246706698e-06, -1.697292235085163e-08,  6.034421419962065e-11, -1.758967060711136e-13,  3.214368696507208e-16,
  2.827072813524825e-19, -8.564454373742632e-21,  3.688231101768554e-23, -3.710434839661593e-25, -1.266010580946302e-27,  1.666341916202345e-01, -1.135814813813067e-03,
  5.492419987259771e-06, -2.158972039644004e-08,  6.773686728998243e-11, -1.418580101036909e-13, -9.267889141013896e-17,  2.717624095995765e-18, -1.956259006600699e-20,
  6.299366698873937e-23, -4.522404253080051e-25, -2.645795251095177e-27,  2.223711973760379e-01, -1.497576551440810e-03,  6.997397973409499e-06, -2.540890817616582e-08,
  6.508032838639764e-11, -4.141172530531893e-14, -8.064811346981171e-16,  5.895925001052898e-18, -2.890328627176416e-20,  5.265667899827538e-23, -2.897977321718704e-25,
 -5.459282783003263e-27,  2.863770396417726e-01, -1.900661131908034e-03,  8.505678600501262e-06, -2.767153969852564e-08,  4.803601348553211e-11,  1.370072718540023e-13,
 -1.757237291958352e-15,  8.735598758818169e-18, -2.836944524656319e-20, -3.461477188970908e-23,  2.129891769007209e-25, -9.299712764184675e-27,  3.587611756085683e-01,
 -2.339513260189756e-03,  9.914840068032712e-06, -2.750367819708564e-08,  1.267121631242166e-11,  3.912066303853805e-13, -2.742876754602591e-15,  9.324796996050987e-18,
 -7.639741014638710e-21, -2.232569553810488e-22,  8.962929199528064e-25, -1.187345408529049e-26,  4.396337442813650e-01, -2.806785302446426e-03,  1.109766536850430e-05,
 -2.394071434605748e-08, -4.364926948018365e-11,  6.957026302955767e-13, -3.376004344886960e-15,  5.064455120935001e-18,  4.098539398584311e-20, -4.764206287988900e-22,
  1.106738511686727e-24, -8.809736811867132e-27,  5.290955918643159e-01, -3.292735102606174e-03,  1.189763056947849e-05, -1.598567088202980e-08, -1.208365031304630e-10,
  9.896106964838669e-13, -3.064352488118555e-15, -6.602073103749411e-18,  1.128356048350005e-19, -6.352663310497762e-22, -3.715652076548066e-25,  3.657915260470404e-27,
  6.272222763397503e-01, -3.784395562332643e-03,  1.212461063161205e-05, -2.729876346864501e-09, -2.138793370978730e-10,  1.163588281470064e-12, -1.071460746863746e-15,
 -2.638052137800176e-17,  1.755778794039042e-19, -3.821978136101006e-22, -4.709426213259053e-24,  2.035647032558139e-26,  7.340383114082751e-01, -4.264431447584648e-03,
  1.155242617390487e-05,  1.641553328029472e-08, -3.096455848179222e-10,  1.051652242209386e-12,  3.236768600314577e-15, -4.969668447330057e-17,  1.537007794861005e-19,
  6.569434839318349e-22, -1.094017437466452e-23,  1.391858896366391e-26,  8.494753964893251e-01, -4.709579805023873e-03,  9.921927649389638e-06,  4.129813853107889e-08,
 -3.826972347021745e-10,  4.433597928479583e-13,  9.783474425589521e-15, -6.175658874955987e-17, -6.501642857925414e-20,  2.444096335995745e-21, -1.215227455002005e-23,
 -6.535143127113147e-26,  9.733040397606743e-01, -5.088574391222223e-03,  6.957619197193075e-06,  7.029537994337799e-08, -3.910996465760997e-10, -8.485944067847049e-13,
  1.661017861477646e-14, -3.417618811427266e-17, -5.440601672250595e-19,  3.487028344760704e-21,  6.013618953438877e-24, -2.187372775420953e-25,  1.105020474292976e+00,
 -5.359545339721120e-03,  2.414438624885607e-06,  9.914497183935029e-08, -2.760638051608163e-10, -2.799328214870221e-12,  1.825531306817739e-14,  6.522483324786801e-17,
 -1.045607765191662e-18, -8.425353955725892e-23,  4.853873241724996e-23, -1.981373642024160e-25,  1.243657991226624e+00, -5.467241728767785e-03, -3.812736447503987e-06,
  1.193330678613296e-07,  2.368384881903112e-11, -4.779905244068082e-12,  5.314934545029473e-15,  2.228067874579347e-16, -6.641135905522728e-19, -1.124973769874172e-20,
  5.371312376363830e-23,  5.035537439894933e-25,  1.387471316424775e+00, -5.341516679645658e-03, -1.146020199361975e-05,  1.167266823822768e-07,  5.186853934783796e-10,
 -5.032827547621896e-12, -2.892395661751322e-14,  2.707604457062451e-16,  1.757416330980827e-18, -1.694664230622492e-20, -1.207258925132979e-22,  1.061450621489424e-24,
  1.533415305148265e+00, -4.901452800536976e-03, -1.947815300030619e-05,  7.340133753078053e-08,  1.045249925642872e-09, -8.774811129403205e-13, -6.457877506805217e-14,
 -1.240567339645387e-16,  4.067359760868238e-18,  1.971851124741972e-20, -2.554837321289664e-22, -2.291490769215803e-24,  1.676325667880864e+00, -4.076278894319225e-03,
 -2.546637228644405e-05, -1.941940472828355e-08,  1.120767640707150e-09,  7.684212789575374e-12, -3.078129176154224e-14, -7.562278258366738e-16, -2.199305806892781e-18,
  4.868959874470527e-20,  4.858540085406455e-22, -1.350353687390299e-24,  1.807804859027279e+00, -2.865057266806562e-03, -2.559349386527971e-05, -1.280428941371668e-07,
  2.010375734254253e-10,  1.043878200850313e-11,  8.677114849547154e-14,  1.979183704798481e-18, -7.675171404304501e-18, -8.015069862551082e-20, -1.073655208240586e-22,
  6.757115776680278e-24,  1.915300568415164e+00, -1.453708395295226e-03, -1.704033624511525e-05, -1.539355041474415e-07, -1.006333074785173e-09, -2.685480788799868e-12,
  4.303151337379504e-14,  8.461013480218670e-16,  8.302330400555982e-18,  4.019618192152191e-20, -2.413856477804422e-22, -7.931871802920432e-24,  1.983093258343618e+00,
 -3.178305402026450e-04, -4.401682352721224e-06, -5.291183942475663e-08, -5.781506635611270e-10, -5.824443339989678e-12, -5.400880635113995e-14, -4.530591307083793e-16,
 -3.278317420279316e-18, -1.754791300895448e-20, -1.117344118816347e-23,  1.469188534853464e-24,  9.519120391513922e-04, -6.610278159229856e-06,  3.440490518022343e-08,
 -1.592358595547354e-10,  6.893617763310428e-13, -2.876191365795420e-15,  1.151763610367573e-17, -4.676208190758328e-20,  1.667342304458566e-22, -8.408123623205810e-25,
  4.419898408296141e-28, -3.769529012389984e-29,  8.570524586244502e-03, -5.943655688867523e-05,  3.082728499841106e-07, -1.417471313623227e-09,  6.072101486209959e-12,
 -2.494819666353166e-14,  9.772893823500866e-17, -3.864093193813526e-19,  1.312242692000405e-21, -6.595657851460842e-24, -9.290611569468646e-28, -3.166457276632391e-28,
  2.382543243937601e-02, -1.647863798392975e-04,  8.486260888141835e-07, -3.850012166882396e-09,  1.613322566126174e-11, -6.414115280193699e-14,  2.392406260813869e-16,
 -8.892560549074731e-19,  2.660149654006069e-21, -1.338261552940081e-23, -2.671513517892953e-26, -7.738341908509943e-28,  4.675197685769002e-02, -3.220329797670316e-04,
  1.640363541486565e-06, -7.286825258720647e-09,  2.946714031451932e-11, -1.108005056582688e-13,  3.777598883491168e-16, -1.237812056772472e-18,  2.618193406334693e-21,
 -1.390758953055618e-23, -1.087246461488713e-25, -1.295958301402261e-27,  7.740308083460465e-02, -5.301810611704433e-04,  2.659974548897415e-06, -1.146750730647632e-08,
  4.397742433644694e-11, -1.511197757791372e-13,  4.351232189176311e-16, -1.046229960937500e-18, -4.758337279789758e-22, -2.332698307443777e-24, -2.625016485059561e-25,
 -1.899079821419225e-27,  1.158490576546934e-01, -7.877950714719292e-04,  3.874452495027707e-06, -1.603513709406477e-08,  5.690391087771243e-11, -1.681170793198862e-13,
  3.256942326584016e-16,  2.689107902051121e-20, -7.521039904912322e-21,  2.050340918930890e-23, -4.594734264568143e-25, -2.853131588111359e-27,  1.621771959918634e-01,
 -1.092893552352099e-03,  5.239752131683204e-06, -2.052872403001226e-08,  6.488327055731430e-11, -1.432379557183269e-13, -2.503489383211797e-17,  2.124156032670240e-18,
 -1.765320988884377e-20,  4.204381822064733e-23, -6.100873083719373e-25, -4.680161032979506e-27,  2.164909433604089e-01, -1.442799362903896e-03,  6.698708197391092e-06,
 -2.437524617900807e-08,  6.407137732342724e-11, -5.888909670775539e-14, -6.540777724205673e-16,  4.998607576660419e-18, -2.727968965139742e-20,  3.563799358446313e-23,
 -5.788979972965561e-25, -7.894659831860145e-27,  2.789084016368644e-01, -1.833930677444812e-03,  8.178314806398857e-06, -2.688325245372276e-08,  5.037369940415384e-11,
  9.766504084735562e-14, -1.525530504339225e-15,  7.808637278293121e-18, -2.956782736214175e-20, -3.506986445822665e-23, -2.582759541949707e-25, -1.238992428782911e-26,
  3.495596753503425e-01, -2.261510697793306e-03,  9.586259218055438e-06, -2.724183420434467e-08,  1.985803366870207e-11,  3.284758891107996e-13, -2.486370248007217e-15,
  8.957554479678314e-18, -1.516871660825656e-20, -1.991040720595945e-22,  2.771639809758726e-25, -1.656441837877697e-26,  4.285823308203289e-01, -2.719163977272313e-03,
  1.080663150769321e-05, -2.453214186672095e-08, -3.053327200231389e-11,  6.165128227853493e-13, -3.218360645303222e-15,  6.109225300179240e-18,  2.451775783865015e-20,
 -4.421185648222262e-22,  5.502033392310999e-25, -1.679199430155701e-26,  5.161137541809296e-01, -3.198352759817641e-03,  1.169484225917364e-05, -1.776476891902062e-08,
 -1.017926886589418e-10,  9.142347237249154e-13, -3.202117879675239e-15, -3.360006606008287e-18,  8.970576232146220e-20, -6.504070113191559e-22, -4.765070139658661e-25,
 -8.833238826990749e-27,  6.122784005791883e-01, -3.687586128148375e-03,  1.207208248241015e-05, -5.967408695639024e-09, -1.909213304262385e-10,  1.129630284027147e-12,
 -1.733775057170696e-15, -2.101700324339155e-17,  1.586094317822816e-19, -5.565126485182052e-22, -4.110845023470958e-24,  6.024736806098607e-27,  7.171665552525831e-01,
 -4.171306692569084e-03,  1.172039309162830e-05,  1.163322616538132e-08, -2.879454734016791e-10,  1.113211246648355e-12,  1.917079364995556e-15, -4.448316249594989e-17,
  1.696141472170679e-19,  2.306430997121158e-22, -1.041629873906826e-23,  8.250557591676047e-27,  8.307988208037371e-01, -4.628325412967150e-03,  1.038109870569975e-05,
  3.525808684811094e-08, -3.716229516000077e-10,  6.572556792283875e-13,  8.037690271635787e-15, -6.252841745434803e-17,  1.357882896972811e-20,  1.905874206471774e-21,
 -1.464613344117920e-23, -4.990281809684275e-26,  9.530662548440980e-01, -5.029646789407185e-03,  7.763127308600944e-06,  6.392331091239979e-08, -4.041722740663862e-10,
 -4.632834508876319e-13,  1.542860114621879e-14, -4.954977879885191e-17, -4.164848103676859e-19,  3.538696131004170e-21, -3.329667596807586e-24, -2.050481280264713e-25,
  1.083628347549845e+00, -5.335550058941843e-03,  3.575907248541125e-06,  9.430441638004136e-08, -3.275406692866281e-10, -2.343055939191145e-12,  1.961528327404882e-14,
  3.207256540111015e-17, -1.016088915866549e-18,  1.651007083584638e-21,  3.749257546534251e-23, -2.985428435659936e-25,  1.221737089426552e+00, -5.492016401172362e-03,
 -2.381592589364278e-06,  1.189562285552242e-07, -7.014728767744143e-11, -4.580243560128548e-12,  1.119830465014530e-14,  1.955290406256632e-16, -1.025744977450259e-18,
 -8.730721806281429e-21,  7.034200654275108e-23,  2.440141704741406e-25,  1.365930946499009e+00, -5.427462214119344e-03, -1.001312454636678e-05,  1.241853638730471e-07,
  4.117315143582569e-10, -5.630266842670524e-12, -2.065314376544736e-14,  3.164016118001219e-16,  1.072527472563783e-18, -2.075072320694723e-20, -6.765234108564163e-23,
  1.311226919402437e-24,  1.513503820922240e+00, -5.053472338002604e-03, -1.849784744847371e-05,  8.989981989692393e-08,  1.011998559012492e-09, -2.453766459379273e-12,
 -6.613861283600241e-14,  1.529971180614834e-17,  4.570939971931536e-18,  7.704925742790309e-21, -3.388355966462033e-22, -1.420798362651481e-24,  1.659612059873501e+00,
 -4.280625772262534e-03, -2.558688985696756e-05, -3.051075721960708e-10,  1.265315510577942e-09,  6.685166520765632e-12, -5.265161299840847e-14, -7.949726809014788e-16,
 -1.181453197307653e-19,  6.614379178363108e-20,  3.666776664930290e-22, -4.110108646087058e-24,  1.795925501839585e+00, -3.075879994407235e-03, -2.710345409580247e-05,
 -1.230434530498768e-07,  4.304879729234684e-10,  1.249152109262132e-11,  8.295211879658162e-14, -2.899698298130212e-16, -1.055549973245892e-17, -7.731801034321527e-20,
  2.781608687682234e-22,  1.073892647492645e-23,  1.909200999052810e+00, -1.597697387178466e-03, -1.898573757749443e-05, -1.704017858504612e-07, -1.047635643301762e-09,
 -1.337161212073779e-12,  7.064167389478426e-14,  1.132296075636106e-15,  9.478169098691156e-18,  2.207687437740386e-20, -7.039525640758111e-22, -1.332904635929385e-23,
  1.981747253679777e+00, -3.557503573193705e-04, -5.096211470030223e-06, -6.316912233448280e-08, -7.086929239373791e-10, -7.285320142031281e-12, -6.825787072609841e-14,
 -5.680059605205495e-16, -3.898348049948882e-18, -1.622907772461914e-20,  9.093448462302746e-23,  3.378235821915097e-24,  9.260095621433371e-04, -6.342499009044347e-06,
  3.255840276924396e-08, -1.486516774400971e-10,  6.344991226951586e-13, -2.614905179158547e-15,  1.027844868727587e-17, -4.191095505984563e-20,  1.363485381233839e-22,
 -8.601708273669303e-25, -1.507931702675254e-27, -5.099085728252849e-29,  8.337605279181592e-03, -5.703679821147769e-05,  2.918300531086260e-07, -1.324185558839911e-09,
  5.595739710731575e-12, -2.272801097626984e-14,  8.746144680367946e-17, -3.482532287355054e-19,  1.070443319167766e-21, -6.947833541463413e-24, -1.759884463507698e-26,
 -4.413803585946866e-28,  2.317957840563769e-02, -1.581778789844672e-04,  8.039333871392894e-07, -3.601839469420289e-09,  1.490585131408120e-11, -5.868900300897640e-14,
  2.154588893160036e-16, -8.121189064561794e-19,  2.149955023355687e-21, -1.524037418055547e-23, -6.889549430535747e-26, -1.143600034969358e-27,  4.548954805386460e-02,
 -3.092519892596127e-04,  1.555678919374639e-06, -6.832598115583619e-09,  2.733903206356676e-11, -1.021412014409833e-13,  3.441921374917972e-16, -1.163004962427493e-18,
  2.023444937620411e-21, -1.962331423560905e-23, -1.827397098423915e-25, -2.067568522412147e-27,  7.532406124122004e-02, -5.094399693358311e-04,  2.526488365571737e-06,
 -1.078749027334536e-08,  4.105707604406178e-11, -1.410302269245992e-13,  4.055874742304180e-16, -1.065013280966917e-18, -7.724692959980534e-22, -1.489219237274969e-23,
 -3.752115120904769e-25, -3.222808162503615e-27,  1.127586714559771e-01, -7.575539130078328e-04,  3.687384043341364e-06, -1.515114877328183e-08,  5.361965875382929e-11,
 -1.603180299146173e-13,  3.231618422864721e-16, -2.057991142088565e-19, -7.149215461852896e-21, -9.628077504565954e-25, -6.283433565155877e-25, -4.824492108971180e-27,
  1.578879222615124e-01, -1.051943483640482e-03,  4.999541647022899e-06, -1.951352332982060e-08,  6.201699603805176e-11, -1.431876913990516e-13,  2.672424395101565e-17,
  1.578312526608244e-18, -1.663545882712090e-20,  1.275523236428594e-23, -8.737448819238661e-25, -7.315240883447436e-27,  2.108250971999363e-01, -1.390362376550408e-03,
  6.412314591618971e-06, -2.336033348921214e-08,  6.274744815443968e-11, -7.300506663332360e-14, -5.261812623455127e-16,  4.140980024426321e-18, -2.650587901023826e-20,
  4.578945063808725e-24, -9.983943001945711e-25, -1.119730572721092e-26,  2.717015083601825e-01, -1.769780717577395e-03,  7.860609865636378e-06, -2.606356374969360e-08,
  5.197802502703712e-11,  6.356782804090200e-14, -1.320345587036827e-15,  6.839134779745233e-18, -3.115863547808212e-20, -5.751613229200786e-23, -8.948868531911079e-25,
 -1.657462734261005e-26,  3.406649505849859e-01, -2.186122352067622e-03,  9.261470100938606e-06, -2.687470754544782e-08,  2.585082690671629e-11,  2.717513077256203e-13,
 -2.243425357510285e-15,  8.358084297379486e-18, -2.232804593624745e-20, -2.043044513958172e-22, -5.802154526519439e-25, -2.240875858965288e-26,  4.178767060493088e-01,
 -2.633895862942242e-03,  1.050970807763226e-05, -2.492616934169628e-08, -1.896117016909209e-11,  5.413989297199622e-13, -3.038689996896686e-15,  6.641776129598892e-18,
  8.795258015550505e-21, -4.375637291076404e-22, -3.889184233918820e-25, -2.583679128265776e-26,  5.035060732047624e-01, -3.105673055891315e-03,  1.147248272924639e-05,
 -1.925137637339128e-08, -8.428253891085426e-11,  8.365575184423461e-13, -3.259561716512954e-15, -8.687401160657781e-19,  6.581708552298603e-20, -6.813408960372937e-22,
 -1.171877334869355e-24, -2.269369171873822e-26,  5.977206847935754e-01, -3.591346133111168e-03,  1.198288284046865e-05, -8.843859991213925e-09, -1.687896158919105e-10,
  1.081511862060867e-12, -2.254430717244295e-15, -1.629357418691570e-17,  1.356325665361503e-19, -7.207799857669034e-22, -4.232503025371232e-24, -1.168812239543274e-26,
  7.006696305747242e-01, -4.077061767883674e-03,  1.183309072695693e-05,  7.206299886763618e-09, -2.653188453525347e-10,  1.144892944510204e-12,  7.482159807638400e-16,
 -3.900257171631317e-17,  1.704727591715964e-19, -1.823842735119575e-22, -1.033528155156735e-23, -5.340072772602886e-27,  8.124541550418695e-01, -4.543684252420791e-03,
  1.076898606180307e-05,  2.942716806354124e-08, -3.566900990714068e-10,  8.292590493731513e-13,  6.302462179871168e-15, -6.111333799834221e-17,  7.113583640724398e-20,
  1.278167769075148e-21, -1.670439799686018e-23, -4.495722984997698e-26,  9.330765799261367e-01, -4.964583962799628e-03,  8.491164553724549e-06,  5.740205075739436e-08,
 -4.098547462066855e-10, -1.110353976360471e-13,  1.387348950036385e-14, -6.088206848212262e-17, -2.936194701464408e-19,  3.229936448819433e-21, -1.198214130958658e-23,
 -1.876217892265336e-25,  1.062350398705465e+00, -5.302508674043521e-03,  4.674653455760834e-06,  8.871469507842951e-08, -3.696400995635302e-10, -1.865122330621785e-12,
  2.006895052451291e-14,  7.710849379653181e-19, -9.330282001256369e-19,  2.866066474085542e-21,  2.278607269084264e-23, -3.634763907325150e-25,  1.199739923028875e+00,
 -5.505385181118922e-03, -9.638227276934919e-07,  1.171174267524642e-07, -1.586414353010768e-10, -4.249766160678099e-12,  1.617030207340117e-14,  1.582353456945090e-16,
 -1.287578781178133e-18, -5.786051174686616e-21,  7.481350580815728e-23, -4.031585575285878e-26,  1.344070472357415e+00, -5.501503039824933e-03, -8.487168790921781e-06,
  1.298483666253857e-07,  2.949040772457070e-10, -6.016459193715213e-12, -1.142877187999705e-14,  3.383620404168384e-16,  2.908859091455012e-19, -2.228579614499107e-20,
 -9.147049990259169e-24,  1.305358935072354e-24,  1.493001181383962e+00, -5.196868950739228e-03, -1.732379548431817e-05,  1.056133948193798e-07,  9.471708225335581e-10,
 -4.019263828565703e-12, -6.363999980066105e-14,  1.632899317875476e-16,  4.592386329530043e-18, -6.754652118107046e-21, -3.751442444496264e-22, -1.894825826576165e-25,
  1.642080642029163e+00, -4.484981692578248e-03, -2.546491168330304e-05,  2.093336280644194e-08,  1.384586922233895e-09,  5.156281516955380e-12, -7.458791618012745e-14,
 -7.582266766571479e-16,  2.476002832719032e-18,  7.638119683356193e-20,  1.259076850923364e-22, -6.743153205681774e-24,  1.783179166499488e+00, -3.298476946914795e-03,
 -2.853006315910419e-05, -1.140523117512432e-07,  6.993614334059648e-10,  1.434430232254290e-11,  6.970662880661867e-14, -6.691465947153840e-16, -1.301537441954601e-17,
 -5.572909844203020e-20,  8.232264772511869e-22,  1.371822068305462e-23,  1.902493083017523e+00, -1.758048908375626e-03, -2.113168521155868e-05, -1.872743818652752e-07,
 -1.054677378967556e-09,  7.734731581555548e-13,  1.066657385172431e-13,  1.441622893634842e-15,  9.608087319226135e-18, -1.964784985558670e-20, -1.428421087992164e-21,
 -1.963014731875992e-23,  1.980237624513384e+00, -3.997566112936451e-04, -5.927387491237234e-06, -7.576853623536299e-08, -8.721444791552584e-10, -9.128962090162926e-12,
 -8.598939161995996e-14, -7.010569631027344e-16, -4.373327693948447e-18, -8.714903700845784e-21,  3.108930759691317e-22,  6.983462752965089e-24,  9.011494415386930e-04,
 -6.088998373169144e-06,  3.083381106484643e-08, -1.389050637019581e-10,  5.845752175374741e-13, -2.381840596483481e-15,  9.161261476566597e-18, -3.805947954821755e-20,
  1.037282646768617e-22, -9.681912663219009e-25, -3.932665954378338e-27, -5.588980369009718e-29,  8.114028833213707e-03, -5.476423047402244e-05,  2.764623774669911e-07,
 -1.238179404244906e-09,  5.161399403011142e-12, -2.074231555979839e-14,  7.815111569544250e-17, -3.181766279321847e-19,  8.027088031348440e-22, -8.066939154280669e-24,
 -3.874149990706094e-26, -4.894266998404776e-28,  2.255946169258174e-02, -1.519153332100836e-04,  7.621044297860399e-07, -3.372462728688365e-09,  1.378197745134222e-11,
 -5.378361589094215e-14,  1.935958701174840e-16, -7.527344069064348e-19,  1.538791481627867e-21, -1.908265589917065e-23, -1.244220639036148e-25, -1.295379835158921e-27,
  4.427692197918350e-02, -2.971272387905370e-04,  1.476246299785866e-06, -6.411078317310901e-09,  2.537621129816891e-11, -9.426475083843971e-14,  3.124171559163164e-16,
 -1.111157588351660e-18,  1.161871737290561e-21, -2.892135240703629e-23, -2.847962497671038e-25, -2.402647890550728e-27,  7.332592081602450e-02, -4.897349054000679e-04,
  2.400888567003439e-06, -1.015262320347983e-08,  3.833138011086609e-11, -1.316573714250674e-13,  3.753180849497967e-16, -1.101503426568166e-18, -1.615742727783808e-21,
 -3.302926028148129e-23, -5.362944828220497e-25, -3.817180959815400e-27,  1.097863227334388e-01, -7.287677522122395e-04,  3.510613293960864e-06, -1.431846614146951e-08,
  5.049025583849948e-11, -1.526573620510113e-13,  3.141542745036108e-16, -4.404233884289615e-19, -7.691674937561528e-21, -3.077990302921161e-23, -8.694606987789865e-25,
 -5.711247834412718e-27,  1.537586814934791e-01, -1.012867148309878e-03,  4.771238646148244e-06, -1.854411262918513e-08,  5.916292562777065e-11, -1.420759835518668e-13,
  6.348140938504954e-17,  1.045911410143320e-18, -1.688860070387440e-20, -2.921622166358431e-23, -1.233848951665377e-24, -8.457971462262815e-27,  2.053644932851882e-01,
 -1.340168203755835e-03,  6.137964042400189e-06, -2.236870357295532e-08,  6.116995928280383e-11, -8.433804093646132e-14, -4.221444497186931e-16,  3.286709912388379e-18,
 -2.718567407927230e-20, -4.593507122495583e-23, -1.537954235885281e-24, -1.252891882814132e-26,  2.647461944901232e-01, -1.708132665937432e-03,  7.552873541630369e-06,
 -2.522340317312763e-08,  5.294741837656838e-11,  3.406261691776508e-14, -1.143177980030948e-15,  5.800533741648606e-18, -3.405812591997419e-20, -1.088012150316550e-22,
 -1.682168250854784e-24, -1.816109152328033e-26,  3.320666126683965e-01, -2.113313151352859e-03,  8.941625383130552e-06, -2.642046150497653e-08,  3.076594026348670e-11,
  2.206296717689150e-13, -2.020551183683313e-15,  7.519415932046231e-18, -3.035064525696101e-20, -2.484923218308372e-22, -1.647810801800112e-24, -2.474819744171395e-26,
  4.075073773097419e-01, -2.551019014389691e-03,  1.020911843479624e-05, -2.514682307341864e-08, -8.847311600310565e-12,  4.707190902068597e-13, -2.851183025844071e-15,
  6.665830698986978e-18, -7.530328825532488e-21, -4.778620444759338e-22, -1.659256207817063e-24, -3.012809716801865e-26,  4.912654468774104e-01, -3.014838941046118e-03,
  1.123391343567293e-05, -2.047030254393857e-08, -6.833452118753949e-11,  7.582510952792233e-13, -3.258164652077847e-15,  8.337464886911447e-19,  4.017358985962069e-20,
 -7.514278985117010e-22, -2.392046611209451e-24, -3.052923166690554e-26,  5.835462915803993e-01, -3.495951862379392e-03,  1.186125658928107e-05, -1.137453833507864e-08,
 -1.477349672404562e-10,  1.022396156819804e-12, -2.654028454223625e-15, -1.240246440209173e-17,  1.064710865941190e-19, -9.048210479248440e-22, -5.056112193498828e-24,
 -2.314189265583483e-26,  6.845511610513315e-01, -3.982121561621960e-03,  1.189485351818812e-05,  3.144996585853231e-09, -2.423267228485612e-10,  1.150352757988023e-12,
 -2.690440329592159e-16, -3.373299020489500e-17,  1.563723453199797e-19, -6.043558927048806e-22, -1.083576515527153e-23, -1.475236314928873e-26,  7.944538230305475e-01,
 -4.456215568565963e-03,  1.108844218418337e-05,  2.386044966429590e-08, -3.387294395014801e-10,  9.602790987118232e-13,  4.629133410990197e-15, -5.823354711652036e-17,
  1.046537376539316e-19,  5.714152135560433e-22, -1.858753377453248e-23, -3.804637592717311e-26,  9.133583078013804e-01, -4.894010882612484e-03,  9.140626798718554e-06,
  5.084410282613569e-08, -4.088889417584488e-10,  2.005139880637058e-13,  1.205397936237909e-14, -6.852570318625610e-17, -1.878969226858967e-19,  2.592576739515405e-21,
 -1.967213147333798e-23, -1.575983638590926e-25,  1.041221755315838e+00, -5.260956348308213e-03,  5.702598014367899e-06,  8.252815174211313e-08, -4.021412607245555e-10,
 -1.386481424136140e-12,  1.968912524009553e-14, -2.729095518366191e-17, -8.173874067335113e-19,  3.448684490183108e-21,  6.234706863327912e-24, -3.778097830579337e-25,
  1.177711792811621e+00, -5.507523592445841e-03,  4.236241826372624e-07,  1.139217076482110e-07, -2.394218125928897e-10, -3.813339711858101e-12,  1.999681657544156e-14,
  1.142694077212418e-16, -1.443154671692103e-18, -2.906725193226371e-21,  6.735830893830668e-23, -2.850749602049115e-25,  1.321938635057090e+00, -5.563096680451617e-03,
 -6.904687911901390e-06,  1.335925259054530e-07,  1.726016831444995e-10, -6.176749340612565e-12, -1.944795777906212e-15,  3.348724868555869e-16, -5.046220528152964e-19,
 -2.155799091588800e-20,  4.383407384864999e-23,  1.073840688424491e-24,  1.471944906461926e+00, -5.330138880719780e-03, -1.596842291863851e-05,  1.200439085956876e-07,
  8.519667795049674e-10, -5.475480535122991e-12, -5.706767509732999e-14,  3.034668310200771e-16,  4.080703825526278e-18, -2.153178111009220e-20, -3.539284107151676e-22,
  1.150045916138527e-24,  1.623735408783271e+00, -4.687312406416832e-03, -2.507772216240226e-05,  4.380747148414809e-08,  1.468148926037726e-09,  3.122921027570568e-12,
 -9.429225217093075e-14, -6.346439040270672e-16,  5.239424174597641e-18,  7.490407678041917e-20, -2.115538732610953e-22, -8.346829033806314e-24,  1.769520407727530e+00,
 -3.531979378088248e-03, -2.982181001319718e-05, -1.004837812799904e-07,  1.001209271513075e-09,  1.574376769141461e-11,  4.489029408243439e-14, -1.110180546358794e-15,
 -1.428038508506729e-17, -1.044686469531865e-20,  1.440815359171859e-21,  1.367505922713209e-23,  1.895108145345927e+00, -1.936376282659741e-03, -2.347922679649027e-05,
 -2.038720353719635e-07, -1.010163331619863e-09,  3.851487418974017e-12,  1.511403476458144e-13,  1.724943585094323e-15,  7.648496147235583e-18, -9.574338270099390e-20,
 -2.413149305715116e-21, -2.460625981464387e-23,  1.978537647302210e+00, -4.510644630859306e-04, -6.926743057180790e-06, -9.130257331742277e-08, -1.077033765668622e-09,
 -1.144426408117605e-11, -1.076043524644788e-13, -8.429278256217994e-16, -4.374546484347630e-18,  1.152044447057241e-20,  7.481460970629349e-22,  1.350270934805791e-23,
  8.772764520374942e-04, -5.848839867805300e-06,  2.922153522899945e-08, -1.299213644339498e-10,  5.390525869470733e-13, -2.174416630400376e-15,  8.136583504741276e-18,
 -3.533272605730239e-20,  6.549935230259986e-23, -1.168298769142608e-24, -5.795244758401385e-27, -1.656913234943564e-29,  7.899303148948067e-03, -5.261059104611454e-05,
  2.620863509823578e-07, -1.158816855601402e-09,  4.764601555130987e-12, -1.897097356715041e-14,  6.955576104541161e-17, -2.974750838797472e-19,  4.796589005593277e-22,
 -9.990666371210129e-24, -5.496365091728265e-26, -1.377041853825003e-28,  2.196374290997070e-02, -1.459767074310575e-04,  7.229232480819736e-07, -3.160311093406286e-09,
  1.275108687037538e-11, -4.938534125260622e-14,  1.730979481316361e-16, -7.155496527990154e-19,  7.496936138024332e-22, -2.504580888157557e-23, -1.669118702335801e-25,
 -3.276154566572320e-28,  4.311155528169478e-02, -2.856182385098871e-04,  1.401688552427279e-06, -6.019744420468042e-09,  2.356339362187035e-11, -8.713693226972876e-14,
  2.816519273673974e-16, -1.093028409496685e-18, -1.075458632843782e-22, -4.213314276499962e-23, -3.625294289238649e-25, -5.205052213685467e-28,  7.140463827148276e-02,
 -4.710048936344689e-04,  2.282651563591671e-06, -9.559907493363639e-09,  3.578577539137762e-11, -1.230269395577911e-13,  3.435420597992293e-16, -1.176678984113873e-18,
 -3.227682803934362e-21, -5.735814714602971e-23, -6.582256726952151e-25, -7.049256919114141e-28,  1.069263524195241e-01, -7.013566282863319e-04,  3.343539325258009e-06,
 -1.353464227758951e-08,  4.751135774459802e-11, -1.452947303031342e-13,  2.981594155600692e-16, -7.114569428447072e-19, -9.480680014784925e-21, -6.985357828676528e-23,
 -1.051019455089099e-24, -9.975733988514457e-28,  1.497821658005936e-01, -9.755714796038853e-04,  4.554295457981803e-06, -1.762014635430708e-08,  5.633869258768235e-11,
 -1.402634023203600e-13,  8.497081011869215e-17,  4.784429056070095e-19, -1.891018866625616e-20, -8.494977329207874e-23, -1.505085507532476e-24, -1.682503223685586e-27,
  2.001003511892983e-01, -1.292121682581362e-03,  5.875354550555600e-06, -2.140399929039613e-08,  5.938882189548674e-11, -9.346545465129594e-14, -3.426349345931598e-16,
  2.377427589931006e-18, -3.006781383094729e-20, -1.169806898226048e-22, -1.948222158783313e-24, -3.152868667872034e-27,  2.580326132125919e-01, -1.648905956903745e-03,
  7.255293453699159e-06, -2.437223221029080e-08,  5.336680996269400e-11,  8.448049913647879e-15, -9.967111199188439e-16,  4.633548572604292e-18, -3.936289299694764e-20,
 -1.900533400876125e-22, -2.292364096573996e-24, -5.673533160445083e-27,  3.237544303491637e-01, -2.043039643518315e-03,  8.627670646712384e-06, -2.589547101240243e-08,
  3.471005136003450e-11,  1.745444476627300e-13, -1.825051969532812e-15,  6.390329134550201e-18, -4.072549223908306e-20, -3.336562766638282e-22, -2.498633588727350e-24,
 -8.896811608944340e-27,  3.974647335044928e-01, -2.470554829237465e-03,  9.906806018962014e-06, -2.521672018700315e-08, -1.023056674373871e-13,  4.044867712514823e-13,
 -2.670605318484740e-15,  6.134335934664661e-18, -2.622566741360852e-20, -5.678886476410707e-22, -2.708799888454370e-24, -1.118860683095542e-26,  4.793842532295706e-01,
 -2.925967670085226e-03,  1.098219640161333e-05, -2.144657313069703e-08, -5.394892577538979e-11,  6.804548310794665e-13, -3.221035084480301e-15,  1.665500844055655e-18,
  1.109704090149509e-20, -8.711107348613744e-22, -3.442821873743549e-24, -9.233413969139287e-27,  5.697513450610446e-01, -3.401646440418528e-03,  1.171124283644408e-05,
 -1.357828682335548e-08, -1.279502829493655e-10,  9.548857038723585e-13, -2.958784708703223e-15, -9.557489514460996e-18,  7.003114717603085e-20, -1.124598447460077e-21,
 -5.766957468631309e-24,  6.180586078015004e-28,  6.688131407279534e-01, -3.886875941806122e-03,  1.191008735460822e-05, -5.488366240247975e-10, -2.194579186871235e-10,
  1.133103735919448e-12, -1.147386739025426e-15, -2.916193615943138e-17,  1.266877380448514e-19, -1.046611667701831e-21, -1.106158620364679e-23,  1.606154811753227e-26,
  7.768080611237795e-01, -4.366453367797915e-03,  1.134290139367451e-05,  1.859991229548313e-08, -3.185429216878391e-10,  1.052204061020843e-12,  3.047531697748574e-15,
 -5.470178121516731e-17,  1.115166369020515e-19, -1.960182299788125e-22, -1.941855922086769e-23,  1.365572103921557e-26,  8.939322219646374e-01, -4.818556165461442e-03,
  9.711684139845475e-06,  4.434901684524924e-08, -4.021442895092052e-10,  4.661859133396676e-13,  1.006395649326259e-14, -7.320948156432071e-17, -1.102358067322745e-19,
  1.686134548254122e-21, -2.501490131192472e-23, -6.862950402078667e-26,  1.020275286637913e+00, -5.211485537478773e-03,  6.653497528695451e-06,  7.589741765585658e-08,
 -4.252221798604654e-10, -9.259522067857240e-13,  1.857761156856595e-14, -5.144453065556007e-17, -6.926253422394589e-19,  3.381395505858399e-21, -8.955692672270070e-24,
 -2.873973824549632e-25,  1.155697035118166e+00, -5.498737101598231e-03,  1.765270586772717e-06,  1.095078930396008e-07, -3.106575222258128e-10, -3.300318802027188e-12,
  2.253764603991573e-14,  6.690672026473750e-17, -1.502752849247336e-18, -5.078711626893283e-22,  5.184883259388242e-23, -3.830563381091738e-25,  1.299585980259850e+00,
 -5.611884184318285e-03, -5.289084096930601e-06,  1.353664830374896e-07,  4.934701386614672e-11, -6.113434817316066e-12,  7.091812002232981e-15,  3.067324468589122e-16,
 -1.238607391212390e-18, -1.895245515727525e-20,  8.418299701289654e-23,  7.685718627382761e-25,  1.450378295101487e+00, -5.451901212313513e-03, -1.444995356473238e-05,
  1.327280283029188e-07,  7.295220637551117e-10, -6.729195107188224e-12, -4.687777399265809e-14,  4.190363207013028e-16,  3.066354775425439e-18, -3.430259604732608e-20,
 -2.756399761607865e-22,  2.381825888948451e-24,  1.604588813957273e+00, -4.885428169083604e-03, -2.440944298989688e-05,  6.766889480812796e-08,  1.506646050773325e-09,
  6.680276555235449e-13, -1.093254823147203e-13, -4.261962765564297e-16,  7.694240866256259e-18,  5.902941926658690e-20, -5.797301150208874e-22, -7.999227949607610e-24,
  1.754908120913058e+00, -3.775080496183606e-03, -3.092094991105904e-05, -8.189839142657965e-08,  1.324073599374580e-09,  1.639655455168191e-11,  7.436940297695759e-15,
 -1.560926547950551e-15, -1.348309759473408e-17,  5.815083767633429e-20,  1.952610806936255e-21,  8.658857576053005e-24,  1.886971099842107e+00, -2.134263501048157e-03,
 -2.601944053822107e-05, -2.192044523800806e-07, -8.928209040502391e-10,  8.082189813008816e-12,  2.022018789211011e-13,  1.893769001194398e-15,  2.199283123844910e-18,
 -2.142512001369909e-19, -3.504543314701375e-21, -2.342067766560500e-23,  1.976615184851831e+00, -5.111722321243925e-04, -8.133799509631044e-06, -1.105148139773700e-07,
 -1.333735124125322e-09, -1.432518916957539e-11, -1.330550668462662e-13, -9.691741520857663e-16, -3.252326198805168e-18,  5.622102247464404e-20,  1.568480803188899e-21,
  2.474347092756284e-23,  8.543389658297185e-04, -5.621160426997065e-06,  2.771282624815648e-08, -1.216341522186626e-10,  4.974379530524138e-13, -1.990814040766599e-15,
  7.169969782922383e-18, -3.395397339532519e-20,  1.939080644353624e-23, -1.379679307508987e-24, -3.609560361977540e-27,  1.453766564294935e-28,  7.692967888612757e-03,
 -5.056825573625334e-05,  2.486257157530205e-07, -1.085530690941127e-09,  4.401208291227294e-12, -1.740019998056373e-14,  6.138426318590168e-17, -2.882998860465569e-19,
  8.164739242662098e-23, -1.199521954483135e-23, -3.477543560524858e-26,  1.321314822009319e-27,  2.139116746782808e-02, -1.403416217161495e-04,  6.861917376214920e-07,
 -2.963976412738975e-09,  1.180331099350459e-11, -4.546958335572447e-14,  1.532537466322899e-16, -7.072555989648071e-19, -2.681363295309156e-22, -3.113396523247910e-23,
 -1.082859824798529e-25,  3.735828911480708e-27,  4.199106072058155e-02, -2.746873986933228e-04,  1.331657356001956e-06, -5.656315189124364e-09,  2.188576413010478e-11,
 -8.074643351201165e-14,  2.507511542345643e-16, -1.123489682214413e-18, -1.876189077329780e-21, -5.536770774129430e-23, -2.416521177123325e-25,  7.485312979335962e-27,
  6.955642806778196e-02, -4.531930071015281e-04,  2.171288330280260e-06, -9.006582856761622e-09,  3.340494891250029e-11, -1.151910540048437e-13,  3.088027775496587e-16,
 -1.317991385921001e-18, -5.749501391706925e-21, -8.143374253273859e-23, -4.495705237890110e-25,  1.264877141986846e-26,  1.041734118590984e-01, -6.752452717825125e-04,
  3.185590053111944e-06, -1.279732633308788e-08,  4.467521972710090e-11, -1.384148477429929e-13,  2.735559945105668e-16, -1.063041014521539e-18, -1.272566074181744e-20,
 -1.084200539357836e-22, -7.319170603148304e-25,  1.922992545612326e-26,  1.459514308322813e-01, -9.399677713036742e-04,  4.348170010686281e-06, -1.674105533104164e-08,
  5.355453575167358e-11, -1.381349642513002e-13,  8.935360410532581e-17, -1.870459944832610e-19, -2.301705840558097e-20, -1.404316304515072e-22, -1.061976507979424e-24,
  2.712140879168870e-26,  1.950242660423092e-01, -1.246130229249362e-03,  5.624144808496145e-06, -2.046915878686312e-08,  5.744209204693510e-11, -1.010030303552444e-13,
 -2.902770787652290e-16,  1.333019167503820e-18, -3.564309270011366e-20, -1.892125896214264e-22, -1.380956766509375e-24,  3.613868416352219e-26,  2.515512422899904e-01,
 -1.592018956042738e-03,  6.967951360711293e-06, -2.351826981081414e-08,  5.330630442638397e-11, -1.406543707794623e-14, -8.857610425701684e-16,  3.246880114739047e-18,
 -4.782009904439213e-20, -2.755487410607672e-22, -1.609607861287512e-24,  4.619226524470035e-26,  3.157183601089656e-01, -1.975251569682764e-03,  8.320364809333366e-06,
 -2.531450490925980e-08,  3.777661039744759e-11,  1.327312937375151e-13, -1.666311815402370e-15,  4.875641213515299e-18, -5.450824424719519e-20, -4.270834802535712e-22,
 -1.694263752980628e-24,  5.767302997864274e-26,  3.877391073562618e-01, -2.392510219005222e-03,  9.604451390922316e-06, -2.515706522021785e-08,  7.359824137137861e-12,
  3.423389034484095e-13, -2.513816543880672e-15,  4.947090876315182e-18, -4.858670263198362e-20, -6.682303331336541e-22, -1.710015954786877e-24,  7.206383122130262e-26,
  4.678544483650646e-01, -2.839153201407338e-03,  1.072009396593898e-05, -2.220506720283196e-08, -4.110901926556509e-11,  6.037197978273774e-13, -3.174332647435950e-15,
  1.492625821360756e-18, -2.265601331280716e-20, -9.953135157050857e-22, -2.036294588832057e-24,  9.252501571032919e-26,  5.563310599835304e-01, -3.308641632046947e-03,
  1.153663765533986e-05, -1.547665481908099e-08, -1.095832093140549e-10,  8.808778119212882e-13, -3.201417362492572e-15, -8.007355437842462e-18,  2.561919850435140e-20,
 -1.328848126235070e-21, -3.563525620999289e-24,  1.234435133835120e-25,  6.534560746318308e-01, -3.791679568430550e-03,  1.188317561707743e-05, -3.880632772784111e-09,
 -1.971351471768863e-10,  1.096188342582952e-12, -1.913421908896896e-15, -2.579310332442770e-17,  8.148471451017404e-20, -1.443205621213792e-21, -7.689589215003348e-24,
  1.662832104590869e-25,  7.595250274857616e-01, -4.274902381920583e-03,  1.153622614246657e-05,  1.367503853780694e-08, -2.968894594581239e-10,  1.107356456110345e-12,
  1.563729198379163e-15, -5.139263650907106e-17,  9.098129244955416e-20, -9.188225133817757e-22, -1.533321247923920e-23,  2.069292365335971e-25,  8.748166013882904e-01,
 -4.738842532403439e-03,  1.020561476289103e-05,  3.800171788245732e-08, -3.905731083194182e-10,  6.827729646179210e-13,  7.972435114905102e-15, -7.596161947107179e-17,
 -6.776614478042398e-20,  6.840418141613570e-22, -2.320544653825833e-23,  1.932875501018672e-25,  9.995414037063569e-01, -5.154731394302042e-03,  7.522911111114432e-06,
  6.896940223092626e-08, -4.394117506692208e-10, -4.997699607719168e-13,  1.684455133726771e-14, -7.175078889027973e-17, -5.797670301652400e-19,  2.842997881687713e-21,
 -1.559908494732835e-23,  4.115778385855277e-26,  1.133738527978609e+00, -5.479447879664957e-03,  3.047460674555686e-06,  1.040392498728235e-07, -3.711312243487226e-10,
 -2.742371966645882e-12,  2.373772262173355e-14,  1.889507243383304e-17, -1.487478434907341e-18,  1.266682164135880e-21,  3.860882253071106e-23, -1.405311094133906e-25,
  1.277064112820606e+00, -5.647695061716443e-03, -3.663946130702528e-06,  1.351899650923579e-07, -7.054971106625499e-11, -5.845253662404215e-12,  1.502785219331757e-14,
  2.568928877292055e-16, -1.852643827411496e-18, -1.495939655296364e-20,  1.149574705724464e-22,  7.062282930843066e-25,  1.428349844501284e+00, -5.560942070433981e-03,
 -1.279181104059446e-05,  1.432667548819635e-07,  5.846900726079637e-10, -7.703589214685487e-12, -3.397056115422588e-14,  4.954984472061068e-16,  1.661298545135031e-18,
 -4.289873562774961e-20, -1.459428372874661e-22,  3.517249716685833e-24,  1.584662271731149e+00, -5.077045727158152e-03, -2.345280895368680e-05,  9.173602222905295e-08,
  1.492953361471312e-09, -2.069376357549882e-12, -1.175282131236038e-13, -1.511072151686064e-16,  9.322838082155076e-18,  2.947438892990923e-20, -8.762242690628654e-22,
 -5.001177248538588e-24,  1.739307380740251e+00, -4.025994161708342e-03, -3.176580905239531e-05, -5.809577432407679e-08,  1.650007624965437e-09,  1.600430382679777e-11,
 -4.188368520645874e-14, -1.943226980349000e-15, -9.916073825617029e-18,  1.411545416992021e-19,  2.121223413911956e-21, -1.782360270577548e-24,  1.878000750871722e+00,
 -2.353169598630453e-03, -2.872936704148434e-05, -2.319146946120629e-07, -6.783464068114805e-10,  1.357115270728385e-11,  2.548493778837702e-13,  1.811831588335930e-15,
 -8.258883294760101e-18, -3.718880893705949e-19, -4.266998436966642e-21, -8.115115297119432e-24,  1.974431413666626e+00, -5.819330633250437e-04, -9.598058156531813e-06,
 -1.343295195078025e-07, -1.654421293095570e-09, -1.785355292992144e-11, -1.612447149394902e-13, -1.026351797121793e-15,  2.058362286119529e-19,  1.455143343054808e-19,
  3.028688687517168e-21,  4.296847126490682e-23,  8.322886722472797e-04, -5.405163920090178e-06,  2.629968593224037e-08, -1.139846481505217e-10,  4.592656226494199e-13,
 -1.830119666554922e-15,  6.220378894613254e-18, -3.413805416707061e-20, -3.047934016785054e-23, -1.297894790326695e-24,  1.068931677924182e-26,  5.583914680161725e-28,
  7.494592032619746e-03, -4.863018429661824e-05,  2.360106311150657e-07, -1.017818089678598e-09,  4.067282459917272e-12, -1.602395610161265e-14,  5.328250818050386e-17,
 -2.927018993300074e-19, -3.534911400136828e-22, -1.133749535254951e-23,  9.463817378517397e-26,  5.046994730434145e-27,  2.084055922950306e-02, -1.349912160313451e-04,
  6.517277574742973e-07, -2.782205491288804e-09,  1.092908668807289e-11, -4.203115601424409e-14,  1.331585319116480e-16, -7.341461324298139e-19, -1.405781733423883e-21,
 -2.970583372013632e-23,  2.549855215951969e-25,  1.413449842573733e-26,  4.091319600847807e-02, -2.642998107104368e-04,  1.265830344045171e-06, -5.318746254662108e-09,
  2.032842460700781e-11, -7.511457030279242e-14,  2.181449977500144e-16, -1.216369576021582e-18, -3.921543967830256e-21, -5.356641217473996e-23,  4.804148303412132e-25,
  2.802214802920661e-26,  6.777772475223838e-02, -4.362461028284676e-04,  2.066341454120331e-06, -8.490144520940701e-09,  3.117213201124052e-11, -1.082462205070669e-13,
  2.688662659397560e-16, -1.550810186953520e-18, -8.799689098692530e-21, -8.013277513908360e-23,  7.631051391947828e-25,  4.696793894127629e-26,  1.015224444967718e-01,
 -6.503628794886132e-04,  3.036220730160895e-06, -1.210432347187298e-08,  4.196991154422053e-11, -1.322564569188623e-13,  2.374755889342964e-16, -1.536020797417669e-18,
 -1.684426941771928e-20, -1.084190001026676e-22,  1.108602034332382e-24,  7.124841149819792e-26,  1.422598784360870e-01, -9.059716242636288e-04,  4.152327781893768e-06,
 -1.590617117640082e-08,  5.081240631470561e-11, -1.361414440999387e-13,  7.300443225333073e-17, -1.009367634387823e-18, -2.839654897323274e-20, -1.414633906913388e-22,
  1.546284036391155e-24,  1.011374211062800e-25,  1.901281976385006e-01, -1.202104122084663e-03,  5.383961484670349e-06, -1.956661403231576e-08,  5.535469435019792e-11,
 -1.076572456022444e-13, -2.699962495173245e-16,  7.723397288576976e-20, -4.285731792098127e-20, -1.887036181628930e-22,  2.136213919960805e-24,  1.369385035437297e-25,
  2.452928867312378e-01, -1.537389751536388e-03,  6.690836580269038e-06, -2.266874676377076e-08,  5.281884319075450e-11, -3.441514823433532e-14, -8.178201862631840e-16,
  1.551225569712820e-18, -5.813396341572748e-20, -2.677039210290284e-22,  2.964314289671004e-24,  1.791282007137109e-25,  3.079485705195029e-01, -1.909893284355744e-03,
  8.020297987057902e-06, -2.469097232178600e-08,  4.004129926422295e-11,  9.416641281803887e-14, -1.556578565279567e-15,  2.879518011642867e-18, -7.013799164771379e-20,
 -4.034939149318711e-22,  4.111851203141400e-24,  2.286850703341189e-25,  3.783208292511998e-01, -2.316879645858187e-03,  9.303488597159013e-06, -2.498776817854905e-08,
  1.361350284648890e-11,  2.834713436279381e-13, -2.400725825299076e-15,  3.003256703641457e-18, -7.266499819974795e-20, -6.220850740205248e-22,  5.578104626298949e-24,
  2.876599398270891e-25,  4.566676548679746e-01, -2.754468583734580e-03,  1.045007177468624e-05, -2.277034336486349e-08, -2.979364299038539e-11,  5.279220020216430e-13,
 -3.148124708583202e-15,  1.900867591819146e-19, -5.842193464840858e-20, -9.320801531740155e-22,  7.133427357652933e-24,  3.598892964905820e-25,  5.432798630827673e-01,
 -3.217119905430292e-03,  1.134096546046043e-05, -1.709329550294326e-08, -9.275186524246079e-11,  8.014011159009620e-13, -3.421451602533292e-15, -7.965555314918990e-18,
 -2.280354894986648e-20, -1.285405618535711e-21,  8.108208195231979e-24,  4.512218199000492e-25,  6.384791187148726e-01, -3.696852405831032e-03,  1.181839779214056e-05,
 -6.862140976470404e-09, -1.757277875914789e-10,  1.041844701281959e-12, -2.607249407285258e-15, -2.405669127458362e-17,  2.657791009766271e-20, -1.509918318797205e-21,
  7.255893140772843e-24,  5.672405922894783e-25,  7.426109251066308e-01, -4.182035230840739e-03,  1.167256135375846e-05,  9.103539554595006e-09, -2.744820369232417e-10,
  1.127912781030591e-12,  1.598130044125866e-16, -4.910450497040742e-17,  5.008217462859421e-20, -1.232371412795837e-21,  3.252052664652316e-24,  7.038331527811234e-25,
  8.560272606943294e-01, -4.655478665977363e-03,  1.062462267879505e-05,  3.187146054862991e-08, -3.751777369747588e-10,  8.483601722525018e-13,  5.817712287622986e-15,
 -7.789021768836136e-17, -5.648134950201408e-20,  7.696678780869717e-23, -2.576419786306610e-24,  8.248743855444957e-25,  9.790479168212977e-01, -5.091357714585860e-03,
  8.308099758415740e-06,  6.188009670739560e-08, -4.455376365790085e-10, -1.216148883843561e-13,  1.459039347147063e-14, -8.877194472309293e-17, -4.865391963516069e-19,
  2.447230336805348e-21,  1.616701494120575e-24,  8.430227048623384e-25,  1.111877255057582e+00, -5.450179224764820e-03,  4.258593638068613e-06,  9.769340851369888e-08,
 -4.202663370177738e-10, -2.171643913880445e-12,  2.360935763318488e-14, -2.767758860221724e-17, -1.413822163223897e-18,  2.890188996482212e-21,  4.901281543494714e-23,
  7.505026945818217e-25,  1.254424945242593e+00, -5.670545447797529e-03, -2.052227332722487e-06,  1.331478444946637e-07, -1.833020798351512e-10, -5.405432630156017e-12,
  2.131661663973283e-14,  1.899461539408949e-16, -2.299901096127588e-18, -9.614153541454950e-21,  1.571459010795207e-22,  1.380274998437181e-24,  1.405912504265732e+00,
 -5.656252692285218e-03, -1.102169448705819e-05,  1.513497307719514e-07,  4.236140136556007e-10, -8.347847318216776e-12, -1.959068324012114e-14,  5.231482999766906e-16,
  5.253814882453213e-20, -4.526356974369822e-20,  3.801050923571835e-23,  4.944463515156221e-24,  1.563986383704012e+00, -5.259862932199885e-03, -2.221051783990577e-05,
  1.151380970790121e-07,  1.423193827172882e-09, -4.906384591867305e-12, -1.174733617587586e-13,  1.570939735427915e-16,  9.713640562082794e-18, -8.435023708382111e-21,
 -9.757024859599557e-22,  9.755811399242379e-25,  1.722691400983463e+00, -4.282436551756098e-03, -3.229422364587984e-05, -2.920865883679085e-08,  1.955471099286433e-09,
  1.431558743497401e-11, -9.985776990236772e-14, -2.163242418495251e-15, -3.361014571791525e-18,  2.205876030349789e-19,  1.753917012379912e-21, -1.492663071525516e-23,
  1.868110546620200e+00, -2.594298080424431e-03, -3.156738572059673e-05, -2.402479878146326e-07, -3.418614218062787e-10,  2.025289301652022e-11,  2.996316737502039e-13,
  1.300228872110583e-15, -2.472250618654566e-17, -5.402546128461868e-19, -3.868451407386639e-21,  3.082566279806553e-23,  1.971939230583439e+00, -6.656438997834003e-04,
 -1.138132778928684e-05, -1.638767782799521e-07, -2.052491100479404e-09, -2.206176038623615e-11, -1.889126463869641e-13, -9.084461251668832e-16,  8.145771129516270e-18,
  3.117542281985692e-19,  5.479570718283265e-21,  6.989519483534733e-23,  8.110803214634195e-04, -5.200115506200320e-06,  2.497477715620873e-08, -1.069214334509713e-10,
  4.240779575281273e-13, -1.692449995632912e-15,  5.244757520505089e-18, -3.571876532858606e-20, -6.178049183235566e-23, -1.745990925459202e-25,  5.130438213249124e-26,
  1.359142610850068e-27,  7.303771641632388e-03, -4.678987213412044e-05,  2.241769147304014e-07, -9.552387368999809e-10,  3.758919220799922e-12, -1.484514032829554e-14,
  4.487536613144335e-17, -3.092740435860910e-19, -6.236905677340306e-22, -1.266731846020993e-24,  4.615017821606420e-25,  1.227321150238826e-26,  2.031081467579705e-02,
 -1.299080299179027e-04,  6.193632864570812e-07, -2.613898542732357e-09,  1.011872647625831e-11, -3.908799000412439e-14,  1.118343835131144e-16, -7.927635341611878e-19,
 -2.096221026580751e-21, -1.918658704581256e-24,  1.281292269746410e-24,  3.431769278754518e-26,  3.987585348426777e-02, -2.544230508314290e-04,  1.203908231279063e-06,
 -5.005237187055372e-09,  1.887564913270056e-11, -7.030354990777601e-14,  1.820831157817864e-16, -1.366013289623781e-18, -5.116972801022263e-21,  4.864326470150095e-25,
  2.512629154308304e-24,  6.791664900102271e-26,  6.606516830915718e-02, -4.201145816447557e-04,  1.967381895941298e-06, -8.008374569777653e-09,  2.906804364767138e-11,
 -1.023486593769909e-13,  2.211377516010970e-16, -1.867654437173475e-18, -1.048663757828846e-20,  8.740189194436862e-24,  4.166211916432256e-24,  1.136880637341278e-25,
  9.896866843576051e-02, -6.266429044531538e-04,  2.894911631156920e-06, -1.145367201264868e-08,  3.937796444245882e-11, -1.271371767966832e-13,  1.864376644273305e-16,
 -2.121327378442497e-18, -1.896566960059155e-20,  2.442725813091748e-23,  6.270249149274205e-24,  1.724332831601964e-25,  1.387012395543817e-01, -8.735028836223309e-04,
  3.966242142978602e-06, -1.511487161930564e-08,  4.810426096524801e-11, -1.348351928041288e-13,  3.140054010934830e-17, -1.976808010093440e-18, -3.097903091964220e-20,
  4.610925536287532e-23,  8.880597453771875e-24,  2.451463329818849e-25,  1.854044585088170e-01, -1.159956737138338e-03,  5.154403967832360e-06, -1.869851828192626e-08,
  5.313610118665598e-11, -1.142715213131700e-13, -2.878554033763531e-16, -1.371769596143841e-18, -4.621868679650449e-20,  6.725784888103941e-23,  1.208951727322357e-23,
  3.330732223963680e-25,  2.392486784904332e-01, -1.484936851195552e-03,  6.423856090599884e-06, -2.183020725079471e-08,  5.193666177078757e-11, -5.373947062581111e-14,
 -8.016080516202330e-16, -4.212028289237620e-19, -6.315480447801110e-20,  7.446194367822529e-23,  1.602733393544122e-23,  4.378714486421063e-25,  3.004354611840763e-01,
 -1.846905045834699e-03,  7.727905922343981e-06, -2.403725199215471e-08,  4.155621767276185e-11,  5.751071390115870e-14, -1.509193847267937e-15,  4.589491716836609e-19,
 -7.852799617648314e-20,  4.715421025310057e-23,  2.084625510990077e-23,  5.619438463378582e-25,  3.692002731851303e-01, -2.243647036421331e-03,  9.005119291914030e-06,
 -2.472770364510370e-08,  1.871212903315343e-11,  2.265818311203247e-13, -2.352075267703356e-15,  3.935835780120861e-19, -8.704551730759333e-20, -3.849614550179804e-23,
  2.666831795167782e-23,  7.090305288208949e-25,  4.458152407189266e-01, -2.671968314126720e-03,  1.017430259040413e-05, -2.316668164883700e-08, -1.999153508340323e-11,
  4.521914925854765e-13, -3.173410858924861e-15, -2.122647191834493e-18, -8.184434499913753e-20, -1.964024016390684e-22,  3.347294493042062e-23,  8.850735128547791e-25,
  5.305915057702648e-01, -3.127236699679258e-03,  1.112745599598123e-05, -1.845364057364692e-08, -7.756365304778483e-11,  7.164880037004015e-13, -3.660943189582832e-15,
 -9.324870876550225e-18, -5.700192262690615e-20, -3.993588678943575e-22,  4.090897199442849e-23,  1.099035007269863e-24,  6.238802165126898e-01, -3.602680843835813e-03,
  1.171985821435162e-05, -9.510718182232044e-09, -1.555708986594334e-10,  9.712369653141893e-13, -3.276363808606195e-15, -2.395960006682617e-17, -1.475786195471685e-20,
 -5.186257282705109e-22,  4.809497807973869e-23,  1.362304673426745e-24,  7.260701338920587e-01, -4.088290715754134e-03,  1.175619737978901e-05,  4.892036685584313e-09,
 -2.519960243816263e-10,  1.115391935338035e-12, -1.198747547731266e-15, -4.811189856732119e-17,  1.771743028425364e-20, -2.342023799661293e-22,  5.378070168518078e-23,
  1.682816795862354e-24,  8.375776199137256e-01, -4.569052567686196e-03,  1.097164559952123e-05,  2.601119553392581e-08, -3.569919782565070e-10,  9.616138437290709e-13,
  3.612254316925406e-15, -7.958447473545570e-17, -4.406995580389308e-20,  1.010951534256879e-21,  5.816477016982446e-23,  2.046425870203267e-24,  9.588199472667142e-01,
 -5.022043923679134e-03,  9.007868286772567e-06,  5.475018631565866e-08, -4.446783131055429e-10,  1.970519072960931e-13,  1.190067171510187e-14, -1.028241507855118e-16,
 -3.848584841230280e-19,  3.647246496331812e-21,  6.961120427474790e-23,  2.385846896220233e-24,  1.090151934871456e+00, -5.411538607052543e-03,  5.389234474442172e-06,
  9.065211660915610e-08, -4.581216999626338e-10, -1.619319633086373e-12,  2.221983595333105e-14, -7.078539337214780e-17, -1.262362703650798e-18,  5.984011889442402e-21,
  1.193569577159722e-22,  2.630300387011431e-24,  1.231719966067474e+00, -5.680630055395432e-03, -4.755231699308290e-07,  1.293795938861246e-07, -2.859081154423114e-10,
 -4.838601393167356e-12,  2.556218377986486e-14,  1.121694865965896e-16, -2.514160380643104e-18, -1.646386432889885e-21,  2.554344667362635e-22,  3.332591434795703e-24,
  1.383122794724048e+00, -5.737059068119605e-03, -9.170409528106556e-06,  1.567713178666864e-07,  2.531364702486399e-10, -8.643539897162228e-12, -5.159233766189823e-15,
  4.995116398488396e-16, -1.491735105537696e-18, -3.877993877652148e-20,  3.035664488497651e-22,  7.340936927322065e-24,  1.542600849617594e+00, -5.431641780506296e-03,
 -2.069596289441402e-05,  1.369731127766345e-07,  1.297408188844334e-09, -7.638382424203155e-12, -1.088212022757799e-13,  4.557636332541890e-16,  8.739373173884942e-18,
 -4.419942806441177e-20, -7.482715751828082e-22,  9.781977679275706e-24,  1.705043505738368e+00, -4.541639657501548e-03, -3.244803242037833e-05,  4.218443932424423e-09,
  2.212880725204868e-09,  1.118778410004898e-11, -1.606524047226113e-13, -2.131687737387393e-15,  5.653714316104321e-18,  2.743006778094297e-19,  8.626054038629386e-22,
 -2.428089641127944e-23,  1.857209929855769e+00, -2.858428678942697e-03, -3.446851828969858e-05, -2.420760581345265e-07,  1.375150621250674e-10,  2.777257912822222e-11,
  3.218460004445980e-13,  1.717415254525402e-16, -4.647081024327929e-17, -6.499652356760986e-19, -1.123088075453828e-21,  9.850115888737614e-23,  1.969081264670905e+00,
 -7.651540596520770e-04, -1.356026903580999e-05, -2.005008292108187e-07, -2.540923446702580e-09, -2.685940469734700e-11, -2.086733934699216e-13, -4.193238175674176e-16,
  2.414244801224593e-17,  6.020744464675613e-19,  9.282026279033792e-21,  1.034158963039634e-22,  7.906714893523357e-04, -5.005336698346555e-06,  2.373133563695240e-08,
 -1.004004829379553e-10,  3.914055719751450e-13, -1.578789121004585e-15,  4.219604082473730e-18, -3.726415006344776e-20, -1.377710388360035e-23,  3.400986656564715e-24,
  1.361385269229564e-25,  2.542218914957427e-27,  7.120127799723802e-03, -4.504130804882931e-05,  2.130652897529927e-07, -8.974157182670087e-10,  3.472073791532972e-12,
 -1.387418834225988e-14,  3.596178491963862e-17, -3.251701627809762e-19, -1.803542881401411e-22,  3.094844912854356e-23,  1.227455285999162e-24,  2.295169035600506e-26,
  1.980089752082531e-02, -1.250758969669930e-04,  5.889425550578214e-07, -2.458114845665148e-09,  9.361971044587411e-12, -3.667754153562122e-14,  8.877749488447140e-17,
 -8.476206231954759e-19, -8.047881869353050e-22,  8.778747181225537e-23,  3.422502627988624e-24,  6.415384324457211e-26,  3.887705052384015e-02, -2.450270075742889e-04,
  1.145611779809754e-06, -4.714251261593169e-09,  1.751008744928153e-11, -6.641016676885461e-14,  1.417217733398406e-16, -1.503280445092707e-18, -2.423723589376403e-21,
  1.770808788249638e-22,  6.749163336584461e-24,  1.269191250839568e-25,  6.441559041571708e-02, -4.047521757361759e-04,  1.874005267075987e-06, -7.559391738451404e-09,
  2.706971799248160e-11, -9.770509292018386e-14,  1.644864757058904e-16, -2.154650326449199e-18, -5.721744128412831e-21,  3.027430860589673e-22,  1.125690933358595e-23,
  2.124165462910112e-25,  9.650755979319045e-02, -6.040228686283626e-04,  2.761164670480512e-06, -1.084374481340951e-08,  3.687481140781631e-11, -1.234410639529953e-13,
  1.191189506623502e-16, -2.648493037110981e-18, -1.137149993747678e-20,  4.684098138241765e-22,  1.702588670996523e-23,  3.222401535458732e-25,  1.352695573659751e-01,
 -8.424855807421765e-04,  3.789392777835948e-06, -1.436675691472872e-08,  4.541004820275462e-11, -1.348532374040819e-13, -3.695135430445460e-17, -2.848477694247437e-18,
 -1.979631526088115e-20,  6.760487752388666e-22,  2.417846138085619e-23,  4.584660081784591e-25,  1.808457011084570e-01, -1.119604757461942e-03,  4.935046136277492e-06,
 -1.786701546824409e-08,  5.077763473652723e-11, -1.218017229423547e-13, -3.457525941233635e-16, -2.685338492109931e-18, -3.084002960763953e-20,  9.243098665560640e-22,
  3.289172950555443e-23,  6.237676147304188e-25,  2.334100735147352e-01, -1.434579814158337e-03,  6.166840648402657e-06, -2.100887230982035e-08,  5.066738085614533e-11,
 -7.334000919482005e-14, -8.401614682202010e-16, -2.231658372270253e-18, -4.333971563385720e-20,  1.206954594044677e-21,  4.340742672780245e-23,  8.216379153604348e-25,
  2.931696767210786e-01, -1.786224208628754e-03,  7.443479877388677e-06, -2.336511943643767e-08,  4.234383068401151e-11,  2.116897655691209e-14, -1.529802178785728e-15,
 -1.809508603971472e-18, -5.463573438087695e-20,  1.512245815626205e-21,  5.603179760776860e-23,  1.056794828864175e-24,  3.603678952570604e-01, -2.172787597688481e-03,
  8.710322818143349e-06, -2.439512544060518e-08,  2.267856030763520e-11,  1.699572874855649e-13, -2.378389104697401e-15, -2.137041686960518e-18, -6.015877661589596e-20,
  1.825304451068778e-21,  7.111161251678328e-23,  1.335877818885125e-24,  4.352883888314885e-01, -2.591690671496159e-03,  9.894668197147419e-06, -2.341835920768327e-08,
 -1.171565484128528e-11,  3.750252951529205e-13, -3.268229081121280e-15, -4.507592787827007e-18, -5.348967292714806e-20,  2.137614511660806e-21,  8.896446488858467e-23,
  1.668538422734871e-24,  5.182591674025739e-01, -3.039122866182304e-03,  1.089902336506872e-05, -1.958488733166245e-08, -6.413474027801128e-11,  6.252867249543101e-13,
 -3.946862182784128e-15, -1.095295717820358e-17, -2.787195322884186e-20,  2.471601399466919e-21,  1.097399809979982e-22,  2.068861343323652e-24,  6.096562302249771e-01,
 -3.509419360491973e-03,  1.159142134121013e-05, -1.184895614551359e-08, -1.369871173296408e-10,  8.844997196814226e-13, -3.953231113914372e-15, -2.422285423664171e-17,
  1.859567811102434e-20,  2.933013046841684e-21,  1.332293850352296e-22,  2.556362458897284e-24,  7.099053474351190e-01, -3.994073178902687e-03,  1.179144004826633e-05,
  1.036543042903536e-09, -2.300846379652675e-10,  1.070531532498793e-12, -2.535296644624699e-15, -4.709620306963167e-17,  6.948451514682717e-20,  3.803003360666030e-21,
  1.588486083512157e-22,  3.153764338961339e-24,  8.194787976995405e-01, -4.480126478837462e-03,  1.125015656359148e-05,  2.045713259160212e-08, -3.370738647423698e-10,
  1.021462785214703e-12,  1.373981668729941e-15, -7.975788782892816e-17,  6.041722775563005e-20,  5.641880041231340e-21,  1.867630708674090e-22,  3.874399108549931e-24,
  9.388798882381303e-01, -4.947473525557044e-03,  9.622358996120539e-06,  4.768137795088482e-08, -4.381209080161215e-10,  4.468737596357721e-13,  8.874119027033863e-15,
 -1.122590631357394e-16, -1.724480951365309e-19,  9.165885345595004e-21,  2.231902451415767e-22,  4.690615522785287e-24,  1.068598718824516e+00, -5.364200315550706e-03,
  6.432103263529215e-06,  8.309129985591565e-08, -4.853584791478540e-10, -1.114153724217027e-12,  1.971279760295945e-14, -1.065402226596657e-16, -9.260049381759488e-19,
  1.386634253699583e-20,  2.959676828075824e-22,  5.527935004120725e-24,  1.208999551117508e+00, -5.678308920729905e-03,  1.046501799364042e-06,  1.240651252494119e-07,
 -3.763377534425897e-10, -4.196487453464088e-12,  2.758364958594062e-14,  3.307899755862501e-17, -2.346125361651456e-18,  1.240688286275678e-20,  4.718534564356710e-22,
  6.696495518943364e-24,  1.360039826375222e+00, -5.802841626696386e-03, -7.270566415965149e-06,  1.594364501041294e-07,  8.012735567184187e-11, -8.606109189164405e-12,
  7.969571228919989e-15,  4.324728735570897e-16, -2.582362773093444e-18, -1.916594959817740e-20,  7.044169539896492e-22,  1.107003901804650e-23,  1.520554038810844e+00,
 -5.590294387716261e-03, -1.893322216897644e-05,  1.563724865115557e-07,  1.119713530796593e-09, -1.006700573088708e-11, -9.241920989740929e-14,  7.052110431881381e-16,
  6.740829650197513e-18, -6.246689696731305e-20, -8.763974696519633e-23,  2.037070720176781e-23,  1.686358969522823e+00, -4.800403982459994e-03, -3.217832350691960e-05,
  4.118528316948610e-08,  2.393390235595359e-09,  6.645632877534044e-12, -2.162871404675155e-13, -1.788244245744781e-15,  1.588689535797048e-17,  2.870632180774382e-19,
 -2.075977752124231e-22, -2.189681196012816e-23,  1.845206432957878e+00, -3.145714136082385e-03, -3.734054357892411e-05, -2.350141836079895e-07,  7.696386272061150e-10,
  3.536485625255987e-11,  3.023127000389481e-13, -1.688430325302983e-15, -6.940956495963557e-17, -5.834545472756183e-19,  5.074562791948821e-21,  1.837953581071978e-22,
  1.965787414281451e+00, -8.839939895605660e-04, -1.622882279334434e-05, -2.457273571130071e-07, -3.128597949744663e-09, -3.189833955888477e-11, -2.057749792404962e-13,
  7.811527959004189e-16,  5.368170576182931e-17,  1.073464048220040e-18,  1.448021011451714e-20,  1.292298859068201e-22,  7.710223606711708e-04, -4.820201139885958e-06,
  2.256307963191428e-08, -9.438545146957882e-11,  3.607583575477262e-13, -1.489932660219755e-15,  3.197311566957224e-18, -3.445410059366379e-20,  2.369843765034949e-22,
  1.144674479445110e-23,  2.743995002063351e-25,  3.654635331305606e-27,  6.943304714407462e-03, -4.337893808066825e-05,  2.026206067057420e-07, -8.440386040002305e-10,
  3.202485767501046e-12, -1.311959395393662e-14,  2.702370210745290e-17, -3.014638359361311e-19,  2.091164811107105e-21,  1.035215850210805e-22,  2.475680914681017e-24,
  3.299425490386404e-26,  1.930983371950360e-02, -1.204798546208514e-04,  5.603200718770094e-07, -2.314084023624398e-09,  8.647805671991127e-12, -3.483058039549179e-14,
  6.538179137333353e-17, -7.903060308007550e-19,  5.584525683695906e-21,  2.903025011659433e-22,  6.911423056486114e-24,  9.222357449648635e-26,  3.791492059113711e-02,
 -2.360837344667347e-04,  1.090678461711410e-06, -4.444545056797285e-09,  1.621247531654222e-11, -6.351466635620630e-14,  9.994265327010436e-17, -1.414708171981424e-18,
  1.032354519978937e-20,  5.768561447301190e-22,  1.365149633589282e-23,  1.824589148203762e-25,  6.282600148387425e-02, -3.901157686607283e-04,  1.785827411978784e-06,
 -7.141715296290675e-09,  2.515015482154888e-11, -9.448840532080324e-14,  1.039659731476774e-16, -2.056329751520807e-18,  1.581418634837460e-20,  9.702798957164137e-22,
  2.280964520593267e-23,  3.054186953809797e-25,  9.413483674246659e-02, -5.824442078154326e-04,  2.634498676537038e-06, -1.027336877197432e-08,  3.442844498214426e-11,
 -1.214922027380088e-13,  4.351335254564147e-17, -2.580592965935871e-18,  2.159160761499639e-20,  1.479069923418003e-21,  3.455459606289776e-23,  4.634872694930253e-25,
  1.319591706205755e-01, -8.128478967468938e-04,  3.621261823848896e-06, -1.366184888965864e-08,  4.269740792595495e-11, -1.367385289297706e-13, -1.203396236008010e-16,
 -2.862435695241801e-18,  2.741660098668618e-20,  2.112259549893347e-21,  4.912526898661205e-23,  6.598224981509332e-25,  1.764449041742828e-01, -1.080968381798780e-03,
  4.725434680376715e-06, -1.707453952616909e-08,  4.825212108211573e-11, -1.310723211164415e-13, -4.276077982599798e-16, -2.826747734984736e-18,  3.355677005725906e-20,
  2.878391235152950e-21,  6.684983162831995e-23,  8.985353085648968e-25,  2.277688463343757e-01, -1.386239852023796e-03,  5.919546232549014e-06, -2.021104760648793e-08,
  4.899329062021974e-11, -9.435642412262710e-14, -9.126977415533843e-16, -2.510289039985418e-18,  4.116697995091788e-20,  3.784561832147285e-21,  8.816716384064071e-23,
  1.184990185674730e-24,  2.861421161015339e-01, -1.727786358701490e-03,  7.167170907660102e-06, -2.268624593713945e-08,  4.239521024014120e-11, -1.628363976949712e-14,
 -1.593104221018689e-15, -2.153966902076919e-18,  5.276181106576277e-20,  4.836193851033902e-21,  1.136467897599101e-22,  1.526308204016577e-24,  3.518142650255045e-01,
 -2.104269574524256e-03,  8.419860517260925e-06, -2.400819999310539e-08,  2.550126056032915e-11,  1.120237794079672e-13, -2.450660677279950e-15, -2.334979395964143e-18,
  7.270386078637362e-20,  6.039087830588640e-21,  1.439986572019277e-22,  1.932199730940789e-24,  4.250781572589472e-01, -2.513660051692246e-03,  9.612756772387705e-06,
 -2.355011261904236e-08, -5.010343331948809e-12,  2.949793183747024e-13, -3.401034967882817e-15, -4.142795513418084e-18,  1.074481872332737e-19,  7.407174803044770e-21,
  1.800570074123528e-22,  2.416297216165309e-24,  5.062755484428275e-01, -2.952887282025395e-03,  1.065824351340962e-05, -2.051624870631211e-08, -5.260114049060298e-11,
  5.268983080964023e-13, -4.245493406415298e-15, -9.377616023440875e-18,  1.648313033795974e-19,  8.982967022552990e-21,  2.227168297846115e-22,  2.998125294757609e-24,
  5.958030641297133e-01, -3.417292690339769e-03,  1.143664955193663e-05, -1.390461281636472e-08, -1.202999216084900e-10,  7.816907403108554e-13, -4.598547740484780e-15,
 -2.066718301617150e-17,  2.506418834955546e-19,  1.088363387276475e-20,  2.728191533284651e-22,  3.705478538485561e-24,  6.941177103006554e-01, -3.899752883943614e-03,
  1.178248507158172e-05, -2.477273874392834e-09, -2.093872745141850e-10,  9.942889312702922e-13, -3.791826402393389e-15, -4.115646915961591e-17,  3.584346746626178e-19,
  1.339148625902855e-20,  3.311125011956670e-22,  4.575545448226585e-24,  8.017397216520299e-01, -4.389233407535351e-03,  1.146396097401011e-05,  1.522842408812353e-08,
 -3.164936026471648e-10,  1.028106285528432e-12, -7.892560982884619e-16, -7.276476062944477e-17,  4.443413962475059e-19,  1.709364606359609e-20,  3.989740283620954e-22,
  5.649112896223613e-24,  9.192474084098701e-01, -4.868324367239484e-03,  1.015280540813406e-05,  4.075343974442680e-08, -4.273099177677007e-10,  6.218873071097432e-13,
  5.718053720092682e-15, -1.103271381560722e-16,  3.746163043080062e-19,  2.294481130752120e-20,  4.824576074721194e-22,  6.945932539108882e-24,  1.047250957746870e+00,
 -5.308888656319477e-03,  7.381949471556329e-06,  7.517193738599440e-08, -5.031671248054365e-10, -6.796367711857442e-13,  1.640918773926215e-14, -1.253686619538549e-16,
 -1.466101835585327e-19,  3.149383808597090e-20,  6.068917091356626e-22,  8.430450027412575e-24,  1.186312335785007e+00, -5.664090288198037e-03,  2.496502217016153e-06,
  1.174084212487388e-07, -4.536139725945617e-10, -3.531290447707930e-12,  2.755558568982843e-14, -3.056388408526457e-17, -1.478463894633684e-18,  3.829395217947278e-20,
  8.488128001216626e-22,  1.024937468550046e-23,  1.336724261607387e+00, -5.853344407810029e-03, -5.355272325697410e-06,  1.593558457292075e-07, -8.915145906565915e-11,
 -8.279284574852108e-12,  1.886283891509092e-14,  3.452621012097022e-16, -2.636626949040707e-18,  1.996475470577695e-20,  1.280176617915757e-21,  1.484919815806076e-23,
  1.497902222866321e+00, -5.733965773439421e-03, -1.695627509265150e-05,  1.725637930965016e-07,  8.979094411894689e-10, -1.202579629321388e-11, -6.998524650133207e-14,
  8.861960070834699e-16,  4.672506101528327e-18, -4.506020963744682e-20,  1.025706121157855e-21,  2.955604285712996e-23,  1.666646560472310e+00, -5.055194485701350e-03,
 -3.145090588815157e-05,  8.024492060347068e-08,  2.470675308972362e-09,  9.207873647096289e-13, -2.577083203891685e-13, -1.117775973663210e-15,  2.587518200709060e-17,
  2.636132034218714e-19, -8.377443948701613e-22, -4.584385446445201e-24,  1.832008636156946e+00, -3.455453606999927e-03, -4.006226599807786e-05, -2.166681937006136e-07,
  1.544288394642338e-09,  4.178447357446905e-11,  2.211612624555713e-13, -4.189236822794798e-15, -8.460538791964179e-17, -1.967390783141093e-19,  1.471813161640405e-20,
  2.452940625862473e-22,  1.961971834441351e+00, -1.026520639672552e-03, -1.949978877182688e-05, -3.011455615934587e-07, -3.813008905270353e-09, -3.634037784149027e-11,
 -1.531820979614132e-13,  3.240207944624110e-15,  1.041191145736177e-16,  1.764973961434570e-18,  1.991618991763302e-20,  1.030441581213195e-22,  };
  constexpr double w[9216] = {  1.280352917258108e-01, -7.157219019508455e-04,  4.301800513305075e-06, -2.707174617184253e-08,  1.744269273111122e-10,
 -1.133872406465170e-12,  7.373759793615857e-15, -4.776715945239790e-17,  3.076208314846978e-19, -1.968106350051550e-21,  1.250779248339483e-23, -7.897579719901675e-26,
  1.265071219389021e-01, -1.199546669203801e-03,  1.292163728977991e-05, -1.338310884216596e-07,  1.316395821869719e-09, -1.240721731996495e-11,  1.129692289985611e-13,
 -9.994504785049029e-16,  8.627304580818685e-18, -7.288577674308892e-20,  6.040945091259476e-22, -4.921151550458088e-24,  1.235267432123466e-01, -2.125622221615186e-03,
  3.473760224166603e-05, -5.004729358603634e-07,  6.599279044832731e-09, -8.143905744162042e-11,  9.532902417762196e-13, -1.068043284686085e-14,  1.152756738662332e-16,
 -1.204440151983128e-18,  1.222844502051582e-20, -1.209931528528746e-22,  1.192379914652665e-01, -3.416003324227760e-03,  7.768486320451919e-05, -1.482793790274761e-06,
  2.517499639860939e-08, -3.916384675071487e-10,  5.684420168053536e-12, -7.792016929842344e-14,  1.017518931305341e-15, -1.274007537061243e-17,  1.537107228938891e-19,
 -1.793909995311454e-21,  1.138377654448310e-01, -4.965823628626419e-03,  1.509343400017849e-04, -3.702239677922808e-06,  7.869836520077497e-08, -1.503943364861700e-09,
  2.642250174794566e-11, -4.331870847147321e-13,  6.697921908848426e-15, -9.844405732112938e-17,  1.383747424335353e-18, -1.868757814810137e-20,  1.075568865892188e-01,
 -6.655320314485110e-03,  2.623933299580555e-04, -8.067247082722205e-06,  2.100427890236683e-07, -4.834053554747135e-09,  1.009348932484303e-10, -1.945478693215330e-12,
  3.504349547973033e-14, -5.953195426378531e-16,  9.605160188968428e-18, -1.479757401308819e-19,  1.006395268683725e-01, -8.362442479465583e-03,  4.164231812457563e-04,
 -1.570518085766092e-05,  4.916827312397637e-07, -1.340478423479385e-08,  3.276494799366359e-10, -7.320832701004021e-12,  1.515983303228737e-13, -2.939383449874740e-15,
  5.378562305015240e-17, -9.343616021436617e-19,  9.332399274448830e-02, -9.974174633274619e-03,  6.122706709765877e-04, -2.778757085760901e-05,  1.029143527698026e-06,
 -3.276015691737277e-08,  9.251247984686248e-10, -2.367127550476814e-11,  5.571110735105135e-13, -1.219614589453320e-14,  2.505014941273114e-16, -4.858817949579978e-18,
  8.582703962572567e-02, -1.139518648754901e-02,  8.434970090819751e-04, -4.527187509921153e-05,  1.954435800061649e-06, -7.169910249115859e-08,  2.311671486854560e-09,
 -6.699873313724532e-11,  1.773911751499830e-12, -4.342527780779995e-14,  9.920382855011150e-16, -2.129686895851072e-17,  7.833298263504807e-02, -1.255309360052335e-02,
  1.098433677954677e-03, -6.861695093664938e-05,  3.406296531499860e-06, -1.422874455704869e-07,  5.180792446133512e-09, -1.683786757197533e-10,  4.968475690082927e-12,
 -1.348119887760907e-13,  3.396858796436761e-15, -8.006896597871139e-17,  7.098791201472597e-02, -1.340029533534592e-02,  1.361472472490598e-03, -9.754410055952132e-05,
  5.498133108318243e-06, -2.585872670314270e-07,  1.052495951642329e-08, -3.799933930918460e-10,  1.238725445781366e-11, -3.694841002606089e-13,  1.018873445344953e-14,
 -2.617459229187241e-16,  6.389852157787605e-02, -1.391289771704717e-02,  1.614859493051470e-03, -1.309069369674442e-04,  8.279393211153069e-06, -4.338093248527894e-07,
  1.954819588441927e-08, -7.770702643548420e-10,  2.775344152051880e-11, -9.029515701186258e-13,  2.704953298808133e-14, -7.520443261188365e-16,  5.713453763980152e-02,
 -1.408754868857845e-02,  1.840626241476695e-03, -1.667063283287347e-04,  1.169972174472926e-05, -6.761251300606374e-07,  3.342272778189070e-08, -1.450449631617836e-09,
  5.630799881650216e-11, -1.983367784289720e-12,  6.409197503411359e-14, -1.915561169426800e-15,  5.073352040298874e-02, -1.393710456820688e-02,  2.022340670455860e-03,
 -2.022518321436533e-04,  1.558618478086532e-05, -9.839994317498401e-07,  5.289323541739580e-08, -2.485550666783106e-09,  1.040836336013949e-10, -3.940724290101068e-12,
  1.364343655678142e-13, -4.355242475469225e-15,  4.470685177929521e-02, -1.348595634066624e-02,  2.146463426687974e-03, -2.344395400526745e-04,  1.964158841221387e-05,
 -1.342365784753819e-06,  7.780318783695143e-08, -3.927886699930063e-09,  1.761158592081623e-10, -7.117399529615459e-12,  2.622673385573010e-13, -8.885806969563588e-15,
  3.904593513652049e-02, -1.276564589577127e-02,  2.203212066328345e-03, -2.600960437488914e-04,  2.346723365711512e-05, -1.721044985937300e-06,  1.066838709946875e-07,
 -5.742245682542300e-09,  2.737014160852169e-10, -1.172668372605240e-11,  4.569513279797803e-13, -1.633121466690621e-14,  3.372791966932028e-02, -1.181116803901518e-02,
  2.186938790025161e-03, -2.763321549791583e-04,  2.660783613439039e-05, -2.076413836344773e-06,  1.365748733902562e-07, -7.779434672045619e-09,  3.914265965901459e-10,
 -1.766175899173920e-11,  7.231917089577449e-13, -2.710072766376618e-14,  2.872054912171126e-02, -1.065813890493748e-02,  2.096098414609521e-03, -2.808563147640756e-04,
  2.861143042804314e-05, -2.356562336080833e-06,  1.632124713220686e-07, -9.767320113336666e-09,  5.152285095784201e-10, -2.432387455497051e-11,  1.040102061974893e-12,
 -4.062628200566514e-14,  2.398597383363632e-02, -9.340846272983995e-03,  1.932918909558063e-03, -2.722117964597580e-04,  2.909405894953353e-05, -2.509260508050629e-06,
  1.816302688748224e-07, -1.133893834986348e-08,  6.228569438324051e-10, -3.056884436408292e-11,  1.356696708521952e-12, -5.491308793249798e-14,  1.948353685596861e-02,
 -7.891091666383177e-03,  1.702892098003511e-03, -2.499187043070838e-04,  2.779837976318973e-05, -2.491266592182019e-06,  1.870906426611855e-07, -1.209962373910206e-08,
  6.875335693935334e-10, -3.485685540521058e-11,  1.595953674276786e-12, -6.655198181100337e-14,  1.517165183276262e-02, -6.337683223560838e-03,  1.414186867677677e-03,
 -2.145172499708964e-04,  2.463680441915740e-05, -2.277070401723420e-06,  1.761480316124563e-07, -1.172069540843019e-08,  6.844371652780681e-10, -3.562111540693924e-11,
  1.672478847490221e-12, -7.144246014747991e-14,  1.100895919308019e-02, -4.706435155581139e-03,  1.077062988422300e-03, -1.675206368392904e-04,  1.971276677688413e-05,
 -1.865190670350278e-06,  1.475778973425180e-07, -1.003483437071076e-08,  5.983157419063221e-10, -3.176757473585652e-11,  1.520444329776362e-12, -6.615242742822380e-14,
  6.955142590371795e-03, -3.020624130088645e-03,  7.033538105729240e-04, -1.112958256119719e-04,  1.331772495733773e-05, -1.280640759916275e-06,  1.029166013547720e-07,
 -7.103520630484610e-09,  4.296733673678114e-10, -2.313076745989940e-11,  1.121855454556813e-12, -4.943435288334633e-14,  2.975637322372065e-03, -1.303574134655517e-03,
  3.064594759607206e-04, -4.895727216813827e-05,  5.912855458786342e-06, -5.737031886597937e-07,  4.650449042980480e-08, -3.236602609224751e-09,  1.973422863286594e-10,
 -1.070537046876764e-11,  5.230548511491960e-13, -2.321148056900038e-14,  1.252392402572045e-01, -6.825611607311892e-04,  3.992966139130682e-06, -2.445315507370937e-08,
  1.534163286749886e-10, -9.719017557993380e-13,  6.164093093308238e-15, -3.896676233849358e-17,  2.449969025118799e-19, -1.530828617071303e-21,  9.503979239994273e-24,
 -5.863562571596086e-26,  1.219059920785384e-01, -1.102257350422870e-03,  1.143430193500211e-05, -1.146155811705235e-07,  1.093248850703349e-09, -1.000284249298460e-11,
  8.848614079725629e-14, -7.610877324986926e-16,  6.390859421602716e-18, -5.254829915982876e-20,  4.240802659214298e-22, -3.365221791521292e-24,  1.155444005301988e-01,
 -1.870065287823703e-03,  2.931547389683353e-05, -4.067662900884863e-07,  5.177060101575498e-09, -6.176881032920747e-11,  6.999804543512156e-13, -7.600467934182155e-15,
  7.957381510404757e-17, -8.071122313018813e-19,  7.960308364445485e-21, -7.655846495727702e-23,  1.067131824796802e-01, -2.859401485196985e-03,  6.207178841224357e-05,
 -1.135924162169121e-06,  1.854712505554684e-08, -2.780991013357179e-10,  3.897198238309724e-12, -5.164998147337297e-14,  6.528607449945148e-16, -7.920282589611671e-18,
  9.267078248298545e-20, -1.049663586683659e-21,  9.613551538957403e-02, -3.916731439764739e-03,  1.131712093269268e-04, -2.652968511520561e-06,  5.409097766998690e-08,
 -9.940635547657699e-10,  1.682891828830399e-11, -2.662985836449617e-13,  3.979624195204563e-15, -5.659975549379214e-17,  7.706486564965087e-19, -1.009098604272562e-20,
  8.459273195534471e-02, -4.892846036887388e-03,  1.829407233587582e-04, -5.364862962572290e-06,  1.337533365920023e-07, -2.956015661149322e-09,  5.940216989779837e-11,
 -1.103938526883294e-12,  1.920223361426342e-14, -3.154264510681101e-16,  4.926796363932511e-18, -7.355661906821324e-20,  7.282399492304716e-02, -5.669077334112337e-03,
  2.675302331298583e-04, -9.616720406832857e-06,  2.880857187558382e-07, -7.537521513070283e-09,  1.772259734304638e-10, -3.816528972503790e-12,  7.629708515498061e-14,
 -1.430199388619999e-15,  2.533274518005422e-17, -4.264860216351958e-19,  6.144997434566693e-02, -6.172831185876296e-03,  3.593650246741536e-04, -1.555023434912645e-05,
  5.511957110229925e-07, -1.684186311903358e-08,  4.576008592593723e-10, -1.128783774785311e-11,  2.565496090329575e-13, -5.431724494559715e-15,  1.080397443867033e-16,
 -2.031816115379615e-18,  5.092970189122197e-02, -6.380806895260344e-03,  4.488029191450169e-04, -2.299689401023709e-05,  9.511913102424331e-07, -3.352624517554154e-08,
  1.040942910632046e-09, -2.911044963929263e-11,  7.449611542856195e-13, -1.765278085847176e-14,  3.908837070757498e-16, -8.143590198487396e-18,  4.155047635095777e-02,
 -6.311930553218883e-03,  5.262978997559283e-04, -3.145559461880246e-05,  1.498812030440050e-06, -6.025102414569088e-08,  2.115831819188316e-09, -6.644757687887522e-11,
  1.897753150439420e-12, -4.991213068907213e-14,  1.220639865499527e-15, -2.795988154291375e-17,  3.344377765729890e-02, -6.014185475984646e-03,  5.843143074263315e-04,
 -4.016869671927072e-05,  2.178584955957785e-06, -9.882528425622146e-08,  3.887454331403514e-09, -1.358857528429985e-10,  4.295422281409319e-12, -1.244135387149506e-13,
  3.335665990917536e-15, -8.341512380657941e-17,  2.661691377181208e-02, -5.549874633352094e-03,  6.184762649400072e-04, -4.826977236059972e-05,  2.946368955508582e-06,
 -1.493050814922646e-07,  6.518771986736161e-09, -2.514819100569669e-10,  8.729302917394086e-12, -2.763825074575283e-13,  8.066865070105767e-15, -2.187620441872756e-16,
  2.099031928243085e-02, -4.982828218274824e-03,  6.278017020948302e-04, -5.495150538457436e-05,  3.734713665661254e-06, -2.093877399452970e-07,  1.005797545649574e-08,
 -4.247614258749830e-10,  1.606771982188298e-11, -5.521352610926986e-13,  1.742514261125560e-14, -5.091514211616311e-16,  1.643282871110853e-02, -4.369442794232356e-03,
  6.141838174652784e-04, -5.960236211094602e-05,  4.464401054173506e-06, -2.743701500398883e-07,  1.437690671764414e-08, -6.594173782590299e-10,  2.698319416512396e-11,
 -9.993528210037398e-13,  3.387823431763751e-14, -1.059905931128821e-15,  1.279043451587901e-02, -3.753905883635365e-03,  5.814469497721577e-04, -6.188032505480001e-05,
  5.058416644822630e-06, -3.377341444812465e-07,  1.914589659741674e-08, -9.464089609490832e-10,  4.159011948506857e-11, -1.648853258151351e-12,  5.965428751072880e-14,
 -1.986030208270249e-15,  9.906917208357435e-03, -3.166923844097129e-03,  5.343128007118181e-04, -6.171821237033343e-05,  5.454249934628777e-06, -3.921939547474683e-07,
  2.385935246495917e-08, -1.261478502855057e-09,  5.911161411444750e-11, -2.491740931283821e-12,  9.559624422651320e-14, -3.366164641043088e-15,  7.636748964138493e-03,
 -2.626815696803006e-03,  4.775207854313546e-04, -5.927594949696530e-05,  5.611654600304510e-06, -4.308978998716223e-07,  2.790873678170256e-08, -1.566523424013606e-09,
  7.772301353513991e-11, -3.460317831187510e-12,  1.398856623479186e-13, -5.178315096871496e-15,  5.851739037330875e-03, -2.141834659215296e-03,  4.152215443520525e-04,
 -5.486482775993059e-05,  5.514944422383675e-06, -4.484683515481575e-07,  3.068384934528750e-08, -1.814996118997148e-09,  9.468271146649727e-11, -4.422700808975222e-12,
  1.872042346121382e-13, -7.241528191508424e-15,  4.443204492489683e-03, -1.712830934242599e-03,  3.506563143356842e-04, -4.886789188079198e-05,  5.170637551088343e-06,
 -4.416675434637533e-07,  3.167614760918852e-08, -1.960144937189947e-09,  1.067687890932358e-10, -5.197982536419095e-12,  2.289228725070886e-13, -9.197780808639814e-15,
  3.321299236968669e-03, -1.335695725726008e-03,  2.860696639542912e-04, -4.167339299896564e-05,  4.602245154249615e-06, -4.096258672464360e-07,  3.056068408755253e-08,
 -1.964037528995675e-09,  1.109319165292438e-10, -5.591747527849472e-12,  2.546142482162280e-13, -1.056168187081107e-14,  2.412772932174849e-03, -1.003315451999534e-03,
  2.227787481124164e-04, -3.362943846039901e-05,  3.844160973710620e-06, -3.536978884473403e-07,  2.724286908846052e-08, -1.805202346366699e-09,  1.049975173752756e-10,
 -5.443748088817468e-12,  2.546624335174481e-13, -1.084036068036208e-14,  1.658034402055726e-03, -7.069710024460749e-04,  1.613267368820306e-04, -2.502081526003765e-05,
  2.936197861698769e-06, -2.770823116130548e-07,  2.186750431098544e-08, -1.483283953326666e-09,  8.823139565911597e-11, -4.674079993272693e-12,  2.232240036950128e-13,
 -9.692014565783549e-15,  1.008074140789069e-03, -4.372470848494517e-04,  1.016692712575776e-04, -1.606507454552694e-05,  1.919716686273672e-06, -1.843556823313774e-07,
  1.479641700517657e-08, -1.020014682693419e-09,  6.162431482941896e-11, -3.313623589263498e-12,  1.605341134373016e-13, -7.066347452280940e-15,  4.220847272000726e-04,
 -1.848087473779420e-04,  4.342091805110040e-05, -6.932347273990425e-06,  8.367606149150465e-07, -8.114048569627337e-08,  6.573515748466033e-09, -4.572470802404580e-10,
  2.786420714635541e-11, -1.510773349720221e-12,  7.377714908728247e-14, -3.272358596940906e-15,  1.225710816605114e-01, -6.517508806679356e-04,  3.713639851161373e-06,
 -2.214631577083613e-08,  1.353736708674395e-10, -8.362188627896450e-13,  5.174992811404601e-15, -3.194000633830812e-17,  1.961515792947076e-19, -1.197569902807272e-21,
  7.266634326253741e-24, -4.382671278357800e-26,  1.176716013878866e-01, -1.016001608175511e-03,  1.015761989684446e-05, -9.861551951264111e-08,  9.128149468503701e-10,
 -8.113428943674608e-12,  6.977616477118038e-14, -5.838429961092225e-16,  4.771897531507584e-18, -3.820960806250567e-20,  3.004217429576026e-22, -2.323461450877915e-24,
  1.085041439854741e-01, -1.653746415918371e-03,  2.489327953750935e-05, -3.329710667853537e-07,  4.093821996423611e-09, -4.726010101597632e-11,  5.188510890286857e-13,
 -5.463576368022559e-15,  5.552159370690944e-17, -5.470194121737539e-19,  5.243941982207070e-21, -4.904938485546799e-23,  9.618899850938335e-02, -2.412698692924281e-03,
  5.005289066569270e-05, -8.790364458312209e-07,  1.381449755072618e-08, -1.997999448253997e-10,  2.705237369636278e-12, -3.468654633581092e-14,  4.246541336012109e-16,
 -4.994552486167991e-18,  5.670290301350339e-20, -6.236590577514836e-22,  8.209664761700512e-02, -3.125371522441748e-03,  8.593697202516000e-05, -1.926916573514399e-06,
  3.771177433977860e-08, -6.669452218199394e-10,  1.088698092714055e-11, -1.663741230104137e-13,  2.404384000720349e-15, -3.310696398856536e-17,  4.368588713372818e-19,
 -5.548699218442127e-21,  6.758668307933345e-02, -3.654490185385351e-03,  1.296766556456955e-04, -3.629694090167654e-06,  8.670462990752914e-08, -1.841125941295775e-09,
  3.562585395550002e-11, -6.386568885343782e-13,  1.073213845562996e-14, -1.705325404120262e-16,  2.579545481391999e-18, -3.733499693662960e-20,  5.379451144024713e-02,
 -3.922196457453190e-03,  1.754711251604512e-04, -6.014166623957671e-06,  1.724604124703171e-07, -4.331956227475408e-09,  9.801110501028325e-11, -2.034872304643579e-12,
  3.928258977162397e-14, -7.120687930308548e-16,  1.221177126809232e-17, -1.992780733070272e-19,  4.150888546468443e-02, -3.916592793270487e-03,  2.162363177469534e-04,
 -8.921911732405000e-06,  3.027056532313481e-07, -8.879158560740614e-09,  2.321456042490391e-10, -5.521168264672231e-12,  1.211907122291764e-13, -2.481712229096516e-15,
  4.780554569293622e-17, -8.717160926960648e-19,  3.114726633510436e-02, -3.678853711398179e-03,  2.457691160861624e-04, -1.201989349568859e-05,  4.762437430333822e-07,
 -1.612540815528824e-08,  4.820908821420613e-10, -1.300712982800663e-11,  3.216876438034335e-13, -7.377854345323928e-15,  1.583280768564959e-16, -3.200727197692121e-18,
  2.280696770033339e-02, -3.280099316176539e-03,  2.604165641739781e-04, -1.488321356101386e-05,  6.803670859327377e-07, -2.630991440448988e-08,  8.907695638849264e-10,
 -2.702234187764599e-11,  7.467362162090069e-13, -1.903084523751586e-14,  4.515835196903290e-16, -1.004879903947508e-17,  1.635659385470487e-02, -2.797920735251639e-03,
  2.596682890508604e-04, -1.711352333441467e-05,  8.924484959372804e-07, -3.902097567259459e-08,  1.482597608114440e-09, -5.014717040049711e-11,  1.536334554117664e-12,
 -4.318899308160371e-14,  1.125305885414397e-15, -2.737999425478034e-17,  1.153414049249654e-02, -2.299248551681990e-03,  2.456909594763147e-04, -1.844149070293660e-05,
  1.085356468536009e-06, -5.314669018135020e-08,  2.246519971874422e-09, -8.404680727337802e-11,  2.833421900074638e-12, -8.724517568135351e-14,  2.479491945051967e-15,
 -6.554681492147201e-17,  8.029136849729274e-03, -1.831826619031893e-03,  2.222405036491238e-04, -1.877630159881369e-05,  1.234409620351059e-06, -6.707431781446279e-08,
  3.127911593161244e-09, -1.284352258689410e-10,  4.730192176088137e-12, -1.584493599561125e-13,  4.880116180362110e-15, -1.393063970592078e-16,  5.539171688626892e-03,
 -1.423087624449971e-03,  1.934819685224372e-04, -1.819500685780565e-05,  1.323058561730410e-06, -7.906591656228817e-08,  4.034541417901454e-09, -1.804444748485495e-10,
  7.208689768950881e-12, -2.609405012143059e-13,  8.654537545109910e-15, -2.651617907499239e-16,  3.801160828729839e-03, -1.083614715796157e-03,  1.630936651018270e-04,
 -1.688991423169247e-05,  1.345451755465193e-06, -8.765925748089870e-08,  4.855233689160310e-09, -2.347585602179362e-10,  1.010174629645660e-11, -3.925286163313959e-13,
  1.393161628676448e-14, -4.553954451475990e-16,  2.603087330358045e-03, -8.123691269266717e-04,  1.337957796387182e-04, -1.510209083893047e-05,  1.305664685604271e-06,
 -9.194941998088985e-08,  5.484102588666737e-09, -2.845379903675217e-10,  1.309575856695231e-11, -5.426429511179497e-13,  2.048030577821132e-14, -7.099635344199654e-16,
  1.783328603523831e-03, -6.017138782111893e-04,  1.072558075135210e-04, -1.306428708186615e-05,  1.214659902157409e-06, -9.167919491882656e-08,  5.841533625608942e-09,
 -3.228117203220654e-10,  1.577978214669815e-11, -6.926259839393653e-13,  2.762235549484526e-14, -1.009364018129253e-15,  1.223680278194235e-03, -4.412673744792621e-04,
  8.423467864350957e-05, -1.096491670171424e-05,  1.086501112021807e-06, -8.715322608056104e-08,  5.885720160588730e-09, -3.438466210931954e-10,  1.772576389697121e-11,
 -8.186496144292089e-13,  3.427830775061996e-14, -1.312323446278016e-15,  8.402985448699043e-04, -3.203817943323477e-04,  6.483360866098852e-05, -8.933758866502775e-06,
  9.350640397990928e-07, -7.904703554462642e-08,  5.613294609515901e-09, -3.440828529921052e-10,  1.857344753205460e-11, -8.964585360294748e-13,  3.915577033606653e-14,
 -1.560858815575579e-15,  5.749662363415805e-04, -2.294573131875566e-04,  4.874193113598272e-05, -7.043661973088232e-06,  7.718742646734394e-07, -6.819332240274151e-08,
  5.051673381564537e-09, -3.224594258482497e-10,  1.809523276119425e-11, -9.064843579859053e-13,  4.103144863387158e-14, -1.692407153513127e-15,  3.877484810158462e-04,
 -1.604415810170790e-04,  3.543454414853881e-05, -5.320871760712919e-06,  6.051356010790237e-07, -5.540633895629591e-08,  4.247608810517999e-09, -2.802004579176778e-10,
  1.622768011375199e-11, -8.378942754760820e-13,  3.904319319985307e-14, -1.655729402192818e-15,  2.512867639670113e-04, -1.068411303769048e-04,  2.430472370588555e-05,
 -3.757925952447397e-06,  4.396790691902715e-07, -4.137244279017378e-08,  3.256138339439506e-09, -2.202813458871415e-10,  1.306992952909905e-11, -6.906974075966524e-13,
  3.290917777376010e-14, -1.425667149546321e-15,  1.465713295280904e-04, -6.348646910316286e-05,  1.473939689347035e-05, -2.325475978185512e-06,  2.774741387531396e-07,
 -2.660842571247878e-08,  2.132644406064924e-09, -1.468213967123769e-10,  8.858848959909719e-12, -4.757634605080198e-13,  2.302170989041268e-14, -1.012203266615712e-15,
  5.995124318169283e-05, -2.623456019127381e-05,  6.159898652807753e-06, -9.828252792373671e-07,  1.185558179065318e-07, -1.148923041333682e-08,  9.302280330514659e-10,
 -6.466776754094955e-11,  3.938543161490881e-12, -2.134257705597432e-13,  1.041680367120708e-14, -4.617910023083419e-16,  1.200218636166132e-01, -6.230691920468003e-04,
  3.460349087855275e-06, -2.010767566358806e-08,  1.198223556035720e-10, -7.220795131118436e-13,  4.362446444706968e-15, -2.630041876113399e-17,  1.578380714835877e-19,
 -9.420323214638837e-22,  5.589199549685595e-24, -3.296885853136575e-26,  1.137629570681215e-01, -9.392376759282302e-04,  9.056789295449232e-06, -8.522290412061240e-08,
  7.660525621115815e-10, -6.618909829088814e-12,  5.537502700744007e-14, -4.510177089598986e-16,  3.590124189191629e-18, -2.801008492915401e-20,  2.146723818300577e-22,
 -1.618994715213274e-24,  1.022636275506096e-01, -1.469536955216915e-03,  2.126149970327375e-05, -2.744035700237482e-07,  3.261718172463428e-09, -3.645951708379264e-11,
  3.880500724434936e-13, -3.965355946329867e-15,  3.913704675290336e-17, -3.747653150246154e-19,  3.493945595076955e-21, -3.180069179088359e-23,  8.727717458317753e-02,
 -2.050994084982050e-03,  4.070936392533364e-05, -6.867494201922038e-07,  1.039637046084588e-08, -1.451450987242891e-10,  1.900064229317069e-12, -2.358525693706340e-14,
  2.798338601050891e-16, -3.192633348869826e-18,  3.518823338758516e-20, -3.760062004939791e-22,  7.083695948377133e-02, -2.521038935222450e-03,  6.603612650670382e-05,
 -1.417483265382352e-06,  2.664907260269281e-08, -4.538566710002130e-10,  7.148031844120454e-12, -1.055565048537332e-13,  1.475993735956951e-15, -1.968628952491231e-17,
  2.518675525551758e-19, -3.104478103386233e-21,  5.479764353529300e-02, -2.770242868860091e-03,  9.336423397514551e-05, -2.495992109891206e-06,  5.716269104112565e-08,
 -1.166919536128651e-09,  2.175385338189076e-11, -3.763632052143068e-13,  6.112657611183002e-15, -9.399468005324305e-17,  1.377439969457516e-18, -1.933359990471221e-20,
  4.051467044211055e-02, -2.766039203426279e-03,  1.173648528702595e-04, -3.837196276372525e-06,  1.053734987360799e-07, -2.542057518017695e-09,  5.536390229189071e-11,
 -1.108544871843715e-12,  2.067144529994268e-14, -3.624471981625227e-16,  6.019771032086474e-18, -9.523916463023197e-20,  2.872486872912807e-02, -2.544379905274702e-03,
  1.332267497390563e-04, -5.242187087060283e-06,  1.702726099035443e-07, -4.795554654078706e-09,  1.206674774161741e-10, -2.767394463713706e-12,  5.867364278271601e-14,
 -1.162220852389805e-15,  2.168385143382896e-17, -3.834076877029979e-19,  1.960569275680062e-02, -2.181083232453630e-03,  1.383493279993028e-04, -6.457074840173755e-06,
  2.450471549279116e-07, -7.970092230149794e-09,  2.294194967439596e-10, -5.971543490071736e-12,  1.427181528923172e-13, -3.167814491203988e-15,  6.587886069201869e-17,
 -1.292170573376792e-18,  1.293880187191985e-02, -1.759650397090332e-03,  1.329298389852414e-04, -7.261069684799284e-06,  3.183289249536264e-07, -1.183768943411928e-08,
  3.862888021295240e-10, -1.131638807260435e-11,  3.024957003731539e-13, -7.468284112586351e-15,  1.719044306323879e-16, -3.715173430154738e-18,  8.296828152007257e-03,
 -1.348048810110193e-03,  1.193911161578590e-04, -7.537603847619869e-06,  3.777013358222366e-07, -1.590863467050273e-08,  5.835211225081405e-10, -1.908888577824157e-11,
  5.665329146748948e-13, -1.545055889605822e-14,  3.910542450676733e-16, -9.253745718702887e-18,  5.196811269209369e-03, -9.887808995234105e-04,  1.011879052331216e-04,
 -7.296997699195563e-06,  4.137113605278680e-07, -1.956005315629088e-08,  7.998865418133057e-10, -2.900097993762859e-11,  9.489435237577799e-13, -2.839905203538478e-14,
  7.854118388397970e-16, -2.022843614953723e-17,  3.197508865797248e-03, -6.998791617098087e-04,  8.164691059289424e-05, -6.650112845345913e-06,  4.224564695689934e-07,
 -2.222581605291213e-08,  1.005319150089239e-09, -4.010185248258326e-11,  1.436817641882320e-12, -4.688229412262914e-14,  1.408145482201987e-15, -3.924295782065561e-17,
  1.943862316620875e-03, -4.816687176806209e-04,  6.324659179084563e-05, -5.755952323281307e-06,  4.058356921008614e-07, -2.355702709835877e-08,  1.169393041784179e-09,
 -5.095096466810274e-11,  1.985442907458515e-12, -7.018359003915534e-14,  2.275568159710166e-15, -6.822518642405388e-17,  1.174447601519416e-03, -3.246369491099029e-04,
  4.740582775756887e-05, -4.770604374131596e-06,  3.698697830684472e-07, -2.348802435941848e-08,  1.269709862483576e-09, -5.999125092132429e-11,  2.525319450246452e-12,
 -9.609180250277216e-14,  3.342865886485066e-15, -1.072009817919808e-16,  7.091648449162446e-04, -2.157136855703840e-04,  3.463063354398299e-05, -3.814606089761328e-06,
  3.222410553115737e-07, -2.219996453995069e-08,  1.296712184374212e-09, -6.595634841047444e-11,  2.978754143416232e-12, -1.212228067153951e-13,  4.497009465178612e-15,
 -1.533485812057571e-16,  4.301049166067549e-04, -1.421520310377058e-04,  2.481253444106856e-05, -2.961940501099787e-06,  2.701480398238178e-07, -2.002092983657791e-08,
  1.253701214204419e-09, -6.814468364108180e-11,  3.278959579868378e-12, -1.417750716788700e-13,  5.573401693140102e-15, -2.008865955008899e-16,  2.630175921316767e-04,
 -9.333292912686807e-05,  1.752340290639289e-05, -2.244725329242772e-06,  2.190413249440321e-07, -1.731529914290581e-08,  1.153180685833960e-09, -6.648101385298091e-11,
  3.384071112370150e-12, -1.544130518094007e-13,  6.391324643849908e-15, -2.420069733304109e-16,  1.624691555054870e-04, -6.120891332516840e-05,  1.223227226768041e-05,
 -1.665132852365874e-06,  1.722585245804775e-07, -1.440049073577221e-08,  1.011775810022774e-09, -6.139267052991019e-11,  3.281964443567384e-12, -1.569454442232638e-13,
  6.794691223216115e-15, -2.685773834393297e-16,  1.011986554441510e-04, -4.004954010254372e-05,  8.432019261964472e-06, -1.207940420049087e-06,  1.312670246395256e-07,
 -1.150452965145970e-08,  8.457360560493218e-10, -5.359153920772843e-11,  2.986405815582561e-12, -1.486082618474368e-13,  6.683819137674063e-15, -2.740089018003805e-16,
  6.302387434382196e-05, -2.593709420750523e-05,  5.695078762673110e-06, -8.502910828712744e-07,  9.616942949297871e-08, -8.758730422238767e-09,  6.680701557854675e-10,
 -4.385690559529701e-11,  2.528185393508035e-12, -1.299608062513168e-13,  6.030067013366913e-15, -2.546848149618923e-16,  3.834470433839528e-05, -1.625258397003186e-05,
  3.684701161038511e-06, -5.678134810054778e-07,  6.621946961052650e-08, -6.211654076510381e-09,  4.874162585604519e-10, -3.287984341122461e-11,  1.945503309869329e-12,
 -1.025422540467710e-13,  4.873440119639719e-15, -2.106144327219434e-16,  2.138389287154138e-05, -9.248375193538061e-06,  2.143603635709799e-06, -3.376460464258923e-07,
  4.022320888623690e-08, -3.851245655606486e-09,  3.082142441716131e-10, -2.118848849563656e-11,  1.276696726507298e-12, -6.847371918788828e-14,  3.309134368720515e-15,
 -1.453150848511141e-16,  8.527296105975505e-06, -3.729270099652474e-06,  8.750433869408191e-07, -1.395200536740582e-07,  1.681869177855491e-08, -1.628830893884203e-09,
  1.317945739204578e-10, -9.156436592859071e-12,  5.573296415609891e-13, -3.018342490289566e-14,  1.472340527830758e-15, -6.523472693858059e-17,  1.175834688603069e-01,
 -5.963200379000080e-04,  3.230101120271241e-06, -1.830060256423550e-08,  1.063709252430637e-10, -6.256768571349216e-13,  3.691939859774794e-15, -2.175174462267338e-17,
  1.276229383003383e-19, -7.449417952273093e-22,  4.323611335552866e-24, -2.495411541274799e-26,  1.101447195183644e-01, -8.706753066793062e-04,  8.103509721044407e-06,
 -7.395695117045794e-08,  6.460048074923433e-10, -5.429344989866242e-12,  4.421437199433314e-14, -3.507400720129317e-16,  2.720592107027290e-18, -2.069306150065569e-20,
  1.546731468273432e-22, -1.138068179649850e-24,  9.670599241302089e-02, -1.311781450119586e-03,  1.825926030183346e-05, -2.275789394834778e-07,  2.617348219607192e-09,
 -2.834872082577210e-11,  2.927028282042304e-13, -2.904377069500267e-15,  2.785722084762712e-17, -2.594094518776507e-19,  2.353313910668472e-21, -2.085312913495557e-23,
  7.967607544668397e-02, -1.755660901434962e-03,  3.337808009084309e-05, -5.413606223113927e-07,  7.900804370735693e-09, -1.065535562548102e-10,  1.349528424445264e-12,
 -1.622721336713055e-14,  1.867004671894112e-16, -2.067396791710980e-18,  2.213305331266516e-20, -2.298858354002609e-22,  6.171104738695077e-02, -2.054174502392326e-03,
  5.131275457450260e-05, -1.055310765948925e-06,  1.907310263165986e-08, -3.130251087081057e-10,  4.759608740659622e-12, -6.795847557026656e-14,  9.199427090290266e-16,
 -1.189117464893357e-17,  1.475797296591865e-19, -1.766053302140658e-21,  4.504062860916371e-02, -2.129194087294487e-03,  6.821275528366156e-05, -1.742951077475625e-06,
  3.829386160656250e-08, -7.519656514440588e-10,  1.351261427963656e-11, -2.257319817707833e-13,  3.545013736411620e-15, -5.277475631442772e-17,  7.495465955790299e-19,
 -1.020616917487932e-20,  3.107262638282385e-02, -1.986086517581904e-03,  7.996454759409337e-05, -2.495103077909530e-06,  6.564610854808087e-08, -1.521624510117815e-09,
  3.191311067123685e-11, -6.164761510624842e-13,  1.110787116925776e-14, -1.884458787348292e-16,  3.031925962938008e-18, -4.651745605944985e-20,  2.033749018495795e-02,
 -1.690260537856094e-03,  8.394753880119661e-05, -3.150734418996779e-06,  9.799712898435330e-08, -2.650617758136979e-09,  6.420241357137772e-11, -1.420117421023654e-12,
  2.908725621325743e-14, -5.574115002194124e-16,  1.007395468472947e-17, -1.727423003050495e-19,  1.268448162525745e-02, -1.327994999497975e-03,  7.996216078162610e-05,
 -3.561127063971080e-06,  1.294408178090018e-07, -4.044006063427191e-09,  1.120791168060461e-10, -2.814366859091735e-12,  6.499889682792367e-14, -1.396240439726310e-15,
  2.813774690296145e-17, -5.354576854318314e-19,  7.577305975910764e-03, -9.733429267771128e-04,  6.992229051329070e-05, -3.648940838747044e-06,  1.533680744032654e-07,
 -5.483096537764548e-09,  1.724120754401597e-10, -4.876468589379356e-12,  1.260640486234282e-13, -3.014479426306440e-15,  6.729357641987006e-17, -1.412177420997339e-18,
  4.360471267784578e-03, -6.720001703237503e-04,  5.674398846500978e-05, -3.429381958372200e-06,  1.650243215580193e-07, -6.692351795519126e-09,  2.368637172210347e-10,
 -7.490917569645634e-12,  2.152812584301738e-13, -5.693580997353700e-15,  1.399288287770836e-16, -3.219159497222636e-18,  2.432910063497792e-03, -4.411150171660325e-04,
  4.318087370720292e-05, -2.988794206263901e-06,  1.631039116103557e-07, -7.440171748647221e-09,  2.941511662242467e-10, -1.032889123396711e-11,  3.278387584993927e-13,
 -9.530390189346877e-15,  2.563540400195391e-16, -6.429132914396051e-18,  1.325417042607562e-03, -2.778423475164028e-04,  3.112372037342286e-05, -2.441026655910713e-06,
  1.496852745793117e-07, -7.617755600878557e-09,  3.339239406820944e-10, -1.292976805498211e-11,  4.503426311499177e-13, -1.430326735344035e-14,  4.186746418736377e-16,
 -1.138360516070036e-17,  7.103782032304192e-04, -1.694652624671755e-04,  2.145818861080196e-05, -1.887419566503437e-06,  1.288825856479757e-07, -7.258656352673700e-09,
  3.501860794614550e-10, -1.485011302800319e-11,  5.639590909762466e-13, -1.945180222175920e-14,  6.160623333026914e-16, -1.806097797313067e-17,  3.775351616952138e-04,
 -1.010065152484093e-04,  1.428825237390013e-05, -1.395304697243943e-06,  1.051554520856356e-07, -6.501210681516779e-09,  3.426344922887507e-10, -1.580339127010306e-11,
  6.501622696035153e-13, -2.420466883469420e-14,  8.246433875996721e-16, -2.592317635008672e-17,  2.005425785364459e-04, -5.935681855265364e-05,  9.274433344533075e-06,
 -9.955701038117749e-07,  8.207097418734499e-08, -5.524668249415972e-09,  3.156881610832330e-10, -1.572554619884548e-11,  6.962316855379430e-13, -2.780193949745108e-14,
  1.012879595636011e-15, -3.394805698794845e-17,  1.072872863452519e-04, -3.468097220708898e-05,  5.919511107669632e-06, -6.916206597732530e-07,  6.180566479140688e-08,
 -4.492536692635931e-09,  2.761858728704622e-10, -1.475126181987963e-11,  6.980470894966761e-13, -2.970543378872482e-14,  1.150154796384454e-15, -4.085924557133074e-17,
  5.819610519549056e-05, -2.029572248321197e-05,  3.743246444517111e-06, -4.713291625125757e-07,  4.524382632620554e-08, -3.521099652879398e-09,  2.310406901116456e-10,
 -1.313227262432163e-11,  6.595101405120672e-13, -2.970814575515147e-14,  1.214630962496639e-15, -4.545590833223507e-17,  3.216179140127624e-05, -1.196055103359443e-05,
  2.358121210659774e-06, -3.168121070304083e-07,  3.236454897173353e-08, -2.673335079919192e-09,  1.856914465840428e-10, -1.114520104536941e-11,  5.896416320888216e-13,
 -2.791849206622696e-14,  1.197279843954548e-15, -4.689960517583043e-17,  1.813198723061996e-05, -7.110585422751567e-06,  1.482659233322377e-06, -2.104054426534294e-07,
  2.265844934606589e-08, -1.968699975047125e-09,  1.435332286401615e-10, -9.023704118733133e-12,  4.990732891338677e-13, -2.465657601581795e-14,  1.101356694996772e-15,
 -4.485592082689483e-17,  1.037016638804273e-05, -4.242618551098625e-06,  9.256671480171841e-07, -1.373462775492954e-07,  1.544112813505279e-08, -1.398250486077671e-09,
  1.060662043980388e-10, -6.926439092744791e-12,  3.972824021287133e-13, -2.032438709222093e-14,  9.387135899076591e-16, -3.947401012891618e-17,  5.894610499853988e-06,
 -2.489975362876645e-06,  5.624316123479627e-07, -8.635552766123926e-08,  1.003551467874000e-08, -9.381900667152771e-10,  7.337942044875927e-11, -4.934627950147879e-12,
  2.911149416520891e-13, -1.530023410284059e-14,  7.251798484652278e-16, -3.125832726773107e-17,  3.131328134095079e-06, -1.352062738357532e-06,  3.128204080454551e-07,
 -4.918553396678201e-08,  5.849239982021499e-09, -5.591098711462635e-10,  4.467339739532239e-11, -3.066361737217518e-12,  1.844863584793001e-13, -9.880489804586126e-15,
  4.768379889486182e-16, -2.091189521046282e-17,  1.214725440202263e-06, -5.308968801362764e-07,  1.244809520360171e-07, -1.983332309529754e-08,  2.389141895866384e-09,
 -2.312192650621126e-10,  1.869613745391389e-11, -1.298061824545389e-12,  7.895936149937831e-14, -4.273566604819813e-15,  2.083379195539553e-16, -9.225397667668103e-18,
  1.152485191116009e-01, -5.713296457153852e-04,  3.020307599862701e-06, -1.669416084791800e-08,  9.469640475542265e-11, -5.439410395706574e-13,  3.136260563575459e-15,
 -1.806555130439776e-17,  1.036707807847040e-19, -5.920762955866451e-22,  3.362967971022866e-24, -1.899969359641683e-26,  1.067862913567979e-01, -8.092293431676564e-04,
  7.274637446520529e-06, -6.443508437703430e-08,  5.472819479883220e-10, -4.476859010776243e-12,  3.550846275642723e-14, -2.744976446812844e-16,  2.075924453525355e-18,
 -1.540117893315559e-20,  1.123285646922516e-22, -8.067505091366770e-25,  9.173466999353259e-02, -1.175959978639062e-03,  1.576203326318482e-05, -1.898814206700077e-07,
  2.114521563381852e-09, -2.220701317303104e-11,  2.225762168340872e-13, -2.145851004871552e-15,  2.001305633681973e-17, -1.813330903049400e-19,  1.601539027566102e-21,
 -1.382356044910259e-23,  7.314917161299868e-02, -1.512623800510411e-03,  2.757521023218735e-05, -4.303796977906674e-07,  6.060034749504743e-09, -7.900522587626396e-11,
  9.687320693201405e-13, -1.129073416573511e-14,  1.260424014586686e-16, -1.355383620710980e-18,  1.410178586088304e-20, -1.424401918814070e-22,  5.424189374965938e-02,
 -1.689577958780947e-03,  4.029191728481147e-05, -7.946104219036278e-07,  1.381642719921178e-08, -2.186603168346680e-10,  3.211871156792487e-12, -4.436662033444887e-14,
  5.817362888948623e-16, -7.291130035657447e-18,  8.782075567468188e-20, -1.020773769036416e-21,  3.749612219435352e-02, -1.657776079977964e-03,  5.052897118942023e-05,
 -1.234882301457577e-06,  2.604510459993480e-08, -4.922585389141346e-10,  8.531340323018873e-12, -1.376802955364968e-13,  2.091704099023921e-15, -3.015996049333220e-17,
  4.153173216297306e-19, -5.488198359201639e-21,  2.424055225364461e-02, -1.450348302399357e-03,  5.544140969940870e-05, -1.651829568175468e-06,  4.165833738050191e-08,
 -9.282008479281256e-10,  1.875447757693185e-11, -3.496541883949338e-13,  6.089792228155937e-15, -9.999530282508555e-17,  1.558963217840967e-18, -2.320124560704704e-20,
  1.471308349631059e-02, -1.146805460431815e-03,  5.403538045781990e-05, -1.934999275809228e-06,  5.764648417579137e-08, -1.497829500986155e-09,  3.493229828744434e-11,
 -7.454014411999957e-13,  1.475243088621876e-14, -2.735540202712064e-16,  4.789752621205274e-18, -7.966114760247697e-20,  8.423903814411403e-03, -8.293389648076020e-04,
  4.739514505570764e-05, -2.014054672644586e-06,  7.011931488803722e-08, -2.104383534344052e-09,  5.615701048100444e-11, -1.360433118269625e-12,  3.036324797769752e-14,
 -6.312248395294616e-16,  1.232702774839647e-17, -2.275897303672395e-19,  4.574870585293021e-03, -5.544724136687199e-04,  3.785818141141739e-05, -1.886867570832587e-06,
  7.601466476282635e-08, -2.612176944391395e-09,  7.913433136258224e-11, -2.160595046569164e-12,  5.400874278110053e-14, -1.250647833403933e-15,  2.707202568264287e-17,
 -5.515529977381731e-19,  2.371854385074664e-03, -3.462422152443582e-04,  2.785154157281153e-05, -1.610301249768882e-06,  7.437601662184063e-08, -2.902795262494911e-09,
  9.909623341502322e-11, -3.028608592826949e-12,  8.425316440295749e-14, -2.160113297442286e-15,  5.153255974819843e-17, -1.152201726973873e-18,  1.182550099820541e-03,
 -2.039967041516513e-04,  1.908032782617489e-05, -1.266449218712877e-06,  6.647175343594258e-08, -2.923514507373336e-09,  1.116739443806468e-10, -3.795618813091570e-12,
  1.167968478389378e-13, -3.296419504068520e-15,  8.619669346011575e-17, -2.103970411984698e-18,  5.716611615848999e-04, -1.145677370206044e-04,  1.230683609740289e-05,
 -9.283850411109061e-07,  5.489825866776011e-08, -2.700176786671668e-09,  1.146126351039456e-10, -4.304557676825579e-12,  1.456416854849725e-13, -4.499544254823947e-15,
  1.282718973721760e-16, -3.400583253215593e-18,  2.703789826946720e-04, -6.198348419910001e-05,  7.557181189512010e-06, -6.416026796064848e-07,  4.238203127308855e-08,
 -2.313547856637709e-09,  1.083683473507580e-10, -4.468684634695303e-12,  1.652499828131062e-13, -5.556977061849363e-15,  1.717836370059740e-16, -4.920877357446241e-18,
  1.263443839497747e-04, -3.265704339027045e-05,  4.468050303090553e-06, -4.228144129717210e-07,  3.093511465504920e-08, -1.859845083292314e-09,  9.546131459773070e-11,
 -4.293863611623487e-12,  1.724863577915795e-13, -6.277026511578458e-15,  2.092615827569872e-16, -6.443253054319397e-18,  5.892849109956155e-05, -1.694178007248092e-05,
  2.572347531667307e-06, -2.687169050021567e-07,  2.158926031864259e-08, -1.418343540349138e-09,  7.919770113137858e-11, -3.859613530087637e-12,  1.673547985263822e-13,
 -6.551353923274555e-15,  2.341951805954494e-16, -7.708609022374546e-18,  2.771737300182920e-05, -8.749135399792717e-06,  1.458129405230762e-06, -1.665204448309914e-07,
  1.456198191500135e-08, -1.036958612292628e-09,  6.251750153984918e-11, -3.277773289221986e-12,  1.523953705749811e-13, -6.377043409600661e-15,  2.429794805969099e-16,
 -8.500728838748501e-18,  1.327594048667024e-05, -4.544014054676584e-06,  8.221963487333946e-07, -1.016374084475631e-07,  9.586687145296731e-09, -7.337418924595532e-10,
  4.738777686849985e-11, -2.653170712259230e-12,  1.313428376593831e-13, -5.835944826383444e-15,  2.355062458737291e-16, -8.704343325330218e-18,  6.528340224388607e-06,
 -2.393867374303993e-06,  4.651203333515233e-07, -6.160983158374807e-08,  6.209218157661566e-09, -5.063109472885653e-10,  3.473925702911266e-11, -2.060797393754644e-12,
  1.078184958179604e-13, -5.051019857611793e-15,  2.144248722121449e-16, -8.318555569394785e-18,  3.311556782818437e-06, -1.285793105261653e-06,  2.653061372794478e-07,
 -3.726663377565804e-08,  3.974035408900377e-09, -3.420673724672466e-10,  2.471746485022921e-11, -1.540764942566527e-12,  8.452539120065603e-14, -4.143702466616053e-15,
  1.837253282632983e-16, -7.430138880586860e-18,  1.729147479085826e-06, -7.028644201698414e-07,  1.522950062690438e-07, -2.244410805724270e-08,  2.506860883729324e-09,
 -2.255920213788808e-10,  1.701080169901335e-11, -1.104546794155186e-12,  6.301032495225049e-14, -3.206818091205661e-15,  1.473787698185543e-16, -6.168197615482006e-18,
  9.134797676287126e-07, -3.844344205144283e-07,  8.648570572803796e-08, -1.322631784226683e-08,  1.531165194819408e-09, -1.426179277818278e-10,  1.111543758720838e-11,
 -7.449756587315266e-13,  4.380778251833288e-14, -2.295327653951964e-15,  1.084700582211428e-16, -4.662355982736369e-18,  4.603738447237424e-07, -1.984289467531257e-07,
  4.581991257018411e-08, -7.190435274355385e-09,  8.534942883627082e-10, -8.143499694179406e-11,  6.495399907162019e-12, -4.450953749924512e-13,  2.673594536747140e-14,
 -1.429680427618616e-15,  6.889487562927085e-17, -3.017115146479646e-18,  1.733170767632117e-07, -7.569616233482448e-08,  1.773506215773175e-08, -2.823516099135090e-09,
  3.398660135930311e-10, -3.286767877607394e-11,  2.655736671743716e-12, -1.842576707874039e-13,  1.120056043586051e-14, -6.058165512595880e-16,  2.951493494593455e-17,
 -1.306141551968078e-18,  1.130102919999350e-01, -5.479435482623783e-04,  2.828722316804612e-06, -1.526212473745144e-08,  8.453117090803444e-11, -4.743847432457557e-13,
  2.673841371555827e-15, -1.506470943155572e-17,  8.458885417880614e-20, -4.728734025115527e-22,  2.629550758810597e-24, -1.454846709860621e-26,  1.036610726652561e-01,
 -7.539827834009897e-04,  6.551143932947265e-06, -5.635105205131750e-08,  4.656809667058636e-10, -3.709863505903866e-12,  2.867499458940286e-14, -2.161368544779454e-16,
  1.594487384724392e-18, -1.154414068555943e-20,  8.219664194922259e-23, -5.765053197019290e-25,  8.726936135430728e-02, -1.058434836244173e-03,  1.367268097455537e-05,
 -1.593311580389719e-07,  1.719282729624866e-09, -1.751944025763394e-11,  1.705585767542022e-13, -1.598615015587973e-15,  1.450538810099034e-17, -1.279500820964408e-19,
  1.100753308738892e-21, -9.259284952056503e-24,  6.750934936956615e-02, -1.311144397777908e-03,  2.294409052721780e-05, -3.448965807439785e-07,  4.688995960486111e-09,
 -5.913504992781800e-11,  7.024337387643353e-13, -7.940382274048684e-15,  8.605473102364122e-17, -8.991250961727487e-19,  9.095936981773414e-21, -8.939307581535963e-23,
  4.807276140319344e-02, -1.401932958609950e-03,  3.195115107885841e-05, -6.047323663784766e-07,  1.012337050275893e-08, -1.545993369888530e-10,  2.195132784234102e-12,
 -2.935179174118172e-14,  3.729840973913142e-16, -4.535054264697258e-18,  5.303848167876148e-20, -5.990633016005458e-22,  3.158872891397760e-02, -1.306416344029301e-03,
  3.791857966533229e-05, -8.869835734840688e-07,  1.797041183143342e-08, -3.271026517750099e-10,  5.470537474437915e-12, -8.533087632104212e-14,  1.254708920900496e-15,
 -1.753016419208648e-17,  2.341474386708764e-19, -3.003931139844561e-21,  1.921500099240081e-02, -1.076040806744497e-03,  3.907703500411171e-05, -1.112323731052599e-06,
  2.690349202324294e-08, -5.764972004224300e-10,  1.122669242507657e-11, -2.020910077888787e-13,  3.403459112674897e-15, -5.410864158922214e-17,  8.176792217021739e-19,
 -1.180757962791473e-20,  1.086283644485594e-02, -7.937349940462666e-04,  3.549112869261000e-05, -1.212997800008644e-06,  3.462447489972008e-08, -8.644938924579794e-10,
  1.941827629807457e-11, -3.998312454995040e-13,  7.647988519400840e-15, -1.372540635198472e-16,  2.328753818345609e-18, -3.757204112205691e-20,  5.735040222966017e-03,
 -5.305599943667054e-04,  2.877509879768722e-05, -1.166833236574811e-06,  3.891318366967701e-08, -1.121951375440161e-09,  2.883109332778993e-11, -6.738900254092735e-13,
  1.453575857519884e-14, -2.924697214277769e-16,  5.535027496130316e-18, -9.914827895736828e-20,  2.843999786788813e-03, -3.248901976854567e-04,  2.107463128817930e-05,
 -1.002913090600294e-06,  3.871977209450272e-08, -1.278775477897269e-09,  3.731872235849906e-11, -9.834637050417497e-13,  2.376876382964695e-14, -5.329406797631192e-16,
  1.118505838597932e-17, -2.212084318891147e-19,  1.333776696374869e-03, -1.841904720065304e-04,  1.410341710560870e-05, -7.796597011558777e-07,  3.454879857668626e-08,
 -1.297193250980920e-09,  4.269907163262297e-11, -1.260713294937858e-12,  3.393908930098175e-14, -8.432853551657433e-16,  1.952265084064725e-17, -4.241052656413453e-19,
  5.962696134335927e-04, -9.771375415607552e-05,  8.723323775329826e-06, -5.547784401930055e-07,  2.798625451837821e-08, -1.186023797227728e-09,  4.374762525023450e-11,
 -1.438486204383614e-12,  4.289254393334711e-14, -1.174760594219976e-15,  2.984824522622013e-17, -7.087820477406425e-19,  2.564262641506119e-04, -4.904717781968069e-05,
  5.045717352195306e-06, -3.657098420370502e-07,  2.083454651323572e-08, -9.895529395599989e-10,  4.064113166172326e-11, -1.479465572358254e-12,  4.859319148350984e-14,
 -1.459392789496701e-15,  4.049414049792483e-17, -1.046111643266123e-18,  1.071792370662277e-04, -2.356809098415585e-05,  2.762707478285681e-06, -2.261099722873821e-07,
  1.443230961741961e-08, -7.628239210291295e-10,  3.465948697578095e-11, -1.388565838475131e-12,  4.995922877266239e-14, -1.636668042404176e-15,  4.934704182962844e-17,
 -1.380253137219304e-18,  4.403947187874403e-05, -1.097678105396990e-05,  1.450232206933245e-06, -1.328019276616721e-07,  9.421064841717100e-09, -5.501604042685871e-10,
  2.747218990755350e-11, -1.203888645431154e-12,  4.717637022938166e-14, -1.676735296830218e-15,  5.465209580334916e-17, -1.646915667300027e-18,  1.801031560739864e-05,
 -5.020313291121210e-06,  7.395317762935171e-07, -7.507171829273127e-08,  5.870480711021493e-09, -3.759407791320886e-10,  2.049002444965127e-11, -9.758933857620432e-13,
  4.140143627330742e-14, -1.587363049027742e-15,  5.562946447438833e-17, -1.796720291807695e-18,  7.426206772193979e-06, -2.285162820779335e-06,  3.712921238909181e-07,
 -4.138721416243984e-08,  3.537124637498422e-09, -2.464614919122542e-10,  1.455577890566601e-11, -7.483574805331362e-13,  3.415177044180680e-14, -1.403961780323736e-15,
  5.259626981359673e-17, -1.810645176719764e-18,  3.127344383337119e-06, -1.048997491046510e-06,  1.859511944522475e-07, -2.253825169879637e-08,  2.086395597133746e-09,
 -1.568716453404997e-10,  9.961602093258395e-12, -5.488484098696083e-13,  2.675809714844338e-14, -1.171750899058920e-15,  4.663306949462212e-17, -1.700901568749270e-18,
  1.360966039120987e-06, -4.914832908352032e-07,  9.399736687750826e-08, -1.226230480595206e-08,  1.217957141459520e-09, -9.794711954356055e-11,  6.632365389227159e-12,
 -3.885389293934019e-13,  2.008650274534538e-14, -9.303487998113800e-16,  3.906842045176181e-17, -1.500052169911355e-18,  6.173789604510113e-07, -2.371243347647946e-07,
  4.837242125359189e-08, -6.719752527829725e-09,  7.090074387835949e-10, -6.041298457879482e-11,  4.323454273234239e-12, -2.670365663393977e-13,  1.452168793196724e-14,
 -7.059780785793748e-16,  3.105353776147948e-17, -1.246358471910160e-18,  2.924978411748048e-07, -1.180555756469850e-07,  2.538744359589016e-08, -3.713871188902550e-09,
  4.118805576823190e-10, -3.681437972491169e-11,  2.758076484659653e-12, -1.779850480654214e-13,  1.009375617962436e-14, -5.108275468072053e-16,  2.335094785997584e-17,
 -9.723163684033754e-19,  1.428057866941007e-07, -5.985450982249927e-08,  1.340610067784207e-08, -2.041328665898439e-09,  2.353309924791914e-10, -2.183181298010759e-11,
  1.695028096434471e-12, -1.131881594195747e-13,  6.632687894214202e-15, -3.463615751954507e-16,  1.631569158091816e-17, -6.991585505683822e-19,  6.798047088759622e-08,
 -2.924379585935249e-08,  6.738418214141351e-09, -1.055221181794275e-09,  1.249975982904623e-10, -1.190303795126352e-11,  9.476153903472677e-13, -6.481745303850171e-14,
  3.886683012224603e-15, -2.074903441574917e-16,  9.982754427461692e-18, -4.365053131286019e-19,  2.477126005660452e-08, -1.081085404721824e-08,  2.530824427997946e-09,
 -4.025890191439288e-10,  4.842042500891849e-11, -4.678948055657297e-12,  3.777742343055188e-13, -2.619092975287620e-14,  1.590936397230045e-15, -8.599067331894093e-17,
  4.186569389361281e-18, -1.851494942497268e-19,  1.108626489794698e-01, -5.260240583392247e-04,  2.653389633696146e-06, -1.398217898027115e-08,  7.565254780574677e-11,
 -4.149834530848258e-13,  2.287503920511859e-15, -1.261112865549280e-17,  6.931414335434092e-20, -3.794397137906269e-22,  2.066480514681680e-24, -1.120112300666625e-26,
  1.007458488355942e-01, -7.041572230815309e-04,  5.917303911655300e-06, -4.945830114831347e-08,  3.979037439984239e-10, -3.088882439028992e-12,  2.327926857111298e-14,
 -1.711745662328781e-16,  1.232444596654412e-18, -8.711955587766564e-21,  6.058530188121577e-23, -4.151590831295807e-25,  8.324290256494750e-02, -9.562588956130443e-04,
  1.191487640425802e-05, -1.344176632472727e-07,  1.406456386010878e-09, -1.391468849783836e-11,  1.316595722069238e-13, -1.200380813479945e-15,  1.060257274368345e-17,
 -9.109512035860612e-20,  7.637473323425251e-22, -6.263979452622730e-24,  6.260735421892809e-02, -1.142955590607961e-03,  1.921921926041260e-05, -2.784886336368456e-07,
  3.658360112307681e-09, -4.466101065759335e-11,  5.142488793896322e-13, -5.641332954708139e-15,  5.938739017459929e-17, -6.032080674295660e-19,  5.936446112030866e-21,
 -5.679204120760368e-23,  4.293388772823777e-02, -1.172815035647482e-03,  2.557273389834764e-05, -4.648888409942827e-07,  7.498025424190851e-09, -1.105670382168553e-10,
  1.518481511632065e-12, -1.966553870525107e-14,  2.423139213871585e-16, -2.859637338874974e-18,  3.248854940460710e-20, -3.567420846173221e-22,  2.690864901571044e-02,
 -1.041209541546806e-03,  2.880511788328782e-05, -6.453974316975858e-07,  1.256894718203805e-08, -2.204682634527139e-10,  3.560040320511666e-12, -5.370015143104222e-14,
  7.645877464170910e-16, -1.035560180769010e-17,  1.342186001144714e-19, -1.672368680247256e-21,  1.546081851129454e-02, -8.102882053583931e-04,  2.797404889748804e-05,
 -7.611913130532088e-07,  1.766632557876572e-08, -3.642492678245261e-10,  6.839791642946065e-12, -1.189272966662370e-13,  1.937459560129851e-15, -2.983337474091939e-17,
  4.371409557595506e-19, -6.126794657853668e-21,  8.175316425414867e-03, -5.597785831258147e-04,  2.376124286696980e-05, -7.753653773111807e-07,  2.121382437257633e-08,
 -5.091381921079605e-10,  1.101807940521421e-11, -2.189782049198964e-13,  4.049330915305691e-15, -7.034995331166577e-17,  1.156870166807106e-18, -1.810997386158143e-20,
  3.997489734957132e-03, -3.472723237290342e-04,  1.787456288779526e-05, -6.917196755483208e-07,  2.210054884236080e-08, -6.122595580344559e-10,  1.515278309760371e-11,
 -3.417677248642818e-13,  7.125357664895227e-15, -1.387712450797761e-16,  2.545294892959678e-18, -4.423870894453502e-20,  1.818065665907334e-03, -1.955696798033016e-04,
  1.204811462931276e-05, -5.473535456735815e-07,  2.024911618281471e-08, -6.426767238094782e-10,  1.806630007282409e-11, -4.595143687004202e-13,  1.073689963735349e-14,
 -2.330901639561858e-16,  4.742695430339504e-18, -9.104367259992814e-20,  7.744749185733752e-04, -1.010512376540004e-04,  7.360230800471089e-06, -3.888569988881321e-07,
  1.652569462211734e-08, -5.967388049019294e-10,  1.893433062629783e-11, -5.399420092183208e-13,  1.406254844961251e-14, -3.385458148812472e-16,  7.603909982083448e-18,
 -1.604560322650613e-19,  3.115902289597260e-04, -4.843457011144470e-05,  4.123027616061628e-06, -2.510493281904734e-07,  1.216424183304048e-08, -4.964476072820756e-10,
  1.767383957310050e-11, -5.619532653800232e-13,  1.622977998311332e-14, -4.311747667326983e-16,  1.064062407285349e-17, -2.457158380390839e-19,  1.195540398521365e-04,
 -2.178727664314264e-05,  2.143840495696776e-06, -1.491401042007969e-07,  8.178561535701712e-09, -3.748116384922350e-10,  1.488386993321441e-11, -5.248192013983451e-13,
  1.672331872416180e-14, -4.879501556776192e-16,  1.317060235034489e-17, -3.313731487065547e-19,  4.424229313180178e-05, -9.314476715612138e-06,  1.048242040962233e-06,
 -8.260144155011927e-08,  5.088990343946533e-09, -2.601870338046483e-10,  1.145687616889362e-11, -4.455679808655086e-13,  1.558508458437038e-14, -4.970251291785302e-16,
  1.460589280462353e-17, -3.986276076686468e-19,  1.599446913776816e-05, -3.836915783251713e-06,  4.887354052653757e-07, -4.324862391940997e-08,  2.971131282668427e-09,
 -1.683387695449031e-10,  8.169365030364617e-12, -3.484428073703984e-13,  1.330776751360119e-14, -4.615424616915038e-16,  1.469620890663908e-17, -4.330915339651208e-19,
  5.730152245335345e-06, -1.545714196142202e-06,  2.205447077458264e-07, -2.172371465449930e-08,  1.651236696464085e-09, -1.029504349232912e-10,  5.470829153116510e-12,
 -2.543808867322364e-13,  1.054840801217857e-14, -3.957406757266394e-16,  1.358429876146769e-17, -4.301555167894830e-19,  2.066092122609412e-06, -6.186788609269138e-07,
  9.784431300868968e-08, -1.063000352825547e-08,  8.866866352486589e-10, -6.037987420505186e-11,  3.489216075279330e-12, -1.757249028060315e-13,  7.863435732229176e-15,
 -3.172761430835069e-16,  1.167608460101428e-17, -3.951831157465929e-19,  7.619092806596410e-07, -2.500591934405176e-07,  4.336280614636520e-08, -5.146276411826468e-09,
  4.669674689551050e-10, -3.445099718601170e-11,  2.148703560454926e-12, -1.163810419119667e-13,  5.582534561753817e-15, -2.407106710631011e-16,  9.439555733815081e-18,
 -3.394988137253609e-19,  2.918686177779407e-07, -1.036684808643504e-07,  1.949164424124140e-08, -2.501298364528865e-09,  2.445806231472653e-10, -1.937832861974454e-11,
  1.293750580625540e-12, -7.477864585842741e-14,  3.816735509571342e-15, -1.746397736329899e-16,  7.249037690913822e-18, -2.752706156129394e-19,  1.176685671746614e-07,
 -4.466198498240751e-08,  8.998596974343047e-09, -1.235110188313097e-09,  1.288270736179503e-10, -1.085745662112123e-11,  7.689550726229887e-13, -4.702539894113286e-14,
  2.533245336604150e-15, -1.220517448933763e-16,  5.322783716364363e-18, -2.118971735945351e-19,  5.025481996657268e-08, -2.012656678713372e-08,  4.292568546493085e-09,
 -6.229115765221827e-10,  6.855100926018039e-11, -6.082124964936992e-12,  4.524700439565756e-13, -2.900394634980027e-14,  1.634381622877233e-15, -8.221129880128158e-17,
  3.736287703437095e-18, -1.547187788586603e-19,  2.253910463366646e-08, -9.404625882529919e-09,  2.096275052221942e-09, -3.176864589398975e-10,  3.645702268725672e-11,
 -3.367386931132520e-12,  2.603552514886403e-13, -1.731645939964965e-14,  1.010869507536740e-15, -5.259657482788773e-17,  2.469029452068198e-18, -1.054533169122918e-19,
  1.008596302812138e-08, -4.329549249857627e-09,  9.953068510392658e-10, -1.555051046679833e-10,  1.837963619238099e-11, -1.746482458921203e-12,  1.387546428712076e-13,
 -9.472256452871331e-15,  5.669207494550283e-16, -3.021043216073399e-17,  1.450967439342903e-18, -6.333996560286202e-20,  3.546910595225204e-09, -1.546743302103044e-09,
  3.617745932061858e-10, -5.749835236873529e-11,  6.909510403450407e-12, -6.671174100341618e-13,  5.381862664156675e-14, -3.728278274616352e-15,  2.262966022208755e-16,
 -1.222235029677064e-17,  5.946340897715259e-19, -2.627922888898747e-20,  1.087999725773077e-01, -5.054481203411039e-04,  2.492601586332428e-06, -1.283526836762899e-08,
  6.787452143067854e-11, -3.640821325578002e-13,  1.963499922920530e-15, -1.059659543751179e-17,  5.703074806436386e-20, -3.058411452550549e-22,  1.631862416461938e-24,
 -8.669525192830837e-27,  9.802028481882939e-02, -6.590890660815511e-04,  5.360058459156992e-06, -4.355725922617197e-08,  3.413467561108421e-10, -2.583512043269874e-12,
  1.899450553594523e-14, -1.363201996708933e-16,  9.583701606116769e-19, -6.617468689082650e-21,  4.496748910096022e-23, -3.011864413251354e-25,  7.959880279585120e-02,
 -8.670294650466251e-04,  1.042822704940854e-05, -1.139798018506903e-07,  1.157224458845523e-09, -1.112267980744297e-11,  1.023449663308843e-13, -9.081725191125471e-16,
  7.812594197490188e-18, -6.541391302603428e-20,  5.347365271582339e-22, -4.278149208491663e-24,  5.832319471877039e-02, -1.001637996795033e-03,  1.620111617591255e-05,
 -2.264801367772467e-07,  2.876795372301502e-09, -3.401832049354751e-11,  3.799330295670081e-13, -4.047029222316596e-15,  4.140594975076492e-17, -4.090589258116411e-19,
  3.918225390665035e-21, -3.650541577330219e-23,  3.861913258499932e-02, -9.886644326622120e-04,  2.064684198445513e-05, -3.608036482072385e-07,  5.610673858392574e-09,
 -7.994175670876658e-11,  1.062551629936227e-12, -1.333560058533208e-14,  1.594153387167640e-16, -1.826912633141297e-18,  2.017207450127051e-20, -2.154312240293195e-22,
  2.316006230994698e-02, -8.386362230185647e-04,  2.213521013748908e-05, -4.753924648593629e-07,  8.905150790830744e-09, -1.506164948403445e-10,  2.349557085440648e-12,
 -3.429056327899973e-14,  4.729872058209068e-16, -6.212929130567080e-18,  7.817163630301534e-20, -9.463618882232997e-22,  1.261552054802316e-02, -6.187286186790925e-04,
  2.032139151728562e-05, -5.289086628433170e-07,  1.178555999689486e-08, -2.339315877708985e-10,  4.237667741807113e-12, -7.120282940251186e-14,  1.122534184897232e-15,
 -1.674763626735541e-17,  2.380258043599548e-19, -3.238971765375875e-21,  6.264686132963306e-03, -4.018259381320575e-04,  1.619877312598012e-05, -5.048870760031228e-07,
  1.324555040670040e-08, -3.056941546053673e-10,  6.375713279270972e-12, -1.223461461677776e-13,  2.187813788867434e-15, -3.680511660930402e-17,  5.867537007054607e-19,
 -8.914057162348833e-21,  2.849226430944257e-03, -2.322837327294580e-04,  1.134760295776237e-05, -4.191561729469012e-07,  1.283275166327434e-08, -3.416590017263075e-10,
  8.145159018042372e-12, -1.773054113390571e-13,  3.573467963301259e-15, -6.737360541221699e-17,  1.197782337586005e-18, -2.020147404394208e-20,  1.193614983850581e-03,
 -1.207929753643232e-04,  7.065467846899775e-06, -3.064014113400272e-07,  1.086127414929196e-08, -3.312732198179093e-10,  8.970248224707982e-12, -2.202061148158128e-13,
  4.974333093429270e-15, -1.045546133954056e-16,  2.062399044923933e-18, -3.842729087922684e-20,  4.638053831485767e-04, -5.710841851887075e-05,  3.954424078067726e-06,
 -1.995851497908650e-07,  8.132253624111514e-09, -2.823458433925085e-10,  8.633844592206929e-12, -2.377455850396713e-13,  5.989320648997366e-15, -1.396775062365240e-16,
  3.043110926681362e-18, -6.236434941922937e-20,  1.685775072705457e-04, -2.481974276785200e-05,  2.012776314045970e-06, -1.172588448908844e-07,  5.454163116779132e-09,
 -2.142615809702134e-10,  7.358799460333594e-12, -2.261606043873442e-13,  6.324087733825684e-15, -1.629110737333941e-16,  3.903483603130757e-18, -8.762686057187983e-20,
  5.789429908879577e-05, -1.003533945658493e-05,  9.433714166248937e-07, -6.292980311071022e-08,  3.319089767812284e-09, -1.466634483035403e-10,  5.627488829313526e-12,
 -1.920869505022253e-13,  5.934758028608807e-15, -1.681413694930162e-16,  4.412522649388487e-18, -1.080696996938191e-19,  1.901205897901237e-05, -3.825197955571693e-06,
  4.126955557754676e-07, -3.127362717993684e-08,  1.857791704814207e-09, -9.179304752134527e-11,  3.913818273382020e-12, -1.476406271305796e-13,  5.016746288710329e-15,
 -1.556352330676644e-16,  4.454649117636302e-18, -1.185530801661314e-19,  6.053850397732826e-06, -1.395014109510590e-06,  1.710440859669990e-07, -1.460634482569792e-08,
  9.705422630786688e-10, -5.329279167607843e-11,  2.510903193288807e-12, -1.041385001414279e-13,  3.872878741021876e-15, -1.309608743281820e-16,  4.070423163322464e-18,
 -1.172175170956743e-19,  1.899238288664618e-06, -4.948203929344285e-07,  6.826999867007489e-08, -6.515424248706258e-09,  4.807466909445565e-10, -2.914594552618033e-11,
  1.508394909053294e-12, -6.840079140933574e-14,  2.769647489672037e-15, -1.015797099384087e-16,  3.412309298196341e-18, -1.058485859531886e-19,  5.976194903726648e-07,
 -1.738186509235298e-07,  2.671265045282068e-08, -2.824304330762828e-09,  2.296186138397351e-10, -1.526179413302751e-11,  8.619518938118670e-13, -4.247627171135860e-14,
  1.861896759000370e-15, -7.366217121837632e-17,  2.660528931633590e-18, -8.845367393474617e-20,  1.922742556987759e-07, -6.164142011828417e-08,  1.044054934058542e-08,
 -1.211533886849874e-09,  1.076159646970939e-10, -7.780931247065750e-12,  4.761072940058991e-13, -2.532406525720214e-14,  1.193980868905537e-15, -5.064523242243785e-17,
  1.955276530325332e-18, -6.928401148693211e-20,  6.449978589962705e-08, -2.250102493556436e-08,  4.153479379365816e-09, -5.236530988239530e-10,  5.034884543993541e-11,
 -3.925959664541112e-12,  2.581642348428077e-13, -1.470856935805775e-14,  7.405271548711203e-16, -3.344534939553227e-17,  1.371149058671978e-18, -5.145611117282818e-20,
  2.296434512725932e-08, -8.604200349736218e-09,  1.710383412685811e-09, -2.317170186544583e-10,  2.386985171138938e-11, -1.988040464966689e-12,  1.392220138612973e-13,
 -8.423468696037715e-15,  4.491737661111943e-16, -2.143249051833179e-17,  9.261011123756194e-19, -3.654528738574854e-20,  8.781358048876565e-09, -3.487008399574508e-09,
  7.370227332464780e-10, -1.060162399421312e-10,  1.156917806335873e-11, -1.018256561172447e-12,  7.517483971201173e-14, -4.783886843077224e-15,  2.677134462663440e-16,
 -1.337778452265299e-17,  6.041761865385488e-19, -2.486966988184765e-20,  3.594577851177382e-09, -1.492491433927830e-09,  3.309150094106205e-10, -4.988975586886691e-11,
  5.696723049906678e-12, -5.236772065455973e-13,  4.030501157923412e-14, -2.669106764278346e-15,  1.551686044088152e-16, -8.041763464061899e-18,  3.760830558301336e-19,
 -1.600514823082448e-20,  1.504172787594269e-09, -6.441834506859445e-10,  1.477130692266617e-10, -2.302059436650280e-11,  2.714283391171823e-12, -2.573183216884693e-13,
  2.039786342821929e-14, -1.389513412090493e-15,  8.299341092366114e-17, -4.413957266921169e-18,  2.115995929838719e-19, -9.220559723537084e-21,  5.088679885324172e-10,
 -2.217192368552437e-10,  5.180992086250650e-11, -8.226595552896471e-12,  9.876674565379700e-13, -9.527431331309629e-14,  7.679417769669733e-15, -5.315427397723393e-16,
  3.223694483277409e-17, -1.739754366049293e-18,  8.457681618049778e-20, -3.735028261166714e-21,  1.068171115954855e-01, -4.861054759185398e-04,  2.344862052611557e-06,
 -1.180506605745222e-08,  6.104110988471899e-11, -3.203221081682651e-13,  1.690775492377830e-15, -8.935887190965432e-18,  4.710905330886010e-20, -2.475910252167985e-22,
  1.294647263741724e-24, -6.744417914597261e-27,  9.546650523308849e-02, -6.182102727495952e-04,  4.868512350084179e-06, -3.848554234275111e-08,  2.939430415076917e-10,
 -2.170190355228896e-12,  1.557340877758330e-14, -1.091411996447812e-16,  7.495634133123485e-19, -5.057937093074662e-21,  3.359885193640655e-23, -2.200575783831122e-25,
  7.628929723009363e-02, -7.887759944463247e-04,  9.164631853823729e-06, -9.711854547473459e-08,  9.574111971347587e-10, -8.945333198395274e-12,  8.008958865843746e-14,
 -6.920614249871924e-16,  5.801325262804323e-18, -4.735926384984697e-20,  3.776536593113913e-22, -2.948640509281111e-24,  5.455968845048691e-02, -8.821662955793387e-04,
  1.373858048911393e-05, -1.854349076669487e-07,  2.279153982737067e-09, -2.612260408861428e-11,  2.831509992141876e-13, -2.930290390107640e-15,  2.915278874423770e-17,
 -2.802664055035104e-19,  2.614124176233704e-21, -2.373008414399858e-23,  3.496940816250585e-02, -8.393952688630066e-04,  1.680722604044656e-05, -2.825552912369777e-07,
  4.239346140543044e-09, -5.840046287908019e-11,  7.516971042368359e-13, -9.147695084304487e-15,  1.061449406626650e-16, -1.181827420986561e-18,  1.268822031977713e-20,
 -1.318507848293968e-22,  2.012669193222228e-02, -6.821617151663191e-04,  1.719508940809610e-05, -3.542429942361083e-07,  6.386978338633810e-09, -1.042253801749604e-10,
  1.571568203613775e-12, -2.220310317934024e-14,  2.968381765650543e-16, -3.783210268673781e-18,  4.622865464338034e-20, -5.439754429344959e-22,  1.042964958251681e-02,
 -4.786621962189077e-04,  1.496771568853275e-05, -3.728542016680814e-07,  7.981313176657709e-09, -1.525903211891040e-10,  2.667891977496463e-12, -4.333744690937483e-14,
  6.614475021264019e-16, -9.565307808366167e-18,  1.319089966153177e-19, -1.743296413768152e-21,  4.882726633333157e-03, -2.932834376292098e-04,  1.123400281342208e-05,
 -3.345920361784485e-07,  8.420582044473588e-09, -1.869537000012757e-10,  3.759308547877132e-12, -6.967609296421532e-14,  1.205249787497045e-15, -1.963886292764456e-17,
  3.036018138608102e-19, -4.477274324822692e-21,  2.074118094995129e-03, -1.585897394386606e-04,  7.354474140624668e-06, -2.593575370588336e-07,  7.610630622586895e-09,
 -1.947771458523782e-10,  4.473953008611985e-12, -9.401263541804718e-14,  1.832003860108217e-15, -3.344296470528777e-17,  5.763754769140192e-19, -9.434225701325991e-21,
  8.037953598021348e-04, -7.645900588812703e-05,  4.245547212273464e-06, -1.757398251639992e-07,  5.969280792447389e-09, -1.749704197081402e-10,  4.563977016655979e-12,
 -1.081385195614803e-13,  2.361700136748574e-15, -4.806233048143499e-17,  9.191066201524969e-19, -1.662161545857616e-20,  2.861110943957699e-04, -3.320699826584237e-05,
  2.184858461593847e-06, -1.053117872557367e-07,  4.113144341629571e-09, -1.372812535688307e-10,  4.045032390685714e-12, -1.075416836396853e-13,  2.620157583409560e-15,
 -5.918465037755256e-17,  1.250571055552829e-18, -2.488631036703630e-20,  9.432354305159619e-05, -1.313498898458023e-05,  1.013915668666132e-06, -5.647997397215922e-08,
  2.520696380481749e-09, -9.527558436442011e-11,  3.155623580995501e-12, -9.370949728249838e-14,  2.536230140138697e-15, -6.333069670054814e-17,  1.472883381807600e-18,
 -3.213204069591859e-20,  2.909543498277887e-05, -4.789186036719604e-06,  4.296166632585273e-07, -2.745611850248755e-08,  1.391731811002963e-09, -5.925676285209845e-11,
  2.195634425830944e-12, -7.250886206625249e-14,  2.171006930726290e-15, -5.969454225635646e-17,  1.522372110602885e-18, -3.627780856272784e-20,  8.501644344325387e-06,
 -1.631666628824552e-06,  1.685301840942388e-07, -1.226736220151395e-08,  7.019623662037511e-10, -3.348885560690012e-11,  1.381496715042983e-12, -5.051103919192625e-14,
  1.666162153638571e-15, -5.024921540417093e-17,  1.399953105743062e-18, -3.630834618043497e-20,  2.388126337939014e-06, -5.275746575917092e-07,  6.216775863999339e-08,
 -5.116198803151550e-09,  3.284169787997837e-10, -1.745835160531471e-11,  7.977968144660719e-13, -3.214492433254739e-14,  1.163079089230821e-15, -3.831458560224205e-17,
  1.161528811887605e-18, -3.266179023589092e-20,  6.561814059304168e-07, -1.647877516279968e-07,  2.194756127707764e-08, -2.026417807825923e-09,  1.449511919614713e-10,
 -8.534904173235514e-12,  4.296951769510976e-13, -1.898313449520944e-14,  7.498374160976240e-16, -2.686008016184745e-17,  8.822335699507162e-19, -2.678594775906466e-20,
  1.799194433808957e-07, -5.072936719776499e-08,  7.562852283858846e-09, -7.769796214159288e-10,  6.148339980601237e-11, -3.983603409212145e-12,  2.196239243190024e-13,
 -1.057840137853926e-14,  4.537414580177862e-16, -1.758475653799720e-17,  6.227613363524512e-19, -2.032053461338619e-20,  5.033737766786305e-08, -1.573544217921556e-08,
  2.598945481110226e-09, -2.944418989020594e-10,  2.556789829543695e-11, -1.809427670691213e-12,  1.084933869872860e-13, -5.660808977060819e-15,  2.620658828659535e-16,
 -1.092467175307796e-17,  4.148530227236863e-19, -1.447043219616584e-20,  1.471337118000637e-08, -5.033594360774654e-09,  9.108940455667651e-10, -1.126762451293312e-10,
  1.063968229424821e-11, -8.155419536581506e-13,  5.276495848849081e-14, -2.960263406070532e-15,  1.468746856634160e-16, -6.541833521893968e-18,  2.646647985373767e-19,
 -9.807937191442275e-21,  4.596929607646213e-09, -1.698176672480094e-09,  3.326609388316885e-10, -4.443456020349217e-11,  4.516021621889386e-12, -3.713374205733270e-13,
  2.569040509463947e-14, -1.536525628446699e-15,  8.103981853748689e-17, -3.826706397269865e-18,  1.637183433862341e-19, -6.399852785714263e-21,  1.562738209806318e-09,
 -6.147685683802861e-10,  1.286620498848632e-10, -1.833046372212569e-11,  1.982059066489875e-12, -1.729320766585314e-13,  1.266140740565790e-14, -7.993917546485184e-16,
  4.440035555976158e-17, -2.202906866220142e-18,  9.881429706587223e-20, -4.041260434435619e-21,  5.798227142310077e-10, -2.394418102570279e-10,  5.278076248520771e-11,
 -7.912203679234754e-12,  8.985388766192414e-13, -8.216915523119451e-14,  6.292809058590441e-15, -4.147580319004411e-16,  2.400346868765564e-17, -1.238669192529569e-18,
  5.769112955090270e-20, -2.445642337895504e-21,  2.255976515614936e-10, -9.636792552250051e-11,  2.203587386797416e-11, -3.424795586327422e-12,  4.027371635103859e-13,
 -3.808315137632286e-14,  3.011551370385171e-15, -2.046719216782511e-16,  1.219757845255820e-17, -6.473437967038703e-19,  3.096982326921445e-20, -1.346909929104247e-21,
  7.316044401228463e-11, -3.184755084131411e-11,  7.434369709233224e-12, -1.179263132601426e-12,  1.414395102705939e-13, -1.363069429939987e-14,  1.097655366096841e-15,
 -7.590752498325470e-17,  4.599625585539486e-18, -2.480224983164407e-19,  1.204761496723119e-20, -5.316217852647114e-22,  1.049093331150369e-01, -4.678970924621255e-04,
  2.208856710429395e-06, -1.087753717235699e-08,  5.502103392901648e-11, -2.825835004920842e-13,  1.460403579156974e-15, -7.561567479494294e-18,  3.906066171080752e-20,
 -2.012784653899403e-22,  1.031685402943028e-24, -5.272900000305852e-27,  9.306874412367691e-02, -5.810326991931208e-04,  4.433535104281473e-06, -3.411036873825123e-08,
  2.540426464766851e-10, -1.830548987719108e-12,  1.282763125496347e-14, -8.782696102835482e-17,  5.895066294425967e-19, -3.889109103031503e-21,  2.526549472714797e-23,
 -1.618807176794336e-25,  7.327379688854474e-02, -7.198731635842219e-04,  8.085538026140719e-06, -8.313301302169872e-08,  7.962585296073085e-10, -7.236215189413647e-12,
  6.307395892152382e-14, -5.310183636576552e-16,  4.339722807025513e-18, -3.455796036591489e-20,  2.689390686835997e-22, -2.050147516622733e-24,  5.123757321006827e-02,
 -7.805760360427473e-04,  1.171604358643276e-05, -1.528049441848420e-07,  1.818519962042206e-09, -2.021478993683994e-11,  2.127793854277181e-13, -2.140531129094917e-15,
  2.071846435441421e-17, -1.939227614740215e-19,  1.762131911331961e-21, -1.559231693107694e-23,  3.186078690234614e-02, -7.174298186550554e-04,  1.378794827812820e-05,
 -2.231702658895257e-07,  3.232825935929880e-09, -4.308560965354641e-11,  5.373562870815974e-13, -6.344151665453053e-15,  7.149125937596597e-17, -7.737200638636788e-19,
  8.080575400300890e-21, -8.174024766089446e-23,  1.764850334599290e-02, -5.600134899854531e-04,  1.349463861031474e-05, -2.668716341095497e-07,  4.634346751580346e-09,
 -7.300877406892651e-11,  1.064686978748097e-12, -1.456858916134290e-14,  1.888700196495813e-16, -2.336642610787959e-18,  2.774111918021643e-20, -3.174124924547549e-22,
  8.728932529460725e-03, -3.748577767864579e-04,  1.116919896813018e-05, -2.664619971375196e-07,  5.482643986893461e-09, -1.010156711502690e-10,  1.705479677218224e-12,
 -2.679558593449871e-14,  3.961023350348128e-16, -5.554307534273754e-18,  7.434775912312554e-20, -9.546077520429531e-22,  3.866803233050898e-03, -2.174367567659817e-04,
  7.918123739917153e-06, -2.254656978123975e-07,  5.445745363121712e-09, -1.163613908465980e-10,  2.256759906537246e-12, -4.041402535292780e-14,  6.764607374949383e-16,
 -1.067961637839197e-17,  1.601421508584078e-19, -2.293063619697939e-21,  1.540294550872355e-03, -1.103951789772796e-04,  4.860962530430580e-06, -1.637064033400844e-07,
  4.605652282451698e-09, -1.133373832377341e-10,  2.508911518641333e-12, -5.090438911336966e-14,  9.593142578892390e-16, -1.695906302918171e-17,  2.833938893134316e-19,
 -4.502497305804440e-21,  5.545165703508283e-04, -4.953833571530052e-05,  2.611034850134961e-06, -1.031692473256819e-07,  3.358141375344207e-09, -9.460610221607902e-11,
  2.377378482038517e-12, -5.437300586338858e-14,  1.148146877071421e-15, -2.262426619400597e-17,  4.194560795585718e-19, -7.362870272067242e-21,  1.815791800193611e-04,
 -1.984318791520990e-05,  1.240023522493913e-06, -5.706729637030525e-08,  2.136139019784169e-09, -6.853009177951194e-11,  1.945518800063929e-12, -4.993386658605022e-14,
  1.176494392353033e-15, -2.573721988989508e-17,  5.273804701644927e-19, -1.018970783065707e-20,  5.451975185818014e-05, -7.170999235008034e-06,  5.264981836276499e-07,
 -2.802857880946172e-08,  1.199745341573172e-09, -4.361552845718826e-11,  1.392669861101066e-12, -3.994916266338986e-14,  1.046202513279639e-15, -2.531610904480808e-17,
  5.713316784035271e-19, -1.210957567416356e-20,  1.516141234068693e-05, -2.365994888672222e-06,  2.023200899033787e-07, -1.237727438647653e-08,  6.025578784583280e-10,
 -2.470594782471581e-11,  8.835248341228463e-13, -2.821504547210995e-14,  8.182978891542734e-16, -2.182687435540848e-17,  5.407087964192029e-19, -1.253152133276846e-20,
  3.953864239866250e-06, -7.225351634790442e-07,  7.134998639495226e-08, -4.983326463260992e-09,  2.744224691995835e-10, -1.263044785240528e-11,  5.037303366273702e-13,
 -1.783860747775615e-14,  5.708478198427138e-16, -1.672580599656480e-17,  4.533047669387785e-19, -1.145056462087878e-20,  9.817769670855267e-07, -2.075188572981941e-07,
  2.346460431689552e-08, -1.858539788055867e-09,  1.151206153800395e-10, -5.918374337203896e-12,  2.620626350415991e-13, -1.024895850813486e-14,  3.604877648932214e-16,
 -1.155984656380451e-17,  3.415559308115814e-19, -9.371712132936283e-21,  2.364291912789054e-07, -5.711387580625885e-08,  7.330617102265192e-09, -6.538356326190479e-10,
  4.527989120449079e-11, -2.586275092058718e-12,  1.265262123041053e-13, -5.440040687562751e-15,  2.094199522311721e-16, -7.320162386373168e-18,  2.348859883944282e-19,
 -6.974458318287849e-21,  5.643513934605394e-08, -1.539426642067284e-08,  2.222416039669280e-09, -2.215124550630943e-10,  1.703661861134056e-11, -1.074626763661577e-12,
  5.776519766403215e-14, -2.716429214182600e-15,  1.138967311733696e-16, -4.319662584143829e-18,  1.498621053138741e-19, -4.794977449951035e-21,  1.369157164186063e-08,
 -4.165401261516253e-09,  6.697304780343124e-10, -7.396387781568073e-11,  6.269802361160694e-12, -4.337345490879086e-13,  2.545355420126101e-14, -1.301305320166115e-15,
  5.909067411152819e-17, -2.418468698707565e-18,  9.024719363111177e-20, -3.095968677758536e-21,  3.470668839223577e-09, -1.162482617436416e-09,  2.059137964166456e-10,
 -2.495542374864862e-11,  2.311219941142335e-12, -1.739367959305217e-13,  1.105980762328196e-14, -6.103553822939425e-16,  2.981358413666277e-17, -1.308335237536206e-18,
  5.218927168066617e-20, -1.908232059744641e-21,  9.455295279941517e-10, -3.439366620958218e-10,  6.631000351311356e-11, -8.722371573046175e-12,  8.736365861491641e-13,
 -7.084863654212213e-14,  4.837643946127097e-15, -2.857565017975778e-16,  1.489436306991108e-17, -6.954582996915169e-19,  2.943770414947754e-20, -1.139119805311414e-21,
  2.836696538772110e-10, -1.104502309281147e-10,  2.286697306575726e-11, -3.223868137500627e-12,  3.451213738697469e-13, -2.982612439185274e-14,  2.164102416242116e-15,
 -1.354653232985433e-16,  7.463010450348130e-18, -3.674157917763103e-19,  1.635985796949425e-20, -6.644093013627438e-22,  9.469736026970570e-11, -3.887213156006533e-11,
  8.513961331825973e-12, -1.268346596582367e-12,  1.431774274814176e-13, -1.301863208126051e-14,  9.916083340452924e-16, -6.501968934851633e-17,  3.744449604088292e-18,
 -1.923253165747107e-19,  8.917733413385238e-21, -3.764427218165330e-22,  3.404568721640419e-11, -1.450216390622516e-11,  3.305971104054806e-12, -5.122646839107777e-13,
  6.006481148830067e-14, -5.664003148857804e-15,  4.467113123991675e-16, -3.028260811289791e-17,  1.800349889158748e-18, -9.532657419842952e-20,  4.550491210176716e-21,
 -1.974892893550374e-22,  1.054227906279389e-11, -4.584622121009255e-12,  1.069043801134550e-12, -1.693898856386652e-13,  2.029478312039526e-14, -1.953812396726470e-15,
  1.571799218115848e-16, -1.085917779883492e-17,  6.574006036418355e-19, -3.541670160120184e-20,  1.718861388883750e-21, -7.578426755364460e-23,  1.030722803366714e-01,
 -4.507338123434752e-04,  2.083427756496759e-06, -1.004057915133156e-08,  4.970341369913899e-11, -2.499396793195145e-13,  1.265143809595612e-15, -6.420030258782487e-18,
  3.250480224097542e-20, -1.642969098841387e-22,  8.256151401679765e-25, -4.142609116210278e-27,  9.081305151651892e-02, -5.471352942180799e-04,  4.047442599350765e-06,
 -3.032264635415611e-08,  2.203215987349002e-10, -1.550186764047519e-12,  1.061284143102453e-14, -7.102093878740567e-17,  4.660967255595682e-19, -3.007587635557297e-21,
  1.911604828951929e-23, -1.198662095459827e-25,  7.051764663936735e-02, -6.589731503650078e-04,  7.159860047165167e-06, -7.147320953169012e-08,  6.655441059152621e-10,
 -5.886249355913032e-12,  4.997645354505493e-14, -4.101406967701240e-16,  3.269361048057806e-18, -2.540719608060352e-20,  1.930509185899109e-22, -1.437446722161265e-24,
  4.829177254236974e-02, -6.937167070251459e-04,  1.004446658539009e-05, -1.266846349455115e-07,  1.460797974554848e-09, -1.575838070804321e-11,  1.611666156051496e-13,
 -1.576872303894242e-15,  1.485651992026058e-17, -1.354490441730883e-19,  1.199604855342053e-21, -1.035140546962486e-23,  2.919587431184202e-02, -6.170202962246433e-04,
  1.139393516231006e-05, -1.776940902591170e-07,  2.486925124969956e-09, -3.208585050528463e-11,  3.879678624750466e-13, -4.446122201251046e-15,  4.868224505069947e-17,
 -5.123697774952326e-19,  5.207734607552111e-21, -5.130261331087411e-23,  1.560572521755956e-02, -4.637082724410077e-04,  1.069303632627959e-05, -2.031424692115630e-07,
  3.399880212004642e-09, -5.173907335571666e-11,  7.301164349126615e-13, -9.681105748223538e-15,  1.217635553314472e-16, -1.462950061921118e-18,  1.688203920887393e-20,
 -1.879010100573065e-22,  7.389877166197338e-03, -2.969433461899709e-04,  8.437882668715968e-06, -1.929097600258948e-07,  3.817560312070749e-09, -6.782127221801347e-11,
  1.106258235950310e-12, -1.681878557572803e-14,  2.408996453723242e-16, -3.276800552818617e-18,  4.259034914992136e-20, -5.314696108597081e-22,  3.108490721564246e-03,
 -1.635923736185368e-04,  5.667106525515875e-06, -1.543536645818590e-07,  3.579761669230445e-09, -7.364766743615430e-11,  1.378213069886797e-12, -2.385603582751345e-14,
  3.865247169283497e-16, -5.914303030866589e-18,  8.604866876097308e-20, -1.196668885354793e-21,  1.165613107498484e-03, -7.826584141576876e-05,  3.273235040834124e-06,
 -1.053070543137346e-07,  2.841382808933217e-09, -6.725303766194943e-11,  1.435186941446097e-12, -2.812346266993003e-14,  5.126786059597338e-16, -8.778983493783020e-18,
  1.422679532761318e-19, -2.194368671539090e-21,  3.914214214213219e-04, -3.281472329876950e-05,  1.641733977500689e-06, -6.192741134333600e-08,  1.931911352632785e-09,
 -5.231741810994038e-11,  1.266731428762999e-12, -2.796863024948383e-14,  5.710873038524978e-16, -1.089726248563570e-17,  1.958910410865374e-19, -3.337766112291659e-21,
  1.184108481830259e-04, -1.217096682129984e-05,  7.221373534088422e-07, -3.172545219692195e-08,  1.138032824271233e-09, -3.509090350987974e-11,  9.597784184684620e-13,
 -2.378021742400014e-14,  5.417931899052621e-16, -1.147815028950424e-17,  2.280713514479968e-19, -4.278221515102560e-21,  3.251570096337721e-05, -4.034196686706824e-06,
  2.815311069545025e-07, -1.431676916937332e-08,  5.875497050119060e-10, -2.053820192609118e-11,  6.320652694009731e-13, -1.750974090815984e-14,  4.436011181814552e-16,
 -1.040000653047693e-17,  2.277022688661171e-19, -4.687954779969401e-21,  8.183779976476924e-06, -1.208861099926747e-06,  9.844096838881215e-08, -5.760575195786735e-09,
  2.691729339776265e-10, -1.062244153154316e-11,  3.664624170416306e-13, -1.131177044054151e-14,  3.176441504463481e-16, -8.215887653260151e-18,  1.976262160973294e-19,
 -4.452883655885986e-21,  1.911159520175926e-06, -3.319364677476180e-07,  3.129827621813390e-08, -2.095326234052867e-09,  1.109456777527587e-10, -4.922512140247116e-12,
  1.896668718152245e-13, -6.501278846911146e-15,  2.017073853709714e-16, -5.738411814701107e-18,  1.512074372034410e-19, -3.718099076423790e-21,  4.205343595028069e-07,
 -8.487867503444462e-08,  9.195250985732830e-09, -7.000739034724208e-10,  4.179698764856713e-11, -2.076027729329303e-12,  8.899260504003220e-14, -3.375330958766938e-15,
  1.153180562124134e-16, -3.596999714286796e-18,  1.035105326738459e-19, -2.769441671753107e-21,  8.886853381095158e-08, -2.060707849310729e-08,  2.544541820486041e-09,
 -2.189188308626965e-10,  1.465873047618575e-11, -8.112309941843482e-13,  3.852321725459069e-14, -1.610350113070365e-15,  6.035907612477808e-17, -2.056935418896324e-18,
  6.442435400589860e-20, -1.869319432644350e-21,  1.845977515813598e-08, -4.861258203881802e-09,  6.783788905777161e-10, -6.549422970867324e-11,  4.888814813793424e-12,
 -2.998240443761354e-13,  1.569483376919313e-14, -7.197699498040663e-16,  2.946965776518490e-17, -1.092685108524753e-18,  3.710117801585919e-20, -1.162996115281373e-21,
  3.874567842922071e-09, -1.144916134227106e-09,  1.788821570026045e-10, -1.922675308568415e-11,  1.588705318845489e-12, -1.072885434862475e-13,  6.154591379640621e-15,
 -3.079509573869267e-16,  1.370115251532276e-17, -5.499945633739065e-19,  2.014837758384555e-20, -6.791757941073326e-22,  8.480676754259982e-10, -2.776144427020438e-10,
  4.805478605942875e-11, -5.697404555991751e-12,  5.168109683068777e-13, -3.813801581976973e-14,  2.380422672788824e-15, -1.290795283162242e-16,  6.200858458985631e-18,
 -2.678455764638478e-19,  1.052475969335059e-20, -3.793614596496553e-22,  2.002095896275076e-10, -7.160650519125557e-11,  1.356855120194875e-11, -1.755359241480149e-12,
  1.730630206914393e-13, -1.382644490022575e-14,  9.308153783507761e-16, -5.424991552716202e-17,  2.791891384261991e-18, -1.287954802116901e-19,  5.389473937884508e-21,
 -2.062896012874221e-22,  5.260843045448595e-11, -2.025286530029024e-11,  4.143640123066775e-12, -5.775267824543129e-13,  6.115356927697486e-14, -5.230495084839978e-15,
  3.757964536941336e-16, -2.330516780829763e-17,  1.272606626891695e-18, -6.212802137705054e-20,  2.744352057081167e-21, -1.106123945001718e-22,  1.567772718154331e-11,
 -6.392985288533194e-12,  1.390372751600519e-12, -2.057082422041700e-13,  2.306913439635820e-14, -2.084504084498501e-15,  1.578314590191696e-16, -1.029067229263820e-17,
  5.894605311073950e-19, -3.012217416728537e-20,  1.389938961995860e-21, -5.840342734960724e-23,  5.173003880777600e-12, -2.196635737277991e-12,  4.990655195457392e-13,
 -7.707503189200600e-14,  9.008550373429191e-15, -8.469048095380230e-16,  6.660016071961809e-17, -4.502333905087752e-18,  2.669645334531796e-19, -1.409989975131487e-20,
  6.714534370172374e-22, -2.907413425236822e-23,  1.522854656837177e-12, -6.615471806413668e-13,  1.540770006060791e-13, -2.438469637798570e-14,  2.918199856412129e-15,
 -2.806275622682974e-16,  2.255164027720663e-17, -1.556425003743521e-18,  9.412990472051836e-20, -5.066258385678624e-21,  2.456498688210063e-22, -1.082097443630857e-23,
  1.013019354457593e-01, -4.345351882473374e-04,  1.967552556119323e-06, -9.283724205185511e-09,  4.499427905904912e-11, -2.216210665045912e-13,  1.099099398123063e-15,
 -5.468477715389867e-18,  2.714314473835832e-20, -1.346447210262168e-22,  6.633387220362170e-25, -3.270552342569159e-27,  8.868704650634189e-02, -5.161535825831854e-04,
  3.703741644859880e-06, -2.703233853974967e-08,  1.917121742097501e-10, -1.317751211923814e-12,  8.817784752042811e-15, -5.770035971913053e-17,  3.704056614731571e-19,
 -2.338731113998558e-21,  1.454890517338610e-23, -8.931683743227121e-26,  6.799112411832929e-02, -6.049524983040288e-04,  6.362389763736518e-06, -6.170483661001801e-08,
  5.589409646308464e-10, -4.813594503980555e-12,  3.982963433363652e-14, -3.187807071453318e-16,  2.479710736159520e-18, -1.881464315219469e-20,  1.396391669463569e-22,
 -1.016005469734061e-24,  4.566852014755222e-02, -6.190671579003165e-04,  8.654728997483675e-06, -1.056371469345519e-07,  1.180993659490502e-09, -1.237068510118788e-11,
  1.229980683009555e-13, -1.171043631546166e-15,  1.074461073861769e-17, -9.546394957703228e-20,  8.244187795756797e-22, -6.940379355585764e-24,  2.689748591652201e-02,
 -5.337673692497367e-04,  9.480704528189978e-06, -1.425704792348242e-07,  1.929078950073178e-09, -2.410819209759527e-11,  2.827761022174112e-13, -3.147244068870548e-15,
  3.349991113538173e-17, -3.430370159498256e-19,  3.394731109974128e-21, -3.258184705491311e-23,  1.390775102005629e-02, -3.870629382092069e-04,  8.550417390290663e-06,
 -1.561553888480257e-07,  2.520454720459142e-09, -3.707320845380450e-11,  5.065213480682334e-13, -6.511610804571231e-15,  7.949388709678933e-17, -9.279450671535750e-19,
  1.041270554415973e-20, -1.127830543594208e-22,  6.323789698908740e-03, -2.377560288229790e-04,  6.448959540647229e-06, -1.413833695821418e-07,  2.692570664082757e-09,
 -4.614937808521370e-11,  7.276247900637536e-13, -1.070949066577653e-14,  1.486945865012703e-16, -1.962795204635268e-18,  2.478121492766227e-20, -3.006439971792901e-22,
  2.534304537112625e-03, -1.247921038695153e-04,  4.115168708495375e-06, -1.072681835233476e-07,  2.389941452437368e-09, -4.736381350536082e-11,  8.555987411601381e-13,
 -1.432048976118610e-14,  2.246792021571349e-16, -3.333097079355998e-18,  4.706669961723083e-20, -6.358977670851811e-22,  8.978883251376418e-04, -5.645311496088517e-05,
  2.243339657181769e-06, -6.897170247295040e-08,  1.785453927799730e-09, -4.066116337372091e-11,  8.367555492811550e-13, -1.584075996158486e-14,  2.794081478195555e-16,
 -4.635557239100017e-18,  7.286773212707441e-20, -1.091350563553104e-21,  2.823728676472738e-04, -2.219786372519500e-05,  1.054242468284746e-06, -3.796907017268322e-08,
  1.135456173559077e-09, -2.956304300924822e-11,  6.897992111851523e-13, -1.470553425860290e-14,  2.903968982611942e-16, -5.366610023286836e-18,  9.354711673069575e-20,
 -1.547365906321559e-21,  7.924575142662813e-05, -7.653347775212932e-06,  4.310339161616375e-07, -1.807539805513287e-08,  6.213358612556931e-10, -1.841416742464545e-11,
  4.852350257530001e-13, -1.160600802781566e-14,  2.556948167660903e-16, -5.245918847902273e-18,  1.010758387522295e-19, -1.840689198983072e-21,  1.998565778213064e-05,
 -2.335926514150874e-06,  1.548547289213124e-07, -7.519590963065763e-09,  2.957916311668261e-10, -9.939677792678611e-12,  2.947671865125754e-13, -7.884540061705563e-15,
  1.932049537243193e-16, -4.387773180346526e-18,  9.318483235653014e-20, -1.863203097027429e-21,  4.571008737632855e-06, -6.381287831287107e-07,  4.944061319311412e-08,
 -2.765586230489496e-09,  1.239682757290772e-10, -4.706444197642370e-12,  1.565690138605160e-13, -4.669599698908436e-15,  1.269147854465681e-16, -3.182059570393700e-18,
  7.429674989757359e-20, -1.626967580435062e-21,  9.593839332390379e-07, -1.580854269229679e-07,  1.421530623734169e-08, -9.113314059940690e-10,  4.635995743195955e-11,
 -1.981476402556937e-12,  7.371234188526304e-14, -2.444185579234940e-15,  7.348158353093810e-17, -2.028715836379996e-18,  5.194691806222596e-20, -1.242810197866616e-21,
  1.876138537962478e-07, -3.608669099764743e-08,  3.740006757856167e-09, -2.733635307417184e-10,  1.571449476412878e-11, -7.533839211802224e-13,  3.123780908625091e-14,
 -1.148110897518708e-15,  3.807234882521483e-17, -1.154320820286799e-18,  3.233044547213030e-20, -8.429240223453713e-22,  3.485257154649011e-08, -7.741124429434323e-09,
  9.180162760560537e-10, -7.607435859694402e-11,  4.918943883359208e-12, -2.634496102099619e-13,  1.213077251392198e-14, -4.925340642368415e-16,  1.795833095637338e-17,
 -5.961329302291503e-19,  1.820993512392569e-20, -5.159186224319930e-22,  6.301394404982089e-09, -1.598547027449540e-09,  2.152332626034609e-10, -2.009559336337604e-11,
  1.453759668514599e-12, -8.657180862068183e-14,  4.407841042892290e-15, -1.969166230147107e-16,  7.864624752580052e-18, -2.848076444868866e-19,  9.455628675945167e-21,
 -2.901299451122090e-22,  1.142294949314528e-09, -3.271606628253613e-10,  4.957918097263679e-11, -5.177707276280362e-12,  4.164139354267111e-13, -2.741427899419547e-14,
  1.535293031535521e-15, -7.509494977698673e-17,  3.269947004632048e-18, -1.286083828190631e-19,  4.620748997146532e-21, -1.529078100571389e-22,  2.150459093405434e-10,
 -6.866821404711306e-11,  1.159548299882449e-11, -1.342765970812445e-12,  1.191245202859402e-13, -8.608366609734191e-15,  5.267638936961275e-16, -2.803390626418990e-17,
  1.323030175553101e-18, -5.619369981081965e-20,  2.173021349063703e-21, -7.714412092737329e-23,  4.372589770781403e-11, -1.535282895505834e-11,  2.854954052970870e-12,
 -3.627488765956928e-13,  3.515840309290310e-14, -2.763912591569756e-15,  1.832514392044598e-16, -1.052707767089691e-17,  5.343937241763557e-19, -2.433451962836944e-20,
  1.005799250609983e-21, -3.805042502428255e-23,  9.985767080049342e-12, -3.796547486464381e-12,  7.667292956829203e-13, -1.055329210191234e-13,  1.104227912203737e-14,
 -9.338378886482659e-16,  6.637939472299287e-17, -4.075021507318084e-18,  2.203932467115430e-19, -1.066184003545745e-20,  4.669010097247314e-22, -1.866483173162934e-23,
  2.634456811560839e-12, -1.066403243520478e-12,  2.301261291844449e-13, -3.379083381844631e-14,  3.762171161087879e-15, -3.376183562540622e-16,  2.539718156872904e-17,
 -1.645696597131988e-18,  9.371561632519089e-20, -4.762374426239512e-21,  2.185917026695823e-22, -9.138937275797789e-24,  7.919019431443129e-13, -3.351087013978286e-13,
  7.585177139812158e-14, -1.167174840067072e-14,  1.359421447049460e-15, -1.273737917431461e-16,  9.984723156927095e-18, -6.729460053056984e-19,  3.978698897551576e-20,
 -2.095599309982291e-21,  9.953346567528782e-23, -4.299093850455232e-24,  2.205648616922560e-13, -9.570432106032189e-14,  2.226127702457444e-14, -3.518639983206430e-15,
  4.205647453353392e-16, -4.039491620273970e-17,  3.242439642808028e-18, -2.235310690350804e-19,  1.350427212741175e-20, -7.260757665540667e-22,  3.517050233738399e-23,
 -1.547792031517247e-24,  9.959458681572557e-02, -4.192284759202629e-04,  1.860325551021868e-06, -8.597892234964498e-09,  4.081372796726301e-11, -1.969862423151220e-13,
  9.574483973040551e-16, -4.672600046450482e-18,  2.274080486298416e-20, -1.107779367706831e-22,  5.349141680898810e-25, -2.595185095301517e-27,  8.667970865219013e-02,
 -4.877709868730245e-04,  3.396924036639165e-06, -2.416481172362764e-08,  1.673491599460423e-10, -1.124246274034249e-12,  7.356217601179520e-15, -4.708942276551401e-17,
  2.958048957010656e-19, -1.828287315621388e-21,  1.113586684136755e-23, -6.695828855643174e-26,  6.566862818807710e-02, -5.568701740744156e-04,  5.672573404482944e-06,
 -5.348289957874077e-08,  4.715490108874067e-10, -3.956416329529434e-12,  3.192006795234196e-14, -2.492708547318627e-16,  1.893018403446566e-18, -1.402937812869802e-20,
  1.017483406667235e-22, -7.237023795928446e-25,  4.332312871582675e-02, -5.545964927436646e-04,  7.492784654302907e-06, -8.857065639700524e-08,  9.606316704006063e-10,
 -9.776311523795623e-12,  9.454792068223067e-14, -8.763911464589848e-16,  7.834652739448522e-18, -6.786649762985593e-20,  5.717407559001372e-22, -4.697747702737034e-24,
  2.490396765543854e-02, -4.642747957069031e-04,  7.940256474947424e-06, -1.152217065803939e-07,  1.508224249451572e-09, -1.826844275831757e-11,  2.079764953609728e-13,
 -2.249195526598412e-15,  2.328491884530205e-17, -2.320894081171175e-19,  2.237215249918020e-21, -2.092847719187604e-23,  1.248533674963976e-02, -3.255218421485047e-04,
  6.896029866067787e-06, -1.211565106934483e-07,  1.887151681307601e-09, -2.684536374102704e-11,  3.553089108925549e-13, -4.430707859551471e-15,  5.252617689703953e-17,
 -5.959814753308782e-19,  6.505807118830563e-21, -6.860072018052796e-23,  5.466152455579940e-03, -1.922828272325172e-04,  4.983203800195158e-06, -1.048303713352769e-07,
  1.922448666117037e-09, -3.180613285468933e-11,  4.849790807910597e-13, -6.913701307708665e-15,  9.309162496134333e-17, -1.192978627694215e-18,  1.463631145744430e-20,
 -1.726946235001394e-22,  2.093657630436603e-03, -9.643492934892444e-05,  3.029398639516035e-06, -7.561464632176033e-08,  1.619301620047432e-09, -3.092780651862813e-11,
  5.395473448742863e-13, -8.735728445401821e-15,  1.327678244701675e-16, -1.910237616045475e-18,  2.618895181952060e-20, -3.438466940127729e-22,  7.033396772101472e-04,
 -4.138679310515149e-05,  1.563408656511641e-06, -4.595351761655619e-08,  1.141758797256308e-09, -2.502737423563399e-11,  4.968266779008426e-13, -9.089418056068759e-15,
  1.551712227686266e-16, -2.494897923745004e-18,  3.805060897129366e-20, -5.534938326699665e-22,  2.079470106601965e-04, -1.531731266139787e-05,  6.906779574248560e-07,
 -2.375552123122146e-08,  6.811487994583617e-10, -1.705449521277010e-11,  3.835659698851517e-13, -7.896858132563126e-15,  1.508418924893467e-16, -2.700173958038953e-18,
  4.564739886965402e-20, -7.330823984228673e-22,  5.436144550141885e-05, -4.928058812386529e-06,  2.634074349809640e-07, -1.054338826028670e-08,  3.473146941624375e-10,
 -9.893633716732931e-12,  2.511897364438226e-13, -5.800143889518352e-15,  1.235707345739413e-16, -2.455208494910400e-18,  4.587202705060504e-20, -8.110038219052510e-22,
  1.264454868769547e-05, -1.390512173907868e-06,  8.752208464846568e-08, -4.057033435905087e-09,  1.529336272190304e-10, -4.939559933147035e-12,  1.411374686073411e-13,
 -3.644712835732750e-15,  8.637338786292062e-17, -1.899924056726386e-18,  3.913349898626891e-20, -7.598085990186737e-22,  2.638967802413695e-06, -3.476513198850838e-07,
  2.560543902154358e-08, -1.368335515058204e-09,  5.881278545021764e-11, -2.147198356546837e-12,  6.885573179980428e-14, -1.983560620727084e-15,  5.216348626501279e-17,
 -1.267407228264329e-18,  2.871594823926128e-20, -6.109701029148012e-22,  4.997231200137657e-07, -7.798305899516284e-08,  6.679764305547978e-09, -4.097175427456086e-10,
  2.000963537644398e-11, -8.233326983099147e-13,  2.955435032624505e-14, -9.474782994062375e-16,  2.758773333032678e-17, -7.387933649217581e-19,  1.837460728210356e-20,
 -4.275289347431475e-22,  8.713360416872199e-08, -1.593992025761597e-08,  1.578128833271427e-09, -1.106086197729674e-10,  6.116055304950068e-12, -2.827666949870815e-13,
  1.133142002101023e-14, -4.032767311707693e-16,  1.297086476324679e-17, -3.820065174558829e-19,  1.040689861362486e-20, -2.642421735688899e-22,  1.426144571787172e-08,
 -3.027568513848725e-09,  3.442379266453101e-10, -2.743738886017259e-11,  1.711022564525350e-12, -8.858769175951011e-14,  3.951239293340420e-15, -1.556754036726447e-16,
  5.516609087935047e-18, -1.782318045366712e-19,  5.305684403751241e-21, -1.466641973703932e-22,  2.246177039090840e-09, -5.476764857686491e-10,  7.101684376574133e-11,
 -6.401977379706173e-12,  4.482029588081569e-13, -2.588305366107831e-14,  1.280283175244191e-15, -5.565462284690790e-17,  2.166015105463846e-18, -7.653596198004872e-20,
  2.482274777630550e-21, -7.448741410611197e-23,  3.512781885656642e-10, -9.729865243450753e-11,  1.427437475339980e-11, -1.445956515326016e-12,  1.130124704795457e-13,
 -7.242862584083772e-15,  3.954862450658920e-16, -1.888712334384307e-17,  8.040111133777008e-19, -3.094989097411105e-20,  1.089508746385405e-21, -3.536009262445535e-23,
  5.668541470167776e-11, -1.762081233853826e-11,  2.897325680236860e-12, -3.271563422037169e-13,  2.834269228552474e-14, -2.002838032618213e-15,  1.199989787916661e-16,
 -6.260165340655752e-18,  2.899172687132281e-19, -1.209533208084833e-20,  4.598437666796070e-22, -1.606345554584480e-23,  9.869746981367854e-12, -3.396202048438345e-12,
  6.187730426660350e-13, -7.710198265186433e-14,  7.336298063297755e-15, -5.667734108155940e-16,  3.696498807053319e-17, -2.090734337247259e-18,  1.045828664208461e-19,
 -4.696381097074243e-21,  1.915586991580466e-22, -7.156455033006605e-24,  1.943632975651502e-12, -7.288551875893738e-13,  1.451128755287030e-13, -1.970138891436951e-14,
  2.034764123951198e-15, -1.699720845861560e-16,  1.194210317203952e-17, -7.250895017021963e-19,  3.880865205819009e-20, -1.858950474995214e-21,  8.064665441204625e-23,
 -3.195404963502246e-24,  4.499663549907197e-13, -1.806634312082555e-13,  3.865237203268733e-14, -5.628398634472904e-15,  6.216835799038269e-16, -5.537055930592368e-17,
  4.135544403587856e-18, -2.661673651209079e-19,  1.506012818735275e-20, -7.606694352397654e-22,  3.471335540687070e-23, -1.443381543056616e-24,  1.222304636057852e-13,
 -5.152610467191400e-14,  1.161488158210598e-14, -1.780054348885675e-15,  2.065248863429325e-16, -1.927961594184987e-17,  1.506026934029474e-18, -1.011650763805078e-19,
  5.962336909425453e-21, -3.130949016994916e-22,  1.482833654422796e-23, -6.387315703000326e-25,  3.203812303361375e-14, -1.388383556903013e-14,  3.224932096406261e-15,
 -5.090295920323980e-16,  6.075977783016659e-17, -5.828352134518011e-18,  4.672485252971675e-19, -3.217301235559330e-20,  1.941435079932098e-21, -1.042679103188919e-22,
  5.045248725586071e-24, -2.218045695100184e-25,  9.794679996871770e-02, -4.047477605279415e-04,  1.760942877346827e-06, -7.975184923059739e-09,  3.709360314302218e-11,
 -1.754987862656498e-13,  8.362321438783881e-16, -4.004786187578916e-18,  1.911192910556549e-20, -9.150111851897643e-23,  4.327421801355823e-25, -2.070793139036808e-27,
  8.478120104856297e-02, -4.617116352536941e-04,  3.122299705227158e-06, -2.165794185777132e-08,  1.465282085584588e-10, -9.625073464438780e-13,  6.160920786084809e-15,
 -3.859623413077050e-17,  2.373424779247892e-19, -1.436564330042087e-21,  8.570029818496576e-24, -5.049148779742160e-26,  6.352801743890281e-02, -5.139342593146907e-04,
  5.073564710092234e-06, -4.653177386750486e-08,  3.995496482327271e-10, -3.267684608171031e-12,  2.571788867608472e-14, -1.960479503860214e-16,  1.454151245809251e-18,
 -1.053085297044347e-20,  7.466321119210122e-23, -5.193412514807742e-25,  4.121824618112954e-02, -4.986584136330680e-04,  6.516082792879120e-06, -7.464933001580611e-08,
  7.859466640879882e-10, -7.775407907816516e-12,  7.318087398446204e-14, -6.607340532366218e-16,  5.757772506651110e-18, -4.864846653529370e-20,  3.999749016400626e-22,
 -3.208891073766555e-24,  2.316570037151024e-02, -4.058992553629589e-04,  6.691151780782418e-06, -9.376185874066859e-08,  1.188073078816983e-09, -1.395568283538522e-11,
  1.542880398127540e-13, -1.622142450986694e-15,  1.634093908213288e-17, -1.586119701262901e-19,  1.489917491414979e-21, -1.359028181653755e-23,  1.128505238429194e-02,
 -2.756938016173730e-04,  5.606993637794026e-06, -9.483301971584592e-08,  1.426373281082827e-09, -1.963489811108505e-11,  2.518819495721077e-13, -3.048291165601870e-15,
  3.510903604779193e-17, -3.873777480075253e-19,  4.115380715873815e-21, -4.226246604011477e-23,  4.769464584637539e-03, -1.569706890213807e-04,  3.890684625520012e-06,
 -7.858799475343622e-08,  1.388625624191109e-09, -2.218900230393701e-11,  3.273711027415340e-13, -4.522284316352128e-15,  5.907736707560527e-17, -7.352966767112261e-19,
  8.769586039004995e-21, -1.006698497188588e-22,  1.751206703947052e-03, -7.543161286696051e-05,  2.259134450631179e-06, -5.402597468016777e-08,  1.112659891071608e-09,
 -2.049077075665387e-11,  3.453752090027465e-13, -5.411565695048435e-15,  7.970257254183907e-17, -1.112580101878225e-18,  1.481395362211875e-20, -1.890709161257852e-22,
  5.597076796097983e-04, -3.080895880286687e-05,  1.106941557871683e-06, -3.111929951688277e-08,  7.424173557232286e-10, -1.567003697444070e-11,  3.001846475082468e-13,
 -5.309074790253760e-15,  8.774850673387468e-17, -1.367675166151891e-18,  2.024324884699707e-20, -2.860598251587779e-22,  1.561542531399846e-04, -1.076989184039650e-05,
  4.611821309578634e-07, -1.515209245959297e-08,  4.166837587673144e-10, -1.003543506509232e-11,  2.176065672976528e-13, -4.327535370646660e-15,  7.997496309562579e-17,
 -1.386967092565003e-18,  2.274346712740919e-20, -3.546758529948275e-22,  3.817835515305862e-05, -3.245567392062465e-06,  1.646266371582267e-07, -6.289895509346769e-09,
  1.985766558239084e-10, -5.437643047589015e-12,  1.330285545618257e-13, -2.965694231112243e-15,  6.110468534823353e-17, -1.175840044832051e-18,  2.130412184531470e-20,
 -3.656759089228258e-22,  8.224666828520210e-06, -8.499395311092501e-07,  5.077251295282590e-08, -2.246175137647218e-09,  8.112986266830344e-11, -2.518381293910875e-12,
  6.932450985021375e-14, -1.728216564460681e-15,  3.960555207169418e-17, -8.437381284433993e-19,  1.685365041719525e-20, -3.177233963149702e-22,  1.572972145335505e-06,
 -1.952528621086668e-07,  1.366067003120262e-08, -6.970560410439233e-10,  2.871657380565569e-11, -1.007880687557652e-12,  3.114629060922789e-14, -8.664173430502020e-16,
  2.204075308919248e-17, -5.188267400048618e-19,  1.140431925064731e-20, -2.356940849160485e-22,  2.698306749488227e-07, -3.980829816317177e-08,  3.244592950492237e-09,
 -1.902542761764817e-10,  8.914328371350956e-12, -3.529113584922518e-13,  1.221749517215609e-14, -3.785095501258653e-16,  1.066918036906325e-17, -2.770231870065034e-19,
  6.689413979101076e-21, -1.513083293525251e-22,  4.210082353672858e-08, -7.310465097883203e-09,  6.904402577449451e-10, -4.635202058372762e-11,  2.463003460864716e-12,
 -1.097242009686748e-13,  4.246428092073606e-15, -1.462366752916675e-16,  4.559098312970598e-18, -1.303459198008175e-19,  3.451889167318032e-21, -8.530893535476070e-23,
  6.087906352074349e-09, -1.232565999948340e-09,  1.341433416095731e-10, -1.026946883560817e-11,  6.169049596399193e-13, -3.084333835817020e-14,  1.331266597494823e-15,
 -5.085070072000326e-17,  1.749859908216232e-18, -5.497995069398190e-20,  1.593752531183616e-21, -4.295337320397266e-23,  8.364554872608697e-10, -1.955749612073566e-10,
  2.437760032715522e-11, -2.118399339994863e-12,  1.433245610271129e-13, -8.016073377232309e-15,  3.847540656144968e-16, -1.625715167625092e-17,  6.159243296773665e-19,
 -2.121513449295576e-20,  6.715552382181208e-22, -1.969114600162264e-23,  1.128032470834073e-10, -3.014718654392749e-11,  4.273184425335830e-12, -4.191361171180020e-13,
  3.178572990473700e-14, -1.980303000766372e-15,  1.052911634481534e-16, -4.903595405920276e-18,  2.038379292547290e-19, -7.671640574940360e-21,  2.643333864837071e-22,
 -8.405951578365139e-24,  1.555917900232861e-11, -4.698178485716716e-12,  7.507526310189335e-13, -8.251709267515084e-14,  6.969895077470522e-15, -4.809334480901070e-16,
  2.817541066719427e-17, -1.439055248529337e-18,  6.532238104997916e-20, -2.673973405453089e-21,  9.984334779227743e-23, -3.428596205925920e-24,  2.307160344214165e-12,
 -7.765917704648744e-13,  1.383889422478462e-13, -1.688378567586898e-14,  1.574829031392362e-15, -1.194033395185266e-16,  7.650889687290263e-18, -4.255614900080164e-19,
  2.095366491891392e-20, -9.269619787500069e-22,  3.727650433650764e-23, -1.374006083466134e-24,  3.887161676205493e-13, -1.435691317912206e-13,  2.814079181135441e-14,
 -3.763680706153971e-15,  3.832289706543742e-16, -3.158583354542339e-17,  2.191244418576364e-18, -1.314620291294934e-19,  6.956936282442387e-21, -3.296855228247337e-22,
  1.415807558328953e-23, -5.556038695706990e-25,  7.824050250805669e-14, -3.113053940281176e-14,  6.597134986421722e-15, -9.518391437654933e-16,  1.042178189201178e-16,
 -9.205485943648656e-18,  6.821666807179717e-19, -4.357995877646068e-20,  2.448541836466381e-21, -1.228522112574759e-22,  5.571117458711295e-24, -2.302674566043368e-25,
  1.903884226461716e-14, -7.991589180655348e-15,  1.793211797478672e-15, -2.735966028933076e-16,  3.160781758562781e-17, -2.938703281751911e-18,  2.286728531697208e-19,
 -1.530461514582950e-20,  8.988743380446874e-22, -4.704625429484850e-23,  2.221157227894525e-24, -9.539229055337561e-26,  4.668336207892272e-15, -2.020225972201986e-15,
  4.685418291973824e-16, -7.384396099345390e-17,  8.801413162302524e-18, -8.430819303041343e-19,  6.749687810655341e-20, -4.641546144275712e-21,  2.797380545746861e-22,
 -1.500577909963117e-23,  7.252538535063706e-25, -3.184917627156079e-26,  9.635539179953270e-02, -3.910331967833796e-04,  1.668689245955297e-06, -7.408713551917951e-09,
  3.377558494616441e-11, -1.567086427568605e-13,  7.321878951224214e-16, -3.442738774848452e-18,  1.610867852713280e-20, -7.588630898141835e-23,  3.509615348607450e-25,
 -1.663553013156005e-27,  8.298271970081533e-02, -4.377343757277265e-04,  2.875860911750483e-06, -1.945981044073521e-08,  1.286733873166056e-10, -8.268008755168851e-13,
  5.179228667700544e-15, -3.176668463077664e-17,  1.912967721449622e-19, -1.134339523335346e-21,  6.629939177966250e-24, -3.829089691534906e-26,  6.155006816441964e-02,
 -4.754753471707085e-04,  4.551487269167141e-06, -4.063004897371714e-08,  3.399493729260059e-10, -2.711399924866491e-12,  2.082687743506737e-14, -1.550463493326358e-16,
  1.123716871635626e-18, -7.955313385601261e-21,  5.516029963942572e-23, -3.753619731502380e-25,  3.932248346844285e-02, -4.499103700462569e-04,  5.690902730794280e-06,
 -6.322875609860462e-08,  6.466044861986715e-10, -6.221767780666634e-12,  5.701703073512165e-14, -5.016753145738642e-16,  4.263374052312512e-18, -3.515069043891427e-20,
  2.821615405276027e-22, -2.211177047530794e-24,  2.164246568811812e-02, -3.565674325427800e-04,  5.671465677695365e-06, -7.679885059829228e-08,  9.425939325766576e-10,
 -1.074361293411289e-11,  1.154060837453614e-13, -1.180165763359810e-15,  1.157373903525272e-17, -1.094465800821458e-19,  1.002270010847552e-21, -8.917867252381365e-24,
  1.026529266835498e-02, -2.350297103691661e-04,  4.593960020079582e-06, -7.485106707610307e-08,  1.087818763982968e-09, -1.449883665244552e-11,  1.803692240987789e-13,
 -2.119471096651023e-15,  2.372738203775085e-17, -2.546904709428098e-19,  2.634347993188465e-21, -2.635748567714179e-23,  4.198352110912381e-03, -1.292708825429046e-04,
  3.067565802077646e-06, -5.953283309064813e-08,  1.014166519674885e-09, -1.566019639169773e-11,  2.236711459747299e-13, -2.995442590348732e-15,  3.798195850356413e-17,
 -4.593205178075931e-19,  5.327416266883756e-21, -5.952054504066068e-23,  1.481910024759007e-03, -5.967759675425212e-05,  1.705443817616702e-06, -3.909834023134976e-08,
  7.748072202645674e-10, -1.376513691146538e-11,  2.242667671673357e-13, -3.402066086020048e-15,  4.857560885982846e-17, -6.581122610407432e-19,  8.513265801509854e-21,
 -1.056560577610944e-22,  4.520744510916652e-04, -2.326672009974785e-05,  7.955822585334050e-07, -2.140175301956727e-08,  4.904852853806832e-10, -9.972617283374548e-12,
  1.844262088143715e-13, -3.154316377766672e-15,  5.049087829943029e-17, -7.631109969024523e-19,  1.096460912135849e-20, -1.505585429880610e-22,  1.194440322528817e-04,
 -7.707992831927740e-06,  3.135532266335946e-07, -9.843592955624461e-09,  2.597052230286031e-10, -6.018279569935178e-12,  1.258528066837839e-13, -2.418222797213797e-15,
  4.324703302903400e-17, -7.267789372653957e-19,  1.156223765633533e-20, -1.751173961548651e-22,  2.741870225652931e-05, -2.183720233087788e-06,  1.051157567080949e-07,
 -3.833929639895881e-09,  1.160195515559498e-10, -3.054404888434616e-12,  7.201274145402470e-14, -1.550211111929730e-15,  3.089296181404922e-17, -5.758071815345776e-19,
  1.011776506823627e-20, -1.686182446370959e-22,  5.493318007787001e-06, -5.328214740530506e-07,  3.019811991768071e-08, -1.274833819320703e-09,  4.411656599877138e-11,
 -1.316072563252539e-12,  3.490144951861767e-14, -8.399105174481208e-16,  1.861309165844539e-17, -3.840156972588736e-19,  7.438566157058556e-21, -1.361507402401318e-22,
  9.668511229960679e-07, -1.129192009528572e-07,  7.499637062973200e-09, -3.652450861074231e-10,  1.441772929819612e-11, -4.863359967736273e-13,  1.447983794325776e-14,
 -3.888735177997608e-16,  9.567495761261516e-18, -2.181498029629296e-19,  4.651109677081956e-21, -9.335385629116657e-23,  1.508790166453521e-07, -2.100741281985294e-08,
  1.627602184269380e-09, -9.117068574625501e-11,  4.095937254858356e-12, -1.559379887454860e-13,  5.204065621469949e-15, -1.557410954320740e-16,  4.248095088348012e-18,
 -1.069039892359441e-19,  2.505442006353482e-21, -5.507205642349923e-23,  2.114728723500144e-08, -3.478583050894810e-09,  3.129886589044450e-10, -2.010550509064423e-11,
  1.025761464797785e-12, -4.399793728117350e-14,  1.643307926935762e-15, -5.472530649379264e-17,  1.652752759258904e-18, -4.584545894149469e-20,  1.179582319563555e-21,
 -2.835923302312002e-23,  2.710282808623494e-09, -5.221699676692107e-10,  5.430697645926771e-11, -3.987942022124782e-12,  2.305031108164121e-13, -1.111734548834293e-14,
  4.639214405415429e-16, -1.716516963373419e-17,  5.731377872009755e-19, -1.749919155282591e-20,  4.936062218550378e-22, -1.296133258442655e-23,  3.255030201184518e-10,
 -7.281010206460103e-11,  8.707542709910174e-12, -7.282595999687318e-13,  4.754937261825366e-14, -2.572414234424486e-15,  1.196726784410272e-16, -4.909767351819020e-18,
  1.808986410235868e-19, -6.068230885514136e-21,  1.873117760316714e-22, -5.362216062935060e-24,  3.786234791102368e-11, -9.739962174434436e-12,  1.331185495546027e-12,
 -1.262064108206146e-13,  9.272157990289297e-15, -5.607582123527418e-16,  2.899382787661400e-17, -1.315190556258013e-18,  5.332615967993684e-20, -1.960138511611919e-21,
  6.603979186112002e-23, -2.055789600097463e-24,  4.454329064542856e-12, -1.303503697954233e-12,  2.020192559703663e-13, -2.157450092554122e-14,  1.773808988424099e-15,
 -1.193350762440052e-16,  6.826631561246597e-18, -3.409223077821627e-19,  1.515012644034740e-20, -6.078203839395216e-22,  2.226630370071390e-23, -7.508981880151515e-25,
  5.597048882903814e-13, -1.839168318068440e-13,  3.199550937705439e-14, -3.815509813614120e-15,  3.483311791936977e-16, -2.588238342469696e-17,  1.627193728353364e-18,
 -8.889918449115305e-20,  4.303615398688992e-21, -1.873563798486600e-22,  7.420600072136126e-24, -2.696117180633590e-25,  8.005161332538122e-14, -2.907463751302002e-14,
  5.601959030585624e-15, -7.370389271069431e-16,  7.389241564783077e-17, -6.001813385776859e-18,  4.106694748974286e-19, -2.431928751293078e-20,  1.271247186523999e-21,
 -5.954737711875366e-23,  2.529215664451584e-24, -9.822558736229652e-26,  1.387383110332582e-14, -5.464743838138997e-15,  1.145919902866220e-15, -1.636596472702781e-16,
  1.774691515648424e-17, -1.553315588781569e-18,  1.141184963449331e-19, -7.231235965716700e-21,  4.031692724380760e-22, -2.008157628714581e-23,  9.043996255010386e-25,
 -3.713792167894737e-26,  2.995547902550559e-15, -1.251404386902029e-15,  2.793723550975249e-16, -4.241410209778734e-17,  4.876849193013284e-18, -4.513877430193075e-19,
  3.497516530554844e-20, -2.331395114103551e-21,  1.364056381713408e-22, -7.113513074084117e-24,  3.346913616026493e-25, -1.432727283023075e-26,  6.825704949391643e-16,
 -2.949320005799015e-16,  6.828808734813524e-17, -1.074472221719729e-17,  1.278614293607824e-18, -1.222899292165450e-19,  9.776098719660196e-21, -6.713238050014030e-22,
  4.040487702093527e-23, -2.164600588998745e-24,  1.044886445231325e-25, -4.583108408893239e-27,  9.481740764150547e-02, -3.780303462597358e-04,  1.582926717446106e-06,
 -6.892454560916001e-09,  3.080961972318510e-11, -1.402370753674893e-13,  6.426157181554713e-16, -2.968399299907001e-18,  1.361273276180347e-20, -6.321311105639177e-23,
  2.849881475576437e-25, -1.348899745030880e-27,  8.127636483407102e-02, -4.156277744849349e-04,  2.654171222752187e-06, -1.752686110929200e-08,  1.133117590921253e-10,
 -7.125172454751970e-13,  4.369670099734451e-15, -2.625050417206217e-17,  1.548545556546679e-19, -8.999682576082688e-22,  5.154743713378404e-24, -2.919967985025666e-26,
  5.971802800890468e-02, -4.409251770637887e-04,  4.094856405874774e-06, -3.559893092900404e-08,  2.903881099530192e-10, -2.259837242917205e-12,  1.694880948627527e-14,
 -1.232741340345536e-16,  8.733623627676349e-19, -6.046603149754121e-21,  4.101806484320146e-23, -2.731705820890101e-25,  3.760932745504441e-02, -4.072512487456252e-04,
  4.990353748384696e-06, -5.380872979244049e-08,  5.347903997342694e-10, -5.007601422766025e-12,  4.470437239738338e-14, -3.834927388718752e-16,  3.179676087783901e-18,
 -2.559236803734270e-20,  2.006557797688685e-22, -1.536552060342896e-24,  2.030144428907597e-02, -3.146410718469981e-04,  4.833736196330036e-06, -6.329636250149666e-08,
  7.529443086211227e-10, -8.331933843203640e-12,  8.700517312001010e-14, -8.658166353204165e-16,  8.269845185112163e-18, -7.622239455899581e-20,  6.807704134351652e-22,
 -5.910947606298871e-24,  9.393378982640808e-03, -2.015955991297211e-04,  3.791318824959758e-06, -5.954931478444847e-08,  8.367336285403729e-10, -1.080411669869289e-11,
  1.304083605967163e-13, -1.488628607926567e-15,  1.620563658298129e-17, -1.693019838857335e-19,  1.705626367660348e-21, -1.663289052367276e-23,  3.726185420760625e-03,
 -1.073341195570993e-04,  2.441068479320565e-06, -4.554636086021564e-08,  7.484999478937341e-10, -1.117514077027934e-11,  1.545948450748193e-13, -2.008087260224262e-15,
  2.472529869601117e-17, -2.906394467335029e-19,  3.279492263911495e-21, -3.567335800081520e-23,  1.267787417134499e-03, -4.771919086921699e-05,  1.302426084787071e-06,
 -2.864088923155477e-08,  5.464353902650656e-10, -9.369927968238482e-12,  1.476297944276250e-13, -2.169123931387218e-15,  3.003717318908065e-17, -3.951160505264444e-19,
  4.967384527408131e-21, -5.996679595691158e-23,  3.702805158950344e-04, -1.780966688817797e-05,  5.799701018206549e-07, -1.493615752512651e-08,  3.289871673225892e-10,
 -6.446313820106957e-12,  1.151312355588296e-13, -1.904967650400206e-15,  2.954128013139444e-17, -4.330835254256245e-19,  6.042421739246451e-21, -8.064453079539342e-23,
  9.296968184519750e-05, -5.609605075510429e-06,  2.168646027184180e-07, -6.507611052192050e-09,  1.647759129941541e-10, -3.675275280160487e-12,  7.414249195146603e-14,
 -1.376850286287529e-15,  2.383441067340038e-17, -3.882270104927747e-19,  5.993308877216982e-21, -8.817591840381850e-23,  2.011341324877852e-05, -1.499363969762830e-06,
  6.849878163590641e-08, -2.385385690135767e-09,  6.920380534901435e-11, -1.751943780948118e-12,  3.981336179202653e-14, -8.277159698036672e-16,  1.595638388805318e-17,
 -2.881060731532594e-19,  4.910226203975239e-21, -7.946042824273876e-23,  3.762947330009210e-06, -3.421688693280587e-07,  1.839486716795888e-08, -7.409594485801872e-10,
  2.456682038479157e-11, -7.043206921700300e-13,  1.799456127215027e-14, -4.180391567769627e-16,  8.958496061174562e-18, -1.789969322655699e-19,  3.362300708115263e-21,
 -5.974955311568220e-23,  6.121064658563392e-07, -6.716494375829529e-08,  4.232182023758401e-09, -1.966548604857595e-10,  7.436315939090859e-12, -2.410325534874748e-13,
  6.912891569517378e-15, -1.792093200747217e-16,  4.263593547117162e-18, -9.415167614573027e-20,  1.946788916358051e-21, -3.794227006495044e-23,  8.727010314779975e-08,
 -1.144800848026906e-08,  8.423537232842537e-10, -4.504553385673811e-11,  1.939416997142494e-12, -7.097458738728562e-14,  2.282443634150109e-15, -6.595860465277863e-17,
  1.740415364558246e-18, -4.243522092789340e-20,  9.649356306066817e-22, -2.060546296721825e-23,  1.103330967260399e-08, -1.715894752007436e-09,  1.468967396268744e-10,
 -9.020335522349407e-12,  4.415114512696338e-13, -1.822108932680152e-14,  6.563782922791827e-16, -2.112560768460886e-17,  6.177180761036266e-19, -1.661592781365145e-20,
  4.151584098988648e-22, -9.705100232098868e-24,  1.257780822972097e-09, -2.300887445303951e-10,  2.283145270798255e-11, -1.606147416421738e-12,  8.922717650256143e-14,
 -4.147472496446742e-15,  1.671808017957995e-16, -5.987020737416423e-18,  1.938196262628789e-19, -5.746506635998652e-21,  1.576219122874078e-22, -4.029898185023422e-24,
  1.323815372596138e-10, -2.826089697745971e-11,  3.236723075429460e-12, -2.601303844866523e-13,  1.636830116576110e-14, -8.555097809259938e-16,  3.853261723737718e-17,
 -1.533389060843491e-18,  5.489096604746258e-20, -1.791607581708590e-21,  5.388156429960647e-23, -1.504714315452992e-24,  1.329407316222220e-11, -3.283582504416572e-12,
  4.318284327686153e-13, -3.950217597767334e-14,  2.807096876998450e-15, -1.645614777894136e-16,  8.263428090922725e-18, -3.646519054098137e-19,  1.440526106984000e-20,
 -5.165951325598552e-22,  1.700159233189454e-23, -5.175929717134689e-25,  1.332053740634780e-12, -3.768586952375973e-13,  5.652640067851744e-14, -5.854432070826160e-15,
  4.677359637390985e-16, -3.063345602908523e-17,  1.708726476636717e-18, -8.332847679536668e-20,  3.620756302386232e-21, -1.422081061042901e-22,  5.105514525136920e-24,
 -1.689141306736810e-25,  1.412081700916324e-13, -4.519768727883539e-14,  7.660808796472942e-15, -8.913494539872281e-16,  7.951496904671697e-17, -5.781412123763765e-18,
  3.561257858760301e-19, -1.908573523406930e-20,  9.073184813561921e-22, -3.882745941730632e-23,  1.513031894757558e-24, -5.413311132945578e-26,  1.701425337382227e-14,
 -6.066147949344727e-15,  1.147004642717345e-15, -1.482254543151783e-16,  1.461109470716888e-17, -1.168015083488114e-18,  7.873115841731320e-20, -4.596935065032188e-21,
  2.371138426514496e-22, -1.096776960868541e-23,  4.603260421026794e-25, -1.767715450628268e-26,  2.513617694272718e-15, -9.790077512683873e-16,  2.029012420963813e-16,
 -2.865376227636476e-17,  3.074187224306110e-18, -2.663764776159562e-19,  1.938522048423553e-20, -1.217418832681842e-21,  6.730476558636177e-23, -3.325751225839126e-24,
  1.486531648506258e-25, -6.060879953132943e-27,  4.766100781895658e-16, -1.980458079568418e-16,  4.396262046855592e-17, -6.637676499226569e-18,  7.592140499694148e-19,
 -6.992194020900906e-20,  5.392361209380685e-21, -3.578502855440600e-22,  2.084914158424926e-23, -1.082948256801850e-24,  5.076059290294051e-26, -2.165176167743441e-27,
  1.001765838328394e-16, -4.321255163130432e-17,  9.987027750932713e-18, -1.568561029599594e-18,  1.863321569194531e-19, -1.779146594988849e-20,  1.420006729279571e-21,
 -9.736227580989317e-23,  5.851335465612860e-24, -3.130319815029364e-25,  1.509021569079441e-26, -6.610399151809077e-28,  9.333010081394902e-02, -3.656895979754334e-04,
  1.503085069008198e-06, -6.421128006257484e-09,  2.815261940788087e-11, -1.257644835053036e-13,  5.652719688284684e-16, -2.567113975271755e-18,  1.152864403427320e-20,
 -5.292523719896815e-23,  2.311438324310978e-25, -1.110087849241205e-27,  7.965503056324948e-02, -3.952059204451368e-04,  2.454274355031948e-06, -1.582241787376062e-08,
  1.000533707373499e-10, -6.159339519783074e-13,  3.699430006906252e-15, -2.177612715335972e-17,  1.258772933596526e-19, -7.173271283176642e-22,  4.026843554214812e-24,
 -2.238975346234952e-26,  5.801724663875144e-02, -4.097993859020600e-04,  3.694123517236298e-06, -3.129331310248345e-08,  2.489950009508646e-10, -1.891518214303287e-12,
  1.385780439324370e-14, -9.851480336005215e-17,  6.825362040813898e-19, -4.622992483656664e-21,  3.069353340129778e-23, -2.001197355455458e-25,  3.605627443679443e-02,
 -3.697730249401234e-04,  4.392863183386520e-06, -4.599845950001299e-08,  4.445536600425262e-10, -4.052851362288823e-12,  3.526288807828417e-14, -2.950583580654637e-16,
  2.387902515536495e-18, -1.877011196280202e-20,  1.438002242316519e-22, -1.076427271895104e-24,  1.911568257179641e-02, -2.788165731004237e-04,  4.141309639634974e-06,
 -5.247664352491776e-08,  6.053676346814531e-10, -6.507179740290409e-12,  6.608940056029798e-14, -6.402995187769711e-16,  5.959223420474435e-18, -5.355676889133529e-20,
  4.667070178489375e-22, -3.955915904740552e-24,  8.643432904409888e-03, -1.739112078443337e-04,  3.150437270928940e-06, -4.773336813400959e-08,  6.488536514256535e-10,
 -8.121089708274519e-12,  9.515681867109291e-14, -1.055707382035971e-15,  1.118086915304410e-17, -1.137333729434147e-19,  1.116465996371665e-21, -1.061566540013470e-23,
  3.332711085188097e-03, -8.980397032628695e-05,  1.959596944179469e-06, -3.517441649233674e-08,  5.579696619012360e-10, -8.059008352756124e-12,  1.080365583291944e-13,
 -1.361748145035641e-15,  1.628872865345229e-17, -1.861879904440570e-19,  2.044663031126446e-21, -2.166223957932363e-23,  1.095765276594078e-03, -3.853900115004424e-05,
  1.005580586107113e-06, -2.122345397566965e-08,  3.900585812248293e-10, -6.458913938197664e-12,  9.845878354776820e-14, -1.401798892842013e-15,  1.883365705142171e-17,
 -2.406286360295934e-19,  2.941100692093589e-21, -3.454781070219793e-23,  3.073007621520744e-04, -1.380626295585927e-05,  4.285054291900348e-07, -1.057002476468615e-08,
  2.238684195670044e-10, -4.229307392720769e-12,  7.297907282563096e-14, -1.168610308617612e-15,  1.756297232398487e-17, -2.498326124565629e-19,  3.385737674833549e-21,
 -4.393291271029248e-23,  7.356314422391618e-05, -4.147252125790785e-06,  1.524468412066929e-07, -4.374266237251529e-09,  1.063379968379156e-10, -2.283721958302224e-12,
  4.445799062139539e-14, -7.981538101787520e-16,  1.337772524991389e-17, -2.112560288791064e-19,  3.165426136694698e-21, -4.524839959085266e-23,  1.505409367924889e-05,
 -1.049409744760361e-06,  4.551033243230082e-08, -1.513471636109418e-09,  4.210484277802405e-11, -1.025217698904446e-12,  2.246175327745306e-14, -4.510787883580248e-16,
  8.413316970724494e-18, -1.471820625038840e-19,  2.433364155150949e-21, -3.824192739500884e-23,  2.640469492998058e-06, -2.248295586696922e-07,  1.146330508493888e-08,
 -4.405817095508798e-10,  1.399614937354910e-11, -3.856577945064964e-13,  9.493132689235725e-15, -2.129110759497414e-16,  4.412368030801528e-18, -8.538468403454222e-20,
  1.555371509459185e-21, -2.683529411871276e-23,  3.986529911933699e-07, -4.103951482576528e-08,  2.452256735544708e-09, -1.086887122647723e-10,  3.936425030593014e-12,
 -1.225860102911969e-13,  3.386362195795356e-15, -8.473167627937224e-17,  1.949137186930302e-18, -4.168171236604449e-20,  8.357543799108712e-22, -1.581474574519263e-23,
  5.215581048712777e-08, -6.435100685439729e-09,  4.493112463470064e-10, -2.292496294019414e-11,  9.454977577464837e-13, -3.324813409125949e-14,  1.029985236642669e-15,
 -2.873323181245803e-17,  7.332198131209512e-19, -1.731663342866456e-20,  3.819450638831213e-22, -7.921490449733423e-24,  5.973514759117597e-09, -8.765978621567669e-10,
  7.131820356715518e-11, -4.182636506618480e-12,  1.962652725763019e-13, -7.788454488802261e-15,  2.704464358700156e-16, -8.408100253481848e-18,  2.379193337571294e-19,
 -6.203103885334093e-21,  1.504395936247300e-22, -3.418063039064040e-24,  6.081050360137636e-10, -1.053893316524048e-10,  9.962358312561917e-12, -6.705718964023798e-13,
  3.576809807566062e-14, -1.600858263824013e-15,  6.228182963631509e-17, -2.157147621672162e-18,  6.766080633480810e-20, -1.946709442092417e-21,  5.189046560170485e-23,
 -1.290944836862703e-24,  5.626405421629689e-11, -1.143535598195044e-11,  1.251937817684529e-12, -9.653857144684164e-14,  5.846480124946486e-15, -2.948700600470301e-16,
  1.284456198764476e-17, -4.953044812194317e-19,  1.721053116941333e-20, -5.461022327883310e-22,  1.598848330662258e-23, -4.352248055685765e-25,  4.885924366349079e-12,
 -1.155727875200636e-12,  1.459469281385000e-13, -1.285872418852794e-14,  8.824481086701774e-16, -5.007510900789983e-17,  2.438905130638697e-18, -1.045753558964004e-19,
  4.020489880467080e-21, -1.405193601425131e-22,  4.513009346955468e-24, -1.342403563420774e-25,  4.166927971631875e-13, -1.136791461767777e-13,  1.646608057454312e-14,
 -1.650707795268233e-15,  1.279337748737375e-16, -8.143905761132089e-18,  4.423050847663942e-19, -2.103467602017961e-20,  8.925802543431056e-22, -3.427938502803234e-23,
  1.204799759669183e-24, -3.906481770609065e-26,  3.712646844411365e-14, -1.154793961406471e-14,  1.902958158319998e-15, -2.156165238034090e-16,  1.876252578238137e-17,
 -1.332788734555773e-18,  8.032148597528165e-20, -4.216939710496147e-21,  1.966153021921968e-22, -8.260956015773369e-24,  3.163729039100644e-25, -1.113472469615371e-26,
  3.741068943217267e-15, -1.306805487323254e-15,  2.420460116805417e-16, -3.067166517903292e-17,  2.968133192765439e-18, -2.331960687210123e-19,  1.546477834100634e-20,
 -8.892137019133836e-22,  4.520830223034913e-23, -2.062791347288590e-24,  8.546787402602714e-26, -3.242360910794534e-27,  4.662774418551874e-16, -1.793384569456349e-16,
  3.668794778554268e-17, -5.116884929556086e-18,  5.425466843470014e-19, -4.649258766446590e-20,  3.348288898827915e-21, -2.082192975731912e-22,  1.140514870966540e-23,
 -5.586584726394893e-25,  2.476526105018492e-26, -1.001889813096238e-27,  7.677869900014573e-17, -3.171313495388447e-17,  6.995156941666595e-18, -1.049687010845810e-18,
  1.193631299741005e-19, -1.093250867491546e-20,  8.387251604390334e-22, -5.538638819153426e-23,  3.211954768406927e-24, -1.661036225046023e-25,  7.753383031998700e-27,
 -3.294210168042479e-28,  1.476322283613457e-17, -6.356484547906005e-18,  1.466105015614259e-18, -2.298089098216827e-19,  2.724717685177590e-20, -2.596863339422367e-21,
  2.069030433135167e-22, -1.416252002838616e-23,  8.497882478183650e-25, -4.539218604866393e-26,  2.185010258901768e-27, -9.558292415196770e-29,  9.189091434188494e-02,
 -3.539656605465824e-04,  1.428653502527682e-06, -5.990095009300584e-09,  2.576738099729306e-11, -1.130205179818416e-13,  4.982833643121213e-16, -2.226990008374458e-18,
  9.778499875696952e-21, -4.460103087415685e-23,  1.863185681594324e-25, -9.381845853597457e-28,  7.811230999181754e-02, -3.763048930210138e-04,  2.273619026748851e-06,
 -1.431548873224308e-08,  8.857542168233354e-11, -5.340320338435302e-13,  3.142420264404229e-15, -1.813197518300760e-17,  1.027303144798525e-19, -5.743423182562321e-22,
  3.159667130537614e-24, -1.726583159999799e-26,  5.643486874552120e-02, -3.816835123396569e-04,  3.341314953629354e-06, -2.759486077195492e-08,  2.142792103538731e-10,
 -1.589709546726532e-12,  1.138174117981654e-14, -7.911573095779618e-17,  5.362403920311543e-19, -3.554627503164688e-21,  2.310699612397173e-23, -1.475388688142855e-25,
  3.464413521177892e-02, -3.367230018617240e-04,  3.881025571500041e-06, -3.949073558322006e-08,  3.713326466881007e-10, -3.297633856944096e-12,  2.797685974158644e-14,
 -2.284333028540115e-16,  1.805242464067374e-18, -1.386363123514808e-20,  1.038233497072648e-22, -7.599738997378730e-25,  1.806290909969649e-02, -2.480496746438492e-04,
  3.565673863695663e-06, -4.375145913238753e-08,  4.897375461958733e-10, -5.116286858312140e-12,  5.056474019640422e-14, -4.771647938490648e-16,  4.329130364458858e-18,
 -3.795270865527821e-20,  3.228187588709307e-22, -2.672197631839618e-24,  7.994801176531348e-03, -1.508340081442176e-04,  2.634943017051163e-06, -3.853636811928825e-08,
  5.070690969324131e-10, -6.155109975131404e-12,  7.004705521573188e-14, -7.556478606614144e-16,  7.789254368073232e-18, -7.718003276050405e-20,  7.385342839792190e-22,
 -6.849400645399283e-24,  3.002374688742488e-03, -7.567519374083777e-05,  1.586173401305311e-06, -2.740744184868891e-08,  4.199098623132617e-10, -5.870450226394936e-12,
  7.629990675076738e-14, -9.336604230146659e-16,  1.085421843473564e-17, -1.206953240803095e-19,  1.290460776220645e-21, -1.332070605072999e-23,  9.562233932016059e-04,
 -3.141603133595487e-05,  7.844640461434075e-07, -1.589976761893296e-08,  2.816518636354147e-10, -4.506065517368442e-12,  6.648976358014505e-14, -9.176910605519280e-16,
  1.196729907793805e-17, -1.485663382651773e-19,  1.766024421470280e-21, -2.019200183400011e-23,  2.582066818622885e-04, -1.083054970576156e-05,  3.206455585643852e-07,
 -7.579735059962105e-09,  1.544429172721176e-10, -2.814416688665349e-12,  4.694063105332221e-14, -7.277243699378288e-16,  1.060324623829719e-17, -1.464010794214142e-19,
  1.927740211666024e-21, -2.432671990250242e-23,  5.911753048612280e-05, -3.111847327320347e-06,  1.088257811645411e-07, -2.987090826515540e-09,  6.974634260980267e-11,
 -1.442777133221970e-12,  2.711358729860752e-14, -4.707394814649385e-16,  7.641571721313704e-18, -1.170234830830127e-19,  1.702341210843102e-21, -2.364855088027594e-23,
  1.148392602709259e-05, -7.479085376487081e-07,  3.079843194969038e-08, -9.783424873452253e-10,  2.610692262890128e-11, -6.115731491314038e-13,  1.292117265795592e-14,
 -2.507063074003293e-16,  4.525132231328363e-18, -7.671308749078802e-20,  1.230544885362815e-21, -1.878356068360367e-23,  1.895771887065033e-06, -1.509788732581618e-07,
  7.300600868427646e-09, -2.677419547792237e-10,  8.150266157207398e-12, -2.158675543492995e-13,  5.120119508525117e-15, -1.108731351236318e-16,  2.222256991556701e-18,
 -4.165177801578243e-20,  7.358310652836900e-22, -1.232665686126728e-23,  2.667684266485452e-07, -2.572899818217073e-08,  1.457352789949479e-09, -6.159943175845666e-11,
  2.136545282045286e-12, -6.392066163032034e-14,  1.700661607126221e-15, -4.106948717556446e-17,  9.134271671592497e-19, -1.891482651577555e-20,  3.677470265907912e-22,
 -6.755840725727446e-24,  3.216807239015936e-08, -3.726831784413636e-09,  2.467395464731622e-10, -1.200590077472944e-11,  4.741584616751791e-13, -1.601687477468679e-14,
  4.778548492115522e-16, -1.286554827459407e-17,  3.174299359439535e-19, -7.260005010064148e-21,  1.552905099878875e-22, -3.127356817927893e-24,  3.352559006736687e-09,
 -4.633244728732706e-10,  3.578352457129226e-11, -2.002735592904796e-12,  9.003507555165004e-14, -3.433650159665014e-15,  1.148742137457093e-16, -3.448291952870650e-18,
  9.438465707645645e-20, -2.384232651246806e-21,  5.610405875573718e-23, -1.238444265679752e-24,  3.060675088747801e-10, -5.014122837739806e-11,  4.508667073679469e-12,
 -2.900461849822011e-13,  1.484031009691306e-14, -6.390125012127357e-16,  2.397715342116786e-17, -8.026199327869554e-19,  2.437565075177889e-20, -6.801602877723752e-22,
  1.760825407443524e-23, -4.260228478815641e-25,  2.498396569315323e-11, -4.822401679281379e-12,  5.037573056294468e-13, -3.721610458228159e-14,  2.166486467810355e-15,
 -1.053221492317215e-16,  4.432525873381457e-18, -1.654723379885042e-19,  5.576218957406113e-21, -1.718690651070187e-22,  4.894693580133011e-24, -1.297770003309509e-25,
  1.880469784888621e-12, -4.248533803302853e-13,  5.140939396897037e-14, -4.354806841056057e-15,  2.881651869731203e-16, -1.580637732660569e-17,  7.457540999193118e-19,
 -3.103400237666751e-20,  1.159899027474710e-21, -3.946933457887043e-23,  1.235831943149969e-24, -3.588344431156890e-26,  1.365250810492044e-13, -3.581865572552308e-14,
  4.998837218999337e-15, -4.841031277562503e-16,  3.633195748727321e-17, -2.244390146773487e-18,  1.185135939053902e-19, -5.488970642586151e-21,  2.271768146608162e-22,
 -8.521202815264159e-24,  2.928665635810866e-25, -9.296768542050408e-27,  1.019331960654222e-14, -3.073214786529415e-15,  4.912513310542004e-16, -5.409564501465963e-17,
  4.583443182068918e-18, -3.175621534477448e-19,  1.869564220187018e-20, -9.601876954175722e-22,  4.385082945300148e-23, -1.806735828425173e-24,  6.792452087520407e-26,
 -2.349119194275720e-27,  8.530913831110550e-16, -2.913382179499838e-16,  5.275402866266537e-17, -6.543207142256297e-18,  6.205910517836292e-19, -4.784736067951074e-20,
  3.117447295721427e-21, -1.762958283217704e-22,  8.823834706576080e-24, -3.967212725249853e-25,  1.620991074526515e-26, -6.069140119615064e-28,  8.876059901822146e-17,
 -3.366235689403452e-17,  6.787579937026891e-18, -9.336787922905539e-19,  9.771765493269714e-20, -8.271883233404409e-21,  5.889111992205073e-22, -3.622870108547904e-23,
  1.964326916477432e-24, -9.530051498019758e-26,  4.186619381460769e-27, -1.679341366042733e-28,  1.254064653177926e-17, -5.145001570866969e-18,  1.126807498728215e-18,
 -1.679295266810637e-19,  1.897174708015712e-20, -1.726977994251145e-21,  1.317257301545250e-22, -8.651333812972549e-24,  4.991302945057357e-25, -2.568703633174749e-26,
  1.193530370843401e-27, -5.049104586324540e-29,  2.185640865394751e-18, -9.391127761027194e-19,  2.161194854727980e-19, -3.380202433745308e-20,  3.999276568324369e-21,
 -3.803943276114380e-22,  3.024945383546026e-23, -2.066788565950152e-24,  1.237964459031615e-25, -6.601694605818179e-27,  3.172762063091259e-28, -1.385819426822780e-29,
  9.049746458189188e-02, -3.428171160316441e-04,  1.359173485761329e-06, -5.595271018019432e-09,  2.362168445762472e-11, -1.017760609659566e-13,  4.400768297015326e-16,
 -1.938408328552144e-18,  8.297398907060730e-21, -3.793806113540551e-23,  1.475886767128137e-25, -8.342555097612985e-28,  7.664241332230187e-02, -3.587797776882509e-04,
  2.109996758806527e-06, -1.297979556428639e-08,  7.860968036307305e-11, -4.643530865769409e-13,  2.677805469072287e-15, -1.515244517683272e-17,  8.415709521214770e-20,
 -4.619321777193092e-22,  2.488961908973510e-24, -1.339988717034176e-26,  5.495957774051012e-02, -3.562215856175753e-04,  3.029744319571992e-06, -2.440662489342941e-08,
  1.850467445828735e-10, -1.341303762714078e-12,  9.388700701728013e-15, -6.383707326277907e-17,  4.234581890829767e-19, -2.748078309133158e-21,  1.749748958328061e-23,
 -1.094378945585557e-25,  3.335647458679918e-02, -3.074741358407065e-04,  3.440720742857208e-06, -3.404261570826674e-08,  3.116082079752708e-10, -2.696849098416147e-12,
  2.231980297141761e-14, -1.779105538108987e-16,  1.373497652266324e-18, -1.030907272779969e-20,  7.549904575599342e-23, -5.405700736108948e-25,  1.712461439165219e-02,
 -2.214985149941037e-04,  3.084496227042950e-06, -3.667260417837260e-08,  3.985409895443301e-10, -4.048585062878754e-12,  3.895469661497992e-14, -3.582141744727831e-16,
  3.169485344677100e-18, -2.711566214080137e-20,  2.252143315045336e-22, -1.821231412430783e-24,  7.430878554260777e-03, -1.314750829769482e-04,  2.217400235126811e-06,
 -3.132345682130172e-08,  3.991997504986449e-10, -4.702089551904805e-12,  5.199827722130410e-14, -5.456870743120780e-16,  5.477143454904791e-18, -5.288550483753396e-20,
  4.934934521062519e-22, -4.465828970318232e-24,  2.723119967307307e-03, -6.419546635725951e-05,  1.294020547486707e-06, -2.153689145593526e-08,  3.188823117404357e-10,
 -4.317398587229926e-12,  5.443180228997655e-14, -6.469265477497463e-16,  7.312574726771897e-18, -7.913417778732889e-20,  8.240780619184590e-22, -8.291003873430355e-24,
  8.420020946326801e-04, -2.583322484179130e-05,  6.179901372693527e-07, -1.203562232913362e-08,  2.056110931226321e-10, -3.179875906242628e-12,  4.543971300514243e-14,
 -6.082440763945421e-16,  7.702035890718432e-18, -9.294089864633573e-20,  1.074860898209447e-21, -1.196609933761419e-23,  2.194928802115343e-04, -8.591116074296548e-06,
  2.428386248078509e-07, -5.504040127455499e-09,  1.079491273704381e-10, -1.898400994562048e-12,  3.061737934871038e-14, -4.597333836958030e-16,  6.496542745265418e-18,
 -8.709459583434960e-20,  1.114639422782410e-21, -1.368349480952758e-23,  4.820849048639441e-05, -2.367634137500543e-06,  7.882748668901457e-08, -2.070667486118837e-09,
  4.645827291983197e-11, -9.260562816026252e-13,  1.680607114824103e-14, -2.822694434602359e-16,  4.439231990142778e-18, -6.594569707024022e-20,  9.315916857978312e-22,
 -1.257986924739421e-23,  8.919636972219904e-06, -5.422113193959358e-07,  2.120964958423071e-08, -6.437561933514044e-10,  1.648279572962199e-11, -3.715877308559717e-13,
  7.572874476482467e-15, -1.420001328103856e-16,  2.480883900187153e-18, -4.076491384281422e-20,  6.345604631327046e-22, -9.409694960671688e-24,  1.391063608560984e-06,
 -1.034982579897134e-07,  4.746706692250219e-09, -1.661267494540257e-10,  4.846596776717153e-12, -1.234082883370363e-13,  2.820907701766813e-15, -5.898662534286122e-17,
  1.143590168794880e-18, -2.076291629184101e-20,  3.557658405061456e-22, -5.787091968601424e-24,  1.831968984865399e-07, -1.653028466473828e-08,  8.873228943610868e-10,
 -3.576307218094846e-11,  1.187873528933806e-12, -3.414161323732811e-14,  8.748697250888724e-16, -2.039070151090119e-17,  4.384711090846346e-19, -8.791994671588759e-21,
  1.657435373551652e-22, -2.955952951392374e-24,  2.045055539736095e-08, -2.221058606236156e-09,  1.393443341070781e-10, -6.463491140902763e-12,  2.443714513135042e-13,
 -7.927832554510858e-15,  2.277415686918645e-16, -5.916640445757644e-18,  1.411202799451616e-19, -3.125100373042884e-21,  6.481386124771871e-23, -1.267216221424911e-24,
  1.948335285129201e-09, -2.530851349038222e-10,  1.853622360474152e-11, -9.893320714586091e-13,  4.258739951237997e-14, -1.560110826946436e-15,  5.026605523174684e-17,
 -1.456303772503434e-18,  3.854386286363472e-20, -9.430117691384675e-22,  2.152317497578792e-23, -4.614304777273634e-25,  1.602321229708559e-10, -2.475808156159576e-11,
  2.114705469417064e-12, -1.298805168914758e-13,  6.368918943598907e-15, -2.636404871463452e-16,  9.534197165368423e-18, -3.082602782353377e-19,  9.059352109909556e-21,
 -2.450193685615371e-22,  6.157311029986989e-24, -1.448033838186093e-25,  1.158618189436423e-11, -2.118535847930886e-12,  2.107894949948483e-13, -1.489823394282710e-14,
  8.326624874198375e-16, -3.897621272493452e-17,  1.583278474216002e-18, -5.717002132610288e-20,  1.866878774168669e-21, -5.584872332248332e-23,  1.546012279724719e-24,
 -3.989714676465429e-26,  7.580975387374656e-13, -1.631456261922752e-13,  1.887689283017898e-14, -1.534690241015182e-15,  9.777209137999863e-17, -5.176962550743831e-18,
  2.363159283395779e-19, -9.533419435794924e-21,  3.460215611426278e-22, -1.145228409333673e-23,  3.492621053214370e-25, -9.890405879174872e-27,  4.690125436815998e-14,
 -1.180000048924156e-14,  1.582996196855722e-15, -1.477974476735695e-16,  1.072219707788397e-17, -6.417437017918244e-19,  3.289866589068365e-20, -1.481920217649992e-21,
  5.974685769647664e-23, -2.186215878801510e-24,  7.339536520374579e-26, -2.278599413667944e-27,  2.928252843694599e-15, -8.534026552725509e-16,  1.320130165394634e-16,
 -1.409831216432455e-17,  1.160905434893797e-18, -7.831696968639361e-20,  4.497033429934847e-21, -2.256116619387328e-22,  1.007857794233507e-23, -4.066989471494881e-25,
  1.499184716280839e-26, -5.089203273295586e-28,  2.022661421590680e-16, -6.737344897619329e-17,  1.190088583951625e-17, -1.441986025694535e-18,  1.338054129299351e-19,
 -1.010732468283664e-20,  6.460237555588766e-22, -3.588176984019252e-23,  1.765785000641586e-24, -7.813411397821950e-26,  3.144859770738541e-27, -1.160874179520151e-28,
  1.738210862499864e-17, -6.489178758205802e-18,  1.287578483177231e-18, -1.744233909948110e-19,  1.799394347290698e-20, -1.502772364000508e-21,  1.056425853707666e-22,
 -6.422139989635501e-24,  3.443414379353064e-25, -1.653123606489718e-26,  7.190709558397590e-28, -2.857578237878974e-29,  2.080145111855074e-18, -8.469269551313573e-19,
  1.840059893986979e-19, -2.721223087248707e-20,  3.051975804590058e-21, -2.759198354402221e-22,  2.091061917726911e-23, -1.365042461986325e-24,  7.830667382705978e-26,
 -4.008336989020989e-27,  1.853028620637762e-28, -7.801713932228423e-30,  3.252170585446442e-19, -1.394158803892427e-19,  3.200431074543024e-20, -4.993456200251021e-21,
  5.894236995967387e-22, -5.593908189604798e-23,  4.438957077889449e-24, -3.026819263316648e-25,  1.809539494116641e-26, -9.632180100173988e-28,  4.621183820021063e-29,
 -2.015142872447351e-30,  8.914752652429506e-02, -3.322060271170072e-04,  1.294232552780390e-06, -5.233052305893409e-09,  2.168753521663149e-11, -9.183674185324439e-14,
  3.893210224278455e-16, -1.693675404088093e-18,  7.029174974715770e-21, -3.275582777583829e-23,  1.116681585813066e-25, -8.149679309815013e-28,  7.524009697851057e-02,
 -3.425021357967420e-04,  1.961490197981113e-06, -1.179298428060978e-08,  6.993243613471582e-11, -4.048873710886589e-13,  2.288869996463959e-15, -1.270737335496111e-17,
  6.918596909998277e-20, -3.732473924500695e-22,  1.966466834629380e-24, -1.048727199079981e-26,  5.358138087028420e-02, -3.331067784912403e-04,  2.753782109043582e-06,
 -2.164882402191155e-08,  1.603367175603584e-10, -1.135979783432189e-12,  7.777010502065602e-15, -5.174310196220881e-17,  3.360465203368967e-19, -2.135669118963029e-21,
  1.332504853776704e-23, -8.164664732331126e-26,  3.217915681795348e-02, -2.815015761970487e-04,  3.060433678869765e-06, -2.946088376337238e-08,  2.626487626661372e-10,
 -2.216308383829886e-12,  1.790174266869714e-14, -1.393573058676675e-16,  1.051452684231641e-18, -7.715704882373079e-21,  5.528364116907399e-23, -3.872535105158875e-25,
  1.628533047579936e-02, -1.984802669858088e-04,  2.680168544861943e-06, -3.089614000655985e-08,  3.261616040342932e-10, -3.223414930541068e-12,  3.020942344739584e-14,
 -2.708159923854846e-16,  2.337871243155519e-18, -1.952562128262741e-20,  1.584231366726814e-22, -1.251934745245255e-24,  6.938220438227012e-03, -1.151375557564938e-04,
  1.876944807685434e-06, -2.562564927153778e-08,  3.164952865507705e-10, -3.619308318807397e-12,  3.891167171961349e-14, -3.974242827731188e-16,  3.885853566638954e-18,
 -3.657754355279265e-20,  3.329731319172105e-22, -2.941174511177469e-24,  2.485519971412988e-03, -5.479646683294094e-05,  1.063555236847049e-06, -1.706029379590171e-08,
  2.442570051690216e-10, -3.204381735675092e-12,  3.920715503718170e-14, -4.527941836691507e-16,  4.978599109134153e-18, -5.245358771495171e-20,  5.322240960111882e-22,
 -5.220871581516458e-24,  7.477153645043012e-04, -2.141556268641815e-05,  4.913798571756789e-07, -9.200697888081312e-09,  1.516714288070138e-10, -2.268660788540307e-12,
  3.141008409338812e-14, -4.079454294660605e-16,  5.018055941537703e-18, -5.888159407796979e-20,  6.627509339620376e-22, -7.186451603917114e-24,  1.886334770878153e-04,
 -6.885885150960780e-06,  1.860186262002924e-07, -4.044661505982658e-09,  7.639675000552648e-11, -1.297179099677630e-12,  2.023908471763098e-14, -2.944592701064630e-16,
  4.037100083641670e-18, -5.256950944958938e-20,  6.541209302983710e-22, -7.814127301022143e-24,  3.985797153211380e-05, -1.825047116273730e-06,  5.789255899206657e-08,
 -1.456013179298721e-09,  3.140492592046496e-11, -6.034618069064747e-13,  1.058002478365620e-14, -1.719657557312881e-16,  2.621015253653195e-18, -3.778045665019684e-20,
  5.184331449669184e-22, -6.806868208342758e-24,  7.046878698629339e-06, -3.994578669956021e-07,  1.485032368557548e-08, -4.308167076437776e-10,  1.058766205898605e-11,
 -2.297789259818175e-13,  4.518423090994620e-15, -8.190307291878643e-17,  1.385415369135745e-18, -2.207002250271081e-20,  3.334567709361056e-22, -4.804489460578117e-24,
  1.042033065859691e-06, -7.234660978255974e-08,  3.147552241125221e-09, -1.051431889438386e-10,  2.940429397058012e-12, -7.199431691899884e-14,  1.586271827624193e-15,
 -3.203588733808297e-17,  6.008569051013304e-19, -1.056887181657776e-20,  1.756666917093736e-22, -2.774985108842460e-24,  1.289509419153244e-07, -1.087057038742284e-08,
  5.528947836069438e-10, -2.124785947152549e-11,  6.758653623863385e-13, -1.866281270151659e-14,  4.606163232219348e-16, -1.036176533351494e-17,  2.154325340175324e-19,
 -4.182979161079447e-21,  7.646140840557398e-23, -1.323833768153304e-24,  1.338468526736424e-08, -1.360449850770381e-09,  8.083732004337738e-11, -3.573346685768897e-12,
  1.293073721353310e-13, -4.028174559873861e-15,  1.114056538918537e-16, -2.792457832247095e-18,  6.437878800123270e-20, -1.380223957366948e-21,  2.775201523742728e-23,
 -5.267082527889550e-25,  1.171075371434191e-09, -1.427049104150186e-10,  9.902662470843764e-12, -5.037113046120413e-13,  2.075217923991217e-14, -7.299519226244879e-16,
  2.264188960711129e-17, -6.329128380426143e-19,  1.619268799027786e-20, -3.835888621354684e-22,  8.489303707344279e-24, -1.767112376189767e-25,  8.716795534059915e-11,
 -1.267480999845075e-11,  1.027027292561595e-12, -6.016281582907109e-14,  2.825220591213976e-15, -1.123525513081816e-16,  3.913575394183761e-18, -1.221474096846940e-19,
  3.471906773999244e-21, -9.097067527035257e-23,  2.218032173435626e-24, -5.067835697959521e-26,  5.608144138420754e-12, -9.689615142112990e-13,  9.167043077451064e-14,
 -6.190228272951529e-15,  3.317865790436289e-16, -1.493914114108024e-17,  5.852220422484438e-19, -2.042257961648100e-20,  6.457389395080371e-22, -1.873600103052067e-23,
  5.037868034335362e-25, -1.264568923941723e-26,  3.201431491997307e-13, -6.544213557829733e-14,  7.225329398330743e-15, -5.628179678709908e-16,  3.447014936917233e-17,
 -1.759558105892454e-18,  7.761755463507810e-20, -3.032169023171063e-21,  1.067668170509307e-22, -3.433659694628241e-24,  1.019016052324029e-25, -2.811867701021467e-27,
  1.690915084078783e-14, -4.067576857733120e-15,  5.232865508093326e-16, -4.700749614306928e-17,  3.290630511219682e-18, -1.905169093598413e-19,  9.468182917265918e-21,
 -4.142434911159715e-22,  1.624883740910825e-23, -5.793415198305531e-25,  1.897752240759336e-26, -5.756043763905028e-28,  8.817958604254073e-16, -2.476921620565267e-16,
  3.698638100786667e-17, -3.822379857090641e-18,  3.052923697824102e-19, -2.001843057825205e-20,  1.119327855885819e-21, -5.477286130679437e-23,  2.390113326168987e-24,
 -9.433839625102087e-26,  3.405610374550129e-27, -1.133473190554863e-28,  4.999330790874198e-17, -1.620007781237568e-17,  2.784987604891722e-18, -3.289571161228516e-19,
  2.980745426061331e-20, -2.202146438673728e-21,  1.378607871379953e-22, -7.509541458831140e-24,  3.628587572554032e-25, -1.578221363752911e-26,  6.250045328951452e-28,
 -2.272096747732427e-29,  3.511206651014438e-18, -1.287887499453017e-18,  2.510062218742422e-19, -3.343019891502557e-20,  3.394253319528057e-21, -2.792801265362374e-22,
  1.936105668215160e-23, -1.161700193581159e-24,  6.152864603256010e-26, -2.920033745418630e-27,  1.256445065761236e-28, -4.942430130401117e-30,  3.510328954048286e-19,
 -1.416920884460138e-19,  3.050782793845058e-20, -4.472864955805803e-21,  4.975755990466455e-22, -4.464094503960808e-23,  3.358887294897154e-24, -2.177933420563492e-25,
  1.241494435895645e-26, -6.317160908961562e-28,  2.904043911009669e-29, -1.216242938687726e-30,  4.866447010012313e-20, -2.080801910012587e-20,  4.763451876790999e-21,
 -7.412070651947032e-22,  8.726548333940026e-23, -8.261564251431027e-24,  6.540551253574106e-25, -4.449980999661085e-26,  2.654768864094424e-27, -1.410313977008795e-28,
  6.753355173535193e-30, -2.939606401433429e-31,  8.783902057272834e-02, -3.220975905676282e-04,  1.233458917747913e-06, -4.900253626675673e-09,  1.994052301327865e-11,
 -8.303775527631115e-14,  3.448756422257774e-16, -1.486818233711072e-18,  5.921558717415459e-21, -2.902651452544092e-23,  7.402753267357503e-26, -9.218690646125184e-28,
  7.390060207806280e-02, -3.273578524560886e-04,  1.826430022958976e-06, -1.073597922243157e-08,  6.235643935759285e-11, -3.539858866606619e-13,  1.962142056536035e-15,
 -1.069409222100725e-17,  5.706005487133597e-20, -3.031306035954665e-22,  1.555154944891116e-24, -8.318248264093386e-27,  5.229142833235081e-02, -3.120737167470542e-04,
  2.508670353872558e-06, -1.925552369210479e-08,  1.393722424872156e-10, -9.655695991011144e-13,  6.467888917315044e-15, -4.212352018773224e-17,  2.679503741513725e-19,
 -1.668053463616901e-21,  1.020413701558830e-23, -6.123845818579498e-26,  3.109997502383827e-02, -2.583640121682131e-04,  2.730726741173752e-06, -2.559103045129036e-08,
  2.223215643184138e-10, -1.829930743712258e-12,  1.443189178993954e-14, -1.097594830877520e-16,  8.097045205223225e-19, -5.810620236709238e-21,  4.075541027329508e-23,
 -2.792786951375118e-25,  1.553206309175689e-02, -1.784378732571636e-04,  2.338719833859857e-06, -2.615634162722249e-08,  2.683704414297593e-10, -2.581537497791830e-12,
  2.357640275292399e-14, -2.061279426573951e-16,  1.736887964918806e-18, -1.416634898150515e-20,  1.123321281236507e-22, -8.676697809001979e-25,  6.505868457399531e-03,
 -1.012711312397089e-04,  1.597586421827366e-06, -2.109361860581453e-08,  2.526143344071266e-10, -2.806042217572028e-12,  2.934365576124086e-14, -2.918083466331128e-16,
  2.780597590570901e-18, -2.552565225462003e-20,  2.267755663426124e-22, -1.955856988952924e-24,  2.282142172455693e-03, -4.704503979105061e-05,  8.803200584622986e-07,
 -1.361776435992593e-08,  1.886382876538677e-10, -2.399154562727750e-12,  2.850233485477530e-14, -3.199941000838529e-16,  3.423919482799093e-18, -3.513460000906822e-20,
  3.474843707255507e-22, -3.324622780231688e-24,  6.692699470474520e-04, -1.788810299439985e-05,  3.941574228158360e-07, -7.099562591169172e-09,  1.129974989925068e-10,
 -1.635533075434440e-12,  2.195021906748340e-14, -2.767271945945804e-16,  3.308027147813042e-18, -3.775904848023420e-20,  4.137846614097447e-22, -4.371676569541527e-24,
  1.637857772403646e-04, -5.572913147712627e-06,  1.440390550539819e-07, -3.006031755349928e-09,  5.471134722921796e-11, -8.973647084154558e-13,  1.355079081645324e-14,
 -1.911057481646485e-16,  2.543034031464265e-18, -3.217556908510033e-20,  3.893819714736903e-22, -4.527855383596533e-24,  3.338436092662553e-05, -1.424088252248173e-06,
  4.307758376768375e-08, -1.037773298882741e-09,  2.152900400166364e-11, -3.989710250663276e-13,  6.760197364580661e-15, -1.063729829353828e-16,  1.571771971522959e-18,
 -2.199085064877472e-20,  2.932107999834139e-22, -3.744165233740599e-24,  5.657559426136741e-06, -2.987691544043871e-07,  1.056243814683518e-08, -2.929848798318687e-10,
  6.913829215376072e-12, -1.444979362864829e-13,  2.742567834934481e-15, -4.807131842393981e-17,  7.874940185087691e-19, -1.216527529669554e-20,  1.784468778385309e-22,
 -2.498692696360286e-24,  7.960166832013671e-07, -5.151063028420728e-08,  2.126551193703818e-09, -6.781687233392710e-11,  1.818487124621922e-12, -4.282355180726093e-14,
  9.096934905632747e-16, -1.774755653978618e-17,  3.220859278147403e-19, -5.489617891312192e-21,  8.852237027142251e-23, -1.358178070782965e-24,  9.292665133783601e-08,
 -7.308377558657638e-09,  3.521924305455880e-10, -1.290564389722804e-11,  3.931607613640124e-13, -1.043112389605007e-14,  2.479914392630459e-16, -5.384849748612566e-18,
  1.082559231819607e-19, -2.035542876933302e-21,  3.607984272661495e-23, -6.064573446120706e-25,  9.007336296397870e-09, -8.553961302157774e-10,  4.811894796940707e-11,
 -2.026580439918314e-12,  7.018089489401822e-14, -2.099153625866581e-15,  5.588833251891547e-17, -1.351500701275541e-18,  3.011502182298198e-20, -6.250130009223397e-22,
  1.218257646706829e-23, -2.244233027205138e-25,  7.271319442846352e-10, -8.296100563559865e-11,  5.449964407463290e-12, -2.640586847592487e-13,  1.040767203502423e-14,
 -3.513978263367016e-16,  1.049040776775401e-17, -2.828546059061267e-19,  6.993606025926477e-21, -1.603715648787118e-22,  3.440690342781961e-24, -6.952242964156474e-26,
  4.922418781795861e-11, -6.720541059399347e-12,  5.159654832612398e-13, -2.880286576241031e-14,  1.294364617431252e-15, -4.942085415812115e-17,  1.657244668970082e-18,
 -4.990679930330553e-20,  1.371342326489764e-21, -3.479497181910862e-23,  8.227584248357881e-25, -1.825627491505991e-26,  2.831279050851628e-12, -4.610512754660793e-13,
  4.140622450218480e-14, -2.667992600946254e-15,  1.369929045392120e-16, -5.927930418098359e-18,  2.237573676204658e-19, -7.540782955793843e-21,  2.307028481564900e-22,
 -6.487891169421428e-24,  1.693419234203264e-25, -4.131978555827186e-27,  1.415981646582783e-13, -2.741528800911765e-14,  2.882330986211753e-15, -2.147595660056539e-16,
  1.262678672445930e-17, -6.205963761551385e-19,  2.642476724094896e-20, -9.985932146353898e-22,  3.407821030334111e-23, -1.063974732087176e-24,  3.070022541599234e-26,
 -8.247945474003610e-28,  6.402099034430723e-15, -1.467972676125764e-15,  1.806683484518788e-16, -1.558376386156610e-17,  1.050786167089793e-18, -5.875727126511599e-20,
  2.826763572530077e-21, -1.199633106901444e-22,  4.572553293536183e-24, -1.586741927547816e-25,  5.066052042246593e-27, -1.499661743770056e-28,  2.788285457569850e-16,
 -7.525402177239739e-17,  1.081917617101527e-17, -1.079559939080098e-18,  8.346631002970406e-20, -5.310018961653677e-21,  2.886455035649402e-22, -1.375582036242037e-23,
  5.855221647485151e-25, -2.257556868410644e-26,  7.971391346446251e-28, -2.598173521432147e-29,  1.291526323022453e-17, -4.059914700747732e-18,  6.775521007089570e-19,
 -7.784258044177892e-20,  6.873821870420952e-21, -4.957717899376482e-22,  3.034799529693458e-23, -1.618747759059593e-24,  7.669071809377924e-26, -3.274337998329398e-27,
  1.274251142682817e-28, -4.556749460601551e-30,  7.337306558879436e-19, -2.638489313240043e-19,  5.040819554232630e-20, -6.588318374614069e-21,  6.572516792427222e-22,
 -5.319716479674320e-23,  3.631689161585872e-24, -2.148003415944499e-25,  1.122464031747628e-26, -5.260128597228507e-28,  2.236632523572976e-29, -8.700565186302633e-31,
  6.039124199164087e-20, -2.413815283334428e-20,  5.144458801373265e-21, -7.469357893987690e-22,  8.233382992939719e-23, -7.323633168282996e-24,  5.466393781320137e-25,
 -3.517900881971097e-26,  1.991229846224201e-27, -1.006523937703180e-28,  4.598370717418463e-30, -1.914633378938150e-31,  7.327935291717397e-21, -3.124204029329633e-21,
  7.129832060735046e-22, -1.106073525782202e-22,  1.298479736867371e-23, -1.225937142260272e-24,  9.680479245035371e-26, -6.570179817445487e-27,  3.910556960122482e-28,
 -2.072874033687634e-29,  9.905369047171041e-31, -4.303104871628211e-32,  8.657000062821599e-02, -3.124598309418180e-04,  1.176516778498946e-06, -4.594055362927354e-09,
  1.835927259083174e-11, -7.523984557517470e-14,  3.057440940429416e-16, -1.313559503551625e-18,  4.919496830541247e-21, -2.694927015111608e-23,  2.761600444137479e-26,
 -1.227962823429193e-27,  7.261960087001101e-02, -3.132453002496737e-04,  1.703358878358736e-06, -9.792453522049196e-09,  5.572440657420492e-11, -3.102910343847875e-13,
  1.686711437508556e-15, -9.031453062509161e-18,  4.718348570087428e-20, -2.477443125770993e-22,  1.225517757381787e-24, -6.757459534125327e-27,  5.108186042184285e-02,
 -2.928921245956887e-04,  2.290372794022741e-06, -1.717200908908733e-08,  1.215223895551018e-10, -8.235776540695896e-13,  5.399977169327272e-15, -3.443610925463559e-17,
  2.146421148035494e-19, -1.309005637678889e-21,  7.858043727519375e-24, -4.614115162377191e-26,  3.010834753694620e-02, -2.376887604447394e-04,  2.443827718507595e-06,
 -2.230884975785121e-08,  1.889520196523097e-10, -1.517699238247837e-12,  1.169203821261358e-14, -8.690375717610703e-17,  6.271308795268078e-19, -4.401706671033905e-21,
  3.024750461734410e-23, -2.026205984467505e-25,  1.485384135520588e-02, -1.609143557256183e-04,  2.048997966314930e-06, -2.224657202230377e-08,  2.219610965012977e-10,
 -2.079124210274101e-12,  1.851205385985398e-14, -1.579096221783646e-16,  1.299358910564297e-18, -1.035231539357923e-20,  8.027059794913150e-23, -6.060222638206439e-25,
  6.124833877942946e-03, -8.943825213725349e-05,  1.366978756793504e-06, -1.746509929472233e-08,  2.029227220526043e-10, -2.190577862038038e-12,  2.229215581127730e-14,
 -2.159366935517078e-16,  2.006154593970502e-18, -1.796659831575924e-20,  1.558473398222997e-22, -1.312730568509693e-24,  2.107080100087347e-03, -4.060824191033942e-05,
  7.335452952704796e-07, -1.094908711901669e-08,  1.468293646840395e-10, -1.811315092075581e-12,  2.090385549233287e-14, -2.282456374333528e-16,  2.377627224905528e-18,
 -2.377180857723344e-20,  2.292520967579996e-22, -2.140019546857888e-24,  6.035248197932254e-04, -1.504719960237473e-05,  3.188169843827715e-07, -5.527099083116257e-09,
  8.498415110730227e-11, -1.190896803042371e-12,  1.550026941997076e-14, -1.897667125246695e-16,  2.205461551002316e-18, -2.449756356834473e-20,  2.614674610039649e-22,
 -2.692427122582897e-24,  1.435896363037649e-04, -4.551266342240249e-06,  1.126793404533341e-07, -2.258224932081340e-09,  3.962615994076349e-11, -6.281333782128032e-13,
  9.184343701667594e-15, -1.256063707619426e-16,  1.622902293439572e-18, -1.995866665700994e-20,  2.349922665058877e-22, -2.660726744260970e-24,  2.830591256029219e-05,
 -1.123978617528787e-06,  3.245378298731002e-08, -7.492483514528497e-10,  1.495731704526689e-11, -2.674419757090138e-13,  4.381339690707687e-15, -6.676657877554044e-17,
  9.567524242596413e-19, -1.299711292215838e-20,  1.684331775650206e-22, -2.092394979627871e-24,  4.611607031105913e-06, -2.266508443482227e-07,  7.625425650586019e-09,
 -2.023181193046887e-10,  4.586224131719982e-12, -9.234095140129931e-14,  1.692232301929515e-15, -2.869077616072235e-17,  4.553152003612337e-19, -6.822686107910768e-21,
  9.718515205576499e-23, -1.322811812292432e-24,  6.194661575626037e-07, -3.731694815240465e-08,  1.462486622974273e-09, -4.453672917015978e-11,  1.145415803970462e-12,
 -2.595021000863482e-14,  5.316162450433604e-16, -1.002140220276637e-17,  1.760166608239738e-19, -2.907509902907895e-21,  4.549441909815920e-23, -6.780502006106501e-25,
  6.847982789186738e-08, -5.017352264671903e-09,  2.291062811060947e-10, -8.005670468415866e-12,  2.336116520876750e-13, -5.956093207388154e-15,  1.364174305415759e-16,
 -2.859587345182171e-18,  5.559425241313827e-20, -1.012404275928849e-21,  1.740206816282774e-23, -2.839938069533409e-25,  6.224904637982466e-09, -5.514051855885111e-10,
  2.935701957983162e-11, -1.177816104247395e-12,  3.903124973292783e-14, -1.120893423021423e-15,  2.872832776656681e-17, -6.702125996416024e-19,  1.443376378986170e-20,
 -2.899817524188894e-22,  5.479085865889172e-24, -9.796427713214485e-26,  4.658088412763558e-10, -4.966220314468513e-11,  3.086390982954270e-12, -1.423779373899999e-13,
  5.366993477726982e-15, -1.738930445772332e-16,  4.995227747903357e-18, -1.298906989351934e-19,  3.103091369297070e-21, -6.886790951603919e-23,  1.432069448119179e-24,
 -2.808316671403566e-26,  2.882163818941863e-11, -3.686408988493499e-12,  2.678607531807687e-13, -1.423808636201852e-14,  6.119308192861184e-16, -2.242090864269853e-17,
  7.234599031585463e-19, -2.101189743128038e-20,  5.579297036168280e-22, -1.370313922228475e-23,  3.141252744591580e-25, -6.766564953021217e-27,  1.489547921460743e-12,
 -2.280216553578049e-13,  1.940910605752622e-14, -1.191941115775825e-15,  5.857476187801084e-17, -2.433834154261251e-18,  8.845427975149863e-20, -2.876785864135601e-21,
  8.510470166522084e-23, -2.318293886344695e-24,  5.870366731700468e-26, -1.391585464766597e-27,  6.557117985333659e-14, -1.198959620590165e-14,  1.197929572282977e-15,
 -8.524023292181663e-17,  4.804673915081753e-18, -2.271019689225080e-19,  9.324017654922887e-21, -3.405150631354494e-22,  1.125201455252144e-23, -3.407546527686104e-25,
  9.551699485033509e-27, -2.496506927626071e-28,  2.546746902973874e-15, -5.548560694134648e-16,  6.517077593836636e-17, -5.386857690529670e-18,  3.492647541715635e-19,
 -1.883325209038918e-20,  8.758717825453466e-22, -3.600895039924010e-23,  1.332123983057889e-24, -4.494069098881019e-26,  1.397015763186244e-27, -4.032062185731341e-29,
  9.272170422791671e-17, -2.396575768862245e-17,  3.308395268667212e-18, -3.179985038217566e-19,  2.375122899814306e-20, -1.463343926097164e-21,  7.720271023344232e-23,
 -3.577682228474699e-24,  1.483353406075439e-25, -5.579415316343869e-27,  1.924562212492015e-28, -6.135839227809388e-30,  3.496475543678055e-18, -1.062939965406062e-18,
  1.717428141953112e-19, -1.914583544580726e-20,  1.644080465457388e-21, -1.155392933188740e-22,  6.903443041038319e-24, -3.599875674014742e-25,  1.669704847141730e-26,
 -6.988212545580574e-28,  2.669007612552175e-29, -9.377324500692966e-31,  1.591051679298526e-19, -5.595536606361942e-20,  1.045545018863352e-20, -1.338274308092059e-21,
  1.309327592159530e-22, -1.040718262949328e-23,  6.985775705664360e-25, -4.067122688155004e-26,  2.094171211103381e-27, -9.678888379979854e-29,  4.062378360658284e-30,
 -1.561125418732623e-31,  1.061653062143658e-20, -4.196109012382908e-21,  8.840236464020812e-22, -1.269501231047671e-22,  1.385010210531117e-23, -1.220172004319957e-24,
  9.025931197166665e-26, -5.760059692931779e-27,  3.234833404119818e-28, -1.623144831229638e-29,  7.364404478535507e-31, -3.046551632294370e-32,  1.111261859058710e-21,
 -4.722231602841626e-22,  1.073903082920197e-22, -1.660334825512237e-23,  1.942879910514450e-24, -1.828751522354916e-25,  1.439902848952414e-26, -9.746153978951906e-28,
  5.786013571003872e-29, -3.059560596187479e-30,  1.458673979197959e-31, -6.323034068435670e-33,  8.533864332706584e-02, -3.032633294842276e-04,  1.123102204054689e-06,
 -4.311958882938439e-09,  1.692496325933099e-11, -6.832644600079089e-14,  2.710233793195287e-16, -1.171559455921918e-18,  3.954854309246202e-21, -2.707570948963351e-23,
 -3.820852910478880e-26, -1.814301979446073e-27,  7.139314997844182e-02, -3.000737677205794e-04,  1.591001083951005e-06, -8.948393122842915e-09,  4.990376127700601e-11,
 -2.726818293476099e-13,  1.453692349961027e-15, -7.655381691762918e-18,  3.907858013750670e-20, -2.043286384909503e-22,  9.528447661997084e-25, -5.715325014269852e-27,
  4.994567788533102e-02, -2.753615522520012e-04,  2.095453219290023e-06, -1.535269611572551e-08,  1.062725639503761e-10, -7.048140569800836e-13,  4.525252020690322e-15,
 -2.826463837841742e-17,  1.727192135765593e-19, -1.031734954590279e-21,  6.087417048811706e-24, -3.487609776790539e-26,  2.919506790214720e-02, -2.191597803315954e-04,
  2.193306454712263e-06, -1.951399122529663e-08,  1.612181539039721e-10, -1.264160759854762e-12,  9.517434740619148e-15, -6.915380653442220e-17,  4.884606923404768e-19,
 -3.352630155496068e-21,  2.260542302660039e-23, -1.477217988756706e-25,  1.424135841563883e-02, -1.455328446034063e-04,  1.802049426988902e-06, -1.900513760456170e-08,
  1.844862640489602e-10, -1.683517497847612e-12,  1.462080412660622e-14, -1.217219804317939e-16,  9.785793855568095e-19, -7.617006196745971e-21,  5.780073202743695e-23,
 -4.263097753321103e-25,  5.787698940422392e-03, -7.928870238918195e-05,  1.175521208594370e-06, -1.454169168611787e-08,  1.640066408202202e-10, -1.721423860716366e-12,
  1.705541599958658e-14, -1.609898491721436e-16,  1.458923488939251e-18, -1.275034419425289e-20,  1.080436095944664e-22, -8.888860429547818e-25,  1.955604689790921e-03,
 -3.522808443713171e-05,  6.151391130947945e-07, -8.864396830589147e-09,  1.151436212047346e-10, -1.378447339982823e-12,  1.546112822745598e-14, -1.642532950048516e-16,
  1.666489951791478e-18, -1.623979081946993e-20,  1.527795025344727e-22, -1.391819905024626e-24,  5.480474360967168e-04, -1.274053605967328e-05,  2.599251428940661e-07,
 -4.339356673439690e-09,  6.449389198005130e-11, -8.754250690421170e-13,  1.105542003824958e-14, -1.314948748080940e-16,  1.486381766677843e-18, -1.607254370256567e-20,
  1.671413985967395e-22, -1.678029973461130e-24,  1.270298642080259e-04, -3.748330588388450e-06,  8.900594879698928e-08, -1.713829430188115e-09,  2.901059031138670e-11,
 -4.446487487494326e-13,  6.298128341250550e-15, -8.356211735702537e-17,  1.048727427030244e-18, -1.254071456376470e-20,  1.437032671884092e-22, -1.584815665965181e-24,
  2.427756658913794e-05, -8.966161981502427e-07,  2.473910215911380e-08, -5.475872164946295e-10,  1.052477362557635e-11, -1.816537221989844e-13,  2.878482932837945e-15,
 -4.249747732966440e-17,  5.908014157355746e-19, -7.795193299512637e-21,  9.821662574882471e-23, -1.187314328589143e-24,  3.813226884174797e-06, -1.742385226472269e-07,
  5.583407847560501e-09, -1.417525934924795e-10,  3.088105377271480e-12, -5.992375469825429e-14,  1.060702326937715e-15, -1.740102986977560e-17,  2.676009370752718e-19,
 -3.890653470339957e-21,  5.383173907425388e-23, -7.124182386629210e-25,  4.906063415572404e-07, -2.747863663612944e-08,  1.022888613103233e-09, -2.975396097874545e-11,
  7.341914282777821e-13, -1.600760112851300e-14,  3.163392412754328e-16, -5.763467364726672e-18,  9.799527199016542e-20, -1.569147995863944e-21,  2.382936141570858e-23,
 -3.450587784684129e-25,  5.154676617321373e-08, -3.513251194818642e-09,  1.520436283259948e-10, -5.066965655164163e-12,  1.416561914032966e-13, -3.471283771662748e-15,
  7.660873898717866e-17, -1.550524175336425e-18,  2.915522062860455e-20, -5.142700186329785e-22,  8.573312513490628e-24, -1.358531429753290e-25,  4.412495964128909e-09,
 -3.639563247862874e-10,  1.833636949181433e-11, -7.007489203200738e-13,  2.222184666951212e-14, -6.127316612497372e-16,  1.511818206943186e-17, -3.402681542608651e-19,
  7.082673594912982e-21, -1.377456254349754e-22,  2.522911307355471e-24, -4.378107142007733e-26,  3.074806975741260e-10, -3.057280239756307e-11,  1.796467788021883e-12,
 -7.887571924251083e-14,  2.842932552871367e-15, -8.837825136323710e-17,  2.442482431635812e-18, -6.124126731913003e-20,  1.413445044295326e-21, -3.035544862504403e-23,
  6.117169681181749e-25, -1.164046414173016e-26,  1.747639393938525e-11, -2.089320203040181e-12,  1.435367699176910e-13, -7.259971357032443e-15,  2.982552041525553e-16,
 -1.048204723617641e-17,  3.253299221304867e-19, -9.109562828338759e-21,  2.336646456772213e-22, -5.553437392945232e-24,  1.233766753919107e-25, -2.579210296313145e-27,
  8.158362206967531e-13, -1.170961723166176e-13,  9.432913630608373e-15, -5.515136122193436e-16,  2.591644497298861e-17, -1.033250635516936e-18,  3.613231488766593e-20,
 -1.133354976003251e-21,  3.240185667824758e-23, -8.544953938962839e-25,  2.098031521757583e-26, -4.829299853400958e-28,  3.177420363478974e-14, -5.470577822498593e-15,
  5.184259577819378e-16, -3.517587825192760e-17,  1.898417378663680e-18, -8.619996249858208e-20,  3.409064243632981e-21, -1.202056190144482e-22,  3.842833268483503e-24,
 -1.127892879415663e-25,  3.069021666480842e-27, -7.797910079855617e-29,  1.064654464700378e-15, -2.196716822954623e-16,  2.456433781181540e-17, -1.941890380635625e-18,
  1.208615017158943e-19, -6.275273043141082e-21,  2.817394285753764e-22, -1.120697206299861e-23,  4.019238047931548e-25, -1.316784238742600e-26,  3.981332363331798e-28,
 -1.119264138735099e-29,  3.246932419104581e-17, -8.009218953935925e-18,  1.058694493433970e-18, -9.779381601769028e-20,  7.041657703673875e-21, -4.193834351893486e-22,
  2.143821970861571e-23, -9.645798707734926e-25,  3.889989147587833e-26, -1.425487520222110e-27,  4.797467180537792e-29, -1.494343447392291e-30,  9.944858252011625e-19,
 -2.913938865349642e-19,  4.545071262867523e-20, -4.904133264808259e-21,  4.086060225550650e-22, -2.792266580981255e-23,  1.625480326451441e-24, -8.272611318658385e-26,
  3.750643500999844e-27, -1.536556371649108e-28,  5.751713608787020e-30, -1.982924502389046e-31,  3.591864265906815e-20, -1.232034935684367e-20,  2.245879147382486e-21,
 -2.808904710889733e-22,  2.689693071140861e-23, -2.095631297635122e-24,  1.380789963734487e-25, -7.900921543915956e-27,  4.002898772294068e-28, -1.822253265208895e-29,
  7.540382610754441e-31, -2.859344923494391e-32,  1.912131488534069e-21, -7.461345449521169e-22,  1.551441737663004e-22, -2.200422208429964e-23,  2.372915183761605e-24,
 -2.068009422840433e-25,  1.514425190091232e-26, -9.574211686713508e-28,  5.329897231097245e-29, -2.652543265086595e-30,  1.194283803173993e-31, -4.905217316901450e-33,
  1.698665203451519e-22, -7.191426557002482e-23,  1.628955902164007e-23, -2.508863330236944e-24,  2.925177889331712e-25, -2.743953891630686e-26,  2.153566361482720e-27,
 -1.453258910565782e-28,  8.602995217924658e-30, -4.536907901570031e-31,  2.157519115464674e-32, -9.329968526116039e-34,  8.414323830060444e-02, -2.944809839026205e-04,
  1.072939513400033e-06, -4.051749195291742e-09,  1.562089288833211e-11, -6.220214343075479e-14,  2.398418810315783e-16, -1.061064583443800e-18,  2.931272119670309e-21,
 -3.043482666149518e-23, -1.358429804316884e-25, -2.644281159978252e-27,  7.021764947869991e-02, -2.877621106082929e-04,  1.488237104751896e-06, -8.191736841776527e-09,
  4.478235082594327e-11, -2.402306587790462e-13,  1.255792700690017e-15, -6.515683223495333e-18,  3.235015833533457e-20, -1.710333052398411e-22,  7.165491816478684e-25,
 -5.075466281606096e-27,  4.887663156586127e-02, -2.593069840450146e-04,  1.920976260329927e-06, -1.375946267952958e-08,  9.320132712550923e-11, -6.051130850342619e-13,
  3.805955078015550e-15, -2.328774629035967e-17,  1.396145022159796e-19, -8.162590657180574e-22,  4.748066394382816e-24, -2.639522721074013e-26,  2.835209809288887e-02,
 -2.025079929717026e-04,  1.973819632996497e-06, -1.712498368580992e-08,  1.380709590719587e-10, -1.057317314180128e-12,  7.782988506058872e-15, -5.529160570968036e-17,
  3.825919729448426e-19, -2.565803166113214e-21,  1.702422270093138e-23, -1.080713555374643e-25,  1.368668305586904e-02, -1.319809561131568e-04,  1.590646074053611e-06,
 -1.630475287675420e-08,  1.540661094451091e-10, -1.370216522302175e-12,  1.161275002228455e-14, -9.438284545480116e-17,  7.418330420455056e-19, -5.640177317692418e-21,
  4.194534890348219e-23, -3.018298361995226e-25,  5.488307003627154e-03, -7.054040342740268e-05,  1.015697477729663e-06, -1.217221585305817e-08,  1.333319058539574e-10,
 -1.361307093953654e-12,  1.313782464330918e-14, -1.208852644233039e-16,  1.069123822162489e-18, -9.119500353572097e-21,  7.554650631759514e-23, -6.069429676313666e-25,
  1.823902492467645e-03, -3.070311511432975e-05,  5.189716454486421e-07, -7.223950957140428e-09,  9.094181427559427e-11, -1.057044158802548e-12,  1.152849683806755e-14,
 -1.192104005706645e-16,  1.178550605382826e-18, -1.119729253813359e-20,  1.028124912329611e-22, -9.142274890304683e-25,  5.009374251864913e-04, -1.085312452753131e-05,
  2.135099922467862e-07, -3.434267698954672e-09,  4.936612698741072e-11, -6.493943516083169e-13,  7.960904047959142e-15, -9.202982243181401e-17,  1.012223624920203e-18,
 -1.065887791253261e-20,  1.080412690562328e-22, -1.057838203915845e-24,  1.133406976965313e-04, -3.111282128275421e-06,  7.095612712494505e-08, -1.313323289050388e-09,
  2.145760996584122e-11, -3.181589645813620e-13,  4.367532851531667e-15, -5.624024970079528e-17,  6.858767312841527e-19, -7.977728321746009e-21,  8.900216093849655e-23,
 -9.563371886385989e-25,  2.104901672490377e-05, -7.223784192671005e-07,  1.906968141872511e-08, -4.048711064160523e-10,  7.496182526409321e-12, -1.249474675121225e-13,
  1.915911726683242e-15, -2.741521452299541e-17,  3.698857266289569e-19, -4.741721374876562e-21,  5.810457491119662e-23, -6.837249883560768e-25,  3.195910262210836e-06,
 -1.356182746084530e-07,  4.143351499303466e-09, -1.006973238349555e-10,  2.109234644723942e-12, -3.946194885116366e-14,  6.749445465387449e-16, -1.071766211587837e-17,
  1.597703170855329e-19, -2.254504833169431e-21,  3.030806202509458e-23, -3.900881349523500e-25,  3.950496342044935e-07, -2.054591796937780e-08,  7.269587474878155e-10,
 -2.020471021838039e-11,  4.785209048559809e-13, -1.004391966687124e-14,  1.915293440614372e-16, -3.373575430561401e-18,  5.554196988669175e-20, -8.623323095709662e-22,
  1.271244603238241e-23, -1.788842220309289e-25,  3.958954614900192e-08, -2.506279634152748e-09,  1.028353813464582e-10, -3.269036414436092e-12,  8.758005544616221e-14,
 -2.063225700393678e-15,  4.388418211534886e-17, -8.577480915375185e-19,  1.560218270837376e-20, -2.666116955806176e-22,  4.311292997351511e-24, -6.634283369542527e-26,
  3.204244676536554e-09, -2.456746414821676e-10,  1.171227863947429e-11, -4.263534265212457e-13,  1.293903157984035e-14, -3.425832285371314e-16,  8.137938120140880e-18,
 -1.767208133567563e-19,  3.555491561284181e-21, -6.694084110494730e-23,  1.188550491708770e-24, -2.001871260162829e-26,  2.088759281400669e-10, -1.933002058653829e-11,
  1.073471218252422e-12, -4.484683598838229e-14,  1.545341284050993e-15, -4.608751221089155e-17,  1.225300875215045e-18, -2.962159248012499e-20,  6.604258520688062e-22,
 -1.372391098598893e-23,  2.679886134350420e-25, -4.947981308303544e-27,  1.096047946833892e-11, -1.221931889613533e-12,  7.930072921814512e-14, -3.814377440889026e-15,
  1.497241494090588e-16, -5.045482422660254e-18,  1.505779219718102e-19, -4.063797728506791e-21,  1.006674989273964e-22, -2.314568622631418e-24,  4.982125657135873e-26,
 -1.010512405571386e-27,  4.646735736470364e-13, -6.236678799333338e-14,  4.748306650421874e-15, -2.640500147522950e-16,  1.185584073359613e-17, -4.532370788311037e-19,
  1.524129008544985e-20, -4.608267763165935e-22,  1.272558860335153e-23, -3.247362848337505e-25,  7.727411856853726e-27, -1.726370819890210e-28,  1.610008161018759e-14,
 -2.602195859798726e-15,  2.334561649370404e-16, -1.508301203794026e-17,  7.784844191708908e-19, -3.392175676233661e-20,  1.291077108567062e-21, -4.391674410961442e-23,
  1.357205923692463e-24, -3.857815056228773e-26,  1.018253732005277e-27, -2.513398440662389e-29,  4.677164107056691e-16, -9.108503808163888e-17,  9.673798325955959e-18,
 -7.299978597648189e-19,  4.354338016333459e-20, -2.173793043527278e-21,  9.409590301697258e-23, -3.617140969123357e-24,  1.256207054870977e-25, -3.992601403313012e-27,
  1.172989432331711e-28, -3.208992949999663e-30,  1.198613984025973e-17, -2.811356814953437e-18,  3.548274492168777e-19, -3.142398157145370e-20,  2.176874119375674e-21,
 -1.250978481175115e-22,  6.185820698515873e-24, -2.698142417484456e-25,  1.056886649246883e-26, -3.768259299148651e-28,  1.235820843377628e-29, -3.756480488323671e-31,
  2.978946016035967e-19, -8.382361204724133e-20,  1.258313286838564e-20, -1.310653874314479e-21,  1.057084975387877e-22, -7.009660591076697e-24,  3.968108917646622e-25,
 -1.967548653930880e-26,  8.705617235714311e-28, -3.485848038932020e-29,  1.277072602983143e-30, -4.314559368347626e-32,  8.470960149806886e-21, -2.825137073511666e-21,
  5.010215920517497e-22, -6.107726215147065e-23,  5.711418289400962e-24, -4.353244475191340e-25,  2.810384456154668e-26, -1.577864258760070e-27,  7.853682411489396e-29,
 -3.516531492166414e-30,  1.432717237556796e-31, -5.354539560450822e-33,  3.538925970143818e-22, -1.360781143793192e-22,  2.787539424604642e-23, -3.898301676524852e-24,
  4.149138465240480e-25, -3.572241311391051e-26,  2.586569278227686e-27, -1.618118130545034e-28,  8.920088111953638e-30, -4.398860698970648e-31,  1.963685907849088e-32,
 -8.001193098981318e-34,  2.620092444590344e-23, -1.104499368699876e-23,  2.490563085842814e-24, -3.819264696351365e-25,  4.434817422185505e-26, -4.144089940161465e-27,
  3.240728214747779e-28, -2.179492566883585e-29,  1.286112266795058e-30, -6.762195453684400e-32,  3.206684497365328e-33, -1.383018462404818e-34,  8.298217934053860e-02,
 -2.860877954386682e-04,  1.025778061280776e-06, -3.811464422232239e-09,  1.443205590477078e-11, -5.679291228174901e-14,  2.112717050041661e-16, -9.860845675188621e-19,
  1.707692676645967e-21, -3.841565707354412e-23, -2.674362137029716e-25, -3.200252509350762e-27,  6.908980698597948e-02, -2.762375911504410e-04,  1.394081955988532e-06,
 -7.512078576019869e-09,  4.026493143226873e-11, -2.121694274826256e-13,  1.086957761887898e-15, -5.573889450938570e-18,  2.665641988242816e-20, -1.466865515117245e-22,
  5.047766422772546e-25, -4.514736412881628e-27,  4.786912814666349e-02, -2.445751660028052e-04,  1.764426152667913e-06, -1.236030952557925e-08,  8.196217652917339e-11,
 -5.211158953615012e-13,  3.212276670622320e-15, -1.925574073757049e-17,  1.133864859388178e-19, -6.475488965655838e-22,  3.733900168368196e-24, -2.001168321098426e-26,
  2.757239671674397e-02, -1.875034235244956e-04,  1.780908306129837e-06, -1.507537262875351e-08,  1.186739327697104e-10, -8.878009868712708e-13,  6.393224537843436e-15,
 -4.440387893905962e-17,  3.014189192411203e-19, -1.970805935177606e-21,  1.293419387221685e-23, -7.939964588555770e-26,  1.318302694157077e-02, -1.199984982958551e-04,
  1.408921751457532e-06, -1.404463930110535e-08,  1.292478861267539e-10, -1.120717338372936e-12,  9.274013602672345e-15, -7.359337754408073e-17,  5.660442473313248e-19,
 -4.200155034674867e-21,  3.068620995804958e-23, -2.150962176972605e-25,  5.221520066110334e-03, -6.296478701518664e-05,  8.815847968262680e-07, -1.024066773585910e-08,
  1.090034386022927e-10, -1.083034522029322e-12,  1.018652419796853e-14, -9.139137932934004e-17,  7.893463248752273e-19, -6.570597474074017e-21,  5.327254805813829e-23,
 -4.178202551291650e-25,  1.708877477919293e-03, -2.687486979962018e-05,  4.403627691530726e-07, -5.924038551592553e-09,  7.231794275213203e-11, -8.164992117349281e-13,
  8.663230430526279e-15, -8.722517876802686e-17,  8.407115427733267e-19, -7.788872810840410e-21,  6.984424977082654e-23, -6.062975839166425e-25,  4.606978177697186e-04,
 -9.297385584375505e-06,  1.766407099285831e-07, -2.738746282015423e-09,  3.809764693093117e-11, -4.859213180578538e-13,  5.785317513624587e-15, -6.502731006107505e-17,
  6.962513753625256e-19, -7.141853774244792e-21,  7.059327083767991e-23, -6.742544919430255e-25,  1.019387003510529e-04, -2.601285247155505e-06,  5.706327928861967e-08,
 -1.015705660387069e-09,  1.602686055515463e-11, -2.299974689803950e-13,  3.061363347969854e-15, -3.827488199611824e-17,  4.537716385402644e-19, -5.135584341120012e-21,
  5.580215270580621e-23, -5.843745676047902e-25,  1.843649486114502e-05, -5.873907125120734e-07,  1.485582983822595e-08, -3.026642347753794e-10,  5.401171427493265e-12,
 -8.698262745321411e-14,  1.291219219332467e-15, -1.791441818487617e-17,  2.346607842536669e-19, -2.923726358435527e-21,  3.485547443196193e-23, -3.993559760730210e-25,
  2.712815287483854e-06, -1.067859538142832e-07,  3.114020510285601e-09, -7.247587618448379e-11,  1.460370242921412e-12, -2.635407520761039e-14,  4.357177470255887e-16,
 -6.699520892393966e-18,  9.684333420971473e-20, -1.326714263620748e-21,  1.733408854819115e-23, -2.170339511893379e-25,  3.231272339943441e-07, -1.558370646711371e-08,
  5.245404720844310e-10, -1.393448741720511e-11,  3.168861814434505e-13, -6.405419624421033e-15,  1.179047012615056e-16, -2.008367075162173e-18,  3.202623921442145e-20,
 -4.822418721953093e-22,  6.902839508545641e-24, -9.441168962781922e-26,  3.099126636711147e-08, -1.819489652362460e-09,  7.081817295747097e-11, -2.147900333301732e-12,
  5.516023104494888e-14, -1.249597362107339e-15,  2.562197843392154e-17, -4.837422625566350e-19,  8.513666183067761e-21, -1.409643445727490e-22,  2.211465464722931e-24,
 -3.305181467371914e-26,  2.380899436194822e-09, -1.693812453197786e-10,  7.642357909101736e-12, -2.650070463010567e-13,  7.697735835461710e-15, -1.957310624965634e-16,
  4.476960067551054e-18, -9.381204075591078e-20,  1.824529033158260e-21, -3.325757629199660e-23,  5.724665185318475e-25, -9.358935925812709e-27,  1.458356330275813e-10,
 -1.253548224465862e-11,  6.577413365580218e-13, -2.614181355019941e-14,  8.611252694546691e-16, -2.463692628215284e-17,  6.300950284775907e-19, -1.468626594240660e-20,
  3.162951879401691e-22, -6.359510663695761e-24,  1.203272193707756e-25, -2.155459823286688e-27,  7.100454671702222e-12, -7.364531694026427e-13,  4.511589040172523e-14,
 -2.062719215655403e-15,  7.733499805889109e-17, -2.498160991404287e-18,  7.167299787030616e-20, -1.863919374071316e-21,  4.458135064464435e-23, -9.914124180299378e-25,
  2.067191310096026e-26, -4.067126700625343e-28,  2.748954861638755e-13, -3.440858484451984e-14,  2.472851262219178e-15, -1.306790260274078e-16,  5.602559505465528e-18,
 -2.052555998977191e-19,  6.634031030797612e-21, -1.932575938999604e-22,  5.152543000680450e-24, -1.271756500509208e-25,  2.931768584338877e-27, -6.354512937828939e-29,
  8.522862792522460e-15, -1.289173186826946e-15,  1.092988568899226e-16, -6.715017137327405e-18,  3.310966941259933e-19, -1.383218947962979e-20,  5.062291124894107e-22,
 -1.659889771410773e-23,  4.955309363276262e-25, -1.363166517943581e-26,  3.487881126607269e-28, -8.358326791860690e-30,  2.158708768549804e-16, -3.954056999815122e-17,
  3.979170670686067e-18, -2.861021802423373e-19,  1.632998109524374e-20, -7.827858047802658e-22,  3.262880559588906e-23, -1.210769444512798e-24,  4.067640354139790e-26,
 -1.252947226897298e-27,  3.573459519805892e-29, -9.504862683676826e-31,  4.668191134004006e-18, -1.037151292946548e-18,  1.246276234039185e-19, -1.055684091394853e-20,
  7.021501549800037e-22, -3.886355542174779e-23,  1.855884616273505e-24, -7.835848645357923e-26,  2.977142543341649e-27, -1.031442922903692e-28,  3.292267758073119e-30,
 -9.754516188352876e-32,  9.418988527978130e-20, -2.535275080224234e-20,  3.651004514361894e-21, -3.660967100092373e-22,  2.851345935522045e-23, -1.830778463481680e-24,
  1.005855787341368e-25, -4.850446855137890e-27,  2.090979234146266e-28, -8.170690066970054e-30,  2.925515668616529e-31, -9.672809537892335e-33,  2.094418137695988e-21,
 -6.768140781117961e-22,  1.164150645406965e-22, -1.379531356205873e-23,  1.256751867765458e-24, -9.350512818745352e-26,  5.903036447212230e-27, -3.246047087338419e-28,
  1.584713970400993e-29, -6.968515416419193e-31,  2.791500276389713e-32, -1.026885772160062e-33,  6.753024751480552e-23, -2.553136918891239e-23,  5.141752948949979e-24,
 -7.076616232712733e-25,  7.421159108880024e-26, -6.302258208317962e-27,  4.505668250402818e-28, -2.785625458859830e-29,  1.518865878683659e-30, -7.414043906033814e-32,
  3.278300515548007e-33, -1.323954516004319e-34,  4.083083771049451e-24, -1.712760439655983e-24,  3.842217642692077e-25, -5.862932731329893e-26,  6.776269195216659e-27,
 -6.304541838671137e-28,  4.910198114855341e-29, -3.289708276338264e-30,  1.934331249373019e-31, -1.013643833556798e-32,  4.791675090489594e-34, -2.060518412558430e-35,
  8.185395636676314e-02, -2.780606803030302e-04,  9.813893492505505e-07, -3.589372188990327e-09,  1.334469262876893e-11, -5.204889915125648e-14,  1.842021931943616e-16,
 -9.558987119911506e-19,  9.955541372059257e-23, -5.174361618203035e-23, -3.886991340190421e-25, -1.727725591195243e-27,  6.800660606253482e-02, -2.654348767582699e-04,
  1.307666865034080e-06, -6.900420779041844e-09,  3.627024909089964e-11, -1.878636278363532e-13,  9.420626746807788e-16, -4.801851165150429e-18,  2.169379747725522e-20,
 -1.301732108164884e-22,  3.306337121023973e-25, -3.146595123054057e-27,  4.691814937993685e-02, -2.310315236894992e-04,  1.623639955768158e-06, -1.112828063983671e-08,
  7.226916418503390e-11, -4.501017290465005e-13,  2.720604529799563e-15, -1.597316698213571e-17,  9.256461720946343e-20, -5.143251358137973e-22,  2.960641191954794e-24,
 -1.543582626065758e-26,  2.684977568462234e-02, -1.739487929679023e-04,  1.610836478866743e-06, -1.331070501916365e-08,  1.023569461277920e-10, -7.482555191540120e-13,
  5.274959898538555e-15, -3.580023989928512e-17,  2.390006340920382e-19, -1.516829046254129e-21,  9.910379439516566e-24, -5.938632558115161e-26,  1.272455578399672e-02,
 -1.093677398012607e-04,  1.252091547495012e-06, -1.214456007745475e-08,  1.089024076356649e-10, -9.209532511758680e-13,  7.445843262776505e-15, -5.767967427392946e-17,
  4.348310579975869e-19, -3.142646276765435e-21,  2.262598009795410e-23, -1.550330047045894e-25,  4.983027774651285e-03, -5.637557578910050e-05,  7.684870797107079e-07,
 -8.657436369864035e-09,  8.959411296589629e-11, -8.666158719465542e-13,  7.948369092699197e-15, -6.953911550190230e-17,  5.871124877582469e-19, -4.766177017884629e-21,
  3.787449533465140e-23, -2.903751194317037e-25,  1.607999797601788e-03, -2.361782261181029e-05,  3.757123889267375e-07, -4.887073317855452e-09,  5.788398515244843e-11,
 -6.350903565029613e-13,  6.558972805769621e-15, -6.431775156700060e-17,  6.047763301017928e-19, -5.463431243134751e-21,  4.788214691326727e-23, -4.060262659011706e-25,
  4.261400959844322e-04, -8.006049653213515e-06,  1.471352690349985e-07, -2.199963914543279e-09,  2.963228486344986e-11, -3.666246564809827e-13,  4.241395314526289e-15,
 -4.636914018238848e-17,  4.835545944728894e-19, -4.832700205201488e-21,  4.660497885002122e-23, -4.344202635130926e-25,  9.237510219982903e-05, -2.189498935048959e-06,
  4.627359381753822e-08, -7.924203708809471e-10,  1.208263844561385e-11, -1.679008579549065e-13,  2.167965430361125e-15, -2.632719285567054e-17,  3.035599697092381e-19,
 -3.343851892789749e-21,  3.540127432734392e-23, -3.614454295892312e-25,  1.630353535985759e-05, -4.817249015923838e-07,  1.168998527416782e-08, -2.286353990061537e-10,
  3.934786712255158e-12, -6.125249878673030e-14,  8.806566111674012e-16, -1.185122465326173e-17,  1.507768261594490e-19, -1.826414006744846e-21,  2.119053893817826e-23,
 -2.364752237712081e-25,  2.330499894614044e-06, -8.499207076386753e-08,  2.368792074888622e-09, -5.281642920849648e-11,  1.024305063798989e-12, -1.783747511296986e-14,
  2.851926218749722e-16, -4.247582646430455e-18,  5.955949281446630e-20, -7.924023805074604e-22,  1.006506443011996e-23, -1.226268735364968e-25,  2.682360343049600e-07,
 -1.197886951639265e-08,  3.839705095293923e-10, -9.752652284099661e-12,  2.130567183023951e-13, -4.149030765454070e-15,  7.374583247532285e-17, -1.215194983548899e-18,
  1.877464140096078e-20, -2.742544256316573e-22,  3.812716704597502e-24, -5.069764980615865e-26,  2.470208344822429e-08, -1.342743026279048e-09,  4.961087438468499e-11,
 -1.435967087105151e-12,  3.536165235755682e-14, -7.705642366330796e-16,  1.523543203126673e-17, -2.779173572077906e-19,  4.733649533852796e-21, -7.595876899567983e-23,
  1.156307419833884e-24, -1.678766914549593e-26,  1.808118224481613e-09, -1.191325152627475e-10,  5.088801605674380e-12, -1.681094417291189e-13,  4.674738816290913e-15,
 -1.141735302979027e-16,  2.515007223198874e-18, -5.086089947153350e-20,  9.563494847076864e-22, -1.687939613084951e-23,  2.817047899279266e-25, -4.470599281203293e-27,
  1.045180548290071e-10, -8.326861558393815e-12,  4.127709480110840e-13, -1.560572590977361e-14,  4.914220033437786e-16, -1.348791902702776e-17,  3.318455772109118e-19,
 -7.457448577588911e-21,  1.551466749005272e-22, -3.018224014613306e-24,  5.533358737271722e-26, -9.616542980775873e-28,  4.745089864596103e-12, -4.567690701644397e-13,
  2.639905724983978e-14, -1.146820129029840e-15,  4.105741691861320e-17, -1.271114192452793e-18,  3.505282971200934e-20, -8.782680123744219e-22,  2.027940480013010e-23,
 -4.361232478210028e-25,  8.807407541562776e-27, -1.680595546212627e-28,  1.686962979575800e-13, -1.963819609497182e-14,  1.330778009999688e-15, -6.677998695617284e-17,
  2.732209034089817e-18, -9.588058005771505e-20,  2.977252142689757e-21, -8.353109145603872e-23,  2.149399680255959e-24, -5.129480435245272e-26,  1.145168243888635e-27,
 -2.407263312533918e-29,  4.708612951270964e-15, -6.644522371337982e-16,  5.314783217884170e-17, -3.101267663721527e-18,  1.459386139009061e-19, -5.840515699152370e-21,
  2.053833457610156e-22, -6.487134645464069e-24,  1.869562851328509e-25, -4.974321897526858e-27,  1.233071402525496e-28, -2.867142011068616e-30,  1.046229314801339e-16,
 -1.795983266838325e-17,  1.708687894031605e-18, -1.168513588726930e-19,  6.372780477497299e-21, -2.929511400477663e-22,  1.174525825867547e-23, -4.202737563167392e-25,
  1.364499093671124e-26, -4.069656407926452e-28,  1.125771186957519e-29, -2.908866370292616e-31,  1.919126120742485e-18, -4.022695646312521e-19,  4.588866843013519e-20,
 -3.709250133412354e-21,  2.363960714658337e-22, -1.258012280275131e-23,  5.792484852169410e-25, -2.363934072030645e-26,  8.699863935436252e-28, -2.925109484615394e-29,
  9.076317024137559e-31, -2.618270586808975e-32,  3.149979115954505e-20, -8.076371149569792e-21,  1.112013946022425e-21, -1.070406777515989e-22,  8.030907232811212e-24,
 -4.981913721093859e-25,  2.651231253257475e-26, -1.241107457097070e-27,  5.204076115233651e-29, -1.981420499229622e-30,  6.923490622580025e-32, -2.237237075139731e-33,
  5.448568754889605e-22, -1.699442009100469e-22,  2.825612608442176e-23, -3.245363395875494e-24,  2.872828284609596e-25, -2.081633274577342e-26,  1.282388785584929e-27,
 -6.893556943523808e-29,  3.295107689732211e-30, -1.420707548418793e-31,  5.587317305730571e-33, -2.020260928207785e-34,  1.333607676685301e-23, -4.944684569365954e-24,
  9.766257508366696e-25, -1.319951168590911e-25,  1.361195852599649e-26, -1.138215933131088e-27,  8.021928973430489e-29, -4.894348613482195e-30,  2.636089949993736e-31,
 -1.272156065211591e-32,  5.565688013148630e-34, -2.225600104941425e-35,  6.438308042201739e-25, -2.685332886140609e-25,  5.988187746276707e-26, -9.085830406268577e-27,
  1.044562455343790e-27, -9.670474519540536e-29,  7.497049840043347e-30, -5.001276299070426e-31,  2.928935341008734e-32, -1.529087807705686e-33,  7.202866160481137e-35,
 -3.087188575750270e-36,  8.075714810481929e-02, -2.703783032167012e-04,  9.395643743721363e-07, -3.383953847929160e-09,  1.234574935201694e-11, -4.795069918879304e-14,
  1.571797382340349e-16, -9.855825518778064e-19, -2.047953859587343e-21, -6.722215252383767e-23, -3.306893278258687e-25,  5.877038725022457e-27,  6.696527835444359e-02,
 -2.552951743206107e-04,  1.228223627249036e-06, -6.348970881230111e-09,  3.272856832990566e-11, -1.667933455084019e-13,  8.166420354089037e-16, -4.180297635705006e-18,
  1.722016505196571e-20, -1.187961280432173e-22,  2.679462556091554e-25,  9.892056645987905e-28,  4.601918265263973e-02, -2.185575661383100e-04,  1.496752451084127e-06,
 -1.004058887521577e-08,  6.388550766929441e-11, -3.898558139334894e-13,  2.312196822511629e-15, -1.328576503499814e-17,  7.602550154789541e-20, -4.085690433903411e-22,
  2.345675765965030e-24, -1.290848779854170e-26,  2.617878014269828e-02, -1.616742681785492e-04,  1.460461823088750e-06, -1.178616210661909e-08,  8.858089307891330e-11,
 -6.328689780959187e-13,  4.371933522418418e-15, -2.895426058145163e-17,  1.909386765796893e-19, -1.168606308421689e-21,  7.585696541890162e-24, -4.775476356094579e-26,
  1.230623535218948e-02, -9.990566423365038e-05,  1.116233644726323e-06, -1.054028679795983e-08,  9.214723173684272e-11, -7.601596416287176e-13,  6.009780744121890e-15,
 -4.541310922289688e-17,  3.364634902110514e-19, -2.361020565524539e-21,  1.674344107395021e-23, -1.154374325536049e-25,  4.769196048041591e-03, -5.062011955430645e-05,
  6.726587644147827e-07, -7.352850178262671e-09,  7.402202475037241e-11, -6.972458330347084e-13,  6.240454033696569e-15, -5.322772580996737e-17,  4.399772742675819e-19,
 -3.479064174288502e-21,  2.710033337997996e-23, -2.051815366533004e-25,  1.519189509006413e-03, -2.083187123324322e-05,  3.222313340025229e-07, -4.054566276781243e-09,
  4.662103518709708e-11, -4.972682381103298e-13,  5.001893560437387e-15, -4.777450635901123e-17,  4.386579868028733e-19, -3.862845525460769e-21,  3.309767616741523e-23,
 -2.751520285541315e-25,  3.963135512363042e-04, -6.927029194336912e-06,  1.233552101110623e-07, -1.779388437751982e-09,  2.322095993660358e-11, -2.788114263015718e-13,
  3.135901113760222e-15, -3.335355187245631e-17,  3.389877369608936e-19, -3.301168259320751e-21,  3.107040494160880e-23, -2.830435568087862e-25,  8.430158498168484e-05,
 -1.854297895747868e-06,  3.782218536834867e-08, -6.233674868862746e-10,  9.190457096935884e-12, -1.237201285153781e-13,  1.550484070540318e-15, -1.829436516257194e-17,
  2.052537561412574e-19, -2.201171031055743e-21,  2.271349385821194e-23, -2.262472966021341e-25,  1.454769619547875e-05, -3.981954222767895e-07,  9.287107004353902e-09,
 -1.744345742921356e-10,  2.896795439297007e-12, -4.360891461043671e-14,  6.075440092973814e-16, -7.933174752443170e-18,  9.807005238660036e-20, -1.155322836567358e-21,
  1.304958265027829e-23, -1.418981649374833e-25,  2.024778639221488e-06, -6.832319471530942e-08,  1.822658284622405e-09, -3.894652753191008e-11,  7.273788051624491e-13,
 -1.222849381804350e-14,  1.891528156598113e-16, -2.729851686912234e-18,  3.714437890579937e-20, -4.800759460091899e-22,  5.930062672257745e-24, -7.032477459155510e-26,
  2.257971043887993e-07, -9.323015925321413e-09,  2.849363641435492e-10, -6.921879695842771e-12,  1.453347001079062e-13, -2.727716407588661e-15,  4.683417738674474e-17,
 -7.468139324547087e-19,  1.118253669032610e-20, -1.585141190200037e-22,  2.140827732042143e-24, -2.768219908852415e-26,  2.002793444218278e-08, -1.006218253320793e-09,
  3.532321738382085e-11, -9.759712310408294e-13,  2.305535197045749e-14, -4.834172153316635e-16,  9.219483596484108e-18, -1.625350294145433e-19,  2.679890745228252e-21,
 -4.168575823689101e-23,  6.158834678513994e-25, -8.687622875422567e-27,  1.401823150593124e-09, -8.537423732808122e-11,  3.454344586553548e-12, -1.087302919001964e-13,
  2.895262343075466e-15, -6.793675192712148e-17,  1.441524169339163e-18, -2.813966389925450e-20,  5.116428291705282e-22, -8.745272836392724e-24,  1.415292578529332e-25,
 -2.180534055251772e-27,  7.679374059116182e-11, -5.658107799440662e-12,  2.650062211601546e-13, -9.530366514176179e-15,  2.869160828812013e-16, -7.555269405074639e-18,
  1.788330143619841e-19, -3.875083912248273e-21,  7.788063082128413e-23, -1.466004126706159e-24,  2.604248248132398e-26, -4.391094979592253e-28,  3.266788073890912e-12,
 -2.911282187305001e-13,  1.586782376368793e-14, -6.547771289155907e-16,  2.238114410057845e-17, -6.640061486303863e-19,  1.759830259490946e-20, -4.247818418593784e-22,
  9.467913173172027e-24, -1.968869695326485e-25,  3.850534020341071e-27, -7.125128956198584e-29,  1.072452626674913e-13, -1.157821326068587e-14,  7.391266508244060e-16,
 -3.519769357977935e-17,  1.373622049948627e-18, -4.615565936843063e-20,  1.376463964191084e-21, -3.718211342346356e-23,  9.231161087041713e-25, -2.129407450156932e-26,
  4.602551073384742e-28, -9.380546556651044e-30,  2.711678238996186e-15, -3.558363693140848e-16,  2.681203000241380e-17, -1.484334934371752e-18,  6.660594209842679e-20,
 -2.551647020595992e-21,  8.616053645966793e-23, -2.619931030560031e-24,  7.284942705588059e-26, -1.873699449296239e-27,  4.497467285235143e-29, -1.014168024775840e-30,
  5.320678352355314e-17, -8.528357749212306e-18,  7.654025517464391e-19, -4.970368748601124e-20,  2.586588594941518e-21, -1.138920186125911e-22,  4.387455237267613e-24,
 -1.512417762100219e-25,  4.741111597275226e-27, -1.368005414369588e-28,  3.667434945786010e-30, -9.198399360070042e-32,  8.329789339628036e-19, -1.640431286887783e-19,
  1.771394052426152e-20, -1.363221694493402e-21,  8.308864969770026e-23, -4.244077500125671e-24,  1.881363844198770e-25, -7.410910959437574e-27,  2.638447491470479e-28,
 -8.598715983673567e-30,  2.590713570266232e-31, -7.268487758103911e-33,  1.116184354904357e-20, -2.713800610134718e-21,  3.560166175485683e-22, -3.280282628245135e-23,
  2.364863574256611e-24, -1.414241670509899e-25,  7.275459702244838e-27, -3.300245528703371e-28,  1.343742356198005e-29, -4.977294997940248e-31,  1.694770136555594e-32,
 -5.344868504646447e-34,  1.496788949183282e-22, -4.486749071586763e-23,  7.184909847849275e-24, -7.973231850386736e-25,  6.839239649813988e-26, -4.814365919250983e-27,
  2.887771504429530e-28, -1.514434503026318e-29,  7.074572865680778e-31, -2.985641462761312e-32,  1.150931461437176e-33, -4.084460140780745e-35,  2.737002339135269e-24,
 -9.922051058111998e-25,  1.916591755636587e-25, -2.537428328516628e-26,  2.567497376680809e-27, -2.109749337688693e-28,  1.463184574054474e-29, -8.795581120446471e-31,
  4.672607184971787e-32, -2.226387013894098e-33,  9.625650472710211e-35, -3.806913939212473e-36,  1.029065988924068e-25, -4.263549911522455e-26,  9.442097676907264e-27,
 -1.423301578376803e-27,  1.626373135074406e-28, -1.497190111310292e-29,  1.154620837035742e-30, -7.664978758008248e-32,  4.468560629520669e-33, -2.323010892992851e-34,
  1.089948988545279e-35, -4.654363913994285e-37,  7.969041538774442e-02, -2.630209315632626e-04,  9.001111105787694e-07, -3.193898553168146e-09,  1.142217516502215e-11,
 -4.451925662348389e-14,  1.282881667742967e-16, -1.091613550630906e-18, -4.601236895348166e-21, -7.038073267567350e-23,  3.243336423725205e-25,  2.683942221801024e-26,
  6.596327895540605e-02, -2.457654805348268e-04,  1.155071178971861e-06, -5.850974548025802e-09,  2.957951991796176e-11, -1.485401216996531e-13,  7.066813048515840e-16,
 -3.695389668389989e-18,  1.316814908062647e-20, -1.047696854200488e-22,  5.076830244877846e-25,  1.126086328008097e-26,  4.516816111724656e-02, -2.070486915379036e-04,
  1.382150521149426e-06, -9.077904280558120e-09,  5.661455187560659e-11, -3.385651694820655e-13,  1.972166390424037e-15, -1.107127438444900e-17,  6.287068041491697e-20,
 -3.259665681786542e-22,  1.781609195995746e-24, -1.332103647999448e-26,  2.555458750267368e-02, -1.505331416135784e-04,  1.327131692764376e-06, -1.046468955345741e-08,
  7.691051990821506e-11, -5.370176496297606e-13,  3.640824433635578e-15, -2.346279791696871e-17,  1.538370278699703e-19, -9.059474635989708e-22,  5.557827965010166e-24,
 -4.635629238891032e-26,  1.192370529457208e-02, -9.145777138376748e-05,  9.981188866479524e-07, -9.180131284883353e-09,  7.828935997324783e-11, -6.300412090653276e-13,
  4.877037897661915e-15, -3.588642036265981e-17,  2.623695592735250e-19, -1.785253988056468e-21,  1.220111385630630e-23, -9.399399653597442e-26,  4.576946384281576e-03,
 -4.557266160579001e-05,  5.910955353314716e-07, -6.272399080240093e-09,  6.146185367402381e-11, -5.638771582591136e-13,  4.929753696350743e-15, -4.095972203760012e-17,
  3.322349155496190e-19, -2.557611513694415e-21,  1.936863651418491e-23, -1.506637976069760e-25,  1.440726535090993e-03, -1.843667444018407e-05,  2.777439115885539e-07,
 -3.382097998964294e-09,  3.777545615055346e-11, -3.918087521398485e-13,  3.841513497561026e-15, -3.572889859682855e-17,  3.207661359087215e-19, -2.753299593402841e-21,
  2.299744352779206e-23, -1.901000504698999e-25,  3.704522740553641e-04, -6.019680774867048e-06,  1.040601741047110e-07, -1.448670491187954e-09,  1.832760024112341e-11,
 -2.136326143199948e-13,  2.337580941947202e-15, -2.418996352598921e-17,  2.398076708386966e-19, -2.275942879587029e-21,  2.088876046991169e-23, -1.869111013911347e-25,
  7.744546918939627e-05, -1.579317980247685e-06,  3.114850770920405e-08, -4.942552517948716e-10,  7.050225528660119e-12, -9.198062085199994e-14,  1.119428586415397e-15,
 -1.283654595269440e-17,  1.402206789245180e-19, -1.464390587864202e-21,  1.472671498617370e-23, -1.433857652273360e-25,  1.309128222346652e-05, -3.315449865352917e-07,
  7.445576851072896e-09, -1.343406390480280e-10,  2.154117128084956e-12, -3.137389337750322e-14,  4.237511347837310e-16, -5.370715814576446e-18,  6.454211132029306e-20,
 -7.396929197000344e-22,  8.135255049827988e-24, -8.626748424645471e-26,  1.777945136604782e-06, -5.543061940666204e-08,  1.417790887308966e-09, -2.904213166463468e-11,
  5.226462016242334e-13, -8.486213077129487e-15,  1.270538833088871e-16, -1.777410391084641e-18,  2.347791116417521e-20, -2.948748217673604e-22,  3.543042549013555e-24,
 -4.091685921778814e-26,  1.925887618755985e-07, -7.340026109756647e-09,  2.142056624026646e-10, -4.978331689630463e-12,  1.005153809610085e-13, -1.818925552863735e-15,
  3.018062243874103e-17, -4.658699071050321e-19,  6.763061694832580e-21, -9.305617912113382e-23,  1.221248628799199e-24, -1.536106706116257e-26,  1.650203338018435e-08,
 -7.648717952469839e-10,  2.554092032366203e-11, -6.737993625181014e-13,  1.527581624416962e-14, -3.083043763436724e-16,  5.673500443775020e-18, -9.669379837462877e-20,
  1.543763491632302e-21, -2.328352367967315e-23,  3.339424936967161e-25, -4.577790477418058e-27,  1.108321757259202e-09, -6.226328123004662e-11,  2.388117748242608e-12,
 -7.163420709931776e-14,  1.827128111494972e-15, -4.120102952676707e-17,  8.423229210558987e-19, -1.587537574806127e-20,  2.791748069734284e-22, -4.621971396073909e-24,
  7.254450432695415e-26, -1.085248265838261e-27,  5.777384346246544e-11, -3.927607931376352e-12,  1.738648444806768e-13, -5.947738933918560e-15,  1.712138804272893e-16,
 -4.326102636172078e-18,  9.852778968578597e-20, -2.058832777688967e-21,  3.997690358102820e-23, -7.281948421755740e-25,  1.253525556671218e-26, -2.050717497004249e-28,
  2.313827007654760e-12, -1.904052939035572e-13,  9.785448494128760e-15, -3.834741243329629e-16,  1.251378579630960e-17, -3.557584593090657e-19,  9.061492163173570e-21,
 -2.107029488022986e-22,  4.533161290783690e-24, -9.114871185573136e-26,  1.726207602982355e-27, -3.097346135921359e-29,  7.053119049018378e-14, -7.041100910359066e-15,
  4.231333299189560e-16, -1.911162238116559e-17,  7.111821794694920e-19, -2.287451053992376e-20,  6.549900594070439e-22, -1.703083962614835e-23,  4.078593703636682e-25,
 -9.091989673174759e-27,  1.902137862529315e-28, -3.757891372470983e-30,  1.625767536791228e-15, -1.977269637223252e-16,  1.401577060291981e-17, -7.354439568664332e-19,
  3.144556496339719e-20, -1.152447686116980e-21,  3.734565792370820e-23, -1.092675387493484e-24,  2.929978779923818e-26, -7.281388935109916e-28,  1.691599561150435e-29,
 -3.697645346932575e-31,  2.836671544734103e-17, -4.229379007727453e-18,  3.573333692177059e-19, -2.200083008885291e-20,  1.091153772956916e-21, -4.597159341636009e-23,
  1.699992206357699e-24, -5.640459664093371e-26,  1.705821654904539e-27, -4.758016832222850e-29,  1.235260811912991e-30, -3.005188375562332e-32,  3.816764677891702e-19,
 -7.031466765654742e-20,  7.167156252732945e-21, -5.239796538845079e-22,  3.048683299356788e-23, -1.492289084923526e-24,  6.359519666266215e-26, -2.414771062174366e-27,
  8.306487263881868e-29, -2.620928542019915e-30,  7.659193847720056e-32, -2.087726852073689e-33,  4.196712534516778e-21, -9.629527173120557e-22,  1.199363727077533e-22,
 -1.054706935624929e-23,  7.288260286591220e-25, -4.192493370693257e-26,  2.080819762306578e-27, -9.129739127740981e-29,  3.603609835739900e-30, -1.296533266006571e-31,
  4.295728295562995e-33, -1.320402072675618e-34,  4.357468200873414e-23, -1.249340971774137e-23,  1.919315715080619e-24, -2.051007435128239e-25,  1.699799094228392e-26,
 -1.159409513947917e-27,  6.755426326220445e-29, -3.448901461591310e-30,  1.571476606424253e-31, -6.479895190779617e-33,  2.444392018763115e-34, -8.500929123114024e-36,
  5.864659513844143e-25, -2.071277407017895e-25,  3.900388641881019e-26, -5.043994370195118e-27,  4.995205358506845e-28, -4.024557839914816e-29,  2.741115403967987e-30,
 -1.620517811370984e-31,  8.477403785915423e-33, -3.982117470785174e-34,  1.699021606615937e-35, -6.637603727806241e-37,  1.670844550370052e-26, -6.868381166337543e-27,
  1.508865882945545e-27, -2.257270543277699e-28,  2.561251537041949e-29, -2.342536609841518e-30,  1.795724961398748e-31, -1.185485464388513e-32,  6.875637760292800e-34,
 -3.557254383056584e-35,  1.661618745898374e-36, -7.066127576226085e-38,  7.865249500117388e-02, -2.559703096128622e-04,  8.628519867581247e-07, -3.018110263894906e-09,
  1.056000803264075e-11, -4.182594424553523e-14,  9.531493131669579e-17, -1.273965454607920e-18, -6.521468218817420e-21, -2.296298930826165e-23,  2.360032297906103e-24,
  6.995661890430252e-26,  6.499826456625860e-02, -2.367979322172502e-04,  1.087603972692741e-06, -5.400581502862769e-09,  2.677017175375494e-11, -1.327771209458877e-13,
  6.085776865739980e-16, -3.329174815425275e-18,  9.926892781728415e-21, -6.939268954379029e-23,  1.409701099154213e-24,  3.168749913903738e-26,  4.436141192063950e-02,
 -1.964123260340580e-04,  1.278435265748079e-06, -8.223771615374662e-09,  5.029258938118338e-11, -2.947361644810847e-13,  1.688663800580800e-15, -9.234616515085056e-18,
  5.226867222613980e-20, -2.674484636722140e-22,  1.110373979755211e-24, -1.799240873148183e-26,  2.497292222190342e-02, -1.403982599999727e-04,  1.208599188192167e-06,
 -9.315510153289433e-09,  6.699350344277567e-11, -4.569937910139747e-13,  3.048164292852773e-15, -1.902304838642860e-17,  1.247125682848319e-19, -7.268741071352496e-22,
  3.309292011348369e-24, -5.826439422320372e-26,  1.157317527181656e-02, -8.389308986007582e-05,  8.950769692124958e-07, -8.022273760371921e-09,  6.678229727781542e-11,
 -5.241576226051216e-13,  3.980723423648961e-15, -2.843263513348199e-17,  2.059117008398518e-19, -1.377636050362406e-21,  8.203482207581808e-24, -9.073124176514629e-26,
  4.403659085785713e-03, -4.112907203496612e-05,  5.213747329862612e-07, -5.373170730153977e-09,  5.128042100191330e-11, -4.582042137468484e-13,  3.918875175123449e-15,
 -3.166416690146248e-17,  2.526076586346510e-19, -1.904894094380383e-21,  1.348905371288936e-23, -1.201328203089879e-25,  1.371180460092112e-03, -1.636735353918428e-05,
  2.405419305826662e-07, -2.835691152309148e-09,  3.078583891024987e-11, -3.105430705271641e-13,  2.971083183923935e-15, -2.688800358684243e-17,  2.363546724333446e-19,
 -1.982956987223505e-21,  1.591046433936896e-23, -1.362983410357847e-25,  3.479350480872637e-04, -5.252056459084733e-06,  8.830386056911592e-08, -1.186777503545900e-09,
  1.456528458846239e-11, -1.648616714795883e-13,  1.756441092006489e-15, -1.768064674589030e-17,  1.711176603287615e-19, -1.584864166186190e-21,  1.410827619613322e-23,
 -1.258798819145505e-25,  7.159154419853616e-05, -1.352067407770055e-06,  2.583797436519642e-08, -3.948224757306821e-10,  5.452590299064356e-12, -6.896530894980442e-14,
  8.156431602589398e-16, -9.090576673417824e-18,  9.674237332436514e-20, -9.846324254634557e-22,  9.632787032771522e-24, -9.217663947073443e-26,  1.187479015792323e-05,
 -2.778871386597912e-07,  6.021237340902554e-09, -1.043892412572341e-10,  1.617268123227903e-12, -2.279757311514953e-14,  2.986908983392508e-16, -3.675367821353257e-18,
  4.295824357469817e-20, -4.792034439456692e-22,  5.129360736885247e-24, -5.315279013147406e-26,  1.576885061332317e-06, -4.535205571765761e-08,  1.114352304493616e-09,
 -2.188741849755315e-11,  3.797841370447380e-13, -5.958145046258806e-15,  8.638498957072812e-17, -1.171783708339058e-18,  1.503199755256439e-20, -1.835402034426421e-22,
  2.145215798110117e-24, -2.414625970385161e-26,  1.663128448227078e-07, -5.840529984832048e-09,  1.630310114308436e-10, -3.625789828863331e-12,  7.043800898157207e-14,
 -1.229456076293523e-15,  1.972276348393765e-17, -2.948042758087747e-19,  4.150676043588683e-21, -5.545503974406631e-23,  7.073369903193392e-25, -8.658365749224781e-27,
  1.380529566765269e-08, -5.891565309288757e-10,  1.873999692063675e-11, -4.721459375134586e-13,  1.027793730903746e-14, -1.997384591457431e-16,  3.547995240688569e-18,
 -5.847498220956679e-20,  9.042648647845906e-22, -1.322762436146961e-23,  1.842083396168948e-25, -2.454686643948612e-27,  8.926615217226843e-10, -4.615597459975251e-11,
  1.679903692679929e-12, -4.802869375301000e-14,  1.173890588298738e-15, -2.544572386805433e-17,  5.013786680164445e-19, -9.125721705921281e-21,  1.552476214140425e-22,
 -2.490072340957308e-24,  3.791138797725287e-26, -5.507826492042360e-28,  4.445124197096983e-11, -2.781439146018061e-12,  1.164415553239776e-13, -3.789291784041872e-15,
  1.043246888251546e-16, -2.529801725597945e-18,  5.544873843218444e-20, -1.117507156274163e-21,  2.096711988034096e-23, -3.696258402636198e-25,  6.166359743966681e-27,
 -9.788612077652673e-29,  1.683807172694654e-12, -1.275975808950210e-13,  6.183710521336878e-15, -2.301043269744191e-16,  7.168894218635489e-18, -1.953010643997940e-19,
  4.780884504011023e-21, -1.070936522568528e-22,  2.224032895774584e-24, -4.323907632878265e-26,  7.929581351599725e-28, -1.379619136394366e-29,  4.791781300697079e-14,
 -4.409879990977021e-15,  2.493501985913186e-16, -1.067753668627726e-17,  3.787705935775483e-19, -1.165926072422453e-20,  3.204939861488063e-22, -8.020105421956975e-24,
  1.852397808824674e-25, -3.989838332604466e-27,  8.078033750225954e-29, -1.546683634003148e-30,  1.013327543356284e-15, -1.138290986395195e-16,  7.581920863291436e-18,
 -3.767738383599674e-19,  1.534092754919756e-20, -5.375780803504703e-22,  1.671054833942591e-23, -4.702458197203384e-25,  1.215507946815660e-26, -2.917503630008460e-28,
  6.557541237968932e-30, -1.388950859882094e-31,  1.583670246246132e-17, -2.187709168078061e-18,  1.736753075438258e-19, -1.012439908468720e-20,  4.780193243083677e-22,
 -1.925198072844608e-23,  6.828143164687906e-25, -2.178910753288070e-26,  6.352585272020999e-28, -1.711684940536089e-29,  4.300533335014210e-31, -1.014179473608982e-32,
  1.845479879464179e-19, -3.166103634148771e-20,  3.037971413017134e-21, -2.105526068454881e-22,  1.167430383199794e-23, -5.467865701552918e-25,  2.237096789331128e-26,
 -8.178078464751210e-28,  2.714913767354443e-29, -8.284651077699587e-31,  2.345825159006467e-32, -6.206163294192130e-34,  1.676047011201201e-21, -3.611020570074625e-22,
  4.254663156414338e-23, -3.560653376469943e-24,  2.352621838267664e-25, -1.298954129498359e-26,  6.207802356767279e-28, -2.629840155947046e-29,  1.004629842056922e-30,
 -3.505550334278047e-32,  1.128551487536600e-33, -3.376333616062480e-35,  1.348855315315279e-23, -3.679633305926944e-24,  5.400345107575315e-25, -5.537547283435390e-26,
  4.420552514886331e-27, -2.913724131207687e-28,  1.645131836393705e-29, -8.158496905203791e-31,  3.618564692354320e-32, -1.455154670850126e-33,  5.362316195082468e-35,
 -1.824568310609091e-36,  1.318617021672103e-25, -4.518271630961720e-26,  8.263838041851561e-27, -1.040528274852566e-27,  1.005694956877274e-28, -7.924726469376281e-30,
  5.288815718462160e-31, -3.068789676454958e-32,  1.577955147320954e-33, -7.295106332757599e-35,  3.066977420716353e-36, -1.181918225170265e-37,  2.762982032337157e-27,
 -1.125260335272630e-27,  2.448701811889606e-28, -3.630964124519652e-29,  4.086432800091098e-30, -3.709519822526459e-31,  2.824037468355390e-32, -1.852509799351571e-33,
  1.068123197180968e-34, -5.496122675040691e-36,  2.554325181773389e-37, -1.081155757178382e-38,  7.764219399029612e-02, -2.492095535191530e-04,  8.276211876839084e-07,
 -2.855730550270372e-09,  9.743353172185312e-12, -3.998996378291567e-14,  5.676799904737962e-17, -1.470566141296367e-18, -4.741830287848552e-21,  1.514924713651692e-22,
  6.862192808704715e-24,  1.382695766451320e-25,  6.406807407672496e-02, -2.283492436812989e-04,  1.025281783779524e-06, -4.992740581936973e-09,  2.425331479079561e-11,
 -1.192558060860542e-13,  5.195283196083512e-16, -3.037372098293228e-18,  8.857095579025349e-21,  2.352812774577316e-23,  3.469086065384998e-24,  6.351853051977523e-26,
  4.359561131332074e-02, -1.865663394769519e-04,  1.184390469723181e-06, -7.464130578400000e-09,  4.478314132366382e-11, -2.571306917286433e-13,  1.452114931732829e-15,
 -7.709187280836762e-18,  4.322727030505244e-20, -2.413428236027679e-22,  1.253678667022880e-25, -2.750160373723358e-26,  2.442998363130445e-02, -1.311590584225761e-04,
  1.102955226270934e-06, -8.312931586359430e-09,  5.854427371131403e-11, -3.898020280398562e-13,  2.567607562398917e-15, -1.543077680514513e-17,  1.002503407220120e-19,
 -6.525115514486157e-22,  2.189107526076454e-25, -8.421129417782331e-26,  1.125133908597434e-02, -7.710014274832071e-05,  8.048909465903838e-07, -7.032689209286407e-09,
  5.719369446286217e-11, -4.374728065871756e-13,  3.269807881976147e-15, -2.258161065488519e-17,  1.612364736563317e-19, -1.132276339220285e-21,  3.964705289933510e-24,
 -1.042905429783942e-25,  4.247095245912292e-03, -3.720270279384924e-05,  4.615329573993528e-07, -4.621172241241657e-09,  4.298951703451625e-11, -3.739368318965353e-13,
  3.135821507441403e-15, -2.458384427247229e-17,  1.925139411910793e-19, -1.466426948869186e-21,  8.519481917795564e-24, -1.083062688579406e-25,  1.309355433959869e-03,
 -1.457120558729452e-05,  2.092760045626952e-07, -2.389171729904851e-09,  2.523120765596465e-11, -2.474786323207328e-13,  2.314185318295259e-15, -2.035506770200277e-17,
  1.750789650299731e-19, -1.455705757985614e-21,  1.068609215654761e-23, -1.040404265040670e-25,  3.282547693932758e-04, -4.598865639145236e-06,  7.535897384032458e-08,
 -9.779782448586778e-10,  1.165248480830698e-11, -1.280780995990394e-13,  1.330184067279692e-15, -1.301889798908278e-17,  1.230031998280895e-19, -1.118671224115729e-21,
  9.480634521338662e-24, -8.740526494135810e-26,  6.656863944680970e-05, -1.162930309740173e-06,  2.158125931895653e-08, -3.176325251401875e-10,  4.250099071063984e-12,
 -5.212476476722752e-14,  5.996062303910832e-16, -6.494887332181112e-18,  6.735122500484957e-20, -6.699618346620432e-22,  6.331784405790152e-24, -6.033835210755760e-26,
  1.085222615157378e-05, -2.343203114164420e-07,  4.909950162610606e-09, -8.180345594983095e-11,  1.225406717205695e-12, -1.672320817402167e-14,  2.126903051424813e-16,
 -2.541290810103404e-18,  2.889791960270428e-20, -3.142028284607702e-22,  3.265204357236021e-24, -3.322529566958414e-26,  1.411777787314446e-06, -3.739290827750071e-08,
  8.845667882061973e-10, -1.666177970243503e-11,  2.789530400542605e-13, -4.229829762372265e-15,  5.942310049014869e-17, -7.817941298357129e-19,  9.743282121934231e-21,
 -1.157415129853706e-22,  1.314977911339096e-24, -1.445284058659220e-26,  1.453084401124302e-07, -4.692875262237436e-09,  1.255483839222538e-10, -2.672334527555443e-12,
  4.998413050030462e-14, -8.418215500202929e-16,  1.306262826578735e-17, -1.891311631049612e-19,  2.583444567840324e-21, -3.353156555108875e-23,  4.156549081207489e-25,
 -4.955351999926774e-27,  1.171620761292985e-08, -4.593800484518561e-10,  1.394269620152014e-11, -3.355335364423879e-13,  7.017267101815727e-15, -1.313582868430435e-16,
  2.253252559680014e-18, -3.592291560362547e-20,  5.382361117461582e-22, -7.638861801249066e-24,  1.033043528327170e-25, -1.338689999872112e-27,  7.316705520892403e-10,
 -3.473764763205537e-11,  1.201361320629392e-12, -3.274170606340340e-14,  7.671942807429676e-16, -1.599093338720909e-17,  3.037739973018034e-19, -5.341029551111972e-21,
  8.792208819637288e-23, -1.366567909815299e-24,  2.018561965732996e-26, -2.848652127159687e-28,  3.493608841030395e-11, -2.006839708663777e-12,  7.952367260368788e-14,
 -2.461976778056398e-15,  6.484709192350996e-17, -1.509478180648125e-18,  3.184752349664125e-20, -6.191757414138705e-22,  1.122737247267254e-23, -1.915828516792915e-25,
  3.097822777612160e-27, -4.772244313338894e-29,  1.257275242003942e-12, -8.748385120377131e-14,  3.999494512507498e-15, -1.413072437549090e-16,  4.203567858035070e-18,
 -1.097468366260941e-19,  2.582230070701096e-21, -5.572711399678530e-23,  1.117163030047749e-24, -2.100184392644773e-26,  3.729692954589933e-28, -6.292164255854831e-30,
  3.358149634650016e-14, -2.839916831708381e-15,  1.510574686233190e-16, -6.130569450323148e-18,  2.072846374281512e-19, -6.105660873096276e-21,  1.611032902288889e-22,
 -3.879539918621043e-24,  8.641108601038743e-26, -1.798106647978838e-27,  3.522743066355763e-29, -6.536029774256120e-31,  6.556552892387236e-16, -6.778108790632935e-17,
  4.238579865742797e-18, -1.993355181437572e-19,  7.725102375671510e-21, -2.587273424064831e-22,  7.711922632753479e-24, -2.086561891517550e-25,  5.197332690489144e-27,
 -1.204474384880711e-28,  2.618387189379153e-30, -5.372268152216353e-32,  9.246399917329327e-18, -1.178618993851261e-18,  8.776913375484091e-20, -4.838398875512217e-21,
  2.172646796409263e-22, -8.357713237337555e-24,  2.840955355898248e-25, -8.713138829951219e-27,  2.447362698753741e-28, -6.366269962113782e-30,  1.546999838417606e-31,
 -3.534346482066054e-33,  9.409547209225985e-20, -1.496250470403910e-20,  1.348008826014262e-21, -8.839561529871038e-23,  4.663163155966874e-24, -2.086954840245707e-25,
  8.187224374581291e-27, -2.878212573580328e-28,  9.211458320992362e-30, -2.715749687098397e-31,  7.443681807605340e-33, -1.909641724255983e-34,  7.114587869895016e-22,
 -1.431553080333904e-22,  1.589895134966216e-23, -1.262652764154530e-24,  7.957924030109805e-26, -4.208496241943496e-27,  1.933026468822780e-28, -7.893173380184081e-30,
  2.913639162474885e-31, -9.845671397417241e-33,  3.075499182360710e-34, -8.943751399600586e-36,  4.453461666480524e-24, -1.149280325977055e-24,  1.604227206082557e-25,
 -1.572684654507125e-26,  1.205474666148985e-27, -7.656916611797913e-29,  4.178870427597404e-30, -2.008473040222175e-31,  8.653459973767366e-33, -3.387219691352356e-34,
  1.217179936986795e-35, -4.045341703259927e-37,  3.127943711903356e-26, -1.034797370544452e-26,  1.830537887786573e-27, -2.236053941026950e-28,  2.102586622732758e-29,
 -1.615886500527577e-30,  1.054064277611235e-31, -5.989420530405440e-33,  3.021000632152528e-34, -1.372062098719737e-35,  5.674359232899152e-37, -2.153725911215664e-38,
  4.668080720119835e-28, -1.880089982023440e-28,  4.045705240847191e-29, -5.936916214457097e-30,  6.618234689961250e-31, -5.955629518858212e-32,  4.497916120814115e-33,
 -2.928984857098011e-34,  1.677442785629785e-35, -8.577869685616065e-37,  3.963684105995637e-38, -1.668780184282863e-39,  7.665838434152829e-02, -2.427230692663078e-04,
  7.942615905852442e-07, -2.706175490889299e-09,  8.953783662259896e-12, -3.913153514130275e-14,  1.474107117873578e-17, -1.468792637386257e-18,  7.327933417526566e-21,
  5.705265553897525e-22,  1.463717900547299e-23,  2.124438174924377e-25,  6.317071124191249e-02, -2.203802210659052e-04,  9.676206230937877e-07, -4.623119328330212e-09,
  2.198616950583531e-11, -1.077737689407456e-13,  4.388029411264455e-16, -2.707509292839665e-18,  1.297188995477035e-20,  2.287355714924575e-22,  7.042823136829135e-24,
  9.757956745966223e-26,  4.286774562550678e-02, -1.774376918621263e-04,  1.098956317840125e-06, -6.786918352258556e-09,  3.997232432633644e-11, -2.247219663179864e-13,
  1.254309535515390e-15, -6.466533624202839e-18,  3.430612238584900e-20, -2.639831704198420e-22, -1.341787136541106e-24, -3.892704789754115e-26,  2.392238462481440e-02,
 -1.227190847362159e-04,  1.008573487453125e-06, -7.435384029179761e-09,  5.133124294797850e-11, -3.330235168231880e-13,  2.176893892427365e-15, -1.260473015388574e-17,
  7.593938080750424e-20, -7.271975209398750e-22, -4.178582474750571e-24, -1.146707527074353e-25,  1.095530340507259e-02, -7.098366585594632e-05,  7.257137871871837e-07,
 -6.183526878401613e-09,  4.918063373926174e-11, -3.660386062144879e-13,  2.703793284929327e-15, -1.805296812305601e-17,  1.221674816234170e-19, -1.071595972668952e-21,
 -1.080721599663010e-24, -1.244301592932595e-25,  4.105333543676912e-03, -3.372110518407471e-05,  4.099717208948345e-07, -3.989302867990320e-09,  3.621101992884844e-11,
 -3.062878143869514e-13,  2.526199039292956e-15, -1.921155155003899e-17,  1.447166404087476e-19, -1.220097595572901e-21,  3.810615895615735e-24, -1.061331933635638e-25,
  1.254246667045366e-03, -1.300517238496215e-05,  1.828740756048407e-07, -2.022234274114240e-09,  2.079395063538466e-11, -1.981900894025874e-13,  1.815338762690391e-15,
 -1.551709359051321e-17,  1.293229623199760e-19, -1.113513676075357e-21,  6.563103266692309e-24, -8.469917646184682e-26,  3.109949554394779e-04, -4.039951322106171e-06,
  6.466264022022933e-08, -8.104128139280016e-10,  9.382789865403743e-12, -1.001180238975264e-13,  1.015186799831520e-15, -9.660988833001672e-18,  8.870431544093485e-20,
 -8.083898270632894e-22,  6.210945281475957e-24, -6.292162558100603e-26,  6.223961190983933e-05, -1.004445009346916e-06,  1.814564993272497e-08, -2.572467347814200e-10,
  3.337948929857901e-12, -3.969361430298363e-14,  4.446173390791849e-16, -4.681451669670924e-18,  4.721259359527451e-20, -4.632341426969035e-22,  4.149756297998797e-24,
 -4.033107158771965e-26,  9.987726220680333e-06, -1.986576956538058e-07,  4.035746968843727e-09, -6.461775226206940e-11,  9.367233398659950e-13, -1.237763623636727e-14,
  1.529443547466889e-16, -1.774941506713604e-18,  1.962255193526766e-20, -2.088259703905949e-22,  2.091667473614779e-24, -2.108933942445992e-26,  1.275192160931777e-06,
 -3.104622461678430e-08,  7.088453281536127e-10, -1.280467089344393e-11,  2.070118537616138e-13, -3.034642135839115e-15,  4.133721924926584e-17, -5.276506743924753e-19,
  6.387753851388712e-21, -7.396948030440290e-23,  8.147897579126953e-25, -8.774411116740336e-27,  1.283602519409125e-07, -3.804341769750902e-09,  9.777387629699439e-11,
 -1.991891916676679e-12,  3.589771323817848e-14, -5.835352153571955e-16,  8.763490418403754e-18, -1.229491207110769e-19,  1.629558408317898e-21, -2.056770411517226e-23,
  2.475826375366555e-25, -2.878587876195522e-27,  1.007872353160603e-08, -3.622175331329507e-10,  1.051191596387771e-11, -2.416463132583448e-13,  4.858484444921617e-15,
 -8.763226276663172e-17,  1.452280953731808e-18, -2.240434605730853e-20,  3.253184002215046e-22, -4.482038481380971e-24,  5.885457486833060e-26, -7.421234409369236e-28,
  6.097188893437782e-10, -2.651164583431262e-11,  8.727142940417891e-13, -2.267468426274797e-14,  5.096366023030535e-16, -1.021745524959811e-17,  1.872019292813809e-19,
 -3.180436174333437e-21,  5.067321457628935e-23, -7.634995961246932e-25,  1.094249741972937e-26, -1.500499494033936e-28,  2.801618181179879e-11, -1.473237956933704e-12,
  5.532903015040799e-14, -1.629648749356583e-15,  4.108223297488569e-17, -9.181920057504691e-19,  1.865296081935756e-20, -3.499169187052086e-22,  6.133216735129132e-24,
 -1.013248389017725e-25,  1.588190452862560e-27, -2.374741965621108e-29,  9.620113005394629e-13, -6.127457785392588e-14,  2.644532242818595e-15, -8.870830063035375e-17,
  2.520226143826067e-18, -6.306561176277377e-20,  1.426464404010366e-21, -2.966210470398905e-23,  5.740738098184052e-25, -1.043652741330818e-26,  1.794890690655350e-28,
 -2.936346247544002e-30,  2.424170688237087e-14, -1.877421660256256e-15,  9.395184461581407e-17, -3.612834450231829e-18,  1.164298452153255e-19, -3.281566197034230e-21,
  8.311234640076263e-23, -1.925939404920844e-24,  4.136641651427238e-26, -8.315658837087901e-28,  1.576330629167780e-29, -2.833891849913554e-31,  4.397183911676053e-16,
 -4.167590364924479e-17,  2.445265767441069e-18, -1.087672224114118e-19,  4.010616108133718e-21, -1.283400760332596e-22,  3.667212264583759e-24, -9.537336555054231e-26,
  2.288669690135056e-27, -5.119818097308474e-29,  1.076184226008784e-30, -2.138332758420522e-32,  5.637789539735250e-18, -6.602653831995187e-19,  4.605619374900099e-20,
 -2.398310554535930e-21,  1.023412331560829e-22, -3.757631593713742e-24,  1.223404931917665e-25, -3.604146579582029e-27,  9.747648866352211e-29, -2.446636465244349e-30,
  5.747200906568102e-32, -1.271393518649426e-33,  5.054123277510224e-20, -7.412415976082915e-21,  6.255075777311654e-22, -3.873926587488221e-23,  1.941571409257054e-24,
 -8.292571200261617e-26,  3.115898397050039e-27, -1.052304152415676e-28,  3.243603161836820e-30, -9.230679402177153e-32,  2.446958377083552e-33, -6.082171613615624e-35,
  3.210689333366857e-22, -5.999319108465784e-23,  6.258222574509219e-24, -4.703558313745414e-25,  2.821267594878151e-26, -1.426238558367881e-27,  6.284834679473124e-29,
 -2.469562355045657e-30,  8.795341661389451e-32, -2.874116094949750e-33,  8.699548406408500e-35, -2.455993353016200e-36,  1.572576698747390e-24, -3.815026253306174e-25,
  5.041349687239247e-26, -4.707223644918737e-27,  3.453366308514023e-28, -2.107836968656107e-29,  1.109168855581660e-30, -5.154736799648367e-32,  2.152853196543874e-33,
 -8.186615645946867e-35,  2.863510625244422e-36, -9.280230470205346e-38,  7.873299669894580e-27, -2.500536634744982e-27,  4.257986164884711e-28, -5.025527251885320e-29,
  4.581306598637498e-30, -3.423307384317550e-31,  2.176672915847082e-32, -1.208235098934984e-33,  5.964729965257562e-35, -2.655968949928215e-36,  1.078524680276152e-37,
 -4.025025131370438e-39,  8.088821854986015e-29, -3.214359608592741e-29,  6.825100307757294e-30, -9.893096681397570e-31,  1.090559032277841e-31, -9.714280432106602e-33,
  7.268805656080240e-34, -4.693378027759226e-35,  2.667110523244678e-36, -1.354163776885334e-37,  6.216312595000703e-39, -2.601352122334601e-40,  };
  int offset = -24;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 24;
    if (std::isnan(t)) {
      fill_n(rr+offset, 24, 0.5);
      fill_n(ww+offset, 24, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 24; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=24; ++j) {
        const int boxof = it*288+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
