//
// BAGEL - Parallel electron correlation program.
// Filename: _spin2root_4.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/spin2rootlist.h>

using namespace std;
using namespace bagel;

void Spin2RootList::spin2root4(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[4] = {9.785072681047292e-01,2.990377340190600e+00,6.319300497896596e+00,1.171181489380808e+01};
  constexpr double aw[4] = {2.654349482046309e-01,3.386032767788276e-01,5.947439028776936e-02,1.157578818340595e-03};
  constexpr double x[1536] = {  3.202378272141573e-01, -1.240976711498785e-02,  2.929162055594082e-04, -3.787509113602267e-06, -3.177964001284512e-08,
  3.187488554319952e-09, -8.212232355915388e-11,  4.838898822559775e-13,  4.324021201314503e-14, -1.847970511161891e-15,  2.862870749094820e-17,  6.089437129186683e-19,
  8.568485701435435e-01, -2.315910087647661e-02,  1.253082622604639e-04,  7.890726458676046e-06, -1.299008407137669e-07, -4.258510721823683e-09,  1.315314730759253e-10,
  2.375099532782046e-12, -1.365943490416382e-13, -9.772397395254163e-16,  1.357936562830839e-16, -1.270022188792806e-19,  1.449219960043999e+00, -1.941972709418471e-02,
 -3.134303565149581e-04,  1.845286800242940e-06,  2.101215733955888e-07,  2.930133804699714e-09, -1.020902385873899e-10, -4.611338730654988e-12, -1.165528467997879e-14,
  3.929895703438126e-15,  9.664223651281085e-17, -1.549201657836496e-18,  1.884629749033540e+00, -5.408322900421603e-03, -1.790400669377549e-04, -4.748854594955217e-06,
 -9.980662331015629e-08, -1.356443685930344e-09,  6.078552145743905e-12,  1.188750916563878e-12,  4.740815124495053e-14,  1.193700677620069e-15,  1.558871060529585e-17,
 -2.497184996698095e-19,  2.749909138666735e-01, -1.025270091130079e-02,  2.461899183921297e-04, -3.886356167802080e-06,  1.393677641325927e-08,  1.482668899300935e-09,
 -5.746933853528629e-11,  1.047635541950578e-12, -4.652957053813932e-16, -6.079691008682336e-16,  2.563267239862379e-17, -4.659717443654071e-19,  7.667598752707150e-01,
 -2.181849572672659e-02,  2.053116694235651e-04,  5.316130960740078e-06, -1.806768038060305e-07, -7.946567627777795e-10,  1.385127143978077e-10, -1.610856606114134e-12,
 -8.850258396959753e-14,  2.979200967138377e-15,  3.915402939938520e-17, -3.208223512294602e-18,  1.366751615116588e+00, -2.177806872907303e-02, -2.697302500586329e-04,
  5.500166849886122e-06,  2.341820078384360e-07, -9.593735589655040e-10, -2.111138225311326e-10, -2.209202108318800e-12,  1.677248488377601e-13,  4.794211145349151e-15,
 -8.727218578121863e-17, -5.914698729284867e-18,  1.859730009825857e+00, -7.097675564637670e-03, -2.464378062479804e-04, -6.539920096237438e-06, -1.217132973854106e-07,
 -5.966365807097844e-10,  6.768608690449688e-11,  3.469049261043869e-12,  9.525437205586976e-14,  1.160039947868564e-15, -3.218346298491547e-17, -2.318687536504713e-18,
  2.376315549200728e-01, -8.464120397876435e-03,  2.016541234686954e-04, -3.491335310104492e-06,  3.210144034197196e-08,  4.395333506071515e-10, -3.046866161637880e-11,
  8.380442103017875e-13, -9.116302921063995e-15, -1.203394177178951e-17,  5.001237914949474e-18, -3.666552655561324e-19,  6.831052955559409e-01, -1.997010150303721e-02,
  2.517679950841211e-04,  2.459007711866678e-06, -1.681954567116828e-07,  1.771780114873433e-09,  7.053400326556980e-11, -2.679706464893465e-12,  1.647829264394160e-14,
  2.168535351940889e-15, -6.244886254580956e-17, -9.611288865914068e-19,  1.275827351740957e+00, -2.361150601396796e-02, -1.827991086413384e-04,  8.809875987535991e-06,
  1.630011609427012e-07, -6.038530249709857e-09, -1.794595033592187e-10,  4.778198123966440e-12,  2.223008300982000e-13, -2.869928169920348e-15, -2.455312227976954e-16,
  8.137552507929144e-19,  1.826852288930964e+00, -9.416343196108413e-03, -3.366032292643228e-04, -8.454949874235580e-06, -1.076414308824867e-07,  2.561440383074493e-09,
  2.105246405339436e-10,  6.671748581630164e-12,  7.917316363242552e-14, -3.286782688791257e-15, -2.181351489501216e-16, -5.963302456136627e-18,  2.067491258755370e-01,
 -7.009292743900216e-03,  1.630216077490678e-04, -2.939729946855950e-06,  3.531109766558456e-08, -4.278088388998570e-11, -1.102904220266743e-11,  5.527923437401596e-13,
 -8.868556575697324e-15, -2.819678989510841e-17, -3.209697119873627e-18, -1.596236483495731e-20,  6.073796322537328e-01, -1.788050330405113e-02,  2.665311653425798e-04,
  1.196472818621027e-07, -1.213618965312858e-07,  2.677569590289122e-09,  1.094694218113534e-11, -1.419441193763472e-12,  4.664722869049308e-14, -4.056109573932122e-16,
 -5.090990469018628e-17,  1.123319011741924e-18,  1.179175006610455e+00, -2.461710908264526e-02, -6.602078807197948e-05,  1.027581553464733e-05,  1.351607356858910e-08,
 -8.094050068362101e-09,  2.625558666597509e-11,  8.609120556692695e-12, -2.003358396702499e-14, -8.904596348535550e-15,  2.200731816935468e-19,  8.175561255270713e-18,
  1.783125135108425e+00, -1.253827884734383e-02, -4.456348938293768e-04, -9.426284670861994e-06,  1.000026293227412e-08,  9.959854599428715e-09,  4.000808605655807e-10,
  5.131620423189892e-12, -2.550720285205041e-13, -1.644344141984792e-14, -3.717476728301477e-16,  4.061204800963518e-18,  1.811102661643966e-01, -5.836757049563749e-03,
  1.310728388392681e-04, -2.391313954119690e-06,  3.288944932225771e-08, -1.555781940481339e-10,  1.620276624801021e-13,  2.312672502070043e-13, -1.166779430746362e-14,
 -9.632643968194953e-17,  1.388392719839640e-18,  2.043111307851186e-19,  5.400900223244903e-01, -1.577141443006050e-02,  2.580993923548793e-04, -1.390225829503109e-06,
 -6.763087718722842e-08,  2.607099575806906e-09, -1.228333906191572e-11, -4.464766905293482e-13,  8.723661237713405e-15, -1.318604317303963e-15,  6.183548974252389e-18,
  1.289869597830378e-18,  1.080420924404516e+00, -2.466005159570413e-02,  5.356814762320507e-05,  9.308256314022466e-06, -1.241160396996040e-07, -4.923484881971629e-09,
  2.139261918967131e-10,  3.476621996167286e-12, -2.652037317742866e-13, -3.138165377615263e-15,  2.332854384963402e-16,  1.148229590160269e-18,  1.725153717089350e+00,
 -1.653442304004683e-02, -5.494503581954361e-04, -7.126607710096762e-06,  3.094549144118316e-07,  1.973434888746273e-08,  3.252100175559658e-10, -1.436655801203099e-11,
 -9.684800555397444e-13, -1.589760202709689e-14,  7.445166229800474e-16,  4.929274497665618e-17,  1.596909925441708e-01, -4.894238857526281e-03,  1.054365749565370e-04,
 -1.888354871643056e-06,  3.011258711105539e-08, -1.185100697955345e-10,  1.080358743058566e-12, -1.666982194475642e-13, -1.159494215596305e-14,  1.763440787481666e-16,
  1.257137890770569e-17,  2.307630823498097e-19,  4.810073958622266e-01, -1.378790764158448e-02,  2.365815199345730e-04, -2.075407941079677e-06, -1.945770937689994e-08,
  2.154357992258676e-09, -2.704656442313105e-11, -7.716495471731990e-13, -2.118260301037108e-14, -4.258695450522360e-18,  5.673282355012697e-17,  8.437865419533682e-19,
  9.832901054638841e-01, -2.382404943441726e-02,  1.510534762908890e-04,  6.828745791311533e-06, -1.685217313838099e-07,  3.801528140979879e-10,  1.883162397995230e-10,
 -5.029982652920759e-12, -2.141779417075813e-13,  5.587552693634448e-15,  1.819343376502428e-16, -1.961018362332646e-18,  1.649843896006195e+00, -2.115612977764674e-02,
 -5.913980406461291e-04,  1.202590220720393e-06,  7.303721925293140e-07,  1.899796979974177e-08, -5.300521445213820e-10, -4.431911283582724e-11, -4.677702007805928e-13,
  5.574176213897252e-14,  2.375756998878646e-15, -1.766157199943435e-17,  1.416688317948596e-01, -4.133378219050033e-03,  8.558755794363279e-05, -1.426335501892915e-06,
  2.744557914186308e-08, -1.808505564609865e-10, -7.064458984839946e-12, -3.287462627242817e-13,  4.690040403439124e-15,  6.911067107651429e-16,  6.037774367179125e-18,
 -7.250088773628910e-19,  4.294798449842775e-01, -1.199716364778606e-02,  2.110932527853400e-04, -2.085864732524470e-06,  1.505273981579221e-08,  1.186052658087600e-09,
 -5.479710260668354e-11, -9.787295070636009e-13,  2.236211059938309e-14,  2.268540554203031e-15,  3.002309499578143e-17, -2.779301681607790e-18,  8.908674613056281e-01,
 -2.233179112988256e-02,  2.177084286957580e-04,  4.379805384846237e-06, -1.301764832948434e-07,  2.666617927622849e-09, -9.344796401474711e-12, -7.464269229860084e-12,
  9.068564459180199e-14,  1.021333325048318e-14, -1.932197255697589e-18, -9.027114231865411e-18,  1.556158698886847e+00, -2.560866029375031e-02, -4.977142153905596e-04,
  1.481408148011224e-05,  8.837825261613343e-07, -7.907421827081926e-09, -1.576593808371155e-09, -1.436666637569270e-11,  2.455118826347797e-12,  6.975395365471066e-14,
 -2.997183101586294e-15, -1.784961788597962e-16,  1.264064033691331e-01, -3.510024670771850e-03,  7.094993672168048e-05, -1.027882976743995e-06,  2.157267860486179e-08,
 -4.211620883800220e-10, -1.055394221569979e-11,  1.848413040594176e-13,  2.359745572104506e-14,  4.815197978990154e-17, -3.816726148545389e-17, -6.379549170653460e-19,
  3.847176836840471e-01, -1.040314312558189e-02,  1.880394807136299e-04, -1.733579657914346e-06,  2.414767461773815e-08, -3.006841207727673e-10, -6.001081735983208e-11,
  9.639277450347874e-13,  8.604032770926549e-14,  7.120063667879122e-17, -1.402292759967789e-16, -2.484425810068523e-18,  8.053113686917290e-01, -2.041164117198854e-02,
  2.593188347444003e-04,  2.650460684961927e-06, -9.295513763260904e-08,  5.782665850229280e-10, -1.280725639904756e-10,  3.306526536703750e-13,  3.336732468367375e-13,
 -3.400982608733904e-16, -5.145357748406713e-16, -6.181542221875372e-18,  1.447193228526882e+00, -2.866424473654972e-02, -2.469262700807082e-04,  2.567548445391008e-05,
  3.663470450306648e-07, -4.051454278869830e-08, -7.362995618914265e-10,  7.004265635323090e-11,  1.608403738159342e-12, -1.220783614669901e-13, -3.539082757572154e-15,
  2.093960912850036e-16,  1.134307296072655e-01, -2.986610660098216e-03,  6.037210134255593e-05, -7.606612235803107e-07,  1.144340522585703e-08, -5.363949375193120e-10,
  3.282375677964028e-12,  6.690745567954857e-13, -1.064284018408678e-15, -1.169854059169432e-15, -1.920653466943416e-18,  1.979579018224104e-18,  3.459901018336429e-01,
 -8.976369212816976e-03,  1.691405740316580e-04, -1.459174795246901e-06,  7.387792673067492e-09, -1.144022448644844e-09, -2.090854712542771e-12,  2.658647007470877e-12,
 -8.376887060788093e-15, -4.364038230914788e-15, -1.533620329555747e-18,  7.546000816727053e-18,  7.279795560021488e-01, -1.823525931724484e-02,  2.820990221061246e-04,
  1.111987751104620e-06, -1.057133079529829e-07, -1.331878827766507e-09,  7.685853159435129e-13,  6.993938833081730e-12, -9.395802793805566e-15, -1.480165408527363e-14,
  5.308485348594541e-17,  2.627638021643127e-17,  1.330592704328380e+00, -2.937186880238715e-02,  6.844777749950815e-05,  2.480848273080724e-05, -4.508714024147078e-07,
 -3.335474159584722e-08,  1.212031684000914e-09,  4.505240276844387e-11, -2.730647399888366e-12, -5.348291112543125e-14,  5.627832794081749e-15,  4.309562895186325e-17,
  1.023958209823174e-01, -2.537790809666228e-03,  5.201877840639269e-05, -6.532805326719031e-07,  2.846865831768826e-09, -2.720847869547444e-10,  1.602603600183866e-11,
  1.011000056293408e-13, -2.652313731605591e-14,  8.067850777638405e-17,  4.419067798768995e-17, -5.711284829947013e-19,  3.126806422707897e-01, -7.692914846328947e-03,
  1.516398301311058e-04, -1.503715596141011e-06, -1.068933288953153e-08, -4.616199339278312e-10,  4.837390578096029e-11,  4.463470411483727e-13, -9.914819616851035e-14,
  4.888926714610785e-16,  1.638524188506524e-16, -2.537516530467487e-18,  6.595937356909989e-01, -1.595555593558234e-02,  2.845863720097106e-04, -7.313028414789914e-07,
 -1.183502759221866e-07,  5.753686945947542e-10,  1.267214656090134e-10,  4.825886150125728e-13, -2.867138646653446e-13,  2.632502730660283e-15,  5.137999660628832e-16,
 -1.181718642486488e-17,  1.215860494006132e+00, -2.779517251705433e-02,  3.066962074954297e-04,  1.408166939472487e-05, -7.779832142922723e-07,  7.088953051757281e-10,
  1.251506805368128e-09, -3.397710103172949e-11, -1.308915782009284e-12,  9.190126815820971e-14,  8.176983093104570e-17, -1.646773882187666e-16,  9.302802584886695e-02,
 -2.152503281268953e-03,  4.433959310243264e-05, -6.309906493688489e-07,  1.034430357892985e-09,  6.342583972478093e-11,  9.342939494642299e-12, -4.507882626557889e-13,
 -3.679119130129252e-15,  7.929132619098273e-16, -1.142222822018133e-17, -1.014544026955983e-18,  2.842164210063673e-01, -6.555177079242408e-03,  1.324660433661523e-04,
 -1.687137169479372e-06, -8.945349601285717e-09,  5.438517241216808e-10,  2.607633816318665e-11, -1.547092788439457e-12, -1.110031425494919e-14,  2.886726724227508e-15,
 -4.935284578222964e-17, -3.553102300135838e-18,  6.002263201270962e-01, -1.374425610985215e-02,  2.653365500562916e-04, -2.379406183613006e-06, -7.991150902403308e-08,
  2.937972453918405e-09,  4.632914361468042e-11, -4.618886733555097e-12,  2.883485737856695e-16,  8.233296059841631e-15, -2.026264330211163e-16, -9.123643308000774e-18,
  1.110370963982370e+00, -2.486743537170851e-02,  4.057367607194320e-04,  3.007777288920414e-06, -5.528308467180790e-07,  1.739701207729887e-08,  1.530712806014242e-10,
 -3.244930556128554e-11,  9.302869379803471e-13,  1.854758158052578e-14, -2.127690976124142e-15,  4.378774399956813e-17,  8.508008904369831e-02, -1.827638397450098e-03,
  3.693668427013806e-05, -5.963452326685279e-07,  3.549498173922585e-09,  1.446037968807106e-10, -1.596682101646573e-12, -2.521412755942589e-13,  1.116551313509031e-14,
  8.314658351722215e-18, -1.633228221778213e-17,  4.945684987172871e-19,  2.599847918412855e-01, -5.577889192341380e-03,  1.117910817424841e-04, -1.723640451126038e-06,
  4.814650765055245e-09,  6.870901417438026e-10, -1.040824191830108e-11, -7.910874198530903e-13,  3.982019687579390e-14, -6.979124182474882e-17, -5.696993740670877e-17,
  1.933781199853671e-18,  5.492892876063185e-01, -1.175286092427599e-02,  2.311331835385762e-04, -3.168593128530365e-06, -1.958249776291084e-08,  2.705966080753869e-09,
 -5.177979481903769e-11, -1.771277915990181e-12,  1.197281946368168e-13, -1.070469842033833e-15, -1.461477741214362e-16,  6.537979102950009e-18,  1.017444248747695e+00,
 -2.160107343426029e-02,  4.001957748316592e-04, -3.099791191860319e-06, -2.235327213835450e-07,  1.367116892831139e-08, -3.295855208198110e-10, -3.919836095976978e-12,
  6.228867358024161e-13, -2.085915610905460e-14,  2.182170942443824e-18,  2.889826796527409e-17,  7.831682478323362e-02, -1.559606826777770e-03,  3.020511214672192e-05,
 -5.202047833360263e-07,  5.683450194328446e-09,  5.879748650771047e-11, -4.254351852187222e-12,  2.736683680265266e-14,  4.970897416442252e-15, -2.262710734370847e-16,
  2.157685661701411e-18,  2.055394450762144e-19,  2.393339767514089e-01, -4.764056850715962e-03,  9.196446231644972e-05, -1.555335726121434e-06,  1.495469618028869e-08,
  3.015619514724216e-10, -1.727333337875694e-11,  1.666153300147752e-13,  1.593075308488315e-14, -8.043607237138557e-16,  9.724481606305153e-18,  6.627333098276256e-19,
  5.057324449006645e-01, -1.005759456495839e-02,  1.927684474258077e-04, -3.126299727062702e-06,  2.007439362745894e-08,  1.238160385640012e-09, -5.856321779399160e-11,
  8.228496067346440e-13,  3.599890883231179e-14, -2.317446320808527e-15,  4.225902109075261e-17,  1.336841066422940e-18,  9.371454814987793e-01, -1.859116067594568e-02,
  3.491468653002582e-04, -4.924007672416714e-06, -2.925305789451878e-08,  6.047829346075046e-09, -2.630921853648697e-10,  5.616083318438747e-12,  4.932975174231783e-14,
 -8.979188737295399e-15,  3.463152692909511e-16, -4.792753951115845e-18,  7.252440135701699e-02, -1.341334234478035e-03,  2.453039853607417e-05, -4.249137783684846e-07,
  5.964539332560382e-09, -2.277295234812614e-11, -2.301922191167866e-12,  8.300565883779411e-14, -5.353631117586465e-16, -7.253205243484165e-17,  3.568060289629737e-18,
 -6.540152842390003e-20,  2.216371511607846e-01, -4.098606558894330e-03,  7.486830198329863e-05, -1.288021091420894e-06,  1.741521956771815e-08, -2.257748219499498e-11,
 -9.091544293791367e-12,  3.188644328230158e-13, -2.849731149631998e-15, -2.294205651677781e-16,  1.242861709878751e-17, -2.551592869077135e-19,  4.683583830529576e-01,
 -8.658617919663811e-03,  1.577749513157819e-04, -2.674054271100595e-06,  3.304185808875448e-08,  1.753402918556486e-10, -2.930409699614124e-11,  1.010662113826549e-12,
 -1.305441760737698e-14, -4.894117584142874e-16,  3.368595660744249e-17, -8.626666757454195e-19,  8.679913696637324e-01, -1.603506336970981e-02,  2.902779261098514e-04,
 -4.713782126145364e-06,  4.126290822207616e-08,  1.583918818978042e-09, -1.161052544339472e-10,  4.202599701956832e-12, -8.597952596277153e-14, -2.351851549100126e-16,
  9.880855976142765e-17, -4.278577643338302e-18,  6.752148204875270e-02, -1.163914968853827e-03,  1.998130067481504e-05, -3.353935410441192e-07,  5.127743578830756e-09,
 -5.364076394061231e-11, -4.483614258280141e-13,  4.567507064157973e-14, -1.307993789952565e-15,  1.078383068533270e-17,  7.932262161007333e-19, -4.353283214122474e-20,
  2.063492905161142e-01, -3.556845487776989e-03,  6.103830045551359e-05, -1.022063629331485e-06,  1.542993997941032e-08, -1.486988713423653e-10, -2.127508688116688e-12,
  1.691785652969604e-13, -4.871565618566538e-15,  4.953245275366520e-17,  2.425543069646453e-18, -1.477725200549376e-19,  4.360578627628774e-01, -7.515723441051516e-03,
  1.288742097935925e-04, -2.146901763253062e-06,  3.152294820102882e-08, -2.443303425492674e-10, -8.058113003920147e-12,  5.014482946256257e-13, -1.477299330005059e-14,
  1.995795841318801e-16,  4.624197935066119e-18, -3.751632488131976e-19,  8.081553111121590e-01, -1.392627786761787e-02,  2.383247925976251e-04, -3.917029741036009e-06,
  5.304164696868418e-08, -8.968233651874718e-11, -3.454243947927027e-11,  1.786072321032576e-12, -5.734424027490362e-14,  1.162101939714458e-15, -3.681512676330481e-18,
 -8.419205281176129e-19,  6.316189209272961e-02, -1.018852205670918e-03,  1.641254120378506e-05, -2.621609809866552e-07,  4.028535926974140e-09, -5.328359732503870e-11,
  3.290615056969527e-13,  1.324783910592385e-14, -6.849653952826874e-16,  1.752874380269992e-17, -1.843146410847398e-19, -6.442465220238939e-21,  1.930264572561063e-01,
 -3.113638444762690e-03,  5.015137631578418e-05, -8.004314645095444e-07,  1.224660000605949e-08, -1.584715396604774e-10,  7.699380404041397e-13,  5.083339960763549e-14,
 -2.461700842864048e-15,  6.387634022437331e-17, -7.649724002282074e-19, -1.849122559891407e-20,  4.079053456249559e-01, -6.579626339601049e-03,  1.059532270941274e-04,
 -1.688230195785592e-06,  2.559432441278174e-08, -3.153790769523384e-10,  5.545518719025694e-13,  1.556230239804165e-13, -6.973733748033811e-15,  1.870167544796055e-16,
 -2.737968642332802e-18, -2.766953604356601e-20,  7.559856085345509e-01, -1.219362766209297e-02,  1.962458548042929e-04, -3.114008628174596e-06,  4.609309418193324e-08,
 -4.895638936211940e-10, -4.418109110848808e-12,  5.467139375773091e-13, -2.313015594654430e-14,  6.800133249124095e-16, -1.375414131051061e-17,  1.062394748020247e-19,
  5.933060396037339e-02, -8.991175752410544e-04,  1.361982414221850e-05, -2.057122320123181e-07,  3.061344690383425e-09, -4.288790398446217e-11,  4.760259897445046e-13,
 -2.800030138639740e-16, -2.155124476226896e-16,  8.508489582374190e-18, -2.038057766880052e-19,  2.561532465952010e-21,  1.813178882990127e-01, -2.747749583353262e-03,
  4.162152492607915e-05, -6.284885814738661e-07,  9.339412170989496e-09, -1.299229551526337e-10,  1.389310294107947e-12,  2.240116996991135e-15, -7.808816713967594e-16,
  3.002061321567182e-17, -7.300979573247372e-19,  9.974948818615019e-21,  3.831629955965565e-01, -5.806542827757656e-03,  8.794882655677762e-05, -1.327358616899061e-06,
  1.966603835699208e-08, -2.695512489752485e-10,  2.645775839726811e-12,  1.869717402343653e-14, -2.213862042589145e-15,  8.251909694242716e-17, -2.074898927323701e-18,
  3.261586887572975e-20,  7.101310637046175e-01, -1.076135685671439e-02,  1.629720739194738e-04, -2.456655986369972e-06,  3.613222511513492e-08, -4.764338379761894e-10,
  3.518312312965485e-12,  1.039757472393964e-13, -7.043170125844517e-15,  2.591852866322280e-16, -7.100831462016587e-18,  1.429948914574974e-19,  5.593751133421532e-02,
 -7.992616993554964e-04,  1.141883701246210e-05, -1.629856121116658e-07,  2.314184891376206e-09, -3.210415074361332e-11,  4.078089864646059e-13, -3.616986991333784e-15,
 -2.742673823366482e-17,  2.700030411777709e-18, -9.099643641890603e-20,  2.081418696518511e-21,  1.709484099566713e-01, -2.442590289996564e-03,  3.489632503389347e-05,
 -4.980524916068027e-07,  7.068448662792991e-09, -9.783169794704431e-11,  1.229556570098363e-12, -1.021974218529910e-14, -1.190440095529931e-16,  9.520055722772418e-18,
 -3.169227959059723e-19,  7.352715327094408e-21,  3.612501665753011e-01, -5.161703164189469e-03,  7.374194081039457e-05, -1.052316066423751e-06,  1.492081441465005e-08,
 -2.055354656558211e-10,  2.525695157648305e-12, -1.792790762154985e-14, -4.090571697186682e-16,  2.590605296012621e-17, -8.517185121604336e-19,  2.036893986664848e-20,
  6.695194453189122e-01, -9.566362775469765e-03,  1.366631187097776e-04, -1.949556855557867e-06,  2.758249204832147e-08, -3.755860326197855e-10,  4.350563077109588e-12,
 -1.603278225594402e-14, -1.523228211936766e-15,  7.742275169421477e-17, -2.559128058419617e-18,  6.600560871938111e-20,  5.291160747172658e-02, -7.151503725675246e-04,
  9.665608955729763e-06, -1.305988172897677e-07,  1.761562774569739e-09, -2.356253884479473e-11,  3.047671859733377e-13, -3.487207501653509e-15,  2.264308704265482e-17,
  4.929592260388835e-19, -2.837137525784793e-20,  8.561133091463851e-22,  1.617010687466722e-01, -2.185542381368476e-03,  2.953861378598349e-05, -3.991087696316956e-07,
  5.382576045259138e-09, -7.194343902742746e-11,  9.273730214485219e-13, -1.044902888685445e-14,  5.997801598239875e-17,  1.859294793131714e-18, -9.840956596422973e-20,
  2.952087630472698e-21,  3.417085924802156e-01, -4.618512286877797e-03,  6.242105094189653e-05, -8.433634505422330e-07,  1.137089287302903e-08, -1.517566344038875e-10,
  1.942615403174148e-12, -2.118385009297709e-14,  8.648747184583161e-17,  5.492820798723066e-18, -2.608218416295211e-19,  7.791861679569863e-21,  6.333023219368122e-01,
 -8.559669213948389e-03,  1.156862499508277e-04, -1.562882304524734e-06,  2.105883272073452e-08, -2.800764818131380e-10,  3.525383718700606e-12, -3.524108797800479e-14,
 -2.509707352904236e-17,  1.762170730142427e-17, -7.453965198236875e-19,  2.255356610190489e-20,  5.019636249466573e-02, -6.436484904554261e-04,  8.253182399728683e-06,
 -1.058179820482807e-07,  1.356016457605212e-09, -1.732782300989556e-11,  2.187331982196625e-13, -2.637903572251775e-15,  2.698280123147299e-17, -1.057591118440276e-19,
 -5.869289727925688e-21,  2.594432123276968e-22,  1.534031168258667e-01, -1.967028604620143e-03,  2.522220927116494e-05, -3.233842125020995e-07,  4.143880361347784e-09,
 -5.294042073883539e-11,  6.675466814356724e-13, -8.012661724971349e-15,  8.021266839229296e-17, -2.333295705838460e-19, -2.108616365482142e-20,  8.898570733214040e-22,
  3.241732663734647e-01, -4.156747626449516e-03,  5.329980788964228e-05, -6.833713512321924e-07,  8.756118586667303e-09, -1.118140408500277e-10,  1.406820604376106e-12,
 -1.672494328878216e-14,  1.598740864731321e-16, -1.034733938549584e-19, -5.840355654929813e-20,  2.314141381745238e-21,  6.008034069520967e-01, -7.703867063108958e-03,
  9.878244329493261e-05, -1.266487428519438e-06,  1.622487024498321e-08, -2.069780457259493e-10,  2.591003553531140e-12, -3.010031092134925e-14,  2.537670650816068e-16,
  1.572656919747135e-18, -1.728554275056933e-19,  6.388795296550368e-21,  4.774626546052554e-02, -5.823580608460728e-04,  7.102967246185968e-06, -8.663235699919498e-08,
  1.056458121676093e-09, -1.287167401741538e-11,  1.561687090506090e-13, -1.863407723647046e-15,  2.095622371650296e-17, -1.900137158186263e-19,  2.067053673558160e-22,
  5.647137645495746e-23,  1.459154723999870e-01, -1.779721409177932e-03,  2.170709410407622e-05, -2.647533191418347e-07,  3.228560450067021e-09, -3.933352189600870e-11,
  4.770608913700103e-13, -5.683716473206898e-15,  6.352471325229339e-17, -5.592479585877626e-19, -1.504940606717161e-22,  1.978829040770739e-22,  3.083502889447995e-01,
 -3.760928111484526e-03,  4.587167383868404e-05, -5.594781960795401e-07,  6.822470315696534e-09, -8.310731130610222e-11,  1.007299925345929e-12, -1.196501604207537e-14,
  1.320532610681318e-16, -1.090497916742997e-18, -3.685368882799956e-21,  5.285162181228253e-22,  5.714780463116865e-01, -6.970279758720469e-03,  8.501577804953430e-05,
 -1.036897075924746e-06,  1.264371013257233e-08, -1.539742142522794e-10,  1.863438970705335e-12, -2.198281305197750e-14,  2.354002546356945e-16, -1.623370740367527e-18,
 -2.184255404307279e-20,  1.485204725831792e-21,  4.552427808454428e-02, -5.294236440990751e-04,  6.156917930543879e-06, -7.160130683170224e-08,  8.326442450587940e-10,
 -9.680123138189590e-12,  1.123856347302641e-13, -1.297231418249914e-15,  1.465384207863526e-17, -1.537507671100260e-19,  1.224551826625029e-21,  2.519459075203473e-24,
  1.391249447421841e-01, -1.617950645187200e-03,  1.881591264639746e-05, -2.188178403030066e-07,  2.544603095595271e-09, -2.958240054434119e-11,  3.434150439301983e-13,
 -3.962053242316918e-15,  4.466856921712165e-17, -4.650117331393621e-19,  3.559450166617051e-21,  1.383582733978470e-23,  2.940004663189293e-01, -3.419072283776812e-03,
  3.976200507201056e-05, -4.624081050802253e-07,  5.377252509204072e-09, -6.251126005943858e-11,  7.255352090302816e-13, -8.362885892361578e-15,  9.391775828899895e-17,
 -9.622802470830763e-19,  6.747875481675982e-21,  5.547948364182705e-23,  5.448829408590417e-01, -6.336704737887477e-03,  7.369252095546376e-05, -8.569983558960447e-07,
  9.965750527013267e-09, -1.158442058852097e-10,  1.343963278528542e-12, -1.545930496012313e-14,  1.720843220387978e-16, -1.697409651846209e-18,  9.178712996669764e-21,
  2.180891753072798e-22,  4.349995396111614e-02, -4.833925034619573e-04,  5.371690346827385e-06, -5.969272624479694e-08,  6.633255928665905e-10, -7.370526211368442e-12,
  8.186311628930369e-14, -9.074967671988445e-16,  9.984023790015073e-18, -1.069447584773310e-19,  1.047847136227525e-21, -7.266058361574327e-24,  1.329384879022458e-01,
 -1.477276700263722e-03,  1.641621018258801e-05, -1.824245627858731e-07,  2.027161498555350e-09, -2.252464429391750e-11,  2.501699757785767e-13, -2.772872060789563e-15,
  3.048744893091539e-17, -3.257736182777769e-19,  3.161546874474774e-21, -2.079861731214109e-23,  2.809271731302899e-01, -3.121798461758167e-03,  3.469092759728830e-05,
 -3.855016644616699e-07,  4.283815042975515e-09, -4.759881982776123e-11,  5.286269238873289e-13, -5.857649641133022e-15,  6.432630755344318e-17, -6.840537109993685e-19,
  6.510987278691549e-21, -3.803026756080150e-23,  5.206536785672927e-01, -5.785755191948465e-03,  6.429409575994918e-05, -7.144655652857878e-07,  7.939342499402419e-09,
 -8.821476631153288e-11,  9.795862462816399e-13, -1.084814666551364e-14,  1.188126886813480e-16, -1.249806169819273e-18,  1.135752580090818e-20, -4.533846838538143e-23,
  4.164803511642548e-02, -4.431143570452328e-04,  4.714515995148089e-06, -5.016008414174415e-08,  5.336765018470922e-10, -5.677912102577303e-12,  6.040123883594582e-14,
 -6.421577594206855e-16,  6.809783884567717e-18, -7.153456090430483e-20,  7.278479980824982e-22, -6.670551078818573e-24,  1.272789120070381e-01, -1.354184251366988e-03,
  1.440784574612587e-05, -1.532922451728038e-07,  1.630947328079327e-09, -1.735201705477160e-11,  1.845881085366030e-13, -1.962373056067630e-15,  2.080609930874305e-17,
 -2.183923841932870e-19,  2.215622923154376e-21, -2.007721222558768e-23,  2.689672909182982e-01, -2.861678055681121e-03,  3.044682867010040e-05, -3.239389598953695e-07,
  3.446535797252859e-09, -3.666838398315169e-11,  3.900667899935052e-13, -4.146504991430062e-15,  4.394727129676805e-17, -4.606013411763758e-19,  4.646097203673563e-21,
 -4.114650195615467e-23,  4.984879457381085e-01, -5.303663542325024e-03,  5.642833720648375e-05, -6.003691148685581e-07,  6.387599272663529e-09, -6.795860325552902e-11,
  7.228994182194180e-13, -7.683294326242848e-15,  8.136813778728814e-17, -8.500022613225595e-19,  8.464324821800041e-21, -7.096890741322457e-23,  3.994739194063252e-02,
 -4.076689004732489e-04,  4.160319942397852e-06, -4.245666176746907e-08,  4.332759947558359e-10, -4.421615396722166e-12,  4.512136917105896e-14, -4.603682040884544e-16,
  4.693275677133267e-18, -4.769285907367893e-20,  4.791867534760876e-22, -4.639805958669100e-24,  1.220816436962270e-01, -1.245860794286472e-03,  1.271418913807336e-05,
 -1.297501233466684e-07,  1.324117562644570e-09, -1.351271893779462e-11,  1.378932938247540e-13, -1.406893314968502e-15,  1.434192938083439e-17, -1.457071434368882e-19,
  1.462616035746205e-21, -1.411438699865704e-23,  2.579843625165478e-01, -2.632767654969943e-03,  2.686777371610279e-05, -2.741894814749500e-07,  2.798140541462148e-09,
 -2.855521672726465e-11,  2.913963780651361e-13, -2.972984109003739e-15,  3.030347491787727e-17, -3.077268798561725e-19,  3.083438337242841e-21, -2.955917845224795e-23,
  4.781328408566594e-01, -4.879414650692951e-03,  4.979513034610055e-05, -5.081664339982973e-07,  5.185906014060461e-09, -5.292246232048124e-11,  5.400515059264173e-13,
 -5.509644669766864e-15,  5.614681503656022e-17, -5.696006326612886e-19,  5.685251747188409e-21, -5.370407027039237e-23,  3.838021272499078e-02, -3.763127688010976e-04,
  3.689695541232479e-06, -3.617696252203095e-08,  3.547101277096704e-10, -3.477878853799926e-12,  3.409975323314231e-14, -3.343224485692177e-16,  3.276969660127163e-18,
 -3.208693014837623e-20,  3.129655511154956e-22, -3.012451445033688e-24,  1.172922493123621e-01, -1.150034561136411e-03,  1.127593253275853e-05, -1.105589834492379e-07,
  1.084015573486215e-09, -1.062860700983808e-11,  1.042108420346660e-13, -1.021705788871773e-15,  1.001442059930370e-17, -9.805064429821192e-20,  9.560775574253968e-22,
 -9.192897989808810e-24,  2.478633580843247e-01, -2.430266534283467e-03,  2.382843298801691e-05, -2.336345412074696e-07,  2.290754390853128e-09, -2.246049342217927e-11,
  2.202193184823536e-13, -2.159065430410206e-15,  2.116180265207670e-17, -2.071657239068378e-19,  2.018921404467327e-21, -1.937230903932883e-23,  4.593751744843740e-01,
 -4.504111143517600e-03,  4.416219744395674e-05, -4.330043318193088e-07,  4.245547488830073e-09, -4.162692598702907e-11,  4.081403898136661e-13, -4.001425102378129e-15,
  3.921699362905950e-17, -3.838088640905026e-19,  3.735984447004769e-21, -3.568904279927932e-23,  3.693137691393805e-02, -3.484402299809083e-04,  3.287464589135466e-06,
 -3.101657744932743e-08,  2.926352539530955e-10, -2.760954564905197e-12,  2.604898504866056e-14, -2.457627902626923e-16,  2.318515548877606e-18, -2.186573781957380e-20,
  2.059514878050270e-22, -1.930888086188295e-24,  1.128645195240969e-01, -1.064854398233804e-03,  1.004669043791202e-05, -9.478853492367657e-08,  8.943110172884644e-10,
 -8.437643815778863e-12,  7.960726029288175e-14, -7.510652140836082e-16,  7.085485902579058e-18, -6.682127891696561e-20,  6.293286379421158e-22, -5.898252805206919e-24,
  2.385066275207955e-01, -2.250262814160330e-03,  2.123078416614059e-05, -2.003082446021253e-07,  1.889868531594310e-09, -1.783052727728098e-11,  1.682269491119519e-13,
 -1.587156955608095e-15,  1.497298182389937e-17, -1.412005680334896e-19,  1.329617477748206e-21, -1.245354102675140e-23,  4.420339677468439e-01, -4.170502977438506e-03,
  3.934786995405337e-05, -3.712393613036073e-07,  3.502569665045763e-09, -3.304603397796140e-11,  3.117816219011438e-13, -2.941531295810653e-15,  2.774946288295128e-17,
 -2.616661961410056e-19,  2.463127655663944e-21, -2.303900452141150e-23,  3.558796527106390e-02, -3.235536991941272e-04,  2.941640396078575e-06, -2.674439585594709e-08,
  2.431509655288773e-10, -2.210645819683107e-12,  2.009842679780898e-14, -1.827272403104865e-16,  1.661252540017241e-18, -1.510172065832405e-20,  1.372281922504237e-22,
 -1.245005055382483e-24,  1.087589723643105e-01, -9.887996563161885e-04,  8.989830806711062e-06, -8.173248983239902e-08,  7.430840433183270e-10, -6.755867177414267e-12,
  6.142200455985564e-14, -5.584253532262807e-16,  5.076881048182970e-18, -4.615144047732322e-20,  4.193638839785633e-22, -3.804293161487631e-24,  2.298307370696905e-01,
 -2.089543040771987e-03,  1.899741598795955e-05, -1.727180569187332e-07,  1.570293921595674e-09, -1.427657769933090e-11,  1.297976922550568e-13, -1.180070479390295e-15,
  1.072849653588871e-17, -9.752645388555526e-20,  8.861498294788316e-22, -8.037206224803959e-24,  4.259545894935076e-01, -3.872634528821933e-03,  3.520867848957580e-05,
 -3.201053521367893e-07,  2.910289154811726e-09, -2.645935772604849e-11,  2.405592740057965e-13, -2.187070310718471e-15,  1.988345084023642e-17, -1.807447706794119e-19,
  1.642128952552154e-21, -1.488775246160807e-23,  3.433887329083373e-02, -3.012413680904858e-04,  2.642671501748833e-06, -2.318311296036544e-08,  2.033762898514496e-10,
 -1.784139795887199e-12,  1.565155073152507e-14, -1.373047093929645e-16,  1.204511841428146e-18, -1.056634489701866e-20,  9.267998905504435e-23, -8.124672801474671e-25,
  1.049416717930754e-01, -9.206118241825560e-04,  8.076163799681760e-06, -7.084899410652884e-08,  6.215302312639811e-10, -5.452439021838703e-12,  4.783208441466822e-14,
 -4.196114641344708e-16,  3.681059658737373e-18, -3.229132676088955e-20,  2.832330492590556e-22, -2.482850379430818e-24,  2.217639726930963e-01, -1.945447713483302e-03,
  1.706664414368522e-05, -1.497189260058755e-07,  1.313424980293131e-09, -1.152215812224225e-11,  1.010793206716671e-13, -8.867277744712345e-16,  7.778853309466663e-18,
 -6.823816707551623e-20,  5.985211173849603e-22, -5.246396217748949e-24,  4.110041292009386e-01, -3.605576837733983e-03,  3.163030103339478e-05, -2.774801337599198e-07,
  2.434223573522479e-09, -2.135448102788216e-11,  1.873343824770038e-13, -1.643408047791014e-15,  1.441684392599136e-17, -1.264676435657817e-19,  1.109224781283123e-21,
 -9.721876184406533e-24,  3.317450332647593e-02, -2.811600526265240e-04,  2.382883457659881e-06, -2.019537811118117e-08,  1.711595653323346e-10, -1.450608971259743e-12,
  1.229417885432761e-14, -1.041954094048279e-16,  8.830738074728956e-19, -7.484143559834270e-21,  6.342667014356006e-23, -5.374114123325785e-25,  1.013832868218956e-01,
 -8.592421106586635e-04,  7.282235838577057e-06, -6.171829586623625e-08,  5.230739744084843e-10, -4.433148671994602e-12,  3.757175341367158e-14, -3.184274629389851e-16,
  2.698726677925866e-18, -2.287198361187040e-20,  1.938352546483391e-22, -1.642343256836687e-24,  2.142443518018243e-01, -1.815760514475036e-03,  1.538890625675303e-05,
 -1.304238273055904e-07,  1.105366062788824e-09, -9.368181808308530e-12,  7.939707006597475e-14, -6.729046350510622e-16,  5.702979956360429e-18, -4.833329967427928e-20,
  4.096130375276283e-22, -3.470545998740422e-24,  3.970677120326934e-01, -3.365222312832797e-03,  2.852088163194341e-05, -2.417197478809412e-07,  2.048619577522559e-09,
 -1.736242977788139e-11,  1.471497963267544e-13, -1.247121279649260e-15,  1.056955969475267e-17, -8.957789242732387e-20,  7.591453501189304e-22, -6.431830471124207e-24,
  3.208651734627281e-02, -2.630219131841045e-04,  2.156062188625978e-06, -1.767382840808599e-08,  1.448771803580808e-10, -1.187597665961779e-12,  9.735061106747060e-15,
 -7.980093897919010e-17,  6.541497145014267e-19, -5.362229761069994e-21,  4.395510930591453e-23, -3.602676988879527e-25,  9.805833592199467e-02, -8.038108604780870e-04,
  6.589056334141280e-06, -5.401228760242780e-08,  4.427534177550084e-10, -3.629370230696559e-12,  2.975093499579100e-14, -2.438764909000202e-16,  1.999121013079876e-18,
 -1.638729611772131e-20,  1.343293820486349e-22, -1.100996449392393e-24,  2.072180265301492e-01, -1.698622545912585e-03,  1.392407119107994e-05, -1.141394001857241e-07,
  9.356317196619747e-10, -7.669627774249739e-12,  6.287002501476295e-14, -5.153626602061117e-16,  4.224565823467584e-18, -3.462981847627629e-20,  2.838660819252803e-22,
 -2.326625231432420e-24,  3.840455395639312e-01, -3.148125783668449e-03,  2.580604362973451e-05, -2.115391612582407e-07,  1.734044062776131e-09, -1.421443098180917e-11,
  1.165195569417950e-13, -9.551424260253990e-16,  7.829557889623318e-18, -6.418081214855430e-20,  5.260992100266625e-22, -4.311979092577723e-24,  3.106763682997751e-02,
 -2.465840791251014e-04,  1.957139785389078e-06, -1.553383394879566e-08,  1.232921628514390e-10, -9.785708709831464e-13,  7.766924721242112e-15, -6.164614185172290e-17,
  4.892858601366523e-19, -3.883463212219115e-21,  3.082297421289670e-23, -2.446229246235224e-25,  9.494457549567450e-02, -7.535758462946313e-04,  5.981137449442604e-06,
 -4.747233522008653e-08,  3.767882999252488e-10, -2.990571714399050e-12,  2.373619128259173e-14, -1.883943344868576e-16,  1.495287147287160e-18, -1.186809787651280e-20,
  9.419685587467449e-23, -7.475818205407378e-25,  2.006379914463087e-01, -1.592465324255362e-03,  1.263940986786681e-05, -1.003190960420561e-07,  7.962334583378494e-10,
 -6.319711251634665e-12,  5.015959803734531e-14, -3.981171185608305e-16,  3.159858322354986e-18, -2.507980231379361e-20,  1.990578396662140e-22, -1.579796258940352e-24,
  3.718504947290870e-01, -2.951380316333239e-03,  2.342512890290591e-05, -1.859254332895719e-07,  1.475691633810181e-09, -1.171257615987348e-11,  9.296280931061920e-14,
 -7.378465366176627e-16,  5.856292970500032e-18, -4.648140558965118e-20,  3.689217103833495e-22, -2.927891377556246e-24  };
  constexpr double w[1536] = {  1.256761886958427e-02, -2.040276584147877e-03,  2.043813771615751e-04, -1.589874102088116e-05,  1.043791073371789e-06,
 -6.029131198298835e-08,  3.139700776010411e-09, -1.497514013328309e-10,  6.613307829046749e-12, -2.725325577887418e-13,  1.054069746622352e-14, -3.838428563104486e-16,
  5.874669695259668e-02, -1.436704353277752e-02,  2.047103471165938e-03, -2.148369535999931e-04,  1.821418170564284e-05, -1.309828888448682e-06,  8.231245185435172e-08,
 -4.611365413000598e-09,  2.336074595201230e-10, -1.081562288998475e-11,  4.614157620689579e-13, -1.823454773622134e-14,  9.355720415297419e-02, -3.113510223953505e-02,
  5.711067017504253e-03, -7.373080933943556e-04,  7.419025514168017e-05, -6.151307949263730e-06,  4.351663376931384e-07, -2.690126941338273e-08,  1.478606292013009e-09,
 -7.321824846428650e-11,  3.300456100851707e-12, -1.363842352645961e-13,  6.151664705571539e-02, -2.425731455432126e-02,  5.137674246560240e-03, -7.458218894371693e-04,
  8.256723597005580e-05, -7.400389386311055e-06,  5.578961356921339e-07, -3.632396822132707e-08,  2.082585673237318e-09, -1.067158961728157e-10,  4.944964109696570e-12,
 -2.088926379457755e-13,  6.774870907715185e-03, -9.551585638240092e-04,  8.420467694776046e-05, -5.838802728480200e-06,  3.454302336146000e-07, -1.814869980819672e-08,
  8.667299645143795e-10, -3.819357624692540e-11,  1.569034401662581e-12, -6.053335986491226e-14,  2.205227446286720e-15, -7.609459676268073e-17,  2.274496746196825e-02,
 -4.810830401502176e-03,  6.094447858490067e-04, -5.795768909483478e-05,  4.516416685537274e-06, -3.019200278743446e-07,  1.780314725319506e-08, -9.433219504069588e-10,
  4.550850732203415e-11, -2.018541690854345e-12,  8.293942269072039e-14, -3.171957363255399e-15,  2.397798641572180e-02, -7.287849502338343e-03,  1.242135928141896e-03,
 -1.510336011668440e-04,  1.446145789962194e-05, -1.150156434229917e-06,  7.855055082720503e-08, -4.712271260357422e-09,  2.524264086009994e-10, -1.222578295136933e-11,
  5.406418467649372e-13, -2.197344035161653e-14,  1.125216614131859e-02, -4.310616921865951e-03,  8.902447715363874e-04, -1.265342034557058e-04,  1.376131436873865e-05,
 -1.214879901538887e-06,  9.040078183167559e-08, -5.819523712118676e-09,  3.303471005064115e-10, -1.677881206838091e-11,  7.713749903573963e-13, -3.235490268368922e-14,
  3.961492714001459e-03, -4.895346398252796e-04,  3.818924456358111e-05, -2.367902963545549e-06,  1.264140486664241e-07, -6.041911863437751e-09,  2.643552703257296e-10,
 -1.074024973546254e-11,  4.092578494646499e-13, -1.472747014868179e-14,  5.030442755234288e-16, -1.636064097302865e-17,  1.012433805123256e-02, -1.831849136482282e-03,
  2.045442029129634e-04, -1.748574458655000e-05,  1.242658858142994e-06, -7.663044666089000e-08,  4.208078105532411e-09, -2.093394529204579e-10,  9.549046332773714e-12,
 -4.029944178955942e-13,  1.584318718775172e-14, -5.826932048767575e-16,  7.099658189961569e-03, -1.920092641544003e-03,  2.986982402484661e-04, -3.372834682987612e-05,
  3.037674350638343e-06, -2.294946976052481e-07,  1.500573043422979e-08, -8.673608881296866e-10,  4.500403434929170e-11, -2.120549395332100e-12,  9.156792617625145e-14,
 -3.645654274773318e-15,  2.196943705555942e-03, -8.074034339758009e-04,  1.610862244773396e-04, -2.226036403976372e-05,  2.365373303623832e-06, -2.048005321224899e-07,
  1.499021792231759e-08, -9.514263902327812e-10,  5.334884166632582e-11, -2.680680476872782e-12,  1.220739468657689e-13, -5.077271009794693e-15,  2.473165978610722e-03,
 -2.706572576553057e-04,  1.881246632314466e-05, -1.048029918918598e-06,  5.064415839087859e-08, -2.205619151090867e-09,  8.850644205742555e-11, -3.314559251131334e-12,
  1.170029409344574e-13, -3.921298008613941e-15,  1.252831018361064e-16, -3.827308519810277e-18,  5.099621486899069e-03, -7.854943505765894e-04,  7.695594938131256e-05,
 -5.885279454209624e-06,  3.794515312207943e-07, -2.146514179391610e-08,  1.091310025244250e-09, -5.066521064578185e-11,  2.171939934579260e-12, -8.668035666406524e-14,
  3.240808022284662e-15, -1.139486635558403e-16,  2.463019401961032e-03, -5.765464149629794e-04,  8.041222064198141e-05, -8.312039514728137e-06,  6.956801564779459e-07,
 -4.940841414072150e-08,  3.064979420805987e-09, -1.693457869052652e-10,  8.451597753801226e-12, -3.850556843607959e-13,  1.614861622605783e-14, -6.268324441507687e-16,
  4.690349595551843e-04, -1.621504657301894e-04,  3.083723048302776e-05, -4.102586499713094e-06,  4.227620904458974e-07, -3.569056546416898e-08,  2.557722200098774e-09,
 -1.594573878127553e-10,  8.805008236715772e-12, -4.365959868304892e-13,  1.965243665850694e-14, -8.090809749041162e-16,  1.627697988452630e-03, -1.594211287236513e-04,
  9.945129374269504e-06, -5.005386332193644e-07,  2.199289178157750e-08, -8.746338859452818e-10,  3.226177038896824e-11, -1.116070731501569e-12,  3.647071648189766e-14,
 -1.137747669567339e-15,  3.400645271512570e-17, -9.737319572298551e-19,  2.853636861000678e-03, -3.744374305489873e-04,  3.215896846982805e-05, -2.196184960064970e-06,
  1.281257130147506e-07, -6.627062616718663e-09,  3.107066905340814e-10, -1.340276049107198e-11,  5.374559654802243e-13, -2.018344173212370e-14,  7.139414741801515e-16,
 -2.387307402920985e-17,  1.004909497567610e-03, -1.983668445923465e-04,  2.442231695858074e-05, -2.281037300256338e-06,  1.753904436125358e-07, -1.159143406642948e-08,
  6.759242113806143e-10, -3.540226510845542e-11,  1.686788091694421e-12, -7.380919835209174e-14,  2.988276868000222e-15, -1.124831602865688e-16,  1.131216480986978e-04,
 -3.569037159006265e-05,  6.350947207611968e-06, -8.026223114116315e-07,  7.940420629152426e-08, -6.485458678485249e-09,  4.522575172887596e-10, -2.755819343318193e-11,
  1.492525083799439e-12, -7.278844287137375e-14,  3.229716259574085e-15, -1.313147260367327e-16,  1.118076871377619e-03, -9.900455806937289e-05,  5.584780508213094e-06,
 -2.551833765487437e-07,  1.026129195812380e-08, -3.736561794877016e-10,  1.267150186179226e-11, -4.073784831965604e-13,  1.234599768816863e-14, -3.567145436686696e-16,
  1.002770125208847e-17, -2.692486753632715e-19,  1.742123529077821e-03, -1.956895483840997e-04,  1.476341439206294e-05, -9.009722090023157e-07,  4.753399415948175e-08,
 -2.245490127064346e-09,  9.690257950168312e-11, -3.872393094075047e-12,  1.447959603082013e-13, -5.099718240224604e-15,  1.699627562446108e-16, -5.381367474154298e-18,
  4.785606372098146e-04, -7.798083272685944e-05,  8.380130314445859e-06, -7.002131464389913e-07,  4.897429642107245e-08, -2.985277053411308e-09,  1.622634196028478e-10,
 -7.991119698727483e-12,  3.608023233053684e-13, -1.505902378548708e-14,  5.848041737663169e-16, -2.122340187779978e-17,  3.207726169749270e-05, -8.831220671676216e-06,
  1.435665095586280e-06, -1.693953184482980e-07,  1.587930613301391e-08, -1.242148387563031e-09,  8.361390634696065e-11, -4.947864474864783e-12,  2.614602662746993e-13,
 -1.248742134820614e-14,  5.442462549177330e-16, -2.178885132330120e-17,  7.953278216288406e-04, -6.426109709657592e-05,  3.305627827944774e-06, -1.374678323230103e-07,
  5.094264602537040e-09, -1.713566948694136e-10,  5.306959000832752e-12, -1.587932321911586e-13,  4.564838218609959e-15, -1.201945935238436e-16,  3.113053643713342e-18,
 -8.356751893535439e-20,  1.141708241102135e-03, -1.106429578692821e-04,  7.360293867848126e-06, -4.025796183464594e-07,  1.922441240128609e-08, -8.294657584915542e-10,
  3.296448160654718e-11, -1.218951418205509e-12,  4.237160716971492e-14, -1.397531511773788e-15,  4.382063814226761e-17, -1.306957108537361e-18,  2.616900317505651e-04,
 -3.469256365259563e-05,  3.231494452455509e-06, -2.404067842956741e-07,  1.517433013399631e-08, -8.468968995168772e-10,  4.264522059749557e-11, -1.960458294811712e-12,
  8.326668940034902e-14, -3.295049270484915e-15,  1.219652357029460e-16, -4.239523067301920e-18,  1.112941390252630e-05, -2.516969909057972e-06,  3.637393719743733e-07,
 -3.927577485169735e-08,  3.432713721247595e-09, -2.539854306994829e-10,  1.633986003260636e-11, -9.313149531190418e-13,  4.769994217286446e-14, -2.219009270612744e-15,
  9.456188973590269e-17, -3.713656320080903e-18,  5.823874600944608e-04, -4.325084666378266e-05,  2.050871707478604e-06, -7.771513727575663e-08,  2.651632326964081e-09,
 -8.412840809493351e-11,  2.391911140281901e-12, -6.372707320140152e-14,  1.798006323867029e-15, -4.756930537952272e-17,  9.536047936529491e-19, -2.267072521170735e-20,
  7.923178006883946e-04, -6.688507567131074e-05,  3.940509528478528e-06, -1.940611133940658e-07,  8.413074692427965e-09, -3.313610331752592e-10,  1.214048616187485e-11,
 -4.170155418109352e-13,  1.344390900151764e-14, -4.123528827102889e-16,  1.222218330432804e-17, -3.456029828009772e-19,  1.608461239092036e-04, -1.725339865403504e-05,
  1.384064868594550e-06, -9.189090816901023e-08,  5.214633377457132e-09, -2.642376972669614e-10,  1.228500645192646e-11, -5.258222560286756e-13,  2.082520034678897e-14,
 -7.757104553220821e-16,  2.734763448514210e-17, -9.043457882909309e-19,  4.838190169987969e-06, -8.402779004545202e-07,  1.049609052489329e-07, -1.018600762977291e-08,
  8.151088225359524e-10, -5.620172777110497e-11,  3.417485850312390e-12, -1.857987399231981e-13,  9.143905401740677e-15, -4.116341953047410e-16,  1.706216604544711e-17,
 -6.538316348076398e-19,  4.371636489817684e-04, -2.996316679039834e-05,  1.326009766995397e-06, -4.613820873141168e-08,  1.426313320943800e-09, -4.298912503146102e-11,
  1.199830154797375e-12, -2.757880975022281e-14,  6.197343824162025e-16, -2.030678249132690e-17,  5.554960601193946e-19, -2.840958822599089e-21,  5.757527250262232e-04,
 -4.280507172208236e-05,  2.242946393144558e-06, -9.988142940711052e-08,  3.957082759875532e-09, -1.424520833680663e-10,  4.787328377022744e-12, -1.534353209347180e-13,
  4.656417601816267e-15, -1.316482230823908e-16,  3.566516164164173e-18, -9.802380007116551e-20,  1.085729751854327e-04, -9.491132776379983e-06,  6.484613870889689e-07,
 -3.863533490355749e-08,  1.987752125620790e-09, -9.059015187186438e-11,  3.842380197510105e-12, -1.542555355346836e-13,  5.727601690076899e-15, -1.962232780879869e-16,
  6.491172615823076e-18, -2.107295724291036e-19,  2.610751486602030e-06, -3.311416963752808e-07,  3.461391718890537e-08, -2.992242995444780e-09,  2.161850321489521e-10,
 -1.362976822711659e-11,  7.732754929874772e-13, -3.980512518187126e-14,  1.863956595516312e-15, -8.026111632413855e-17,  3.218528593344646e-18, -1.202318031766264e-19,
  3.354935684633299e-04, -2.123810930891939e-05,  8.853363202483236e-07, -2.886031692138956e-08,  8.011892399844001e-10, -2.174911335074546e-11,  6.239197234134413e-13,
 -1.552892164230240e-14,  2.377845757588661e-16, -3.003284667489138e-18,  2.419288880418134e-19, -1.087404808616687e-20,  4.341061516704417e-04, -2.876164246652961e-05,
  1.347084963814247e-06, -5.432337420084422e-08,  1.980460190558351e-09, -6.584145526345762e-11,  2.021353867552784e-12, -5.933680742256233e-14,  1.713986546774302e-15,
 -4.726773925582012e-17,  1.164750286090581e-18, -2.627607724540326e-20,  7.866292533286621e-05, -5.728435901856227e-06,  3.288341217193211e-07, -1.748016020332193e-08,
  8.329292645940299e-10, -3.459415279761911e-11,  1.300990670208020e-12, -4.775021215111173e-14,  1.728947362572465e-15, -5.699735611222127e-17,  1.635858121873125e-18,
 -4.630704069255180e-20,  1.674729085107912e-06, -1.547073719957043e-07,  1.292772041820197e-08, -9.905184667403023e-10,  6.496760784722615e-11, -3.690644720067176e-12,
  1.903425085731357e-13, -9.181885926777542e-15,  4.112444313447714e-16, -1.681539854672418e-17,  6.338257706739442e-19, -2.278493145488005e-20,  2.627830345939151e-04,
 -1.535123734985225e-05,  6.038392009617356e-07, -1.884072310663493e-08,  4.849193678122882e-10, -1.118812876734838e-11,  2.876047873057365e-13, -8.642395279358364e-15,
  2.019514882955179e-16, -1.126835118953264e-18, -7.243645282415240e-20, -1.316409495042874e-21,  3.371315346892140e-04, -2.013916664337356e-05,  8.490981363197005e-07,
 -3.100554449257992e-08,  1.040554957044404e-09, -3.236654248767269e-11,  9.252372777584228e-13, -2.454054016262975e-14,  6.370790646923011e-16, -1.714425135393758e-17,
  4.542665790585332e-19, -1.003163891085746e-20,  5.994414465297046e-05, -3.753687629259928e-06,  1.806800539923827e-07, -8.354466739775416e-09,  3.706349913309336e-10,
 -1.468645473620159e-11,  5.020452001474978e-13, -1.562498357374420e-14,  5.068050065932853e-16, -1.772803156610608e-17,  5.588499093412482e-19, -1.289931521897345e-20,
  1.206622697326708e-06, -8.550233312845715e-08,  5.459363042262432e-09, -3.597533904480712e-10,  2.183437702124221e-11, -1.143454312230448e-12,  5.261092093322080e-14,
 -2.262435233796374e-15,  9.529235963219104e-17, -3.854424004903553e-18,  1.411908144816408e-19, -4.569263648832767e-21,  2.097740375934753e-04, -1.130790714312214e-05,
  4.179388340658644e-07, -1.256689215717340e-08,  3.141232526287695e-10, -6.516414876700446e-12,  1.261458639542236e-13, -3.345870267107070e-15,  1.175706066951070e-16,
 -2.965758026271252e-18,  6.576870991284490e-21,  2.425012449852983e-21,  2.681473618775840e-04, -1.459398886436368e-05,  5.589188372390945e-07, -1.852720956374805e-08,
  5.695031453223496e-10, -1.656683484966027e-11,  4.513226377099047e-13, -1.126646407934174e-14,  2.584237113689778e-16, -5.885092872307846e-18,  1.510325264278958e-19,
 -4.183071986872592e-21,  4.730281849531895e-05, -2.627145711993674e-06,  1.080941204201963e-07, -4.241488247176296e-09,  1.694095885828862e-10, -6.514863554585115e-12,
  2.207256015036001e-13, -6.265182886333774e-15,  1.563676039155171e-16, -4.363600334865763e-18,  1.603500253952262e-19, -5.693184408856287e-21,  9.311703554862812e-07,
 -5.453544057575462e-08,  2.659108726959531e-09, -1.414149341073903e-10,  7.813248322629603e-12, -3.936032599436159e-13,  1.704877098446356e-14, -6.452209434219728e-16,
  2.305632225897211e-17, -8.539742551719499e-19,  3.268192185242591e-20, -1.154068507953350e-21,  1.703830964164895e-04, -8.491133325938093e-06,  2.934526910317199e-07,
 -8.444467459754768e-09,  2.082804398777189e-10, -4.280653817763313e-12,  7.038709463975304e-14, -1.086988758069245e-15,  3.289210138891833e-17, -1.488898191006367e-18,
  4.554453217591358e-20, -4.066504690058343e-22,  2.174957687282410e-04, -1.087886919980357e-05,  3.819795455881673e-07, -1.156993206752008e-08,  3.250573487450932e-10,
 -8.747789558078995e-12,  2.263719870959371e-13, -5.508871892667549e-15,  1.216254503270079e-16, -2.395722716700040e-18,  4.584886789574045e-20, -1.098318381721187e-21,
  3.825542337978484e-05, -1.928197543573580e-06,  6.995029704813533e-08, -2.336466136244810e-09,  8.031109304847982e-11, -2.868197796682266e-12,  9.824077892639965e-14,
 -2.923239762404657e-15,  6.984717988346441e-17, -1.309722440487633e-18,  2.629115295867137e-20, -1.072863345589957e-21,  7.471890980740832e-07, -3.840456634254147e-08,
  1.510617908670725e-09, -6.208211874911692e-11,  2.906110490060395e-12, -1.392522547024004e-13,  6.031113242564580e-15, -2.229712340426811e-16,  7.041862437403947e-18,
 -2.041459532775922e-19,  6.375572137412280e-21, -2.344716219575532e-22,  1.405441246048328e-04, -6.498148765954290e-06,  2.095618112317896e-07, -5.713828669607479e-09,
  1.375414628039073e-10, -2.875817174734913e-12,  4.884644409194436e-14, -5.920057125278974e-16,  5.484531030539026e-18, -2.390175379628110e-19,  1.594310291055428e-20,
 -6.038851919649167e-22,  1.793220741327753e-04, -8.301584236646257e-06,  2.694022648909101e-07, -7.518915634766043e-09,  1.939113235434064e-10, -4.794983416109366e-12,
  1.157365910829236e-13, -2.714763402080721e-15,  6.003687127284791e-17, -1.190067558205397e-18,  2.005754195176189e-20, -2.956356992906961e-22,  3.151025798954325e-05,
 -1.462549757376650e-06,  4.807832591166137e-08, -1.406080026293131e-09,  4.103640150022963e-11, -1.278017886585843e-12,  4.167142665975221e-14, -1.299358859594536e-15,
  3.494523347456278e-17, -7.274601502734709e-19,  9.792266386238792e-21, -5.909840511513803e-23,  6.139127893760029e-07, -2.867860670630684e-08,  9.733298526101009e-10,
 -3.173760383896764e-11,  1.170742619723570e-12, -4.938037031717063e-14,  2.100704673032305e-15, -8.049589739675776e-17,  2.622277715452804e-18, -7.103225130007470e-20,
  1.642770934763052e-21, -3.864156338743325e-23,  1.175178089338226e-04, -5.062490967394543e-06,  1.524934431099978e-07, -3.914946987512964e-09,  9.048674704493203e-11,
 -1.887245145347494e-12,  3.405717708112260e-14, -4.735484264768784e-16,  3.395042437499208e-18,  2.338675513522223e-20,  6.864712604297964e-22, -1.329103543193564e-22,
  1.499206843265376e-04, -6.460952097570823e-06,  1.950527271870872e-07, -5.055007198626292e-09,  1.206036819651122e-10, -2.746981080375531e-12,  6.115435114322173e-14,
 -1.345980432595348e-15,  2.903686503590520e-17, -5.927934971829796e-19,  1.075786092461218e-20, -1.575550492336217e-22,  2.633602658026654e-05, -1.135895814566186e-06,
  3.444843782425484e-08, -9.100216438387856e-10,  2.309010738739020e-11, -6.097289949328533e-13,  1.752181971191384e-14, -5.288377588977726e-16,  1.527289412712213e-17,
 -3.814295365309656e-19,  7.288588833051751e-21, -7.678007308699951e-23,  5.127286846565046e-07, -2.215739660918746e-08,  6.794109386727035e-10, -1.878934510765791e-11,
  5.451491304541964e-13, -1.850452084144083e-14,  7.122561926516320e-16, -2.737115836375467e-17,  9.492207338456168e-19, -2.806709573168807e-20,  6.795265659836276e-22,
 -1.295107150129676e-23,  9.944150633190677e-05, -4.008450012137996e-06,  1.130873186935866e-07, -2.728984880107287e-09,  5.990832448267878e-11, -1.215943188400180e-12,
  2.243810786976022e-14, -3.533853122323645e-16,  3.932291027513405e-18, -3.467345021659575e-21, -1.003437949370892e-21,  1.261731859968470e-23,  1.268549291596861e-04,
 -5.114080475075329e-06,  1.443849414619269e-07, -3.496270577560875e-09,  7.775718731357604e-11, -1.643590128718126e-12,  3.378710607500029e-14, -6.874817204642329e-16,
  1.396390659526663e-17, -2.802344576204000e-19,  5.354722031837314e-21, -9.091522906467769e-23,  2.228226211112720e-05, -8.985086522631044e-07,  2.540473786681694e-08,
 -6.194731381060621e-10,  1.413971741155350e-11, -3.225146672746504e-13,  7.853503935217530e-15, -2.104632084817990e-16,  5.934398817783002e-18, -1.607379024938087e-19,
  3.805239482698957e-21, -7.002163177994190e-23,  4.337202168277421e-07, -1.749888906611812e-08,  4.964826189818329e-10, -1.230803650355472e-11,  2.983018716237229e-13,
 -7.945603310964865e-15,  2.508885421023613e-16, -8.885589662009421e-18,  3.124463147180523e-19, -9.972046857203889e-21,  2.738936200748358e-22, -6.171671162288559e-24,
  8.503048889404553e-05, -3.220121486715532e-06,  8.537437070658778e-08, -1.938855643859407e-09,  4.024522705930384e-11, -7.823046489187224e-13,  1.423921326348034e-14,
 -2.358457523612769e-16,  3.268069968145449e-18, -2.803764711647765e-20, -2.204234986417474e-22,  1.511533096967052e-23,  1.084699396741717e-04, -4.107913166660746e-06,
  1.089364019073565e-07, -2.476814290460961e-09,  5.166129296475921e-11, -1.021219624184991e-12,  1.953094485404510e-14, -3.675858076815040e-16,  6.909717115942121e-18,
 -1.306822232504564e-19,  2.461208292537454e-21, -4.449936828459730e-23,  1.905247998622189e-05, -7.215917329788942e-07,  1.914411067884351e-08, -4.362758465879708e-10,
  9.188525700775785e-12, -1.877214433621873e-13,  3.926892467196019e-15, -8.915955605298096e-17,  2.242427590342699e-18, -5.943704487666814e-20,  1.522409814562541e-21,
 -3.458829715711159e-23,  3.708338453544649e-07, -1.404697770907060e-08,  3.730486631962449e-10, -8.547208636245734e-12,  1.841193289650492e-13, -4.047773318039073e-15,
  1.004997393150955e-16, -2.967151525001895e-18,  9.727524217739706e-20, -3.159767484515290e-21,  9.389718560463893e-23, -2.431569606157480e-24,  7.338266562532842e-05,
 -2.620323684881683e-06,  6.550982029262587e-08, -1.403577779282686e-09,  2.753863279696300e-11, -5.089559249938517e-13,  8.942150759735645e-15, -1.480489249924201e-16,
  2.225414859139177e-18, -2.732997753170815e-20,  1.708043701043014e-22,  3.628248504748082e-24,  9.361101218305160e-05, -3.342659676111618e-06,  8.357401944680042e-08,
 -1.791259972765923e-09,  3.520352349994161e-11, -6.547524912335410e-13,  1.174283585073562e-14, -2.060334672375170e-16,  3.586370732627662e-18, -6.277546830999499e-20,
  1.112939802513802e-21, -1.979456535688937e-23,  1.644245144574687e-05, -5.871365754948869e-07,  1.468157406254887e-08, -3.148988323016552e-10,  6.209173100106112e-12,
 -1.169466079668415e-13,  2.182292593010995e-15, -4.238355241039910e-17,  9.032716021130478e-19, -2.140530663568222e-20,  5.355341944688072e-22, -1.303280533905590e-23,
  3.200286428015877e-07, -1.142819367795425e-08,  2.858461551704707e-10, -6.140938156284461e-12,  1.220059927627784e-13, -2.364638545523646e-15,  4.804565206421880e-17,
 -1.120485071293742e-18,  3.101609962682659e-20, -9.457013133829547e-22,  2.857976303745141e-23, -7.966160343771649e-25,  6.385249853959521e-05, -2.156830651220035e-06,
  5.100892950737794e-08, -1.034007820656288e-09,  1.920777631788202e-11, -3.368981025435398e-13,  5.656482961764311e-15, -9.106288858618059e-17,  1.385923198145914e-18,
 -1.908243238334688e-20,  2.093366251810653e-22, -8.745747227758905e-25,  8.145374253572919e-05, -2.751377254214482e-06,  6.507105258507990e-08, -1.319203489668103e-09,
  2.451862820877331e-11, -4.310017432734904e-13,  7.293499244710988e-15, -1.202881347992863e-16,  1.955279445661671e-18, -3.171646762322743e-20,  5.200796846276885e-22,
 -8.684720228066528e-24,  1.430704907739717e-05, -4.832712946544677e-07,  1.142992357319454e-08, -2.317703996271733e-10,  4.312184525945018e-12, -7.613428468541140e-14,
  1.308385109127234e-15, -2.258955291982193e-17,  4.105507459905182e-19, -8.246712216386144e-21,  1.846011894436201e-22, -4.369477153378723e-24,  2.784652633621730e-07,
 -9.406237004514812e-09,  2.224847221550741e-10, -4.513519224144664e-12,  8.417309641229066e-14, -1.500873426947648e-15,  2.669466516744601e-17, -5.067612655243317e-19,
  1.114399295319742e-20, -2.897196561189907e-22,  8.247654305368962e-24, -2.330149925725301e-25,  5.596949037764124e-05, -1.793635203150354e-06,  4.024415411132095e-08,
 -7.739953780846353e-10,  1.364424912368506e-11, -2.273074496375143e-13,  3.635307919290790e-15, -5.618733307089784e-17,  8.370735826172908e-19, -1.180962324267973e-20,
  1.501808081306288e-22, -1.485775386385896e-24,  7.139773378942779e-05, -2.288060077961786e-06,  5.133789598936005e-08, -9.873851694147108e-10,  1.740875212797269e-11,
 -2.902322182507295e-13,  4.654580770572520e-15, -7.261274597513279e-17,  1.111819312429449e-18, -1.686661151168480e-20,  2.564422400690606e-22, -3.956824785377261e-24,
  1.254074420899594e-05, -4.018895805850384e-07,  9.017396398642967e-09, -1.734422197254804e-10,  3.058946046927636e-12, -5.106988955858588e-14,  8.235145669263079e-16,
 -1.308146312049749e-17,  2.107923817292362e-19, -3.603885766752499e-21,  6.840852904021869e-23, -1.448209131614092e-24,  2.440866169087193e-07, -7.822189615128724e-09,
  1.755136231896563e-10, -3.376283423397244e-12,  5.958730746242890e-14, -9.979523763223799e-16,  1.628904826061672e-17, -2.691703489110115e-19,  4.805460786443124e-21,
 -9.984050677621944e-23,  2.440998837527169e-24, -6.504869787662994e-26,  4.938485205176041e-05, -1.505439672408816e-06,  3.213004945695265e-08, -5.878012377555177e-10,
  9.857258397331872e-12, -1.562666101724732e-13,  2.380706678811606e-15, -3.516683577312841e-17,  5.050954499417080e-19, -7.016825877109430e-21,  9.241037387346282e-23,
 -1.093719606184730e-24,  6.299800768777358e-05, -1.920421098173294e-06,  4.098689276849696e-08, -7.498382109876676e-10,  1.257515147417113e-11, -1.993976522639379e-13,
  3.040609142446930e-15, -4.506443190866465e-17,  6.541476301083077e-19, -9.365602976182756e-21,  1.333573457524634e-22, -1.908863935027152e-24,  1.106536300687056e-05,
 -3.373148194477799e-07,  7.199210700235827e-09, -1.317085959082527e-10,  2.209013680521871e-12, -3.504233368538931e-14,  5.353222348811471e-16, -7.985662294371724e-18,
  1.183112201520671e-19, -1.790302672303806e-21,  2.889787878142434e-23, -5.190159634040009e-25,  2.153705201919939e-07, -6.565324955621599e-09,  1.401224296384458e-10,
 -2.563604704196208e-12,  4.300493888908673e-14, -6.828430837603485e-16,  1.047268152915803e-17, -1.584729415000617e-19,  2.452889966299487e-21, -4.134899871935426e-23,
  8.124603520102781e-25, -1.868961007034905e-26,  4.383599681609895e-05, -1.274151456118144e-06,  2.592880984325863e-08, -4.522880045192506e-10,  7.232071993728356e-12,
 -1.093293626063438e-13,  1.588924233170605e-15, -2.241805281336998e-17,  3.086580301824753e-19, -4.149177479505557e-21,  5.408050279231656e-23, -6.687978140007840e-25,
  5.591958518365755e-05, -1.625377043266706e-06,  3.307621205526632e-08, -5.769645725767678e-10,  9.225763288146714e-12, -1.394776894602180e-13,  2.027668303980245e-15,
 -2.864035771725960e-17,  3.958429689259075e-19, -5.383856281284059e-21,  7.247982072561170e-23, -9.729632443849020e-25,  9.822064570522472e-06, -2.854913724315621e-07,
  5.809715407707534e-09, -1.013421090393360e-10,  1.620517048755873e-12, -2.450251095453755e-14,  3.564067696432157e-16, -5.045131145959472e-18,  7.025015126474758e-20,
 -9.771029107180406e-22,  1.394787755145655e-23, -2.130302667272228e-25,  1.911715941037180e-07, -5.556657295051991e-09,  1.130774349161457e-10, -1.972488972619256e-12,
  3.154281369703967e-14, -4.770608199069145e-16,  6.947571781111125e-18, -9.881261754143633e-20,  1.398288378536939e-21, -2.038702017654485e-23,  3.253310133021906e-25,
 -6.045539973045883e-27,  3.912245183581463e-05, -1.086617381006757e-06,  2.112964855518889e-08, -3.521905648091706e-10,  5.381215022887089e-12, -7.773594712394520e-14,
  1.079714234458375e-15, -1.456517200132472e-17,  1.920048562651400e-19, -2.480896557695420e-21,  3.139019433047873e-23, -3.857913816115762e-25,  4.990673038034204e-05,
 -1.386148322853601e-06,  2.695413241723316e-08, -4.492737273477671e-10,  6.864597835770959e-12, -9.916641218235876e-14,  1.377492080615760e-15, -1.858878853768969e-17,
  2.453663427558775e-19, -3.183948886737211e-21,  4.079663023766098e-23, -5.186784112797797e-25,  8.765929235898223e-06, -2.434717353361524e-07,  4.734392470326460e-09,
 -7.891332475007117e-11,  1.205749712229557e-12, -1.741894475714456e-14,  2.420016791218236e-16, -3.267978675547137e-18,  4.324535055443292e-20, -5.658075791819651e-22,
  7.425165874534457e-24, -1.003076633806882e-25,  1.706155199881038e-07, -4.738808242251535e-09,  9.214779508449124e-11, -1.535931673652304e-12,  2.346845164493977e-14,
 -3.390634194441761e-16,  4.712268055879002e-18, -6.372790134646742e-20,  8.479090286581154e-22, -1.129150747177636e-23,  1.557008635857231e-25, -2.355136563183314e-27,
  3.508921154917777e-05, -9.331313015956211e-07,  1.737286246137411e-08, -2.772480758683566e-10,  4.055860776031930e-12, -5.609703113213500e-14,  7.460336414930785e-16,
 -9.637412488584610e-18,  1.217220494271959e-19, -1.509157209297580e-21,  1.839809721329620e-23, -2.200973369403489e-25,  4.476170938176144e-05, -1.190353112797103e-06,
  2.216176991811465e-08, -3.536727949034051e-10,  5.173882015835163e-12, -7.156085228183890e-14,  9.517103357644468e-16, -1.229571992453565e-17,  1.553624650623311e-19,
 -1.929078457997370e-21,  2.362637874546434e-23, -2.864083982645057e-25,  7.862225668720000e-06, -2.090810416092425e-07,  3.892631534774372e-09, -6.212131058368445e-11,
  9.087745812774580e-13, -1.256953513483243e-14,  1.671740781455051e-16, -2.160270678936889e-18,  2.731819960192960e-20, -3.401610366693207e-22,  4.203265674505463e-24,
 -5.223925052474399e-26,  1.530263002008191e-07, -4.069445440647616e-09,  7.576417450654273e-11, -1.209097749172926e-12,  1.768798657140086e-14, -2.446526022203693e-16,
  3.254184419337526e-18, -4.206983253699581e-20,  5.329185546090600e-22, -6.675968510976037e-24,  8.406069004667810e-26, -1.099280527945937e-27,  3.161503376260726e-05,
 -8.064324879374519e-07,  1.440114245624273e-08, -2.204414264959832e-10,  3.093189382084394e-12, -4.103580198401118e-14,  5.234627060728356e-16, -6.486524239980261e-18,
  7.859923019265970e-20, -9.354464876459455e-22,  1.096446800425194e-23, -1.266486185979667e-25,  4.032985897338985e-05, -1.028729204071443e-06,  1.837088173667061e-08,
 -2.812070989988641e-10,  3.945841799025203e-12, -5.234758398405471e-14,  6.677631047223214e-16, -8.274894013168933e-18,  1.002825138732865e-19, -1.194083567316629e-21,
  1.401848819577999e-23, -1.627177632653093e-25,  7.083787834953206e-06, -1.806924103034528e-07,  3.226776208161800e-09, -4.939297080775309e-11,  6.930725645901064e-13,
 -9.194682378199868e-15,  1.172919193108497e-16, -1.453563905579500e-18,  1.761994466897088e-20, -2.099971246867722e-22,  2.472959847644712e-24, -2.897347758040384e-26,
  1.378751881654245e-07, -3.516903763524904e-09,  6.280430654426189e-11, -9.613593924133491e-13,  1.348961883453322e-14, -1.789615965241955e-16,  2.282983026281780e-18,
 -2.829584181514489e-20,  3.431767851427694e-22, -4.097958195704727e-24,  4.857354099571812e-26, -5.803449208251770e-28,  2.860407932649861e-05, -7.010214160010579e-07,
  1.202776176441153e-08, -1.768905384785662e-10,  2.384739986320680e-12, -3.039629387289747e-14,  3.725356895258541e-16, -4.435315896666768e-18,  5.163979898692770e-20,
 -5.906364210317520e-22,  6.656989741679143e-24, -7.406310807174984e-26,  3.648892150314946e-05, -8.942610992654079e-07,  1.534326800746517e-08, -2.256512068340265e-10,
  3.042104385837935e-12, -3.877518280517259e-14,  4.752278570873973e-16, -5.657993005603046e-18,  6.587780270204575e-20, -7.535985207958368e-22,  8.498227881250442e-24,
 -9.470979130420302e-26,  6.409141634181700e-06, -1.570735940566984e-07,  2.694987242109799e-09, -3.963478515115407e-11,  5.343342351991518e-13, -6.810719684368120e-15,
  8.347232626986277e-17, -9.938258124898837e-19,  1.157227033387737e-20, -1.324168856646540e-22,  1.494759080795656e-24, -1.671301858674304e-26,  1.247442229114016e-07,
 -3.057199318266223e-09,  5.245384006126212e-11, -7.714310105595189e-13,  1.040000784049880e-14, -1.325605213046879e-16,  1.624675781698329e-18, -1.934413255886187e-20,
  2.252800014717303e-22, -2.579316196173734e-24,  2.917772448040937e-26, -3.284799545261596e-28,  2.597985273115796e-05, -6.126846615094842e-07,  1.011541457898588e-08,
 -1.431514186502388e-10,  1.857051268233339e-12, -2.277692954513656e-14,  2.686175440971520e-16, -3.077404987295741e-18,  3.447826028330239e-20, -3.794967524358748e-22,
  4.116996300634559e-24, -4.411512255379996e-26,  3.314131513016250e-05, -7.815739239504005e-07,  1.290377377260028e-08, -1.826117466332687e-10,  2.368955773245124e-12,
 -2.905549456856776e-14,  3.426633609972870e-16, -3.925717012991261e-18,  4.398295865136392e-20, -4.841352753912964e-22,  5.253056419983257e-24, -5.632053880082528e-26,
  5.821147182788266e-06, -1.372805161103480e-07,  2.266499264467342e-09, -3.207506562340622e-11,  4.160981696987132e-13, -5.103489071443644e-15,  6.018759152364692e-17,
 -6.895412192605188e-19,  7.725642769207871e-21, -8.504598254087167e-23,  9.230753558144166e-25, -9.907459607885429e-27,  1.132998025646423e-07, -2.671957070236989e-09,
  4.411397122647537e-11, -6.242925165363377e-13,  8.098720287947310e-15, -9.933170990997292e-17,  1.171462646107282e-18, -1.342102378428475e-20,  1.503758911008264e-22,
 -1.655666856810181e-24,  1.798212832389599e-26, -1.934386882701279e-28,  2.368075137284843e-05, -5.381599771030066e-07,  8.561901362421103e-09, -1.167598348948669e-10,
  1.459595950300637e-12, -1.725101765197081e-14,  1.960490306348401e-16, -2.164343460040242e-18,  2.336684734423098e-20, -2.478473190570692e-22,  2.591234976927412e-24,
 -2.676452664842443e-26,  3.020845621749386e-05, -6.865061775447748e-07,  1.092202770011783e-08, -1.489452047400029e-10,  1.861940096382719e-12, -2.200633817468482e-14,
  2.500908559391544e-16, -2.760956517294755e-18,  2.980813595073775e-20, -3.161728529358401e-22,  3.305744613589288e-24, -3.415082628383987e-26,  5.306001560771171e-06,
 -1.205822245043447e-07,  1.918413030110833e-09, -2.616166425858844e-11,  3.270427671513771e-13, -3.865330575832699e-15,  4.392752823584930e-17, -4.849523061261620e-19,
  5.235723784552957e-21, -5.553631796322383e-23,  5.807155438638283e-25, -6.001291508530023e-27,  1.032732742129018e-07, -2.346950145776873e-09,  3.733900050100115e-11,
 -5.091971231679046e-13,  6.365391595858406e-15, -7.523280422392068e-17,  8.549831607830341e-19, -9.438888132359742e-21,  1.019068679940375e-22, -1.080998886978196e-24,
  1.130567388962228e-26, -1.169187358396503e-28,  2.165675602703801e-05, -4.748968852676007e-07,  7.290294137839414e-09, -9.592999796107073e-11,  1.157122760770600e-12,
 -1.319614804515041e-14,  1.447047436950577e-16, -1.541451738185595e-18,  1.605795023665614e-20, -1.643474031580369e-22,  1.657994429472798e-24, -1.652597724061775e-26,
  2.762653751796710e-05, -6.058043319894026e-07,  9.299896266364357e-09, -1.223735302120176e-10,  1.476088817039637e-12, -1.683372525745072e-14,  1.845932585649089e-16,
 -1.966360173515436e-18,  2.048441638632064e-20, -2.096514713031016e-22,  2.115069408222972e-24, -2.108302989659856e-26,  4.852497265454986e-06, -1.064072492787069e-07,
  1.633491753092980e-09, -2.149444969039047e-11,  2.592694416542061e-13, -2.956780468617721e-15,  3.242311264519955e-17, -3.453838826201902e-19,  3.598017261974464e-21,
 -3.682480935689074e-23,  3.715175577031273e-25, -3.703679075634944e-27,  9.444650081098891e-08, -2.071055748316990e-09,  3.179343990264095e-11, -4.183568685570485e-13,
  5.046286530618687e-15, -5.754924913879823e-17,  6.310667972593061e-19, -6.722378295474585e-21,  7.003020790785040e-23, -7.167514373839025e-25,  7.231557147725406e-27,
 -7.210713575661429e-29,  1.986694186262477e-05, -4.208833357250851e-07,  6.242081996802739e-09, -7.935241822702873e-11,  9.247113782852221e-13, -1.018813850343858e-14,
  1.079322553430127e-16, -1.110757416697476e-18,  1.117893243350984e-20, -1.105336915744110e-22,  1.077306315774062e-24, -1.037433068866458e-26,  2.534335308805385e-05,
 -5.369017063580647e-07,  7.962739768589305e-09, -1.012262666018815e-10,  1.179612198491159e-12, -1.299654438453220e-14,  1.376842645129873e-16, -1.416942725639106e-18,
  1.426045873328571e-20, -1.410029725694751e-22,  1.374278141382400e-24, -1.323435352211129e-26,  4.451464519477211e-06, -9.430476259381284e-08,  1.398625250362103e-09,
 -1.778001248156706e-11,  2.071944399580273e-13, -2.282794077238809e-15,  2.418372285583701e-17, -2.488806750719591e-19,  2.504797055962819e-21, -2.476669813298710e-23,
  2.413892359196109e-25, -2.324659975975191e-27,  8.664100654767500e-08, -1.835499197538170e-09,  2.722211958440635e-11, -3.460609808700297e-13,  4.032725580498907e-15,
 -4.443112520509502e-17,  4.706995059234664e-19, -4.844085766832423e-21,  4.875212187673466e-23, -4.820484190687895e-25,  4.698370508942705e-27, -4.524970401968127e-29,
  1.827758681120306e-05, -3.745186955993801e-07,  5.372329765330542e-09, -6.605628616160521e-11,  7.445274769893354e-13, -7.933955957138760e-15,  8.129550682641986e-17,
 -8.091980396804496e-19,  7.876916711680853e-21, -7.533054166553622e-23,  7.101284152652829e-25, -6.614309557209730e-27,  2.331588522062925e-05, -4.777564461749813e-07,
  6.853236451273426e-09, -8.426499636735377e-11,  9.497598001829288e-13, -1.012098634249850e-14,  1.037049764382988e-16, -1.032257104082966e-18,  1.004822461895778e-20,
 -9.609577301482576e-23,  9.058798330850095e-25, -8.437626316062951e-27,  4.095347424597776e-06, -8.391612040089436e-08,  1.203745171384863e-09, -1.480082924552607e-11,
  1.668217318400348e-13, -1.777713133321268e-15,  1.821538858962776e-17, -1.813120763848571e-19,  1.764933018831889e-21, -1.687887070972384e-23,  1.591148189764366e-25,
 -1.482054469352804e-27,  7.970972732166048e-08, -1.633300030876934e-09,  2.342907436854823e-11, -2.880756968804732e-13,  3.246932037534641e-15, -3.460049039823008e-17,
  3.545349188883206e-19, -3.528964765143751e-21,  3.435175275851631e-23, -3.285220083386220e-25,  3.096945464125044e-27, -2.884660519872324e-29,  1.686071984951167e-05,
 -3.345196548868623e-07,  4.646216068848182e-09, -5.531449153888041e-11,  6.036612598183296e-13, -6.228594399546424e-15,  6.179515612836417e-17, -5.955665525865042e-19,
  5.613313542721996e-21, -5.197826049020342e-23,  4.744335075427982e-25, -4.278720731516581e-27,  2.150845255498601e-05, -4.267314913041972e-07,  5.926966272435539e-09,
 -7.056217809718397e-11,  7.700631812910265e-13, -7.945534255368880e-15,  7.882926684821375e-17, -7.597371339296501e-19,  7.160648595860173e-21, -6.630630554886022e-23,
  6.052134609046479e-25, -5.458178612423272e-27,  3.777878684194692e-06, -7.495377925266076e-08,  1.041049303074413e-09, -1.239398082509764e-11,  1.352586975134652e-13,
 -1.395603166906068e-15,  1.384606383849024e-17, -1.334449668465402e-19,  1.257740993136019e-21, -1.164645460900388e-23,  1.063035421611520e-25, -9.587115638946532e-28,
  7.353067970809518e-08, -1.458861651168548e-09,  2.026244600838259e-11, -2.412300421856613e-13,  2.632605437129173e-15, -2.716329931792827e-17,  2.694926364564880e-19,
 -2.597303944910709e-21,  2.448002252849144e-23, -2.266806448805761e-25,  2.069040179993827e-27, -1.865998318013640e-29  };
  int offset = -4;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 4;
    if (std::isnan(t)) {
      fill_n(rr+offset, 4, 0.5);
      fill_n(ww+offset, 4, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 4; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t*t*t*t*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=4; ++j) {
        const int boxof = it*48+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
