//
// BAGEL - Parallel electron correlation program.
// Filename: _r2root_11.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <iostream>
#include <cassert>
#include <src/integral/rys/r2rootlist.h>

using namespace std;
using namespace bagel;

void R2RootList::r2root11(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[11] = {6.654207944473094e-01,1.257969221074837e-01,1.647156829867703e+00,3.091149936010304e+00,5.029303588902189e+00,
    7.509916515199427e+00,1.060599146338118e+01,1.443166881837418e+01,1.917893057680273e+01,2.521780555566961e+01,3.349732065685939e+01};
  constexpr double aw[11] = {1.948611881259652e-01,1.424671499583614e-01,1.163913599026633e-01,3.828237278540672e-02,7.196668828134485e-03,
    7.594433187997459e-04,4.256577442916053e-05,1.146206307544775e-06,1.243181586873306e-08,3.856328149133933e-11,1.441893420266434e-14};
  constexpr double x[5797] = {  1.017973083189129e-02,  2.301229857440546e-04,  3.880791374334135e-06,  5.776687581848900e-08,  7.988188238501501e-10,
  1.048642861887981e-11,  1.320007959344018e-13,  1.600524723969812e-15,  1.870812480460042e-17,  2.103575160945323e-19,  2.262034690717785e-21,  2.299778560549371e-23,
  9.026167576680563e-02,  1.954701046995387e-03,  3.020126581230056e-05,  3.851878245452195e-07,  4.102355324572027e-09,  3.388460799153311e-11,  1.417517420525233e-13,
 -1.819869738720160e-15, -5.837892171029294e-17, -9.492496045507116e-19, -1.100542407285730e-20, -8.299348276401257e-23,  2.433797631647369e-01,  4.830936951385680e-03,
  6.168022409280889e-05,  5.205460018765858e-07,  1.253144917071695e-09, -4.789605536221736e-11, -9.803792054106119e-13, -9.177048899131088e-15,  4.133616960927100e-18,
  1.683680675125862e-18,  2.962647447571774e-20,  2.263776739373843e-22,  4.562874329748973e-01,  7.920617961611554e-03,  7.191445621997825e-05,  1.031327321057662e-07,
 -7.295322325328182e-09, -9.827581127316782e-11, -1.097181554582098e-14,  1.677869231752994e-14,  2.120164215669986e-16, -4.974783718256516e-19, -4.829797650521437e-20,
 -5.305849100084545e-22,  7.110378053735367e-01,  1.024668924429270e-02,  4.845484879430518e-05, -5.847645678349517e-07, -9.192014572496559e-09,  3.176807499891114e-11,
  1.716185583832440e-12,  5.134340376518694e-15, -2.930375807961304e-16, -2.940526306625112e-18,  4.074514054126014e-20,  8.970043106161961e-22,  9.868403693704024e-01,
  1.110957714834176e-02,  1.037510536444912e-06, -9.139196369590985e-07, -1.031371471760508e-10,  1.353984320989480e-10,  7.104481072740477e-15, -2.440014633498094e-14,
  8.244443757429387e-19,  4.874461286469991e-18, -6.823743778841022e-22, -1.037831394455205e-21,  1.261973556739664e+00,  1.028622388592945e-02, -4.583471148043593e-05,
 -5.912932425726166e-07,  8.752976583582332e-09,  3.373017370347992e-11, -1.625783650112763e-12,  4.376333732331695e-15,  2.738617556200383e-16, -2.656791765089057e-18,
 -3.735087862491957e-20,  8.039575210302770e-22,  1.515529793024637e+00,  8.064199060366119e-03, -6.922577746395662e-05,  5.919828042235424e-08,  7.174832669822145e-09,
 -8.772913759423625e-11, -8.337481060319905e-14,  1.550506551487593e-14, -1.740972432009690e-16, -6.820900102331487e-19,  4.158097252778545e-20, -3.959317141659792e-22,
  1.728871096652464e+00,  5.124664870825481e-03, -6.155565825986349e-05,  4.698752245010589e-07, -4.703063116827683e-10, -5.116508837594612e-11,  8.768964256199790e-13,
 -6.603458817246849e-15, -2.970543637667066e-17,  1.605648342225680e-18, -2.255327440354508e-20,  1.085663541690281e-22,  1.886759082766342e+00,  2.327964532227038e-03,
 -3.380552692279945e-05,  3.980657565280249e-07, -3.772828755602484e-09,  2.471659132440713e-11, -2.801171724012315e-15, -3.194188857398736e-15,  6.306325201607745e-17,
 -7.950404961519014e-19,  6.617342522645893e-21, -1.265583639661870e-23,  1.978196694811483e+00,  4.690305808500661e-04, -7.488004715593061e-06,  1.047364026275468e-07,
 -1.347721489915962e-09,  1.624893156063540e-11, -1.845593301819037e-13,  1.968909652318325e-15, -1.948396569520105e-17,  1.735978407682074e-19, -1.287977150597847e-21,
  5.735666542644163e-24,  1.116703498786561e-02,  2.641765441020875e-04,  4.658203876904781e-06,  7.241448484208171e-08,  1.044239330060660e-09,  1.426754687043966e-11,
  1.864721090335584e-13,  2.339989947236459e-15,  2.818392230073354e-17,  3.244850088290725e-19,  3.537738714458685e-21,  3.584344097741588e-23,  9.859461907944499e-02,
  2.215968632304873e-03,  3.524025099224286e-05,  4.564103326385529e-07,  4.808703834089940e-09,  3.642928738803852e-11,  5.885785634626362e-14, -4.326712154020948e-15,
 -1.013278813803912e-16, -1.458651340830600e-18, -1.426361114110288e-20, -5.431719355800299e-23,  2.637303302889026e-01,  5.349624269956387e-03,  6.801108917723730e-05,
  5.315682417660111e-07,  3.946540730044481e-11, -7.442906427914317e-11, -1.224638009550125e-12, -7.828659042716826e-15,  8.817214074147449e-17,  3.031116636232189e-18,
  3.639937001199114e-20,  3.908636303826660e-23,  4.891253767751384e-01,  8.498751030539537e-03,  7.238725858958223e-05, -2.915768740411098e-08, -9.221577776549343e-09,
 -9.216578668459927e-11,  5.482177793801350e-13,  2.286197005551965e-14,  1.543239778619729e-16, -2.822321524200688e-18, -6.531834876790846e-20, -1.685956934797886e-22,
  7.527519502681339e-01,  1.060382209569351e-02,  4.058354185810626e-05, -7.244873154584104e-07, -8.138968283570627e-09,  7.353731973102482e-11,  1.715423180137014e-12,
 -5.548870052200262e-15, -3.607055498394477e-16, -6.013784031486243e-19,  7.324437122006107e-20,  4.909247198926113e-22,  1.031226050652047e+00,  1.107418575669385e-02,
 -9.850663370994885e-06, -8.941269963727054e-07,  2.551892774575074e-09,  1.275332454034045e-10, -6.498959635446266e-13, -2.165870332511415e-14,  1.651522008971675e-16,
  3.979242454992296e-18, -4.200881626280531e-20, -7.571374325011511e-22,  1.302343570334560e+00,  9.893582699295750e-03, -5.207439595697907e-05, -4.479105515743272e-07,
  9.052028441559728e-09, -2.924856002998361e-12, -1.396585858863734e-12,  1.139108731264725e-14,  1.599125313662361e-16, -3.442361241887960e-18, -2.629124714405929e-21,
  7.112718776425016e-22,  1.546686055170760e+00,  7.515052544107822e-03, -6.788449193572359e-05,  1.599863176858926e-07,  5.432094609089558e-09, -8.516206007492376e-11,
  2.711616613371132e-13,  9.826150332338045e-15, -1.731721032846274e-16,  6.078417003166493e-19,  2.274001865736205e-20, -4.225979850970399e-22,  1.748420301959131e+00,
  4.654575032578618e-03, -5.599254496763049e-05,  4.552432097836560e-07, -1.298479912380081e-09, -3.239830645276545e-11,  6.862013799278147e-13, -6.792511607927753e-15,
  1.321905290883816e-17,  8.202709608889099e-19, -1.639178447551041e-20,  1.543225187076493e-22,  1.895558906032333e+00,  2.075638673793547e-03, -2.937470220139924e-05,
  3.416248712475361e-07, -3.285340795133209e-09,  2.377949531797219e-11, -6.793368860288365e-14, -1.584650142975469e-15,  3.899316912349099e-17, -5.496525102844164e-19,
  5.509947703175121e-21, -3.259573162943847e-23,  1.979960482201850e+00,  4.138105331525245e-04, -6.350556112402448e-06,  8.554956950578088e-08, -1.062912476681223e-09,
  1.241603903350062e-11, -1.372870713774454e-13,  1.435989774605505e-15, -1.409753597928209e-17,  1.274616504484487e-19, -1.015428315350682e-21,  6.247076600582949e-24,
  1.230420764155515e-02,  3.052254885062492e-04,  5.637694513694602e-06,  9.167253994761934e-08,  1.380226992636250e-09,  1.964287898869029e-11,  2.665883457272278e-13,
  3.459466937562314e-15,  4.283754289945638e-17,  5.025520265048184e-19,  5.500294351163359e-21,  5.432579665363146e-23,  1.080589447006624e-01,  2.521161941261535e-03,
  4.120297264650911e-05,  5.392065875456392e-07,  5.539488338561427e-09,  3.596915302149119e-11, -1.163839354382920e-13, -8.522620771415634e-15, -1.644369325892736e-16,
 -2.047732788169972e-18, -1.419721167069311e-20,  8.411419953166710e-23,  2.862572564936279e-01,  5.919115144332782e-03,  7.433921389044814e-05,  5.186267070774129e-07,
 -1.758672274357829e-09, -1.060211411646772e-10, -1.385945129428092e-12, -2.983730283045393e-15,  2.228387385379905e-16,  4.398130754325821e-18,  2.822702376452435e-20,
 -4.731079941830168e-22,  5.242726424754615e-01,  9.073806930208792e-03,  7.109419699679333e-05, -1.905082768158726e-07, -1.087905087525625e-08, -7.088095875877318e-11,
  1.238593816743701e-12,  2.566773120390933e-14,  5.736181671104241e-18, -5.376382314027417e-18, -5.656296716373245e-20,  6.257258090394481e-22,  7.957585541631448e-01,
  1.089162719200332e-02,  3.116393272372281e-05, -8.407842672785959e-07, -6.275854600907655e-09,  1.115397676441010e-10,  1.399417201075920e-12, -1.684308389991313e-14,
 -3.264096122089933e-16,  2.536781798364267e-18,  7.762705352531485e-20, -3.297734870010756e-22,  1.075298456791131e+00,  1.095334383881924e-02, -2.025431291403866e-05,
 -8.339327340394548e-07,  4.901061869180265e-09,  1.053749464446449e-10, -1.163456907257505e-12, -1.446129929021794e-14,  2.716651490607265e-16,  1.804347770583775e-18,
 -6.213855224322460e-20, -1.328847792152555e-22,  1.341054125508436e+00,  9.457934274798067e-03, -5.658783927368898e-05, -3.052498371948472e-07,  8.686690200860143e-09,
 -3.215107974948991e-11, -1.024440489437648e-12,  1.456111519429460e-14,  4.081784588048429e-17, -3.013780520958146e-18,  2.152649954052824e-20,  3.679805277077437e-22,
  1.575674191102830e+00,  6.981006752291648e-03, -6.549800745981798e-05,  2.337100893129623e-07,  3.813087519000132e-09, -7.595315878943413e-11,  4.730515251183364e-13,
  4.775643721593001e-15, -1.391307190722778e-16,  1.176318602769857e-18,  6.605367507280779e-21, -2.981630092963196e-22,  1.766176763248542e+00,  4.228089411980198e-03,
 -5.067293882817685e-05,  4.301151116289308e-07, -1.796815727178917e-09, -1.814086959817336e-11,  5.055464734561019e-13, -6.010459338926020e-15,  3.255318967292374e-17,
  2.964625954405531e-19, -9.972706326395291e-21,  1.312163461224396e-22,  1.903416214260794e+00,  1.856180941241109e-03, -2.557522454296897e-05,  2.927627833351600e-07,
 -2.828992532371852e-09,  2.174080993426880e-11, -9.752300494296029e-14, -6.138032568973034e-16,  2.281830942821992e-17, -3.587239549539741e-19,  4.039731445597390e-21,
 -3.235690032653506e-23,  1.981520232540700e+00,  3.668411250054658e-04, -5.418350932597592e-06,  7.036331892767665e-08, -8.445302095462949e-10,  9.556637909598373e-12,
 -1.027580651344662e-13,  1.050972802802674e-15, -1.017572133376550e-17,  9.211714196631217e-20, -7.587162297339590e-22,  5.314061286710869e-24,  1.362285225111385e-02,
  3.551350396072562e-04,  6.884454349144103e-06,  1.172826145917504e-07,  1.845789255244135e-09,  2.737663865182388e-11,  3.856961714545401e-13,  5.167264927405188e-15,
  6.552514855286261e-17,  7.769442996038141e-19,  8.386715177600230e-21,  7.716156766128514e-23,  1.188460171858574e-01,  2.878227617165853e-03,  4.822824119253674e-05,
  6.333489590141651e-07,  6.208234459184016e-09,  2.964596550755272e-11, -4.404834822422791e-13, -1.506159473430979e-14, -2.467214712174331e-16, -2.453563120508810e-18,
 -3.368561843072496e-21,  4.612718350689188e-22,  3.111616574415658e-01,  6.538071609252468e-03,  8.031803516247196e-05,  4.717053280260557e-07, -4.213679381225541e-09,
 -1.393277358778328e-10, -1.344603072622142e-12,  6.844132158595764e-15,  3.943981651968535e-16,  4.878071529001080e-18, -1.051065950113610e-20, -1.329758015491124e-21,
  5.616865938076928e-01,  9.630360967646526e-03,  6.772282246178333e-05, -3.740566188971977e-07, -1.194189648864655e-08, -3.270241563131591e-11,  1.928044371525879e-12,
  2.238847200251506e-14, -2.193526950355032e-16, -6.809158354836428e-18, -8.389769302227893e-21,  1.531585199189005e-21,  8.397576137143899e-01,  1.109905449488612e-02,
  2.055108038796432e-05, -9.217070355434092e-07, -3.753066158141379e-09,  1.383910293137995e-10,  7.993412072125974e-13, -2.527136981682500e-14, -1.849935643527508e-16,
  5.102429806720027e-18,  4.501994900870374e-20, -1.094396192448865e-21,  1.118726464269283e+00,  1.075276335664687e-02, -2.972670304681970e-05, -7.402922991997081e-07,
  6.701801727609424e-09,  7.361812188288592e-11, -1.440332636954240e-12, -5.208548982764179e-15,  2.921781843884687e-16, -6.135494323100491e-19, -5.456963029217812e-20,
  4.371811792557845e-22,  1.377960519364041e+00,  8.992885494190351e-03, -5.944207952775162e-05, -1.726027800088474e-07,  7.831188699036346e-09, -5.179116557728162e-11,
 -6.134174352676369e-13,  1.432266807621900e-14, -4.926556539743241e-17, -1.936390937249791e-18,  2.983565471716427e-20,  2.596647490404017e-23,  1.602569329256864e+00,
  6.469166686334289e-03, -6.237545734552775e-05,  2.832207705466348e-07,  2.415958576732837e-09, -6.345803589242306e-11,  5.510334294975160e-13,  1.029051830686344e-15,
 -9.477901004370609e-17,  1.223056109093832e-18, -3.181538004911243e-21, -1.498802213145311e-22,  1.782310321351632e+00,  3.842839126588032e-03, -4.569404036492405e-05,
  3.990677530663802e-07, -2.051292647161503e-09, -7.902180587742988e-12,  3.529549463135799e-13, -4.864398350986670e-15,  3.732869894061454e-17,  1.049572787759834e-21,
 -5.103105147072353e-21,  8.966543836915915e-23,  1.910452940570507e+00,  1.664894468864171e-03, -2.231973013381788e-05,  2.508457610651479e-07, -2.418594324277164e-09,
  1.926564620056383e-11, -1.062215999593081e-13, -6.173924284641565e-17,  1.248543723626248e-17, -2.238362419720034e-19,  2.754053085032902e-21, -2.565898005524131e-23,
  1.982905944850825e+00,  3.266557472743424e-04, -4.649166848666232e-06,  5.825528166597869e-08, -6.758536689759857e-10,  7.409641506943039e-12, -7.743022658101576e-14,
  7.729880783715841e-16, -7.352656174849586e-18,  6.608988168381517e-20, -5.514647591105275e-22,  4.109255266932706e-24,  1.516322523965092e-02,  4.163874374497101e-04,
  8.488884698287376e-06,  1.517522628887446e-07,  2.498951651413033e-09,  3.863481730808144e-11,  5.644416178099196e-13,  7.783352420030147e-15,  1.004080647054534e-16,
  1.186301375130177e-18,  1.220072477713302e-20,  9.297301425743802e-23,  1.311811517564186e-01,  3.296183485906413e-03,  5.644169224062268e-05,  7.366891920387242e-07,
  6.656321328201640e-09,  1.304015871535072e-11, -9.859198020497772e-13, -2.434514207132538e-14, -3.308572270158292e-16, -1.986216589013591e-18,  3.243409824266574e-20,
  1.244992066678955e-21,  3.386329709574897e-01,  7.201888890628227e-03,  8.547659419609789e-05,  3.803334969721836e-07, -7.299377847881633e-09, -1.677162132365041e-10,
 -9.511992429869647e-13,  2.206264770139514e-14,  5.458634220163828e-16,  3.019296954352398e-18, -8.845858130577596e-20, -2.141188891173420e-21,  6.012585450963107e-01,
  1.015090825064336e-02,  6.207482312894658e-05, -5.676492074579922e-07, -1.208749481293480e-08,  2.007465492571659e-11,  2.420156987897071e-12,  1.152501992163294e-14,
 -4.526988998308805e-16, -5.635320755152886e-18,  6.944536437926005e-20,  1.845522858271105e-21,  8.844114424289212e-01,  1.121841625724151e-02,  9.224334729650878e-06,
 -9.588215306878725e-07, -8.534187657018115e-10,  1.485947748531635e-10,  3.837411948848810e-14, -2.800633765471381e-14,  1.841488867573900e-17,  5.830676268039317e-18,
 -1.001938705857489e-20, -1.286035959706944e-21,  1.161208333673869e+00,  1.048133811871178e-02, -3.792442425669711e-05, -6.231937442941626e-07,  7.821993470474432e-09,
  3.832216537369771e-11, -1.461350310473751e-12,  3.410460682277976e-15,  2.363720652049109e-16, -2.314311053836048e-18, -2.875880676922632e-20,  6.720404110411959e-22,
  1.412970767904489e+00,  8.511110749720146e-03, -6.079792880870870e-05, -5.625784105676547e-08,  6.679464926952124e-09, -6.193511838990177e-11, -2.433006761225635e-13,
  1.185889414552876e-14, -9.788650295502790e-17, -7.911236051879329e-19,  2.596932049704972e-20, -1.742065661183298e-22,  1.627470319933636e+00,  5.984323002802154e-03,
 -5.878441777415530e-05,  3.124455104013709e-07,  1.279777077638326e-09, -5.019066526541795e-11,  5.437662499464930e-13, -1.334634863638058e-15, -5.429503874673341e-17,
  9.998876339902599e-19, -7.175397155659519e-21, -3.993234572091775e-23,  1.796980102327134e+00,  3.495874863050914e-03, -4.110599669072901e-05,  3.653990824968542e-07,
 -2.134966332686544e-09, -9.319147587431217e-13,  2.332410736214999e-13, -3.701658722666530e-15,  3.453666874157181e-17, -1.357218503606526e-19, -2.003793777712371e-21,
  5.292706567969503e-23,  1.916773575776207e+00,  1.497747750612620e-03, -1.952949925418446e-05,  2.150923784892733e-07, -2.058710277422042e-09,  1.673399300105957e-11,
 -1.034287741760099e-13,  2.280518057789024e-16,  6.158489278676861e-18, -1.340263539290403e-19,  1.790795351078185e-21, -1.821736612597864e-23,  1.984142363108872e+00,
  2.920854751584425e-04, -4.010403108742718e-06,  4.853310382696705e-08, -5.446195609148190e-10,  5.786507449089947e-12, -5.875127478846871e-14,  5.718472183868244e-16,
 -5.329922322230329e-18,  4.731879729214213e-20, -3.947927059151563e-22,  3.054052821874668e-24,  1.697717384420682e-02,  4.923262416403815e-04,  1.057791375016071e-05,
  1.987342616000203e-07,  3.426823406999376e-09,  5.520272324645458e-11,  8.344959206485600e-13,  1.178178193359315e-14,  1.528598474358176e-16,  1.752299667187921e-18,
  1.585779368573705e-20,  5.790101100687979e-23,  1.453275112825985e-01,  3.784898852103138e-03,  6.592472466616634e-05,  8.437370943889420e-07,  6.618867721542369e-09,
 -2.005237327870825e-11, -1.824056362934809e-12, -3.569958596551552e-14, -3.628042911316685e-16,  7.420931641118095e-19,  1.129428799559476e-19,  2.467181473981204e-21,
  3.688339096046115e-01,  7.901710424704620e-03,  8.922580695359436e-05,  2.357150511482732e-07, -1.082142851043028e-08, -1.810867573755129e-10, -7.852142925095339e-14,
  4.039713795804071e-14,  5.675090696200731e-16, -2.454177216576493e-18, -1.836652273100564e-19, -1.907569961415081e-21,  6.428076589015662e-01,  1.061702330959615e-02,
  5.412632924352417e-05, -7.546032096630871e-07, -1.108819867626351e-08,  8.022938751818223e-11,  2.514256158593977e-12, -5.520168571699051e-15, -5.872964377322672e-16,
 -1.393629387895081e-18,  1.364395610280296e-19,  9.989352972611340e-22,  9.293597952596352e-01,  1.124618025052974e-02, -2.265937487462293e-06, -9.489140138639661e-07,
  2.065316678255586e-09,  1.403607499255585e-10, -7.071650418053412e-13, -2.424121422019258e-14,  2.083467008981995e-16,  4.403919610578458e-18, -5.757002392634287e-20,
 -7.776727691170312e-22,  1.202482597750231e+00,  1.015020309630051e-02, -4.463259448635344e-05, -4.937691105764256e-07,  8.249513976683840e-09,  5.166904431534190e-12,
 -1.273736313799183e-12,  9.476895454271937e-15,  1.394135624664512e-16, -2.884410651037987e-18, -5.311639155872186e-22,  5.676327472293344e-22,  1.446040607298062e+00,
  8.023748088387328e-03, -6.087340660429251e-05,  4.049297351633144e-08,  5.407350209913935e-09, -6.416325442471589e-11,  4.194804275993161e-14,  8.454732806191248e-15,
 -1.097470423049889e-16,  7.103148084959913e-20,  1.681206063050997e-20, -2.199300023951945e-22,  1.650491203682303e+00,  5.529321385442863e-03, -5.494308435049570e-05,
  3.255846764533693e-07,  4.025597824343784e-10, -3.775382336302983e-11,  4.870755447819041e-13, -2.553626472210417e-15, -2.368796122858199e-17,  6.991593687064886e-19,
 -7.408817161038022e-21,  2.245518984673517e-23,  1.810332856754363e+00,  3.183985728105302e-03, -3.692588533654000e-05,  3.313616057816204e-07, -2.105397547570586e-09,
  3.542033825669674e-12,  1.442461076895422e-13, -2.686082356265627e-15,  2.869316544009313e-17, -1.774571860428661e-19, -2.606160034571274e-22,  2.855075030884814e-23,
  1.922467683712602e+00,  1.351300793193456e-03, -1.713541256552109e-05,  1.846981009738998e-07, -1.748238248858545e-09,  1.434659638332777e-11, -9.491958651079106e-14,
  3.603031249432253e-16,  2.448185577634641e-18, -7.641177991705955e-20,  1.138291657846240e-21, -1.156739262104891e-23,  1.985250028942269e+00,  2.621920261885581e-04,
 -3.476704329026386e-06,  4.067353676163565e-08, -4.417860713516888e-10,  4.550815792718708e-12, -4.489155027964604e-14,  4.257453094320925e-16, -3.880572360324937e-18,
  3.397163417076450e-20, -2.778873698740706e-22,  2.325631795038575e-24,  1.913226539703590e-02,  5.875124701257558e-04,  1.333199076857315e-05,  2.636069517048282e-07,
  4.760998193201071e-09,  7.980479505673620e-11,  1.243241476427393e-12,  1.780776879304858e-14,  2.276106140302365e-16,  2.394038338106282e-18,  1.466002690900292e-20,
 -1.628333403200475e-22,  1.615885061299145e-01,  4.354548647964379e-03,  7.666305767551543e-05,  9.436892327282547e-07,  5.692536436392648e-09, -7.707514852461509e-11,
 -2.974606596500022e-12, -4.577498006064227e-14, -2.252041871000243e-16,  7.796716202949368e-18,  2.475966115130881e-19,  3.506426241480263e-21,  4.018817618945074e-01,
  8.623613911166337e-03,  9.089681784137769e-05,  3.391585026087849e-08, -1.436032521383048e-08, -1.674816228342587e-10,  1.282634703915378e-12,  5.558994108721867e-14,
  3.311843346846886e-16, -1.095128465829194e-17, -2.236986204801862e-19,  4.918173681917689e-22,  6.860803528036515e-01,  1.101093983191438e-02,  4.406995917903226e-05,
 -9.159900659904895e-07, -8.903738744440321e-09,  1.365860251627197e-10,  2.096914142292807e-12, -2.400456133499775e-14, -5.328673906062477e-16,  4.470509835807082e-18,
  1.442072734201684e-19, -7.043019974481720e-22,  9.742372092901325e-01,  1.118327291666188e-02, -1.336557839887018e-05, -8.945488837229034e-07,  4.652285771293290e-09,
  1.161263307054345e-10, -1.272231673762608e-12, -1.553444134529338e-14,  3.193963347522762e-16,  1.661361044044153e-18, -7.326685383884354e-20,  7.716005103520746e-23,
  1.242334927330778e+00,  9.771682834006954e-03, -4.976757489778351e-05, -3.625130657753802e-07,  8.070850299620973e-09, -2.180937107512473e-11, -9.613031083298315e-13,
  1.231727073570165e-14,  4.056715463175277e-17, -2.477946949865715e-18,  1.896920680611511e-20,  3.119788978935863e-22,  1.477166651351919e+00,  7.540078495617487e-03,
 -5.991035297303271e-05,  1.168725779305431e-07,  4.151302476140165e-09, -6.070601248694242e-11,  2.307166877140471e-13,  5.095178896310483e-15, -9.732267667204690e-17,
  5.615249179621945e-19,  8.137063335734457e-21, -1.627014946684104e-22,  1.671754228278774e+00,  5.105460886083294e-03, -5.102035213455242e-05,  3.265945944071029e-07,
 -2.417614247278212e-10, -2.698641189094790e-11,  4.083524227923359e-13, -2.963514309285277e-15, -3.513942205714579e-18,  4.332598419806276e-19, -5.663603957265699e-21,
  5.327225889380423e-23,  1.822502369002330e+00,  2.903917820664763e-03, -3.314878273619481e-05,  2.984062866603831e-07, -2.005518752193408e-09,  6.199252106071171e-12,
  8.092849079752393e-14, -1.869938486495696e-15,  2.238024964647200e-17, -1.669175899368523e-19,  7.077684486132459e-22,  1.753044559325955e-23,  1.927612113775522e+00,
  1.222628500952171e-03, -1.507778872199515e-05,  1.589015289789804e-07, -1.483233817996730e-09,  1.219619060891228e-11, -8.409042229624381e-14,  4.025347001244792e-16,
  4.111038465068530e-19, -3.921297524578246e-20,  7.670733927352367e-22, -5.330604931621173e-24,  1.986246099984825e+00,  2.362171115734688e-04, -3.028208937327119e-06,
  3.427836596328455e-08, -3.606461258378753e-10,  3.603495002539004e-12, -3.453949771537949e-14,  3.191818596320933e-16, -2.834136742070248e-18,  2.478581946162403e-20,
 -1.834500945853634e-22,  2.042995794838960e-24,  2.171766378019998e-02,  7.082492629579226e-04,  1.701075379252167e-05,  3.543582701013201e-07,  6.700464754622309e-09,
  1.165322179408682e-10,  1.857468056999028e-12,  2.656048523170685e-14,  3.212052391633609e-16,  2.671028201137255e-18, -6.310847065050368e-21, -9.310079030779109e-22,
  1.803070270639716e-01,  5.014553998112097e-03,  8.846916037753257e-05,  1.018112528031125e-06,  3.330475202394276e-09, -1.643252604078638e-10, -4.299625379891597e-12,
 -4.627838528130688e-14,  2.705112835268078e-16,  2.069285087538450e-17,  3.884102790447615e-19,  2.233179882364535e-21,  4.378273112061128e-01,  9.348269397545102e-03,
  8.982158329927439e-05, -2.204283502736533e-07, -1.727162188157565e-08, -1.172463349922245e-10,  2.916522910056271e-12,  5.826396122482965e-14, -2.083447441473565e-16,
 -1.828838949120632e-17, -1.121247226519716e-19,  4.696999399998034e-21,  7.307564917523482e-01,  1.131733427348348e-02,  3.232162066741350e-05, -1.034122655844050e-06,
 -5.732389867079927e-09,  1.771060415223968e-10,  1.217696677838722e-12, -3.745800460187788e-14, -2.799723399657565e-16,  9.146791564262937e-18,  7.951025476262957e-20,
 -2.073365791019855e-21,  1.018690470812251e+00,  1.103484045048894e-02, -2.358262901015838e-05, -8.033176855321544e-07,  6.640375716326324e-09,  8.156360575742169e-11,
 -1.559039273844398e-12, -4.901656734351637e-15,  3.293948010702859e-16, -9.730893657045481e-19, -5.347191536704655e-20,  7.552797875694219e-22,  1.280600872435437e+00,
  9.358296173929387e-03, -5.336106022859593e-05, -2.380035995350260e-07,  7.432315013734556e-09, -4.067195999992084e-11, -6.104783005894097e-13,  1.235700712621425e-14,
 -3.233751960311721e-17, -1.516609990378588e-18,  2.745013417710871e-20,  8.604960976281003e-23,  1.506378757174323e+00,  7.067444607335696e-03, -5.814833056512654e-05,
  1.739237434983646e-07,  3.002377742018194e-09, -5.378814331940785e-11,  3.331947792225694e-13,  2.354722481387412e-15, -7.272737977762331e-17,  7.711173850853005e-19,
  3.028685379200698e-21, -6.984757056560296e-23,  1.691384424647721e+00,  4.712871150247521e-03, -4.714058951329427e-05,  3.189128061715854e-07, -6.902161520693598e-10,
 -1.818143252834510e-11,  3.258610272851198e-13, -2.865217687429009e-15,  8.618325208199090e-18,  2.586066315837440e-19, -2.976842527059035e-21,  6.569585447947258e-23,
  1.833609581705759e+00,  2.652515585215852e-03, -2.975604903482769e-05,  2.673989829675557e-07, -1.865956384126197e-09,  7.588842601250809e-12,  3.774056526274315e-14,
 -1.243008147207433e-15,  1.705720655397595e-17, -1.241443190790005e-19,  1.415221933322486e-21,  1.510913937792188e-23,  1.932272913681214e+00,  1.109247869846501e-03,
 -1.330565603021050e-05,  1.370153686498304e-07, -1.258575870721734e-09,  1.031365662312291e-11, -7.280741398989770e-14,  3.986717646169486e-16, -4.888816363927917e-19,
 -1.149567230109515e-20,  6.580837443785638e-22, -1.820322103589352e-26,  1.987144990626165e+00,  2.135439049608732e-04, -2.649250281169455e-06,  2.904241197504481e-08,
 -2.961914368683606e-10,  2.872322109938829e-12, -2.674703898259436e-14,  2.415253193421298e-16, -2.052315298950281e-18,  1.924175049966470e-20, -9.379074121747572e-23,
  2.020665626988860e-24,  2.485259208927130e-02,  8.633612261925717e-04,  2.199179846715071e-05,  4.829078534528737e-07,  9.543506226673583e-09,  1.712818960428297e-10,
  2.758575895480684e-12,  3.822165635976344e-14,  3.986829721152765e-16,  1.105309198582978e-18, -8.767113030032717e-20, -3.114250699442234e-21,  2.018590273413222e-01,
  5.771794289033461e-03,  1.008784800314106e-04,  1.039088302096498e-06, -1.084521715661254e-09, -2.812888273926954e-10, -5.340153259969794e-12, -2.259696246879198e-14,
  1.305285323131213e-15,  3.660519970902697e-17,  3.540331874621445e-19, -5.112986962877008e-21,  4.766339486948691e-01,  1.005141278729713e-02,  8.545476969061184e-05,
 -5.111974559725742e-07, -1.879099215888314e-08, -2.905446175311362e-11,  4.352108574961611e-12,  4.066959203639163e-14, -8.875293877001458e-16, -1.757349675009154e-17,
  1.679318299950651e-19,  7.366272295246698e-21,  7.764625459029839e-01,  1.152498782852074e-02,  1.948286357455059e-05, -1.096286789064052e-06, -1.986852480202614e-09,
  1.930540832401782e-10,  9.624002384945550e-14, -4.072285165074767e-14,  8.322032588560697e-17,  1.037355499743421e-17, -1.893439916875265e-20, -2.186873716236609e-21,
  1.062394154944545e+00,  1.080953697371108e-02, -3.253779565741372e-05, -6.860802649049804e-07,  7.892331603364921e-09,  4.364539706083496e-11, -1.556519452950783e-12,
  4.736601614836344e-15,  2.647200479909686e-16, -2.363568513102763e-18, -1.518298427074298e-20,  8.717772012107567e-22,  1.317164958580854e+00,  8.921938689138346e-03,
 -5.553270822731432e-05, -1.262751722935010e-07,  6.499596322629488e-09, -5.133116511583188e-11, -2.856391565504431e-13,  1.066477529041098e-14, -6.674150327388753e-17,
 -3.956659289778249e-19,  2.729875049094425e-20, -9.505916005080364e-23,  1.533732429310792e+00,  6.611344107338111e-03, -5.580705954686518e-05,  2.138081917277519e-07,
  2.010674489396333e-09, -4.523690182168145e-11,  3.708567904209448e-13,  4.902693566397280e-16, -4.333776571722222e-17,  8.503848521023736e-19,  1.251823444321552e-21,
 -2.813884080045220e-23,  1.709505599026778e+00,  4.350841502177940e-03, -4.339059285243070e-05,  3.053586283176842e-07, -9.819414510490334e-10, -1.128439769833176e-11,
  2.507640494817161e-13, -2.457892934586618e-15,  1.646384585246291e-17,  1.947590743629416e-19, -3.678687460263693e-22,  4.396158937325082e-23,  1.843763168601857e+00,
  2.426806604348047e-03, -2.672125476887017e-05,  2.387963367674619e-07, -1.707638174883552e-09,  8.134936265523249e-12,  9.991158301876301e-15, -7.565383625504982e-16,
  1.375376739687582e-17, -5.595596695450380e-20,  1.917332584550557e-21,  4.055566318517120e-24,  1.936506964453374e+00,  1.009052105298943e-03, -1.177578512853818e-05,
  1.184371593525565e-07, -1.068882424960867e-09,  8.698264680542745e-12, -6.188940498586647e-14,  3.815267918952143e-16, -4.234449006645209e-19,  1.530342419816840e-20,
  6.763712545168921e-22, -9.507386608320197e-25,  1.987958877211303e+00,  1.936675246451687e-04, -2.327386983721067e-06,  2.473021616589119e-08, -2.446522228525346e-10,
  2.304742890796385e-12, -2.080381289520475e-14,  1.863783618920037e-16, -1.406731194386529e-18,  1.713661222049178e-20, -1.751506833703088e-23,  1.155703649924298e-24,
  2.869864649006523e-02,  1.065356656317021e-03,  2.882862467490312e-05,  6.669962187937937e-07,  1.372538255345321e-08,  2.517765064421485e-10,  4.006656652503661e-12,
  5.060076360497220e-14,  3.312668650638894e-16, -6.414037186810471e-18, -3.273873648273198e-19, -8.530524855651640e-21,  2.266381929140759e-01,  6.627929910781692e-03,
  1.130348705203925e-04,  9.696524157083553e-07, -8.013315911112189e-09, -4.110248452320772e-10, -5.174164832070310e-12,  4.232126161579379e-14,  2.788349411617766e-15,
  4.227509349815912e-17, -1.815333485812401e-19, -2.020756947849790e-20,  5.181607996683436e-01,  1.070539668876997e-02,  7.751657605033152e-05, -8.105043675992478e-07,
 -1.825418471545842e-08,  8.532905947340726e-11,  5.010976455951840e-12,  4.058762973478546e-15, -1.324505374712688e-15, -4.848521243984295e-18,  4.429102648809195e-19,
  3.866316321639896e-21,  8.227905278914147e-01,  1.162798091728580e-02,  6.263469703626942e-06, -1.097440213895783e-06,  1.807953362717587e-09,  1.823172557633865e-10,
 -9.526575789168417e-13, -3.240864497684040e-14,  4.214592314089477e-16,  7.873934645933972e-18, -1.010755713067785e-19, -1.528596929910379e-21,  1.105062657870269e+00,
  1.051850291433254e-02, -3.999070136654080e-05, -5.547881170296466e-07,  8.407021348816756e-09,  8.756589232045233e-12, -1.318523621274547e-12,  1.179748264515489e-14,
  1.768831655136062e-16, -2.330868344887777e-18,  1.233387190306688e-20,  2.582169014373017e-22,  1.351956983614847e+00,  8.473303748004367e-03, -5.645886741920146e-05,
 -3.077000094279935e-08,  5.427330796617682e-09, -5.485037917657634e-11, -1.763127062965997e-14,  8.499696236670027e-15, -6.296265876197417e-17,  5.416239310267622e-19,
  1.748173219543755e-20, -3.831402151734871e-22,  1.559301827628111e+00,  6.175631722424374e-03, -5.307661958902874e-05,  2.392268895972367e-07,  1.195365179752540e-09,
 -3.629975922258341e-11,  3.698221356285630e-13, -4.003649638279539e-16, -1.227183601859145e-17,  8.564646626874125e-19, -1.767763543298291e-21, -1.413101976344871e-22,
  1.726237525666174e+00,  4.018091746098891e-03, -3.982700534317932e-05,  2.881468122966951e-07, -1.152685495301465e-09, -6.025929839636190e-12,  1.903687948765431e-13,
 -1.819131183225281e-15,  2.348523286987514e-17,  1.963922641593486e-19, -2.756351900114097e-22, -5.589032108543541e-23,  1.853060364101168e+00,  2.224046730336743e-03,
 -2.401423829850876e-05,  2.127824181248411e-07, -1.544006341983308e-09,  8.168927408832474e-12, -5.228205902611428e-15, -3.340628095338327e-16,  1.307309258175893e-17,
  1.380125561805065e-20,  1.226474746108679e-21, -4.336325166606226e-23,  1.940363367878498e+00,  9.202527868840323e-04, -1.045166261944129e-05,  1.026496720210506e-07,
 -9.089103746594451e-10,  7.340271318781345e-12, -5.127765285628802e-14,  3.817469098846608e-16,  5.747766957273615e-19,  3.799682688901291e-20,  3.358130525715559e-22,
 -1.782493293051051e-23,  1.988698099075134e+00,  1.761722691686016e-04, -2.052673104489130e-06,  2.115910136376001e-08, -2.031514559313522e-10,  1.863554666489524e-12,
 -1.612328688216477e-14,  1.511543501303705e-16, -7.970724727396564e-19,  1.664690034832743e-20, -3.312039036079944e-23, -2.446200856839859e-24,  3.347784369425773e-02,
  1.332153887414611e-03,  3.833467268360988e-05,  9.326107486702851e-07,  1.984216216922223e-08,  3.658112062768158e-10,  5.514125283752385e-12,  5.408472047172568e-14,
 -2.508217271293975e-16, -2.986468284672878e-17, -9.288519971182147e-19, -2.005689045034030e-20,  2.550282114289439e-01,  7.575906772747461e-03,  1.236098642489945e-04,
  7.695297120215146e-07, -1.732188875729578e-08, -5.095945348650498e-10, -2.532695500568816e-12,  1.524689897520637e-13,  3.921905758629272e-15,  1.259702228329926e-17,
 -1.397420193064176e-18, -3.277624678211044e-20,  5.621542679914628e-01,  1.128183194095661e-02,  6.611550160542240e-05, -1.082432705350803e-06, -1.536073663498715e-08,
  2.021333556699434e-10,  4.530588267507600e-12, -3.751474728929495e-14, -1.162214384144305e-15,  1.366681243196007e-17,  4.103209624499840e-19, -5.952366187920644e-21,
  8.693203093480820e-01,  1.162617094962258e-02, -6.616714266155893e-06, -1.040862520820319e-06,  5.161033913831899e-09,  1.503190891903632e-10, -1.634955774642854e-12,
 -1.529026889745175e-14,  6.171097098487285e-16,  2.602781208380474e-18, -1.610964803367021e-19, -1.338318373104945e-21,  1.146457886913527e+00,  1.017423692406408e-02,
 -4.584054233414474e-05, -4.204712140212484e-07,  8.295453922164268e-09, -1.835833166333029e-11, -9.208481789373026e-13,  1.621398994466823e-14,  1.017225097592838e-16,
 -1.930912814906579e-18, -8.966710179958491e-22, -9.033330910229462e-22,  1.384946492665898e+00,  8.021548946654194e-03, -5.634314757985487e-05,  4.734533169863771e-08,
  4.344283371545082e-09, -5.262341651646936e-11,  1.958187172093347e-13,  6.891313602961354e-15, -3.610105237365950e-17,  7.739947105412710e-19, -9.321767450462046e-21,
 -8.522854907579755e-22,  1.583173700044771e+00,  5.762774732320949e-03, -5.011354912398671e-05,  2.530227664036563e-07,  5.571078692950890e-10, -2.757530220833480e-11,
  3.575608651635718e-13, -3.298230858074570e-16,  1.512694750133516e-17,  5.866325504799807e-19, -1.380018339098124e-20, -4.223564682572730e-22,  1.741694106950118e+00,
  3.712985593790990e-03, -3.648311786166458e-05,  2.689722278593583e-07, -1.231175569760736e-09, -1.977099121904561e-12,  1.509602750832205e-13, -9.643117456256840e-16,
  2.931836438057834e-17,  8.628205309200839e-20, -6.568509900004640e-21, -2.374218450011011e-22,  1.861587918074707e+00,  2.041738770463208e-03, -2.160371110613034e-05,
  1.893762059670656e-07, -1.382393097839816e-09,  7.979157526307089e-12, -8.611431350883466e-15,  9.656555209748610e-17,  1.377775809870449e-17,  5.745430994694085e-22,
 -2.536861426093471e-21, -1.313448972342282e-22,  1.943884618962529e+00,  8.413301876045474e-04, -9.302483912396474e-06,  8.921837173409048e-08, -7.735294906223429e-10,
  6.241262055131422e-12, -4.011857295636523e-14,  4.225556133092369e-16,  1.913782614875452e-18,  2.658427199276769e-20, -1.154526809790310e-21, -5.143630048757063e-23,
  1.989371479034665e+00,  1.607139669665217e-04, -1.817100764383346e-06,  1.818721613251658e-08, -1.694197348459610e-10,  1.525038921859172e-12, -1.216151096638647e-14,
  1.346660246728798e-16, -2.636665620318889e-19,  1.136803738468208e-20, -2.791266855598343e-22, -8.995299228680958e-24,  3.949910672271098e-02,  1.689598838648836e-03,
  5.169691031893199e-05,  1.316288511479914e-06,  2.859445066333495e-08,  5.141178222268573e-10,  6.691945608777017e-12,  1.966521276244102e-14, -2.252682726919286e-15,
 -8.972158728357025e-17, -2.197779554514514e-18, -3.818616358473214e-20,  2.873603907704536e-01,  8.596223766541154e-03,  1.308388722237222e-04,  4.092494081078851e-07,
 -2.770238440959954e-08, -5.050039799067339e-10,  3.468575478054078e-12,  2.716727995476296e-13,  3.033531840061282e-15, -7.026004097334948e-17, -2.621777802759557e-18,
 -1.542687503510618e-20,  6.082517312980830e-01,  1.175496463255178e-02,  5.180308051703394e-05, -1.290381206179766e-06, -1.033524043007451e-08,  2.946117397199783e-10,
  3.052187943999775e-12, -6.435884609423819e-14, -4.649512967997683e-16,  2.195222225873418e-17, -5.573320982299616e-20, -1.395548839078620e-20,  9.156422851106987e-01,
  1.152489371221464e-02, -1.851960030572535e-05, -9.364716738341490e-07,  7.752076561352209e-09,  1.082132681067150e-10, -1.782088275633801e-12,  4.592987719094883e-15,
  5.799264148029186e-16, -5.094702451188312e-18, -2.252274271282113e-19, -1.498091200334014e-21,  1.186392569920047e+00,  9.789551414795278e-03, -5.010540363209632e-05,
 -2.917219382850601e-07,  7.745677282113118e-09, -3.470973684377399e-11, -4.323337535358700e-13,  1.825228517055324e-14,  1.900689277133353e-17, -3.078161221160516e-18,
 -6.276899795094336e-20, -1.744136348804824e-21,  1.416136361560695e+00,  7.574179975595319e-03, -5.539168246974002e-05,  1.087530123989977e-07,  3.353859974973162e-09,
 -4.571761807858912e-11,  3.758142460509300e-13,  6.028792536244189e-15, -2.514166691904339e-17, -4.700662533654006e-19, -5.506103099328896e-20, -1.137905434823920e-21,
  1.605442374389330e+00,  5.374124069393726e-03, -4.704048868913663e-05,  2.579887522516356e-07,  9.101684375906576e-11, -1.903525298586274e-11,  3.572824527896284e-13,
  3.442369877794532e-16,  2.108501684487216e-17, -4.157436909280052e-19, -3.779575425879842e-20, -6.166477259223806e-22,  1.755982286160053e+00,  3.433694674055128e-03,
 -3.337433166745476e-05,  2.491466767263918e-07, -1.236122467886876e-09,  1.428446844344939e-12,  1.370658852264674e-13, -5.065030357973665e-17,  2.471930361261458e-17,
 -4.337327226564517e-19, -2.034220609144375e-20, -3.575920262468702e-22,  1.869423091439762e+00,  1.877635192118975e-03, -1.945867185094646e-05,  1.685251588920562e-07,
 -1.224403654871249e-09,  7.853760369901478e-12,  5.540804417220300e-17,  5.054046296767460e-16,  1.035757871590025e-17, -2.398146357324002e-19, -9.915829281521628e-21,
 -1.884252171181939e-22,  1.947107595635605e+00,  7.709915654654371e-04, -8.302161202727036e-06,  7.779234168104456e-08, -6.573363791419484e-10,  5.427760385274248e-12,
 -2.737781805931317e-14,  4.851948998737866e-16,  1.408792019414053e-18, -7.384594245140800e-20, -4.033496489433227e-21, -7.335768749227578e-23,  1.989986581395633e+00,
  1.470062863940192e-04, -1.614159839502428e-06,  1.570591678009068e-08, -1.415359677020973e-10,  1.277736867869512e-12, -8.467859925166196e-15,  1.297370244590942e-16,
 -1.672118761072218e-19, -9.444897066168457e-21, -7.938365394829822e-22, -1.325836264541045e-23,  4.719677279378225e-02,  2.174971994829024e-03,  7.060508628563920e-05,
  1.864780675340261e-06,  4.047022490723678e-08,  6.695085640515238e-10,  5.606417039267965e-12, -1.246254029001238e-13, -7.509205558184669e-15, -2.151329335008640e-16,
 -4.107276371887622e-18, -4.142761394155667e-20,  3.238582144828447e-01,  9.654318962663909e-03,  1.327792467131797e-04, -1.075198755638623e-07, -3.630977498097241e-08,
 -3.225847745065098e-10,  1.190644085415895e-11,  3.075889410286579e-13, -1.409430711605124e-15, -1.729904508883804e-16, -2.055652839286694e-18,  4.670688241217957e-20,
  6.559990205690618e-01,  1.210511032804421e-02,  3.553193188615901e-05, -1.405261104023067e-06, -3.862189875574449e-09,  3.452431055739118e-10,  1.150534585677489e-12,
 -6.823670643382693e-14,  1.365370653756530e-16,  7.578161494366018e-18, -6.326265525526201e-19, -9.779663925818259e-21,  9.613775495817574e-01,  1.133404458139507e-02,
 -2.894896354595032e-05, -7.973695209140223e-07,  9.508940001196158e-09,  6.884877187407551e-11, -1.434339171252519e-12,  1.836036352819410e-14,  2.205012567897297e-16,
 -1.516130312476326e-17, -2.666645198046696e-19,  1.002188291696965e-22,  1.224729819473507e+00,  9.376756797926889e-03, -5.288674198222565e-05, -1.737349354183963e-07,
  6.988964288002961e-09, -3.900766600823178e-11,  6.626948255970582e-14,  1.645508860435128e-14, -1.549704716791651e-16, -7.035525656313257e-18, -1.289344663792192e-19,
 -8.863143810896870e-22,  1.445556280385442e+00,  7.137112880560182e-03, -5.379310984217753e-05,  1.556454050977813e-07,  2.542777155454369e-09, -3.479650640987590e-11,
  5.272343127347678e-13,  4.434824665109067e-15, -9.301725909349740e-17, -3.573610426120666e-18, -9.540225307064657e-20, -4.833978230980131e-22,  1.626205830635143e+00,
  5.010182490765492e-03, -4.394692850725032e-05,  2.568696366765007e-07, -2.028664876893907e-10, -1.029411119390047e-11,  3.717387117668376e-13,  4.367705832428017e-16,
 -2.724923867809635e-17, -2.417696982168052e-18, -5.965458970216243e-20, -2.485438871232204e-22,  1.769201540355262e+00,  3.178326171658095e-03, -3.050171553447494e-05,
  2.297768827590850e-07, -1.174394722270393e-09,  4.769606682576514e-12,  1.430815699886362e-13,  3.038675367365455e-16, -9.124372829691024e-18, -1.533191605524737e-18,
 -3.313728110018315e-20, -1.499206348947023e-22,  1.876634646971084e+00,  1.729733951507217e-03, -1.754871449367037e-05,  1.501967274416737e-07, -1.066020416391625e-09,
  8.051252930238891e-12,  1.691212445009181e-14,  6.065855952837689e-16, -7.298745056666271e-18, -7.866886826918224e-19, -1.665024905763849e-20, -8.031939291508002e-23,
  1.950064397732311e+00,  7.081375541583217e-04, -7.428277968504136e-06,  6.811236770215220e-08, -5.542400700190591e-10,  4.935090159573375e-12, -1.381834790799286e-14,
  4.505424702859523e-16, -4.886338677112958e-18, -2.935917965958342e-19, -6.648644207510694e-21, -3.093279894870111e-23,  1.990549921761256e+00,  1.348102703870708e-04,
 -1.438465417955205e-06,  1.363595492989486e-08, -1.177246184587352e-10,  1.116934347462773e-12, -5.011359632530960e-15,  1.117211524589803e-16, -1.211329239515046e-18,
 -5.176299955250440e-20, -1.266260057089430e-21, -5.497997825735101e-24,  5.718499762261382e-02,  2.841386980485571e-03,  9.732851174859138e-05,  2.624958075491814e-06,
  5.474821506819239e-08,  7.266718573443844e-10, -2.654085108058807e-12, -5.232049634266110e-13, -1.849853732773804e-14, -3.965962437926159e-16, -4.127281530810922e-18,
  7.844131176325726e-20,  3.645773413893749e-01,  1.070114016088968e-02,  1.278482666382068e-04, -7.218056068447282e-07, -3.925874924714402e-08,  5.522404638752382e-11,
  1.886751713354297e-11,  1.522222110561652e-13, -8.438345594573897e-15, -1.945712122948789e-16,  1.369200540158909e-18,  9.882730351394217e-20,  7.048803901294760e-01,
  1.232139406785358e-02,  1.852899845094342e-05, -1.410956301698222e-06,  3.166970464936185e-09,  3.504830905890253e-10, -6.964362145078825e-13, -6.498590170826623e-14,
 -1.121332225040833e-16, -2.205126462672541e-17, -7.265812117782940e-19,  6.793864103583798e-21,  1.006193719604309e+00,  1.106685896752043e-02, -3.756466143068546e-05,
 -6.358990919359972e-07,  1.058503203299232e-08,  4.081452396969118e-11, -9.178232616370797e-13,  1.470010348148341e-14, -5.058320476250691e-16, -2.455101802422505e-17,
 -1.677765693655653e-19,  4.890753329252038e-21,  1.261380062122691e+00,  8.947166578506598e-03, -5.432568927809782e-05, -6.792310372888848e-08,  6.258013127644225e-09,
 -3.271939434507507e-11,  4.121793584753267e-13,  6.415267481129222e-15, -5.036950803893937e-16, -1.219570678994448e-17, -1.058730957498450e-19,  2.287552639648999e-21,
  1.473256783741092e+00,  6.714882371624294e-03, -5.170190009296431e-05,  1.914842944920869e-07,  1.981100911485791e-09, -2.113487202819046e-11,  5.850388561816737e-13,
 -1.350567959059686e-15, -2.911609933856424e-16, -7.321479520042756e-18, -7.739863084576978e-20,  1.516047308343678e-21,  1.645562837283389e+00,  4.670869137265690e-03,
 -4.088918742371578e-05,  2.524626538041065e-07, -3.194521629362714e-10, -1.421286350850500e-12,  3.553473793517925e-13, -2.293411536346724e-15, -1.573218257116114e-16,
 -4.730585828405591e-18, -4.727627747537389e-20,  9.463151247048120e-22,  1.781443840765789e+00,  2.945030773780705e-03, -2.785337765197119e-05,  2.119378374824870e-07,
 -1.044394634627599e-09,  8.212370888486620e-12,  1.373508601906762e-13, -1.130621521236139e-15, -8.830752666500292e-17, -2.823349954105586e-18, -2.636261417451916e-20,
  5.371444598460990e-22,  1.883283825290998e+00,  1.596276127541327e-03, -1.584329264915002e-05,  1.344555734774054e-07, -8.998251992749108e-10,  8.603714409124810e-12,
  2.543565472972359e-14, -2.107865104921984e-16, -4.771259006925385e-17, -1.437850214015223e-18, -1.334739782531358e-20,  2.710815160022679e-22,  1.952783068979513e+00,
  6.518373745414131e-04, -6.660927167638085e-06,  6.001994976895887e-08, -4.579723976068893e-10,  4.725529385611925e-12, -5.353514854055500e-15,  7.294963202044031e-17,
 -2.027826733290998e-17, -5.532653087105944e-19, -5.331512311583107e-21,  1.068245584504788e-22,  1.991067140713249e+00,  1.239267119408121e-04, -1.285416852248394e-06,
  1.192549496336037e-08, -9.636651104085059e-11,  1.027742964884102e-12, -2.776754440034500e-15,  3.324013131130470e-17, -3.990692705360588e-18, -1.010511720008197e-19,
 -1.012065927421823e-21,  2.004906503974349e-23,  7.032971310145734e-02,  3.761956399750800e-03,  1.345353356779931e-04,  3.607373605540589e-06,  6.705305198259954e-08,
  4.062272015688620e-10, -2.789691896141221e-11, -1.362680297787412e-12, -3.395534075963317e-14, -3.795915155148115e-16,  8.776772820794994e-18,  6.048279256553327e-19,
  4.093578595380263e-01,  1.167884972417222e-02,  1.155363715354618e-04, -1.315683825276353e-06, -3.346393204557483e-08,  5.227932906927807e-10,  1.842052942287930e-11,
 -2.109341501535988e-13, -1.343878553504903e-14, -5.769822511010891e-17,  5.155701546183297e-18,  5.613846625368025e-20,  7.543571049247459e-01,  1.240328526364691e-02,
  2.128196931743070e-06, -1.305752799576177e-06,  9.856225929034375e-09,  3.106145858781954e-10, -2.720553011535760e-12, -8.596083570620416e-14, -1.305558639273271e-15,
 -3.949790756729032e-17, -8.819116817634154e-21,  2.562439315564499e-20,  1.049815929854494e+00,  1.073875243430424e-02, -4.415594715783290e-05, -4.611088763266887e-07,
  1.120133733313308e-08,  2.104648280176303e-11, -8.719315551487616e-13, -1.638560901153528e-14, -1.440633694542648e-15, -2.494279787719259e-17,  2.038184663995157e-19,
  1.261016119177580e-20,  1.296296697347949e+00,  8.510956844694330e-03, -5.455977485310395e-05,  2.753035597065210e-08,  5.705877045384865e-09, -2.292149673110996e-11,
  2.958499328903776e-13, -1.726828934790584e-14, -9.823756349282791e-16, -1.302980120811250e-17,  1.030270550946865e-19,  7.677687988325259e-21,  1.499304360081826e+00,
  6.310969955745219e-03, -4.922546858287750e-05,  2.205281239859263e-07,  1.689210281304033e-09, -8.861326239475644e-12,  3.739003731699003e-13, -1.530137900494087e-14,
 -5.865657826251611e-16, -8.201544117391574e-18,  5.837167663593461e-20,  4.983066434163802e-21,  1.663611152079552e+00,  4.355787647110319e-03, -3.788982896116907e-05,
  2.475531946815709e-07, -2.714431603365911e-10,  5.599758716904371e-12,  1.930697717669416e-13, -1.030508040506000e-14, -3.468285982567898e-16, -5.246503969920685e-18,
  3.700808236909232e-20,  3.102538838158322e-21,  1.792794033871975e+00,  2.732106258724108e-03, -2.540443113971575e-05,  1.967028367664622e-07, -8.518179534668787e-10,
  1.070986068676537e-11,  4.975590331230774e-14, -5.721984834101617e-15, -2.004400283883402e-16, -3.089062062325483e-18,  2.217596122472660e-20,  1.800846473548785e-21,
  1.889425327693036e+00,  1.475752169763765e-03, -1.431043744911950e-05,  1.214623789931331e-07, -7.232301038288832e-10,  8.920049293899006e-12, -1.017787247858654e-14,
 -2.636248454868539e-15, -1.047754833200763e-16, -1.570663260655725e-18,  1.139889551881709e-20,  9.228100155934336e-22,  1.955288238707436e+00,  6.013134809792330e-04,
 -5.981558701945410e-06,  5.344062248067762e-08, -3.650426961883527e-10,  4.528647942002746e-12, -1.561238917235642e-14, -9.229583793144038e-16, -4.233656506467658e-17,
 -6.084895828960011e-19,  4.422820633000567e-21,  3.641538729063648e-22,  1.991543152254695e+00,  1.141911281944395e-04, -1.150895375431221e-06,  1.054446022950557e-08,
 -7.649237049818807e-11,  9.542534579941942e-13, -4.223171343986864e-15, -1.580769700609245e-16, -8.039382554045314e-18, -1.119637916781364e-19,  8.120027504247214e-22,
  6.805315302963628e-23,  8.783043946326577e-02,  5.029938737747481e-03,  1.843701395289844e-04,  4.693533746981058e-06,  6.471747727161380e-08, -8.525586793418271e-10,
 -8.245363107149712e-11, -2.531619588378750e-12, -3.234999590585833e-14,  7.870247161213627e-16,  5.693641708286944e-17,  1.583788566202850e-18,  4.578102260918693e-01,
  1.253182282700091e-02,  9.695086460891731e-05, -1.746331659250210e-06, -1.931934201108214e-08,  8.450121845936986e-10,  6.485683922628804e-12, -6.311133318141095e-13,
 -1.143948528616095e-14,  1.732341631254007e-16,  5.896620141579263e-18, -7.292522573072201e-21,  8.039094327150752e-01,  1.236076021875842e-02, -1.240360131230452e-05,
 -1.102822108918844e-06,  1.519083766833074e-08,  2.104622749759954e-10, -5.912107085918725e-12, -1.479991356586606e-13, -2.407359915945057e-15, -1.109177106767283e-17,
  1.611543153205196e-18,  5.119477443872284e-20,  1.092033732910439e+00,  1.036644180869893e-02, -4.860439111541659e-05, -2.799165894830378e-07,  1.134569963293835e-08,
 -1.133762373614482e-11, -2.092615034836706e-12, -7.398558338911459e-14, -2.025371292039892e-15, -1.918820556011193e-18,  1.065102696643757e-18,  2.897444624923745e-20,
  1.329471807590505e+00,  8.077318673509857e-03, -5.369613920776618e-05,  1.153093092461216e-07,  5.259252575577595e-09, -2.556151969466830e-11, -6.880789331399657e-13,
 -5.460662689794977e-14, -1.272884756151034e-15,  4.856731499185557e-19,  6.534777285223363e-19,  1.885854236295481e-20,  1.523778026354314e+00,  5.928199831112826e-03,
 -4.642173303490544e-05,  2.464381733260262e-07,  1.554994727470169e-09, -7.394368820401125e-12, -3.555456169229750e-13, -3.781978377841120e-14, -7.718789177724926e-16,
  2.487217974062864e-19,  4.168915785696605e-19,  1.227552936529914e-20,  1.680446787784172e+00,  4.064487297549622e-03, -3.494106473619446e-05,  2.442350856174061e-07,
 -1.436436334890757e-10,  5.360187897857427e-12, -2.753688062035000e-13, -2.381196837508629e-14, -4.666261071698625e-16,  5.779016294149535e-20,  2.614743097881132e-19,
  7.696192136413546e-21,  1.803330631921914e+00,  2.538097224108771e-03, -2.311867586139564e-05,  1.847834745550160e-07, -6.428021399660500e-10,  9.164470316940944e-12,
 -2.146832608561733e-13, -1.355322608966337e-14, -2.709569296430214e-16,  2.810378290759584e-20,  1.532673873569265e-19,  4.503024610541029e-21,  1.895108340373099e+00,
  1.366915463556336e-03, -1.291656109726419e-05,  1.112720994560877e-07, -5.554118187135058e-10,  7.364331392815971e-12, -1.382555550204834e-13, -6.707733113206999e-15,
 -1.404143369921380e-16,  3.132540482732213e-20,  7.881800119188653e-20,  2.317995086939456e-21,  1.957601717844345e+00,  5.559335652521179e-04, -5.372423536684838e-06,
  4.829238342378398e-08, -2.811797322385562e-10,  3.672635205658136e-12, -6.325466176669332e-14, -2.555362774359124e-15, -5.604301402136249e-17,  2.110299664888974e-20,
  3.105890474029945e-20,  9.158551748708629e-22,  1.991982276302809e+00,  1.054706982928021e-04, -1.031098619757101e-06,  9.465683750395729e-09, -5.894407091144576e-11,
  7.673824718300556e-13, -1.277165951594956e-14, -4.663248396081581e-16, -1.054821643985207e-17,  5.119160814179447e-21,  5.789951222682979e-21,  1.711226310910879e-22,
  1.112789341797815e-01,  6.745671704795074e-03,  2.459246262648971e-04,  5.459396193837758e-06,  2.171078226296166e-08, -3.753644636722100e-09, -1.596179486840338e-10,
 -2.532606167794917e-12,  5.422283363230602e-14,  4.449211430769528e-15,  1.175078554985910e-16,  2.496382636235735e-19,  5.093503144093854e-01,  1.321965778226905e-02,
  7.470731659473459e-05, -1.918444531238021e-06, -2.477316940608038e-09,  7.546359769087185e-10, -1.504836224405863e-11, -8.516866340673959e-13, -8.915672068818006e-16,
  4.216576019899310e-16,  7.386233462344929e-18,  1.070243694066450e-19,  8.530763841564118e-01,  1.221299003865372e-02, -2.406944030922446e-05, -8.353690989235121e-07,
  1.760097187602380e-08,  1.033756148581191e-11, -1.107672534655099e-11, -2.138216541078492e-13, -9.868692660488329e-16,  1.114770503865974e-16,  4.858953671303929e-18,
  9.599405488742628e-20,  1.132704863030477e+00,  9.967217727469637e-03, -5.089276169470891e-05, -1.037616751990656e-07,  1.041209398334737e-08, -9.344270961810156e-11,
 -5.006571569819694e-12, -1.287099464536858e-13, -9.472130466194745e-16,  7.427695897098234e-17,  2.944130930795557e-18,  5.487115138488073e-20,  1.360932665010417e+00,
  7.654667330353243e-03, -5.182893137513529e-05,  1.938699215617947e-07,  4.436118868209834e-09, -6.478369557974684e-11, -2.737827151358602e-12, -8.808615269543364e-14,
 -5.383215301441695e-16,  4.833894175840483e-17,  1.859822568036612e-18,  3.442135290358159e-20,  1.546767383339659e+00,  5.569061719102480e-03, -4.332267927412528e-05,
  2.692625652398379e-07,  1.222125039601854e-09, -3.127297110229914e-11, -1.728941441812789e-12, -5.790819023700620e-14, -3.031172754413434e-16,  3.094922515004618e-17,
  1.191884778195012e-18,  2.173837580679757e-20,  1.696164192933145e+00,  3.796647561177200e-03, -3.202234964982620e-05,  2.421791675735930e-07, -1.649240044917109e-10,
 -1.084410918040796e-11, -1.132024117470151e-12, -3.591006492415101e-14, -1.764814694897207e-16,  1.927164125087887e-17,  7.436418549091660e-19,  1.337306999407234e-20,
  1.813126933922662e+00,  2.361853982388064e-03, -2.095823540089275e-05,  1.755388663318962e-07, -5.466464038413552e-10, -1.467477708869863e-12, -7.043884353996272e-13,
 -2.056742895364826e-14, -1.013013174264238e-16,  1.126732765513396e-17,  4.339844050173584e-19,  7.725303993619456e-21,  1.900377593504093e+00,  1.268782632706360e-03,
 -1.163053490062522e-05,  1.033107961377502e-07, -4.590422541253723e-10,  1.313053252869685e-12, -3.831399032752784e-13, -1.033945162209096e-14, -5.257131194764804e-17,
  5.808428263125979e-18,  2.228001868026430e-19,  3.940640563850841e-21,  1.959743062097305e+00,  5.152006417400175e-04, -4.817826463406562e-06,  4.427078260386160e-08,
 -2.297098038136974e-10,  1.104754005761199e-12, -1.575631733438690e-13, -4.004020462870386e-15, -2.109292511601945e-17,  2.298831093853417e-18,  8.780132258149517e-20,
  1.547290401337228e-21,  1.992388359646926e+00,  9.766126282441666e-05, -9.227302601287324e-07,  8.623601008962644e-09, -4.790851215999497e-11,  2.682162314440201e-13,
 -3.010987336325009e-14, -7.388916352015023e-16, -3.986511354108473e-18,  4.300012029435133e-19,  1.637628798873880e-20,  2.880959493903732e-22,  1.426103202089340e-01,
  8.973869410443635e-03,  3.103173607087736e-04,  4.979665427289258e-06, -9.565916698842247e-08, -8.060490532446290e-09, -1.761399416103535e-10,  2.573220454630958e-12,
  2.823360610510236e-13,  7.089380099306216e-15, -6.140313758069511e-17, -1.001388268398957e-17,  5.632788126690337e-01,  1.372553690621362e-02,  5.186079800401871e-05,
 -1.864927180202449e-06,  7.123334478256797e-09,  1.204266030764396e-10, -3.654050483287027e-11, -5.686985160418662e-13,  2.106919644633541e-14,  8.397065231474419e-16,
  1.304702641710355e-17,  1.255978194866754e-20,  9.014863941053501e-01,  1.198503597804921e-02, -3.244972465449093e-05, -5.685810771443175e-07,  1.466720440694561e-08,
 -3.256611265742155e-10, -1.658716726253370e-11, -1.354963959618014e-13,  7.508007531644139e-15,  3.822436130581068e-16,  7.861598485922344e-18, -2.746874439778310e-20,
  1.171755313865051e+00,  9.557736517872284e-03, -5.122457016022392e-05,  4.010602737747311e-08,  7.045864826164192e-09, -2.568733162445401e-10, -8.444017404952254e-12,
 -8.896830646421893e-14,  4.386377019705457e-15,  2.330673769912709e-16,  4.437111837586481e-18, -2.781835390030048e-20,  1.390738344826564e+00,  7.250422376916581e-03,
 -4.913326613238796e-05,  2.500649077787243e-07,  2.282450993037848e-09, -1.598425086778392e-10, -5.064955290642233e-12, -6.032695050071256e-14,  2.869554109659292e-15,
  1.473085274244435e-16,  2.703956126222825e-18, -2.197845571581054e-20,  1.568371316109951e+00,  5.235672363211781e-03, -4.000366550473676e-05,  2.810041169863184e-07,
  5.043061209790768e-11, -9.191780786324907e-11, -3.242799126712315e-12, -3.884990603117171e-14,  1.872223277330274e-15,  9.362294858291111e-17,  1.682895772295466e-18,
 -1.599342257645909e-20,  1.710856731973021e+00,  3.552020722581822e-03, -2.914491045742816e-05,  2.359862649783419e-07, -7.346779318391568e-10, -4.984315664052241e-11,
 -2.065083399172792e-12, -2.366438628648073e-14,  1.175621081863404e-15,  5.801228461056171e-17,  1.026836017572739e-18, -1.080862759368832e-20,  1.822252137476278e+00,
  2.202456100574875e-03, -1.890872870884094e-05,  1.654429142969265e-07, -7.915117647204230e-10, -2.513957883423044e-11, -1.237203657448293e-12, -1.336636204649795e-14,
  6.869654366099780e-16,  3.372673178766840e-17,  5.897223823529823e-19, -6.650754652100526e-21,  1.905274308767282e+00,  1.180570670159166e-03, -1.043589561407659e-05,
  9.557788452943204e-08, -5.480974344706099e-10, -1.128382482981382e-11, -6.506756487587358e-13, -6.650641452220022e-15,  3.524504854997737e-16,  1.728769244610478e-17,
  2.994458317161844e-19, -3.537085989491001e-21,  1.961730056111693e+00,  4.787207002664030e-04, -4.308670413442394e-06,  4.052847577097380e-08, -2.544823270708300e-10,
 -3.994578566533050e-12, -2.611380760717530e-13, -2.557589299350643e-15,  1.387470848779935e-16,  6.810195754988351e-18,  1.171860396509878e-19, -1.425391960194592e-21,
  1.992764878184122e+00,  9.068043988387098e-05, -8.238157727665781e-07,  7.853654754814613e-09, -5.144182461784188e-11, -6.977028180269303e-13, -4.922366397068000e-14,
 -4.701600748739893e-16,  2.585862249465215e-17,  1.270252250024572e-18,  2.177716164746437e-20, -2.690067374707428e-22,  1.837948121857738e-01,  1.165587440630471e-02,
  3.549431624066595e-04,  1.975275230710705e-06, -2.871720768217685e-07, -1.020888880030936e-08,  5.132318818197031e-11,  1.414490627976177e-11,  3.568709161553261e-13,
 -7.156901854359684e-15, -6.712333726199912e-16, -1.151673998090752e-17,  6.188715607528916e-01,  1.405269784521903e-02,  3.008000190044641e-05, -1.782986449904156e-06,
 -3.088231635390576e-12, -8.401980362192826e-10, -3.784324739912939e-11,  6.724211659640663e-13,  5.780888471685902e-14,  1.008707496498242e-15, -1.770007982017797e-17,
 -1.768257571668527e-18,  9.488689281077802e-01,  1.170149644438554e-02, -3.815159961781674e-05, -4.082601256505442e-07,  4.067262807967811e-09, -7.274700337347881e-10,
 -1.457493559563659e-11,  3.737358433849728e-13,  2.511527096738391e-14,  4.929568434495149e-16, -8.287925212705830e-18, -8.339205678078174e-19,  1.209171812289298e+00,
  9.151316869049412e-03, -5.027348710166755e-05,  1.002777219862380e-07, -2.010873730872417e-10, -4.647423466361043e-10, -7.505171679174432e-12,  2.118626734254962e-13,
  1.477967892298374e-14,  2.811439786039717e-16, -5.404109906568803e-18, -4.819836109071376e-19,  1.418973406796402e+00,  6.869692464645008e-03, -4.604123188297443e-05,
  2.540862949098207e-07, -2.190002455194258e-09, -2.857579693876208e-10, -4.550454719224335e-12,  1.317672520898097e-13,  9.321661692536035e-15,  1.703939424500500e-16,
 -3.615225261089392e-18, -2.995201818002172e-19,  1.588695102308569e+00,  4.928976575551765e-03, -3.670176018531384e-05,  2.626714105711076e-07, -2.604638229982867e-09,
 -1.725238802805384e-10, -2.911357723763489e-12,  8.433168113150459e-14,  5.925570618390625e-15,  1.052103643410005e-16, -2.392713041115851e-18, -1.888841692604217e-19,
  1.724616026326482e+00,  3.329894975934051e-03, -2.642559628429341e-05,  2.134419926704677e-07, -2.249786519533276e-09, -1.009400992521401e-10, -1.842663876542323e-12,
  5.295733780067407e-14,  3.666187999312864e-15,  6.382355981237813e-17, -1.524732799511480e-18, -1.164002847997484e-19,  1.830771627866044e+00,  2.058863149898605e-03,
 -1.702142283770737e-05,  1.470762827705301e-07, -1.603442844453723e-09, -5.558349305558969e-11, -1.095957163209841e-12,  3.120311474817124e-14,  2.125874084327021e-15,
  3.652661171161748e-17, -9.035865325404833e-19, -6.737097847838707e-20,  1.909836640771060e+00,  1.101499303853439e-03, -9.351874420709603e-06,  8.412211555886848e-08,
 -9.357375047963732e-10, -2.721745195950140e-11, -5.727307649389648e-13,  1.617237006533827e-14,  1.086666814668637e-15,  1.851251081107754e-17, -4.691361401247741e-19,
 -3.441088491648933e-20,  1.963578971746078e+00,  4.461191272032893e-04, -3.850536382920552e-06,  3.546495563057840e-08, -3.991938439563018e-10, -1.036661823572869e-11,
 -2.287892374885530e-13,  6.421424440079331e-15,  4.271022725429576e-16,  7.238215009834238e-18, -1.863014317714964e-19, -1.352121369260682e-20,  1.993114994075297e+00,
  8.445140607365602e-05, -7.351856304962603e-07,  6.852563840701736e-09, -7.759485900119421e-11, -1.896394545999878e-12, -4.301235728052220e-14,  1.203074813411027e-15,
  7.955439934772694e-17,  1.344615642802568e-18, -3.489574262124454e-20, -2.518372508693969e-21,  2.361182444908787e-01,  1.449778571034003e-02,  3.449701283945600e-04,
 -4.033089502274998e-06, -4.420146224577378e-07, -3.370684662957394e-09,  5.289131370291320e-10,  1.592120559235216e-11, -4.013245731189535e-13, -3.172122190021089e-14,
 -1.490318925381682e-16,  4.205469545613083e-17,  6.754260947760360e-01,  1.420620426712937e-02,  7.996806406164766e-06, -1.956306460007630e-06, -2.317397152773803e-08,
 -1.289372939610919e-09,  1.027537356988987e-11,  2.772833376752650e-12,  5.661964476580823e-14, -1.848292603898655e-15, -1.292299316744821e-16, -2.028678233793911e-18,
  9.950334391123986e-01,  1.137658914024838e-02, -4.318792137010949e-05, -4.732216834107446e-07, -1.260854791917958e-08, -8.488613917187296e-10,  8.854566805906530e-12,
  1.309377495594152e-12,  2.573319268090026e-14, -7.970595265193379e-16, -5.717003671988567e-17, -8.526355825432127e-19,  1.244979253683207e+00,  8.753131879457350e-03,
 -4.941985063041521e-05,  1.598911420502042e-08, -1.051000727954103e-08, -5.135668423863349e-10,  5.989956437925232e-12,  7.553369336609704e-13,  1.474049572298717e-14,
 -4.687503038255831e-16, -3.214910860124883e-17, -4.324415089748161e-19,  1.445733376086981e+00,  6.512499064916870e-03, -4.340524266650318e-05,  1.693091394074202e-07,
 -8.506132929720192e-09, -3.130485881886842e-10,  3.865158984435752e-12,  4.699030294815573e-13,  9.032690809210283e-15, -2.973605400911766e-16, -1.958986899483931e-17,
 -2.415459423546809e-19,  1.607842373356572e+00,  4.646981036450794e-03, -3.392271222867661e-05,  1.908200692171784e-07, -6.440853687057728e-09, -1.902518748606730e-10,
  2.434120986781852e-12,  2.971262280495733e-13,  5.614717595242464e-15, -1.905114349447222e-16, -1.217998034770109e-17, -1.400469944802644e-19,  1.737527936707479e+00,
  3.127957986842927e-03, -2.415267719892847e-05,  1.596556907800183e-07, -4.515624892676202e-09, -1.126912123466548e-10,  1.477879900444208e-12,  1.836808786541334e-13,
  3.416673091354305e-15, -1.187694191685730e-16, -7.429949989061654e-18, -8.085269238637389e-20,  1.838745179207328e+00,  1.929223600042535e-03, -1.545058116221689e-05,
  1.115459155083649e-07, -2.863913465820234e-09, -6.291078708780610e-11,  8.399377397299501e-13,  1.066276796580155e-13,  1.957422814326325e-15, -6.931689109281624e-17,
 -4.269306690875196e-18, -4.453197464539598e-20,  1.914098982596463e+00,  1.030422499963904e-03, -8.452018277287878e-06,  6.427930996888472e-08, -1.558676488327874e-09,
 -3.119554145539213e-11,  4.218801002117171e-13,  5.459561522226044e-14,  9.921024534322074e-16, -3.561105667397564e-17, -2.169699282256800e-18, -2.193759499340558e-20,
  1.965304359016876e+00,  4.168913025485173e-04, -3.470848741279904e-06,  2.721209815143606e-08, -6.381587461700454e-10, -1.199843325478534e-11,  1.636613503629628e-13,
  2.149049246177366e-14,  3.877820344262542e-16, -1.404559711898466e-17, -8.497915218647042e-19, -8.413869389229178e-21,  1.993441523564711e+00,  7.887457082569778e-05,
 -6.617925514503544e-07,  5.268594957783877e-09, -1.214948808680619e-10, -2.207689338970252e-12,  3.025473122497424e-14,  4.006703566701330e-15,  7.201659755388308e-17,
 -2.621301588759767e-18, -1.580040960891618e-19, -1.546597960287648e-21,  2.991522882878218e-01,  1.694368844621205e-02,  2.544716309776292e-04, -1.084258101882662e-05,
 -3.581779928129465e-07,  1.222827022016355e-08,  6.393607020910051e-10, -1.210064019892893e-11, -1.124033632852719e-12,  5.641155328308044e-15,  1.831387079173799e-15,
  1.476961561962430e-17,  7.322189815049306e-01,  1.416824204248835e-02, -1.843262347976427e-05, -2.491065927756233e-06, -3.954618714973377e-08, -5.372104551727466e-12,
  9.582846694676491e-11,  2.491147165134884e-12, -1.013990573325625e-13, -6.069111462743195e-15,  7.455884698072366e-18,  9.588985629195990e-18,  1.039806457374062e+00,
  1.100379335646164e-02, -5.056282891166062e-05, -7.855929487952909e-07, -2.418306001218718e-08, -1.464482386369751e-10,  4.943768577682906e-11,  1.217760384900513e-12,
 -4.373282804885012e-14, -2.720687347184577e-15, -2.934556843159211e-18,  3.869025966669146e-18,  1.279197324689871e+00,  8.354990577671353e-03, -5.052925722249784e-05,
 -2.186715287813826e-07, -1.745502617744269e-08, -8.753777911153283e-11,  2.937518480820030e-11,  7.041247476511813e-13, -2.467503510864142e-14, -1.526191313196121e-15,
 -1.446112217281879e-18,  2.091174390646729e-18,  1.471097932714474e+00,  6.170651193089599e-03, -4.236715706679505e-05, -6.957117910163381e-09, -1.266726595761093e-08,
 -4.520469471561421e-11,  1.835496369726649e-11,  4.353982316744247e-13, -1.519427818019566e-14, -9.265924718311809e-16, -4.842724578908966e-19,  1.248498622752947e-18,
  1.625899226294968e+00,  4.382753369230040e-03, -3.235811545378295e-05,  6.357896950243658e-08, -8.922375044634144e-09, -2.147865003560264e-11,  1.155629398075905e-11,
  2.732694964361454e-13, -9.547239192496457e-15, -5.741117949903741e-16, -6.488267354851083e-20,  7.668988357055092e-19,  1.749663526971999e+00,  2.941022367357275e-03,
 -2.273328167980197e-05,  7.320192291115414e-08, -5.958731571242489e-09, -9.193050832647418e-12,  7.095369504368505e-12,  1.677935275174332e-13, -5.876258925102813e-15,
 -3.491845841703138e-16,  7.902504932545699e-20,  4.641864524875732e-19,  1.846222131544797e+00,  1.810111079639599e-03, -1.442194728971007e-05,  5.785392914223150e-08,
 -3.656297085928251e-09, -3.350640681979308e-12,  4.090726908560457e-12,  9.686760103925043e-14, -3.400438664579601e-15, -2.001729520457478e-16,  9.814852083980395e-20,
  2.653429065666964e-19,  1.918089672361477e+00,  9.654267289386711e-04, -7.847576255103762e-06,  3.546245248455151e-08, -1.946220594421520e-09, -9.304462147456215e-13,
  2.082432017200612e-12,  4.939120428293987e-14, -1.737183805876483e-15, -1.015507390585343e-16,  6.948708070719486e-20,  1.343843402874632e-19,  1.966918192743235e+00,
  3.902413532479020e-04, -3.212192523473316e-06,  1.551670980211140e-08, -7.857125992488143e-10, -1.520950283633582e-13,  8.162561274666139e-13,  1.938649224001644e-14,
 -6.827902308684954e-16, -3.972615988271014e-17,  3.234760747357902e-20,  5.251905876301728e-20,  1.993746783072508e+00,  7.379718017436945e-05, -6.114500169052236e-07,
  3.052174912283760e-09, -1.484858652410925e-10, -6.196404717150351e-15,  1.518177517104458e-13,  3.608772161896416e-15, -1.271971766968008e-16, -7.381551262817922e-18,
  6.532657162834391e-21,  9.753881543873681e-21,  3.700673168591621e-01,  1.838475141252683e-02,  1.002712870368797e-04, -1.396418848862159e-05, -6.009898441732284e-09,
  2.012173845581934e-08, -7.644124994115139e-11, -3.187045948976876e-11,  1.828282198801248e-13,  5.197191553985465e-14, -3.189381261166862e-16, -8.607626201711071e-17,
  7.883936346920938e-01,  1.389133953794507e-02, -5.167696004324069e-05, -2.984972068328712e-06, -1.367633056852475e-08,  2.587698727348478e-09,  9.303277640574469e-11,
 -3.273855079500575e-12, -2.024168317351696e-13,  3.162945966849787e-15,  3.812059481261890e-16, -5.137375467171357e-19,  1.082943920221390e+00,  1.055524285514915e-02,
 -6.217692968994118e-05, -1.123833024724791e-06, -1.365962300529562e-08,  1.209061995542000e-09,  5.124322592183151e-11, -1.391867230994760e-12, -9.702577432615493e-14,
  9.564764107438818e-16,  1.644005418054712e-16,  6.826891351448428e-19,  1.311785665476400e+00,  7.935652924937843e-03, -5.474959367987901e-05, -4.691696167418109e-07,
 -1.122078443264172e-08,  7.186587973592579e-10,  3.087330742371871e-11, -7.714940505489462e-13, -5.548847389623669e-14,  4.619929560410265e-16,  8.952712628015804e-17,
  4.766269763999258e-19,  1.495097394077980e+00,  5.828036542910113e-03, -4.361087787579233e-05, -1.901475019274948e-07, -8.584413359730046e-09,  4.586751672427107e-10,
  1.939530879101078e-11, -4.672534299049186e-13, -3.399868595512657e-14,  2.641526227782252e-16,  5.332322666775433e-17,  2.973402943371192e-19,  1.642914007818182e+00,
  4.124588189397369e-03, -3.241197207371219e-05, -6.579630311029686e-08, -6.212377123129451e-09,  2.958645628546581e-10,  1.224595869553297e-11, -2.895950558302847e-13,
 -2.117991526183470e-14,  1.597548273887622e-16,  3.261915506569467e-17,  1.815507727114889e-19,  1.761067223673117e+00,  2.761101055049730e-03, -2.239985703238174e-05,
 -1.328115644347437e-08, -4.214671988598629e-09,  1.857242010495522e-10,  7.532165423312055e-12, -1.763193317030469e-13, -1.292790423381577e-14,  9.629394663029618e-17,
  1.966585809487834e-17,  1.077559881336001e-19,  1.853234858712410e+00,  1.696550938594954e-03, -1.406182599447900e-05,  4.772225937685636e-09, -2.611548404411736e-09,
  1.090689035493106e-10,  4.347818821556603e-12, -1.011872335227153e-13, -7.429102724001847e-15,  5.506416791688977e-17,  1.120494929444942e-17,  6.029709069329905e-20,
  1.921827788347034e+00,  9.038369051694820e-04, -7.599758559105255e-06,  7.206133076946867e-09, -1.398747222668473e-09,  5.631718358377862e-11,  2.215169785340780e-12,
 -5.138074971610163e-14, -3.775160930349311e-15,  2.793820480471779e-17,  5.660774575716666e-18,  2.998069030413630e-20,  1.968428649875676e+00,  3.650822654295311e-04,
 -3.097710515177150e-06,  4.109640052959591e-09, -5.668259601919429e-10,  2.229304919773199e-11,  8.687650075511583e-13, -2.011301074791209e-14, -1.478400019265080e-15,
  1.093870977293404e-17,  2.208567515402876e-18,  1.155961020818699e-20,  1.994032365303284e+00,  6.901309963718335e-05, -5.883739098402032e-07,  8.965128010010378e-10,
 -1.073282479478308e-10,  4.169050138900206e-12,  1.616322494450717e-13, -3.738581646126813e-15, -2.748584010000560e-16,  2.033967160331529e-18,  4.097966958678629e-19,
  2.130347389289655e-21,  4.441848885669894e-01,  1.854355597777936e-02, -5.567479230123444e-05, -1.121210559449845e-05,  3.156984448513293e-07,  9.718822273658700e-09,
 -6.599656413993479e-10, -4.610420870851939e-12,  1.135725410672864e-12, -8.931663324016234e-15, -1.742695750445685e-15,  3.791832056565801e-17,  8.429059870732479e-01,
  1.333544614429267e-02, -8.682067716323876e-05, -2.710480357733704e-06,  4.999329232796222e-08,  3.187461599751624e-09, -5.421722021895683e-11, -5.579660626887303e-12,
  9.936478429565728e-14,  9.552213326089347e-15, -1.909988450926336e-16, -1.647252881629411e-17,  1.124082266459229e+00,  1.000235124484619e-02, -7.600945734081834e-05,
 -1.100841804557188e-06,  1.814283344992268e-08,  1.694872105580073e-09, -1.773540709471276e-11, -2.840904061276803e-12,  2.959555662678802e-14,  4.587140098120330e-15,
 -4.843113513447672e-17, -7.510245413975289e-18,  1.342614027412456e+00,  7.473388189561909e-03, -6.087995020747994e-05, -5.039793638825363e-07,  7.927440422932307e-09,
  1.038679441327439e-09, -8.496984561923976e-12, -1.665308933162989e-12,  1.314354928876039e-14,  2.592201117493000e-15, -1.927349116692475e-17, -4.080440617242602e-18,
  1.517695108093875e+00,  5.468518742479330e-03, -4.634904705574748e-05, -2.352249411093775e-07,  3.638148404856254e-09,  6.671125301956937e-10, -4.739277212391141e-12,
 -1.033262192096430e-12,  6.900565511967538e-15,  1.571605252774043e-15, -9.408015197381357e-18, -2.408833767320044e-18,  1.658887083788471e+00,  3.860979105536011e-03,
 -3.356144448941886e-05, -1.058675725067759e-07,  1.645731314560098e-09,  4.298304542823508e-10, -2.800485339713997e-12, -6.483577290586715e-13,  3.885809913092945e-15,
  9.710867767787330e-16, -5.047687839909744e-18, -1.461011166344939e-18,  1.771751041080069e+00,  2.580452979994535e-03, -2.281586141151911e-05, -4.360452187356151e-08,
  6.988429101454829e-10,  2.689198387353927e-10, -1.657923660900326e-12, -3.975190654485471e-13,  2.214771760982045e-15,  5.891050548849458e-16, -2.786011138652501e-18,
 -8.746722714365216e-19,  1.859795690113488e+00,  1.583771103590207e-03, -1.416860140813140e-05, -1.528541179043654e-08,  2.636945396472885e-10,  1.573549088470252e-10,
 -9.358614578821904e-13, -2.290892400418438e-13,  1.214213514833821e-15,  3.370016747880968e-16, -1.495272101735239e-18, -4.956645777045585e-19,  1.925321682831711e+00,
  8.431053026387328e-04, -7.602909829245408e-06, -3.982324996408178e-09,  8.162689997926345e-11,  8.099557381046980e-11, -4.706617895698290e-13, -1.166260667781545e-13,
  5.976767027546780e-16,  1.706989104410400e-16, -7.259625660296149e-19, -2.494216739608014e-19,  1.969839562603225e+00,  3.403836060055063e-04, -3.085159727293914e-06,
 -5.369586773227785e-10,  1.799440055163363e-11,  3.198851504235080e-11, -1.832581274511783e-13, -4.572298319795725e-14,  2.293727844354524e-16,  6.670631077410427e-17,
 -2.762745413512528e-19, -9.705570252619867e-20,  1.994299040425436e+00,  6.432741103515767e-05, -5.846211614519927e-07,  5.557378525171017e-12,  1.916014299023784e-12,
  5.974386211138168e-12, -3.397686843347662e-14, -8.505485786503737e-15,  4.219224381647417e-17,  1.238764803533234e-17, -5.060148287601072e-20, -1.798274048291733e-20,
  5.167499191506268e-01,  1.765508464556538e-02, -1.562446302889311e-04, -5.444222695258469e-06,  3.597776471363199e-07, -4.233886074680903e-09, -3.990129632682465e-10,
  1.763981425783178e-11,  1.285686581558502e-13, -3.053819609175149e-14,  5.923708160563172e-16,  3.266857089451933e-17,  8.946773744496571e-01,  1.252853591332687e-02,
 -1.127945469274545e-04, -1.514620489585330e-06,  9.099954020673507e-08,  6.089555580877070e-10, -1.307172883454183e-10,  6.782069931988727e-13,  2.045322934989111e-13,
 -4.239410849252562e-15, -2.761807474964096e-16,  1.157698126531949e-17,  1.162801882940225e+00,  9.348675604310680e-03, -8.649962164839160e-05, -5.859125346224084e-07,
  4.244784184285319e-08,  5.473545291862550e-10, -6.492775113165070e-11, -1.265758066352588e-13,  1.038188327186749e-13, -1.153287562473415e-15, -1.489712612142016e-16,
  3.809118595704829e-18,  1.371500145767564e+00,  6.965748915449007e-03, -6.555610486900760e-05, -2.360405063803540e-07,  2.345200418608393e-08,  3.960295690296077e-10,
 -3.799946936588965e-11, -1.855556984429520e-13,  6.022756736929636e-14, -4.421688919188797e-16, -8.661787781374081e-17,  1.723428778680055e-18,  1.538812349712616e+00,
  5.088354136808669e-03, -4.842666628647120e-05, -8.523748540850347e-08,  1.382592463770524e-08,  2.762641798234501e-10, -2.363125312703908e-11, -1.518646481909767e-13,
  3.705066542495629e-14, -1.988259841215730e-16, -5.301447590264822e-17,  9.033959144372330e-19,  1.673787400033363e+00,  3.588454876617521e-03, -3.441743089118700e-05,
 -1.995710379630561e-08,  8.295231235296048e-09,  1.869397254092456e-10, -1.487283048253591e-11, -1.092374472253484e-13,  2.310033901479437e-14, -9.656617892302155e-17,
 -3.286815921262104e-17,  5.048572143697050e-19,  1.781705253587586e+00,  2.396400476861604e-03, -2.311102969470574e-05,  5.031668978079098e-09,  4.894015588752324e-09,
  1.207195695075361e-10, -9.144879158974418e-12, -7.251255292611189e-14,  1.409668119548178e-14, -4.814506500100612e-17, -1.996086897016928e-17,  2.852281521642610e-19,
  1.865903309547684e+00,  1.469981526298428e-03, -1.423228906487644e-05,  1.091994136321844e-08,  2.732247424082112e-09,  7.215348485577688e-11, -5.282992731994139e-12,
 -4.391910571893073e-14,  8.096231728534729e-15, -2.352631637251760e-17, -1.142075695475795e-17,  1.551150605235221e-19,  1.928572337207867e+00,  7.822270822179187e-04,
 -7.594185335521414e-06,  8.664698537172196e-09,  1.357032581607600e-09,  3.767092204770484e-11, -2.694603340418280e-12, -2.307910612132091e-14,  4.111837519377504e-15,
 -1.055801491376859e-17, -5.784009636291000e-18,  7.585641600605438e-20,  1.971151760266844e+00,  3.157265103913112e-04, -3.070633249466683e-06,  4.235930667622165e-09,
  5.228947414416559e-10,  1.501193473089287e-11, -1.057813635915280e-12, -9.225505079059025e-15,  1.609533731919525e-15, -3.791221991506620e-18, -2.259822550861469e-18,
  2.897715409015552e-20,  1.994547008442311e+00,  5.965964914443302e-05, -5.807748933841097e-07,  8.744400030731571e-10,  9.633140617821519e-11,  2.816991999602997e-12,
 -1.969221832097805e-13, -1.733424791986296e-15,  2.991604087402653e-16, -6.714306424615409e-19, -4.195971342059627e-19,  5.316371673940940e-21,  5.845830054406892e-01,
  1.623267697457755e-02, -1.910618893772054e-04, -7.202497927168474e-07,  2.181781414475347e-07, -8.227466207929808e-09,  2.914874154173606e-11,  1.015347005061574e-11,
 -4.046412449270221e-13,  2.288726182545157e-16,  5.552119652894903e-16, -1.962177684039861e-17,  9.429065574239288e-01,  1.157812590866308e-02, -1.223396583870535e-04,
 -1.142324667316880e-07,  7.637623470680137e-08, -1.751560227221333e-09, -5.205699771593814e-11,  3.710817673497975e-12, -1.826850042020004e-14, -5.082323113721817e-15,
  1.636902184796685e-16,  3.303088250296989e-18,  1.198784788187258e+00,  8.640401269691711e-03, -8.935735409938660e-05,  1.008957795475011e-07,  3.918474697298032e-08,
 -7.474937187663234e-10, -3.402669983657152e-11,  1.797653537796247e-12,  7.075518397909763e-15, -2.779985999828462e-15,  5.650364095444026e-17,  2.698097646547438e-18,
  1.398305705120952e+00,  6.436634982730734e-03, -6.603253706097927e-05,  1.547714461205634e-07,  2.282352578553134e-08, -3.942139087211163e-10, -2.219679622180311e-11,
  1.026939651991391e-12,  8.428488451400142e-15, -1.647845351460596e-15,  2.541280943096093e-17,  1.765758752687505e-18,  1.558390074255898e+00,  4.700831709769267e-03,
 -4.803829501583578e-05,  1.501215199909152e-07,  1.395492963226226e-08, -2.264567148792934e-10, -1.462366255957637e-11,  6.268863679087899e-13,  6.712489414938267e-15,
 -1.022060348537305e-15,  1.300755456484371e-17,  1.141808648972319e-18,  1.687592425701724e+00,  3.314572494292380e-03, -3.379948732540193e-05,  1.236275036258940e-07,
  8.606809865708493e-09, -1.338814716445198e-10, -9.532415343429800e-12,  3.890725113266944e-13,  4.792461733275621e-15, -6.394748005853719e-16,  7.065010016793609e-18,
  7.300165066295293e-19,  1.790923485056833e+00,  2.213191029103176e-03, -2.253959664794825e-05,  9.088525937995623e-08,  5.188645788507192e-09, -7.833913836075587e-11,
 -5.996843936843683e-12,  2.367393944723901e-13,  3.173907935710658e-15, -3.908442145816037e-16,  3.882873203774229e-18,  4.518066645383380e-19,  1.871557486218129e+00,
  1.357455402143066e-03, -1.381359968177276e-05,  5.936292602214039e-08,  2.945892907017892e-09, -4.354371430798902e-11, -3.518028020517053e-12,  1.357099255659260e-13,
  1.921221485899957e-15, -2.246319048959730e-16,  2.061418632659099e-18,  2.616731068205266e-19,  1.931580964819648e+00,  7.222929861354372e-04, -7.346447285046809e-06,
  3.292033235753619e-08,  1.481733702730581e-09, -2.158034775765459e-11, -1.812893157630887e-12,  6.883762625489550e-14,  1.009594905133515e-15, -1.141168655171725e-16,
  9.889443828822305e-19,  1.335737299023301e-19,  1.972366077642101e+00,  2.915208196137205e-04, -2.964166930757210e-06,  1.363464781108399e-08,  5.759125618765733e-10,
 -8.307601544105059e-12, -7.163044129969986e-13,  2.692505368480099e-14,  4.036379747418300e-16, -4.467451134394029e-17,  3.726704323304701e-19,  5.244243355874523e-20,
  1.994776461622390e+00,  5.508423176398211e-05, -5.600072875489525e-07,  2.611347306571361e-09,  1.066089910822133e-10, -1.529974488980812e-12, -1.338008220530602e-13,
  5.002508167484069e-15,  7.585208002511544e-17, -8.303806748935659e-18,  6.785095745249218e-20,  9.761977753683169e-21,  6.464700503555939e-01,  1.471707255053178e-02,
 -1.838634160303846e-04,  1.563828704137446e-06,  7.654912677747787e-08, -5.459343001402664e-09,  1.545452438023153e-10,  2.468858369253043e-14, -1.875674940233257e-13,
  7.558280613686131e-15, -7.800965210416620e-17, -6.001635140418037e-18,  9.872784086215156e-01,  1.061176089157200e-02, -1.176643643667185e-04,  7.920965839735673e-07,
  3.638220360153686e-08, -1.941629406306664e-09,  2.560235038021385e-11,  1.507862190858010e-12, -8.306198826142143e-14,  8.395419095399658e-16,  8.057723895264949e-17,
 -3.899921370247563e-18,  1.231937631167701e+00,  7.939702496627760e-03, -8.497629115920611e-05,  5.804553765202211e-07,  1.995416979087850e-08, -1.007885027062827e-09,
  8.302734456521485e-12,  9.742865445406767e-13, -4.102713487722356e-14,  3.988728538675591e-17,  5.170939092377263e-17, -1.706327360111567e-18,  1.423015283729806e+00,
  5.921273056298306e-03, -6.231147992456818e-05,  4.376424919041419e-07,  1.190018744449230e-08, -5.966431930548462e-10,  3.377222761365319e-12,  6.318025759267960e-13,
 -2.341347918896526e-14, -9.095124368024821e-17,  3.252977556559337e-17, -8.803279336853394e-19,  1.576440983061957e+00,  4.327088856867538e-03, -4.509188842158963e-05,
  3.241171999931386e-07,  7.337947895176832e-09, -3.711898450555281e-10,  1.505160582608578e-12,  4.142860411578868e-13, -1.422503086277182e-14, -9.844939043737536e-17,
  2.079626485598136e-17, -4.954879135050527e-19,  1.700322277479834e+00,  3.052186304162659e-03, -3.160799664760635e-05,  2.312571936124809e-07,  4.534012623168973e-09,
 -2.327839350690568e-10,  6.898356614143038e-13,  2.690230174557862e-13, -8.784766511628906e-15, -7.880875549714123e-17,  1.324481077897588e-17, -2.887892564213852e-19,
  1.799424308378183e+00,  2.038489677742080e-03, -2.102157353520730e-05,  1.558597040617542e-07,  2.729977147650283e-09, -1.424549627527533e-10,  3.118965395463429e-13,
  1.687280806663354e-13, -5.322055439939159e-15, -5.539086116498464e-17,  8.186765425687085e-18, -1.674654005223160e-19,  1.876771816298479e+00,  1.250507933128093e-03,
 -1.285839773044191e-05,  9.627305104223648e-08,  1.546144105068434e-09, -8.191450359451434e-11,  1.339278434360020e-13,  9.875033514841368e-14, -3.040161103114510e-15,
 -3.472993760252027e-17,  4.740120479749387e-18, -9.259069661714695e-20,  1.934355606046797e+00,  6.654598190693295e-04, -6.829206071919682e-06,  5.148808223897512e-08,
  7.756254582627418e-10, -4.161708052813584e-11,  5.186766558545127e-14,  5.079875964284204e-14, -1.538027974599121e-15, -1.865211408411602e-17,  2.419774676587832e-18,
 -4.575549735603311e-20,  1.973485968947649e+00,  2.686012175896876e-04, -2.753046786926605e-06,  2.085124436370783e-08,  3.008075122235253e-10, -1.629071159830813e-11,
  1.617156281694319e-14,  2.004776547083375e-14, -6.005013360005019e-16, -7.555482866849484e-18,  9.501616416625067e-19, -1.758886374726103e-20,  1.994988073637955e+00,
  5.075530178207316e-05, -5.198767057596908e-07,  3.947156089244734e-09,  5.560924475543219e-11, -3.027699042889216e-12,  2.593746658034386e-15,  3.742368248472502e-15,
 -1.114592859535278e-16, -1.429375986387479e-18,  1.768881487898541e-19, -3.237318344570610e-21,  7.025354350750418e-01,  1.333502341532796e-02, -1.607213913998108e-04,
  2.107617153154308e-06,  1.964420902137177e-09, -2.198607540358342e-09,  1.060017658690130e-10, -2.510006080160182e-12, -1.317615505017977e-15,  2.647068727656462e-15,
 -1.106005271446140e-16,  1.985112523990595e-18,  1.027913437478672e+00,  9.715679262261937e-03, -1.058125251065971e-04,  1.106402949742211e-06,  5.736728877953866e-09,
 -1.078236294177424e-09,  3.786231246736968e-11, -3.343047704387857e-13, -2.888411485897983e-14,  1.475659928517467e-15, -2.407151857653730e-17, -7.273011008353802e-19,
  1.262386710032023e+00,  7.291755532858019e-03, -7.670617624149627e-05,  7.560218513256481e-07,  3.278083593863085e-09, -6.176021697462936e-10,  1.943216463594933e-11,
 -5.811306940062485e-14, -1.937254002268274e-14,  7.704845982369384e-16, -6.390063493926644e-18, -6.256143457930582e-19,  1.445740092300516e+00,  5.446170389766740e-03,
 -5.628403938604213e-05,  5.415119816892352e-07,  1.786804638990695e-09, -3.839650741804442e-10,  1.142144306099281e-11,  3.182514708777789e-15, -1.275877172739468e-14,
  4.495129053327348e-16, -1.738405615810277e-18, -4.355430162089559e-19,  1.593054610555530e+00,  3.983371664620725e-03, -4.072811265960425e-05,  3.871207251514625e-07,
  9.524991827253331e-10, -2.459772330041810e-10,  7.077408207975707e-12,  1.689032762484805e-14, -8.433031012874207e-15,  2.760690149726929e-16, -2.829200377306298e-19,
 -2.934908765550176e-19,  1.712044164935830e+00,  2.811318313028095e-03, -2.854275754425362e-05,  2.694420650332968e-07,  4.898710475636523e-10, -1.572493382019345e-10,
  4.429255353709722e-12,  1.702643151110758e-14, -5.501324558334592e-15,  1.714983863724479e-16,  1.600276719484887e-19, -1.929706196529157e-19,  1.807254541433148e+00,
  1.878333565776964e-03, -1.897833932266931e-05,  1.784087412022772e-07,  2.380684099933920e-10, -9.750750210440759e-11,  2.707908653552168e-12,  1.322975083728360e-14,
 -3.460158812812362e-15,  1.042577836175753e-16,  2.424914398463934e-19, -1.217811529134179e-19,  1.881575866125940e+00,  1.152562880689649e-03, -1.160610627303719e-05,
  1.088182783206421e-07,  1.062862296103545e-10, -5.658654907826440e-11,  1.556543984377702e-12,  8.769360633377289e-15, -2.028771012681563e-15,  5.968068844094821e-17,
  1.982521991299769e-19, -7.150368832157127e-20,  1.936912308545311e+00,  6.134477346678274e-04, -6.163062489473148e-06,  5.768826584006710e-08,  4.163912697394316e-11,
 -2.893094922810510e-11,  7.907684562414833e-13,  4.870035189037134e-15, -1.044840593603053e-15,  3.023119237243803e-17,  1.214508321562101e-19, -3.684486339330309e-20,
  1.974517993761562e+00,  2.476356824355068e-04, -2.484212927705749e-06,  2.322954120019044e-08,  1.286939452788823e-11, -1.137077508780722e-11,  3.095606279689567e-13,
  2.012405233816188e-15, -4.126379950155887e-16,  1.181217298536456e-17,  5.279409991701255e-20, -1.455343863874566e-20,  1.995183092295425e+00,  4.679644382453206e-05,
 -4.690802600198522e-07,  4.384037943958796e-09,  2.032719944869482e-12, -2.117856289628467e-12,  5.753713934144618e-14,  3.845927002820654e-16, -7.705609667958944e-17,
  2.193281672306737e-18,  1.033293658895213e-20, -2.717786988259022e-21,  7.534615035226487e-01,  1.214839250823858e-02, -1.363083053537847e-04,  1.902378728131895e-06,
 -2.200800932830268e-08, -4.407783215329587e-10,  4.439480830935142e-11, -1.704995686959012e-12,  3.585879538943241e-14, -3.475997737701892e-17, -2.961705929416727e-17,
  1.277446097898798e-18,  1.065167660885288e+00,  8.922507174316474e-03, -9.254866287823511e-05,  1.070539579912679e-06, -7.857812120592194e-09, -3.447061644657423e-10,
  2.204625891162420e-11, -6.204445617588399e-13,  4.503817278073096e-15,  4.130703204090156e-16, -2.083492139534039e-17,  4.426645866265506e-19,  1.290384111300041e+00,
  6.714505884741091e-03, -6.764863306787296e-05,  7.334839990691361e-07, -4.804813568205660e-09, -2.178602320357156e-10,  1.274102303011481e-11, -3.158118405797316e-13,
  3.032202062595735e-16,  2.937911016900618e-16, -1.168742490746518e-17,  1.719459494573719e-19,  1.466665419611019e+00,  5.021887210448603e-03, -4.982105298337884e-05,
  5.229413668834838e-07, -3.323125897757044e-09, -1.411241705890695e-10,  7.979794782858109e-12, -1.840618103078637e-13, -5.208594941879704e-16,  1.985635478921651e-16,
 -7.060200239798683e-18,  7.841225394655428e-20,  1.608365815722055e+00,  3.676072677728547e-03, -3.612430777964783e-05,  3.719583849645321e-07, -2.350637397992111e-09,
 -9.230515560910140e-11,  5.144942819104756e-12, -1.133042518794005e-13, -6.093432820842666e-16,  1.331485646450175e-16, -4.424897034509183e-18,  3.887508668457393e-20,
  1.722853151457270e+00,  2.595840821388497e-03, -2.534776389264212e-05,  2.577709270439519e-07, -1.632963769721066e-09, -5.968611820967212e-11,  3.307314067341683e-12,
 -7.055865563586581e-14, -5.070958891997212e-16,  8.764420062945898e-17, -2.784775088503293e-18,  2.000429522489867e-20,  1.814477706095250e+00,  1.735009818086080e-03,
 -1.686759930315870e-05,  1.700919938136134e-07, -1.082548088815807e-09, -3.725109592455047e-11,  2.060361500464568e-12, -4.297972706122102e-14, -3.654028996073544e-16,
  5.545397062892362e-17, -1.707815884101631e-18,  1.031799433881537e-20,  1.886008634132844e+00,  1.064893358861549e-03, -1.032089066707608e-05,  1.034712193420939e-07,
 -6.616694326325319e-10, -2.169837283828608e-11,  1.200200613960807e-12, -2.463976642179891e-14, -2.330220281024746e-16,  3.264511126010071e-17, -9.835058499577637e-19,
  5.137665742772297e-21,  1.939271841247197e+00,  5.668863201396590e-04, -5.482569321185253e-06,  5.474778903396683e-08, -3.514907534935388e-10, -1.111696605218841e-11,
  6.153951133343061e-13, -1.249438542189441e-14, -1.265949843693597e-16,  1.685812088193715e-17, -5.002276705197709e-19,  2.327091652799803e-21,  1.975470539994560e+00,
  2.288658399303020e-04, -2.210421490835305e-06,  2.201708105298392e-08, -1.417591777900584e-10, -4.374240205652293e-12,  2.423523987730910e-13, -4.885233331963531e-15,
 -5.165869764605477e-17,  6.669157422479494e-18, -1.959605245505167e-19,  8.387346844390139e-22,  1.995363103125571e+00,  4.325205782270744e-05, -4.174314521392218e-07,
  4.152305796193207e-09, -2.677839203058536e-11, -8.151468065886502e-13,  4.518923526754845e-14, -9.074174415029377e-16, -9.811127030221683e-18,  1.246520095364932e-18,
 -3.643575902406816e-20,  1.486995107347146e-22,  8.000097735731773e-01,  1.114288884016574e-02, -1.157348126854545e-04,  1.523641804574018e-06, -2.339277610432649e-08,
  1.744502157349040e-10,  1.142600047387965e-11, -7.187785914573737e-13,  2.346605671269786e-14, -4.531243795898338e-16,  1.352866729486369e-18,  2.720732429326311e-19,
  1.099454765270235e+00,  8.231001593016768e-03, -8.060607007752611e-05,  9.129232125526360e-07, -1.074346349855498e-08,  1.139838858976448e-12,  7.996382515434346e-12,
 -3.623251377185710e-13,  8.835759538733914e-15, -6.395520832925640e-17, -4.656304629848680e-18,  2.381906184487007e-19,  1.316213338127433e+00,  6.206979437415213e-03,
 -5.940600903987030e-05,  6.354734998463929e-07, -6.783748132501384e-09, -1.014074025547333e-11,  5.075957789665766e-12, -2.106038365667236e-13,  4.506102759281236e-15,
 -5.000020599908762e-18, -3.552691955305655e-18,  1.437355495564345e-19,  1.485994090925920e+00,  4.647360580550976e-03, -4.392893237001065e-05,  4.558780289715600e-07,
 -4.636061611250733e-09, -8.476383512882145e-12,  3.327315104155293e-12, -1.323226500916030e-13,  2.618809067842915e-15,  7.286233857656808e-18, -2.476912985517162e-18,
  9.017786515999822e-20,  1.622519347097715e+00,  3.404190775194399e-03, -3.192859900930156e-05,  3.252156603129536e-07, -3.215614426236515e-09, -5.780402423025293e-12,
  2.203298377749387e-12, -8.550500600900740e-14,  1.606618605024721e-15,  8.819404023735506e-18, -1.690547099486153e-18,  5.783960913584959e-20,  1.732849825638354e+00,
  2.404921484314156e-03, -2.243854766452795e-05,  2.257320299594591e-07, -2.192662625340830e-09, -3.641785550841024e-12,  1.440829719818310e-12, -5.505973415313731e-14,
  9.974585993591403e-16,  7.437102374522561e-18, -1.125376782721379e-18,  3.696356755351460e-20,  1.821160319897425e+00,  1.607897760692906e-03, -1.494743524437013e-05,
  1.490840872356136e-07, -1.431166930243284e-09, -2.155899624482516e-12,  9.080196045499272e-13, -3.434746364920263e-14,  6.060670876057278e-16,  5.399370731215157e-18,
 -7.174497612933652e-19,  2.291046553062962e-20,  1.890110650928492e+00,  9.870888789430508e-04, -9.152659760836094e-06,  9.073948672099388e-08, -8.641467796400020e-10,
 -1.181374833670146e-12,  5.331413231404436e-13, -2.002946291415749e-14,  3.467720364572901e-16,  3.459631757304362e-18, -4.245533092537659e-19,  1.329226622212461e-20,
  1.941455674831973e+00,  5.255457668020386e-04, -4.864408496397313e-06,  4.802641114044650e-08, -4.549324122750278e-10, -5.713056676748906e-13,  2.748311819165150e-13,
 -1.027821411033770e-14,  1.755880998365041e-16,  1.885321916810145e-18, -2.200154463125712e-19,  6.795346155811532e-21,  1.976352249005438e+00,  2.121958975327162e-04,
 -1.961818688523646e-06,  1.931755157849480e-08, -1.823690856074873e-10, -2.147145689325926e-13,  1.086012512979605e-13, -4.049945725103636e-15,  6.858723683701456e-17,
  7.707992196437681e-19, -8.723483095559268e-20,  2.670803169697148e-21,  1.995529736541114e+00,  4.010373305622513e-05, -3.705457974798364e-07,  3.643514998267864e-09,
 -3.433594681129164e-11, -3.891873889495320e-14,  2.028616894133457e-14, -7.553851747252529e-16,  1.273312020906965e-17,  1.465372527501598e-19, -1.632425270598180e-20,
  4.974628457064402e-22,  8.428368226148784e-01,  1.028411585388651e-02, -9.954884596890589e-05,  1.186666922019265e-06, -1.841438576834706e-08,  2.777410447731777e-10,
 -4.703080511785034e-13, -2.031374533768835e-13,  9.823956672047388e-15, -2.822692171982480e-16,  5.091564310664017e-18, -2.442955110191137e-20,  1.131154400570451e+00,
  7.627105688404967e-03, -7.065595438852111e-05,  7.487265307832808e-07, -9.470485850592054e-09,  1.002725574912045e-10,  1.303793353048234e-12, -1.363253554916253e-13,
  5.042610842872093e-15, -1.110467659258676e-16,  8.773123660041140e-19,  4.272666559290026e-20,  1.340136473851858e+00,  5.760407708886126e-03, -5.242161143071927e-05,
  5.302086482511767e-07, -6.165186403043717e-09,  5.633048282262831e-11,  1.035610982298997e-12, -8.661181086693432e-14,  2.951492979520148e-15, -5.729518625956701e-17,
  1.387775316641494e-19,  3.530208614626683e-20,  1.503913548526218e+00,  4.316559994999309e-03, -3.889803379210819e-05,  3.835920560830741e-07, -4.259112212076018e-09,
  3.611562715726529e-11,  7.372742953727909e-13, -5.696119454684796e-14,  1.860729650978036e-15, -3.343058194459149e-17, -3.906875488444578e-20,  2.545999467438886e-20,
  1.635648741717739e+00,  3.163503952493600e-03, -2.833119031301897e-05,  2.750046390481013e-07, -2.966429661376691e-09,  2.411466803096906e-11,  5.087144503001390e-13,
 -3.784509544184754e-14,  1.204804920943995e-15, -2.053824171840586e-17, -7.635008048574456e-20,  1.771400181679907e-20,  1.742126813687691e+00,  2.235656171848724e-03,
 -1.993785059226634e-05,  1.914869936853350e-07, -2.025786203803872e-09,  1.605201965571936e-11,  3.405100108563765e-13, -2.482235651989872e-14,  7.768587956240278e-16,
 -1.275622414121293e-17, -7.137346479867476e-20,  1.193734533250652e-20,  1.827363536383527e+00,  1.495087993051230e-03, -1.329420240296624e-05,  1.267376805823268e-07,
 -1.322750222036563e-09,  1.031279964033904e-11,  2.176321083792745e-13, -1.568263364802900e-14,  4.850802634814348e-16, -7.750842653604246e-18, -5.422738202163265e-20,
  7.673488870919076e-21,  1.893919130536258e+00,  9.179899164989291e-04, -8.145737141764820e-06,  7.725174317963890e-08, -7.986219264434496e-10,  6.161487501253505e-12,
  1.289057386546819e-13, -9.226756316432794e-15,  2.830632926688166e-16, -4.434131869369245e-18, -3.562224679689548e-20,  4.566768486864585e-21,  1.943483503928918e+00,
  4.888130467964315e-04, -4.331220357022212e-06,  4.092835054208683e-08, -4.203410428433991e-10,  3.221168822097649e-12,  6.681302273380247e-14, -4.763704302652688e-15,
  1.453249765270189e-16, -2.244828869389394e-18, -1.970125238018614e-20,  2.375823896110337e-21,  1.977171042118249e+00,  1.973794070503191e-04, -1.747292768979413e-06,
  1.647294798782017e-08, -1.684646979539012e-10,  1.285662061735663e-12,  2.648716647991171e-14, -1.884416600225495e-15,  5.728074582375802e-17, -8.767338600581692e-19,
 -8.124938917332969e-21,  9.443363289596853e-22,  1.995684486561810e+00,  3.730499649143179e-05, -3.300774592518845e-07,  3.108029054362446e-09, -3.171349398567734e-11,
  2.415126229028092e-13,  4.955741596625662e-15, -3.522077171278598e-16,  1.068566797006722e-17, -1.627499004534575e-19, -1.551421944349532e-21,  1.769453610863195e-22,
  8.824641625717647e-01,  9.540087184873583e-03, -8.689928259665732e-05,  9.344602447937006e-07, -1.328453013952013e-08,  2.256626230126153e-10, -3.022803956007730e-12,
 -1.535392612339528e-14,  2.899524913270216e-15, -1.166712559825993e-16,  3.015665462656065e-18, -5.129865095669095e-20,  1.160585803011152e+00,  7.095379148109905e-03,
 -6.251156936911309e-05,  6.139283407228430e-07, -7.381660371499693e-09,  1.006023309610771e-10, -7.932867539685132e-13, -2.998909552500588e-14,  1.908804019620461e-15,
 -6.106563506104215e-17,  1.243652893870092e-18, -1.085957388023608e-20,  1.362377407108916e+00,  5.364898901755277e-03, -4.661125534405040e-05,  4.412728801092343e-07,
 -4.939071295872790e-09,  6.094437914750069e-11, -3.571878050392304e-13, -2.206677103538329e-14,  1.214977767344540e-15, -3.604113347815938e-17,  6.532236309772632e-19,
 -2.684863012636666e-21,  1.520585014951967e+00,  4.022688557355649e-03, -3.467807423722566e-05,  3.217509435511752e-07, -3.458889716417219e-09,  4.031825557888844e-11,
 -1.977779775521113e-13, -1.545240109176996e-14,  8.008364652781636e-16, -2.281808963086572e-17,  3.845785698866828e-19, -3.992067659021288e-22,  1.647869271643443e+00,
  2.949287247185755e-03, -2.529866219488835e-05,  2.317728550334086e-07, -2.428241328471873e-09,  2.728944386051052e-11, -1.199451642618027e-13, -1.062902058865635e-14,
  5.330811616103831e-16, -1.481172211923411e-17,  2.375115822465700e-19,  2.757042059850618e-22,  1.750764242468952e+00,  2.084820025873893e-03, -1.782298544881836e-05,
  1.618955297247270e-07, -1.666609276144697e-09,  1.826894986588331e-11, -7.494977707444494e-14, -7.123342755004846e-15,  3.501781511315954e-16, -9.566252334314451e-18,
  1.480120902770051e-19,  4.129048530337253e-22,  1.833140327469505e+00,  1.394474888987535e-03, -1.189294780032544e-05,  1.073864332112908e-07, -1.091871704711967e-09,
  1.176073570877827e-11, -4.618624445960151e-14, -4.564838225178024e-15,  2.215091880248151e-16, -5.979976006537183e-18,  9.013549762291541e-20,  3.614249069499196e-22,
  1.897466336142416e+00,  8.563249674395454e-04, -7.290972721435130e-06,  6.555637755559326e-08, -6.607275570405150e-10,  7.028954542673000e-12, -2.684834007415255e-14,
 -2.711544537224949e-15,  1.304458854366477e-16, -3.492270684372731e-18,  5.164377319588413e-20,  2.538594387877299e-22,  1.945372412669523e+00,  4.560187840712593e-04,
 -3.878127987014042e-06,  3.476853219086648e-08, -3.482942427406107e-10,  3.673474623930232e-12, -1.378994750328193e-14, -1.408950237632405e-15,  6.739518203970934e-17,
 -1.793894673326139e-18,  2.617211632328589e-20,  1.456558493446446e-22,  1.977933793082749e+00,  1.841480473509030e-04, -1.564870466589376e-06,  1.400316246717671e-08,
 -1.397245910640145e-10,  1.465508683047944e-12, -5.444967423080090e-15, -5.596059638543183e-16,  2.667263935184113e-17, -7.073180480388394e-19,  1.022836425280607e-20,
  6.132345914131864e-23,  1.995828649860307e+00,  3.480533115562780e-05, -2.956529178830538e-07,  2.642988536481708e-09, -2.631652244621572e-11,  2.752057211882947e-13,
 -1.017217796335892e-15, -1.048153096292715e-16,  4.986552137375198e-18, -1.319736265915876e-19,  1.899363134511327e-21,  1.182922837941298e-23,  9.193004603285519e-01,
  8.886450912113741e-03, -7.682494438916745e-05,  7.540721513223569e-07, -9.491159136830893e-09,  1.552892657684695e-10, -2.643093362703942e-12,  2.943574846916292e-14,
  3.799058992016679e-16, -3.515556352585696e-17,  1.227489050698198e-18, -2.898584272123232e-20,  1.188011150408672e+00,  6.622892543013637e-03, -5.579055348506534e-05,
  5.106995338004190e-07, -5.599800475859160e-09,  7.667480731850585e-11, -1.046142703967660e-12,  4.422599115104658e-15,  4.684061602567025e-16, -2.294321005192659e-17,
  6.550137212106592e-19, -1.251798905231004e-20,  1.383122980140600e+00,  5.011935369162105e-03, -4.175183088749091e-05,  3.713883807582433e-07, -3.837710118085425e-09,
  4.832308893498805e-11, -5.920646356976385e-13,  6.943145992127362e-16,  3.351942432919112e-16, -1.464766397559420e-17,  3.901169652642862e-19, -6.711809449095849e-21,
  1.536144122864183e+00,  3.759826249524876e-03, -3.112363737973361e-05,  2.724980156269450e-07, -2.722916235712121e-09,  3.261904462355444e-11, -3.748742175544411e-13,
 -1.670326435572472e-16,  2.330626613338363e-16, -9.677684860113987e-18,  2.481891322094560e-19, -3.997618494994304e-21,  1.659278377269074e+00,  2.757402647313020e-03,
 -2.273320020111082e-05,  1.970587135888207e-07, -1.927239452447615e-09,  2.233857738087032e-11, -2.461799899290126e-13, -3.408348000356015e-16,  1.599835066825919e-16,
 -6.453080894566868e-18,  1.615825401332646e-19, -2.487265371271439e-21,  1.758830054383134e+00,  1.949580686727304e-03, -1.602863120260884e-05,  1.380063696053326e-07,
 -1.330032437435315e-09,  1.506516882723494e-11, -1.612827780427927e-13, -3.160441021141317e-16,  1.071815262097439e-16, -4.244374698038338e-18,  1.045630280800588e-19,
 -1.557892087390595e-21,  1.838535704823556e+00,  1.304206185976750e-03, -1.070165240671178e-05,  9.170662706534384e-08, -8.747087338738475e-10,  9.745334632531481e-12,
 -1.022093209887693e-13, -2.374603029942690e-16,  6.870606029779941e-17, -2.687370579039528e-18,  6.545133088911029e-20, -9.521239628015003e-22,  1.900779722692651e+00,
  8.009745320170949e-04, -6.563253400037479e-06,  5.605568452985328e-08, -5.307448989435447e-10,  5.843323083200361e-12, -6.039606929512883e-14, -1.544024209070403e-16,
  4.083264489147032e-17, -1.583692601856999e-18,  3.825896901989783e-20, -5.469206295382643e-22,  1.947136953573094e+00,  4.265733293177488e-04, -3.492003221827370e-06,
  2.975587675308281e-08, -2.802970629088423e-10,  3.060402982841638e-12, -3.131267530483113e-14, -8.469154536329215e-17,  2.122782623102209e-17, -8.186303814345608e-19,
  1.966531662048267e-20, -2.776623143073568e-22,  1.978646360784575e+00,  1.722653914083903e-04, -1.409312821882911e-06,  1.199108462948123e-08, -1.125813951404903e-10,
  1.222568471995266e-12, -1.242689721527904e-14, -3.472251745392203e-17,  8.434593776983834e-18, -3.240930592881548e-19,  7.757068543614468e-21, -1.086387723079207e-22,
  1.995963332035802e+00,  3.256021904720468e-05, -2.662881602538131e-07,  2.263906192215825e-09, -2.121777084117857e-11,  2.297452644541020e-13, -2.327103152719102e-15,
 -6.608143334833103e-18,  1.580186389363954e-18, -6.060136494922281e-20,  1.447654684608300e-21, -2.018617267285389e-23, -2.007484323989538e+00,  4.782710746418396e-03,
 -1.338786187969941e-03,  3.863523921849904e-04, -1.149684507935907e-04,  3.530444288238727e-05, -1.120036234039148e-05,  3.674051670581701e-06, -1.245072459133795e-06,
  4.336883063206294e-07, -1.524094039086208e-07,  4.866338725091408e-08, -2.006484273445942e+00,  4.078844415779153e-03, -1.060049206163441e-03,  2.851886324525654e-04,
 -7.967363497243242e-05,  2.319250530523409e-05, -7.056798334548130e-06,  2.248325335576457e-06, -7.488633442922691e-07,  2.587385129172715e-07, -9.065889835028519e-08,
  2.891009354748002e-08, -2.005919237591981e+00,  3.689950730119467e-03, -9.175231930327555e-04,  2.372676864577092e-04, -6.412560362445122e-05,  1.820006179067712e-05,
 -5.445315017912765e-06,  1.719796404399757e-06, -5.715364051771516e-07,  1.978030260699517e-07, -6.950254577972344e-08,  2.220617077956051e-08, -2.005543712055479e+00,
  3.435014419901470e-03, -8.286056024819518e-04,  2.087520721521565e-04, -5.526389695434569e-05,  1.545864841911659e-05, -4.586581344741699e-06,  1.444225703176792e-06,
 -4.803260951976821e-07,  1.666656136436640e-07, -5.871295775372381e-08,  1.878718668124222e-08, -2.005275889447377e+00,  3.254917380045439e-03, -7.679699073773976e-04,
  1.899362065298414e-04, -4.958411889965839e-05,  1.374328397754129e-05, -4.058859375740007e-06,  1.276843007363591e-06, -4.252427660647610e-07,  1.478852442067035e-07,
 -5.219808270221631e-08,  1.671976290522040e-08, -2.005078304019252e+00,  3.122971190953057e-03, -7.246999907544150e-04,  1.768288205981708e-04, -4.570875273985408e-05,
  1.259203470402302e-05, -3.708794679643963e-06,  1.166558385392557e-06, -3.890401740886775e-07,  1.355368341182076e-07, -4.790726831240376e-08,  1.535611831807589e-08,
 -2.004930860052898e+00,  3.025018354511653e-03, -6.932126014121515e-04,  1.674608369240441e-04, -4.298073302890626e-05,  1.179105951473092e-05, -3.467146955083618e-06,
  1.090741728379655e-06, -3.641774599439140e-07,  1.270484413200432e-07, -4.495306733552696e-08,  1.441611922184724e-08, -2.004821751097164e+00,  2.952813288211493e-03,
 -6.703497995079707e-04,  1.607497641137319e-04, -4.104812421888549e-05,  1.122836686743505e-05, -3.298300637443039e-06,  1.037901937442298e-06, -3.468552463639829e-07,
  1.211286436931639e-07, -4.289010914032198e-08,  1.375909338061611e-08, -2.004743685433900e+00,  2.901298112635736e-03, -6.542191914532195e-04,  1.560612918454663e-04,
 -3.970882308729228e-05,  1.084073045434675e-05, -3.182411368274232e-06,  1.001693086824806e-06, -3.349853358584358e-07,  1.170686955918938e-07, -4.147384998107689e-08,
  1.330772420222268e-08, -2.004692099923490e+00,  2.867324073408803e-03, -6.436637926353401e-04,  1.530142263631866e-04, -3.884322092963009e-05,  1.059120382318307e-05,
 -3.107992991460012e-06,  9.784644603657027e-07, -3.273699228969594e-07,  1.144622528669416e-07, -4.056397189787438e-08,  1.301760433785910e-08, -2.004664240532264e+00,
  2.848998150403316e-03, -6.379974293562824e-04,  1.513853556108078e-04, -3.838205873429235e-05,  1.045858721345035e-05, -3.068498495854011e-06,  9.661436405012879e-07,
 -3.233302205743238e-07,  1.130790489270150e-07, -4.008089556248177e-08,  1.286352834499380e-08, -2.002284595686121e+00,  1.378807550507290e-03, -2.856958434082565e-04,
  5.945920112064242e-05, -1.242763446949404e-05,  2.608264669546329e-06, -5.496030793467346e-07,  1.162580705124475e-07, -2.468404081055044e-08,  5.259421616906748e-09,
 -1.122338643539417e-09,  2.301138139973529e-10, -2.002165410201903e+00,  1.300595214861842e-03, -2.619296163364754e-04,  5.297940461574954e-05, -1.076260023430226e-05,
  2.195941814484725e-06, -4.500097377533101e-07,  9.262379046096908e-08, -1.914791971562199e-08,  3.975431773322483e-09, -8.274810798418698e-10,  1.659424016368273e-10,
 -2.002086402169437e+00,  1.249133416167145e-03, -2.467701277948413e-04,  4.897430969900763e-05, -9.765459780040247e-06,  1.956677852046593e-06, -3.940015855566310e-07,
  7.973951527321869e-08, -1.622125186060558e-08,  3.316900894044094e-09, -6.806554697721389e-10,  1.348239185146094e-10, -2.002028407424117e+00,  1.211553858699110e-03,
 -2.359409160417004e-04,  4.617580987165912e-05, -9.083868296873652e-06,  1.796645362762393e-06, -3.573332127371174e-07,  7.147932461132312e-08, -1.438300011726470e-08,
  2.911434311375015e-09, -5.919686836671975e-10,  1.163447463273214e-10, -2.001984065909128e+00,  1.182932793071801e-03, -2.278301094118427e-04,  4.411451782921978e-05,
 -8.590039570777726e-06,  1.682559706945793e-06, -3.316026150201234e-07,  6.577142085805290e-08, -1.313147489088850e-08,  2.639298665408410e-09, -5.332477294295301e-10,
  1.042546115224929e-10, -2.001949634088187e+00,  1.160774703731671e-03, -2.216322972622928e-04,  4.255968966490601e-05, -8.222258894993614e-06,  1.598643008946555e-06,
 -3.129029604637053e-07,  6.167115512186937e-08, -1.224240834653771e-08,  2.448018550316896e-09, -4.923836101759384e-10,  9.591389879891020e-11, -2.001922932100940e+00,
  1.143631087731671e-03, -2.168859633801870e-04,  4.138099152456813e-05, -7.946196115642838e-06,  1.536256314401329e-06, -2.991292978239322e-07,  5.867773760346217e-08,
 -1.159881065731535e-08,  2.310652731398150e-09, -4.632552226247213e-10,  9.000667581708258e-11, -2.001902592970256e+00,  1.130596117906889e-03, -2.133057226010525e-04,
  4.049881869980039e-05, -7.741153443937597e-06,  1.490259926796024e-06, -2.890459667993377e-07,  5.650109123860134e-08, -1.113380438885640e-08,  2.211997809071049e-09,
 -4.424511347199612e-10,  8.580762686936159e-11, -2.001887727985959e+00,  1.121082259199086e-03, -2.107082117192484e-04,  3.986254744624917e-05, -7.594108622313208e-06,
  1.457455217239089e-06, -2.818923267491954e-07,  5.496457482567649e-08, -1.080709528043954e-08,  2.142987839397986e-09, -4.279571592597831e-10,  8.289224977036652e-11,
 -2.001877758701511e+00,  1.114707806991327e-03, -2.089752078968892e-04,  3.943980496669378e-05, -7.496804680991385e-06,  1.435831432229408e-06, -2.771943069739700e-07,
  5.395902566244373e-08, -1.059398726901905e-08,  2.098110778016123e-09, -4.185580270222417e-10,  8.100614129339309e-11, -2.001872325394650e+00,  1.111235752140514e-03,
 -2.080337609726600e-04,  3.921074541907460e-05, -7.444213210724217e-06,  1.424172125847325e-06, -2.746669777897174e-07,  5.341925215906122e-08, -1.047982315858544e-08,
  2.074114673835368e-09, -4.135408109171042e-10,  8.000079646841359e-11, -2.000950004179824e+00,  5.638077213026965e-04, -1.054245035622842e-04,  1.973182131345992e-05,
 -3.696589425806978e-06,  6.931656036902869e-07, -1.300971581087008e-07,  2.443919374123021e-08, -4.595014023823437e-09,  8.646560985348586e-10, -1.626505064797375e-10,
  2.960473004757904e-11, -2.000927430609020e+00,  5.493180919183376e-04, -1.014193813537085e-04,  1.874159817953542e-05, -3.466416769039123e-06,  6.417164987246766e-07,
 -1.189032156771171e-07,  2.205116540128800e-08, -4.093134323862062e-09,  7.604138594835391e-10, -1.412347333052070e-10,  2.540368289474578e-11, -2.000911658751543e+00,
  5.392263663714540e-04, -9.866897957681282e-05,  1.807124492871071e-05, -3.312821570689212e-06,  6.078761146314424e-07, -1.116461070949814e-07,  2.052522053655558e-08,
 -3.777038732758570e-09,  6.957012667775997e-10, -1.281293620534992e-10,  2.286679869002807e-11, -2.000899646899317e+00,  5.315581468078539e-04, -9.660057799199539e-05,
  1.757234952993521e-05, -3.199701310759718e-06,  5.832124492774087e-07, -1.064118499486341e-07,  1.943600548749079e-08, -3.553735662247884e-09,  6.504543174937699e-10,
 -1.190590428255645e-10,  2.112747609538856e-11, -2.000890203822129e+00,  5.255405073931014e-04, -9.499041717053462e-05,  1.718711650454040e-05, -3.113057816153688e-06,
  5.644734416070040e-07, -1.024667792645301e-07,  1.862159125851840e-08, -3.388088954338965e-09,  6.171529558097846e-10, -1.124349383762507e-10,  1.986629866270589e-11,
 -2.000882711151521e+00,  5.207724754738700e-04, -9.372275632529145e-05,  1.688577010212332e-05, -3.045714450071154e-06,  5.500011461975240e-07, -9.943918497915211e-08,
  1.800048832505494e-08, -3.262543113463276e-09,  5.920680855054132e-10, -1.074752868251236e-10,  1.892726589928870e-11, -2.000876801794360e+00,  5.170161824209128e-04,
 -9.272915461581946e-05,  1.665077515641792e-05, -2.993465131920551e-06,  5.388290951613177e-07, -9.711364998250676e-08,  1.752576436864669e-08, -3.167053279176807e-09,
  5.730804306617504e-10, -1.037388802355150e-10,  1.822291072848311e-11, -2.000872241538500e+00,  5.141199687346173e-04, -9.196611184331673e-05,  1.647102945076022e-05,
 -2.953658593149856e-06,  5.303510477903555e-07, -9.535575389224231e-08,  1.716829466643162e-08, -3.095421591818650e-09,  5.588900663092926e-10, -1.009567110806314e-10,
  1.770020461045478e-11, -2.000868875856066e+00,  5.119838355948805e-04, -9.140502620826661e-05,  1.633925800293499e-05, -2.924564216872963e-06,  5.241729403922362e-07,
 -9.407851194636803e-08,  1.690932041011593e-08, -3.043675404442924e-09,  5.486679090629443e-10, -9.895806928315604e-11,  1.732565460276830e-11, -2.000866602955625e+00,
  5.105419463844689e-04, -9.102711200772358e-05,  1.625069616302951e-05, -2.905052160929159e-06,  5.200383902660156e-07, -9.322553640399849e-08,  1.673672725606752e-08,
 -3.009259206960428e-09,  5.418827539669930e-10, -9.763401847196282e-11,  1.707796817276574e-11, -2.000865358871921e+00,  5.097529518655715e-04, -9.082059855914633e-05,
  1.620236629589751e-05, -2.894418304090910e-06,  5.177880845375103e-07, -9.276189413009651e-08,  1.664303328412714e-08, -2.990599633648578e-09,  5.382085846642223e-10,
 -9.691791250000284e-11,  1.694415709959004e-11, -2.000437235572406e+00,  2.577058495241112e-04, -4.607844086228440e-05,  8.240792508265360e-06, -1.474134536995317e-06,
  2.637554423996903e-07, -4.720207910418527e-08,  8.449196760633937e-09, -1.512735902596357e-09,  2.708883764120815e-10, -4.847189687455292e-11,  8.413688282045773e-12,
 -2.000432255744848e+00,  2.545390128224810e-04, -4.523913790365967e-05,  8.041998906300254e-06, -1.429892457133751e-06,  2.542918038737361e-07, -4.523253332988801e-08,
  8.047462203823470e-09, -1.432042788153065e-09,  2.548762652581151e-10, -4.532961627177254e-11,  7.823183089058687e-12, -2.000428697279081e+00,  2.522793846438024e-04,
 -4.464429739239047e-05,  7.902066049586910e-06, -1.398963001292129e-06,  2.477212055248876e-07, -4.387448085796528e-08,  7.772363376913814e-09, -1.377166891564043e-09,
  2.440622377419816e-10, -4.322200633626462e-11,  7.429657300232113e-12, -2.000425942336664e+00,  2.505318929914600e-04, -4.418657651090405e-05,  7.794933870357134e-06,
 -1.375403587055777e-06,  2.427417032844032e-07, -4.285051499069669e-08,  7.565993651970892e-09, -1.336209861607922e-09,  2.360320387102550e-10, -4.166484377096498e-11,
  7.140277297176838e-12, -2.000423748809823e+00,  2.491416983337474e-04, -4.382387692612628e-05,  7.710379301426399e-06, -1.356883274497343e-06,  2.388428565150391e-07,
 -4.205196216037078e-08,  7.405693238353242e-09, -1.304522153014614e-09,  2.298438069853845e-10, -4.046957866054986e-11,  6.918965704794130e-12, -2.000421990702642e+00,
  2.480282183041397e-04, -4.353428897176951e-05,  7.643083719963301e-06, -1.342190225577806e-06,  2.357595612886970e-07, -4.142245516554295e-08,  7.279727344923465e-09,
 -1.279700276691352e-09,  2.250116554733064e-10, -3.953915776482777e-11,  6.747193476214298e-12, -2.000420592967276e+00,  2.471434575010849e-04, -4.330476702039445e-05,
  7.589882323268718e-06, -1.330604038175382e-06,  2.333344161776534e-07, -4.092857658506247e-08,  7.181150866936141e-09, -1.260324470965221e-09,  2.212491661047040e-10,
 -3.881649871205187e-11,  6.614086716514967e-12, -2.000419507552164e+00,  2.464566881740307e-04, -4.312696277462074e-05,  7.548751400435559e-06, -1.321664530980468e-06,
  2.314670030758595e-07, -4.054903841881058e-08,  7.105546890973267e-09, -1.245493450526802e-09,  2.183748747566138e-10, -3.826551169474221e-11,  6.512784553240022e-12,
 -2.000418702647897e+00,  2.459475710527557e-04, -4.299535311656288e-05,  7.518353109606793e-06, -1.315067784771325e-06,  2.300910805729914e-07, -4.026981683136027e-08,
  7.050010054655815e-09, -1.234615332120782e-09,  2.162698198558258e-10, -3.786258091402702e-11,  6.438805515449973e-12, -2.000418157239045e+00,  2.456026700027916e-04,
 -4.290629126864424e-05,  7.497804722368057e-06, -1.310613443800485e-06,  2.291630243378043e-07, -4.008168686266021e-08,  7.012631618416794e-09, -1.227301797726590e-09,
  2.148560676992628e-10, -3.759225885824927e-11,  6.389222528812443e-12, -2.000417858074905e+00,  2.454135146647801e-04, -4.285748003559961e-05,  7.486550685642248e-06,
 -1.308175537965911e-06,  2.286554359497964e-07, -3.997886140843431e-08,  6.992215621770576e-09, -1.223309846423840e-09,  2.140849130096472e-10, -3.744490445600916e-11,
  6.362211095783635e-12, -2.000210152840758e+00,  1.234730443712998e-04, -2.161765390577863e-05,  3.785024656403957e-06, -6.627542544725907e-07,  1.160539432568759e-07,
 -2.032313729992965e-08,  3.559139167663074e-09, -6.233358617773856e-10,  1.091718469504196e-10, -1.910459515856688e-11,  3.246815584454286e-12, -2.000208980038337e+00,
  1.227304296547459e-04, -2.142472552064376e-05,  3.740243690406025e-06, -6.529894185539665e-07,  1.140076498300887e-07, -1.990597428202253e-08,  3.475797457352037e-09,
 -6.069413260615649e-10,  1.059861066155339e-10, -1.849237416357769e-11,  3.134004531539902e-12, -2.000208133154452e+00,  1.221945646677103e-04, -2.128596857710112e-05,
  3.708143837228618e-06, -6.460132244404189e-07,  1.125506430293471e-07, -1.960994347375285e-08,  3.416854892748540e-09, -5.953855334387800e-10,  1.037481890646104e-10,
 -1.806374608226548e-11,  3.055271713955716e-12, -2.000207472386407e+00,  1.217766851073719e-04, -2.117802973759074e-05,  3.683235629118453e-06, -6.406135183645888e-07,
  1.114257189267783e-07, -1.938195778736484e-08,  3.371574707915537e-09, -5.865305618277410e-10,  1.020376223694365e-10, -1.773694005879610e-11,  2.995382542848718e-12,
 -2.000206943050466e+00,  1.214420647788529e-04, -2.109176557387731e-05,  3.663368340186274e-06, -6.363151183222802e-07,  1.105320031248455e-07, -1.920118918597569e-08,
  3.335743379014535e-09, -5.795372714551537e-10,  1.006893588946640e-10, -1.747985927555386e-11,  2.948357666732169e-12, -2.000206516711100e+00,  1.211726441427628e-04,
 -2.102241876811455e-05,  3.647422549667321e-06, -6.328706379156143e-07,  1.098169715381960e-07, -1.905679231399828e-08,  3.307167004949732e-09, -5.739688024059881e-10,
  9.961749420625055e-11, -1.727580315563636e-11,  2.911087040161203e-12, -2.000206176434601e+00,  1.209576678239876e-04, -2.096715531327704e-05,  3.634731289424210e-06,
 -6.301326710868582e-07,  1.092493285928830e-07, -1.894230598011448e-08,  3.284538837342311e-09, -5.695650266699629e-10,  9.877089587210993e-11, -1.711483556760419e-11,
  2.881721204193445e-12, -2.000205911377375e+00,  1.207902482989672e-04, -2.092416009112208e-05,  3.624867358110429e-06, -6.280068061875419e-07,  1.088090324506063e-07,
 -1.885359327802010e-08,  3.267022445735652e-09, -5.661595002181604e-10,  9.811686061623410e-11, -1.699060467396216e-11,  2.859078462372714e-12, -2.000205714359065e+00,
  1.206658247319974e-04, -2.089223106294255e-05,  3.617547850452418e-06, -6.264305268373843e-07,  1.084828142736014e-07, -1.878791599223135e-08,  3.254064365348531e-09,
 -5.636421274096578e-10,  9.763376572035269e-11, -1.689891275254108e-11,  2.842378246698827e-12, -2.000205580634057e+00,  1.205813827730363e-04, -2.087057376564334e-05,
  3.612585796385431e-06, -6.253625213996004e-07,  1.082619074286349e-07, -1.874346543040974e-08,  3.245299117793681e-09, -5.619402314793121e-10,  9.730734295247736e-11,
 -1.683699100726014e-11,  2.831105917599179e-12, -2.000205507207089e+00,  1.205350199689131e-04, -2.085868690708822e-05,  3.609863254089607e-06, -6.247767385179328e-07,
  1.081407855704288e-07, -1.871910185882327e-08,  3.240496494602435e-09, -5.610080547024718e-10,  9.712861311542676e-11, -1.680309783998952e-11,  2.824937914410136e-12,
 -2.000103067867281e+00,  6.046478553256332e-05, -1.047859307791159e-05,  1.815972599973189e-06, -3.147179064054995e-07,  5.454305386111935e-08, -9.452860969687170e-09,
  1.638297968186425e-09, -2.839409184807934e-10,  4.921050075715241e-11, -8.521664536638525e-12,  1.433911818319782e-12, -2.000102783104218e+00,  6.028484875035681e-05,
 -1.043229846050687e-05,  1.805332252923780e-06, -3.124205463391482e-07,  5.406638613758766e-08, -9.356650390925562e-09,  1.619268095133485e-09, -2.802348163183502e-10,
  4.849754368447403e-11, -8.386019142144165e-12,  1.409151191178895e-12, -2.000102576431782e+00,  6.015430142276109e-05, -1.039876568032966e-05,  1.797637787702732e-06,
 -3.107619827698801e-07,  5.372283018280308e-08, -9.287422332767602e-09,  1.605597984472380e-09, -2.775769706450486e-10,  4.798709548064261e-11, -8.289063729686800e-12,
  1.391480537732211e-12, -2.000102414566971e+00,  6.005208405148389e-05, -1.037254198383638e-05,  1.791627917944599e-06, -3.094681478982958e-07,  5.345515799422230e-08,
 -9.233552409057406e-09,  1.594973831255305e-09, -2.755139198332283e-10,  4.759137393025650e-11, -8.213993071163285e-12,  1.377814428373569e-12, -2.000102284509706e+00,
  5.996997004838394e-05, -1.035149623909324e-05,  1.786809447361312e-06, -3.084318247834474e-07,  5.324097201187895e-08, -9.190489310825560e-09,  1.586489371359570e-09,
 -2.738679922507973e-10,  4.727597403658457e-11, -8.154218696990263e-12,  1.366942925111411e-12, -2.000102179506295e+00,  5.990368526877908e-05, -1.033452081200669e-05,
  1.782925957135327e-06, -3.075972532019312e-07,  5.306862079386449e-08, -9.155864828017331e-09,  1.579672942724469e-09, -2.725467023007118e-10,  4.702298375041772e-11,
 -8.106310054486900e-12,  1.358235963226283e-12, -2.000102095537367e+00,  5.985068586709592e-05, -1.032095629923284e-05,  1.779824759060355e-06, -3.069312232241708e-07,
  5.293116372133365e-08, -9.128268044108923e-09,  1.574243509025140e-09, -2.714949382319045e-10,  4.682172869586079e-11, -8.068222689744530e-12,  1.351318047637302e-12,
 -2.000102030030182e+00,  5.980934349754603e-05, -1.031038052869968e-05,  1.777408081142004e-06, -3.064124664139498e-07,  5.282415537582433e-08, -9.106795203132866e-09,
  1.570021043681010e-09, -2.706773953891689e-10,  4.666537080391108e-11, -8.038646933488408e-12,  1.345948645639302e-12, -2.000101981281609e+00,  5.977858017485358e-05,
 -1.030251397916835e-05,  1.775611181040935e-06, -3.060268980736257e-07,  5.274465165847248e-08, -9.090847743646132e-09,  1.566886312062852e-09, -2.700706909626123e-10,
  4.654938122144427e-11, -8.016715428497454e-12,  1.341968468054724e-12, -2.000101948166187e+00,  5.975768353440133e-05, -1.029717191853905e-05,  1.774391268460456e-06,
 -3.057652087286351e-07,  5.269070657126295e-08, -9.080030023062299e-09,  1.564760502011731e-09, -2.696593696830344e-10,  4.647076665017498e-11, -8.001854936833985e-12,
  1.339272247375757e-12, -2.000101929973358e+00,  5.974620383127572e-05, -1.029423772612430e-05,  1.773721332298816e-06, -3.056215223927333e-07,  5.266109196341488e-08,
 -9.074092374264554e-09,  1.563593886089462e-09, -2.694336812116351e-10,  4.642763897128313e-11, -7.993703926401938e-12,  1.337793603179967e-12, -2.000051044470689e+00,
  2.992304632317862e-05, -5.159647416181467e-06,  8.896838355244034e-07, -1.534097026167500e-07,  2.645278534817347e-08, -4.561329415234997e-09,  7.865256804408649e-10,
 -1.356236738067301e-10,  2.338561521234360e-11, -4.029042890307594e-12,  6.746894822508770e-13, -2.000050974300740e+00,  2.987875238060923e-05, -5.148305933420865e-06,
  8.870897271043952e-07, -1.528523320673679e-07,  2.633770348502472e-08, -4.538214865671909e-09,  7.819761548575109e-10, -1.347419920183055e-10,  2.321683577089469e-11,
 -3.997088584479835e-12,  6.688833614736318e-13, -2.000050923246475e+00,  2.984653053351952e-05, -5.140062211634810e-06,  8.852057075727283e-07, -1.524478646186728e-07,
  2.625426086534726e-08, -4.521469004527361e-09,  7.786828734537759e-10, -1.341042940325381e-10,  2.309486295178247e-11, -3.974015022182370e-12,  6.646941198562756e-13,
 -2.000050883186201e+00,  2.982125058860506e-05, -5.133598472526253e-06,  8.837293959482625e-07, -1.521311214313595e-07,  2.618895650725802e-08, -4.508371397979485e-09,
  7.761086672908985e-10, -1.336061448325742e-10,  2.299964094312019e-11, -3.956013057003423e-12,  6.614275762313426e-13, -2.000050850950311e+00,  2.980091029266794e-05,
 -5.128400255219713e-06,  8.825427093310060e-07, -1.518766424847121e-07,  2.613651527185530e-08, -4.497858834034932e-09,  7.740435445062878e-10, -1.332067083143184e-10,
  2.292332567052397e-11, -3.941592543149089e-12,  6.588121088412258e-13, -2.000050824893162e+00,  2.978447003762848e-05, -5.124200384799794e-06,  8.815843110405948e-07,
 -1.516712002519569e-07,  2.609419598267491e-08, -4.489378723128814e-09,  7.723783456044951e-10, -1.328847531994849e-10,  2.286183823553267e-11, -3.929978491397720e-12,
  6.567064345924549e-13, -2.000050804035815e+00,  2.977131137474617e-05, -5.120839896540288e-06,  8.808177010289230e-07, -1.515069221625262e-07,  2.606036695512106e-08,
 -4.482602092638270e-09,  7.710480766206576e-10, -1.326276368210730e-10,  2.281274949481617e-11, -3.920709318393737e-12,  6.550263978177960e-13, -2.000050787751883e+00,
  2.976103856914749e-05, -5.118217058791890e-06,  8.802195178032695e-07, -1.513787688912857e-07,  2.603398361938827e-08, -4.477318320807596e-09,  7.700111220149585e-10,
 -1.324272634291171e-10,  2.277450382552161e-11, -3.913489406081170e-12,  6.537180984349133e-13, -2.000050775626806e+00,  2.975338970847825e-05, -5.116264535257355e-06,
  8.797742969802248e-07, -1.512834043275921e-07,  2.601435440137693e-08, -4.473387952400933e-09,  7.692399258831487e-10, -1.322782720829664e-10,  2.274607105434862e-11,
 -3.908122979892049e-12,  6.527458395308660e-13, -2.000050767386684e+00,  2.974819174386581e-05, -5.114937833022570e-06,  8.794718197371953e-07, -1.512186238552856e-07,
  2.600102226215536e-08, -4.470718821807885e-09,  7.687162758724847e-10, -1.321771194865924e-10,  2.272677027152658e-11, -3.904480636274937e-12,  6.520860256287916e-13,
 -2.000050762858575e+00,  2.974533541182615e-05, -5.114208859763434e-06,  8.793056341881454e-07, -1.511830355797332e-07,  2.599369865729086e-08, -4.469252743744445e-09,
  7.684286747398467e-10, -1.321215688912962e-10,  2.271617166346980e-11, -3.902480695097342e-12,  6.517237638411744e-13, -2.000025401408064e+00,  1.488522697126412e-05,
 -2.560261516262419e-06,  4.403657743788667e-07, -7.574311286972994e-08,  1.302786061965918e-08, -2.240801667987926e-09,  3.854198580292450e-10, -6.629256198581636e-11,
  1.140211169148802e-11, -1.959512403762434e-12,  3.273543470596674e-13, -2.000025383991133e+00,  1.487423829936017e-05, -2.557454567136020e-06,  4.397252931199138e-07,
 -7.560583156586034e-08,  1.299958443843676e-08, -2.235136092076995e-09,  3.843074395795731e-10, -6.607750363026663e-11,  1.136104349015219e-11, -1.951755990487117e-12,
  3.259482077555366e-13, -2.000025371303253e+00,  1.486623396111193e-05, -2.555410764605861e-06,  4.392591350500102e-07, -7.550595586664426e-08,  1.297902124917800e-08,
 -2.231017632253041e-09,  3.834991260243656e-10, -6.592130083344796e-11,  1.133122683401426e-11, -1.946126933145935e-12,  3.249281244179359e-13, -2.000025361338319e+00,
  1.485994783946565e-05, -2.553806175174028e-06,  4.388932669652254e-07, -7.542759180450210e-08,  1.296289203915624e-08, -2.227788224975167e-09,  3.828654998448826e-10,
 -6.579889355037671e-11,  1.130786846164717e-11, -1.941718492009573e-12,  3.241294696067216e-13, -2.000025353313775e+00,  1.485488602169289e-05, -2.552514413130028e-06,
  4.385987997535651e-07, -7.536453633502633e-08,  1.294991689715981e-08, -2.225190967971983e-09,  3.823560302927736e-10, -6.570049575843271e-11,  1.128909632782664e-11,
 -1.938176484153658e-12,  3.234879297694648e-13, -2.000025346823458e+00,  1.485079215153134e-05, -2.551469872750317e-06,  4.383607356153992e-07, -7.531356878174478e-08,
  1.293943120829697e-08, -2.223092446046156e-09,  3.819444728062085e-10, -6.562102428163503e-11,  1.127393793238249e-11, -1.935316898356937e-12,  3.229700885530500e-13,
 -2.000025341625821e+00,  1.484751376879572e-05, -2.550633533476172e-06,  4.381701534592691e-07, -7.527277323313219e-08,  1.293103957366329e-08, -2.221413279973095e-09,
  3.816152111574950e-10, -6.555745425282363e-11,  1.126181452092759e-11, -1.933030217669749e-12,  3.225560563725112e-13, -2.000025337566338e+00,  1.484495333803534e-05,
 -2.549980430373952e-06,  4.380213452686183e-07, -7.524092374071180e-08,  1.292448896970857e-08, -2.220102670162493e-09,  3.813582509514619e-10, -6.550784963848303e-11,
  1.125235564636865e-11, -1.931246338926499e-12,  3.222331010066550e-13, -2.000025334542755e+00,  1.484304631734563e-05, -2.549494042548162e-06,  4.379105334803545e-07,
 -7.521720892996949e-08,  1.291961192837089e-08, -2.219126992379170e-09,  3.811669765898415e-10, -6.547092886035716e-11,  1.124531607658663e-11, -1.929918852628535e-12,
  3.219927931895469e-13, -2.000025332487521e+00,  1.484175006805377e-05, -2.549163455281305e-06,  4.378352223094559e-07, -7.520109271701131e-08,  1.291629779778727e-08,
 -2.218464029190637e-09,  3.810370166310753e-10, -6.544584505349177e-11,  1.124053375777262e-11, -1.929017089679863e-12,  3.218295624134139e-13, -2.000025331357982e+00,
  1.484103766717498e-05, -2.548981776833619e-06,  4.377938358874177e-07, -7.519223661514359e-08,  1.291447671238416e-08, -2.218099752664986e-09,  3.809656110097940e-10,
 -6.543206352624152e-11,  1.123790637413536e-11, -1.928521686830167e-12,  3.217398917296885e-13, -2.000012670686737e+00,  7.423667493884813e-06, -1.275283155164020e-06,
  2.190760114102771e-07, -3.763423720872990e-08,  6.465044237416381e-09, -1.110605894136662e-09,  1.907868898436714e-10, -3.277455945437530e-11,  5.630082710108033e-12,
 -9.663543143432263e-13,  1.612480569546823e-13, -2.000012666348073e+00,  7.420930837525510e-06, -1.274584933862369e-06,  2.189168845345674e-07, -3.760017090900292e-08,
  6.458035986394007e-09, -1.109203378973600e-09,  1.905118435537825e-10, -3.272145051196296e-11,  5.619953151016057e-12, -9.644434875877551e-13,  1.609020405160359e-13,
 -2.000012663185500e+00,  7.418936097286065e-06, -1.274076105425142e-06,  2.188009445775938e-07, -3.757535526676596e-08,  6.452931865196332e-09, -1.108182134875784e-09,
  1.903116092963694e-10, -3.268279505666378e-11,  5.612581848806274e-12, -9.630532600760208e-13,  1.606503437018741e-13, -2.000012660700496e+00,  7.417368773136945e-06,
 -1.273676365307141e-06,  2.187098751259463e-07, -3.755586588498515e-08,  6.448923877832039e-09, -1.107380331890142e-09,  1.901544249887683e-10, -3.265245514853550e-11,
  5.606797155461953e-12, -9.619624354597011e-13,  1.604528815517977e-13, -2.000012658698640e+00,  7.416106209109876e-06, -1.273354392058997e-06,  2.186365316111115e-07,
 -3.754017187972601e-08,  6.445696805482239e-09, -1.106734831371171e-09,  1.900278975710991e-10, -3.262803567887447e-11,  5.602141843258373e-12, -9.610846869077676e-13,
  1.602940089223323e-13, -2.000012657079042e+00,  7.415084755044309e-06, -1.273093930993054e-06,  2.185772060413029e-07, -3.752747868335825e-08,  6.443087031910839e-09,
 -1.106212858902343e-09,  1.899255935999804e-10, -3.260829323536425e-11,  5.598378530482896e-12, -9.603751930701751e-13,  1.601656023469005e-13, -2.000012655781710e+00,
  7.414266562611899e-06, -1.272885316118026e-06,  2.185296933227057e-07, -3.751731375481745e-08,  6.440997247612550e-09, -1.105794921253991e-09,  1.898436864843441e-10,
 -3.259248820720236e-11,  5.595366010659369e-12, -9.598072908092760e-13,  1.600628291759284e-13, -2.000012654768270e+00,  7.413627421458905e-06, -1.272722364178664e-06,
  2.184925828220383e-07, -3.750937479091488e-08,  6.439365197569583e-09, -1.105468546928358e-09,  1.897797279369496e-10, -3.258014736811717e-11,  5.593013932305824e-12,
 -9.593639190378297e-13,  1.599825970182054e-13, -2.000012654013331e+00,  7.413151312403440e-06, -1.272600983801518e-06,  2.184649411157601e-07, -3.750346175025482e-08,
  6.438149684946440e-09, -1.105225482765347e-09,  1.897320977303099e-10, -3.257095753794337e-11,  5.591262499404648e-12, -9.590337861678870e-13,  1.599228591783317e-13,
 -2.000012653500119e+00,  7.412827653304429e-06, -1.272518472201503e-06,  2.184461515659321e-07, -3.749944247882946e-08,  6.437323493188786e-09, -1.105060276232989e-09,
  1.896997254241187e-10, -3.256471180307289e-11,  5.590072204846892e-12, -9.588094317326640e-13,  1.598822633609742e-13, -2.000012653218044e+00,  7.412649762297613e-06,
 -1.272473122768008e-06,  2.184358248120583e-07, -3.749723353158515e-08,  6.436869437202459e-09, -1.104969484502613e-09,  1.896819351253536e-10, -3.256127951549985e-11,
  5.589418103425775e-12, -9.586861451357123e-13,  1.598599557201650e-13, -2.000006327862564e+00,  3.707113133257524e-06, -6.364349949353058e-07,  1.092627900181900e-07,
 -1.875817325984409e-08,  3.220392617509801e-09, -5.528752187244739e-10,  9.491731390449653e-11, -1.629534158552812e-11,  2.797506126653470e-12, -4.798694691467788e-13,
  8.002509793457865e-14, -2.000006326779836e+00,  3.706430277538867e-06, -6.362608768364557e-07,  1.092231317200271e-07, -1.874968821371513e-08,  3.218648093011056e-09,
 -5.525263091808270e-10,  9.484893081463821e-11, -1.628214541025917e-11,  2.794990718898805e-12, -4.793952515984128e-13,  7.993927414168402e-14, -2.000006325990364e+00,
  3.705932382659421e-06, -6.361339338375313e-07,  1.091942212867174e-07, -1.874350334841169e-08,  3.217376615946312e-09, -5.522720365164625e-10,  9.479910081559164e-11,
 -1.627253049313994e-11,  2.793158146377225e-12, -4.790498010559091e-13,  7.987676058530630e-14, -2.000006325369889e+00,  3.705541075741203e-06, -6.360341740356367e-07,
  1.091715033935226e-07, -1.873864364021437e-08,  3.216377640292177e-09, -5.520722747199141e-10,  9.475995638286714e-11, -1.626497798821184e-11,  2.791718774588976e-12,
 -4.787784920727511e-13,  7.982766741716521e-14, -2.000006324869959e+00,  3.705225795005284e-06, -6.359538012114757e-07,  1.091532015353851e-07, -1.873472883013072e-08,
  3.215572950057662e-09, -5.519113734201063e-10,  9.472842882054907e-11, -1.625889545251986e-11,  2.790559623915331e-12, -4.785600157164424e-13,  7.978813654945340e-14,
 -2.000006324465431e+00,  3.704970682507329e-06, -6.358887699273044e-07,  1.091383938602852e-07, -1.873156159069549e-08,  3.214921955449127e-09, -5.517812106890901e-10,
  9.470292554774976e-11, -1.625397541285502e-11,  2.789622057067215e-12, -4.783833121583292e-13,  7.975616548973122e-14, -2.000006324141357e+00,  3.704766309363469e-06,
 -6.358366747712765e-07,  1.091265322229101e-07, -1.872902458555645e-08,  3.214400520071758e-09, -5.516769567712718e-10,  9.468249950351470e-11, -1.625003501959496e-11,
  2.788871202517515e-12, -4.782418039768721e-13,  7.973056330405642e-14, -2.000006323888176e+00,  3.704606644594777e-06, -6.357959771446619e-07,  1.091172660005387e-07,
 -1.872704275872736e-08,  3.213993204415417e-09, -5.515955221212298e-10,  9.466654485107811e-11, -1.624695730126338e-11,  2.788284752040849e-12, -4.781312833458303e-13,
  7.971056809359310e-14, -2.000006323699560e+00,  3.704487697897310e-06, -6.357656590419812e-07,  1.091103632020328e-07, -1.872556644831793e-08,  3.213689792548926e-09,
 -5.515348624347967e-10,  9.465466071172619e-11, -1.624466485736580e-11,  2.787847943979494e-12, -4.780489658488700e-13,  7.969567568541513e-14, -2.000006323571331e+00,
  3.704406833400849e-06, -6.357450479932258e-07,  1.091056705779286e-07, -1.872456284815646e-08,  3.213483535852308e-09, -5.514936272349516e-10,  9.464658226025672e-11,
 -1.624310655568289e-11,  2.787551026403152e-12, -4.779930120100146e-13,  7.968555300328980e-14, -2.000006323500851e+00,  3.704362386735353e-06, -6.357337193804921e-07,
  1.091030913619938e-07, -1.872401124348413e-08,  3.213370173058680e-09, -5.514709637939983e-10,  9.464214227911588e-11, -1.624225011004273e-11,  2.787387841706707e-12,
 -4.779622603413947e-13,  7.967998973546742e-14, -2.000003162064010e+00,  1.852378391132068e-06, -3.179165134710622e-07,  5.456277795917760e-08, -9.364398045330827e-09,
  1.607175352315262e-09, -2.758332818164186e-10,  4.734019760064841e-11, -8.124809066235837e-12,  1.394394984385211e-12, -2.391130985883992e-13,  3.986384697574060e-14,
 -2.000003161793571e+00,  1.852207840401552e-06, -3.178730384584726e-07,  5.455287876506951e-08, -9.362280710963212e-09,  1.606740159686955e-09, -2.757462683691692e-10,
  4.732314890268501e-11, -8.121520099544327e-12,  1.393768242560544e-12, -2.389949775369347e-13,  3.984247548170711e-14, -2.000003161596348e+00,  1.852083465276193e-06,
 -3.178413356501157e-07,  5.454566045203900e-08, -9.360736868144779e-09,  1.606422857632857e-09, -2.756828295018669e-10,  4.731071985260430e-11, -8.119122460174831e-12,
  1.393311374576085e-12, -2.389088767534930e-13,  3.982689812325961e-14, -2.000003161441327e+00,  1.851985703957907e-06, -3.178164175609301e-07,  5.453998714836685e-08,
 -9.359523516588010e-09,  1.606173490236598e-09, -2.756329748824755e-10,  4.730095262948808e-11, -8.117238376400332e-12,  1.392952378047143e-12, -2.388412233156511e-13,
  3.981465870255597e-14, -2.000003161316410e+00,  1.851906928743552e-06, -3.177963393897276e-07,  5.453541592766558e-08, -9.358545897888279e-09,  1.605972576707885e-09,
 -2.755928086069776e-10,  4.729308373170832e-11, -8.115720523671371e-12,  1.392663172708567e-12, -2.387867238041118e-13,  3.980479928836100e-14, -2.000003161215325e+00,
  1.851843181954884e-06, -3.177800920495816e-07,  5.453171696791310e-08, -9.357754843817462e-09,  1.605810008700277e-09, -2.755603091066169e-10,  4.728671697525196e-11,
 -8.114492453517597e-12,  1.392429187150718e-12, -2.387426313160099e-13,  3.979682277633051e-14, -2.000003161134339e+00,  1.851792110511902e-06, -3.177670755696952e-07,
  5.452875362260237e-08, -9.357121119798275e-09,  1.605679775891750e-09, -2.755342743619464e-10,  4.728161678725268e-11, -8.113508708763314e-12,  1.392241756932943e-12,
 -2.387073124701758e-13,  3.979043357169934e-14, -2.000003161071066e+00,  1.851752209366136e-06, -3.177569062002676e-07,  5.452643848983382e-08, -9.356626026612775e-09,
  1.605578033881597e-09, -2.755139355140163e-10,  4.727763248455449e-11, -8.112740212639966e-12,  1.392095339775320e-12, -2.386797224509480e-13,  3.978544259133051e-14,
 -2.000003161023927e+00,  1.851722482750222e-06, -3.177493300435171e-07,  5.452471374203305e-08, -9.356257192232498e-09,  1.605502239065977e-09, -2.754987838521589e-10,
  4.727466436783299e-11, -8.112167726392171e-12,  1.391986268579116e-12, -2.386591699415330e-13,  3.978172472485536e-14, -2.000003160991879e+00,  1.851702272903125e-06,
 -3.177441793845692e-07,  5.452354118036773e-08, -9.356006444091071e-09,  1.605450711212135e-09, -2.754884833346224e-10,  4.727264657780156e-11, -8.111778541230568e-12,
  1.391912120908934e-12, -2.386451982649937e-13,  3.977919732519807e-14, -2.000003160974264e+00,  1.851691164493453e-06, -3.177413483229308e-07,  5.452289668489567e-08,
 -9.355868621776220e-09,  1.605422389369499e-09, -2.754828217744423e-10,  4.727153752893111e-11, -8.111564632449100e-12,  1.391871367168239e-12, -2.386375190623384e-13,
  3.977780820664185e-14,     0.994778686623335,     0.999012927099325,     0.987075135287783,     0.975743812193643,     0.960533742548587,     0.941064945723959,
     0.916763033514926,     0.886729849183962,     0.849454536144563,     0.802024722844585,     0.736970301040723,     0.997395363354113,     0.999507597971308,
     0.993552557425118,     0.987900283417006,     0.980313591430091,     0.970603318702831,     0.958483547457982,     0.943507241243835,     0.924922491757757,
     0.901280063697689,     0.868863086263183,     0.998699053732989,     0.999754057957856,     0.996779684934758,     0.993956561521396,     0.990167301440288,
     0.985317464421445,     0.979264305605526,     0.971784642494327,     0.962503086939273,     0.950696112481301,     0.934508071503666,     0.999349856277249,
     0.999877091204193,     0.998390659057557,     0.996979816489205,     0.995086156525619,     0.992662487763352,     0.989637481180167,     0.985899613329198,
     0.981261303976544,     0.975361008643728,     0.967271461677604,     0.999675008935027,     0.999938560870502,     0.999195529673289,     0.998490284246234,
     0.997543690891035,     0.996332160352251,     0.994820037853636,     0.992951576873576,     0.990633012820921,     0.987683622539599,     0.983639898666061,
     0.999837524480071,     0.999969284217851,      0.99959781439279,     0.999245235172327,     0.998771996944413,     0.998166306605383,     0.997410339069278,
     0.996476224671795,     0.995317087160184,     0.993842576587244,     0.991820969045376,     0.999918767220329,      0.99998464305035,     0.999798919526638,
     0.999622640731936,     0.999386036143781,     0.999083209580686,     0.998705249059244,     0.998238220621795,     0.997658687611978,     0.996921477887397,
     0.995910736748393,     0.999959384852411,     0.999992321760008,     0.999899462838604,     0.999811326137989,     0.999693027464641,     0.999541618819086,
     0.999352644347546,     0.999119137286787,     0.998829379671144,     0.998460786127866,     0.997955431097554,     0.999979692736415,     0.999996160938648,
     0.999949732187218,     0.999905664510206,     0.999846516077381,      0.99977081291166,     0.999676327120391,     0.999559575375481,     0.999414698784109,
     0.999230404833355,     0.998977731188274,     0.999989846445716,     0.999998080483977,     0.999974866285475,     0.999952832615182,     0.999923258624565,
     0.999885407330727,     0.999838164795869,      0.99977978936928,     0.999707351626976,     0.999615205355716,     0.999488869498861,      0.99999492324223,
      0.99999904024565,      0.99998743319069,     0.999976416397583,     0.999961629458703,     0.999942703884009,     0.999919082706731,      0.99988989510484,
     0.999853676371942,     0.999807603412203,     0.999744435724969  };
  constexpr double w[5797] = {  1.317097209024177e-01, -5.749599646783941e-02,  1.347003343013137e-02, -2.145339474264363e-03,  2.584445287678098e-04,
 -2.502361192703431e-05,  2.025064528525298e-06, -1.407632238279794e-07,  8.575052444526969e-09, -4.649254155466762e-10,  2.271067867521844e-11, -1.007887181303703e-12,
  1.319513924357754e-01, -5.574583913773534e-02,  1.262234653962428e-02, -1.946711364517878e-03,  2.276435104847937e-04, -2.144675835765975e-05,  1.692598837548693e-06,
 -1.149775323033427e-07,  6.858031121008297e-09, -3.647073726877185e-10,  1.750188043355877e-11, -7.642124174222454e-13,  1.322778254695906e-01, -5.221528824324315e-02,
  1.103205286871323e-02, -1.594659313612675e-03,  1.756668871993314e-04, -1.566785672751074e-05,  1.175992585161256e-06, -7.629346018170239e-08,  4.362729277927286e-09,
 -2.232036829417055e-10,  1.033760943930824e-11, -4.369432124508571e-13,  1.323133428718095e-01, -4.689364878646264e-02,  8.907392645115506e-03, -1.166838992668183e-03,
  1.174621955397433e-04, -9.648181818732341e-06,  6.716134708574310e-07, -4.066644726139125e-08,  2.182885331010979e-09, -1.053787557855185e-10,  4.627006959515659e-12,
 -1.862306912095704e-13,  1.313519907848418e-01, -3.988953797470224e-02,  6.544389454711576e-03, -7.502193975953898e-04,  6.690447736876836e-05, -4.921608410180362e-06,
  3.097855235741940e-07, -1.710667120403153e-08,  8.438410572109595e-10, -3.769313920826728e-11,  1.540930740721690e-12, -5.807883261440789e-14,  1.282400021383732e-01,
 -3.156438792531316e-02,  4.281851366579850e-03, -4.140732913588428e-04,  3.168377496183801e-05, -2.028697434005603e-06,  1.125271683407909e-07, -5.535021492499996e-09,
  2.455256287452569e-10, -9.946290986396806e-12,  3.715837965171054e-13, -1.288951466174337e-14,  1.213513297412363e-01, -2.264187999826979e-02,  2.421307805984888e-03,
 -1.900036053599886e-04,  1.206471774594979e-05, -6.527740393206298e-07,  3.106335365160684e-08, -1.327987291231754e-09,  5.178180634039535e-11, -1.862544771245135e-12,
  6.234092799029201e-14, -1.953560858529500e-15,  1.088026111010599e-01, -1.418703929250126e-02,  1.135115236543154e-03, -6.932164433032840e-05,  3.524206760142860e-06,
 -1.560726942358480e-07,  6.189534928075399e-09, -2.239007296812581e-10,  7.485184169235080e-12, -2.335199311334532e-13,  6.849699144045564e-15, -1.899019933233353e-16,
  8.901429957494990e-02, -7.351485802259599e-03,  4.151121655798703e-04, -1.882518890530175e-05,  7.356561415946523e-07, -2.570584524792339e-08,  8.214154738671507e-10,
 -2.436492146634753e-11,  6.780258525240311e-13, -1.784129282500546e-14,  4.466136819369665e-16, -1.068111354178913e-17,  6.152933909540616e-02, -2.899574935476284e-03,
  1.071559685147949e-04, -3.401535050895273e-06,  9.698456723143718e-08, -2.549222829050458e-09,  6.278125513423717e-11, -1.464465345070034e-12,  3.260612181898220e-14,
 -6.969046425329910e-16,  1.436181964638122e-17, -2.862560333278378e-19,  2.774615920714785e-02, -7.386179954180258e-04,  1.597260449699557e-05, -3.189346205081283e-07,
  6.048077550914125e-09, -1.101140414606326e-10,  1.937487362946433e-12, -3.310627778907535e-14,  5.514283968464462e-16, -8.979666815843789e-18,  1.432997809159626e-19,
 -2.244736006687123e-21,  1.886116180569295e-02, -8.219772618933934e-03,  1.922269126568261e-03, -3.056281029584594e-04,  3.675849051387410e-05, -3.553659914431707e-06,
  2.871711626210161e-07, -1.993448557576578e-08,  1.212833944425574e-09, -6.567931881565192e-11,  3.204687802601650e-12, -1.420712467766953e-13,  2.050861355463758e-02,
 -8.595366962593085e-03,  1.930363704165906e-03, -2.954473199155338e-04,  3.430693014921388e-05, -3.211396696536443e-06,  2.519581399684423e-07, -1.702327878635733e-08,
  1.010364650222195e-09, -5.348660744182338e-11,  2.556014016077120e-12, -1.111772612943153e-13,  2.401217950323371e-02, -9.287706260743961e-03,  1.923113490630249e-03,
 -2.728583091284411e-04,  2.955254886360597e-05, -2.595442893650407e-06,  1.920868822724142e-07, -1.230276104124436e-08,  6.952961623119412e-10, -3.519115425704084e-11,
  1.613814567020751e-12, -6.759464287476170e-14,  2.971187795801896e-02, -1.013842057315839e-02,  1.857278854884895e-03, -2.354120358330859e-04,  2.300141279321233e-05,
 -1.838807194450575e-06,  1.248807007511911e-07, -7.393042425808985e-09,  3.887306471548765e-10, -1.841331089949323e-11,  7.944992672374999e-13, -3.146753423607172e-14,
  3.784830332341272e-02, -1.083410645576346e-02,  1.683875618866117e-03, -1.838909628394723e-04,  1.569805510188828e-05, -1.109912560363129e-06,  6.738351485826392e-08,
 -3.599880376124313e-09,  1.722547471293955e-10, -7.481472683700849e-12,  2.980156733900660e-13, -1.096606665269829e-14,  4.806844780624935e-02, -1.090627774710974e-02,
  1.377901722472575e-03, -1.251210384260253e-04,  9.048136380816156e-06, -5.504110459669852e-07,  2.913272310248998e-08, -1.372547980814940e-09,  5.850717502066234e-11,
 -2.284180260822388e-12,  8.245195150763428e-14, -2.770043199604723e-15,  5.867769833601804e-02, -9.890436807949611e-03,  9.719800794981596e-04, -7.083149204191260e-05,
  4.208818774294181e-06, -2.143779351053389e-07,  9.650807556580555e-09, -3.919236004632503e-10,  1.456893940164006e-11, -5.011474979672284e-13,  1.608636695266976e-14,
 -4.846864343440537e-16,  6.604353642676568e-02, -7.668666049623641e-03,  5.598791985842539e-04, -3.156306951990398e-05,  1.493131172493458e-06, -6.190392763608925e-08,
  2.309498537488973e-09, -7.891367017101230e-11,  2.500682212130492e-12, -7.417834617337960e-14,  2.074516902399347e-15, -5.497581253018358e-17,  6.505796222824278e-02,
 -4.767208504917415e-03,  2.457946475249392e-04, -1.029089271120125e-05,  3.739571717755173e-07, -1.221641217352726e-08,  3.665183631287872e-10, -1.024387677283436e-11,
  2.694264268111875e-13, -6.718671593132359e-15,  1.597714197564653e-16, -3.638012247139830e-18,  5.141974639391687e-02, -2.182625529081005e-03,  7.419720242337467e-05,
 -2.187873641620473e-06,  5.826987038438549e-08, -1.436381109722006e-09,  3.327989051421755e-11, -7.322580935977567e-13,  1.541356127535281e-14, -3.120803192234347e-16,
  6.103444853937009e-18, -1.156439758589795e-19,  2.502513058761812e-02, -6.246533343175325e-04,  1.266073074205744e-05, -2.375399125016378e-07,  4.244876273142209e-09,
 -7.300753368554374e-11,  1.215849958416814e-12, -1.969409927583236e-14,  3.113526637158814e-16, -4.817671143467342e-18,  7.312378604306930e-20, -1.090457281272963e-21,
  2.712528785251266e-03, -1.179827931321368e-03,  2.753438828107378e-04, -4.369122883997451e-05,  5.245051658400503e-06, -5.061871136014799e-07,  4.083836359345146e-08,
 -2.830546444418859e-09,  1.719673667633331e-10, -9.300170739791358e-12,  4.532110281562242e-13, -2.006812262157484e-14,  3.249867566969332e-03, -1.348980444293296e-03,
  3.000054131485068e-04, -4.550086124865839e-05,  5.239719585597219e-06, -4.867722201258759e-07,  3.792766152589332e-08, -2.546405432268036e-09,  1.502632573182997e-10,
 -7.912602195511067e-12,  3.762919404246457e-13, -1.629441976139294e-14,  4.552052062436258e-03, -1.718459533368071e-03,  3.474572611787368e-04, -4.823534023347396e-05,
  5.121907627608646e-06, -4.418305478327106e-07,  3.217073856675824e-08, -2.030094860642934e-09,  1.131865755281043e-10, -5.658089519385186e-12,  2.565359218260296e-13,
 -1.063352335381137e-14,  7.134185537700403e-03, -2.329168669438790e-03,  4.093219775164972e-04, -4.997075991010591e-05,  4.719938449981105e-06, -3.659358143773837e-07,
  2.416921479959226e-08, -1.394919362674283e-09,  7.165850218762540e-11, -3.322561170434363e-12,  1.405714320197842e-13, -5.467773412589475e-15,  1.183720694102612e-02,
 -3.169850249727375e-03,  4.640016676231460e-04, -4.803697064871420e-05,  3.908699080514828e-06, -2.646193242180879e-07,  1.544221772670547e-08, -7.956343185041091e-10,
  3.682393502445026e-11, -1.550946832078378e-12,  6.004768712669072e-14, -2.152152249416568e-15,  1.959894146669969e-02, -4.069812529361390e-03,  4.765681820539732e-04,
 -4.047675613102241e-05,  2.756958950808653e-06, -1.588464867124021e-07,  8.000187694994903e-09, -3.600681264133078e-10,  1.471252838521514e-11, -5.522501291733905e-13,
  1.921755639484898e-14, -6.239476284677681e-16,  3.055526509680851e-02, -4.629104087450884e-03,  4.170200157264072e-04, -2.816638428141479e-05,  1.563469289492450e-06,
 -7.484664937420917e-08,  3.182458907527788e-09, -1.225773930986024e-10,  4.337120336742929e-12, -1.424524528392438e-13,  4.378360900325656e-15, -1.266446885894983e-16,
  4.239822755723324e-02, -4.376219882306550e-03,  2.916414603710444e-04, -1.518136872383022e-05,  6.683803184745141e-07, -2.594208966132990e-08,  9.103727641176034e-10,
 -2.937526973567053e-11,  8.820395519559840e-13, -2.486560797753266e-14,  6.626519171047671e-16, -1.677462110328047e-17,  4.926224817907672e-02, -3.208983375341266e-03,
  1.514594198776417e-04, -5.866741214222105e-06,  1.985856842116266e-07, -6.073733745128663e-09,  1.712946987166341e-10, -4.515466638719791e-12,  1.123353530135891e-13,
 -2.656407138931742e-15,  6.003818697906674e-17, -1.302026840878981e-18,  4.372993556544950e-02, -1.680148744831163e-03,  5.271229529340224e-05, -1.448066229715247e-06,
  3.611808492420896e-08, -8.368804671383364e-10,  1.827898396087238e-11, -3.800705959051429e-13,  7.576010513528527e-15, -1.455265440952509e-16,  2.704638048319007e-18,
 -4.877370361788840e-20,  2.271253156507983e-02, -5.337163237323940e-04,  1.017424305844727e-05, -1.798867327115461e-07,  3.037068569240796e-09, -4.946067057585753e-11,
  7.813687106683982e-13, -1.202317449409647e-14,  1.807821528715536e-16, -2.663166684444787e-18,  3.851812746664758e-20, -5.477966044046564e-22,  3.920471173476086e-04,
 -1.701327180768608e-04,  3.960935000146116e-05, -6.270743697824482e-06,  7.511758730514718e-07, -7.234929045193990e-08,  5.826168104750901e-09, -4.031175012995121e-10,
  2.445143714857913e-11, -1.320358845500057e-12,  6.425187778818322e-14, -2.841291986408344e-15,  5.269998953228830e-04, -2.162037382910349e-04,  4.751955291730686e-05,
 -7.129197027684604e-06,  8.128903648345972e-07, -7.484273521774682e-08,  5.784126334042394e-09, -3.854664045078497e-10,  2.259298245297444e-11, -1.182375668088901e-12,
  5.591173440032093e-14, -2.408615166402136e-15,  9.071548722772251e-04, -3.326676220141594e-04,  6.540140369073861e-05, -8.850417962678226e-06,  9.183694795542543e-07,
 -7.758759757380377e-08,  5.543684028190978e-09, -3.438773451974379e-10,  1.887529810358365e-11, -9.301816053085260e-13,  4.162638174657104e-14, -1.704908036201753e-15,
  1.843440156427415e-03, -5.717853760695066e-04,  9.583319275407049e-05, -1.121259578634528e-05,  1.019389633526875e-06, -7.635383859484444e-08,  4.887602214208898e-09,
 -2.741534409327367e-10,  1.372080658973061e-11, -6.211352730478410e-13,  2.570653506317840e-14, -9.798384571466184e-16,  4.029988217178534e-03, -1.001597027875721e-03,
  1.372721169869103e-04, -1.340714632195759e-05,  1.035474566839194e-06, -6.687287488161075e-08,  3.738413630287888e-09, -1.851855992665750e-10,  8.266163182472847e-12,
 -3.367078996138458e-13,  1.263881393436549e-14, -4.401709066002307e-16,  8.677346765882697e-03, -1.637741218071157e-03,  1.769820270482481e-04, -1.401136533562463e-05,
  8.961934477773105e-07, -4.877421394876771e-08,  2.331554556967080e-09, -1.000075713477398e-10,  3.908130133136690e-12, -1.407332924520048e-13,  4.711262532710890e-15,
 -1.475260339008803e-16,  1.704895589925266e-02, -2.311299041250780e-03,  1.905391339747564e-04, -1.191184412381221e-05,  6.169309886891166e-07, -2.772503589546118e-08,
  1.112131643785679e-09, -4.057802919632096e-11,  1.364935703588347e-12, -4.275284393567213e-14,  1.256602940304549e-15, -3.484794897127070e-17,  2.861875998511542e-02,
 -2.622901082891383e-03,  1.597072428563357e-04, -7.682206162972677e-06,  3.149454028298319e-07, -1.144833871740310e-08,  3.779765674970161e-10, -1.151819622120822e-11,
  3.276889793139890e-13, -8.777779070797725e-15,  2.228385304733089e-16, -5.386406694693899e-18,  3.846947727908612e-02, -2.232864380756556e-03,  9.673559338708188e-05,
 -3.474466954392295e-06,  1.097575157260364e-07, -3.147848896080901e-09,  8.356412649900809e-11, -2.079990479765937e-12,  4.899228899993883e-14, -1.099476450656857e-15,
  2.363297435730138e-17, -4.883839668846158e-19,  3.775505183776247e-02, -1.319266798114898e-03,  3.831888415721296e-05, -9.834227664891583e-07,  2.302888895421249e-08,
 -5.026800556313480e-10,  1.037114868841026e-11, -2.041538610079317e-13,  3.860016579007356e-15, -7.045045254434385e-17,  1.245966557338782e-18, -2.141187449181231e-20,
  2.072785758101210e-02, -4.601999443905813e-04,  8.277530591033153e-06, -1.382921764055590e-07,  2.211152900615277e-09, -3.417291456199887e-11,  5.131728591805974e-13,
 -7.516154573260647e-15,  1.076909547686662e-16, -1.513126648735554e-18,  2.089060371700018e-20, -2.838223404651932e-22,  5.699498037040222e-05, -2.466637117505495e-05,
  5.726403725709664e-06, -9.041404798896139e-07,  1.080371423832615e-07, -1.038151140721491e-08,  8.342159984528723e-10, -5.760550688331191e-11,  3.487665183955279e-12,
 -1.880077337962273e-13,  9.134250032378857e-15, -4.033233248046844e-16,  8.784725669981313e-05, -3.552720559875158e-05,  7.698142032045166e-06, -1.139944611717197e-06,
  1.284529084994604e-07, -1.170110047178608e-08,  8.956184222934087e-10, -5.916604636900560e-11,  3.440391656437932e-12, -1.787500967008997e-13,  8.397001832719405e-15,
 -3.595589676953837e-16,  1.914380241705769e-04, -6.780949094575874e-05,  1.289789760206716e-05, -1.694096762930881e-06,  1.711384954044948e-07, -1.411356861571062e-08,
  9.866627000082156e-10, -6.000456684511517e-11,  3.234914830935913e-12, -1.568239862565449e-13,  6.913529303185944e-15, -2.793040865446619e-16,  5.157087463376503e-04,
 -1.507768213581976e-04,  2.394982393746571e-05, -2.671377810243988e-06,  2.326987081628103e-07, -1.677061955600763e-08,  1.036684690669916e-09, -5.632883500627972e-11,
  2.738324277657252e-12, -1.206984463510041e-13,  4.874113453864081e-15, -1.816319503276282e-16,  1.495962054229385e-03, -3.422682801061194e-04,  4.366864145466604e-05,
 -4.004901694585674e-06,  2.924084410350827e-07, -1.794977752024729e-08,  9.581259103365166e-10, -4.549302883098335e-11,  1.952980420821825e-12, -7.673302374392886e-14,
  2.785530925033869e-15, -9.404598079285112e-17,  4.159768106554263e-03, -7.089190412270118e-04,  7.043926850147327e-05, -5.182915450625671e-06,  3.105244962547652e-07,
 -1.592658082841931e-08,  7.210520924578471e-10, -2.941398137172104e-11,  1.097113058040333e-12, -3.782782432818154e-14,  1.215917464446470e-15, -3.665302744110748e-17,
  1.013832209171872e-02, -1.225280835203979e-03,  9.234590289920562e-05, -5.339553874245186e-06,  2.578436022340968e-07, -1.086993397653483e-08,  4.110213664907680e-10,
 -1.419451344964161e-11,  4.535035881651759e-13, -1.353327433894640e-14,  3.800061252461704e-16, -1.009290121814218e-17,  2.020008015125916e-02, -1.642992322723158e-03,
  9.154081063866709e-05, -4.073482673186748e-06,  1.556465021855679e-07, -5.302373756141438e-09,  1.647855434891705e-10, -4.743987928441403e-12,  1.279020323322084e-13,
 -3.255677728011425e-15,  7.873090641659227e-17, -1.816884912952192e-18,  3.085835399320408e-02, -1.600063593875735e-03,  6.380676698618538e-05, -2.130060855015132e-06,
  6.291967533375770e-08, -1.694987948886921e-09,  4.241492510142485e-11, -9.981267295389557e-13,  2.228294713852497e-14, -4.750203946286208e-16,  9.718192750667561e-18,
 -1.914978624044796e-19,  3.302428240258957e-02, -1.054341093248796e-03,  2.843585794589875e-05, -6.835847651862580e-07,  1.506465420488293e-08, -3.104505538328342e-10,
  6.062072140147844e-12, -1.131730691882640e-13,  2.033005219753542e-15, -3.530837108073774e-17,  5.950525979910802e-19, -9.757242243014730e-21,  1.900977376255748e-02,
 -4.000642146384537e-04,  6.809728725297987e-06, -1.077773591776444e-07,  1.635627608206402e-09, -2.403790071317542e-11,  3.437996605714402e-13, -4.801889279138975e-15,
  6.567764912172479e-17, -8.816942835006110e-19,  1.163871500265837e-20, -1.513267899109497e-22,  8.343400615648212e-06, -3.599092018929532e-06,  8.327240506984990e-07,
 -1.310614448563140e-07,  1.561483269601147e-08, -1.496412769924423e-09,  1.199468255577588e-10, -8.263754710965736e-12,  4.992597504138786e-13, -2.686045089411083e-14,
  1.302617508541484e-15, -5.741962823724287e-17,  1.513549434010091e-05, -6.014184020408333e-06,  1.280819391846851e-06, -1.867021197037445e-07,  2.074245190234552e-08,
 -1.865589559410694e-09,  1.411678827094139e-10, -9.229807787640467e-12,  5.316927730527135e-13, -2.739096012615151e-14,  1.276807651071241e-15, -5.428929200660727e-17,
  4.312011886178652e-05, -1.465370440024475e-05,  2.681199139639638e-06, -3.401388812798482e-07,  3.330976430989160e-08, -2.671478862986388e-09,  1.821257406179300e-10,
 -1.082714260842432e-11,  5.717788303173959e-13, -2.720278468880519e-14,  1.178812918600523e-15, -4.688271481809405e-17,  1.570300476304634e-04, -4.290293965883461e-05,
  6.415946493184550e-06, -6.785017884990451e-07,  5.636095703657535e-08, -3.892088768040178e-09,  2.314644528902144e-10, -1.214163099748972e-11,  5.715416331305742e-13,
 -2.445859384646549e-14,  9.611978740648907e-16, -3.493256828347902e-17,  6.056353241057887e-04, -1.265140917553123e-04,  1.494514723588475e-05, -1.281443898203937e-06,
  8.811800307023990e-08, -5.124307504064372e-09,  2.603694320857222e-10, -1.181609172108965e-11,  4.865399829462042e-13, -1.839237109337690e-14,  6.441570255595169e-16,
 -2.103523508788106e-17,  2.150832664405578e-03, -3.289695346841074e-04,  2.996599182774816e-05, -2.044518116959220e-06,  1.145084692779438e-07, -5.524466341300423e-09,
  2.364537168318596e-10, -9.157505812228513e-12,  3.254573538605385e-13, -1.072640587112633e-14,  3.305031032458220e-16, -9.575003842970442e-18,  6.389846457404563e-03,
 -6.862872185071172e-04,  4.727724970641562e-05, -2.527785369368300e-06,  1.137843416389052e-07, -4.498315400957522e-09,  1.602738494123638e-10, -5.236278949190757e-12,
  1.588063629504630e-13, -4.512027098888272e-15,  1.209472181568688e-16, -3.074119116829198e-18,  1.483384190030798e-02, -1.070715368632193e-03,  5.469155239947217e-05,
 -2.254680639852113e-06,  8.038713493637236e-08, -2.568901471473096e-09,  7.520454648723784e-11, -2.046543872319829e-12,  5.231109948165090e-14, -1.265677680467016e-15,
  2.916063313654639e-17, -6.425026874076852e-19,  2.533828906378919e-02, -1.176997188141148e-03,  4.332392657986996e-05, -1.347466505403201e-06,  3.729372042708587e-08,
 -9.453018103771032e-10,  2.233196004776982e-11, -4.975037338857366e-13,  1.053925848764439e-14, -2.136358762333105e-16,  4.163654323496390e-18, -7.829259197259057e-20,
  2.921516075467690e-02, -8.559940990249256e-04,  2.149710106416716e-05, -4.852761718061582e-07,  1.008741032233626e-08, -1.966644883678104e-10,  3.641387959778809e-12,
 -6.458502832903903e-14,  1.104038237524467e-15, -1.827305351234535e-17,  2.938560892246884e-19, -4.603531780336795e-21,  1.751086480489304e-02, -3.503486431236691e-04,
  5.658892479186809e-06, -8.504685449628873e-08,  1.227604496681642e-09, -1.718906432634238e-11,  2.345710942194994e-13, -3.129764408127442e-15,  4.093112432828616e-17,
 -5.259239310465359e-19,  6.644295151338713e-21, -8.295774475764776e-23,  1.231576624430665e-06, -5.291563981420515e-07,  1.219333070448237e-07, -1.911817836427506e-08,
  2.269845120279894e-09, -2.168339091601464e-10,  1.733000719393363e-11, -1.190765853557417e-12,  7.176418732941597e-14, -3.852209237835434e-15,  1.864245031939825e-16,
 -8.201713720725567e-18,  2.713264729969777e-06, -1.054873359948443e-06,  2.199608631197427e-07, -3.145845732346452e-08,  3.436034466850134e-09, -3.043727775150440e-10,
  2.271969323989728e-11, -1.467347693729306e-12,  8.359815315737200e-14, -4.263795986307981e-15,  1.969568178891102e-16, -8.305798266262884e-18,  1.045287689622940e-05,
 -3.381145567366815e-06,  5.912260128627825e-07, -7.204269346778933e-08,  6.806837942853044e-09, -5.287006746258169e-10,  3.502018783992947e-11, -2.028434744583309e-12,
  1.046234081672585e-13, -4.871826661821421e-15,  2.070223610868826e-16, -8.087629742085686e-18,  5.226568091040549e-05, -1.322072043250017e-05,  1.848769484866731e-06,
 -1.843395397051615e-07,  1.453265320282435e-08, -9.575699549945527e-10,  5.457975506048366e-11, -2.754451502930811e-12,  1.251545256673960e-13, -5.184712484678585e-15,
  1.977477862497837e-16, -6.991175414352777e-18,  2.671038715877317e-04, -5.052985604605348e-05,  5.499595228642666e-06, -4.391484287261898e-07,  2.834554532838913e-08,
 -1.556839771307347e-09,  7.508924348622651e-11, -3.248523184476878e-12,  1.279808061668519e-13, -4.643776365235284e-15,  1.565559743588278e-16, -4.934051506614503e-18,
  1.194009438382076e-03, -1.629864668884804e-04,  1.358155558737635e-05, -8.577802435407722e-07,  4.484351055135340e-08, -2.032186329385366e-09,  8.211599185370500e-11,
 -3.015096558438522e-12,  1.019608883208054e-13, -3.207643949411343e-15,  9.460720254646461e-17, -2.630443751972418e-18,  4.245152277865647e-03, -4.041445053690641e-04,
  2.546027539251684e-05, -1.259126889512099e-06,  5.284215431627420e-08, -1.959150178650629e-09,  6.576951221501226e-11, -2.032391676455214e-12,  5.849388877336231e-14,
 -1.581712557727878e-15,  4.045597138404454e-17, -9.834811639534376e-19,  1.128110926721133e-02, -7.228944811037181e-04,  3.392866083188673e-05, -1.297993693744164e-06,
  4.324101253344595e-08, -1.297711297941697e-09,  3.582011340114114e-11, -9.221155666339268e-13,  2.235939538573771e-14, -5.144678365614146e-16,  1.129674923170491e-17,
 -2.376991677276263e-19,  2.123371472244812e-02, -8.862089524922493e-04,  3.019348803515201e-05, -8.770259011686246e-07,  2.278952362740409e-08, -5.444903562854700e-10,
  1.216257387561117e-11, -2.568595170148726e-13,  5.169734700148440e-15, -9.975354005139938e-17,  1.853863451520901e-18, -3.329319192258969e-20,  2.610177189353895e-02,
 -7.048376369773793e-04,  1.652623845274976e-05, -3.511456391398713e-07,  6.899894428073136e-09, -1.275150906653367e-10,  2.242862942738940e-12, -3.785634300790897e-14,
  6.167617797102758e-16, -9.742565614150703e-18,  1.496910404751198e-19, -2.243571367591712e-21,  1.619398823936398e-02, -3.088501218116303e-04,  4.745750846377349e-06,
 -6.787689201891611e-08,  9.337188025289130e-10, -1.247877466691716e-11,  1.627567176295889e-13, -2.077976088768799e-15,  2.601710023012413e-17, -3.208756815637163e-19,
  3.868770645664232e-21, -4.693489646229740e-23,  1.836417728595110e-07, -7.851641582213452e-08,  1.800270237412493e-08, -2.809739941911930e-09,  3.322009174870320e-10,
 -3.161437260618673e-11,  2.518017947870710e-12, -1.724732480115679e-13,  1.036466876904082e-14, -5.548980366499923e-16,  2.678881922592251e-17, -1.175943462133856e-18,
  5.101128794240584e-07, -1.930140988008733e-07,  3.922096448873876e-08, -5.481328832569596e-09,  5.865527861222050e-10, -5.102020663070481e-11,  3.746947361792101e-12,
 -2.384973384359216e-13,  1.341103029590323e-14, -6.759815894507703e-16,  3.089382944122375e-17, -1.290284320545643e-18,  2.749908782840437e-06, -8.388944581884935e-07,
  1.391637161060103e-07, -1.618933893575297e-08,  1.468125132691751e-09, -1.099354834438255e-10,  7.046755886728724e-12, -3.962521754817881e-13,  1.989706051504548e-14,
 -9.041879064498977e-16,  3.757705834048150e-17, -1.438502992514097e-18,  1.907057698794087e-05, -4.422512735830552e-06,  5.744037329507232e-07, -5.370747515826279e-08,
  3.999803068666473e-09, -2.504358752953060e-10,  1.363015943107872e-11, -6.595309625172928e-13,  2.883494393679505e-14, -1.152972585196100e-15,  4.256200114337763e-17,
 -1.460047276504692e-18,  1.280150985454297e-04, -2.175796490662587e-05,  2.172595790874776e-06, -1.610221530691655e-07,  9.727824745731057e-09, -5.033000037160203e-10,
  2.298680150117029e-11, -9.458096328045351e-13,  3.557221045394021e-14, -1.236268344879935e-15,  4.003622866200215e-17, -1.215317789757417e-18,  7.080544483457545e-04,
 -8.582291022484402e-05,  6.533786204927741e-06, -3.815734857378710e-07,  1.860179038932505e-08, -7.910608919313683e-10,  3.014756167092463e-11, -1.048387763000267e-12,
  3.369819707039362e-14, -1.010815053059891e-15,  2.850567327389672e-17, -7.597445460418102e-19,  2.957211034371124e-03, -2.490306855477485e-04,  1.436338790621414e-05,
 -6.574747080404223e-07,  2.573905343357591e-08, -8.952883085280576e-10,  2.832450141912562e-11, -8.279562412125976e-13,  2.261289921992978e-14, -5.818707862395971e-16,
  1.419747367781245e-17, -3.299978357385759e-19,  8.848081699903030e-03, -5.037147422587860e-04,  2.177778068364380e-05, -7.745779212677087e-07,  2.414740506792235e-08,
 -6.814438087339261e-10,  1.775415641996589e-11, -4.327455791052128e-13,  9.961818100594967e-15, -2.181083027140162e-16,  4.566774389506249e-18, -9.180025420069143e-20,
  1.811309723654597e-02, -6.812950329944267e-04,  2.154302718938682e-05, -5.857989434316347e-07,  1.432036666421067e-08, -3.230690241943257e-10,  6.834244281091213e-12,
 -1.370152596873779e-13,  2.623321487917292e-15, -4.823803201440070e-17,  8.557502637698547e-19, -1.469029658778999e-20,  2.352257004413846e-02, -5.877824097086336e-04,
  1.289929810690027e-05, -2.585490973124309e-07,  4.812308788090131e-09, -8.446297766551760e-11,  1.413710954740859e-12, -2.274460086901527e-14,  3.536737201873514e-16,
 -5.340451262823235e-18,  7.847439367351868e-20, -1.127053170897662e-21,  1.502969628727090e-02, -2.739059149899150e-04,  4.013266383892636e-06, -5.473997707934320e-08,
  7.189365750465659e-10, -9.186433648135445e-12,  1.146840533496156e-13, -1.404015090158419e-15,  1.681476534616103e-17, -2.008687605606837e-19,  2.271809198135488e-21,
 -2.754662115841456e-23,  2.772650718124155e-08, -1.178163805473953e-08,  2.684764617473144e-09, -4.166665603517602e-10,  4.901389860857131e-11, -4.643218615907960e-12,
  3.683016644750161e-13, -2.513313481423240e-14,  1.505250468439551e-15, -8.033872360003027e-17,  3.867568055119777e-18, -1.693352149880673e-19,  1.015326737167905e-07,
 -3.713671384485384e-08,  7.311182760546871e-09, -9.935626213217053e-10,  1.037284862004476e-10, -8.827824488883521e-12,  6.358691306489708e-13, -3.977951790783997e-14,
  2.202451773918369e-15, -1.094779149724551e-16,  4.940872115778702e-18, -2.040277833258897e-19,  7.913655460676251e-07, -2.252982560210281e-07,  3.517528249326696e-08,
 -3.881207933477646e-09,  3.359397790658655e-10, -2.413451572592733e-11,  1.490615128257858e-12, -8.106170070403642e-14,  3.948871177359791e-15, -1.745737128073123e-16,
  7.075078760331184e-18, -2.647039572573207e-19,  7.638135392012735e-06, -1.607447234288371e-06,  1.926628508305316e-07, -1.680589100012512e-08,  1.177158426880519e-09,
 -6.976383144921326e-11,  3.612744171836367e-12, -1.670631314713606e-13,  7.006688735204647e-15, -2.696452793324386e-16,  9.608211909938604e-18, -3.189992010409788e-19,
  6.643414267043702e-05, -1.006741557927266e-05,  9.191241728231891e-07, -6.305569177513677e-08,  3.557067662699185e-09, -1.729886800740047e-10,  7.466166948660979e-12,
 -2.915961154974080e-13,  1.044964740862760e-14, -3.471851699555703e-16,  1.078055322672076e-17, -3.146235830774642e-19,  4.461320053747763e-04, -4.779740113202173e-05,
  3.323121084120635e-06, -1.793550036072358e-07,  8.149504578661767e-09, -3.250443991954050e-10,  1.167611900427570e-11, -3.842981647986292e-13,  1.173221563129958e-14,
 -3.352770938855111e-16,  9.032476199765683e-18, -2.305539861287142e-19,  2.149284848490939e-03, -1.598361336347731e-04,  8.454924851241391e-06, -3.585861774205588e-07,
  1.310611608262102e-08, -4.279660371286944e-10,  1.276618335813033e-11, -3.531113696371799e-13,  9.153699001392659e-15, -2.241581223773995e-16,  5.217489311312111e-18,
 -1.159381988921801e-19,  7.130873618016037e-03, -3.610076341725477e-04,  1.441636024242044e-05, -4.776526157695075e-07,  1.395747080873149e-08, -3.708904938380579e-10,
  9.131792319609721e-12, -2.109599083022440e-13,  4.614521706905762e-15, -9.620598784288010e-17,  1.922055776855882e-18, -3.693013746699913e-20,  1.569300219829741e-02,
 -5.336130379090112e-04,  1.570064355693721e-05, -4.006044441217118e-07,  9.231439138484008e-09, -1.969946373243789e-10,  3.952678970365849e-12, -7.533175430730313e-14,
  1.373891681660389e-15, -2.410019583138495e-17,  4.086043712163885e-19, -6.710989847541638e-21,  2.135987198543193e-02, -4.958068291560403e-04,  1.020837571902806e-05,
 -1.934183539516616e-07,  3.416682530933633e-09, -5.705537869635456e-11,  9.102220917208061e-13, -1.398243342223290e-14,  2.077392478042405e-16, -3.004725894438776e-18,
  4.224947164864039e-20, -5.819457562537530e-22,  1.399438346118412e-02, -2.442448060422496e-04,  3.419791886312957e-06, -4.456962542898511e-08,  5.598357564160925e-10,
 -6.851072254897887e-12,  8.193000443478244e-14, -9.662433242926853e-16,  1.096192324694141e-17, -1.304877533149777e-19,  1.331043909821209e-21, -1.594704599392964e-23,
  4.251988113320420e-09, -1.792584512183806e-09,  4.053339293194765e-10, -6.246765510539547e-11,  7.302549332706941e-12, -6.879492470562073e-13,  5.429723643831379e-14,
 -3.688735882456280e-15,  2.200325177583175e-16, -1.170079642438965e-17,  5.614161069010767e-19, -2.450643428645709e-20,  2.162981738968282e-08, -7.582374215226937e-09,
  1.435998115448831e-09, -1.886389827054601e-10,  1.911808115256087e-11, -1.585114861285093e-12,  1.115690508956784e-13, -6.837800029006433e-15,  3.717039491745416e-16,
 -1.817499154557408e-17,  8.082093717150519e-19, -3.293224440792388e-20,  2.508725175897595e-07, -6.587223015955918e-08,  9.597793250094928e-09, -9.976153102607475e-10,
  8.194196728130819e-11, -5.619463079023655e-12,  3.329286055691146e-13, -1.743889700140670e-14,  8.211625855156038e-16, -3.519839972193736e-17,  1.386871456474007e-18,
 -5.056932424327044e-20,  3.356668233361455e-06, -6.344507258329175e-07,  6.976035641373973e-08, -5.650514724372975e-09,  3.707658555396043e-10, -2.072452438513309e-11,
  1.017827701928172e-12, -4.484398412860120e-14,  1.799038248848695e-15, -6.645419604729199e-17,  2.279810589574687e-18, -7.307696358006672e-20,  3.716312761815821e-05,
 -4.984720509333867e-06,  4.150779432050726e-07, -2.630432700108305e-08,  1.383122416042364e-09, -6.312089167202430e-11,  2.570253403912573e-12, -9.513095013269486e-14,
  3.243113217111828e-15, -1.028462030601902e-16,  3.057157485175853e-18, -8.564313258442389e-20,  2.970650242474350e-04, -2.801544911723734e-05,  1.779576332435913e-06,
 -8.876138064857183e-08,  3.758939427976397e-09, -1.405940859367905e-10,  4.759120607178559e-12, -1.481968364428475e-13,  4.295205513502687e-15, -1.168780700405025e-16,
  3.006172486959914e-18, -7.343684398089703e-20,  1.622260092924016e-03, -1.064009252119525e-04,  5.173609885985695e-06, -2.035649840379099e-07,  6.953793315008837e-09,
 -2.133530879875514e-10,  6.004969408237907e-12, -1.572499709232802e-13,  3.870768495542346e-15, -9.023067452129791e-17,  2.003814028743015e-18, -4.257213485622139e-20,
  5.885906248919261e-03, -2.653029143022404e-04,  9.813386200550368e-06, -3.035121758289481e-07,  8.327196478806584e-09, -2.086628227457555e-10,  4.861422845878772e-12,
 -1.065527484897726e-13,  2.217069605072728e-15, -4.404643227846688e-17,  8.402749109615952e-19, -1.544376428949153e-20,  1.378250273680090e-02, -4.249951261161989e-04,
  1.166452330524695e-05, -2.799033075584067e-07,  6.091979397091569e-09, -1.231755074077898e-10,  2.348003235812415e-12, -4.259279662218068e-14,  7.411048446608961e-16,
 -1.241173576865122e-17,  2.013470090071817e-19, -3.169201147690952e-21,  1.952648552112402e-02, -4.225741896179570e-04,  8.181211465635318e-06, -1.468141371216143e-07,
  2.465812998834381e-09, -3.924637696345895e-11,  5.975844680265030e-13, -8.783479578822543e-15,  1.247037853795226e-16, -1.732420417200190e-18,  2.335405268774787e-20,
 -3.068886922622622e-22,  1.306893568495202e-02, -2.188833001203683e-04,  2.934501446727630e-06, -3.661012588816702e-08,  4.404737474805580e-10, -5.173775590078812e-12,
  5.914608226688294e-14, -6.815493568889040e-16,  7.079455492159132e-18, -8.844708507467701e-20,  8.406717626112302e-22, -6.337918447079548e-24,  6.651185636322757e-10,
 -2.775400572435777e-10,  6.213719101538408e-11, -9.492008709637769e-12,  1.101022690533923e-12, -1.030133570474862e-13,  8.081075039407748e-15, -5.460245908126999e-16,
  3.241244935515732e-17, -1.716101972129935e-18,  8.201601444849884e-20, -3.567330467905103e-21,  4.992838795477044e-09, -1.659531595416716e-09,  2.997652175443443e-10,
 -3.779958686969942e-11,  3.697091879662785e-12, -2.971409455361196e-13,  2.034864825383950e-14, -1.217168162761847e-15,  6.474793349371167e-17, -3.105190269460424e-18,
  1.357005677239531e-19, -5.443608773097212e-21,  8.809019742991447e-08, -2.105804431962286e-08,  2.838775423975924e-09, -2.760576724569753e-10,  2.139289081931354e-11,
 -1.393358653560462e-12,  7.882774252287572e-14, -3.960800505442159e-15,  1.796054837949586e-16, -7.438875989281393e-18,  2.840554668122725e-19, -1.006471691864400e-20,
  1.615181223172939e-06, -2.713490221570363e-07,  2.723278101222466e-08, -2.039986130818180e-09,  1.249619764630361e-10, -6.567441211107391e-12,  3.050075539975902e-13,
 -1.276848624034541e-14,  4.887068232247437e-16, -1.728416203646487e-17,  5.695196106119615e-19, -1.758411301610078e-20,  2.229380314477323e-05, -2.628433629163705e-06,
  1.993548163407864e-07, -1.165353424049778e-08,  5.704718929669969e-10, -2.440149646250196e-11,  9.363207825913788e-13, -3.280194906114202e-14,  1.062470814448475e-15,
 -3.211830215001975e-17,  9.127717723902552e-19, -2.451216676187052e-20,  2.079356889698087e-04, -1.719635751283485e-05,  9.993318576232769e-07, -4.608164363193881e-08,
  1.819492384908242e-09, -6.382945629856743e-11,  2.036200663457407e-12, -5.998420515282242e-14,  1.650234208789510e-15, -4.274635529148733e-17,  1.049284733606232e-18,
 -2.452104509693387e-20,  1.266262009568120e-03, -7.317168440111920e-05,  3.279387850100661e-06, -1.198891550291934e-07,  3.832638491085582e-09, -1.106003245012855e-10,
  2.939932498817090e-12, -7.293063533738424e-14,  1.705771363466703e-15, -3.786711214743424e-17,  8.025397899129473e-19, -1.630796307956940e-20,  4.961467697526925e-03,
 -1.993799024024904e-04,  6.851006898241091e-06, -1.982106588356324e-07,  5.114984858614491e-09, -1.210358146225656e-10,  2.672365581398557e-12, -5.561923140041082e-14,
  1.102340167996782e-15, -2.088637907647429e-17,  3.805890936064632e-19, -6.702519853311511e-21,  1.224999724686832e-02, -3.436264486561904e-04,  8.818133375451077e-06,
 -1.994399829947458e-07,  4.107669978131441e-09, -7.881813612487800e-11,  1.429929651270927e-12, -2.470894566134414e-14,  4.110044634458536e-16, -6.577889381924333e-18,
  1.020456931538241e-19, -1.547103012017354e-21,  1.795680440179714e-02, -3.635558516732348e-04,  6.632571017777495e-06, -1.129374848236568e-07,  1.806492261585045e-09,
 -2.745644730109923e-11,  3.992862047697176e-13, -5.633878177798310e-15,  7.635623679531350e-17, -1.019337275949950e-18,  1.333924762857252e-20, -1.632648487695946e-22,
  1.223773150573455e-02, -1.970521592495459e-04,  2.534283859431183e-06, -3.031928680652620e-08,  3.497681684059582e-10, -3.960391249116918e-12,  4.279958902422660e-14,
 -4.998332504098895e-16,  4.460013174572126e-18, -5.747644585302654e-20,  7.800412286362413e-22,  3.508257683870292e-24,  1.067423841346012e-10, -4.393626937801412e-11,
  9.710469033267710e-12, -1.466663911605333e-12,  1.684579885350744e-13, -1.562629172581719e-14,  1.216621936819909e-15, -8.165956510589019e-17,  4.818809136061960e-18,
 -2.537932087735684e-19,  1.207204304291564e-20, -5.228518669415663e-22,  1.265463829773767e-09, -3.935413381269089e-10,  6.712203448409799e-11, -8.059043088829295e-12,
  7.555969537071356e-13, -5.853120216399296e-14,  3.880602337681908e-15, -2.255685241845629e-16,  1.169758321115690e-17, -5.483797469737720e-19,  2.348109426668928e-20,
 -9.248531104399295e-22,  3.437948988157459e-08, -7.378615164934973e-09,  9.126198317886618e-10, -8.248013142232336e-11,  5.996680754614744e-12, -3.691199240464720e-13,
  1.985259722646217e-14, -9.530146910633297e-16,  4.146143214168313e-17, -1.653585027924936e-18,  6.099719313154265e-20, -2.093897003598264e-21,  8.479425525608816e-07,
 -1.253108606898034e-07,  1.143410445369844e-08, -7.894894104594666e-10,  4.502064021850980e-11, -2.218870491174594e-12,  9.720904065026224e-14, -3.857538783669055e-15,
  1.405404149834713e-16, -4.748486654358800e-18,  1.499543559412419e-19, -4.450233496649993e-21,  1.426262588294811e-05, -1.468264739858664e-06,  1.014153348659252e-07,
 -5.463982201619160e-09,  2.488595897572110e-10, -9.969746200102462e-12,  3.602213943991096e-13, -1.193436052471162e-14,  3.669426329156621e-16, -1.056388134207987e-17,
  2.867237826241430e-19, -7.373315262597114e-21,  1.522268619087577e-04, -1.100094434488861e-05,  5.861603076067184e-07, -2.500669541224038e-08,  9.212611107074766e-10,
 -3.032523889250406e-11,  9.120761693387776e-13, -2.542159717996150e-14,  6.639160388759320e-16, -1.637093807366070e-17,  3.834271928322240e-19, -8.570308920013842e-21,
  1.018211641711655e-03, -5.179503512494421e-05,  2.146412127142333e-06, -7.302685060335384e-08,  2.188049035525794e-09, -5.944704585085992e-11,  1.494316513900936e-12,
 -3.513561856716851e-14,  7.814592648801055e-16, -1.653487137732856e-17,  3.343988466882539e-19, -6.504641025974442e-21,  4.260247414646738e-03, -1.528583826845806e-04,
  4.893630309356568e-06, -1.327176167155633e-07,  3.227485405808854e-09, -7.220345285382050e-11,  1.513863155543874e-12, -2.992991933934023e-14,  5.658067788364136e-16,
 -1.024608484871842e-17,  1.779772830859309e-19, -3.013863818244675e-21,  1.100285749628976e-02, -2.816459720091185e-04,  6.772625984918336e-06, -1.446745773532506e-07,
  2.825295717266261e-09, -5.150945734813405e-11,  8.915391110394005e-13, -1.467416569385191e-14,  2.337786103662607e-16, -3.590608439155308e-18,  5.285211029033692e-20,
 -7.803817313707187e-22,  1.660076151172504e-02, -3.154635154644596e-04,  5.434174316698120e-06, -8.795503872597009e-08,  1.341709806657873e-09, -1.952099996614176e-11,
  2.708894771942488e-13, -3.687059555692097e-15,  4.777639513433542e-17, -6.034808904514173e-19,  8.002370415313263e-21, -8.749762790757986e-23,  1.148789394830585e-02,
 -1.781437569196606e-04,  2.201584736946832e-06, -2.530533860284452e-08,  2.797746749738569e-10, -3.086703991608633e-12,  3.053670424538330e-14, -3.837467999553872e-16,
  3.011811437485100e-18, -2.084711827843906e-20,  1.096931605909318e-21,  9.598379325620969e-24,  1.771799879658978e-11, -7.158202100176544e-12,  1.555182880849504e-12,
 -2.314564358289803e-13,  2.625068860308331e-14, -2.408647058463883e-15,  1.857657453792612e-16, -1.236593692067513e-17,  7.244378188592582e-19, -3.790927950279495e-20,
  1.792906757284546e-21, -7.725642537476030e-23,  3.569444548712153e-10, -1.021907383350216e-10,  1.627057306023166e-11, -1.843309118357904e-12,  1.644292032682476e-13,
 -1.219822585329659e-14,  7.786548778530692e-16, -4.377084298881096e-17,  2.203368239246092e-18, -1.005876870180231e-19,  4.205834586379418e-21, -1.621580883400188e-22,
  1.492907732083142e-08, -2.834588884623733e-09,  3.192211009489304e-10, -2.664865761829982e-11,  1.808371032371218e-12, -1.047158065312070e-13,  5.331922817156321e-15,
 -2.435968292685703e-16,  1.013132952835251e-17, -3.877786705394610e-19,  1.377471659425298e-20, -4.567549098715566e-22,  4.833372116517518e-07, -6.218818275142892e-08,
  5.146320056751773e-09, -3.266792009111944e-10,  1.730564465797514e-11, -7.982078474642237e-13,  3.292330179992898e-14, -1.236062886045660e-15,  4.278397373823877e-17,
 -1.378372676197408e-18,  4.163843234262608e-20, -1.185545018892204e-21,  9.675788368458004e-06, -8.641062870833723e-07,  5.441818182825655e-08, -2.701234192258861e-09,
  1.144616345750820e-10, -4.293074899062308e-12,  1.460149320584582e-13, -4.572526307202669e-15,  1.333737503855197e-16, -3.654395949103313e-18,  9.465531508878589e-20,
 -2.329020851928477e-21,  1.160025854473751e-04, -7.300815007564867e-06,  3.577883225622390e-07, -1.413409330277867e-08,  4.864287600307182e-10, -1.503085035151250e-11,
  4.265924530800652e-13, -1.125301139257516e-14,  2.790213488745208e-16, -6.552803123939858e-18,  1.463990599195154e-19, -3.129928996251930e-21,  8.405592760730517e-04,
 -3.761305340501832e-05,  1.446414273851327e-06, -4.587089331207974e-08,  1.290622838434749e-09, -3.303315927558540e-11,  7.867311702972727e-13, -1.754293392264875e-14,
  3.710849509939949e-16, -7.502228445510380e-18,  1.445962212929199e-19, -2.694775059715754e-21,  3.718134681528218e-03, -1.193001125089117e-04,  3.568899219149307e-06,
 -9.090837764145900e-08,  2.088150182144290e-09, -4.417866958387280e-11,  8.823297367719094e-13, -1.657496894683722e-14,  2.985250091841977e-16, -5.207610231042153e-18,
  8.559682715109443e-20, -1.396842971188764e-21,  9.974630781352294e-03, -2.337122413639187e-04,  5.277180899870683e-06, -1.066746799248490e-07,  1.979705192084708e-09,
 -3.430405319543195e-11,  5.685237851699314e-13, -8.912377665879741e-15,  1.355191899433409e-16, -2.032827881942145e-18,  2.777888519168058e-20, -4.007639015138370e-22,
  1.541964844497618e-02, -2.758745571389170e-04,  4.495689425071063e-06, -6.929003137221780e-08,  1.008756180184801e-09, -1.410378140494737e-11,  1.861905396742190e-13,
 -2.450748825859778e-15,  3.100738325643547e-17, -3.474066784389388e-19,  5.064672674492619e-21, -5.112693768919523e-23,  1.080872262309986e-02, -1.616740870114503e-04,
  1.922861281489646e-06, -2.128645965976096e-08,  2.245535765634849e-10, -2.472241743795865e-12,  2.109334857578801e-14, -2.901026728892211e-16,  3.148524566513101e-18,
  3.077691728877691e-20,  1.438212814198088e-21,  3.187802295541633e-24,  3.076635050159324e-12, -1.211017094862456e-12,  2.570863510027919e-13, -3.752300868940512e-14,
  4.186237470616907e-15, -3.787735102885265e-16,  2.886415189204071e-17, -1.901563084145701e-18,  1.103963497197881e-19, -5.731264465565585e-21,  2.691643524334532e-22,
 -1.152648806743056e-23,  1.134539813335861e-10, -2.933165346215258e-11,  4.305973882797029e-12, -4.558425382403595e-13,  3.837771735255224e-14, -2.707909079878975e-15,
  1.654330518912301e-16, -8.946099301584978e-18,  4.350967499121226e-19, -1.926180631084437e-20,  7.835046433435665e-22, -2.947075089482864e-23,  7.203015488910109e-09,
 -1.191388890480728e-09,  1.214031050167069e-10, -9.310696117538941e-12,  5.870869337337073e-13, -3.185080469530751e-14,  1.529622139250611e-15, -6.627484240737071e-17,
  2.626321638366854e-18, -9.616765018707278e-20,  3.279714355562968e-21, -1.047480290169614e-22,  2.974352779509935e-07, -3.297429774546523e-08,  2.473223718726274e-09,
 -1.440456400674087e-10,  7.079628270209286e-12, -3.051219676861128e-13,  1.183192918614505e-14, -4.196467247064868e-16,  1.377845332128359e-17, -4.226258376234891e-19,
  1.219323255963314e-20, -3.325451221330480e-22,  6.921441450212411e-06, -5.327605395829317e-07,  3.067402758712594e-08, -1.402524875889187e-09,  5.533119982674321e-11,
 -1.942469032652001e-12,  6.219932940644187e-14, -1.840905308397974e-15,  5.091370701006858e-17, -1.327496648067309e-18,  3.279403160145434e-20, -7.716079765023391e-22,
  9.161039605353056e-05, -5.004335838301192e-06,  2.265035319320770e-07, -8.291311005933335e-09,  2.670897489695603e-10, -7.748059625957902e-12,  2.077739063644750e-13,
 -5.191952539484737e-15,  1.221343273087992e-16, -2.736591964350798e-18,  5.829560123852247e-20, -1.191788198029017e-21,  7.102003936358890e-04, -2.793677901633858e-05,
  1.000980139971049e-06, -2.962604846159750e-08,  7.849924333213614e-10, -1.891890859210132e-11,  4.279650630785022e-13, -9.069795841273605e-15,  1.817812910000755e-16,
 -3.535864522248697e-18,  6.480169061771637e-20, -1.153780289855352e-21,  3.291849444551481e-03, -9.460493209368342e-05,  2.652641332839166e-06, -6.355638473370819e-08,
  1.383665012292285e-09, -2.764474531623710e-11,  5.278830731474754e-13, -9.464748819510308e-15,  1.603115958265455e-16, -2.753502893595135e-18,  4.246023743366320e-20,
 -6.547867366639139e-22,  9.116806489110155e-03, -1.961244128398259e-04,  4.166684853352463e-06, -7.982351678164972e-08,  1.412127609231888e-09, -2.322472998273262e-11,
  3.700386225050202e-13, -5.562427978528081e-15,  7.872888106270444e-17, -1.205839650025589e-18,  1.504426975360260e-20, -1.969936355586045e-22,  1.438317615821944e-02,
 -2.429805500185270e-04,  3.752468425294263e-06, -5.518519405574834e-08,  7.663431687338034e-10, -1.035679844822293e-11,  1.298355869073430e-13, -1.623602899471025e-15,
  2.165154789340846e-17, -1.850176740975386e-19,  3.136059093377959e-21, -3.985136306200186e-23,  1.019125576827168e-02, -1.472554601768906e-04,  1.687431311123586e-06,
 -1.806419530936907e-08,  1.795778275910388e-10, -2.050669004342063e-12,  1.462678277643988e-14, -1.605657155208777e-16,  5.275527720311460e-18,  8.533498473130393e-20,
  1.114649237408652e-21, -2.084296421520488e-23,  5.679791494496766e-13, -2.153670715352188e-13,  4.429058534462980e-14, -6.297570320026106e-15,  6.875160626148338e-16,
 -6.108612097156832e-17,  4.583839856328186e-18, -2.980263284141251e-19,  1.710630340571625e-20, -8.793336947087828e-22,  4.094087799594499e-23, -1.739916170766760e-24,
  4.104893782689264e-11, -9.371057969681216e-12,  1.252722549633624e-12, -1.226923740996487e-13,  9.669618784173100e-15, -6.443616660975628e-16,  3.744205558314420e-17,
 -1.937046384272488e-18,  9.057015794929145e-20, -3.870822697832830e-21,  1.525533914060947e-22, -5.577453805689654e-24,  3.847099928365371e-09, -5.454018615541174e-10,
  5.008773274868187e-11, -3.512456948810112e-12,  2.050728946664622e-13, -1.038758682097429e-14,  4.690051961404120e-16, -1.921279476753485e-17,  7.232736137702478e-19,
 -2.526443996160366e-20,  8.249389274124804e-22, -2.530921326927338e-23,  1.963750998170807e-07, -1.855731662246680e-08,  1.263824419134374e-09, -6.741277232000723e-11,
  3.073238654132609e-12, -1.236214494230807e-13,  4.502523176697221e-15, -1.507258821062674e-16,  4.688291879553776e-18, -1.367641746913786e-19,  3.763700872384093e-21,
 -9.819280972780231e-23,  5.192518007473067e-06, -3.421403075421649e-07,  1.809523589296252e-08, -7.616140674297267e-10,  2.802693372056089e-11, -9.206416166490765e-13,
  2.776074612928402e-14, -7.772956191383213e-16,  2.036001682887115e-17, -5.054737152869241e-19,  1.190598684454355e-20, -2.676651962881838e-22,  7.467595725392582e-05,
 -3.527875628366101e-06,  1.482941479482865e-07, -5.029134976054037e-09,  1.521664696115431e-10, -4.141501670216303e-12,  1.050041152177812e-13, -2.495561929461397e-15,
  5.545326656439303e-17, -1.190132818893305e-18,  2.419629947931750e-20, -4.711336947597574e-22,  6.124849998963606e-04, -2.116298669126534e-05,  7.099376552656829e-07,
 -1.961099523095797e-08,  4.917116395155246e-10, -1.113978736896129e-11,  2.393778892099759e-13, -4.873745470842192e-15,  9.110135847656373e-17, -1.727440083874760e-18,
  3.030798091215309e-20, -5.022672340296766e-22,  2.951522753703106e-03, -7.609610753789306e-05,  2.006557365578285e-06, -4.523328743003416e-08,  9.386418444476092e-10,
 -1.765714029742289e-11,  3.218375507775089e-13, -5.641488724337748e-15,  8.598715269736480e-17, -1.506190210364519e-18,  2.254714989310084e-20, -2.885600449862924e-22,
  8.393408574072779e-03, -1.662707745003994e-04,  3.330468218978832e-06, -6.051120992946910e-08,  1.025141673328266e-09, -1.596442685035647e-11,  2.437774114778708e-13,
 -3.635979009883982e-15,  4.443733053102966e-17, -7.369170366762927e-19,  9.315105864325566e-21, -7.059953657827435e-23,  1.346737419750955e-02, -2.154159602223369e-04,
  3.157488980878009e-06, -4.442560463230559e-08,  5.870667952232551e-10, -7.713356974925362e-12,  9.322593280447145e-14, -1.016569427145677e-15,  1.682061663316158e-17,
 -9.555421456026108e-20,  1.276588983584758e-21, -4.841888492396059e-23,  9.627924946702905e-03, -1.345772450530396e-04,  1.486605515029970e-06, -1.550113022027352e-08,
  1.418222904698984e-10, -1.731409859282340e-12,  1.300403117026402e-14,  6.356726674959165e-17,  8.828470655905528e-18,  1.001603456608422e-19, -7.059323028752906e-22,
 -6.705846438599344e-23,  1.140520724846316e-13, -4.093213807379584e-14,  8.054455194277157e-15, -1.105400848287396e-15,  1.172487697481336e-16, -1.017220101437698e-17,
  7.482243289046379e-19, -4.783177202456479e-20,  2.706100402908221e-21, -1.373832833775377e-22,  6.327640007817415e-24, -2.663898247426889e-25,  1.701642471752668e-11,
 -3.342898887398117e-12,  4.024585382755897e-13, -3.611378673728105e-14,  2.643627352260579e-15, -1.652265666445453e-16,  9.075652025031811e-18, -4.466968443426618e-19,
  1.997792541916134e-20, -8.204765241319770e-22,  3.119718429219117e-23, -1.104343744264599e-24,  2.261969212890445e-09, -2.700823573255506e-10,  2.234435619119166e-11,
 -1.426464038449557e-12,  7.694174937339925e-14, -3.628697804316645e-15,  1.536252056743728e-16, -5.935711079367592e-18,  2.117231052961608e-19, -7.037943541035330e-21,
  2.194817063536367e-22, -6.452790098128165e-24,  1.382166733711991e-07, -1.100243302785313e-08,  6.840347971548747e-10, -3.332850506588433e-11,  1.411083573245854e-12,
 -5.293918427502553e-14,  1.809104375873099e-15, -5.717951942453948e-17,  1.682374362400496e-18, -4.664915338186561e-20,  1.223613258362165e-21, -3.049191898749033e-23,
  4.064772355964711e-06, -2.275087749399150e-07,  1.113864774463016e-08, -4.305481456419641e-10,  1.483327241342061e-11, -4.559531200696774e-13,  1.292458920096812e-14,
 -3.439481230064059e-16,  8.502756590876605e-18, -2.011979424798965e-19,  4.529921257486808e-21, -9.679190964067694e-23,  6.260607157863214e-05, -2.547042010540537e-06,
  1.002054377665929e-07, -3.140785096311698e-09,  8.976725688193094e-11, -2.293183184591290e-12,  5.465987743186746e-14, -1.253827478359888e-15,  2.599718784988612e-17,
 -5.352124411107668e-19,  1.057147486967923e-20, -1.896068782889685e-22,  5.378704128095969e-04, -1.630618073013367e-05,  5.153549389534144e-07, -1.325495898621581e-08,
  3.167989755360490e-10, -6.752916689806193e-12,  1.358279602214602e-13, -2.756208080414383e-15,  4.638474435495857e-17, -8.533544553032125e-19,  1.555961421966429e-20,
 -2.020240347123050e-22,  2.676133699288109e-03, -6.198389404787158e-05,  1.543438697336296e-06, -3.266918205579377e-08,  6.513603976249761e-10, -1.156206135145400e-11,
  1.953654788798359e-13, -3.603852178828843e-15,  4.559795860955089e-17, -7.869553959188574e-19,  1.504486559214275e-20, -6.300240706586750e-23,  7.777378182151734e-03,
 -1.422750900624455e-04,  2.693152238682564e-06, -4.637737895349847e-08,  7.568487217226369e-10, -1.119682916518482e-11,  1.583767158263494e-13, -2.570682295713651e-15,
  2.416062955658646e-17, -3.940296823080903e-19,  8.650458174951929e-21,  4.267734612486031e-23,  1.265306475190066e-02, -1.921397734578588e-04,  2.676019216104107e-06,
 -3.615372798796262e-08,  4.531700816164381e-10, -5.759616626196431e-12,  7.182423988633163e-14, -5.281596027890147e-16,  1.370689453108685e-17, -9.645418272141577e-20,
 -1.635143118653463e-21, -9.174367988696095e-23,  9.112274704228681e-03, -1.233923956171696e-04,  1.313122213747955e-06, -1.349082292184051e-08,  1.106371168863500e-10,
 -1.363060743527360e-12,  1.920238515096687e-14,  3.912068635576606e-16,  1.100469163294017e-17, -1.120647463972454e-20, -5.594735482227868e-21, -1.680132704601907e-22,
  2.571351907238365e-14, -8.493571704718301e-15,  1.571913816742563e-15, -2.056023166376635e-16,  2.098547511962861e-17, -1.764380296565774e-18,  1.264494051668669e-19,
 -7.909205940521872e-21,  4.392780481897750e-22, -2.195202499479723e-23,  9.974185766829387e-25, -4.149942238346124e-26,  8.099781112830293e-12, -1.328714080500169e-12,
  1.430548126876443e-13, -1.165067975454863e-14,  7.868314807163120e-16, -4.583002056750504e-17,  2.365887614939375e-18, -1.102032190142534e-19,  4.691022078969021e-21,
 -1.842876904687963e-22,  6.731641032823618e-24, -2.298029501444839e-25,  1.454365559009830e-09, -1.433171930155631e-10,  1.074040548875327e-11, -6.208909399479524e-13,
  3.092215147919628e-14, -1.355429392696926e-15,  5.366701389070123e-17, -1.953311519276388e-18,  6.585683726557943e-20, -2.079157764178182e-21,  6.181427394746583e-23,
 -1.737176333312519e-24,  1.030707677456187e-07, -6.813567150231455e-09,  3.909971403489530e-10, -1.731427154934005e-11,  6.827065102945075e-13, -2.391878476030725e-14,
  7.640156305161793e-16, -2.288376494202906e-17,  6.354451803109211e-19, -1.672113020970604e-20,  4.193627672174378e-22, -9.923182607699385e-24,  3.305136681742591e-06,
 -1.556290795091926e-07,  7.141948335699225e-09, -2.521107363847391e-10,  8.170506278751915e-12, -2.362046562213311e-13,  6.222702869398305e-15, -1.596663704320512e-16,
  3.708163946030998e-18, -8.273930436919042e-20,  1.829472047561863e-21, -3.587878915198571e-23,  5.381288437525076e-05, -1.874815163464368e-06,  6.982206727940625e-08,
 -2.010589194173399e-09,  5.459804379418405e-11, -1.323865138989939e-12,  2.880356697417061e-14, -6.622347670125801e-16,  1.272718186695624e-17, -2.372130829313850e-19,
  5.176146765009976e-21, -7.204905008093504e-23,  4.799934139584370e-04, -1.274264278329097e-05,  3.827598008384885e-07, -9.113068231050597e-09,  2.088490951896569e-10,
 -4.275862296740418e-12,  7.558872173587016e-14, -1.657301809794426e-15,  2.523175303632283e-17, -3.546041644543415e-19,  1.051926244652634e-20, -4.592460518666622e-23,
  2.450639126813248e-03, -5.104341370294018e-05,  1.207046121124830e-06, -2.387422629172038e-08,  4.595892762088777e-10, -7.941397442752212e-12,  1.114400158286028e-13,
 -2.483873234475923e-15,  2.794450737110905e-17, -1.853715995522246e-19,  1.623299100404619e-20,  9.646228587732955e-23,  7.248113317436983e-03, -1.227659165289451e-04,
  2.202496842499645e-06, -3.587581336842435e-08,  5.654972406305989e-10, -8.182761370370071e-12,  9.559696233799258e-14, -1.951926643340312e-15,  1.697617942832491e-17,
  2.396042996873171e-20,  1.297545923383016e-20,  1.366030388517975e-22,  1.192473749743229e-02, -1.723519040349027e-04,  2.282169152994660e-06, -2.973507012190966e-08,
  3.542578983708847e-10, -4.167611106497368e-12,  6.251244968207157e-14, -1.668961247249866e-16,  7.889088399061791e-18, -2.639964711093830e-19, -7.237627686243045e-21,
 -1.553009900966082e-22,  8.638729758566228e-03, -1.135067719554439e-04,  1.161046845236003e-06, -1.190926173604767e-08,  8.906889011565483e-11, -7.332874475518681e-13,
  3.462131600371175e-14,  6.766827791888890e-16,  4.402239473428533e-18, -4.250551602546044e-19, -1.601499711815250e-20, -2.845350746838520e-22,  6.788234700147486e-15,
 -1.973257137602099e-15,  3.359463195747073e-16, -4.117815856583029e-17,  3.994384989102604e-18, -3.222710322722412e-19,  2.232783551193151e-20, -1.357789486204030e-21,
  7.364632091792238e-23, -3.607098038204441e-24,  1.610992268401142e-25, -6.604474742794211e-27,  4.418758227539829e-12, -5.833030206050345e-13,  5.625551444023989e-14,
 -4.116521032962256e-15,  2.552234790418467e-16, -1.378179697549311e-17,  6.649750199096424e-19, -2.918426640206362e-20,  1.176784063233888e-21, -4.403058747406182e-23,
  1.538977783950479e-24, -5.045830428929265e-26,  1.015391178450568e-09, -8.046903012239937e-11,  5.548208001247211e-12, -2.880779772863827e-13,  1.325279776762698e-14,
 -5.407852009950522e-16,  1.992216430479305e-17, -6.840062652415093e-19,  2.175842290957908e-20, -6.500205934318276e-22,  1.845947301102632e-23, -4.934301325938797e-25,
  8.097780404330324e-08, -4.361798063029798e-09,  2.356972420795255e-10, -9.404344127523625e-12,  3.456715447073483e-13, -1.143212936170595e-14,  3.363939717911416e-16,
 -9.637368254921010e-18,  2.538023808347506e-19, -6.208147606083593e-21,  1.530155439957442e-22, -3.379725953042555e-24,  2.780453487333156e-06, -1.086854182814276e-07,
  4.767737270233196e-09, -1.523705891163674e-10,  4.636979865784786e-12, -1.294126324328448e-13,  3.050972723310840e-15, -7.709956733664868e-17,  1.744261303229292e-18,
 -3.295643395603128e-20,  8.152854144555444e-22, -1.426054520269913e-23,  4.729655750768608e-05, -1.399692738058054e-06,  5.016889727259044e-08, -1.316843664887666e-09,
  3.374077860381105e-11, -8.156641136546891e-13,  1.493327121329215e-14, -3.567874811235076e-16,  7.304109798703918e-18, -7.778851489935143e-20,  3.041570319101131e-21,
 -3.874167468723800e-23,  4.345267542712508e-04, -1.006711572400748e-05,  2.909102812666031e-07, -6.371312200185987e-09,  1.381461814484088e-10, -2.936317100376493e-12,
  3.913042581201737e-14, -9.758821588736898e-16,  1.968375564285911e-17,  3.632022678773433e-20,  8.764055276332548e-21, -8.785610215345515e-23,  2.264125391234983e-03,
 -4.241923626616912e-05,  9.598450618403261e-07, -1.766796553068906e-08,  3.223865510552520e-10, -6.001851912694119e-12,  5.434810239101167e-14, -1.563219026796453e-15,
  3.386462159258281e-17,  5.261888112344536e-19,  1.741956778183892e-20, -1.850438947113572e-22,  6.789764704906168e-03, -1.067258811018223e-04,  1.821229978751841e-06,
 -2.802987127205811e-08,  4.206928766045204e-10, -6.478246045556425e-12,  4.945426511265609e-14, -1.284413162153908e-15,  2.835520008399804e-17,  6.233508387760767e-19,
  1.465917051579225e-20, -2.000703351865812e-22,  1.126971306501314e-02, -1.554312874537412e-04,  1.956867103339893e-06, -2.465345554744479e-08,  2.856319978156360e-10,
 -2.705961248168845e-12,  5.947274277960437e-14, -1.348464587426364e-16, -8.295627543772365e-18, -6.633938088285402e-19, -1.103720321354694e-20,  9.172017944494391e-23,
  8.202407458278205e-03, -1.047666039333719e-04,  1.026366388360126e-06, -1.054983995648695e-08,  8.425128431363584e-11,  3.217772337529306e-13,  5.222739510541031e-14,
  4.270816364138822e-16, -2.498664161792410e-17, -1.250209804145944e-18, -2.148935272358084e-20,  2.577071701064236e-22,  2.207024541450007e-15, -5.254268249515886e-16,
  8.045283419384010e-17, -9.041253036670977e-18,  8.211197772285296e-19, -6.280226697499678e-20,  4.164938128740457e-21, -2.442919088013132e-22,  1.285435878108658e-23,
 -6.136847026460461e-25,  2.681819270760016e-26, -1.079128787996337e-27,  2.748886927371071e-12, -2.778686258275369e-13,  2.446285212754252e-14, -1.587484907483995e-15,
  9.002811742409102e-17, -4.500354168724612e-18,  2.015189158619545e-19, -8.312661873529308e-21,  3.163547461053401e-22, -1.120996733592146e-23,  3.742965942152295e-25,
 -1.173174336303901e-26,  7.645768621902742e-10, -4.698696982686221e-11,  3.075871922791605e-12, -1.419106508111742e-13,  5.997615825488255e-15, -2.312122178593383e-16,
  7.813738030899690e-18, -2.533986109791969e-19,  7.695930298596325e-21, -2.125870245597094e-22,  5.851457777294109e-24, -1.500726075426785e-25,  6.669997037106766e-08,
 -2.848529391709788e-09,  1.496893328308202e-10, -5.341599243600465e-12,  1.799061837784696e-13, -5.849581588348518e-15,  1.536452359935782e-16, -4.150435063164412e-18,
  1.120989608826909e-19, -2.285457950610812e-21,  5.718164899263455e-23, -1.410739932618601e-24,  2.411965318468491e-06, -7.677013502899619e-08,  3.310156286243296e-09,
 -9.553903033860124e-11,  2.634772955146648e-12, -7.668652850844926e-14,  1.533685397362733e-15, -3.507025059081421e-17,  1.011834992685858e-18, -1.113184871152672e-20,
  2.902053299040554e-22, -1.214794825030532e-23,  4.241187165691512e-05, -1.053500883897198e-06,  3.712243397054253e-08, -8.909715235587420e-10,  2.033057366507761e-11,
 -5.525737888315686e-13,  7.940128247318215e-15, -1.482524088521788e-16,  6.192225484338861e-18, -1.659000048737801e-21,  2.995216200597531e-22, -1.012462325241797e-22,
  3.984761675922541e-04, -8.012253189406912e-06,  2.259216616381020e-07, -4.587730719062316e-09,  8.697873659923480e-11, -2.250567515947888e-12,  2.123173577477958e-14,
 -2.707663259377896e-16,  2.544745852293221e-17,  2.012472430327596e-19, -4.036627990218789e-21, -5.606073420909506e-22,  2.108575472127701e-03, -3.550957537894260e-05,
  7.750121443291408e-07, -1.341161969981661e-08,  2.125701256037392e-10, -5.078691014947178e-12,  2.937578527928443e-14, -7.628008530462718e-17,  6.048444687236322e-17,
  7.237006524021618e-19, -1.791539482924846e-20, -1.573899410675520e-21,  6.390019617474246e-03, -9.339652677221162e-05,  1.521162972023870e-06, -2.228089944958974e-08,
  3.007142307920835e-10, -5.596350740268294e-12,  3.018468372855622e-14,  5.922825853429112e-17,  5.628447792891162e-17,  6.950378214606038e-19, -2.116269989168993e-20,
 -1.545098174150930e-21,  1.067752900924275e-02, -1.408856434286423e-04,  1.686906109057954e-06, -2.044087761074148e-08,  2.452220168879780e-10, -1.378576406416057e-12,
  4.789985320167828e-14, -8.448145648629283e-16, -3.679276526664857e-17, -7.504620443953510e-19,  1.517304524902959e-20,  1.231352919687326e-21,  7.798994686041508e-03,
 -9.703820564863194e-05,  9.082953443964656e-07, -9.080373238736695e-09,  1.035283055042592e-10,  1.581948392970076e-12,  4.531628982713362e-14, -1.206059167937244e-15,
 -7.796666798864836e-17, -1.333421888900901e-18,  3.389630911714807e-20,  2.472035056511915e-21,  9.284411135289808e-16, -1.614908798887859e-16,  2.213488785044723e-17,
 -2.213582490213524e-18,  1.852361636243437e-19, -1.325430777407077e-20,  8.308387352476468e-22, -4.657699475632993e-23,  2.358647975739818e-24, -1.089707844349162e-25,
  4.634892321925734e-27, -1.821659847823768e-28,  1.935475981500274e-12, -1.393339628059415e-13,  1.176133473944431e-14, -6.667954328194102e-16,  3.417115611317543e-17,
 -1.603086594055222e-18,  6.575371469593579e-20, -2.533180600564961e-21,  9.199680859334127e-23, -3.033585367901296e-24,  9.643359298715209e-26, -2.943601873616267e-27,
  6.169683455491497e-10, -2.785581425855385e-11,  1.823564364610828e-12, -7.474225262073842e-14,  2.792762182195027e-15, -1.067259486656082e-16,  3.275187249554291e-18,
 -9.492052203853142e-20,  3.016796751159848e-21, -7.397667483180839e-23,  1.741870817818500e-24, -5.630341290099504e-26,  5.735371428707756e-08, -1.866236209873806e-09,
  9.955714912259652e-11, -3.231740417612983e-12,  9.219694800347000e-14, -3.214325808476023e-15,  7.778407443915483e-17, -1.548730912506340e-18,  5.762265152733597e-20,
 -1.076071971150219e-21,  6.265412582037379e-24, -9.553847475163252e-25,  2.151459033047834e-06, -5.426307496604266e-08,  2.371728348311834e-09, -6.392479640862579e-11,
  1.407128983311570e-12, -4.832058470966755e-14,  9.542640650931790e-16, -7.994545282474356e-18,  6.785415377966781e-19, -1.150580177528891e-20, -3.218085103166780e-22,
 -1.299823066603623e-23,  3.873089094571623e-05, -7.945361487028435e-07,  2.804846107051447e-08, -6.447505493900787e-10,  1.096349768382680e-11, -3.896500721040509e-13,
  6.512550680129833e-15,  4.103119875587665e-17,  5.057205222232791e-18, -1.001449853719986e-19, -5.362963269991044e-21, -1.100702828743000e-22,  3.697223428410690e-04,
 -6.404679580296336e-06,  1.778202471390839e-07, -3.529333560875051e-09,  4.694447005267528e-11, -1.735747594058933e-12,  2.559485192266818e-14,  5.716149266459374e-16,
  2.265215904116619e-17, -5.657270978214069e-19, -3.433563152040709e-20, -5.065391329791061e-22,  1.977989860159604e-03, -2.990287441706164e-05,  6.312595945707735e-07,
 -1.078134331602294e-08,  1.190758917337527e-10, -4.165242742744046e-12,  5.637353623687317e-14,  1.981290720930744e-15,  5.405635938058695e-17, -1.637826465212390e-18,
 -9.814009639093220e-20, -1.145036564459452e-21,  6.039183372905085e-03, -8.222314418192573e-05,  1.279105485179257e-06, -1.832109138340173e-08,  1.972828775252065e-10,
 -4.634861087301959e-12,  5.879525250080928e-14,  1.947407188863923e-15,  4.743846912837700e-17, -1.696784718455785e-18, -9.425631067636115e-20, -8.372681772007939e-22,
  1.013951527901870e-02, -1.283065964930890e-04,  1.464421051783915e-06, -1.668612762985280e-08,  2.264617026491977e-10, -6.636625329937438e-13,  5.244486552659659e-15,
 -2.212935386067606e-15, -3.726275911198954e-17,  1.176956163834519e-18,  8.045880075377163e-20,  1.004025497879940e-21,  7.424727793451137e-03, -9.017683179784889e-05,
  8.104605352431851e-07, -7.128700123817758e-09,  1.417155033986951e-10,  1.953272582490528e-12, -2.734071888679849e-14, -3.964106929597361e-15, -7.121909099893071e-17,
  2.556058730424125e-18,  1.556088823973020e-19,  1.561079266061261e-21,  5.197445824044650e-16, -5.509524758200933e-17,  7.193252381767078e-18, -6.134183065861669e-19,
  4.626589071802113e-20, -3.085706494046278e-21,  1.795591272547124e-22, -9.496255462900683e-24,  4.612150062571111e-25, -2.039117290656873e-26,  8.357388004861649e-28,
 -3.212047259245254e-29,  1.526134377279404e-12, -6.993376678775732e-14,  6.206067304995201e-15, -3.100124118362127e-16,  1.351593164214406e-17, -6.229954054045719e-19,
  2.373784442358239e-20, -7.907564582813260e-22,  2.903405988161255e-23, -9.324612154840285e-25,  2.378861646488995e-26, -7.891156853703377e-28,  5.299305662142007e-10,
 -1.623355885586247e-11,  1.136100273388696e-12, -4.359839577010192e-14,  1.276350853739942e-15, -5.119146430162351e-17,  1.640234721941358e-18, -3.161116144231326e-20,
  1.129153003710286e-21, -4.084906170241336e-23,  2.454552800357268e-25, -9.721246590554369e-27,  5.126579081093403e-08, -1.204111331351851e-09,  6.780202078154813e-11,
 -2.180902096849232e-12,  4.399151375590208e-14, -1.695362195819814e-15,  5.435045520165134e-17, -3.432775362685893e-19,  1.574857127896077e-20, -1.363611385064172e-21,
 -9.332757750629796e-24,  5.902035663785066e-25,  1.967949518274449e-06, -3.804048087530991e-08,  1.711739908544760e-09, -4.793558378679464e-11,  6.622707113998299e-13,
 -2.614371520342829e-14,  9.497016999067530e-16,  3.866756798059699e-18, -4.314956116656100e-20, -2.825340911629374e-20, -2.377222402999951e-22,  2.421165753987258e-23,
  3.595602303832355e-05, -5.986484300156658e-07,  2.113602456371822e-08, -5.225251070469142e-10,  4.901043364832539e-12, -2.062336453856269e-13,  9.059207943929870e-15,
  9.944912974121018e-17, -2.744967347294212e-18, -3.123137866788085e-19, -1.878449838527294e-21,  3.359687016968959e-22,  3.466953792496367e-04, -5.141146350606418e-06,
  1.389551257467069e-07, -3.015989452311205e-09,  1.997581904257720e-11, -8.762991553948597e-13,  4.670122278047527e-14,  6.951102525730744e-16, -2.250828518630211e-17,
 -1.762629729734289e-18, -5.652004900283114e-21,  2.106431102194754e-21,  1.867697240899542e-03, -2.534366240984218e-05,  5.108617485754327e-07, -9.447650198556656e-09,
  5.447164834716754e-11, -2.033395737145553e-12,  1.216963913163286e-13,  2.009323344264943e-15, -7.219298993076695e-17, -4.769012201702669e-18, -3.479277155562160e-21,
  6.050201010341088e-21,  5.729431300113262e-03, -7.282249735013555e-05,  1.075436873095669e-06, -1.580882980527393e-08,  1.236647321119213e-10, -2.480417688168045e-12,
  1.202573640697672e-13,  1.786658393293660e-15, -7.491122040420738e-17, -4.425668033707776e-18,  9.512928053297893e-21,  5.900622703658445e-21,  9.648537035049377e-03,
 -1.173316409585397e-04,  1.285450131564675e-06, -1.318485116437460e-08,  2.089818892365921e-10, -1.353929711620225e-12, -6.247967294466086e-14, -2.097090292545598e-15,
  6.139160836751012e-17,  3.843807281603356e-18,  8.205046585642373e-21, -4.859062830758860e-21,  7.076503850051033e-03, -8.399424223162551e-05,  7.395834725190265e-07,
 -4.625233176000931e-09,  1.644176815398378e-10, -1.638294383954250e-13, -1.478157130529146e-13, -3.592258480305548e-15,  1.245669844248174e-16,  7.287138084843567e-18,
 -4.372684298110952e-21, -9.584883397982937e-21,  3.809035058530755e-16, -1.792949326911776e-17,  2.805626076450083e-18, -1.999979592270073e-19,  1.251135160154123e-20,
 -8.009846397939306e-22,  4.365935728130811e-23, -2.057160311354655e-24,  9.567217597491489e-26, -4.200623301071282e-27,  1.581314645827007e-28, -5.662192160341821e-30,
  1.326292547263304e-12, -3.226625325146320e-14,  3.455759470446212e-15, -1.684655336280829e-16,  5.390153285266897e-18, -2.397788398798248e-19,  1.056527598637168e-20,
 -2.645967019909951e-22,  6.972473144978582e-24, -3.834558211342622e-25,  9.598369291229368e-27,  1.679021910781587e-29,  4.802639575717663e-10, -8.955481490940068e-12,
  7.079090325500699e-13, -2.947280734115122e-14,  5.900535252405896e-16, -1.965736208090096e-17,  1.053495567246455e-18, -1.695481860263272e-20, -1.187590192332464e-22,
 -2.373200597043316e-23,  9.129138942381258e-25,  2.833088601400826e-26,  4.738248729068164e-08, -7.565433869445993e-10,  4.495726447089327e-11, -1.680257435063333e-12,
  2.244854100255785e-14, -4.952685539247421e-16,  4.439278645965742e-17, -6.066110777945301e-19, -2.803738430145105e-20, -6.303266557608012e-22,  5.344375801321030e-23,
  1.450214946167746e-24,  1.839744543850518e-06, -2.649889562900447e-08,  1.186914792517285e-09, -4.026200215290608e-11,  3.712709632410688e-13, -3.146804833903757e-15,
  8.885298440196034e-16, -1.279535413196403e-17, -8.691616083313338e-19, -6.308479949230905e-21,  1.378734536685784e-21,  2.731386908249678e-23,  3.386146352249452e-05,
 -4.535415651201825e-07,  1.524024417252305e-08, -4.646559116019030e-10,  3.081580539750106e-12,  2.462357065228970e-14,  9.023282614747292e-15, -1.471045500269925e-16,
 -1.085263454343453e-17, -9.060469559557182e-21,  1.647186019570420e-20,  2.341928048904414e-22,  3.281313036742382e-04, -4.169751377234260e-06,  1.043128017934402e-07,
 -2.771258697928670e-09,  1.457594616133035e-11,  3.416452987791025e-13,  4.744429047709644e-14, -8.721523476889658e-16, -6.368235967982425e-17,  1.901349482158660e-19,
  9.571052489747901e-20,  9.744946266690057e-22,  1.773796583929362e-03, -2.169742997770572e-05,  4.019279492290085e-07, -8.730251220641867e-09,  4.558820633580424e-11,
  1.156161338697245e-12,  1.229924177807015e-13, -2.488116947179026e-15, -1.740557362583231e-16,  9.866086868083299e-19,  2.619388709577555e-19,  1.869334273334193e-21,
  5.454190701694349e-03, -6.494688232899766e-05,  8.965045043424486e-07, -1.405986196543063e-08,  1.049989470649060e-10,  6.042235730441754e-13,  1.164874893577651e-13,
 -2.535252687829611e-15, -1.600433073030109e-16,  1.357959502625781e-18,  2.438865901177977e-19,  9.384507927823293e-22,  9.198852398503316e-03, -1.076267343772523e-04,
  1.146095182149807e-06, -1.015364529552268e-08,  1.638127365161697e-10, -3.217614734688510e-12, -7.519064377552798e-14,  1.666279663307622e-15,  1.464521593468267e-16,
 -6.857989910669491e-19, -2.137670132340457e-19, -1.825631222686378e-21,  6.752069773694838e-03, -7.825649195486322e-05,  6.990647550558056e-07, -2.236693032149113e-09,
  1.207982755385519e-10, -4.249198225305762e-12, -1.586614046791446e-13,  3.646021878222339e-15,  2.718594136620520e-16, -1.936586727417104e-18, -4.044483750697141e-19,
 -2.234123225219716e-21,  3.424463538208079e-16, -2.605986668135011e-18,  1.220791319910233e-18, -8.584046334189766e-20,  3.627259747913667e-21, -2.038863093300361e-22,
  1.276391054788938e-23, -5.446679253662431e-25,  1.811933091142391e-26, -8.374110655982160e-28,  4.125255529497251e-29, -1.167138016909141e-30,  1.241404734821881e-12,
 -1.152650588404734e-14,  1.831908009636609e-15, -1.090125903638515e-16,  2.616242797867030e-18, -5.992177342886595e-20,  4.753926322005717e-21, -1.848015000698791e-22,
  4.532105706056826e-25,  1.916314838036379e-26,  8.556513747625905e-27, -2.244720144208841e-28,  4.537260274811808e-10, -4.568222534690621e-12,  4.018806653876291e-13,
 -2.197973877714195e-14,  4.068007469159366e-16, -9.889261243029541e-19,  4.580706431261299e-19, -2.568647867592514e-20, -1.401029269819732e-22,  2.233462494870150e-23,
  8.319843237709070e-25, -4.264784704436443e-26,  4.495598759813136e-08, -4.718448546564261e-10,  2.678944339373345e-11, -1.350140591794823e-12,  2.126931938191401e-14,
  2.607548427877622e-16,  1.480710443821474e-17, -1.391035283731455e-18, -6.623628653683337e-21,  1.658324435762170e-21,  2.848815641680712e-23, -2.682697516750991e-24,
  1.749824422663420e-06, -1.883325471070548e-08,  7.406222871827334e-10, -3.384355396624328e-11,  4.769158280474390e-13,  1.093470044167240e-14,  1.881396599381087e-16,
 -3.292354418598721e-17, -7.410022005627982e-20,  4.370744518034216e-20,  3.782097036256507e-22, -6.720706345028915e-23,  3.225714454690656e-05, -3.529807243288244e-07,
  1.000912963113959e-08, -4.017086222090163e-10,  5.219022323968243e-12,  1.568910297122346e-13,  9.187359465470808e-16, -3.723953922028441e-16,  8.034832963942177e-20,
  5.161527729539138e-19,  1.844517560294129e-21, -7.747115048362258e-22,  3.129174064541813e-04, -3.463440434542883e-06,  7.285092541564254e-08, -2.433616004274852e-09,
  2.975090247703797e-11,  9.896791753362913e-13,  7.082564811871588e-16, -2.093794525180458e-15,  4.746584921915036e-18,  2.953985686964250e-18,  3.906120311619875e-22,
 -4.369085309947007e-21,  1.692795153602901e-03, -1.888601905275760e-05,  3.027343498275856e-07, -7.689359106113279e-09,  8.973228648531747e-11,  2.745868066259174e-12,
 -5.513153373821507e-15, -5.621543667625445e-15,  2.224500188888302e-17,  7.972268504569550e-18, -1.933148465733619e-20, -1.167024577148991e-20,  5.207721276764386e-03,
 -5.841941277522706e-05,  7.386684412063359e-07, -1.216463138384071e-08,  1.367271274930707e-10,  2.078453418747069e-12, -6.390711337328414e-15, -5.200679005499733e-15,
  3.085185865144090e-17,  7.291297424043356e-18, -3.788947869399281e-20, -1.056710081566253e-20,  8.785967099250863e-03, -9.890620396673003e-05,  1.037600700644690e-06,
 -8.120988621346613e-09,  8.762034267177259e-11, -4.013687290978333e-12,  2.195976169614881e-14,  4.409187918299508e-15, -1.225492937494950e-17, -6.592784299221071e-18,
  8.819435470334145e-21,  9.649601536320987e-21,  6.450095319610700e-03, -7.274604303622820e-05,  6.804798553270244e-07, -1.140189735721526e-09,  1.041614253947877e-11,
 -6.020802485821825e-12,  3.375144926853444e-14,  8.399398596322839e-15, -3.979288452222678e-17, -1.225165302599418e-17,  4.649602334817233e-20,  1.779315533875040e-20,
  3.461248863870262e-16,  3.802941646904133e-18,  4.463545995711311e-19, -4.805165199243112e-20,  1.632056831158569e-21, -3.378610915431380e-23,  2.842511036647161e-24,
 -2.182642782950696e-25,  6.906246619638547e-27, -4.290864973782249e-29,  2.635615948812541e-30, -5.341937231576859e-31,  1.217249163488843e-12, -1.451562028778569e-15,
  7.507681157507118e-16, -7.224426404725550e-17,  2.157454965764257e-18, -3.894626521952354e-21,  2.112381133604064e-22, -1.190219604426450e-22,  4.033866222788336e-24,
  8.357986323918579e-26, -5.051913256322662e-27, -1.860658054512735e-28,  4.403704057283464e-10, -2.296390607076391e-12,  1.777925350546320e-13, -1.527453488028021e-14,
  4.397364358835784e-16,  1.734886651563829e-18, -1.820472557107755e-19, -1.519463533391646e-20,  7.304257033915346e-22,  1.219248524915845e-23, -1.122583129829252e-24,
 -1.544045412733026e-26,  4.340339732377252e-08, -3.160939450505839e-10,  1.282863983088768e-11, -9.617403372765149e-13,  2.700259252632931e-14,  1.817296589785896e-16,
 -1.798627877261011e-17, -6.713570543695031e-19,  4.414086097170180e-20,  4.783437343348764e-22, -6.844115984397686e-23, -2.791347318466565e-25,  1.683974461868515e-06,
 -1.438634225153950e-08,  3.874676718406221e-10, -2.451777419760084e-11,  6.707910407079444e-13,  5.533927445334433e-15, -5.429738215527233e-16, -1.287397346703180e-17,
  1.095723787067563e-18,  6.957617578821761e-21, -1.661189288357081e-21,  3.021203386001016e-24,  3.097714562127194e-05, -2.905407050539691e-07,  5.787872528598989e-09,
 -2.952316074450207e-10,  7.803767096062451e-12,  7.018629656766667e-14, -6.946161079424647e-15, -1.204412903274110e-16,  1.266886396690346e-17,  3.930161045877422e-20,
 -1.871911775655963e-20,  1.099923284642122e-22,  3.000576056443378e-04, -2.987937568591936e-06,  4.710869350434849e-08, -1.816764714967585e-09,  4.544326495162107e-11,
  4.099319138455494e-13, -4.179709001643613e-14, -5.750034813837218e-16,  7.195775698269449e-17,  5.260678494438343e-20, -1.038949668937112e-19,  9.178586290099498e-22,
  1.621550032817867e-03, -1.680494799140844e-05,  2.207295347928444e-07, -5.870404312644245e-09,  1.320237047215076e-10,  1.042108738411246e-12, -1.161151587286922e-13,
 -1.342431433794799e-15,  1.938507441493818e-16, -2.110154044002766e-19, -2.742388274983464e-19,  3.053559292663233e-21,  4.984994130683805e-03, -5.305390029914128e-05,
  6.070392635811477e-07, -9.697442635160393e-09,  1.664688026022759e-10,  5.010674004880709e-13, -1.054301937407641e-13, -1.072603345579972e-15,  1.779740364124227e-16,
 -5.524252191162575e-19, -2.450770195736119e-19,  3.365774050881012e-21,  8.406352776016595e-03, -9.097709194220605e-05,  9.461111000784818e-07, -7.294069414823955e-09,
  2.152856504414627e-11, -2.247228356111690e-12,  1.091189388129829e-13,  1.021213067280683e-15, -1.579487199302637e-16,  2.632657990162051e-20,  2.282028613085862e-19,
 -2.307532856594169e-21,  6.169904916727710e-03, -6.736259628313860e-05,  6.641680147669887e-07, -1.820287807639928e-09, -8.516330191273476e-11, -2.892672453950514e-12,
  1.952512428769606e-13,  1.741512647500959e-15, -2.957472656671289e-16,  5.957307103569766e-19,  4.159113629226740e-19, -5.147273835175600e-21,  3.654052605493677e-16,
  5.475393104728848e-18,  1.148556509558461e-20, -2.528447112936388e-20,  1.266447103595462e-21, -1.544456942448397e-23, -4.426550537975044e-25, -3.031745010300345e-26,
  4.184886124468202e-27, -1.317054746882915e-28, -1.639913271744385e-30,  1.785569145202477e-31,  1.218782052555405e-12,  1.665072550717226e-15,  8.685668769317270e-17,
 -3.892323289424499e-17,  1.941725259247947e-18, -2.304197717434399e-20, -1.180157629578996e-21,  1.375944048281355e-23,  3.008411158491287e-24, -1.158521262917285e-25,
 -1.862744834287494e-27,  2.109090904139259e-28,  4.330384160062338e-10, -1.487041607429087e-12,  3.681309418854267e-14, -8.293596187263545e-15,  4.105083055657445e-16,
 -5.004927836852845e-18, -2.757032159252515e-19,  6.814235174499885e-21,  4.339477704518223e-22, -2.181904446391341e-23, -1.860294560966922e-25,  3.613498691828874e-26,
  4.228170412324460e-08, -2.521797227226067e-10,  3.913502370926697e-12, -5.275716733025852e-13,  2.562418113191585e-14, -3.179075721237280e-16, -1.791618516236594e-17,
  5.455108403613339e-19,  2.094741513137781e-20, -1.302399398908939e-21, -3.825752115508829e-24,  1.960377048259563e-24,  1.631027703438032e-06, -1.227750911653617e-08,
  1.588438108664455e-10, -1.366025956590242e-11,  6.418678039810821e-13, -8.047710694823247e-15, -4.560139145942279e-16,  1.536721246178092e-17,  4.324075004670379e-19,
 -3.175809993226530e-20,  2.927537855976522e-23,  4.426898205902321e-23,  2.988821127347021e-05, -2.562408133210414e-07,  3.010030391703191e-09, -1.685514684579341e-10,
  7.492532449997914e-12, -9.445444744959594e-14, -5.314939786990518e-15,  1.903056163475359e-16,  4.312662634265851e-18, -3.614299779373001e-19,  1.318098945358839e-21,
  4.744468580676187e-22,  2.887393346739898e-04, -2.685652042263608e-06,  2.975991929546414e-08, -1.079610703995156e-09,  4.356591715799858e-11, -5.493579065009875e-13,
 -3.016763881334945e-14,  1.126181865780492e-15,  2.175964104156440e-17, -2.026492229305489e-18,  1.140636942057076e-20,  2.537845000133866e-21,  1.557467289834011e-03,
 -1.528439499298373e-05,  1.631501774145961e-07, -3.743620918279697e-09,  1.253052602049205e-10, -1.566431210579542e-12, -8.040620650343068e-14,  3.111220299231812e-15,
  5.315593259578966e-17, -5.399848669523017e-18,  3.861852198987017e-20,  6.507638375409111e-21,  4.781817946167170e-03, -4.861792180618034e-05,  5.065345970778896e-07,
 -7.090701378919793e-09,  1.517902632578252e-10, -1.821168519337593e-12, -6.956118643433257e-14,  2.889486315787658e-15,  4.359916617883589e-17, -4.886103349793529e-18,
  4.320666928556941e-20,  5.626266694748550e-21,  8.057032775837983e-03, -8.375494574226967e-05,  8.596297354340004e-07, -7.166867266407898e-09,  2.342704798736454e-12,
  1.986999455778374e-13,  7.750887397568437e-14, -2.648421026842717e-15, -4.458961153144298e-17,  4.457489395903827e-18, -2.882161269403494e-20, -5.481858465882902e-21,
  5.910906474040955e-03, -6.216252494280481e-05,  6.330660261136230e-07, -3.392533455161647e-09, -9.728658135270632e-11,  1.426088040907285e-12,  1.333596258236876e-13,
 -4.942421377033228e-15, -7.602780885749449e-17,  8.221926025551161e-18, -6.546844942002910e-20, -9.713551312216873e-21,  3.860189575699829e-16,  4.670343207692621e-18,
 -1.826713298271071e-19, -8.143604932966633e-21,  8.417334469019898e-22, -2.558480509239825e-23, -1.342246843747810e-25,  2.946559808310983e-26, -4.788377568700051e-29,
 -7.070973235372962e-29,  3.119959723692632e-30, -8.714383249016232e-33,  1.224562266923036e-12,  9.760054661406194e-16, -2.132917359658153e-16, -1.280566864840379e-17,
  1.268178107036911e-18, -3.982549364509539e-20, -8.358858536847517e-23,  4.443712899796152e-23, -7.019750791064244e-25, -5.747893649108641e-26,  3.012728143547621e-27,
 -1.079936065156228e-29,  4.271941001390721e-10, -1.488510058949492e-12, -2.754413872328578e-14, -2.801921375369277e-15,  2.647569275477070e-16, -8.473568673330270e-18,
 -3.647843971986395e-21,  9.207740754539232e-21, -1.974176191969384e-22, -8.447874199625086e-24,  5.384716158928824e-25, -4.167170620323844e-27,  4.130455304641805e-08,
 -2.398309339579875e-10, -2.266399149237611e-13, -1.857931927476454e-13,  1.641863561826152e-14, -5.297438287959087e-16,  2.753625997950388e-19,  5.663278806619361e-19,
 -1.391103389453601e-20, -4.078925990474417e-22,  3.070823234091818e-23, -3.372739164879069e-25,  1.583647440199283e-06, -1.150316334334108e-08,  4.974160877269901e-11,
 -5.111040776575134e-12,  4.102037522909527e-13, -1.323661445372397e-14,  1.506401061140043e-17,  1.397301194270535e-17, -3.708205236858370e-19, -8.371600821163048e-21,
  7.238866509145204e-22, -9.681014925229640e-24,  2.890124145156865e-05, -2.383920420536799e-07,  1.627215207590286e-09, -6.876580609074451e-11,  4.793034271562049e-12,
 -1.533293945462445e-13,  2.434525440960149e-16,  1.598040136120665e-16, -4.456502082862917e-18, -8.282756469203824e-20,  8.035159569317080e-21, -1.217243696135080e-22,
  2.784062097096555e-04, -2.488578505656516e-06,  2.052786214386282e-08, -4.984523254494398e-10,  2.803877393035724e-11, -8.763312076809863e-13,  1.724353189952785e-15,
  8.973101956017833e-16, -2.590063869362299e-17, -4.142136018145926e-19,  4.421552699320745e-20, -7.291139371486531e-22,  1.498699904834215e-03, -1.412771285258883e-05,
  1.289671660521275e-07, -2.063245303220194e-09,  8.204081504784484e-11, -2.416871144925032e-12,  5.818393927428695e-15,  2.386942731658708e-15, -7.077242560834817e-17,
 -1.002010406015990e-18,  1.160857129021384e-19, -2.037426332101915e-21,  4.594965987107111e-03, -4.486792781482271e-05,  4.346000763640029e-07, -5.015696312184664e-09,
  1.054242202972196e-10, -2.503646619688045e-12,  8.839011820475864e-15,  2.129985184495345e-15, -6.549087194395310e-17, -8.067293084487495e-19,  1.032469994144379e-19,
 -1.937022576092983e-21,  7.735224352237079e-03, -7.722045240208706e-05,  7.742387357029385e-07, -7.022888734860863e-09,  1.864911303614286e-11,  1.139060987812613e-12,
  3.881199413403528e-15, -2.059279538991160e-15,  5.875562304746266e-17,  8.585495000733593e-19, -9.664382796687138e-20,  1.651010093339143e-21,  5.672094225629399e-03,
 -5.728424524399380e-05,  5.843872063642121e-07, -4.595848264009608e-09, -4.834647022599940e-11,  2.930753216952983e-12, -1.735186214400886e-15, -3.715693881989423e-15,
  1.100994112680080e-16,  1.437657476319073e-18, -1.755123654702069e-19,  3.182488395789101e-21,  4.014307855476142e-16,  3.008304944306360e-18, -2.163317293756195e-19,
  1.310773197639414e-21,  3.567044982828404e-22, -2.063777680420071e-23,  4.413737547954955e-25,  8.088220951408543e-27, -7.846838024866147e-28,  1.305098504332910e-29,
  7.824134926118342e-31, -5.371410433172068e-32,  1.224488936323319e-12, -1.059445585220626e-15, -2.708445001767902e-16,  1.364646259158213e-18,  5.339722069327722e-19,
 -3.058958839640765e-20,  6.834334879843438e-22,  8.856091788835483e-24, -1.045899997148671e-24,  2.167600436190376e-26,  6.708565145071364e-28, -5.377397520255988e-29,
  4.206715131027937e-10, -1.783877559215485e-12, -4.115503074132313e-14,  1.462172535539019e-16,  1.109030251253218e-16, -6.329481615028459e-18,  1.457645740970249e-19,
  1.476363260296207e-21, -2.063691733739906e-22,  4.822068051357146e-24,  9.466863485421219e-26, -9.278016955275583e-27,  4.033275670428617e-08, -2.468764146323136e-10,
 -1.216110657629151e-12, -3.107142308701228e-15,  6.884261683854451e-15, -3.893030185539029e-16,  9.128114922904641e-18,  7.768549705001029e-20, -1.235140734189481e-20,
  3.097897007724232e-22,  4.294895976670434e-24, -5.121397019940228e-25,  1.538174046751760e-06, -1.125842155688740e-08,  1.941731386227016e-11, -5.389138525410432e-13,
  1.733061828174368e-13, -9.627319895287893e-15,  2.281187899844337e-16,  1.703834640201849e-18, -2.995507242640291e-19,  7.865666113163956e-21,  8.208225311643277e-23,
 -1.176679161905429e-23,  2.797002611056082e-05, -2.275960592333662e-07,  1.165408824550308e-09, -1.507713955565745e-11,  2.059368947393154e-12, -1.107727943344230e-13,
  2.637360616914790e-15,  1.776271062851937e-17, -3.386688591969329e-18,  9.178433636334483e-20,  7.529924530178842e-22, -1.280494431270051e-22,  2.687515314570884e-04,
 -2.341936907525503e-06,  1.668617514324289e-08, -1.810103661012201e-10,  1.245699390835818e-11, -6.305789267685530e-13,  1.498759773743118e-14,  9.231852129997139e-17,
 -1.887012571874039e-17,  5.232371823507475e-19,  3.485784065408103e-21, -6.938809385042466e-22,  1.444122558353215e-03, -1.317622706008115e-05,  1.105642155846366e-07,
 -1.111737524262039e-09,  3.914954682008138e-11, -1.737589525297825e-12,  4.069023061424394e-14,  2.273114342557277e-16, -4.996962410395323e-17,  1.410615772273067e-18,
  7.786421762293991e-21, -1.799277651064430e-21,  4.422102345706978e-03, -4.160685296931831e-05,  3.829622677832929e-07, -3.702050622930204e-09,  6.105416143814420e-11,
 -1.815776645825829e-12,  3.932519358334738e-14,  1.695923172605207e-16, -4.468989594619037e-17,  1.289940014952000e-18,  5.550951846449699e-21, -1.577189156902943e-21,
  7.438206008675346e-03, -7.135688560979790e-05,  6.924785275676748e-07, -6.552837184157711e-09,  3.882695259134436e-11,  7.588719228811987e-13, -2.712586358955517e-14,
 -2.549705295046904e-16,  4.205186829766324e-17, -1.167156364123652e-18, -6.943516865709913e-21,  1.507048570903210e-21,  5.451945266638981e-03, -5.283860419258780e-05,
  5.264438176347927e-07, -4.930745646846160e-09,  3.534473308271804e-12,  2.046107111289457e-12, -5.644558925613654e-14, -3.903015427563559e-16,  7.647938469257332e-17,
 -2.169038925480950e-18, -1.060032980981574e-20,  2.702502353979428e-21,  4.102028901541460e-16,  1.410160332370409e-18, -1.780129629934910e-19,  4.324403674716584e-21,
  5.587431854047523e-23, -9.609792540787288e-24,  4.083316035691066e-25, -7.049371262473388e-27, -1.639772683504840e-28,  1.411795186245588e-29, -3.499310975052708e-31,
 -3.318550198323079e-33,  1.216172615427517e-12, -3.055986555028028e-15, -2.204208234235939e-16,  5.931601861575410e-18,  9.016428915957820e-20, -1.418295968591799e-20,
  5.953229851300746e-22, -1.054772071541773e-23, -1.966278489349979e-25,  1.818247649217172e-26, -4.602684920188462e-28, -2.644316553200548e-30,  4.129201219809407e-10,
 -2.084296846572522e-12, -3.230465210678844e-14,  1.100832050668100e-15,  1.951086084429478e-17, -2.911085218384463e-18,  1.222527289698694e-19, -2.230680912959241e-21,
 -3.472391562169191e-23,  3.506574754805499e-24, -9.252843995199379e-26, -2.270799435254023e-28,  3.932751908794870e-08, -2.553954487290451e-10, -8.105061258022721e-13,
  5.672795362002588e-14,  1.279432512528657e-15, -1.781887286193728e-16,  7.480942188008464e-18, -1.392285910238161e-19, -1.907089269733837e-21,  2.067148947504969e-22,
 -5.631021069241312e-24, -1.487210357698816e-27,  1.493459788866797e-06, -1.109449929207294e-08,  2.420213487032998e-11,  9.912202474224743e-13,  3.490062889838257e-14,
 -4.399125882936611e-15,  1.841235052841777e-16, -3.472444926269709e-18, -4.329328396286003e-20,  4.961047310668524e-21, -1.383313147184896e-22,  1.698448114976543e-25,
  2.707773962614076e-05, -2.185822921353518e-07,  1.120230399656471e-09,  3.576349431478619e-12,  4.668662685953828e-13, -5.071212662878947e-14,  2.106123075932564e-15,
 -4.006517842333018e-17, -4.648501431943108e-19,  5.567122158542968e-20, -1.579385834939491e-21,  3.604706110799496e-24,  2.596406858890457e-04, -2.214579052930280e-06,
  1.535698078897578e-08, -6.317338085683372e-11,  3.372645349237826e-12, -2.909042306776874e-13,  1.187567905198171e-14, -2.269633310305989e-16, -2.484819116898703e-18,
  3.085224124520438e-19, -8.868101919915453e-21,  2.706536578227899e-23,  1.393114170875708e-03, -1.233672484521173e-05,  1.000061814311530e-07, -7.107889328559730e-10,
  1.394202587716087e-11, -8.193088734974256e-13,  3.204380673176662e-14, -6.117509064800439e-16, -6.341042916608754e-18,  8.138837846071382e-19, -2.364149547362438e-20,
  8.618055947949108e-23,  4.261541197863400e-03, -3.870667524069778e-05,  3.433651571952097e-07, -2.965178413819406e-09,  3.390505394285388e-11, -9.347991129910342e-13,
  3.074064352885365e-14, -5.726153116547990e-16, -5.332597544214128e-18,  7.263355930904431e-19, -2.137299701288249e-20,  9.197771153914583e-23,  7.163376244403403e-03,
 -6.612011163430239e-05,  6.179570152045439e-07, -5.845745118991585e-09,  4.753847066226793e-11,  1.360543459165188e-13, -2.154731293340339e-14,  4.594380318751806e-16,
  5.760588557989695e-18, -6.805081938029161e-19,  1.960034499439583e-20, -6.648170316044607e-23,  5.248644067351578e-03, -4.886013762320950e-05,  4.687260060305502e-07,
 -4.620077340133839e-09,  3.115192989515084e-11,  7.663025323902109e-13, -4.440409855517460e-14,  8.944200521534051e-16,  9.837761338685981e-18, -1.237625350957052e-18,
  3.608431942812459e-20, -1.432380762278578e-22,  4.133300974103711e-16,  1.973197727355179e-19, -1.255717111541591e-19,  4.140570212256489e-21, -5.573546348358023e-23,
 -2.398490009795817e-24,  1.947640562714667e-25, -6.804042158414689e-27,  1.067345297993366e-28,  2.119963326554161e-30, -1.898765002280316e-31,  5.677832489714602e-33,
  1.200884648871675e-12, -4.527153468499226e-15, -1.477227041656319e-16,  5.774556855478913e-18, -7.610639400216717e-20, -3.670683629333573e-21,  2.855664114428230e-22,
 -9.773750066602580e-24,  1.519040803844294e-25,  2.749813973668184e-27, -2.457727989903660e-28,  7.100915350407866e-30,  4.041525521569495e-10, -2.288086466851603e-12,
 -1.868724556954237e-14,  1.084402579179728e-15, -1.467413710013294e-17, -7.602096221753753e-19,  5.833443993405309e-20, -1.992523425587820e-21,  3.152307275740806e-23,
  5.006826722686861e-25, -4.707540168078192e-26,  1.370487344183727e-27,  3.829748624970507e-08, -2.590228426655090e-10, -9.670831241848325e-14,  5.706754670351588e-14,
 -8.166153323767041e-16, -4.693627429609242e-17,  3.553749269022902e-18, -1.213802231751582e-19,  1.949187785506638e-21,  2.797936313682117e-23, -2.756920097745620e-24,
  8.117501358576130e-26,  1.449550703125812e-06, -1.084910677777009e-08,  3.722832780347695e-11,  1.051745002467526e-12, -1.700987771365520e-14, -1.174721668503807e-15,
  8.721266140574299e-17, -2.977243433787761e-18,  4.834210774932460e-20,  6.425773410235889e-22, -6.581693880960039e-23,  1.957535744788471e-24,  2.622170369926777e-05,
 -2.093829826106811e-07,  1.182320479591882e-09,  5.286601539358038e-12, -1.351176974873878e-13, -1.386809966346491e-14,  9.963942594262368e-16, -3.394360434008033e-17,
  5.555630376898616e-19,  6.959185123200842e-21, -7.355671549765902e-22,  2.205823557941614e-23,  2.510241056450199e-04, -2.094190730913863e-06,  1.477478762435555e-08,
 -4.248373366911894e-11, -1.213853995782700e-13, -8.317331500341236e-14,  5.624936405138302e-15, -1.905753808423244e-16,  3.136055610800653e-18,  3.746912375771474e-20,
 -4.063681026876684e-21,  1.226709070029663e-22,  1.345317368195592e-03, -1.156800447866289e-05,  9.239348489881668e-08, -5.829715659068923e-10,  3.832783030183893e-12,
 -2.577818639048263e-13,  1.527749708020291e-14, -5.099162376170053e-16,  8.411866418306778e-18,  9.638348403013210e-20, -1.069448219308187e-20,  3.246234428459658e-22,
  4.111994426508392e-03, -3.609404839992424e-05,  3.105356162075979e-07, -2.537723445879137e-09,  2.127072354725455e-11, -3.900562637782023e-13,  1.516794185971548e-14,
 -4.724679557727983e-16,  7.743409109512078e-18,  8.286612585563641e-20, -9.525219015218569e-21,  2.911385700667375e-22,  6.908357158244540e-03, -6.144407417464999e-05,
  5.523828700847515e-07, -5.086949177221825e-09,  4.616049216061597e-11, -2.234348558203783e-13, -8.787641938308538e-15,  3.880793563961340e-16, -6.648008650355393e-18,
 -8.368109276399849e-20,  8.925371052874711e-21, -2.697481679609722e-22,  5.060365084036213e-03, -4.532278804577852e-05,  4.166177042910218e-07, -4.048220269659970e-09,
  3.789299382672730e-11,  4.858214333388945e-15, -1.982132311894293e-14,  7.461532369281085e-16, -1.257745471180192e-17, -1.466247650813619e-19,  1.621503614981704e-20,
 -4.932518140437200e-22,  4.124004255715949e-16, -6.259538313989907e-19, -8.215496198081545e-20,  3.061663887754928e-21, -7.025433909570973e-23,  4.048418303872297e-25,
  5.564666236623331e-26, -3.201713346424919e-27,  9.760988836841102e-29, -1.494811087878428e-30, -1.888677541793425e-32,  2.008087710969306e-33,  1.180817291982284e-12,
 -5.456036901558705e-15, -8.717967397380985e-17,  4.259377628337632e-18, -1.001257534721336e-19,  4.857974064455690e-22,  8.452691670152799e-23, -4.682337556983653e-24,
  1.386901013465972e-25, -2.036221604226416e-27, -2.733958314989955e-29,  2.670205928430282e-30,  3.947769847413284e-10, -2.390271217523897e-12, -7.385109103928979e-15,
  7.872402261175216e-16, -1.977592344278639e-17,  9.066101263523631e-20,  1.740361441833778e-20, -9.542396973446650e-22,  2.809596085366726e-23, -4.133741377893109e-25,
 -5.141774341193774e-27,  5.134756631376742e-28,  3.726380860853183e-08, -2.573258219003985e-10,  4.909015485710404e-13,  4.010297719232233e-14, -1.139611577035011e-15,
  4.946335517782113e-18,  1.064532179718154e-18, -5.800675337053239e-20,  1.704731723129351e-21, -2.524795783433538e-23, -2.917215741786476e-25,  3.006481279303245e-26,
  1.406821750881299e-06, -1.050659724683002e-08,  4.773981206066978e-11,  6.802844559289323e-13, -2.538530999258465e-14,  9.984939835595723e-17,  2.623974178838554e-17,
 -1.420110230090349e-18,  4.169473802145681e-20, -6.213389613583362e-22, -6.757312822669419e-24,  7.169335151782590e-25,  2.540341985950641e-05, -1.997215043407232e-07,
  1.227051390650235e-09,  1.919436525668438e-12, -2.395645615590204e-13,  7.204971850755527e-16,  3.019065392776724e-16, -1.617088213723060e-17,  4.742343349011178e-19,
 -7.102324648373099e-21, -7.358084040753087e-23,  8.002428232741542e-24,  2.428803473329826e-04, -1.978151586644212e-06,  1.421774530486462e-08, -5.200210604545264e-11,
 -8.065077518134365e-13, -5.058280864952183e-16,  1.727639840327991e-15, -9.077364019156492e-17,  2.655926586417111e-18, -3.992425624898852e-20, -3.977019210229378e-22,
  4.416024989969840e-23,  1.300480431774959e-03, -1.085608092528898e-05,  8.564826357182719e-08, -5.472602972672417e-10,  1.349354841715974e-12, -3.115430538607713e-14,
  4.845994125632217e-15, -2.433810189335115e-16,  7.077985992586353e-18, -1.066402923980769e-19, -1.026625308158591e-21,  1.161085828338149e-22,  3.972401459216932e-03,
 -3.372627317017020e-05,  2.819205129863197e-07, -2.244001991306640e-09,  1.618700828269600e-11, -1.560851794398442e-13,  5.461560515182997e-15, -2.286459525588817e-16,
  6.459574103959981e-18, -9.718169023445901e-20, -8.895811562424491e-22,  1.033284731258690e-22,  6.671049583615315e-03, -5.725702666630160e-05,  4.955953177966162e-07,
 -4.392343613806849e-09,  4.033414724564646e-11, -3.288249571132424e-13, -9.816325355840088e-16,  1.757536661871765e-16, -5.643455045694124e-18,  8.633566496002121e-20,
  8.779684631101520e-22, -9.682765784950277e-23,  4.885446538416178e-03, -4.217398279262683e-05,  3.716136465612133e-07, -3.460743129725869e-09,  3.468276780130167e-11,
 -2.669811792393103e-13, -4.684356899597255e-15,  3.473614626986146e-16, -1.057682726756951e-17,  1.609565296862359e-19,  1.552577309926590e-21, -1.758280054717098e-22,
  4.087890883096472e-16, -1.154383869878804e-18, -5.172660125352996e-20,  2.050141938047640e-21, -5.445855775452033e-23,  9.659683912992032e-25,  1.358668252124045e-27,
 -9.601607763773527e-28,  4.441888509221181e-29, -1.222614205707744e-30,  1.879606639332245e-32,  1.036763579328426e-34,  1.157885179716787e-12, -5.974991646176809e-15,
 -4.510359517777840e-17,  2.808858734151680e-18, -7.845104957653986e-20,  1.371926964973058e-21,  4.054726728182096e-24, -1.459451699900581e-24,  6.499100699075197e-26,
 -1.726675818455889e-27,  2.491823360869819e-29,  1.898776061905457e-31,  3.851502949451116e-10, -2.416696674695202e-12,  2.758137388307919e-16,  5.005861136904467e-16,
 -1.548564205065178e-17,  2.750202230023456e-19,  9.492118281592969e-22, -3.004406945095006e-22,  1.323293591500757e-23, -3.481580401295319e-25,  4.967575319343372e-27,
  3.764717837221966e-29,  3.624498838229159e-08, -2.517694336355742e-10,  8.692295660429971e-13,  2.359630795706477e-14, -8.885874890805836e-16,  1.629981898556660e-17,
  6.292844545395894e-20, -1.834583878822237e-20,  8.035987903415912e-22, -2.105751763501959e-23,  2.999786788437958e-25,  2.182404997404152e-27,  1.365601562838247e-06,
 -1.009861287792148e-08,  5.361196738617455e-11,  3.132320707933848e-13, -1.962289444481414e-14,  3.818974897515556e-16,  1.696897069361875e-18, -4.505515209855796e-19,
  1.965174864963348e-20, -5.138476442529907e-22,  7.326519418366557e-24,  5.109579719342100e-26,  2.462422441916885e-05, -1.898751187249337e-07,  1.228484052349314e-09,
 -1.530839140308731e-12, -1.815419191402841e-13,  4.004678988213573e-15,  2.216558268834528e-17, -5.148150001969025e-18,  2.234563858362425e-19, -5.833887756949708e-21,
  8.329827186315836e-23,  5.596664566552854e-25,  2.351909760089445e-04, -1.867114876949378e-06,  1.352127561265269e-08, -6.344317098787961e-11, -5.640201870848837e-13,
  1.869845435294803e-14,  1.548292870777629e-16, -2.905906215805946e-17,  1.251459934712752e-18, -3.261763239358519e-20,  4.663410760330146e-22,  3.035573409832142e-24,
  1.258385383954434e-03, -1.019681238060787e-05,  7.920526168601833e-08, -5.262392465700868e-10,  1.454155637977668e-12,  2.533359020017517e-14,  6.131777288254332e-16,
 -7.890077303099630e-17,  3.338236718417697e-18, -8.673294409459377e-20,  1.241117055220683e-21,  7.855130064380298e-24,  3.841842500577370e-03, -3.157441852192178e-05,
  2.564614669192804e-07, -2.004660458596181e-09,  1.396419101467657e-11, -8.177819479416373e-14,  1.418076447786414e-15, -7.826183556630113e-17,  3.065904060871338e-18,
 -7.858411563454418e-20,  1.123513285973130e-21,  6.831761967535985e-24,  6.449632011299044e-03, -5.349262691265236e-05,  4.465418720590891e-07, -3.799545457551856e-09,
  3.382772947270217e-11, -3.107875595209187e-13,  1.889595812855435e-15,  4.554935520778601e-17, -2.603048593785744e-18,  7.054835260422774e-20, -1.017021931344825e-21,
 -6.680722823402493e-24,  4.722446159251791e-03, -3.935818720742066e-05,  3.332258130084010e-07, -2.951955115618964e-09,  2.883235417306609e-11, -2.954533453544208e-13,
  1.192432983281578e-15,  1.024942747965710e-16, -4.933969614973345e-18,  1.307542992519431e-19, -1.880027408744424e-21, -1.186054600951503e-23,  4.034807329112587e-16,
 -1.483158109273019e-18, -3.172869390754338e-20,  1.328411053122503e-21, -3.631425180129857e-23,  8.011107321521167e-25, -1.121118142869554e-26, -9.961023261011865e-29,
  1.350571326531057e-29, -5.334234109623022e-31,  1.352495610802935e-32, -2.095800943702755e-34,  1.133449629867705e-12, -6.220268346205203e-15, -1.803524392973476e-17,
  1.768104831369553e-18, -5.235311814869383e-20,  1.163422032737826e-21, -1.564943946757218e-23, -1.806796453463340e-25,  2.060918132745456e-26, -7.827602549708677e-28,
  1.907348839314260e-29, -2.746673333794242e-31,  3.755205668875983e-10, -2.394259230506984e-12,  4.975709575439593e-15,  2.959229207930881e-16, -1.023559342261595e-17,
  2.345158585507408e-19, -3.141843647675191e-21, -3.888566447839037e-23,  4.249259320555943e-24, -1.594170753173608e-25,  3.835137287752123e-27, -5.410522155460818e-29,
  3.525330292093882e-08, -2.439000446765615e-10,  1.077735281812702e-12,  1.193842031227819e-14, -5.767449676383503e-16,  1.393529511674638e-17, -1.879922592822486e-19,
 -2.429936443896921e-21,  2.595572695867823e-22, -9.678528650039068e-24,  2.314534011930344e-25, -3.239790246385139e-27,  1.326081936079066e-06, -9.659441367754638e-09,
  5.573709524793103e-11,  5.937258511558377e-14, -1.229734714136297e-14,  3.272553908345837e-16, -4.487940789817086e-18, -6.086897617985854e-20,  6.369996893801729e-21,
 -2.365842928967440e-22,  5.638597314163943e-24, -7.865425642351140e-26,  2.388420165945816e-05, -1.801640233024734e-07,  1.195318793753934e-09, -3.802586791976442e-12,
 -1.043672646452687e-13,  3.444107552002839e-15, -4.881987466969873e-17, -7.130738562025925e-19,  7.263880330229817e-20, -2.688517318211633e-21,  6.393304279073324e-23,
 -8.903420236239329e-25,  2.279338564371934e-04, -1.762114711526278e-06,  1.271821896643249e-08, -6.948168574838470e-11, -1.995402129425412e-13,  1.622095400298884e-14,
 -2.488218901503012e-16, -4.195095378203569e-18,  4.081485655313734e-19, -1.504189121566298e-20,  3.570432410167469e-22, -4.967886893022996e-24,  1.218826036509013e-03,
 -9.587993503808419e-06,  7.304769656753857e-08, -4.986873040825250e-10,  1.980447538563543e-12,  2.307125152497563e-14, -5.011190524594357e-16, -1.245220842204131e-17,
  1.095365399302753e-18, -4.003502916212932e-20,  9.481424252073657e-22, -1.318375746713834e-23,  3.719501065593900e-03, -2.961526751331542e-05,  2.336964976553892e-07,
 -1.793044736567776e-09,  1.253881198502145e-11, -6.525516169113993e-14,  2.371604576259106e-16, -1.675607385445283e-17,  1.031568954944443e-18, -3.640645126181095e-20,
  8.558453471170521e-22, -1.188076675616789e-23,  6.242529797260893e-03, -5.009392380322499e-05,  4.039984875826820e-07, -3.305272216373392e-09,  2.812906426163489e-11,
 -2.574825022765950e-13,  2.324174373823808e-15, -4.976633349818275e-18, -7.852217111628951e-19,  3.220828478741929e-20, -7.784655793531767e-22,  1.087202644960144e-23,
  4.570131171665833e-03, -3.682666741698523e-05,  3.003822997820480e-07, -2.535649746802185e-09,  2.336626704196642e-11, -2.464128603178103e-13,  2.455305645593697e-15,
  5.408075567843655e-18, -1.558756722775872e-18,  6.004348305227385e-20, -1.435008424257942e-21,  1.999349118310176e-23,  1.936882174491779e+00,  4.388054585875986e-02,
 -1.659607341784822e-02,  5.688618058666717e-03, -1.875061224332154e-03,  6.117181339222232e-04, -2.010486418379434e-04,  6.734716848516953e-05, -2.312958268865496e-05,
  8.128434390343161e-06, -2.870225718419239e-06,  9.171599764874334e-07,  1.959920566409411e+00,  2.768039938971745e-02, -1.021503543146196e-02,  3.402613456764988e-03,
 -1.091887946138725e-03,  3.484081315937375e-04, -1.127098943902089e-04,  3.742173633863371e-05, -1.281848762805033e-05,  4.512404659974981e-06, -1.598753539043794e-06,
  5.122950662975227e-07,  1.973397857559409e+00,  1.835613932341033e-02, -6.738601397869164e-03,  2.218751153157645e-03, -7.039553937903532e-04,  2.226799464544834e-04,
 -7.167364582257836e-05,  2.376338267569038e-05, -8.151398051616644e-06,  2.877697328175059e-06, -1.022537193885996e-06,  3.283002715972265e-07,  1.982535661952416e+00,
  1.209751312463291e-02, -4.485123173397994e-03,  1.474392838249966e-03, -4.660335978144077e-04,  1.469795832928157e-04, -4.725166963400855e-05,  1.567646064638101e-05,
 -5.387785495304094e-06,  1.906563912699179e-06, -6.788409202890347e-07,  2.182245964009257e-07,  1.989140086643818e+00,  7.605669985892617e-03, -2.907242535127360e-03,
  9.638912971879558e-04, -3.054503263156455e-04,  9.643973285674304e-05, -3.104189872821371e-05,  1.031670252678606e-05, -3.553118963881000e-06,  1.259844604506380e-06,
 -4.492561187914511e-07,  1.445465766194401e-07,  1.994058884748155e+00,  4.277415458092162e-03, -1.759310766694291e-03,  5.979851735125125e-04, -1.916087683161537e-04,
  6.085919297560512e-05, -1.966651596400945e-05,  6.556035622908242e-06, -2.263536758345920e-06,  8.041342918980668e-07, -2.871243735299848e-07,  9.244550393912216e-08,
  1.997755018698354e+00,  1.786059180763813e-03, -9.118199703080973e-04,  3.307914583438392e-04, -1.091246471244036e-04,  3.519876142109178e-05, -1.147772144910942e-05,
  3.848018022435480e-06, -1.333479214651729e-06,  4.748484988533350e-07, -1.697886092939091e-07,  5.470535695716195e-08,  2.000504214799661e+00, -6.169633760552611e-05,
 -2.897749266782647e-04,  1.362579245112415e-04, -4.940620904420155e-05,  1.667941723501143e-05, -5.574192230184065e-06,  1.894884004652791e-06, -6.618426912780606e-07,
  2.367203018602490e-07, -8.484100726719285e-08,  2.736562281907577e-08,  2.002478540635897e+00, -1.385860471691852e-03,  1.525966877800927e-04, -1.274977866078508e-06,
 -7.353190159433952e-06,  3.666421523076224e-06, -1.428621304643418e-06,  5.227823414625754e-07, -1.895586536281871e-07,  6.910095686327921e-08, -2.499938312849136e-08,
  8.097898014202626e-09,  2.003786515783222e+00, -2.261823976459842e-03,  4.436731338990997e-04, -9.140412888911061e-05,  2.013127867575118e-05, -4.826393341648422e-06,
  1.275934876352434e-06, -3.726726181497160e-07,  1.188702765683957e-07, -4.044113783589199e-08,  1.412864117397172e-08, -4.503996142787507e-09,  2.004494011053704e+00,
 -2.735214109705674e-03,  6.004598469599248e-04, -1.398315694308572e-04,  3.487502967683961e-05, -9.378457954744122e-06,  2.725257745944328e-06, -8.526379145138743e-07,
  2.842582797773400e-07, -9.920569444744902e-08,  3.512571797824770e-08, -1.126759975589342e-08,  1.992612321727803e+00,  4.922077932667394e-03, -1.571585532911670e-03,
  4.316829318892280e-04, -1.099959562441736e-04,  2.680900507553064e-05, -6.347764996598517e-06,  1.473310318403508e-06, -3.370999458852241e-07,  7.631763931602528e-08,
 -1.710621125924166e-08,  3.641398057560166e-09,  1.995253311296667e+00,  3.184554704202318e-03, -1.038305897193185e-03,  2.851262600079057e-04, -7.211313625853213e-05,
  1.739006583761882e-05, -4.067617906155535e-06,  9.319097468753190e-07, -2.104063762272204e-07,  4.700424213563705e-08, -1.039918558195669e-08,  2.187938791862903e-09,
  1.997016384978968e+00,  2.032091876420638e-03, -6.938420973122606e-04,  1.929100754158677e-04, -4.888142985763971e-05,  1.175702496552154e-05, -2.736874188874466e-06,
  6.233437456160836e-07, -1.398385970182615e-07,  3.103487903013856e-08, -6.821915478008897e-09,  1.427057543593524e-09,  1.998316762944323e+00,  1.185904752411085e-03,
 -4.456298714956118e-04,  1.276707079811045e-04, -3.273540485050159e-05,  7.908445266261905e-06, -1.842464684579113e-06,  4.191690909392426e-07, -9.383265442126749e-08,
  2.076874345106387e-08, -4.552103113829390e-09,  9.496899043763659e-10,  1.999314534708141e+00,  5.388301844717263e-04, -2.585173362974938e-04,  7.916694505887302e-05,
 -2.088942890448413e-05,  5.120237504640671e-06, -1.202174142517004e-06,  2.746357349960151e-07, -6.160517972768332e-08,  1.364682734015243e-08, -2.991406131470485e-09,
  6.239180738238955e-10,  2.000091420918397e+00,  3.632510433933194e-05, -1.148219868425656e-04,  4.231550539358017e-05, -1.198057442913936e-05,  3.043400572259856e-06,
 -7.295146730575143e-07,  1.688295499234110e-07, -3.819383942868172e-08,  8.509398039526852e-09, -1.872672777241443e-09,  3.916221346092126e-10,  2.000695160084424e+00,
 -3.533872851352744e-04, -4.352052828238770e-06,  1.422106962863301e-05, -5.242175465859233e-06,  1.484106418344253e-06, -3.770648992743353e-07,  9.042831829372674e-08,
 -2.094556052134920e-08,  4.743910893552117e-09, -1.056435791653506e-09,  2.227706580269026e-10,  2.001155771054592e+00, -6.502418212589859e-04,  7.922610024966385e-05,
 -6.897322002273476e-06, -2.076179055122874e-07,  3.256425208531030e-07, -1.165722461838770e-07,  3.275644897998160e-08, -8.311821998534375e-09,  1.996297227246654e-09,
 -4.628164001213109e-10,  1.003004704686266e-10,  2.001492814378569e+00, -8.672024994982407e-04,  1.399986484298285e-04, -2.217889370499856e-05,  3.418973387503062e-06,
 -5.053513805512896e-07,  6.956904790785002e-08, -8.311272358182023e-09,  6.566156712754292e-10,  5.117008642814669e-11, -4.356986171198925e-11,  1.396935896368080e-11,
  2.001719044723481e+00, -1.012709168194816e-03,  1.806087331644990e-04, -3.235554168191190e-05,  5.826368150182096e-06, -1.055357477289727e-06,  1.924392300581366e-07,
 -3.535421061554367e-08,  6.549605565294096e-09, -1.224528820965908e-09,  2.309460853719720e-10, -4.248644721453629e-11,  2.001842405622064e+00, -1.092011146417253e-03,
  2.026915664806513e-04, -3.787759333177009e-05,  7.130083738151652e-06, -1.352669489228022e-06,  2.587483019756125e-07, -4.992674864457735e-08,  9.720965644704403e-09,
 -1.910269171438556e-09,  3.783653047467655e-10, -7.278068685844504e-11,  1.999025041462761e+00,  6.678789303783351e-04, -2.302485571008417e-04,  6.208475119094106e-05,
 -1.505177876630858e-05,  3.438256069720278e-06, -7.561102217301338e-07,  1.619608848792595e-07, -3.403172771318276e-08,  7.046618819413532e-09, -1.440292639698197e-09,
  2.808404900031832e-10,  1.999512092906803e+00,  3.547349489541138e-04, -1.430719705475290e-04,  4.038715634545021e-05, -9.977111970308284e-06,  2.297514661671723e-06,
 -5.066322247195138e-07,  1.084899087592091e-07, -2.274668070236807e-08,  4.693878048629862e-09, -9.553471455832471e-10,  1.854536243057702e-10,  1.999853244210302e+00,
  1.360289265752931e-04, -8.295881347328205e-05,  2.561545072673656e-05, -6.565882099085638e-06,  1.540293030468611e-06, -3.430809857561840e-07,  7.386555419349812e-08,
 -1.552785021156946e-08,  3.206921791680610e-09, -6.524697347992900e-10,  1.265238837265510e-10,  2.000113534988158e+00, -3.048822842017000e-05, -3.761700063937775e-05,
  1.457704503792496e-05, -4.040210870451452e-06,  9.847309228310221e-07, -2.241581164541477e-07,  4.891065358497992e-08, -1.037003203490612e-08,  2.153536589121176e-09,
 -4.396901029833466e-10,  8.543886028181144e-11,  2.000318446101223e+00, -1.613636634325653e-04, -2.239521846539076e-06,  6.026664243985332e-06, -2.097752915899694e-06,
  5.604478273610001e-07, -1.339608817266145e-07,  3.011111773194885e-08, -6.510087265056175e-09,  1.370308118442563e-09, -2.824749644172874e-10,  5.525634439418355e-11,
  2.000481211882627e+00, -2.651872150367879e-04,  2.566298803333332e-05, -6.784273275024905e-07, -5.830905705035896e-07,  2.314344831606095e-07, -6.439496951271223e-08,
  1.568831142445979e-08, -3.564048191919233e-09,  7.755261512095876e-10, -1.636674823005007e-10,  3.254825574535180e-11,  2.000609693559510e+00, -3.470582182606947e-04,
  4.756433198179767e-05, -5.917433489806456e-06,  5.950970505480901e-07, -2.337151747209771e-08, -1.074914202806630e-08,  4.612384013012807e-09, -1.310802628311682e-09,
  3.224013807139686e-10, -7.349945144960466e-11,  1.537333778250861e-11,  2.000708909650387e+00, -4.102300957075060e-04,  6.440229954789362e-05, -9.930848230930609e-06,
  1.494507820312618e-06, -2.172226437399955e-07,  2.992781512674148e-08, -3.758795565677008e-09,  3.868562205656260e-10, -1.795783940771231e-11, -5.969088228129670e-12,
  2.544381542530132e-12,  2.000782172988694e+00, -4.568493373753798e-04,  7.679410950493550e-05, -1.287649229728726e-05,  2.152880121345563e-06, -3.587558791217447e-07,
  5.955199567353501e-08, -9.840490133612588e-09,  1.617299381764094e-09, -2.640829329103842e-10,  4.275722657921646e-11, -6.694001500366525e-12,  2.000831666786860e+00,
 -4.883298581242478e-04,  8.514548775145103e-05, -1.485785362652623e-05,  2.594892483901832e-06, -4.536026575621835e-07,  7.936885770373919e-08, -1.390175648520487e-08,
  2.437596744591778e-09, -4.279017448746310e-10,  7.513881655075672e-11, -1.282490604379889e-11,  2.000858763567706e+00, -5.055601203071824e-04,  8.971084714639167e-05,
 -1.593967609462489e-05,  2.835946701028361e-06, -5.052686664914700e-07,  9.015171965991659e-08, -1.610921630569483e-08,  2.882997109659878e-09, -5.167619080664986e-10,
  9.268666325221177e-11, -1.614442114219955e-11,  2.000003088457234e+00,  1.797190544589145e-05, -2.648595794791483e-05,  8.828230597696482e-06, -2.298415058671418e-06,
  5.376441617025711e-07, -1.184321249556508e-07,  2.510285931349731e-08, -5.180197507417784e-09,  1.048079586584736e-09, -2.086008609646873e-10,  3.958869789477618e-11,
  2.000109087200694e+00, -4.949583712092847e-05, -8.533038374947557e-06,  4.559258272437016e-06, -1.344721007877056e-06,  3.328916402648320e-07, -7.566805986483239e-08,
  1.635023727535780e-08, -3.416328739217068e-09,  6.969606659663349e-10, -1.394867709985188e-10,  2.656516824252224e-11,  2.000184913018625e+00, -9.769257305862692e-05,
  4.211800400731479e-06,  1.547737912630991e-06, -6.761653405907067e-07,  1.902545441691222e-07, -4.606285209883640e-08,  1.032844756243619e-08, -2.210279578655356e-09,
  4.583562852420769e-10, -9.280548407505607e-11,  1.781844173063698e-11,  2.000243663552258e+00, -1.349979618910990e-04,  1.403070925567138e-05, -7.615739758727414e-07,
 -1.658857755928455e-07,  8.188999923237856e-08, -2.367465259916208e-08,  5.795443114897267e-09, -1.306528531232527e-09,  2.803644724298633e-10, -5.813772212237794e-11,
  1.134954196390626e-11,  2.000290470687049e+00, -1.646958682221490e-04,  2.181865500854720e-05, -2.586496365922690e-06,  2.358855837010944e-07, -3.121438508997334e-09,
 -6.174550893025799e-09,  2.264818786731507e-09, -6.051195340400658e-10,  1.427089697082459e-10, -3.141927698855008e-11,  6.379976028361774e-12,  2.000328005093521e+00,
 -1.884953076221770e-04,  2.804145440249804e-05, -4.040374586149522e-06,  5.550322151167032e-07, -7.045414051611422e-08,  7.646390986813611e-09, -5.155898750855402e-10,
 -5.431107251884561e-11,  3.491172616362676e-11, -1.055380705638820e-11,  2.508938879931132e-12,  2.000357857593983e+00, -2.074142471148061e-04,  3.297651211125502e-05,
 -5.190673609318632e-06,  8.069481907359081e-07, -1.234794150528107e-07,  1.850553786240579e-08, -2.695196849389986e-09,  3.765054139904497e-10, -4.921474228989758e-11,
  5.694267207206480e-12, -4.993613008896276e-13,  2.000381046831469e+00, -2.221044720701141e-04,  3.680138132652527e-05, -6.080547165194959e-06,  1.001471703240503e-06,
 -1.643495068552627e-07,  2.686027840242551e-08, -4.369132487404517e-09,  7.067876523310650e-10, -1.135971645989993e-10,  1.810767610305545e-11, -2.794036507844855e-12,
  2.000398247186186e+00, -2.329974537885538e-04,  3.963355083392680e-05, -6.738532172087303e-06,  1.145103134582926e-06, -1.944850285934228e-07,  3.301216684230826e-08,
 -5.600034960415513e-09,  9.493295490810227e-10, -1.608135870526538e-10,  2.719950234999455e-11, -4.472680632710552e-12,  2.000409904234052e+00, -2.403782495379347e-04,
  4.155060891382318e-05, -7.183462834126961e-06,  1.242129472363894e-06, -2.148220419475376e-07,  3.715970293989074e-08, -6.429090923771221e-09,  1.112533564900702e-09,
 -1.925550266930233e-10,  3.330585025030153e-11, -5.599143143953635e-12,  2.000416298956703e+00, -2.444265900298418e-04,  4.260144123269687e-05, -7.427196378050670e-06,
  1.295247225120751e-06, -2.259487631456535e-07,  3.942749572030916e-08, -6.882127795885345e-09,  1.201662867713527e-09, -2.098794923334719e-10,  3.663676137950506e-11,
 -6.213280936637994e-12,  2.000106824795396e+00, -5.809326768221152e-05,  4.689337526006210e-06,  1.309041565704333e-07, -1.882365956703856e-07,  6.166939018944737e-08,
 -1.578443429312910e-08,  3.629900157218716e-09, -7.860307829817879e-10,  1.637590489372366e-10, -3.316818346747841e-11,  6.354695796668789e-12,  2.000131620261975e+00,
 -7.380083719390120e-05,  8.778744225779361e-06, -8.202936444857781e-07,  1.961068003887639e-08,  1.802421319294797e-08, -6.868859625736153e-09,  1.845192604898040e-09,
 -4.342673580069355e-10,  9.527421235987201e-11, -1.998236879504982e-11,  3.920807387354729e-12,  2.000149534109293e+00, -8.514143187826240e-05,  1.172207195924846e-05,
 -1.502774229994464e-06,  1.682736874733039e-07, -1.309543877227578e-08, -5.317722095706310e-10,  5.805963450164933e-10, -1.857922303252740e-10,  4.704862578049237e-11,
 -1.072579478713349e-11,  2.217106646675705e-12,  2.000163516331979e+00, -9.398864894799629e-05,  1.401293861425865e-05, -2.032724321084333e-06,  2.834413127679212e-07,
 -3.714717930821652e-08,  4.354617741170607e-09, -3.922399941306445e-10,  4.913335948352250e-12,  1.012077834252117e-11, -3.653984394167176e-12,  9.183007873163601e-13,
  2.000174720676528e+00, -1.010753792983120e-04,  1.584457893784158e-05, -2.455657357080522e-06,  3.751822755872491e-07, -5.627111575708936e-08,  8.232719370077209e-09,
 -1.162919624535591e-09,  1.557140724052674e-10, -1.902685891424907e-11,  1.917820727593198e-12, -1.032931569034292e-13,  2.000183747046271e+00, -1.067827379639106e-04,
  1.731752483286464e-05, -2.795260678536181e-06,  4.487381980092281e-07, -7.158154378707845e-08,  1.133290112615471e-08, -1.778099785899893e-09,  2.759114779342241e-10,
 -4.222542515398227e-11,  6.346003568660783e-12, -9.141090830331269e-13,  2.000190952675266e+00, -1.113376885519336e-04,  1.849166248942355e-05, -3.065647282623406e-06,
  5.072323387196090e-07, -8.374242555338238e-08,  1.379241861347719e-08, -2.265574798205549e-09,  3.710452700975329e-10, -6.056516364192025e-11,  9.842673032096647e-12,
 -1.553670852784998e-12,  2.000196566314619e+00, -1.148855706211273e-04,  1.940534724307147e-05, -3.275856806059020e-06,  5.526651832650372e-07, -9.317899895484106e-08,
  1.569916347961126e-08, -2.643138608669658e-09,  4.446609238782822e-10, -7.474359090945789e-11,  1.254347630041712e-11, -2.047243761463055e-12,  2.000200739435657e+00,
 -1.175226253255650e-04,  2.008397950818546e-05, -3.431875711289537e-06,  5.863614613192443e-07, -1.001728213435999e-07,  1.711131900256474e-08, -2.922567632706751e-09,
  4.991041900071594e-10, -8.522203159393059e-11,  1.453809185484062e-11, -2.411524198791229e-12,  2.000203572147981e+00, -1.193124603984880e-04,  2.054434739447202e-05,
 -3.537660540383153e-06,  6.091966238623155e-07, -1.049099329691248e-07,  1.806732239787789e-08, -3.111639735512903e-09,  5.359238997072680e-10, -9.230498522793804e-11,
  1.588569096781853e-11, -2.657524659623821e-12,  2.000205127639429e+00, -1.202952223691579e-04,  2.079704457188371e-05, -3.595707328413613e-06,  6.217228022919559e-07,
 -1.075076289775097e-07,  1.859139931925339e-08, -3.215255225408258e-09,  5.560954835275159e-10, -9.618414155375468e-11,  1.662350728212874e-11, -2.792171874884013e-12,
  2.000077849869757e+00, -4.453563938334065e-05,  6.387139953914320e-06, -8.771786103563784e-07,  1.123655530041415e-07, -1.262912545062224e-08,  1.007304508067137e-09,
  2.934805980797148e-11, -4.028506763795447e-11,  1.305628570396094e-11, -3.305049307206401e-12,  7.215141836727652e-13,  2.000083850064920e+00, -4.832793383564863e-05,
  7.363889085210865e-06, -1.101918297291110e-06,  1.609416533258672e-07, -2.271877594435169e-08,  3.045973847690766e-09, -3.743159545981895e-10,  3.841193549845639e-11,
 -2.098757601905363e-12, -4.187171836149988e-13,  1.941398760454189e-13,  2.000088205878356e+00, -5.108002582379328e-05,  8.071627507361879e-06, -1.264507777702065e-06,
  1.960294732594752e-07, -2.999540839675879e-08,  4.513959432161985e-09, -6.645284591880459e-10,  9.490250386242765e-11, -1.296044807081828e-11,  1.646723573286553e-12,
 -1.826983029748781e-13,  2.000091617947608e+00, -5.323530843854373e-05,  8.625245234323223e-06, -1.391542184448988e-06,  2.234121449233274e-07, -3.566746065553289e-08,
  5.656896220691384e-09, -8.902160545080020e-10,  1.387817644070919e-10, -2.138745585217185e-11,  3.247329078395645e-12, -4.744104806247324e-13,  2.000094359915086e+00,
 -5.496697262330559e-05,  9.069640785606946e-06, -1.493419645959561e-06,  2.453517487489163e-07, -4.020781123946478e-08,  6.570941954505063e-09, -1.070538786396971e-09,
  1.738085105082991e-10, -2.810812278184566e-11,  4.522663956468374e-12, -7.066420297907942e-13,  2.000096573933505e+00, -5.636499502891554e-05,  9.428148075936917e-06,
 -1.575545842791551e-06,  2.630246192953275e-07, -4.386243347211181e-08,  7.306126169441214e-09, -1.215467477777091e-09,  2.019391701701759e-10, -3.350160721231194e-11,
  5.545392292571494e-12, -8.927466001575086e-13,  2.000098344599817e+00, -5.748292491513930e-05,  9.714657712916985e-06, -1.641139490389030e-06,  2.771313238297881e-07,
 -4.677784236480260e-08,  7.892253536895566e-09, -1.330942882492264e-09,  2.243395228060947e-10, -3.779385516035550e-11,  6.358817820704198e-12, -1.040682437880906e-12,
  2.000099726061706e+00, -5.835503877842006e-05,  9.938062624876336e-06, -1.692261579110105e-06,  2.881205066054859e-07, -4.904787674222434e-08,  8.348414786817371e-09,
 -1.420770463004214e-09,  2.417563613923316e-10, -4.112960946965610e-11,  6.990681236919584e-12, -1.155547563810741e-12,  2.000100754163791e+00, -5.900402760621175e-05,
  1.010425070542996e-05, -1.730276816994705e-06,  2.962892691786330e-07, -5.073468287142739e-08,  8.687253661770650e-09, -1.487470636632753e-09,  2.546843025927942e-10,
 -4.360473535539772e-11,  7.459355076725516e-12, -1.240718235739693e-12,  2.000101452592475e+00, -5.944488607239275e-05,  1.021711313543412e-05, -1.756087172091147e-06,
  3.018339830350994e-07, -5.187933816073486e-08,  8.917127554117817e-09, -1.532709375450717e-09,  2.634502783500422e-10, -4.528259593333320e-11,  7.776982322000118e-12,
 -1.298425809341135e-12,  2.000101836302328e+00, -5.968708103880715e-05,  1.027910644700017e-05, -1.770262020482993e-06,  3.048785988504910e-07, -5.250776837179590e-08,
  9.043310621689151e-09, -1.557537914682763e-09,  2.682605584396847e-10, -4.620316332490611e-11,  7.951222205809839e-12, -1.330077527556131e-12,  2.000044814549375e+00,
 -2.599117666629844e-05,  4.153727818172771e-06, -6.597956543049754e-07,  1.040575374938741e-07, -1.627151277112373e-08,  2.518118330687202e-09, -3.847105114925751e-10,
  5.781923242481156e-11, -8.504194739499948e-12,  1.213979914267581e-12, -1.635945084456117e-13,  2.000046290599916e+00, -2.692302433668313e-05,  4.392458566329975e-06,
 -7.144300359851462e-07,  1.158027624200416e-07, -1.869791701977224e-08,  3.005736627794728e-09, -4.807385779312733e-10,  7.643927312304483e-11, -1.207054560825241e-11,
  1.889545918147300e-12, -2.864071056463163e-13,  2.000047364672598e+00, -2.760098786158797e-05,  4.566012698215886e-06, -7.541176218600352e-07,  1.243280864770908e-07,
 -2.045775691630367e-08,  3.359123383078293e-09, -5.502776211403472e-10,  8.991249520853196e-11, -1.464909476201467e-11,  2.377614943111855e-12, -3.750695733480009e-13,
  2.000048207530420e+00, -2.813294124290483e-05,  4.702110267036904e-06, -7.852216005515795e-07,  1.310056373193821e-07, -2.183536033362644e-08,  3.635592094059983e-09,
 -6.046488477636092e-10,  1.004407572966261e-10, -1.666284508932571e-11,  2.758555929365369e-12, -4.442333270414297e-13,  2.000048885813226e+00, -2.856098451748981e-05,
  4.811572558233383e-06, -8.102266876251601e-07,  1.363713482735133e-07, -2.294181014409480e-08,  3.857539921910440e-09, -6.482774703812859e-10,  1.088849206550327e-10,
 -1.827721595445393e-11,  3.063804866697667e-12, -4.996303617313456e-13,  2.000049434119024e+00, -2.890697609711881e-05,  4.900019149741291e-06, -8.304234714253304e-07,
  1.407036422779615e-07, -2.383482569021737e-08,  4.036606627950057e-09, -6.834636533468013e-10,  1.156925216761086e-10, -1.957821733608104e-11,  3.309709339287813e-12,
 -5.442418668457494e-13,  2.000049873028479e+00, -2.918391892173398e-05,  4.970793491358998e-06, -8.465799220799251e-07,  1.441682199115833e-07, -2.454876274011551e-08,
  4.179721338497756e-09, -7.115768468861549e-10,  1.211300409723952e-10, -2.061706844839208e-11,  3.506005363334582e-12, -5.798434853723079e-13,  2.000050215710207e+00,
 -2.940013318869947e-05,  5.026035217111769e-06, -8.591875571328688e-07,  1.468711446453791e-07, -2.510561435255079e-08,  4.291320197886373e-09, -7.334938736205733e-10,
  1.253681129261604e-10, -2.142656873220783e-11,  3.658928054857368e-12, -6.075724371906665e-13,  2.000050470879394e+00, -2.956112543831586e-05,  5.067160527284948e-06,
 -8.685717348333969e-07,  1.488826304723191e-07, -2.551994101433175e-08,  4.374340353619943e-09, -7.497953095827778e-10,  1.285197271842560e-10, -2.202843823741924e-11,
  3.772606545231145e-12, -6.281818612844077e-13,  2.000050644294138e+00, -2.967053387525993e-05,  5.095105174063607e-06, -8.749474479565452e-07,  1.502490764811624e-07,
 -2.580136512231137e-08,  4.430722926612105e-09, -7.608648649366004e-10,  1.306595626899363e-10, -2.243703296988816e-11,  3.849770081204635e-12, -6.421695728775632e-13,
  2.000050739590144e+00, -2.973065567902454e-05,  5.110459983952487e-06, -8.784504380866945e-07,  1.509997772408226e-07, -2.595596170418805e-08,  4.461693389691080e-09,
 -7.669447760205288e-10,  1.318347625141224e-10, -2.266141517677366e-11,  3.892141430070309e-12, -6.498497919304799e-13,  2.000023853118337e+00, -1.390846745601084e-05,
  2.310861395195547e-06, -3.834822586406691e-07,  6.355578301074045e-08, -1.051866374716212e-08,  1.738257014598547e-09, -2.867884412443139e-10,  4.723269649301836e-11,
 -7.763919731818011e-12,  1.272668510302734e-12, -2.028874070488537e-13,  2.000024219181631e+00, -1.413943721074840e-05,  2.369876623373491e-06, -3.969519169755545e-07,
  6.644368468599342e-08, -1.111365780106607e-08,  1.857506550412529e-09, -3.102092254752574e-10,  5.176177664211370e-11, -8.629046162745358e-12,  1.436106996721266e-12,
 -2.325243626530149e-13,  2.000024485867003e+00, -1.430769017353483e-05,  2.412850495449390e-06, -4.067564778520349e-07,  6.854496754263835e-08, -1.154641569661448e-08,
  1.944206569065690e-09, -3.272305745699466e-10,  5.505205453803020e-11, -9.257295760334244e-12,  1.554748810679972e-12, -2.540303025214896e-13,  2.000024695328298e+00,
 -1.443983211013348e-05,  2.446591387935991e-06, -4.144522669036995e-07,  7.019382075674303e-08, -1.188589612747935e-08,  2.012199084483963e-09, -3.405752504875130e-10,
  5.763086106722639e-11, -9.749551251377981e-12,  1.647681577615396e-12, -2.708713935019777e-13,  2.000024864008855e+00, -1.454624169474833e-05,  2.473755571816428e-06,
 -4.206465680607669e-07,  7.152066476049140e-08, -1.215901466016015e-08,  2.066887585769838e-09, -3.513062804905974e-10,  5.970410596841919e-11, -1.014521013394491e-11,
  1.722360524344986e-12, -2.844016126535606e-13,  2.000025000442931e+00, -1.463230568955144e-05,  2.495721862320391e-06, -4.256546442174724e-07,  7.259321276316797e-08,
 -1.237974711169063e-08,  2.111078107823639e-09, -3.599757515154958e-10,  6.137873988509605e-11, -1.046473769130704e-11,  1.782658687255564e-12, -2.953244214454320e-13,
  2.000025109705854e+00, -1.470122766448215e-05,  2.513310327665582e-06, -4.296640180420570e-07,  7.345174487051155e-08, -1.255640786284029e-08,  2.146440127702369e-09,
 -3.669121585257075e-10,  6.271840391702045e-11, -1.072031271595524e-11,  1.830881057666970e-12, -3.040585041333955e-13,  2.000025195044452e+00, -1.475505706073618e-05,
  2.527045631255537e-06, -4.327946708400721e-07,  7.412203489903784e-08, -1.269431732984479e-08,  2.174042018530834e-09, -3.723257327545016e-10,  6.376382966185935e-11,
 -1.091973032184980e-11,  1.868503040195778e-12, -3.108718700741230e-13,  2.000025258607196e+00, -1.479515003863343e-05,  2.537274972687799e-06, -4.351260051518670e-07,
  7.462114058078391e-08, -1.279699686303650e-08,  2.194590922845679e-09, -3.763556298824095e-10,  6.454197924682316e-11, -1.106815067288999e-11,  1.896501354068775e-12,
 -3.159419482072852e-13,  2.000025301813425e+00, -1.482240252036486e-05,  2.544227731557160e-06, -4.367104806818016e-07,  7.496033202362211e-08, -1.286677311106671e-08,
  2.208554083591276e-09, -3.790937996230775e-10,  6.507066893762488e-11, -1.116898364476207e-11,  1.915521440519968e-12, -3.193859910390302e-13,  2.000025325559340e+00,
 -1.483738021133123e-05,  2.548048742317578e-06, -4.375812211911315e-07,  7.514672526505381e-08, -1.290511512524254e-08,  2.216226516092121e-09, -3.805982980335188e-10,
  6.536114760275218e-11, -1.122438214503169e-11,  1.925970809230948e-12, -3.212780268783632e-13,  2.000012284755029e+00, -7.180247809526697e-06,  1.213190755278029e-06,
 -2.049279181073465e-07,  3.460601313295752e-08, -5.842197522324993e-09,  9.859859717409520e-10, -1.663529206830715e-10,  2.805757806606424e-11, -4.730594813213523e-12,
  7.967117845476014e-13, -1.305348984825035e-13,  2.000012375905283e+00, -7.237743442338400e-06,  1.227862024111203e-06, -2.082720134097933e-07,  3.532202593348783e-08,
 -5.989519062093329e-09,  1.015472589070921e-09, -1.721363302935887e-10,  2.917445817546231e-11, -4.943649030689972e-12,  8.369076416853668e-13, -1.378145953803629e-13,
  2.000012442349206e+00, -7.279653143380115e-06,  1.238554144053546e-06, -2.107086480544857e-07,  3.584363826761243e-08, -6.096821219646972e-09,  1.036945069417154e-09,
 -1.763470489062763e-10,  2.998746427808371e-11, -5.098706385177172e-12,  8.661558232382529e-13, -1.431106381786986e-13,  2.000012494558918e+00, -7.312583565245881e-06,
  1.246954228119170e-06, -2.126226690162990e-07,  3.625331410457783e-08, -6.181084247177852e-09,  1.053804653829562e-09, -1.796526990297027e-10,  3.062562558388903e-11,
 -5.220399227687837e-12,  8.891071507119444e-13, -1.472659217743083e-13,  2.000012536618466e+00, -7.339111291490760e-06,  1.253720296282230e-06, -2.141641882337683e-07,
  3.658322140796886e-08, -6.248932376226432e-09,  1.067378310901230e-09, -1.823137675607391e-10,  3.113928919028103e-11, -5.318339774841346e-12,  9.075766311405874e-13,
 -1.506094120964625e-13,  2.000012570647150e+00, -7.360573382499830e-06,  1.259193832746561e-06, -2.154111118228152e-07,  3.685005587432110e-08, -6.303803884570692e-09,
  1.078354836271865e-09, -1.844654741199005e-10,  3.155459188101894e-11, -5.397518306656041e-12,  9.225065945439110e-13, -1.533119128730011e-13,  2.000012597905146e+00,
 -7.377764889350648e-06,  1.263577902127080e-06, -2.164097689816158e-07,  3.706374654292103e-08, -6.347743629108006e-09,  1.087143897359458e-09, -1.861882452900388e-10,
  3.188708008722417e-11, -5.460903219693904e-12,  9.344575958610482e-13, -1.554750324405217e-13,  2.000012619198540e+00, -7.391194377583167e-06,  1.267002402209493e-06,
 -2.171897969547707e-07,  3.723064534325105e-08, -6.382059817176277e-09,  1.094007589996743e-09, -1.875335379147879e-10,  3.214670073448603e-11, -5.510393818092909e-12,
  9.437883132666078e-13, -1.571637881435458e-13,  2.000012635060686e+00, -7.401198346486153e-06,  1.269553284035149e-06, -2.177708067237312e-07,  3.735495546650223e-08,
 -6.407618137717264e-09,  1.099119357291193e-09, -1.885354046930865e-10,  3.234003659086039e-11, -5.547247072991242e-12,  9.507361281274896e-13, -1.584212109343786e-13,
  2.000012645843909e+00, -7.407999084021342e-06,  1.271287327122013e-06, -2.181657536217014e-07,  3.743945366398554e-08, -6.424990501345359e-09,  1.102593785263429e-09,
 -1.892163431264290e-10,  3.247143675556815e-11, -5.572293454357463e-12,  9.554578790366285e-13, -1.592757319579818e-13,  2.000012651770680e+00, -7.411736949177440e-06,
  1.272240383594145e-06, -2.183828179740923e-07,  3.748589324158089e-08, -6.434538024684224e-09,  1.104503225738985e-09, -1.895905585206800e-10,  3.254364731358798e-11,
 -5.586057331011300e-12,  9.580525953736528e-13, -1.597453028367701e-13,  2.000006231521725e+00, -3.646354127344636e-06,  6.209439537538774e-07, -1.057348166291506e-07,
  1.800342905322236e-08, -3.065233637809798e-09,  5.218462814838422e-10, -8.883656668307670e-11,  1.512203782803111e-11, -2.573878768101250e-12,  4.377145271006951e-13,
 -7.239665765581839e-14,  2.000006254263785e+00, -3.660697321975506e-06,  6.246015089926126e-07, -1.065679439413868e-07,  1.818169235017605e-08, -3.101887122889633e-09,
  5.291775908450900e-10, -9.027353740711274e-11,  1.539935564788862e-11, -2.626743810964485e-12,  4.476816122420051e-13, -7.420061684641061e-14,  2.000006270846442e+00,
 -3.671155629186876e-06,  6.272681504726590e-07, -1.071752993856040e-07,  1.831163482841950e-08, -3.128602546034523e-09,  5.345205992238455e-10, -9.132068941192234e-11,
  1.560142342692479e-11, -2.665260181883104e-12,  4.549427152015976e-13, -7.551469568400615e-14,  2.000006283879483e+00, -3.679375147698467e-06,  6.293637975972148e-07,
 -1.076525699900801e-07,  1.841373841816560e-08, -3.149592910055852e-09,  5.387183029380143e-10, -9.214331771660250e-11,  1.576015340994472e-11, -2.695513655307216e-12,
  4.606456786927411e-13, -7.654671900758116e-14,  2.000006294380588e+00, -3.685997775575606e-06,  6.310522045488955e-07, -1.080370718253923e-07,  1.849599097333677e-08,
 -3.166501327663803e-09,  5.420994912489902e-10, -9.280589385669558e-11,  1.588799308899799e-11, -2.719878099205819e-12,  4.652382564100017e-13, -7.737775851984407e-14,
  2.000006302877808e+00, -3.691356580335146e-06,  6.324183424213137e-07, -1.083481685482955e-07,  1.856253758658468e-08, -3.180180474999934e-09,  5.448347908472684e-10,
 -9.334187659639729e-11,  1.599140251928580e-11, -2.739585549490520e-12,  4.689528388233978e-13, -7.804989269150549e-14,  2.000006309685110e+00, -3.695649597932139e-06,
  6.335127346655654e-07, -1.085973739739363e-07,  1.861584302666751e-08, -3.191137384887597e-09,  5.470256650161178e-10, -9.377116266873989e-11,  1.607422335250081e-11,
 -2.755368687197034e-12,  4.719276296201087e-13, -7.858814630689990e-14,  2.000006315003316e+00, -3.699003497345874e-06,  6.343676979990179e-07, -1.087920529118479e-07,
  1.865748391151912e-08, -3.199696392713142e-09,  5.487370182999582e-10, -9.410647994734306e-11,  1.613891312474559e-11, -2.767696222798173e-12,  4.742510419860492e-13,
 -7.900852876157021e-14,  2.000006318965294e+00, -3.701502086951112e-06,  6.350046145367146e-07, -1.089370783039073e-07,  1.868850342880127e-08, -3.206072101851566e-09,
  5.500117967771984e-10, -9.435625033864674e-11,  1.618709798590227e-11, -2.776878306007318e-12,  4.759815804866789e-13, -7.932163389118437e-14,  2.000006321658814e+00,
 -3.703200727850156e-06,  6.354376087600183e-07, -1.090356691252627e-07,  1.870959069613998e-08, -3.210406278261306e-09,  5.508783707122850e-10, -9.452603742741199e-11,
  1.621985219560442e-11, -2.783119828549852e-12,  4.771578949075474e-13, -7.953446035030495e-14,  2.000006323139297e+00, -3.704134376762537e-06,  6.356755992958122e-07,
 -1.090898579324131e-07,  1.872118084236022e-08, -3.212788436964564e-09,  5.513546538670589e-10, -9.461935420874725e-11,  1.623785406896721e-11, -2.786550164137073e-12,
  4.778043896447850e-13, -7.965142724999682e-14,  2.000003137996530e+00, -1.837200606695978e-06,  3.140477515036756e-07, -5.368191285331772e-08,  9.176000085770510e-09,
 -1.568454454896496e-09,  2.680917417072182e-10, -4.582346401487464e-11,  7.832222323116367e-12, -1.338642923320022e-12,  2.286061471271306e-13, -3.796293111807359e-14,
  2.000003143676369e+00, -1.840782574691313e-06,  3.149608610059840e-07, -5.388983376023309e-08,  9.220473758869936e-09, -1.577595804994858e-09,  2.699195492257564e-10,
 -4.618160216171845e-11,  7.901315334956463e-12, -1.351809673905793e-12,  2.310877509677987e-13, -3.841193934907076e-14,  2.000003147818500e+00, -1.843394766369867e-06,
  3.156267246794042e-07, -5.404144783962784e-08,  9.252901985568956e-09, -1.584260945814999e-09,  2.712521750037062e-10, -4.644270228740609e-11,  7.951685034749089e-12,
 -1.361407935549636e-12,  2.328966955061009e-13, -3.873922520657954e-14,  2.000003151074340e+00, -1.845448012982132e-06,  3.161500908747284e-07, -5.416061154384309e-08,
  9.278388574556158e-09, -1.589499143283356e-09,  2.722994596844104e-10, -4.664788823549585e-11,  7.991266683777543e-12, -1.368950188458926e-12,  2.343181004092874e-13,
 -3.899638604750840e-14,  2.000003153697897e+00, -1.847102508862585e-06,  3.165718046069284e-07, -5.425662750784301e-08,  9.298923753588054e-09, -1.593719565943800e-09,
  2.731432336446539e-10, -4.681319714545896e-11,  8.023154869035477e-12, -1.375026279680385e-12,  2.354631606323228e-13, -3.920354488643642e-14,  2.000003155820959e+00,
 -1.848441371578177e-06,  3.169130588097578e-07, -5.433432258828104e-08,  9.315540207056904e-09, -1.597134525279594e-09,  2.738259580783569e-10, -4.694695069615524e-11,
  8.048955396706253e-12, -1.379942290100219e-12,  2.363895778229856e-13, -3.937114416605589e-14,  2.000003157521887e+00, -1.849514019475126e-06,  3.171864540922883e-07,
 -5.439656670632160e-08,  9.328851948990800e-09, -1.599870259049480e-09,  2.743728801782294e-10, -4.705409697014922e-11,  8.069623092692494e-12, -1.383880220118760e-12,
  2.371316626656946e-13, -3.950539326259909e-14,  2.000003158850796e+00, -1.850352060868292e-06,  3.174000499662147e-07, -5.444519551773032e-08,  9.339251718051623e-09,
 -1.602007512826309e-09,  2.748001489806541e-10, -4.713780097330252e-11,  8.085768710297541e-12, -1.386956487167839e-12,  2.377113623574526e-13, -3.961026410441091e-14,
  2.000003159840846e+00, -1.850976408367151e-06,  3.175591787833926e-07, -5.448142354207310e-08,  9.346999362691526e-09, -1.603599710855636e-09,  2.751184493615318e-10,
 -4.720015682082020e-11,  8.097796355287881e-12, -1.389248119562482e-12,  2.381431985019820e-13, -3.968838477920270e-14,  2.000003160513941e+00, -1.851400875928938e-06,
  3.176673628814844e-07, -5.450605304652780e-08,  9.352266530205700e-09, -1.604682143615694e-09,  2.753348394717261e-10, -4.724254783801897e-11,  8.105972972235626e-12,
 -1.390806001007799e-12,  2.384367638945104e-13, -3.974149137828377e-14,  2.000003160883911e+00, -1.851634186129533e-06,  3.177268263764723e-07, -5.451959060784871e-08,
  9.355161604045830e-09, -1.605277094602761e-09,  2.754537760429914e-10, -4.726584749822464e-11,  8.110467117900626e-12, -1.391662260973592e-12,  2.385981157049076e-13,
 -3.977068011958372e-14,    0.0015285756385368,   0.00111781771393397,  0.000912659417355132,  0.000300004832834545,  5.63517695092783e-05,  5.94029863983242e-06,
  3.32489176833119e-07,  8.93746350942154e-09,  9.67136952101347e-11,  2.99069968539208e-13,  1.11300787488701e-16,  0.000762692028529164,  0.000557647132010039,
   0.00045551898056168,  0.000149805638131732,  2.81568739828343e-05,  2.97063568297653e-06,  1.66452123033673e-07,  4.48057772917425e-09,  4.85742089258068e-11,
  1.50585484379265e-13,  5.62559466534136e-17,  0.000380962266662601,  0.000278532765704671,  0.000227545554363899,  7.48398963841466e-05,  1.40685047938391e-05,
  1.48452920699566e-06,  8.32003118506784e-08,  2.24022221665232e-09,  2.42950373698649e-11,  7.53526525224488e-14,  2.81693017064653e-17,  0.000190386784052583,
  0.000139196203791755,   0.00011371820694474,  3.74028660148326e-05,  7.03126086057206e-06,  7.41978783455181e-07,  4.15862425765546e-08,  1.11980725633647e-09,
  1.21451881745414e-11,  3.76729668413682e-14,  1.40854217194588e-17,  9.51699881582509e-05,  6.95808456023935e-05,  5.68453403418502e-05,  1.86970108903743e-05,
  3.51482560969326e-06,  3.70908050552477e-07,  2.07888143245163e-08,  5.59796081374902e-10,  6.07154180806296e-12,   1.8833673392848e-14,  7.04189545198594e-18,
  4.75791652096499e-05,  3.47861433085509e-05,  2.84192151576168e-05,  9.34738193079516e-06,  1.75720484945057e-06,  1.85432520424589e-07,   1.0393232691638e-08,
  2.79867443658518e-10,  3.03545293908138e-12,  9.41590540787994e-15,  3.52062787410648e-18,  2.37881281003483e-05,  1.73920060164178e-05,  1.42087420962052e-05,
  4.67340789538093e-06,  8.78549613736733e-07,  9.27107417095987e-08,  5.19631085657337e-09,   1.3992562276071e-10,  1.51764034002589e-12,  4.70769230598646e-15,
  1.76022005523353e-18,  1.18937007601679e-05,  8.69573712285125e-06,  7.10415446430243e-06,  2.33663290970563e-06,  4.39261502668797e-07,  4.63539736801326e-08,
  2.59807759295277e-09,  6.99607312350109e-11,  7.58797821398968e-13,  2.35377766831675e-15,  8.80084852326385e-19,  5.94675959941154e-06,  4.34780215527243e-06,
  3.55202305974299e-06,  1.16829866175895e-06,  2.19627412684003e-07,  2.31766353673957e-08,  1.29901915605445e-09,  3.49798387111335e-11,  3.79393222350512e-13,
  1.17687129363976e-15,  4.40035921385739e-19,  2.97335710975484e-06,  2.17388448422589e-06,  1.77599798347367e-06,  5.84144878419492e-07,   1.0981287010937e-07,
  1.15882295440621e-08,  6.49504645303199e-10,  1.74897867734605e-11,  1.89695176490302e-13,  5.88431209507049e-16,  2.20016308262294e-19,  1.48667288304112e-06,
   1.0869380947751e-06,   8.8799560472613e-07,  2.92071325572256e-07,  5.49062258005866e-08,  5.79409270324513e-09,  3.24751086648258e-10,  8.74486013446636e-12,
   9.4847228002419e-14,  2.94214488917079e-16,  1.10007737752261e-19  };
  int offset = -11;
  const int ibox0 = static_cast<int>(log(64.0) / log(2.0));
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 11;
    if (std::isnan(t)) {
      fill_n(rr+offset, 11, 0.5);
      fill_n(ww+offset, 11, 0.0);
    } else if (t >= 131072.0) {
      for (int r = 0; r != 11; ++r) {
        ww[offset+r] = aw[11-r-1] / t;
        rr[offset+r] = 1.0 - ax[11-r-1] / t;
      }
    } else {
      assert(t >= 0);
      int it;
      double bigT = 0.0;
      if (t >= 64.0 && t < 131072.0) {
        bigT = t;
        it = static_cast<int>(log(bigT) / log(2.0) + 32 - ibox0);
        t = (t - 1.5 * pow(2.0, it + ibox0 - 32))* 2/pow(2.0, it + ibox0 - 32);
      } else {
        it = static_cast<int>(t*   0.500000000000000);
        t = (t - it *2.000000000000000-   1.000000000000000) *   1.000000000000000;
      }
      const double t2 = t * 2.0;
      for (int j=1; j <=11; ++j) {
        const int boxof = it*132+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
        if (64.0 <= bigT && bigT < 131072.0) {
          const int iref = 5676 + (it - 32) * 11 + 11 - j;
          double rr_infty = x[iref];
          double ww_infty = w[iref];
          double Tref = pow(2.0, it + ibox0 + 1 - 32);
          ww[offset+j-1] = ww[offset+j-1] * ww_infty * Tref / bigT;
          rr[offset+j-1] = 1.0 + rr[offset+j-1] * (1.0 - rr_infty) * Tref /bigT;
        }
      }
    }
  }
}
