# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import sys
from typing import Any, Optional, Union

from azure.core.configuration import Configuration
from azure.core.pipeline import policies

from .. import models as _models

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports

VERSION = "unknown"


class AzureFileStorageConfiguration(Configuration):  # pylint: disable=too-many-instance-attributes
    """Configuration for AzureFileStorage.

    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param url: The URL of the service account, share, directory or file that is the target of the
     desired operation. Required.
    :type url: str
    :param file_request_intent: Valid value is backup. "backup" Default value is None.
    :type file_request_intent: str or ~azure.storage.fileshare.models.ShareTokenIntent
    :param allow_trailing_dot: If true, the trailing dot will not be trimmed from the target URI.
     Default value is None.
    :type allow_trailing_dot: bool
    :param allow_source_trailing_dot: If true, the trailing dot will not be trimmed from the source
     URI. Default value is None.
    :type allow_source_trailing_dot: bool
    :keyword version: Specifies the version of the operation to use for this request. Default value
     is "2022-11-02". Note that overriding this default value may result in unsupported behavior.
    :paramtype version: str
    :keyword file_range_write_from_url: Only update is supported: - Update: Writes the bytes
     downloaded from the source url into the specified range. Default value is "update". Note that
     overriding this default value may result in unsupported behavior.
    :paramtype file_range_write_from_url: str
    """

    def __init__(
        self,
        url: str,
        file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
        allow_trailing_dot: Optional[bool] = None,
        allow_source_trailing_dot: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        super(AzureFileStorageConfiguration, self).__init__(**kwargs)
        version: Literal["2022-11-02"] = kwargs.pop("version", "2022-11-02")
        file_range_write_from_url: Literal["update"] = kwargs.pop("file_range_write_from_url", "update")

        if url is None:
            raise ValueError("Parameter 'url' must not be None.")

        self.url = url
        self.file_request_intent = file_request_intent
        self.allow_trailing_dot = allow_trailing_dot
        self.allow_source_trailing_dot = allow_source_trailing_dot
        self.version = version
        self.file_range_write_from_url = file_range_write_from_url
        kwargs.setdefault("sdk_moniker", "azurefilestorage/{}".format(VERSION))
        self._configure(**kwargs)

    def _configure(self, **kwargs: Any) -> None:
        self.user_agent_policy = kwargs.get("user_agent_policy") or policies.UserAgentPolicy(**kwargs)
        self.headers_policy = kwargs.get("headers_policy") or policies.HeadersPolicy(**kwargs)
        self.proxy_policy = kwargs.get("proxy_policy") or policies.ProxyPolicy(**kwargs)
        self.logging_policy = kwargs.get("logging_policy") or policies.NetworkTraceLoggingPolicy(**kwargs)
        self.http_logging_policy = kwargs.get("http_logging_policy") or policies.HttpLoggingPolicy(**kwargs)
        self.retry_policy = kwargs.get("retry_policy") or policies.AsyncRetryPolicy(**kwargs)
        self.custom_hook_policy = kwargs.get("custom_hook_policy") or policies.CustomHookPolicy(**kwargs)
        self.redirect_policy = kwargs.get("redirect_policy") or policies.AsyncRedirectPolicy(**kwargs)
        self.authentication_policy = kwargs.get("authentication_policy")
