#ifndef ATL_dtGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,96,168,240,264,288,336,672,1008,1176,1248,1296,1320,1344,1992,2328,2496,2568,2616,2640,2664,5304
 * N : 25,96,168,240,264,288,336,672,1008,1176,1248,1296,1320,1344,1992,2328,2496,2568,2616,2640,2664,5304
 * NB : 4,8,8,8,24,24,24,24,24,24,24,24,24,72,72,72,72,72,64,64,240,240
 */
#define ATL_dtGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 60) (nb_) = 4; \
   else if ((n_) < 252) (nb_) = 8; \
   else if ((n_) < 1332) (nb_) = 24; \
   else if ((n_) < 2592) (nb_) = 72; \
   else if ((n_) < 2652) (nb_) = 64; \
   else (nb_) = 240; \
}


#endif    /* end ifndef ATL_dtGetNB_geqrf */
