/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.charcode;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Loader;
import net.sf.saxon.charcode.ASCIICharacterSet;
import net.sf.saxon.charcode.BuggyCharacterSet;
import net.sf.saxon.charcode.CP1250CharacterSet;
import net.sf.saxon.charcode.CP1251CharacterSet;
import net.sf.saxon.charcode.CP852CharacterSet;
import net.sf.saxon.charcode.CharacterSet;
import net.sf.saxon.charcode.KOI8RCharacterSet;
import net.sf.saxon.charcode.Latin1CharacterSet;
import net.sf.saxon.charcode.Latin2CharacterSet;
import net.sf.saxon.charcode.PluggableCharacterSet;
import net.sf.saxon.charcode.UnicodeCharacterSet;
import net.sf.saxon.charcode.UnknownCharacterSet;

public class CharacterSetFactory {
    public static CharacterSet getCharacterSet(Properties properties) throws TransformerException {
        CharacterSet characterSet;
        String string = properties.getProperty("encoding");
        if (string == null) {
            string = "UTF8";
        }
        if (string.equalsIgnoreCase("UTF-8")) {
            string = "UTF8";
        }
        if ((characterSet = CharacterSetFactory.makeCharacterSet(string)) == null) {
            characterSet = ASCIICharacterSet.getInstance();
        }
        return characterSet;
    }

    private static CharacterSet makeCharacterSet(String string) throws TransformerException {
        if (string.equalsIgnoreCase("ASCII")) {
            return ASCIICharacterSet.getInstance();
        }
        if (string.equalsIgnoreCase("US-ASCII")) {
            return ASCIICharacterSet.getInstance();
        }
        if (string.equalsIgnoreCase("iso-8859-1")) {
            return Latin1CharacterSet.getInstance();
        }
        if (string.equalsIgnoreCase("ISO8859_1")) {
            return Latin1CharacterSet.getInstance();
        }
        if (string.equalsIgnoreCase("iso-8859-2")) {
            return Latin2CharacterSet.getInstance();
        }
        if (string.equalsIgnoreCase("ISO8859_2")) {
            return Latin2CharacterSet.getInstance();
        }
        if (string.equalsIgnoreCase("UTF-8")) {
            return UnicodeCharacterSet.getInstance();
        }
        if (string.equalsIgnoreCase("UTF8")) {
            return UnicodeCharacterSet.getInstance();
        }
        if (string.equalsIgnoreCase("utf-16")) {
            return UnicodeCharacterSet.getInstance();
        }
        if (string.equalsIgnoreCase("utf16")) {
            return UnicodeCharacterSet.getInstance();
        }
        if (string.equalsIgnoreCase("KOI8-R")) {
            return KOI8RCharacterSet.getInstance();
        }
        if (string.equalsIgnoreCase("cp1251")) {
            return CP1251CharacterSet.getInstance();
        }
        if (string.equalsIgnoreCase("windows-1251")) {
            return CP1251CharacterSet.getInstance();
        }
        if (string.equalsIgnoreCase("cp1250")) {
            return CP1250CharacterSet.getInstance();
        }
        if (string.equalsIgnoreCase("windows-1250")) {
            return CP1250CharacterSet.getInstance();
        }
        if (string.equalsIgnoreCase("cp852")) {
            return CP852CharacterSet.getInstance();
        }
        String string2 = System.getProperty("encoding." + string);
        if (string2 == null) {
            Charset charset = null;
            try {
                charset = Charset.forName(string);
                CharacterSet characterSet = new UnknownCharacterSet(charset);
                if (characterSet.inCharset(511) && characterSet.inCharset(768) && characterSet.inCharset(2704) && characterSet.inCharset(8704) && characterSet.inCharset(13312)) {
                    characterSet = new BuggyCharacterSet(charset);
                }
                return characterSet;
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                throw new TransformerException("Invalid encoding name: " + string);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                return ASCIICharacterSet.getInstance();
            }
        }
        try {
            Object object = Loader.getInstance(string2);
            if (object instanceof PluggableCharacterSet) {
                return (PluggableCharacterSet)object;
            }
        }
        catch (Exception exception) {
            throw new TransformerException("Failed to load " + string2);
        }
        return null;
    }

    public static void main(String[] stringArray) throws Exception {
        System.err.println("Available Character Sets in the java.nio package for this Java VM:");
        Iterator<String> iterator = Charset.availableCharsets().keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            System.err.println(string);
        }
    }
}

