/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:40:34 GMT 2018
 */

package uk.ac.sanger.artemis.sequence;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.CharArrayReader;
import java.io.LineNumberReader;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.SimpleGotoEventSource;
import uk.ac.sanger.artemis.components.SelectionViewer;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.LinePushBackReader;
import uk.ac.sanger.artemis.util.StringVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class Strand_ESTest extends Strand_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      bases0.addBases(1, 1, "vTgt!f:6B&i!%@?LS");
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(1);
      MarkerRange[] markerRangeArray0 = Strand.getOpenReadingFrameRanges(markerRange0, 2, (-5), 0);
      assertNotNull(markerRangeArray0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("vi.-mWH3Q");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = new Strand(bases0, 1);
      Marker marker0 = strand0.makeMarkerFromRawPosition(5);
      MarkerRange markerRange0 = new MarkerRange(marker0);
      String string0 = Strand.markerRangeBases(markerRange0);
      assertEquals("k", string0);
      assertEquals(2, strand0.getDirection());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("jMQ/n?Z-5GP<}b3F0U");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      strand0.makeMarkerRangeFromRawPositions(1, 5);
      assertEquals(2, strand0.getDirection());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      strand0.getStrandBases();
      assertEquals(2, strand0.getDirection());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      char[] charArray0 = new char[4];
      CharArrayReader charArrayReader0 = new CharArrayReader(charArray0);
      LineNumberReader lineNumberReader0 = new LineNumberReader(charArrayReader0);
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(lineNumberReader0);
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence(linePushBackReader0);
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      int int0 = strand0.getSequenceLength();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("@3s>u1<|PZI@42");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = new Strand(bases0, 120);
      int int0 = strand0.getSequenceLength();
      assertEquals(14, int0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("vi.-mWH3Q");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      int int0 = strand0.getRawPosition(0);
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      assertTrue(strand0.isForwardStrand());
      
      int int0 = strand0.getRawPosition((-5));
      assertEquals((-5), int0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("internal error - unexpected exception: ");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = new Strand(bases0, 3);
      int int0 = strand0.getGCount();
      assertEquals(2, strand0.getDirection());
      assertEquals(2, int0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("vi.-mWH3Q");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = new Strand(bases0, 1);
      Marker marker0 = strand0.makeMarkerFromRawPosition(5);
      String string0 = Strand.getCodonAtMarker(marker0);
      assertEquals(2, strand0.getDirection());
      assertEquals("knn", string0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      Strand strand0 = new Strand((Bases) null, (-38));
      // Undeclared exception!
      try { 
        strand0.makeMarkerRangeFromPositions((-2950), 676);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerInternal", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("@3s>u1<|PZI@42");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = new Strand(bases0, 120);
      try { 
        strand0.makeMarkerFromRawPosition(0);
        fail("Expecting exception: Exception");
      
      } catch(Exception e) {
         //
         // position: 15
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerInternal", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Strand strand0 = new Strand((Bases) null, (-736));
      // Undeclared exception!
      try { 
        strand0.makeMarkerFromRawPosition((-736));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("C");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      try { 
        strand0.makeMarker((-2338));
        fail("Expecting exception: Exception");
      
      } catch(Exception e) {
         //
         // position: -2338
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerInternal", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      Strand strand0 = new Strand((Bases) null, (-1));
      // Undeclared exception!
      try { 
        strand0.makeMarker((-1));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerInternal", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("uk.ac.sanger.artemis.sequence.Strand", "{$!0e!M|");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("");
      Feature feature0 = entry0.createFeature();
      Strand strand0 = feature0.getStrand();
      // Undeclared exception!
      try { 
        strand0.getTranslation((Range) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("vi.-mWH3Q");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = new Strand(bases0, 1);
      Range range0 = new Range((-1));
      // Undeclared exception!
      try { 
        strand0.getTranslation(range0, false);
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      Strand strand0 = new Strand((Bases) null, 3);
      // Undeclared exception!
      try { 
        strand0.getTCount();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("vi.-mWH3Q");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = new Strand(bases0, 1);
      // Undeclared exception!
      try { 
        strand0.getSubSequence((Range) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      Strand strand0 = new Strand((Bases) null, 0);
      Range range0 = new Range((-5), 1);
      StringVector stringVector0 = SelectionViewer.getBaseSummary("S,Cn");
      // Undeclared exception!
      try { 
        strand0.getStopOrStartCodons(range0, stringVector0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = new Strand(bases0, (-1660));
      // Undeclared exception!
      try { 
        strand0.getSpacedTranslation((Range) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("uk.ac.sanger.artemis.sequence.Strand");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Range range0 = new Range(74);
      Strand strand0 = bases0.getReverseStrand();
      // Undeclared exception!
      try { 
        strand0.getSpacedTranslation(range0, false);
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      Strand strand0 = new Strand((Bases) null, 0);
      // Undeclared exception!
      try { 
        strand0.getRawSubSequence((Range) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      Strand strand0 = new Strand((Bases) null, 4414);
      // Undeclared exception!
      try { 
        strand0.getRawPosition(8000);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      // Undeclared exception!
      try { 
        Strand.getOpenReadingFrameRanges((MarkerRange) null, (-2575), (-2010), 75);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      // Undeclared exception!
      try { 
        Strand.getORFAroundMarker((Marker) null, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      StringVector stringVector0 = new StringVector();
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("j'VPj8P{HvYL@^@CrmG");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      // Undeclared exception!
      try { 
        strand0.getMatchingCodons((Range) null, stringVector0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = new Strand(bases0, 1);
      // Undeclared exception!
      try { 
        strand0.getGCount();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      Strand strand0 = new Strand((Bases) null, 191);
      // Undeclared exception!
      try { 
        strand0.getDirection();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      Strand strand0 = new Strand((Bases) null, 3);
      // Undeclared exception!
      try { 
        strand0.getACount();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      // Undeclared exception!
      try { 
        Strand.deleteRange((MarkerRange) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      // Undeclared exception!
      try { 
        Strand.addBases((Marker) null, "gDd/IkgoY");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = new Strand(bases0, (-5));
      boolean boolean0 = strand0.isForwardStrand();
      assertEquals(2, strand0.getDirection());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("uk.ac.sanger.artemis.sequence.Strand");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      int int0 = strand0.getDirection();
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("@3s>u1<|PZI@42");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = new Strand(bases0, 120);
      int int0 = strand0.getDirection();
      assertEquals(2, int0);
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("NOW TRYING TO CONTINUE TO COMMIT", "NOW TRYING TO CONTINUE TO COMMIT");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      Range range0 = new Range(2, 2);
      strand0.getSubSequence(range0);
      assertEquals(2, strand0.getDirection());
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      // Undeclared exception!
      try { 
        strand0.getSequenceLength();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(" sessions");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = new Strand(bases0, 0);
      Bases bases1 = strand0.getBases();
      assertSame(bases1, bases0);
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("vi.-mWH3Q");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = new Strand(bases0, 1);
      int int0 = strand0.getRawPosition(0);
      assertEquals(10, int0);
      assertEquals(2, strand0.getDirection());
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("uk.ac.sanger.artemis.sequence.Strand", "{$!0e!M|");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("");
      Feature feature0 = entry0.createFeature();
      Strand strand0 = feature0.getStrand();
      strand0.getCCount();
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("vi.-mWH3Q");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = new Strand(bases0, 1);
      strand0.getCCount();
      assertEquals(2, strand0.getDirection());
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("vi.-mWH3Q");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      strand0.getGCount();
      assertTrue(strand0.isForwardStrand());
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("NOW TRYING TO CONTINUE TO COMMIT");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = new Strand(bases0, 0);
      strand0.getTCount();
      assertEquals(2, strand0.getDirection());
  }

  @Test(timeout = 4000)
  public void test43()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      strand0.getACount();
      assertTrue(strand0.isForwardStrand());
  }

  @Test(timeout = 4000)
  public void test44()  throws Throwable  {
      char[] charArray0 = new char[4];
      CharArrayReader charArrayReader0 = new CharArrayReader(charArray0);
      LineNumberReader lineNumberReader0 = new LineNumberReader(charArrayReader0);
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(lineNumberReader0);
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence(linePushBackReader0);
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      strand0.getACount();
      assertEquals(2, strand0.getDirection());
  }

  @Test(timeout = 4000)
  public void test45()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      try { 
        strand0.makeMarkerRangeFromRawPositions(5, (-5));
        fail("Expecting exception: Exception");
      
      } catch(Exception e) {
         //
         // position: -5
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerInternal", e);
      }
  }

  @Test(timeout = 4000)
  public void test46()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = new Strand(bases0, (-2618));
      // Undeclared exception!
      try { 
        strand0.makeMarkerRangeFromRawPositions(0, (-5));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test47()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("jMQ/n?Z-5GP<}b3F0U");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      Marker marker0 = strand0.makeMarkerFromRawPosition(1);
      assertEquals(1, marker0.getPosition());
  }

  @Test(timeout = 4000)
  public void test48()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      bases0.addBases(1, 1, "vTgt!f:6B&i!%@?LS");
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(1);
      // Undeclared exception!
      try { 
        Strand.getOpenReadingFrameRanges(markerRange0, 2, 2003, 0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected OutOfRangeException
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test49()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("vi.-mWH3Q");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = new Strand(bases0, 1);
      Marker marker0 = strand0.makeMarkerFromRawPosition(5);
      MarkerRange markerRange0 = Strand.getORFAroundMarker(marker0, false);
      Range range0 = markerRange0.getRange();
      char[] charArray0 = strand0.getRawSubSequenceC(range0);
      assertArrayEquals(new char[] {'m', 'n', 'n'}, charArray0);
      assertEquals(2, strand0.getDirection());
  }

  @Test(timeout = 4000)
  public void test50()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("d");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      String string0 = strand0.getStrandBases();
      assertEquals("d", string0);
  }

  @Test(timeout = 4000)
  public void test51()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      // Undeclared exception!
      try { 
        strand0.getStrandBases();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test52()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(";PUDTxscLL,?8TIo");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = new Strand(bases0, 5);
      // Undeclared exception!
      try { 
        strand0.getRawSubSequenceC((Range) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test53()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("org.biojava.bio.seq.impl.SimpleHomologyFeature", "org.biojava.bio.seq.impl.SimpleHomologyFeature");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      Range range0 = new Range((-5), 1);
      strand0.getStopOrStartCodons(range0, (StringVector) null);
      assertEquals(2, strand0.getDirection());
  }

  @Test(timeout = 4000)
  public void test54()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      bases0.addBases(1, 1, "vTgt!f:6B&i!%@?LS");
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(1);
      MarkerRange[] markerRangeArray0 = Strand.getOpenReadingFrameRanges(markerRange0, 2, 2, 0);
      assertNotNull(markerRangeArray0);
  }

  @Test(timeout = 4000)
  public void test55()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("d");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      try { 
        strand0.makeMarkerRangeFromPositions(0, 0);
        fail("Expecting exception: Exception");
      
      } catch(Exception e) {
         //
         // position: 0
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerInternal", e);
      }
  }

  @Test(timeout = 4000)
  public void test56()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("vi.-mWH3Q");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = new Strand(bases0, 1);
      Range range0 = new Range(0);
      String[] stringArray0 = new String[5];
      StringVector stringVector0 = new StringVector(stringArray0);
      strand0.getMatchingCodons(range0, stringVector0);
      assertEquals(2, strand0.getDirection());
  }

  @Test(timeout = 4000)
  public void test57()  throws Throwable  {
      // Undeclared exception!
      try { 
        Strand.getCodonAtMarker((Marker) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test58()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("vi.-mWH3Q");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = new Strand(bases0, 1);
      Marker marker0 = strand0.makeMarker(1);
      MarkerRange markerRange0 = Strand.getORFAroundMarker(marker0, false);
      Strand.deleteRange(markerRange0);
      assertEquals(6, genbankStreamSequence0.length());
      assertEquals(6, genbankStreamSequence0.getOtherCount());
  }

  @Test(timeout = 4000)
  public void test59()  throws Throwable  {
      // Undeclared exception!
      try { 
        Strand.markerRangeBases((MarkerRange) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Strand", e);
      }
  }

  @Test(timeout = 4000)
  public void test60()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      Range range0 = new Range(0);
      String string0 = strand0.getRawSubSequence(range0);
      assertEquals("@", string0);
  }

  @Test(timeout = 4000)
  public void test61()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("NOW TRYING TO CONTINUE TO COMMIT", "NOW TRYING TO CONTINUE TO COMMIT");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      Range range0 = new Range(2, 2);
      strand0.getSpacedTranslation(range0, false);
      assertEquals(2, strand0.getDirection());
  }

  @Test(timeout = 4000)
  public void test62()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("NOW TRYING TO CONTINUE TO COMMIT");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = new Strand(bases0, 0);
      Range range0 = new Range(2, 2);
      strand0.getTranslation(range0, false);
      assertEquals(2, strand0.getDirection());
  }
}
