/*
 * Copyright (C) 2016 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.build.gradle.integration.library

import com.android.build.gradle.integration.common.fixture.GradleTestProject
import com.android.build.gradle.integration.common.truth.AbstractAndroidSubject
import com.android.build.gradle.integration.common.utils.TestFileUtils
import groovy.transform.CompileStatic
import org.junit.AfterClass
import org.junit.BeforeClass
import org.junit.ClassRule
import org.junit.Test

import static com.android.build.gradle.integration.common.truth.TruthHelper.assertThatAar
/**
 * Assemble tests for minifyLib with provided dependency
 */
@CompileStatic
class MinifyLibProvidedDepTest {
    @ClassRule
    static public GradleTestProject project = GradleTestProject.builder()
            .fromTestProject("libMinify")
            .create()

    @BeforeClass
    static void setUp() {
        project.buildFile << """
dependencies {
    provided 'com.android.support:appcompat-v7:23.0.1'
}
"""

        project.execute("clean", "build")
    }

    @AfterClass
    static void cleanUp() {
        project = null
    }

    @Test
    void "check library has its fields obfuscated"() {
        // test whether a library project has its fields obfuscated
        TestFileUtils.checkContent(
                project.getOutputFile("mapping/release/mapping.txt"),
                "int obfuscatedInt -> a")
    }

    @Test
    void "check R class is not packaged"() {
        assertThatAar(project.getAar("debug")).doesNotContainClass(
                "Lcom/android/tests/basic.R;",
                AbstractAndroidSubject.ClassFileScope.MAIN)
    }
}
