/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.store;

import android.databinding.tool.util.L;
import android.databinding.tool.util.ParserHelper;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.ArrayUtils;

public class ResourceBundle
implements Serializable {
    private static final String[] ANDROID_VIEW_PACKAGE_VIEWS = new String[]{"View", "ViewGroup", "ViewStub", "TextureView", "SurfaceView"};
    private String mAppPackage;
    private HashMap<String, List<LayoutFileBundle>> mLayoutBundles = new HashMap();

    public ResourceBundle(String appPackage) {
        this.mAppPackage = appPackage;
    }

    public void addLayoutBundle(LayoutFileBundle bundle) {
        Preconditions.checkArgument(bundle.mFileName != null, "File bundle must have a name");
        if (!this.mLayoutBundles.containsKey(bundle.mFileName)) {
            this.mLayoutBundles.put(bundle.mFileName, new ArrayList());
        }
        List<LayoutFileBundle> bundles = this.mLayoutBundles.get(bundle.mFileName);
        for (LayoutFileBundle existing : bundles) {
            if (!existing.equals(bundle)) continue;
            L.d("skipping layout bundle %s because it already exists.", bundle);
            return;
        }
        L.d("adding bundle %s", bundle);
        bundles.add(bundle);
    }

    public HashMap<String, List<LayoutFileBundle>> getLayoutBundles() {
        return this.mLayoutBundles;
    }

    public String getAppPackage() {
        return this.mAppPackage;
    }

    public void validateMultiResLayouts() {
        for (List<LayoutFileBundle> layoutFileBundles : this.mLayoutBundles.values()) {
            for (LayoutFileBundle layoutFileBundle : layoutFileBundles) {
                for (BindingTargetBundle target : layoutFileBundle.getBindingTargetBundles()) {
                    if (!target.isBinder()) continue;
                    List<LayoutFileBundle> boundTo = this.mLayoutBundles.get(target.getIncludedLayout());
                    if (boundTo == null || boundTo.isEmpty()) {
                        L.e("There is no binding for %s", target.getIncludedLayout());
                        continue;
                    }
                    String binding = boundTo.get(0).getFullBindingClass();
                    target.setInterfaceType(binding);
                }
            }
        }
        Iterable<Map.Entry<String, List<LayoutFileBundle>>> multiResLayouts = Iterables.filter(this.mLayoutBundles.entrySet(), new Predicate<Map.Entry<String, List<LayoutFileBundle>>>(){

            @Override
            public boolean apply(Map.Entry<String, List<LayoutFileBundle>> input) {
                return input.getValue().size() > 1;
            }
        });
        for (Map.Entry<String, List<LayoutFileBundle>> bundles : multiResLayouts) {
            HashMap<String, String> variableTypes = new HashMap<String, String>();
            HashMap<String, String> importTypes = new HashMap<String, String>();
            String bindingClass = null;
            for (LayoutFileBundle bundle : bundles.getValue()) {
                String existing;
                bundle.mHasVariations = true;
                if (bindingClass == null) {
                    bindingClass = bundle.getFullBindingClass();
                } else if (!bindingClass.equals(bundle.getFullBindingClass())) {
                    L.e("Binding class names must match. Layout file for %s have different binding class names %s and %s", bundle.getFileName(), bindingClass, bundle.getFullBindingClass());
                }
                for (Map.Entry<String, String> entry : bundle.mVariables.entrySet()) {
                    existing = (String)variableTypes.get(entry.getKey());
                    Preconditions.checkState(existing == null || existing.equals(entry.getValue()), "inconsistent variable types for %s for layout %s", entry.getKey(), bundle.mFileName);
                    variableTypes.put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<String, String> entry : bundle.mImports.entrySet()) {
                    existing = (String)importTypes.get(entry.getKey());
                    Preconditions.checkState(existing == null || existing.equals(entry.getValue()), "inconsistent variable types for %s for layout %s", entry.getKey(), bundle.mFileName);
                    importTypes.put(entry.getKey(), entry.getValue());
                }
            }
            for (LayoutFileBundle bundle : bundles.getValue()) {
                L.d("checking for missing variables in %s / %s", bundle.mFileName, bundle.mConfigName);
                for (Map.Entry<String, String> entry : variableTypes.entrySet()) {
                    if (bundle.mVariables.containsKey(entry.getKey())) continue;
                    bundle.mVariables.put(entry.getKey(), entry.getValue());
                    L.d("adding missing variable %s to %s / %s", entry.getKey(), bundle.mFileName, bundle.mConfigName);
                }
                for (Map.Entry<String, String> entry : importTypes.entrySet()) {
                    if (bundle.mImports.containsKey(entry.getKey())) continue;
                    bundle.mImports.put(entry.getKey(), entry.getValue());
                    L.d("adding missing import %s to %s / %s", entry.getKey(), bundle.mFileName, bundle.mConfigName);
                }
            }
            HashSet<String> includeBindingIds = new HashSet<String>();
            HashSet<String> viewBindingIds = new HashSet<String>();
            HashMap<String, String> viewTypes = new HashMap<String, String>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            L.d("validating ids for %s", bundles.getKey());
            for (LayoutFileBundle bundle : bundles.getValue()) {
                for (BindingTargetBundle bindingTargetBundle : bundle.mBindingTargetBundles) {
                    L.d("checking %s %s %s", bindingTargetBundle.getId(), bindingTargetBundle.getFullClassName(), bindingTargetBundle.isBinder());
                    if (bindingTargetBundle.mId == null) continue;
                    if (bindingTargetBundle.isBinder()) {
                        Preconditions.checkState(!viewBindingIds.contains(bindingTargetBundle.getFullClassName()), "Cannot use the same id for a View and an include tag. Error in file %s / %s", bundle.mFileName, bundle.mConfigName);
                        includeBindingIds.add(bindingTargetBundle.getFullClassName());
                    } else {
                        Preconditions.checkState(!includeBindingIds.contains(bindingTargetBundle.getFullClassName()), "Cannot use the same id for a View and an include tag. Error in file %s / %s", bundle.mFileName, bundle.mConfigName);
                        viewBindingIds.add(bindingTargetBundle.getFullClassName());
                    }
                    String existingType = (String)viewTypes.get(bindingTargetBundle.mId);
                    if (existingType == null) {
                        L.d("assigning %s as %s", bindingTargetBundle.getId(), bindingTargetBundle.getFullClassName());
                        viewTypes.put(bindingTargetBundle.mId, bindingTargetBundle.getFullClassName());
                        if (!bindingTargetBundle.isBinder()) continue;
                        hashMap.put(bindingTargetBundle.mId, bindingTargetBundle.getIncludedLayout());
                        continue;
                    }
                    if (existingType.equals(bindingTargetBundle.getFullClassName())) continue;
                    if (bindingTargetBundle.isBinder()) {
                        L.d("overriding %s as base binder", bindingTargetBundle.getId());
                        viewTypes.put(bindingTargetBundle.mId, "android.databinding.ViewDataBinding");
                        hashMap.put(bindingTargetBundle.mId, bindingTargetBundle.getIncludedLayout());
                        continue;
                    }
                    L.d("overriding %s as base view", bindingTargetBundle.getId());
                    viewTypes.put(bindingTargetBundle.mId, "android.view.View");
                }
            }
            for (LayoutFileBundle bundle : bundles.getValue()) {
                for (Map.Entry entry : viewTypes.entrySet()) {
                    BindingTargetBundle target = bundle.getBindingTargetById((String)entry.getKey());
                    if (target == null) {
                        String include = (String)hashMap.get(entry.getKey());
                        if (include == null) {
                            bundle.createBindingTarget((String)entry.getKey(), (String)entry.getValue(), false, null, null);
                            continue;
                        }
                        BindingTargetBundle bindingTargetBundle = bundle.createBindingTarget((String)entry.getKey(), null, false, null, null);
                        bindingTargetBundle.setIncludedLayout((String)hashMap.get(entry.getKey()));
                        bindingTargetBundle.setInterfaceType((String)entry.getValue());
                        continue;
                    }
                    L.d("setting interface type on %s (%s) as %s", target.mId, target.getFullClassName(), entry.getValue());
                    target.setInterfaceType((String)entry.getValue());
                }
            }
        }
        for (Map.Entry<String, List<LayoutFileBundle>> entry : this.mLayoutBundles.entrySet()) {
            for (LayoutFileBundle bundle : entry.getValue()) {
                String configName;
                if (bundle.hasVariations()) {
                    String parentFileName = bundle.mDirectory;
                    L.d("parent file for %s is %s", bundle.getFileName(), parentFileName);
                    configName = "layout".equals(parentFileName) ? "" : ParserHelper.INSTANCE$.toClassName(parentFileName.substring("layout-".length()));
                } else {
                    configName = "";
                }
                bundle.mConfigName = configName;
            }
        }
    }

    private static final class NameTypeAdapter
    extends XmlAdapter<MarshalledMapType, Map<String, String>> {
        private NameTypeAdapter() {
        }

        public HashMap<String, String> unmarshal(MarshalledMapType v) throws Exception {
            HashMap<String, String> map = new HashMap<String, String>();
            if (v.entries != null) {
                for (MarshalledNameType entry : v.entries) {
                    map.put(entry.name, entry.type);
                }
            }
            return map;
        }

        public MarshalledMapType marshal(Map<String, String> v) throws Exception {
            if (v.isEmpty()) {
                return null;
            }
            MarshalledMapType marshalled = new MarshalledMapType();
            marshalled.entries = new ArrayList<MarshalledNameType>();
            for (String name : v.keySet()) {
                MarshalledNameType nameType = new MarshalledNameType();
                nameType.name = name;
                nameType.type = v.get(name);
                marshalled.entries.add(nameType);
            }
            return marshalled;
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class BindingTargetBundle
    implements Serializable {
        @XmlAttribute(name="id")
        public String mId;
        @XmlAttribute(name="tag", required=true)
        public String mTag;
        @XmlAttribute(name="originalTag")
        public String mOriginalTag;
        @XmlAttribute(name="view", required=false)
        public String mViewName;
        private String mFullClassName;
        public boolean mUsed = true;
        @XmlElementWrapper(name="Expressions")
        @XmlElement(name="Expression")
        public List<BindingBundle> mBindingBundleList = new ArrayList<BindingBundle>();
        @XmlAttribute(name="include")
        public String mIncludedLayout;
        private String mInterfaceType;

        public BindingTargetBundle() {
        }

        public BindingTargetBundle(String id, String viewName, boolean used, String tag, String originalTag) {
            this.mId = id;
            this.mViewName = viewName;
            this.mUsed = used;
            this.mTag = tag;
            this.mOriginalTag = originalTag;
        }

        public void addBinding(String name, String expr) {
            this.mBindingBundleList.add(new BindingBundle(name, expr));
        }

        public void setIncludedLayout(String includedLayout) {
            this.mIncludedLayout = includedLayout;
        }

        public String getIncludedLayout() {
            return this.mIncludedLayout;
        }

        public boolean isBinder() {
            return this.mIncludedLayout != null;
        }

        public void setInterfaceType(String interfaceType2) {
            this.mInterfaceType = interfaceType2;
        }

        public String getId() {
            return this.mId;
        }

        public String getTag() {
            return this.mTag;
        }

        public String getOriginalTag() {
            return this.mOriginalTag;
        }

        public String getFullClassName() {
            if (this.mFullClassName == null) {
                this.mFullClassName = this.isBinder() ? this.mInterfaceType : (this.mViewName.indexOf(46) == -1 ? (ArrayUtils.contains(ANDROID_VIEW_PACKAGE_VIEWS, this.mViewName) ? "android.view." + this.mViewName : ("WebView".equals(this.mViewName) ? "android.webkit." + this.mViewName : "android.widget." + this.mViewName)) : this.mViewName);
            }
            if (this.mFullClassName == null) {
                L.e("Unexpected full class name = null. view = %s, interface = %s, layout = %s", this.mViewName, this.mInterfaceType, this.mIncludedLayout);
            }
            return this.mFullClassName;
        }

        public boolean isUsed() {
            return this.mUsed;
        }

        public List<BindingBundle> getBindingBundleList() {
            return this.mBindingBundleList;
        }

        public String getInterfaceType() {
            return this.mInterfaceType;
        }

        @XmlAccessorType(value=XmlAccessType.NONE)
        public static class BindingBundle
        implements Serializable {
            private String mName;
            private String mExpr;

            public BindingBundle() {
            }

            public BindingBundle(String name, String expr) {
                this.mName = name;
                this.mExpr = expr;
            }

            @XmlAttribute(name="attribute", required=true)
            public String getName() {
                return this.mName;
            }

            @XmlAttribute(name="text", required=true)
            public String getExpr() {
                return this.mExpr;
            }

            public void setName(String name) {
                this.mName = name;
            }

            public void setExpr(String expr) {
                this.mExpr = expr;
            }
        }
    }

    public static class MarshalledMapType {
        public List<MarshalledNameType> entries;
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class MarshalledNameType {
        @XmlAttribute(name="type", required=true)
        public String type;
        @XmlAttribute(name="name", required=true)
        public String name;
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    @XmlRootElement(name="Layout")
    public static class LayoutFileBundle
    implements Serializable {
        @XmlAttribute(name="layout", required=true)
        public String mFileName;
        @XmlAttribute(name="modulePackage", required=true)
        public String mModulePackage;
        private String mConfigName;
        @XmlAttribute(name="bindingClass", required=false)
        public String mBindingClass;
        private String mFullBindingClass;
        private String mBindingClassName;
        private String mBindingPackage;
        @XmlAttribute(name="directory", required=true)
        public String mDirectory;
        public boolean mHasVariations;
        @XmlElement(name="Variables")
        @XmlJavaTypeAdapter(value=NameTypeAdapter.class)
        public Map<String, String> mVariables = new HashMap<String, String>();
        @XmlElement(name="Imports")
        @XmlJavaTypeAdapter(value=NameTypeAdapter.class)
        public Map<String, String> mImports = new HashMap<String, String>();
        @XmlElementWrapper(name="Targets")
        @XmlElement(name="Target")
        public List<BindingTargetBundle> mBindingTargetBundles = new ArrayList<BindingTargetBundle>();
        @XmlAttribute(name="isMerge", required=true)
        private boolean mIsMerge;

        public LayoutFileBundle() {
        }

        public LayoutFileBundle(String fileName, String directory, String modulePackage, boolean isMerge) {
            this.mFileName = fileName;
            this.mDirectory = directory;
            this.mModulePackage = modulePackage;
            this.mIsMerge = isMerge;
        }

        public void addVariable(String name, String type) {
            this.mVariables.put(name, type);
        }

        public void addImport(String alias, String type) {
            this.mImports.put(alias, type);
        }

        public BindingTargetBundle createBindingTarget(String id, String viewName, boolean used, String tag, String originalTag) {
            BindingTargetBundle target = new BindingTargetBundle(id, viewName, used, tag, originalTag);
            this.mBindingTargetBundles.add(target);
            return target;
        }

        public boolean isEmpty() {
            return this.mVariables.isEmpty() && this.mImports.isEmpty() && this.mBindingTargetBundles.isEmpty();
        }

        public BindingTargetBundle getBindingTargetById(String key) {
            for (BindingTargetBundle target : this.mBindingTargetBundles) {
                if (!key.equals(target.mId)) continue;
                return target;
            }
            return null;
        }

        public String getFileName() {
            return this.mFileName;
        }

        public String getConfigName() {
            return this.mConfigName;
        }

        public String getDirectory() {
            return this.mDirectory;
        }

        public boolean hasVariations() {
            return this.mHasVariations;
        }

        public Map<String, String> getVariables() {
            return this.mVariables;
        }

        public Map<String, String> getImports() {
            return this.mImports;
        }

        public boolean isMerge() {
            return this.mIsMerge;
        }

        public String getBindingClassName() {
            if (this.mBindingClassName == null) {
                String fullClass = this.getFullBindingClass();
                int dotIndex = fullClass.lastIndexOf(46);
                this.mBindingClassName = fullClass.substring(dotIndex + 1);
            }
            return this.mBindingClassName;
        }

        public void setBindingClass(String bindingClass) {
            this.mBindingClass = bindingClass;
        }

        public String getBindingClassPackage() {
            if (this.mBindingPackage == null) {
                String fullClass = this.getFullBindingClass();
                int dotIndex = fullClass.lastIndexOf(46);
                this.mBindingPackage = fullClass.substring(0, dotIndex);
            }
            return this.mBindingPackage;
        }

        private String getFullBindingClass() {
            if (this.mFullBindingClass == null) {
                this.mFullBindingClass = this.mBindingClass == null ? this.getModulePackage() + ".databinding." + ParserHelper.INSTANCE$.toClassName(this.getFileName()) + "Binding" : (this.mBindingClass.startsWith(".") ? this.getModulePackage() + this.mBindingClass : (this.mBindingClass.indexOf(46) < 0 ? this.getModulePackage() + ".databinding." + this.mBindingClass : this.mBindingClass));
            }
            return this.mFullBindingClass;
        }

        public List<BindingTargetBundle> getBindingTargetBundles() {
            return this.mBindingTargetBundles;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LayoutFileBundle bundle = (LayoutFileBundle)o;
            if (this.mConfigName != null ? !this.mConfigName.equals(bundle.mConfigName) : bundle.mConfigName != null) {
                return false;
            }
            if (this.mDirectory != null ? !this.mDirectory.equals(bundle.mDirectory) : bundle.mDirectory != null) {
                return false;
            }
            return !(this.mFileName != null ? !this.mFileName.equals(bundle.mFileName) : bundle.mFileName != null);
        }

        public int hashCode() {
            int result = this.mFileName != null ? this.mFileName.hashCode() : 0;
            result = 31 * result + (this.mConfigName != null ? this.mConfigName.hashCode() : 0);
            result = 31 * result + (this.mDirectory != null ? this.mDirectory.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "LayoutFileBundle{mHasVariations=" + this.mHasVariations + ", mDirectory='" + this.mDirectory + '\'' + ", mConfigName='" + this.mConfigName + '\'' + ", mModulePackage='" + this.mModulePackage + '\'' + ", mFileName='" + this.mFileName + '\'' + '}';
        }

        public String getModulePackage() {
            return this.mModulePackage;
        }
    }
}

