# D.6 Are anarchists against Nationalism?

Yes, anarchists are opposed to nationalism in all its forms. British
anarchists Stuart Christie and Albert Meltzer simply point out the obvious:
_"As a nation implies a state, it is not possible to be a nationalist and an
anarchist."_ [**The Floodgates of Anarchy**, p. 59fn]

To understand this position, we must first define what anarchists mean by
nationalism. For many people, it is just the natural attachment to home, the
place one grew up. Nationality, as Bakunin noted, is a _"natural and social
fact,"_ as _"every people and the smallest folk-unit has its own character,
its own specific mode of existence, its own way of speaking, feeling,
thinking, and acting; and it is this idiosyncrasy that constitutes the essence
of nationality."_ [**The Political Philosophy of Bakunin**, p. 325] These
feelings, however, obviously do not exist in a social vacuum. They cannot be
discussed without also discussing the nature of these groups and what classes
and other social hierarchies they contain. Once we do this, the anarchist
opposition to nationalism becomes clear.

This means that anarchists distinguish between **nationality** (that is,
cultural affinity) and **nationalism** (confined to the state and government
itself). This allows us to define what we support and oppose -- nationalism,
at root, is destructive and reactionary, whereas cultural difference and
affinity is a source of community, social diversity and vitality.

Such diversity is to be celebrated and allowed to express it itself on its own
terms. Or, as Murray Bookchin puts it, _"[t]hat specific peoples should be
free to fully develop their own cultural capacities is not merely a right but
a desideratum. The world would be a drab place indeed if a magnificent mosaic
of different cultures does not replace the largely decultured and homogenised
world created by modern capitalism."_ [_"Nationalism and the 'National
Question'"_, pp. 8-36. **Society and Nature**, No. 5, pp. 28-29] But, as he
also warns, such cultural freedom and variety should **not** be confused with
nationalism. The latter is far more (and ethically, a lot less) than simple
recognition of cultural uniqueness and love of home. Nationalism is the love
of, or the desire to create, a nation-state and for this reason anarchists are
opposed to it, in all its forms.

This means that nationalism cannot and must not be confused with nationality.
The later is a product of social processes while the former to a product of
state action and elite rule. Social evolution cannot be squeezed into the
narrow, restricting borders of the nation state without harming the
individuals whose lives **make** that social development happen in the first
place.

The state, as we have seen, is a centralised body invested with power and a
social monopoly of force. As such it pre-empts the autonomy of localities and
peoples, and in the name of the "nation" crushes the living, breathing reality
of "nations" (i.e. peoples and their cultures) with one law, one culture and
one "official" history. Unlike most nationalists, anarchists recognise that
almost all "nations" are in fact not homogeneous, and so consider nationality
to be far wider in application than just lines on maps, created by conquest.
Hence we think that recreating the centralised state in a slightly smaller
area, as nationalist movements generally advocate, cannot solve what is called
the "national question."

Ultimately, as Rudolf Rocker argued, the _"**nation is not the cause, but the
result of the state. It is the state that creates the nation, not the nation
the state**."_ Every state _"is an artificial mechanism imposed upon [people]
from above by some ruler, and it never pursues any other ends but to defend
and make secure the interests of privileged minorities within society."_
Nationalism _"has never been anything but the political religion of the modern
state."_ [**Nationalism and Culture**, p. 200 and p. 201] It was created to
reinforce the state by providing it with the loyalty of a people of shared
linguistic, ethnic, and cultural affinities. And if these shared affinities do
not exist, the state will create them by centralising education in its own
hands, imposing an "official" language and attempting to crush cultural
differences from the peoples within its borders.

This is because it treats groups of people not as unique individuals but
rather _"as if they were individuals with definite traits of character and
peculiar psychic properties or intellectual qualities"_ which _"must
irrevocably lead to the most monstrously deceptive conclusions."_ [Rocker,
**Op. Cit.**, p. 437] This creates the theoretical justification for
authoritarianism, as it allows the stamping out of all forms of individuality
and local customs and cultures which do not concur with the abstract standard.
In addition, nationalism hides class differences within the "nation" by
arguing that all people must unite around their supposedly common interests
(as members of the same "nation"), when in fact they have nothing in common
due to the existence of hierarchies and classes.

Malatesta recognised this when he noted that you cannot talk about states like
they were _"homogeneous ethnographic units, each having its proper interests,
aspirations, and mission, in opposition to the interests, aspirations, and
mission of rival units. This may be true relatively, as long as the oppressed,
and chiefly the workers, have no self-consciousness, fail to recognise the
injustice of their inferior position, and make themselves the docile tools of
the oppressors."_ In that case, it is _"the dominating class only that
counts"_ and this _"owning to its desire to conserve and to enlarge its power
. . . may excite racial ambitions and hatred, and send its nation, its flock,
against 'foreign' countries, with a view to releasing them from their present
oppressors, and submitting them to its own political and economical
domination."_ Thus anarchists have _"always fought against patriotism, which
is a survival of the past, and serves well the interests of the oppressors."_
[**Errico Malatesta: His Life and Ideas**, p. 244]

Thus nationalism is a key means of obscuring class differences and getting
those subject to hierarchies to accept them as "natural." As such, it plays an
important role in keeping the current class system going (unsurprisingly, the
nation-state and its nationalism arose at the same time as capitalism). As
well dividing the working class internationally, it is also used within a
nation state to turn working class people born in a specific nation against
immigrants. By getting native-born workers to blame newcomers, the capitalist
class weakens the resistance to their power as well as turning economic issues
into racial/nationalist ones. In practice, however, nationalism is a _"state
ideology"_ which boils down to saying it is _"'our country' as opposed to
**theirs**, meaning **we** were the serfs of the government first."_ [Christie
and Meltzer, **Op. Cit.**, p. 71] It tries to confuse love of where you grow
up or live with _"love of the State"_ and so nationalism is _"not the faithful
expression"_ of this natural feeling but rather _"an expression distorted by
means of a false abstraction, always for the benefit of an exploiting
minority."_ [Bakunin, **Op. Cit.**, p. 324]

Needless to say, the nationalism of the bourgeoisie often comes into direct
conflict with the people who make up the nation it claims to love. Bakunin
simply stated a truism when he noted that the capitalist class _"would rather
submit"_ to a _"foreign yoke than renounce its social privileges and accept
economic equality."_ This does not mean that the _"bourgeoisie is unpatriotic;
on the contrary patriotism, in the narrowest sense, is its essential virtue.
But the bourgeoisie love their country only because, for them, the country,
represented by the State, safeguards their economic, political, and social
privileges. Any nation withdrawing their protection would be disowned by them,
Therefore, for the bourgeoisie, the country **is** the State. Patriots of the
State, they become furious enemies of the masses if the people, tried of
sacrificing themselves, of being used as a passive footstool by the
government, revolt against it. If the bourgeoisie had to choose between the
masses who rebel against the State"_ and a foreign invader, _"they would
surely choose the latter."_ [**Bakunin on Anarchism**, pp. 185-6] Given this,
Bakunin would have not been surprised by either the rise of Fascism in Italy
nor when the Allies in post-fascist Italy _"crush[ed] revolutionary
movements"_ and gave _"their support to fascists who made good by becoming
Allied Quislings."_ [Marie-Louise Berneri, **Neither East Nor West**, p. 97]

In addition, nationalism is often used to justify the most horrific crimes,
with the Nation effectively replacing God in terms of justifying injustice and
oppression and allowing individuals to wash their hands of their own actions.
For _"under cover of the nation everything can be hid"_ argues Rocker (echoing
Bakunin, we must note). _"The national flag covers every injustice, every
inhumanity, every lie, every outrage, every crime. The collective
responsibility of the nation kills the sense of justice of the individual and
brings man to the point where he overlooks injustice done; where, indeed, it
may appear to him a meritorious act if committed in the interests of the
nation."_ [**Op. Cit.**, p. 252] So when discussing nationalism:

> _"we must not forget that we are always dealing with the organised
selfishness of privileged minorities which hide behind the skirts of the
nation, hide behind the credulity of the masses. We speak of national
interests, national capital, national spheres of interest, national honour,
and national spirit; but we forget that behind all this there are hidden
merely the selfish interests of power-loving politicians and money-loving
business men for whom the nation is a convenient cover to hide their personal
greed and their schemes for political power from the eyes of the world."_
[Rocker, **Op. Cit.**, pp. 252-3]

Hence we see the all too familiar sight of successful "national liberation"
movements replacing foreign oppression with a home-based one. Nationalist
governments introduce _"the worse features of the very empires from which
oppressed peoples have tried to shake loose. Not only do they typically
reproduce state machines that are as oppressive as the ones that colonial
powers imposed on them, but they reinforce those machines with cultural,
religious, ethnic, and xenophobic traits that are often used to foster
regional and even domestic hatreds and sub-imperialisms."_ [Bookchin, **Op.
Cit.**, p. 30] This is unsurprising as nationalism delivers power to local
ruling classes as it relies on taking state power. As a result, nationalism
can never deliver freedom to the working class (the vast majority of a given
"nation") as its function is to build a mass support base for local elites
angry with imperialism for blocking their ambitions to rule and exploit
"their" nation and fellow country people.

In fact, nationalism is no threat to capitalism or even to imperialism. It
replaces imperialist domination with local elite and foreign oppression and
exploitation with native versions. That sometimes the local elites, like
imperial ones, introduce reforms which benefit the majority does not change
the nature of the new regimes although this does potentially bring them into
conflict with imperialist powers. As Chomsky notes, for imperialism the
_"threat is not nationalism, but independent nationalism, which focuses on the
needs of the population, not merely the wealthy sectors and the foreign
investors to whom they are linked. Subservient nationalism that does not
succumb to these heresies is quite welcome"_ and it is _"quite willing to deal
with them if they are willing to sell the country to the foreign master, as
Third World elites (including now those in much of Eastern Europe) are often
quite willing to do, since they may greatly benefit even as their countries
are destroyed."_ [_"Nationalism and the New World Order"_ pp. 1-7, **Society
and Nature**, No. 5, pp. 4-5] However, independent nationalism is like social
democracy in imperialist countries in that it may, at best, reduce the evils
of the class system and social hierarchies but it never gets rid of them (at
worse, it creates new classes and hierarchies clustered around the state
bureaucracy).

Anarchists oppose nationalism in all its forms as harmful to the interests of
those who make up a given nation and their cultural identities. As Rocker put
it, peoples and groups of peoples have _"existed long before the state put in
its appearance"_ and _"develop without the assistance of the state. They are
only hindered in their natural development when some external power interferes
by violence with their life and forces it into patterns which it has not known
before."_ A nation, in contrast, _"encompasses a whole array of different
peoples and groups of peoples who have by more or less violent means been
pressed together into the frame of a common state."_ In other words, the
_"nation is, then, unthinkable without the state."_ [**Op. Cit.**, p. 201]

Given this, we do support nationality and cultural difference, diversity and
self-determination as a natural expression of our love of freedom and support
for decentralisation. This should not, however, be confused with supporting
nationalism. In addition, it goes without saying that a nationality that take
on notions of racial, cultural or ethnic "superiority" or "purity" or believe
that cultural differences are somehow rooted in biology get no support from
anarchists. Equally unsurprisingly, anarchists have been the most consistent
foes of that particularly extreme form of nationalism, fascism (_"a politico-
economic state where the ruling class of each country behaves towards its own
people as . . . it has behaved to the colonial peoples under its heel."_ [Bart
de Ligt, **The Conquest of Violence**, p. 74]). Moreover, we do not support
those aspects of specific cultures which reflect social hierarchies (for
example, many traditional cultures have sexist and homophobic tendencies). By
supporting nationality, we do not advocate tolerating these. Nor do the
negative aspects of specific cultures justify another state imposing its will
on it in the name of "civilising" it. As history shows, such "humanitarian"
intervention is just a mask for justifying imperialist conquest and
exploitation and it rarely works as cultural change has to flow from below, by
the actions of the oppressed themselves, in order to be successful.

In opposition to nationalism, Anarchists are _"proud of being
internationalists."_ We seek _"the end of all oppression and of all
exploitation,"_ and so aim _"to awaken a consciousness of the antagonism of
interests between dominators and dominated, between exploiters and workers,
and to develop the class struggle inside each country, and the solidarity
among all workers across the frontiers, as against any prejudice and any
passion of either race or nationality."_ [Malatesta, **Op. Cit.**, p. 244]

We must stress that anarchists, being opposed to all forms of exploitation and
oppression, are against a situation of external domination where the one
country dominates the people and territory of another country (i.e.,
imperialism -- see [section D.5](secD5.md)). This flows from our basic
principles as _"[t]rue internationalism will never be attained except by the
independence of each nationality, little or large, compact or disunited --
just as anarchy is in the independence of each individual. If we say no
government of man over man, how can [we] permit the government of conquered
nationalities by the conquering nationalities?"_ [Kropotkin, quoted by Martin
A. Miller, **Kropotkin**, p. 231] As we discuss in the [next
section](secD7.md), while rejecting Nationalism anarchists do not
necessarily oppose national liberation struggles against foreign domination.

[‹ D.5 What causes imperialism?](secD5.md "Go to previous page" )
[up](secDcon.md "Go to parent page" ) [D.7 Are anarchists opposed to
National Liberation struggles? ›](secD7.md "Go to next page" )

