; C Library
;
; Copyright (C) 2025 Kestrel Institute (http://www.kestrel.edu)
; Copyright (C) 2025 Kestrel Technology LLC (http://kestreltechnology.com)
;
; License: A 3-clause BSD license. See the LICENSE file distributed with ACL2.
;
; Author: Alessandro Coglio (www.alessandrocoglio.info)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "C")

(include-book "std/omaps/core" :dir :system)
(include-book "std/util/defval" :dir :system)
(include-book "xdoc/constructors" :dir :system)

(local (xdoc::set-default-parents atc-symbolic-execution-rules))

(local (include-book "kestrel/built-ins/disable" :dir :system))
(local (acl2::disable-most-builtin-logic-defuns))
(local (acl2::disable-builtin-rewrite-rules-for-defaults))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defval *atc-other-executable-counterpart-rules*
  :short "List of other executable counterpart rules
          for the proofs generated by ATC."
  :long
  (xdoc::topstring
   (xdoc::p
    "These should be probably re-organized by their purpose
     rather than by their kind (i.e. executable counterparts)."))
  '((:e booleanp)
    (:e len)
    (:e natp)
    (:e omap::assoc)
    (:e scope-list-fix)
    (:e scope-listp)
    (:e scopep)
    (:e tyname)
    (:e obj-adeclor-none)
    (:e valuep)
    (:e value-list-fix)
    (:e zp)
    (:e <<)))
