!{\src2tex{textfont=tt}}
!!****f* ABINIT/calc_vh
!! NAME
!! calc_vh
!! 
!! FUNCTION
!! Calculate Hartree potential*r from input density
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (FJ,MT)
!! This file is distributed under the terms of the 
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!! 
!! INPUTS 
!!  den(meshsz)= input density*4*pi*r^2
!!  densz = dimension of the radial mesh (from 0 to infinity)
!!  pawdata
!!    %rad(big_meshsz)= Coordinates of the radial grid
!!    %rad_(big_meshsz)= rad(:) + AA where rad(i)=AA*(exp[BB*(i-1)]-1)
!!  pshead
!!    %log_step= Logarithmic step corresponding to radial mesh
!! 
!! OUTPUT
!!  rvh(densz)= r*Hartree potential
!!
!! PARENTS
!!      calc_vhtnzc
!!
!! CHILDREN
!!      ctrap
!!
!! SOURCE

 subroutine calc_vh(den,densz,pawdata,pshead,rvh)

 use defs_basis
 use defs_pawps

 implicit none
 
!Arguments ---------------------------------------------
 integer :: densz
 real(dp) :: den(densz),rvh(densz)

!These types are defined in defs_pawps
 type(pawdata_type) :: pawdata
 type(pshead_type) :: pshead

!Local variables ---------------------------------------
 integer :: ir
 real(dp), allocatable :: den1(:),den2(:),den3(:),den4(:)

!--------------------------------------------------------
 
 allocate (den1(densz),den2(densz),&
&          den3(densz),den4(densz))

 den1(1)=zero;den2(1)=zero
 den3(1)=zero;den4(1)=zero

 do ir=2,densz
  den1(ir)= pawdata%rad_(ir)*den(ir)
  den2(ir)= den1(ir)/pawdata%rad(ir)
 enddo

 do ir=1,densz
  call ctrap(ir,den1(1:ir),pshead%log_step,den3(ir))
  call ctrap(ir,den2(1:ir),pshead%log_step,den4(ir))
 enddo

 do ir=1,densz
  rvh(ir)=den3(ir)+pawdata%rad(ir)*(den4(densz)-den4(ir))
 enddo

 end subroutine
!!***
