/*###############################################################################
# Linux Management Providers (LMP), OS provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "cmpiOpenDRIM_OperatingSystemLoadAverages.h"
#include "OpenDRIM_OperatingSystemLoadAveragesAccess.h"

static const CMPIBroker * _broker;

#ifdef CMPI_VER_100
#define OS_OpenDRIM_OperatingSystemLoadAveragesProviderSetInstance OS_OpenDRIM_OperatingSystemLoadAveragesProviderModifyInstance
#endif

int OS_OpenDRIM_OperatingSystemLoadAverages_init(const CMPIBroker* broker);

int OS_OpenDRIM_OperatingSystemLoadAverages_finalize();

/* ---------------------------------------------------------------------------*/
/*                      Instance Provider Interface                           */
/* ---------------------------------------------------------------------------*/

CMPIStatus OS_OpenDRIM_OperatingSystemLoadAveragesProviderCleanup(CMPIInstanceMI * mi, const CMPIContext* ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = OS_OpenDRIM_OperatingSystemLoadAverages_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus OS_OpenDRIM_OperatingSystemLoadAveragesProviderEnumInstanceNames(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_OperatingSystemLoadAverages> instances;
	string errorMessage;
	
	int errorCode = OS_OpenDRIM_OperatingSystemLoadAverages_retrieve(_broker, ctx, instances, NULL, errorMessage, "ein");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_OperatingSystemLoadAverages_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIObjectPath* op = OS_OpenDRIM_OperatingSystemLoadAverages_toCMPIObjectPath(_broker, instances[i]);
		CMReturnObjectPath(rslt, op);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus OS_OpenDRIM_OperatingSystemLoadAveragesProviderEnumInstances(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_OperatingSystemLoadAverages> instances;
	string errorMessage;
	
	int errorCode = OS_OpenDRIM_OperatingSystemLoadAverages_retrieve(_broker, ctx, instances, properties, errorMessage, "ei");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_OperatingSystemLoadAverages_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIInstance* ci = OS_OpenDRIM_OperatingSystemLoadAverages_toCMPIInstance(_broker, instances[i]);
		CMReturnInstance(rslt, ci);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus OS_OpenDRIM_OperatingSystemLoadAveragesProviderGetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_OperatingSystemLoadAverages instance;
	OS_OpenDRIM_OperatingSystemLoadAverages_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = OS_OpenDRIM_OperatingSystemLoadAverages_getInstance(_broker, ctx, instance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_OperatingSystemLoadAverages_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIInstance* ci = OS_OpenDRIM_OperatingSystemLoadAverages_toCMPIInstance(_broker, instance);
	CMReturnInstance(rslt, ci);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus OS_OpenDRIM_OperatingSystemLoadAveragesProviderSetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_OperatingSystemLoadAverages newInstance, oldInstance;
	OS_OpenDRIM_OperatingSystemLoadAverages_toCPP(_broker, ci, newInstance);
	OS_OpenDRIM_OperatingSystemLoadAverages_toCPP(_broker, cop, oldInstance);
	string errorMessage;
	
	int errorCode = OS_OpenDRIM_OperatingSystemLoadAverages_getInstance(_broker, ctx, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_OperatingSystemLoadAverages_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = OS_OpenDRIM_OperatingSystemLoadAverages_setInstance(_broker, ctx, newInstance, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_OperatingSystemLoadAverages_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus OS_OpenDRIM_OperatingSystemLoadAveragesProviderCreateInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_OperatingSystemLoadAverages instance;
	OS_OpenDRIM_OperatingSystemLoadAverages_toCPP(_broker, ci, instance);
	string errorMessage;
	
	int errorCode = OS_OpenDRIM_OperatingSystemLoadAverages_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != NOT_FOUND) {
		if (errorCode == OK)
			errorCode = ALREADY_EXISTS;
		errorMessage = (string) OpenDRIM_OperatingSystemLoadAverages_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = OS_OpenDRIM_OperatingSystemLoadAverages_createInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_OperatingSystemLoadAverages_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = OS_OpenDRIM_OperatingSystemLoadAverages_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_OperatingSystemLoadAverages_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIObjectPath* _cop = OS_OpenDRIM_OperatingSystemLoadAverages_toCMPIObjectPath(_broker, instance);
	CMReturnObjectPath(rslt, _cop);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus OS_OpenDRIM_OperatingSystemLoadAveragesProviderDeleteInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_OperatingSystemLoadAverages instance;
	OS_OpenDRIM_OperatingSystemLoadAverages_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = OS_OpenDRIM_OperatingSystemLoadAverages_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_OperatingSystemLoadAverages_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = OS_OpenDRIM_OperatingSystemLoadAverages_deleteInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_OperatingSystemLoadAverages_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus OS_OpenDRIM_OperatingSystemLoadAveragesProviderExecQuery(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* lang, const char* query) {
	_E_;
	CMReturn(CMPI_RC_ERR_NOT_SUPPORTED);
}

/* ---------------------------------------------------------------------------*/
/*                   End of Instance Provider Interface                       */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                              Provider Factory                              */
/* ---------------------------------------------------------------------------*/

int OS_OpenDRIM_OperatingSystemLoadAverages_init(const CMPIBroker* broker) {
	_E_;
	_broker = broker;
	static bool initialized = false;
	if (!initialized) {
		string errorMessage;
		int errorCode = OS_OpenDRIM_OperatingSystemLoadAverages_load(broker, errorMessage);
		if (errorCode != OK) {
			errorMessage += "OS_OpenDRIM_OperatingSystemLoadAverages_init FAILED: " + (string) OpenDRIM_OperatingSystemLoadAverages_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return -1;
		}
		initialized = true;
	}
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemLoadAverages_finalize() {
	_E_;
	static bool finalized = false;
	if (!finalized) {
		string errorMessage;
		int errorCode = OS_OpenDRIM_OperatingSystemLoadAverages_unload(errorMessage);
		if (errorCode != OK) {
			errorMessage += "OS_OpenDRIM_OperatingSystemLoadAverages_unload FAILED: " + (string) OpenDRIM_OperatingSystemLoadAverages_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return errorCode;
		}
		finalized = true;
	}
	_L_;
	return OK;
}

#define OS_OpenDRIM_OperatingSystemLoadAverages_INIT if (OS_OpenDRIM_OperatingSystemLoadAverages_init(_broker) < 0) return NULL

CMInstanceMIStub(OS_OpenDRIM_OperatingSystemLoadAveragesProvider, OS_OpenDRIM_OperatingSystemLoadAveragesProvider, _broker, OS_OpenDRIM_OperatingSystemLoadAverages_INIT);

/* ---------------------------------------------------------------------------*/
/*                          End of Provider Factory                           */
/* ---------------------------------------------------------------------------*/
