/*###############################################################################
# Linux Management Providers (LMP), DNS provider package
# Copyright (C) 2007 Ilsoo Byun <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_DNSCONFORMSTOPROFILEACCESS_H_
#define OPENDRIM_DNSCONFORMSTOPROFILEACCESS_H_

#include "DNS_Common.h"

#include "OpenDRIM_DNSConformsToProfile.h"
#include "assocOpenDRIM_DNSConformsToProfile.h"

int DNS_OpenDRIM_DNSConformsToProfile_load(const CMPIBroker* broker, string& errorMessage);

int DNS_OpenDRIM_DNSConformsToProfile_unload(string& errorMessage);

int DNS_OpenDRIM_DNSConformsToProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_DNSConformsToProfile>& instances, const char** properties, string& errorMessage, const string& discriminant);

int DNS_OpenDRIM_DNSConformsToProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_DNSConformsToProfile& instance, const char** properties, string& errorMessage);

int DNS_OpenDRIM_DNSConformsToProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNSConformsToProfile& newInstance, const OpenDRIM_DNSConformsToProfile& oldInstance, const char** properties, string& errorMessage);

int DNS_OpenDRIM_DNSConformsToProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNSConformsToProfile& instance, string& errorMessage);

int DNS_OpenDRIM_DNSConformsToProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNSConformsToProfile& instance, string& errorMessage);

int DNS_OpenDRIM_DNSConformsToProfile_associatorConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int DNS_OpenDRIM_DNSConformsToProfile_associatorManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& ConformantStandard_associatedInstances, string& errorMessage, const string& discriminant);

int DNS_OpenDRIM_DNSConformsToProfile_referenceConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_DNSConformsToProfile>& OpenDRIM_DNSConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int DNS_OpenDRIM_DNSConformsToProfile_referenceManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& ConformantStandard_instances, vector<OpenDRIM_DNSConformsToProfile>& OpenDRIM_DNSConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int DNS_OpenDRIM_DNSConformsToProfile_populate(OpenDRIM_DNSConformsToProfile& instance, string& errorMessage);

#endif /*OPENDRIM_DNSCONFORMSTOPROFILEACCESS_H_*/
