/*###############################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "cmpiOpenDRIM_BIOSConcreteDependency.h"

CMPIObjectPath* BIOS_OpenDRIM_BIOSConcreteDependency_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_BIOSConcreteDependency& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_BIOSConcreteDependency_classnames[0], OpenDRIM_BIOSConcreteDependency_NAMESPACE);

	if (!instance.Antecedent_isNULL)
		op.addKey("Antecedent", instance.Antecedent);

	if (!instance.Dependent_isNULL)
		op.addKey("Dependent", instance.Dependent);

	_L_;
	return op.getHdl();
}

CMPIInstance* BIOS_OpenDRIM_BIOSConcreteDependency_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_BIOSConcreteDependency& instance) {
	_E_;
	Objectpath op(broker, BIOS_OpenDRIM_BIOSConcreteDependency_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	_L_;
	return ci.getHdl();
}

void BIOS_OpenDRIM_BIOSConcreteDependency_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_BIOSConcreteDependency& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("Antecedent", instance.Antecedent) == OK)
		instance.Antecedent_isNULL = false;

	if (op.getKey("Dependent", instance.Dependent) == OK)
		instance.Dependent_isNULL = false;

	_L_;
}

void BIOS_OpenDRIM_BIOSConcreteDependency_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_BIOSConcreteDependency& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Antecedent", instance.Antecedent) == OK)
		instance.Antecedent_isNULL = false;

	if (inst.getProperty("Dependent", instance.Dependent) == OK)
		instance.Dependent_isNULL = false;

	_L_;
}

