#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Friday 31 July 2009 13:29:42 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Examples/ViPErPaper-fig1_net.py,v 1.7 2009/07/31 20:31:15 vareille Exp $
#
# $Id: ViPErPaper-fig1_net.py,v 1.7 2009/07/31 20:31:15 vareille Exp $
#


if __name__=='__main__':
    from sys import argv
    if '--help' in argv or '-h' in argv or '-w' in argv: # run without Vision
        withoutVision = True
        from Vision.VPE import NoGuiExec
        ed = NoGuiExec()
        from NetworkEditor.net import Network
        import os
        masterNet = Network("process-"+str(os.getpid()))
        ed.addNetwork(masterNet)
    else: # run as a stand alone application while vision is hidden
        withoutVision = False
        from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
	if '-noSplash' in argv:
	    splash = False
	else:
	    splash = True
        masterNet = launchVisionToRunNetworkAsApplication(splash=splash)
        import os
        masterNet.filename = os.path.abspath(__file__)
from traceback import print_exc
## loading libraries ##
from Vision.PILNodes import imagelib
from MolKit.VisionInterface.MolKitNodes import molkitlib
from Vision.StandardNodes import stdlib
from DejaVu.VisionInterface.DejaVuNodes import vizlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

masterNet.getEditor().addLibraryInstance(imagelib,"Vision.PILNodes", "imagelib")

masterNet.getEditor().addLibraryInstance(molkitlib,"MolKit.VisionInterface.MolKitNodes", "molkitlib")

masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

masterNet.getEditor().addLibraryInstance(vizlib,"DejaVu.VisionInterface.DejaVuNodes", "vizlib")

try:
    ## saving node Read Molecule ##
    from MolKit.VisionInterface.MolKitNodes import ReadMolecule
    Read_Molecule_0 = ReadMolecule(constrkw={}, name='Read Molecule', library=molkitlib)
    masterNet.addNode(Read_Molecule_0,17,18)
    Read_Molecule_0.inputPortByName['filename'].widget.set(r"1crn.pdb", run=False)
except:
    print "WARNING: failed to restore ReadMolecule named Read Molecule in network masterNet"
    print_exc()
    Read_Molecule_0=None

try:
    ## saving node Assign Radii ##
    from MolKit.VisionInterface.MolKitNodes import AssignRadii
    Assign_Radii_1 = AssignRadii(constrkw={}, name='Assign Radii', library=molkitlib)
    masterNet.addNode(Assign_Radii_1,17,119)
    Assign_Radii_1.inputPortByName['united'].widget.set(1, run=False)
except:
    print "WARNING: failed to restore AssignRadii named Assign Radii in network masterNet"
    print_exc()
    Assign_Radii_1=None

try:
    ## saving node MSMS ##
    from MolKit.VisionInterface.MolKitNodes import AtomsAsMSMS
    MSMS_2 = AtomsAsMSMS(constrkw={}, name='MSMS', library=molkitlib)
    masterNet.addNode(MSMS_2,185,244)
    MSMS_2.inputPortByName['density'].widget.set(5.0, run=False)
    MSMS_2.inputPortByName['probe_radius'].widget.set(1.5, run=False)
    MSMS_2.inputPortByName['allComp'].widget.set(0, run=False)
except:
    print "WARNING: failed to restore AtomsAsMSMS named MSMS in network masterNet"
    print_exc()
    MSMS_2=None

try:
    ## saving node Select Nodes ##
    from MolKit.VisionInterface.MolKitNodes import NodeSelector
    Select_Nodes_3 = NodeSelector(constrkw={}, name='Select Nodes', library=molkitlib)
    masterNet.addNode(Select_Nodes_3,309,34)
    Select_Nodes_3.inputPortByName['nodeType'].widget.set(r"Atom", run=False)
    Select_Nodes_3.inputPortByName['selectionString'].widget.set(r"", run=False)
except:
    print "WARNING: failed to restore NodeSelector named Select Nodes in network masterNet"
    print_exc()
    Select_Nodes_3=None

try:
    ## saving node Extract Atom Property ##
    from MolKit.VisionInterface.MolKitNodes import AtomsProperty
    Extract_Atom_Property_4 = AtomsProperty(constrkw={}, name='Extract Atom Property', library=molkitlib)
    masterNet.addNode(Extract_Atom_Property_4,385,160)
    Extract_Atom_Property_4.inputPortByName['propertyName'].widget.set(r"radius", run=False)
except:
    print "WARNING: failed to restore AtomsProperty named Extract Atom Property in network masterNet"
    print_exc()
    Extract_Atom_Property_4=None

try:
    ## saving node MSMS triang. ##
    from MolKit.VisionInterface.MolKitNodes import GetMSMStriangles
    MSMS_triang__5 = GetMSMStriangles(constrkw={}, name='MSMS triang.', library=molkitlib)
    masterNet.addNode(MSMS_triang__5,16,230)
    MSMS_triang__5.inputPortByName['selnum'].widget.set(3, run=False)
    apply(MSMS_triang__5.inputPortByName['component'].widget.configure, (), {'max': 0})
    MSMS_triang__5.inputPortByName['component'].widget.set(0, run=False)
    apply(MSMS_triang__5.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore GetMSMStriangles named MSMS triang. in network masterNet"
    print_exc()
    MSMS_triang__5=None

try:
    ## saving node indexedPolygons ##
    from DejaVu.VisionInterface.GeometryNodes import IndexedPolygonsNE
    indexedPolygons_6 = IndexedPolygonsNE(constrkw={}, name='indexedPolygons', library=vizlib)
    masterNet.addNode(indexedPolygons_6,16,330)
    indexedPolygons_6.inputPortByName['name'].widget.set(r"", run=False)
    indexedPolygons_6.inputPortByName['geoms'].widget.set(r"indexedPolygons", run=False)
    apply(indexedPolygons_6.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore IndexedPolygonsNE named indexedPolygons in network masterNet"
    print_exc()
    indexedPolygons_6=None

try:
    ## saving node Viewer ##
    from DejaVu.VisionInterface.DejaVuNodes import Viewer
    Viewer_7 = Viewer(constrkw={}, name='Viewer', library=vizlib)
    masterNet.addNode(Viewer_7,174,434)
    apply(Viewer_7.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    ##
        ## Saving State for Viewer
    Viewer_7.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'rootx': 2033, 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 29.44446169579464, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 400, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -68.846794], 'd2cutH': 255, 'far': 164.28732092573586, 'd1off': 4, 'lookFrom': [0.0, 0.0, 68.846794], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 6.6827440655610353, 'drawThumbnail': False, 'rooty': 99, 'd1scale': 0.012999999999999999}
    apply(Viewer_7.vi.cameras[0].Set, (), state)

    state = {'end': 96.787376921190216, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': False, 'start': 45.675811126887886, 'mode': 'GL_LINEAR'}
    apply(Viewer_7.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    state = {'scale': [1.4353848583409141, 1.4353848583409141, 1.4353848583409141], 'name': 'ClipPlane0', 'color': [1.0, 1.0, 1.0, 1.0], 'enabled': False, 'visible': 0, 'pivot': [0.0, 0.0, 0.0], 'rotation': [-0.62599254, -0.36297792, 0.69020325, 0.0, -0.24739572, -0.74691445, -0.61718243, 0.0, 0.73954636, -0.55710495, 0.37776369, 0.0, 0.0, 0.0, 0.0, 1.0], 'lineWidth': 2, 'translation': [10.765459, 11.429804, 0.0]}
    apply(Viewer_7.vi.clipP[0].Set, (), state)

    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'disableStencil': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [10.136495590209961, 9.8463525772094727, 6.5075764656066895], 'rotation': [0.94336474, 0.32135314, 0.082432941, 0.0, 0.3222217, -0.94665974, 0.0029051371, 0.0, 0.078969523, 0.02382108, -0.99659246, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-10.268987, -9.1431532, -5.8339605], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'none', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 2, 'inheritXform': 0}
    apply(Viewer_7.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if Viewer_7.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if Viewer_7.vi.rootObject:
        Viewer_7.vi.rootObject.clipP = []
        Viewer_7.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

except:
    print "WARNING: failed to restore Viewer named Viewer in network masterNet"
    print_exc()
    Viewer_7=None

try:
    ## saving node Array Ufunc2 ##
    from Vision.StandardNodes import BinaryFuncs
    Array_Ufunc2_8 = BinaryFuncs(constrkw={}, name='Array Ufunc2', library=stdlib)
    masterNet.addNode(Array_Ufunc2_8,385,277)
    apply(Array_Ufunc2_8.inputPortByName['inArrayList1'].configure, (), {'datatype': 'list', 'originalDatatype': 'None'})
    apply(Array_Ufunc2_8.inputPortByName['inArrayList2'].configure, (), {'datatype': 'float', 'originalDatatype': 'None'})
    Array_Ufunc2_8.inputPortByName['operator'].widget.set(r"multiply", run=False)
except:
    print "WARNING: failed to restore BinaryFuncs named Array Ufunc2 in network masterNet"
    print_exc()
    Array_Ufunc2_8=None

try:
    ## saving node Dial ##
    from Vision.StandardNodes import DialNE
    Dial_9 = DialNE(constrkw={}, name='Dial', library=stdlib)
    masterNet.addNode(Dial_9,618,147)
    Dial_9.inputPortByName['dial'].widget.set(0.66, run=False)
except:
    print "WARNING: failed to restore DialNE named Dial in network masterNet"
    print_exc()
    Dial_9=None

try:
    ## saving node Extract Atom Property ##
    from MolKit.VisionInterface.MolKitNodes import AtomsProperty
    Extract_Atom_Property_10 = AtomsProperty(constrkw={}, name='Extract Atom Property', library=molkitlib)
    masterNet.addNode(Extract_Atom_Property_10,672,275)
    Extract_Atom_Property_10.inputPortByName['propertyName'].widget.set(r"coords[0]", run=False)
except:
    print "WARNING: failed to restore AtomsProperty named Extract Atom Property in network masterNet"
    print_exc()
    Extract_Atom_Property_10=None

try:
    ## saving node Grab Image ##
    from Vision.PILNodes import GetFrontBuffer
    Grab_Image_11 = GetFrontBuffer(constrkw={}, name='Grab Image', library=imagelib)
    masterNet.addNode(Grab_Image_11,191,514)
    apply(Grab_Image_11.configure, (), {'specialPortsVisible': True})
    apply(Grab_Image_11.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore GetFrontBuffer named Grab Image in network masterNet"
    print_exc()
    Grab_Image_11=None

try:
    ## saving node Scale ##
    from Vision.PILNodes import ResizeImage
    Scale_12 = ResizeImage(constrkw={}, name='Scale', library=imagelib)
    masterNet.addNode(Scale_12,16,575)
    Scale_12.inputPortByName['scale'].widget.set(1.0, run=False)
    Scale_12.inputPortByName['filter'].widget.set(r"NEAREST", run=False)
except:
    print "WARNING: failed to restore ResizeImage named Scale in network masterNet"
    print_exc()
    Scale_12=None

try:
    ## saving node Filter Image ##
    from Vision.PILNodes import ImageFilter
    Filter_Image_13 = ImageFilter(constrkw={}, name='Filter Image', library=imagelib)
    masterNet.addNode(Filter_Image_13,16,633)
    Filter_Image_13.inputPortByName['filter'].widget.set(r"CONTOUR", run=False)
except:
    print "WARNING: failed to restore ImageFilter named Filter Image in network masterNet"
    print_exc()
    Filter_Image_13=None

try:
    ## saving node Show Image ##
    from Vision.PILNodes import ShowImage
    Show_Image_14 = ShowImage(constrkw={}, name='Show Image', library=imagelib)
    masterNet.addNode(Show_Image_14,16,725)
except:
    print "WARNING: failed to restore ShowImage named Show Image in network masterNet"
    print_exc()
    Show_Image_14=None

try:
    ## saving node CPK ##
    from MolKit.VisionInterface.MolKitNodes import AtomsAsCPK
    CPK_15 = AtomsAsCPK(constrkw={}, name='CPK', library=molkitlib)
    masterNet.addNode(CPK_15,283,386)
    CPK_15.inputPortByName['quality'].widget.set(16, run=False)
    CPK_15.inputPortByName['name'].widget.set(r"", run=False)
    CPK_15.inputPortByName['geoms'].widget.set(r"CPK", run=False)
except:
    print "WARNING: failed to restore AtomsAsCPK named CPK in network masterNet"
    print_exc()
    CPK_15=None

try:
    ## saving node Color Map ##
    from DejaVu.VisionInterface.DejaVuNodes import ColorMapNE
    Color_Map_16 = ColorMapNE(constrkw={}, name='Color Map', library=vizlib)
    masterNet.addNode(Color_Map_16,551,395)
    Color_Map_16.inputPortByName['colorMap'].widget.set({'mini': -3.097, 'initialValue': None, 'name': 'cmap', 'ramp': [[1.1920928955078125e-07, 0.0, 1.0, 1.0], [0.0, 0.26666653156280518, 1.0, 1.0], [0.0, 0.5333331823348999, 1.0, 1.0], [0.0, 0.79999983310699463, 1.0, 1.0], [0.0, 1.0, 0.93333333730697632, 1.0], [0.0, 1.0, 0.66666668653488159, 1.0], [0.0, 1.0, 0.40000003576278687, 1.0], [0.0, 1.0, 0.13333338499069214, 1.0], [0.13333326578140259, 1.0, 0.0, 1.0], [0.39999991655349731, 1.0, 0.0, 1.0], [0.66666662693023682, 1.0, 0.0, 1.0], [0.93333327770233154, 1.0, 0.0, 1.0], [1.0, 0.80000007152557373, 0.0, 1.0], [1.0, 0.53333336114883423, 0.0, 1.0], [1.0, 0.26666668057441711, 0.0, 1.0], [1.0, 7.7715611723760958e-16, 0.0, 1.0]], 'labelGridCfg': {'column': 0, 'row': 1}, 'maxi': 24.283999999999999, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 0, 'labelSide': 'top', 'row': 2}, 'labelCfg': {'text': 'colormap'}, 'class': 'NEColorMap'}, run=False)
    Color_Map_16.inputPortByName['filename'].widget.set(r"", run=False)
except:
    print "WARNING: failed to restore ColorMapNE named Color Map in network masterNet"
    print_exc()
    Color_Map_16=None

try:
    ## saving node One Redraw ##
    from DejaVu.VisionInterface.DejaVuNodes import OneRedraw
    One_Redraw_17 = OneRedraw(constrkw={}, name='One Redraw', library=vizlib)
    masterNet.addNode(One_Redraw_17,38,493)
    apply(One_Redraw_17.configure, (), {'specialPortsVisible': True})
    apply(One_Redraw_17.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore OneRedraw named One Redraw in network masterNet"
    print_exc()
    One_Redraw_17=None

#masterNet.run()
masterNet.freeze()

## saving connections for network ViPErPaper-fig1 ##
if Read_Molecule_0 is not None and Assign_Radii_1 is not None:
    try:
        masterNet.connectNodes(
            Read_Molecule_0, Assign_Radii_1, "MolSets", "molecules", blocking=True
            , splitratio=[0.55153155380815211, 0.35430618407125714])
    except:
        print "WARNING: failed to restore connection between Read_Molecule_0 and Assign_Radii_1 in network masterNet"
if Assign_Radii_1 is not None and Select_Nodes_3 is not None:
    try:
        masterNet.connectNodes(
            Assign_Radii_1, Select_Nodes_3, "molecules", "nodes", blocking=True
            , splitratio=[0.21057693749038842, 0.39778128548049685])
    except:
        print "WARNING: failed to restore connection between Assign_Radii_1 and Select_Nodes_3 in network masterNet"
if Select_Nodes_3 is not None and MSMS_2 is not None:
    try:
        masterNet.connectNodes(
            Select_Nodes_3, MSMS_2, "nodes", "atoms", blocking=True
            , splitratio=[0.22996757367904733, 0.73242746382451074])
    except:
        print "WARNING: failed to restore connection between Select_Nodes_3 and MSMS_2 in network masterNet"
if Select_Nodes_3 is not None and Extract_Atom_Property_4 is not None:
    try:
        masterNet.connectNodes(
            Select_Nodes_3, Extract_Atom_Property_4, "nodes", "atoms", blocking=True
            , splitratio=[0.47217299901844501, 0.38324728696492971])
    except:
        print "WARNING: failed to restore connection between Select_Nodes_3 and Extract_Atom_Property_4 in network masterNet"
if Extract_Atom_Property_4 is not None and MSMS_2 is not None:
    try:
        masterNet.connectNodes(
            Extract_Atom_Property_4, MSMS_2, "propertyValues", "radii", blocking=True
            , splitratio=[0.35005963237202575, 0.58197115449893189])
    except:
        print "WARNING: failed to restore connection between Extract_Atom_Property_4 and MSMS_2 in network masterNet"
if MSMS_2 is not None and MSMS_triang__5 is not None:
    try:
        masterNet.connectNodes(
            MSMS_2, MSMS_triang__5, "MSMS", "MSMS", blocking=True
            , splitratio=[0.57955393657954812, 0.4991147112922763])
    except:
        print "WARNING: failed to restore connection between MSMS_2 and MSMS_triang__5 in network masterNet"
if MSMS_triang__5 is not None and indexedPolygons_6 is not None:
    try:
        masterNet.connectNodes(
            MSMS_triang__5, indexedPolygons_6, "vertices", "coords", blocking=True
            , splitratio=[0.22702540081543443, 0.6745027456910937])
    except:
        print "WARNING: failed to restore connection between MSMS_triang__5 and indexedPolygons_6 in network masterNet"
if MSMS_triang__5 is not None and indexedPolygons_6 is not None:
    try:
        masterNet.connectNodes(
            MSMS_triang__5, indexedPolygons_6, "indices", "indices", blocking=True
            , splitratio=[0.67369134855920931, 0.60739077129614638])
    except:
        print "WARNING: failed to restore connection between MSMS_triang__5 and indexedPolygons_6 in network masterNet"
if MSMS_triang__5 is not None and indexedPolygons_6 is not None:
    try:
        masterNet.connectNodes(
            MSMS_triang__5, indexedPolygons_6, "vnormals", "vnormals", blocking=True
            , splitratio=[0.26182619002199548, 0.66052321780926926])
    except:
        print "WARNING: failed to restore connection between MSMS_triang__5 and indexedPolygons_6 in network masterNet"
if indexedPolygons_6 is not None and Viewer_7 is not None:
    try:
        masterNet.connectNodes(
            indexedPolygons_6, Viewer_7, "indexedPolygons", "geometries", blocking=True
            , splitratio=[0.59088838015206857, 0.54141336300554843])
    except:
        print "WARNING: failed to restore connection between indexedPolygons_6 and Viewer_7 in network masterNet"
if Extract_Atom_Property_4 is not None and Array_Ufunc2_8 is not None:
    try:
        masterNet.connectNodes(
            Extract_Atom_Property_4, Array_Ufunc2_8, "propertyValues", "inArrayList1", blocking=True
            , splitratio=[0.20177912356678715, 0.61467549498348695])
    except:
        print "WARNING: failed to restore connection between Extract_Atom_Property_4 and Array_Ufunc2_8 in network masterNet"
if Dial_9 is not None and Array_Ufunc2_8 is not None:
    try:
        masterNet.connectNodes(
            Dial_9, Array_Ufunc2_8, "value", "inArrayList2", blocking=True
            , splitratio=[0.33207037147323981, 0.48735919049344956])
    except:
        print "WARNING: failed to restore connection between Dial_9 and Array_Ufunc2_8 in network masterNet"
if Select_Nodes_3 is not None and Extract_Atom_Property_10 is not None:
    try:
        masterNet.connectNodes(
            Select_Nodes_3, Extract_Atom_Property_10, "nodes", "atoms", blocking=True
            , splitratio=[0.58399625348282602, 0.21688212347160477])
    except:
        print "WARNING: failed to restore connection between Select_Nodes_3 and Extract_Atom_Property_10 in network masterNet"
if Viewer_7 is not None and Grab_Image_11 is not None:
    try:
        masterNet.connectNodes(
            Viewer_7, Grab_Image_11, "dejaVuViewer", "viewer", blocking=True
            , splitratio=[0.6740440149200515, 0.58178684718116114])
    except:
        print "WARNING: failed to restore connection between Viewer_7 and Grab_Image_11 in network masterNet"
if Grab_Image_11 is not None and Scale_12 is not None:
    try:
        masterNet.connectNodes(
            Grab_Image_11, Scale_12, "image", "image", blocking=True
            , splitratio=[0.61508477703960307, 0.56652784331171291])
    except:
        print "WARNING: failed to restore connection between Grab_Image_11 and Scale_12 in network masterNet"
if Scale_12 is not None and Filter_Image_13 is not None:
    try:
        masterNet.connectNodes(
            Scale_12, Filter_Image_13, "scaledImage", "image", blocking=True
            , splitratio=[0.38228548624893344, 0.36176328686209624])
    except:
        print "WARNING: failed to restore connection between Scale_12 and Filter_Image_13 in network masterNet"
if Filter_Image_13 is not None and Show_Image_14 is not None:
    try:
        masterNet.connectNodes(
            Filter_Image_13, Show_Image_14, "image", "image", blocking=True
            , splitratio=[0.32804270722478479, 0.24570744893553653])
    except:
        print "WARNING: failed to restore connection between Filter_Image_13 and Show_Image_14 in network masterNet"
if Color_Map_16 is not None and CPK_15 is not None:
    try:
        masterNet.connectNodes(
            Color_Map_16, CPK_15, "mappedColors", "colors", blocking=True
            , splitratio=[0.3674950169971411, 0.60251899565644451])
    except:
        print "WARNING: failed to restore connection between Color_Map_16 and CPK_15 in network masterNet"
if Extract_Atom_Property_10 is not None and Color_Map_16 is not None:
    try:
        masterNet.connectNodes(
            Extract_Atom_Property_10, Color_Map_16, "propertyValues", "values", blocking=True
            , splitratio=[0.64131080376605154, 0.71768128090873229])
    except:
        print "WARNING: failed to restore connection between Extract_Atom_Property_10 and Color_Map_16 in network masterNet"
if Array_Ufunc2_8 is not None and CPK_15 is not None:
    try:
        masterNet.connectNodes(
            Array_Ufunc2_8, CPK_15, "outArrayList", "radii", blocking=True
            , splitratio=[0.72973482138426471, 0.3806262584695152])
    except:
        print "WARNING: failed to restore connection between Array_Ufunc2_8 and CPK_15 in network masterNet"
if Select_Nodes_3 is not None and CPK_15 is not None:
    try:
        masterNet.connectNodes(
            Select_Nodes_3, CPK_15, "nodes", "atoms", blocking=True
            , splitratio=[0.63154449222088327, 0.39759695830474839])
    except:
        print "WARNING: failed to restore connection between Select_Nodes_3 and CPK_15 in network masterNet"
if CPK_15 is not None and Viewer_7 is not None:
    try:
        masterNet.connectNodes(
            CPK_15, Viewer_7, "CPK", "geometries", blocking=True
            , splitratio=[0.44901518162824439, 0.53403756810829128])
    except:
        print "WARNING: failed to restore connection between CPK_15 and Viewer_7 in network masterNet"
if Viewer_7 is not None and One_Redraw_17 is not None:
    try:
        masterNet.connectNodes(
            Viewer_7, One_Redraw_17, "dejaVuViewer", "viewer", blocking=True
            , splitratio=[0.7455557656412144, 0.5812137502434469])
    except:
        print "WARNING: failed to restore connection between Viewer_7 and One_Redraw_17 in network masterNet"
if Viewer_7 is not None and One_Redraw_17 is not None:
    try:
        masterNet.connectNodes(
            Viewer_7, One_Redraw_17, "redraw", "trigger", blocking=True
            , splitratio=[0.52076137955956092, 0.74094626565087474])
    except:
        print "WARNING: failed to restore connection between Viewer_7 and One_Redraw_17 in network masterNet"
if One_Redraw_17 is not None and Grab_Image_11 is not None:
    try:
        masterNet.specialConnectNodes(
            One_Redraw_17, Grab_Image_11, "trigger", "runNode", blocking=True
            , splitratio=[0.61129986872975728, 0.63093264064675258])
    except:
        print "WARNING: failed to restore connection between One_Redraw_17 and Grab_Image_11 in network masterNet"
masterNet.runOnNewData.value = False


def loadSavedStates_Viewer_7(self=Viewer_7, event=None):
    ##
    ## Saving State for objects in Viewer
    ##

    ## Object root|indexedPolygons
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'disableStencil': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': True, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': True, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': 0, 'sharpColorBoundaries': True, 'culling': 'none', 'name': 'indexedPolygons', 'backPolyMode': 'fill', 'inheritFrontPolyMode': True, 'inheritStipplePolygons': True, 'inheritBackPolyMode': True, 'scissor': 0, 'protected': False, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|indexedPolygons')
    if obj:
        apply(obj.Set, (), state)

    ## Material for indexedPolygons
    if obj:
        from opengltk.OpenGL import GL
        state = {'opacity': [0.6538461446762085], 'binding': [10.0, 10.0, 10.0, 10.0, 10.0, 10.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'shininess': [50.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]], 'diffuse': [[0.033794164657592773, 0.68117016553878784, 1.0, 0.6538461446762085]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        from opengltk.OpenGL import GL
        state = {'opacity': [1.0], 'binding': [10.0, 10.0, 10.0, 10.0, 10.0, 10.0], 'shininess': [50.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]], 'diffuse': [[0.11225049942731857, 0.4822641909122467, 1.0, 1.0]]}
        apply(obj.materials[GL.GL_BACK].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for indexedPolygons

    ## Clipping Planes for indexedPolygons
    if obj:
        obj.clipP = []
        obj.clipPI = []
        clip = obj.viewer.clipP[0]
        obj.AddClipPlane(clip, obj.clipSide[clip.num], False)
        pass  ## needed in case there no modif
    ## End Clipping Planes for indexedPolygons

    ## Object root|CPK
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'disableStencil': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'quality': 5, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': True, 'inheritShading': True, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'CPK', 'backPolyMode': 'fill', 'inheritFrontPolyMode': True, 'inheritStipplePolygons': True, 'inheritBackPolyMode': True, 'scissor': 0, 'protected': False, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|CPK')
    if obj:
        apply(obj.Set, (), state)

    ## Material for CPK
    if obj:
        from opengltk.OpenGL import GL
        state = {'shininess': [50.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'binding': [10.0, 11.0, 10.0, 10.0, 10.0, 11.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for CPK

    ## Clipping Planes for CPK
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for CPK

    ## End Object root|CPK

    ##
        ## Saving State for Viewer
    self.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 29.44446169579464, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 400, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -68.846794], 'd2cutH': 255, 'far': 164.28732092573586, 'd1off': 4, 'lookFrom': [0.0, 0.0, 68.846794], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 6.6827440655610353, 'drawThumbnail': False, 'd1scale': 0.012999999999999999}
    apply(self.vi.cameras[0].Set, (), state)

    state = {'end': 96.787376921190216, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': False, 'start': 45.675811126887886, 'mode': 'GL_LINEAR'}
    apply(self.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    state = {'scale': [1.4353848583409141, 1.4353848583409141, 1.4353848583409141], 'name': 'ClipPlane0', 'color': [1.0, 1.0, 1.0, 1.0], 'enabled': False, 'visible': 0, 'pivot': [0.0, 0.0, 0.0], 'rotation': [-0.62599254, -0.36297792, 0.69020325, 0.0, -0.24739572, -0.74691445, -0.61718243, 0.0, 0.73954636, -0.55710495, 0.37776369, 0.0, 0.0, 0.0, 0.0, 1.0], 'lineWidth': 2, 'translation': [10.765459, 11.429804, 0.0]}
    apply(self.vi.clipP[0].Set, (), state)

    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'disableStencil': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [10.136495590209961, 9.8463525772094727, 6.5075764656066895], 'rotation': [0.94336474, 0.32135314, 0.082432941, 0.0, 0.3222217, -0.94665974, 0.0029051371, 0.0, 0.078969523, 0.02382108, -0.99659246, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-10.268987, -9.1431532, -5.8339605], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'none', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 2, 'inheritXform': 0}
    apply(self.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if self.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if self.vi.rootObject:
        self.vi.rootObject.clipP = []
        self.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

Viewer_7.restoreStates_cb = Viewer_7.restoreStatesFirstRun = loadSavedStates_Viewer_7
Viewer_7.menu.add_separator()
Viewer_7.menu.add_command(label='Restore states', command=Viewer_7.restoreStates_cb)

if __name__=='__main__':
    from sys import argv
    lNodePortValues = []
    if (len(argv) > 0) and argv[1].startswith('-'):
        lArgIndex = 2
    else:
        lArgIndex = 1
    while lArgIndex < len(argv) and argv[lArgIndex][-3:]!='.py':
        lNodePortValues.append(argv[lArgIndex])
        lArgIndex += 1
    masterNet.setNodePortValues(lNodePortValues)
    if '--help' in argv or '-h' in argv: # show help
        masterNet.helpForNetworkAsApplication()
    elif '-w' in argv: # run without Vision and exit
         # create communicator
        from NetworkEditor.net import Communicator
        masterNet.communicator = Communicator(masterNet)
        print 'Communicator listening on port:', masterNet.communicator.port

        import socket
        f = open(argv[0]+'.sock', 'w')
        f.write("%s %i"%(socket.gethostbyname(socket.gethostname()),
                         masterNet.communicator.port))
        f.close()

        # create communication socket
        import socket
        HOST = ''                 # Symbolic name meaning the local host
        PORT = 50010              # Arbitrary non-privileged port
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.bind((HOST, PORT))
        s.listen(5)
        s.setblocking(0)
        masterNet.socket = s
        masterNet.socketConnections = []
        masterNet.HOST = HOST
        masterNet.PORT = PORT

        masterNet.run()

    else: # stand alone application while vision is hidden
        if '-e' in argv: # run and exit
            masterNet.run()
        elif '-r' in argv or len(masterNet.userPanels) == 0: # no user panel => run
            masterNet.run()
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
        else: # user panel
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

