#ifndef __GNTTAB_H__
#define __GNTTAB_H__

#include <xen/grant_table.h>

void init_gnttab(void);
grant_ref_t gnttab_alloc_and_grant(void **map);
grant_ref_t gnttab_grant_access(domid_t domid, unsigned long frame,
				int readonly);
grant_ref_t gnttab_grant_transfer(domid_t domid, unsigned long pfn);
unsigned long gnttab_end_transfer(grant_ref_t gref);
int gnttab_end_access(grant_ref_t ref);
const char *gnttabop_error(int16_t status);
void fini_gnttab(void);
grant_entry_t *arch_init_gnttab(int nr_grant_frames);

#endif /* !__GNTTAB_H__ */
