#!/bin/bash

install() {
	inst_dir "/lib/firmware"
	for f in /lib/firmware/qcom/sc8280xp/LENOVO/21BX/* \
	    /lib/firmware/qcom/a6* ; do
		inst "${f}"
	done
}

# called by dracut
installkernel() {
	# Core
	hostonly='' instmods \
	    qnoc-sc8280xp \
	    qcom_hwspinlock \
	    uio_pdrv_genirq

	# NVME
	hostonly='' instmods \
	    phy_qcom_qmp_pcie \
	    pcie_qcom \
	    nvme

	# Keyboard
	hostonly='' instmods \
	    i2c_qcom_geni \
	    i2c_hid_of \
	    hid_generic

	# Display
	hostonly='' instmods \
	    pwm_bl \
	    qrtr \
	    phy_qcom_edp \
	    i2c_qcom_geni \
	    gpio_sbu_mux \
	    pmic_glink_altmode \
	    spmi_pmic_arb \
	    phy_qcom_qmp_combo \
	    qcom_spmi_pmic \
	    pinctrl_spmi_gpio \
	    leds_qcom_lpg \
	    panel_edp \
	    msm

	# USB (required for installation from USB)
	hostonly='' instmods \
	    qcom_q6v5_pas \
	    usb_storage \
	    uas
}
