# Summary

[Getting Started](./getting-started.md)
[About this guide](./about-this-guide.md)

---

# Building and debugging `rustc`

- [How to build and run the compiler](./building/how-to-build-and-run.md)
    - [Quickstart](./building/quickstart.md)
    - [Prerequisites](./building/prerequisites.md)
    - [Suggested Workflows](./building/suggested.md)
    - [Distribution artifacts](./building/build-install-distribution-artifacts.md)
    - [Building Documentation](./building/compiler-documenting.md)
    - [Rustdoc overview](./rustdoc.md)
    - [Adding a new target](./building/new-target.md)
    - [Optimized build](./building/optimized-build.md)
- [Testing the compiler](./tests/intro.md)
    - [Running tests](./tests/running.md)
        - [Testing with Docker](./tests/docker.md)
        - [Testing with CI](./tests/ci.md)
    - [Adding new tests](./tests/adding.md)
    - [Best practices](./tests/best-practices.md)
    - [Compiletest](./tests/compiletest.md)
        - [UI tests](./tests/ui.md)
        - [Test directives](./tests/directives.md)
        - [Minicore](./tests/minicore.md)
    - [Ecosystem testing](./tests/ecosystem.md)
        - [Crater](./tests/crater.md)
        - [Fuchsia](./tests/fuchsia.md)
        - [Rust for Linux](./tests/rust-for-linux.md)
    - [Performance testing](./tests/perf.md)
    - [Suggest tests tool](./tests/suggest-tests.md)
    - [Misc info](./tests/misc.md)
- [Debugging the compiler](./compiler-debugging.md)
    - [Using the tracing/logging instrumentation](./tracing.md)
- [Profiling the compiler](./profiling.md)
    - [with the linux perf tool](./profiling/with_perf.md)
    - [with Windows Performance Analyzer](./profiling/wpa_profiling.md)
    - [with the Rust benchmark suite](./profiling/with_rustc_perf.md)
- [crates.io Dependencies](./crates-io.md)

# Contributing to Rust

- [Contribution Procedures](./contributing.md)
- [About the compiler team](./compiler-team.md)
- [Using Git](./git.md)
- [Mastering @rustbot](./rustbot.md)
- [Walkthrough: a typical contribution](./walkthrough.md)
- [Implementing new language features](./implementing_new_features.md)
- [Stability attributes](./stability.md)
- [Stabilizing Features](./stabilization_guide.md)
- [Feature Gates](./feature-gates.md)
- [Coding conventions](./conventions.md)
- [Procedures for Breaking Changes](./bug-fix-procedure.md)
- [Using external repositories](./external-repos.md)
- [Fuzzing](./fuzzing.md)
- [Notification groups](notification-groups/about.md)
    - [Apple](notification-groups/apple.md)
    - [ARM](notification-groups/arm.md)
    - [Cleanup Crew](notification-groups/cleanup-crew.md)
    - [Emscripten](notification-groups/emscripten.md)
    - [LLVM](notification-groups/llvm.md)
    - [RISC-V](notification-groups/risc-v.md)
    - [WASI](notification-groups/wasi.md)
    - [WebAssembly](notification-groups/wasm.md)
    - [Windows](notification-groups/windows.md)
    - [Rust for Linux](notification-groups/rust-for-linux.md)
- [Licenses](./licenses.md)
- [Editions](guides/editions.md)

# Bootstrapping

- [Prologue](./building/bootstrapping/intro.md)
- [What Bootstrapping does](./building/bootstrapping/what-bootstrapping-does.md)
- [How Bootstrap does it](./building/bootstrapping/how-bootstrap-does-it.md)

# High-level Compiler Architecture

- [Prologue](./part-2-intro.md)
- [Overview of the compiler](./overview.md)
- [The compiler source code](./compiler-src.md)
- [Queries: demand-driven compilation](./query.md)
    - [The Query Evaluation Model in Detail](./queries/query-evaluation-model-in-detail.md)
    - [Incremental compilation](./queries/incremental-compilation.md)
    - [Incremental compilation In Detail](./queries/incremental-compilation-in-detail.md)
    - [Debugging and Testing](./incrcomp-debugging.md)
    - [Salsa](./queries/salsa.md)
- [Memory Management in Rustc](./memory.md)
- [Serialization in Rustc](./serialization.md)
- [Parallel Compilation](./parallel-rustc.md)
- [Rustdoc internals](./rustdoc-internals.md)
    - [Search](./rustdoc-internals/search.md)

# Source Code Representation

- [Prologue](./part-3-intro.md)
- [Command-line arguments](./cli.md)
- [rustc_driver and rustc_interface](./rustc-driver/intro.md)
    - [Example: Type checking](./rustc-driver/interacting-with-the-ast.md)
    - [Example: Getting diagnostics](./rustc-driver/getting-diagnostics.md)
- [Syntax and the AST](./syntax-intro.md)
    - [Lexing and Parsing](./the-parser.md)
    - [Macro expansion](./macro-expansion.md)
    - [Name resolution](./name-resolution.md)
    - [Attributes](./attributes.md)
    - [`#[test]` Implementation](./test-implementation.md)
    - [Panic Implementation](./panic-implementation.md)
    - [AST Validation](./ast-validation.md)
    - [Feature Gate Checking](./feature-gate-ck.md)
    - [Lang Items](./lang-items.md)
- [The HIR (High-level IR)](./hir.md)
    - [Lowering AST to HIR](./ast-lowering.md)
    - [Debugging](./hir-debugging.md)
- [The THIR (Typed High-level IR)](./thir.md)
- [The MIR (Mid-level IR)](./mir/index.md)
    - [MIR construction](./mir/construction.md)
    - [MIR visitor and traversal](./mir/visitor.md)
    - [MIR queries and passes: getting the MIR](./mir/passes.md)
- [Identifiers in the Compiler](./identifiers.md)
- [Closure expansion](./closure.md)
- [Inline assembly](./asm.md)

# Analysis

- [Prologue](./part-4-intro.md)
- [Generic parameter definitions](./generic_parameters_summary.md)
    - [What is `ty::Generics`](./what_is_ty_generics.md)
    - [Early vs Late bound parameters](./early-late-bound-params/early-late-bound-summary.md)
        - [Implementation nuances of early/late bound parameters](./early-late-bound-params/early-late-bound-implementation-nuances.md)
        - [Interactions with turbofishing](./early-late-bound-params/turbofishing-and-early-late-bound.md)
- [The `ty` module: representing types](./ty.md)
    - [ADTs and Generic Arguments](./ty_module/generic_arguments.md)
    - [Parameter types/consts/regions](./ty_module/param_ty_const_regions.md)
    - [`EarlyBinder` and instantiating parameters](./ty_module/early_binder.md)
    - [`Binder` and Higher ranked regions](./ty_module/binders.md)
    - [Instantiating binders](./ty_module/instantiating_binders.md)
    - [Constants in the type system](./constants.md)
- [`TypeFolder` and `TypeFoldable`](./ty-fold.md)
- [Parameter Environments](./param_env/param_env_summary.md)
    - [What is it?](./param_env/param_env_what_is_it.md)
    - [How are `ParamEnv`'s constructed internally](./param_env/param_env_construction_internals.md)
    - [Which `ParamEnv` do I use?](./param_env/param_env_acquisition.md)
- [Type inference](./type-inference.md)
- [Trait solving](./traits/resolution.md)
    - [Higher-ranked trait bounds](./traits/hrtb.md)
    - [Caching subtleties](./traits/caching.md)
    - [Implied bounds](./traits/implied-bounds.md)
    - [Specialization](./traits/specialization.md)
    - [Chalk-based trait solving](./traits/chalk.md)
        - [Lowering to logic](./traits/lowering-to-logic.md)
        - [Goals and clauses](./traits/goals-and-clauses.md)
        - [Canonical queries](./traits/canonical-queries.md)
        - [Canonicalization](./traits/canonicalization.md)
    - [Next-gen trait solving](./solve/trait-solving.md)
        - [Invariants of the type system](./solve/invariants.md)
        - [The solver](./solve/the-solver.md)
        - [Canonicalization](./solve/canonicalization.md)
        - [Coinduction](./solve/coinduction.md)
        - [Caching](./solve/caching.md)
        - [Proof trees](./solve/proof-trees.md)
        - [Normalization](./solve/normalization.md)
        - [Opaque types](./solve/opaque-types.md)
        - [Significant changes and quirks](./solve/significant-changes.md)
    - [`Unsize` and `CoerceUnsized` traits](./traits/unsize.md)
- [Type checking](./type-checking.md)
    - [Method Lookup](./method-lookup.md)
    - [Variance](./variance.md)
    - [Coherence Checking](./coherence.md)
    - [Opaque Types](./opaque-types-type-alias-impl-trait.md)
        - [Inference details](./opaque-types-impl-trait-inference.md)
        - [Return Position Impl Trait In Trait](./return-position-impl-trait-in-trait.md)
        - [Region inference restrictions][opaque-infer]
- [Effect checking](./effects.md)
- [Pattern and Exhaustiveness Checking](./pat-exhaustive-checking.md)
- [Unsafety Checking](./unsafety-checking.md)
- [MIR dataflow](./mir/dataflow.md)
- [Drop elaboration](./mir/drop-elaboration.md)
- [The borrow checker](./borrow_check.md)
    - [Tracking moves and initialization](./borrow_check/moves_and_initialization.md)
        - [Move paths](./borrow_check/moves_and_initialization/move_paths.md)
    - [MIR type checker](./borrow_check/type_check.md)
    - [Drop check](./borrow_check/drop_check.md)
    - [Region inference](./borrow_check/region_inference.md)
        - [Constraint propagation](./borrow_check/region_inference/constraint_propagation.md)
        - [Lifetime parameters](./borrow_check/region_inference/lifetime_parameters.md)
        - [Member constraints](./borrow_check/region_inference/member_constraints.md)
        - [Placeholders and universes][pau]
        - [Closure constraints](./borrow_check/region_inference/closure_constraints.md)
        - [Error reporting](./borrow_check/region_inference/error_reporting.md)
    - [Two-phase-borrows](./borrow_check/two_phase_borrows.md)
- [Errors and Lints](diagnostics.md)
    - [Diagnostic and subdiagnostic structs](./diagnostics/diagnostic-structs.md)
    - [Translation](./diagnostics/translation.md)
    - [`LintStore`](./diagnostics/lintstore.md)
    - [Error codes](./diagnostics/error-codes.md)
    - [Diagnostic items](./diagnostics/diagnostic-items.md)
    - [`ErrorGuaranteed`](./diagnostics/error-guaranteed.md)
- [Async closures/"coroutine-closures"](coroutine-closures.md)

# MIR to Binaries

- [Prologue](./part-5-intro.md)
- [MIR optimizations](./mir/optimizations.md)
- [Debugging MIR](./mir/debugging.md)
- [Constant evaluation](./const-eval.md)
    - [Interpreter](./const-eval/interpret.md)
- [Monomorphization](./backend/monomorph.md)
- [Lowering MIR](./backend/lowering-mir.md)
- [Code Generation](./backend/codegen.md)
    - [Updating LLVM](./backend/updating-llvm.md)
    - [Debugging LLVM](./backend/debugging.md)
    - [Backend Agnostic Codegen](./backend/backend-agnostic.md)
    - [Implicit Caller Location](./backend/implicit-caller-location.md)
- [Libraries and Metadata](./backend/libs-and-metadata.md)
- [Profile-guided Optimization](./profile-guided-optimization.md)
- [LLVM Source-Based Code Coverage](./llvm-coverage-instrumentation.md)
- [Sanitizers Support](./sanitizers.md)
- [Debugging support in the Rust compiler](./debugging-support-in-rustc.md)

---

[Appendix A: Background topics](./appendix/background.md)
[Appendix B: Glossary](./appendix/glossary.md)
[Appendix C: Code Index](./appendix/code-index.md)
[Appendix D: Compiler Lecture Series](./appendix/compiler-lecture.md)
[Appendix E: Bibliography](./appendix/bibliography.md)

[Appendix Z: HumorRust](./appendix/humorust.md)

---

[pau]: ./borrow_check/region_inference/placeholders_and_universes.md
[opaque-infer]: ./borrow_check/opaque-types-region-inference-restrictions.md
