/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import org.odftoolkit.odfdom.type.OdfDataType;
import org.odftoolkit.odfdom.type.W3CSchemaType;

public class StyleName
implements OdfDataType {
    private String mStyleName;

    public StyleName(String styleName) throws IllegalArgumentException {
        if (styleName == null) {
            throw new IllegalArgumentException("A StyleName have to be set and can not be 'null'!");
        }
        if (!W3CSchemaType.isValid("NCName", styleName)) {
            throw new IllegalArgumentException("The given StyleName " + styleName + " is invalid!");
        }
        this.mStyleName = styleName;
    }

    public String toString() {
        return this.mStyleName;
    }

    public static StyleName valueOf(String styleName) throws IllegalArgumentException {
        return new StyleName(styleName);
    }

    public static boolean isValid(String styleName) {
        if (styleName == null) {
            return false;
        }
        return W3CSchemaType.isValid("NCName", styleName);
    }
}

