; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV32I %s
; RUN: llc -mtriple=riscv32 -mattr=+a -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV32IA %s
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64I %s
; RUN: llc -mtriple=riscv64 -mattr=+a -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64IA %s

define i8 @atomicrmw_xchg_i8_monotonic(i8* %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i8_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a2, zero
; RV32I-NEXT:    call __atomic_exchange_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i8_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB0_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a4, (a2)
; RV32IA-NEXT:    mv a5, a1
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB0_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i8_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_exchange_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_i8_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB0_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a4, (a2)
; RV64IA-NEXT:    mv a5, a1
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB0_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg i8* %a, i8 %b monotonic
  ret i8 %1
}

define i8 @atomicrmw_xchg_i8_acquire(i8* %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i8_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 2
; RV32I-NEXT:    call __atomic_exchange_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i8_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB1_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a4, (a2)
; RV32IA-NEXT:    mv a5, a1
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB1_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i8_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_exchange_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_i8_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB1_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a4, (a2)
; RV64IA-NEXT:    mv a5, a1
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB1_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg i8* %a, i8 %b acquire
  ret i8 %1
}

define i8 @atomicrmw_xchg_i8_release(i8* %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i8_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 3
; RV32I-NEXT:    call __atomic_exchange_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i8_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB2_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a4, (a2)
; RV32IA-NEXT:    mv a5, a1
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB2_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i8_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_exchange_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_i8_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB2_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a4, (a2)
; RV64IA-NEXT:    mv a5, a1
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB2_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg i8* %a, i8 %b release
  ret i8 %1
}

define i8 @atomicrmw_xchg_i8_acq_rel(i8* %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i8_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 4
; RV32I-NEXT:    call __atomic_exchange_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i8_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB3_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a4, (a2)
; RV32IA-NEXT:    mv a5, a1
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB3_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i8_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_exchange_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_i8_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB3_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a4, (a2)
; RV64IA-NEXT:    mv a5, a1
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB3_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg i8* %a, i8 %b acq_rel
  ret i8 %1
}

define i8 @atomicrmw_xchg_i8_seq_cst(i8* %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i8_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 5
; RV32I-NEXT:    call __atomic_exchange_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i8_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB4_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a4, (a2)
; RV32IA-NEXT:    mv a5, a1
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w.aqrl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB4_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i8_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_exchange_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_i8_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB4_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a4, (a2)
; RV64IA-NEXT:    mv a5, a1
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w.aqrl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB4_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg i8* %a, i8 %b seq_cst
  ret i8 %1
}

define i8 @atomicrmw_add_i8_monotonic(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i8_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a2, zero
; RV32I-NEXT:    call __atomic_fetch_add_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i8_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB5_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a4, (a2)
; RV32IA-NEXT:    add a5, a4, a1
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB5_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i8_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_fetch_add_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_add_i8_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB5_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a4, (a2)
; RV64IA-NEXT:    add a5, a4, a1
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB5_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw add i8* %a, i8 %b monotonic
  ret i8 %1
}

define i8 @atomicrmw_add_i8_acquire(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i8_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 2
; RV32I-NEXT:    call __atomic_fetch_add_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i8_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB6_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a4, (a2)
; RV32IA-NEXT:    add a5, a4, a1
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB6_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i8_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_fetch_add_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_add_i8_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB6_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a4, (a2)
; RV64IA-NEXT:    add a5, a4, a1
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB6_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw add i8* %a, i8 %b acquire
  ret i8 %1
}

define i8 @atomicrmw_add_i8_release(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i8_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 3
; RV32I-NEXT:    call __atomic_fetch_add_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i8_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB7_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a4, (a2)
; RV32IA-NEXT:    add a5, a4, a1
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB7_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i8_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_fetch_add_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_add_i8_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB7_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a4, (a2)
; RV64IA-NEXT:    add a5, a4, a1
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB7_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw add i8* %a, i8 %b release
  ret i8 %1
}

define i8 @atomicrmw_add_i8_acq_rel(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i8_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 4
; RV32I-NEXT:    call __atomic_fetch_add_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i8_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB8_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a4, (a2)
; RV32IA-NEXT:    add a5, a4, a1
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB8_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i8_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_fetch_add_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_add_i8_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB8_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a4, (a2)
; RV64IA-NEXT:    add a5, a4, a1
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB8_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw add i8* %a, i8 %b acq_rel
  ret i8 %1
}

define i8 @atomicrmw_add_i8_seq_cst(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i8_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 5
; RV32I-NEXT:    call __atomic_fetch_add_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i8_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB9_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a4, (a2)
; RV32IA-NEXT:    add a5, a4, a1
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w.aqrl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB9_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i8_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_fetch_add_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_add_i8_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB9_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a4, (a2)
; RV64IA-NEXT:    add a5, a4, a1
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w.aqrl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB9_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw add i8* %a, i8 %b seq_cst
  ret i8 %1
}

define i8 @atomicrmw_sub_i8_monotonic(i8* %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i8_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a2, zero
; RV32I-NEXT:    call __atomic_fetch_sub_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i8_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB10_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a4, (a2)
; RV32IA-NEXT:    sub a5, a4, a1
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB10_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i8_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_fetch_sub_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_sub_i8_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB10_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a4, (a2)
; RV64IA-NEXT:    sub a5, a4, a1
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB10_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw sub i8* %a, i8 %b monotonic
  ret i8 %1
}

define i8 @atomicrmw_sub_i8_acquire(i8* %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i8_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 2
; RV32I-NEXT:    call __atomic_fetch_sub_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i8_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB11_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a4, (a2)
; RV32IA-NEXT:    sub a5, a4, a1
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB11_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i8_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_fetch_sub_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_sub_i8_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB11_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a4, (a2)
; RV64IA-NEXT:    sub a5, a4, a1
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB11_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw sub i8* %a, i8 %b acquire
  ret i8 %1
}

define i8 @atomicrmw_sub_i8_release(i8* %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i8_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 3
; RV32I-NEXT:    call __atomic_fetch_sub_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i8_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB12_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a4, (a2)
; RV32IA-NEXT:    sub a5, a4, a1
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB12_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i8_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_fetch_sub_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_sub_i8_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB12_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a4, (a2)
; RV64IA-NEXT:    sub a5, a4, a1
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB12_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw sub i8* %a, i8 %b release
  ret i8 %1
}

define i8 @atomicrmw_sub_i8_acq_rel(i8* %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i8_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 4
; RV32I-NEXT:    call __atomic_fetch_sub_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i8_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB13_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a4, (a2)
; RV32IA-NEXT:    sub a5, a4, a1
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB13_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i8_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_fetch_sub_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_sub_i8_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB13_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a4, (a2)
; RV64IA-NEXT:    sub a5, a4, a1
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB13_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw sub i8* %a, i8 %b acq_rel
  ret i8 %1
}

define i8 @atomicrmw_sub_i8_seq_cst(i8* %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i8_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 5
; RV32I-NEXT:    call __atomic_fetch_sub_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i8_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB14_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a4, (a2)
; RV32IA-NEXT:    sub a5, a4, a1
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w.aqrl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB14_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i8_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_fetch_sub_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_sub_i8_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB14_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a4, (a2)
; RV64IA-NEXT:    sub a5, a4, a1
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w.aqrl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB14_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw sub i8* %a, i8 %b seq_cst
  ret i8 %1
}

define i8 @atomicrmw_and_i8_monotonic(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i8_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a2, zero
; RV32I-NEXT:    call __atomic_fetch_and_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i8_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    not a3, a3
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    or a1, a3, a1
; RV32IA-NEXT:    amoand.w a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i8_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_fetch_and_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_and_i8_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    not a3, a3
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    or a1, a3, a1
; RV64IA-NEXT:    amoand.w a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw and i8* %a, i8 %b monotonic
  ret i8 %1
}

define i8 @atomicrmw_and_i8_acquire(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i8_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 2
; RV32I-NEXT:    call __atomic_fetch_and_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i8_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    not a3, a3
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    or a1, a3, a1
; RV32IA-NEXT:    amoand.w.aq a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i8_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_fetch_and_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_and_i8_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    not a3, a3
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    or a1, a3, a1
; RV64IA-NEXT:    amoand.w.aq a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw and i8* %a, i8 %b acquire
  ret i8 %1
}

define i8 @atomicrmw_and_i8_release(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i8_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 3
; RV32I-NEXT:    call __atomic_fetch_and_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i8_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    not a3, a3
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    or a1, a3, a1
; RV32IA-NEXT:    amoand.w.rl a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i8_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_fetch_and_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_and_i8_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    not a3, a3
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    or a1, a3, a1
; RV64IA-NEXT:    amoand.w.rl a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw and i8* %a, i8 %b release
  ret i8 %1
}

define i8 @atomicrmw_and_i8_acq_rel(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i8_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 4
; RV32I-NEXT:    call __atomic_fetch_and_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i8_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    not a3, a3
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    or a1, a3, a1
; RV32IA-NEXT:    amoand.w.aqrl a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i8_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_fetch_and_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_and_i8_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    not a3, a3
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    or a1, a3, a1
; RV64IA-NEXT:    amoand.w.aqrl a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw and i8* %a, i8 %b acq_rel
  ret i8 %1
}

define i8 @atomicrmw_and_i8_seq_cst(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i8_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 5
; RV32I-NEXT:    call __atomic_fetch_and_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i8_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    not a3, a3
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    or a1, a3, a1
; RV32IA-NEXT:    amoand.w.aqrl a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i8_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_fetch_and_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_and_i8_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    not a3, a3
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    or a1, a3, a1
; RV64IA-NEXT:    amoand.w.aqrl a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw and i8* %a, i8 %b seq_cst
  ret i8 %1
}

define i8 @atomicrmw_nand_i8_monotonic(i8* %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i8_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a2, zero
; RV32I-NEXT:    call __atomic_fetch_nand_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i8_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB20_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a4, (a2)
; RV32IA-NEXT:    and a5, a4, a1
; RV32IA-NEXT:    not a5, a5
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB20_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i8_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_fetch_nand_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i8_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB20_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a4, (a2)
; RV64IA-NEXT:    and a5, a4, a1
; RV64IA-NEXT:    not a5, a5
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB20_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand i8* %a, i8 %b monotonic
  ret i8 %1
}

define i8 @atomicrmw_nand_i8_acquire(i8* %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i8_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 2
; RV32I-NEXT:    call __atomic_fetch_nand_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i8_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB21_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a4, (a2)
; RV32IA-NEXT:    and a5, a4, a1
; RV32IA-NEXT:    not a5, a5
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB21_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i8_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_fetch_nand_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i8_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB21_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a4, (a2)
; RV64IA-NEXT:    and a5, a4, a1
; RV64IA-NEXT:    not a5, a5
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB21_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand i8* %a, i8 %b acquire
  ret i8 %1
}

define i8 @atomicrmw_nand_i8_release(i8* %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i8_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 3
; RV32I-NEXT:    call __atomic_fetch_nand_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i8_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB22_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a4, (a2)
; RV32IA-NEXT:    and a5, a4, a1
; RV32IA-NEXT:    not a5, a5
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB22_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i8_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_fetch_nand_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i8_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB22_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a4, (a2)
; RV64IA-NEXT:    and a5, a4, a1
; RV64IA-NEXT:    not a5, a5
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB22_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand i8* %a, i8 %b release
  ret i8 %1
}

define i8 @atomicrmw_nand_i8_acq_rel(i8* %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i8_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 4
; RV32I-NEXT:    call __atomic_fetch_nand_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i8_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB23_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a4, (a2)
; RV32IA-NEXT:    and a5, a4, a1
; RV32IA-NEXT:    not a5, a5
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB23_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i8_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_fetch_nand_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i8_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB23_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a4, (a2)
; RV64IA-NEXT:    and a5, a4, a1
; RV64IA-NEXT:    not a5, a5
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB23_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand i8* %a, i8 %b acq_rel
  ret i8 %1
}

define i8 @atomicrmw_nand_i8_seq_cst(i8* %a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i8_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 5
; RV32I-NEXT:    call __atomic_fetch_nand_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i8_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB24_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a4, (a2)
; RV32IA-NEXT:    and a5, a4, a1
; RV32IA-NEXT:    not a5, a5
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:    sc.w.aqrl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB24_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i8_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_fetch_nand_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i8_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB24_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a4, (a2)
; RV64IA-NEXT:    and a5, a4, a1
; RV64IA-NEXT:    not a5, a5
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:    sc.w.aqrl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB24_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand i8* %a, i8 %b seq_cst
  ret i8 %1
}

define i8 @atomicrmw_or_i8_monotonic(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i8_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a2, zero
; RV32I-NEXT:    call __atomic_fetch_or_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i8_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    amoor.w a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i8_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_fetch_or_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_or_i8_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    amoor.w a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw or i8* %a, i8 %b monotonic
  ret i8 %1
}

define i8 @atomicrmw_or_i8_acquire(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i8_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 2
; RV32I-NEXT:    call __atomic_fetch_or_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i8_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    amoor.w.aq a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i8_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_fetch_or_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_or_i8_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    amoor.w.aq a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw or i8* %a, i8 %b acquire
  ret i8 %1
}

define i8 @atomicrmw_or_i8_release(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i8_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 3
; RV32I-NEXT:    call __atomic_fetch_or_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i8_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    amoor.w.rl a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i8_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_fetch_or_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_or_i8_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    amoor.w.rl a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw or i8* %a, i8 %b release
  ret i8 %1
}

define i8 @atomicrmw_or_i8_acq_rel(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i8_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 4
; RV32I-NEXT:    call __atomic_fetch_or_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i8_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    amoor.w.aqrl a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i8_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_fetch_or_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_or_i8_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    amoor.w.aqrl a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw or i8* %a, i8 %b acq_rel
  ret i8 %1
}

define i8 @atomicrmw_or_i8_seq_cst(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i8_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 5
; RV32I-NEXT:    call __atomic_fetch_or_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i8_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    amoor.w.aqrl a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i8_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_fetch_or_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_or_i8_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    amoor.w.aqrl a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw or i8* %a, i8 %b seq_cst
  ret i8 %1
}

define i8 @atomicrmw_xor_i8_monotonic(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i8_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a2, zero
; RV32I-NEXT:    call __atomic_fetch_xor_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i8_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    amoxor.w a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i8_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_fetch_xor_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xor_i8_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    amoxor.w a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xor i8* %a, i8 %b monotonic
  ret i8 %1
}

define i8 @atomicrmw_xor_i8_acquire(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i8_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 2
; RV32I-NEXT:    call __atomic_fetch_xor_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i8_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    amoxor.w.aq a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i8_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_fetch_xor_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xor_i8_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    amoxor.w.aq a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xor i8* %a, i8 %b acquire
  ret i8 %1
}

define i8 @atomicrmw_xor_i8_release(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i8_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 3
; RV32I-NEXT:    call __atomic_fetch_xor_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i8_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    amoxor.w.rl a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i8_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_fetch_xor_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xor_i8_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    amoxor.w.rl a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xor i8* %a, i8 %b release
  ret i8 %1
}

define i8 @atomicrmw_xor_i8_acq_rel(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i8_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 4
; RV32I-NEXT:    call __atomic_fetch_xor_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i8_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    amoxor.w.aqrl a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i8_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_fetch_xor_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xor_i8_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    amoxor.w.aqrl a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xor i8* %a, i8 %b acq_rel
  ret i8 %1
}

define i8 @atomicrmw_xor_i8_seq_cst(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i8_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 5
; RV32I-NEXT:    call __atomic_fetch_xor_1@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i8_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    amoxor.w.aqrl a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i8_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_fetch_xor_1@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xor_i8_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    amoxor.w.aqrl a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xor i8* %a, i8 %b seq_cst
  ret i8 %1
}

define i8 @atomicrmw_max_i8_monotonic(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i8_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    slli a0, a1, 24
; RV32I-NEXT:    srai s1, a0, 24
; RV32I-NEXT:    j .LBB35_2
; RV32I-NEXT:  .LBB35_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB35_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a3, zero
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    call __atomic_compare_exchange_1@plt
; RV32I-NEXT:    lb a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB35_4
; RV32I-NEXT:  .LBB35_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 24
; RV32I-NEXT:    srai a0, a0, 24
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s1, a0, .LBB35_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB35_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB35_1
; RV32I-NEXT:  .LBB35_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i8_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    addi a4, zero, 255
; RV32IA-NEXT:    sll a7, a4, a0
; RV32IA-NEXT:    slli a1, a1, 24
; RV32IA-NEXT:    srai a1, a1, 24
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    addi a5, zero, 24
; RV32IA-NEXT:    sub a3, a5, a3
; RV32IA-NEXT:  .LBB35_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a5, (a6)
; RV32IA-NEXT:    and a4, a5, a7
; RV32IA-NEXT:    mv a2, a5
; RV32IA-NEXT:    sll a4, a4, a3
; RV32IA-NEXT:    sra a4, a4, a3
; RV32IA-NEXT:    bge a4, a1, .LBB35_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB35_1 Depth=1
; RV32IA-NEXT:    xor a2, a5, a1
; RV32IA-NEXT:    and a2, a2, a7
; RV32IA-NEXT:    xor a2, a5, a2
; RV32IA-NEXT:  .LBB35_3: # in Loop: Header=BB35_1 Depth=1
; RV32IA-NEXT:    sc.w a2, a2, (a6)
; RV32IA-NEXT:    bnez a2, .LBB35_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a5, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i8_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    slli a0, a1, 56
; RV64I-NEXT:    srai s1, a0, 56
; RV64I-NEXT:    j .LBB35_2
; RV64I-NEXT:  .LBB35_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB35_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a3, zero
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_1@plt
; RV64I-NEXT:    lb a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB35_4
; RV64I-NEXT:  .LBB35_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 56
; RV64I-NEXT:    srai a0, a0, 56
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s1, a0, .LBB35_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB35_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB35_1
; RV64I-NEXT:  .LBB35_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_max_i8_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    addi a4, zero, 255
; RV64IA-NEXT:    sllw a7, a4, a0
; RV64IA-NEXT:    slli a1, a1, 56
; RV64IA-NEXT:    srai a1, a1, 56
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    addi a5, zero, 56
; RV64IA-NEXT:    sub a3, a5, a3
; RV64IA-NEXT:  .LBB35_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a5, (a6)
; RV64IA-NEXT:    and a4, a5, a7
; RV64IA-NEXT:    mv a2, a5
; RV64IA-NEXT:    sll a4, a4, a3
; RV64IA-NEXT:    sra a4, a4, a3
; RV64IA-NEXT:    bge a4, a1, .LBB35_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB35_1 Depth=1
; RV64IA-NEXT:    xor a2, a5, a1
; RV64IA-NEXT:    and a2, a2, a7
; RV64IA-NEXT:    xor a2, a5, a2
; RV64IA-NEXT:  .LBB35_3: # in Loop: Header=BB35_1 Depth=1
; RV64IA-NEXT:    sc.w a2, a2, (a6)
; RV64IA-NEXT:    bnez a2, .LBB35_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a5, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw max i8* %a, i8 %b monotonic
  ret i8 %1
}

define i8 @atomicrmw_max_i8_acquire(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i8_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    slli a0, a1, 24
; RV32I-NEXT:    srai s1, a0, 24
; RV32I-NEXT:    j .LBB36_2
; RV32I-NEXT:  .LBB36_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB36_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    addi a3, zero, 2
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_1@plt
; RV32I-NEXT:    lb a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB36_4
; RV32I-NEXT:  .LBB36_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 24
; RV32I-NEXT:    srai a0, a0, 24
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s1, a0, .LBB36_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB36_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB36_1
; RV32I-NEXT:  .LBB36_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i8_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    addi a4, zero, 255
; RV32IA-NEXT:    sll a7, a4, a0
; RV32IA-NEXT:    slli a1, a1, 24
; RV32IA-NEXT:    srai a1, a1, 24
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    addi a5, zero, 24
; RV32IA-NEXT:    sub a3, a5, a3
; RV32IA-NEXT:  .LBB36_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a5, (a6)
; RV32IA-NEXT:    and a4, a5, a7
; RV32IA-NEXT:    mv a2, a5
; RV32IA-NEXT:    sll a4, a4, a3
; RV32IA-NEXT:    sra a4, a4, a3
; RV32IA-NEXT:    bge a4, a1, .LBB36_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB36_1 Depth=1
; RV32IA-NEXT:    xor a2, a5, a1
; RV32IA-NEXT:    and a2, a2, a7
; RV32IA-NEXT:    xor a2, a5, a2
; RV32IA-NEXT:  .LBB36_3: # in Loop: Header=BB36_1 Depth=1
; RV32IA-NEXT:    sc.w a2, a2, (a6)
; RV32IA-NEXT:    bnez a2, .LBB36_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a5, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i8_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    slli a0, a1, 56
; RV64I-NEXT:    srai s1, a0, 56
; RV64I-NEXT:    j .LBB36_2
; RV64I-NEXT:  .LBB36_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB36_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    addi a3, zero, 2
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_1@plt
; RV64I-NEXT:    lb a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB36_4
; RV64I-NEXT:  .LBB36_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 56
; RV64I-NEXT:    srai a0, a0, 56
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s1, a0, .LBB36_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB36_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB36_1
; RV64I-NEXT:  .LBB36_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_max_i8_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    addi a4, zero, 255
; RV64IA-NEXT:    sllw a7, a4, a0
; RV64IA-NEXT:    slli a1, a1, 56
; RV64IA-NEXT:    srai a1, a1, 56
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    addi a5, zero, 56
; RV64IA-NEXT:    sub a3, a5, a3
; RV64IA-NEXT:  .LBB36_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a5, (a6)
; RV64IA-NEXT:    and a4, a5, a7
; RV64IA-NEXT:    mv a2, a5
; RV64IA-NEXT:    sll a4, a4, a3
; RV64IA-NEXT:    sra a4, a4, a3
; RV64IA-NEXT:    bge a4, a1, .LBB36_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB36_1 Depth=1
; RV64IA-NEXT:    xor a2, a5, a1
; RV64IA-NEXT:    and a2, a2, a7
; RV64IA-NEXT:    xor a2, a5, a2
; RV64IA-NEXT:  .LBB36_3: # in Loop: Header=BB36_1 Depth=1
; RV64IA-NEXT:    sc.w a2, a2, (a6)
; RV64IA-NEXT:    bnez a2, .LBB36_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a5, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw max i8* %a, i8 %b acquire
  ret i8 %1
}

define i8 @atomicrmw_max_i8_release(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i8_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    slli a0, a1, 24
; RV32I-NEXT:    srai s1, a0, 24
; RV32I-NEXT:    j .LBB37_2
; RV32I-NEXT:  .LBB37_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB37_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    addi a3, zero, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    call __atomic_compare_exchange_1@plt
; RV32I-NEXT:    lb a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB37_4
; RV32I-NEXT:  .LBB37_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 24
; RV32I-NEXT:    srai a0, a0, 24
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s1, a0, .LBB37_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB37_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB37_1
; RV32I-NEXT:  .LBB37_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i8_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    addi a4, zero, 255
; RV32IA-NEXT:    sll a7, a4, a0
; RV32IA-NEXT:    slli a1, a1, 24
; RV32IA-NEXT:    srai a1, a1, 24
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    addi a5, zero, 24
; RV32IA-NEXT:    sub a3, a5, a3
; RV32IA-NEXT:  .LBB37_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a5, (a6)
; RV32IA-NEXT:    and a4, a5, a7
; RV32IA-NEXT:    mv a2, a5
; RV32IA-NEXT:    sll a4, a4, a3
; RV32IA-NEXT:    sra a4, a4, a3
; RV32IA-NEXT:    bge a4, a1, .LBB37_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB37_1 Depth=1
; RV32IA-NEXT:    xor a2, a5, a1
; RV32IA-NEXT:    and a2, a2, a7
; RV32IA-NEXT:    xor a2, a5, a2
; RV32IA-NEXT:  .LBB37_3: # in Loop: Header=BB37_1 Depth=1
; RV32IA-NEXT:    sc.w.rl a2, a2, (a6)
; RV32IA-NEXT:    bnez a2, .LBB37_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a5, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i8_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    slli a0, a1, 56
; RV64I-NEXT:    srai s1, a0, 56
; RV64I-NEXT:    j .LBB37_2
; RV64I-NEXT:  .LBB37_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB37_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    addi a3, zero, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_1@plt
; RV64I-NEXT:    lb a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB37_4
; RV64I-NEXT:  .LBB37_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 56
; RV64I-NEXT:    srai a0, a0, 56
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s1, a0, .LBB37_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB37_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB37_1
; RV64I-NEXT:  .LBB37_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_max_i8_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    addi a4, zero, 255
; RV64IA-NEXT:    sllw a7, a4, a0
; RV64IA-NEXT:    slli a1, a1, 56
; RV64IA-NEXT:    srai a1, a1, 56
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    addi a5, zero, 56
; RV64IA-NEXT:    sub a3, a5, a3
; RV64IA-NEXT:  .LBB37_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a5, (a6)
; RV64IA-NEXT:    and a4, a5, a7
; RV64IA-NEXT:    mv a2, a5
; RV64IA-NEXT:    sll a4, a4, a3
; RV64IA-NEXT:    sra a4, a4, a3
; RV64IA-NEXT:    bge a4, a1, .LBB37_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB37_1 Depth=1
; RV64IA-NEXT:    xor a2, a5, a1
; RV64IA-NEXT:    and a2, a2, a7
; RV64IA-NEXT:    xor a2, a5, a2
; RV64IA-NEXT:  .LBB37_3: # in Loop: Header=BB37_1 Depth=1
; RV64IA-NEXT:    sc.w.rl a2, a2, (a6)
; RV64IA-NEXT:    bnez a2, .LBB37_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a5, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw max i8* %a, i8 %b release
  ret i8 %1
}

define i8 @atomicrmw_max_i8_acq_rel(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i8_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    slli a0, a1, 24
; RV32I-NEXT:    srai s1, a0, 24
; RV32I-NEXT:    j .LBB38_2
; RV32I-NEXT:  .LBB38_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB38_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    addi a3, zero, 4
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_1@plt
; RV32I-NEXT:    lb a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB38_4
; RV32I-NEXT:  .LBB38_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 24
; RV32I-NEXT:    srai a0, a0, 24
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s1, a0, .LBB38_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB38_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB38_1
; RV32I-NEXT:  .LBB38_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i8_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    addi a4, zero, 255
; RV32IA-NEXT:    sll a7, a4, a0
; RV32IA-NEXT:    slli a1, a1, 24
; RV32IA-NEXT:    srai a1, a1, 24
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    addi a5, zero, 24
; RV32IA-NEXT:    sub a3, a5, a3
; RV32IA-NEXT:  .LBB38_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a5, (a6)
; RV32IA-NEXT:    and a4, a5, a7
; RV32IA-NEXT:    mv a2, a5
; RV32IA-NEXT:    sll a4, a4, a3
; RV32IA-NEXT:    sra a4, a4, a3
; RV32IA-NEXT:    bge a4, a1, .LBB38_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB38_1 Depth=1
; RV32IA-NEXT:    xor a2, a5, a1
; RV32IA-NEXT:    and a2, a2, a7
; RV32IA-NEXT:    xor a2, a5, a2
; RV32IA-NEXT:  .LBB38_3: # in Loop: Header=BB38_1 Depth=1
; RV32IA-NEXT:    sc.w.rl a2, a2, (a6)
; RV32IA-NEXT:    bnez a2, .LBB38_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a5, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i8_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    slli a0, a1, 56
; RV64I-NEXT:    srai s1, a0, 56
; RV64I-NEXT:    j .LBB38_2
; RV64I-NEXT:  .LBB38_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB38_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    addi a3, zero, 4
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_1@plt
; RV64I-NEXT:    lb a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB38_4
; RV64I-NEXT:  .LBB38_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 56
; RV64I-NEXT:    srai a0, a0, 56
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s1, a0, .LBB38_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB38_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB38_1
; RV64I-NEXT:  .LBB38_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_max_i8_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    addi a4, zero, 255
; RV64IA-NEXT:    sllw a7, a4, a0
; RV64IA-NEXT:    slli a1, a1, 56
; RV64IA-NEXT:    srai a1, a1, 56
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    addi a5, zero, 56
; RV64IA-NEXT:    sub a3, a5, a3
; RV64IA-NEXT:  .LBB38_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a5, (a6)
; RV64IA-NEXT:    and a4, a5, a7
; RV64IA-NEXT:    mv a2, a5
; RV64IA-NEXT:    sll a4, a4, a3
; RV64IA-NEXT:    sra a4, a4, a3
; RV64IA-NEXT:    bge a4, a1, .LBB38_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB38_1 Depth=1
; RV64IA-NEXT:    xor a2, a5, a1
; RV64IA-NEXT:    and a2, a2, a7
; RV64IA-NEXT:    xor a2, a5, a2
; RV64IA-NEXT:  .LBB38_3: # in Loop: Header=BB38_1 Depth=1
; RV64IA-NEXT:    sc.w.rl a2, a2, (a6)
; RV64IA-NEXT:    bnez a2, .LBB38_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a5, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw max i8* %a, i8 %b acq_rel
  ret i8 %1
}

define i8 @atomicrmw_max_i8_seq_cst(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i8_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    slli a0, a1, 24
; RV32I-NEXT:    srai s1, a0, 24
; RV32I-NEXT:    j .LBB39_2
; RV32I-NEXT:  .LBB39_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB39_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    addi a3, zero, 5
; RV32I-NEXT:    addi a4, zero, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_1@plt
; RV32I-NEXT:    lb a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB39_4
; RV32I-NEXT:  .LBB39_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 24
; RV32I-NEXT:    srai a0, a0, 24
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s1, a0, .LBB39_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB39_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB39_1
; RV32I-NEXT:  .LBB39_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i8_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    addi a4, zero, 255
; RV32IA-NEXT:    sll a7, a4, a0
; RV32IA-NEXT:    slli a1, a1, 24
; RV32IA-NEXT:    srai a1, a1, 24
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    addi a5, zero, 24
; RV32IA-NEXT:    sub a3, a5, a3
; RV32IA-NEXT:  .LBB39_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a5, (a6)
; RV32IA-NEXT:    and a4, a5, a7
; RV32IA-NEXT:    mv a2, a5
; RV32IA-NEXT:    sll a4, a4, a3
; RV32IA-NEXT:    sra a4, a4, a3
; RV32IA-NEXT:    bge a4, a1, .LBB39_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB39_1 Depth=1
; RV32IA-NEXT:    xor a2, a5, a1
; RV32IA-NEXT:    and a2, a2, a7
; RV32IA-NEXT:    xor a2, a5, a2
; RV32IA-NEXT:  .LBB39_3: # in Loop: Header=BB39_1 Depth=1
; RV32IA-NEXT:    sc.w.aqrl a2, a2, (a6)
; RV32IA-NEXT:    bnez a2, .LBB39_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a5, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i8_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    slli a0, a1, 56
; RV64I-NEXT:    srai s1, a0, 56
; RV64I-NEXT:    j .LBB39_2
; RV64I-NEXT:  .LBB39_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB39_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    addi a3, zero, 5
; RV64I-NEXT:    addi a4, zero, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_1@plt
; RV64I-NEXT:    lb a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB39_4
; RV64I-NEXT:  .LBB39_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 56
; RV64I-NEXT:    srai a0, a0, 56
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s1, a0, .LBB39_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB39_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB39_1
; RV64I-NEXT:  .LBB39_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_max_i8_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    addi a4, zero, 255
; RV64IA-NEXT:    sllw a7, a4, a0
; RV64IA-NEXT:    slli a1, a1, 56
; RV64IA-NEXT:    srai a1, a1, 56
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    addi a5, zero, 56
; RV64IA-NEXT:    sub a3, a5, a3
; RV64IA-NEXT:  .LBB39_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a5, (a6)
; RV64IA-NEXT:    and a4, a5, a7
; RV64IA-NEXT:    mv a2, a5
; RV64IA-NEXT:    sll a4, a4, a3
; RV64IA-NEXT:    sra a4, a4, a3
; RV64IA-NEXT:    bge a4, a1, .LBB39_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB39_1 Depth=1
; RV64IA-NEXT:    xor a2, a5, a1
; RV64IA-NEXT:    and a2, a2, a7
; RV64IA-NEXT:    xor a2, a5, a2
; RV64IA-NEXT:  .LBB39_3: # in Loop: Header=BB39_1 Depth=1
; RV64IA-NEXT:    sc.w.aqrl a2, a2, (a6)
; RV64IA-NEXT:    bnez a2, .LBB39_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a5, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw max i8* %a, i8 %b seq_cst
  ret i8 %1
}

define i8 @atomicrmw_min_i8_monotonic(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i8_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    slli a0, a1, 24
; RV32I-NEXT:    srai s1, a0, 24
; RV32I-NEXT:    j .LBB40_2
; RV32I-NEXT:  .LBB40_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB40_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a3, zero
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    call __atomic_compare_exchange_1@plt
; RV32I-NEXT:    lb a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB40_4
; RV32I-NEXT:  .LBB40_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 24
; RV32I-NEXT:    srai a0, a0, 24
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s1, a0, .LBB40_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB40_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB40_1
; RV32I-NEXT:  .LBB40_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i8_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    addi a4, zero, 255
; RV32IA-NEXT:    sll a7, a4, a0
; RV32IA-NEXT:    slli a1, a1, 24
; RV32IA-NEXT:    srai a1, a1, 24
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    addi a5, zero, 24
; RV32IA-NEXT:    sub a3, a5, a3
; RV32IA-NEXT:  .LBB40_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a5, (a6)
; RV32IA-NEXT:    and a4, a5, a7
; RV32IA-NEXT:    mv a2, a5
; RV32IA-NEXT:    sll a4, a4, a3
; RV32IA-NEXT:    sra a4, a4, a3
; RV32IA-NEXT:    bge a1, a4, .LBB40_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB40_1 Depth=1
; RV32IA-NEXT:    xor a2, a5, a1
; RV32IA-NEXT:    and a2, a2, a7
; RV32IA-NEXT:    xor a2, a5, a2
; RV32IA-NEXT:  .LBB40_3: # in Loop: Header=BB40_1 Depth=1
; RV32IA-NEXT:    sc.w a2, a2, (a6)
; RV32IA-NEXT:    bnez a2, .LBB40_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a5, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i8_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    slli a0, a1, 56
; RV64I-NEXT:    srai s1, a0, 56
; RV64I-NEXT:    j .LBB40_2
; RV64I-NEXT:  .LBB40_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB40_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a3, zero
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_1@plt
; RV64I-NEXT:    lb a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB40_4
; RV64I-NEXT:  .LBB40_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 56
; RV64I-NEXT:    srai a0, a0, 56
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s1, a0, .LBB40_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB40_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB40_1
; RV64I-NEXT:  .LBB40_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_min_i8_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    addi a4, zero, 255
; RV64IA-NEXT:    sllw a7, a4, a0
; RV64IA-NEXT:    slli a1, a1, 56
; RV64IA-NEXT:    srai a1, a1, 56
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    addi a5, zero, 56
; RV64IA-NEXT:    sub a3, a5, a3
; RV64IA-NEXT:  .LBB40_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a5, (a6)
; RV64IA-NEXT:    and a4, a5, a7
; RV64IA-NEXT:    mv a2, a5
; RV64IA-NEXT:    sll a4, a4, a3
; RV64IA-NEXT:    sra a4, a4, a3
; RV64IA-NEXT:    bge a1, a4, .LBB40_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB40_1 Depth=1
; RV64IA-NEXT:    xor a2, a5, a1
; RV64IA-NEXT:    and a2, a2, a7
; RV64IA-NEXT:    xor a2, a5, a2
; RV64IA-NEXT:  .LBB40_3: # in Loop: Header=BB40_1 Depth=1
; RV64IA-NEXT:    sc.w a2, a2, (a6)
; RV64IA-NEXT:    bnez a2, .LBB40_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a5, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw min i8* %a, i8 %b monotonic
  ret i8 %1
}

define i8 @atomicrmw_min_i8_acquire(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i8_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    slli a0, a1, 24
; RV32I-NEXT:    srai s1, a0, 24
; RV32I-NEXT:    j .LBB41_2
; RV32I-NEXT:  .LBB41_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB41_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    addi a3, zero, 2
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_1@plt
; RV32I-NEXT:    lb a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB41_4
; RV32I-NEXT:  .LBB41_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 24
; RV32I-NEXT:    srai a0, a0, 24
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s1, a0, .LBB41_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB41_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB41_1
; RV32I-NEXT:  .LBB41_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i8_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    addi a4, zero, 255
; RV32IA-NEXT:    sll a7, a4, a0
; RV32IA-NEXT:    slli a1, a1, 24
; RV32IA-NEXT:    srai a1, a1, 24
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    addi a5, zero, 24
; RV32IA-NEXT:    sub a3, a5, a3
; RV32IA-NEXT:  .LBB41_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a5, (a6)
; RV32IA-NEXT:    and a4, a5, a7
; RV32IA-NEXT:    mv a2, a5
; RV32IA-NEXT:    sll a4, a4, a3
; RV32IA-NEXT:    sra a4, a4, a3
; RV32IA-NEXT:    bge a1, a4, .LBB41_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB41_1 Depth=1
; RV32IA-NEXT:    xor a2, a5, a1
; RV32IA-NEXT:    and a2, a2, a7
; RV32IA-NEXT:    xor a2, a5, a2
; RV32IA-NEXT:  .LBB41_3: # in Loop: Header=BB41_1 Depth=1
; RV32IA-NEXT:    sc.w a2, a2, (a6)
; RV32IA-NEXT:    bnez a2, .LBB41_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a5, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i8_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    slli a0, a1, 56
; RV64I-NEXT:    srai s1, a0, 56
; RV64I-NEXT:    j .LBB41_2
; RV64I-NEXT:  .LBB41_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB41_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    addi a3, zero, 2
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_1@plt
; RV64I-NEXT:    lb a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB41_4
; RV64I-NEXT:  .LBB41_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 56
; RV64I-NEXT:    srai a0, a0, 56
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s1, a0, .LBB41_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB41_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB41_1
; RV64I-NEXT:  .LBB41_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_min_i8_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    addi a4, zero, 255
; RV64IA-NEXT:    sllw a7, a4, a0
; RV64IA-NEXT:    slli a1, a1, 56
; RV64IA-NEXT:    srai a1, a1, 56
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    addi a5, zero, 56
; RV64IA-NEXT:    sub a3, a5, a3
; RV64IA-NEXT:  .LBB41_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a5, (a6)
; RV64IA-NEXT:    and a4, a5, a7
; RV64IA-NEXT:    mv a2, a5
; RV64IA-NEXT:    sll a4, a4, a3
; RV64IA-NEXT:    sra a4, a4, a3
; RV64IA-NEXT:    bge a1, a4, .LBB41_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB41_1 Depth=1
; RV64IA-NEXT:    xor a2, a5, a1
; RV64IA-NEXT:    and a2, a2, a7
; RV64IA-NEXT:    xor a2, a5, a2
; RV64IA-NEXT:  .LBB41_3: # in Loop: Header=BB41_1 Depth=1
; RV64IA-NEXT:    sc.w a2, a2, (a6)
; RV64IA-NEXT:    bnez a2, .LBB41_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a5, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw min i8* %a, i8 %b acquire
  ret i8 %1
}

define i8 @atomicrmw_min_i8_release(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i8_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    slli a0, a1, 24
; RV32I-NEXT:    srai s1, a0, 24
; RV32I-NEXT:    j .LBB42_2
; RV32I-NEXT:  .LBB42_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB42_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    addi a3, zero, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    call __atomic_compare_exchange_1@plt
; RV32I-NEXT:    lb a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB42_4
; RV32I-NEXT:  .LBB42_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 24
; RV32I-NEXT:    srai a0, a0, 24
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s1, a0, .LBB42_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB42_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB42_1
; RV32I-NEXT:  .LBB42_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i8_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    addi a4, zero, 255
; RV32IA-NEXT:    sll a7, a4, a0
; RV32IA-NEXT:    slli a1, a1, 24
; RV32IA-NEXT:    srai a1, a1, 24
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    addi a5, zero, 24
; RV32IA-NEXT:    sub a3, a5, a3
; RV32IA-NEXT:  .LBB42_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a5, (a6)
; RV32IA-NEXT:    and a4, a5, a7
; RV32IA-NEXT:    mv a2, a5
; RV32IA-NEXT:    sll a4, a4, a3
; RV32IA-NEXT:    sra a4, a4, a3
; RV32IA-NEXT:    bge a1, a4, .LBB42_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB42_1 Depth=1
; RV32IA-NEXT:    xor a2, a5, a1
; RV32IA-NEXT:    and a2, a2, a7
; RV32IA-NEXT:    xor a2, a5, a2
; RV32IA-NEXT:  .LBB42_3: # in Loop: Header=BB42_1 Depth=1
; RV32IA-NEXT:    sc.w.rl a2, a2, (a6)
; RV32IA-NEXT:    bnez a2, .LBB42_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a5, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i8_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    slli a0, a1, 56
; RV64I-NEXT:    srai s1, a0, 56
; RV64I-NEXT:    j .LBB42_2
; RV64I-NEXT:  .LBB42_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB42_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    addi a3, zero, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_1@plt
; RV64I-NEXT:    lb a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB42_4
; RV64I-NEXT:  .LBB42_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 56
; RV64I-NEXT:    srai a0, a0, 56
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s1, a0, .LBB42_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB42_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB42_1
; RV64I-NEXT:  .LBB42_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_min_i8_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    addi a4, zero, 255
; RV64IA-NEXT:    sllw a7, a4, a0
; RV64IA-NEXT:    slli a1, a1, 56
; RV64IA-NEXT:    srai a1, a1, 56
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    addi a5, zero, 56
; RV64IA-NEXT:    sub a3, a5, a3
; RV64IA-NEXT:  .LBB42_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a5, (a6)
; RV64IA-NEXT:    and a4, a5, a7
; RV64IA-NEXT:    mv a2, a5
; RV64IA-NEXT:    sll a4, a4, a3
; RV64IA-NEXT:    sra a4, a4, a3
; RV64IA-NEXT:    bge a1, a4, .LBB42_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB42_1 Depth=1
; RV64IA-NEXT:    xor a2, a5, a1
; RV64IA-NEXT:    and a2, a2, a7
; RV64IA-NEXT:    xor a2, a5, a2
; RV64IA-NEXT:  .LBB42_3: # in Loop: Header=BB42_1 Depth=1
; RV64IA-NEXT:    sc.w.rl a2, a2, (a6)
; RV64IA-NEXT:    bnez a2, .LBB42_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a5, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw min i8* %a, i8 %b release
  ret i8 %1
}

define i8 @atomicrmw_min_i8_acq_rel(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i8_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    slli a0, a1, 24
; RV32I-NEXT:    srai s1, a0, 24
; RV32I-NEXT:    j .LBB43_2
; RV32I-NEXT:  .LBB43_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB43_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    addi a3, zero, 4
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_1@plt
; RV32I-NEXT:    lb a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB43_4
; RV32I-NEXT:  .LBB43_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 24
; RV32I-NEXT:    srai a0, a0, 24
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s1, a0, .LBB43_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB43_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB43_1
; RV32I-NEXT:  .LBB43_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i8_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    addi a4, zero, 255
; RV32IA-NEXT:    sll a7, a4, a0
; RV32IA-NEXT:    slli a1, a1, 24
; RV32IA-NEXT:    srai a1, a1, 24
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    addi a5, zero, 24
; RV32IA-NEXT:    sub a3, a5, a3
; RV32IA-NEXT:  .LBB43_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a5, (a6)
; RV32IA-NEXT:    and a4, a5, a7
; RV32IA-NEXT:    mv a2, a5
; RV32IA-NEXT:    sll a4, a4, a3
; RV32IA-NEXT:    sra a4, a4, a3
; RV32IA-NEXT:    bge a1, a4, .LBB43_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB43_1 Depth=1
; RV32IA-NEXT:    xor a2, a5, a1
; RV32IA-NEXT:    and a2, a2, a7
; RV32IA-NEXT:    xor a2, a5, a2
; RV32IA-NEXT:  .LBB43_3: # in Loop: Header=BB43_1 Depth=1
; RV32IA-NEXT:    sc.w.rl a2, a2, (a6)
; RV32IA-NEXT:    bnez a2, .LBB43_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a5, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i8_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    slli a0, a1, 56
; RV64I-NEXT:    srai s1, a0, 56
; RV64I-NEXT:    j .LBB43_2
; RV64I-NEXT:  .LBB43_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB43_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    addi a3, zero, 4
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_1@plt
; RV64I-NEXT:    lb a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB43_4
; RV64I-NEXT:  .LBB43_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 56
; RV64I-NEXT:    srai a0, a0, 56
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s1, a0, .LBB43_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB43_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB43_1
; RV64I-NEXT:  .LBB43_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_min_i8_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    addi a4, zero, 255
; RV64IA-NEXT:    sllw a7, a4, a0
; RV64IA-NEXT:    slli a1, a1, 56
; RV64IA-NEXT:    srai a1, a1, 56
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    addi a5, zero, 56
; RV64IA-NEXT:    sub a3, a5, a3
; RV64IA-NEXT:  .LBB43_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a5, (a6)
; RV64IA-NEXT:    and a4, a5, a7
; RV64IA-NEXT:    mv a2, a5
; RV64IA-NEXT:    sll a4, a4, a3
; RV64IA-NEXT:    sra a4, a4, a3
; RV64IA-NEXT:    bge a1, a4, .LBB43_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB43_1 Depth=1
; RV64IA-NEXT:    xor a2, a5, a1
; RV64IA-NEXT:    and a2, a2, a7
; RV64IA-NEXT:    xor a2, a5, a2
; RV64IA-NEXT:  .LBB43_3: # in Loop: Header=BB43_1 Depth=1
; RV64IA-NEXT:    sc.w.rl a2, a2, (a6)
; RV64IA-NEXT:    bnez a2, .LBB43_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a5, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw min i8* %a, i8 %b acq_rel
  ret i8 %1
}

define i8 @atomicrmw_min_i8_seq_cst(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i8_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    slli a0, a1, 24
; RV32I-NEXT:    srai s1, a0, 24
; RV32I-NEXT:    j .LBB44_2
; RV32I-NEXT:  .LBB44_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB44_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    addi a3, zero, 5
; RV32I-NEXT:    addi a4, zero, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_1@plt
; RV32I-NEXT:    lb a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB44_4
; RV32I-NEXT:  .LBB44_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 24
; RV32I-NEXT:    srai a0, a0, 24
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s1, a0, .LBB44_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB44_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB44_1
; RV32I-NEXT:  .LBB44_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i8_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    addi a4, zero, 255
; RV32IA-NEXT:    sll a7, a4, a0
; RV32IA-NEXT:    slli a1, a1, 24
; RV32IA-NEXT:    srai a1, a1, 24
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    addi a5, zero, 24
; RV32IA-NEXT:    sub a3, a5, a3
; RV32IA-NEXT:  .LBB44_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a5, (a6)
; RV32IA-NEXT:    and a4, a5, a7
; RV32IA-NEXT:    mv a2, a5
; RV32IA-NEXT:    sll a4, a4, a3
; RV32IA-NEXT:    sra a4, a4, a3
; RV32IA-NEXT:    bge a1, a4, .LBB44_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB44_1 Depth=1
; RV32IA-NEXT:    xor a2, a5, a1
; RV32IA-NEXT:    and a2, a2, a7
; RV32IA-NEXT:    xor a2, a5, a2
; RV32IA-NEXT:  .LBB44_3: # in Loop: Header=BB44_1 Depth=1
; RV32IA-NEXT:    sc.w.aqrl a2, a2, (a6)
; RV32IA-NEXT:    bnez a2, .LBB44_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a5, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i8_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    slli a0, a1, 56
; RV64I-NEXT:    srai s1, a0, 56
; RV64I-NEXT:    j .LBB44_2
; RV64I-NEXT:  .LBB44_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB44_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    addi a3, zero, 5
; RV64I-NEXT:    addi a4, zero, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_1@plt
; RV64I-NEXT:    lb a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB44_4
; RV64I-NEXT:  .LBB44_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 56
; RV64I-NEXT:    srai a0, a0, 56
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s1, a0, .LBB44_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB44_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB44_1
; RV64I-NEXT:  .LBB44_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_min_i8_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    addi a4, zero, 255
; RV64IA-NEXT:    sllw a7, a4, a0
; RV64IA-NEXT:    slli a1, a1, 56
; RV64IA-NEXT:    srai a1, a1, 56
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    addi a5, zero, 56
; RV64IA-NEXT:    sub a3, a5, a3
; RV64IA-NEXT:  .LBB44_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a5, (a6)
; RV64IA-NEXT:    and a4, a5, a7
; RV64IA-NEXT:    mv a2, a5
; RV64IA-NEXT:    sll a4, a4, a3
; RV64IA-NEXT:    sra a4, a4, a3
; RV64IA-NEXT:    bge a1, a4, .LBB44_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB44_1 Depth=1
; RV64IA-NEXT:    xor a2, a5, a1
; RV64IA-NEXT:    and a2, a2, a7
; RV64IA-NEXT:    xor a2, a5, a2
; RV64IA-NEXT:  .LBB44_3: # in Loop: Header=BB44_1 Depth=1
; RV64IA-NEXT:    sc.w.aqrl a2, a2, (a6)
; RV64IA-NEXT:    bnez a2, .LBB44_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a5, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw min i8* %a, i8 %b seq_cst
  ret i8 %1
}

define i8 @atomicrmw_umax_i8_monotonic(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i8_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    andi s1, a1, 255
; RV32I-NEXT:    j .LBB45_2
; RV32I-NEXT:  .LBB45_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB45_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a3, zero
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    call __atomic_compare_exchange_1@plt
; RV32I-NEXT:    lb a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB45_4
; RV32I-NEXT:  .LBB45_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    andi a0, a3, 255
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bltu s1, a0, .LBB45_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB45_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB45_1
; RV32I-NEXT:  .LBB45_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i8_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB45_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a4, (a6)
; RV32IA-NEXT:    and a2, a4, a3
; RV32IA-NEXT:    mv a5, a4
; RV32IA-NEXT:    bgeu a2, a1, .LBB45_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB45_1 Depth=1
; RV32IA-NEXT:    xor a5, a4, a1
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:  .LBB45_3: # in Loop: Header=BB45_1 Depth=1
; RV32IA-NEXT:    sc.w a5, a5, (a6)
; RV32IA-NEXT:    bnez a5, .LBB45_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i8_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    andi s1, a1, 255
; RV64I-NEXT:    j .LBB45_2
; RV64I-NEXT:  .LBB45_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB45_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a3, zero
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_1@plt
; RV64I-NEXT:    lb a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB45_4
; RV64I-NEXT:  .LBB45_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    andi a0, a3, 255
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s1, a0, .LBB45_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB45_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB45_1
; RV64I-NEXT:  .LBB45_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umax_i8_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB45_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a4, (a6)
; RV64IA-NEXT:    and a2, a4, a3
; RV64IA-NEXT:    mv a5, a4
; RV64IA-NEXT:    bgeu a2, a1, .LBB45_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB45_1 Depth=1
; RV64IA-NEXT:    xor a5, a4, a1
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:  .LBB45_3: # in Loop: Header=BB45_1 Depth=1
; RV64IA-NEXT:    sc.w a5, a5, (a6)
; RV64IA-NEXT:    bnez a5, .LBB45_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umax i8* %a, i8 %b monotonic
  ret i8 %1
}

define i8 @atomicrmw_umax_i8_acquire(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i8_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    andi s1, a1, 255
; RV32I-NEXT:    j .LBB46_2
; RV32I-NEXT:  .LBB46_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB46_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    addi a3, zero, 2
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_1@plt
; RV32I-NEXT:    lb a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB46_4
; RV32I-NEXT:  .LBB46_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    andi a0, a3, 255
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bltu s1, a0, .LBB46_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB46_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB46_1
; RV32I-NEXT:  .LBB46_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i8_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB46_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a4, (a6)
; RV32IA-NEXT:    and a2, a4, a3
; RV32IA-NEXT:    mv a5, a4
; RV32IA-NEXT:    bgeu a2, a1, .LBB46_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB46_1 Depth=1
; RV32IA-NEXT:    xor a5, a4, a1
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:  .LBB46_3: # in Loop: Header=BB46_1 Depth=1
; RV32IA-NEXT:    sc.w a5, a5, (a6)
; RV32IA-NEXT:    bnez a5, .LBB46_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i8_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    andi s1, a1, 255
; RV64I-NEXT:    j .LBB46_2
; RV64I-NEXT:  .LBB46_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB46_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    addi a3, zero, 2
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_1@plt
; RV64I-NEXT:    lb a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB46_4
; RV64I-NEXT:  .LBB46_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    andi a0, a3, 255
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s1, a0, .LBB46_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB46_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB46_1
; RV64I-NEXT:  .LBB46_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umax_i8_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB46_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a4, (a6)
; RV64IA-NEXT:    and a2, a4, a3
; RV64IA-NEXT:    mv a5, a4
; RV64IA-NEXT:    bgeu a2, a1, .LBB46_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB46_1 Depth=1
; RV64IA-NEXT:    xor a5, a4, a1
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:  .LBB46_3: # in Loop: Header=BB46_1 Depth=1
; RV64IA-NEXT:    sc.w a5, a5, (a6)
; RV64IA-NEXT:    bnez a5, .LBB46_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umax i8* %a, i8 %b acquire
  ret i8 %1
}

define i8 @atomicrmw_umax_i8_release(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i8_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    andi s1, a1, 255
; RV32I-NEXT:    j .LBB47_2
; RV32I-NEXT:  .LBB47_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB47_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    addi a3, zero, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    call __atomic_compare_exchange_1@plt
; RV32I-NEXT:    lb a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB47_4
; RV32I-NEXT:  .LBB47_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    andi a0, a3, 255
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bltu s1, a0, .LBB47_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB47_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB47_1
; RV32I-NEXT:  .LBB47_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i8_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB47_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a4, (a6)
; RV32IA-NEXT:    and a2, a4, a3
; RV32IA-NEXT:    mv a5, a4
; RV32IA-NEXT:    bgeu a2, a1, .LBB47_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB47_1 Depth=1
; RV32IA-NEXT:    xor a5, a4, a1
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:  .LBB47_3: # in Loop: Header=BB47_1 Depth=1
; RV32IA-NEXT:    sc.w.rl a5, a5, (a6)
; RV32IA-NEXT:    bnez a5, .LBB47_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i8_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    andi s1, a1, 255
; RV64I-NEXT:    j .LBB47_2
; RV64I-NEXT:  .LBB47_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB47_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    addi a3, zero, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_1@plt
; RV64I-NEXT:    lb a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB47_4
; RV64I-NEXT:  .LBB47_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    andi a0, a3, 255
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s1, a0, .LBB47_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB47_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB47_1
; RV64I-NEXT:  .LBB47_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umax_i8_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB47_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a4, (a6)
; RV64IA-NEXT:    and a2, a4, a3
; RV64IA-NEXT:    mv a5, a4
; RV64IA-NEXT:    bgeu a2, a1, .LBB47_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB47_1 Depth=1
; RV64IA-NEXT:    xor a5, a4, a1
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:  .LBB47_3: # in Loop: Header=BB47_1 Depth=1
; RV64IA-NEXT:    sc.w.rl a5, a5, (a6)
; RV64IA-NEXT:    bnez a5, .LBB47_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umax i8* %a, i8 %b release
  ret i8 %1
}

define i8 @atomicrmw_umax_i8_acq_rel(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i8_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    andi s1, a1, 255
; RV32I-NEXT:    j .LBB48_2
; RV32I-NEXT:  .LBB48_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB48_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    addi a3, zero, 4
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_1@plt
; RV32I-NEXT:    lb a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB48_4
; RV32I-NEXT:  .LBB48_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    andi a0, a3, 255
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bltu s1, a0, .LBB48_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB48_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB48_1
; RV32I-NEXT:  .LBB48_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i8_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB48_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a4, (a6)
; RV32IA-NEXT:    and a2, a4, a3
; RV32IA-NEXT:    mv a5, a4
; RV32IA-NEXT:    bgeu a2, a1, .LBB48_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB48_1 Depth=1
; RV32IA-NEXT:    xor a5, a4, a1
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:  .LBB48_3: # in Loop: Header=BB48_1 Depth=1
; RV32IA-NEXT:    sc.w.rl a5, a5, (a6)
; RV32IA-NEXT:    bnez a5, .LBB48_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i8_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    andi s1, a1, 255
; RV64I-NEXT:    j .LBB48_2
; RV64I-NEXT:  .LBB48_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB48_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    addi a3, zero, 4
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_1@plt
; RV64I-NEXT:    lb a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB48_4
; RV64I-NEXT:  .LBB48_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    andi a0, a3, 255
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s1, a0, .LBB48_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB48_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB48_1
; RV64I-NEXT:  .LBB48_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umax_i8_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB48_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a4, (a6)
; RV64IA-NEXT:    and a2, a4, a3
; RV64IA-NEXT:    mv a5, a4
; RV64IA-NEXT:    bgeu a2, a1, .LBB48_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB48_1 Depth=1
; RV64IA-NEXT:    xor a5, a4, a1
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:  .LBB48_3: # in Loop: Header=BB48_1 Depth=1
; RV64IA-NEXT:    sc.w.rl a5, a5, (a6)
; RV64IA-NEXT:    bnez a5, .LBB48_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umax i8* %a, i8 %b acq_rel
  ret i8 %1
}

define i8 @atomicrmw_umax_i8_seq_cst(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i8_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    andi s1, a1, 255
; RV32I-NEXT:    j .LBB49_2
; RV32I-NEXT:  .LBB49_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB49_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    addi a3, zero, 5
; RV32I-NEXT:    addi a4, zero, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_1@plt
; RV32I-NEXT:    lb a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB49_4
; RV32I-NEXT:  .LBB49_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    andi a0, a3, 255
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bltu s1, a0, .LBB49_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB49_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB49_1
; RV32I-NEXT:  .LBB49_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i8_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB49_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a4, (a6)
; RV32IA-NEXT:    and a2, a4, a3
; RV32IA-NEXT:    mv a5, a4
; RV32IA-NEXT:    bgeu a2, a1, .LBB49_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB49_1 Depth=1
; RV32IA-NEXT:    xor a5, a4, a1
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:  .LBB49_3: # in Loop: Header=BB49_1 Depth=1
; RV32IA-NEXT:    sc.w.aqrl a5, a5, (a6)
; RV32IA-NEXT:    bnez a5, .LBB49_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i8_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    andi s1, a1, 255
; RV64I-NEXT:    j .LBB49_2
; RV64I-NEXT:  .LBB49_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB49_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    addi a3, zero, 5
; RV64I-NEXT:    addi a4, zero, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_1@plt
; RV64I-NEXT:    lb a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB49_4
; RV64I-NEXT:  .LBB49_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    andi a0, a3, 255
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s1, a0, .LBB49_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB49_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB49_1
; RV64I-NEXT:  .LBB49_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umax_i8_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB49_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a4, (a6)
; RV64IA-NEXT:    and a2, a4, a3
; RV64IA-NEXT:    mv a5, a4
; RV64IA-NEXT:    bgeu a2, a1, .LBB49_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB49_1 Depth=1
; RV64IA-NEXT:    xor a5, a4, a1
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:  .LBB49_3: # in Loop: Header=BB49_1 Depth=1
; RV64IA-NEXT:    sc.w.aqrl a5, a5, (a6)
; RV64IA-NEXT:    bnez a5, .LBB49_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umax i8* %a, i8 %b seq_cst
  ret i8 %1
}

define i8 @atomicrmw_umin_i8_monotonic(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i8_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    andi s1, a1, 255
; RV32I-NEXT:    j .LBB50_2
; RV32I-NEXT:  .LBB50_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB50_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a3, zero
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    call __atomic_compare_exchange_1@plt
; RV32I-NEXT:    lb a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB50_4
; RV32I-NEXT:  .LBB50_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    andi a0, a3, 255
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bgeu s1, a0, .LBB50_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB50_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB50_1
; RV32I-NEXT:  .LBB50_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i8_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB50_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a4, (a6)
; RV32IA-NEXT:    and a2, a4, a3
; RV32IA-NEXT:    mv a5, a4
; RV32IA-NEXT:    bgeu a1, a2, .LBB50_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB50_1 Depth=1
; RV32IA-NEXT:    xor a5, a4, a1
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:  .LBB50_3: # in Loop: Header=BB50_1 Depth=1
; RV32IA-NEXT:    sc.w a5, a5, (a6)
; RV32IA-NEXT:    bnez a5, .LBB50_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i8_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    andi s1, a1, 255
; RV64I-NEXT:    j .LBB50_2
; RV64I-NEXT:  .LBB50_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB50_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a3, zero
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_1@plt
; RV64I-NEXT:    lb a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB50_4
; RV64I-NEXT:  .LBB50_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    andi a0, a3, 255
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s1, a0, .LBB50_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB50_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB50_1
; RV64I-NEXT:  .LBB50_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umin_i8_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB50_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a4, (a6)
; RV64IA-NEXT:    and a2, a4, a3
; RV64IA-NEXT:    mv a5, a4
; RV64IA-NEXT:    bgeu a1, a2, .LBB50_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB50_1 Depth=1
; RV64IA-NEXT:    xor a5, a4, a1
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:  .LBB50_3: # in Loop: Header=BB50_1 Depth=1
; RV64IA-NEXT:    sc.w a5, a5, (a6)
; RV64IA-NEXT:    bnez a5, .LBB50_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umin i8* %a, i8 %b monotonic
  ret i8 %1
}

define i8 @atomicrmw_umin_i8_acquire(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i8_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    andi s1, a1, 255
; RV32I-NEXT:    j .LBB51_2
; RV32I-NEXT:  .LBB51_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB51_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    addi a3, zero, 2
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_1@plt
; RV32I-NEXT:    lb a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB51_4
; RV32I-NEXT:  .LBB51_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    andi a0, a3, 255
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bgeu s1, a0, .LBB51_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB51_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB51_1
; RV32I-NEXT:  .LBB51_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i8_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB51_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a4, (a6)
; RV32IA-NEXT:    and a2, a4, a3
; RV32IA-NEXT:    mv a5, a4
; RV32IA-NEXT:    bgeu a1, a2, .LBB51_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB51_1 Depth=1
; RV32IA-NEXT:    xor a5, a4, a1
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:  .LBB51_3: # in Loop: Header=BB51_1 Depth=1
; RV32IA-NEXT:    sc.w a5, a5, (a6)
; RV32IA-NEXT:    bnez a5, .LBB51_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i8_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    andi s1, a1, 255
; RV64I-NEXT:    j .LBB51_2
; RV64I-NEXT:  .LBB51_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB51_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    addi a3, zero, 2
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_1@plt
; RV64I-NEXT:    lb a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB51_4
; RV64I-NEXT:  .LBB51_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    andi a0, a3, 255
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s1, a0, .LBB51_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB51_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB51_1
; RV64I-NEXT:  .LBB51_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umin_i8_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB51_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a4, (a6)
; RV64IA-NEXT:    and a2, a4, a3
; RV64IA-NEXT:    mv a5, a4
; RV64IA-NEXT:    bgeu a1, a2, .LBB51_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB51_1 Depth=1
; RV64IA-NEXT:    xor a5, a4, a1
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:  .LBB51_3: # in Loop: Header=BB51_1 Depth=1
; RV64IA-NEXT:    sc.w a5, a5, (a6)
; RV64IA-NEXT:    bnez a5, .LBB51_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umin i8* %a, i8 %b acquire
  ret i8 %1
}

define i8 @atomicrmw_umin_i8_release(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i8_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    andi s1, a1, 255
; RV32I-NEXT:    j .LBB52_2
; RV32I-NEXT:  .LBB52_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB52_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    addi a3, zero, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    call __atomic_compare_exchange_1@plt
; RV32I-NEXT:    lb a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB52_4
; RV32I-NEXT:  .LBB52_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    andi a0, a3, 255
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bgeu s1, a0, .LBB52_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB52_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB52_1
; RV32I-NEXT:  .LBB52_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i8_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB52_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a4, (a6)
; RV32IA-NEXT:    and a2, a4, a3
; RV32IA-NEXT:    mv a5, a4
; RV32IA-NEXT:    bgeu a1, a2, .LBB52_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB52_1 Depth=1
; RV32IA-NEXT:    xor a5, a4, a1
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:  .LBB52_3: # in Loop: Header=BB52_1 Depth=1
; RV32IA-NEXT:    sc.w.rl a5, a5, (a6)
; RV32IA-NEXT:    bnez a5, .LBB52_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i8_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    andi s1, a1, 255
; RV64I-NEXT:    j .LBB52_2
; RV64I-NEXT:  .LBB52_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB52_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    addi a3, zero, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_1@plt
; RV64I-NEXT:    lb a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB52_4
; RV64I-NEXT:  .LBB52_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    andi a0, a3, 255
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s1, a0, .LBB52_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB52_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB52_1
; RV64I-NEXT:  .LBB52_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umin_i8_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB52_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a4, (a6)
; RV64IA-NEXT:    and a2, a4, a3
; RV64IA-NEXT:    mv a5, a4
; RV64IA-NEXT:    bgeu a1, a2, .LBB52_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB52_1 Depth=1
; RV64IA-NEXT:    xor a5, a4, a1
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:  .LBB52_3: # in Loop: Header=BB52_1 Depth=1
; RV64IA-NEXT:    sc.w.rl a5, a5, (a6)
; RV64IA-NEXT:    bnez a5, .LBB52_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umin i8* %a, i8 %b release
  ret i8 %1
}

define i8 @atomicrmw_umin_i8_acq_rel(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i8_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    andi s1, a1, 255
; RV32I-NEXT:    j .LBB53_2
; RV32I-NEXT:  .LBB53_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB53_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    addi a3, zero, 4
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_1@plt
; RV32I-NEXT:    lb a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB53_4
; RV32I-NEXT:  .LBB53_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    andi a0, a3, 255
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bgeu s1, a0, .LBB53_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB53_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB53_1
; RV32I-NEXT:  .LBB53_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i8_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB53_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a4, (a6)
; RV32IA-NEXT:    and a2, a4, a3
; RV32IA-NEXT:    mv a5, a4
; RV32IA-NEXT:    bgeu a1, a2, .LBB53_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB53_1 Depth=1
; RV32IA-NEXT:    xor a5, a4, a1
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:  .LBB53_3: # in Loop: Header=BB53_1 Depth=1
; RV32IA-NEXT:    sc.w.rl a5, a5, (a6)
; RV32IA-NEXT:    bnez a5, .LBB53_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i8_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    andi s1, a1, 255
; RV64I-NEXT:    j .LBB53_2
; RV64I-NEXT:  .LBB53_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB53_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    addi a3, zero, 4
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_1@plt
; RV64I-NEXT:    lb a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB53_4
; RV64I-NEXT:  .LBB53_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    andi a0, a3, 255
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s1, a0, .LBB53_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB53_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB53_1
; RV64I-NEXT:  .LBB53_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umin_i8_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB53_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a4, (a6)
; RV64IA-NEXT:    and a2, a4, a3
; RV64IA-NEXT:    mv a5, a4
; RV64IA-NEXT:    bgeu a1, a2, .LBB53_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB53_1 Depth=1
; RV64IA-NEXT:    xor a5, a4, a1
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:  .LBB53_3: # in Loop: Header=BB53_1 Depth=1
; RV64IA-NEXT:    sc.w.rl a5, a5, (a6)
; RV64IA-NEXT:    bnez a5, .LBB53_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umin i8* %a, i8 %b acq_rel
  ret i8 %1
}

define i8 @atomicrmw_umin_i8_seq_cst(i8 *%a, i8 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i8_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    andi s1, a1, 255
; RV32I-NEXT:    j .LBB54_2
; RV32I-NEXT:  .LBB54_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB54_2 Depth=1
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    addi a1, sp, 15
; RV32I-NEXT:    addi a3, zero, 5
; RV32I-NEXT:    addi a4, zero, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_1@plt
; RV32I-NEXT:    lb a3, 15(sp)
; RV32I-NEXT:    bnez a0, .LBB54_4
; RV32I-NEXT:  .LBB54_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    andi a0, a3, 255
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bgeu s1, a0, .LBB54_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB54_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB54_1
; RV32I-NEXT:  .LBB54_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i8_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    addi a3, zero, 255
; RV32IA-NEXT:    sll a3, a3, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB54_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a4, (a6)
; RV32IA-NEXT:    and a2, a4, a3
; RV32IA-NEXT:    mv a5, a4
; RV32IA-NEXT:    bgeu a1, a2, .LBB54_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB54_1 Depth=1
; RV32IA-NEXT:    xor a5, a4, a1
; RV32IA-NEXT:    and a5, a5, a3
; RV32IA-NEXT:    xor a5, a4, a5
; RV32IA-NEXT:  .LBB54_3: # in Loop: Header=BB54_1 Depth=1
; RV32IA-NEXT:    sc.w.aqrl a5, a5, (a6)
; RV32IA-NEXT:    bnez a5, .LBB54_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a4, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i8_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    andi s1, a1, 255
; RV64I-NEXT:    j .LBB54_2
; RV64I-NEXT:  .LBB54_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB54_2 Depth=1
; RV64I-NEXT:    sb a3, 15(sp)
; RV64I-NEXT:    addi a1, sp, 15
; RV64I-NEXT:    addi a3, zero, 5
; RV64I-NEXT:    addi a4, zero, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_1@plt
; RV64I-NEXT:    lb a3, 15(sp)
; RV64I-NEXT:    bnez a0, .LBB54_4
; RV64I-NEXT:  .LBB54_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    andi a0, a3, 255
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s1, a0, .LBB54_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB54_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB54_1
; RV64I-NEXT:  .LBB54_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umin_i8_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    addi a3, zero, 255
; RV64IA-NEXT:    sllw a3, a3, a0
; RV64IA-NEXT:    andi a1, a1, 255
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB54_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a4, (a6)
; RV64IA-NEXT:    and a2, a4, a3
; RV64IA-NEXT:    mv a5, a4
; RV64IA-NEXT:    bgeu a1, a2, .LBB54_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB54_1 Depth=1
; RV64IA-NEXT:    xor a5, a4, a1
; RV64IA-NEXT:    and a5, a5, a3
; RV64IA-NEXT:    xor a5, a4, a5
; RV64IA-NEXT:  .LBB54_3: # in Loop: Header=BB54_1 Depth=1
; RV64IA-NEXT:    sc.w.aqrl a5, a5, (a6)
; RV64IA-NEXT:    bnez a5, .LBB54_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a4, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umin i8* %a, i8 %b seq_cst
  ret i8 %1
}

define i16 @atomicrmw_xchg_i16_monotonic(i16* %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i16_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a2, zero
; RV32I-NEXT:    call __atomic_exchange_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i16_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB55_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a3, (a2)
; RV32IA-NEXT:    mv a5, a1
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB55_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i16_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_exchange_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_i16_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB55_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a3, (a2)
; RV64IA-NEXT:    mv a5, a1
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB55_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg i16* %a, i16 %b monotonic
  ret i16 %1
}

define i16 @atomicrmw_xchg_i16_acquire(i16* %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i16_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 2
; RV32I-NEXT:    call __atomic_exchange_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i16_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB56_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a3, (a2)
; RV32IA-NEXT:    mv a5, a1
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB56_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i16_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_exchange_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_i16_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB56_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a3, (a2)
; RV64IA-NEXT:    mv a5, a1
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB56_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg i16* %a, i16 %b acquire
  ret i16 %1
}

define i16 @atomicrmw_xchg_i16_release(i16* %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i16_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 3
; RV32I-NEXT:    call __atomic_exchange_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i16_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB57_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a3, (a2)
; RV32IA-NEXT:    mv a5, a1
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB57_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i16_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_exchange_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_i16_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB57_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a3, (a2)
; RV64IA-NEXT:    mv a5, a1
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB57_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg i16* %a, i16 %b release
  ret i16 %1
}

define i16 @atomicrmw_xchg_i16_acq_rel(i16* %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i16_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 4
; RV32I-NEXT:    call __atomic_exchange_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i16_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB58_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a3, (a2)
; RV32IA-NEXT:    mv a5, a1
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB58_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i16_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_exchange_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_i16_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB58_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a3, (a2)
; RV64IA-NEXT:    mv a5, a1
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB58_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg i16* %a, i16 %b acq_rel
  ret i16 %1
}

define i16 @atomicrmw_xchg_i16_seq_cst(i16* %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i16_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 5
; RV32I-NEXT:    call __atomic_exchange_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i16_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB59_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a3, (a2)
; RV32IA-NEXT:    mv a5, a1
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w.aqrl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB59_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i16_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_exchange_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_i16_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB59_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a3, (a2)
; RV64IA-NEXT:    mv a5, a1
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w.aqrl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB59_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg i16* %a, i16 %b seq_cst
  ret i16 %1
}

define i16 @atomicrmw_add_i16_monotonic(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i16_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a2, zero
; RV32I-NEXT:    call __atomic_fetch_add_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i16_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB60_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a3, (a2)
; RV32IA-NEXT:    add a5, a3, a1
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB60_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i16_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_fetch_add_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_add_i16_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB60_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a3, (a2)
; RV64IA-NEXT:    add a5, a3, a1
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB60_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw add i16* %a, i16 %b monotonic
  ret i16 %1
}

define i16 @atomicrmw_add_i16_acquire(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i16_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 2
; RV32I-NEXT:    call __atomic_fetch_add_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i16_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB61_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a3, (a2)
; RV32IA-NEXT:    add a5, a3, a1
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB61_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i16_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_fetch_add_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_add_i16_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB61_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a3, (a2)
; RV64IA-NEXT:    add a5, a3, a1
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB61_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw add i16* %a, i16 %b acquire
  ret i16 %1
}

define i16 @atomicrmw_add_i16_release(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i16_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 3
; RV32I-NEXT:    call __atomic_fetch_add_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i16_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB62_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a3, (a2)
; RV32IA-NEXT:    add a5, a3, a1
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB62_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i16_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_fetch_add_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_add_i16_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB62_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a3, (a2)
; RV64IA-NEXT:    add a5, a3, a1
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB62_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw add i16* %a, i16 %b release
  ret i16 %1
}

define i16 @atomicrmw_add_i16_acq_rel(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i16_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 4
; RV32I-NEXT:    call __atomic_fetch_add_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i16_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB63_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a3, (a2)
; RV32IA-NEXT:    add a5, a3, a1
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB63_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i16_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_fetch_add_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_add_i16_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB63_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a3, (a2)
; RV64IA-NEXT:    add a5, a3, a1
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB63_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw add i16* %a, i16 %b acq_rel
  ret i16 %1
}

define i16 @atomicrmw_add_i16_seq_cst(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i16_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 5
; RV32I-NEXT:    call __atomic_fetch_add_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i16_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB64_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a3, (a2)
; RV32IA-NEXT:    add a5, a3, a1
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w.aqrl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB64_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i16_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_fetch_add_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_add_i16_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB64_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a3, (a2)
; RV64IA-NEXT:    add a5, a3, a1
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w.aqrl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB64_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw add i16* %a, i16 %b seq_cst
  ret i16 %1
}

define i16 @atomicrmw_sub_i16_monotonic(i16* %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i16_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a2, zero
; RV32I-NEXT:    call __atomic_fetch_sub_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i16_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB65_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a3, (a2)
; RV32IA-NEXT:    sub a5, a3, a1
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB65_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i16_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_fetch_sub_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_sub_i16_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB65_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a3, (a2)
; RV64IA-NEXT:    sub a5, a3, a1
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB65_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw sub i16* %a, i16 %b monotonic
  ret i16 %1
}

define i16 @atomicrmw_sub_i16_acquire(i16* %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i16_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 2
; RV32I-NEXT:    call __atomic_fetch_sub_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i16_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB66_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a3, (a2)
; RV32IA-NEXT:    sub a5, a3, a1
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB66_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i16_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_fetch_sub_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_sub_i16_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB66_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a3, (a2)
; RV64IA-NEXT:    sub a5, a3, a1
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB66_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw sub i16* %a, i16 %b acquire
  ret i16 %1
}

define i16 @atomicrmw_sub_i16_release(i16* %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i16_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 3
; RV32I-NEXT:    call __atomic_fetch_sub_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i16_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB67_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a3, (a2)
; RV32IA-NEXT:    sub a5, a3, a1
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB67_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i16_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_fetch_sub_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_sub_i16_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB67_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a3, (a2)
; RV64IA-NEXT:    sub a5, a3, a1
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB67_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw sub i16* %a, i16 %b release
  ret i16 %1
}

define i16 @atomicrmw_sub_i16_acq_rel(i16* %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i16_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 4
; RV32I-NEXT:    call __atomic_fetch_sub_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i16_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB68_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a3, (a2)
; RV32IA-NEXT:    sub a5, a3, a1
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB68_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i16_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_fetch_sub_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_sub_i16_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB68_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a3, (a2)
; RV64IA-NEXT:    sub a5, a3, a1
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB68_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw sub i16* %a, i16 %b acq_rel
  ret i16 %1
}

define i16 @atomicrmw_sub_i16_seq_cst(i16* %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i16_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 5
; RV32I-NEXT:    call __atomic_fetch_sub_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i16_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB69_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a3, (a2)
; RV32IA-NEXT:    sub a5, a3, a1
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w.aqrl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB69_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i16_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_fetch_sub_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_sub_i16_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB69_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a3, (a2)
; RV64IA-NEXT:    sub a5, a3, a1
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w.aqrl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB69_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw sub i16* %a, i16 %b seq_cst
  ret i16 %1
}

define i16 @atomicrmw_and_i16_monotonic(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i16_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a2, zero
; RV32I-NEXT:    call __atomic_fetch_and_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i16_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    not a4, a4
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    or a1, a4, a1
; RV32IA-NEXT:    amoand.w a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i16_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_fetch_and_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_and_i16_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    not a4, a4
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    or a1, a4, a1
; RV64IA-NEXT:    amoand.w a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw and i16* %a, i16 %b monotonic
  ret i16 %1
}

define i16 @atomicrmw_and_i16_acquire(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i16_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 2
; RV32I-NEXT:    call __atomic_fetch_and_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i16_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    not a4, a4
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    or a1, a4, a1
; RV32IA-NEXT:    amoand.w.aq a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i16_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_fetch_and_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_and_i16_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    not a4, a4
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    or a1, a4, a1
; RV64IA-NEXT:    amoand.w.aq a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw and i16* %a, i16 %b acquire
  ret i16 %1
}

define i16 @atomicrmw_and_i16_release(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i16_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 3
; RV32I-NEXT:    call __atomic_fetch_and_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i16_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    not a4, a4
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    or a1, a4, a1
; RV32IA-NEXT:    amoand.w.rl a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i16_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_fetch_and_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_and_i16_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    not a4, a4
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    or a1, a4, a1
; RV64IA-NEXT:    amoand.w.rl a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw and i16* %a, i16 %b release
  ret i16 %1
}

define i16 @atomicrmw_and_i16_acq_rel(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i16_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 4
; RV32I-NEXT:    call __atomic_fetch_and_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i16_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    not a4, a4
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    or a1, a4, a1
; RV32IA-NEXT:    amoand.w.aqrl a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i16_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_fetch_and_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_and_i16_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    not a4, a4
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    or a1, a4, a1
; RV64IA-NEXT:    amoand.w.aqrl a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw and i16* %a, i16 %b acq_rel
  ret i16 %1
}

define i16 @atomicrmw_and_i16_seq_cst(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i16_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 5
; RV32I-NEXT:    call __atomic_fetch_and_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i16_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    not a4, a4
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    or a1, a4, a1
; RV32IA-NEXT:    amoand.w.aqrl a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i16_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_fetch_and_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_and_i16_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    not a4, a4
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    or a1, a4, a1
; RV64IA-NEXT:    amoand.w.aqrl a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw and i16* %a, i16 %b seq_cst
  ret i16 %1
}

define i16 @atomicrmw_nand_i16_monotonic(i16* %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i16_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a2, zero
; RV32I-NEXT:    call __atomic_fetch_nand_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i16_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB75_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a3, (a2)
; RV32IA-NEXT:    and a5, a3, a1
; RV32IA-NEXT:    not a5, a5
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB75_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i16_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_fetch_nand_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i16_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB75_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a3, (a2)
; RV64IA-NEXT:    and a5, a3, a1
; RV64IA-NEXT:    not a5, a5
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB75_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand i16* %a, i16 %b monotonic
  ret i16 %1
}

define i16 @atomicrmw_nand_i16_acquire(i16* %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i16_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 2
; RV32I-NEXT:    call __atomic_fetch_nand_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i16_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB76_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a3, (a2)
; RV32IA-NEXT:    and a5, a3, a1
; RV32IA-NEXT:    not a5, a5
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB76_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i16_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_fetch_nand_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i16_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB76_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a3, (a2)
; RV64IA-NEXT:    and a5, a3, a1
; RV64IA-NEXT:    not a5, a5
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB76_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand i16* %a, i16 %b acquire
  ret i16 %1
}

define i16 @atomicrmw_nand_i16_release(i16* %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i16_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 3
; RV32I-NEXT:    call __atomic_fetch_nand_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i16_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB77_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a3, (a2)
; RV32IA-NEXT:    and a5, a3, a1
; RV32IA-NEXT:    not a5, a5
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB77_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i16_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_fetch_nand_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i16_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB77_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a3, (a2)
; RV64IA-NEXT:    and a5, a3, a1
; RV64IA-NEXT:    not a5, a5
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB77_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand i16* %a, i16 %b release
  ret i16 %1
}

define i16 @atomicrmw_nand_i16_acq_rel(i16* %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i16_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 4
; RV32I-NEXT:    call __atomic_fetch_nand_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i16_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB78_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a3, (a2)
; RV32IA-NEXT:    and a5, a3, a1
; RV32IA-NEXT:    not a5, a5
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB78_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i16_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_fetch_nand_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i16_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB78_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a3, (a2)
; RV64IA-NEXT:    and a5, a3, a1
; RV64IA-NEXT:    not a5, a5
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w.rl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB78_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand i16* %a, i16 %b acq_rel
  ret i16 %1
}

define i16 @atomicrmw_nand_i16_seq_cst(i16* %a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i16_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 5
; RV32I-NEXT:    call __atomic_fetch_nand_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i16_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB79_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a3, (a2)
; RV32IA-NEXT:    and a5, a3, a1
; RV32IA-NEXT:    not a5, a5
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:    sc.w.aqrl a5, a5, (a2)
; RV32IA-NEXT:    bnez a5, .LBB79_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i16_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_fetch_nand_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i16_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB79_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a3, (a2)
; RV64IA-NEXT:    and a5, a3, a1
; RV64IA-NEXT:    not a5, a5
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:    sc.w.aqrl a5, a5, (a2)
; RV64IA-NEXT:    bnez a5, .LBB79_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand i16* %a, i16 %b seq_cst
  ret i16 %1
}

define i16 @atomicrmw_or_i16_monotonic(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i16_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a2, zero
; RV32I-NEXT:    call __atomic_fetch_or_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i16_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    amoor.w a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i16_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_fetch_or_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_or_i16_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    amoor.w a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw or i16* %a, i16 %b monotonic
  ret i16 %1
}

define i16 @atomicrmw_or_i16_acquire(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i16_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 2
; RV32I-NEXT:    call __atomic_fetch_or_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i16_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    amoor.w.aq a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i16_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_fetch_or_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_or_i16_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    amoor.w.aq a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw or i16* %a, i16 %b acquire
  ret i16 %1
}

define i16 @atomicrmw_or_i16_release(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i16_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 3
; RV32I-NEXT:    call __atomic_fetch_or_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i16_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    amoor.w.rl a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i16_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_fetch_or_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_or_i16_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    amoor.w.rl a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw or i16* %a, i16 %b release
  ret i16 %1
}

define i16 @atomicrmw_or_i16_acq_rel(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i16_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 4
; RV32I-NEXT:    call __atomic_fetch_or_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i16_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    amoor.w.aqrl a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i16_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_fetch_or_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_or_i16_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    amoor.w.aqrl a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw or i16* %a, i16 %b acq_rel
  ret i16 %1
}

define i16 @atomicrmw_or_i16_seq_cst(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i16_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 5
; RV32I-NEXT:    call __atomic_fetch_or_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i16_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    amoor.w.aqrl a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i16_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_fetch_or_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_or_i16_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    amoor.w.aqrl a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw or i16* %a, i16 %b seq_cst
  ret i16 %1
}

define i16 @atomicrmw_xor_i16_monotonic(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i16_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a2, zero
; RV32I-NEXT:    call __atomic_fetch_xor_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i16_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    amoxor.w a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i16_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_fetch_xor_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xor_i16_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    amoxor.w a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xor i16* %a, i16 %b monotonic
  ret i16 %1
}

define i16 @atomicrmw_xor_i16_acquire(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i16_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 2
; RV32I-NEXT:    call __atomic_fetch_xor_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i16_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    amoxor.w.aq a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i16_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_fetch_xor_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xor_i16_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    amoxor.w.aq a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xor i16* %a, i16 %b acquire
  ret i16 %1
}

define i16 @atomicrmw_xor_i16_release(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i16_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 3
; RV32I-NEXT:    call __atomic_fetch_xor_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i16_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    amoxor.w.rl a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i16_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_fetch_xor_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xor_i16_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    amoxor.w.rl a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xor i16* %a, i16 %b release
  ret i16 %1
}

define i16 @atomicrmw_xor_i16_acq_rel(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i16_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 4
; RV32I-NEXT:    call __atomic_fetch_xor_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i16_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    amoxor.w.aqrl a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i16_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_fetch_xor_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xor_i16_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    amoxor.w.aqrl a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xor i16* %a, i16 %b acq_rel
  ret i16 %1
}

define i16 @atomicrmw_xor_i16_seq_cst(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i16_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 5
; RV32I-NEXT:    call __atomic_fetch_xor_2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i16_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a2, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    amoxor.w.aqrl a1, a1, (a2)
; RV32IA-NEXT:    srl a0, a1, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i16_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_fetch_xor_2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xor_i16_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a2, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    amoxor.w.aqrl a1, a1, (a2)
; RV64IA-NEXT:    srlw a0, a1, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw xor i16* %a, i16 %b seq_cst
  ret i16 %1
}

define i16 @atomicrmw_max_i16_monotonic(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i16_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lhu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    slli a0, a1, 16
; RV32I-NEXT:    srai s1, a0, 16
; RV32I-NEXT:    j .LBB90_2
; RV32I-NEXT:  .LBB90_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB90_2 Depth=1
; RV32I-NEXT:    sh a3, 14(sp)
; RV32I-NEXT:    addi a1, sp, 14
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a3, zero
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    call __atomic_compare_exchange_2@plt
; RV32I-NEXT:    lh a3, 14(sp)
; RV32I-NEXT:    bnez a0, .LBB90_4
; RV32I-NEXT:  .LBB90_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 16
; RV32I-NEXT:    srai a0, a0, 16
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s1, a0, .LBB90_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB90_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB90_1
; RV32I-NEXT:  .LBB90_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i16_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    lui a4, 16
; RV32IA-NEXT:    addi a4, a4, -1
; RV32IA-NEXT:    sll a7, a4, a0
; RV32IA-NEXT:    slli a1, a1, 16
; RV32IA-NEXT:    srai a1, a1, 16
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    addi a5, zero, 16
; RV32IA-NEXT:    sub a3, a5, a3
; RV32IA-NEXT:  .LBB90_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a5, (a6)
; RV32IA-NEXT:    and a4, a5, a7
; RV32IA-NEXT:    mv a2, a5
; RV32IA-NEXT:    sll a4, a4, a3
; RV32IA-NEXT:    sra a4, a4, a3
; RV32IA-NEXT:    bge a4, a1, .LBB90_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB90_1 Depth=1
; RV32IA-NEXT:    xor a2, a5, a1
; RV32IA-NEXT:    and a2, a2, a7
; RV32IA-NEXT:    xor a2, a5, a2
; RV32IA-NEXT:  .LBB90_3: # in Loop: Header=BB90_1 Depth=1
; RV32IA-NEXT:    sc.w a2, a2, (a6)
; RV32IA-NEXT:    bnez a2, .LBB90_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a5, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i16_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lhu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    slli a0, a1, 48
; RV64I-NEXT:    srai s1, a0, 48
; RV64I-NEXT:    j .LBB90_2
; RV64I-NEXT:  .LBB90_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB90_2 Depth=1
; RV64I-NEXT:    sh a3, 14(sp)
; RV64I-NEXT:    addi a1, sp, 14
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a3, zero
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_2@plt
; RV64I-NEXT:    lh a3, 14(sp)
; RV64I-NEXT:    bnez a0, .LBB90_4
; RV64I-NEXT:  .LBB90_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 48
; RV64I-NEXT:    srai a0, a0, 48
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s1, a0, .LBB90_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB90_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB90_1
; RV64I-NEXT:  .LBB90_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_max_i16_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    lui a4, 16
; RV64IA-NEXT:    addiw a4, a4, -1
; RV64IA-NEXT:    sllw a7, a4, a0
; RV64IA-NEXT:    slli a1, a1, 48
; RV64IA-NEXT:    srai a1, a1, 48
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    addi a5, zero, 48
; RV64IA-NEXT:    sub a3, a5, a3
; RV64IA-NEXT:  .LBB90_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a5, (a6)
; RV64IA-NEXT:    and a4, a5, a7
; RV64IA-NEXT:    mv a2, a5
; RV64IA-NEXT:    sll a4, a4, a3
; RV64IA-NEXT:    sra a4, a4, a3
; RV64IA-NEXT:    bge a4, a1, .LBB90_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB90_1 Depth=1
; RV64IA-NEXT:    xor a2, a5, a1
; RV64IA-NEXT:    and a2, a2, a7
; RV64IA-NEXT:    xor a2, a5, a2
; RV64IA-NEXT:  .LBB90_3: # in Loop: Header=BB90_1 Depth=1
; RV64IA-NEXT:    sc.w a2, a2, (a6)
; RV64IA-NEXT:    bnez a2, .LBB90_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a5, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw max i16* %a, i16 %b monotonic
  ret i16 %1
}

define i16 @atomicrmw_max_i16_acquire(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i16_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lhu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    slli a0, a1, 16
; RV32I-NEXT:    srai s1, a0, 16
; RV32I-NEXT:    j .LBB91_2
; RV32I-NEXT:  .LBB91_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB91_2 Depth=1
; RV32I-NEXT:    sh a3, 14(sp)
; RV32I-NEXT:    addi a1, sp, 14
; RV32I-NEXT:    addi a3, zero, 2
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_2@plt
; RV32I-NEXT:    lh a3, 14(sp)
; RV32I-NEXT:    bnez a0, .LBB91_4
; RV32I-NEXT:  .LBB91_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 16
; RV32I-NEXT:    srai a0, a0, 16
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s1, a0, .LBB91_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB91_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB91_1
; RV32I-NEXT:  .LBB91_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i16_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    lui a4, 16
; RV32IA-NEXT:    addi a4, a4, -1
; RV32IA-NEXT:    sll a7, a4, a0
; RV32IA-NEXT:    slli a1, a1, 16
; RV32IA-NEXT:    srai a1, a1, 16
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    addi a5, zero, 16
; RV32IA-NEXT:    sub a3, a5, a3
; RV32IA-NEXT:  .LBB91_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a5, (a6)
; RV32IA-NEXT:    and a4, a5, a7
; RV32IA-NEXT:    mv a2, a5
; RV32IA-NEXT:    sll a4, a4, a3
; RV32IA-NEXT:    sra a4, a4, a3
; RV32IA-NEXT:    bge a4, a1, .LBB91_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB91_1 Depth=1
; RV32IA-NEXT:    xor a2, a5, a1
; RV32IA-NEXT:    and a2, a2, a7
; RV32IA-NEXT:    xor a2, a5, a2
; RV32IA-NEXT:  .LBB91_3: # in Loop: Header=BB91_1 Depth=1
; RV32IA-NEXT:    sc.w a2, a2, (a6)
; RV32IA-NEXT:    bnez a2, .LBB91_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a5, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i16_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lhu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    slli a0, a1, 48
; RV64I-NEXT:    srai s1, a0, 48
; RV64I-NEXT:    j .LBB91_2
; RV64I-NEXT:  .LBB91_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB91_2 Depth=1
; RV64I-NEXT:    sh a3, 14(sp)
; RV64I-NEXT:    addi a1, sp, 14
; RV64I-NEXT:    addi a3, zero, 2
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_2@plt
; RV64I-NEXT:    lh a3, 14(sp)
; RV64I-NEXT:    bnez a0, .LBB91_4
; RV64I-NEXT:  .LBB91_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 48
; RV64I-NEXT:    srai a0, a0, 48
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s1, a0, .LBB91_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB91_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB91_1
; RV64I-NEXT:  .LBB91_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_max_i16_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    lui a4, 16
; RV64IA-NEXT:    addiw a4, a4, -1
; RV64IA-NEXT:    sllw a7, a4, a0
; RV64IA-NEXT:    slli a1, a1, 48
; RV64IA-NEXT:    srai a1, a1, 48
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    addi a5, zero, 48
; RV64IA-NEXT:    sub a3, a5, a3
; RV64IA-NEXT:  .LBB91_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a5, (a6)
; RV64IA-NEXT:    and a4, a5, a7
; RV64IA-NEXT:    mv a2, a5
; RV64IA-NEXT:    sll a4, a4, a3
; RV64IA-NEXT:    sra a4, a4, a3
; RV64IA-NEXT:    bge a4, a1, .LBB91_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB91_1 Depth=1
; RV64IA-NEXT:    xor a2, a5, a1
; RV64IA-NEXT:    and a2, a2, a7
; RV64IA-NEXT:    xor a2, a5, a2
; RV64IA-NEXT:  .LBB91_3: # in Loop: Header=BB91_1 Depth=1
; RV64IA-NEXT:    sc.w a2, a2, (a6)
; RV64IA-NEXT:    bnez a2, .LBB91_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a5, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw max i16* %a, i16 %b acquire
  ret i16 %1
}

define i16 @atomicrmw_max_i16_release(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i16_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lhu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    slli a0, a1, 16
; RV32I-NEXT:    srai s1, a0, 16
; RV32I-NEXT:    j .LBB92_2
; RV32I-NEXT:  .LBB92_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB92_2 Depth=1
; RV32I-NEXT:    sh a3, 14(sp)
; RV32I-NEXT:    addi a1, sp, 14
; RV32I-NEXT:    addi a3, zero, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    call __atomic_compare_exchange_2@plt
; RV32I-NEXT:    lh a3, 14(sp)
; RV32I-NEXT:    bnez a0, .LBB92_4
; RV32I-NEXT:  .LBB92_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 16
; RV32I-NEXT:    srai a0, a0, 16
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s1, a0, .LBB92_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB92_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB92_1
; RV32I-NEXT:  .LBB92_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i16_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    lui a4, 16
; RV32IA-NEXT:    addi a4, a4, -1
; RV32IA-NEXT:    sll a7, a4, a0
; RV32IA-NEXT:    slli a1, a1, 16
; RV32IA-NEXT:    srai a1, a1, 16
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    addi a5, zero, 16
; RV32IA-NEXT:    sub a3, a5, a3
; RV32IA-NEXT:  .LBB92_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a5, (a6)
; RV32IA-NEXT:    and a4, a5, a7
; RV32IA-NEXT:    mv a2, a5
; RV32IA-NEXT:    sll a4, a4, a3
; RV32IA-NEXT:    sra a4, a4, a3
; RV32IA-NEXT:    bge a4, a1, .LBB92_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB92_1 Depth=1
; RV32IA-NEXT:    xor a2, a5, a1
; RV32IA-NEXT:    and a2, a2, a7
; RV32IA-NEXT:    xor a2, a5, a2
; RV32IA-NEXT:  .LBB92_3: # in Loop: Header=BB92_1 Depth=1
; RV32IA-NEXT:    sc.w.rl a2, a2, (a6)
; RV32IA-NEXT:    bnez a2, .LBB92_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a5, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i16_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lhu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    slli a0, a1, 48
; RV64I-NEXT:    srai s1, a0, 48
; RV64I-NEXT:    j .LBB92_2
; RV64I-NEXT:  .LBB92_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB92_2 Depth=1
; RV64I-NEXT:    sh a3, 14(sp)
; RV64I-NEXT:    addi a1, sp, 14
; RV64I-NEXT:    addi a3, zero, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_2@plt
; RV64I-NEXT:    lh a3, 14(sp)
; RV64I-NEXT:    bnez a0, .LBB92_4
; RV64I-NEXT:  .LBB92_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 48
; RV64I-NEXT:    srai a0, a0, 48
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s1, a0, .LBB92_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB92_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB92_1
; RV64I-NEXT:  .LBB92_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_max_i16_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    lui a4, 16
; RV64IA-NEXT:    addiw a4, a4, -1
; RV64IA-NEXT:    sllw a7, a4, a0
; RV64IA-NEXT:    slli a1, a1, 48
; RV64IA-NEXT:    srai a1, a1, 48
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    addi a5, zero, 48
; RV64IA-NEXT:    sub a3, a5, a3
; RV64IA-NEXT:  .LBB92_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a5, (a6)
; RV64IA-NEXT:    and a4, a5, a7
; RV64IA-NEXT:    mv a2, a5
; RV64IA-NEXT:    sll a4, a4, a3
; RV64IA-NEXT:    sra a4, a4, a3
; RV64IA-NEXT:    bge a4, a1, .LBB92_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB92_1 Depth=1
; RV64IA-NEXT:    xor a2, a5, a1
; RV64IA-NEXT:    and a2, a2, a7
; RV64IA-NEXT:    xor a2, a5, a2
; RV64IA-NEXT:  .LBB92_3: # in Loop: Header=BB92_1 Depth=1
; RV64IA-NEXT:    sc.w.rl a2, a2, (a6)
; RV64IA-NEXT:    bnez a2, .LBB92_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a5, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw max i16* %a, i16 %b release
  ret i16 %1
}

define i16 @atomicrmw_max_i16_acq_rel(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i16_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lhu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    slli a0, a1, 16
; RV32I-NEXT:    srai s1, a0, 16
; RV32I-NEXT:    j .LBB93_2
; RV32I-NEXT:  .LBB93_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB93_2 Depth=1
; RV32I-NEXT:    sh a3, 14(sp)
; RV32I-NEXT:    addi a1, sp, 14
; RV32I-NEXT:    addi a3, zero, 4
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_2@plt
; RV32I-NEXT:    lh a3, 14(sp)
; RV32I-NEXT:    bnez a0, .LBB93_4
; RV32I-NEXT:  .LBB93_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 16
; RV32I-NEXT:    srai a0, a0, 16
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s1, a0, .LBB93_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB93_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB93_1
; RV32I-NEXT:  .LBB93_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i16_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    lui a4, 16
; RV32IA-NEXT:    addi a4, a4, -1
; RV32IA-NEXT:    sll a7, a4, a0
; RV32IA-NEXT:    slli a1, a1, 16
; RV32IA-NEXT:    srai a1, a1, 16
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    addi a5, zero, 16
; RV32IA-NEXT:    sub a3, a5, a3
; RV32IA-NEXT:  .LBB93_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a5, (a6)
; RV32IA-NEXT:    and a4, a5, a7
; RV32IA-NEXT:    mv a2, a5
; RV32IA-NEXT:    sll a4, a4, a3
; RV32IA-NEXT:    sra a4, a4, a3
; RV32IA-NEXT:    bge a4, a1, .LBB93_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB93_1 Depth=1
; RV32IA-NEXT:    xor a2, a5, a1
; RV32IA-NEXT:    and a2, a2, a7
; RV32IA-NEXT:    xor a2, a5, a2
; RV32IA-NEXT:  .LBB93_3: # in Loop: Header=BB93_1 Depth=1
; RV32IA-NEXT:    sc.w.rl a2, a2, (a6)
; RV32IA-NEXT:    bnez a2, .LBB93_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a5, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i16_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lhu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    slli a0, a1, 48
; RV64I-NEXT:    srai s1, a0, 48
; RV64I-NEXT:    j .LBB93_2
; RV64I-NEXT:  .LBB93_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB93_2 Depth=1
; RV64I-NEXT:    sh a3, 14(sp)
; RV64I-NEXT:    addi a1, sp, 14
; RV64I-NEXT:    addi a3, zero, 4
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_2@plt
; RV64I-NEXT:    lh a3, 14(sp)
; RV64I-NEXT:    bnez a0, .LBB93_4
; RV64I-NEXT:  .LBB93_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 48
; RV64I-NEXT:    srai a0, a0, 48
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s1, a0, .LBB93_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB93_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB93_1
; RV64I-NEXT:  .LBB93_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_max_i16_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    lui a4, 16
; RV64IA-NEXT:    addiw a4, a4, -1
; RV64IA-NEXT:    sllw a7, a4, a0
; RV64IA-NEXT:    slli a1, a1, 48
; RV64IA-NEXT:    srai a1, a1, 48
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    addi a5, zero, 48
; RV64IA-NEXT:    sub a3, a5, a3
; RV64IA-NEXT:  .LBB93_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a5, (a6)
; RV64IA-NEXT:    and a4, a5, a7
; RV64IA-NEXT:    mv a2, a5
; RV64IA-NEXT:    sll a4, a4, a3
; RV64IA-NEXT:    sra a4, a4, a3
; RV64IA-NEXT:    bge a4, a1, .LBB93_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB93_1 Depth=1
; RV64IA-NEXT:    xor a2, a5, a1
; RV64IA-NEXT:    and a2, a2, a7
; RV64IA-NEXT:    xor a2, a5, a2
; RV64IA-NEXT:  .LBB93_3: # in Loop: Header=BB93_1 Depth=1
; RV64IA-NEXT:    sc.w.rl a2, a2, (a6)
; RV64IA-NEXT:    bnez a2, .LBB93_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a5, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw max i16* %a, i16 %b acq_rel
  ret i16 %1
}

define i16 @atomicrmw_max_i16_seq_cst(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i16_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lhu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    slli a0, a1, 16
; RV32I-NEXT:    srai s1, a0, 16
; RV32I-NEXT:    j .LBB94_2
; RV32I-NEXT:  .LBB94_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB94_2 Depth=1
; RV32I-NEXT:    sh a3, 14(sp)
; RV32I-NEXT:    addi a1, sp, 14
; RV32I-NEXT:    addi a3, zero, 5
; RV32I-NEXT:    addi a4, zero, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_2@plt
; RV32I-NEXT:    lh a3, 14(sp)
; RV32I-NEXT:    bnez a0, .LBB94_4
; RV32I-NEXT:  .LBB94_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 16
; RV32I-NEXT:    srai a0, a0, 16
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s1, a0, .LBB94_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB94_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB94_1
; RV32I-NEXT:  .LBB94_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i16_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    lui a4, 16
; RV32IA-NEXT:    addi a4, a4, -1
; RV32IA-NEXT:    sll a7, a4, a0
; RV32IA-NEXT:    slli a1, a1, 16
; RV32IA-NEXT:    srai a1, a1, 16
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    addi a5, zero, 16
; RV32IA-NEXT:    sub a3, a5, a3
; RV32IA-NEXT:  .LBB94_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a5, (a6)
; RV32IA-NEXT:    and a4, a5, a7
; RV32IA-NEXT:    mv a2, a5
; RV32IA-NEXT:    sll a4, a4, a3
; RV32IA-NEXT:    sra a4, a4, a3
; RV32IA-NEXT:    bge a4, a1, .LBB94_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB94_1 Depth=1
; RV32IA-NEXT:    xor a2, a5, a1
; RV32IA-NEXT:    and a2, a2, a7
; RV32IA-NEXT:    xor a2, a5, a2
; RV32IA-NEXT:  .LBB94_3: # in Loop: Header=BB94_1 Depth=1
; RV32IA-NEXT:    sc.w.aqrl a2, a2, (a6)
; RV32IA-NEXT:    bnez a2, .LBB94_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a5, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i16_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lhu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    slli a0, a1, 48
; RV64I-NEXT:    srai s1, a0, 48
; RV64I-NEXT:    j .LBB94_2
; RV64I-NEXT:  .LBB94_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB94_2 Depth=1
; RV64I-NEXT:    sh a3, 14(sp)
; RV64I-NEXT:    addi a1, sp, 14
; RV64I-NEXT:    addi a3, zero, 5
; RV64I-NEXT:    addi a4, zero, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_2@plt
; RV64I-NEXT:    lh a3, 14(sp)
; RV64I-NEXT:    bnez a0, .LBB94_4
; RV64I-NEXT:  .LBB94_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 48
; RV64I-NEXT:    srai a0, a0, 48
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s1, a0, .LBB94_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB94_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB94_1
; RV64I-NEXT:  .LBB94_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_max_i16_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    lui a4, 16
; RV64IA-NEXT:    addiw a4, a4, -1
; RV64IA-NEXT:    sllw a7, a4, a0
; RV64IA-NEXT:    slli a1, a1, 48
; RV64IA-NEXT:    srai a1, a1, 48
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    addi a5, zero, 48
; RV64IA-NEXT:    sub a3, a5, a3
; RV64IA-NEXT:  .LBB94_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a5, (a6)
; RV64IA-NEXT:    and a4, a5, a7
; RV64IA-NEXT:    mv a2, a5
; RV64IA-NEXT:    sll a4, a4, a3
; RV64IA-NEXT:    sra a4, a4, a3
; RV64IA-NEXT:    bge a4, a1, .LBB94_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB94_1 Depth=1
; RV64IA-NEXT:    xor a2, a5, a1
; RV64IA-NEXT:    and a2, a2, a7
; RV64IA-NEXT:    xor a2, a5, a2
; RV64IA-NEXT:  .LBB94_3: # in Loop: Header=BB94_1 Depth=1
; RV64IA-NEXT:    sc.w.aqrl a2, a2, (a6)
; RV64IA-NEXT:    bnez a2, .LBB94_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a5, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw max i16* %a, i16 %b seq_cst
  ret i16 %1
}

define i16 @atomicrmw_min_i16_monotonic(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i16_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lhu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    slli a0, a1, 16
; RV32I-NEXT:    srai s1, a0, 16
; RV32I-NEXT:    j .LBB95_2
; RV32I-NEXT:  .LBB95_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB95_2 Depth=1
; RV32I-NEXT:    sh a3, 14(sp)
; RV32I-NEXT:    addi a1, sp, 14
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a3, zero
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    call __atomic_compare_exchange_2@plt
; RV32I-NEXT:    lh a3, 14(sp)
; RV32I-NEXT:    bnez a0, .LBB95_4
; RV32I-NEXT:  .LBB95_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 16
; RV32I-NEXT:    srai a0, a0, 16
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s1, a0, .LBB95_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB95_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB95_1
; RV32I-NEXT:  .LBB95_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i16_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    lui a4, 16
; RV32IA-NEXT:    addi a4, a4, -1
; RV32IA-NEXT:    sll a7, a4, a0
; RV32IA-NEXT:    slli a1, a1, 16
; RV32IA-NEXT:    srai a1, a1, 16
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    addi a5, zero, 16
; RV32IA-NEXT:    sub a3, a5, a3
; RV32IA-NEXT:  .LBB95_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a5, (a6)
; RV32IA-NEXT:    and a4, a5, a7
; RV32IA-NEXT:    mv a2, a5
; RV32IA-NEXT:    sll a4, a4, a3
; RV32IA-NEXT:    sra a4, a4, a3
; RV32IA-NEXT:    bge a1, a4, .LBB95_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB95_1 Depth=1
; RV32IA-NEXT:    xor a2, a5, a1
; RV32IA-NEXT:    and a2, a2, a7
; RV32IA-NEXT:    xor a2, a5, a2
; RV32IA-NEXT:  .LBB95_3: # in Loop: Header=BB95_1 Depth=1
; RV32IA-NEXT:    sc.w a2, a2, (a6)
; RV32IA-NEXT:    bnez a2, .LBB95_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a5, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i16_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lhu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    slli a0, a1, 48
; RV64I-NEXT:    srai s1, a0, 48
; RV64I-NEXT:    j .LBB95_2
; RV64I-NEXT:  .LBB95_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB95_2 Depth=1
; RV64I-NEXT:    sh a3, 14(sp)
; RV64I-NEXT:    addi a1, sp, 14
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a3, zero
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_2@plt
; RV64I-NEXT:    lh a3, 14(sp)
; RV64I-NEXT:    bnez a0, .LBB95_4
; RV64I-NEXT:  .LBB95_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 48
; RV64I-NEXT:    srai a0, a0, 48
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s1, a0, .LBB95_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB95_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB95_1
; RV64I-NEXT:  .LBB95_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_min_i16_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    lui a4, 16
; RV64IA-NEXT:    addiw a4, a4, -1
; RV64IA-NEXT:    sllw a7, a4, a0
; RV64IA-NEXT:    slli a1, a1, 48
; RV64IA-NEXT:    srai a1, a1, 48
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    addi a5, zero, 48
; RV64IA-NEXT:    sub a3, a5, a3
; RV64IA-NEXT:  .LBB95_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a5, (a6)
; RV64IA-NEXT:    and a4, a5, a7
; RV64IA-NEXT:    mv a2, a5
; RV64IA-NEXT:    sll a4, a4, a3
; RV64IA-NEXT:    sra a4, a4, a3
; RV64IA-NEXT:    bge a1, a4, .LBB95_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB95_1 Depth=1
; RV64IA-NEXT:    xor a2, a5, a1
; RV64IA-NEXT:    and a2, a2, a7
; RV64IA-NEXT:    xor a2, a5, a2
; RV64IA-NEXT:  .LBB95_3: # in Loop: Header=BB95_1 Depth=1
; RV64IA-NEXT:    sc.w a2, a2, (a6)
; RV64IA-NEXT:    bnez a2, .LBB95_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a5, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw min i16* %a, i16 %b monotonic
  ret i16 %1
}

define i16 @atomicrmw_min_i16_acquire(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i16_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lhu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    slli a0, a1, 16
; RV32I-NEXT:    srai s1, a0, 16
; RV32I-NEXT:    j .LBB96_2
; RV32I-NEXT:  .LBB96_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB96_2 Depth=1
; RV32I-NEXT:    sh a3, 14(sp)
; RV32I-NEXT:    addi a1, sp, 14
; RV32I-NEXT:    addi a3, zero, 2
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_2@plt
; RV32I-NEXT:    lh a3, 14(sp)
; RV32I-NEXT:    bnez a0, .LBB96_4
; RV32I-NEXT:  .LBB96_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 16
; RV32I-NEXT:    srai a0, a0, 16
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s1, a0, .LBB96_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB96_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB96_1
; RV32I-NEXT:  .LBB96_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i16_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    lui a4, 16
; RV32IA-NEXT:    addi a4, a4, -1
; RV32IA-NEXT:    sll a7, a4, a0
; RV32IA-NEXT:    slli a1, a1, 16
; RV32IA-NEXT:    srai a1, a1, 16
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    addi a5, zero, 16
; RV32IA-NEXT:    sub a3, a5, a3
; RV32IA-NEXT:  .LBB96_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a5, (a6)
; RV32IA-NEXT:    and a4, a5, a7
; RV32IA-NEXT:    mv a2, a5
; RV32IA-NEXT:    sll a4, a4, a3
; RV32IA-NEXT:    sra a4, a4, a3
; RV32IA-NEXT:    bge a1, a4, .LBB96_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB96_1 Depth=1
; RV32IA-NEXT:    xor a2, a5, a1
; RV32IA-NEXT:    and a2, a2, a7
; RV32IA-NEXT:    xor a2, a5, a2
; RV32IA-NEXT:  .LBB96_3: # in Loop: Header=BB96_1 Depth=1
; RV32IA-NEXT:    sc.w a2, a2, (a6)
; RV32IA-NEXT:    bnez a2, .LBB96_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a5, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i16_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lhu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    slli a0, a1, 48
; RV64I-NEXT:    srai s1, a0, 48
; RV64I-NEXT:    j .LBB96_2
; RV64I-NEXT:  .LBB96_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB96_2 Depth=1
; RV64I-NEXT:    sh a3, 14(sp)
; RV64I-NEXT:    addi a1, sp, 14
; RV64I-NEXT:    addi a3, zero, 2
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_2@plt
; RV64I-NEXT:    lh a3, 14(sp)
; RV64I-NEXT:    bnez a0, .LBB96_4
; RV64I-NEXT:  .LBB96_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 48
; RV64I-NEXT:    srai a0, a0, 48
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s1, a0, .LBB96_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB96_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB96_1
; RV64I-NEXT:  .LBB96_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_min_i16_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    lui a4, 16
; RV64IA-NEXT:    addiw a4, a4, -1
; RV64IA-NEXT:    sllw a7, a4, a0
; RV64IA-NEXT:    slli a1, a1, 48
; RV64IA-NEXT:    srai a1, a1, 48
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    addi a5, zero, 48
; RV64IA-NEXT:    sub a3, a5, a3
; RV64IA-NEXT:  .LBB96_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a5, (a6)
; RV64IA-NEXT:    and a4, a5, a7
; RV64IA-NEXT:    mv a2, a5
; RV64IA-NEXT:    sll a4, a4, a3
; RV64IA-NEXT:    sra a4, a4, a3
; RV64IA-NEXT:    bge a1, a4, .LBB96_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB96_1 Depth=1
; RV64IA-NEXT:    xor a2, a5, a1
; RV64IA-NEXT:    and a2, a2, a7
; RV64IA-NEXT:    xor a2, a5, a2
; RV64IA-NEXT:  .LBB96_3: # in Loop: Header=BB96_1 Depth=1
; RV64IA-NEXT:    sc.w a2, a2, (a6)
; RV64IA-NEXT:    bnez a2, .LBB96_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a5, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw min i16* %a, i16 %b acquire
  ret i16 %1
}

define i16 @atomicrmw_min_i16_release(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i16_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lhu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    slli a0, a1, 16
; RV32I-NEXT:    srai s1, a0, 16
; RV32I-NEXT:    j .LBB97_2
; RV32I-NEXT:  .LBB97_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB97_2 Depth=1
; RV32I-NEXT:    sh a3, 14(sp)
; RV32I-NEXT:    addi a1, sp, 14
; RV32I-NEXT:    addi a3, zero, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    call __atomic_compare_exchange_2@plt
; RV32I-NEXT:    lh a3, 14(sp)
; RV32I-NEXT:    bnez a0, .LBB97_4
; RV32I-NEXT:  .LBB97_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 16
; RV32I-NEXT:    srai a0, a0, 16
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s1, a0, .LBB97_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB97_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB97_1
; RV32I-NEXT:  .LBB97_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i16_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    lui a4, 16
; RV32IA-NEXT:    addi a4, a4, -1
; RV32IA-NEXT:    sll a7, a4, a0
; RV32IA-NEXT:    slli a1, a1, 16
; RV32IA-NEXT:    srai a1, a1, 16
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    addi a5, zero, 16
; RV32IA-NEXT:    sub a3, a5, a3
; RV32IA-NEXT:  .LBB97_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a5, (a6)
; RV32IA-NEXT:    and a4, a5, a7
; RV32IA-NEXT:    mv a2, a5
; RV32IA-NEXT:    sll a4, a4, a3
; RV32IA-NEXT:    sra a4, a4, a3
; RV32IA-NEXT:    bge a1, a4, .LBB97_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB97_1 Depth=1
; RV32IA-NEXT:    xor a2, a5, a1
; RV32IA-NEXT:    and a2, a2, a7
; RV32IA-NEXT:    xor a2, a5, a2
; RV32IA-NEXT:  .LBB97_3: # in Loop: Header=BB97_1 Depth=1
; RV32IA-NEXT:    sc.w.rl a2, a2, (a6)
; RV32IA-NEXT:    bnez a2, .LBB97_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a5, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i16_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lhu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    slli a0, a1, 48
; RV64I-NEXT:    srai s1, a0, 48
; RV64I-NEXT:    j .LBB97_2
; RV64I-NEXT:  .LBB97_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB97_2 Depth=1
; RV64I-NEXT:    sh a3, 14(sp)
; RV64I-NEXT:    addi a1, sp, 14
; RV64I-NEXT:    addi a3, zero, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_2@plt
; RV64I-NEXT:    lh a3, 14(sp)
; RV64I-NEXT:    bnez a0, .LBB97_4
; RV64I-NEXT:  .LBB97_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 48
; RV64I-NEXT:    srai a0, a0, 48
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s1, a0, .LBB97_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB97_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB97_1
; RV64I-NEXT:  .LBB97_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_min_i16_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    lui a4, 16
; RV64IA-NEXT:    addiw a4, a4, -1
; RV64IA-NEXT:    sllw a7, a4, a0
; RV64IA-NEXT:    slli a1, a1, 48
; RV64IA-NEXT:    srai a1, a1, 48
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    addi a5, zero, 48
; RV64IA-NEXT:    sub a3, a5, a3
; RV64IA-NEXT:  .LBB97_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a5, (a6)
; RV64IA-NEXT:    and a4, a5, a7
; RV64IA-NEXT:    mv a2, a5
; RV64IA-NEXT:    sll a4, a4, a3
; RV64IA-NEXT:    sra a4, a4, a3
; RV64IA-NEXT:    bge a1, a4, .LBB97_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB97_1 Depth=1
; RV64IA-NEXT:    xor a2, a5, a1
; RV64IA-NEXT:    and a2, a2, a7
; RV64IA-NEXT:    xor a2, a5, a2
; RV64IA-NEXT:  .LBB97_3: # in Loop: Header=BB97_1 Depth=1
; RV64IA-NEXT:    sc.w.rl a2, a2, (a6)
; RV64IA-NEXT:    bnez a2, .LBB97_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a5, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw min i16* %a, i16 %b release
  ret i16 %1
}

define i16 @atomicrmw_min_i16_acq_rel(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i16_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lhu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    slli a0, a1, 16
; RV32I-NEXT:    srai s1, a0, 16
; RV32I-NEXT:    j .LBB98_2
; RV32I-NEXT:  .LBB98_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB98_2 Depth=1
; RV32I-NEXT:    sh a3, 14(sp)
; RV32I-NEXT:    addi a1, sp, 14
; RV32I-NEXT:    addi a3, zero, 4
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_2@plt
; RV32I-NEXT:    lh a3, 14(sp)
; RV32I-NEXT:    bnez a0, .LBB98_4
; RV32I-NEXT:  .LBB98_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 16
; RV32I-NEXT:    srai a0, a0, 16
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s1, a0, .LBB98_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB98_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB98_1
; RV32I-NEXT:  .LBB98_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i16_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    lui a4, 16
; RV32IA-NEXT:    addi a4, a4, -1
; RV32IA-NEXT:    sll a7, a4, a0
; RV32IA-NEXT:    slli a1, a1, 16
; RV32IA-NEXT:    srai a1, a1, 16
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    addi a5, zero, 16
; RV32IA-NEXT:    sub a3, a5, a3
; RV32IA-NEXT:  .LBB98_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a5, (a6)
; RV32IA-NEXT:    and a4, a5, a7
; RV32IA-NEXT:    mv a2, a5
; RV32IA-NEXT:    sll a4, a4, a3
; RV32IA-NEXT:    sra a4, a4, a3
; RV32IA-NEXT:    bge a1, a4, .LBB98_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB98_1 Depth=1
; RV32IA-NEXT:    xor a2, a5, a1
; RV32IA-NEXT:    and a2, a2, a7
; RV32IA-NEXT:    xor a2, a5, a2
; RV32IA-NEXT:  .LBB98_3: # in Loop: Header=BB98_1 Depth=1
; RV32IA-NEXT:    sc.w.rl a2, a2, (a6)
; RV32IA-NEXT:    bnez a2, .LBB98_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a5, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i16_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lhu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    slli a0, a1, 48
; RV64I-NEXT:    srai s1, a0, 48
; RV64I-NEXT:    j .LBB98_2
; RV64I-NEXT:  .LBB98_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB98_2 Depth=1
; RV64I-NEXT:    sh a3, 14(sp)
; RV64I-NEXT:    addi a1, sp, 14
; RV64I-NEXT:    addi a3, zero, 4
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_2@plt
; RV64I-NEXT:    lh a3, 14(sp)
; RV64I-NEXT:    bnez a0, .LBB98_4
; RV64I-NEXT:  .LBB98_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 48
; RV64I-NEXT:    srai a0, a0, 48
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s1, a0, .LBB98_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB98_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB98_1
; RV64I-NEXT:  .LBB98_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_min_i16_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    lui a4, 16
; RV64IA-NEXT:    addiw a4, a4, -1
; RV64IA-NEXT:    sllw a7, a4, a0
; RV64IA-NEXT:    slli a1, a1, 48
; RV64IA-NEXT:    srai a1, a1, 48
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    addi a5, zero, 48
; RV64IA-NEXT:    sub a3, a5, a3
; RV64IA-NEXT:  .LBB98_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a5, (a6)
; RV64IA-NEXT:    and a4, a5, a7
; RV64IA-NEXT:    mv a2, a5
; RV64IA-NEXT:    sll a4, a4, a3
; RV64IA-NEXT:    sra a4, a4, a3
; RV64IA-NEXT:    bge a1, a4, .LBB98_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB98_1 Depth=1
; RV64IA-NEXT:    xor a2, a5, a1
; RV64IA-NEXT:    and a2, a2, a7
; RV64IA-NEXT:    xor a2, a5, a2
; RV64IA-NEXT:  .LBB98_3: # in Loop: Header=BB98_1 Depth=1
; RV64IA-NEXT:    sc.w.rl a2, a2, (a6)
; RV64IA-NEXT:    bnez a2, .LBB98_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a5, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw min i16* %a, i16 %b acq_rel
  ret i16 %1
}

define i16 @atomicrmw_min_i16_seq_cst(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i16_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lhu a3, 0(a0)
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    slli a0, a1, 16
; RV32I-NEXT:    srai s1, a0, 16
; RV32I-NEXT:    j .LBB99_2
; RV32I-NEXT:  .LBB99_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB99_2 Depth=1
; RV32I-NEXT:    sh a3, 14(sp)
; RV32I-NEXT:    addi a1, sp, 14
; RV32I-NEXT:    addi a3, zero, 5
; RV32I-NEXT:    addi a4, zero, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_2@plt
; RV32I-NEXT:    lh a3, 14(sp)
; RV32I-NEXT:    bnez a0, .LBB99_4
; RV32I-NEXT:  .LBB99_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    slli a0, a3, 16
; RV32I-NEXT:    srai a0, a0, 16
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s1, a0, .LBB99_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB99_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB99_1
; RV32I-NEXT:  .LBB99_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i16_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    andi a3, a0, 24
; RV32IA-NEXT:    lui a4, 16
; RV32IA-NEXT:    addi a4, a4, -1
; RV32IA-NEXT:    sll a7, a4, a0
; RV32IA-NEXT:    slli a1, a1, 16
; RV32IA-NEXT:    srai a1, a1, 16
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    addi a5, zero, 16
; RV32IA-NEXT:    sub a3, a5, a3
; RV32IA-NEXT:  .LBB99_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a5, (a6)
; RV32IA-NEXT:    and a4, a5, a7
; RV32IA-NEXT:    mv a2, a5
; RV32IA-NEXT:    sll a4, a4, a3
; RV32IA-NEXT:    sra a4, a4, a3
; RV32IA-NEXT:    bge a1, a4, .LBB99_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB99_1 Depth=1
; RV32IA-NEXT:    xor a2, a5, a1
; RV32IA-NEXT:    and a2, a2, a7
; RV32IA-NEXT:    xor a2, a5, a2
; RV32IA-NEXT:  .LBB99_3: # in Loop: Header=BB99_1 Depth=1
; RV32IA-NEXT:    sc.w.aqrl a2, a2, (a6)
; RV32IA-NEXT:    bnez a2, .LBB99_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a5, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i16_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lhu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    slli a0, a1, 48
; RV64I-NEXT:    srai s1, a0, 48
; RV64I-NEXT:    j .LBB99_2
; RV64I-NEXT:  .LBB99_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB99_2 Depth=1
; RV64I-NEXT:    sh a3, 14(sp)
; RV64I-NEXT:    addi a1, sp, 14
; RV64I-NEXT:    addi a3, zero, 5
; RV64I-NEXT:    addi a4, zero, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_2@plt
; RV64I-NEXT:    lh a3, 14(sp)
; RV64I-NEXT:    bnez a0, .LBB99_4
; RV64I-NEXT:  .LBB99_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    slli a0, a3, 48
; RV64I-NEXT:    srai a0, a0, 48
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s1, a0, .LBB99_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB99_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB99_1
; RV64I-NEXT:  .LBB99_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_min_i16_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    andi a3, a0, 24
; RV64IA-NEXT:    lui a4, 16
; RV64IA-NEXT:    addiw a4, a4, -1
; RV64IA-NEXT:    sllw a7, a4, a0
; RV64IA-NEXT:    slli a1, a1, 48
; RV64IA-NEXT:    srai a1, a1, 48
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:    addi a5, zero, 48
; RV64IA-NEXT:    sub a3, a5, a3
; RV64IA-NEXT:  .LBB99_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a5, (a6)
; RV64IA-NEXT:    and a4, a5, a7
; RV64IA-NEXT:    mv a2, a5
; RV64IA-NEXT:    sll a4, a4, a3
; RV64IA-NEXT:    sra a4, a4, a3
; RV64IA-NEXT:    bge a1, a4, .LBB99_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB99_1 Depth=1
; RV64IA-NEXT:    xor a2, a5, a1
; RV64IA-NEXT:    and a2, a2, a7
; RV64IA-NEXT:    xor a2, a5, a2
; RV64IA-NEXT:  .LBB99_3: # in Loop: Header=BB99_1 Depth=1
; RV64IA-NEXT:    sc.w.aqrl a2, a2, (a6)
; RV64IA-NEXT:    bnez a2, .LBB99_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a5, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw min i16* %a, i16 %b seq_cst
  ret i16 %1
}

define i16 @atomicrmw_umax_i16_monotonic(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i16_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    mv s3, a0
; RV32I-NEXT:    lhu a1, 0(a0)
; RV32I-NEXT:    lui a0, 16
; RV32I-NEXT:    addi s0, a0, -1
; RV32I-NEXT:    and s1, s2, s0
; RV32I-NEXT:    j .LBB100_2
; RV32I-NEXT:  .LBB100_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB100_2 Depth=1
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    mv a0, s3
; RV32I-NEXT:    mv a3, zero
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    call __atomic_compare_exchange_2@plt
; RV32I-NEXT:    lh a1, 10(sp)
; RV32I-NEXT:    bnez a0, .LBB100_4
; RV32I-NEXT:  .LBB100_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    and a0, a1, s0
; RV32I-NEXT:    mv a2, a1
; RV32I-NEXT:    bltu s1, a0, .LBB100_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB100_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB100_1
; RV32I-NEXT:  .LBB100_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i16_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB100_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a3, (a6)
; RV32IA-NEXT:    and a2, a3, a4
; RV32IA-NEXT:    mv a5, a3
; RV32IA-NEXT:    bgeu a2, a1, .LBB100_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB100_1 Depth=1
; RV32IA-NEXT:    xor a5, a3, a1
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:  .LBB100_3: # in Loop: Header=BB100_1 Depth=1
; RV32IA-NEXT:    sc.w a5, a5, (a6)
; RV32IA-NEXT:    bnez a5, .LBB100_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i16_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    mv s3, a0
; RV64I-NEXT:    lhu a1, 0(a0)
; RV64I-NEXT:    lui a0, 16
; RV64I-NEXT:    addiw s0, a0, -1
; RV64I-NEXT:    and s1, s2, s0
; RV64I-NEXT:    j .LBB100_2
; RV64I-NEXT:  .LBB100_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB100_2 Depth=1
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    mv a0, s3
; RV64I-NEXT:    mv a3, zero
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_2@plt
; RV64I-NEXT:    lh a1, 6(sp)
; RV64I-NEXT:    bnez a0, .LBB100_4
; RV64I-NEXT:  .LBB100_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    and a0, a1, s0
; RV64I-NEXT:    mv a2, a1
; RV64I-NEXT:    bltu s1, a0, .LBB100_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB100_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB100_1
; RV64I-NEXT:  .LBB100_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umax_i16_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB100_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a3, (a6)
; RV64IA-NEXT:    and a2, a3, a4
; RV64IA-NEXT:    mv a5, a3
; RV64IA-NEXT:    bgeu a2, a1, .LBB100_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB100_1 Depth=1
; RV64IA-NEXT:    xor a5, a3, a1
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:  .LBB100_3: # in Loop: Header=BB100_1 Depth=1
; RV64IA-NEXT:    sc.w a5, a5, (a6)
; RV64IA-NEXT:    bnez a5, .LBB100_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umax i16* %a, i16 %b monotonic
  ret i16 %1
}

define i16 @atomicrmw_umax_i16_acquire(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i16_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    mv s3, a0
; RV32I-NEXT:    lhu a1, 0(a0)
; RV32I-NEXT:    lui a0, 16
; RV32I-NEXT:    addi s0, a0, -1
; RV32I-NEXT:    and s1, s2, s0
; RV32I-NEXT:    j .LBB101_2
; RV32I-NEXT:  .LBB101_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB101_2 Depth=1
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    addi a3, zero, 2
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    mv a0, s3
; RV32I-NEXT:    call __atomic_compare_exchange_2@plt
; RV32I-NEXT:    lh a1, 10(sp)
; RV32I-NEXT:    bnez a0, .LBB101_4
; RV32I-NEXT:  .LBB101_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    and a0, a1, s0
; RV32I-NEXT:    mv a2, a1
; RV32I-NEXT:    bltu s1, a0, .LBB101_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB101_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB101_1
; RV32I-NEXT:  .LBB101_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i16_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB101_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a3, (a6)
; RV32IA-NEXT:    and a2, a3, a4
; RV32IA-NEXT:    mv a5, a3
; RV32IA-NEXT:    bgeu a2, a1, .LBB101_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB101_1 Depth=1
; RV32IA-NEXT:    xor a5, a3, a1
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:  .LBB101_3: # in Loop: Header=BB101_1 Depth=1
; RV32IA-NEXT:    sc.w a5, a5, (a6)
; RV32IA-NEXT:    bnez a5, .LBB101_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i16_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    mv s3, a0
; RV64I-NEXT:    lhu a1, 0(a0)
; RV64I-NEXT:    lui a0, 16
; RV64I-NEXT:    addiw s0, a0, -1
; RV64I-NEXT:    and s1, s2, s0
; RV64I-NEXT:    j .LBB101_2
; RV64I-NEXT:  .LBB101_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB101_2 Depth=1
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    addi a3, zero, 2
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s3
; RV64I-NEXT:    call __atomic_compare_exchange_2@plt
; RV64I-NEXT:    lh a1, 6(sp)
; RV64I-NEXT:    bnez a0, .LBB101_4
; RV64I-NEXT:  .LBB101_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    and a0, a1, s0
; RV64I-NEXT:    mv a2, a1
; RV64I-NEXT:    bltu s1, a0, .LBB101_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB101_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB101_1
; RV64I-NEXT:  .LBB101_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umax_i16_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB101_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a3, (a6)
; RV64IA-NEXT:    and a2, a3, a4
; RV64IA-NEXT:    mv a5, a3
; RV64IA-NEXT:    bgeu a2, a1, .LBB101_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB101_1 Depth=1
; RV64IA-NEXT:    xor a5, a3, a1
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:  .LBB101_3: # in Loop: Header=BB101_1 Depth=1
; RV64IA-NEXT:    sc.w a5, a5, (a6)
; RV64IA-NEXT:    bnez a5, .LBB101_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umax i16* %a, i16 %b acquire
  ret i16 %1
}

define i16 @atomicrmw_umax_i16_release(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i16_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    mv s3, a0
; RV32I-NEXT:    lhu a1, 0(a0)
; RV32I-NEXT:    lui a0, 16
; RV32I-NEXT:    addi s0, a0, -1
; RV32I-NEXT:    and s1, s2, s0
; RV32I-NEXT:    j .LBB102_2
; RV32I-NEXT:  .LBB102_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB102_2 Depth=1
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    addi a3, zero, 3
; RV32I-NEXT:    mv a0, s3
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    call __atomic_compare_exchange_2@plt
; RV32I-NEXT:    lh a1, 10(sp)
; RV32I-NEXT:    bnez a0, .LBB102_4
; RV32I-NEXT:  .LBB102_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    and a0, a1, s0
; RV32I-NEXT:    mv a2, a1
; RV32I-NEXT:    bltu s1, a0, .LBB102_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB102_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB102_1
; RV32I-NEXT:  .LBB102_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i16_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB102_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a3, (a6)
; RV32IA-NEXT:    and a2, a3, a4
; RV32IA-NEXT:    mv a5, a3
; RV32IA-NEXT:    bgeu a2, a1, .LBB102_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB102_1 Depth=1
; RV32IA-NEXT:    xor a5, a3, a1
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:  .LBB102_3: # in Loop: Header=BB102_1 Depth=1
; RV32IA-NEXT:    sc.w.rl a5, a5, (a6)
; RV32IA-NEXT:    bnez a5, .LBB102_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i16_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    mv s3, a0
; RV64I-NEXT:    lhu a1, 0(a0)
; RV64I-NEXT:    lui a0, 16
; RV64I-NEXT:    addiw s0, a0, -1
; RV64I-NEXT:    and s1, s2, s0
; RV64I-NEXT:    j .LBB102_2
; RV64I-NEXT:  .LBB102_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB102_2 Depth=1
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    addi a3, zero, 3
; RV64I-NEXT:    mv a0, s3
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_2@plt
; RV64I-NEXT:    lh a1, 6(sp)
; RV64I-NEXT:    bnez a0, .LBB102_4
; RV64I-NEXT:  .LBB102_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    and a0, a1, s0
; RV64I-NEXT:    mv a2, a1
; RV64I-NEXT:    bltu s1, a0, .LBB102_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB102_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB102_1
; RV64I-NEXT:  .LBB102_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umax_i16_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB102_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a3, (a6)
; RV64IA-NEXT:    and a2, a3, a4
; RV64IA-NEXT:    mv a5, a3
; RV64IA-NEXT:    bgeu a2, a1, .LBB102_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB102_1 Depth=1
; RV64IA-NEXT:    xor a5, a3, a1
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:  .LBB102_3: # in Loop: Header=BB102_1 Depth=1
; RV64IA-NEXT:    sc.w.rl a5, a5, (a6)
; RV64IA-NEXT:    bnez a5, .LBB102_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umax i16* %a, i16 %b release
  ret i16 %1
}

define i16 @atomicrmw_umax_i16_acq_rel(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i16_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    mv s3, a0
; RV32I-NEXT:    lhu a1, 0(a0)
; RV32I-NEXT:    lui a0, 16
; RV32I-NEXT:    addi s0, a0, -1
; RV32I-NEXT:    and s1, s2, s0
; RV32I-NEXT:    j .LBB103_2
; RV32I-NEXT:  .LBB103_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB103_2 Depth=1
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    addi a3, zero, 4
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    mv a0, s3
; RV32I-NEXT:    call __atomic_compare_exchange_2@plt
; RV32I-NEXT:    lh a1, 10(sp)
; RV32I-NEXT:    bnez a0, .LBB103_4
; RV32I-NEXT:  .LBB103_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    and a0, a1, s0
; RV32I-NEXT:    mv a2, a1
; RV32I-NEXT:    bltu s1, a0, .LBB103_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB103_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB103_1
; RV32I-NEXT:  .LBB103_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i16_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB103_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a3, (a6)
; RV32IA-NEXT:    and a2, a3, a4
; RV32IA-NEXT:    mv a5, a3
; RV32IA-NEXT:    bgeu a2, a1, .LBB103_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB103_1 Depth=1
; RV32IA-NEXT:    xor a5, a3, a1
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:  .LBB103_3: # in Loop: Header=BB103_1 Depth=1
; RV32IA-NEXT:    sc.w.rl a5, a5, (a6)
; RV32IA-NEXT:    bnez a5, .LBB103_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i16_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    mv s3, a0
; RV64I-NEXT:    lhu a1, 0(a0)
; RV64I-NEXT:    lui a0, 16
; RV64I-NEXT:    addiw s0, a0, -1
; RV64I-NEXT:    and s1, s2, s0
; RV64I-NEXT:    j .LBB103_2
; RV64I-NEXT:  .LBB103_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB103_2 Depth=1
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    addi a3, zero, 4
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s3
; RV64I-NEXT:    call __atomic_compare_exchange_2@plt
; RV64I-NEXT:    lh a1, 6(sp)
; RV64I-NEXT:    bnez a0, .LBB103_4
; RV64I-NEXT:  .LBB103_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    and a0, a1, s0
; RV64I-NEXT:    mv a2, a1
; RV64I-NEXT:    bltu s1, a0, .LBB103_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB103_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB103_1
; RV64I-NEXT:  .LBB103_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umax_i16_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB103_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a3, (a6)
; RV64IA-NEXT:    and a2, a3, a4
; RV64IA-NEXT:    mv a5, a3
; RV64IA-NEXT:    bgeu a2, a1, .LBB103_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB103_1 Depth=1
; RV64IA-NEXT:    xor a5, a3, a1
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:  .LBB103_3: # in Loop: Header=BB103_1 Depth=1
; RV64IA-NEXT:    sc.w.rl a5, a5, (a6)
; RV64IA-NEXT:    bnez a5, .LBB103_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umax i16* %a, i16 %b acq_rel
  ret i16 %1
}

define i16 @atomicrmw_umax_i16_seq_cst(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i16_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    mv s3, a0
; RV32I-NEXT:    lhu a1, 0(a0)
; RV32I-NEXT:    lui a0, 16
; RV32I-NEXT:    addi s0, a0, -1
; RV32I-NEXT:    and s1, s2, s0
; RV32I-NEXT:    j .LBB104_2
; RV32I-NEXT:  .LBB104_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB104_2 Depth=1
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    addi a3, zero, 5
; RV32I-NEXT:    addi a4, zero, 5
; RV32I-NEXT:    mv a0, s3
; RV32I-NEXT:    call __atomic_compare_exchange_2@plt
; RV32I-NEXT:    lh a1, 10(sp)
; RV32I-NEXT:    bnez a0, .LBB104_4
; RV32I-NEXT:  .LBB104_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    and a0, a1, s0
; RV32I-NEXT:    mv a2, a1
; RV32I-NEXT:    bltu s1, a0, .LBB104_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB104_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB104_1
; RV32I-NEXT:  .LBB104_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i16_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB104_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a3, (a6)
; RV32IA-NEXT:    and a2, a3, a4
; RV32IA-NEXT:    mv a5, a3
; RV32IA-NEXT:    bgeu a2, a1, .LBB104_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB104_1 Depth=1
; RV32IA-NEXT:    xor a5, a3, a1
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:  .LBB104_3: # in Loop: Header=BB104_1 Depth=1
; RV32IA-NEXT:    sc.w.aqrl a5, a5, (a6)
; RV32IA-NEXT:    bnez a5, .LBB104_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i16_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    mv s3, a0
; RV64I-NEXT:    lhu a1, 0(a0)
; RV64I-NEXT:    lui a0, 16
; RV64I-NEXT:    addiw s0, a0, -1
; RV64I-NEXT:    and s1, s2, s0
; RV64I-NEXT:    j .LBB104_2
; RV64I-NEXT:  .LBB104_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB104_2 Depth=1
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    addi a3, zero, 5
; RV64I-NEXT:    addi a4, zero, 5
; RV64I-NEXT:    mv a0, s3
; RV64I-NEXT:    call __atomic_compare_exchange_2@plt
; RV64I-NEXT:    lh a1, 6(sp)
; RV64I-NEXT:    bnez a0, .LBB104_4
; RV64I-NEXT:  .LBB104_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    and a0, a1, s0
; RV64I-NEXT:    mv a2, a1
; RV64I-NEXT:    bltu s1, a0, .LBB104_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB104_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB104_1
; RV64I-NEXT:  .LBB104_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umax_i16_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB104_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a3, (a6)
; RV64IA-NEXT:    and a2, a3, a4
; RV64IA-NEXT:    mv a5, a3
; RV64IA-NEXT:    bgeu a2, a1, .LBB104_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB104_1 Depth=1
; RV64IA-NEXT:    xor a5, a3, a1
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:  .LBB104_3: # in Loop: Header=BB104_1 Depth=1
; RV64IA-NEXT:    sc.w.aqrl a5, a5, (a6)
; RV64IA-NEXT:    bnez a5, .LBB104_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umax i16* %a, i16 %b seq_cst
  ret i16 %1
}

define i16 @atomicrmw_umin_i16_monotonic(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i16_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    mv s3, a0
; RV32I-NEXT:    lhu a1, 0(a0)
; RV32I-NEXT:    lui a0, 16
; RV32I-NEXT:    addi s0, a0, -1
; RV32I-NEXT:    and s1, s2, s0
; RV32I-NEXT:    j .LBB105_2
; RV32I-NEXT:  .LBB105_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB105_2 Depth=1
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    mv a0, s3
; RV32I-NEXT:    mv a3, zero
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    call __atomic_compare_exchange_2@plt
; RV32I-NEXT:    lh a1, 10(sp)
; RV32I-NEXT:    bnez a0, .LBB105_4
; RV32I-NEXT:  .LBB105_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    and a0, a1, s0
; RV32I-NEXT:    mv a2, a1
; RV32I-NEXT:    bgeu s1, a0, .LBB105_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB105_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB105_1
; RV32I-NEXT:  .LBB105_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i16_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB105_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a3, (a6)
; RV32IA-NEXT:    and a2, a3, a4
; RV32IA-NEXT:    mv a5, a3
; RV32IA-NEXT:    bgeu a1, a2, .LBB105_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB105_1 Depth=1
; RV32IA-NEXT:    xor a5, a3, a1
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:  .LBB105_3: # in Loop: Header=BB105_1 Depth=1
; RV32IA-NEXT:    sc.w a5, a5, (a6)
; RV32IA-NEXT:    bnez a5, .LBB105_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i16_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    mv s3, a0
; RV64I-NEXT:    lhu a1, 0(a0)
; RV64I-NEXT:    lui a0, 16
; RV64I-NEXT:    addiw s0, a0, -1
; RV64I-NEXT:    and s1, s2, s0
; RV64I-NEXT:    j .LBB105_2
; RV64I-NEXT:  .LBB105_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB105_2 Depth=1
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    mv a0, s3
; RV64I-NEXT:    mv a3, zero
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_2@plt
; RV64I-NEXT:    lh a1, 6(sp)
; RV64I-NEXT:    bnez a0, .LBB105_4
; RV64I-NEXT:  .LBB105_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    and a0, a1, s0
; RV64I-NEXT:    mv a2, a1
; RV64I-NEXT:    bgeu s1, a0, .LBB105_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB105_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB105_1
; RV64I-NEXT:  .LBB105_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umin_i16_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB105_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a3, (a6)
; RV64IA-NEXT:    and a2, a3, a4
; RV64IA-NEXT:    mv a5, a3
; RV64IA-NEXT:    bgeu a1, a2, .LBB105_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB105_1 Depth=1
; RV64IA-NEXT:    xor a5, a3, a1
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:  .LBB105_3: # in Loop: Header=BB105_1 Depth=1
; RV64IA-NEXT:    sc.w a5, a5, (a6)
; RV64IA-NEXT:    bnez a5, .LBB105_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umin i16* %a, i16 %b monotonic
  ret i16 %1
}

define i16 @atomicrmw_umin_i16_acquire(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i16_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    mv s3, a0
; RV32I-NEXT:    lhu a1, 0(a0)
; RV32I-NEXT:    lui a0, 16
; RV32I-NEXT:    addi s0, a0, -1
; RV32I-NEXT:    and s1, s2, s0
; RV32I-NEXT:    j .LBB106_2
; RV32I-NEXT:  .LBB106_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB106_2 Depth=1
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    addi a3, zero, 2
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    mv a0, s3
; RV32I-NEXT:    call __atomic_compare_exchange_2@plt
; RV32I-NEXT:    lh a1, 10(sp)
; RV32I-NEXT:    bnez a0, .LBB106_4
; RV32I-NEXT:  .LBB106_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    and a0, a1, s0
; RV32I-NEXT:    mv a2, a1
; RV32I-NEXT:    bgeu s1, a0, .LBB106_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB106_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB106_1
; RV32I-NEXT:  .LBB106_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i16_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB106_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a3, (a6)
; RV32IA-NEXT:    and a2, a3, a4
; RV32IA-NEXT:    mv a5, a3
; RV32IA-NEXT:    bgeu a1, a2, .LBB106_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB106_1 Depth=1
; RV32IA-NEXT:    xor a5, a3, a1
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:  .LBB106_3: # in Loop: Header=BB106_1 Depth=1
; RV32IA-NEXT:    sc.w a5, a5, (a6)
; RV32IA-NEXT:    bnez a5, .LBB106_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i16_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    mv s3, a0
; RV64I-NEXT:    lhu a1, 0(a0)
; RV64I-NEXT:    lui a0, 16
; RV64I-NEXT:    addiw s0, a0, -1
; RV64I-NEXT:    and s1, s2, s0
; RV64I-NEXT:    j .LBB106_2
; RV64I-NEXT:  .LBB106_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB106_2 Depth=1
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    addi a3, zero, 2
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s3
; RV64I-NEXT:    call __atomic_compare_exchange_2@plt
; RV64I-NEXT:    lh a1, 6(sp)
; RV64I-NEXT:    bnez a0, .LBB106_4
; RV64I-NEXT:  .LBB106_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    and a0, a1, s0
; RV64I-NEXT:    mv a2, a1
; RV64I-NEXT:    bgeu s1, a0, .LBB106_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB106_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB106_1
; RV64I-NEXT:  .LBB106_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umin_i16_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB106_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a3, (a6)
; RV64IA-NEXT:    and a2, a3, a4
; RV64IA-NEXT:    mv a5, a3
; RV64IA-NEXT:    bgeu a1, a2, .LBB106_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB106_1 Depth=1
; RV64IA-NEXT:    xor a5, a3, a1
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:  .LBB106_3: # in Loop: Header=BB106_1 Depth=1
; RV64IA-NEXT:    sc.w a5, a5, (a6)
; RV64IA-NEXT:    bnez a5, .LBB106_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umin i16* %a, i16 %b acquire
  ret i16 %1
}

define i16 @atomicrmw_umin_i16_release(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i16_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    mv s3, a0
; RV32I-NEXT:    lhu a1, 0(a0)
; RV32I-NEXT:    lui a0, 16
; RV32I-NEXT:    addi s0, a0, -1
; RV32I-NEXT:    and s1, s2, s0
; RV32I-NEXT:    j .LBB107_2
; RV32I-NEXT:  .LBB107_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB107_2 Depth=1
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    addi a3, zero, 3
; RV32I-NEXT:    mv a0, s3
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    call __atomic_compare_exchange_2@plt
; RV32I-NEXT:    lh a1, 10(sp)
; RV32I-NEXT:    bnez a0, .LBB107_4
; RV32I-NEXT:  .LBB107_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    and a0, a1, s0
; RV32I-NEXT:    mv a2, a1
; RV32I-NEXT:    bgeu s1, a0, .LBB107_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB107_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB107_1
; RV32I-NEXT:  .LBB107_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i16_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB107_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a3, (a6)
; RV32IA-NEXT:    and a2, a3, a4
; RV32IA-NEXT:    mv a5, a3
; RV32IA-NEXT:    bgeu a1, a2, .LBB107_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB107_1 Depth=1
; RV32IA-NEXT:    xor a5, a3, a1
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:  .LBB107_3: # in Loop: Header=BB107_1 Depth=1
; RV32IA-NEXT:    sc.w.rl a5, a5, (a6)
; RV32IA-NEXT:    bnez a5, .LBB107_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i16_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    mv s3, a0
; RV64I-NEXT:    lhu a1, 0(a0)
; RV64I-NEXT:    lui a0, 16
; RV64I-NEXT:    addiw s0, a0, -1
; RV64I-NEXT:    and s1, s2, s0
; RV64I-NEXT:    j .LBB107_2
; RV64I-NEXT:  .LBB107_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB107_2 Depth=1
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    addi a3, zero, 3
; RV64I-NEXT:    mv a0, s3
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_2@plt
; RV64I-NEXT:    lh a1, 6(sp)
; RV64I-NEXT:    bnez a0, .LBB107_4
; RV64I-NEXT:  .LBB107_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    and a0, a1, s0
; RV64I-NEXT:    mv a2, a1
; RV64I-NEXT:    bgeu s1, a0, .LBB107_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB107_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB107_1
; RV64I-NEXT:  .LBB107_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umin_i16_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB107_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a3, (a6)
; RV64IA-NEXT:    and a2, a3, a4
; RV64IA-NEXT:    mv a5, a3
; RV64IA-NEXT:    bgeu a1, a2, .LBB107_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB107_1 Depth=1
; RV64IA-NEXT:    xor a5, a3, a1
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:  .LBB107_3: # in Loop: Header=BB107_1 Depth=1
; RV64IA-NEXT:    sc.w.rl a5, a5, (a6)
; RV64IA-NEXT:    bnez a5, .LBB107_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umin i16* %a, i16 %b release
  ret i16 %1
}

define i16 @atomicrmw_umin_i16_acq_rel(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i16_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    mv s3, a0
; RV32I-NEXT:    lhu a1, 0(a0)
; RV32I-NEXT:    lui a0, 16
; RV32I-NEXT:    addi s0, a0, -1
; RV32I-NEXT:    and s1, s2, s0
; RV32I-NEXT:    j .LBB108_2
; RV32I-NEXT:  .LBB108_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB108_2 Depth=1
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    addi a3, zero, 4
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    mv a0, s3
; RV32I-NEXT:    call __atomic_compare_exchange_2@plt
; RV32I-NEXT:    lh a1, 10(sp)
; RV32I-NEXT:    bnez a0, .LBB108_4
; RV32I-NEXT:  .LBB108_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    and a0, a1, s0
; RV32I-NEXT:    mv a2, a1
; RV32I-NEXT:    bgeu s1, a0, .LBB108_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB108_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB108_1
; RV32I-NEXT:  .LBB108_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i16_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB108_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a3, (a6)
; RV32IA-NEXT:    and a2, a3, a4
; RV32IA-NEXT:    mv a5, a3
; RV32IA-NEXT:    bgeu a1, a2, .LBB108_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB108_1 Depth=1
; RV32IA-NEXT:    xor a5, a3, a1
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:  .LBB108_3: # in Loop: Header=BB108_1 Depth=1
; RV32IA-NEXT:    sc.w.rl a5, a5, (a6)
; RV32IA-NEXT:    bnez a5, .LBB108_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i16_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    mv s3, a0
; RV64I-NEXT:    lhu a1, 0(a0)
; RV64I-NEXT:    lui a0, 16
; RV64I-NEXT:    addiw s0, a0, -1
; RV64I-NEXT:    and s1, s2, s0
; RV64I-NEXT:    j .LBB108_2
; RV64I-NEXT:  .LBB108_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB108_2 Depth=1
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    addi a3, zero, 4
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s3
; RV64I-NEXT:    call __atomic_compare_exchange_2@plt
; RV64I-NEXT:    lh a1, 6(sp)
; RV64I-NEXT:    bnez a0, .LBB108_4
; RV64I-NEXT:  .LBB108_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    and a0, a1, s0
; RV64I-NEXT:    mv a2, a1
; RV64I-NEXT:    bgeu s1, a0, .LBB108_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB108_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB108_1
; RV64I-NEXT:  .LBB108_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umin_i16_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB108_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a3, (a6)
; RV64IA-NEXT:    and a2, a3, a4
; RV64IA-NEXT:    mv a5, a3
; RV64IA-NEXT:    bgeu a1, a2, .LBB108_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB108_1 Depth=1
; RV64IA-NEXT:    xor a5, a3, a1
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:  .LBB108_3: # in Loop: Header=BB108_1 Depth=1
; RV64IA-NEXT:    sc.w.rl a5, a5, (a6)
; RV64IA-NEXT:    bnez a5, .LBB108_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umin i16* %a, i16 %b acq_rel
  ret i16 %1
}

define i16 @atomicrmw_umin_i16_seq_cst(i16 *%a, i16 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i16_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    mv s3, a0
; RV32I-NEXT:    lhu a1, 0(a0)
; RV32I-NEXT:    lui a0, 16
; RV32I-NEXT:    addi s0, a0, -1
; RV32I-NEXT:    and s1, s2, s0
; RV32I-NEXT:    j .LBB109_2
; RV32I-NEXT:  .LBB109_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB109_2 Depth=1
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    addi a3, zero, 5
; RV32I-NEXT:    addi a4, zero, 5
; RV32I-NEXT:    mv a0, s3
; RV32I-NEXT:    call __atomic_compare_exchange_2@plt
; RV32I-NEXT:    lh a1, 10(sp)
; RV32I-NEXT:    bnez a0, .LBB109_4
; RV32I-NEXT:  .LBB109_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    and a0, a1, s0
; RV32I-NEXT:    mv a2, a1
; RV32I-NEXT:    bgeu s1, a0, .LBB109_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB109_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    j .LBB109_1
; RV32I-NEXT:  .LBB109_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i16_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a6, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a3, 16
; RV32IA-NEXT:    addi a3, a3, -1
; RV32IA-NEXT:    sll a4, a3, a0
; RV32IA-NEXT:    and a1, a1, a3
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:  .LBB109_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a3, (a6)
; RV32IA-NEXT:    and a2, a3, a4
; RV32IA-NEXT:    mv a5, a3
; RV32IA-NEXT:    bgeu a1, a2, .LBB109_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB109_1 Depth=1
; RV32IA-NEXT:    xor a5, a3, a1
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a3, a5
; RV32IA-NEXT:  .LBB109_3: # in Loop: Header=BB109_1 Depth=1
; RV32IA-NEXT:    sc.w.aqrl a5, a5, (a6)
; RV32IA-NEXT:    bnez a5, .LBB109_1
; RV32IA-NEXT:  # %bb.4:
; RV32IA-NEXT:    srl a0, a3, a0
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i16_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    mv s3, a0
; RV64I-NEXT:    lhu a1, 0(a0)
; RV64I-NEXT:    lui a0, 16
; RV64I-NEXT:    addiw s0, a0, -1
; RV64I-NEXT:    and s1, s2, s0
; RV64I-NEXT:    j .LBB109_2
; RV64I-NEXT:  .LBB109_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB109_2 Depth=1
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    addi a3, zero, 5
; RV64I-NEXT:    addi a4, zero, 5
; RV64I-NEXT:    mv a0, s3
; RV64I-NEXT:    call __atomic_compare_exchange_2@plt
; RV64I-NEXT:    lh a1, 6(sp)
; RV64I-NEXT:    bnez a0, .LBB109_4
; RV64I-NEXT:  .LBB109_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    and a0, a1, s0
; RV64I-NEXT:    mv a2, a1
; RV64I-NEXT:    bgeu s1, a0, .LBB109_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB109_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB109_1
; RV64I-NEXT:  .LBB109_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umin_i16_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    andi a6, a0, -4
; RV64IA-NEXT:    slli a0, a0, 3
; RV64IA-NEXT:    lui a3, 16
; RV64IA-NEXT:    addiw a3, a3, -1
; RV64IA-NEXT:    sllw a4, a3, a0
; RV64IA-NEXT:    and a1, a1, a3
; RV64IA-NEXT:    sllw a1, a1, a0
; RV64IA-NEXT:  .LBB109_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a3, (a6)
; RV64IA-NEXT:    and a2, a3, a4
; RV64IA-NEXT:    mv a5, a3
; RV64IA-NEXT:    bgeu a1, a2, .LBB109_3
; RV64IA-NEXT:  # %bb.2: # in Loop: Header=BB109_1 Depth=1
; RV64IA-NEXT:    xor a5, a3, a1
; RV64IA-NEXT:    and a5, a5, a4
; RV64IA-NEXT:    xor a5, a3, a5
; RV64IA-NEXT:  .LBB109_3: # in Loop: Header=BB109_1 Depth=1
; RV64IA-NEXT:    sc.w.aqrl a5, a5, (a6)
; RV64IA-NEXT:    bnez a5, .LBB109_1
; RV64IA-NEXT:  # %bb.4:
; RV64IA-NEXT:    srlw a0, a3, a0
; RV64IA-NEXT:    ret
  %1 = atomicrmw umin i16* %a, i16 %b seq_cst
  ret i16 %1
}

define i32 @atomicrmw_xchg_i32_monotonic(i32* %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i32_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a2, zero
; RV32I-NEXT:    call __atomic_exchange_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i32_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoswap.w a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i32_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_exchange_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_i32_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoswap.w a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg i32* %a, i32 %b monotonic
  ret i32 %1
}

define i32 @atomicrmw_xchg_i32_acquire(i32* %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i32_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 2
; RV32I-NEXT:    call __atomic_exchange_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i32_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoswap.w.aq a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i32_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_exchange_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_i32_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoswap.w.aq a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg i32* %a, i32 %b acquire
  ret i32 %1
}

define i32 @atomicrmw_xchg_i32_release(i32* %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i32_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 3
; RV32I-NEXT:    call __atomic_exchange_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i32_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoswap.w.rl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i32_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_exchange_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_i32_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoswap.w.rl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg i32* %a, i32 %b release
  ret i32 %1
}

define i32 @atomicrmw_xchg_i32_acq_rel(i32* %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i32_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 4
; RV32I-NEXT:    call __atomic_exchange_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i32_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoswap.w.aqrl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i32_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_exchange_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_i32_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoswap.w.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg i32* %a, i32 %b acq_rel
  ret i32 %1
}

define i32 @atomicrmw_xchg_i32_seq_cst(i32* %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i32_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 5
; RV32I-NEXT:    call __atomic_exchange_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i32_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoswap.w.aqrl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i32_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_exchange_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_i32_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoswap.w.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg i32* %a, i32 %b seq_cst
  ret i32 %1
}

define i32 @atomicrmw_add_i32_monotonic(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i32_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a2, zero
; RV32I-NEXT:    call __atomic_fetch_add_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i32_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoadd.w a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i32_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_fetch_add_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_add_i32_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoadd.w a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw add i32* %a, i32 %b monotonic
  ret i32 %1
}

define i32 @atomicrmw_add_i32_acquire(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i32_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 2
; RV32I-NEXT:    call __atomic_fetch_add_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i32_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoadd.w.aq a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i32_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_fetch_add_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_add_i32_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoadd.w.aq a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw add i32* %a, i32 %b acquire
  ret i32 %1
}

define i32 @atomicrmw_add_i32_release(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i32_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 3
; RV32I-NEXT:    call __atomic_fetch_add_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i32_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoadd.w.rl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i32_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_fetch_add_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_add_i32_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoadd.w.rl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw add i32* %a, i32 %b release
  ret i32 %1
}

define i32 @atomicrmw_add_i32_acq_rel(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i32_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 4
; RV32I-NEXT:    call __atomic_fetch_add_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i32_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoadd.w.aqrl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i32_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_fetch_add_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_add_i32_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoadd.w.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw add i32* %a, i32 %b acq_rel
  ret i32 %1
}

define i32 @atomicrmw_add_i32_seq_cst(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i32_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 5
; RV32I-NEXT:    call __atomic_fetch_add_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i32_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoadd.w.aqrl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i32_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_fetch_add_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_add_i32_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoadd.w.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw add i32* %a, i32 %b seq_cst
  ret i32 %1
}

define i32 @atomicrmw_sub_i32_monotonic(i32* %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i32_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a2, zero
; RV32I-NEXT:    call __atomic_fetch_sub_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i32_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    neg a1, a1
; RV32IA-NEXT:    amoadd.w a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i32_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_fetch_sub_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_sub_i32_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    neg a1, a1
; RV64IA-NEXT:    amoadd.w a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw sub i32* %a, i32 %b monotonic
  ret i32 %1
}

define i32 @atomicrmw_sub_i32_acquire(i32* %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i32_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 2
; RV32I-NEXT:    call __atomic_fetch_sub_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i32_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    neg a1, a1
; RV32IA-NEXT:    amoadd.w.aq a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i32_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_fetch_sub_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_sub_i32_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    neg a1, a1
; RV64IA-NEXT:    amoadd.w.aq a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw sub i32* %a, i32 %b acquire
  ret i32 %1
}

define i32 @atomicrmw_sub_i32_release(i32* %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i32_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 3
; RV32I-NEXT:    call __atomic_fetch_sub_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i32_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    neg a1, a1
; RV32IA-NEXT:    amoadd.w.rl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i32_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_fetch_sub_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_sub_i32_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    neg a1, a1
; RV64IA-NEXT:    amoadd.w.rl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw sub i32* %a, i32 %b release
  ret i32 %1
}

define i32 @atomicrmw_sub_i32_acq_rel(i32* %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i32_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 4
; RV32I-NEXT:    call __atomic_fetch_sub_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i32_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    neg a1, a1
; RV32IA-NEXT:    amoadd.w.aqrl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i32_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_fetch_sub_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_sub_i32_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    neg a1, a1
; RV64IA-NEXT:    amoadd.w.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw sub i32* %a, i32 %b acq_rel
  ret i32 %1
}

define i32 @atomicrmw_sub_i32_seq_cst(i32* %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i32_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 5
; RV32I-NEXT:    call __atomic_fetch_sub_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i32_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    neg a1, a1
; RV32IA-NEXT:    amoadd.w.aqrl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i32_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_fetch_sub_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_sub_i32_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    neg a1, a1
; RV64IA-NEXT:    amoadd.w.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw sub i32* %a, i32 %b seq_cst
  ret i32 %1
}

define i32 @atomicrmw_and_i32_monotonic(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i32_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a2, zero
; RV32I-NEXT:    call __atomic_fetch_and_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i32_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoand.w a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i32_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_fetch_and_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_and_i32_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoand.w a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw and i32* %a, i32 %b monotonic
  ret i32 %1
}

define i32 @atomicrmw_and_i32_acquire(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i32_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 2
; RV32I-NEXT:    call __atomic_fetch_and_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i32_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoand.w.aq a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i32_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_fetch_and_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_and_i32_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoand.w.aq a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw and i32* %a, i32 %b acquire
  ret i32 %1
}

define i32 @atomicrmw_and_i32_release(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i32_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 3
; RV32I-NEXT:    call __atomic_fetch_and_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i32_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoand.w.rl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i32_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_fetch_and_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_and_i32_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoand.w.rl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw and i32* %a, i32 %b release
  ret i32 %1
}

define i32 @atomicrmw_and_i32_acq_rel(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i32_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 4
; RV32I-NEXT:    call __atomic_fetch_and_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i32_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoand.w.aqrl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i32_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_fetch_and_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_and_i32_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoand.w.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw and i32* %a, i32 %b acq_rel
  ret i32 %1
}

define i32 @atomicrmw_and_i32_seq_cst(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i32_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 5
; RV32I-NEXT:    call __atomic_fetch_and_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i32_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoand.w.aqrl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i32_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_fetch_and_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_and_i32_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoand.w.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw and i32* %a, i32 %b seq_cst
  ret i32 %1
}

define i32 @atomicrmw_nand_i32_monotonic(i32* %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i32_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a2, zero
; RV32I-NEXT:    call __atomic_fetch_nand_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i32_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:  .LBB130_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a2, (a0)
; RV32IA-NEXT:    and a3, a2, a1
; RV32IA-NEXT:    not a3, a3
; RV32IA-NEXT:    sc.w a3, a3, (a0)
; RV32IA-NEXT:    bnez a3, .LBB130_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    mv a0, a2
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i32_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_fetch_nand_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i32_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:  .LBB130_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a2, (a0)
; RV64IA-NEXT:    and a3, a2, a1
; RV64IA-NEXT:    not a3, a3
; RV64IA-NEXT:    sc.w a3, a3, (a0)
; RV64IA-NEXT:    bnez a3, .LBB130_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    mv a0, a2
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand i32* %a, i32 %b monotonic
  ret i32 %1
}

define i32 @atomicrmw_nand_i32_acquire(i32* %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i32_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 2
; RV32I-NEXT:    call __atomic_fetch_nand_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i32_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:  .LBB131_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a2, (a0)
; RV32IA-NEXT:    and a3, a2, a1
; RV32IA-NEXT:    not a3, a3
; RV32IA-NEXT:    sc.w a3, a3, (a0)
; RV32IA-NEXT:    bnez a3, .LBB131_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    mv a0, a2
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i32_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_fetch_nand_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i32_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:  .LBB131_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a2, (a0)
; RV64IA-NEXT:    and a3, a2, a1
; RV64IA-NEXT:    not a3, a3
; RV64IA-NEXT:    sc.w a3, a3, (a0)
; RV64IA-NEXT:    bnez a3, .LBB131_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    mv a0, a2
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand i32* %a, i32 %b acquire
  ret i32 %1
}

define i32 @atomicrmw_nand_i32_release(i32* %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i32_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 3
; RV32I-NEXT:    call __atomic_fetch_nand_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i32_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:  .LBB132_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a2, (a0)
; RV32IA-NEXT:    and a3, a2, a1
; RV32IA-NEXT:    not a3, a3
; RV32IA-NEXT:    sc.w.rl a3, a3, (a0)
; RV32IA-NEXT:    bnez a3, .LBB132_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    mv a0, a2
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i32_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_fetch_nand_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i32_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:  .LBB132_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w a2, (a0)
; RV64IA-NEXT:    and a3, a2, a1
; RV64IA-NEXT:    not a3, a3
; RV64IA-NEXT:    sc.w.rl a3, a3, (a0)
; RV64IA-NEXT:    bnez a3, .LBB132_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    mv a0, a2
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand i32* %a, i32 %b release
  ret i32 %1
}

define i32 @atomicrmw_nand_i32_acq_rel(i32* %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i32_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 4
; RV32I-NEXT:    call __atomic_fetch_nand_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i32_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:  .LBB133_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aq a2, (a0)
; RV32IA-NEXT:    and a3, a2, a1
; RV32IA-NEXT:    not a3, a3
; RV32IA-NEXT:    sc.w.rl a3, a3, (a0)
; RV32IA-NEXT:    bnez a3, .LBB133_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    mv a0, a2
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i32_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_fetch_nand_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i32_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:  .LBB133_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aq a2, (a0)
; RV64IA-NEXT:    and a3, a2, a1
; RV64IA-NEXT:    not a3, a3
; RV64IA-NEXT:    sc.w.rl a3, a3, (a0)
; RV64IA-NEXT:    bnez a3, .LBB133_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    mv a0, a2
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand i32* %a, i32 %b acq_rel
  ret i32 %1
}

define i32 @atomicrmw_nand_i32_seq_cst(i32* %a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i32_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 5
; RV32I-NEXT:    call __atomic_fetch_nand_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i32_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:  .LBB134_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a2, (a0)
; RV32IA-NEXT:    and a3, a2, a1
; RV32IA-NEXT:    not a3, a3
; RV32IA-NEXT:    sc.w.aqrl a3, a3, (a0)
; RV32IA-NEXT:    bnez a3, .LBB134_1
; RV32IA-NEXT:  # %bb.2:
; RV32IA-NEXT:    mv a0, a2
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i32_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_fetch_nand_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i32_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:  .LBB134_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.w.aqrl a2, (a0)
; RV64IA-NEXT:    and a3, a2, a1
; RV64IA-NEXT:    not a3, a3
; RV64IA-NEXT:    sc.w.aqrl a3, a3, (a0)
; RV64IA-NEXT:    bnez a3, .LBB134_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    mv a0, a2
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand i32* %a, i32 %b seq_cst
  ret i32 %1
}

define i32 @atomicrmw_or_i32_monotonic(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i32_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a2, zero
; RV32I-NEXT:    call __atomic_fetch_or_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i32_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoor.w a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i32_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_fetch_or_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_or_i32_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoor.w a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw or i32* %a, i32 %b monotonic
  ret i32 %1
}

define i32 @atomicrmw_or_i32_acquire(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i32_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 2
; RV32I-NEXT:    call __atomic_fetch_or_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i32_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoor.w.aq a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i32_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_fetch_or_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_or_i32_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoor.w.aq a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw or i32* %a, i32 %b acquire
  ret i32 %1
}

define i32 @atomicrmw_or_i32_release(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i32_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 3
; RV32I-NEXT:    call __atomic_fetch_or_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i32_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoor.w.rl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i32_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_fetch_or_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_or_i32_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoor.w.rl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw or i32* %a, i32 %b release
  ret i32 %1
}

define i32 @atomicrmw_or_i32_acq_rel(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i32_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 4
; RV32I-NEXT:    call __atomic_fetch_or_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i32_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoor.w.aqrl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i32_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_fetch_or_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_or_i32_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoor.w.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw or i32* %a, i32 %b acq_rel
  ret i32 %1
}

define i32 @atomicrmw_or_i32_seq_cst(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i32_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 5
; RV32I-NEXT:    call __atomic_fetch_or_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i32_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoor.w.aqrl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i32_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_fetch_or_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_or_i32_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoor.w.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw or i32* %a, i32 %b seq_cst
  ret i32 %1
}

define i32 @atomicrmw_xor_i32_monotonic(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i32_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a2, zero
; RV32I-NEXT:    call __atomic_fetch_xor_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i32_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoxor.w a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i32_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_fetch_xor_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xor_i32_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoxor.w a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw xor i32* %a, i32 %b monotonic
  ret i32 %1
}

define i32 @atomicrmw_xor_i32_acquire(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i32_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 2
; RV32I-NEXT:    call __atomic_fetch_xor_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i32_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoxor.w.aq a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i32_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_fetch_xor_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xor_i32_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoxor.w.aq a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw xor i32* %a, i32 %b acquire
  ret i32 %1
}

define i32 @atomicrmw_xor_i32_release(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i32_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 3
; RV32I-NEXT:    call __atomic_fetch_xor_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i32_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoxor.w.rl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i32_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_fetch_xor_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xor_i32_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoxor.w.rl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw xor i32* %a, i32 %b release
  ret i32 %1
}

define i32 @atomicrmw_xor_i32_acq_rel(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i32_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 4
; RV32I-NEXT:    call __atomic_fetch_xor_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i32_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoxor.w.aqrl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i32_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_fetch_xor_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xor_i32_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoxor.w.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw xor i32* %a, i32 %b acq_rel
  ret i32 %1
}

define i32 @atomicrmw_xor_i32_seq_cst(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i32_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a2, zero, 5
; RV32I-NEXT:    call __atomic_fetch_xor_4@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i32_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amoxor.w.aqrl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i32_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_fetch_xor_4@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xor_i32_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoxor.w.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw xor i32* %a, i32 %b seq_cst
  ret i32 %1
}

define i32 @atomicrmw_max_i32_monotonic(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i32_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB145_2
; RV32I-NEXT:  .LBB145_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB145_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a3, zero
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    call __atomic_compare_exchange_4@plt
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB145_4
; RV32I-NEXT:  .LBB145_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s1, a3, .LBB145_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB145_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB145_1
; RV32I-NEXT:  .LBB145_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i32_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amomax.w a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i32_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lwu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    sext.w s1, a1
; RV64I-NEXT:    j .LBB145_2
; RV64I-NEXT:  .LBB145_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB145_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a3, zero
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_4@plt
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB145_4
; RV64I-NEXT:  .LBB145_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    sext.w a0, a3
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s1, a0, .LBB145_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB145_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB145_1
; RV64I-NEXT:  .LBB145_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_max_i32_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomax.w a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw max i32* %a, i32 %b monotonic
  ret i32 %1
}

define i32 @atomicrmw_max_i32_acquire(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i32_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB146_2
; RV32I-NEXT:  .LBB146_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB146_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    addi a3, zero, 2
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_4@plt
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB146_4
; RV32I-NEXT:  .LBB146_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s1, a3, .LBB146_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB146_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB146_1
; RV32I-NEXT:  .LBB146_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i32_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amomax.w.aq a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i32_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lwu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    sext.w s1, a1
; RV64I-NEXT:    j .LBB146_2
; RV64I-NEXT:  .LBB146_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB146_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    addi a3, zero, 2
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_4@plt
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB146_4
; RV64I-NEXT:  .LBB146_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    sext.w a0, a3
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s1, a0, .LBB146_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB146_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB146_1
; RV64I-NEXT:  .LBB146_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_max_i32_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomax.w.aq a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw max i32* %a, i32 %b acquire
  ret i32 %1
}

define i32 @atomicrmw_max_i32_release(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i32_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB147_2
; RV32I-NEXT:  .LBB147_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB147_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    addi a3, zero, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    call __atomic_compare_exchange_4@plt
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB147_4
; RV32I-NEXT:  .LBB147_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s1, a3, .LBB147_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB147_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB147_1
; RV32I-NEXT:  .LBB147_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i32_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amomax.w.rl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i32_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lwu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    sext.w s1, a1
; RV64I-NEXT:    j .LBB147_2
; RV64I-NEXT:  .LBB147_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB147_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    addi a3, zero, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_4@plt
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB147_4
; RV64I-NEXT:  .LBB147_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    sext.w a0, a3
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s1, a0, .LBB147_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB147_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB147_1
; RV64I-NEXT:  .LBB147_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_max_i32_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomax.w.rl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw max i32* %a, i32 %b release
  ret i32 %1
}

define i32 @atomicrmw_max_i32_acq_rel(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i32_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB148_2
; RV32I-NEXT:  .LBB148_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB148_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    addi a3, zero, 4
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_4@plt
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB148_4
; RV32I-NEXT:  .LBB148_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s1, a3, .LBB148_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB148_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB148_1
; RV32I-NEXT:  .LBB148_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i32_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amomax.w.aqrl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i32_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lwu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    sext.w s1, a1
; RV64I-NEXT:    j .LBB148_2
; RV64I-NEXT:  .LBB148_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB148_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    addi a3, zero, 4
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_4@plt
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB148_4
; RV64I-NEXT:  .LBB148_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    sext.w a0, a3
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s1, a0, .LBB148_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB148_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB148_1
; RV64I-NEXT:  .LBB148_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_max_i32_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomax.w.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw max i32* %a, i32 %b acq_rel
  ret i32 %1
}

define i32 @atomicrmw_max_i32_seq_cst(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i32_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB149_2
; RV32I-NEXT:  .LBB149_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB149_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    addi a3, zero, 5
; RV32I-NEXT:    addi a4, zero, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_4@plt
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB149_4
; RV32I-NEXT:  .LBB149_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    blt s1, a3, .LBB149_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB149_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB149_1
; RV32I-NEXT:  .LBB149_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i32_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amomax.w.aqrl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i32_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lwu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    sext.w s1, a1
; RV64I-NEXT:    j .LBB149_2
; RV64I-NEXT:  .LBB149_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB149_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    addi a3, zero, 5
; RV64I-NEXT:    addi a4, zero, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_4@plt
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB149_4
; RV64I-NEXT:  .LBB149_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    sext.w a0, a3
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s1, a0, .LBB149_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB149_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB149_1
; RV64I-NEXT:  .LBB149_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_max_i32_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomax.w.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw max i32* %a, i32 %b seq_cst
  ret i32 %1
}

define i32 @atomicrmw_min_i32_monotonic(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i32_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB150_2
; RV32I-NEXT:  .LBB150_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB150_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a3, zero
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    call __atomic_compare_exchange_4@plt
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB150_4
; RV32I-NEXT:  .LBB150_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s1, a3, .LBB150_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB150_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB150_1
; RV32I-NEXT:  .LBB150_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i32_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amomin.w a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i32_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lwu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    sext.w s1, a1
; RV64I-NEXT:    j .LBB150_2
; RV64I-NEXT:  .LBB150_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB150_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a3, zero
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_4@plt
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB150_4
; RV64I-NEXT:  .LBB150_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    sext.w a0, a3
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s1, a0, .LBB150_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB150_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB150_1
; RV64I-NEXT:  .LBB150_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_min_i32_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomin.w a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw min i32* %a, i32 %b monotonic
  ret i32 %1
}

define i32 @atomicrmw_min_i32_acquire(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i32_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB151_2
; RV32I-NEXT:  .LBB151_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB151_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    addi a3, zero, 2
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_4@plt
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB151_4
; RV32I-NEXT:  .LBB151_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s1, a3, .LBB151_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB151_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB151_1
; RV32I-NEXT:  .LBB151_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i32_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amomin.w.aq a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i32_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lwu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    sext.w s1, a1
; RV64I-NEXT:    j .LBB151_2
; RV64I-NEXT:  .LBB151_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB151_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    addi a3, zero, 2
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_4@plt
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB151_4
; RV64I-NEXT:  .LBB151_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    sext.w a0, a3
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s1, a0, .LBB151_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB151_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB151_1
; RV64I-NEXT:  .LBB151_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_min_i32_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomin.w.aq a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw min i32* %a, i32 %b acquire
  ret i32 %1
}

define i32 @atomicrmw_min_i32_release(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i32_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB152_2
; RV32I-NEXT:  .LBB152_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB152_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    addi a3, zero, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    call __atomic_compare_exchange_4@plt
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB152_4
; RV32I-NEXT:  .LBB152_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s1, a3, .LBB152_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB152_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB152_1
; RV32I-NEXT:  .LBB152_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i32_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amomin.w.rl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i32_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lwu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    sext.w s1, a1
; RV64I-NEXT:    j .LBB152_2
; RV64I-NEXT:  .LBB152_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB152_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    addi a3, zero, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_4@plt
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB152_4
; RV64I-NEXT:  .LBB152_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    sext.w a0, a3
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s1, a0, .LBB152_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB152_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB152_1
; RV64I-NEXT:  .LBB152_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_min_i32_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomin.w.rl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw min i32* %a, i32 %b release
  ret i32 %1
}

define i32 @atomicrmw_min_i32_acq_rel(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i32_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB153_2
; RV32I-NEXT:  .LBB153_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB153_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    addi a3, zero, 4
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_4@plt
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB153_4
; RV32I-NEXT:  .LBB153_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s1, a3, .LBB153_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB153_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB153_1
; RV32I-NEXT:  .LBB153_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i32_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amomin.w.aqrl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i32_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lwu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    sext.w s1, a1
; RV64I-NEXT:    j .LBB153_2
; RV64I-NEXT:  .LBB153_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB153_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    addi a3, zero, 4
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_4@plt
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB153_4
; RV64I-NEXT:  .LBB153_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    sext.w a0, a3
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s1, a0, .LBB153_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB153_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB153_1
; RV64I-NEXT:  .LBB153_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_min_i32_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomin.w.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw min i32* %a, i32 %b acq_rel
  ret i32 %1
}

define i32 @atomicrmw_min_i32_seq_cst(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i32_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB154_2
; RV32I-NEXT:  .LBB154_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB154_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    addi a3, zero, 5
; RV32I-NEXT:    addi a4, zero, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_4@plt
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB154_4
; RV32I-NEXT:  .LBB154_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bge s1, a3, .LBB154_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB154_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB154_1
; RV32I-NEXT:  .LBB154_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i32_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amomin.w.aqrl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i32_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lwu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    sext.w s1, a1
; RV64I-NEXT:    j .LBB154_2
; RV64I-NEXT:  .LBB154_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB154_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    addi a3, zero, 5
; RV64I-NEXT:    addi a4, zero, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_4@plt
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB154_4
; RV64I-NEXT:  .LBB154_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    sext.w a0, a3
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s1, a0, .LBB154_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB154_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB154_1
; RV64I-NEXT:  .LBB154_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_min_i32_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomin.w.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw min i32* %a, i32 %b seq_cst
  ret i32 %1
}

define i32 @atomicrmw_umax_i32_monotonic(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i32_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB155_2
; RV32I-NEXT:  .LBB155_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB155_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a3, zero
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    call __atomic_compare_exchange_4@plt
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB155_4
; RV32I-NEXT:  .LBB155_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bltu s1, a3, .LBB155_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB155_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB155_1
; RV32I-NEXT:  .LBB155_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i32_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amomaxu.w a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i32_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lwu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    sext.w s1, a1
; RV64I-NEXT:    j .LBB155_2
; RV64I-NEXT:  .LBB155_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB155_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a3, zero
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_4@plt
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB155_4
; RV64I-NEXT:  .LBB155_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    sext.w a0, a3
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s1, a0, .LBB155_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB155_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB155_1
; RV64I-NEXT:  .LBB155_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umax_i32_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomaxu.w a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw umax i32* %a, i32 %b monotonic
  ret i32 %1
}

define i32 @atomicrmw_umax_i32_acquire(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i32_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB156_2
; RV32I-NEXT:  .LBB156_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB156_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    addi a3, zero, 2
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_4@plt
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB156_4
; RV32I-NEXT:  .LBB156_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bltu s1, a3, .LBB156_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB156_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB156_1
; RV32I-NEXT:  .LBB156_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i32_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amomaxu.w.aq a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i32_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lwu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    sext.w s1, a1
; RV64I-NEXT:    j .LBB156_2
; RV64I-NEXT:  .LBB156_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB156_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    addi a3, zero, 2
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_4@plt
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB156_4
; RV64I-NEXT:  .LBB156_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    sext.w a0, a3
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s1, a0, .LBB156_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB156_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB156_1
; RV64I-NEXT:  .LBB156_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umax_i32_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomaxu.w.aq a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw umax i32* %a, i32 %b acquire
  ret i32 %1
}

define i32 @atomicrmw_umax_i32_release(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i32_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB157_2
; RV32I-NEXT:  .LBB157_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB157_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    addi a3, zero, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    call __atomic_compare_exchange_4@plt
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB157_4
; RV32I-NEXT:  .LBB157_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bltu s1, a3, .LBB157_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB157_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB157_1
; RV32I-NEXT:  .LBB157_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i32_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amomaxu.w.rl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i32_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lwu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    sext.w s1, a1
; RV64I-NEXT:    j .LBB157_2
; RV64I-NEXT:  .LBB157_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB157_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    addi a3, zero, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_4@plt
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB157_4
; RV64I-NEXT:  .LBB157_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    sext.w a0, a3
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s1, a0, .LBB157_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB157_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB157_1
; RV64I-NEXT:  .LBB157_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umax_i32_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomaxu.w.rl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw umax i32* %a, i32 %b release
  ret i32 %1
}

define i32 @atomicrmw_umax_i32_acq_rel(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i32_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB158_2
; RV32I-NEXT:  .LBB158_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB158_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    addi a3, zero, 4
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_4@plt
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB158_4
; RV32I-NEXT:  .LBB158_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bltu s1, a3, .LBB158_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB158_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB158_1
; RV32I-NEXT:  .LBB158_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i32_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amomaxu.w.aqrl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i32_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lwu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    sext.w s1, a1
; RV64I-NEXT:    j .LBB158_2
; RV64I-NEXT:  .LBB158_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB158_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    addi a3, zero, 4
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_4@plt
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB158_4
; RV64I-NEXT:  .LBB158_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    sext.w a0, a3
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s1, a0, .LBB158_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB158_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB158_1
; RV64I-NEXT:  .LBB158_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umax_i32_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomaxu.w.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw umax i32* %a, i32 %b acq_rel
  ret i32 %1
}

define i32 @atomicrmw_umax_i32_seq_cst(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i32_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB159_2
; RV32I-NEXT:  .LBB159_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB159_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    addi a3, zero, 5
; RV32I-NEXT:    addi a4, zero, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_4@plt
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB159_4
; RV32I-NEXT:  .LBB159_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bltu s1, a3, .LBB159_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB159_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB159_1
; RV32I-NEXT:  .LBB159_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i32_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amomaxu.w.aqrl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i32_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lwu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    sext.w s1, a1
; RV64I-NEXT:    j .LBB159_2
; RV64I-NEXT:  .LBB159_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB159_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    addi a3, zero, 5
; RV64I-NEXT:    addi a4, zero, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_4@plt
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB159_4
; RV64I-NEXT:  .LBB159_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    sext.w a0, a3
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s1, a0, .LBB159_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB159_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB159_1
; RV64I-NEXT:  .LBB159_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umax_i32_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomaxu.w.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw umax i32* %a, i32 %b seq_cst
  ret i32 %1
}

define i32 @atomicrmw_umin_i32_monotonic(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i32_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB160_2
; RV32I-NEXT:  .LBB160_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB160_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a3, zero
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    call __atomic_compare_exchange_4@plt
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB160_4
; RV32I-NEXT:  .LBB160_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bgeu s1, a3, .LBB160_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB160_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB160_1
; RV32I-NEXT:  .LBB160_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i32_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amominu.w a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i32_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lwu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    sext.w s1, a1
; RV64I-NEXT:    j .LBB160_2
; RV64I-NEXT:  .LBB160_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB160_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a3, zero
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_4@plt
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB160_4
; RV64I-NEXT:  .LBB160_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    sext.w a0, a3
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s1, a0, .LBB160_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB160_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB160_1
; RV64I-NEXT:  .LBB160_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umin_i32_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amominu.w a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw umin i32* %a, i32 %b monotonic
  ret i32 %1
}

define i32 @atomicrmw_umin_i32_acquire(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i32_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB161_2
; RV32I-NEXT:  .LBB161_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB161_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    addi a3, zero, 2
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_4@plt
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB161_4
; RV32I-NEXT:  .LBB161_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bgeu s1, a3, .LBB161_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB161_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB161_1
; RV32I-NEXT:  .LBB161_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i32_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amominu.w.aq a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i32_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lwu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    sext.w s1, a1
; RV64I-NEXT:    j .LBB161_2
; RV64I-NEXT:  .LBB161_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB161_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    addi a3, zero, 2
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_4@plt
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB161_4
; RV64I-NEXT:  .LBB161_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    sext.w a0, a3
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s1, a0, .LBB161_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB161_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB161_1
; RV64I-NEXT:  .LBB161_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umin_i32_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amominu.w.aq a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw umin i32* %a, i32 %b acquire
  ret i32 %1
}

define i32 @atomicrmw_umin_i32_release(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i32_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB162_2
; RV32I-NEXT:  .LBB162_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB162_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    addi a3, zero, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    call __atomic_compare_exchange_4@plt
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB162_4
; RV32I-NEXT:  .LBB162_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bgeu s1, a3, .LBB162_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB162_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB162_1
; RV32I-NEXT:  .LBB162_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i32_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amominu.w.rl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i32_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lwu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    sext.w s1, a1
; RV64I-NEXT:    j .LBB162_2
; RV64I-NEXT:  .LBB162_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB162_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    addi a3, zero, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_4@plt
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB162_4
; RV64I-NEXT:  .LBB162_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    sext.w a0, a3
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s1, a0, .LBB162_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB162_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB162_1
; RV64I-NEXT:  .LBB162_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umin_i32_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amominu.w.rl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw umin i32* %a, i32 %b release
  ret i32 %1
}

define i32 @atomicrmw_umin_i32_acq_rel(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i32_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB163_2
; RV32I-NEXT:  .LBB163_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB163_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    addi a3, zero, 4
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_4@plt
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB163_4
; RV32I-NEXT:  .LBB163_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bgeu s1, a3, .LBB163_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB163_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB163_1
; RV32I-NEXT:  .LBB163_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i32_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amominu.w.aqrl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i32_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lwu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    sext.w s1, a1
; RV64I-NEXT:    j .LBB163_2
; RV64I-NEXT:  .LBB163_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB163_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    addi a3, zero, 4
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_4@plt
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB163_4
; RV64I-NEXT:  .LBB163_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    sext.w a0, a3
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s1, a0, .LBB163_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB163_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB163_1
; RV64I-NEXT:  .LBB163_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umin_i32_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amominu.w.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw umin i32* %a, i32 %b acq_rel
  ret i32 %1
}

define i32 @atomicrmw_umin_i32_seq_cst(i32 *%a, i32 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i32_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a3, 0(a0)
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    j .LBB164_2
; RV32I-NEXT:  .LBB164_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB164_2 Depth=1
; RV32I-NEXT:    sw a3, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    addi a3, zero, 5
; RV32I-NEXT:    addi a4, zero, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_4@plt
; RV32I-NEXT:    lw a3, 0(sp)
; RV32I-NEXT:    bnez a0, .LBB164_4
; RV32I-NEXT:  .LBB164_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    bgeu s1, a3, .LBB164_1
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB164_2 Depth=1
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    j .LBB164_1
; RV32I-NEXT:  .LBB164_4: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a3
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i32_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    amominu.w.aqrl a0, a1, (a0)
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i32_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lwu a3, 0(a0)
; RV64I-NEXT:    mv s2, a1
; RV64I-NEXT:    sext.w s1, a1
; RV64I-NEXT:    j .LBB164_2
; RV64I-NEXT:  .LBB164_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB164_2 Depth=1
; RV64I-NEXT:    sw a3, 12(sp)
; RV64I-NEXT:    addi a1, sp, 12
; RV64I-NEXT:    addi a3, zero, 5
; RV64I-NEXT:    addi a4, zero, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_4@plt
; RV64I-NEXT:    lw a3, 12(sp)
; RV64I-NEXT:    bnez a0, .LBB164_4
; RV64I-NEXT:  .LBB164_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    sext.w a0, a3
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s1, a0, .LBB164_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB164_2 Depth=1
; RV64I-NEXT:    mv a2, s2
; RV64I-NEXT:    j .LBB164_1
; RV64I-NEXT:  .LBB164_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umin_i32_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amominu.w.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw umin i32* %a, i32 %b seq_cst
  ret i32 %1
}

define i64 @atomicrmw_xchg_i64_monotonic(i64* %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i64_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a3, zero
; RV32I-NEXT:    call __atomic_exchange_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i64_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv a3, zero
; RV32IA-NEXT:    call __atomic_exchange_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i64_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_exchange_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_i64_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoswap.d a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg i64* %a, i64 %b monotonic
  ret i64 %1
}

define i64 @atomicrmw_xchg_i64_acquire(i64* %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i64_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 2
; RV32I-NEXT:    call __atomic_exchange_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i64_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 2
; RV32IA-NEXT:    call __atomic_exchange_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i64_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_exchange_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_i64_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoswap.d.aq a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg i64* %a, i64 %b acquire
  ret i64 %1
}

define i64 @atomicrmw_xchg_i64_release(i64* %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i64_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 3
; RV32I-NEXT:    call __atomic_exchange_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i64_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 3
; RV32IA-NEXT:    call __atomic_exchange_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i64_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_exchange_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_i64_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoswap.d.rl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg i64* %a, i64 %b release
  ret i64 %1
}

define i64 @atomicrmw_xchg_i64_acq_rel(i64* %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i64_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 4
; RV32I-NEXT:    call __atomic_exchange_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i64_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 4
; RV32IA-NEXT:    call __atomic_exchange_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i64_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_exchange_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_i64_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoswap.d.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg i64* %a, i64 %b acq_rel
  ret i64 %1
}

define i64 @atomicrmw_xchg_i64_seq_cst(i64* %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_xchg_i64_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 5
; RV32I-NEXT:    call __atomic_exchange_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xchg_i64_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 5
; RV32IA-NEXT:    call __atomic_exchange_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xchg_i64_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_exchange_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xchg_i64_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoswap.d.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw xchg i64* %a, i64 %b seq_cst
  ret i64 %1
}

define i64 @atomicrmw_add_i64_monotonic(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i64_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a3, zero
; RV32I-NEXT:    call __atomic_fetch_add_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i64_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv a3, zero
; RV32IA-NEXT:    call __atomic_fetch_add_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i64_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_fetch_add_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_add_i64_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoadd.d a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw add i64* %a, i64 %b monotonic
  ret i64 %1
}

define i64 @atomicrmw_add_i64_acquire(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i64_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 2
; RV32I-NEXT:    call __atomic_fetch_add_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i64_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 2
; RV32IA-NEXT:    call __atomic_fetch_add_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i64_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_fetch_add_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_add_i64_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoadd.d.aq a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw add i64* %a, i64 %b acquire
  ret i64 %1
}

define i64 @atomicrmw_add_i64_release(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i64_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 3
; RV32I-NEXT:    call __atomic_fetch_add_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i64_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 3
; RV32IA-NEXT:    call __atomic_fetch_add_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i64_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_fetch_add_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_add_i64_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoadd.d.rl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw add i64* %a, i64 %b release
  ret i64 %1
}

define i64 @atomicrmw_add_i64_acq_rel(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i64_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 4
; RV32I-NEXT:    call __atomic_fetch_add_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i64_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 4
; RV32IA-NEXT:    call __atomic_fetch_add_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i64_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_fetch_add_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_add_i64_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoadd.d.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw add i64* %a, i64 %b acq_rel
  ret i64 %1
}

define i64 @atomicrmw_add_i64_seq_cst(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_add_i64_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 5
; RV32I-NEXT:    call __atomic_fetch_add_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_add_i64_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 5
; RV32IA-NEXT:    call __atomic_fetch_add_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_add_i64_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_fetch_add_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_add_i64_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoadd.d.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw add i64* %a, i64 %b seq_cst
  ret i64 %1
}

define i64 @atomicrmw_sub_i64_monotonic(i64* %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i64_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a3, zero
; RV32I-NEXT:    call __atomic_fetch_sub_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i64_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv a3, zero
; RV32IA-NEXT:    call __atomic_fetch_sub_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i64_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_fetch_sub_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_sub_i64_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    neg a1, a1
; RV64IA-NEXT:    amoadd.d a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw sub i64* %a, i64 %b monotonic
  ret i64 %1
}

define i64 @atomicrmw_sub_i64_acquire(i64* %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i64_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 2
; RV32I-NEXT:    call __atomic_fetch_sub_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i64_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 2
; RV32IA-NEXT:    call __atomic_fetch_sub_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i64_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_fetch_sub_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_sub_i64_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    neg a1, a1
; RV64IA-NEXT:    amoadd.d.aq a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw sub i64* %a, i64 %b acquire
  ret i64 %1
}

define i64 @atomicrmw_sub_i64_release(i64* %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i64_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 3
; RV32I-NEXT:    call __atomic_fetch_sub_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i64_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 3
; RV32IA-NEXT:    call __atomic_fetch_sub_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i64_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_fetch_sub_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_sub_i64_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    neg a1, a1
; RV64IA-NEXT:    amoadd.d.rl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw sub i64* %a, i64 %b release
  ret i64 %1
}

define i64 @atomicrmw_sub_i64_acq_rel(i64* %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i64_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 4
; RV32I-NEXT:    call __atomic_fetch_sub_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i64_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 4
; RV32IA-NEXT:    call __atomic_fetch_sub_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i64_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_fetch_sub_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_sub_i64_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    neg a1, a1
; RV64IA-NEXT:    amoadd.d.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw sub i64* %a, i64 %b acq_rel
  ret i64 %1
}

define i64 @atomicrmw_sub_i64_seq_cst(i64* %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_sub_i64_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 5
; RV32I-NEXT:    call __atomic_fetch_sub_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_sub_i64_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 5
; RV32IA-NEXT:    call __atomic_fetch_sub_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_sub_i64_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_fetch_sub_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_sub_i64_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    neg a1, a1
; RV64IA-NEXT:    amoadd.d.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw sub i64* %a, i64 %b seq_cst
  ret i64 %1
}

define i64 @atomicrmw_and_i64_monotonic(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i64_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a3, zero
; RV32I-NEXT:    call __atomic_fetch_and_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i64_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv a3, zero
; RV32IA-NEXT:    call __atomic_fetch_and_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i64_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_fetch_and_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_and_i64_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoand.d a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw and i64* %a, i64 %b monotonic
  ret i64 %1
}

define i64 @atomicrmw_and_i64_acquire(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i64_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 2
; RV32I-NEXT:    call __atomic_fetch_and_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i64_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 2
; RV32IA-NEXT:    call __atomic_fetch_and_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i64_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_fetch_and_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_and_i64_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoand.d.aq a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw and i64* %a, i64 %b acquire
  ret i64 %1
}

define i64 @atomicrmw_and_i64_release(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i64_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 3
; RV32I-NEXT:    call __atomic_fetch_and_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i64_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 3
; RV32IA-NEXT:    call __atomic_fetch_and_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i64_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_fetch_and_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_and_i64_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoand.d.rl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw and i64* %a, i64 %b release
  ret i64 %1
}

define i64 @atomicrmw_and_i64_acq_rel(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i64_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 4
; RV32I-NEXT:    call __atomic_fetch_and_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i64_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 4
; RV32IA-NEXT:    call __atomic_fetch_and_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i64_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_fetch_and_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_and_i64_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoand.d.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw and i64* %a, i64 %b acq_rel
  ret i64 %1
}

define i64 @atomicrmw_and_i64_seq_cst(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_and_i64_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 5
; RV32I-NEXT:    call __atomic_fetch_and_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_and_i64_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 5
; RV32IA-NEXT:    call __atomic_fetch_and_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_and_i64_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_fetch_and_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_and_i64_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoand.d.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw and i64* %a, i64 %b seq_cst
  ret i64 %1
}

define i64 @atomicrmw_nand_i64_monotonic(i64* %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i64_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a3, zero
; RV32I-NEXT:    call __atomic_fetch_nand_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i64_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv a3, zero
; RV32IA-NEXT:    call __atomic_fetch_nand_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i64_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_fetch_nand_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i64_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:  .LBB185_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.d a2, (a0)
; RV64IA-NEXT:    and a3, a2, a1
; RV64IA-NEXT:    not a3, a3
; RV64IA-NEXT:    sc.d a3, a3, (a0)
; RV64IA-NEXT:    bnez a3, .LBB185_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    mv a0, a2
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand i64* %a, i64 %b monotonic
  ret i64 %1
}

define i64 @atomicrmw_nand_i64_acquire(i64* %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i64_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 2
; RV32I-NEXT:    call __atomic_fetch_nand_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i64_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 2
; RV32IA-NEXT:    call __atomic_fetch_nand_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i64_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_fetch_nand_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i64_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:  .LBB186_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.d.aq a2, (a0)
; RV64IA-NEXT:    and a3, a2, a1
; RV64IA-NEXT:    not a3, a3
; RV64IA-NEXT:    sc.d a3, a3, (a0)
; RV64IA-NEXT:    bnez a3, .LBB186_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    mv a0, a2
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand i64* %a, i64 %b acquire
  ret i64 %1
}

define i64 @atomicrmw_nand_i64_release(i64* %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i64_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 3
; RV32I-NEXT:    call __atomic_fetch_nand_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i64_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 3
; RV32IA-NEXT:    call __atomic_fetch_nand_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i64_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_fetch_nand_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i64_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:  .LBB187_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.d a2, (a0)
; RV64IA-NEXT:    and a3, a2, a1
; RV64IA-NEXT:    not a3, a3
; RV64IA-NEXT:    sc.d.rl a3, a3, (a0)
; RV64IA-NEXT:    bnez a3, .LBB187_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    mv a0, a2
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand i64* %a, i64 %b release
  ret i64 %1
}

define i64 @atomicrmw_nand_i64_acq_rel(i64* %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i64_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 4
; RV32I-NEXT:    call __atomic_fetch_nand_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i64_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 4
; RV32IA-NEXT:    call __atomic_fetch_nand_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i64_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_fetch_nand_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i64_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:  .LBB188_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.d.aq a2, (a0)
; RV64IA-NEXT:    and a3, a2, a1
; RV64IA-NEXT:    not a3, a3
; RV64IA-NEXT:    sc.d.rl a3, a3, (a0)
; RV64IA-NEXT:    bnez a3, .LBB188_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    mv a0, a2
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand i64* %a, i64 %b acq_rel
  ret i64 %1
}

define i64 @atomicrmw_nand_i64_seq_cst(i64* %a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_nand_i64_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 5
; RV32I-NEXT:    call __atomic_fetch_nand_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_nand_i64_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 5
; RV32IA-NEXT:    call __atomic_fetch_nand_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_nand_i64_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_fetch_nand_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_nand_i64_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:  .LBB189_1: # =>This Inner Loop Header: Depth=1
; RV64IA-NEXT:    lr.d.aqrl a2, (a0)
; RV64IA-NEXT:    and a3, a2, a1
; RV64IA-NEXT:    not a3, a3
; RV64IA-NEXT:    sc.d.aqrl a3, a3, (a0)
; RV64IA-NEXT:    bnez a3, .LBB189_1
; RV64IA-NEXT:  # %bb.2:
; RV64IA-NEXT:    mv a0, a2
; RV64IA-NEXT:    ret
  %1 = atomicrmw nand i64* %a, i64 %b seq_cst
  ret i64 %1
}

define i64 @atomicrmw_or_i64_monotonic(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i64_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a3, zero
; RV32I-NEXT:    call __atomic_fetch_or_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i64_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv a3, zero
; RV32IA-NEXT:    call __atomic_fetch_or_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i64_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_fetch_or_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_or_i64_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoor.d a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw or i64* %a, i64 %b monotonic
  ret i64 %1
}

define i64 @atomicrmw_or_i64_acquire(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i64_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 2
; RV32I-NEXT:    call __atomic_fetch_or_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i64_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 2
; RV32IA-NEXT:    call __atomic_fetch_or_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i64_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_fetch_or_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_or_i64_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoor.d.aq a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw or i64* %a, i64 %b acquire
  ret i64 %1
}

define i64 @atomicrmw_or_i64_release(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i64_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 3
; RV32I-NEXT:    call __atomic_fetch_or_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i64_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 3
; RV32IA-NEXT:    call __atomic_fetch_or_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i64_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_fetch_or_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_or_i64_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoor.d.rl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw or i64* %a, i64 %b release
  ret i64 %1
}

define i64 @atomicrmw_or_i64_acq_rel(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i64_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 4
; RV32I-NEXT:    call __atomic_fetch_or_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i64_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 4
; RV32IA-NEXT:    call __atomic_fetch_or_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i64_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_fetch_or_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_or_i64_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoor.d.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw or i64* %a, i64 %b acq_rel
  ret i64 %1
}

define i64 @atomicrmw_or_i64_seq_cst(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_or_i64_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 5
; RV32I-NEXT:    call __atomic_fetch_or_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_or_i64_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 5
; RV32IA-NEXT:    call __atomic_fetch_or_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_or_i64_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_fetch_or_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_or_i64_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoor.d.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw or i64* %a, i64 %b seq_cst
  ret i64 %1
}

define i64 @atomicrmw_xor_i64_monotonic(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i64_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a3, zero
; RV32I-NEXT:    call __atomic_fetch_xor_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i64_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv a3, zero
; RV32IA-NEXT:    call __atomic_fetch_xor_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i64_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a2, zero
; RV64I-NEXT:    call __atomic_fetch_xor_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xor_i64_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoxor.d a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw xor i64* %a, i64 %b monotonic
  ret i64 %1
}

define i64 @atomicrmw_xor_i64_acquire(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i64_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 2
; RV32I-NEXT:    call __atomic_fetch_xor_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i64_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 2
; RV32IA-NEXT:    call __atomic_fetch_xor_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i64_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 2
; RV64I-NEXT:    call __atomic_fetch_xor_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xor_i64_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoxor.d.aq a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw xor i64* %a, i64 %b acquire
  ret i64 %1
}

define i64 @atomicrmw_xor_i64_release(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i64_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 3
; RV32I-NEXT:    call __atomic_fetch_xor_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i64_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 3
; RV32IA-NEXT:    call __atomic_fetch_xor_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i64_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 3
; RV64I-NEXT:    call __atomic_fetch_xor_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xor_i64_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoxor.d.rl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw xor i64* %a, i64 %b release
  ret i64 %1
}

define i64 @atomicrmw_xor_i64_acq_rel(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i64_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 4
; RV32I-NEXT:    call __atomic_fetch_xor_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i64_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 4
; RV32IA-NEXT:    call __atomic_fetch_xor_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i64_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 4
; RV64I-NEXT:    call __atomic_fetch_xor_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xor_i64_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoxor.d.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw xor i64* %a, i64 %b acq_rel
  ret i64 %1
}

define i64 @atomicrmw_xor_i64_seq_cst(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_xor_i64_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a3, zero, 5
; RV32I-NEXT:    call __atomic_fetch_xor_8@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_xor_i64_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    addi a3, zero, 5
; RV32IA-NEXT:    call __atomic_fetch_xor_8@plt
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_xor_i64_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a2, zero, 5
; RV64I-NEXT:    call __atomic_fetch_xor_8@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_xor_i64_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amoxor.d.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw xor i64* %a, i64 %b seq_cst
  ret i64 %1
}

define i64 @atomicrmw_max_i64_monotonic(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i64_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB200_2
; RV32I-NEXT:  .LBB200_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB200_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    mv a5, zero
; RV32I-NEXT:    call __atomic_compare_exchange_8@plt
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB200_7
; RV32I-NEXT:  .LBB200_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB200_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB200_2 Depth=1
; RV32I-NEXT:    slt a0, s1, a5
; RV32I-NEXT:    j .LBB200_5
; RV32I-NEXT:  .LBB200_4: # in Loop: Header=BB200_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB200_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB200_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB200_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB200_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB200_1
; RV32I-NEXT:  .LBB200_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i64_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB200_2
; RV32IA-NEXT:  .LBB200_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB200_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    mv a4, zero
; RV32IA-NEXT:    mv a5, zero
; RV32IA-NEXT:    call __atomic_compare_exchange_8@plt
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB200_7
; RV32IA-NEXT:  .LBB200_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB200_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB200_2 Depth=1
; RV32IA-NEXT:    slt a0, s1, a5
; RV32IA-NEXT:    j .LBB200_5
; RV32IA-NEXT:  .LBB200_4: # in Loop: Header=BB200_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB200_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB200_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB200_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB200_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB200_1
; RV32IA-NEXT:  .LBB200_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i64_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB200_2
; RV64I-NEXT:  .LBB200_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB200_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a3, zero
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_8@plt
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB200_4
; RV64I-NEXT:  .LBB200_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s1, a3, .LBB200_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB200_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB200_1
; RV64I-NEXT:  .LBB200_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_max_i64_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomax.d a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw max i64* %a, i64 %b monotonic
  ret i64 %1
}

define i64 @atomicrmw_max_i64_acquire(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i64_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB201_2
; RV32I-NEXT:  .LBB201_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB201_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    addi a5, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_8@plt
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB201_7
; RV32I-NEXT:  .LBB201_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB201_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB201_2 Depth=1
; RV32I-NEXT:    slt a0, s1, a5
; RV32I-NEXT:    j .LBB201_5
; RV32I-NEXT:  .LBB201_4: # in Loop: Header=BB201_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB201_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB201_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB201_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB201_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB201_1
; RV32I-NEXT:  .LBB201_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i64_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB201_2
; RV32IA-NEXT:  .LBB201_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB201_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    addi a4, zero, 2
; RV32IA-NEXT:    addi a5, zero, 2
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    call __atomic_compare_exchange_8@plt
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB201_7
; RV32IA-NEXT:  .LBB201_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB201_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB201_2 Depth=1
; RV32IA-NEXT:    slt a0, s1, a5
; RV32IA-NEXT:    j .LBB201_5
; RV32IA-NEXT:  .LBB201_4: # in Loop: Header=BB201_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB201_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB201_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB201_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB201_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB201_1
; RV32IA-NEXT:  .LBB201_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i64_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB201_2
; RV64I-NEXT:  .LBB201_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB201_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    addi a3, zero, 2
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_8@plt
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB201_4
; RV64I-NEXT:  .LBB201_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s1, a3, .LBB201_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB201_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB201_1
; RV64I-NEXT:  .LBB201_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_max_i64_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomax.d.aq a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw max i64* %a, i64 %b acquire
  ret i64 %1
}

define i64 @atomicrmw_max_i64_release(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i64_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB202_2
; RV32I-NEXT:  .LBB202_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB202_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    addi a4, zero, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a5, zero
; RV32I-NEXT:    call __atomic_compare_exchange_8@plt
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB202_7
; RV32I-NEXT:  .LBB202_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB202_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB202_2 Depth=1
; RV32I-NEXT:    slt a0, s1, a5
; RV32I-NEXT:    j .LBB202_5
; RV32I-NEXT:  .LBB202_4: # in Loop: Header=BB202_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB202_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB202_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB202_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB202_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB202_1
; RV32I-NEXT:  .LBB202_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i64_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB202_2
; RV32IA-NEXT:  .LBB202_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB202_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    addi a4, zero, 3
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    mv a5, zero
; RV32IA-NEXT:    call __atomic_compare_exchange_8@plt
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB202_7
; RV32IA-NEXT:  .LBB202_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB202_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB202_2 Depth=1
; RV32IA-NEXT:    slt a0, s1, a5
; RV32IA-NEXT:    j .LBB202_5
; RV32IA-NEXT:  .LBB202_4: # in Loop: Header=BB202_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB202_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB202_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB202_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB202_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB202_1
; RV32IA-NEXT:  .LBB202_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i64_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB202_2
; RV64I-NEXT:  .LBB202_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB202_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    addi a3, zero, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_8@plt
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB202_4
; RV64I-NEXT:  .LBB202_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s1, a3, .LBB202_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB202_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB202_1
; RV64I-NEXT:  .LBB202_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_max_i64_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomax.d.rl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw max i64* %a, i64 %b release
  ret i64 %1
}

define i64 @atomicrmw_max_i64_acq_rel(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i64_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB203_2
; RV32I-NEXT:  .LBB203_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB203_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    addi a4, zero, 4
; RV32I-NEXT:    addi a5, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_8@plt
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB203_7
; RV32I-NEXT:  .LBB203_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB203_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB203_2 Depth=1
; RV32I-NEXT:    slt a0, s1, a5
; RV32I-NEXT:    j .LBB203_5
; RV32I-NEXT:  .LBB203_4: # in Loop: Header=BB203_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB203_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB203_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB203_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB203_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB203_1
; RV32I-NEXT:  .LBB203_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i64_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB203_2
; RV32IA-NEXT:  .LBB203_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB203_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    addi a4, zero, 4
; RV32IA-NEXT:    addi a5, zero, 2
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    call __atomic_compare_exchange_8@plt
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB203_7
; RV32IA-NEXT:  .LBB203_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB203_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB203_2 Depth=1
; RV32IA-NEXT:    slt a0, s1, a5
; RV32IA-NEXT:    j .LBB203_5
; RV32IA-NEXT:  .LBB203_4: # in Loop: Header=BB203_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB203_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB203_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB203_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB203_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB203_1
; RV32IA-NEXT:  .LBB203_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i64_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB203_2
; RV64I-NEXT:  .LBB203_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB203_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    addi a3, zero, 4
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_8@plt
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB203_4
; RV64I-NEXT:  .LBB203_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s1, a3, .LBB203_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB203_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB203_1
; RV64I-NEXT:  .LBB203_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_max_i64_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomax.d.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw max i64* %a, i64 %b acq_rel
  ret i64 %1
}

define i64 @atomicrmw_max_i64_seq_cst(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_max_i64_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB204_2
; RV32I-NEXT:  .LBB204_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB204_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    addi a4, zero, 5
; RV32I-NEXT:    addi a5, zero, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_8@plt
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB204_7
; RV32I-NEXT:  .LBB204_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB204_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB204_2 Depth=1
; RV32I-NEXT:    slt a0, s1, a5
; RV32I-NEXT:    j .LBB204_5
; RV32I-NEXT:  .LBB204_4: # in Loop: Header=BB204_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB204_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB204_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB204_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB204_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB204_1
; RV32I-NEXT:  .LBB204_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_max_i64_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB204_2
; RV32IA-NEXT:  .LBB204_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB204_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    addi a4, zero, 5
; RV32IA-NEXT:    addi a5, zero, 5
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    call __atomic_compare_exchange_8@plt
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB204_7
; RV32IA-NEXT:  .LBB204_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB204_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB204_2 Depth=1
; RV32IA-NEXT:    slt a0, s1, a5
; RV32IA-NEXT:    j .LBB204_5
; RV32IA-NEXT:  .LBB204_4: # in Loop: Header=BB204_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB204_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB204_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB204_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB204_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB204_1
; RV32IA-NEXT:  .LBB204_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_max_i64_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB204_2
; RV64I-NEXT:  .LBB204_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB204_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    addi a3, zero, 5
; RV64I-NEXT:    addi a4, zero, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_8@plt
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB204_4
; RV64I-NEXT:  .LBB204_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    blt s1, a3, .LBB204_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB204_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB204_1
; RV64I-NEXT:  .LBB204_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_max_i64_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomax.d.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw max i64* %a, i64 %b seq_cst
  ret i64 %1
}

define i64 @atomicrmw_min_i64_monotonic(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i64_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB205_2
; RV32I-NEXT:  .LBB205_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB205_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    mv a5, zero
; RV32I-NEXT:    call __atomic_compare_exchange_8@plt
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB205_7
; RV32I-NEXT:  .LBB205_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB205_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB205_2 Depth=1
; RV32I-NEXT:    slt a0, s1, a5
; RV32I-NEXT:    j .LBB205_5
; RV32I-NEXT:  .LBB205_4: # in Loop: Header=BB205_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB205_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB205_2 Depth=1
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB205_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB205_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB205_1
; RV32I-NEXT:  .LBB205_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i64_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB205_2
; RV32IA-NEXT:  .LBB205_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB205_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    mv a4, zero
; RV32IA-NEXT:    mv a5, zero
; RV32IA-NEXT:    call __atomic_compare_exchange_8@plt
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB205_7
; RV32IA-NEXT:  .LBB205_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB205_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB205_2 Depth=1
; RV32IA-NEXT:    slt a0, s1, a5
; RV32IA-NEXT:    j .LBB205_5
; RV32IA-NEXT:  .LBB205_4: # in Loop: Header=BB205_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB205_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB205_2 Depth=1
; RV32IA-NEXT:    xori a0, a0, 1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB205_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB205_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB205_1
; RV32IA-NEXT:  .LBB205_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i64_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB205_2
; RV64I-NEXT:  .LBB205_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB205_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a3, zero
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_8@plt
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB205_4
; RV64I-NEXT:  .LBB205_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s1, a3, .LBB205_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB205_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB205_1
; RV64I-NEXT:  .LBB205_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_min_i64_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomin.d a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw min i64* %a, i64 %b monotonic
  ret i64 %1
}

define i64 @atomicrmw_min_i64_acquire(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i64_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB206_2
; RV32I-NEXT:  .LBB206_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB206_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    addi a5, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_8@plt
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB206_7
; RV32I-NEXT:  .LBB206_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB206_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB206_2 Depth=1
; RV32I-NEXT:    slt a0, s1, a5
; RV32I-NEXT:    j .LBB206_5
; RV32I-NEXT:  .LBB206_4: # in Loop: Header=BB206_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB206_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB206_2 Depth=1
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB206_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB206_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB206_1
; RV32I-NEXT:  .LBB206_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i64_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB206_2
; RV32IA-NEXT:  .LBB206_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB206_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    addi a4, zero, 2
; RV32IA-NEXT:    addi a5, zero, 2
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    call __atomic_compare_exchange_8@plt
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB206_7
; RV32IA-NEXT:  .LBB206_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB206_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB206_2 Depth=1
; RV32IA-NEXT:    slt a0, s1, a5
; RV32IA-NEXT:    j .LBB206_5
; RV32IA-NEXT:  .LBB206_4: # in Loop: Header=BB206_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB206_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB206_2 Depth=1
; RV32IA-NEXT:    xori a0, a0, 1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB206_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB206_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB206_1
; RV32IA-NEXT:  .LBB206_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i64_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB206_2
; RV64I-NEXT:  .LBB206_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB206_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    addi a3, zero, 2
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_8@plt
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB206_4
; RV64I-NEXT:  .LBB206_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s1, a3, .LBB206_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB206_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB206_1
; RV64I-NEXT:  .LBB206_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_min_i64_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomin.d.aq a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw min i64* %a, i64 %b acquire
  ret i64 %1
}

define i64 @atomicrmw_min_i64_release(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i64_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB207_2
; RV32I-NEXT:  .LBB207_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB207_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    addi a4, zero, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a5, zero
; RV32I-NEXT:    call __atomic_compare_exchange_8@plt
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB207_7
; RV32I-NEXT:  .LBB207_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB207_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB207_2 Depth=1
; RV32I-NEXT:    slt a0, s1, a5
; RV32I-NEXT:    j .LBB207_5
; RV32I-NEXT:  .LBB207_4: # in Loop: Header=BB207_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB207_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB207_2 Depth=1
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB207_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB207_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB207_1
; RV32I-NEXT:  .LBB207_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i64_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB207_2
; RV32IA-NEXT:  .LBB207_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB207_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    addi a4, zero, 3
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    mv a5, zero
; RV32IA-NEXT:    call __atomic_compare_exchange_8@plt
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB207_7
; RV32IA-NEXT:  .LBB207_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB207_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB207_2 Depth=1
; RV32IA-NEXT:    slt a0, s1, a5
; RV32IA-NEXT:    j .LBB207_5
; RV32IA-NEXT:  .LBB207_4: # in Loop: Header=BB207_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB207_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB207_2 Depth=1
; RV32IA-NEXT:    xori a0, a0, 1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB207_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB207_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB207_1
; RV32IA-NEXT:  .LBB207_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i64_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB207_2
; RV64I-NEXT:  .LBB207_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB207_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    addi a3, zero, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_8@plt
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB207_4
; RV64I-NEXT:  .LBB207_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s1, a3, .LBB207_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB207_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB207_1
; RV64I-NEXT:  .LBB207_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_min_i64_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomin.d.rl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw min i64* %a, i64 %b release
  ret i64 %1
}

define i64 @atomicrmw_min_i64_acq_rel(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i64_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB208_2
; RV32I-NEXT:  .LBB208_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB208_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    addi a4, zero, 4
; RV32I-NEXT:    addi a5, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_8@plt
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB208_7
; RV32I-NEXT:  .LBB208_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB208_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB208_2 Depth=1
; RV32I-NEXT:    slt a0, s1, a5
; RV32I-NEXT:    j .LBB208_5
; RV32I-NEXT:  .LBB208_4: # in Loop: Header=BB208_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB208_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB208_2 Depth=1
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB208_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB208_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB208_1
; RV32I-NEXT:  .LBB208_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i64_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB208_2
; RV32IA-NEXT:  .LBB208_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB208_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    addi a4, zero, 4
; RV32IA-NEXT:    addi a5, zero, 2
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    call __atomic_compare_exchange_8@plt
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB208_7
; RV32IA-NEXT:  .LBB208_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB208_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB208_2 Depth=1
; RV32IA-NEXT:    slt a0, s1, a5
; RV32IA-NEXT:    j .LBB208_5
; RV32IA-NEXT:  .LBB208_4: # in Loop: Header=BB208_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB208_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB208_2 Depth=1
; RV32IA-NEXT:    xori a0, a0, 1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB208_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB208_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB208_1
; RV32IA-NEXT:  .LBB208_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i64_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB208_2
; RV64I-NEXT:  .LBB208_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB208_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    addi a3, zero, 4
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_8@plt
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB208_4
; RV64I-NEXT:  .LBB208_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s1, a3, .LBB208_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB208_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB208_1
; RV64I-NEXT:  .LBB208_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_min_i64_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomin.d.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw min i64* %a, i64 %b acq_rel
  ret i64 %1
}

define i64 @atomicrmw_min_i64_seq_cst(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_min_i64_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB209_2
; RV32I-NEXT:  .LBB209_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB209_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    addi a4, zero, 5
; RV32I-NEXT:    addi a5, zero, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_8@plt
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB209_7
; RV32I-NEXT:  .LBB209_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB209_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB209_2 Depth=1
; RV32I-NEXT:    slt a0, s1, a5
; RV32I-NEXT:    j .LBB209_5
; RV32I-NEXT:  .LBB209_4: # in Loop: Header=BB209_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB209_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB209_2 Depth=1
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB209_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB209_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB209_1
; RV32I-NEXT:  .LBB209_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_min_i64_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB209_2
; RV32IA-NEXT:  .LBB209_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB209_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    addi a4, zero, 5
; RV32IA-NEXT:    addi a5, zero, 5
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    call __atomic_compare_exchange_8@plt
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB209_7
; RV32IA-NEXT:  .LBB209_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB209_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB209_2 Depth=1
; RV32IA-NEXT:    slt a0, s1, a5
; RV32IA-NEXT:    j .LBB209_5
; RV32IA-NEXT:  .LBB209_4: # in Loop: Header=BB209_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB209_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB209_2 Depth=1
; RV32IA-NEXT:    xori a0, a0, 1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB209_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB209_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB209_1
; RV32IA-NEXT:  .LBB209_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_min_i64_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB209_2
; RV64I-NEXT:  .LBB209_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB209_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    addi a3, zero, 5
; RV64I-NEXT:    addi a4, zero, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_8@plt
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB209_4
; RV64I-NEXT:  .LBB209_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bge s1, a3, .LBB209_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB209_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB209_1
; RV64I-NEXT:  .LBB209_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_min_i64_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomin.d.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw min i64* %a, i64 %b seq_cst
  ret i64 %1
}

define i64 @atomicrmw_umax_i64_monotonic(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i64_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB210_2
; RV32I-NEXT:  .LBB210_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB210_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    mv a5, zero
; RV32I-NEXT:    call __atomic_compare_exchange_8@plt
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB210_7
; RV32I-NEXT:  .LBB210_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB210_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB210_2 Depth=1
; RV32I-NEXT:    sltu a0, s1, a5
; RV32I-NEXT:    j .LBB210_5
; RV32I-NEXT:  .LBB210_4: # in Loop: Header=BB210_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB210_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB210_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB210_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB210_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB210_1
; RV32I-NEXT:  .LBB210_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i64_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB210_2
; RV32IA-NEXT:  .LBB210_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB210_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    mv a4, zero
; RV32IA-NEXT:    mv a5, zero
; RV32IA-NEXT:    call __atomic_compare_exchange_8@plt
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB210_7
; RV32IA-NEXT:  .LBB210_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB210_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB210_2 Depth=1
; RV32IA-NEXT:    sltu a0, s1, a5
; RV32IA-NEXT:    j .LBB210_5
; RV32IA-NEXT:  .LBB210_4: # in Loop: Header=BB210_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB210_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB210_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB210_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB210_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB210_1
; RV32IA-NEXT:  .LBB210_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i64_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB210_2
; RV64I-NEXT:  .LBB210_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB210_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a3, zero
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_8@plt
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB210_4
; RV64I-NEXT:  .LBB210_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s1, a3, .LBB210_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB210_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB210_1
; RV64I-NEXT:  .LBB210_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umax_i64_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomaxu.d a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw umax i64* %a, i64 %b monotonic
  ret i64 %1
}

define i64 @atomicrmw_umax_i64_acquire(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i64_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB211_2
; RV32I-NEXT:  .LBB211_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB211_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    addi a5, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_8@plt
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB211_7
; RV32I-NEXT:  .LBB211_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB211_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB211_2 Depth=1
; RV32I-NEXT:    sltu a0, s1, a5
; RV32I-NEXT:    j .LBB211_5
; RV32I-NEXT:  .LBB211_4: # in Loop: Header=BB211_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB211_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB211_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB211_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB211_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB211_1
; RV32I-NEXT:  .LBB211_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i64_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB211_2
; RV32IA-NEXT:  .LBB211_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB211_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    addi a4, zero, 2
; RV32IA-NEXT:    addi a5, zero, 2
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    call __atomic_compare_exchange_8@plt
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB211_7
; RV32IA-NEXT:  .LBB211_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB211_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB211_2 Depth=1
; RV32IA-NEXT:    sltu a0, s1, a5
; RV32IA-NEXT:    j .LBB211_5
; RV32IA-NEXT:  .LBB211_4: # in Loop: Header=BB211_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB211_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB211_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB211_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB211_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB211_1
; RV32IA-NEXT:  .LBB211_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i64_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB211_2
; RV64I-NEXT:  .LBB211_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB211_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    addi a3, zero, 2
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_8@plt
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB211_4
; RV64I-NEXT:  .LBB211_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s1, a3, .LBB211_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB211_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB211_1
; RV64I-NEXT:  .LBB211_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umax_i64_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomaxu.d.aq a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw umax i64* %a, i64 %b acquire
  ret i64 %1
}

define i64 @atomicrmw_umax_i64_release(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i64_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB212_2
; RV32I-NEXT:  .LBB212_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB212_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    addi a4, zero, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a5, zero
; RV32I-NEXT:    call __atomic_compare_exchange_8@plt
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB212_7
; RV32I-NEXT:  .LBB212_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB212_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB212_2 Depth=1
; RV32I-NEXT:    sltu a0, s1, a5
; RV32I-NEXT:    j .LBB212_5
; RV32I-NEXT:  .LBB212_4: # in Loop: Header=BB212_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB212_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB212_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB212_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB212_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB212_1
; RV32I-NEXT:  .LBB212_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i64_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB212_2
; RV32IA-NEXT:  .LBB212_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB212_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    addi a4, zero, 3
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    mv a5, zero
; RV32IA-NEXT:    call __atomic_compare_exchange_8@plt
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB212_7
; RV32IA-NEXT:  .LBB212_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB212_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB212_2 Depth=1
; RV32IA-NEXT:    sltu a0, s1, a5
; RV32IA-NEXT:    j .LBB212_5
; RV32IA-NEXT:  .LBB212_4: # in Loop: Header=BB212_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB212_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB212_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB212_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB212_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB212_1
; RV32IA-NEXT:  .LBB212_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i64_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB212_2
; RV64I-NEXT:  .LBB212_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB212_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    addi a3, zero, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_8@plt
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB212_4
; RV64I-NEXT:  .LBB212_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s1, a3, .LBB212_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB212_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB212_1
; RV64I-NEXT:  .LBB212_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umax_i64_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomaxu.d.rl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw umax i64* %a, i64 %b release
  ret i64 %1
}

define i64 @atomicrmw_umax_i64_acq_rel(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i64_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB213_2
; RV32I-NEXT:  .LBB213_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB213_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    addi a4, zero, 4
; RV32I-NEXT:    addi a5, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_8@plt
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB213_7
; RV32I-NEXT:  .LBB213_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB213_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB213_2 Depth=1
; RV32I-NEXT:    sltu a0, s1, a5
; RV32I-NEXT:    j .LBB213_5
; RV32I-NEXT:  .LBB213_4: # in Loop: Header=BB213_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB213_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB213_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB213_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB213_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB213_1
; RV32I-NEXT:  .LBB213_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i64_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB213_2
; RV32IA-NEXT:  .LBB213_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB213_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    addi a4, zero, 4
; RV32IA-NEXT:    addi a5, zero, 2
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    call __atomic_compare_exchange_8@plt
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB213_7
; RV32IA-NEXT:  .LBB213_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB213_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB213_2 Depth=1
; RV32IA-NEXT:    sltu a0, s1, a5
; RV32IA-NEXT:    j .LBB213_5
; RV32IA-NEXT:  .LBB213_4: # in Loop: Header=BB213_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB213_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB213_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB213_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB213_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB213_1
; RV32IA-NEXT:  .LBB213_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i64_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB213_2
; RV64I-NEXT:  .LBB213_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB213_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    addi a3, zero, 4
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_8@plt
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB213_4
; RV64I-NEXT:  .LBB213_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s1, a3, .LBB213_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB213_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB213_1
; RV64I-NEXT:  .LBB213_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umax_i64_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomaxu.d.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw umax i64* %a, i64 %b acq_rel
  ret i64 %1
}

define i64 @atomicrmw_umax_i64_seq_cst(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_umax_i64_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB214_2
; RV32I-NEXT:  .LBB214_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB214_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    addi a4, zero, 5
; RV32I-NEXT:    addi a5, zero, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_8@plt
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB214_7
; RV32I-NEXT:  .LBB214_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB214_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB214_2 Depth=1
; RV32I-NEXT:    sltu a0, s1, a5
; RV32I-NEXT:    j .LBB214_5
; RV32I-NEXT:  .LBB214_4: # in Loop: Header=BB214_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB214_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB214_2 Depth=1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB214_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB214_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB214_1
; RV32I-NEXT:  .LBB214_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umax_i64_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB214_2
; RV32IA-NEXT:  .LBB214_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB214_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    addi a4, zero, 5
; RV32IA-NEXT:    addi a5, zero, 5
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    call __atomic_compare_exchange_8@plt
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB214_7
; RV32IA-NEXT:  .LBB214_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB214_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB214_2 Depth=1
; RV32IA-NEXT:    sltu a0, s1, a5
; RV32IA-NEXT:    j .LBB214_5
; RV32IA-NEXT:  .LBB214_4: # in Loop: Header=BB214_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB214_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB214_2 Depth=1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB214_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB214_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB214_1
; RV32IA-NEXT:  .LBB214_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umax_i64_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB214_2
; RV64I-NEXT:  .LBB214_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB214_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    addi a3, zero, 5
; RV64I-NEXT:    addi a4, zero, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_8@plt
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB214_4
; RV64I-NEXT:  .LBB214_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bltu s1, a3, .LBB214_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB214_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB214_1
; RV64I-NEXT:  .LBB214_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umax_i64_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amomaxu.d.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw umax i64* %a, i64 %b seq_cst
  ret i64 %1
}

define i64 @atomicrmw_umin_i64_monotonic(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i64_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB215_2
; RV32I-NEXT:  .LBB215_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB215_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a4, zero
; RV32I-NEXT:    mv a5, zero
; RV32I-NEXT:    call __atomic_compare_exchange_8@plt
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB215_7
; RV32I-NEXT:  .LBB215_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB215_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB215_2 Depth=1
; RV32I-NEXT:    sltu a0, s1, a5
; RV32I-NEXT:    j .LBB215_5
; RV32I-NEXT:  .LBB215_4: # in Loop: Header=BB215_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB215_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB215_2 Depth=1
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB215_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB215_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB215_1
; RV32I-NEXT:  .LBB215_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i64_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB215_2
; RV32IA-NEXT:  .LBB215_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB215_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    mv a4, zero
; RV32IA-NEXT:    mv a5, zero
; RV32IA-NEXT:    call __atomic_compare_exchange_8@plt
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB215_7
; RV32IA-NEXT:  .LBB215_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB215_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB215_2 Depth=1
; RV32IA-NEXT:    sltu a0, s1, a5
; RV32IA-NEXT:    j .LBB215_5
; RV32IA-NEXT:  .LBB215_4: # in Loop: Header=BB215_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB215_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB215_2 Depth=1
; RV32IA-NEXT:    xori a0, a0, 1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB215_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB215_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB215_1
; RV32IA-NEXT:  .LBB215_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i64_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB215_2
; RV64I-NEXT:  .LBB215_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB215_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a3, zero
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_8@plt
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB215_4
; RV64I-NEXT:  .LBB215_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s1, a3, .LBB215_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB215_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB215_1
; RV64I-NEXT:  .LBB215_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umin_i64_monotonic:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amominu.d a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw umin i64* %a, i64 %b monotonic
  ret i64 %1
}

define i64 @atomicrmw_umin_i64_acquire(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i64_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB216_2
; RV32I-NEXT:  .LBB216_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB216_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    addi a4, zero, 2
; RV32I-NEXT:    addi a5, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_8@plt
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB216_7
; RV32I-NEXT:  .LBB216_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB216_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB216_2 Depth=1
; RV32I-NEXT:    sltu a0, s1, a5
; RV32I-NEXT:    j .LBB216_5
; RV32I-NEXT:  .LBB216_4: # in Loop: Header=BB216_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB216_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB216_2 Depth=1
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB216_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB216_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB216_1
; RV32I-NEXT:  .LBB216_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i64_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB216_2
; RV32IA-NEXT:  .LBB216_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB216_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    addi a4, zero, 2
; RV32IA-NEXT:    addi a5, zero, 2
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    call __atomic_compare_exchange_8@plt
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB216_7
; RV32IA-NEXT:  .LBB216_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB216_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB216_2 Depth=1
; RV32IA-NEXT:    sltu a0, s1, a5
; RV32IA-NEXT:    j .LBB216_5
; RV32IA-NEXT:  .LBB216_4: # in Loop: Header=BB216_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB216_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB216_2 Depth=1
; RV32IA-NEXT:    xori a0, a0, 1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB216_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB216_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB216_1
; RV32IA-NEXT:  .LBB216_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i64_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB216_2
; RV64I-NEXT:  .LBB216_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB216_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    addi a3, zero, 2
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_8@plt
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB216_4
; RV64I-NEXT:  .LBB216_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s1, a3, .LBB216_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB216_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB216_1
; RV64I-NEXT:  .LBB216_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umin_i64_acquire:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amominu.d.aq a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw umin i64* %a, i64 %b acquire
  ret i64 %1
}

define i64 @atomicrmw_umin_i64_release(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i64_release:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB217_2
; RV32I-NEXT:  .LBB217_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB217_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    addi a4, zero, 3
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a5, zero
; RV32I-NEXT:    call __atomic_compare_exchange_8@plt
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB217_7
; RV32I-NEXT:  .LBB217_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB217_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB217_2 Depth=1
; RV32I-NEXT:    sltu a0, s1, a5
; RV32I-NEXT:    j .LBB217_5
; RV32I-NEXT:  .LBB217_4: # in Loop: Header=BB217_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB217_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB217_2 Depth=1
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB217_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB217_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB217_1
; RV32I-NEXT:  .LBB217_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i64_release:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB217_2
; RV32IA-NEXT:  .LBB217_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB217_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    addi a4, zero, 3
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    mv a5, zero
; RV32IA-NEXT:    call __atomic_compare_exchange_8@plt
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB217_7
; RV32IA-NEXT:  .LBB217_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB217_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB217_2 Depth=1
; RV32IA-NEXT:    sltu a0, s1, a5
; RV32IA-NEXT:    j .LBB217_5
; RV32IA-NEXT:  .LBB217_4: # in Loop: Header=BB217_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB217_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB217_2 Depth=1
; RV32IA-NEXT:    xori a0, a0, 1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB217_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB217_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB217_1
; RV32IA-NEXT:  .LBB217_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i64_release:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB217_2
; RV64I-NEXT:  .LBB217_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB217_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    addi a3, zero, 3
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a4, zero
; RV64I-NEXT:    call __atomic_compare_exchange_8@plt
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB217_4
; RV64I-NEXT:  .LBB217_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s1, a3, .LBB217_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB217_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB217_1
; RV64I-NEXT:  .LBB217_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umin_i64_release:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amominu.d.rl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw umin i64* %a, i64 %b release
  ret i64 %1
}

define i64 @atomicrmw_umin_i64_acq_rel(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i64_acq_rel:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB218_2
; RV32I-NEXT:  .LBB218_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB218_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    addi a4, zero, 4
; RV32I-NEXT:    addi a5, zero, 2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_8@plt
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB218_7
; RV32I-NEXT:  .LBB218_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB218_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB218_2 Depth=1
; RV32I-NEXT:    sltu a0, s1, a5
; RV32I-NEXT:    j .LBB218_5
; RV32I-NEXT:  .LBB218_4: # in Loop: Header=BB218_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB218_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB218_2 Depth=1
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB218_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB218_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB218_1
; RV32I-NEXT:  .LBB218_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i64_acq_rel:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB218_2
; RV32IA-NEXT:  .LBB218_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB218_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    addi a4, zero, 4
; RV32IA-NEXT:    addi a5, zero, 2
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    call __atomic_compare_exchange_8@plt
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB218_7
; RV32IA-NEXT:  .LBB218_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB218_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB218_2 Depth=1
; RV32IA-NEXT:    sltu a0, s1, a5
; RV32IA-NEXT:    j .LBB218_5
; RV32IA-NEXT:  .LBB218_4: # in Loop: Header=BB218_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB218_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB218_2 Depth=1
; RV32IA-NEXT:    xori a0, a0, 1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB218_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB218_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB218_1
; RV32IA-NEXT:  .LBB218_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i64_acq_rel:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB218_2
; RV64I-NEXT:  .LBB218_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB218_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    addi a3, zero, 4
; RV64I-NEXT:    addi a4, zero, 2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_8@plt
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB218_4
; RV64I-NEXT:  .LBB218_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s1, a3, .LBB218_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB218_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB218_1
; RV64I-NEXT:  .LBB218_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umin_i64_acq_rel:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amominu.d.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw umin i64* %a, i64 %b acq_rel
  ret i64 %1
}

define i64 @atomicrmw_umin_i64_seq_cst(i64 *%a, i64 %b) nounwind {
; RV32I-LABEL: atomicrmw_umin_i64_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lw a5, 4(a0)
; RV32I-NEXT:    lw a4, 0(a0)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    j .LBB219_2
; RV32I-NEXT:  .LBB219_1: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB219_2 Depth=1
; RV32I-NEXT:    sw a4, 8(sp)
; RV32I-NEXT:    sw a5, 12(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    addi a4, zero, 5
; RV32I-NEXT:    addi a5, zero, 5
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __atomic_compare_exchange_8@plt
; RV32I-NEXT:    lw a5, 12(sp)
; RV32I-NEXT:    lw a4, 8(sp)
; RV32I-NEXT:    bnez a0, .LBB219_7
; RV32I-NEXT:  .LBB219_2: # %atomicrmw.start
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    beq a5, s1, .LBB219_4
; RV32I-NEXT:  # %bb.3: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB219_2 Depth=1
; RV32I-NEXT:    sltu a0, s1, a5
; RV32I-NEXT:    j .LBB219_5
; RV32I-NEXT:  .LBB219_4: # in Loop: Header=BB219_2 Depth=1
; RV32I-NEXT:    sltu a0, s2, a4
; RV32I-NEXT:  .LBB219_5: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB219_2 Depth=1
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    mv a2, a4
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    bnez a0, .LBB219_1
; RV32I-NEXT:  # %bb.6: # %atomicrmw.start
; RV32I-NEXT:    # in Loop: Header=BB219_2 Depth=1
; RV32I-NEXT:    mv a2, s2
; RV32I-NEXT:    mv a3, s1
; RV32I-NEXT:    j .LBB219_1
; RV32I-NEXT:  .LBB219_7: # %atomicrmw.end
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: atomicrmw_umin_i64_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -32
; RV32IA-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv s0, a0
; RV32IA-NEXT:    lw a5, 4(a0)
; RV32IA-NEXT:    lw a4, 0(a0)
; RV32IA-NEXT:    mv s1, a2
; RV32IA-NEXT:    mv s2, a1
; RV32IA-NEXT:    j .LBB219_2
; RV32IA-NEXT:  .LBB219_1: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB219_2 Depth=1
; RV32IA-NEXT:    sw a4, 8(sp)
; RV32IA-NEXT:    sw a5, 12(sp)
; RV32IA-NEXT:    addi a1, sp, 8
; RV32IA-NEXT:    addi a4, zero, 5
; RV32IA-NEXT:    addi a5, zero, 5
; RV32IA-NEXT:    mv a0, s0
; RV32IA-NEXT:    call __atomic_compare_exchange_8@plt
; RV32IA-NEXT:    lw a5, 12(sp)
; RV32IA-NEXT:    lw a4, 8(sp)
; RV32IA-NEXT:    bnez a0, .LBB219_7
; RV32IA-NEXT:  .LBB219_2: # %atomicrmw.start
; RV32IA-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    beq a5, s1, .LBB219_4
; RV32IA-NEXT:  # %bb.3: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB219_2 Depth=1
; RV32IA-NEXT:    sltu a0, s1, a5
; RV32IA-NEXT:    j .LBB219_5
; RV32IA-NEXT:  .LBB219_4: # in Loop: Header=BB219_2 Depth=1
; RV32IA-NEXT:    sltu a0, s2, a4
; RV32IA-NEXT:  .LBB219_5: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB219_2 Depth=1
; RV32IA-NEXT:    xori a0, a0, 1
; RV32IA-NEXT:    mv a2, a4
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    bnez a0, .LBB219_1
; RV32IA-NEXT:  # %bb.6: # %atomicrmw.start
; RV32IA-NEXT:    # in Loop: Header=BB219_2 Depth=1
; RV32IA-NEXT:    mv a2, s2
; RV32IA-NEXT:    mv a3, s1
; RV32IA-NEXT:    j .LBB219_1
; RV32IA-NEXT:  .LBB219_7: # %atomicrmw.end
; RV32IA-NEXT:    mv a0, a4
; RV32IA-NEXT:    mv a1, a5
; RV32IA-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 32
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: atomicrmw_umin_i64_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    ld a3, 0(a0)
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    j .LBB219_2
; RV64I-NEXT:  .LBB219_1: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB219_2 Depth=1
; RV64I-NEXT:    sd a3, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    addi a3, zero, 5
; RV64I-NEXT:    addi a4, zero, 5
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __atomic_compare_exchange_8@plt
; RV64I-NEXT:    ld a3, 0(sp)
; RV64I-NEXT:    bnez a0, .LBB219_4
; RV64I-NEXT:  .LBB219_2: # %atomicrmw.start
; RV64I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64I-NEXT:    mv a2, a3
; RV64I-NEXT:    bgeu s1, a3, .LBB219_1
; RV64I-NEXT:  # %bb.3: # %atomicrmw.start
; RV64I-NEXT:    # in Loop: Header=BB219_2 Depth=1
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    j .LBB219_1
; RV64I-NEXT:  .LBB219_4: # %atomicrmw.end
; RV64I-NEXT:    mv a0, a3
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
;
; RV64IA-LABEL: atomicrmw_umin_i64_seq_cst:
; RV64IA:       # %bb.0:
; RV64IA-NEXT:    amominu.d.aqrl a0, a1, (a0)
; RV64IA-NEXT:    ret
  %1 = atomicrmw umin i64* %a, i64 %b seq_cst
  ret i64 %1
}
