/* This file is automatically generated by aarch64-gen.  Do not edit!  */
/* Copyright 2012, 2013  Free Software Foundation, Inc.
   Contributed by ARM Ltd.

   This file is part of the GNU opcodes library.

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING3. If not,
   see <http://www.gnu.org/licenses/>.  */

#include "sysdep.h"
#include "aarch64-dis.h"

/* Called by aarch64_opcode_lookup.  */

static int
aarch64_opcode_lookup_1 (uint32_t word)
{
  if (((word >> 26) & 0x1) == 0)
    {
      if (((word >> 25) & 0x1) == 0)
        {
          if (((word >> 27) & 0x1) == 0)
            {
              if (((word >> 24) & 0x1) == 0)
                {
                  if (((word >> 31) & 0x1) == 0)
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxxx0000xxx0
                         adr.  */
                      return 781;
                    }
                  else
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxxx0000xxx1
                         adrp.  */
                      return 782;
                    }
                }
              else
                {
                  if (((word >> 29) & 0x1) == 0)
                    {
                      if (((word >> 30) & 0x1) == 0)
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxxxx1000x00x
                             add.  */
                          return 12;
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxxxx1000x01x
                             sub.  */
                          return 16;
                        }
                    }
                  else
                    {
                      if (((word >> 30) & 0x1) == 0)
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxxxx1000x10x
                             adds.  */
                          return 14;
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxxxx1000x11x
                             subs.  */
                          return 17;
                        }
                    }
                }
            }
          else
            {
              if (((word >> 28) & 0x1) == 0)
                {
                  if (((word >> 22) & 0x1) == 0)
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx0xxxxx000x0010000
                                                 stxrb.  */
                                              return 717;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx0xxxxx000x0010010
                                                 stxrh.  */
                                              return 723;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx0xxxxx000x00100x1
                                             stxr.  */
                                          return 729;
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxx0xxxxx100x00100xx
                                         stxp.  */
                                      return 731;
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx000x0010000
                                                 stlxrb.  */
                                              return 718;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx000x0010010
                                                 stlxrh.  */
                                              return 724;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx1xxxxx000x00100x1
                                             stlxr.  */
                                          return 730;
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxx1xxxxx100x00100xx
                                         stlxp.  */
                                      return 732;
                                    }
                                }
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxx00x00101xx
                                 stnp.  */
                              return 739;
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 31) & 0x1) == 0)
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxxx01x0010000
                                         stlrb.  */
                                      return 721;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxxx01x0010010
                                         stlrh.  */
                                      return 727;
                                    }
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx01x00100x1
                                     stlr.  */
                                  return 737;
                                }
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxx01x00101xx
                                 stp.  */
                              return 748;
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx0xxxxx010x0010000
                                                 ldxrb.  */
                                              return 719;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx0xxxxx010x0010010
                                                 ldxrh.  */
                                              return 725;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx0xxxxx010x00100x1
                                             ldxr.  */
                                          return 733;
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxx0xxxxx110x00100xx
                                         ldxp.  */
                                      return 735;
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx010x0010000
                                                 ldaxrb.  */
                                              return 720;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx010x0010010
                                                 ldaxrh.  */
                                              return 726;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx1xxxxx010x00100x1
                                             ldaxr.  */
                                          return 734;
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxx1xxxxx110x00100xx
                                         ldaxp.  */
                                      return 736;
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx10x001010x
                                     ldnp.  */
                                  return 740;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx10x001011x
                                     ldpsw.  */
                                  return 747;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 31) & 0x1) == 0)
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxxx11x0010000
                                         ldarb.  */
                                      return 722;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxxx11x0010010
                                         ldarh.  */
                                      return 728;
                                    }
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx11x00100x1
                                     ldar.  */
                                  return 738;
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx11x001010x
                                     ldp.  */
                                  return 749;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx11x001011x
                                     ldpsw.  */
                                  return 752;
                                }
                            }
                        }
                    }
                }
              else
                {
                  if (((word >> 24) & 0x1) == 0)
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          if (((word >> 31) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxxx000110x0
                                 ldr.  */
                              return 753;
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxxxx00011001
                                     ldrsw.  */
                                  return 755;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxxxx00011011
                                     prfm.  */
                                  return 756;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 10) & 0x1) == 0)
                            {
                              if (((word >> 11) & 0x1) == 0)
                                {
                                  if (((word >> 23) & 0x1) == 0)
                                    {
                                      if (((word >> 22) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxxx0000011100
                                                     sturb.  */
                                                  return 693;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxxx0000011110
                                                     sturh.  */
                                                  return 703;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx00xxxxxxxxxx00000111x1
                                                 stur.  */
                                              return 709;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxxx1000011100
                                                     ldurb.  */
                                                  return 694;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxxx1000011110
                                                     ldurh.  */
                                                  return 704;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx00xxxxxxxxxx10000111x1
                                                 ldur.  */
                                              return 710;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx00xxxxxxxxxxx100011100
                                                 ldursb.  */
                                              return 697;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx00xxxxxxxxxxx100011101
                                                 ldursw.  */
                                              return 713;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 31) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx00xxxxxxxxxxx100011110
                                                 ldursh.  */
                                              return 707;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx00xxxxxxxxxxx100011111
                                                 prfum.  */
                                              return 715;
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01xxxxxxxxx00000011100
                                                         sttrb.  */
                                                      return 684;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01xxxxxxxxx00000011110
                                                         sttrh.  */
                                                      return 687;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx000000111x1
                                                     sttr.  */
                                                  return 690;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01xxxxxxxxx01000011100
                                                         ldtrb.  */
                                                      return 685;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01xxxxxxxxx01000011110
                                                         ldtrh.  */
                                                      return 688;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx010000111x1
                                                     ldtr.  */
                                                  return 691;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx0x100011100
                                                     ldtrsb.  */
                                                  return 686;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx0x100011101
                                                     ldtrsw.  */
                                                  return 692;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx01xxxxxxxxx0x10001111x
                                                 ldtrsh.  */
                                              return 689;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01xxxxxxxxx10000011100
                                                         strb.  */
                                                      return 672;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01xxxxxxxxx10000011110
                                                         strh.  */
                                                      return 677;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx100000111x1
                                                     str.  */
                                                  return 680;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01xxxxxxxxx11000011100
                                                         ldrb.  */
                                                      return 673;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01xxxxxxxxx11000011110
                                                         ldrh.  */
                                                      return 678;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx110000111x1
                                                     ldr.  */
                                                  return 681;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx1x100011100
                                                     ldrsb.  */
                                                  return 674;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx1x100011101
                                                     ldrsw.  */
                                                  return 682;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx1x100011110
                                                     ldrsh.  */
                                                  return 679;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx1x100011111
                                                     prfm.  */
                                                  return 683;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 23) & 0x1) == 0)
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1xxxxxxxxxxx0000011100
                                                 strb.  */
                                              return 649;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1xxxxxxxxxxx0000011110
                                                 strh.  */
                                              return 654;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx1xxxxxxxxxxx00000111x1
                                             str.  */
                                          return 657;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1xxxxxxxxxxx1000011100
                                                 ldrb.  */
                                              return 650;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1xxxxxxxxxxx1000011110
                                                 ldrh.  */
                                              return 655;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx1xxxxxxxxxxx10000111x1
                                             ldr.  */
                                          return 658;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx1xxxxxxxxxxxx100011100
                                             ldrsb.  */
                                          return 651;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx1xxxxxxxxxxxx100011101
                                             ldrsw.  */
                                          return 659;
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx1xxxxxxxxxxxx10001111x
                                         ldrsh.  */
                                      return 656;
                                    }
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 22) & 0x1) == 0)
                            {
                              if (((word >> 31) & 0x1) == 0)
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxxx0010011x00
                                         strb.  */
                                      return 660;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxxx0010011x10
                                         strh.  */
                                      return 665;
                                    }
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx0010011xx1
                                     str.  */
                                  return 668;
                                }
                            }
                          else
                            {
                              if (((word >> 31) & 0x1) == 0)
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxxx1010011x00
                                         ldrb.  */
                                      return 661;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxxx1010011x10
                                         ldrh.  */
                                      return 666;
                                    }
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx1010011xx1
                                     ldr.  */
                                  return 669;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              if (((word >> 31) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxxx110011x00
                                     ldrsb.  */
                                  return 662;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxxx110011x01
                                     ldrsw.  */
                                  return 670;
                                }
                            }
                          else
                            {
                              if (((word >> 31) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxxx110011x10
                                     ldrsh.  */
                                  return 667;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxxx110011x11
                                     prfm.  */
                                  return 671;
                                }
                            }
                        }
                    }
                }
            }
        }
      else
        {
          if (((word >> 24) & 0x1) == 0)
            {
              if (((word >> 27) & 0x1) == 0)
                {
                  if (((word >> 23) & 0x1) == 0)
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxx00100x00x
                                 and.  */
                              return 757;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxx00100x01x
                                 eor.  */
                              return 761;
                            }
                        }
                      else
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxx00100x10x
                                 orr.  */
                              return 759;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxx00100x11x
                                 ands.  */
                              return 762;
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxx10100x00x
                                 movn.  */
                              return 776;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxx10100x01x
                                 movz.  */
                              return 778;
                            }
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxxx10100x1xx
                             movk.  */
                          return 780;
                        }
                    }
                }
              else
                {
                  if (((word >> 21) & 0x1) == 0)
                    {
                      if (((word >> 28) & 0x1) == 0)
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx0xx0101000x
                                     and.  */
                                  return 764;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx0xx0101001x
                                     eor.  */
                                  return 771;
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx0xx0101010x
                                     orr.  */
                                  return 766;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx0xx0101011x
                                     ands.  */
                                  return 773;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 10) & 0x1) == 0)
                            {
                              if (((word >> 11) & 0x1) == 0)
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxx0000101100x
                                                     adc.  */
                                                  return 0;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxx0000101101x
                                                     sbc.  */
                                                  return 2;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxx0000101110x
                                                     adcs.  */
                                                  return 1;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxx0000101111x
                                                     sbcs.  */
                                                  return 4;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx00xxxxxxxxx00101011x0x
                                                 csel.  */
                                              return 524;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx00xxxxxxxxx00101011x1x
                                                 csinv.  */
                                              return 528;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx00xxxxxxxxx01001011x0x
                                                 ccmn.  */
                                              return 522;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx00xxxxxxxxx01001011x1x
                                                 ccmp.  */
                                              return 523;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00000xxxxxx01101011xxx
                                                         rbit.  */
                                                      return 547;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00001xxxxxx01101011xxx
                                                         crc32b.  */
                                                      return 564;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0001xxxxxxx01101011xxx
                                                     lslv.  */
                                                  return 556;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx001x0xxxxxx01101011xxx
                                                     clz.  */
                                                  return 551;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx001x1xxxxxx01101011xxx
                                                     crc32cb.  */
                                                  return 568;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 23) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx01xxxxxxxxx0x001011x0x
                                             ccmn.  */
                                          return 520;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx01xxxxxxxxx0x001011x1x
                                             ccmp.  */
                                          return 521;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01000xxxxxx0x101011x0x
                                                         udiv.  */
                                                      return 554;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 31) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx01000xxxxxx0x101011x10
                                                             rev.  */
                                                          return 549;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx01000xxxxxx0x101011x11
                                                             rev32.  */
                                                          return 553;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01001xxxxxx0x101011xxx
                                                     crc32w.  */
                                                  return 566;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0101xxxxxxx0x101011xxx
                                                 asrv.  */
                                              return 560;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx011xxxxxxxx0x101011xxx
                                             crc32cw.  */
                                          return 570;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 11) & 0x1) == 0)
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx10xxxxxxxxx00x01011x0x
                                             csinc.  */
                                          return 525;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx10xxxxxxxxx00x01011x1x
                                             csneg.  */
                                          return 531;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx10000xxxxxx01x01011xxx
                                                     rev16.  */
                                                  return 548;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx10001xxxxxx01x01011xxx
                                                     crc32h.  */
                                                  return 565;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1001xxxxxxx01x01011xxx
                                                 lsrv.  */
                                              return 558;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx101x0xxxxxx01x01011xxx
                                                 cls.  */
                                              return 552;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx101x1xxxxxx01x01011xxx
                                                 crc32ch.  */
                                              return 569;
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 12) & 0x1) == 0)
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx11000xxxxxx0xx01011x0x
                                                     sdiv.  */
                                                  return 555;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx11000xxxxxx0xx01011x1x
                                                     rev.  */
                                                  return 550;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx11001xxxxxx0xx01011xxx
                                                 crc32x.  */
                                              return 567;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx1101xxxxxxx0xx01011xxx
                                             rorv.  */
                                          return 562;
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx111xxxxxxxx0xx01011xxx
                                         crc32cx.  */
                                      return 571;
                                    }
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxx1xx0101x00x
                                 bic.  */
                              return 765;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxx1xx0101x01x
                                 eon.  */
                              return 772;
                            }
                        }
                      else
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxx1xx0101x10x
                                 orn.  */
                              return 769;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxx1xx0101x11x
                                 bics.  */
                              return 775;
                            }
                        }
                    }
                }
            }
          else
            {
              if (((word >> 27) & 0x1) == 0)
                {
                  if (((word >> 23) & 0x1) == 0)
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxx01100x00x
                                 sbfm.  */
                              return 493;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxx01100x01x
                                 ubfm.  */
                              return 503;
                            }
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxxx01100x1xx
                             bfm.  */
                          return 500;
                        }
                    }
                  else
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxx11100xxxx
                         extr.  */
                      return 594;
                    }
                }
              else
                {
                  if (((word >> 21) & 0x1) == 0)
                    {
                      if (((word >> 28) & 0x1) == 0)
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx0xx1101000x
                                     add.  */
                                  return 19;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx0xx1101001x
                                     sub.  */
                                  return 22;
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx0xx1101010x
                                     adds.  */
                                  return 20;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx0xx1101011x
                                     subs.  */
                                  return 24;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 15) & 0x1) == 0)
                            {
                              if (((word >> 22) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxx0xxxxx00x11011xxx
                                     madd.  */
                                  return 572;
                                }
                              else
                                {
                                  if (((word >> 23) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxx0xxxxx01011011xxx
                                         smulh.  */
                                      return 580;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxx0xxxxx01111011xxx
                                         umulh.  */
                                      return 585;
                                    }
                                }
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxx1xxxxx0xx11011xxx
                                 msub.  */
                              return 574;
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 28) & 0x1) == 0)
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxx1x01101000x
                                         add.  */
                                      return 6;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxx1x01101001x
                                         sub.  */
                                      return 9;
                                    }
                                }
                              else
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxx1x01101010x
                                         adds.  */
                                      return 7;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxx1x01101011x
                                         subs.  */
                                      return 10;
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxx0xxxxx1x011011xxx
                                     smaddl.  */
                                  return 576;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxx1xxxxx1x011011xxx
                                     smsubl.  */
                                  return 578;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 15) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxx0xxxxx1x11101xxxx
                                 umaddl.  */
                              return 581;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxx1xxxxx1x11101xxxx
                                 umsubl.  */
                              return 583;
                            }
                        }
                    }
                }
            }
        }
    }
  else
    {
      if (((word >> 27) & 0x1) == 0)
        {
          if (((word >> 29) & 0x1) == 0)
            {
              if (((word >> 30) & 0x1) == 0)
                {
                  if (((word >> 31) & 0x1) == 0)
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxxxxx10x000
                         b.  */
                      return 510;
                    }
                  else
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxxxxx10x001
                         bl.  */
                      return 511;
                    }
                }
              else
                {
                  if (((word >> 24) & 0x1) == 0)
                    {
                      if (((word >> 25) & 0x1) == 0)
                        {
                          if (((word >> 31) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxxx0010x010
                                 b.c.  */
                              return 519;
                            }
                          else
                            {
                              if (((word >> 0) & 0x1) == 0)
                                {
                                  if (((word >> 1) & 0x1) == 0)
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             00xxxxxxxxxxxxxxxxxxx0xx0010x011
                                             hlt.  */
                                          return 590;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             00xxxxxxxxxxxxxxxxxxx1xx0010x011
                                             brk.  */
                                          return 589;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             01xxxxxxxxxxxxxxxxxxx0xx0010x011
                                             hvc.  */
                                          return 587;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             01xxxxxxxxxxxxxxxxxxx1xx0010x011
                                             dcps2.  */
                                          return 592;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 1) & 0x1) == 0)
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             10xxxxxxxxxxxxxxxxxxx0xx0010x011
                                             svc.  */
                                          return 586;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             10xxxxxxxxxxxxxxxxxxx1xx0010x011
                                             dcps1.  */
                                          return 591;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             11xxxxxxxxxxxxxxxxxxx0xx0010x011
                                             smc.  */
                                          return 588;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             11xxxxxxxxxxxxxxxxxxx1xx0010x011
                                             dcps3.  */
                                          return 593;
                                        }
                                    }
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 21) & 0x1) == 0)
                            {
                              if (((word >> 22) & 0x1) == 0)
                                {
                                  if (((word >> 23) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxx0000110x01x
                                         br.  */
                                      return 512;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxx0010110x01x
                                         eret.  */
                                      return 515;
                                    }
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx01x0110x01x
                                     ret.  */
                                  return 514;
                                }
                            }
                          else
                            {
                              if (((word >> 23) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx1x00110x01x
                                     blr.  */
                                  return 513;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx1x10110x01x
                                     drps.  */
                                  return 516;
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 20) & 0x1) == 0)
                        {
                          if (((word >> 19) & 0x1) == 0)
                            {
                              if (((word >> 12) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxx00xxxxx00xxx1x10x01x
                                         msr.  */
                                      return 783;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxx01xxxxx00xxx1x10x01x
                                         hint.  */
                                      return 784;
                                    }
                                }
                              else
                                {
                                  if (((word >> 5) & 0x1) == 0)
                                    {
                                      if (((word >> 6) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxx00xxxxx1xxxxxx00xxx1x10x01x
                                             dsb.  */
                                          return 792;
                                        }
                                      else
                                        {
                                          if (((word >> 7) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxx010xxxx1xxxxxx00xxx1x10x01x
                                                 clrex.  */
                                              return 791;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxx011xxxx1xxxxxx00xxx1x10x01x
                                                 isb.  */
                                              return 794;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxx1xxxxxx1xxxxxx00xxx1x10x01x
                                         dmb.  */
                                      return 793;
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 21) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxx100xx1x10x01x
                                     sys.  */
                                  return 795;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxx101xx1x10x01x
                                     sysl.  */
                                  return 801;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 21) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxx10xx1x10x01x
                                 msr.  */
                              return 800;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxx11xx1x10x01x
                                 mrs.  */
                              return 802;
                            }
                        }
                    }
                }
            }
          else
            {
              if (((word >> 24) & 0x1) == 0)
                {
                  if (((word >> 25) & 0x1) == 0)
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxxx0010x1xx
                         cbz.  */
                      return 517;
                    }
                  else
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxxx0110x1xx
                         tbz.  */
                      return 803;
                    }
                }
              else
                {
                  if (((word >> 25) & 0x1) == 0)
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxxx1010x1xx
                         cbnz.  */
                      return 518;
                    }
                  else
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxxx1110x1xx
                         tbnz.  */
                      return 804;
                    }
                }
            }
        }
      else
        {
          if (((word >> 25) & 0x1) == 0)
            {
              if (((word >> 28) & 0x1) == 0)
                {
                  if (((word >> 22) & 0x1) == 0)
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 24) & 0x1) == 0)
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx00001100xx
                                     st4.  */
                                  return 355;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx00001101xx
                                     stnp.  */
                                  return 741;
                                }
                            }
                          else
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx0xxxxxxx000101100xx
                                             st1.  */
                                          return 371;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx0xxxxxxx100101100xx
                                             st2.  */
                                          return 373;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx1xxxxxxx000101100xx
                                             st3.  */
                                          return 372;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx1xxxxxxx100101100xx
                                             st4.  */
                                          return 374;
                                        }
                                    }
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx00101101xx
                                     stp.  */
                                  return 745;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 21) & 0x1) == 0)
                                {
                                  if (((word >> 24) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxx001001100xx
                                         st4.  */
                                      return 363;
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx0xxxxxxx001101100xx
                                             st1.  */
                                          return 383;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx1xxxxxxx001101100xx
                                             st3.  */
                                          return 384;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxx0xxxxxxx101x01100xx
                                         st2.  */
                                      return 385;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxx1xxxxxxx101x01100xx
                                         st4.  */
                                      return 386;
                                    }
                                }
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxx01x01101xx
                                 stp.  */
                              return 750;
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 24) & 0x1) == 0)
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx10001100xx
                                     ld4.  */
                                  return 359;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx10001101xx
                                     ldnp.  */
                                  return 742;
                                }
                            }
                          else
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx0xxxxxxx010101100xx
                                             ld1.  */
                                          return 375;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx0xxxxxxx110101100xx
                                             ld2.  */
                                          return 379;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx1xxxxxxx010101100xx
                                             ld3.  */
                                          return 376;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx1xxxxxxx110101100xx
                                             ld4.  */
                                          return 380;
                                        }
                                    }
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx10101101xx
                                     ldp.  */
                                  return 746;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 21) & 0x1) == 0)
                                {
                                  if (((word >> 24) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxx011001100xx
                                         ld4.  */
                                      return 367;
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx0xxxxxxx011101100xx
                                             ld1.  */
                                          return 387;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx1xxxxxxx011101100xx
                                             ld3.  */
                                          return 388;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxx0xxxxxxx111x01100xx
                                         ld2.  */
                                      return 391;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxx1xxxxxxx111x01100xx
                                         ld4.  */
                                      return 392;
                                    }
                                }
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxx11x01101xx
                                 ldp.  */
                              return 751;
                            }
                        }
                    }
                }
              else
                {
                  if (((word >> 24) & 0x1) == 0)
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxxxx001110xx
                             ldr.  */
                          return 754;
                        }
                      else
                        {
                          if (((word >> 10) & 0x1) == 0)
                            {
                              if (((word >> 11) & 0x1) == 0)
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx00xxxxxxxxxx0x001111xx
                                         stur.  */
                                      return 699;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx00xxxxxxxxxx1x001111xx
                                         ldur.  */
                                      return 700;
                                    }
                                }
                              else
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx01xxxxxxxxxx0x001111xx
                                         str.  */
                                      return 675;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx01xxxxxxxxxx1x001111xx
                                         ldr.  */
                                      return 676;
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 22) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxx1xxxxxxxxxxx0x001111xx
                                     str.  */
                                  return 652;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxx1xxxxxxxxxxx1x001111xx
                                     ldr.  */
                                  return 653;
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 22) & 0x1) == 0)
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxx0x10111xxx
                             str.  */
                          return 663;
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxx1x10111xxx
                             ldr.  */
                          return 664;
                        }
                    }
                }
            }
          else
            {
              if (((word >> 24) & 0x1) == 0)
                {
                  if (((word >> 21) & 0x1) == 0)
                    {
                      if (((word >> 28) & 0x1) == 0)
                        {
                          if (((word >> 10) & 0x1) == 0)
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  if (((word >> 11) & 0x1) == 0)
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx000xxxxxxxx0xx011100xx
                                             tbl.  */
                                          return 341;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx001xxxxxxxx0xx011100xx
                                             tbx.  */
                                          return 342;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx010x0xxxxxx0xx011100xx
                                                 trn1.  */
                                              return 216;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx010x1xxxxxx0xx011100xx
                                                 trn2.  */
                                              return 219;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01100xxxxxx0xx011100xx
                                                     uzp1.  */
                                                  return 215;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01101xxxxxx0xx011100xx
                                                     uzp2.  */
                                                  return 218;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01110xxxxxx0xx011100xx
                                                     zip1.  */
                                                  return 217;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01111xxxxxx0xx011100xx
                                                     zip2.  */
                                                  return 220;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxx0xxxxxxxxxx0xx011101xx
                                     ext.  */
                                  return 119;
                                }
                            }
                          else
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  if (((word >> 11) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx10xxxxxxxxx0xx011100xx
                                         dup.  */
                                      return 135;
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1100xxxxxxx0xx011100xx
                                                 dup.  */
                                              return 136;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1101xxxxxxx0xx011100xx
                                                 smov.  */
                                              return 137;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1110xxxxxxx0xx011100xx
                                                 ins.  */
                                              return 140;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1111xxxxxxx0xx011100xx
                                                 umov.  */
                                              return 138;
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxx1xxxxxxxxxx0xx011101xx
                                     ins.  */
                                  return 142;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              if (((word >> 16) & 0x1) == 0)
                                {
                                  if (((word >> 17) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxx00xxx0xx01111x0x
                                         fcvtzs.  */
                                      return 598;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxx01xxx0xx01111x0x
                                         scvtf.  */
                                      return 596;
                                    }
                                }
                              else
                                {
                                  if (((word >> 17) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxx10xxx0xx01111x0x
                                         fcvtzu.  */
                                      return 599;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxx11xxx0xx01111x0x
                                         ucvtf.  */
                                      return 597;
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 10) & 0x1) == 0)
                                {
                                  if (((word >> 12) & 0x1) == 0)
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x000xxxxxx0xx01111x1x
                                                 sha1c.  */
                                              return 540;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x001xxxxxx0xx01111x1x
                                                 sha256h.  */
                                              return 544;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x010xxxxxx0xx01111x1x
                                                 sha1m.  */
                                              return 542;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x011xxxxxx0xx01111x1x
                                                 sha256su1.  */
                                              return 546;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x100xxxxxx0xx01111x1x
                                                 sha1p.  */
                                              return 541;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x101xxxxxx0xx01111x1x
                                                 sha256h2.  */
                                              return 545;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0x11xxxxxxx0xx01111x1x
                                             sha1su0.  */
                                          return 543;
                                        }
                                    }
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxx1xxxxxxxxxx0xx01111x1x
                                     dup.  */
                                  return 430;
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 10) & 0x1) == 0)
                        {
                          if (((word >> 11) & 0x1) == 0)
                            {
                              if (((word >> 12) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000000xxxxx1xx0111000x
                                                             saddl.  */
                                                          return 38;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000000xxxxx1xx0111001x
                                                             saddl2.  */
                                                          return 39;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000000xxxxx1xx0111010x
                                                             uaddl.  */
                                                          return 70;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000000xxxxx1xx0111011x
                                                             uaddl2.  */
                                                          return 71;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 17) & 0x1) == 0)
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              if (((word >> 19) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 20) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000000001xx01111xxx
                                                                         fcvtns.  */
                                                                      return 600;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000000011xx01111xxx
                                                                         fcvtms.  */
                                                                      return 610;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 20) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000000101xx01111xxx
                                                                         fcvtps.  */
                                                                      return 608;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000000111xx01111xxx
                                                                         fcvtzs.  */
                                                                      return 612;
                                                                    }
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000000001xx1xx01111xxx
                                                                 fcvtas.  */
                                                              return 604;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000000010xx1xx01111xxx
                                                                 scvtf.  */
                                                              return 602;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 19) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0000000110x1xx01111xxx
                                                                     fmov.  */
                                                                  return 606;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0000000111x1xx01111xxx
                                                                     fmov.  */
                                                                  return 614;
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 17) & 0x1) == 0)
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              if (((word >> 19) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 20) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000100001xx01111xxx
                                                                         fcvtnu.  */
                                                                      return 601;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000100011xx01111xxx
                                                                         fcvtmu.  */
                                                                      return 611;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 20) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000100101xx01111xxx
                                                                         fcvtpu.  */
                                                                      return 609;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000100111xx01111xxx
                                                                         fcvtzu.  */
                                                                      return 613;
                                                                    }
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000000101xx1xx01111xxx
                                                                 fcvtau.  */
                                                              return 605;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000000110xx1xx01111xxx
                                                                 ucvtf.  */
                                                              return 603;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 19) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0000001110x1xx01111xxx
                                                                     fmov.  */
                                                                  return 607;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0000001111x1xx01111xxx
                                                                     fmov.  */
                                                                  return 615;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 29) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000001xxxxx1xx0111x00x
                                                         smlal.  */
                                                      return 54;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000001xxxxx1xx0111x01x
                                                         smlal2.  */
                                                      return 55;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000001xxxxx1xx0111x10x
                                                         umlal.  */
                                                      return 86;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000001xxxxx1xx0111x11x
                                                         umlal2.  */
                                                      return 87;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 28) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000010xxxxx1xx0111000x
                                                             addhn.  */
                                                          return 46;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000010xxxxx1xx0111001x
                                                             addhn2.  */
                                                          return 47;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000010xxxxx1xx0111010x
                                                             raddhn.  */
                                                          return 78;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000010xxxxx1xx0111011x
                                                             raddhn2.  */
                                                          return 79;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000011xxxxx1xx0111000x
                                                             smull.  */
                                                          return 62;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000011xxxxx1xx0111001x
                                                             smull2.  */
                                                          return 63;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000011xxxxx1xx0111010x
                                                             umull.  */
                                                          return 90;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000011xxxxx1xx0111011x
                                                             umull2.  */
                                                          return 91;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 17) & 0x1) == 0)
                                                {
                                                  if (((word >> 15) & 0x1) == 0)
                                                    {
                                                      if (((word >> 16) & 0x1) == 0)
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000010000xx1xx01111xxx
                                                                 fmov.  */
                                                              return 622;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000010001xx1xx01111xxx
                                                                 frintn.  */
                                                              return 627;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000010100xx1xx01111xxx
                                                                 fneg.  */
                                                              return 624;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000010101xx1xx01111xxx
                                                                 frintm.  */
                                                              return 629;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 16) & 0x1) == 0)
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000011000xx1xx01111xxx
                                                                 fabs.  */
                                                              return 623;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000011001xx1xx01111xxx
                                                                 frintp.  */
                                                              return 628;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000011100xx1xx01111xxx
                                                                 fsqrt.  */
                                                              return 625;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000011101xx1xx01111xxx
                                                                 frintz.  */
                                                              return 630;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 18) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00001xx10xx1xx01111xxx
                                                         fcvt.  */
                                                      return 626;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 15) & 0x1) == 0)
                                                        {
                                                          if (((word >> 16) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000010011xx1xx01111xxx
                                                                 frinta.  */
                                                              return 631;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000010111xx1xx01111xxx
                                                                 frintx.  */
                                                              return 632;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000011x11xx1xx01111xxx
                                                             frinti.  */
                                                          return 633;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000100xxxxx1xx0111000x
                                                             ssubl.  */
                                                          return 42;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000100xxxxx1xx0111001x
                                                             ssubl2.  */
                                                          return 43;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000100xxxxx1xx0111010x
                                                             usubl.  */
                                                          return 74;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000100xxxxx1xx0111011x
                                                             usubl2.  */
                                                          return 75;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 3) & 0x1) == 0)
                                                    {
                                                      if (((word >> 4) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxx00xxxxx000100xxxxx1xx01111xxx
                                                             fcmp.  */
                                                          return 618;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxx01xxxxx000100xxxxx1xx01111xxx
                                                             fcmpe.  */
                                                          return 619;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 4) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxx10xxxxx000100xxxxx1xx01111xxx
                                                             fcmp.  */
                                                          return 620;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxx11xxxxx000100xxxxx1xx01111xxx
                                                             fcmpe.  */
                                                          return 621;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 29) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000101xxxxx1xx0111x00x
                                                         smlsl.  */
                                                      return 58;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000101xxxxx1xx0111x01x
                                                         smlsl2.  */
                                                      return 59;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000101xxxxx1xx0111x10x
                                                         umlsl.  */
                                                      return 88;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000101xxxxx1xx0111x11x
                                                         umlsl2.  */
                                                      return 89;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 29) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000110xxxxx1xx0111x00x
                                                         subhn.  */
                                                      return 50;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000110xxxxx1xx0111x01x
                                                         subhn2.  */
                                                      return 51;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000110xxxxx1xx0111x10x
                                                         rsubhn.  */
                                                      return 82;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000110xxxxx1xx0111x11x
                                                         rsubhn2.  */
                                                      return 83;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000111xxxxx10x0111xx0x
                                                         pmull.  */
                                                      return 66;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000111xxxxx10x0111xx1x
                                                         pmull2.  */
                                                      return 68;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000111xxxxx11x0111xx0x
                                                         pmull.  */
                                                      return 67;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000111xxxxx11x0111xx1x
                                                         pmull2.  */
                                                      return 69;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 28) & 0x1) == 0)
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001000xxxxx1xx0111000x
                                                             saddw.  */
                                                          return 40;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001000xxxxx1xx0111001x
                                                             saddw2.  */
                                                          return 41;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001000xxxxx1xx0111010x
                                                             uaddw.  */
                                                          return 72;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001000xxxxx1xx0111011x
                                                             uaddw2.  */
                                                          return 73;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx001001xxxxx1xx01110x0x
                                                         sqdmlal.  */
                                                      return 56;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx001001xxxxx1xx01110x1x
                                                         sqdmlal2.  */
                                                      return 57;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001010xxxxx1xx0111000x
                                                             sabal.  */
                                                          return 48;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001010xxxxx1xx0111001x
                                                             sabal2.  */
                                                          return 49;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001010xxxxx1xx0111010x
                                                             uabal.  */
                                                          return 80;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001010xxxxx1xx0111011x
                                                             uabal2.  */
                                                          return 81;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx001011xxxxx1xx01110x0x
                                                         sqdmull.  */
                                                      return 64;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx001011xxxxx1xx01110x1x
                                                         sqdmull2.  */
                                                      return 65;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001100xxxxx1xx0111000x
                                                             ssubw.  */
                                                          return 44;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001100xxxxx1xx0111001x
                                                             ssubw2.  */
                                                          return 45;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001100xxxxx1xx0111010x
                                                             usubw.  */
                                                          return 76;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001100xxxxx1xx0111011x
                                                             usubw2.  */
                                                          return 77;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx001101xxxxx1xx01110x0x
                                                         sqdmlsl.  */
                                                      return 60;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx001101xxxxx1xx01110x1x
                                                         sqdmlsl2.  */
                                                      return 61;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 29) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00111xxxxxx1xx0111000x
                                                         sabdl.  */
                                                      return 52;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00111xxxxxx1xx0111001x
                                                         sabdl2.  */
                                                      return 53;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00111xxxxxx1xx0111010x
                                                         uabdl.  */
                                                      return 84;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00111xxxxxx1xx0111011x
                                                         uabdl2.  */
                                                      return 85;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx001xxxxxxxx1xx01111x0x
                                             fmov.  */
                                          return 647;
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00100xxxxxx1xx01111x1x
                                                     sqdmlal.  */
                                                  return 343;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00101xxxxxx1xx01111x1x
                                                     sqdmull.  */
                                                  return 345;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0011xxxxxxx1xx01111x1x
                                                 sqdmlsl.  */
                                              return 344;
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 12) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010000xxxxx1xx011100xx
                                                         rev64.  */
                                                      return 144;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010000xxxxx1xx011101xx
                                                         rev32.  */
                                                      return 180;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010000xxxxx1xx01111x0x
                                                         fmul.  */
                                                      return 634;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010000xxxxx1xx01111x1x
                                                         sha1h.  */
                                                      return 537;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0100010xxxx1xx011100xx
                                                             cmgt.  */
                                                          return 152;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0100010xxxx1xx011101xx
                                                             cmge.  */
                                                          return 186;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100011xxxx1x0011100xx
                                                                 frintn.  */
                                                              return 164;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100011xxxx1x0011101xx
                                                                 frinta.  */
                                                              return 197;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0100011xxxx1x101110xxx
                                                             frintp.  */
                                                          return 174;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx010001xxxxx1xx0111100x
                                                             fnmul.  */
                                                          return 642;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx010001xxxxx1xx0111101x
                                                             cmgt.  */
                                                          return 397;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010001xxxxx1xx011111xx
                                                         cmge.  */
                                                      return 415;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100100xx0x1xx011100xx
                                                                 cls.  */
                                                              return 148;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100100xx0x1xx011101xx
                                                                 clz.  */
                                                              return 183;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0100100xx1x1xx01110xxx
                                                             aese.  */
                                                          return 533;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100101xxxx1xx0111000x
                                                                 sqxtn.  */
                                                              return 158;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100101xxxx1xx0111001x
                                                                 sqxtn2.  */
                                                              return 159;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100101xxxx1xx0111010x
                                                                 uqxtn.  */
                                                              return 193;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100101xxxx1xx0111011x
                                                                 uqxtn2.  */
                                                              return 194;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx010010xxxxx1xx0111100x
                                                             fmax.  */
                                                          return 638;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx010010xxxxx1xx0111101x
                                                             sqxtn.  */
                                                          return 401;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010010xxxxx1xx011111xx
                                                         uqxtn.  */
                                                      return 419;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 20) & 0x1) == 0)
                                                    {
                                                      if (((word >> 28) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100110xxx01xx011100xx
                                                                 fcmgt.  */
                                                              return 170;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100110xxx01xx011101xx
                                                                 fcmge.  */
                                                              return 206;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100110xxx01xx011110xx
                                                                 fcmgt.  */
                                                              return 406;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100110xxx01xx011111xx
                                                                 fcmge.  */
                                                              return 425;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100110xxx11x001110xxx
                                                                 fmaxnmv.  */
                                                              return 34;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100110xxx11x001111xxx
                                                                 fmaxnmp.  */
                                                              return 433;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100110xxx11x101110xxx
                                                                 fminnmv.  */
                                                              return 36;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100110xxx11x101111xxx
                                                                 fminnmp.  */
                                                              return 436;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 28) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100111xxxx1x0011100xx
                                                                 fcvtas.  */
                                                              return 168;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100111xxxx1x0011101xx
                                                                 fcvtau.  */
                                                              return 201;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100111xxxx1x0011110xx
                                                                 fcvtas.  */
                                                              return 404;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100111xxxx1x0011111xx
                                                                 fcvtau.  */
                                                              return 423;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0100111xxxx1x10111x0xx
                                                             urecpe.  */
                                                          return 178;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0100111xxxx1x10111x1xx
                                                             ursqrte.  */
                                                          return 212;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0101000xxxx1xx011100xx
                                                             saddlp.  */
                                                          return 146;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0101000xxxx1xx011101xx
                                                             uaddlp.  */
                                                          return 181;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101001xxxx1xx0111000x
                                                                 xtn.  */
                                                              return 156;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101001xxxx1xx0111001x
                                                                 xtn2.  */
                                                              return 157;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101001xxxx1xx0111010x
                                                                 sqxtun.  */
                                                              return 189;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101001xxxx1xx0111011x
                                                                 sqxtun2.  */
                                                              return 190;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx010100xxxxx1xx0111100x
                                                             fadd.  */
                                                          return 636;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx010100xxxxx1xx0111101x
                                                             sha256su0.  */
                                                          return 539;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010100xxxxx1xx011111xx
                                                         sqxtun.  */
                                                      return 418;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 20) & 0x1) == 0)
                                                    {
                                                      if (((word >> 28) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0101010xxx01xx01110xxx
                                                             cmlt.  */
                                                          return 154;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0101010xxx01xx01111xxx
                                                             cmlt.  */
                                                          return 399;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0101010xxx11xx0111x0xx
                                                             smaxv.  */
                                                          return 28;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0101010xxx11xx0111x1xx
                                                             umaxv.  */
                                                          return 32;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 20) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0101011xxx01x0011100xx
                                                                     fcvtns.  */
                                                                  return 166;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0101011xxx01x0011101xx
                                                                     fcvtnu.  */
                                                                  return 199;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0101011xxx01x0011110xx
                                                                     fcvtns.  */
                                                                  return 402;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0101011xxx01x0011111xx
                                                                     fcvtnu.  */
                                                                  return 421;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0101011xxx01x1011100xx
                                                                     fcvtps.  */
                                                                  return 176;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0101011xxx01x1011101xx
                                                                     fcvtpu.  */
                                                                  return 210;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0101011xxx01x1011110xx
                                                                     fcvtps.  */
                                                                  return 409;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0101011xxx01x1011111xx
                                                                     fcvtpu.  */
                                                                  return 427;
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0101011xxx11xx0111x0xx
                                                             sminv.  */
                                                          return 29;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0101011xxx11xx0111x1xx
                                                             uminv.  */
                                                          return 33;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101100xx0x1xx011100xx
                                                                 sadalp.  */
                                                              return 150;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101100xx0x1xx011101xx
                                                                 uadalp.  */
                                                              return 184;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0101100xx1x1xx01110xxx
                                                             aesmc.  */
                                                          return 535;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101101xxxx1xx0111000x
                                                                 fcvtn.  */
                                                              return 160;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101101xxxx1xx0111001x
                                                                 fcvtn2.  */
                                                              return 161;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101101xxxx1xx0111010x
                                                                 fcvtxn.  */
                                                              return 195;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101101xxxx1xx0111011x
                                                                 fcvtxn2.  */
                                                              return 196;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010110xxxxx1xx011110xx
                                                         fmaxnm.  */
                                                      return 640;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010110xxxxx1xx011111xx
                                                         fcvtxn.  */
                                                      return 420;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx010111xxxxx1xx01110xxx
                                                     fcmlt.  */
                                                  return 172;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx010111xxxxx1xx01111xxx
                                                     fcmlt.  */
                                                  return 408;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx011000xxxxx1xx01110xxx
                                                     rev16.  */
                                                  return 145;
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx011000xxxxx1xx01111x0x
                                                         fdiv.  */
                                                      return 635;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx011000xxxxx1xx01111x1x
                                                         sha1su1.  */
                                                      return 538;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 28) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0110010xxxx1xx011100xx
                                                             cmeq.  */
                                                          return 153;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0110010xxxx1xx011101xx
                                                             cmle.  */
                                                          return 187;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0110010xxxx1xx011110xx
                                                             cmeq.  */
                                                          return 398;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0110010xxxx1xx011111xx
                                                             cmle.  */
                                                          return 416;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0110011xxxx1x00111x0xx
                                                             frintm.  */
                                                          return 165;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0110011xxxx1x00111x1xx
                                                             frintx.  */
                                                          return 198;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0110011xxxx1x10111x0xx
                                                             frintz.  */
                                                          return 175;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0110011xxxx1x10111x1xx
                                                             frinti.  */
                                                          return 209;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 19) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx011010xxx0x1xx011100xx
                                                             cnt.  */
                                                          return 149;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx011010xxx0x10x011101xx
                                                                 not.  */
                                                              return 203;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx011010xxx0x11x011101xx
                                                                 rbit.  */
                                                              return 205;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx011010xxx1x1xx01110xxx
                                                         aesd.  */
                                                      return 534;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx011010xxxxx1xx01111xxx
                                                     fmin.  */
                                                  return 639;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 20) & 0x1) == 0)
                                                    {
                                                      if (((word >> 28) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110110xxx01xx011100xx
                                                                 fcmeq.  */
                                                              return 171;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110110xxx01xx011101xx
                                                                 fcmle.  */
                                                              return 207;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110110xxx01xx011110xx
                                                                 fcmeq.  */
                                                              return 407;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110110xxx01xx011111xx
                                                                 fcmle.  */
                                                              return 426;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx0110110xxx11xx0111xxxx
                                                         faddp.  */
                                                      return 434;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 28) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110111xxxx1x0011100xx
                                                                 scvtf.  */
                                                              return 169;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110111xxxx1x0011101xx
                                                                 ucvtf.  */
                                                              return 202;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110111xxxx1x0011110xx
                                                                 scvtf.  */
                                                              return 405;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110111xxxx1x0011111xx
                                                                 ucvtf.  */
                                                              return 424;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 28) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110111xxxx1x1011100xx
                                                                 frecpe.  */
                                                              return 179;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110111xxxx1x1011101xx
                                                                 frsqrte.  */
                                                              return 213;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110111xxxx1x1011110xx
                                                                 frecpe.  */
                                                              return 411;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110111xxxx1x1011111xx
                                                                 frsqrte.  */
                                                              return 429;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111000xxx01xx011100xx
                                                                 suqadd.  */
                                                              return 147;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111000xxx01xx011101xx
                                                                 usqadd.  */
                                                              return 182;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111000xxx11xx011100xx
                                                                 saddlv.  */
                                                              return 27;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111000xxx11xx011101xx
                                                                 uaddlv.  */
                                                              return 31;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111001xxxx1xx01110x0x
                                                             shll.  */
                                                          return 191;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111001xxxx1xx01110x1x
                                                             shll2.  */
                                                          return 192;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx011100xxxxx1xx0111100x
                                                             fsub.  */
                                                          return 637;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx011100xxxxx1xx0111101x
                                                             suqadd.  */
                                                          return 395;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx011100xxxxx1xx011111xx
                                                         usqadd.  */
                                                      return 413;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 28) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111010xxxx1xx011100xx
                                                             abs.  */
                                                          return 155;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111010xxxx1xx011101xx
                                                             neg.  */
                                                          return 188;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111010xxxx1xx011110xx
                                                             abs.  */
                                                          return 400;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111010xxxx1xx011111xx
                                                             neg.  */
                                                          return 417;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 20) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0111011xxx01x0011100xx
                                                                     fcvtms.  */
                                                                  return 167;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0111011xxx01x0011101xx
                                                                     fcvtmu.  */
                                                                  return 200;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0111011xxx01x0011110xx
                                                                     fcvtms.  */
                                                                  return 403;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0111011xxx01x0011111xx
                                                                     fcvtmu.  */
                                                                  return 422;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0111011xxx01x1011100xx
                                                                     fcvtzs.  */
                                                                  return 177;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0111011xxx01x1011101xx
                                                                     fcvtzu.  */
                                                                  return 211;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0111011xxx01x1011110xx
                                                                     fcvtzs.  */
                                                                  return 410;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0111011xxx01x1011111xx
                                                                     fcvtzu.  */
                                                                  return 428;
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 28) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111011xxx11xx01110xxx
                                                             addv.  */
                                                          return 30;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111011xxx11xx01111xxx
                                                             addp.  */
                                                          return 432;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111100xx0x1xx011100xx
                                                                 sqabs.  */
                                                              return 151;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111100xx0x1xx011101xx
                                                                 sqneg.  */
                                                              return 185;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111100xx1x1xx01110xxx
                                                             aesimc.  */
                                                          return 536;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111101xxxx1xx01110x0x
                                                             fcvtl.  */
                                                          return 162;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111101xxxx1xx01110x1x
                                                             fcvtl2.  */
                                                          return 163;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx011110xxxxx1xx0111100x
                                                             fminnm.  */
                                                          return 641;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx011110xxxxx1xx0111101x
                                                             sqabs.  */
                                                          return 396;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx011110xxxxx1xx011111xx
                                                         sqneg.  */
                                                      return 414;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 20) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111110xxx01xx0111x0xx
                                                             fabs.  */
                                                          return 173;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111110xxx01xx0111x1xx
                                                             fneg.  */
                                                          return 208;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111110xxx11x001110xxx
                                                                 fmaxv.  */
                                                              return 35;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111110xxx11x001111xxx
                                                                 fmaxp.  */
                                                              return 435;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111110xxx11x101110xxx
                                                                 fminv.  */
                                                              return 37;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111110xxx11x101111xxx
                                                                 fminp.  */
                                                              return 437;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 28) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx0111111xxxx1xx01110xxx
                                                         fsqrt.  */
                                                      return 214;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx0111111xxxx1xx01111xxx
                                                         frecpx.  */
                                                      return 412;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 11) & 0x1) == 0)
                            {
                              if (((word >> 28) & 0x1) == 0)
                                {
                                  if (((word >> 12) & 0x1) == 0)
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100000xxxxx1xx011100xx
                                                         shadd.  */
                                                      return 221;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100000xxxxx1xx011101xx
                                                         uhadd.  */
                                                      return 261;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100001xxxxx1xx011100xx
                                                         add.  */
                                                      return 236;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100001xxxxx1xx011101xx
                                                         sub.  */
                                                      return 276;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100010xxxxx1xx011100xx
                                                         sshl.  */
                                                      return 228;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100010xxxxx1xx011101xx
                                                         ushl.  */
                                                      return 268;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx100011xxxxx1x0011100xx
                                                             fmaxnm.  */
                                                          return 244;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx100011xxxxx1x0011101xx
                                                             fmaxnmp.  */
                                                          return 283;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx100011xxxxx1x1011100xx
                                                             fminnm.  */
                                                          return 253;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx100011xxxxx1x1011101xx
                                                             fminnmp.  */
                                                          return 292;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100100xxxxx1xx011100xx
                                                         shsub.  */
                                                      return 224;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100100xxxxx1xx011101xx
                                                         uhsub.  */
                                                      return 264;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100101xxxxx1xx011100xx
                                                         smaxp.  */
                                                      return 240;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100101xxxxx1xx011101xx
                                                         umaxp.  */
                                                      return 280;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100110xxxxx1xx011100xx
                                                         smax.  */
                                                      return 232;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100110xxxxx1xx011101xx
                                                         umax.  */
                                                      return 272;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx100111xxxxx1x0011100xx
                                                             fcmeq.  */
                                                          return 248;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx100111xxxxx1x0011101xx
                                                             fcmge.  */
                                                          return 286;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100111xxxxx1x101110xxx
                                                         fcmgt.  */
                                                      return 294;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101000xxxxx1xx011100xx
                                                         srhadd.  */
                                                      return 223;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101000xxxxx1xx011101xx
                                                         urhadd.  */
                                                      return 263;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101001xxxxx1xx011100xx
                                                         mla.  */
                                                      return 238;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101001xxxxx1xx011101xx
                                                         mls.  */
                                                      return 278;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101010xxxxx1xx011100xx
                                                         srshl.  */
                                                      return 230;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101010xxxxx1xx011101xx
                                                         urshl.  */
                                                      return 270;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx101011xxxxx1x0011100xx
                                                             fadd.  */
                                                          return 246;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx101011xxxxx1x0011101xx
                                                             faddp.  */
                                                          return 284;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx101011xxxxx1x1011100xx
                                                             fsub.  */
                                                          return 255;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx101011xxxxx1x1011101xx
                                                             fabd.  */
                                                          return 293;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101100xxxxx1xx011100xx
                                                         cmgt.  */
                                                      return 226;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101100xxxxx1xx011101xx
                                                         cmhi.  */
                                                      return 266;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101101xxxxx1xx011100xx
                                                         sqdmulh.  */
                                                      return 242;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101101xxxxx1xx011101xx
                                                         sqrdmulh.  */
                                                      return 282;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101110xxxxx1xx011100xx
                                                         sabd.  */
                                                      return 234;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101110xxxxx1xx011101xx
                                                         uabd.  */
                                                      return 274;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx101111xxxxx1x0011100xx
                                                             fmax.  */
                                                          return 249;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx101111xxxxx1x0011101xx
                                                             fmaxp.  */
                                                          return 288;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx101111xxxxx1x1011100xx
                                                             fmin.  */
                                                          return 256;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx101111xxxxx1x1011101xx
                                                             fminp.  */
                                                          return 296;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 29) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 4) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxx0xxxxx10xxxxxxxxx1xx0111100x
                                                 fccmp.  */
                                              return 616;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxx1xxxxx10xxxxxxxxx1xx0111100x
                                                 fccmpe.  */
                                              return 617;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx10000xxxxxx1xx0111101x
                                                         add.  */
                                                      return 451;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx10001xxxxxx1xx0111101x
                                                         sshl.  */
                                                      return 449;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1001xxxxxxx1xx0111101x
                                                     fcmeq.  */
                                                  return 444;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1010xxxxxxx1xx0111101x
                                                     srshl.  */
                                                  return 450;
                                                }
                                              else
                                                {
                                                  if (((word >> 15) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx1011x0xxxxx1xx0111101x
                                                         cmgt.  */
                                                      return 447;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx1011x1xxxxx1xx0111101x
                                                         sqdmulh.  */
                                                      return 442;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx10000xxxxxx1xx011111xx
                                                     sub.  */
                                                  return 467;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx10001xxxxxx1xx011111xx
                                                     ushl.  */
                                                  return 465;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1001xxxxxxx1x0011111xx
                                                     fcmge.  */
                                                  return 458;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1001xxxxxxx1x1011111xx
                                                     fcmgt.  */
                                                  return 461;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1010x0xxxxx1xx011111xx
                                                     urshl.  */
                                                  return 466;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1010x1xxxxx1xx011111xx
                                                     fabd.  */
                                                  return 460;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1011x0xxxxx1xx011111xx
                                                     cmhi.  */
                                                  return 463;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1011x1xxxxx1xx011111xx
                                                     sqrdmulh.  */
                                                  return 457;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 28) & 0x1) == 0)
                                {
                                  if (((word >> 12) & 0x1) == 0)
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110000xxxxx1xx011100xx
                                                         sqadd.  */
                                                      return 222;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110000xxxxx1xx011101xx
                                                         uqadd.  */
                                                      return 262;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110001xxxxx1xx011100xx
                                                         cmtst.  */
                                                      return 237;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110001xxxxx1xx011101xx
                                                         cmeq.  */
                                                      return 277;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110010xxxxx1xx011100xx
                                                         sqshl.  */
                                                      return 229;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110010xxxxx1xx011101xx
                                                         uqshl.  */
                                                      return 269;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110011xxxxx1x001110xxx
                                                         fmla.  */
                                                      return 245;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110011xxxxx1x101110xxx
                                                         fmls.  */
                                                      return 254;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110100xxxxx1xx011100xx
                                                         sqsub.  */
                                                      return 225;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110100xxxxx1xx011101xx
                                                         uqsub.  */
                                                      return 265;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110101xxxxx1xx011100xx
                                                         sminp.  */
                                                      return 241;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110101xxxxx1xx011101xx
                                                         uminp.  */
                                                      return 281;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110110xxxxx1xx011100xx
                                                         smin.  */
                                                      return 233;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110110xxxxx1xx011101xx
                                                         umin.  */
                                                      return 273;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110111xxxxx1x001110xxx
                                                         facge.  */
                                                      return 287;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110111xxxxx1x101110xxx
                                                         facgt.  */
                                                      return 295;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx111000xxxxx100011100xx
                                                                 and.  */
                                                              return 251;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx111000xxxxx100011101xx
                                                                 eor.  */
                                                              return 290;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx111000xxxxx101011100xx
                                                                 orr.  */
                                                              return 258;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx111000xxxxx101011101xx
                                                                 bit.  */
                                                              return 297;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx111000xxxxx110011100xx
                                                                 bic.  */
                                                              return 252;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx111000xxxxx110011101xx
                                                                 bsl.  */
                                                              return 291;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx111000xxxxx111011100xx
                                                                 orn.  */
                                                              return 260;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx111000xxxxx111011101xx
                                                                 bif.  */
                                                              return 298;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111001xxxxx1xx011100xx
                                                         mul.  */
                                                      return 239;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111001xxxxx1xx011101xx
                                                         pmul.  */
                                                      return 279;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111010xxxxx1xx011100xx
                                                         sqrshl.  */
                                                      return 231;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111010xxxxx1xx011101xx
                                                         uqrshl.  */
                                                      return 271;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111011xxxxx1xx011100xx
                                                         fmulx.  */
                                                      return 247;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111011xxxxx1xx011101xx
                                                         fmul.  */
                                                      return 285;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111100xxxxx1xx011100xx
                                                         cmge.  */
                                                      return 227;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111100xxxxx1xx011101xx
                                                         cmhs.  */
                                                      return 267;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx111101xxxxx1xx01110xxx
                                                     addp.  */
                                                  return 243;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111110xxxxx1xx011100xx
                                                         saba.  */
                                                      return 235;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111110xxxxx1xx011101xx
                                                         uaba.  */
                                                      return 275;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx111111xxxxx1x0011100xx
                                                             frecps.  */
                                                          return 250;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx111111xxxxx1x0011101xx
                                                             fdiv.  */
                                                          return 289;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111111xxxxx1x101110xxx
                                                         frsqrts.  */
                                                      return 257;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 29) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx11xxxxxxxxx1xx0111100x
                                             fcsel.  */
                                          return 648;
                                        }
                                      else
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      if (((word >> 15) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx110000xxxxx1xx0111101x
                                                             sqadd.  */
                                                          return 438;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx110001xxxxx1xx0111101x
                                                             cmtst.  */
                                                          return 452;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx11001xxxxxx1xx0111101x
                                                         sqshl.  */
                                                      return 440;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1101xxxxxxx1xx0111101x
                                                     sqsub.  */
                                                  return 439;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 15) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx1110x0xxxxx1xx0111101x
                                                         sqrshl.  */
                                                      return 441;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx1110x1xxxxx1xx0111101x
                                                         fmulx.  */
                                                      return 443;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx11110xxxxxx1xx0111101x
                                                         cmge.  */
                                                      return 448;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx11111xxxxxx1x00111101x
                                                             frecps.  */
                                                          return 445;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx11111xxxxxx1x10111101x
                                                             frsqrts.  */
                                                          return 446;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 15) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110000xxxxx1xx011111xx
                                                         uqadd.  */
                                                      return 453;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110001xxxxx1xx011111xx
                                                         cmeq.  */
                                                      return 468;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx11001xxxxxx1xx011111xx
                                                     uqshl.  */
                                                  return 455;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx11010xxxxxx1xx011111xx
                                                     uqsub.  */
                                                  return 454;
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx11011xxxxxx1x0011111xx
                                                         facge.  */
                                                      return 459;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx11011xxxxxx1x1011111xx
                                                         facgt.  */
                                                      return 462;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1110xxxxxxx1xx011111xx
                                                 uqrshl.  */
                                              return 456;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1111xxxxxxx1xx011111xx
                                                 cmhs.  */
                                              return 464;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
              else
                {
                  if (((word >> 15) & 0x1) == 0)
                    {
                      if (((word >> 28) & 0x1) == 0)
                        {
                          if (((word >> 10) & 0x1) == 0)
                            {
                              if (((word >> 12) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0x0000xxxxxxxx11110xxx
                                             mla.  */
                                          return 110;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0x0010xxxxxxxx11110xxx
                                             mls.  */
                                          return 113;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x0100xxxxxxxx1111000x
                                                     smlal.  */
                                                  return 92;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x0100xxxxxxxx1111001x
                                                     smlal2.  */
                                                  return 93;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x0100xxxxxxxx1111010x
                                                     umlal.  */
                                                  return 111;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x0100xxxxxxxx1111011x
                                                     umlal2.  */
                                                  return 112;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x0110xxxxxxxx1111000x
                                                     smlsl.  */
                                                  return 96;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x0110xxxxxxxx1111001x
                                                     smlsl2.  */
                                                  return 97;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x0110xxxxxxxx1111010x
                                                     umlsl.  */
                                                  return 114;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x0110xxxxxxxx1111011x
                                                     umlsl2.  */
                                                  return 115;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0x1000xxxxxxxx11110xxx
                                             fmla.  */
                                          return 107;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0x1010xxxxxxxx11110xxx
                                             fmls.  */
                                          return 108;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1100xxxxxxxx11110x0x
                                                 sqdmlal.  */
                                              return 94;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1100xxxxxxxx11110x1x
                                                 sqdmlal2.  */
                                              return 95;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1110xxxxxxxx11110x0x
                                                 sqdmlsl.  */
                                              return 98;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1110xxxxxxxx11110x1x
                                                 sqdmlsl2.  */
                                              return 99;
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 12) & 0x1) == 0)
                                {
                                  if (((word >> 29) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx1x0xx0xxxxxxxx111100xx
                                         movi.  */
                                      return 120;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx1x0xx0xxxxxxxx111101xx
                                         mvni.  */
                                      return 127;
                                    }
                                }
                              else
                                {
                                  if (((word >> 29) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx1x1xx0xxxxxxxx111100xx
                                         orr.  */
                                      return 121;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx1x1xx0xxxxxxxx111101xx
                                         bic.  */
                                      return 128;
                                    }
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxx0xxxxx0xx1111100x
                                         fmadd.  */
                                      return 643;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxx0xxxxx1xx1111100x
                                         fnmadd.  */
                                      return 645;
                                    }
                                }
                              else
                                {
                                  if (((word >> 10) & 0x1) == 0)
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0xx000xxxxxxxx1111101x
                                                 fmla.  */
                                              return 351;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0xx010xxxxxxxx1111101x
                                                 fmls.  */
                                              return 352;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0xx100xxxxxxxx1111101x
                                                 sqdmlal.  */
                                              return 346;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0xx110xxxxxxxx1111101x
                                                 sqdmlsl.  */
                                              return 347;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1x00x0xxxxxxxx1111101x
                                                 sshr.  */
                                              return 469;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1x01x0xxxxxxxx1111101x
                                                 srshr.  */
                                              return 471;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1x1000xxxxxxxx1111101x
                                                     ssra.  */
                                                  return 470;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1x1010xxxxxxxx1111101x
                                                     shl.  */
                                                  return 473;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1x1100xxxxxxxx1111101x
                                                     srsra.  */
                                                  return 472;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1x1110xxxxxxxx1111101x
                                                     sqshl.  */
                                                  return 474;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 12) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxx0000xxxxxxxx111111xx
                                             ushr.  */
                                          return 479;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxx0010xxxxxxxx111111xx
                                             sri.  */
                                          return 483;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxx0100xxxxxxxx111111xx
                                             urshr.  */
                                          return 481;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxx0110xxxxxxxx111111xx
                                             sqshlu.  */
                                          return 485;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxx1000xxxxxxxx111111xx
                                             usra.  */
                                          return 480;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxx1010xxxxxxxx111111xx
                                             sli.  */
                                          return 484;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxx1100xxxxxxxx111111xx
                                             ursra.  */
                                          return 482;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxx1110xxxxxxxx111111xx
                                             uqshl.  */
                                          return 486;
                                        }
                                    }
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 28) & 0x1) == 0)
                        {
                          if (((word >> 10) & 0x1) == 0)
                            {
                              if (((word >> 12) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0x0001xxxxxxxx11110xxx
                                             mul.  */
                                          return 100;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0x0011xxxxxxxx11110xxx
                                             sqdmulh.  */
                                          return 105;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 29) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x01x1xxxxxxxx1111000x
                                                 smull.  */
                                              return 101;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x01x1xxxxxxxx1111001x
                                                 smull2.  */
                                              return 102;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x01x1xxxxxxxx1111010x
                                                 umull.  */
                                              return 116;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x01x1xxxxxxxx1111011x
                                                 umull2.  */
                                              return 117;
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1001xxxxxxxx111100xx
                                                 fmul.  */
                                              return 109;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1001xxxxxxxx111101xx
                                                 fmulx.  */
                                              return 118;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0x1011xxxxxxxx11110xxx
                                             sqrdmulh.  */
                                          return 106;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0x11x1xxxxxxxx11110x0x
                                             sqdmull.  */
                                          return 103;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0x11x1xxxxxxxx11110x1x
                                             sqdmull2.  */
                                          return 104;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 11) & 0x1) == 0)
                                {
                                  if (((word >> 14) & 0x1) == 0)
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx100x01xxxxxxxx111100xx
                                                 movi.  */
                                              return 122;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx100x01xxxxxxxx111101xx
                                                 mvni.  */
                                              return 129;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx101x01xxxxxxxx111100xx
                                                 orr.  */
                                              return 123;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx101x01xxxxxxxx111101xx
                                                 bic.  */
                                              return 130;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx10x011xxxxxxxx111100xx
                                                 movi.  */
                                              return 124;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx10x011xxxxxxxx111101xx
                                                 mvni.  */
                                              return 131;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 29) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx100111xxxxxxxx111100xx
                                                     movi.  */
                                                  return 125;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx100111xxxxxxxx111101xx
                                                     movi.  */
                                                  return 132;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 29) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx101111xxxxxxxx111100xx
                                                     fmov.  */
                                                  return 126;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx101111xxxxxxxx111101xx
                                                     fmov.  */
                                                  return 134;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 12) & 0x1) == 0)
                                    {
                                      if (((word >> 29) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx110xx1xxxxxxxx1111000x
                                                 rshrn.  */
                                              return 307;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx110xx1xxxxxxxx1111001x
                                                 rshrn2.  */
                                              return 308;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx110xx1xxxxxxxx1111010x
                                                 sqrshrun.  */
                                              return 329;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx110xx1xxxxxxxx1111011x
                                                 sqrshrun2.  */
                                              return 330;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1110x1xxxxxxxx1111000x
                                                     sqrshrn.  */
                                                  return 311;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1110x1xxxxxxxx1111001x
                                                     sqrshrn2.  */
                                                  return 312;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1110x1xxxxxxxx1111010x
                                                     uqrshrn.  */
                                                  return 333;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1110x1xxxxxxxx1111011x
                                                     uqrshrn2.  */
                                                  return 334;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1111x1xxxxxxxx111100xx
                                                 fcvtzs.  */
                                              return 318;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1111x1xxxxxxxx111101xx
                                                 fcvtzu.  */
                                              return 340;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxx1xxxxx0xx1111100x
                                         fmsub.  */
                                      return 644;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxx1xxxxx1xx1111100x
                                         fnmsub.  */
                                      return 646;
                                    }
                                }
                              else
                                {
                                  if (((word >> 10) & 0x1) == 0)
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0x0xx1xxxxxxxx1111101x
                                             sqdmulh.  */
                                          return 349;
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x1001xxxxxxxx1111101x
                                                     fmul.  */
                                                  return 353;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x1011xxxxxxxx1111101x
                                                     sqrdmulh.  */
                                                  return 350;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x11x1xxxxxxxx1111101x
                                                 sqdmull.  */
                                              return 348;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 11) & 0x1) == 0)
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx100xx1xxxxxxxx1111101x
                                                 scvtf.  */
                                              return 477;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx101xx1xxxxxxxx1111101x
                                                 sqshrn.  */
                                              return 475;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx11x0x1xxxxxxxx1111101x
                                                 sqrshrn.  */
                                              return 476;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx11x1x1xxxxxxxx1111101x
                                                 fcvtzs.  */
                                              return 478;
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 10) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxx0xxxx1xxxxxxxx111111xx
                                     fmulx.  */
                                  return 354;
                                }
                              else
                                {
                                  if (((word >> 11) & 0x1) == 0)
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1000x1xxxxxxxx111111xx
                                                 sqshrun.  */
                                              return 487;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1001x1xxxxxxxx111111xx
                                                 ucvtf.  */
                                              return 491;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx101xx1xxxxxxxx111111xx
                                             uqshrn.  */
                                          return 489;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx110xx1xxxxxxxx111111xx
                                             sqrshrun.  */
                                          return 488;
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1110x1xxxxxxxx111111xx
                                                 uqrshrn.  */
                                              return 490;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1111x1xxxxxxxx111111xx
                                                 fcvtzu.  */
                                              return 492;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

/* Lookup opcode WORD in the opcode table.  N.B. all alias
   opcodes are ignored here.  */

const aarch64_opcode *
aarch64_opcode_lookup (uint32_t word)
{
  return aarch64_opcode_table + aarch64_opcode_lookup_1 (word);
}

const aarch64_opcode *
aarch64_find_next_opcode (const aarch64_opcode *opcode)
{
  /* Use the index as the key to locate the next opcode.  */
  int key = opcode - aarch64_opcode_table;
  int value;
  switch (key)
    {
    case 739: value = 743; break;	/* stnp --> stp.  */
    case 743: return NULL;		/* stp --> NULL.  */
    case 740: value = 744; break;	/* ldnp --> ldp.  */
    case 744: return NULL;		/* ldp --> NULL.  */
    case 355: value = 356; break;	/* st4 --> st1.  */
    case 356: value = 357; break;	/* st1 --> st2.  */
    case 357: value = 358; break;	/* st2 --> st3.  */
    case 358: return NULL;		/* st3 --> NULL.  */
    case 363: value = 364; break;	/* st4 --> st1.  */
    case 364: value = 365; break;	/* st1 --> st2.  */
    case 365: value = 366; break;	/* st2 --> st3.  */
    case 366: return NULL;		/* st3 --> NULL.  */
    case 359: value = 360; break;	/* ld4 --> ld1.  */
    case 360: value = 361; break;	/* ld1 --> ld2.  */
    case 361: value = 362; break;	/* ld2 --> ld3.  */
    case 362: return NULL;		/* ld3 --> NULL.  */
    case 375: value = 377; break;	/* ld1 --> ld1r.  */
    case 377: return NULL;		/* ld1r --> NULL.  */
    case 379: value = 381; break;	/* ld2 --> ld2r.  */
    case 381: return NULL;		/* ld2r --> NULL.  */
    case 376: value = 378; break;	/* ld3 --> ld3r.  */
    case 378: return NULL;		/* ld3r --> NULL.  */
    case 380: value = 382; break;	/* ld4 --> ld4r.  */
    case 382: return NULL;		/* ld4r --> NULL.  */
    case 367: value = 368; break;	/* ld4 --> ld1.  */
    case 368: value = 369; break;	/* ld1 --> ld2.  */
    case 369: value = 370; break;	/* ld2 --> ld3.  */
    case 370: return NULL;		/* ld3 --> NULL.  */
    case 387: value = 389; break;	/* ld1 --> ld1r.  */
    case 389: return NULL;		/* ld1r --> NULL.  */
    case 388: value = 390; break;	/* ld3 --> ld3r.  */
    case 390: return NULL;		/* ld3r --> NULL.  */
    case 391: value = 393; break;	/* ld2 --> ld2r.  */
    case 393: return NULL;		/* ld2r --> NULL.  */
    case 392: value = 394; break;	/* ld4 --> ld4r.  */
    case 394: return NULL;		/* ld4r --> NULL.  */
    case 120: value = 299; break;	/* movi --> sshr.  */
    case 299: value = 301; break;	/* sshr --> srshr.  */
    case 301: return NULL;		/* srshr --> NULL.  */
    case 127: value = 319; break;	/* mvni --> ushr.  */
    case 319: value = 321; break;	/* ushr --> urshr.  */
    case 321: value = 323; break;	/* urshr --> sri.  */
    case 323: value = 325; break;	/* sri --> sqshlu.  */
    case 325: return NULL;		/* sqshlu --> NULL.  */
    case 121: value = 300; break;	/* orr --> ssra.  */
    case 300: value = 302; break;	/* ssra --> srsra.  */
    case 302: value = 303; break;	/* srsra --> shl.  */
    case 303: value = 304; break;	/* shl --> sqshl.  */
    case 304: return NULL;		/* sqshl --> NULL.  */
    case 128: value = 320; break;	/* bic --> usra.  */
    case 320: value = 322; break;	/* usra --> ursra.  */
    case 322: value = 324; break;	/* ursra --> sli.  */
    case 324: value = 326; break;	/* sli --> uqshl.  */
    case 326: return NULL;		/* uqshl --> NULL.  */
    case 122: value = 305; break;	/* movi --> shrn.  */
    case 305: value = 306; break;	/* shrn --> shrn2.  */
    case 306: value = 313; break;	/* shrn2 --> sshll.  */
    case 313: value = 315; break;	/* sshll --> sshll2.  */
    case 315: return NULL;		/* sshll2 --> NULL.  */
    case 129: value = 327; break;	/* mvni --> sqshrun.  */
    case 327: value = 328; break;	/* sqshrun --> sqshrun2.  */
    case 328: value = 335; break;	/* sqshrun2 --> ushll.  */
    case 335: value = 337; break;	/* ushll --> ushll2.  */
    case 337: return NULL;		/* ushll2 --> NULL.  */
    case 123: value = 309; break;	/* orr --> sqshrn.  */
    case 309: value = 310; break;	/* sqshrn --> sqshrn2.  */
    case 310: return NULL;		/* sqshrn2 --> NULL.  */
    case 130: value = 331; break;	/* bic --> uqshrn.  */
    case 331: value = 332; break;	/* uqshrn --> uqshrn2.  */
    case 332: return NULL;		/* uqshrn2 --> NULL.  */
    case 125: value = 317; break;	/* movi --> scvtf.  */
    case 317: return NULL;		/* scvtf --> NULL.  */
    case 132: value = 133; break;	/* movi --> movi.  */
    case 133: value = 339; break;	/* movi --> ucvtf.  */
    case 339: return NULL;		/* ucvtf --> NULL.  */
    default: return NULL;
    }

  return aarch64_opcode_table + value;
}

const aarch64_opcode *
aarch64_find_alias_opcode (const aarch64_opcode *opcode)
{
  /* Use the index as the key to locate the alias opcode.  */
  int key = opcode - aarch64_opcode_table;
  int value;
  switch (key)
    {
    case 2: value = 3; break;	/* sbc --> ngc.  */
    case 4: value = 5; break;	/* sbcs --> ngcs.  */
    case 7: value = 8; break;	/* adds --> cmn.  */
    case 10: value = 11; break;	/* subs --> cmp.  */
    case 12: value = 13; break;	/* add --> mov.  */
    case 14: value = 15; break;	/* adds --> cmn.  */
    case 17: value = 18; break;	/* subs --> cmp.  */
    case 20: value = 21; break;	/* adds --> cmn.  */
    case 22: value = 23; break;	/* sub --> neg.  */
    case 24: value = 26; break;	/* subs --> negs.  */
    case 138: value = 139; break;	/* umov --> mov.  */
    case 140: value = 141; break;	/* ins --> mov.  */
    case 142: value = 143; break;	/* ins --> mov.  */
    case 203: value = 204; break;	/* not --> mvn.  */
    case 258: value = 259; break;	/* orr --> mov.  */
    case 313: value = 314; break;	/* sshll --> sxtl.  */
    case 315: value = 316; break;	/* sshll2 --> sxtl2.  */
    case 335: value = 336; break;	/* ushll --> uxtl.  */
    case 337: value = 338; break;	/* ushll2 --> uxtl2.  */
    case 430: value = 431; break;	/* dup --> mov.  */
    case 493: value = 498; break;	/* sbfm --> sxtw.  */
    case 500: value = 502; break;	/* bfm --> bfxil.  */
    case 503: value = 507; break;	/* ubfm --> uxth.  */
    case 525: value = 527; break;	/* csinc --> cset.  */
    case 528: value = 530; break;	/* csinv --> csetm.  */
    case 531: value = 532; break;	/* csneg --> cneg.  */
    case 556: value = 557; break;	/* lslv --> lsl.  */
    case 558: value = 559; break;	/* lsrv --> lsr.  */
    case 560: value = 561; break;	/* asrv --> asr.  */
    case 562: value = 563; break;	/* rorv --> ror.  */
    case 572: value = 573; break;	/* madd --> mul.  */
    case 574: value = 575; break;	/* msub --> mneg.  */
    case 576: value = 577; break;	/* smaddl --> smull.  */
    case 578: value = 579; break;	/* smsubl --> smnegl.  */
    case 581: value = 582; break;	/* umaddl --> umull.  */
    case 583: value = 584; break;	/* umsubl --> umnegl.  */
    case 594: value = 595; break;	/* extr --> ror.  */
    case 693: value = 695; break;	/* sturb --> strb.  */
    case 694: value = 696; break;	/* ldurb --> ldrb.  */
    case 697: value = 698; break;	/* ldursb --> ldrsb.  */
    case 699: value = 701; break;	/* stur --> str.  */
    case 700: value = 702; break;	/* ldur --> ldr.  */
    case 703: value = 705; break;	/* sturh --> strh.  */
    case 704: value = 706; break;	/* ldurh --> ldrh.  */
    case 707: value = 708; break;	/* ldursh --> ldrsh.  */
    case 709: value = 711; break;	/* stur --> str.  */
    case 710: value = 712; break;	/* ldur --> ldr.  */
    case 713: value = 714; break;	/* ldursw --> ldrsw.  */
    case 715: value = 716; break;	/* prfum --> prfm.  */
    case 757: value = 758; break;	/* and --> bic.  */
    case 759: value = 760; break;	/* orr --> mov.  */
    case 762: value = 763; break;	/* ands --> tst.  */
    case 766: value = 768; break;	/* orr --> uxtw.  */
    case 769: value = 770; break;	/* orn --> mvn.  */
    case 773: value = 774; break;	/* ands --> tst.  */
    case 776: value = 777; break;	/* movn --> mov.  */
    case 778: value = 779; break;	/* movz --> mov.  */
    case 784: value = 790; break;	/* hint --> sevl.  */
    case 795: value = 799; break;	/* sys --> tlbi.  */
    default: return NULL;
    }

  return aarch64_opcode_table + value;
}

const aarch64_opcode *
aarch64_find_next_alias_opcode (const aarch64_opcode *opcode)
{
  /* Use the index as the key to locate the next opcode.  */
  int key = opcode - aarch64_opcode_table;
  int value;
  switch (key)
    {
    case 26: value = 25; break;	/* negs --> cmp.  */
    case 498: value = 497; break;	/* sxtw --> sxth.  */
    case 497: value = 496; break;	/* sxth --> sxtb.  */
    case 496: value = 499; break;	/* sxtb --> asr.  */
    case 499: value = 495; break;	/* asr --> sbfx.  */
    case 495: value = 494; break;	/* sbfx --> sbfiz.  */
    case 502: value = 501; break;	/* bfxil --> bfi.  */
    case 507: value = 506; break;	/* uxth --> uxtb.  */
    case 506: value = 509; break;	/* uxtb --> lsr.  */
    case 509: value = 508; break;	/* lsr --> lsl.  */
    case 508: value = 505; break;	/* lsl --> ubfx.  */
    case 505: value = 504; break;	/* ubfx --> ubfiz.  */
    case 527: value = 526; break;	/* cset --> cinc.  */
    case 530: value = 529; break;	/* csetm --> cinv.  */
    case 768: value = 767; break;	/* uxtw --> mov.  */
    case 790: value = 789; break;	/* sevl --> sev.  */
    case 789: value = 788; break;	/* sev --> wfi.  */
    case 788: value = 787; break;	/* wfi --> wfe.  */
    case 787: value = 786; break;	/* wfe --> yield.  */
    case 786: value = 785; break;	/* yield --> nop.  */
    case 799: value = 798; break;	/* tlbi --> ic.  */
    case 798: value = 797; break;	/* ic --> dc.  */
    case 797: value = 796; break;	/* dc --> at.  */
    default: return NULL;
    }

  return aarch64_opcode_table + value;
}

int
aarch64_extract_operand (const aarch64_operand *self,
			   aarch64_opnd_info *info,
			   aarch64_insn code, const aarch64_inst *inst)
{
  /* Use the index as the key.  */
  int key = self - aarch64_operands;
  switch (key)
    {
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 9:
    case 10:
    case 13:
    case 14:
    case 15:
    case 16:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 34:
    case 35:
      return aarch64_ext_regno (self, info, code, inst);
    case 8:
      return aarch64_ext_regrt_sysins (self, info, code, inst);
    case 11:
      return aarch64_ext_reg_extended (self, info, code, inst);
    case 12:
      return aarch64_ext_reg_shifted (self, info, code, inst);
    case 17:
      return aarch64_ext_ft (self, info, code, inst);
    case 27:
    case 28:
    case 29:
      return aarch64_ext_reglane (self, info, code, inst);
    case 30:
      return aarch64_ext_reglist (self, info, code, inst);
    case 31:
      return aarch64_ext_ldst_reglist (self, info, code, inst);
    case 32:
      return aarch64_ext_ldst_reglist_r (self, info, code, inst);
    case 33:
      return aarch64_ext_ldst_elemlist (self, info, code, inst);
    case 36:
    case 45:
    case 46:
    case 47:
    case 48:
    case 49:
    case 50:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
    case 65:
    case 66:
    case 67:
    case 68:
    case 69:
      return aarch64_ext_imm (self, info, code, inst);
    case 37:
    case 38:
      return aarch64_ext_advsimd_imm_shift (self, info, code, inst);
    case 39:
    case 40:
    case 41:
      return aarch64_ext_advsimd_imm_modified (self, info, code, inst);
    case 42:
      return aarch64_ext_shll_imm (self, info, code, inst);
    case 58:
      return aarch64_ext_limm (self, info, code, inst);
    case 59:
      return aarch64_ext_aimm (self, info, code, inst);
    case 60:
      return aarch64_ext_imm_half (self, info, code, inst);
    case 61:
      return aarch64_ext_fbits (self, info, code, inst);
    case 63:
    case 64:
      return aarch64_ext_cond (self, info, code, inst);
    case 70:
    case 76:
      return aarch64_ext_addr_simple (self, info, code, inst);
    case 71:
      return aarch64_ext_addr_regoff (self, info, code, inst);
    case 72:
    case 73:
    case 74:
      return aarch64_ext_addr_simm (self, info, code, inst);
    case 75:
      return aarch64_ext_addr_uimm12 (self, info, code, inst);
    case 77:
      return aarch64_ext_simd_addr_post (self, info, code, inst);
    case 78:
      return aarch64_ext_sysreg (self, info, code, inst);
    case 79:
      return aarch64_ext_pstatefield (self, info, code, inst);
    case 80:
    case 81:
    case 82:
    case 83:
      return aarch64_ext_sysins_op (self, info, code, inst);
    case 84:
    case 85:
      return aarch64_ext_barrier (self, info, code, inst);
    case 86:
      return aarch64_ext_prfop (self, info, code, inst);
    default: assert (0); abort ();
    }
}
