// global async_test, assert_equals
//
// This test generates a couple of scenarios (each a
// SVGSizing.TestData) for sizing inline <svg> and uses a simple
// JavaScript sizing implementation for comparison.
//
// The tests loops through different combinations of:
//
// * width and height attributes and style on <svg>
//
// * viewBox on <svg> (gives intrinsic ratio)
//
// * width and height on containing block of <svg>
//
// All these may contribute to the final size of the SVG. The test
// focuses on the size of the CSS box generated by the SVG. Little
// focus is put on variations within an attribute that doesn't affect
// the final size.
//
// To debug a specific test append ?<test-id> to the URL. An <iframe>
// is generated with equivalent test and the source of the test is
// added to a <pre> element.

var debugHint = function(id) { return "(append ?"+id+" to debug) "; };
var testSingleId;
if (window.location.search) {
    testSingleId = window.location.search.substring(1);
    debugHint = function(id) { return ""; };
}

var testContainer = document.querySelector('#testContainer');
var testContainerWidth = testContainer.getBoundingClientRect().width;
var testContainerHeight = testContainer.getBoundingClientRect().height;

SVGSizing.doCombinationTest(
    [["placeholder", [ null ]],
     ["containerWidthStyle", [null, "400px"]],
     ["containerHeightStyle", [null, "400px"]],
     ["svgViewBoxAttr", [ null, "0 0 100 200" ]],
     ["svgWidthStyle", [ null, "100px", "50%" ]],
     ["svgHeightStyle", [ null, "100px", "50%" ]],
     ["svgWidthAttr", [ null, "200", "25%" ]],
     ["svgHeightAttr", [ null, "200", "25%" ]]],
    function(config, id, cont) {
        var testData = new SVGSizing.TestData(config);

        var expectedRect =
                testData.computeInlineReplacedSize(testContainerWidth,
                                                   testContainerHeight);
        var svgElement = testData.buildSVGOrPlaceholder();
        var container =
                testData.buildContainer(svgElement);

        var checkSize = function() {
            var svgRect =
                    svgElement.getBoundingClientRect();

            try {
                assert_equals(svgRect.width,
                              expectedRect.width,
                              debugHint(id) + "Wrong width");
                assert_equals(svgRect.height,
                              expectedRect.height,
                              debugHint(id) + "Wrong height");
            } finally {
                testContainer.removeChild(container);
                if (testSingleId)
                    document.body.removeChild(testContainer);
                cont(id+1);
            }
        };

        testContainer.appendChild(container);
        test(checkSize, testData.name);

        if (testSingleId == id) {
            testData.buildDemo(expectedRect, id);
        }
    }, testSingleId);
