/*
 *  This file is part of X-File Manager XFM
 *  ----------------------------------------------------------------------
  FmViewportScroll.c

  (c) Bernhard R. Libk 2007

  Action procedures to easily scroll viewports
 *  ----------------------------------------------------------------------
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <xfmconfig.h>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <assert.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>
#include <X11/Xaw3d/ViewportP.h>

#include "global.h"

static void ViewportScroll(Widget widget, XEvent *event, String *params, Cardinal *num_params) {
	ViewportWidget viewport;
	float f;
	char *e;
	Position x, y;

	while( widget != NULL && !XtIsSubclass(widget, viewportWidgetClass) )
		widget = widget->core.parent;

	if( widget == NULL ) {
		XtWarning("ViewportScroll called from something not a Viewport");
		return;
	}
	viewport = (ViewportWidget)widget;

	if( *num_params <= 1 ) {
		XtWarning("Wrong number of arguments to ViewportScroll");
		return;
	}

	f = strtof(params[0], &e);
	if( e == NULL || *e != '\0' ) {
		XtWarning("cannot parse 1st argument to ViewportScroll");
		return;
	}

	x = -viewport->viewport.child->core.x;
	y = -viewport->viewport.child->core.y;

	switch( params[1][0] ) {
		case 'v': case 'V':
		case 'y': case 'Y':
			y += f*(float)viewport->core.height;
			break;
		case 'h': case 'H':
		case 'x': case 'X':
			x += f*(float)viewport->core.width;
			break;
		default:
			XtWarning("unrecognized 2nd argument to ViewportScroll");
			return;
	}
	XawViewportSetCoordinates(widget, x, y);
}

void initViewportScroll(XtAppContext context) {
	static XtActionsRec const actions[1] = {
		{ "ViewportScroll", ViewportScroll }
	};

	XtAppAddActions(context, (XtActionsRec*)actions, 1);
}
