#!/bin/sh

URL=https://github.com/KhronosGroup
GLSLANG_SHA=`cat external_revisions/glslang_revision`

# clean old checkout
git rm -rf external/glslang

# sync glslang and it's dependencies
./update_external_sources.sh --no-build

# the first sha is for spirv-tools
grep "commit\" \:" external/glslang/known_good.json | head -1 | sed 's/.* \"//;s/\"//' \
    > external/glslang/External/spirv-tools/commit-sha

rm -rf external/glslang/.git*
rm -rf external/glslang/External/spirv-tools/.git*
rm -rf external/glslang/External/spirv-tools/external/spirv-headers/.git*

git add -f external/
git commit -m "Refresh external/

glslang: $GLSLANG_SHA
Vcs-Browser: $URL/glslang/commits/$GLSLANG_SHA
"

echo "\nRemember to check if this commit looks sane!"
