// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SQDMLSL_4S_4H_H_TRACE_AARCH64_H_
#define VIXL_SIM_SQDMLSL_4S_4H_H_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_sqdmlsl_4S_4H_H[] = {
  0xffff83f8, 0xffff82fd, 0xffcd99ce, 0xffac0074,
  0xffff06f4, 0xffff04fb, 0xff9acd34, 0xff57561e,
  0xffcca0c0, 0xffcc3861, 0xeb2014e2, 0xdd357840,
  0xff78a114, 0xff778e0b, 0xc8fe3704, 0xa4525bce,
  0xfefaa408, 0xfef89105, 0x95cc6a36, 0x80000000,
  0xfe7ca600, 0xfe799301, 0x80000000, 0x80000000,
  0xfdfea6fc, 0xfdfa93ff, 0x80000000, 0x80000000,
  0xfdfea6fc, 0xfdfa93ff, 0x80000000, 0x80000000,
  0xffff82fc, 0xffff81ff, 0xffcd3368, 0xffab55ca,
  0xffcd1cc8, 0xffccb565, 0xeb527b16, 0xdd8977ec,
  0xff791d1c, 0xff780b0f, 0xc9309d38, 0xa4a65b7a,
  0xfefb2010, 0xfef90e09, 0x95fed06a, 0x80000000,
  0xfe7d2208, 0xfe7a1005, 0x80000000, 0x80000000,
  0xfdff2304, 0xfdfb1103, 0x80000000, 0x80000000,
  0xfdff2304, 0xfdfb1103, 0x80000000, 0x80000000,
  0xfdff2208, 0xfdfb1005, 0x80000000, 0x80000000,
  0xffcd99cc, 0xffcd3367, 0xeb8547b0, 0xddde2242,
  0xff799a20, 0xff788911, 0xc96369d2, 0xa4fb05d0,
  0xfefb9d14, 0xfef98c0b, 0x96319d04, 0x80000000,
  0xfe7d9f0c, 0xfe7a8e07, 0x80000000, 0x80000000,
  0xfdffa008, 0xfdfb8f05, 0x80000000, 0x80000000,
  0xfdffa008, 0xfdfb8f05, 0x80000000, 0x80000000,
  0xfdff9f0c, 0xfdfb8e07, 0x80000000, 0x80000000,
  0xfdff9d14, 0xfdfb8c0b, 0x80000000, 0x80000000,
  0xffac0054, 0xffab55ab, 0xddde2224, 0xc71ce3ae,
  0xff2e0348, 0xff2c58a5, 0xaaac5556, 0x80000000,
  0xfeb00540, 0xfead5aa1, 0x80000000, 0x80000000,
  0xfe32063c, 0xfe2e5b9f, 0x80000000, 0x80000000,
  0xfe32063c, 0xfe2e5b9f, 0x80000000, 0x80000000,
  0xfe320540, 0xfe2e5aa1, 0x80000000, 0x80000000,
  0xfe320348, 0xfe2e58a5, 0x80000000, 0x80000000,
  0xfe31f388, 0xfe2e48c5, 0x80000000, 0x80000000,
  0xff8202f4, 0xff8102fb, 0xccce3334, 0xaaad001e,
  0xff0404ec, 0xff0204f7, 0x999c0000, 0x80000000,
  0xfe8605e8, 0xfe8305f5, 0x80000000, 0x80000000,
  0xfe8605e8, 0xfe8305f5, 0x80000000, 0x80000000,
  0xfe8604ec, 0xfe8304f7, 0x80000000, 0x80000000,
  0xfe8602f4, 0xfe8302fb, 0x80000000, 0x80000000,
  0xfe85f334, 0xfe82f31b, 0x80000000, 0x80000000,
  0xfe857828, 0xfe827715, 0x80000000, 0x80000000,
  0xff8201f8, 0xff8101fd, 0xcccdccce, 0xaaac5574,
  0xff0402f4, 0xff0202fb, 0x999b3334, 0x80000000,
  0xff0402f4, 0xff0202fb, 0x999b3334, 0x80000000,
  0xff0401f8, 0xff0201fd, 0x999accce, 0x80000000,
  0xff040000, 0xff020001, 0x999a0002, 0x80000000,
  0xff03f040, 0xff01f021, 0x999399a2, 0x80000000,
  0xff037534, 0xff01741b, 0x996199d4, 0x80000000,
  0xff02f92c, 0xff00f717, 0x992f33a0, 0x80000000,
  0xff8200fc, 0xff8100ff, 0xcccd6668, 0xaaabaaca,
  0xff8200fc, 0xff8100ff, 0xcccd6668, 0xaaabaaca,
  0xff820000, 0xff810001, 0xcccd0002, 0xaaab0020,
  0xff81fe08, 0xff80fe05, 0xcccc3336, 0xaaa9aacc,
  0xff81ee48, 0xff80ee25, 0xccc5ccd6, 0xaa9f002c,
  0xff81733c, 0xff80721f, 0xcc93cd08, 0xaa4bab2a,
  0xff80f734, 0xff7ff51b, 0xcc6166d4, 0xa9f7ab7e,
  0xff807a30, 0xff7f7719, 0xcc2e9a3a, 0xa9a30128,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffff04, 0xffffff03, 0xffff999c, 0xffff5576,
  0xfffffd0c, 0xfffffd07, 0xfffeccd0, 0xfffe0022,
  0xffffed4c, 0xffffed27, 0xfff86670, 0xfff35582,
  0xffff7240, 0xffff7121, 0xffc666a2, 0xffa00080,
  0xfffef638, 0xfffef41d, 0xff94006e, 0xff4c00d4,
  0xfffe7934, 0xfffe761b, 0xff6133d4, 0xfef7567e,
  0xffcc1300, 0xffcba981, 0xeae67b82, 0xdcd578a0,
  0xffffff04, 0xffffff03, 0xffff999c, 0xffff5576,
  0xfffffd0c, 0xfffffd07, 0xfffeccd0, 0xfffe0022,
  0xffffed4c, 0xffffed27, 0xfff86670, 0xfff35582,
  0xffff7240, 0xffff7121, 0xffc666a2, 0xffa00080,
  0xfffef638, 0xfffef41d, 0xff94006e, 0xff4c00d4,
  0xfffe7934, 0xfffe761b, 0xff6133d4, 0xfef7567e,
  0xffcc1300, 0xffcba981, 0xeae67b82, 0xdcd578a0,
  0xff781354, 0xff76ff2b, 0xc8c49da4, 0xa3f25c2e,
  0xfffffe08, 0xfffffe05, 0xffff3336, 0xfffeaacc,
  0xffffee48, 0xffffee25, 0xfff8ccd6, 0xfff4002c,
  0xffff733c, 0xffff721f, 0xffc6cd08, 0xffa0ab2a,
  0xfffef734, 0xfffef51b, 0xff9466d4, 0xff4cab7e,
  0xfffe7a30, 0xfffe7719, 0xff619a3a, 0xfef80128,
  0xffcc13fc, 0xffcbaa7f, 0xeae6e1e8, 0xdcd6234a,
  0xff781450, 0xff770029, 0xc8c5040a, 0xa3f306d8,
  0xfefa1744, 0xfef80323, 0x9593373c, 0x80000000,
  0xfffff040, 0xfffff021, 0xfff999a2, 0xfff55580,
  0xffff7534, 0xffff741b, 0xffc799d4, 0xffa2007e,
  0xfffef92c, 0xfffef717, 0xff9533a0, 0xff4e00d2,
  0xfffe7c28, 0xfffe7915, 0xff626706, 0xfef9567c,
  0xffcc15f4, 0xffcbac7b, 0xeae7aeb4, 0xdcd7789e,
  0xff781648, 0xff770225, 0xc8c5d0d6, 0xa3f45c2c,
  0xfefa193c, 0xfef8051f, 0x95940408, 0x80000000,
  0xfe7c1b34, 0xfe79071b, 0x80000000, 0x80000000,
  0xffff84f4, 0xffff83fb, 0xffce0034, 0xffacab1e,
  0xffff08ec, 0xffff06f7, 0xff9b9a00, 0xff58ab72,
  0xfffe8be8, 0xfffe88f5, 0xff68cd66, 0xff04011c,
  0xffcc25b4, 0xffcbbc5b, 0xeaee1514, 0xdce2233e,
  0xff782608, 0xff771205, 0xc8cc3736, 0xa3ff06cc,
  0xfefa28fc, 0xfef814ff, 0x959a6a68, 0x80000000,
  0xfe7c2af4, 0xfe7916fb, 0x80000000, 0x80000000,
  0xfdfe2bf0, 0xfdfa17f9, 0x80000000, 0x80000000,
  0xffff83f8, 0xffff82fd, 0xffcd99ce, 0xffac0074,
  0xffff06f4, 0xffff04fb, 0xff9acd34, 0xff57561e,
  0xffcca0c0, 0xffcc3861, 0xeb2014e2, 0xdd357840,
  0xff78a114, 0xff778e0b, 0xc8fe3704, 0xa4525bce,
  0xfefaa408, 0xfef89105, 0x95cc6a36, 0x80000000,
  0xfe7ca600, 0xfe799301, 0x80000000, 0x80000000,
  0xfdfea6fc, 0xfdfa93ff, 0x80000000, 0x80000000,
  0xfe7ca6fc, 0xfe7993ff, 0xb3330000, 0xd5550000,
  0xffff82fc, 0xffff81ff, 0xffcd3368, 0xffab55ca,
  0xffcd1cc8, 0xffccb565, 0xeb527b16, 0xdd8977ec,
  0xff791d1c, 0xff780b0f, 0xc9309d38, 0xa4a65b7a,
  0xfefb2010, 0xfef90e09, 0x95fed06a, 0x80000000,
  0xfe7d2208, 0xfe7a1005, 0x80000000, 0x80000000,
  0xfdff2304, 0xfdfb1103, 0x80000000, 0x80000000,
  0xfe7d2304, 0xfe7a1103, 0xb3330000, 0xd5550000,
  0xfefb2208, 0xfef91005, 0xe665999a, 0x2aa95556,
  0xffcd99cc, 0xffcd3367, 0xeb8547b0, 0xddde2242,
  0xff799a20, 0xff788911, 0xc96369d2, 0xa4fb05d0,
  0xfefb9d14, 0xfef98c0b, 0x96319d04, 0x80000000,
  0xfe7d9f0c, 0xfe7a8e07, 0x80000000, 0x80000000,
  0xfdffa008, 0xfdfb8f05, 0x80000000, 0x80000000,
  0xfe7da008, 0xfe7a8f05, 0xb3330000, 0xd5550000,
  0xfefb9f0c, 0xfef98e07, 0xe665999a, 0x2aa95556,
  0xff4f9fb4, 0xff4e395b, 0x0887ddde, 0x638d1c72,
  0xffac0054, 0xffab55ab, 0xddde2224, 0xc71ce3ae,
  0xff2e0348, 0xff2c58a5, 0xaaac5556, 0x80000000,
  0xfeb00540, 0xfead5aa1, 0x80000000, 0x80000000,
  0xfe32063c, 0xfe2e5b9f, 0x80000000, 0x80000000,
  0xfeb0063c, 0xfead5b9f, 0xb3330000, 0xd5550000,
  0xff2e0540, 0xff2c5aa1, 0xe665999a, 0x2aa95556,
  0xff8205e8, 0xff8105f5, 0x0887ddde, 0x638d1c72,
  0xffb46d18, 0xffb3d38d, 0x1d02fc96, 0x7fffffff,
  0xff8202f4, 0xff8102fb, 0xccce3334, 0xaaad001e,
  0xff0404ec, 0xff0204f7, 0x999c0000, 0x80000000,
  0xfe8605e8, 0xfe8305f5, 0x80000000, 0x80000000,
  0xff0405e8, 0xff0205f5, 0xb3330000, 0xd5550000,
  0xff8204ec, 0xff8104f7, 0xe665999a, 0x2aa95556,
  0xffd60594, 0xffd5b04b, 0x0887ddde, 0x638d1c72,
  0x00086cc4, 0x00087de3, 0x1d02fc96, 0x7fffffff,
  0x0008eac4, 0x0008fce3, 0x1d362f96, 0x7fffffff,
  0xff8201f8, 0xff8101fd, 0xcccdccce, 0xaaac5574,
  0xff0402f4, 0xff0202fb, 0x999b3334, 0x80000000,
  0xff8202f4, 0xff8102fb, 0xccce3334, 0xd5550000,
  0x000001f8, 0x000001fd, 0x0000ccce, 0x2aa95556,
  0x005402a0, 0x0054ad51, 0x22231112, 0x638d1c72,
  0x008669d0, 0x00877ae9, 0x369e2fca, 0x7fffffff,
  0x0086e7d0, 0x0087f9e9, 0x36d162ca, 0x7fffffff,
  0x008764d4, 0x008877eb, 0x37042f64, 0x7fffffff,
  0xff8200fc, 0xff8100ff, 0xcccd6668, 0xaaabaaca,
  0x000000fc, 0x000000ff, 0x00006668, 0x0000aaca,
  0x007e0000, 0x007f0001, 0x33330002, 0x55550020,
  0x00d200a8, 0x00d3ab55, 0x55554446, 0x7fffffff,
  0x010467d8, 0x010678ed, 0x69d062fe, 0x7fffffff,
  0x0104e5d8, 0x0106f7ed, 0x6a0395fe, 0x7fffffff,
  0x010562dc, 0x010775ef, 0x6a366298, 0x7fffffff,
  0x0105dee4, 0x0107f2f3, 0x6a68c8cc, 0x7fffffff,
  0x007e0000, 0x007f0001, 0x33330002, 0x55550020,
  0x00fbff04, 0x00fdff03, 0x6665999c, 0x7fffffff,
  0x014fffac, 0x0152aa57, 0x7fffffff, 0x7fffffff,
  0x018266dc, 0x018577ef, 0x7fffffff, 0x7fffffff,
  0x0182e4dc, 0x0185f6ef, 0x7fffffff, 0x7fffffff,
  0x018361e0, 0x018674f1, 0x7fffffff, 0x7fffffff,
  0x0183dde8, 0x0186f1f5, 0x7fffffff, 0x7fffffff,
  0x018458f4, 0x01876dfb, 0x7fffffff, 0x7fffffff,
  0x007dff04, 0x007eff03, 0x3332999c, 0x55545576,
  0x00d1ffac, 0x00d3aa57, 0x5554dde0, 0x7fffffff,
  0x010466dc, 0x010677ef, 0x69cffc98, 0x7fffffff,
  0x0104e4dc, 0x0106f6ef, 0x6a032f98, 0x7fffffff,
  0x010561e0, 0x010774f1, 0x6a35fc32, 0x7fffffff,
  0x0105dde8, 0x0107f1f5, 0x6a686266, 0x7fffffff,
  0x010658f4, 0x01086dfb, 0x6a9a6234, 0x7fffffff,
  0x010668b4, 0x01087ddb, 0x6aa0c894, 0x7fffffff,
  0x005400a8, 0x0054ab55, 0x22224446, 0x38e3c73c,
  0x008667d8, 0x008778ed, 0x369d62fe, 0x5b064fc4,
  0x0086e5d8, 0x0087f7ed, 0x36d095fe, 0x5b5ba4c4,
  0x008762dc, 0x008875ef, 0x37036298, 0x5bb04f1a,
  0x0087dee4, 0x0088f2f3, 0x3735c8cc, 0x5c044ec6,
  0x008859f0, 0x00896ef9, 0x3767c89a, 0x5c57a3c8,
  0x008869b0, 0x00897ed9, 0x376e2efa, 0x5c624e68,
  0x00886ca4, 0x008981d3, 0x376f622c, 0x5c644e66,
  0x00326730, 0x0032cd99, 0x147b1eba, 0x222288a8,
  0x0032e530, 0x00334c99, 0x14ae51ba, 0x2277dda8,
  0x00336234, 0x0033ca9b, 0x14e11e54, 0x22cc87fe,
  0x0033de3c, 0x0034479f, 0x15138488, 0x232087aa,
  0x00345948, 0x0034c3a5, 0x15458456, 0x2373dcac,
  0x00346908, 0x0034d385, 0x154beab6, 0x237e874c,
  0x00346bfc, 0x0034d67f, 0x154d1de8, 0x2380874a,
  0x00346df4, 0x0034d87b, 0x154deab4, 0x2381dc9e,
  0x00007e00, 0x00007f01, 0x00333302, 0x00555520,
  0x0000fb04, 0x0000fd03, 0x0065ff9c, 0x00a9ff76,
  0x0001770c, 0x00017a07, 0x009865d0, 0x00fdff22,
  0x0001f218, 0x0001f60d, 0x00ca659e, 0x01515424,
  0x000201d8, 0x000205ed, 0x00d0cbfe, 0x015bfec4,
  0x000204cc, 0x000208e7, 0x00d1ff30, 0x015dfec2,
  0x000206c4, 0x00020ae3, 0x00d2cbfc, 0x015f5416,
  0x000207c0, 0x00020be1, 0x00d33262, 0x015ffec0,
  0x00007e02, 0x0032cc9b, 0x0054aa58, 0x007efd26,
  0x0000fb06, 0x006532cf, 0x00a8aa04, 0x00fcfa32,
  0x0001770c, 0x0097329d, 0x00fbff06, 0x0179f744,
  0x000186ec, 0x009d98fd, 0x0106a9a6, 0x0189f6e4,
  0x000189e6, 0x009ecc2f, 0x0108a9a4, 0x018cf6d2,
  0x00018be2, 0x009f98fb, 0x0109fef8, 0x018ef6c6,
  0x00018ce0, 0x009fff61, 0x010aa9a2, 0x018ff6c0,
  0x00018ce0, 0x009fff61, 0x010aa9a2, 0x018ff6c0,
  0x00007d04, 0x00326635, 0x0053ffae, 0x007dfd2c,
  0x0000f90a, 0x00646603, 0x00a754b0, 0x00fafa3e,
  0x000108ea, 0x006acc63, 0x00b1ff50, 0x010af9de,
  0x00010be4, 0x006bff95, 0x00b3ff4e, 0x010df9cc,
  0x00010de0, 0x006ccc61, 0x00b554a2, 0x010ff9c0,
  0x00010ede, 0x006d32c7, 0x00b5ff4c, 0x0110f9ba,
  0x00010ede, 0x006d32c7, 0x00b5ff4c, 0x0110f9ba,
  0x00010de0, 0x006ccc61, 0x00b554a2, 0x010ff9c0,
  0x00007c06, 0x0031ffcf, 0x00535504, 0x007cfd32,
  0x00008be6, 0x0038662f, 0x005dffa4, 0x008cfcd2,
  0x00008ee0, 0x00399961, 0x005fffa2, 0x008ffcc0,
  0x000090dc, 0x003a662d, 0x006154f6, 0x0091fcb4,
  0x000091da, 0x003acc93, 0x0061ffa0, 0x0092fcae,
  0x000091da, 0x003acc93, 0x0061ffa0, 0x0092fcae,
  0x000090dc, 0x003a662d, 0x006154f6, 0x0091fcb4,
  0x00008ee0, 0x00399961, 0x005fffa2, 0x008ffcc0,
  0x00000fe0, 0x00066661, 0x000aaaa2, 0x000fffc0,
  0x000012da, 0x00079993, 0x000caaa0, 0x0012ffae,
  0x000014d6, 0x0008665f, 0x000dfff4, 0x0014ffa2,
  0x000015d4, 0x0008ccc5, 0x000eaa9e, 0x0015ff9c,
  0x000015d4, 0x0008ccc5, 0x000eaa9e, 0x0015ff9c,
  0x000014d6, 0x0008665f, 0x000dfff4, 0x0014ffa2,
  0x000012da, 0x00079993, 0x000caaa0, 0x0012ffae,
  0x000002fa, 0x00013333, 0x00020000, 0x0003000e,
  0x000002fa, 0x00013333, 0x00020000, 0x0003000e,
  0x000004f6, 0x0001ffff, 0x00035554, 0x00050002,
  0x000005f4, 0x00026665, 0x0003fffe, 0x0005fffc,
  0x000005f4, 0x00026665, 0x0003fffe, 0x0005fffc,
  0x000004f6, 0x0001ffff, 0x00035554, 0x00050002,
  0x000002fa, 0x00013333, 0x00020000, 0x0003000e,
  0xfffff31a, 0xfffaccd3, 0xfff75560, 0xfff3006e,
  0xffff7714, 0xffc8cd05, 0xffa4005e, 0xff76035c,
  0x000001fc, 0x0000cccd, 0x00015556, 0x00020014,
  0x000002fa, 0x00013333, 0x00020000, 0x0003000e,
  0x000002fa, 0x00013333, 0x00020000, 0x0003000e,
  0x000001fc, 0x0000cccd, 0x00015556, 0x00020014,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffff020, 0xfff999a1, 0xfff55562, 0xfff00080,
  0xffff741a, 0xffc799d3, 0xffa20060, 0xff73036e,
  0xfffef716, 0xff95339f, 0xff4e00b4, 0xfef50662,
  0x000000fe, 0x00006667, 0x0000aaac, 0x0001001a,
  0x000000fe, 0x00006667, 0x0000aaac, 0x0001001a,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffffe04, 0xffff3335, 0xfffeaaae, 0xfffe002c,
  0xffffee24, 0xfff8ccd5, 0xfff4000e, 0xffee008c,
  0xffff721e, 0xffc6cd07, 0xffa0ab0c, 0xff71037a,
  0xfffef51a, 0xff9466d3, 0xff4cab60, 0xfef3066e,
  0xfffe7718, 0xff619a39, 0xfef8010a, 0xfe740968,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffff02, 0xffff999b, 0xffff5558, 0xffff0026,
  0xfffffd06, 0xfffecccf, 0xfffe0004, 0xfffd0032,
  0xffffed26, 0xfff8666f, 0xfff35564, 0xffed0092,
  0xffff7120, 0xffc666a1, 0xffa00062, 0xff700380,
  0xfffef41c, 0xff94006d, 0xff4c00b6, 0xfef20674,
  0xfffe761a, 0xff6133d3, 0xfef75660, 0xfe73096e,
  0xffcba980, 0xeae67b81, 0xdcd57882, 0xcb413ca0,
  0xffffff02, 0xffff999b, 0xffff5558, 0xffff0026,
  0xfffffd06, 0xfffecccf, 0xfffe0004, 0xfffd0032,
  0xffffed26, 0xfff8666f, 0xfff35564, 0xffed0092,
  0xffff7120, 0xffc666a1, 0xffa00062, 0xff700380,
  0xfffef41c, 0xff94006d, 0xff4c00b6, 0xfef20674,
  0xfffe761a, 0xff6133d3, 0xfef75660, 0xfe73096e,
  0xffcba980, 0xeae67b81, 0xdcd57882, 0xcb413ca0,
  0xff76ff2a, 0xc8c49da3, 0xa3f25c10, 0x80000000,
  0xfffffe04, 0xffff3335, 0xfffeaaae, 0xfffe002c,
  0xffffee24, 0xfff8ccd5, 0xfff4000e, 0xffee008c,
  0xffff721e, 0xffc6cd07, 0xffa0ab0c, 0xff71037a,
  0xfffef51a, 0xff9466d3, 0xff4cab60, 0xfef3066e,
  0xfffe7718, 0xff619a39, 0xfef8010a, 0xfe740968,
  0xffcbaa7e, 0xeae6e1e7, 0xdcd6232c, 0xcb423c9a,
  0xff770028, 0xc8c50409, 0xa3f306ba, 0x80000000,
  0xfef80322, 0x9593373b, 0x80000000, 0x80000000,
  0xfffff020, 0xfff999a1, 0xfff55562, 0xfff00080,
  0xffff741a, 0xffc799d3, 0xffa20060, 0xff73036e,
  0xfffef716, 0xff95339f, 0xff4e00b4, 0xfef50662,
  0xfffe7914, 0xff626705, 0xfef9565e, 0xfe76095c,
  0xffcbac7a, 0xeae7aeb3, 0xdcd77880, 0xcb443c8e,
  0xff770224, 0xc8c5d0d5, 0xa3f45c0e, 0x80000000,
  0xfef8051e, 0x95940407, 0x80000000, 0x80000000,
  0xfe79071a, 0x80000000, 0x80000000, 0x80000000,
  0xffff83fa, 0xffce0033, 0xffacab00, 0xff83030e,
  0xffff06f6, 0xff9b99ff, 0xff58ab54, 0xff050602,
  0xfffe88f4, 0xff68cd65, 0xff0400fe, 0xfe8608fc,
  0xffcbbc5a, 0xeaee1513, 0xdce22320, 0xcb543c2e,
  0xff771204, 0xc8cc3735, 0xa3ff06ae, 0x80000000,
  0xfef814fe, 0x959a6a67, 0x80000000, 0x80000000,
  0xfe7916fa, 0x80000000, 0x80000000, 0x80000000,
  0xfdfa17f8, 0x80000000, 0x80000000, 0x80000000,
  0xffff82fc, 0xffcd99cd, 0xffac0056, 0xff820314,
  0xffff04fa, 0xff9acd33, 0xff575600, 0xff03060e,
  0xffcc3860, 0xeb2014e1, 0xdd357822, 0xcbd13940,
  0xff778e0a, 0xc8fe3703, 0xa4525bb0, 0x80000000,
  0xfef89104, 0x95cc6a35, 0x80000000, 0x80000000,
  0xfe799300, 0x80000000, 0x80000000, 0x80000000,
  0xfdfa93fe, 0x80000000, 0x80000000, 0x80000000,
  0xfe7993fe, 0xb3330000, 0xd5550000, 0xfffd0000,
  0xffff81fe, 0xffcd3367, 0xffab55ac, 0xff81031a,
  0xffccb564, 0xeb527b15, 0xdd8977ce, 0xcc4f364c,
  0xff780b0e, 0xc9309d37, 0xa4a65b5c, 0x80000000,
  0xfef90e08, 0x95fed069, 0x80000000, 0x80000000,
  0xfe7a1004, 0x80000000, 0x80000000, 0x80000000,
  0xfdfb1102, 0x80000000, 0x80000000, 0x80000000,
  0xfe7a1102, 0xb3330000, 0xd5550000, 0xfffd0000,
  0xfef91004, 0xe665999a, 0x2aa95556, 0x7ff90006,
  0xffcd3366, 0xeb8547af, 0xddde2224, 0xccce3352,
  0xff788910, 0xc96369d1, 0xa4fb05b2, 0x80000000,
  0xfef98c0a, 0x96319d03, 0x80000000, 0x80000000,
  0xfe7a8e06, 0x80000000, 0x80000000, 0x80000000,
  0xfdfb8f04, 0x80000000, 0x80000000, 0x80000000,
  0xfe7a8f04, 0xb3330000, 0xd5550000, 0xfffd0000,
  0xfef98e06, 0xe665999a, 0x2aa95556, 0x7ff90006,
  0xff4e395a, 0x0887ddde, 0x638d1c72, 0x7fffffff,
  0xffab55aa, 0xddde2223, 0xc71ce390, 0xaaad001e,
  0xff2c58a4, 0xaaac5555, 0x80000000, 0x80000000,
  0xfead5aa0, 0x80000000, 0x80000000, 0x80000000,
  0xfe2e5b9e, 0x80000000, 0x80000000, 0x80000000,
  0xfead5b9e, 0xb3330000, 0xd5550000, 0xfffd0000,
  0xff2c5aa0, 0xe665999a, 0x2aa95556, 0x7ff90006,
  0xff8105f4, 0x0887ddde, 0x638d1c72, 0x7fffffff,
  0xffb3d38c, 0x1d02fc96, 0x7fffffff, 0x7fffffff,
  0xff8102fa, 0xccce3333, 0xaaad0000, 0x8006000e,
  0xff0204f6, 0x999bffff, 0x80000000, 0x80000000,
  0xfe8305f4, 0x80000000, 0x80000000, 0x80000000,
  0xff0205f4, 0xb3330000, 0xd5550000, 0xfffd0000,
  0xff8104f6, 0xe665999a, 0x2aa95556, 0x7ff90006,
  0xffd5b04a, 0x0887ddde, 0x638d1c72, 0x7fffffff,
  0x00087de2, 0x1d02fc96, 0x7fffffff, 0x7fffffff,
  0x0008fce2, 0x1d362f96, 0x7fffffff, 0x7fffffff,
  0xff8101fc, 0xcccdcccd, 0xaaac5556, 0x80050014,
  0xff0202fa, 0x999b3333, 0x80000000, 0x80000000,
  0xff8102fa, 0xccce3333, 0xd5550000, 0xfffd0000,
  0x000001fc, 0x0000cccd, 0x2aa95556, 0x7ff90006,
  0x0054ad50, 0x22231111, 0x638d1c72, 0x7fffffff,
  0x00877ae8, 0x369e2fc9, 0x7fffffff, 0x7fffffff,
  0x0087f9e8, 0x36d162c9, 0x7fffffff, 0x7fffffff,
  0x008877ea, 0x37042f63, 0x7fffffff, 0x7fffffff,
  0xff8100fe, 0xcccd6667, 0xaaabaaac, 0x8004001a,
  0x000000fe, 0x00006667, 0x0000aaac, 0x0001001a,
  0x007f0000, 0x33330001, 0x55550002, 0x7ffd0020,
  0x00d3ab54, 0x55554445, 0x7fffffff, 0x7fffffff,
  0x010678ec, 0x69d062fd, 0x7fffffff, 0x7fffffff,
  0x0106f7ec, 0x6a0395fd, 0x7fffffff, 0x7fffffff,
  0x010775ee, 0x6a366297, 0x7fffffff, 0x7fffffff,
  0x0107f2f2, 0x6a68c8cb, 0x7fffffff, 0x7fffffff,
  0x007f0000, 0x33330001, 0x55550002, 0x7ffd0020,
  0x00fdff02, 0x6665999b, 0x7fffffff, 0x7fffffff,
  0x0152aa56, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x018577ee, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x0185f6ee, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x018674f0, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x0186f1f4, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x01876dfa, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x007eff02, 0x3332999b, 0x55545558, 0x7ffc0026,
  0x00d3aa56, 0x5554dddf, 0x7fffffff, 0x7fffffff,
  0x010677ee, 0x69cffc97, 0x7fffffff, 0x7fffffff,
  0x0106f6ee, 0x6a032f97, 0x7fffffff, 0x7fffffff,
  0x010774f0, 0x6a35fc31, 0x7fffffff, 0x7fffffff,
  0x0107f1f4, 0x6a686265, 0x7fffffff, 0x7fffffff,
  0x01086dfa, 0x6a9a6233, 0x7fffffff, 0x7fffffff,
  0x01087dda, 0x6aa0c893, 0x7fffffff, 0x7fffffff,
  0x0054ab54, 0x22224445, 0x38e3c71e, 0x5554001c,
  0x008778ec, 0x369d62fd, 0x5b064fa6, 0x7fffffff,
  0x0087f7ec, 0x36d095fd, 0x5b5ba4a6, 0x7fffffff,
  0x008875ee, 0x37036297, 0x5bb04efc, 0x7fffffff,
  0x0088f2f2, 0x3735c8cb, 0x5c044ea8, 0x7fffffff,
  0x00896ef8, 0x3767c899, 0x5c57a3aa, 0x7fffffff,
  0x00897ed8, 0x376e2ef9, 0x5c624e4a, 0x7fffffff,
  0x008981d2, 0x376f622b, 0x5c644e48, 0x7fffffff,
  0x0032cd98, 0x147b1eb9, 0x2222888a, 0x3332cce8,
  0x00334c98, 0x14ae51b9, 0x2277dd8a, 0x33b2c9e8,
  0x0033ca9a, 0x14e11e53, 0x22cc87e0, 0x3431c6ee,
  0x0034479e, 0x15138487, 0x2320878c, 0x34afc3fa,
  0x0034c3a4, 0x15458455, 0x2373dc8e, 0x352cc10c,
  0x0034d384, 0x154beab5, 0x237e872e, 0x353cc0ac,
  0x0034d67e, 0x154d1de7, 0x2380872c, 0x353fc09a,
  0x0034d87a, 0x154deab3, 0x2381dc80, 0x3541c08e,
  0x00007f00, 0x00333301, 0x00555502, 0x007ffd20,
  0x0000fd02, 0x0065ff9b, 0x00a9ff58, 0x00fefa26,
  0x00017a06, 0x009865cf, 0x00fdff04, 0x017cf732,
  0x0001f60c, 0x00ca659d, 0x01515406, 0x01f9f444,
  0x000205ec, 0x00d0cbfd, 0x015bfea6, 0x0209f3e4,
  0x000208e6, 0x00d1ff2f, 0x015dfea4, 0x020cf3d2,
  0x00020ae2, 0x00d2cbfb, 0x015f53f8, 0x020ef3c6,
  0x00020be0, 0x00d33261, 0x015ffea2, 0x020ff3c0,
  0x0032cc9a, 0x0054aa57, 0x007efd08, 0x007efe24,
  0x006532ce, 0x00a8aa03, 0x00fcfa14, 0x00fcfc2c,
  0x0097329c, 0x00fbff05, 0x0179f726, 0x0179fa38,
  0x009d98fc, 0x0106a9a5, 0x0189f6c6, 0x0189f9f8,
  0x009ecc2e, 0x0108a9a3, 0x018cf6b4, 0x018cf9ec,
  0x009f98fa, 0x0109fef7, 0x018ef6a8, 0x018ef9e4,
  0x009fff60, 0x010aa9a1, 0x018ff6a2, 0x018ff9e0,
  0x009fff60, 0x010aa9a1, 0x018ff6a2, 0x018ff9e0,
  0x00326634, 0x0053ffad, 0x007dfd0e, 0x007dfe28,
  0x00646602, 0x00a754af, 0x00fafa20, 0x00fafc34,
  0x006acc62, 0x00b1ff4f, 0x010af9c0, 0x010afbf4,
  0x006bff94, 0x00b3ff4d, 0x010df9ae, 0x010dfbe8,
  0x006ccc60, 0x00b554a1, 0x010ff9a2, 0x010ffbe0,
  0x006d32c6, 0x00b5ff4b, 0x0110f99c, 0x0110fbdc,
  0x006d32c6, 0x00b5ff4b, 0x0110f99c, 0x0110fbdc,
  0x006ccc60, 0x00b554a1, 0x010ff9a2, 0x010ffbe0,
  0x0031ffce, 0x00535503, 0x007cfd14, 0x007cfe2c,
  0x0038662e, 0x005dffa3, 0x008cfcb4, 0x008cfdec,
  0x00399960, 0x005fffa1, 0x008ffca2, 0x008ffde0,
  0x003a662c, 0x006154f5, 0x0091fc96, 0x0091fdd8,
  0x003acc92, 0x0061ff9f, 0x0092fc90, 0x0092fdd4,
  0x003acc92, 0x0061ff9f, 0x0092fc90, 0x0092fdd4,
  0x003a662c, 0x006154f5, 0x0091fc96, 0x0091fdd8,
  0x00399960, 0x005fffa1, 0x008ffca2, 0x008ffde0,
  0x00066660, 0x000aaaa1, 0x000fffa2, 0x000fffe0,
  0x00079992, 0x000caa9f, 0x0012ff90, 0x0012ffd4,
  0x0008665e, 0x000dfff3, 0x0014ff84, 0x0014ffcc,
  0x0008ccc4, 0x000eaa9d, 0x0015ff7e, 0x0015ffc8,
  0x0008ccc4, 0x000eaa9d, 0x0015ff7e, 0x0015ffc8,
  0x0008665e, 0x000dfff3, 0x0014ff84, 0x0014ffcc,
  0x00079992, 0x000caa9f, 0x0012ff90, 0x0012ffd4,
  0x00013332, 0x0001ffff, 0x0002fff0, 0x00030014,
  0x00013332, 0x0001ffff, 0x0002fff0, 0x00030014,
  0x0001fffe, 0x00035553, 0x0004ffe4, 0x0005000c,
  0x00026664, 0x0003fffd, 0x0005ffde, 0x00060008,
  0x00026664, 0x0003fffd, 0x0005ffde, 0x00060008,
  0x0001fffe, 0x00035553, 0x0004ffe4, 0x0005000c,
  0x00013332, 0x0001ffff, 0x0002fff0, 0x00030014,
  0xfffaccd2, 0xfff7555f, 0xfff30050, 0xfff30054,
  0xffc8cd04, 0xffa4005d, 0xff76033e, 0xff760248,
  0x0000cccc, 0x00015555, 0x0001fff6, 0x00020018,
  0x00013332, 0x0001ffff, 0x0002fff0, 0x00030014,
  0x00013332, 0x0001ffff, 0x0002fff0, 0x00030014,
  0x0000cccc, 0x00015555, 0x0001fff6, 0x00020018,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfff999a0, 0xfff55561, 0xfff00062, 0xfff00060,
  0xffc799d2, 0xffa2005f, 0xff730350, 0xff730254,
  0xff95339e, 0xff4e00b3, 0xfef50644, 0xfef5044c,
  0x00006666, 0x0000aaab, 0x0000fffc, 0x0001001c,
  0x00006666, 0x0000aaab, 0x0000fffc, 0x0001001c,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff3334, 0xfffeaaad, 0xfffe000e, 0xfffe0028,
  0xfff8ccd4, 0xfff4000d, 0xffee006e, 0xffee0068,
  0xffc6cd06, 0xffa0ab0b, 0xff71035c, 0xff71025c,
  0xff9466d2, 0xff4cab5f, 0xfef30650, 0xfef30454,
  0xff619a38, 0xfef80109, 0xfe74094a, 0xfe740650,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff999a, 0xffff5557, 0xffff0008, 0xffff0024,
  0xfffeccce, 0xfffe0003, 0xfffd0014, 0xfffd002c,
  0xfff8666e, 0xfff35563, 0xffed0074, 0xffed006c,
  0xffc666a0, 0xffa00061, 0xff700362, 0xff700260,
  0xff94006c, 0xff4c00b5, 0xfef20656, 0xfef20458,
  0xff6133d2, 0xfef7565f, 0xfe730950, 0xfe730654,
  0xeae67b80, 0xdcd57881, 0xcb413c82, 0xcb40d320,
  0xffff999a, 0xffff5557, 0xffff0008, 0xffff0024,
  0xfffeccce, 0xfffe0003, 0xfffd0014, 0xfffd002c,
  0xfff8666e, 0xfff35563, 0xffed0074, 0xffed006c,
  0xffc666a0, 0xffa00061, 0xff700362, 0xff700260,
  0xff94006c, 0xff4c00b5, 0xfef20656, 0xfef20458,
  0xff6133d2, 0xfef7565f, 0xfe730950, 0xfe730654,
  0xeae67b80, 0xdcd57881, 0xcb413c82, 0xcb40d320,
  0xc8c49da2, 0xa3f25c0f, 0x80000000, 0x80000000,
  0xffff3334, 0xfffeaaad, 0xfffe000e, 0xfffe0028,
  0xfff8ccd4, 0xfff4000d, 0xffee006e, 0xffee0068,
  0xffc6cd06, 0xffa0ab0b, 0xff71035c, 0xff71025c,
  0xff9466d2, 0xff4cab5f, 0xfef30650, 0xfef30454,
  0xff619a38, 0xfef80109, 0xfe74094a, 0xfe740650,
  0xeae6e1e6, 0xdcd6232b, 0xcb423c7c, 0xcb41d31c,
  0xc8c50408, 0xa3f306b9, 0x80000000, 0x80000000,
  0x9593373a, 0x80000000, 0x80000000, 0x80000000,
  0xfff999a0, 0xfff55561, 0xfff00062, 0xfff00060,
  0xffc799d2, 0xffa2005f, 0xff730350, 0xff730254,
  0xff95339e, 0xff4e00b3, 0xfef50644, 0xfef5044c,
  0xff626704, 0xfef9565d, 0xfe76093e, 0xfe760648,
  0xeae7aeb2, 0xdcd7787f, 0xcb443c70, 0xcb43d314,
  0xc8c5d0d4, 0xa3f45c0d, 0x80000000, 0x80000000,
  0x95940406, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xffce0032, 0xffacaaff, 0xff8302f0, 0xff830214,
  0xff9b99fe, 0xff58ab53, 0xff0505e4, 0xff05040c,
  0xff68cd64, 0xff0400fd, 0xfe8608de, 0xfe860608,
  0xeaee1512, 0xdce2231f, 0xcb543c10, 0xcb53d2d4,
  0xc8cc3734, 0xa3ff06ad, 0x80000000, 0x80000000,
  0x959a6a66, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xffcd99cc, 0xffac0055, 0xff8202f6, 0xff820218,
  0xff9acd32, 0xff5755ff, 0xff0305f0, 0xff030414,
  0xeb2014e0, 0xdd357821, 0xcbd13922, 0xcbd0d0e0,
  0xc8fe3702, 0xa4525baf, 0x80000000, 0x80000000,
  0x95cc6a34, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xb3330000, 0xd5550000, 0xfffd0000, 0xfffe0000,
  0xffcd3366, 0xffab55ab, 0xff8102fc, 0xff81021c,
  0xeb527b14, 0xdd8977cd, 0xcc4f362e, 0xcc4ecee8,
  0xc9309d36, 0xa4a65b5b, 0x80000000, 0x80000000,
  0x95fed068, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xb3330000, 0xd5550000, 0xfffd0000, 0xfffe0000,
  0xe665999a, 0x2aa95556, 0x7ff90006, 0x7ffb0004,
  0xeb8547ae, 0xddde2223, 0xccce3334, 0xcccdccec,
  0xc96369d0, 0xa4fb05b1, 0x80000000, 0x80000000,
  0x96319d02, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xb3330000, 0xd5550000, 0xfffd0000, 0xfffe0000,
  0xe665999a, 0x2aa95556, 0x7ff90006, 0x7ffb0004,
  0x0887ddde, 0x638d1c72, 0x7fffffff, 0x7fffffff,
  0xddde2222, 0xc71ce38f, 0xaaad0000, 0xaaac5574,
  0xaaac5554, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xb3330000, 0xd5550000, 0xfffd0000, 0xfffe0000,
  0xe665999a, 0x2aa95556, 0x7ff90006, 0x7ffb0004,
  0x0887ddde, 0x638d1c72, 0x7fffffff, 0x7fffffff,
  0x1d02fc96, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0xccce3332, 0xaaacffff, 0x8005fff0, 0x80050014,
  0x999bfffe, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xb3330000, 0xd5550000, 0xfffd0000, 0xfffe0000,
  0xe665999a, 0x2aa95556, 0x7ff90006, 0x7ffb0004,
  0x0887ddde, 0x638d1c72, 0x7fffffff, 0x7fffffff,
  0x1d02fc96, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x1d362f96, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0xcccdcccc, 0xaaac5555, 0x8004fff6, 0x80040018,
  0x999b3332, 0x80000000, 0x80000000, 0x80000000,
  0xccce3332, 0xd5550000, 0xfffd0000, 0xfffe0000,
  0x0000cccc, 0x2aa95556, 0x7ff90006, 0x7ffb0004,
  0x22231110, 0x638d1c72, 0x7fffffff, 0x7fffffff,
  0x369e2fc8, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x36d162c8, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x37042f62, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0xcccd6666, 0xaaabaaab, 0x8003fffc, 0x8003001c,
  0x00006666, 0x0000aaab, 0x0000fffc, 0x0001001c,
  0x33330000, 0x55550001, 0x7ffd0002, 0x7ffe0020,
  0x55554444, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x69d062fc, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x6a0395fc, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x6a366296, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x6a68c8ca, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x33330000, 0x55550001, 0x7ffd0002, 0x7ffe0020,
  0x6665999a, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x3332999a, 0x55545557, 0x7ffc0008, 0x7ffd0024,
  0x5554ddde, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x69cffc96, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x6a032f96, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x6a35fc30, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x6a686264, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x6a9a6232, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x6aa0c892, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x22224444, 0x38e3c71d, 0x5553fffe, 0x5554aac8,
  0x369d62fc, 0x5b064fa5, 0x7fffffff, 0x7fffffff,
  0x36d095fc, 0x5b5ba4a5, 0x7fffffff, 0x7fffffff,
  0x37036296, 0x5bb04efb, 0x7fffffff, 0x7fffffff,
  0x3735c8ca, 0x5c044ea7, 0x7fffffff, 0x7fffffff,
  0x3767c898, 0x5c57a3a9, 0x7fffffff, 0x7fffffff,
  0x376e2ef8, 0x5c624e49, 0x7fffffff, 0x7fffffff,
  0x376f622a, 0x5c644e47, 0x7fffffff, 0x7fffffff,
  0x147b1eb8, 0x22228889, 0x3332ccca, 0x33333350,
  0x14ae51b8, 0x2277dd89, 0x33b2c9ca, 0x33b33150,
  0x14e11e52, 0x22cc87df, 0x3431c6d0, 0x34322f54,
  0x15138486, 0x2320878b, 0x34afc3dc, 0x34b02d5c,
  0x15458454, 0x2373dc8d, 0x352cc0ee, 0x352d2b68,
  0x154beab4, 0x237e872d, 0x353cc08e, 0x353d2b28,
  0x154d1de6, 0x2380872b, 0x353fc07c, 0x35402b1c,
  0x154deab2, 0x2381dc7f, 0x3541c070, 0x35422b14,
  0x00333300, 0x00555501, 0x007ffd02, 0x007ffe20,
  0x0065ff9a, 0x00a9ff57, 0x00fefa08, 0x00fefc24,
  0x009865ce, 0x00fdff03, 0x017cf714, 0x017cfa2c,
  0x00ca659c, 0x01515405, 0x01f9f426, 0x01f9f838,
  0x00d0cbfc, 0x015bfea5, 0x0209f3c6, 0x0209f7f8,
  0x00d1ff2e, 0x015dfea3, 0x020cf3b4, 0x020cf7ec,
  0x00d2cbfa, 0x015f53f7, 0x020ef3a8, 0x020ef7e4,
  0x00d33260, 0x015ffea1, 0x020ff3a2, 0x020ff7e0,
  0x0054aa56, 0x007efd07, 0x007efe06, 0x007eff22,
  0x00a8aa02, 0x00fcfa13, 0x00fcfc0e, 0x00fcfe26,
  0x00fbff04, 0x0179f725, 0x0179fa1a, 0x0179fd2c,
  0x0106a9a4, 0x0189f6c5, 0x0189f9da, 0x0189fd0c,
  0x0108a9a2, 0x018cf6b3, 0x018cf9ce, 0x018cfd06,
  0x0109fef6, 0x018ef6a7, 0x018ef9c6, 0x018efd02,
  0x010aa9a0, 0x018ff6a1, 0x018ff9c2, 0x018ffd00,
  0x010aa9a0, 0x018ff6a1, 0x018ff9c2, 0x018ffd00,
  0x0053ffac, 0x007dfd0d, 0x007dfe0a, 0x007dff24,
  0x00a754ae, 0x00fafa1f, 0x00fafc16, 0x00fafe2a,
  0x00b1ff4e, 0x010af9bf, 0x010afbd6, 0x010afe0a,
  0x00b3ff4c, 0x010df9ad, 0x010dfbca, 0x010dfe04,
  0x00b554a0, 0x010ff9a1, 0x010ffbc2, 0x010ffe00,
  0x00b5ff4a, 0x0110f99b, 0x0110fbbe, 0x0110fdfe,
  0x00b5ff4a, 0x0110f99b, 0x0110fbbe, 0x0110fdfe,
  0x00b554a0, 0x010ff9a1, 0x010ffbc2, 0x010ffe00,
  0x00535502, 0x007cfd13, 0x007cfe0e, 0x007cff26,
  0x005dffa2, 0x008cfcb3, 0x008cfdce, 0x008cff06,
  0x005fffa0, 0x008ffca1, 0x008ffdc2, 0x008fff00,
  0x006154f4, 0x0091fc95, 0x0091fdba, 0x0091fefc,
  0x0061ff9e, 0x0092fc8f, 0x0092fdb6, 0x0092fefa,
  0x0061ff9e, 0x0092fc8f, 0x0092fdb6, 0x0092fefa,
  0x006154f4, 0x0091fc95, 0x0091fdba, 0x0091fefc,
  0x005fffa0, 0x008ffca1, 0x008ffdc2, 0x008fff00,
  0x000aaaa0, 0x000fffa1, 0x000fffc2, 0x00100000,
  0x000caa9e, 0x0012ff8f, 0x0012ffb6, 0x0012fffa,
  0x000dfff2, 0x0014ff83, 0x0014ffae, 0x0014fff6,
  0x000eaa9c, 0x0015ff7d, 0x0015ffaa, 0x0015fff4,
  0x000eaa9c, 0x0015ff7d, 0x0015ffaa, 0x0015fff4,
  0x000dfff2, 0x0014ff83, 0x0014ffae, 0x0014fff6,
  0x000caa9e, 0x0012ff8f, 0x0012ffb6, 0x0012fffa,
  0x0001fffe, 0x0002ffef, 0x0002fff6, 0x0003001a,
  0x0001fffe, 0x0002ffef, 0x0002fff6, 0x0003001a,
  0x00035552, 0x0004ffe3, 0x0004ffee, 0x00050016,
  0x0003fffc, 0x0005ffdd, 0x0005ffea, 0x00060014,
  0x0003fffc, 0x0005ffdd, 0x0005ffea, 0x00060014,
  0x00035552, 0x0004ffe3, 0x0004ffee, 0x00050016,
  0x0001fffe, 0x0002ffef, 0x0002fff6, 0x0003001a,
  0xfff7555e, 0xfff3004f, 0xfff30036, 0xfff3003a,
  0xffa4005c, 0xff76033d, 0xff76022a, 0xff760134,
  0x00015554, 0x0001fff5, 0x0001fffa, 0x0002001c,
  0x0001fffe, 0x0002ffef, 0x0002fff6, 0x0003001a,
  0x0001fffe, 0x0002ffef, 0x0002fff6, 0x0003001a,
  0x00015554, 0x0001fff5, 0x0001fffa, 0x0002001c,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfff55560, 0xfff00061, 0xfff00042, 0xfff00040,
  0xffa2005e, 0xff73034f, 0xff730236, 0xff73013a,
  0xff4e00b2, 0xfef50643, 0xfef5042e, 0xfef50236,
  0x0000aaaa, 0x0000fffb, 0x0000fffe, 0x0001001e,
  0x0000aaaa, 0x0000fffb, 0x0000fffe, 0x0001001e,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffeaaac, 0xfffe000d, 0xfffe000a, 0xfffe0024,
  0xfff4000c, 0xffee006d, 0xffee004a, 0xffee0044,
  0xffa0ab0a, 0xff71035b, 0xff71023e, 0xff71013e,
  0xff4cab5e, 0xfef3064f, 0xfef30436, 0xfef3023a,
  0xfef80108, 0xfe740949, 0xfe740632, 0xfe740338,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff5556, 0xffff0007, 0xffff0006, 0xffff0022,
  0xfffe0002, 0xfffd0013, 0xfffd000e, 0xfffd0026,
  0xfff35562, 0xffed0073, 0xffed004e, 0xffed0046,
  0xffa00060, 0xff700361, 0xff700242, 0xff700140,
  0xff4c00b4, 0xfef20655, 0xfef2043a, 0xfef2023c,
  0xfef7565e, 0xfe73094f, 0xfe730636, 0xfe73033a,
  0xdcd57880, 0xcb413c81, 0xcb40d302, 0xcb4069a0,
  0xffff5556, 0xffff0007, 0xffff0006, 0xffff0022,
  0xfffe0002, 0xfffd0013, 0xfffd000e, 0xfffd0026,
  0xfff35562, 0xffed0073, 0xffed004e, 0xffed0046,
  0xffa00060, 0xff700361, 0xff700242, 0xff700140,
  0xff4c00b4, 0xfef20655, 0xfef2043a, 0xfef2023c,
  0xfef7565e, 0xfe73094f, 0xfe730636, 0xfe73033a,
  0xdcd57880, 0xcb413c81, 0xcb40d302, 0xcb4069a0,
  0xa3f25c0e, 0x80000000, 0x80000000, 0x80000000,
  0xfffeaaac, 0xfffe000d, 0xfffe000a, 0xfffe0024,
  0xfff4000c, 0xffee006d, 0xffee004a, 0xffee0044,
  0xffa0ab0a, 0xff71035b, 0xff71023e, 0xff71013e,
  0xff4cab5e, 0xfef3064f, 0xfef30436, 0xfef3023a,
  0xfef80108, 0xfe740949, 0xfe740632, 0xfe740338,
  0xdcd6232a, 0xcb423c7b, 0xcb41d2fe, 0xcb41699e,
  0xa3f306b8, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xfff55560, 0xfff00061, 0xfff00042, 0xfff00040,
  0xffa2005e, 0xff73034f, 0xff730236, 0xff73013a,
  0xff4e00b2, 0xfef50643, 0xfef5042e, 0xfef50236,
  0xfef9565c, 0xfe76093d, 0xfe76062a, 0xfe760334,
  0xdcd7787e, 0xcb443c6f, 0xcb43d2f6, 0xcb43699a,
  0xa3f45c0c, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xffacaafe, 0xff8302ef, 0xff8301f6, 0xff83011a,
  0xff58ab52, 0xff0505e3, 0xff0503ee, 0xff050216,
  0xff0400fc, 0xfe8608dd, 0xfe8605ea, 0xfe860314,
  0xdce2231e, 0xcb543c0f, 0xcb53d2b6, 0xcb53697a,
  0xa3ff06ac, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xffac0054, 0xff8202f5, 0xff8201fa, 0xff82011c,
  0xff5755fe, 0xff0305ef, 0xff0303f6, 0xff03021a,
  0xdd357820, 0xcbd13921, 0xcbd0d0c2, 0xcbd06880,
  0xa4525bae, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xd5550000, 0xfffd0000, 0xfffe0000, 0xffff0000,
  0xffab55aa, 0xff8102fb, 0xff8101fe, 0xff81011e,
  0xdd8977cc, 0xcc4f362d, 0xcc4ececa, 0xcc4e6784,
  0xa4a65b5a, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xd5550000, 0xfffd0000, 0xfffe0000, 0xffff0000,
  0x2aa95556, 0x7ff90006, 0x7ffb0004, 0x7ffd0002,
  0xddde2222, 0xccce3333, 0xcccdccce, 0xcccd6686,
  0xa4fb05b0, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xd5550000, 0xfffd0000, 0xfffe0000, 0xffff0000,
  0x2aa95556, 0x7ff90006, 0x7ffb0004, 0x7ffd0002,
  0x638d1c72, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0xc71ce38e, 0xaaacffff, 0xaaac5556, 0xaaabaaca,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xd5550000, 0xfffd0000, 0xfffe0000, 0xffff0000,
  0x2aa95556, 0x7ff90006, 0x7ffb0004, 0x7ffd0002,
  0x638d1c72, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0xaaacfffe, 0x8005ffef, 0x8004fff6, 0x8004001a,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xd5550000, 0xfffd0000, 0xfffe0000, 0xffff0000,
  0x2aa95556, 0x7ff90006, 0x7ffb0004, 0x7ffd0002,
  0x638d1c72, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0xaaac5554, 0x8004fff5, 0x8003fffa, 0x8003001c,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xd5550000, 0xfffd0000, 0xfffe0000, 0xffff0000,
  0x2aa95556, 0x7ff90006, 0x7ffb0004, 0x7ffd0002,
  0x638d1c72, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0xaaabaaaa, 0x8003fffb, 0x8002fffe, 0x8002001e,
  0x0000aaaa, 0x0000fffb, 0x0000fffe, 0x0001001e,
  0x55550000, 0x7ffd0001, 0x7ffe0002, 0x7fff0020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x55550000, 0x7ffd0001, 0x7ffe0002, 0x7fff0020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x55545556, 0x7ffc0007, 0x7ffd0006, 0x7ffe0022,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x38e3c71c, 0x5553fffd, 0x5554aaaa, 0x55555574,
  0x5b064fa4, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x5b5ba4a4, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x5bb04efa, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x5c044ea6, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x5c57a3a8, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x5c624e48, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x5c644e46, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x22228888, 0x3332ccc9, 0x33333332, 0x333399b8,
  0x2277dd88, 0x33b2c9c9, 0x33b33132, 0x33b398b8,
  0x22cc87de, 0x3431c6cf, 0x34322f36, 0x343297ba,
  0x2320878a, 0x34afc3db, 0x34b02d3e, 0x34b096be,
  0x2373dc8c, 0x352cc0ed, 0x352d2b4a, 0x352d95c4,
  0x237e872c, 0x353cc08d, 0x353d2b0a, 0x353d95a4,
  0x2380872a, 0x353fc07b, 0x35402afe, 0x3540959e,
  0x2381dc7e, 0x3541c06f, 0x35422af6, 0x3542959a,
  0x00555500, 0x007ffd01, 0x007ffe02, 0x007fff20,
  0x00a9ff56, 0x00fefa07, 0x00fefc06, 0x00fefe22,
  0x00fdff02, 0x017cf713, 0x017cfa0e, 0x017cfd26,
  0x01515404, 0x01f9f425, 0x01f9f81a, 0x01f9fc2c,
  0x015bfea4, 0x0209f3c5, 0x0209f7da, 0x0209fc0c,
  0x015dfea2, 0x020cf3b3, 0x020cf7ce, 0x020cfc06,
  0x015f53f6, 0x020ef3a7, 0x020ef7c6, 0x020efc02,
  0x015ffea0, 0x020ff3a1, 0x020ff7c2, 0x020ffc00,
  0x007efd06, 0x007efe05, 0x007eff04, 0x00000020,
  0x00fcfa12, 0x00fcfc0d, 0x00fcfe08, 0x00000020,
  0x0179f724, 0x0179fa19, 0x0179fd0e, 0x00000020,
  0x0189f6c4, 0x0189f9d9, 0x0189fcee, 0x00000020,
  0x018cf6b2, 0x018cf9cd, 0x018cfce8, 0x00000020,
  0x018ef6a6, 0x018ef9c5, 0x018efce4, 0x00000020,
  0x018ff6a0, 0x018ff9c1, 0x018ffce2, 0x00000020,
  0x018ff6a0, 0x018ff9c1, 0x018ffce2, 0x00000020,
  0x007dfd0c, 0x007dfe09, 0x007dff06, 0x00000020,
  0x00fafa1e, 0x00fafc15, 0x00fafe0c, 0x00000020,
  0x010af9be, 0x010afbd5, 0x010afdec, 0x00000020,
  0x010df9ac, 0x010dfbc9, 0x010dfde6, 0x00000020,
  0x010ff9a0, 0x010ffbc1, 0x010ffde2, 0x00000020,
  0x0110f99a, 0x0110fbbd, 0x0110fde0, 0x00000020,
  0x0110f99a, 0x0110fbbd, 0x0110fde0, 0x00000020,
  0x010ff9a0, 0x010ffbc1, 0x010ffde2, 0x00000020,
  0x007cfd12, 0x007cfe0d, 0x007cff08, 0x00000020,
  0x008cfcb2, 0x008cfdcd, 0x008cfee8, 0x00000020,
  0x008ffca0, 0x008ffdc1, 0x008ffee2, 0x00000020,
  0x0091fc94, 0x0091fdb9, 0x0091fede, 0x00000020,
  0x0092fc8e, 0x0092fdb5, 0x0092fedc, 0x00000020,
  0x0092fc8e, 0x0092fdb5, 0x0092fedc, 0x00000020,
  0x0091fc94, 0x0091fdb9, 0x0091fede, 0x00000020,
  0x008ffca0, 0x008ffdc1, 0x008ffee2, 0x00000020,
  0x000fffa0, 0x000fffc1, 0x000fffe2, 0x00000020,
  0x0012ff8e, 0x0012ffb5, 0x0012ffdc, 0x00000020,
  0x0014ff82, 0x0014ffad, 0x0014ffd8, 0x00000020,
  0x0015ff7c, 0x0015ffa9, 0x0015ffd6, 0x00000020,
  0x0015ff7c, 0x0015ffa9, 0x0015ffd6, 0x00000020,
  0x0014ff82, 0x0014ffad, 0x0014ffd8, 0x00000020,
  0x0012ff8e, 0x0012ffb5, 0x0012ffdc, 0x00000020,
  0x0002ffee, 0x0002fff5, 0x0002fffc, 0x00000020,
  0x0002ffee, 0x0002fff5, 0x0002fffc, 0x00000020,
  0x0004ffe2, 0x0004ffed, 0x0004fff8, 0x00000020,
  0x0005ffdc, 0x0005ffe9, 0x0005fff6, 0x00000020,
  0x0005ffdc, 0x0005ffe9, 0x0005fff6, 0x00000020,
  0x0004ffe2, 0x0004ffed, 0x0004fff8, 0x00000020,
  0x0002ffee, 0x0002fff5, 0x0002fffc, 0x00000020,
  0xfff3004e, 0xfff30035, 0xfff3001c, 0x00000020,
  0xff76033c, 0xff760229, 0xff760116, 0x00000020,
  0x0001fff4, 0x0001fff9, 0x0001fffe, 0x00000020,
  0x0002ffee, 0x0002fff5, 0x0002fffc, 0x00000020,
  0x0002ffee, 0x0002fff5, 0x0002fffc, 0x00000020,
  0x0001fff4, 0x0001fff9, 0x0001fffe, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfff00060, 0xfff00041, 0xfff00022, 0x00000020,
  0xff73034e, 0xff730235, 0xff73011c, 0x00000020,
  0xfef50642, 0xfef5042d, 0xfef50218, 0x00000020,
  0x0000fffa, 0x0000fffd, 0x00010000, 0x00000020,
  0x0000fffa, 0x0000fffd, 0x00010000, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffe000c, 0xfffe0009, 0xfffe0006, 0x00000020,
  0xffee006c, 0xffee0049, 0xffee0026, 0x00000020,
  0xff71035a, 0xff71023d, 0xff710120, 0x00000020,
  0xfef3064e, 0xfef30435, 0xfef3021c, 0x00000020,
  0xfe740948, 0xfe740631, 0xfe74031a, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff0006, 0xffff0005, 0xffff0004, 0x00000020,
  0xfffd0012, 0xfffd000d, 0xfffd0008, 0x00000020,
  0xffed0072, 0xffed004d, 0xffed0028, 0x00000020,
  0xff700360, 0xff700241, 0xff700122, 0x00000020,
  0xfef20654, 0xfef20439, 0xfef2021e, 0x00000020,
  0xfe73094e, 0xfe730635, 0xfe73031c, 0x00000020,
  0xcb413c80, 0xcb40d301, 0xcb406982, 0x00000020,
  0xffff0006, 0xffff0005, 0xffff0004, 0x00000020,
  0xfffd0012, 0xfffd000d, 0xfffd0008, 0x00000020,
  0xffed0072, 0xffed004d, 0xffed0028, 0x00000020,
  0xff700360, 0xff700241, 0xff700122, 0x00000020,
  0xfef20654, 0xfef20439, 0xfef2021e, 0x00000020,
  0xfe73094e, 0xfe730635, 0xfe73031c, 0x00000020,
  0xcb413c80, 0xcb40d301, 0xcb406982, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0xfffe000c, 0xfffe0009, 0xfffe0006, 0x00000020,
  0xffee006c, 0xffee0049, 0xffee0026, 0x00000020,
  0xff71035a, 0xff71023d, 0xff710120, 0x00000020,
  0xfef3064e, 0xfef30435, 0xfef3021c, 0x00000020,
  0xfe740948, 0xfe740631, 0xfe74031a, 0x00000020,
  0xcb423c7a, 0xcb41d2fd, 0xcb416980, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0xfff00060, 0xfff00041, 0xfff00022, 0x00000020,
  0xff73034e, 0xff730235, 0xff73011c, 0x00000020,
  0xfef50642, 0xfef5042d, 0xfef50218, 0x00000020,
  0xfe76093c, 0xfe760629, 0xfe760316, 0x00000020,
  0xcb443c6e, 0xcb43d2f5, 0xcb43697c, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0xff8302ee, 0xff8301f5, 0xff8300fc, 0x00000020,
  0xff0505e2, 0xff0503ed, 0xff0501f8, 0x00000020,
  0xfe8608dc, 0xfe8605e9, 0xfe8602f6, 0x00000020,
  0xcb543c0e, 0xcb53d2b5, 0xcb53695c, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0xff8202f4, 0xff8201f9, 0xff8200fe, 0x00000020,
  0xff0305ee, 0xff0303f5, 0xff0301fc, 0x00000020,
  0xcbd13920, 0xcbd0d0c1, 0xcbd06862, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0xfffd0000, 0xfffe0000, 0xffff0000, 0x00000020,
  0xff8102fa, 0xff8101fd, 0xff810100, 0x00000020,
  0xcc4f362c, 0xcc4ecec9, 0xcc4e6766, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0xfffd0000, 0xfffe0000, 0xffff0000, 0x00000020,
  0x7ff90006, 0x7ffb0004, 0x7ffd0002, 0x00000020,
  0xccce3332, 0xcccdcccd, 0xcccd6668, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0xfffd0000, 0xfffe0000, 0xffff0000, 0x00000020,
  0x7ff90006, 0x7ffb0004, 0x7ffd0002, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0xaaacfffe, 0xaaac5555, 0xaaabaaac, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0xfffd0000, 0xfffe0000, 0xffff0000, 0x00000020,
  0x7ff90006, 0x7ffb0004, 0x7ffd0002, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x8005ffee, 0x8004fff5, 0x8003fffc, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0xfffd0000, 0xfffe0000, 0xffff0000, 0x00000020,
  0x7ff90006, 0x7ffb0004, 0x7ffd0002, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x8004fff4, 0x8003fff9, 0x8002fffe, 0x00000020,
  0x80000000, 0x80000000, 0x80000000, 0x00000020,
  0xfffd0000, 0xfffe0000, 0xffff0000, 0x00000020,
  0x7ff90006, 0x7ffb0004, 0x7ffd0002, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x8003fffa, 0x8002fffd, 0x80020000, 0x00000020,
  0x0000fffa, 0x0000fffd, 0x00010000, 0x00000020,
  0x7ffd0000, 0x7ffe0001, 0x7fff0002, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7ffd0000, 0x7ffe0001, 0x7fff0002, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7ffc0006, 0x7ffd0005, 0x7ffe0004, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x5553fffc, 0x5554aaa9, 0x55555556, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000020,
  0x3332ccc8, 0x33333331, 0x3333999a, 0x00000020,
  0x33b2c9c8, 0x33b33131, 0x33b3989a, 0x00000020,
  0x3431c6ce, 0x34322f35, 0x3432979c, 0x00000020,
  0x34afc3da, 0x34b02d3d, 0x34b096a0, 0x00000020,
  0x352cc0ec, 0x352d2b49, 0x352d95a6, 0x00000020,
  0x353cc08c, 0x353d2b09, 0x353d9586, 0x00000020,
  0x353fc07a, 0x35402afd, 0x35409580, 0x00000020,
  0x3541c06e, 0x35422af5, 0x3542957c, 0x00000020,
  0x007ffd00, 0x007ffe01, 0x007fff02, 0x00000020,
  0x00fefa06, 0x00fefc05, 0x00fefe04, 0x00000020,
  0x017cf712, 0x017cfa0d, 0x017cfd08, 0x00000020,
  0x01f9f424, 0x01f9f819, 0x01f9fc0e, 0x00000020,
  0x0209f3c4, 0x0209f7d9, 0x0209fbee, 0x00000020,
  0x020cf3b2, 0x020cf7cd, 0x020cfbe8, 0x00000020,
  0x020ef3a6, 0x020ef7c5, 0x020efbe4, 0x00000020,
  0x020ff3a0, 0x020ff7c1, 0x020ffbe2, 0x00000020,
  0x007efe04, 0x007eff03, 0x00000002, 0x0000011e,
  0x00fcfc0c, 0x00fcfe07, 0x00000002, 0x0000021a,
  0x0179fa18, 0x0179fd0d, 0x00000002, 0x00000314,
  0x0189f9d8, 0x0189fced, 0x00000002, 0x00000334,
  0x018cf9cc, 0x018cfce7, 0x00000002, 0x0000033a,
  0x018ef9c4, 0x018efce3, 0x00000002, 0x0000033e,
  0x018ff9c0, 0x018ffce1, 0x00000002, 0x00000340,
  0x018ff9c0, 0x018ffce1, 0x00000002, 0x00000340,
  0x007dfe08, 0x007dff05, 0x00000002, 0x0000011c,
  0x00fafc14, 0x00fafe0b, 0x00000002, 0x00000216,
  0x010afbd4, 0x010afdeb, 0x00000002, 0x00000236,
  0x010dfbc8, 0x010dfde5, 0x00000002, 0x0000023c,
  0x010ffbc0, 0x010ffde1, 0x00000002, 0x00000240,
  0x0110fbbc, 0x0110fddf, 0x00000002, 0x00000242,
  0x0110fbbc, 0x0110fddf, 0x00000002, 0x00000242,
  0x010ffbc0, 0x010ffde1, 0x00000002, 0x00000240,
  0x007cfe0c, 0x007cff07, 0x00000002, 0x0000011a,
  0x008cfdcc, 0x008cfee7, 0x00000002, 0x0000013a,
  0x008ffdc0, 0x008ffee1, 0x00000002, 0x00000140,
  0x0091fdb8, 0x0091fedd, 0x00000002, 0x00000144,
  0x0092fdb4, 0x0092fedb, 0x00000002, 0x00000146,
  0x0092fdb4, 0x0092fedb, 0x00000002, 0x00000146,
  0x0091fdb8, 0x0091fedd, 0x00000002, 0x00000144,
  0x008ffdc0, 0x008ffee1, 0x00000002, 0x00000140,
  0x000fffc0, 0x000fffe1, 0x00000002, 0x00000040,
  0x0012ffb4, 0x0012ffdb, 0x00000002, 0x00000046,
  0x0014ffac, 0x0014ffd7, 0x00000002, 0x0000004a,
  0x0015ffa8, 0x0015ffd5, 0x00000002, 0x0000004c,
  0x0015ffa8, 0x0015ffd5, 0x00000002, 0x0000004c,
  0x0014ffac, 0x0014ffd7, 0x00000002, 0x0000004a,
  0x0012ffb4, 0x0012ffdb, 0x00000002, 0x00000046,
  0x0002fff4, 0x0002fffb, 0x00000002, 0x00000026,
  0x0002fff4, 0x0002fffb, 0x00000002, 0x00000026,
  0x0004ffec, 0x0004fff7, 0x00000002, 0x0000002a,
  0x0005ffe8, 0x0005fff5, 0x00000002, 0x0000002c,
  0x0005ffe8, 0x0005fff5, 0x00000002, 0x0000002c,
  0x0004ffec, 0x0004fff7, 0x00000002, 0x0000002a,
  0x0002fff4, 0x0002fffb, 0x00000002, 0x00000026,
  0xfff30034, 0xfff3001b, 0x00000002, 0x00000006,
  0xff760228, 0xff760115, 0x00000002, 0xffffff0c,
  0x0001fff8, 0x0001fffd, 0x00000002, 0x00000024,
  0x0002fff4, 0x0002fffb, 0x00000002, 0x00000026,
  0x0002fff4, 0x0002fffb, 0x00000002, 0x00000026,
  0x0001fff8, 0x0001fffd, 0x00000002, 0x00000024,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfff00040, 0xfff00021, 0x00000002, 0x00000000,
  0xff730234, 0xff73011b, 0x00000002, 0xffffff06,
  0xfef5042c, 0xfef50217, 0x00000002, 0xfffffe0a,
  0x0000fffc, 0x0000ffff, 0x00000002, 0x00000022,
  0x0000fffc, 0x0000ffff, 0x00000002, 0x00000022,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffe0008, 0xfffe0005, 0x00000002, 0x0000001c,
  0xffee0048, 0xffee0025, 0x00000002, 0xfffffffc,
  0xff71023c, 0xff71011f, 0x00000002, 0xffffff02,
  0xfef30434, 0xfef3021b, 0x00000002, 0xfffffe06,
  0xfe740630, 0xfe740319, 0x00000002, 0xfffffd08,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff0004, 0xffff0003, 0x00000002, 0x0000001e,
  0xfffd000c, 0xfffd0007, 0x00000002, 0x0000001a,
  0xffed004c, 0xffed0027, 0x00000002, 0xfffffffa,
  0xff700240, 0xff700121, 0x00000002, 0xffffff00,
  0xfef20438, 0xfef2021d, 0x00000002, 0xfffffe04,
  0xfe730634, 0xfe73031b, 0x00000002, 0xfffffd06,
  0xcb40d300, 0xcb406981, 0x00000002, 0xffff96a0,
  0xffff0004, 0xffff0003, 0x00000002, 0x0000001e,
  0xfffd000c, 0xfffd0007, 0x00000002, 0x0000001a,
  0xffed004c, 0xffed0027, 0x00000002, 0xfffffffa,
  0xff700240, 0xff700121, 0x00000002, 0xffffff00,
  0xfef20438, 0xfef2021d, 0x00000002, 0xfffffe04,
  0xfe730634, 0xfe73031b, 0x00000002, 0xfffffd06,
  0xcb40d300, 0xcb406981, 0x00000002, 0xffff96a0,
  0x80000000, 0x80000000, 0x00000002, 0xfffeebf6,
  0xfffe0008, 0xfffe0005, 0x00000002, 0x0000001c,
  0xffee0048, 0xffee0025, 0x00000002, 0xfffffffc,
  0xff71023c, 0xff71011f, 0x00000002, 0xffffff02,
  0xfef30434, 0xfef3021b, 0x00000002, 0xfffffe06,
  0xfe740630, 0xfe740319, 0x00000002, 0xfffffd08,
  0xcb41d2fc, 0xcb41697f, 0x00000002, 0xffff96a2,
  0x80000000, 0x80000000, 0x00000002, 0xfffeebf8,
  0x80000000, 0x80000000, 0x00000002, 0xfffdebfe,
  0xfff00040, 0xfff00021, 0x00000002, 0x00000000,
  0xff730234, 0xff73011b, 0x00000002, 0xffffff06,
  0xfef5042c, 0xfef50217, 0x00000002, 0xfffffe0a,
  0xfe760628, 0xfe760315, 0x00000002, 0xfffffd0c,
  0xcb43d2f4, 0xcb43697b, 0x00000002, 0xffff96a6,
  0x80000000, 0x80000000, 0x00000002, 0xfffeebfc,
  0x80000000, 0x80000000, 0x00000002, 0xfffdec02,
  0x80000000, 0x80000000, 0x00000002, 0xfffcec06,
  0xff8301f4, 0xff8300fb, 0x00000002, 0xffffff26,
  0xff0503ec, 0xff0501f7, 0x00000002, 0xfffffe2a,
  0xfe8605e8, 0xfe8602f5, 0x00000002, 0xfffffd2c,
  0xcb53d2b4, 0xcb53695b, 0x00000002, 0xffff96c6,
  0x80000000, 0x80000000, 0x00000002, 0xfffeec1c,
  0x80000000, 0x80000000, 0x00000002, 0xfffdec22,
  0x80000000, 0x80000000, 0x00000002, 0xfffcec26,
  0x80000000, 0x80000000, 0x00000002, 0xfffbec28,
  0xff8201f8, 0xff8200fd, 0x00000002, 0xffffff24,
  0xff0303f4, 0xff0301fb, 0x00000002, 0xfffffe26,
  0xcbd0d0c0, 0xcbd06861, 0x00000002, 0xffff97c0,
  0x80000000, 0x80000000, 0x00000002, 0xfffeed16,
  0x80000000, 0x80000000, 0x00000002, 0xfffded1c,
  0x80000000, 0x80000000, 0x00000002, 0xfffced20,
  0x80000000, 0x80000000, 0x00000002, 0xfffbed22,
  0xfffe0000, 0xffff0000, 0x00000002, 0xfffced22,
  0xff8101fc, 0xff8100ff, 0x00000002, 0xffffff22,
  0xcc4ecec8, 0xcc4e6765, 0x00000002, 0xffff98bc,
  0x80000000, 0x80000000, 0x00000002, 0xfffeee12,
  0x80000000, 0x80000000, 0x00000002, 0xfffdee18,
  0x80000000, 0x80000000, 0x00000002, 0xfffcee1c,
  0x80000000, 0x80000000, 0x00000002, 0xfffbee1e,
  0xfffe0000, 0xffff0000, 0x00000002, 0xfffcee1e,
  0x7ffb0004, 0x7ffd0002, 0x00000002, 0xfffdee1c,
  0xcccdcccc, 0xcccd6667, 0x00000002, 0xffff99ba,
  0x80000000, 0x80000000, 0x00000002, 0xfffeef10,
  0x80000000, 0x80000000, 0x00000002, 0xfffdef16,
  0x80000000, 0x80000000, 0x00000002, 0xfffcef1a,
  0x80000000, 0x80000000, 0x00000002, 0xfffbef1c,
  0xfffe0000, 0xffff0000, 0x00000002, 0xfffcef1c,
  0x7ffb0004, 0x7ffd0002, 0x00000002, 0xfffdef1a,
  0x7fffffff, 0x7fffffff, 0x00000002, 0xfffe99c6,
  0xaaac5554, 0xaaabaaab, 0x00000002, 0xffff5576,
  0x80000000, 0x80000000, 0x00000002, 0xfffe557c,
  0x80000000, 0x80000000, 0x00000002, 0xfffd5580,
  0x80000000, 0x80000000, 0x00000002, 0xfffc5582,
  0xfffe0000, 0xffff0000, 0x00000002, 0xfffd5582,
  0x7ffb0004, 0x7ffd0002, 0x00000002, 0xfffe5580,
  0x7fffffff, 0x7fffffff, 0x00000002, 0xffff002c,
  0x7fffffff, 0x7fffffff, 0x00000002, 0xffff6694,
  0x8004fff4, 0x8003fffb, 0x00000002, 0xffff0026,
  0x80000000, 0x80000000, 0x00000002, 0xfffe002a,
  0x80000000, 0x80000000, 0x00000002, 0xfffd002c,
  0xfffe0000, 0xffff0000, 0x00000002, 0xfffe002c,
  0x7ffb0004, 0x7ffd0002, 0x00000002, 0xffff002a,
  0x7fffffff, 0x7fffffff, 0x00000002, 0xffffaad6,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x0000113e,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x0000123e,
  0x8003fff8, 0x8002fffd, 0x00000002, 0xffff0024,
  0x80000000, 0x80000000, 0x00000002, 0xfffe0026,
  0xfffe0000, 0xffff0000, 0x00000002, 0xffff0026,
  0x7ffb0004, 0x7ffd0002, 0x00000002, 0x00000024,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x0000aad0,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x00011138,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x00011238,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x00011336,
  0x8002fffc, 0x8001ffff, 0x00000002, 0xffff0022,
  0x0000fffc, 0x0000ffff, 0x00000002, 0x00000022,
  0x7ffe0000, 0x7fff0001, 0x00000002, 0x00010020,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x0001aacc,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x00021134,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x00021234,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x00021332,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x0002142e,
  0x7ffe0000, 0x7fff0001, 0x00000002, 0x00010020,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x0002001e,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x0002aaca,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x00031132,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x00031232,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x00031330,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x0003142c,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x00031526,
  0x7ffd0004, 0x7ffe0003, 0x00000002, 0x0001001e,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x0001aaca,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x00021132,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x00021232,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x00021330,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x0002142c,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x00021526,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x00021546,
  0x5554aaa8, 0x55555555, 0x00000002, 0x0000aacc,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x00011134,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x00011234,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x00011332,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x0001142e,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x00011528,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x00011548,
  0x7fffffff, 0x7fffffff, 0x00000002, 0x0001154e,
  0x33333330, 0x33339999, 0x00000002, 0x00006688,
  0x33b33130, 0x33b39899, 0x00000002, 0x00006788,
  0x34322f34, 0x3432979b, 0x00000002, 0x00006886,
  0x34b02d3c, 0x34b0969f, 0x00000002, 0x00006982,
  0x352d2b48, 0x352d95a5, 0x00000002, 0x00006a7c,
  0x353d2b08, 0x353d9585, 0x00000002, 0x00006a9c,
  0x35402afc, 0x3540957f, 0x00000002, 0x00006aa2,
  0x35422af4, 0x3542957b, 0x00000002, 0x00006aa6,
  0x007ffe00, 0x007fff01, 0x00000002, 0x00000120,
  0x00fefc04, 0x00fefe03, 0x00000002, 0x0000021e,
  0x017cfa0c, 0x017cfd07, 0x00000002, 0x0000031a,
  0x01f9f818, 0x01f9fc0d, 0x00000002, 0x00000414,
  0x0209f7d8, 0x0209fbed, 0x00000002, 0x00000434,
  0x020cf7cc, 0x020cfbe7, 0x00000002, 0x0000043a,
  0x020ef7c4, 0x020efbe3, 0x00000002, 0x0000043e,
  0x020ff7c0, 0x020ffbe1, 0x00000002, 0x00000440,
  0x007eff02, 0x00000001, 0x00000100, 0x0000021c,
  0x00fcfe06, 0x00000001, 0x000001fc, 0x00000414,
  0x0179fd0c, 0x00000001, 0x000002f6, 0x00000608,
  0x0189fcec, 0x00000001, 0x00000316, 0x00000648,
  0x018cfce6, 0x00000001, 0x0000031c, 0x00000654,
  0x018efce2, 0x00000001, 0x00000320, 0x0000065c,
  0x018ffce0, 0x00000001, 0x00000322, 0x00000660,
  0x018ffce0, 0x00000001, 0x00000322, 0x00000660,
  0x007dff04, 0x00000001, 0x000000fe, 0x00000218,
  0x00fafe0a, 0x00000001, 0x000001f8, 0x0000040c,
  0x010afdea, 0x00000001, 0x00000218, 0x0000044c,
  0x010dfde4, 0x00000001, 0x0000021e, 0x00000458,
  0x010ffde0, 0x00000001, 0x00000222, 0x00000460,
  0x0110fdde, 0x00000001, 0x00000224, 0x00000464,
  0x0110fdde, 0x00000001, 0x00000224, 0x00000464,
  0x010ffde0, 0x00000001, 0x00000222, 0x00000460,
  0x007cff06, 0x00000001, 0x000000fc, 0x00000214,
  0x008cfee6, 0x00000001, 0x0000011c, 0x00000254,
  0x008ffee0, 0x00000001, 0x00000122, 0x00000260,
  0x0091fedc, 0x00000001, 0x00000126, 0x00000268,
  0x0092feda, 0x00000001, 0x00000128, 0x0000026c,
  0x0092feda, 0x00000001, 0x00000128, 0x0000026c,
  0x0091fedc, 0x00000001, 0x00000126, 0x00000268,
  0x008ffee0, 0x00000001, 0x00000122, 0x00000260,
  0x000fffe0, 0x00000001, 0x00000022, 0x00000060,
  0x0012ffda, 0x00000001, 0x00000028, 0x0000006c,
  0x0014ffd6, 0x00000001, 0x0000002c, 0x00000074,
  0x0015ffd4, 0x00000001, 0x0000002e, 0x00000078,
  0x0015ffd4, 0x00000001, 0x0000002e, 0x00000078,
  0x0014ffd6, 0x00000001, 0x0000002c, 0x00000074,
  0x0012ffda, 0x00000001, 0x00000028, 0x0000006c,
  0x0002fffa, 0x00000001, 0x00000008, 0x0000002c,
  0x0002fffa, 0x00000001, 0x00000008, 0x0000002c,
  0x0004fff6, 0x00000001, 0x0000000c, 0x00000034,
  0x0005fff4, 0x00000001, 0x0000000e, 0x00000038,
  0x0005fff4, 0x00000001, 0x0000000e, 0x00000038,
  0x0004fff6, 0x00000001, 0x0000000c, 0x00000034,
  0x0002fffa, 0x00000001, 0x00000008, 0x0000002c,
  0xfff3001a, 0x00000001, 0xffffffe8, 0xffffffec,
  0xff760114, 0x00000001, 0xfffffeee, 0xfffffdf8,
  0x0001fffc, 0x00000001, 0x00000006, 0x00000028,
  0x0002fffa, 0x00000001, 0x00000008, 0x0000002c,
  0x0002fffa, 0x00000001, 0x00000008, 0x0000002c,
  0x0001fffc, 0x00000001, 0x00000006, 0x00000028,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfff00020, 0x00000001, 0xffffffe2, 0xffffffe0,
  0xff73011a, 0x00000001, 0xfffffee8, 0xfffffdec,
  0xfef50216, 0x00000001, 0xfffffdec, 0xfffffbf4,
  0x0000fffe, 0x00000001, 0x00000004, 0x00000024,
  0x0000fffe, 0x00000001, 0x00000004, 0x00000024,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffe0004, 0x00000001, 0xfffffffe, 0x00000018,
  0xffee0024, 0x00000001, 0xffffffde, 0xffffffd8,
  0xff71011e, 0x00000001, 0xfffffee4, 0xfffffde4,
  0xfef3021a, 0x00000001, 0xfffffde8, 0xfffffbec,
  0xfe740318, 0x00000001, 0xfffffcea, 0xfffff9f0,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff0002, 0x00000001, 0x00000000, 0x0000001c,
  0xfffd0006, 0x00000001, 0xfffffffc, 0x00000014,
  0xffed0026, 0x00000001, 0xffffffdc, 0xffffffd4,
  0xff700120, 0x00000001, 0xfffffee2, 0xfffffde0,
  0xfef2021c, 0x00000001, 0xfffffde6, 0xfffffbe8,
  0xfe73031a, 0x00000001, 0xfffffce8, 0xfffff9ec,
  0xcb406980, 0x00000001, 0xffff9682, 0xffff2d20,
  0xffff0002, 0x00000001, 0x00000000, 0x0000001c,
  0xfffd0006, 0x00000001, 0xfffffffc, 0x00000014,
  0xffed0026, 0x00000001, 0xffffffdc, 0xffffffd4,
  0xff700120, 0x00000001, 0xfffffee2, 0xfffffde0,
  0xfef2021c, 0x00000001, 0xfffffde6, 0xfffffbe8,
  0xfe73031a, 0x00000001, 0xfffffce8, 0xfffff9ec,
  0xcb406980, 0x00000001, 0xffff9682, 0xffff2d20,
  0x80000000, 0x00000001, 0xfffeebd8, 0xfffdd7cc,
  0xfffe0004, 0x00000001, 0xfffffffe, 0x00000018,
  0xffee0024, 0x00000001, 0xffffffde, 0xffffffd8,
  0xff71011e, 0x00000001, 0xfffffee4, 0xfffffde4,
  0xfef3021a, 0x00000001, 0xfffffde8, 0xfffffbec,
  0xfe740318, 0x00000001, 0xfffffcea, 0xfffff9f0,
  0xcb41697e, 0x00000001, 0xffff9684, 0xffff2d24,
  0x80000000, 0x00000001, 0xfffeebda, 0xfffdd7d0,
  0x80000000, 0x00000001, 0xfffdebe0, 0xfffbd7dc,
  0xfff00020, 0x00000001, 0xffffffe2, 0xffffffe0,
  0xff73011a, 0x00000001, 0xfffffee8, 0xfffffdec,
  0xfef50216, 0x00000001, 0xfffffdec, 0xfffffbf4,
  0xfe760314, 0x00000001, 0xfffffcee, 0xfffff9f8,
  0xcb43697a, 0x00000001, 0xffff9688, 0xffff2d2c,
  0x80000000, 0x00000001, 0xfffeebde, 0xfffdd7d8,
  0x80000000, 0x00000001, 0xfffdebe4, 0xfffbd7e4,
  0x80000000, 0x00000001, 0xfffcebe8, 0xfff9d7ec,
  0xff8300fa, 0x00000001, 0xffffff08, 0xfffffe2c,
  0xff0501f6, 0x00000001, 0xfffffe0c, 0xfffffc34,
  0xfe8602f4, 0x00000001, 0xfffffd0e, 0xfffffa38,
  0xcb53695a, 0x00000001, 0xffff96a8, 0xffff2d6c,
  0x80000000, 0x00000001, 0xfffeebfe, 0xfffdd818,
  0x80000000, 0x00000001, 0xfffdec04, 0xfffbd824,
  0x80000000, 0x00000001, 0xfffcec08, 0xfff9d82c,
  0x80000000, 0x00000001, 0xfffbec0a, 0xfff7d830,
  0xff8200fc, 0x00000001, 0xffffff06, 0xfffffe28,
  0xff0301fa, 0x00000001, 0xfffffe08, 0xfffffc2c,
  0xcbd06860, 0x00000001, 0xffff97a2, 0xffff2f60,
  0x80000000, 0x00000001, 0xfffeecf8, 0xfffdda0c,
  0x80000000, 0x00000001, 0xfffdecfe, 0xfffbda18,
  0x80000000, 0x00000001, 0xfffced02, 0xfff9da20,
  0x80000000, 0x00000001, 0xfffbed04, 0xfff7da24,
  0xffff0000, 0x00000001, 0xfffced04, 0xfff9da24,
  0xff8100fe, 0x00000001, 0xffffff04, 0xfffffe24,
  0xcc4e6764, 0x00000001, 0xffff989e, 0xffff3158,
  0x80000000, 0x00000001, 0xfffeedf4, 0xfffddc04,
  0x80000000, 0x00000001, 0xfffdedfa, 0xfffbdc10,
  0x80000000, 0x00000001, 0xfffcedfe, 0xfff9dc18,
  0x80000000, 0x00000001, 0xfffbee00, 0xfff7dc1c,
  0xffff0000, 0x00000001, 0xfffcee00, 0xfff9dc1c,
  0x7ffd0002, 0x00000001, 0xfffdedfe, 0xfffbdc18,
  0xcccd6666, 0x00000001, 0xffff999c, 0xffff3354,
  0x80000000, 0x00000001, 0xfffeeef2, 0xfffdde00,
  0x80000000, 0x00000001, 0xfffdeef8, 0xfffbde0c,
  0x80000000, 0x00000001, 0xfffceefc, 0xfff9de14,
  0x80000000, 0x00000001, 0xfffbeefe, 0xfff7de18,
  0xffff0000, 0x00000001, 0xfffceefe, 0xfff9de18,
  0x7ffd0002, 0x00000001, 0xfffdeefc, 0xfffbde14,
  0x7fffffff, 0x00000001, 0xfffe99a8, 0xfffd336c,
  0xaaabaaaa, 0x00000001, 0xffff5558, 0xfffeaacc,
  0x80000000, 0x00000001, 0xfffe555e, 0xfffcaad8,
  0x80000000, 0x00000001, 0xfffd5562, 0xfffaaae0,
  0x80000000, 0x00000001, 0xfffc5564, 0xfff8aae4,
  0xffff0000, 0x00000001, 0xfffd5564, 0xfffaaae4,
  0x7ffd0002, 0x00000001, 0xfffe5562, 0xfffcaae0,
  0x7fffffff, 0x00000001, 0xffff000e, 0xfffe0038,
  0x7fffffff, 0x00000001, 0xffff6676, 0xfffecd08,
  0x8003fffa, 0x00000001, 0xffff0008, 0xfffe002c,
  0x80000000, 0x00000001, 0xfffe000c, 0xfffc0034,
  0x80000000, 0x00000001, 0xfffd000e, 0xfffa0038,
  0xffff0000, 0x00000001, 0xfffe000e, 0xfffc0038,
  0x7ffd0002, 0x00000001, 0xffff000c, 0xfffe0034,
  0x7fffffff, 0x00000001, 0xffffaab8, 0xffff558c,
  0x7fffffff, 0x00000001, 0x00001120, 0x0000225c,
  0x7fffffff, 0x00000001, 0x00001220, 0x0000245c,
  0x8002fffc, 0x00000001, 0xffff0006, 0xfffe0028,
  0x80000000, 0x00000001, 0xfffe0008, 0xfffc002c,
  0xffff0000, 0x00000001, 0xffff0008, 0xfffe002c,
  0x7ffd0002, 0x00000001, 0x00000006, 0x00000028,
  0x7fffffff, 0x00000001, 0x0000aab2, 0x00015580,
  0x7fffffff, 0x00000001, 0x0001111a, 0x00022250,
  0x7fffffff, 0x00000001, 0x0001121a, 0x00022450,
  0x7fffffff, 0x00000001, 0x00011318, 0x0002264c,
  0x8001fffe, 0x00000001, 0xffff0004, 0xfffe0024,
  0x0000fffe, 0x00000001, 0x00000004, 0x00000024,
  0x7fff0000, 0x00000001, 0x00010002, 0x00020020,
  0x7fffffff, 0x00000001, 0x0001aaae, 0x00035578,
  0x7fffffff, 0x00000001, 0x00021116, 0x00042248,
  0x7fffffff, 0x00000001, 0x00021216, 0x00042448,
  0x7fffffff, 0x00000001, 0x00021314, 0x00042644,
  0x7fffffff, 0x00000001, 0x00021410, 0x0004283c,
  0x7fff0000, 0x00000001, 0x00010002, 0x00020020,
  0x7fffffff, 0x00000001, 0x00020000, 0x0004001c,
  0x7fffffff, 0x00000001, 0x0002aaac, 0x00055574,
  0x7fffffff, 0x00000001, 0x00031114, 0x00062244,
  0x7fffffff, 0x00000001, 0x00031214, 0x00062444,
  0x7fffffff, 0x00000001, 0x00031312, 0x00062640,
  0x7fffffff, 0x00000001, 0x0003140e, 0x00062838,
  0x7fffffff, 0x00000001, 0x00031508, 0x00062a2c,
  0x7ffe0002, 0x00000001, 0x00010000, 0x0002001c,
  0x7fffffff, 0x00000001, 0x0001aaac, 0x00035574,
  0x7fffffff, 0x00000001, 0x00021114, 0x00042244,
  0x7fffffff, 0x00000001, 0x00021214, 0x00042444,
  0x7fffffff, 0x00000001, 0x00021312, 0x00042640,
  0x7fffffff, 0x00000001, 0x0002140e, 0x00042838,
  0x7fffffff, 0x00000001, 0x00021508, 0x00042a2c,
  0x7fffffff, 0x00000001, 0x00021528, 0x00042a6c,
  0x55555554, 0x00000001, 0x0000aaae, 0x00015578,
  0x7fffffff, 0x00000001, 0x00011116, 0x00022248,
  0x7fffffff, 0x00000001, 0x00011216, 0x00022448,
  0x7fffffff, 0x00000001, 0x00011314, 0x00022644,
  0x7fffffff, 0x00000001, 0x00011410, 0x0002283c,
  0x7fffffff, 0x00000001, 0x0001150a, 0x00022a30,
  0x7fffffff, 0x00000001, 0x0001152a, 0x00022a70,
  0x7fffffff, 0x00000001, 0x00011530, 0x00022a7c,
  0x33339998, 0x00000001, 0x0000666a, 0x0000ccf0,
  0x33b39898, 0x00000001, 0x0000676a, 0x0000cef0,
  0x3432979a, 0x00000001, 0x00006868, 0x0000d0ec,
  0x34b0969e, 0x00000001, 0x00006964, 0x0000d2e4,
  0x352d95a4, 0x00000001, 0x00006a5e, 0x0000d4d8,
  0x353d9584, 0x00000001, 0x00006a7e, 0x0000d518,
  0x3540957e, 0x00000001, 0x00006a84, 0x0000d524,
  0x3542957a, 0x00000001, 0x00006a88, 0x0000d52c,
  0x007fff00, 0x00000001, 0x00000102, 0x00000220,
  0x00fefe02, 0x00000001, 0x00000200, 0x0000041c,
  0x017cfd06, 0x00000001, 0x000002fc, 0x00000614,
  0x01f9fc0c, 0x00000001, 0x000003f6, 0x00000808,
  0x0209fbec, 0x00000001, 0x00000416, 0x00000848,
  0x020cfbe6, 0x00000001, 0x0000041c, 0x00000854,
  0x020efbe2, 0x00000001, 0x00000420, 0x0000085c,
  0x020ffbe0, 0x00000001, 0x00000422, 0x00000860,
  0x00000000, 0x000000ff, 0x000001fe, 0x00001000,
  0x00000000, 0x000001fb, 0x000003f6, 0x00001fc0,
  0x00000000, 0x000002f5, 0x000005ea, 0x00002f60,
  0x00000000, 0x00000315, 0x0000062a, 0x00003160,
  0x00000000, 0x0000031b, 0x00000636, 0x000031c0,
  0x00000000, 0x0000031f, 0x0000063e, 0x00003200,
  0x00000000, 0x00000321, 0x00000642, 0x00003220,
  0x00000000, 0x00000321, 0x00000642, 0x00003220,
  0x00000000, 0x000000fd, 0x000001fa, 0x00000fe0,
  0x00000000, 0x000001f7, 0x000003ee, 0x00001f80,
  0x00000000, 0x00000217, 0x0000042e, 0x00002180,
  0x00000000, 0x0000021d, 0x0000043a, 0x000021e0,
  0x00000000, 0x00000221, 0x00000442, 0x00002220,
  0x00000000, 0x00000223, 0x00000446, 0x00002240,
  0x00000000, 0x00000223, 0x00000446, 0x00002240,
  0x00000000, 0x00000221, 0x00000442, 0x00002220,
  0x00000000, 0x000000fb, 0x000001f6, 0x00000fc0,
  0x00000000, 0x0000011b, 0x00000236, 0x000011c0,
  0x00000000, 0x00000121, 0x00000242, 0x00001220,
  0x00000000, 0x00000125, 0x0000024a, 0x00001260,
  0x00000000, 0x00000127, 0x0000024e, 0x00001280,
  0x00000000, 0x00000127, 0x0000024e, 0x00001280,
  0x00000000, 0x00000125, 0x0000024a, 0x00001260,
  0x00000000, 0x00000121, 0x00000242, 0x00001220,
  0x00000000, 0x00000021, 0x00000042, 0x00000220,
  0x00000000, 0x00000027, 0x0000004e, 0x00000280,
  0x00000000, 0x0000002b, 0x00000056, 0x000002c0,
  0x00000000, 0x0000002d, 0x0000005a, 0x000002e0,
  0x00000000, 0x0000002d, 0x0000005a, 0x000002e0,
  0x00000000, 0x0000002b, 0x00000056, 0x000002c0,
  0x00000000, 0x00000027, 0x0000004e, 0x00000280,
  0x00000000, 0x00000007, 0x0000000e, 0x00000080,
  0x00000000, 0x00000007, 0x0000000e, 0x00000080,
  0x00000000, 0x0000000b, 0x00000016, 0x000000c0,
  0x00000000, 0x0000000d, 0x0000001a, 0x000000e0,
  0x00000000, 0x0000000d, 0x0000001a, 0x000000e0,
  0x00000000, 0x0000000b, 0x00000016, 0x000000c0,
  0x00000000, 0x00000007, 0x0000000e, 0x00000080,
  0x00000000, 0xffffffe7, 0xffffffce, 0xfffffe80,
  0x00000000, 0xfffffeed, 0xfffffdda, 0xffffeee0,
  0x00000000, 0x00000005, 0x0000000a, 0x00000060,
  0x00000000, 0x00000007, 0x0000000e, 0x00000080,
  0x00000000, 0x00000007, 0x0000000e, 0x00000080,
  0x00000000, 0x00000005, 0x0000000a, 0x00000060,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0xffffffe1, 0xffffffc2, 0xfffffe20,
  0x00000000, 0xfffffee7, 0xfffffdce, 0xffffee80,
  0x00000000, 0xfffffdeb, 0xfffffbd6, 0xffffdec0,
  0x00000000, 0x00000003, 0x00000006, 0x00000040,
  0x00000000, 0x00000003, 0x00000006, 0x00000040,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0xfffffffd, 0xfffffffa, 0xffffffe0,
  0x00000000, 0xffffffdd, 0xffffffba, 0xfffffde0,
  0x00000000, 0xfffffee3, 0xfffffdc6, 0xffffee40,
  0x00000000, 0xfffffde7, 0xfffffbce, 0xffffde80,
  0x00000000, 0xfffffce9, 0xfffff9d2, 0xffffcea0,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0xffffffff, 0xfffffffe, 0x00000000,
  0x00000000, 0xfffffffb, 0xfffffff6, 0xffffffc0,
  0x00000000, 0xffffffdb, 0xffffffb6, 0xfffffdc0,
  0x00000000, 0xfffffee1, 0xfffffdc2, 0xffffee20,
  0x00000000, 0xfffffde5, 0xfffffbca, 0xffffde60,
  0x00000000, 0xfffffce7, 0xfffff9ce, 0xffffce80,
  0x00000000, 0xffff9681, 0xffff2d02, 0xfff96820,
  0x00000000, 0xffffffff, 0xfffffffe, 0x00000000,
  0x00000000, 0xfffffffb, 0xfffffff6, 0xffffffc0,
  0x00000000, 0xffffffdb, 0xffffffb6, 0xfffffdc0,
  0x00000000, 0xfffffee1, 0xfffffdc2, 0xffffee20,
  0x00000000, 0xfffffde5, 0xfffffbca, 0xffffde60,
  0x00000000, 0xfffffce7, 0xfffff9ce, 0xffffce80,
  0x00000000, 0xffff9681, 0xffff2d02, 0xfff96820,
  0x00000000, 0xfffeebd7, 0xfffdd7ae, 0xffeebd80,
  0x00000000, 0xfffffffd, 0xfffffffa, 0xffffffe0,
  0x00000000, 0xffffffdd, 0xffffffba, 0xfffffde0,
  0x00000000, 0xfffffee3, 0xfffffdc6, 0xffffee40,
  0x00000000, 0xfffffde7, 0xfffffbce, 0xffffde80,
  0x00000000, 0xfffffce9, 0xfffff9d2, 0xffffcea0,
  0x00000000, 0xffff9683, 0xffff2d06, 0xfff96840,
  0x00000000, 0xfffeebd9, 0xfffdd7b2, 0xffeebda0,
  0x00000000, 0xfffdebdf, 0xfffbd7be, 0xffdebe00,
  0x00000000, 0xffffffe1, 0xffffffc2, 0xfffffe20,
  0x00000000, 0xfffffee7, 0xfffffdce, 0xffffee80,
  0x00000000, 0xfffffdeb, 0xfffffbd6, 0xffffdec0,
  0x00000000, 0xfffffced, 0xfffff9da, 0xffffcee0,
  0x00000000, 0xffff9687, 0xffff2d0e, 0xfff96880,
  0x00000000, 0xfffeebdd, 0xfffdd7ba, 0xffeebde0,
  0x00000000, 0xfffdebe3, 0xfffbd7c6, 0xffdebe40,
  0x00000000, 0xfffcebe7, 0xfff9d7ce, 0xffcebe80,
  0x00000000, 0xffffff07, 0xfffffe0e, 0xfffff080,
  0x00000000, 0xfffffe0b, 0xfffffc16, 0xffffe0c0,
  0x00000000, 0xfffffd0d, 0xfffffa1a, 0xffffd0e0,
  0x00000000, 0xffff96a7, 0xffff2d4e, 0xfff96a80,
  0x00000000, 0xfffeebfd, 0xfffdd7fa, 0xffeebfe0,
  0x00000000, 0xfffdec03, 0xfffbd806, 0xffdec040,
  0x00000000, 0xfffcec07, 0xfff9d80e, 0xffcec080,
  0x00000000, 0xfffbec09, 0xfff7d812, 0xffbec0a0,
  0x00000000, 0xffffff05, 0xfffffe0a, 0xfffff060,
  0x00000000, 0xfffffe07, 0xfffffc0e, 0xffffe080,
  0x00000000, 0xffff97a1, 0xffff2f42, 0xfff97a20,
  0x00000000, 0xfffeecf7, 0xfffdd9ee, 0xffeecf80,
  0x00000000, 0xfffdecfd, 0xfffbd9fa, 0xffdecfe0,
  0x00000000, 0xfffced01, 0xfff9da02, 0xffced020,
  0x00000000, 0xfffbed03, 0xfff7da06, 0xffbed040,
  0x00000000, 0xfffced03, 0xfff9da06, 0xffced040,
  0x00000000, 0xffffff03, 0xfffffe06, 0xfffff040,
  0x00000000, 0xffff989d, 0xffff313a, 0xfff989e0,
  0x00000000, 0xfffeedf3, 0xfffddbe6, 0xffeedf40,
  0x00000000, 0xfffdedf9, 0xfffbdbf2, 0xffdedfa0,
  0x00000000, 0xfffcedfd, 0xfff9dbfa, 0xffcedfe0,
  0x00000000, 0xfffbedff, 0xfff7dbfe, 0xffbee000,
  0x00000000, 0xfffcedff, 0xfff9dbfe, 0xffcee000,
  0x00000000, 0xfffdedfd, 0xfffbdbfa, 0xffdedfe0,
  0x00000000, 0xffff999b, 0xffff3336, 0xfff999c0,
  0x00000000, 0xfffeeef1, 0xfffddde2, 0xffeeef20,
  0x00000000, 0xfffdeef7, 0xfffbddee, 0xffdeef80,
  0x00000000, 0xfffceefb, 0xfff9ddf6, 0xffceefc0,
  0x00000000, 0xfffbeefd, 0xfff7ddfa, 0xffbeefe0,
  0x00000000, 0xfffceefd, 0xfff9ddfa, 0xffceefe0,
  0x00000000, 0xfffdeefb, 0xfffbddf6, 0xffdeefc0,
  0x00000000, 0xfffe99a7, 0xfffd334e, 0xffe99a80,
  0x00000000, 0xffff5557, 0xfffeaaae, 0xfff55580,
  0x00000000, 0xfffe555d, 0xfffcaaba, 0xffe555e0,
  0x00000000, 0xfffd5561, 0xfffaaac2, 0xffd55620,
  0x00000000, 0xfffc5563, 0xfff8aac6, 0xffc55640,
  0x00000000, 0xfffd5563, 0xfffaaac6, 0xffd55640,
  0x00000000, 0xfffe5561, 0xfffcaac2, 0xffe55620,
  0x00000000, 0xffff000d, 0xfffe001a, 0xfff000e0,
  0x00000000, 0xffff6675, 0xfffeccea, 0xfff66760,
  0x00000000, 0xffff0007, 0xfffe000e, 0xfff00080,
  0x00000000, 0xfffe000b, 0xfffc0016, 0xffe000c0,
  0x00000000, 0xfffd000d, 0xfffa001a, 0xffd000e0,
  0x00000000, 0xfffe000d, 0xfffc001a, 0xffe000e0,
  0x00000000, 0xffff000b, 0xfffe0016, 0xfff000c0,
  0x00000000, 0xffffaab7, 0xffff556e, 0xfffaab80,
  0x00000000, 0x0000111f, 0x0000223e, 0x00011200,
  0x00000000, 0x0000121f, 0x0000243e, 0x00012200,
  0x00000000, 0xffff0005, 0xfffe000a, 0xfff00060,
  0x00000000, 0xfffe0007, 0xfffc000e, 0xffe00080,
  0x00000000, 0xffff0007, 0xfffe000e, 0xfff00080,
  0x00000000, 0x00000005, 0x0000000a, 0x00000060,
  0x00000000, 0x0000aab1, 0x00015562, 0x000aab20,
  0x00000000, 0x00011119, 0x00022232, 0x001111a0,
  0x00000000, 0x00011219, 0x00022432, 0x001121a0,
  0x00000000, 0x00011317, 0x0002262e, 0x00113180,
  0x00000000, 0xffff0003, 0xfffe0006, 0xfff00040,
  0x00000000, 0x00000003, 0x00000006, 0x00000040,
  0x00000000, 0x00010001, 0x00020002, 0x00100020,
  0x00000000, 0x0001aaad, 0x0003555a, 0x001aaae0,
  0x00000000, 0x00021115, 0x0004222a, 0x00211160,
  0x00000000, 0x00021215, 0x0004242a, 0x00212160,
  0x00000000, 0x00021313, 0x00042626, 0x00213140,
  0x00000000, 0x0002140f, 0x0004281e, 0x00214100,
  0x00000000, 0x00010001, 0x00020002, 0x00100020,
  0x00000000, 0x0001ffff, 0x0003fffe, 0x00200000,
  0x00000000, 0x0002aaab, 0x00055556, 0x002aaac0,
  0x00000000, 0x00031113, 0x00062226, 0x00311140,
  0x00000000, 0x00031213, 0x00062426, 0x00312140,
  0x00000000, 0x00031311, 0x00062622, 0x00313120,
  0x00000000, 0x0003140d, 0x0006281a, 0x003140e0,
  0x00000000, 0x00031507, 0x00062a0e, 0x00315080,
  0x00000000, 0x0000ffff, 0x0001fffe, 0x00100000,
  0x00000000, 0x0001aaab, 0x00035556, 0x001aaac0,
  0x00000000, 0x00021113, 0x00042226, 0x00211140,
  0x00000000, 0x00021213, 0x00042426, 0x00212140,
  0x00000000, 0x00021311, 0x00042622, 0x00213120,
  0x00000000, 0x0002140d, 0x0004281a, 0x002140e0,
  0x00000000, 0x00021507, 0x00042a0e, 0x00215080,
  0x00000000, 0x00021527, 0x00042a4e, 0x00215280,
  0x00000000, 0x0000aaad, 0x0001555a, 0x000aaae0,
  0x00000000, 0x00011115, 0x0002222a, 0x00111160,
  0x00000000, 0x00011215, 0x0002242a, 0x00112160,
  0x00000000, 0x00011313, 0x00022626, 0x00113140,
  0x00000000, 0x0001140f, 0x0002281e, 0x00114100,
  0x00000000, 0x00011509, 0x00022a12, 0x001150a0,
  0x00000000, 0x00011529, 0x00022a52, 0x001152a0,
  0x00000000, 0x0001152f, 0x00022a5e, 0x00115300,
  0x00000000, 0x00006669, 0x0000ccd2, 0x000666a0,
  0x00000000, 0x00006769, 0x0000ced2, 0x000676a0,
  0x00000000, 0x00006867, 0x0000d0ce, 0x00068680,
  0x00000000, 0x00006963, 0x0000d2c6, 0x00069640,
  0x00000000, 0x00006a5d, 0x0000d4ba, 0x0006a5e0,
  0x00000000, 0x00006a7d, 0x0000d4fa, 0x0006a7e0,
  0x00000000, 0x00006a83, 0x0000d506, 0x0006a840,
  0x00000000, 0x00006a87, 0x0000d50e, 0x0006a880,
  0x00000000, 0x00000101, 0x00000202, 0x00001020,
  0x00000000, 0x000001ff, 0x000003fe, 0x00002000,
  0x00000000, 0x000002fb, 0x000005f6, 0x00002fc0,
  0x00000000, 0x000003f5, 0x000007ea, 0x00003f60,
  0x00000000, 0x00000415, 0x0000082a, 0x00004160,
  0x00000000, 0x0000041b, 0x00000836, 0x000041c0,
  0x00000000, 0x0000041f, 0x0000083e, 0x00004200,
  0x00000000, 0x00000421, 0x00000842, 0x00004220,
  0x000000fe, 0x000001fd, 0x00000fe2, 0x00007c26,
  0x000001fa, 0x000003f5, 0x00001fa2, 0x0000f732,
  0x000002f4, 0x000005e9, 0x00002f42, 0x00017144,
  0x00000314, 0x00000629, 0x00003142, 0x000180e4,
  0x0000031a, 0x00000635, 0x000031a2, 0x000183d2,
  0x0000031e, 0x0000063d, 0x000031e2, 0x000185c6,
  0x00000320, 0x00000641, 0x00003202, 0x000186c0,
  0x00000320, 0x00000641, 0x00003202, 0x000186c0,
  0x000000fc, 0x000001f9, 0x00000fc2, 0x00007b2c,
  0x000001f6, 0x000003ed, 0x00001f62, 0x0000f53e,
  0x00000216, 0x0000042d, 0x00002162, 0x000104de,
  0x0000021c, 0x00000439, 0x000021c2, 0x000107cc,
  0x00000220, 0x00000441, 0x00002202, 0x000109c0,
  0x00000222, 0x00000445, 0x00002222, 0x00010aba,
  0x00000222, 0x00000445, 0x00002222, 0x00010aba,
  0x00000220, 0x00000441, 0x00002202, 0x000109c0,
  0x000000fa, 0x000001f5, 0x00000fa2, 0x00007a32,
  0x0000011a, 0x00000235, 0x000011a2, 0x000089d2,
  0x00000120, 0x00000241, 0x00001202, 0x00008cc0,
  0x00000124, 0x00000249, 0x00001242, 0x00008eb4,
  0x00000126, 0x0000024d, 0x00001262, 0x00008fae,
  0x00000126, 0x0000024d, 0x00001262, 0x00008fae,
  0x00000124, 0x00000249, 0x00001242, 0x00008eb4,
  0x00000120, 0x00000241, 0x00001202, 0x00008cc0,
  0x00000020, 0x00000041, 0x00000202, 0x00000fc0,
  0x00000026, 0x0000004d, 0x00000262, 0x000012ae,
  0x0000002a, 0x00000055, 0x000002a2, 0x000014a2,
  0x0000002c, 0x00000059, 0x000002c2, 0x0000159c,
  0x0000002c, 0x00000059, 0x000002c2, 0x0000159c,
  0x0000002a, 0x00000055, 0x000002a2, 0x000014a2,
  0x00000026, 0x0000004d, 0x00000262, 0x000012ae,
  0x00000006, 0x0000000d, 0x00000062, 0x0000030e,
  0x00000006, 0x0000000d, 0x00000062, 0x0000030e,
  0x0000000a, 0x00000015, 0x000000a2, 0x00000502,
  0x0000000c, 0x00000019, 0x000000c2, 0x000005fc,
  0x0000000c, 0x00000019, 0x000000c2, 0x000005fc,
  0x0000000a, 0x00000015, 0x000000a2, 0x00000502,
  0x00000006, 0x0000000d, 0x00000062, 0x0000030e,
  0xffffffe6, 0xffffffcd, 0xfffffe62, 0xfffff36e,
  0xfffffeec, 0xfffffdd9, 0xffffeec2, 0xffff795c,
  0x00000004, 0x00000009, 0x00000042, 0x00000214,
  0x00000006, 0x0000000d, 0x00000062, 0x0000030e,
  0x00000006, 0x0000000d, 0x00000062, 0x0000030e,
  0x00000004, 0x00000009, 0x00000042, 0x00000214,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffffe0, 0xffffffc1, 0xfffffe02, 0xfffff080,
  0xfffffee6, 0xfffffdcd, 0xffffee62, 0xffff766e,
  0xfffffdea, 0xfffffbd5, 0xffffdea2, 0xfffefb62,
  0x00000002, 0x00000005, 0x00000022, 0x0000011a,
  0x00000002, 0x00000005, 0x00000022, 0x0000011a,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffffffc, 0xfffffff9, 0xffffffc2, 0xfffffe2c,
  0xffffffdc, 0xffffffb9, 0xfffffdc2, 0xffffee8c,
  0xfffffee2, 0xfffffdc5, 0xffffee22, 0xffff747a,
  0xfffffde6, 0xfffffbcd, 0xffffde62, 0xfffef96e,
  0xfffffce8, 0xfffff9d1, 0xffffce82, 0xfffe7d68,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffffffe, 0xfffffffd, 0xffffffe2, 0xffffff26,
  0xfffffffa, 0xfffffff5, 0xffffffa2, 0xfffffd32,
  0xffffffda, 0xffffffb5, 0xfffffda2, 0xffffed92,
  0xfffffee0, 0xfffffdc1, 0xffffee02, 0xffff7380,
  0xfffffde4, 0xfffffbc9, 0xffffde42, 0xfffef874,
  0xfffffce6, 0xfffff9cd, 0xffffce62, 0xfffe7c6e,
  0xffff9680, 0xffff2d01, 0xfff96802, 0xffcc7ca0,
  0xfffffffe, 0xfffffffd, 0xffffffe2, 0xffffff26,
  0xfffffffa, 0xfffffff5, 0xffffffa2, 0xfffffd32,
  0xffffffda, 0xffffffb5, 0xfffffda2, 0xffffed92,
  0xfffffee0, 0xfffffdc1, 0xffffee02, 0xffff7380,
  0xfffffde4, 0xfffffbc9, 0xffffde42, 0xfffef874,
  0xfffffce6, 0xfffff9cd, 0xffffce62, 0xfffe7c6e,
  0xffff9680, 0xffff2d01, 0xfff96802, 0xffcc7ca0,
  0xfffeebd6, 0xfffdd7ad, 0xffeebd62, 0xff79279e,
  0xfffffffc, 0xfffffff9, 0xffffffc2, 0xfffffe2c,
  0xffffffdc, 0xffffffb9, 0xfffffdc2, 0xffffee8c,
  0xfffffee2, 0xfffffdc5, 0xffffee22, 0xffff747a,
  0xfffffde6, 0xfffffbcd, 0xffffde62, 0xfffef96e,
  0xfffffce8, 0xfffff9d1, 0xffffce82, 0xfffe7d68,
  0xffff9682, 0xffff2d05, 0xfff96822, 0xffcc7d9a,
  0xfffeebd8, 0xfffdd7b1, 0xffeebd82, 0xff792898,
  0xfffdebde, 0xfffbd7bd, 0xffdebde2, 0xfefc2b86,
  0xffffffe0, 0xffffffc1, 0xfffffe02, 0xfffff080,
  0xfffffee6, 0xfffffdcd, 0xffffee62, 0xffff766e,
  0xfffffdea, 0xfffffbd5, 0xffffdea2, 0xfffefb62,
  0xfffffcec, 0xfffff9d9, 0xffffcec2, 0xfffe7f5c,
  0xffff9686, 0xffff2d0d, 0xfff96862, 0xffcc7f8e,
  0xfffeebdc, 0xfffdd7b9, 0xffeebdc2, 0xff792a8c,
  0xfffdebe2, 0xfffbd7c5, 0xffdebe22, 0xfefc2d7a,
  0xfffcebe6, 0xfff9d7cd, 0xffcebe62, 0xfe7f2f6e,
  0xffffff06, 0xfffffe0d, 0xfffff062, 0xffff860e,
  0xfffffe0a, 0xfffffc15, 0xffffe0a2, 0xffff0b02,
  0xfffffd0c, 0xfffffa19, 0xffffd0c2, 0xfffe8efc,
  0xffff96a6, 0xffff2d4d, 0xfff96a62, 0xffcc8f2e,
  0xfffeebfc, 0xfffdd7f9, 0xffeebfc2, 0xff793a2c,
  0xfffdec02, 0xfffbd805, 0xffdec022, 0xfefc3d1a,
  0xfffcec06, 0xfff9d80d, 0xffcec062, 0xfe7f3f0e,
  0xfffbec08, 0xfff7d811, 0xffbec082, 0xfe024008,
  0xffffff04, 0xfffffe09, 0xfffff042, 0xffff8514,
  0xfffffe06, 0xfffffc0d, 0xffffe062, 0xffff090e,
  0xffff97a0, 0xffff2f41, 0xfff97a02, 0xffcd0940,
  0xfffeecf6, 0xfffdd9ed, 0xffeecf62, 0xff79b43e,
  0xfffdecfc, 0xfffbd9f9, 0xffdecfc2, 0xfefcb72c,
  0xfffced00, 0xfff9da01, 0xffced002, 0xfe7fb920,
  0xfffbed02, 0xfff7da05, 0xffbed022, 0xfe02ba1a,
  0xfffced02, 0xfff9da05, 0xffced022, 0xfe7fba1a,
  0xffffff02, 0xfffffe05, 0xfffff022, 0xffff841a,
  0xffff989c, 0xffff3139, 0xfff989c2, 0xffcd844c,
  0xfffeedf2, 0xfffddbe5, 0xffeedf22, 0xff7a2f4a,
  0xfffdedf8, 0xfffbdbf1, 0xffdedf82, 0xfefd3238,
  0xfffcedfc, 0xfff9dbf9, 0xffcedfc2, 0xfe80342c,
  0xfffbedfe, 0xfff7dbfd, 0xffbedfe2, 0xfe033526,
  0xfffcedfe, 0xfff9dbfd, 0xffcedfe2, 0xfe803526,
  0xfffdedfc, 0xfffbdbf9, 0xffdedfc2, 0xfefd342c,
  0xffff999a, 0xffff3335, 0xfff999a2, 0xffce0052,
  0xfffeeef0, 0xfffddde1, 0xffeeef02, 0xff7aab50,
  0xfffdeef6, 0xfffbdded, 0xffdeef62, 0xfefdae3e,
  0xfffceefa, 0xfff9ddf5, 0xffceefa2, 0xfe80b032,
  0xfffbeefc, 0xfff7ddf9, 0xffbeefc2, 0xfe03b12c,
  0xfffceefc, 0xfff9ddf9, 0xffceefc2, 0xfe80b12c,
  0xfffdeefa, 0xfffbddf5, 0xffdeefa2, 0xfefdb032,
  0xfffe99a6, 0xfffd334d, 0xffe99a62, 0xff51062e,
  0xffff5556, 0xfffeaaad, 0xfff55562, 0xffacab1e,
  0xfffe555c, 0xfffcaab9, 0xffe555c2, 0xff2fae0c,
  0xfffd5560, 0xfffaaac1, 0xffd55602, 0xfeb2b000,
  0xfffc5562, 0xfff8aac5, 0xffc55622, 0xfe35b0fa,
  0xfffd5562, 0xfffaaac5, 0xffd55622, 0xfeb2b0fa,
  0xfffe5560, 0xfffcaac1, 0xffe55602, 0xff2fb000,
  0xffff000c, 0xfffe0019, 0xfff000c2, 0xff8305fc,
  0xffff6674, 0xfffecce9, 0xfff66742, 0xffb506c4,
  0xffff0006, 0xfffe000d, 0xfff00062, 0xff83030e,
  0xfffe000a, 0xfffc0015, 0xffe000a2, 0xff060502,
  0xfffd000c, 0xfffa0019, 0xffd000c2, 0xfe8905fc,
  0xfffe000c, 0xfffc0019, 0xffe000c2, 0xff0605fc,
  0xffff000a, 0xfffe0015, 0xfff000a2, 0xff830502,
  0xffffaab6, 0xffff556d, 0xfffaab62, 0xffd65afe,
  0x0000111e, 0x0000223d, 0x000111e2, 0x00085bc6,
  0x0000121e, 0x0000243d, 0x000121e2, 0x0008d8c6,
  0xffff0004, 0xfffe0009, 0xfff00042, 0xff830214,
  0xfffe0006, 0xfffc000d, 0xffe00062, 0xff06030e,
  0xffff0006, 0xfffe000d, 0xfff00062, 0xff83030e,
  0x00000004, 0x00000009, 0x00000042, 0x00000214,
  0x0000aab0, 0x00015561, 0x000aab02, 0x00535810,
  0x00011118, 0x00022231, 0x00111182, 0x008558d8,
  0x00011218, 0x00022431, 0x00112182, 0x0085d5d8,
  0x00011316, 0x0002262d, 0x00113162, 0x008651de,
  0xffff0002, 0xfffe0005, 0xfff00022, 0xff83011a,
  0x00000002, 0x00000005, 0x00000022, 0x0000011a,
  0x00010000, 0x00020001, 0x00100002, 0x007d0020,
  0x0001aaac, 0x00035559, 0x001aaac2, 0x00d0561c,
  0x00021114, 0x00042229, 0x00211142, 0x010256e4,
  0x00021214, 0x00042429, 0x00212142, 0x0102d3e4,
  0x00021312, 0x00042625, 0x00213122, 0x01034fea,
  0x0002140e, 0x0004281d, 0x002140e2, 0x0103caf6,
  0x00010000, 0x00020001, 0x00100002, 0x007d0020,
  0x0001fffe, 0x0003fffd, 0x001fffe2, 0x00f9ff26,
  0x0002aaaa, 0x00055555, 0x002aaaa2, 0x014d5522,
  0x00031112, 0x00062225, 0x00311122, 0x017f55ea,
  0x00031212, 0x00062425, 0x00312122, 0x017fd2ea,
  0x00031310, 0x00062621, 0x00313102, 0x01804ef0,
  0x0003140c, 0x00062819, 0x003140c2, 0x0180c9fc,
  0x00031506, 0x00062a0d, 0x00315062, 0x0181440e,
  0x0000fffe, 0x0001fffd, 0x000fffe2, 0x007cff26,
  0x0001aaaa, 0x00035555, 0x001aaaa2, 0x00d05522,
  0x00021112, 0x00042225, 0x00211122, 0x010255ea,
  0x00021212, 0x00042425, 0x00212122, 0x0102d2ea,
  0x00021310, 0x00042621, 0x00213102, 0x01034ef0,
  0x0002140c, 0x00042819, 0x002140c2, 0x0103c9fc,
  0x00021506, 0x00042a0d, 0x00215062, 0x0104440e,
  0x00021526, 0x00042a4d, 0x00215262, 0x010453ae,
  0x0000aaac, 0x00015559, 0x000aaac2, 0x0053561c,
  0x00011114, 0x00022229, 0x00111142, 0x008556e4,
  0x00011214, 0x00022429, 0x00112142, 0x0085d3e4,
  0x00011312, 0x00022625, 0x00113122, 0x00864fea,
  0x0001140e, 0x0002281d, 0x001140e2, 0x0086caf6,
  0x00011508, 0x00022a11, 0x00115082, 0x00874508,
  0x00011528, 0x00022a51, 0x00115282, 0x008754a8,
  0x0001152e, 0x00022a5d, 0x001152e2, 0x00875796,
  0x00006668, 0x0000ccd1, 0x00066682, 0x003200e8,
  0x00006768, 0x0000ced1, 0x00067682, 0x00327de8,
  0x00006866, 0x0000d0cd, 0x00068662, 0x0032f9ee,
  0x00006962, 0x0000d2c5, 0x00069622, 0x003374fa,
  0x00006a5c, 0x0000d4b9, 0x0006a5c2, 0x0033ef0c,
  0x00006a7c, 0x0000d4f9, 0x0006a7c2, 0x0033feac,
  0x00006a82, 0x0000d505, 0x0006a822, 0x0034019a,
  0x00006a86, 0x0000d50d, 0x0006a862, 0x0034038e,
  0x00000100, 0x00000201, 0x00001002, 0x00007d20,
  0x000001fe, 0x000003fd, 0x00001fe2, 0x0000f926,
  0x000002fa, 0x000005f5, 0x00002fa2, 0x00017432,
  0x000003f4, 0x000007e9, 0x00003f42, 0x0001ee44,
  0x00000414, 0x00000829, 0x00004142, 0x0001fde4,
  0x0000041a, 0x00000835, 0x000041a2, 0x000200d2,
  0x0000041e, 0x0000083d, 0x000041e2, 0x000202c6,
  0x00000420, 0x00000841, 0x00004202, 0x000203c0,
  0x000001fc, 0x00000fe1, 0x00007c08, 0x00007d24,
  0x000003f4, 0x00001fa1, 0x0000f714, 0x0000f92c,
  0x000005e8, 0x00002f41, 0x00017126, 0x00017438,
  0x00000628, 0x00003141, 0x000180c6, 0x000183f8,
  0x00000634, 0x000031a1, 0x000183b4, 0x000186ec,
  0x0000063c, 0x000031e1, 0x000185a8, 0x000188e4,
  0x00000640, 0x00003201, 0x000186a2, 0x000189e0,
  0x00000640, 0x00003201, 0x000186a2, 0x000189e0,
  0x000001f8, 0x00000fc1, 0x00007b0e, 0x00007c28,
  0x000003ec, 0x00001f61, 0x0000f520, 0x0000f734,
  0x0000042c, 0x00002161, 0x000104c0, 0x000106f4,
  0x00000438, 0x000021c1, 0x000107ae, 0x000109e8,
  0x00000440, 0x00002201, 0x000109a2, 0x00010be0,
  0x00000444, 0x00002221, 0x00010a9c, 0x00010cdc,
  0x00000444, 0x00002221, 0x00010a9c, 0x00010cdc,
  0x00000440, 0x00002201, 0x000109a2, 0x00010be0,
  0x000001f4, 0x00000fa1, 0x00007a14, 0x00007b2c,
  0x00000234, 0x000011a1, 0x000089b4, 0x00008aec,
  0x00000240, 0x00001201, 0x00008ca2, 0x00008de0,
  0x00000248, 0x00001241, 0x00008e96, 0x00008fd8,
  0x0000024c, 0x00001261, 0x00008f90, 0x000090d4,
  0x0000024c, 0x00001261, 0x00008f90, 0x000090d4,
  0x00000248, 0x00001241, 0x00008e96, 0x00008fd8,
  0x00000240, 0x00001201, 0x00008ca2, 0x00008de0,
  0x00000040, 0x00000201, 0x00000fa2, 0x00000fe0,
  0x0000004c, 0x00000261, 0x00001290, 0x000012d4,
  0x00000054, 0x000002a1, 0x00001484, 0x000014cc,
  0x00000058, 0x000002c1, 0x0000157e, 0x000015c8,
  0x00000058, 0x000002c1, 0x0000157e, 0x000015c8,
  0x00000054, 0x000002a1, 0x00001484, 0x000014cc,
  0x0000004c, 0x00000261, 0x00001290, 0x000012d4,
  0x0000000c, 0x00000061, 0x000002f0, 0x00000314,
  0x0000000c, 0x00000061, 0x000002f0, 0x00000314,
  0x00000014, 0x000000a1, 0x000004e4, 0x0000050c,
  0x00000018, 0x000000c1, 0x000005de, 0x00000608,
  0x00000018, 0x000000c1, 0x000005de, 0x00000608,
  0x00000014, 0x000000a1, 0x000004e4, 0x0000050c,
  0x0000000c, 0x00000061, 0x000002f0, 0x00000314,
  0xffffffcc, 0xfffffe61, 0xfffff350, 0xfffff354,
  0xfffffdd8, 0xffffeec1, 0xffff793e, 0xffff7848,
  0x00000008, 0x00000041, 0x000001f6, 0x00000218,
  0x0000000c, 0x00000061, 0x000002f0, 0x00000314,
  0x0000000c, 0x00000061, 0x000002f0, 0x00000314,
  0x00000008, 0x00000041, 0x000001f6, 0x00000218,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffffc0, 0xfffffe01, 0xfffff062, 0xfffff060,
  0xfffffdcc, 0xffffee61, 0xffff7650, 0xffff7554,
  0xfffffbd4, 0xffffdea1, 0xfffefb44, 0xfffef94c,
  0x00000004, 0x00000021, 0x000000fc, 0x0000011c,
  0x00000004, 0x00000021, 0x000000fc, 0x0000011c,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffffff8, 0xffffffc1, 0xfffffe0e, 0xfffffe28,
  0xffffffb8, 0xfffffdc1, 0xffffee6e, 0xffffee68,
  0xfffffdc4, 0xffffee21, 0xffff745c, 0xffff735c,
  0xfffffbcc, 0xffffde61, 0xfffef950, 0xfffef754,
  0xfffff9d0, 0xffffce81, 0xfffe7d4a, 0xfffe7a50,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffffffc, 0xffffffe1, 0xffffff08, 0xffffff24,
  0xfffffff4, 0xffffffa1, 0xfffffd14, 0xfffffd2c,
  0xffffffb4, 0xfffffda1, 0xffffed74, 0xffffed6c,
  0xfffffdc0, 0xffffee01, 0xffff7362, 0xffff7260,
  0xfffffbc8, 0xffffde41, 0xfffef856, 0xfffef658,
  0xfffff9cc, 0xffffce61, 0xfffe7c50, 0xfffe7954,
  0xffff2d00, 0xfff96801, 0xffcc7c82, 0xffcc1320,
  0xfffffffc, 0xffffffe1, 0xffffff08, 0xffffff24,
  0xfffffff4, 0xffffffa1, 0xfffffd14, 0xfffffd2c,
  0xffffffb4, 0xfffffda1, 0xffffed74, 0xffffed6c,
  0xfffffdc0, 0xffffee01, 0xffff7362, 0xffff7260,
  0xfffffbc8, 0xffffde41, 0xfffef856, 0xfffef658,
  0xfffff9cc, 0xffffce61, 0xfffe7c50, 0xfffe7954,
  0xffff2d00, 0xfff96801, 0xffcc7c82, 0xffcc1320,
  0xfffdd7ac, 0xffeebd61, 0xff792780, 0xff781374,
  0xfffffff8, 0xffffffc1, 0xfffffe0e, 0xfffffe28,
  0xffffffb8, 0xfffffdc1, 0xffffee6e, 0xffffee68,
  0xfffffdc4, 0xffffee21, 0xffff745c, 0xffff735c,
  0xfffffbcc, 0xffffde61, 0xfffef950, 0xfffef754,
  0xfffff9d0, 0xffffce81, 0xfffe7d4a, 0xfffe7a50,
  0xffff2d04, 0xfff96821, 0xffcc7d7c, 0xffcc141c,
  0xfffdd7b0, 0xffeebd81, 0xff79287a, 0xff781470,
  0xfffbd7bc, 0xffdebde1, 0xfefc2b68, 0xfefa1764,
  0xffffffc0, 0xfffffe01, 0xfffff062, 0xfffff060,
  0xfffffdcc, 0xffffee61, 0xffff7650, 0xffff7554,
  0xfffffbd4, 0xffffdea1, 0xfffefb44, 0xfffef94c,
  0xfffff9d8, 0xffffcec1, 0xfffe7f3e, 0xfffe7c48,
  0xffff2d0c, 0xfff96861, 0xffcc7f70, 0xffcc1614,
  0xfffdd7b8, 0xffeebdc1, 0xff792a6e, 0xff781668,
  0xfffbd7c4, 0xffdebe21, 0xfefc2d5c, 0xfefa195c,
  0xfff9d7cc, 0xffcebe61, 0xfe7f2f50, 0xfe7c1b54,
  0xfffffe0c, 0xfffff061, 0xffff85f0, 0xffff8514,
  0xfffffc14, 0xffffe0a1, 0xffff0ae4, 0xffff090c,
  0xfffffa18, 0xffffd0c1, 0xfffe8ede, 0xfffe8c08,
  0xffff2d4c, 0xfff96a61, 0xffcc8f10, 0xffcc25d4,
  0xfffdd7f8, 0xffeebfc1, 0xff793a0e, 0xff782628,
  0xfffbd804, 0xffdec021, 0xfefc3cfc, 0xfefa291c,
  0xfff9d80c, 0xffcec061, 0xfe7f3ef0, 0xfe7c2b14,
  0xfff7d810, 0xffbec081, 0xfe023fea, 0xfdfe2c10,
  0xfffffe08, 0xfffff041, 0xffff84f6, 0xffff8418,
  0xfffffc0c, 0xffffe061, 0xffff08f0, 0xffff0714,
  0xffff2f40, 0xfff97a01, 0xffcd0922, 0xffcca0e0,
  0xfffdd9ec, 0xffeecf61, 0xff79b420, 0xff78a134,
  0xfffbd9f8, 0xffdecfc1, 0xfefcb70e, 0xfefaa428,
  0xfff9da00, 0xffced001, 0xfe7fb902, 0xfe7ca620,
  0xfff7da04, 0xffbed021, 0xfe02b9fc, 0xfdfea71c,
  0xfff9da04, 0xffced021, 0xfe7fb9fc, 0xfe7ca71c,
  0xfffffe04, 0xfffff021, 0xffff83fc, 0xffff831c,
  0xffff3138, 0xfff989c1, 0xffcd842e, 0xffcd1ce8,
  0xfffddbe4, 0xffeedf21, 0xff7a2f2c, 0xff791d3c,
  0xfffbdbf0, 0xffdedf81, 0xfefd321a, 0xfefb2030,
  0xfff9dbf8, 0xffcedfc1, 0xfe80340e, 0xfe7d2228,
  0xfff7dbfc, 0xffbedfe1, 0xfe033508, 0xfdff2324,
  0xfff9dbfc, 0xffcedfe1, 0xfe803508, 0xfe7d2324,
  0xfffbdbf8, 0xffdedfc1, 0xfefd340e, 0xfefb2228,
  0xffff3334, 0xfff999a1, 0xffce0034, 0xffcd99ec,
  0xfffddde0, 0xffeeef01, 0xff7aab32, 0xff799a40,
  0xfffbddec, 0xffdeef61, 0xfefdae20, 0xfefb9d34,
  0xfff9ddf4, 0xffceefa1, 0xfe80b014, 0xfe7d9f2c,
  0xfff7ddf8, 0xffbeefc1, 0xfe03b10e, 0xfdffa028,
  0xfff9ddf8, 0xffceefc1, 0xfe80b10e, 0xfe7da028,
  0xfffbddf4, 0xffdeefa1, 0xfefdb014, 0xfefb9f2c,
  0xfffd334c, 0xffe99a61, 0xff510610, 0xff4f9fd4,
  0xfffeaaac, 0xfff55561, 0xffacab00, 0xffac0074,
  0xfffcaab8, 0xffe555c1, 0xff2fadee, 0xff2e0368,
  0xfffaaac0, 0xffd55601, 0xfeb2afe2, 0xfeb00560,
  0xfff8aac4, 0xffc55621, 0xfe35b0dc, 0xfe32065c,
  0xfffaaac4, 0xffd55621, 0xfeb2b0dc, 0xfeb0065c,
  0xfffcaac0, 0xffe55601, 0xff2fafe2, 0xff2e0560,
  0xfffe0018, 0xfff000c1, 0xff8305de, 0xff820608,
  0xfffecce8, 0xfff66741, 0xffb506a6, 0xffb46d38,
  0xfffe000c, 0xfff00061, 0xff8302f0, 0xff820314,
  0xfffc0014, 0xffe000a1, 0xff0604e4, 0xff04050c,
  0xfffa0018, 0xffd000c1, 0xfe8905de, 0xfe860608,
  0xfffc0018, 0xffe000c1, 0xff0605de, 0xff040608,
  0xfffe0014, 0xfff000a1, 0xff8304e4, 0xff82050c,
  0xffff556c, 0xfffaab61, 0xffd65ae0, 0xffd605b4,
  0x0000223c, 0x000111e1, 0x00085ba8, 0x00086ce4,
  0x0000243c, 0x000121e1, 0x0008d8a8, 0x0008eae4,
  0xfffe0008, 0xfff00041, 0xff8301f6, 0xff820218,
  0xfffc000c, 0xffe00061, 0xff0602f0, 0xff040314,
  0xfffe000c, 0xfff00061, 0xff8302f0, 0xff820314,
  0x00000008, 0x00000041, 0x000001f6, 0x00000218,
  0x00015560, 0x000aab01, 0x005357f2, 0x005402c0,
  0x00022230, 0x00111181, 0x008558ba, 0x008669f0,
  0x00022430, 0x00112181, 0x0085d5ba, 0x0086e7f0,
  0x0002262c, 0x00113161, 0x008651c0, 0x008764f4,
  0xfffe0004, 0xfff00021, 0xff8300fc, 0xff82011c,
  0x00000004, 0x00000021, 0x000000fc, 0x0000011c,
  0x00020000, 0x00100001, 0x007d0002, 0x007e0020,
  0x00035558, 0x001aaac1, 0x00d055fe, 0x00d200c8,
  0x00042228, 0x00211141, 0x010256c6, 0x010467f8,
  0x00042428, 0x00212141, 0x0102d3c6, 0x0104e5f8,
  0x00042624, 0x00213121, 0x01034fcc, 0x010562fc,
  0x0004281c, 0x002140e1, 0x0103cad8, 0x0105df04,
  0x00020000, 0x00100001, 0x007d0002, 0x007e0020,
  0x0003fffc, 0x001fffe1, 0x00f9ff08, 0x00fbff24,
  0x00055554, 0x002aaaa1, 0x014d5504, 0x014fffcc,
  0x00062224, 0x00311121, 0x017f55cc, 0x018266fc,
  0x00062424, 0x00312121, 0x017fd2cc, 0x0182e4fc,
  0x00062620, 0x00313101, 0x01804ed2, 0x01836200,
  0x00062818, 0x003140c1, 0x0180c9de, 0x0183de08,
  0x00062a0c, 0x00315061, 0x018143f0, 0x01845914,
  0x0001fffc, 0x000fffe1, 0x007cff08, 0x007dff24,
  0x00035554, 0x001aaaa1, 0x00d05504, 0x00d1ffcc,
  0x00042224, 0x00211121, 0x010255cc, 0x010466fc,
  0x00042424, 0x00212121, 0x0102d2cc, 0x0104e4fc,
  0x00042620, 0x00213101, 0x01034ed2, 0x01056200,
  0x00042818, 0x002140c1, 0x0103c9de, 0x0105de08,
  0x00042a0c, 0x00215061, 0x010443f0, 0x01065914,
  0x00042a4c, 0x00215261, 0x01045390, 0x010668d4,
  0x00015558, 0x000aaac1, 0x005355fe, 0x005400c8,
  0x00022228, 0x00111141, 0x008556c6, 0x008667f8,
  0x00022428, 0x00112141, 0x0085d3c6, 0x0086e5f8,
  0x00022624, 0x00113121, 0x00864fcc, 0x008762fc,
  0x0002281c, 0x001140e1, 0x0086cad8, 0x0087df04,
  0x00022a10, 0x00115081, 0x008744ea, 0x00885a10,
  0x00022a50, 0x00115281, 0x0087548a, 0x008869d0,
  0x00022a5c, 0x001152e1, 0x00875778, 0x00886cc4,
  0x0000ccd0, 0x00066681, 0x003200ca, 0x00326750,
  0x0000ced0, 0x00067681, 0x00327dca, 0x0032e550,
  0x0000d0cc, 0x00068661, 0x0032f9d0, 0x00336254,
  0x0000d2c4, 0x00069621, 0x003374dc, 0x0033de5c,
  0x0000d4b8, 0x0006a5c1, 0x0033eeee, 0x00345968,
  0x0000d4f8, 0x0006a7c1, 0x0033fe8e, 0x00346928,
  0x0000d504, 0x0006a821, 0x0034017c, 0x00346c1c,
  0x0000d50c, 0x0006a861, 0x00340370, 0x00346e14,
  0x00000200, 0x00001001, 0x00007d02, 0x00007e20,
  0x000003fc, 0x00001fe1, 0x0000f908, 0x0000fb24,
  0x000005f4, 0x00002fa1, 0x00017414, 0x0001772c,
  0x000007e8, 0x00003f41, 0x0001ee26, 0x0001f238,
  0x00000828, 0x00004141, 0x0001fdc6, 0x000201f8,
  0x00000834, 0x000041a1, 0x000200b4, 0x000204ec,
  0x0000083c, 0x000041e1, 0x000202a8, 0x000206e4,
  0x00000840, 0x00004201, 0x000203a2, 0x000207e0,
  0x00000fe0, 0x00007c07, 0x00007d06, 0x00007e22,
  0x00001fa0, 0x0000f713, 0x0000f90e, 0x0000fb26,
  0x00002f40, 0x00017125, 0x0001741a, 0x0001772c,
  0x00003140, 0x000180c5, 0x000183da, 0x0001870c,
  0x000031a0, 0x000183b3, 0x000186ce, 0x00018a06,
  0x000031e0, 0x000185a7, 0x000188c6, 0x00018c02,
  0x00003200, 0x000186a1, 0x000189c2, 0x00018d00,
  0x00003200, 0x000186a1, 0x000189c2, 0x00018d00,
  0x00000fc0, 0x00007b0d, 0x00007c0a, 0x00007d24,
  0x00001f60, 0x0000f51f, 0x0000f716, 0x0000f92a,
  0x00002160, 0x000104bf, 0x000106d6, 0x0001090a,
  0x000021c0, 0x000107ad, 0x000109ca, 0x00010c04,
  0x00002200, 0x000109a1, 0x00010bc2, 0x00010e00,
  0x00002220, 0x00010a9b, 0x00010cbe, 0x00010efe,
  0x00002220, 0x00010a9b, 0x00010cbe, 0x00010efe,
  0x00002200, 0x000109a1, 0x00010bc2, 0x00010e00,
  0x00000fa0, 0x00007a13, 0x00007b0e, 0x00007c26,
  0x000011a0, 0x000089b3, 0x00008ace, 0x00008c06,
  0x00001200, 0x00008ca1, 0x00008dc2, 0x00008f00,
  0x00001240, 0x00008e95, 0x00008fba, 0x000090fc,
  0x00001260, 0x00008f8f, 0x000090b6, 0x000091fa,
  0x00001260, 0x00008f8f, 0x000090b6, 0x000091fa,
  0x00001240, 0x00008e95, 0x00008fba, 0x000090fc,
  0x00001200, 0x00008ca1, 0x00008dc2, 0x00008f00,
  0x00000200, 0x00000fa1, 0x00000fc2, 0x00001000,
  0x00000260, 0x0000128f, 0x000012b6, 0x000012fa,
  0x000002a0, 0x00001483, 0x000014ae, 0x000014f6,
  0x000002c0, 0x0000157d, 0x000015aa, 0x000015f4,
  0x000002c0, 0x0000157d, 0x000015aa, 0x000015f4,
  0x000002a0, 0x00001483, 0x000014ae, 0x000014f6,
  0x00000260, 0x0000128f, 0x000012b6, 0x000012fa,
  0x00000060, 0x000002ef, 0x000002f6, 0x0000031a,
  0x00000060, 0x000002ef, 0x000002f6, 0x0000031a,
  0x000000a0, 0x000004e3, 0x000004ee, 0x00000516,
  0x000000c0, 0x000005dd, 0x000005ea, 0x00000614,
  0x000000c0, 0x000005dd, 0x000005ea, 0x00000614,
  0x000000a0, 0x000004e3, 0x000004ee, 0x00000516,
  0x00000060, 0x000002ef, 0x000002f6, 0x0000031a,
  0xfffffe60, 0xfffff34f, 0xfffff336, 0xfffff33a,
  0xffffeec0, 0xffff793d, 0xffff782a, 0xffff7734,
  0x00000040, 0x000001f5, 0x000001fa, 0x0000021c,
  0x00000060, 0x000002ef, 0x000002f6, 0x0000031a,
  0x00000060, 0x000002ef, 0x000002f6, 0x0000031a,
  0x00000040, 0x000001f5, 0x000001fa, 0x0000021c,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffffe00, 0xfffff061, 0xfffff042, 0xfffff040,
  0xffffee60, 0xffff764f, 0xffff7536, 0xffff743a,
  0xffffdea0, 0xfffefb43, 0xfffef92e, 0xfffef736,
  0x00000020, 0x000000fb, 0x000000fe, 0x0000011e,
  0x00000020, 0x000000fb, 0x000000fe, 0x0000011e,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffffc0, 0xfffffe0d, 0xfffffe0a, 0xfffffe24,
  0xfffffdc0, 0xffffee6d, 0xffffee4a, 0xffffee44,
  0xffffee20, 0xffff745b, 0xffff733e, 0xffff723e,
  0xffffde60, 0xfffef94f, 0xfffef736, 0xfffef53a,
  0xffffce80, 0xfffe7d49, 0xfffe7a32, 0xfffe7738,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffffe0, 0xffffff07, 0xffffff06, 0xffffff22,
  0xffffffa0, 0xfffffd13, 0xfffffd0e, 0xfffffd26,
  0xfffffda0, 0xffffed73, 0xffffed4e, 0xffffed46,
  0xffffee00, 0xffff7361, 0xffff7242, 0xffff7140,
  0xffffde40, 0xfffef855, 0xfffef63a, 0xfffef43c,
  0xffffce60, 0xfffe7c4f, 0xfffe7936, 0xfffe763a,
  0xfff96800, 0xffcc7c81, 0xffcc1302, 0xffcba9a0,
  0xffffffe0, 0xffffff07, 0xffffff06, 0xffffff22,
  0xffffffa0, 0xfffffd13, 0xfffffd0e, 0xfffffd26,
  0xfffffda0, 0xffffed73, 0xffffed4e, 0xffffed46,
  0xffffee00, 0xffff7361, 0xffff7242, 0xffff7140,
  0xffffde40, 0xfffef855, 0xfffef63a, 0xfffef43c,
  0xffffce60, 0xfffe7c4f, 0xfffe7936, 0xfffe763a,
  0xfff96800, 0xffcc7c81, 0xffcc1302, 0xffcba9a0,
  0xffeebd60, 0xff79277f, 0xff781356, 0xff76ff4a,
  0xffffffc0, 0xfffffe0d, 0xfffffe0a, 0xfffffe24,
  0xfffffdc0, 0xffffee6d, 0xffffee4a, 0xffffee44,
  0xffffee20, 0xffff745b, 0xffff733e, 0xffff723e,
  0xffffde60, 0xfffef94f, 0xfffef736, 0xfffef53a,
  0xffffce80, 0xfffe7d49, 0xfffe7a32, 0xfffe7738,
  0xfff96820, 0xffcc7d7b, 0xffcc13fe, 0xffcbaa9e,
  0xffeebd80, 0xff792879, 0xff781452, 0xff770048,
  0xffdebde0, 0xfefc2b67, 0xfefa1746, 0xfef80342,
  0xfffffe00, 0xfffff061, 0xfffff042, 0xfffff040,
  0xffffee60, 0xffff764f, 0xffff7536, 0xffff743a,
  0xffffdea0, 0xfffefb43, 0xfffef92e, 0xfffef736,
  0xffffcec0, 0xfffe7f3d, 0xfffe7c2a, 0xfffe7934,
  0xfff96860, 0xffcc7f6f, 0xffcc15f6, 0xffcbac9a,
  0xffeebdc0, 0xff792a6d, 0xff78164a, 0xff770244,
  0xffdebe20, 0xfefc2d5b, 0xfefa193e, 0xfef8053e,
  0xffcebe60, 0xfe7f2f4f, 0xfe7c1b36, 0xfe79073a,
  0xfffff060, 0xffff85ef, 0xffff84f6, 0xffff841a,
  0xffffe0a0, 0xffff0ae3, 0xffff08ee, 0xffff0716,
  0xffffd0c0, 0xfffe8edd, 0xfffe8bea, 0xfffe8914,
  0xfff96a60, 0xffcc8f0f, 0xffcc25b6, 0xffcbbc7a,
  0xffeebfc0, 0xff793a0d, 0xff78260a, 0xff771224,
  0xffdec020, 0xfefc3cfb, 0xfefa28fe, 0xfef8151e,
  0xffcec060, 0xfe7f3eef, 0xfe7c2af6, 0xfe79171a,
  0xffbec080, 0xfe023fe9, 0xfdfe2bf2, 0xfdfa1818,
  0xfffff040, 0xffff84f5, 0xffff83fa, 0xffff831c,
  0xffffe060, 0xffff08ef, 0xffff06f6, 0xffff051a,
  0xfff97a00, 0xffcd0921, 0xffcca0c2, 0xffcc3880,
  0xffeecf60, 0xff79b41f, 0xff78a116, 0xff778e2a,
  0xffdecfc0, 0xfefcb70d, 0xfefaa40a, 0xfef89124,
  0xffced000, 0xfe7fb901, 0xfe7ca602, 0xfe799320,
  0xffbed020, 0xfe02b9fb, 0xfdfea6fe, 0xfdfa941e,
  0xffced020, 0xfe7fb9fb, 0xfe7ca6fe, 0xfe79941e,
  0xfffff020, 0xffff83fb, 0xffff82fe, 0xffff821e,
  0xfff989c0, 0xffcd842d, 0xffcd1cca, 0xffccb584,
  0xffeedf20, 0xff7a2f2b, 0xff791d1e, 0xff780b2e,
  0xffdedf80, 0xfefd3219, 0xfefb2012, 0xfef90e28,
  0xffcedfc0, 0xfe80340d, 0xfe7d220a, 0xfe7a1024,
  0xffbedfe0, 0xfe033507, 0xfdff2306, 0xfdfb1122,
  0xffcedfe0, 0xfe803507, 0xfe7d2306, 0xfe7a1122,
  0xffdedfc0, 0xfefd340d, 0xfefb220a, 0xfef91024,
  0xfff999a0, 0xffce0033, 0xffcd99ce, 0xffcd3386,
  0xffeeef00, 0xff7aab31, 0xff799a22, 0xff788930,
  0xffdeef60, 0xfefdae1f, 0xfefb9d16, 0xfef98c2a,
  0xffceefa0, 0xfe80b013, 0xfe7d9f0e, 0xfe7a8e26,
  0xffbeefc0, 0xfe03b10d, 0xfdffa00a, 0xfdfb8f24,
  0xffceefc0, 0xfe80b10d, 0xfe7da00a, 0xfe7a8f24,
  0xffdeefa0, 0xfefdb013, 0xfefb9f0e, 0xfef98e26,
  0xffe99a60, 0xff51060f, 0xff4f9fb6, 0xff4e397a,
  0xfff55560, 0xffacaaff, 0xffac0056, 0xffab55ca,
  0xffe555c0, 0xff2faded, 0xff2e034a, 0xff2c58c4,
  0xffd55600, 0xfeb2afe1, 0xfeb00542, 0xfead5ac0,
  0xffc55620, 0xfe35b0db, 0xfe32063e, 0xfe2e5bbe,
  0xffd55620, 0xfeb2b0db, 0xfeb0063e, 0xfead5bbe,
  0xffe55600, 0xff2fafe1, 0xff2e0542, 0xff2c5ac0,
  0xfff000c0, 0xff8305dd, 0xff8205ea, 0xff810614,
  0xfff66740, 0xffb506a5, 0xffb46d1a, 0xffb3d3ac,
  0xfff00060, 0xff8302ef, 0xff8202f6, 0xff81031a,
  0xffe000a0, 0xff0604e3, 0xff0404ee, 0xff020516,
  0xffd000c0, 0xfe8905dd, 0xfe8605ea, 0xfe830614,
  0xffe000c0, 0xff0605dd, 0xff0405ea, 0xff020614,
  0xfff000a0, 0xff8304e3, 0xff8204ee, 0xff810516,
  0xfffaab60, 0xffd65adf, 0xffd60596, 0xffd5b06a,
  0x000111e0, 0x00085ba7, 0x00086cc6, 0x00087e02,
  0x000121e0, 0x0008d8a7, 0x0008eac6, 0x0008fd02,
  0xfff00040, 0xff8301f5, 0xff8201fa, 0xff81021c,
  0xffe00060, 0xff0602ef, 0xff0402f6, 0xff02031a,
  0xfff00060, 0xff8302ef, 0xff8202f6, 0xff81031a,
  0x00000040, 0x000001f5, 0x000001fa, 0x0000021c,
  0x000aab00, 0x005357f1, 0x005402a2, 0x0054ad70,
  0x00111180, 0x008558b9, 0x008669d2, 0x00877b08,
  0x00112180, 0x0085d5b9, 0x0086e7d2, 0x0087fa08,
  0x00113160, 0x008651bf, 0x008764d6, 0x0088780a,
  0xfff00020, 0xff8300fb, 0xff8200fe, 0xff81011e,
  0x00000020, 0x000000fb, 0x000000fe, 0x0000011e,
  0x00100000, 0x007d0001, 0x007e0002, 0x007f0020,
  0x001aaac0, 0x00d055fd, 0x00d200aa, 0x00d3ab74,
  0x00211140, 0x010256c5, 0x010467da, 0x0106790c,
  0x00212140, 0x0102d3c5, 0x0104e5da, 0x0106f80c,
  0x00213120, 0x01034fcb, 0x010562de, 0x0107760e,
  0x002140e0, 0x0103cad7, 0x0105dee6, 0x0107f312,
  0x00100000, 0x007d0001, 0x007e0002, 0x007f0020,
  0x001fffe0, 0x00f9ff07, 0x00fbff06, 0x00fdff22,
  0x002aaaa0, 0x014d5503, 0x014fffae, 0x0152aa76,
  0x00311120, 0x017f55cb, 0x018266de, 0x0185780e,
  0x00312120, 0x017fd2cb, 0x0182e4de, 0x0185f70e,
  0x00313100, 0x01804ed1, 0x018361e2, 0x01867510,
  0x003140c0, 0x0180c9dd, 0x0183ddea, 0x0186f214,
  0x00315060, 0x018143ef, 0x018458f6, 0x01876e1a,
  0x000fffe0, 0x007cff07, 0x007dff06, 0x007eff22,
  0x001aaaa0, 0x00d05503, 0x00d1ffae, 0x00d3aa76,
  0x00211120, 0x010255cb, 0x010466de, 0x0106780e,
  0x00212120, 0x0102d2cb, 0x0104e4de, 0x0106f70e,
  0x00213100, 0x01034ed1, 0x010561e2, 0x01077510,
  0x002140c0, 0x0103c9dd, 0x0105ddea, 0x0107f214,
  0x00215060, 0x010443ef, 0x010658f6, 0x01086e1a,
  0x00215260, 0x0104538f, 0x010668b6, 0x01087dfa,
  0x000aaac0, 0x005355fd, 0x005400aa, 0x0054ab74,
  0x00111140, 0x008556c5, 0x008667da, 0x0087790c,
  0x00112140, 0x0085d3c5, 0x0086e5da, 0x0087f80c,
  0x00113120, 0x00864fcb, 0x008762de, 0x0088760e,
  0x001140e0, 0x0086cad7, 0x0087dee6, 0x0088f312,
  0x00115080, 0x008744e9, 0x008859f2, 0x00896f18,
  0x00115280, 0x00875489, 0x008869b2, 0x00897ef8,
  0x001152e0, 0x00875777, 0x00886ca6, 0x008981f2,
  0x00066680, 0x003200c9, 0x00326732, 0x0032cdb8,
  0x00067680, 0x00327dc9, 0x0032e532, 0x00334cb8,
  0x00068660, 0x0032f9cf, 0x00336236, 0x0033caba,
  0x00069620, 0x003374db, 0x0033de3e, 0x003447be,
  0x0006a5c0, 0x0033eeed, 0x0034594a, 0x0034c3c4,
  0x0006a7c0, 0x0033fe8d, 0x0034690a, 0x0034d3a4,
  0x0006a820, 0x0034017b, 0x00346bfe, 0x0034d69e,
  0x0006a860, 0x0034036f, 0x00346df6, 0x0034d89a,
  0x00001000, 0x00007d01, 0x00007e02, 0x00007f20,
  0x00001fe0, 0x0000f907, 0x0000fb06, 0x0000fd22,
  0x00002fa0, 0x00017413, 0x0001770e, 0x00017a26,
  0x00003f40, 0x0001ee25, 0x0001f21a, 0x0001f62c,
  0x00004140, 0x0001fdc5, 0x000201da, 0x0002060c,
  0x000041a0, 0x000200b3, 0x000204ce, 0x00020906,
  0x000041e0, 0x000202a7, 0x000206c6, 0x00020b02,
  0x00004200, 0x000203a1, 0x000207c2, 0x00020c00,
  0x00007c06, 0x00007d05, 0x00007e04, 0x0032ccba,
  0x0000f712, 0x0000f90d, 0x0000fb08, 0x006532ee,
  0x00017124, 0x00017419, 0x0001770e, 0x009732bc,
  0x000180c4, 0x000183d9, 0x000186ee, 0x009d991c,
  0x000183b2, 0x000186cd, 0x000189e8, 0x009ecc4e,
  0x000185a6, 0x000188c5, 0x00018be4, 0x009f991a,
  0x000186a0, 0x000189c1, 0x00018ce2, 0x009fff80,
  0x000186a0, 0x000189c1, 0x00018ce2, 0x009fff80,
  0x00007b0c, 0x00007c09, 0x00007d06, 0x00326654,
  0x0000f51e, 0x0000f715, 0x0000f90c, 0x00646622,
  0x000104be, 0x000106d5, 0x000108ec, 0x006acc82,
  0x000107ac, 0x000109c9, 0x00010be6, 0x006bffb4,
  0x000109a0, 0x00010bc1, 0x00010de2, 0x006ccc80,
  0x00010a9a, 0x00010cbd, 0x00010ee0, 0x006d32e6,
  0x00010a9a, 0x00010cbd, 0x00010ee0, 0x006d32e6,
  0x000109a0, 0x00010bc1, 0x00010de2, 0x006ccc80,
  0x00007a12, 0x00007b0d, 0x00007c08, 0x0031ffee,
  0x000089b2, 0x00008acd, 0x00008be8, 0x0038664e,
  0x00008ca0, 0x00008dc1, 0x00008ee2, 0x00399980,
  0x00008e94, 0x00008fb9, 0x000090de, 0x003a664c,
  0x00008f8e, 0x000090b5, 0x000091dc, 0x003accb2,
  0x00008f8e, 0x000090b5, 0x000091dc, 0x003accb2,
  0x00008e94, 0x00008fb9, 0x000090de, 0x003a664c,
  0x00008ca0, 0x00008dc1, 0x00008ee2, 0x00399980,
  0x00000fa0, 0x00000fc1, 0x00000fe2, 0x00066680,
  0x0000128e, 0x000012b5, 0x000012dc, 0x000799b2,
  0x00001482, 0x000014ad, 0x000014d8, 0x0008667e,
  0x0000157c, 0x000015a9, 0x000015d6, 0x0008cce4,
  0x0000157c, 0x000015a9, 0x000015d6, 0x0008cce4,
  0x00001482, 0x000014ad, 0x000014d8, 0x0008667e,
  0x0000128e, 0x000012b5, 0x000012dc, 0x000799b2,
  0x000002ee, 0x000002f5, 0x000002fc, 0x00013352,
  0x000002ee, 0x000002f5, 0x000002fc, 0x00013352,
  0x000004e2, 0x000004ed, 0x000004f8, 0x0002001e,
  0x000005dc, 0x000005e9, 0x000005f6, 0x00026684,
  0x000005dc, 0x000005e9, 0x000005f6, 0x00026684,
  0x000004e2, 0x000004ed, 0x000004f8, 0x0002001e,
  0x000002ee, 0x000002f5, 0x000002fc, 0x00013352,
  0xfffff34e, 0xfffff335, 0xfffff31c, 0xfffaccf2,
  0xffff793c, 0xffff7829, 0xffff7716, 0xffc8cd24,
  0x000001f4, 0x000001f9, 0x000001fe, 0x0000ccec,
  0x000002ee, 0x000002f5, 0x000002fc, 0x00013352,
  0x000002ee, 0x000002f5, 0x000002fc, 0x00013352,
  0x000001f4, 0x000001f9, 0x000001fe, 0x0000ccec,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffff060, 0xfffff041, 0xfffff022, 0xfff999c0,
  0xffff764e, 0xffff7535, 0xffff741c, 0xffc799f2,
  0xfffefb42, 0xfffef92d, 0xfffef718, 0xff9533be,
  0x000000fa, 0x000000fd, 0x00000100, 0x00006686,
  0x000000fa, 0x000000fd, 0x00000100, 0x00006686,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffffe0c, 0xfffffe09, 0xfffffe06, 0xffff3354,
  0xffffee6c, 0xffffee49, 0xffffee26, 0xfff8ccf4,
  0xffff745a, 0xffff733d, 0xffff7220, 0xffc6cd26,
  0xfffef94e, 0xfffef735, 0xfffef51c, 0xff9466f2,
  0xfffe7d48, 0xfffe7a31, 0xfffe771a, 0xff619a58,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffff06, 0xffffff05, 0xffffff04, 0xffff99ba,
  0xfffffd12, 0xfffffd0d, 0xfffffd08, 0xfffeccee,
  0xffffed72, 0xffffed4d, 0xffffed28, 0xfff8668e,
  0xffff7360, 0xffff7241, 0xffff7122, 0xffc666c0,
  0xfffef854, 0xfffef639, 0xfffef41e, 0xff94008c,
  0xfffe7c4e, 0xfffe7935, 0xfffe761c, 0xff6133f2,
  0xffcc7c80, 0xffcc1301, 0xffcba982, 0xeae67ba0,
  0xffffff06, 0xffffff05, 0xffffff04, 0xffff99ba,
  0xfffffd12, 0xfffffd0d, 0xfffffd08, 0xfffeccee,
  0xffffed72, 0xffffed4d, 0xffffed28, 0xfff8668e,
  0xffff7360, 0xffff7241, 0xffff7122, 0xffc666c0,
  0xfffef854, 0xfffef639, 0xfffef41e, 0xff94008c,
  0xfffe7c4e, 0xfffe7935, 0xfffe761c, 0xff6133f2,
  0xffcc7c80, 0xffcc1301, 0xffcba982, 0xeae67ba0,
  0xff79277e, 0xff781355, 0xff76ff2c, 0xc8c49dc2,
  0xfffffe0c, 0xfffffe09, 0xfffffe06, 0xffff3354,
  0xffffee6c, 0xffffee49, 0xffffee26, 0xfff8ccf4,
  0xffff745a, 0xffff733d, 0xffff7220, 0xffc6cd26,
  0xfffef94e, 0xfffef735, 0xfffef51c, 0xff9466f2,
  0xfffe7d48, 0xfffe7a31, 0xfffe771a, 0xff619a58,
  0xffcc7d7a, 0xffcc13fd, 0xffcbaa80, 0xeae6e206,
  0xff792878, 0xff781451, 0xff77002a, 0xc8c50428,
  0xfefc2b66, 0xfefa1745, 0xfef80324, 0x9593375a,
  0xfffff060, 0xfffff041, 0xfffff022, 0xfff999c0,
  0xffff764e, 0xffff7535, 0xffff741c, 0xffc799f2,
  0xfffefb42, 0xfffef92d, 0xfffef718, 0xff9533be,
  0xfffe7f3c, 0xfffe7c29, 0xfffe7916, 0xff626724,
  0xffcc7f6e, 0xffcc15f5, 0xffcbac7c, 0xeae7aed2,
  0xff792a6c, 0xff781649, 0xff770226, 0xc8c5d0f4,
  0xfefc2d5a, 0xfefa193d, 0xfef80520, 0x95940426,
  0xfe7f2f4e, 0xfe7c1b35, 0xfe79071c, 0x80000000,
  0xffff85ee, 0xffff84f5, 0xffff83fc, 0xffce0052,
  0xffff0ae2, 0xffff08ed, 0xffff06f8, 0xff9b9a1e,
  0xfffe8edc, 0xfffe8be9, 0xfffe88f6, 0xff68cd84,
  0xffcc8f0e, 0xffcc25b5, 0xffcbbc5c, 0xeaee1532,
  0xff793a0c, 0xff782609, 0xff771206, 0xc8cc3754,
  0xfefc3cfa, 0xfefa28fd, 0xfef81500, 0x959a6a86,
  0xfe7f3eee, 0xfe7c2af5, 0xfe7916fc, 0x80000000,
  0xfe023fe8, 0xfdfe2bf1, 0xfdfa17fa, 0x80000000,
  0xffff84f4, 0xffff83f9, 0xffff82fe, 0xffcd99ec,
  0xffff08ee, 0xffff06f5, 0xffff04fc, 0xff9acd52,
  0xffcd0920, 0xffcca0c1, 0xffcc3862, 0xeb201500,
  0xff79b41e, 0xff78a115, 0xff778e0c, 0xc8fe3722,
  0xfefcb70c, 0xfefaa409, 0xfef89106, 0x95cc6a54,
  0xfe7fb900, 0xfe7ca601, 0xfe799302, 0x80000000,
  0xfe02b9fa, 0xfdfea6fd, 0xfdfa9400, 0x80000000,
  0xfe7fb9fa, 0xfe7ca6fd, 0xfe799400, 0xb3330000,
  0xffff83fa, 0xffff82fd, 0xffff8200, 0xffcd3386,
  0xffcd842c, 0xffcd1cc9, 0xffccb566, 0xeb527b34,
  0xff7a2f2a, 0xff791d1d, 0xff780b10, 0xc9309d56,
  0xfefd3218, 0xfefb2011, 0xfef90e0a, 0x95fed088,
  0xfe80340c, 0xfe7d2209, 0xfe7a1006, 0x80000000,
  0xfe033506, 0xfdff2305, 0xfdfb1104, 0x80000000,
  0xfe803506, 0xfe7d2305, 0xfe7a1104, 0xb3330000,
  0xfefd340c, 0xfefb2209, 0xfef91006, 0xe665999a,
  0xffce0032, 0xffcd99cd, 0xffcd3368, 0xeb8547ce,
  0xff7aab30, 0xff799a21, 0xff788912, 0xc96369f0,
  0xfefdae1e, 0xfefb9d15, 0xfef98c0c, 0x96319d22,
  0xfe80b012, 0xfe7d9f0d, 0xfe7a8e08, 0x80000000,
  0xfe03b10c, 0xfdffa009, 0xfdfb8f06, 0x80000000,
  0xfe80b10c, 0xfe7da009, 0xfe7a8f06, 0xb3330000,
  0xfefdb012, 0xfefb9f0d, 0xfef98e08, 0xe665999a,
  0xff51060e, 0xff4f9fb5, 0xff4e395c, 0x0887ddde,
  0xffacaafe, 0xffac0055, 0xffab55ac, 0xddde2242,
  0xff2fadec, 0xff2e0349, 0xff2c58a6, 0xaaac5574,
  0xfeb2afe0, 0xfeb00541, 0xfead5aa2, 0x80000000,
  0xfe35b0da, 0xfe32063d, 0xfe2e5ba0, 0x80000000,
  0xfeb2b0da, 0xfeb0063d, 0xfead5ba0, 0xb3330000,
  0xff2fafe0, 0xff2e0541, 0xff2c5aa2, 0xe665999a,
  0xff8305dc, 0xff8205e9, 0xff8105f6, 0x0887ddde,
  0xffb506a4, 0xffb46d19, 0xffb3d38e, 0x1d02fc96,
  0xff8302ee, 0xff8202f5, 0xff8102fc, 0xccce3352,
  0xff0604e2, 0xff0404ed, 0xff0204f8, 0x999c001e,
  0xfe8905dc, 0xfe8605e9, 0xfe8305f6, 0x80000000,
  0xff0605dc, 0xff0405e9, 0xff0205f6, 0xb3330000,
  0xff8304e2, 0xff8204ed, 0xff8104f8, 0xe665999a,
  0xffd65ade, 0xffd60595, 0xffd5b04c, 0x0887ddde,
  0x00085ba6, 0x00086cc5, 0x00087de4, 0x1d02fc96,
  0x0008d8a6, 0x0008eac5, 0x0008fce4, 0x1d362f96,
  0xff8301f4, 0xff8201f9, 0xff8101fe, 0xcccdccec,
  0xff0602ee, 0xff0402f5, 0xff0202fc, 0x999b3352,
  0xff8302ee, 0xff8202f5, 0xff8102fc, 0xccce3352,
  0x000001f4, 0x000001f9, 0x000001fe, 0x0000ccec,
  0x005357f0, 0x005402a1, 0x0054ad52, 0x22231130,
  0x008558b8, 0x008669d1, 0x00877aea, 0x369e2fe8,
  0x0085d5b8, 0x0086e7d1, 0x0087f9ea, 0x36d162e8,
  0x008651be, 0x008764d5, 0x008877ec, 0x37042f82,
  0xff8300fa, 0xff8200fd, 0xff810100, 0xcccd6686,
  0x000000fa, 0x000000fd, 0x00000100, 0x00006686,
  0x007d0000, 0x007e0001, 0x007f0002, 0x33330020,
  0x00d055fc, 0x00d200a9, 0x00d3ab56, 0x55554464,
  0x010256c4, 0x010467d9, 0x010678ee, 0x69d0631c,
  0x0102d3c4, 0x0104e5d9, 0x0106f7ee, 0x6a03961c,
  0x01034fca, 0x010562dd, 0x010775f0, 0x6a3662b6,
  0x0103cad6, 0x0105dee5, 0x0107f2f4, 0x6a68c8ea,
  0x007d0000, 0x007e0001, 0x007f0002, 0x33330020,
  0x00f9ff06, 0x00fbff05, 0x00fdff04, 0x666599ba,
  0x014d5502, 0x014fffad, 0x0152aa58, 0x7fffffff,
  0x017f55ca, 0x018266dd, 0x018577f0, 0x7fffffff,
  0x017fd2ca, 0x0182e4dd, 0x0185f6f0, 0x7fffffff,
  0x01804ed0, 0x018361e1, 0x018674f2, 0x7fffffff,
  0x0180c9dc, 0x0183dde9, 0x0186f1f6, 0x7fffffff,
  0x018143ee, 0x018458f5, 0x01876dfc, 0x7fffffff,
  0x007cff06, 0x007dff05, 0x007eff04, 0x333299ba,
  0x00d05502, 0x00d1ffad, 0x00d3aa58, 0x5554ddfe,
  0x010255ca, 0x010466dd, 0x010677f0, 0x69cffcb6,
  0x0102d2ca, 0x0104e4dd, 0x0106f6f0, 0x6a032fb6,
  0x01034ed0, 0x010561e1, 0x010774f2, 0x6a35fc50,
  0x0103c9dc, 0x0105dde9, 0x0107f1f6, 0x6a686284,
  0x010443ee, 0x010658f5, 0x01086dfc, 0x6a9a6252,
  0x0104538e, 0x010668b5, 0x01087ddc, 0x6aa0c8b2,
  0x005355fc, 0x005400a9, 0x0054ab56, 0x22224464,
  0x008556c4, 0x008667d9, 0x008778ee, 0x369d631c,
  0x0085d3c4, 0x0086e5d9, 0x0087f7ee, 0x36d0961c,
  0x00864fca, 0x008762dd, 0x008875f0, 0x370362b6,
  0x0086cad6, 0x0087dee5, 0x0088f2f4, 0x3735c8ea,
  0x008744e8, 0x008859f1, 0x00896efa, 0x3767c8b8,
  0x00875488, 0x008869b1, 0x00897eda, 0x376e2f18,
  0x00875776, 0x00886ca5, 0x008981d4, 0x376f624a,
  0x003200c8, 0x00326731, 0x0032cd9a, 0x147b1ed8,
  0x00327dc8, 0x0032e531, 0x00334c9a, 0x14ae51d8,
  0x0032f9ce, 0x00336235, 0x0033ca9c, 0x14e11e72,
  0x003374da, 0x0033de3d, 0x003447a0, 0x151384a6,
  0x0033eeec, 0x00345949, 0x0034c3a6, 0x15458474,
  0x0033fe8c, 0x00346909, 0x0034d386, 0x154bead4,
  0x0034017a, 0x00346bfd, 0x0034d680, 0x154d1e06,
  0x0034036e, 0x00346df5, 0x0034d87c, 0x154dead2,
  0x00007d00, 0x00007e01, 0x00007f02, 0x00333320,
  0x0000f906, 0x0000fb05, 0x0000fd04, 0x0065ffba,
  0x00017412, 0x0001770d, 0x00017a08, 0x009865ee,
  0x0001ee24, 0x0001f219, 0x0001f60e, 0x00ca65bc,
  0x0001fdc4, 0x000201d9, 0x000205ee, 0x00d0cc1c,
  0x000200b2, 0x000204cd, 0x000208e8, 0x00d1ff4e,
  0x000202a6, 0x000206c5, 0x00020ae4, 0x00d2cc1a,
  0x000203a0, 0x000207c1, 0x00020be2, 0x00d33280,
  0x00007d04, 0x00007e03, 0x0032cc9c, 0x0054aa76,
  0x0000f90c, 0x0000fb07, 0x006532d0, 0x00a8aa22,
  0x00017418, 0x0001770d, 0x0097329e, 0x00fbff24,
  0x000183d8, 0x000186ed, 0x009d98fe, 0x0106a9c4,
  0x000186cc, 0x000189e7, 0x009ecc30, 0x0108a9c2,
  0x000188c4, 0x00018be3, 0x009f98fc, 0x0109ff16,
  0x000189c0, 0x00018ce1, 0x009fff62, 0x010aa9c0,
  0x000189c0, 0x00018ce1, 0x009fff62, 0x010aa9c0,
  0x00007c08, 0x00007d05, 0x00326636, 0x0053ffcc,
  0x0000f714, 0x0000f90b, 0x00646604, 0x00a754ce,
  0x000106d4, 0x000108eb, 0x006acc64, 0x00b1ff6e,
  0x000109c8, 0x00010be5, 0x006bff96, 0x00b3ff6c,
  0x00010bc0, 0x00010de1, 0x006ccc62, 0x00b554c0,
  0x00010cbc, 0x00010edf, 0x006d32c8, 0x00b5ff6a,
  0x00010cbc, 0x00010edf, 0x006d32c8, 0x00b5ff6a,
  0x00010bc0, 0x00010de1, 0x006ccc62, 0x00b554c0,
  0x00007b0c, 0x00007c07, 0x0031ffd0, 0x00535522,
  0x00008acc, 0x00008be7, 0x00386630, 0x005dffc2,
  0x00008dc0, 0x00008ee1, 0x00399962, 0x005fffc0,
  0x00008fb8, 0x000090dd, 0x003a662e, 0x00615514,
  0x000090b4, 0x000091db, 0x003acc94, 0x0061ffbe,
  0x000090b4, 0x000091db, 0x003acc94, 0x0061ffbe,
  0x00008fb8, 0x000090dd, 0x003a662e, 0x00615514,
  0x00008dc0, 0x00008ee1, 0x00399962, 0x005fffc0,
  0x00000fc0, 0x00000fe1, 0x00066662, 0x000aaac0,
  0x000012b4, 0x000012db, 0x00079994, 0x000caabe,
  0x000014ac, 0x000014d7, 0x00086660, 0x000e0012,
  0x000015a8, 0x000015d5, 0x0008ccc6, 0x000eaabc,
  0x000015a8, 0x000015d5, 0x0008ccc6, 0x000eaabc,
  0x000014ac, 0x000014d7, 0x00086660, 0x000e0012,
  0x000012b4, 0x000012db, 0x00079994, 0x000caabe,
  0x000002f4, 0x000002fb, 0x00013334, 0x0002001e,
  0x000002f4, 0x000002fb, 0x00013334, 0x0002001e,
  0x000004ec, 0x000004f7, 0x00020000, 0x00035572,
  0x000005e8, 0x000005f5, 0x00026666, 0x0004001c,
  0x000005e8, 0x000005f5, 0x00026666, 0x0004001c,
  0x000004ec, 0x000004f7, 0x00020000, 0x00035572,
  0x000002f4, 0x000002fb, 0x00013334, 0x0002001e,
  0xfffff334, 0xfffff31b, 0xfffaccd4, 0xfff7557e,
  0xffff7828, 0xffff7715, 0xffc8cd06, 0xffa4007c,
  0x000001f8, 0x000001fd, 0x0000ccce, 0x00015574,
  0x000002f4, 0x000002fb, 0x00013334, 0x0002001e,
  0x000002f4, 0x000002fb, 0x00013334, 0x0002001e,
  0x000001f8, 0x000001fd, 0x0000ccce, 0x00015574,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffff040, 0xfffff021, 0xfff999a2, 0xfff55580,
  0xffff7534, 0xffff741b, 0xffc799d4, 0xffa2007e,
  0xfffef92c, 0xfffef717, 0xff9533a0, 0xff4e00d2,
  0x000000fc, 0x000000ff, 0x00006668, 0x0000aaca,
  0x000000fc, 0x000000ff, 0x00006668, 0x0000aaca,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffffe08, 0xfffffe05, 0xffff3336, 0xfffeaacc,
  0xffffee48, 0xffffee25, 0xfff8ccd6, 0xfff4002c,
  0xffff733c, 0xffff721f, 0xffc6cd08, 0xffa0ab2a,
  0xfffef734, 0xfffef51b, 0xff9466d4, 0xff4cab7e,
  0xfffe7a30, 0xfffe7719, 0xff619a3a, 0xfef80128,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffff04, 0xffffff03, 0xffff999c, 0xffff5576,
  0xfffffd0c, 0xfffffd07, 0xfffeccd0, 0xfffe0022,
  0xffffed4c, 0xffffed27, 0xfff86670, 0xfff35582,
  0xffff7240, 0xffff7121, 0xffc666a2, 0xffa00080,
  0xfffef638, 0xfffef41d, 0xff94006e, 0xff4c00d4,
  0xfffe7934, 0xfffe761b, 0xff6133d4, 0xfef7567e,
  0xffcc1300, 0xffcba981, 0xeae67b82, 0xdcd578a0,
  0xffffff04, 0xffffff03, 0xffff999c, 0xffff5576,
  0xfffffd0c, 0xfffffd07, 0xfffeccd0, 0xfffe0022,
  0xffffed4c, 0xffffed27, 0xfff86670, 0xfff35582,
  0xffff7240, 0xffff7121, 0xffc666a2, 0xffa00080,
  0xfffef638, 0xfffef41d, 0xff94006e, 0xff4c00d4,
  0xfffe7934, 0xfffe761b, 0xff6133d4, 0xfef7567e,
  0xffcc1300, 0xffcba981, 0xeae67b82, 0xdcd578a0,
  0xff781354, 0xff76ff2b, 0xc8c49da4, 0xa3f25c2e,
  0xfffffe08, 0xfffffe05, 0xffff3336, 0xfffeaacc,
  0xffffee48, 0xffffee25, 0xfff8ccd6, 0xfff4002c,
  0xffff733c, 0xffff721f, 0xffc6cd08, 0xffa0ab2a,
  0xfffef734, 0xfffef51b, 0xff9466d4, 0xff4cab7e,
  0xfffe7a30, 0xfffe7719, 0xff619a3a, 0xfef80128,
  0xffcc13fc, 0xffcbaa7f, 0xeae6e1e8, 0xdcd6234a,
  0xff781450, 0xff770029, 0xc8c5040a, 0xa3f306d8,
  0xfefa1744, 0xfef80323, 0x9593373c, 0x80000000,
  0xfffff040, 0xfffff021, 0xfff999a2, 0xfff55580,
  0xffff7534, 0xffff741b, 0xffc799d4, 0xffa2007e,
  0xfffef92c, 0xfffef717, 0xff9533a0, 0xff4e00d2,
  0xfffe7c28, 0xfffe7915, 0xff626706, 0xfef9567c,
  0xffcc15f4, 0xffcbac7b, 0xeae7aeb4, 0xdcd7789e,
  0xff781648, 0xff770225, 0xc8c5d0d6, 0xa3f45c2c,
  0xfefa193c, 0xfef8051f, 0x95940408, 0x80000000,
  0xfe7c1b34, 0xfe79071b, 0x80000000, 0x80000000,
  0xffff84f4, 0xffff83fb, 0xffce0034, 0xffacab1e,
  0xffff08ec, 0xffff06f7, 0xff9b9a00, 0xff58ab72,
  0xfffe8be8, 0xfffe88f5, 0xff68cd66, 0xff04011c,
  0xffcc25b4, 0xffcbbc5b, 0xeaee1514, 0xdce2233e,
  0xff782608, 0xff771205, 0xc8cc3736, 0xa3ff06cc,
  0xfefa28fc, 0xfef814ff, 0x959a6a68, 0x80000000,
  0xfe7c2af4, 0xfe7916fb, 0x80000000, 0x80000000,
  0xfdfe2bf0, 0xfdfa17f9, 0x80000000, 0x80000000,
  0xffff83f8, 0xffff82fd, 0xffcd99ce, 0xffac0074,
  0xffff06f4, 0xffff04fb, 0xff9acd34, 0xff57561e,
  0xffcca0c0, 0xffcc3861, 0xeb2014e2, 0xdd357840,
  0xff78a114, 0xff778e0b, 0xc8fe3704, 0xa4525bce,
  0xfefaa408, 0xfef89105, 0x95cc6a36, 0x80000000,
  0xfe7ca600, 0xfe799301, 0x80000000, 0x80000000,
  0xfdfea6fc, 0xfdfa93ff, 0x80000000, 0x80000000,
  0xfe7ca6fc, 0xfe7993ff, 0xb3330000, 0xd5550000,
  0xffff82fc, 0xffff81ff, 0xffcd3368, 0xffab55ca,
  0xffcd1cc8, 0xffccb565, 0xeb527b16, 0xdd8977ec,
  0xff791d1c, 0xff780b0f, 0xc9309d38, 0xa4a65b7a,
  0xfefb2010, 0xfef90e09, 0x95fed06a, 0x80000000,
  0xfe7d2208, 0xfe7a1005, 0x80000000, 0x80000000,
  0xfdff2304, 0xfdfb1103, 0x80000000, 0x80000000,
  0xfe7d2304, 0xfe7a1103, 0xb3330000, 0xd5550000,
  0xfefb2208, 0xfef91005, 0xe665999a, 0x2aa95556,
  0xffcd99cc, 0xffcd3367, 0xeb8547b0, 0xddde2242,
  0xff799a20, 0xff788911, 0xc96369d2, 0xa4fb05d0,
  0xfefb9d14, 0xfef98c0b, 0x96319d04, 0x80000000,
  0xfe7d9f0c, 0xfe7a8e07, 0x80000000, 0x80000000,
  0xfdffa008, 0xfdfb8f05, 0x80000000, 0x80000000,
  0xfe7da008, 0xfe7a8f05, 0xb3330000, 0xd5550000,
  0xfefb9f0c, 0xfef98e07, 0xe665999a, 0x2aa95556,
  0xff4f9fb4, 0xff4e395b, 0x0887ddde, 0x638d1c72,
  0xffac0054, 0xffab55ab, 0xddde2224, 0xc71ce3ae,
  0xff2e0348, 0xff2c58a5, 0xaaac5556, 0x80000000,
  0xfeb00540, 0xfead5aa1, 0x80000000, 0x80000000,
  0xfe32063c, 0xfe2e5b9f, 0x80000000, 0x80000000,
  0xfeb0063c, 0xfead5b9f, 0xb3330000, 0xd5550000,
  0xff2e0540, 0xff2c5aa1, 0xe665999a, 0x2aa95556,
  0xff8205e8, 0xff8105f5, 0x0887ddde, 0x638d1c72,
  0xffb46d18, 0xffb3d38d, 0x1d02fc96, 0x7fffffff,
  0xff8202f4, 0xff8102fb, 0xccce3334, 0xaaad001e,
  0xff0404ec, 0xff0204f7, 0x999c0000, 0x80000000,
  0xfe8605e8, 0xfe8305f5, 0x80000000, 0x80000000,
  0xff0405e8, 0xff0205f5, 0xb3330000, 0xd5550000,
  0xff8204ec, 0xff8104f7, 0xe665999a, 0x2aa95556,
  0xffd60594, 0xffd5b04b, 0x0887ddde, 0x638d1c72,
  0x00086cc4, 0x00087de3, 0x1d02fc96, 0x7fffffff,
  0x0008eac4, 0x0008fce3, 0x1d362f96, 0x7fffffff,
  0xff8201f8, 0xff8101fd, 0xcccdccce, 0xaaac5574,
  0xff0402f4, 0xff0202fb, 0x999b3334, 0x80000000,
  0xff8202f4, 0xff8102fb, 0xccce3334, 0xd5550000,
  0x000001f8, 0x000001fd, 0x0000ccce, 0x2aa95556,
  0x005402a0, 0x0054ad51, 0x22231112, 0x638d1c72,
  0x008669d0, 0x00877ae9, 0x369e2fca, 0x7fffffff,
  0x0086e7d0, 0x0087f9e9, 0x36d162ca, 0x7fffffff,
  0x008764d4, 0x008877eb, 0x37042f64, 0x7fffffff,
  0xff8200fc, 0xff8100ff, 0xcccd6668, 0xaaabaaca,
  0x000000fc, 0x000000ff, 0x00006668, 0x0000aaca,
  0x007e0000, 0x007f0001, 0x33330002, 0x55550020,
  0x00d200a8, 0x00d3ab55, 0x55554446, 0x7fffffff,
  0x010467d8, 0x010678ed, 0x69d062fe, 0x7fffffff,
  0x0104e5d8, 0x0106f7ed, 0x6a0395fe, 0x7fffffff,
  0x010562dc, 0x010775ef, 0x6a366298, 0x7fffffff,
  0x0105dee4, 0x0107f2f3, 0x6a68c8cc, 0x7fffffff,
  0x007e0000, 0x007f0001, 0x33330002, 0x55550020,
  0x00fbff04, 0x00fdff03, 0x6665999c, 0x7fffffff,
  0x014fffac, 0x0152aa57, 0x7fffffff, 0x7fffffff,
  0x018266dc, 0x018577ef, 0x7fffffff, 0x7fffffff,
  0x0182e4dc, 0x0185f6ef, 0x7fffffff, 0x7fffffff,
  0x018361e0, 0x018674f1, 0x7fffffff, 0x7fffffff,
  0x0183dde8, 0x0186f1f5, 0x7fffffff, 0x7fffffff,
  0x018458f4, 0x01876dfb, 0x7fffffff, 0x7fffffff,
  0x007dff04, 0x007eff03, 0x3332999c, 0x55545576,
  0x00d1ffac, 0x00d3aa57, 0x5554dde0, 0x7fffffff,
  0x010466dc, 0x010677ef, 0x69cffc98, 0x7fffffff,
  0x0104e4dc, 0x0106f6ef, 0x6a032f98, 0x7fffffff,
  0x010561e0, 0x010774f1, 0x6a35fc32, 0x7fffffff,
  0x0105dde8, 0x0107f1f5, 0x6a686266, 0x7fffffff,
  0x010658f4, 0x01086dfb, 0x6a9a6234, 0x7fffffff,
  0x010668b4, 0x01087ddb, 0x6aa0c894, 0x7fffffff,
  0x005400a8, 0x0054ab55, 0x22224446, 0x38e3c73c,
  0x008667d8, 0x008778ed, 0x369d62fe, 0x5b064fc4,
  0x0086e5d8, 0x0087f7ed, 0x36d095fe, 0x5b5ba4c4,
  0x008762dc, 0x008875ef, 0x37036298, 0x5bb04f1a,
  0x0087dee4, 0x0088f2f3, 0x3735c8cc, 0x5c044ec6,
  0x008859f0, 0x00896ef9, 0x3767c89a, 0x5c57a3c8,
  0x008869b0, 0x00897ed9, 0x376e2efa, 0x5c624e68,
  0x00886ca4, 0x008981d3, 0x376f622c, 0x5c644e66,
  0x00326730, 0x0032cd99, 0x147b1eba, 0x222288a8,
  0x0032e530, 0x00334c99, 0x14ae51ba, 0x2277dda8,
  0x00336234, 0x0033ca9b, 0x14e11e54, 0x22cc87fe,
  0x0033de3c, 0x0034479f, 0x15138488, 0x232087aa,
  0x00345948, 0x0034c3a5, 0x15458456, 0x2373dcac,
  0x00346908, 0x0034d385, 0x154beab6, 0x237e874c,
  0x00346bfc, 0x0034d67f, 0x154d1de8, 0x2380874a,
  0x00346df4, 0x0034d87b, 0x154deab4, 0x2381dc9e,
  0x00007e00, 0x00007f01, 0x00333302, 0x00555520,
  0x0000fb04, 0x0000fd03, 0x0065ff9c, 0x00a9ff76,
  0x0001770c, 0x00017a07, 0x009865d0, 0x00fdff22,
  0x0001f218, 0x0001f60d, 0x00ca659e, 0x01515424,
  0x000201d8, 0x000205ed, 0x00d0cbfe, 0x015bfec4,
  0x000204cc, 0x000208e7, 0x00d1ff30, 0x015dfec2,
  0x000206c4, 0x00020ae3, 0x00d2cbfc, 0x015f5416,
  0x000207c0, 0x00020be1, 0x00d33262, 0x015ffec0,
  0x00007e02, 0x0032cc9b, 0x0054aa58, 0x007efd26,
  0x0000fb06, 0x006532cf, 0x00a8aa04, 0x00fcfa32,
  0x0001770c, 0x0097329d, 0x00fbff06, 0x0179f744,
  0x000186ec, 0x009d98fd, 0x0106a9a6, 0x0189f6e4,
  0x000189e6, 0x009ecc2f, 0x0108a9a4, 0x018cf6d2,
  0x00018be2, 0x009f98fb, 0x0109fef8, 0x018ef6c6,
  0x00018ce0, 0x009fff61, 0x010aa9a2, 0x018ff6c0,
  0x00018ce0, 0x009fff61, 0x010aa9a2, 0x018ff6c0,
  0x00007d04, 0x00326635, 0x0053ffae, 0x007dfd2c,
  0x0000f90a, 0x00646603, 0x00a754b0, 0x00fafa3e,
  0x000108ea, 0x006acc63, 0x00b1ff50, 0x010af9de,
  0x00010be4, 0x006bff95, 0x00b3ff4e, 0x010df9cc,
  0x00010de0, 0x006ccc61, 0x00b554a2, 0x010ff9c0,
  0x00010ede, 0x006d32c7, 0x00b5ff4c, 0x0110f9ba,
  0x00010ede, 0x006d32c7, 0x00b5ff4c, 0x0110f9ba,
  0x00010de0, 0x006ccc61, 0x00b554a2, 0x010ff9c0,
  0x00007c06, 0x0031ffcf, 0x00535504, 0x007cfd32,
  0x00008be6, 0x0038662f, 0x005dffa4, 0x008cfcd2,
  0x00008ee0, 0x00399961, 0x005fffa2, 0x008ffcc0,
  0x000090dc, 0x003a662d, 0x006154f6, 0x0091fcb4,
  0x000091da, 0x003acc93, 0x0061ffa0, 0x0092fcae,
  0x000091da, 0x003acc93, 0x0061ffa0, 0x0092fcae,
  0x000090dc, 0x003a662d, 0x006154f6, 0x0091fcb4,
  0x00008ee0, 0x00399961, 0x005fffa2, 0x008ffcc0,
  0x00000fe0, 0x00066661, 0x000aaaa2, 0x000fffc0,
  0x000012da, 0x00079993, 0x000caaa0, 0x0012ffae,
  0x000014d6, 0x0008665f, 0x000dfff4, 0x0014ffa2,
  0x000015d4, 0x0008ccc5, 0x000eaa9e, 0x0015ff9c,
  0x000015d4, 0x0008ccc5, 0x000eaa9e, 0x0015ff9c,
  0x000014d6, 0x0008665f, 0x000dfff4, 0x0014ffa2,
  0x000012da, 0x00079993, 0x000caaa0, 0x0012ffae,
  0x000002fa, 0x00013333, 0x00020000, 0x0003000e,
  0x000002fa, 0x00013333, 0x00020000, 0x0003000e,
  0x000004f6, 0x0001ffff, 0x00035554, 0x00050002,
  0x000005f4, 0x00026665, 0x0003fffe, 0x0005fffc,
  0x000005f4, 0x00026665, 0x0003fffe, 0x0005fffc,
  0x000004f6, 0x0001ffff, 0x00035554, 0x00050002,
  0x000002fa, 0x00013333, 0x00020000, 0x0003000e,
  0xfffff31a, 0xfffaccd3, 0xfff75560, 0xfff3006e,
  0xffff7714, 0xffc8cd05, 0xffa4005e, 0xff76035c,
  0x000001fc, 0x0000cccd, 0x00015556, 0x00020014,
  0x000002fa, 0x00013333, 0x00020000, 0x0003000e,
  0x000002fa, 0x00013333, 0x00020000, 0x0003000e,
  0x000001fc, 0x0000cccd, 0x00015556, 0x00020014,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffff020, 0xfff999a1, 0xfff55562, 0xfff00080,
  0xffff741a, 0xffc799d3, 0xffa20060, 0xff73036e,
  0xfffef716, 0xff95339f, 0xff4e00b4, 0xfef50662,
  0x000000fe, 0x00006667, 0x0000aaac, 0x0001001a,
  0x000000fe, 0x00006667, 0x0000aaac, 0x0001001a,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffffe04, 0xffff3335, 0xfffeaaae, 0xfffe002c,
  0xffffee24, 0xfff8ccd5, 0xfff4000e, 0xffee008c,
  0xffff721e, 0xffc6cd07, 0xffa0ab0c, 0xff71037a,
  0xfffef51a, 0xff9466d3, 0xff4cab60, 0xfef3066e,
  0xfffe7718, 0xff619a39, 0xfef8010a, 0xfe740968,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffff02, 0xffff999b, 0xffff5558, 0xffff0026,
  0xfffffd06, 0xfffecccf, 0xfffe0004, 0xfffd0032,
  0xffffed26, 0xfff8666f, 0xfff35564, 0xffed0092,
  0xffff7120, 0xffc666a1, 0xffa00062, 0xff700380,
  0xfffef41c, 0xff94006d, 0xff4c00b6, 0xfef20674,
  0xfffe761a, 0xff6133d3, 0xfef75660, 0xfe73096e,
  0xffcba980, 0xeae67b81, 0xdcd57882, 0xcb413ca0,
  0xffffff02, 0xffff999b, 0xffff5558, 0xffff0026,
  0xfffffd06, 0xfffecccf, 0xfffe0004, 0xfffd0032,
  0xffffed26, 0xfff8666f, 0xfff35564, 0xffed0092,
  0xffff7120, 0xffc666a1, 0xffa00062, 0xff700380,
  0xfffef41c, 0xff94006d, 0xff4c00b6, 0xfef20674,
  0xfffe761a, 0xff6133d3, 0xfef75660, 0xfe73096e,
  0xffcba980, 0xeae67b81, 0xdcd57882, 0xcb413ca0,
  0xff76ff2a, 0xc8c49da3, 0xa3f25c10, 0x80000000,
  0xfffffe04, 0xffff3335, 0xfffeaaae, 0xfffe002c,
  0xffffee24, 0xfff8ccd5, 0xfff4000e, 0xffee008c,
  0xffff721e, 0xffc6cd07, 0xffa0ab0c, 0xff71037a,
  0xfffef51a, 0xff9466d3, 0xff4cab60, 0xfef3066e,
  0xfffe7718, 0xff619a39, 0xfef8010a, 0xfe740968,
  0xffcbaa7e, 0xeae6e1e7, 0xdcd6232c, 0xcb423c9a,
  0xff770028, 0xc8c50409, 0xa3f306ba, 0x80000000,
  0xfef80322, 0x9593373b, 0x80000000, 0x80000000,
  0xfffff020, 0xfff999a1, 0xfff55562, 0xfff00080,
  0xffff741a, 0xffc799d3, 0xffa20060, 0xff73036e,
  0xfffef716, 0xff95339f, 0xff4e00b4, 0xfef50662,
  0xfffe7914, 0xff626705, 0xfef9565e, 0xfe76095c,
  0xffcbac7a, 0xeae7aeb3, 0xdcd77880, 0xcb443c8e,
  0xff770224, 0xc8c5d0d5, 0xa3f45c0e, 0x80000000,
  0xfef8051e, 0x95940407, 0x80000000, 0x80000000,
  0xfe79071a, 0x80000000, 0x80000000, 0x80000000,
  0xffff83fa, 0xffce0033, 0xffacab00, 0xff83030e,
  0xffff06f6, 0xff9b99ff, 0xff58ab54, 0xff050602,
  0xfffe88f4, 0xff68cd65, 0xff0400fe, 0xfe8608fc,
  0xffcbbc5a, 0xeaee1513, 0xdce22320, 0xcb543c2e,
  0xff771204, 0xc8cc3735, 0xa3ff06ae, 0x80000000,
  0xfef814fe, 0x959a6a67, 0x80000000, 0x80000000,
  0xfe7916fa, 0x80000000, 0x80000000, 0x80000000,
  0xfdfa17f8, 0x80000000, 0x80000000, 0x80000000,
  0xffff82fc, 0xffcd99cd, 0xffac0056, 0xff820314,
  0xffff04fa, 0xff9acd33, 0xff575600, 0xff03060e,
  0xffcc3860, 0xeb2014e1, 0xdd357822, 0xcbd13940,
  0xff778e0a, 0xc8fe3703, 0xa4525bb0, 0x80000000,
  0xfef89104, 0x95cc6a35, 0x80000000, 0x80000000,
  0xfe799300, 0x80000000, 0x80000000, 0x80000000,
  0xfdfa93fe, 0x80000000, 0x80000000, 0x80000000,
  0xfe7993fe, 0xb3330000, 0xd5550000, 0xfffd0000,
  0xffff81fe, 0xffcd3367, 0xffab55ac, 0xff81031a,
  0xffccb564, 0xeb527b15, 0xdd8977ce, 0xcc4f364c,
  0xff780b0e, 0xc9309d37, 0xa4a65b5c, 0x80000000,
  0xfef90e08, 0x95fed069, 0x80000000, 0x80000000,
  0xfe7a1004, 0x80000000, 0x80000000, 0x80000000,
  0xfdfb1102, 0x80000000, 0x80000000, 0x80000000,
  0xfe7a1102, 0xb3330000, 0xd5550000, 0xfffd0000,
  0xfef91004, 0xe665999a, 0x2aa95556, 0x7ff90006,
  0xffcd3366, 0xeb8547af, 0xddde2224, 0xccce3352,
  0xff788910, 0xc96369d1, 0xa4fb05b2, 0x80000000,
  0xfef98c0a, 0x96319d03, 0x80000000, 0x80000000,
  0xfe7a8e06, 0x80000000, 0x80000000, 0x80000000,
  0xfdfb8f04, 0x80000000, 0x80000000, 0x80000000,
  0xfe7a8f04, 0xb3330000, 0xd5550000, 0xfffd0000,
  0xfef98e06, 0xe665999a, 0x2aa95556, 0x7ff90006,
  0xff4e395a, 0x0887ddde, 0x638d1c72, 0x7fffffff,
  0xffab55aa, 0xddde2223, 0xc71ce390, 0xaaad001e,
  0xff2c58a4, 0xaaac5555, 0x80000000, 0x80000000,
  0xfead5aa0, 0x80000000, 0x80000000, 0x80000000,
  0xfe2e5b9e, 0x80000000, 0x80000000, 0x80000000,
  0xfead5b9e, 0xb3330000, 0xd5550000, 0xfffd0000,
  0xff2c5aa0, 0xe665999a, 0x2aa95556, 0x7ff90006,
  0xff8105f4, 0x0887ddde, 0x638d1c72, 0x7fffffff,
  0xffb3d38c, 0x1d02fc96, 0x7fffffff, 0x7fffffff,
  0xff8102fa, 0xccce3333, 0xaaad0000, 0x8006000e,
  0xff0204f6, 0x999bffff, 0x80000000, 0x80000000,
  0xfe8305f4, 0x80000000, 0x80000000, 0x80000000,
  0xff0205f4, 0xb3330000, 0xd5550000, 0xfffd0000,
  0xff8104f6, 0xe665999a, 0x2aa95556, 0x7ff90006,
  0xffd5b04a, 0x0887ddde, 0x638d1c72, 0x7fffffff,
  0x00087de2, 0x1d02fc96, 0x7fffffff, 0x7fffffff,
  0x0008fce2, 0x1d362f96, 0x7fffffff, 0x7fffffff,
  0xff8101fc, 0xcccdcccd, 0xaaac5556, 0x80050014,
  0xff0202fa, 0x999b3333, 0x80000000, 0x80000000,
  0xff8102fa, 0xccce3333, 0xd5550000, 0xfffd0000,
  0x000001fc, 0x0000cccd, 0x2aa95556, 0x7ff90006,
  0x0054ad50, 0x22231111, 0x638d1c72, 0x7fffffff,
  0x00877ae8, 0x369e2fc9, 0x7fffffff, 0x7fffffff,
  0x0087f9e8, 0x36d162c9, 0x7fffffff, 0x7fffffff,
  0x008877ea, 0x37042f63, 0x7fffffff, 0x7fffffff,
  0xff8100fe, 0xcccd6667, 0xaaabaaac, 0x8004001a,
  0x000000fe, 0x00006667, 0x0000aaac, 0x0001001a,
  0x007f0000, 0x33330001, 0x55550002, 0x7ffd0020,
  0x00d3ab54, 0x55554445, 0x7fffffff, 0x7fffffff,
  0x010678ec, 0x69d062fd, 0x7fffffff, 0x7fffffff,
  0x0106f7ec, 0x6a0395fd, 0x7fffffff, 0x7fffffff,
  0x010775ee, 0x6a366297, 0x7fffffff, 0x7fffffff,
  0x0107f2f2, 0x6a68c8cb, 0x7fffffff, 0x7fffffff,
  0x007f0000, 0x33330001, 0x55550002, 0x7ffd0020,
  0x00fdff02, 0x6665999b, 0x7fffffff, 0x7fffffff,
  0x0152aa56, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x018577ee, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x0185f6ee, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x018674f0, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x0186f1f4, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x01876dfa, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x007eff02, 0x3332999b, 0x55545558, 0x7ffc0026,
  0x00d3aa56, 0x5554dddf, 0x7fffffff, 0x7fffffff,
  0x010677ee, 0x69cffc97, 0x7fffffff, 0x7fffffff,
  0x0106f6ee, 0x6a032f97, 0x7fffffff, 0x7fffffff,
  0x010774f0, 0x6a35fc31, 0x7fffffff, 0x7fffffff,
  0x0107f1f4, 0x6a686265, 0x7fffffff, 0x7fffffff,
  0x01086dfa, 0x6a9a6233, 0x7fffffff, 0x7fffffff,
  0x01087dda, 0x6aa0c893, 0x7fffffff, 0x7fffffff,
  0x0054ab54, 0x22224445, 0x38e3c71e, 0x5554001c,
  0x008778ec, 0x369d62fd, 0x5b064fa6, 0x7fffffff,
  0x0087f7ec, 0x36d095fd, 0x5b5ba4a6, 0x7fffffff,
  0x008875ee, 0x37036297, 0x5bb04efc, 0x7fffffff,
  0x0088f2f2, 0x3735c8cb, 0x5c044ea8, 0x7fffffff,
  0x00896ef8, 0x3767c899, 0x5c57a3aa, 0x7fffffff,
  0x00897ed8, 0x376e2ef9, 0x5c624e4a, 0x7fffffff,
  0x008981d2, 0x376f622b, 0x5c644e48, 0x7fffffff,
  0x0032cd98, 0x147b1eb9, 0x2222888a, 0x3332cce8,
  0x00334c98, 0x14ae51b9, 0x2277dd8a, 0x33b2c9e8,
  0x0033ca9a, 0x14e11e53, 0x22cc87e0, 0x3431c6ee,
  0x0034479e, 0x15138487, 0x2320878c, 0x34afc3fa,
  0x0034c3a4, 0x15458455, 0x2373dc8e, 0x352cc10c,
  0x0034d384, 0x154beab5, 0x237e872e, 0x353cc0ac,
  0x0034d67e, 0x154d1de7, 0x2380872c, 0x353fc09a,
  0x0034d87a, 0x154deab3, 0x2381dc80, 0x3541c08e,
  0x00007f00, 0x00333301, 0x00555502, 0x007ffd20,
  0x0000fd02, 0x0065ff9b, 0x00a9ff58, 0x00fefa26,
  0x00017a06, 0x009865cf, 0x00fdff04, 0x017cf732,
  0x0001f60c, 0x00ca659d, 0x01515406, 0x01f9f444,
  0x000205ec, 0x00d0cbfd, 0x015bfea6, 0x0209f3e4,
  0x000208e6, 0x00d1ff2f, 0x015dfea4, 0x020cf3d2,
  0x00020ae2, 0x00d2cbfb, 0x015f53f8, 0x020ef3c6,
  0x00020be0, 0x00d33261, 0x015ffea2, 0x020ff3c0,
  0x0032cc9a, 0x0054aa57, 0x007efd08, 0x007efe24,
  0x006532ce, 0x00a8aa03, 0x00fcfa14, 0x00fcfc2c,
  0x0097329c, 0x00fbff05, 0x0179f726, 0x0179fa38,
  0x009d98fc, 0x0106a9a5, 0x0189f6c6, 0x0189f9f8,
  0x009ecc2e, 0x0108a9a3, 0x018cf6b4, 0x018cf9ec,
  0x009f98fa, 0x0109fef7, 0x018ef6a8, 0x018ef9e4,
  0x009fff60, 0x010aa9a1, 0x018ff6a2, 0x018ff9e0,
  0x009fff60, 0x010aa9a1, 0x018ff6a2, 0x018ff9e0,
  0x00326634, 0x0053ffad, 0x007dfd0e, 0x007dfe28,
  0x00646602, 0x00a754af, 0x00fafa20, 0x00fafc34,
  0x006acc62, 0x00b1ff4f, 0x010af9c0, 0x010afbf4,
  0x006bff94, 0x00b3ff4d, 0x010df9ae, 0x010dfbe8,
  0x006ccc60, 0x00b554a1, 0x010ff9a2, 0x010ffbe0,
  0x006d32c6, 0x00b5ff4b, 0x0110f99c, 0x0110fbdc,
  0x006d32c6, 0x00b5ff4b, 0x0110f99c, 0x0110fbdc,
  0x006ccc60, 0x00b554a1, 0x010ff9a2, 0x010ffbe0,
  0x0031ffce, 0x00535503, 0x007cfd14, 0x007cfe2c,
  0x0038662e, 0x005dffa3, 0x008cfcb4, 0x008cfdec,
  0x00399960, 0x005fffa1, 0x008ffca2, 0x008ffde0,
  0x003a662c, 0x006154f5, 0x0091fc96, 0x0091fdd8,
  0x003acc92, 0x0061ff9f, 0x0092fc90, 0x0092fdd4,
  0x003acc92, 0x0061ff9f, 0x0092fc90, 0x0092fdd4,
  0x003a662c, 0x006154f5, 0x0091fc96, 0x0091fdd8,
  0x00399960, 0x005fffa1, 0x008ffca2, 0x008ffde0,
  0x00066660, 0x000aaaa1, 0x000fffa2, 0x000fffe0,
  0x00079992, 0x000caa9f, 0x0012ff90, 0x0012ffd4,
  0x0008665e, 0x000dfff3, 0x0014ff84, 0x0014ffcc,
  0x0008ccc4, 0x000eaa9d, 0x0015ff7e, 0x0015ffc8,
  0x0008ccc4, 0x000eaa9d, 0x0015ff7e, 0x0015ffc8,
  0x0008665e, 0x000dfff3, 0x0014ff84, 0x0014ffcc,
  0x00079992, 0x000caa9f, 0x0012ff90, 0x0012ffd4,
  0x00013332, 0x0001ffff, 0x0002fff0, 0x00030014,
  0x00013332, 0x0001ffff, 0x0002fff0, 0x00030014,
  0x0001fffe, 0x00035553, 0x0004ffe4, 0x0005000c,
  0x00026664, 0x0003fffd, 0x0005ffde, 0x00060008,
  0x00026664, 0x0003fffd, 0x0005ffde, 0x00060008,
  0x0001fffe, 0x00035553, 0x0004ffe4, 0x0005000c,
  0x00013332, 0x0001ffff, 0x0002fff0, 0x00030014,
  0xfffaccd2, 0xfff7555f, 0xfff30050, 0xfff30054,
  0xffc8cd04, 0xffa4005d, 0xff76033e, 0xff760248,
  0x0000cccc, 0x00015555, 0x0001fff6, 0x00020018,
  0x00013332, 0x0001ffff, 0x0002fff0, 0x00030014,
  0x00013332, 0x0001ffff, 0x0002fff0, 0x00030014,
  0x0000cccc, 0x00015555, 0x0001fff6, 0x00020018,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfff999a0, 0xfff55561, 0xfff00062, 0xfff00060,
  0xffc799d2, 0xffa2005f, 0xff730350, 0xff730254,
  0xff95339e, 0xff4e00b3, 0xfef50644, 0xfef5044c,
  0x00006666, 0x0000aaab, 0x0000fffc, 0x0001001c,
  0x00006666, 0x0000aaab, 0x0000fffc, 0x0001001c,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff3334, 0xfffeaaad, 0xfffe000e, 0xfffe0028,
  0xfff8ccd4, 0xfff4000d, 0xffee006e, 0xffee0068,
  0xffc6cd06, 0xffa0ab0b, 0xff71035c, 0xff71025c,
  0xff9466d2, 0xff4cab5f, 0xfef30650, 0xfef30454,
  0xff619a38, 0xfef80109, 0xfe74094a, 0xfe740650,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff999a, 0xffff5557, 0xffff0008, 0xffff0024,
  0xfffeccce, 0xfffe0003, 0xfffd0014, 0xfffd002c,
  0xfff8666e, 0xfff35563, 0xffed0074, 0xffed006c,
  0xffc666a0, 0xffa00061, 0xff700362, 0xff700260,
  0xff94006c, 0xff4c00b5, 0xfef20656, 0xfef20458,
  0xff6133d2, 0xfef7565f, 0xfe730950, 0xfe730654,
  0xeae67b80, 0xdcd57881, 0xcb413c82, 0xcb40d320,
  0xffff999a, 0xffff5557, 0xffff0008, 0xffff0024,
  0xfffeccce, 0xfffe0003, 0xfffd0014, 0xfffd002c,
  0xfff8666e, 0xfff35563, 0xffed0074, 0xffed006c,
  0xffc666a0, 0xffa00061, 0xff700362, 0xff700260,
  0xff94006c, 0xff4c00b5, 0xfef20656, 0xfef20458,
  0xff6133d2, 0xfef7565f, 0xfe730950, 0xfe730654,
  0xeae67b80, 0xdcd57881, 0xcb413c82, 0xcb40d320,
  0xc8c49da2, 0xa3f25c0f, 0x80000000, 0x80000000,
  0xffff3334, 0xfffeaaad, 0xfffe000e, 0xfffe0028,
  0xfff8ccd4, 0xfff4000d, 0xffee006e, 0xffee0068,
  0xffc6cd06, 0xffa0ab0b, 0xff71035c, 0xff71025c,
  0xff9466d2, 0xff4cab5f, 0xfef30650, 0xfef30454,
  0xff619a38, 0xfef80109, 0xfe74094a, 0xfe740650,
  0xeae6e1e6, 0xdcd6232b, 0xcb423c7c, 0xcb41d31c,
  0xc8c50408, 0xa3f306b9, 0x80000000, 0x80000000,
  0x9593373a, 0x80000000, 0x80000000, 0x80000000,
  0xfff999a0, 0xfff55561, 0xfff00062, 0xfff00060,
  0xffc799d2, 0xffa2005f, 0xff730350, 0xff730254,
  0xff95339e, 0xff4e00b3, 0xfef50644, 0xfef5044c,
  0xff626704, 0xfef9565d, 0xfe76093e, 0xfe760648,
  0xeae7aeb2, 0xdcd7787f, 0xcb443c70, 0xcb43d314,
  0xc8c5d0d4, 0xa3f45c0d, 0x80000000, 0x80000000,
  0x95940406, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xffce0032, 0xffacaaff, 0xff8302f0, 0xff830214,
  0xff9b99fe, 0xff58ab53, 0xff0505e4, 0xff05040c,
  0xff68cd64, 0xff0400fd, 0xfe8608de, 0xfe860608,
  0xeaee1512, 0xdce2231f, 0xcb543c10, 0xcb53d2d4,
  0xc8cc3734, 0xa3ff06ad, 0x80000000, 0x80000000,
  0x959a6a66, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xffcd99cc, 0xffac0055, 0xff8202f6, 0xff820218,
  0xff9acd32, 0xff5755ff, 0xff0305f0, 0xff030414,
  0xeb2014e0, 0xdd357821, 0xcbd13922, 0xcbd0d0e0,
  0xc8fe3702, 0xa4525baf, 0x80000000, 0x80000000,
  0x95cc6a34, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xb3330000, 0xd5550000, 0xfffd0000, 0xfffe0000,
  0xffcd3366, 0xffab55ab, 0xff8102fc, 0xff81021c,
  0xeb527b14, 0xdd8977cd, 0xcc4f362e, 0xcc4ecee8,
  0xc9309d36, 0xa4a65b5b, 0x80000000, 0x80000000,
  0x95fed068, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xb3330000, 0xd5550000, 0xfffd0000, 0xfffe0000,
  0xe665999a, 0x2aa95556, 0x7ff90006, 0x7ffb0004,
  0xeb8547ae, 0xddde2223, 0xccce3334, 0xcccdccec,
  0xc96369d0, 0xa4fb05b1, 0x80000000, 0x80000000,
  0x96319d02, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xb3330000, 0xd5550000, 0xfffd0000, 0xfffe0000,
  0xe665999a, 0x2aa95556, 0x7ff90006, 0x7ffb0004,
  0x0887ddde, 0x638d1c72, 0x7fffffff, 0x7fffffff,
  0xddde2222, 0xc71ce38f, 0xaaad0000, 0xaaac5574,
  0xaaac5554, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xb3330000, 0xd5550000, 0xfffd0000, 0xfffe0000,
  0xe665999a, 0x2aa95556, 0x7ff90006, 0x7ffb0004,
  0x0887ddde, 0x638d1c72, 0x7fffffff, 0x7fffffff,
  0x1d02fc96, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0xccce3332, 0xaaacffff, 0x8005fff0, 0x80050014,
  0x999bfffe, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xb3330000, 0xd5550000, 0xfffd0000, 0xfffe0000,
  0xe665999a, 0x2aa95556, 0x7ff90006, 0x7ffb0004,
  0x0887ddde, 0x638d1c72, 0x7fffffff, 0x7fffffff,
  0x1d02fc96, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x1d362f96, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0xcccdcccc, 0xaaac5555, 0x8004fff6, 0x80040018,
  0x999b3332, 0x80000000, 0x80000000, 0x80000000,
  0xccce3332, 0xd5550000, 0xfffd0000, 0xfffe0000,
  0x0000cccc, 0x2aa95556, 0x7ff90006, 0x7ffb0004,
  0x22231110, 0x638d1c72, 0x7fffffff, 0x7fffffff,
  0x369e2fc8, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x36d162c8, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x37042f62, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0xcccd6666, 0xaaabaaab, 0x8003fffc, 0x8003001c,
  0x00006666, 0x0000aaab, 0x0000fffc, 0x0001001c,
  0x33330000, 0x55550001, 0x7ffd0002, 0x7ffe0020,
  0x55554444, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x69d062fc, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x6a0395fc, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x6a366296, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x6a68c8ca, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x33330000, 0x55550001, 0x7ffd0002, 0x7ffe0020,
  0x6665999a, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x3332999a, 0x55545557, 0x7ffc0008, 0x7ffd0024,
  0x5554ddde, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x69cffc96, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x6a032f96, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x6a35fc30, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x6a686264, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x6a9a6232, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x6aa0c892, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x22224444, 0x38e3c71d, 0x5553fffe, 0x5554aac8,
  0x369d62fc, 0x5b064fa5, 0x7fffffff, 0x7fffffff,
  0x36d095fc, 0x5b5ba4a5, 0x7fffffff, 0x7fffffff,
  0x37036296, 0x5bb04efb, 0x7fffffff, 0x7fffffff,
  0x3735c8ca, 0x5c044ea7, 0x7fffffff, 0x7fffffff,
  0x3767c898, 0x5c57a3a9, 0x7fffffff, 0x7fffffff,
  0x376e2ef8, 0x5c624e49, 0x7fffffff, 0x7fffffff,
  0x376f622a, 0x5c644e47, 0x7fffffff, 0x7fffffff,
  0x147b1eb8, 0x22228889, 0x3332ccca, 0x33333350,
  0x14ae51b8, 0x2277dd89, 0x33b2c9ca, 0x33b33150,
  0x14e11e52, 0x22cc87df, 0x3431c6d0, 0x34322f54,
  0x15138486, 0x2320878b, 0x34afc3dc, 0x34b02d5c,
  0x15458454, 0x2373dc8d, 0x352cc0ee, 0x352d2b68,
  0x154beab4, 0x237e872d, 0x353cc08e, 0x353d2b28,
  0x154d1de6, 0x2380872b, 0x353fc07c, 0x35402b1c,
  0x154deab2, 0x2381dc7f, 0x3541c070, 0x35422b14,
  0x00333300, 0x00555501, 0x007ffd02, 0x007ffe20,
  0x0065ff9a, 0x00a9ff57, 0x00fefa08, 0x00fefc24,
  0x009865ce, 0x00fdff03, 0x017cf714, 0x017cfa2c,
  0x00ca659c, 0x01515405, 0x01f9f426, 0x01f9f838,
  0x00d0cbfc, 0x015bfea5, 0x0209f3c6, 0x0209f7f8,
  0x00d1ff2e, 0x015dfea3, 0x020cf3b4, 0x020cf7ec,
  0x00d2cbfa, 0x015f53f7, 0x020ef3a8, 0x020ef7e4,
  0x00d33260, 0x015ffea1, 0x020ff3a2, 0x020ff7e0,
  0x0054aa56, 0x007efd07, 0x007efe06, 0x007eff22,
  0x00a8aa02, 0x00fcfa13, 0x00fcfc0e, 0x00fcfe26,
  0x00fbff04, 0x0179f725, 0x0179fa1a, 0x0179fd2c,
  0x0106a9a4, 0x0189f6c5, 0x0189f9da, 0x0189fd0c,
  0x0108a9a2, 0x018cf6b3, 0x018cf9ce, 0x018cfd06,
  0x0109fef6, 0x018ef6a7, 0x018ef9c6, 0x018efd02,
  0x010aa9a0, 0x018ff6a1, 0x018ff9c2, 0x018ffd00,
  0x010aa9a0, 0x018ff6a1, 0x018ff9c2, 0x018ffd00,
  0x0053ffac, 0x007dfd0d, 0x007dfe0a, 0x007dff24,
  0x00a754ae, 0x00fafa1f, 0x00fafc16, 0x00fafe2a,
  0x00b1ff4e, 0x010af9bf, 0x010afbd6, 0x010afe0a,
  0x00b3ff4c, 0x010df9ad, 0x010dfbca, 0x010dfe04,
  0x00b554a0, 0x010ff9a1, 0x010ffbc2, 0x010ffe00,
  0x00b5ff4a, 0x0110f99b, 0x0110fbbe, 0x0110fdfe,
  0x00b5ff4a, 0x0110f99b, 0x0110fbbe, 0x0110fdfe,
  0x00b554a0, 0x010ff9a1, 0x010ffbc2, 0x010ffe00,
  0x00535502, 0x007cfd13, 0x007cfe0e, 0x007cff26,
  0x005dffa2, 0x008cfcb3, 0x008cfdce, 0x008cff06,
  0x005fffa0, 0x008ffca1, 0x008ffdc2, 0x008fff00,
  0x006154f4, 0x0091fc95, 0x0091fdba, 0x0091fefc,
  0x0061ff9e, 0x0092fc8f, 0x0092fdb6, 0x0092fefa,
  0x0061ff9e, 0x0092fc8f, 0x0092fdb6, 0x0092fefa,
  0x006154f4, 0x0091fc95, 0x0091fdba, 0x0091fefc,
  0x005fffa0, 0x008ffca1, 0x008ffdc2, 0x008fff00,
  0x000aaaa0, 0x000fffa1, 0x000fffc2, 0x00100000,
  0x000caa9e, 0x0012ff8f, 0x0012ffb6, 0x0012fffa,
  0x000dfff2, 0x0014ff83, 0x0014ffae, 0x0014fff6,
  0x000eaa9c, 0x0015ff7d, 0x0015ffaa, 0x0015fff4,
  0x000eaa9c, 0x0015ff7d, 0x0015ffaa, 0x0015fff4,
  0x000dfff2, 0x0014ff83, 0x0014ffae, 0x0014fff6,
  0x000caa9e, 0x0012ff8f, 0x0012ffb6, 0x0012fffa,
  0x0001fffe, 0x0002ffef, 0x0002fff6, 0x0003001a,
  0x0001fffe, 0x0002ffef, 0x0002fff6, 0x0003001a,
  0x00035552, 0x0004ffe3, 0x0004ffee, 0x00050016,
  0x0003fffc, 0x0005ffdd, 0x0005ffea, 0x00060014,
  0x0003fffc, 0x0005ffdd, 0x0005ffea, 0x00060014,
  0x00035552, 0x0004ffe3, 0x0004ffee, 0x00050016,
  0x0001fffe, 0x0002ffef, 0x0002fff6, 0x0003001a,
  0xfff7555e, 0xfff3004f, 0xfff30036, 0xfff3003a,
  0xffa4005c, 0xff76033d, 0xff76022a, 0xff760134,
  0x00015554, 0x0001fff5, 0x0001fffa, 0x0002001c,
  0x0001fffe, 0x0002ffef, 0x0002fff6, 0x0003001a,
  0x0001fffe, 0x0002ffef, 0x0002fff6, 0x0003001a,
  0x00015554, 0x0001fff5, 0x0001fffa, 0x0002001c,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfff55560, 0xfff00061, 0xfff00042, 0xfff00040,
  0xffa2005e, 0xff73034f, 0xff730236, 0xff73013a,
  0xff4e00b2, 0xfef50643, 0xfef5042e, 0xfef50236,
  0x0000aaaa, 0x0000fffb, 0x0000fffe, 0x0001001e,
  0x0000aaaa, 0x0000fffb, 0x0000fffe, 0x0001001e,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffeaaac, 0xfffe000d, 0xfffe000a, 0xfffe0024,
  0xfff4000c, 0xffee006d, 0xffee004a, 0xffee0044,
  0xffa0ab0a, 0xff71035b, 0xff71023e, 0xff71013e,
  0xff4cab5e, 0xfef3064f, 0xfef30436, 0xfef3023a,
  0xfef80108, 0xfe740949, 0xfe740632, 0xfe740338,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff5556, 0xffff0007, 0xffff0006, 0xffff0022,
  0xfffe0002, 0xfffd0013, 0xfffd000e, 0xfffd0026,
  0xfff35562, 0xffed0073, 0xffed004e, 0xffed0046,
  0xffa00060, 0xff700361, 0xff700242, 0xff700140,
  0xff4c00b4, 0xfef20655, 0xfef2043a, 0xfef2023c,
  0xfef7565e, 0xfe73094f, 0xfe730636, 0xfe73033a,
  0xdcd57880, 0xcb413c81, 0xcb40d302, 0xcb4069a0,
  0xffff5556, 0xffff0007, 0xffff0006, 0xffff0022,
  0xfffe0002, 0xfffd0013, 0xfffd000e, 0xfffd0026,
  0xfff35562, 0xffed0073, 0xffed004e, 0xffed0046,
  0xffa00060, 0xff700361, 0xff700242, 0xff700140,
  0xff4c00b4, 0xfef20655, 0xfef2043a, 0xfef2023c,
  0xfef7565e, 0xfe73094f, 0xfe730636, 0xfe73033a,
  0xdcd57880, 0xcb413c81, 0xcb40d302, 0xcb4069a0,
  0xa3f25c0e, 0x80000000, 0x80000000, 0x80000000,
  0xfffeaaac, 0xfffe000d, 0xfffe000a, 0xfffe0024,
  0xfff4000c, 0xffee006d, 0xffee004a, 0xffee0044,
  0xffa0ab0a, 0xff71035b, 0xff71023e, 0xff71013e,
  0xff4cab5e, 0xfef3064f, 0xfef30436, 0xfef3023a,
  0xfef80108, 0xfe740949, 0xfe740632, 0xfe740338,
  0xdcd6232a, 0xcb423c7b, 0xcb41d2fe, 0xcb41699e,
  0xa3f306b8, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xfff55560, 0xfff00061, 0xfff00042, 0xfff00040,
  0xffa2005e, 0xff73034f, 0xff730236, 0xff73013a,
  0xff4e00b2, 0xfef50643, 0xfef5042e, 0xfef50236,
  0xfef9565c, 0xfe76093d, 0xfe76062a, 0xfe760334,
  0xdcd7787e, 0xcb443c6f, 0xcb43d2f6, 0xcb43699a,
  0xa3f45c0c, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xffacaafe, 0xff8302ef, 0xff8301f6, 0xff83011a,
  0xff58ab52, 0xff0505e3, 0xff0503ee, 0xff050216,
  0xff0400fc, 0xfe8608dd, 0xfe8605ea, 0xfe860314,
  0xdce2231e, 0xcb543c0f, 0xcb53d2b6, 0xcb53697a,
  0xa3ff06ac, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xffac0054, 0xff8202f5, 0xff8201fa, 0xff82011c,
  0xff5755fe, 0xff0305ef, 0xff0303f6, 0xff03021a,
  0xdd357820, 0xcbd13921, 0xcbd0d0c2, 0xcbd06880,
  0xa4525bae, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xd5550000, 0xfffd0000, 0xfffe0000, 0xffff0000,
  0xffab55aa, 0xff8102fb, 0xff8101fe, 0xff81011e,
  0xdd8977cc, 0xcc4f362d, 0xcc4ececa, 0xcc4e6784,
  0xa4a65b5a, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xd5550000, 0xfffd0000, 0xfffe0000, 0xffff0000,
  0x2aa95556, 0x7ff90006, 0x7ffb0004, 0x7ffd0002,
  0xddde2222, 0xccce3333, 0xcccdccce, 0xcccd6686,
  0xa4fb05b0, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xd5550000, 0xfffd0000, 0xfffe0000, 0xffff0000,
  0x2aa95556, 0x7ff90006, 0x7ffb0004, 0x7ffd0002,
  0x638d1c72, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0xc71ce38e, 0xaaacffff, 0xaaac5556, 0xaaabaaca,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xd5550000, 0xfffd0000, 0xfffe0000, 0xffff0000,
  0x2aa95556, 0x7ff90006, 0x7ffb0004, 0x7ffd0002,
  0x638d1c72, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0xaaacfffe, 0x8005ffef, 0x8004fff6, 0x8004001a,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xd5550000, 0xfffd0000, 0xfffe0000, 0xffff0000,
  0x2aa95556, 0x7ff90006, 0x7ffb0004, 0x7ffd0002,
  0x638d1c72, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0xaaac5554, 0x8004fff5, 0x8003fffa, 0x8003001c,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0xd5550000, 0xfffd0000, 0xfffe0000, 0xffff0000,
  0x2aa95556, 0x7ff90006, 0x7ffb0004, 0x7ffd0002,
  0x638d1c72, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0xaaabaaaa, 0x8003fffb, 0x8002fffe, 0x8002001e,
  0x0000aaaa, 0x0000fffb, 0x0000fffe, 0x0001001e,
  0x55550000, 0x7ffd0001, 0x7ffe0002, 0x7fff0020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x55550000, 0x7ffd0001, 0x7ffe0002, 0x7fff0020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x55545556, 0x7ffc0007, 0x7ffd0006, 0x7ffe0022,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x38e3c71c, 0x5553fffd, 0x5554aaaa, 0x55555574,
  0x5b064fa4, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x5b5ba4a4, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x5bb04efa, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x5c044ea6, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x5c57a3a8, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x5c624e48, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x5c644e46, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x22228888, 0x3332ccc9, 0x33333332, 0x333399b8,
  0x2277dd88, 0x33b2c9c9, 0x33b33132, 0x33b398b8,
  0x22cc87de, 0x3431c6cf, 0x34322f36, 0x343297ba,
  0x2320878a, 0x34afc3db, 0x34b02d3e, 0x34b096be,
  0x2373dc8c, 0x352cc0ed, 0x352d2b4a, 0x352d95c4,
  0x237e872c, 0x353cc08d, 0x353d2b0a, 0x353d95a4,
  0x2380872a, 0x353fc07b, 0x35402afe, 0x3540959e,
  0x2381dc7e, 0x3541c06f, 0x35422af6, 0x3542959a,
  0x00555500, 0x007ffd01, 0x007ffe02, 0x007fff20,
  0x00a9ff56, 0x00fefa07, 0x00fefc06, 0x00fefe22,
  0x00fdff02, 0x017cf713, 0x017cfa0e, 0x017cfd26,
  0x01515404, 0x01f9f425, 0x01f9f81a, 0x01f9fc2c,
  0x015bfea4, 0x0209f3c5, 0x0209f7da, 0x0209fc0c,
  0x015dfea2, 0x020cf3b3, 0x020cf7ce, 0x020cfc06,
  0x015f53f6, 0x020ef3a7, 0x020ef7c6, 0x020efc02,
  0x015ffea0, 0x020ff3a1, 0x020ff7c2, 0x020ffc00,
  0x007efd06, 0x007efe05, 0x007eff04, 0xff810020,
  0x00fcfa12, 0x00fcfc0d, 0x00fcfe08, 0xff030020,
  0x0179f724, 0x0179fa19, 0x0179fd0e, 0xfe860020,
  0x0189f6c4, 0x0189f9d9, 0x0189fcee, 0xfe760020,
  0x018cf6b2, 0x018cf9cd, 0x018cfce8, 0xfe730020,
  0x018ef6a6, 0x018ef9c5, 0x018efce4, 0xfe710020,
  0x018ff6a0, 0x018ff9c1, 0x018ffce2, 0xfe700020,
  0x018ff6a0, 0x018ff9c1, 0x018ffce2, 0xfe700020,
  0x007dfd0c, 0x007dfe09, 0x007dff06, 0xff820020,
  0x00fafa1e, 0x00fafc15, 0x00fafe0c, 0xff050020,
  0x010af9be, 0x010afbd5, 0x010afdec, 0xfef50020,
  0x010df9ac, 0x010dfbc9, 0x010dfde6, 0xfef20020,
  0x010ff9a0, 0x010ffbc1, 0x010ffde2, 0xfef00020,
  0x0110f99a, 0x0110fbbd, 0x0110fde0, 0xfeef0020,
  0x0110f99a, 0x0110fbbd, 0x0110fde0, 0xfeef0020,
  0x010ff9a0, 0x010ffbc1, 0x010ffde2, 0xfef00020,
  0x007cfd12, 0x007cfe0d, 0x007cff08, 0xff830020,
  0x008cfcb2, 0x008cfdcd, 0x008cfee8, 0xff730020,
  0x008ffca0, 0x008ffdc1, 0x008ffee2, 0xff700020,
  0x0091fc94, 0x0091fdb9, 0x0091fede, 0xff6e0020,
  0x0092fc8e, 0x0092fdb5, 0x0092fedc, 0xff6d0020,
  0x0092fc8e, 0x0092fdb5, 0x0092fedc, 0xff6d0020,
  0x0091fc94, 0x0091fdb9, 0x0091fede, 0xff6e0020,
  0x008ffca0, 0x008ffdc1, 0x008ffee2, 0xff700020,
  0x000fffa0, 0x000fffc1, 0x000fffe2, 0xfff00020,
  0x0012ff8e, 0x0012ffb5, 0x0012ffdc, 0xffed0020,
  0x0014ff82, 0x0014ffad, 0x0014ffd8, 0xffeb0020,
  0x0015ff7c, 0x0015ffa9, 0x0015ffd6, 0xffea0020,
  0x0015ff7c, 0x0015ffa9, 0x0015ffd6, 0xffea0020,
  0x0014ff82, 0x0014ffad, 0x0014ffd8, 0xffeb0020,
  0x0012ff8e, 0x0012ffb5, 0x0012ffdc, 0xffed0020,
  0x0002ffee, 0x0002fff5, 0x0002fffc, 0xfffd0020,
  0x0002ffee, 0x0002fff5, 0x0002fffc, 0xfffd0020,
  0x0004ffe2, 0x0004ffed, 0x0004fff8, 0xfffb0020,
  0x0005ffdc, 0x0005ffe9, 0x0005fff6, 0xfffa0020,
  0x0005ffdc, 0x0005ffe9, 0x0005fff6, 0xfffa0020,
  0x0004ffe2, 0x0004ffed, 0x0004fff8, 0xfffb0020,
  0x0002ffee, 0x0002fff5, 0x0002fffc, 0xfffd0020,
  0xfff3004e, 0xfff30035, 0xfff3001c, 0x000d0020,
  0xff76033c, 0xff760229, 0xff760116, 0x008a0020,
  0x0001fff4, 0x0001fff9, 0x0001fffe, 0xfffe0020,
  0x0002ffee, 0x0002fff5, 0x0002fffc, 0xfffd0020,
  0x0002ffee, 0x0002fff5, 0x0002fffc, 0xfffd0020,
  0x0001fff4, 0x0001fff9, 0x0001fffe, 0xfffe0020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfff00060, 0xfff00041, 0xfff00022, 0x00100020,
  0xff73034e, 0xff730235, 0xff73011c, 0x008d0020,
  0xfef50642, 0xfef5042d, 0xfef50218, 0x010b0020,
  0x0000fffa, 0x0000fffd, 0x00010000, 0xffff0020,
  0x0000fffa, 0x0000fffd, 0x00010000, 0xffff0020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffe000c, 0xfffe0009, 0xfffe0006, 0x00020020,
  0xffee006c, 0xffee0049, 0xffee0026, 0x00120020,
  0xff71035a, 0xff71023d, 0xff710120, 0x008f0020,
  0xfef3064e, 0xfef30435, 0xfef3021c, 0x010d0020,
  0xfe740948, 0xfe740631, 0xfe74031a, 0x018c0020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff0006, 0xffff0005, 0xffff0004, 0x00010020,
  0xfffd0012, 0xfffd000d, 0xfffd0008, 0x00030020,
  0xffed0072, 0xffed004d, 0xffed0028, 0x00130020,
  0xff700360, 0xff700241, 0xff700122, 0x00900020,
  0xfef20654, 0xfef20439, 0xfef2021e, 0x010e0020,
  0xfe73094e, 0xfe730635, 0xfe73031c, 0x018d0020,
  0xcb413c80, 0xcb40d301, 0xcb406982, 0x34c00020,
  0xffff0006, 0xffff0005, 0xffff0004, 0x00010020,
  0xfffd0012, 0xfffd000d, 0xfffd0008, 0x00030020,
  0xffed0072, 0xffed004d, 0xffed0028, 0x00130020,
  0xff700360, 0xff700241, 0xff700122, 0x00900020,
  0xfef20654, 0xfef20439, 0xfef2021e, 0x010e0020,
  0xfe73094e, 0xfe730635, 0xfe73031c, 0x018d0020,
  0xcb413c80, 0xcb40d301, 0xcb406982, 0x34c00020,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0xfffe000c, 0xfffe0009, 0xfffe0006, 0x00020020,
  0xffee006c, 0xffee0049, 0xffee0026, 0x00120020,
  0xff71035a, 0xff71023d, 0xff710120, 0x008f0020,
  0xfef3064e, 0xfef30435, 0xfef3021c, 0x010d0020,
  0xfe740948, 0xfe740631, 0xfe74031a, 0x018c0020,
  0xcb423c7a, 0xcb41d2fd, 0xcb416980, 0x34bf0020,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0xfff00060, 0xfff00041, 0xfff00022, 0x00100020,
  0xff73034e, 0xff730235, 0xff73011c, 0x008d0020,
  0xfef50642, 0xfef5042d, 0xfef50218, 0x010b0020,
  0xfe76093c, 0xfe760629, 0xfe760316, 0x018a0020,
  0xcb443c6e, 0xcb43d2f5, 0xcb43697c, 0x34bd0020,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0xff8302ee, 0xff8301f5, 0xff8300fc, 0x007d0020,
  0xff0505e2, 0xff0503ed, 0xff0501f8, 0x00fb0020,
  0xfe8608dc, 0xfe8605e9, 0xfe8602f6, 0x017a0020,
  0xcb543c0e, 0xcb53d2b5, 0xcb53695c, 0x34ad0020,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0xff8202f4, 0xff8201f9, 0xff8200fe, 0x007e0020,
  0xff0305ee, 0xff0303f5, 0xff0301fc, 0x00fd0020,
  0xcbd13920, 0xcbd0d0c1, 0xcbd06862, 0x34300020,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0xfffd0000, 0xfffe0000, 0xffff0000, 0x00000000,
  0xff8102fa, 0xff8101fd, 0xff810100, 0x007f0020,
  0xcc4f362c, 0xcc4ecec9, 0xcc4e6766, 0x33b20020,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0xfffd0000, 0xfffe0000, 0xffff0000, 0x00000000,
  0x7ff90006, 0x7ffb0004, 0x7ffd0002, 0x80010000,
  0xccce3332, 0xcccdcccd, 0xcccd6668, 0x33330020,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0xfffd0000, 0xfffe0000, 0xffff0000, 0x00000000,
  0x7ff90006, 0x7ffb0004, 0x7ffd0002, 0x80010000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0xaaacfffe, 0xaaac5555, 0xaaabaaac, 0x55550020,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0xfffd0000, 0xfffe0000, 0xffff0000, 0x00000000,
  0x7ff90006, 0x7ffb0004, 0x7ffd0002, 0x80010000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x8005ffee, 0x8004fff5, 0x8003fffc, 0x7ffd0020,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0xfffd0000, 0xfffe0000, 0xffff0000, 0x00000000,
  0x7ff90006, 0x7ffb0004, 0x7ffd0002, 0x80010000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x8004fff4, 0x8003fff9, 0x8002fffe, 0x7ffe0020,
  0x80000000, 0x80000000, 0x80000000, 0x7fffffff,
  0xfffd0000, 0xfffe0000, 0xffff0000, 0x00000000,
  0x7ff90006, 0x7ffb0004, 0x7ffd0002, 0x80010000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x8003fffa, 0x8002fffd, 0x80020000, 0x7fff0020,
  0x0000fffa, 0x0000fffd, 0x00010000, 0xffff0021,
  0x7ffd0000, 0x7ffe0001, 0x7fff0002, 0x80000021,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7ffd0000, 0x7ffe0001, 0x7fff0002, 0x80000021,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7ffc0006, 0x7ffd0005, 0x7ffe0004, 0x80010020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x5553fffc, 0x5554aaa9, 0x55555556, 0xaaaa0020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x3332ccc8, 0x33333331, 0x3333999a, 0xcccc0020,
  0x33b2c9c8, 0x33b33131, 0x33b3989a, 0xcc4c0020,
  0x3431c6ce, 0x34322f35, 0x3432979c, 0xcbcd0020,
  0x34afc3da, 0x34b02d3d, 0x34b096a0, 0xcb4f0020,
  0x352cc0ec, 0x352d2b49, 0x352d95a6, 0xcad20020,
  0x353cc08c, 0x353d2b09, 0x353d9586, 0xcac20020,
  0x353fc07a, 0x35402afd, 0x35409580, 0xcabf0020,
  0x3541c06e, 0x35422af5, 0x3542957c, 0xcabd0020,
  0x007ffd00, 0x007ffe01, 0x007fff02, 0xff800020,
  0x00fefa06, 0x00fefc05, 0x00fefe04, 0xff010020,
  0x017cf712, 0x017cfa0d, 0x017cfd08, 0xfe830020,
  0x01f9f424, 0x01f9f819, 0x01f9fc0e, 0xfe060020,
  0x0209f3c4, 0x0209f7d9, 0x0209fbee, 0xfdf60020,
  0x020cf3b2, 0x020cf7cd, 0x020cfbe8, 0xfdf30020,
  0x020ef3a6, 0x020ef7c5, 0x020efbe4, 0xfdf10020,
  0x020ff3a0, 0x020ff7c1, 0x020ffbe2, 0xfdf00020,
  0x007efe04, 0x007eff03, 0xff810002, 0xff81011e,
  0x00fcfc0c, 0x00fcfe07, 0xff030002, 0xff03021a,
  0x0179fa18, 0x0179fd0d, 0xfe860002, 0xfe860314,
  0x0189f9d8, 0x0189fced, 0xfe760002, 0xfe760334,
  0x018cf9cc, 0x018cfce7, 0xfe730002, 0xfe73033a,
  0x018ef9c4, 0x018efce3, 0xfe710002, 0xfe71033e,
  0x018ff9c0, 0x018ffce1, 0xfe700002, 0xfe700340,
  0x018ff9c0, 0x018ffce1, 0xfe700002, 0xfe700340,
  0x007dfe08, 0x007dff05, 0xff820002, 0xff82011c,
  0x00fafc14, 0x00fafe0b, 0xff050002, 0xff050216,
  0x010afbd4, 0x010afdeb, 0xfef50002, 0xfef50236,
  0x010dfbc8, 0x010dfde5, 0xfef20002, 0xfef2023c,
  0x010ffbc0, 0x010ffde1, 0xfef00002, 0xfef00240,
  0x0110fbbc, 0x0110fddf, 0xfeef0002, 0xfeef0242,
  0x0110fbbc, 0x0110fddf, 0xfeef0002, 0xfeef0242,
  0x010ffbc0, 0x010ffde1, 0xfef00002, 0xfef00240,
  0x007cfe0c, 0x007cff07, 0xff830002, 0xff83011a,
  0x008cfdcc, 0x008cfee7, 0xff730002, 0xff73013a,
  0x008ffdc0, 0x008ffee1, 0xff700002, 0xff700140,
  0x0091fdb8, 0x0091fedd, 0xff6e0002, 0xff6e0144,
  0x0092fdb4, 0x0092fedb, 0xff6d0002, 0xff6d0146,
  0x0092fdb4, 0x0092fedb, 0xff6d0002, 0xff6d0146,
  0x0091fdb8, 0x0091fedd, 0xff6e0002, 0xff6e0144,
  0x008ffdc0, 0x008ffee1, 0xff700002, 0xff700140,
  0x000fffc0, 0x000fffe1, 0xfff00002, 0xfff00040,
  0x0012ffb4, 0x0012ffdb, 0xffed0002, 0xffed0046,
  0x0014ffac, 0x0014ffd7, 0xffeb0002, 0xffeb004a,
  0x0015ffa8, 0x0015ffd5, 0xffea0002, 0xffea004c,
  0x0015ffa8, 0x0015ffd5, 0xffea0002, 0xffea004c,
  0x0014ffac, 0x0014ffd7, 0xffeb0002, 0xffeb004a,
  0x0012ffb4, 0x0012ffdb, 0xffed0002, 0xffed0046,
  0x0002fff4, 0x0002fffb, 0xfffd0002, 0xfffd0026,
  0x0002fff4, 0x0002fffb, 0xfffd0002, 0xfffd0026,
  0x0004ffec, 0x0004fff7, 0xfffb0002, 0xfffb002a,
  0x0005ffe8, 0x0005fff5, 0xfffa0002, 0xfffa002c,
  0x0005ffe8, 0x0005fff5, 0xfffa0002, 0xfffa002c,
  0x0004ffec, 0x0004fff7, 0xfffb0002, 0xfffb002a,
  0x0002fff4, 0x0002fffb, 0xfffd0002, 0xfffd0026,
  0xfff30034, 0xfff3001b, 0x000d0002, 0x000d0006,
  0xff760228, 0xff760115, 0x008a0002, 0x0089ff0c,
  0x0001fff8, 0x0001fffd, 0xfffe0002, 0xfffe0024,
  0x0002fff4, 0x0002fffb, 0xfffd0002, 0xfffd0026,
  0x0002fff4, 0x0002fffb, 0xfffd0002, 0xfffd0026,
  0x0001fff8, 0x0001fffd, 0xfffe0002, 0xfffe0024,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfff00040, 0xfff00021, 0x00100002, 0x00100000,
  0xff730234, 0xff73011b, 0x008d0002, 0x008cff06,
  0xfef5042c, 0xfef50217, 0x010b0002, 0x010afe0a,
  0x0000fffc, 0x0000ffff, 0xffff0002, 0xffff0022,
  0x0000fffc, 0x0000ffff, 0xffff0002, 0xffff0022,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffe0008, 0xfffe0005, 0x00020002, 0x0002001c,
  0xffee0048, 0xffee0025, 0x00120002, 0x0011fffc,
  0xff71023c, 0xff71011f, 0x008f0002, 0x008eff02,
  0xfef30434, 0xfef3021b, 0x010d0002, 0x010cfe06,
  0xfe740630, 0xfe740319, 0x018c0002, 0x018bfd08,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff0004, 0xffff0003, 0x00010002, 0x0001001e,
  0xfffd000c, 0xfffd0007, 0x00030002, 0x0003001a,
  0xffed004c, 0xffed0027, 0x00130002, 0x0012fffa,
  0xff700240, 0xff700121, 0x00900002, 0x008fff00,
  0xfef20438, 0xfef2021d, 0x010e0002, 0x010dfe04,
  0xfe730634, 0xfe73031b, 0x018d0002, 0x018cfd06,
  0xcb40d300, 0xcb406981, 0x34c00002, 0x34bf96a0,
  0xffff0004, 0xffff0003, 0x00010002, 0x0001001e,
  0xfffd000c, 0xfffd0007, 0x00030002, 0x0003001a,
  0xffed004c, 0xffed0027, 0x00130002, 0x0012fffa,
  0xff700240, 0xff700121, 0x00900002, 0x008fff00,
  0xfef20438, 0xfef2021d, 0x010e0002, 0x010dfe04,
  0xfe730634, 0xfe73031b, 0x018d0002, 0x018cfd06,
  0xcb40d300, 0xcb406981, 0x34c00002, 0x34bf96a0,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0xfffe0008, 0xfffe0005, 0x00020002, 0x0002001c,
  0xffee0048, 0xffee0025, 0x00120002, 0x0011fffc,
  0xff71023c, 0xff71011f, 0x008f0002, 0x008eff02,
  0xfef30434, 0xfef3021b, 0x010d0002, 0x010cfe06,
  0xfe740630, 0xfe740319, 0x018c0002, 0x018bfd08,
  0xcb41d2fc, 0xcb41697f, 0x34bf0002, 0x34be96a2,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0xfff00040, 0xfff00021, 0x00100002, 0x00100000,
  0xff730234, 0xff73011b, 0x008d0002, 0x008cff06,
  0xfef5042c, 0xfef50217, 0x010b0002, 0x010afe0a,
  0xfe760628, 0xfe760315, 0x018a0002, 0x0189fd0c,
  0xcb43d2f4, 0xcb43697b, 0x34bd0002, 0x34bc96a6,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0xff8301f4, 0xff8300fb, 0x007d0002, 0x007cff26,
  0xff0503ec, 0xff0501f7, 0x00fb0002, 0x00fafe2a,
  0xfe8605e8, 0xfe8602f5, 0x017a0002, 0x0179fd2c,
  0xcb53d2b4, 0xcb53695b, 0x34ad0002, 0x34ac96c6,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0xff8201f8, 0xff8200fd, 0x007e0002, 0x007dff24,
  0xff0303f4, 0xff0301fb, 0x00fd0002, 0x00fcfe26,
  0xcbd0d0c0, 0xcbd06861, 0x34300002, 0x342f97c0,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0xfffe0000, 0xffff0000, 0x00000000, 0x0000ffff,
  0xff8101fc, 0xff8100ff, 0x007f0002, 0x007eff22,
  0xcc4ecec8, 0xcc4e6765, 0x33b20002, 0x33b198bc,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0xfffe0000, 0xffff0000, 0x00000000, 0x0000ffff,
  0x7ffb0004, 0x7ffd0002, 0x80010000, 0x8002fffd,
  0xcccdcccc, 0xcccd6667, 0x33330002, 0x333299ba,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0xfffe0000, 0xffff0000, 0x00000000, 0x0000ffff,
  0x7ffb0004, 0x7ffd0002, 0x80010000, 0x8002fffd,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0xaaac5554, 0xaaabaaab, 0x55550002, 0x55545576,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0xfffe0000, 0xffff0000, 0x00000000, 0x0000ffff,
  0x7ffb0004, 0x7ffd0002, 0x80010000, 0x8002fffd,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x8004fff4, 0x8003fffb, 0x7ffd0002, 0x7ffc0026,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0xfffe0000, 0xffff0000, 0x00000000, 0x0000ffff,
  0x7ffb0004, 0x7ffd0002, 0x80010000, 0x8002fffd,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x8003fff8, 0x8002fffd, 0x7ffe0002, 0x7ffd0024,
  0x80000000, 0x80000000, 0x7fffffff, 0x7fffffff,
  0xfffe0000, 0xffff0000, 0x00000000, 0x0000ffff,
  0x7ffb0004, 0x7ffd0002, 0x80010000, 0x8002fffd,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x8002fffc, 0x8001ffff, 0x7fff0002, 0x7ffe0022,
  0x0000fffc, 0x0000ffff, 0xffff0003, 0xffff0022,
  0x7ffe0000, 0x7fff0001, 0x80000003, 0x80010020,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7ffe0000, 0x7fff0001, 0x80000003, 0x80010020,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7ffd0004, 0x7ffe0003, 0x80010002, 0x8002001e,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x5554aaa8, 0x55555555, 0xaaaa0002, 0xaaaaaacc,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x33333330, 0x33339999, 0xcccc0002, 0xcccc6688,
  0x33b33130, 0x33b39899, 0xcc4c0002, 0xcc4c6788,
  0x34322f34, 0x3432979b, 0xcbcd0002, 0xcbcd6886,
  0x34b02d3c, 0x34b0969f, 0xcb4f0002, 0xcb4f6982,
  0x352d2b48, 0x352d95a5, 0xcad20002, 0xcad26a7c,
  0x353d2b08, 0x353d9585, 0xcac20002, 0xcac26a9c,
  0x35402afc, 0x3540957f, 0xcabf0002, 0xcabf6aa2,
  0x35422af4, 0x3542957b, 0xcabd0002, 0xcabd6aa6,
  0x007ffe00, 0x007fff01, 0xff800002, 0xff800120,
  0x00fefc04, 0x00fefe03, 0xff010002, 0xff01021e,
  0x017cfa0c, 0x017cfd07, 0xfe830002, 0xfe83031a,
  0x01f9f818, 0x01f9fc0d, 0xfe060002, 0xfe060414,
  0x0209f7d8, 0x0209fbed, 0xfdf60002, 0xfdf60434,
  0x020cf7cc, 0x020cfbe7, 0xfdf30002, 0xfdf3043a,
  0x020ef7c4, 0x020efbe3, 0xfdf10002, 0xfdf1043e,
  0x020ff7c0, 0x020ffbe1, 0xfdf00002, 0xfdf00440,
  0x007eff02, 0xff810001, 0xff810100, 0xffab54cc,
  0x00fcfe06, 0xff030001, 0xff0301fc, 0xff575424,
  0x0179fd0c, 0xfe860001, 0xfe8602f6, 0xff03fe28,
  0x0189fcec, 0xfe760001, 0xfe760316, 0xfef95368,
  0x018cfce6, 0xfe730001, 0xfe73031c, 0xfef75364,
  0x018efce2, 0xfe710001, 0xfe710320, 0xfef5fe0c,
  0x018ffce0, 0xfe700001, 0xfe700322, 0xfef55360,
  0x018ffce0, 0xfe700001, 0xfe700322, 0xfef55360,
  0x007dff04, 0xff820001, 0xff8200fe, 0xffabff78,
  0x00fafe0a, 0xff050001, 0xff0501f8, 0xff58a97c,
  0x010afdea, 0xfef50001, 0xfef50218, 0xff4dfebc,
  0x010dfde4, 0xfef20001, 0xfef2021e, 0xff4bfeb8,
  0x010ffde0, 0xfef00001, 0xfef00222, 0xff4aa960,
  0x0110fdde, 0xfeef0001, 0xfeef0224, 0xff49feb4,
  0x0110fdde, 0xfeef0001, 0xfeef0224, 0xff49feb4,
  0x010ffde0, 0xfef00001, 0xfef00222, 0xff4aa960,
  0x007cff06, 0xff830001, 0xff8300fc, 0xffacaa24,
  0x008cfee6, 0xff730001, 0xff73011c, 0xffa1ff64,
  0x008ffee0, 0xff700001, 0xff700122, 0xff9fff60,
  0x0091fedc, 0xff6e0001, 0xff6e0126, 0xff9eaa08,
  0x0092feda, 0xff6d0001, 0xff6d0128, 0xff9dff5c,
  0x0092feda, 0xff6d0001, 0xff6d0128, 0xff9dff5c,
  0x0091fedc, 0xff6e0001, 0xff6e0126, 0xff9eaa08,
  0x008ffee0, 0xff700001, 0xff700122, 0xff9fff60,
  0x000fffe0, 0xfff00001, 0xfff00022, 0xfff55560,
  0x0012ffda, 0xffed0001, 0xffed0028, 0xfff3555c,
  0x0014ffd6, 0xffeb0001, 0xffeb002c, 0xfff20004,
  0x0015ffd4, 0xffea0001, 0xffea002e, 0xfff15558,
  0x0015ffd4, 0xffea0001, 0xffea002e, 0xfff15558,
  0x0014ffd6, 0xffeb0001, 0xffeb002c, 0xfff20004,
  0x0012ffda, 0xffed0001, 0xffed0028, 0xfff3555c,
  0x0002fffa, 0xfffd0001, 0xfffd0008, 0xfffe001c,
  0x0002fffa, 0xfffd0001, 0xfffd0008, 0xfffe001c,
  0x0004fff6, 0xfffb0001, 0xfffb000c, 0xfffcaac4,
  0x0005fff4, 0xfffa0001, 0xfffa000e, 0xfffc0018,
  0x0005fff4, 0xfffa0001, 0xfffa000e, 0xfffc0018,
  0x0004fff6, 0xfffb0001, 0xfffb000c, 0xfffcaac4,
  0x0002fffa, 0xfffd0001, 0xfffd0008, 0xfffe001c,
  0xfff3001a, 0x000d0001, 0x000cffe8, 0x0008aadc,
  0xff760114, 0x008a0001, 0x0089feee, 0x005c00d8,
  0x0001fffc, 0xfffe0001, 0xfffe0006, 0xfffeaac8,
  0x0002fffa, 0xfffd0001, 0xfffd0008, 0xfffe001c,
  0x0002fffa, 0xfffd0001, 0xfffd0008, 0xfffe001c,
  0x0001fffc, 0xfffe0001, 0xfffe0006, 0xfffeaac8,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfff00020, 0x00100001, 0x000fffe2, 0x000aaae0,
  0xff73011a, 0x008d0001, 0x008cfee8, 0x005e00dc,
  0xfef50216, 0x010b0001, 0x010afdec, 0x00b20184,
  0x0000fffe, 0xffff0001, 0xffff0004, 0xffff5574,
  0x0000fffe, 0xffff0001, 0xffff0004, 0xffff5574,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffe0004, 0x00020001, 0x0001fffe, 0x00015578,
  0xffee0024, 0x00120001, 0x0011ffde, 0x000c0038,
  0xff71011e, 0x008f0001, 0x008efee4, 0x005f5634,
  0xfef3021a, 0x010d0001, 0x010cfde8, 0x00b356dc,
  0xfe740318, 0x018c0001, 0x018bfcea, 0x01080230,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff0002, 0x00010001, 0x00010000, 0x0000aacc,
  0xfffd0006, 0x00030001, 0x0002fffc, 0x00020024,
  0xffed0026, 0x00130001, 0x0012ffdc, 0x000caae4,
  0xff700120, 0x00900001, 0x008ffee2, 0x006000e0,
  0xfef2021c, 0x010e0001, 0x010dfde6, 0x00b40188,
  0xfe73031a, 0x018d0001, 0x018cfce8, 0x0108acdc,
  0xcb406980, 0x34c00001, 0x34bf9682, 0x232af120,
  0xffff0002, 0x00010001, 0x00010000, 0x0000aacc,
  0xfffd0006, 0x00030001, 0x0002fffc, 0x00020024,
  0xffed0026, 0x00130001, 0x0012ffdc, 0x000caae4,
  0xff700120, 0x00900001, 0x008ffee2, 0x006000e0,
  0xfef2021c, 0x010e0001, 0x010dfde6, 0x00b40188,
  0xfe73031a, 0x018d0001, 0x018cfce8, 0x0108acdc,
  0xcb406980, 0x34c00001, 0x34bf9682, 0x232af120,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x5c0eb83c,
  0xfffe0004, 0x00020001, 0x0001fffe, 0x00015578,
  0xffee0024, 0x00120001, 0x0011ffde, 0x000c0038,
  0xff71011e, 0x008f0001, 0x008efee4, 0x005f5634,
  0xfef3021a, 0x010d0001, 0x010cfde8, 0x00b356dc,
  0xfe740318, 0x018c0001, 0x018bfcea, 0x01080230,
  0xcb41697e, 0x34bf0001, 0x34be9684, 0x232a4674,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x5c0e0d90,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0xfff00020, 0x00100001, 0x000fffe2, 0x000aaae0,
  0xff73011a, 0x008d0001, 0x008cfee8, 0x005e00dc,
  0xfef50216, 0x010b0001, 0x010afdec, 0x00b20184,
  0xfe760314, 0x018a0001, 0x0189fcee, 0x0106acd8,
  0xcb43697a, 0x34bd0001, 0x34bc9688, 0x2328f11c,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x5c0cb838,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0xff8300fa, 0x007d0001, 0x007cff08, 0x0053561c,
  0xff0501f6, 0x00fb0001, 0x00fafe0c, 0x00a756c4,
  0xfe8602f4, 0x017a0001, 0x0179fd0e, 0x00fc0218,
  0xcb53695a, 0x34ad0001, 0x34ac96a8, 0x231e465c,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x5c020d78,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0xff8200fc, 0x007e0001, 0x007dff06, 0x005400c8,
  0xff0301fa, 0x00fd0001, 0x00fcfe08, 0x00a8ac1c,
  0xcbd06860, 0x34300001, 0x342f97a2, 0x22caf060,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x5baeb77c,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0xffff0000, 0x00000000, 0x0000ffff, 0x2aa9ffff,
  0xff8100fe, 0x007f0001, 0x007eff04, 0x0054ab74,
  0xcc4e6764, 0x33b20001, 0x33b1989e, 0x2276efb8,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x5b5ab6d4,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0xffff0000, 0x00000000, 0x0000ffff, 0x2aa9ffff,
  0x7ffd0002, 0x80010000, 0x8002fffd, 0xd554aaab,
  0xcccd6666, 0x33330001, 0x3332999c, 0x22224464,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x5b060b80,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0xffff0000, 0x00000000, 0x0000ffff, 0x2aa9ffff,
  0x7ffd0002, 0x80010000, 0x8002fffd, 0xd554aaab,
  0x7fffffff, 0x80000000, 0x80000000, 0x9c7038e3,
  0xaaabaaaa, 0x55550001, 0x55545558, 0x38e3c73c,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0xffff0000, 0x00000000, 0x0000ffff, 0x2aa9ffff,
  0x7ffd0002, 0x80010000, 0x8002fffd, 0xd554aaab,
  0x7fffffff, 0x80000000, 0x80000000, 0x9c7038e3,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x8003fffa, 0x7ffd0001, 0x7ffc0008, 0x5554001c,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0xffff0000, 0x00000000, 0x0000ffff, 0x2aa9ffff,
  0x7ffd0002, 0x80010000, 0x8002fffd, 0xd554aaab,
  0x7fffffff, 0x80000000, 0x80000000, 0x9c7038e3,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x8002fffc, 0x7ffe0001, 0x7ffd0006, 0x5554aac8,
  0x80000000, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0xffff0000, 0x00000000, 0x0000ffff, 0x2aa9ffff,
  0x7ffd0002, 0x80010000, 0x8002fffd, 0xd554aaab,
  0x7fffffff, 0x80000000, 0x80000000, 0x9c7038e3,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x8001fffe, 0x7fff0001, 0x7ffe0004, 0x55555574,
  0x0000fffe, 0xffff0002, 0xffff0004, 0xffff5574,
  0x7fff0000, 0x80000002, 0x80010002, 0xaaaa0020,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x7fff0000, 0x80000002, 0x80010002, 0xaaaa0020,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x7ffe0002, 0x80010001, 0x80020000, 0xaaaaaacc,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x55555554, 0xaaaa0001, 0xaaaaaaae, 0xc71b8e58,
  0x7fffffff, 0x80000000, 0x80000000, 0xa4f89f68,
  0x7fffffff, 0x80000000, 0x80000000, 0xa4a34968,
  0x7fffffff, 0x80000000, 0x80000000, 0xa44e9e14,
  0x7fffffff, 0x80000000, 0x80000000, 0xa3fa9d6c,
  0x7fffffff, 0x80000000, 0x80000000, 0xa3a74770,
  0x7fffffff, 0x80000000, 0x80000000, 0xa39c9cb0,
  0x7fffffff, 0x80000000, 0x80000000, 0xa39a9cac,
  0x33339998, 0xcccc0001, 0xcccc666a, 0xdddd1130,
  0x33b39898, 0xcc4c0001, 0xcc4c676a, 0xdd87bb30,
  0x3432979a, 0xcbcd0001, 0xcbcd6868, 0xdd330fdc,
  0x34b0969e, 0xcb4f0001, 0xcb4f6964, 0xdcdf0f34,
  0x352d95a4, 0xcad20001, 0xcad26a5e, 0xdc8bb938,
  0x353d9584, 0xcac20001, 0xcac26a7e, 0xdc810e78,
  0x3540957e, 0xcabf0001, 0xcabf6a84, 0xdc7f0e74,
  0x3542957a, 0xcabd0001, 0xcabd6a88, 0xdc7db91c,
  0x007fff00, 0xff800001, 0xff800102, 0xffaaaa20,
  0x00fefe02, 0xff010001, 0xff010200, 0xff55fecc,
  0x017cfd06, 0xfe830001, 0xfe8302fc, 0xff01fe24,
  0x01f9fc0c, 0xfe060001, 0xfe0603f6, 0xfeaea828,
  0x0209fbec, 0xfdf60001, 0xfdf60416, 0xfea3fd68,
  0x020cfbe6, 0xfdf30001, 0xfdf3041c, 0xfea1fd64,
  0x020efbe2, 0xfdf10001, 0xfdf10420, 0xfea0a80c,
  0x020ffbe0, 0xfdf00001, 0xfdf00422, 0xfe9ffd60,
  0xff810000, 0xff8100ff, 0xffab54ae, 0xffcd3288,
  0xff030000, 0xff0301fb, 0xff575406, 0xff9acb58,
  0xfe860000, 0xfe8602f5, 0xff03fe0a, 0xff68ca90,
  0xfe760000, 0xfe760315, 0xfef9534a, 0xff626410,
  0xfe730000, 0xfe73031b, 0xfef75346, 0xff6130d8,
  0xfe710000, 0xfe71031f, 0xfef5fdee, 0xff606408,
  0xfe700000, 0xfe700321, 0xfef55342, 0xff5ffda0,
  0xfe700000, 0xfe700321, 0xfef55342, 0xff5ffda0,
  0xff820000, 0xff8200fd, 0xffabff5a, 0xffcd98f0,
  0xff050000, 0xff0501f7, 0xff58a95e, 0xff9b9828,
  0xfef50000, 0xfef50217, 0xff4dfe9e, 0xff9531a8,
  0xfef20000, 0xfef2021d, 0xff4bfe9a, 0xff93fe70,
  0xfef00000, 0xfef00221, 0xff4aa942, 0xff9331a0,
  0xfeef0000, 0xfeef0223, 0xff49fe96, 0xff92cb38,
  0xfeef0000, 0xfeef0223, 0xff49fe96, 0xff92cb38,
  0xfef00000, 0xfef00221, 0xff4aa942, 0xff9331a0,
  0xff830000, 0xff8300fb, 0xffacaa06, 0xffcdff58,
  0xff730000, 0xff73011b, 0xffa1ff46, 0xffc798d8,
  0xff700000, 0xff700121, 0xff9fff42, 0xffc665a0,
  0xff6e0000, 0xff6e0125, 0xff9ea9ea, 0xffc598d0,
  0xff6d0000, 0xff6d0127, 0xff9dff3e, 0xffc53268,
  0xff6d0000, 0xff6d0127, 0xff9dff3e, 0xffc53268,
  0xff6e0000, 0xff6e0125, 0xff9ea9ea, 0xffc598d0,
  0xff700000, 0xff700121, 0xff9fff42, 0xffc665a0,
  0xfff00000, 0xfff00021, 0xfff55542, 0xfff999a0,
  0xffed0000, 0xffed0027, 0xfff3553e, 0xfff86668,
  0xffeb0000, 0xffeb002b, 0xfff1ffe6, 0xfff79998,
  0xffea0000, 0xffea002d, 0xfff1553a, 0xfff73330,
  0xffea0000, 0xffea002d, 0xfff1553a, 0xfff73330,
  0xffeb0000, 0xffeb002b, 0xfff1ffe6, 0xfff79998,
  0xffed0000, 0xffed0027, 0xfff3553e, 0xfff86668,
  0xfffd0000, 0xfffd0007, 0xfffdfffe, 0xfffecce8,
  0xfffd0000, 0xfffd0007, 0xfffdfffe, 0xfffecce8,
  0xfffb0000, 0xfffb000b, 0xfffcaaa6, 0xfffe0018,
  0xfffa0000, 0xfffa000d, 0xfffbfffa, 0xfffd99b0,
  0xfffa0000, 0xfffa000d, 0xfffbfffa, 0xfffd99b0,
  0xfffb0000, 0xfffb000b, 0xfffcaaa6, 0xfffe0018,
  0xfffd0000, 0xfffd0007, 0xfffdfffe, 0xfffecce8,
  0x000d0000, 0x000cffe7, 0x0008aabe, 0x00053368,
  0x008a0000, 0x0089feed, 0x005c00ba, 0x00373430,
  0xfffe0000, 0xfffe0005, 0xfffeaaaa, 0xffff3350,
  0xfffd0000, 0xfffd0007, 0xfffdfffe, 0xfffecce8,
  0xfffd0000, 0xfffd0007, 0xfffdfffe, 0xfffecce8,
  0xfffe0000, 0xfffe0005, 0xfffeaaaa, 0xffff3350,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00100000, 0x000fffe1, 0x000aaac2, 0x000666a0,
  0x008d0000, 0x008cfee7, 0x005e00be, 0x00386768,
  0x010b0000, 0x010afdeb, 0x00b20166, 0x006ace98,
  0xffff0000, 0xffff0003, 0xffff5556, 0xffff99b8,
  0xffff0000, 0xffff0003, 0xffff5556, 0xffff99b8,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00020000, 0x0001fffd, 0x0001555a, 0x0000ccf0,
  0x00120000, 0x0011ffdd, 0x000c001a, 0x00073370,
  0x008f0000, 0x008efee3, 0x005f5616, 0x00393438,
  0x010d0000, 0x010cfde7, 0x00b356be, 0x006b9b68,
  0x018c0000, 0x018bfce9, 0x01080212, 0x009e6900,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00010000, 0x0000ffff, 0x0000aaae, 0x00006688,
  0x00030000, 0x0002fffb, 0x00020006, 0x00013358,
  0x00130000, 0x0012ffdb, 0x000caac6, 0x000799d8,
  0x00900000, 0x008ffee1, 0x006000c2, 0x00399aa0,
  0x010e0000, 0x010dfde5, 0x00b4016a, 0x006c01d0,
  0x018d0000, 0x018cfce7, 0x0108acbe, 0x009ecf68,
  0x34c00000, 0x34bf9681, 0x232af102, 0x1519ee20,
  0x00010000, 0x0000ffff, 0x0000aaae, 0x00006688,
  0x00030000, 0x0002fffb, 0x00020006, 0x00013358,
  0x00130000, 0x0012ffdb, 0x000caac6, 0x000799d8,
  0x00900000, 0x008ffee1, 0x006000c2, 0x00399aa0,
  0x010e0000, 0x010dfde5, 0x00b4016a, 0x006c01d0,
  0x018d0000, 0x018cfce7, 0x0108acbe, 0x009ecf68,
  0x34c00000, 0x34bf9681, 0x232af102, 0x1519ee20,
  0x7fffffff, 0x7fffffff, 0x5c0eb81e, 0x373c76a8,
  0x00020000, 0x0001fffd, 0x0001555a, 0x0000ccf0,
  0x00120000, 0x0011ffdd, 0x000c001a, 0x00073370,
  0x008f0000, 0x008efee3, 0x005f5616, 0x00393438,
  0x010d0000, 0x010cfde7, 0x00b356be, 0x006b9b68,
  0x018c0000, 0x018bfce9, 0x01080212, 0x009e6900,
  0x34bf0000, 0x34be9683, 0x232a4656, 0x151987b8,
  0x7fffffff, 0x7fffffff, 0x5c0e0d72, 0x373c1040,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x6a6edd08,
  0x00100000, 0x000fffe1, 0x000aaac2, 0x000666a0,
  0x008d0000, 0x008cfee7, 0x005e00be, 0x00386768,
  0x010b0000, 0x010afdeb, 0x00b20166, 0x006ace98,
  0x018a0000, 0x0189fced, 0x0106acba, 0x009d9c30,
  0x34bd0000, 0x34bc9687, 0x2328f0fe, 0x1518bae8,
  0x7fffffff, 0x7fffffff, 0x5c0cb81a, 0x373b4370,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x6a6e1038,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x007d0000, 0x007cff07, 0x005355fe, 0x003200e8,
  0x00fb0000, 0x00fafe0b, 0x00a756a6, 0x00646818,
  0x017a0000, 0x0179fd0d, 0x00fc01fa, 0x009735b0,
  0x34ad0000, 0x34ac96a7, 0x231e463e, 0x15125468,
  0x7fffffff, 0x7fffffff, 0x5c020d5a, 0x3734dcf0,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x6a67a9b8,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x007e0000, 0x007dff05, 0x005400aa, 0x00326750,
  0x00fd0000, 0x00fcfe07, 0x00a8abfe, 0x006534e8,
  0x34300000, 0x342f97a1, 0x22caf042, 0x14e053a0,
  0x7fffffff, 0x7fffffff, 0x5baeb75e, 0x3702dc28,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x6a35a8f0,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x00000000, 0x0000ffff, 0x2aa9ffff, 0x4ccbffff,
  0x007f0000, 0x007eff03, 0x0054ab56, 0x0032cdb8,
  0x33b20000, 0x33b1989d, 0x2276ef9a, 0x14adec70,
  0x7fffffff, 0x7fffffff, 0x5b5ab6b6, 0x36d074f8,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x6a0341c0,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x00000000, 0x0000ffff, 0x2aa9ffff, 0x4ccbffff,
  0x80010000, 0x8002fffd, 0xd554aaab, 0x19986667,
  0x33330000, 0x3332999b, 0x22224446, 0x147b1ed8,
  0x7fffffff, 0x7fffffff, 0x5b060b62, 0x369da760,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x69d07428,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x00000000, 0x0000ffff, 0x2aa9ffff, 0x4ccbffff,
  0x80010000, 0x8002fffd, 0xd554aaab, 0x19986667,
  0x80000000, 0x80000000, 0x9c7038e3, 0xf7757777,
  0x55550000, 0x55545557, 0x38e3c71e, 0x222288a8,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x55555570,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x00000000, 0x0000ffff, 0x2aa9ffff, 0x4ccbffff,
  0x80010000, 0x8002fffd, 0xd554aaab, 0x19986667,
  0x80000000, 0x80000000, 0x9c7038e3, 0xf7757777,
  0x80000000, 0x80000000, 0x80000000, 0xe2f9f257,
  0x7ffd0000, 0x7ffc0007, 0x5553fffe, 0x3332cce8,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x66660018,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x00000000, 0x0000ffff, 0x2aa9ffff, 0x4ccbffff,
  0x80010000, 0x8002fffd, 0xd554aaab, 0x19986667,
  0x80000000, 0x80000000, 0x9c7038e3, 0xf7757777,
  0x80000000, 0x80000000, 0x80000000, 0xe2f9f257,
  0x80000000, 0x80000000, 0x80000000, 0xe2c6be57,
  0x7ffe0000, 0x7ffd0005, 0x5554aaaa, 0x33333350,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x6666cce8,
  0x00000000, 0x0000ffff, 0x2aa9ffff, 0x3332cce8,
  0x80010000, 0x8002fffd, 0xd554aaab, 0xffff3350,
  0x80000000, 0x80000000, 0x9c7038e3, 0xdddc4460,
  0x80000000, 0x80000000, 0x80000000, 0xc960bf40,
  0x80000000, 0x80000000, 0x80000000, 0xc92d8b40,
  0x80000000, 0x80000000, 0x80000000, 0xc8fabda8,
  0x7fff0000, 0x7ffe0003, 0x55555556, 0x333399b8,
  0xffff0001, 0xffff0003, 0xffff5556, 0xffff99b8,
  0x80000001, 0x80010001, 0xaaaa0002, 0xcccc0020,
  0x80000000, 0x80000000, 0x80000000, 0xaaa91130,
  0x80000000, 0x80000000, 0x80000000, 0x962d8c10,
  0x80000000, 0x80000000, 0x80000000, 0x95fa5810,
  0x80000000, 0x80000000, 0x80000000, 0x95c78a78,
  0x80000000, 0x80000000, 0x80000000, 0x95952348,
  0x80000001, 0x80010001, 0xaaaa0002, 0xcccc0020,
  0x80000000, 0x80000000, 0x80000000, 0x99986688,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80010000, 0x8001ffff, 0xaaaaaaae, 0xcccc6688,
  0x80000000, 0x80000000, 0x80000000, 0xaaa97798,
  0x80000000, 0x80000000, 0x80000000, 0x962df278,
  0x80000000, 0x80000000, 0x80000000, 0x95fabe78,
  0x80000000, 0x80000000, 0x80000000, 0x95c7f0e0,
  0x80000000, 0x80000000, 0x80000000, 0x959589b0,
  0x80000000, 0x80000000, 0x80000000, 0x956388e8,
  0x80000000, 0x80000000, 0x80000000, 0x955d2268,
  0xaaaa0000, 0xaaaaaaad, 0xc71b8e3a, 0xdddd1130,
  0x80000000, 0x80000000, 0xa4f89f4a, 0xc9618c10,
  0x80000000, 0x80000000, 0xa4a3494a, 0xc92e5810,
  0x80000000, 0x80000000, 0xa44e9df6, 0xc8fb8a78,
  0x80000000, 0x80000000, 0xa3fa9d4e, 0xc8c92348,
  0x80000000, 0x80000000, 0xa3a74752, 0xc8972280,
  0x80000000, 0x80000000, 0xa39c9c92, 0xc890bc00,
  0x80000000, 0x80000000, 0xa39a9c8e, 0xc88f88c8,
  0xcccc0000, 0xcccc6669, 0xdddd1112, 0xeb847b00,
  0xcc4c0000, 0xcc4c6769, 0xdd87bb12, 0xeb514700,
  0xcbcd0000, 0xcbcd6867, 0xdd330fbe, 0xeb1e7968,
  0xcb4f0000, 0xcb4f6963, 0xdcdf0f16, 0xeaec1238,
  0xcad20000, 0xcad26a5d, 0xdc8bb91a, 0xeaba1170,
  0xcac20000, 0xcac26a7d, 0xdc810e5a, 0xeab3aaf0,
  0xcabf0000, 0xcabf6a83, 0xdc7f0e56, 0xeab277b8,
  0xcabd0000, 0xcabd6a87, 0xdc7db8fe, 0xeab1aae8,
  0xff800000, 0xff800101, 0xffaaaa02, 0xffcccc20,
  0xff010000, 0xff0101ff, 0xff55feae, 0xff99fe88,
  0xfe830000, 0xfe8302fb, 0xff01fe06, 0xff679758,
  0xfe060000, 0xfe0603f5, 0xfeaea80a, 0xff359690,
  0xfdf60000, 0xfdf60415, 0xfea3fd4a, 0xff2f3010,
  0xfdf30000, 0xfdf3041b, 0xfea1fd46, 0xff2dfcd8,
  0xfdf10000, 0xfdf1041f, 0xfea0a7ee, 0xff2d3008,
  0xfdf00000, 0xfdf00421, 0xfe9ffd42, 0xff2cc9a0,
  0xff8100fe, 0xffab54ad, 0xffcd326a, 0xffff8120,
  0xff0301fa, 0xff575405, 0xff9acb3a, 0xffff0320,
  0xfe8602f4, 0xff03fe09, 0xff68ca72, 0xfffe8620,
  0xfe760314, 0xfef95349, 0xff6263f2, 0xfffe7620,
  0xfe73031a, 0xfef75345, 0xff6130ba, 0xfffe7320,
  0xfe71031e, 0xfef5fded, 0xff6063ea, 0xfffe7120,
  0xfe700320, 0xfef55341, 0xff5ffd82, 0xfffe7020,
  0xfe700320, 0xfef55341, 0xff5ffd82, 0xfffe7020,
  0xff8200fc, 0xffabff59, 0xffcd98d2, 0xffff8220,
  0xff0501f6, 0xff58a95d, 0xff9b980a, 0xffff0520,
  0xfef50216, 0xff4dfe9d, 0xff95318a, 0xfffef520,
  0xfef2021c, 0xff4bfe99, 0xff93fe52, 0xfffef220,
  0xfef00220, 0xff4aa941, 0xff933182, 0xfffef020,
  0xfeef0222, 0xff49fe95, 0xff92cb1a, 0xfffeef20,
  0xfeef0222, 0xff49fe95, 0xff92cb1a, 0xfffeef20,
  0xfef00220, 0xff4aa941, 0xff933182, 0xfffef020,
  0xff8300fa, 0xffacaa05, 0xffcdff3a, 0xffff8320,
  0xff73011a, 0xffa1ff45, 0xffc798ba, 0xffff7320,
  0xff700120, 0xff9fff41, 0xffc66582, 0xffff7020,
  0xff6e0124, 0xff9ea9e9, 0xffc598b2, 0xffff6e20,
  0xff6d0126, 0xff9dff3d, 0xffc5324a, 0xffff6d20,
  0xff6d0126, 0xff9dff3d, 0xffc5324a, 0xffff6d20,
  0xff6e0124, 0xff9ea9e9, 0xffc598b2, 0xffff6e20,
  0xff700120, 0xff9fff41, 0xffc66582, 0xffff7020,
  0xfff00020, 0xfff55541, 0xfff99982, 0xfffff020,
  0xffed0026, 0xfff3553d, 0xfff8664a, 0xffffed20,
  0xffeb002a, 0xfff1ffe5, 0xfff7997a, 0xffffeb20,
  0xffea002c, 0xfff15539, 0xfff73312, 0xffffea20,
  0xffea002c, 0xfff15539, 0xfff73312, 0xffffea20,
  0xffeb002a, 0xfff1ffe5, 0xfff7997a, 0xffffeb20,
  0xffed0026, 0xfff3553d, 0xfff8664a, 0xffffed20,
  0xfffd0006, 0xfffdfffd, 0xfffeccca, 0xfffffd20,
  0xfffd0006, 0xfffdfffd, 0xfffeccca, 0xfffffd20,
  0xfffb000a, 0xfffcaaa5, 0xfffdfffa, 0xfffffb20,
  0xfffa000c, 0xfffbfff9, 0xfffd9992, 0xfffffa20,
  0xfffa000c, 0xfffbfff9, 0xfffd9992, 0xfffffa20,
  0xfffb000a, 0xfffcaaa5, 0xfffdfffa, 0xfffffb20,
  0xfffd0006, 0xfffdfffd, 0xfffeccca, 0xfffffd20,
  0x000cffe6, 0x0008aabd, 0x0005334a, 0x00000d20,
  0x0089feec, 0x005c00b9, 0x00373412, 0x00008a20,
  0xfffe0004, 0xfffeaaa9, 0xffff3332, 0xfffffe20,
  0xfffd0006, 0xfffdfffd, 0xfffeccca, 0xfffffd20,
  0xfffd0006, 0xfffdfffd, 0xfffeccca, 0xfffffd20,
  0xfffe0004, 0xfffeaaa9, 0xffff3332, 0xfffffe20,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x000fffe0, 0x000aaac1, 0x00066682, 0x00001020,
  0x008cfee6, 0x005e00bd, 0x0038674a, 0x00008d20,
  0x010afdea, 0x00b20165, 0x006ace7a, 0x00010b20,
  0xffff0002, 0xffff5555, 0xffff999a, 0xffffff20,
  0xffff0002, 0xffff5555, 0xffff999a, 0xffffff20,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0001fffc, 0x00015559, 0x0000ccd2, 0x00000220,
  0x0011ffdc, 0x000c0019, 0x00073352, 0x00001220,
  0x008efee2, 0x005f5615, 0x0039341a, 0x00008f20,
  0x010cfde6, 0x00b356bd, 0x006b9b4a, 0x00010d20,
  0x018bfce8, 0x01080211, 0x009e68e2, 0x00018c20,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000fffe, 0x0000aaad, 0x0000666a, 0x00000120,
  0x0002fffa, 0x00020005, 0x0001333a, 0x00000320,
  0x0012ffda, 0x000caac5, 0x000799ba, 0x00001320,
  0x008ffee0, 0x006000c1, 0x00399a82, 0x00009020,
  0x010dfde4, 0x00b40169, 0x006c01b2, 0x00010e20,
  0x018cfce6, 0x0108acbd, 0x009ecf4a, 0x00018d20,
  0x34bf9680, 0x232af101, 0x1519ee02, 0x0034c020,
  0x0000fffe, 0x0000aaad, 0x0000666a, 0x00000120,
  0x0002fffa, 0x00020005, 0x0001333a, 0x00000320,
  0x0012ffda, 0x000caac5, 0x000799ba, 0x00001320,
  0x008ffee0, 0x006000c1, 0x00399a82, 0x00009020,
  0x010dfde4, 0x00b40169, 0x006c01b2, 0x00010e20,
  0x018cfce6, 0x0108acbd, 0x009ecf4a, 0x00018d20,
  0x34bf9680, 0x232af101, 0x1519ee02, 0x0034c020,
  0x7fffffff, 0x5c0eb81d, 0x373c768a, 0x008a1520,
  0x0001fffc, 0x00015559, 0x0000ccd2, 0x00000220,
  0x0011ffdc, 0x000c0019, 0x00073352, 0x00001220,
  0x008efee2, 0x005f5615, 0x0039341a, 0x00008f20,
  0x010cfde6, 0x00b356bd, 0x006b9b4a, 0x00010d20,
  0x018bfce8, 0x01080211, 0x009e68e2, 0x00018c20,
  0x34be9682, 0x232a4655, 0x1519879a, 0x0034bf20,
  0x7fffffff, 0x5c0e0d71, 0x373c1022, 0x008a1420,
  0x7fffffff, 0x7fffffff, 0x6a6edcea, 0x010a1120,
  0x000fffe0, 0x000aaac1, 0x00066682, 0x00001020,
  0x008cfee6, 0x005e00bd, 0x0038674a, 0x00008d20,
  0x010afdea, 0x00b20165, 0x006ace7a, 0x00010b20,
  0x0189fcec, 0x0106acb9, 0x009d9c12, 0x00018a20,
  0x34bc9686, 0x2328f0fd, 0x1518baca, 0x0034bd20,
  0x7fffffff, 0x5c0cb819, 0x373b4352, 0x008a1220,
  0x7fffffff, 0x7fffffff, 0x6a6e101a, 0x010a0f20,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x018a0d20,
  0x007cff06, 0x005355fd, 0x003200ca, 0x00007d20,
  0x00fafe0a, 0x00a756a5, 0x006467fa, 0x0000fb20,
  0x0179fd0c, 0x00fc01f9, 0x00973592, 0x00017a20,
  0x34ac96a6, 0x231e463d, 0x1512544a, 0x0034ad20,
  0x7fffffff, 0x5c020d59, 0x3734dcd2, 0x008a0220,
  0x7fffffff, 0x7fffffff, 0x6a67a99a, 0x0109ff20,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0189fd20,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0209fc20,
  0x007dff04, 0x005400a9, 0x00326732, 0x00007e20,
  0x00fcfe06, 0x00a8abfd, 0x006534ca, 0x0000fd20,
  0x342f97a0, 0x22caf041, 0x14e05382, 0x00343020,
  0x7fffffff, 0x5baeb75d, 0x3702dc0a, 0x00898520,
  0x7fffffff, 0x7fffffff, 0x6a35a8d2, 0x01098220,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x01898020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x02097f20,
  0x0000ffff, 0x2aa9ffff, 0x4ccbffff, 0x01897f20,
  0x007eff02, 0x0054ab55, 0x0032cd9a, 0x00007f20,
  0x33b1989c, 0x2276ef99, 0x14adec52, 0x0033b220,
  0x7fffffff, 0x5b5ab6b5, 0x36d074da, 0x00890720,
  0x7fffffff, 0x7fffffff, 0x6a0341a2, 0x01090420,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x01890220,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x02090120,
  0x0000ffff, 0x2aa9ffff, 0x4ccbffff, 0x01890120,
  0x8002fffd, 0xd554aaab, 0x19986667, 0x01090220,
  0x3332999a, 0x22224445, 0x147b1eba, 0x00333320,
  0x7fffffff, 0x5b060b61, 0x369da742, 0x00888820,
  0x7fffffff, 0x7fffffff, 0x69d0740a, 0x01088520,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x01888320,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x02088220,
  0x0000ffff, 0x2aa9ffff, 0x4ccbffff, 0x01888220,
  0x8002fffd, 0xd554aaab, 0x19986667, 0x01088320,
  0x80000000, 0x9c7038e3, 0xf7757777, 0x00b32d20,
  0x55545556, 0x38e3c71d, 0x2222888a, 0x00555520,
  0x7fffffff, 0x7fffffff, 0x55555552, 0x00d55220,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x01555020,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x01d54f20,
  0x0000ffff, 0x2aa9ffff, 0x4ccbffff, 0x01554f20,
  0x8002fffd, 0xd554aaab, 0x19986667, 0x00d55020,
  0x80000000, 0x9c7038e3, 0xf7757777, 0x007ffa20,
  0x80000000, 0x80000000, 0xe2f9f257, 0x004cc620,
  0x7ffc0006, 0x5553fffd, 0x3332ccca, 0x007ffd20,
  0x7fffffff, 0x7fffffff, 0x6665fffa, 0x00fffb20,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x017ffa20,
  0x0000ffff, 0x2aa9ffff, 0x4ccbffff, 0x00fffa20,
  0x8002fffd, 0xd554aaab, 0x19986667, 0x007ffb20,
  0x80000000, 0x9c7038e3, 0xf7757777, 0x002aa520,
  0x80000000, 0x80000000, 0xe2f9f257, 0xfff77120,
  0x80000000, 0x80000000, 0xe2c6be57, 0xfff6f120,
  0x7ffd0004, 0x5554aaa9, 0x33333332, 0x007ffe20,
  0x7fffffff, 0x7fffffff, 0x6666ccca, 0x00fffd20,
  0x0000ffff, 0x2aa9ffff, 0x3332ccca, 0x007ffd20,
  0x8002fffd, 0xd554aaab, 0xffff3332, 0xfffffe20,
  0x80000000, 0x9c7038e3, 0xdddc4442, 0xffaaa820,
  0x80000000, 0x80000000, 0xc960bf22, 0xff777420,
  0x80000000, 0x80000000, 0xc92d8b22, 0xff76f420,
  0x80000000, 0x80000000, 0xc8fabd8a, 0xff767520,
  0x7ffe0002, 0x55555555, 0x3333999a, 0x007fff20,
  0xffff0002, 0xffff5555, 0xffff999a, 0xffffff20,
  0x80010000, 0xaaaa0001, 0xcccc0002, 0xff800020,
  0x80000000, 0x80000000, 0xaaa91112, 0xff2aaa20,
  0x80000000, 0x80000000, 0x962d8bf2, 0xfef77620,
  0x80000000, 0x80000000, 0x95fa57f2, 0xfef6f620,
  0x80000000, 0x80000000, 0x95c78a5a, 0xfef67720,
  0x80000000, 0x80000000, 0x9595232a, 0xfef5f920,
  0x80010000, 0xaaaa0001, 0xcccc0002, 0xff800020,
  0x80000000, 0x80000000, 0x9998666a, 0xff000120,
  0x80000000, 0x80000000, 0x80000000, 0xfeaaab20,
  0x80000000, 0x80000000, 0x80000000, 0xfe777720,
  0x80000000, 0x80000000, 0x80000000, 0xfe76f720,
  0x80000000, 0x80000000, 0x80000000, 0xfe767820,
  0x80000000, 0x80000000, 0x80000000, 0xfe75fa20,
  0x80000000, 0x80000000, 0x80000000, 0xfe757d20,
  0x8001fffe, 0xaaaaaaad, 0xcccc666a, 0xff800120,
  0x80000000, 0x80000000, 0xaaa9777a, 0xff2aab20,
  0x80000000, 0x80000000, 0x962df25a, 0xfef77720,
  0x80000000, 0x80000000, 0x95fabe5a, 0xfef6f720,
  0x80000000, 0x80000000, 0x95c7f0c2, 0xfef67820,
  0x80000000, 0x80000000, 0x95958992, 0xfef5fa20,
  0x80000000, 0x80000000, 0x956388ca, 0xfef57d20,
  0x80000000, 0x80000000, 0x955d224a, 0xfef56d20,
  0xaaaaaaac, 0xc71b8e39, 0xdddd1112, 0xffaaaa20,
  0x80000000, 0xa4f89f49, 0xc9618bf2, 0xff777620,
  0x80000000, 0xa4a34949, 0xc92e57f2, 0xff76f620,
  0x80000000, 0xa44e9df5, 0xc8fb8a5a, 0xff767720,
  0x80000000, 0xa3fa9d4d, 0xc8c9232a, 0xff75f920,
  0x80000000, 0xa3a74751, 0xc8972262, 0xff757c20,
  0x80000000, 0xa39c9c91, 0xc890bbe2, 0xff756c20,
  0x80000000, 0xa39a9c8d, 0xc88f88aa, 0xff756920,
  0xcccc6668, 0xdddd1111, 0xeb847ae2, 0xffcccc20,
  0xcc4c6768, 0xdd87bb11, 0xeb5146e2, 0xffcc4c20,
  0xcbcd6866, 0xdd330fbd, 0xeb1e794a, 0xffcbcd20,
  0xcb4f6962, 0xdcdf0f15, 0xeaec121a, 0xffcb4f20,
  0xcad26a5c, 0xdc8bb919, 0xeaba1152, 0xffcad220,
  0xcac26a7c, 0xdc810e59, 0xeab3aad2, 0xffcac220,
  0xcabf6a82, 0xdc7f0e55, 0xeab2779a, 0xffcabf20,
  0xcabd6a86, 0xdc7db8fd, 0xeab1aaca, 0xffcabd20,
  0xff800100, 0xffaaaa01, 0xffcccc02, 0xffff8020,
  0xff0101fe, 0xff55fead, 0xff99fe6a, 0xffff0120,
  0xfe8302fa, 0xff01fe05, 0xff67973a, 0xfffe8320,
  0xfe0603f4, 0xfeaea809, 0xff359672, 0xfffe0620,
  0xfdf60414, 0xfea3fd49, 0xff2f2ff2, 0xfffdf620,
  0xfdf3041a, 0xfea1fd45, 0xff2dfcba, 0xfffdf320,
  0xfdf1041e, 0xfea0a7ed, 0xff2d2fea, 0xfffdf120,
  0xfdf00420, 0xfe9ffd41, 0xff2cc982, 0xfffdf020,
  0xffab54ac, 0xffcd3269, 0xffff8102, 0xffff821e,
  0xff575404, 0xff9acb39, 0xffff0302, 0xffff051a,
  0xff03fe08, 0xff68ca71, 0xfffe8602, 0xfffe8914,
  0xfef95348, 0xff6263f1, 0xfffe7602, 0xfffe7934,
  0xfef75344, 0xff6130b9, 0xfffe7302, 0xfffe763a,
  0xfef5fdec, 0xff6063e9, 0xfffe7102, 0xfffe743e,
  0xfef55340, 0xff5ffd81, 0xfffe7002, 0xfffe7340,
  0xfef55340, 0xff5ffd81, 0xfffe7002, 0xfffe7340,
  0xffabff58, 0xffcd98d1, 0xffff8202, 0xffff831c,
  0xff58a95c, 0xff9b9809, 0xffff0502, 0xffff0716,
  0xff4dfe9c, 0xff953189, 0xfffef502, 0xfffef736,
  0xff4bfe98, 0xff93fe51, 0xfffef202, 0xfffef43c,
  0xff4aa940, 0xff933181, 0xfffef002, 0xfffef240,
  0xff49fe94, 0xff92cb19, 0xfffeef02, 0xfffef142,
  0xff49fe94, 0xff92cb19, 0xfffeef02, 0xfffef142,
  0xff4aa940, 0xff933181, 0xfffef002, 0xfffef240,
  0xffacaa04, 0xffcdff39, 0xffff8302, 0xffff841a,
  0xffa1ff44, 0xffc798b9, 0xffff7302, 0xffff743a,
  0xff9fff40, 0xffc66581, 0xffff7002, 0xffff7140,
  0xff9ea9e8, 0xffc598b1, 0xffff6e02, 0xffff6f44,
  0xff9dff3c, 0xffc53249, 0xffff6d02, 0xffff6e46,
  0xff9dff3c, 0xffc53249, 0xffff6d02, 0xffff6e46,
  0xff9ea9e8, 0xffc598b1, 0xffff6e02, 0xffff6f44,
  0xff9fff40, 0xffc66581, 0xffff7002, 0xffff7140,
  0xfff55540, 0xfff99981, 0xfffff002, 0xfffff040,
  0xfff3553c, 0xfff86649, 0xffffed02, 0xffffed46,
  0xfff1ffe4, 0xfff79979, 0xffffeb02, 0xffffeb4a,
  0xfff15538, 0xfff73311, 0xffffea02, 0xffffea4c,
  0xfff15538, 0xfff73311, 0xffffea02, 0xffffea4c,
  0xfff1ffe4, 0xfff79979, 0xffffeb02, 0xffffeb4a,
  0xfff3553c, 0xfff86649, 0xffffed02, 0xffffed46,
  0xfffdfffc, 0xfffeccc9, 0xfffffd02, 0xfffffd26,
  0xfffdfffc, 0xfffeccc9, 0xfffffd02, 0xfffffd26,
  0xfffcaaa4, 0xfffdfff9, 0xfffffb02, 0xfffffb2a,
  0xfffbfff8, 0xfffd9991, 0xfffffa02, 0xfffffa2c,
  0xfffbfff8, 0xfffd9991, 0xfffffa02, 0xfffffa2c,
  0xfffcaaa4, 0xfffdfff9, 0xfffffb02, 0xfffffb2a,
  0xfffdfffc, 0xfffeccc9, 0xfffffd02, 0xfffffd26,
  0x0008aabc, 0x00053349, 0x00000d02, 0x00000d06,
  0x005c00b8, 0x00373411, 0x00008a02, 0x0000890c,
  0xfffeaaa8, 0xffff3331, 0xfffffe02, 0xfffffe24,
  0xfffdfffc, 0xfffeccc9, 0xfffffd02, 0xfffffd26,
  0xfffdfffc, 0xfffeccc9, 0xfffffd02, 0xfffffd26,
  0xfffeaaa8, 0xffff3331, 0xfffffe02, 0xfffffe24,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x000aaac0, 0x00066681, 0x00001002, 0x00001000,
  0x005e00bc, 0x00386749, 0x00008d02, 0x00008c06,
  0x00b20164, 0x006ace79, 0x00010b02, 0x0001090a,
  0xffff5554, 0xffff9999, 0xffffff02, 0xffffff22,
  0xffff5554, 0xffff9999, 0xffffff02, 0xffffff22,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00015558, 0x0000ccd1, 0x00000202, 0x0000021c,
  0x000c0018, 0x00073351, 0x00001202, 0x000011fc,
  0x005f5614, 0x00393419, 0x00008f02, 0x00008e02,
  0x00b356bc, 0x006b9b49, 0x00010d02, 0x00010b06,
  0x01080210, 0x009e68e1, 0x00018c02, 0x00018908,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000aaac, 0x00006669, 0x00000102, 0x0000011e,
  0x00020004, 0x00013339, 0x00000302, 0x0000031a,
  0x000caac4, 0x000799b9, 0x00001302, 0x000012fa,
  0x006000c0, 0x00399a81, 0x00009002, 0x00008f00,
  0x00b40168, 0x006c01b1, 0x00010e02, 0x00010c04,
  0x0108acbc, 0x009ecf49, 0x00018d02, 0x00018a06,
  0x232af100, 0x1519ee01, 0x0034c002, 0x003456a0,
  0x0000aaac, 0x00006669, 0x00000102, 0x0000011e,
  0x00020004, 0x00013339, 0x00000302, 0x0000031a,
  0x000caac4, 0x000799b9, 0x00001302, 0x000012fa,
  0x006000c0, 0x00399a81, 0x00009002, 0x00008f00,
  0x00b40168, 0x006c01b1, 0x00010e02, 0x00010c04,
  0x0108acbc, 0x009ecf49, 0x00018d02, 0x00018a06,
  0x232af100, 0x1519ee01, 0x0034c002, 0x003456a0,
  0x5c0eb81c, 0x373c7689, 0x008a1502, 0x008900f6,
  0x00015558, 0x0000ccd1, 0x00000202, 0x0000021c,
  0x000c0018, 0x00073351, 0x00001202, 0x000011fc,
  0x005f5614, 0x00393419, 0x00008f02, 0x00008e02,
  0x00b356bc, 0x006b9b49, 0x00010d02, 0x00010b06,
  0x01080210, 0x009e68e1, 0x00018c02, 0x00018908,
  0x232a4654, 0x15198799, 0x0034bf02, 0x003455a2,
  0x5c0e0d70, 0x373c1021, 0x008a1402, 0x0088fff8,
  0x7fffffff, 0x6a6edce9, 0x010a1102, 0x0107fcfe,
  0x000aaac0, 0x00066681, 0x00001002, 0x00001000,
  0x005e00bc, 0x00386749, 0x00008d02, 0x00008c06,
  0x00b20164, 0x006ace79, 0x00010b02, 0x0001090a,
  0x0106acb8, 0x009d9c11, 0x00018a02, 0x0001870c,
  0x2328f0fc, 0x1518bac9, 0x0034bd02, 0x003453a6,
  0x5c0cb818, 0x373b4351, 0x008a1202, 0x0088fdfc,
  0x7fffffff, 0x6a6e1019, 0x010a0f02, 0x0107fb02,
  0x7fffffff, 0x7fffffff, 0x018a0d02, 0x0186f906,
  0x005355fc, 0x003200c9, 0x00007d02, 0x00007c26,
  0x00a756a4, 0x006467f9, 0x0000fb02, 0x0000f92a,
  0x00fc01f8, 0x00973591, 0x00017a02, 0x0001772c,
  0x231e463c, 0x15125449, 0x0034ad02, 0x003443c6,
  0x5c020d58, 0x3734dcd1, 0x008a0202, 0x0088ee1c,
  0x7fffffff, 0x6a67a999, 0x0109ff02, 0x0107eb22,
  0x7fffffff, 0x7fffffff, 0x0189fd02, 0x0186e926,
  0x7fffffff, 0x7fffffff, 0x0209fc02, 0x0205e828,
  0x005400a8, 0x00326731, 0x00007e02, 0x00007d24,
  0x00a8abfc, 0x006534c9, 0x0000fd02, 0x0000fb26,
  0x22caf040, 0x14e05381, 0x00343002, 0x0033c7c0,
  0x5baeb75c, 0x3702dc09, 0x00898502, 0x00887216,
  0x7fffffff, 0x6a35a8d1, 0x01098202, 0x01076f1c,
  0x7fffffff, 0x7fffffff, 0x01898002, 0x01866d20,
  0x7fffffff, 0x7fffffff, 0x02097f02, 0x02056c22,
  0x2aa9ffff, 0x4ccbffff, 0x01897f02, 0x01866c22,
  0x0054ab54, 0x0032cd99, 0x00007f02, 0x00007e22,
  0x2276ef98, 0x14adec51, 0x0033b202, 0x00334abc,
  0x5b5ab6b4, 0x36d074d9, 0x00890702, 0x0087f512,
  0x7fffffff, 0x6a0341a1, 0x01090402, 0x0106f218,
  0x7fffffff, 0x7fffffff, 0x01890202, 0x0185f01c,
  0x7fffffff, 0x7fffffff, 0x02090102, 0x0204ef1e,
  0x2aa9ffff, 0x4ccbffff, 0x01890102, 0x0185ef1e,
  0xd554aaab, 0x19986667, 0x01090202, 0x0106f01c,
  0x22224444, 0x147b1eb9, 0x00333302, 0x0032ccba,
  0x5b060b60, 0x369da741, 0x00888802, 0x00877710,
  0x7fffffff, 0x69d07409, 0x01088502, 0x01067416,
  0x7fffffff, 0x7fffffff, 0x01888302, 0x0185721a,
  0x7fffffff, 0x7fffffff, 0x02088202, 0x0204711c,
  0x2aa9ffff, 0x4ccbffff, 0x01888202, 0x0185711c,
  0xd554aaab, 0x19986667, 0x01088302, 0x0106721a,
  0x9c7038e3, 0xf7757777, 0x00b32d02, 0x00b1c6c6,
  0x38e3c71c, 0x22228889, 0x00555502, 0x0054aa76,
  0x7fffffff, 0x55555551, 0x00d55202, 0x00d3a77c,
  0x7fffffff, 0x7fffffff, 0x01555002, 0x0152a580,
  0x7fffffff, 0x7fffffff, 0x01d54f02, 0x01d1a482,
  0x2aa9ffff, 0x4ccbffff, 0x01554f02, 0x0152a482,
  0xd554aaab, 0x19986667, 0x00d55002, 0x00d3a580,
  0x9c7038e3, 0xf7757777, 0x007ffa02, 0x007efa2c,
  0x80000000, 0xe2f9f257, 0x004cc602, 0x004c2c94,
  0x5553fffc, 0x3332ccc9, 0x007ffd02, 0x007efd26,
  0x7fffffff, 0x6665fff9, 0x00fffb02, 0x00fdfb2a,
  0x7fffffff, 0x7fffffff, 0x017ffa02, 0x017cfa2c,
  0x2aa9ffff, 0x4ccbffff, 0x00fffa02, 0x00fdfa2c,
  0xd554aaab, 0x19986667, 0x007ffb02, 0x007efb2a,
  0x9c7038e3, 0xf7757777, 0x002aa502, 0x002a4fd6,
  0x80000000, 0xe2f9f257, 0xfff77102, 0xfff7823e,
  0x80000000, 0xe2c6be57, 0xfff6f102, 0xfff7033e,
  0x5554aaa8, 0x33333331, 0x007ffe02, 0x007efe24,
  0x7fffffff, 0x6666ccc9, 0x00fffd02, 0x00fdfd26,
  0x2aa9ffff, 0x3332ccc9, 0x007ffd02, 0x007efd26,
  0xd554aaab, 0xffff3331, 0xfffffe02, 0xfffffe24,
  0x9c7038e3, 0xdddc4441, 0xffaaa802, 0xffab52d0,
  0x80000000, 0xc960bf21, 0xff777402, 0xff788538,
  0x80000000, 0xc92d8b21, 0xff76f402, 0xff780638,
  0x80000000, 0xc8fabd89, 0xff767502, 0xff778836,
  0x55555554, 0x33339999, 0x007fff02, 0x007eff22,
  0xffff5554, 0xffff9999, 0xffffff02, 0xffffff22,
  0xaaaa0000, 0xcccc0001, 0xff800002, 0xff810020,
  0x80000000, 0xaaa91111, 0xff2aaa02, 0xff2c54cc,
  0x80000000, 0x962d8bf1, 0xfef77602, 0xfef98734,
  0x80000000, 0x95fa57f1, 0xfef6f602, 0xfef90834,
  0x80000000, 0x95c78a59, 0xfef67702, 0xfef88a32,
  0x80000000, 0x95952329, 0xfef5f902, 0xfef80d2e,
  0xaaaa0000, 0xcccc0001, 0xff800002, 0xff810020,
  0x80000000, 0x99986669, 0xff000102, 0xff02011e,
  0x80000000, 0x80000000, 0xfeaaab02, 0xfead55ca,
  0x80000000, 0x80000000, 0xfe777702, 0xfe7a8832,
  0x80000000, 0x80000000, 0xfe76f702, 0xfe7a0932,
  0x80000000, 0x80000000, 0xfe767802, 0xfe798b30,
  0x80000000, 0x80000000, 0xfe75fa02, 0xfe790e2c,
  0x80000000, 0x80000000, 0xfe757d02, 0xfe789226,
  0xaaaaaaac, 0xcccc6669, 0xff800102, 0xff81011e,
  0x80000000, 0xaaa97779, 0xff2aab02, 0xff2c55ca,
  0x80000000, 0x962df259, 0xfef77702, 0xfef98832,
  0x80000000, 0x95fabe59, 0xfef6f702, 0xfef90932,
  0x80000000, 0x95c7f0c1, 0xfef67802, 0xfef88b30,
  0x80000000, 0x95958991, 0xfef5fa02, 0xfef80e2c,
  0x80000000, 0x956388c9, 0xfef57d02, 0xfef79226,
  0x80000000, 0x955d2249, 0xfef56d02, 0xfef78246,
  0xc71b8e38, 0xdddd1111, 0xffaaaa02, 0xffab54cc,
  0xa4f89f48, 0xc9618bf1, 0xff777602, 0xff788734,
  0xa4a34948, 0xc92e57f1, 0xff76f602, 0xff780834,
  0xa44e9df4, 0xc8fb8a59, 0xff767702, 0xff778a32,
  0xa3fa9d4c, 0xc8c92329, 0xff75f902, 0xff770d2e,
  0xa3a74750, 0xc8972261, 0xff757c02, 0xff769128,
  0xa39c9c90, 0xc890bbe1, 0xff756c02, 0xff768148,
  0xa39a9c8c, 0xc88f88a9, 0xff756902, 0xff767e4e,
  0xdddd1110, 0xeb847ae1, 0xffcccc02, 0xffcd3288,
  0xdd87bb10, 0xeb5146e1, 0xffcc4c02, 0xffccb388,
  0xdd330fbc, 0xeb1e7949, 0xffcbcd02, 0xffcc3586,
  0xdcdf0f14, 0xeaec1219, 0xffcb4f02, 0xffcbb882,
  0xdc8bb918, 0xeaba1151, 0xffcad202, 0xffcb3c7c,
  0xdc810e58, 0xeab3aad1, 0xffcac202, 0xffcb2c9c,
  0xdc7f0e54, 0xeab27799, 0xffcabf02, 0xffcb29a2,
  0xdc7db8fc, 0xeab1aac9, 0xffcabd02, 0xffcb27a6,
  0xffaaaa00, 0xffcccc01, 0xffff8002, 0xffff8120,
  0xff55feac, 0xff99fe69, 0xffff0102, 0xffff031e,
  0xff01fe04, 0xff679739, 0xfffe8302, 0xfffe861a,
  0xfeaea808, 0xff359671, 0xfffe0602, 0xfffe0a14,
  0xfea3fd48, 0xff2f2ff1, 0xfffdf602, 0xfffdfa34,
  0xfea1fd44, 0xff2dfcb9, 0xfffdf302, 0xfffdf73a,
  0xfea0a7ec, 0xff2d2fe9, 0xfffdf102, 0xfffdf53e,
  0xfe9ffd40, 0xff2cc981, 0xfffdf002, 0xfffdf440,
  0xffcd3268, 0xffff8101, 0xffff8200, 0xffff831c,
  0xff9acb38, 0xffff0301, 0xffff04fc, 0xffff0714,
  0xff68ca70, 0xfffe8601, 0xfffe88f6, 0xfffe8c08,
  0xff6263f0, 0xfffe7601, 0xfffe7916, 0xfffe7c48,
  0xff6130b8, 0xfffe7301, 0xfffe761c, 0xfffe7954,
  0xff6063e8, 0xfffe7101, 0xfffe7420, 0xfffe775c,
  0xff5ffd80, 0xfffe7001, 0xfffe7322, 0xfffe7660,
  0xff5ffd80, 0xfffe7001, 0xfffe7322, 0xfffe7660,
  0xffcd98d0, 0xffff8201, 0xffff82fe, 0xffff8418,
  0xff9b9808, 0xffff0501, 0xffff06f8, 0xffff090c,
  0xff953188, 0xfffef501, 0xfffef718, 0xfffef94c,
  0xff93fe50, 0xfffef201, 0xfffef41e, 0xfffef658,
  0xff933180, 0xfffef001, 0xfffef222, 0xfffef460,
  0xff92cb18, 0xfffeef01, 0xfffef124, 0xfffef364,
  0xff92cb18, 0xfffeef01, 0xfffef124, 0xfffef364,
  0xff933180, 0xfffef001, 0xfffef222, 0xfffef460,
  0xffcdff38, 0xffff8301, 0xffff83fc, 0xffff8514,
  0xffc798b8, 0xffff7301, 0xffff741c, 0xffff7554,
  0xffc66580, 0xffff7001, 0xffff7122, 0xffff7260,
  0xffc598b0, 0xffff6e01, 0xffff6f26, 0xffff7068,
  0xffc53248, 0xffff6d01, 0xffff6e28, 0xffff6f6c,
  0xffc53248, 0xffff6d01, 0xffff6e28, 0xffff6f6c,
  0xffc598b0, 0xffff6e01, 0xffff6f26, 0xffff7068,
  0xffc66580, 0xffff7001, 0xffff7122, 0xffff7260,
  0xfff99980, 0xfffff001, 0xfffff022, 0xfffff060,
  0xfff86648, 0xffffed01, 0xffffed28, 0xffffed6c,
  0xfff79978, 0xffffeb01, 0xffffeb2c, 0xffffeb74,
  0xfff73310, 0xffffea01, 0xffffea2e, 0xffffea78,
  0xfff73310, 0xffffea01, 0xffffea2e, 0xffffea78,
  0xfff79978, 0xffffeb01, 0xffffeb2c, 0xffffeb74,
  0xfff86648, 0xffffed01, 0xffffed28, 0xffffed6c,
  0xfffeccc8, 0xfffffd01, 0xfffffd08, 0xfffffd2c,
  0xfffeccc8, 0xfffffd01, 0xfffffd08, 0xfffffd2c,
  0xfffdfff8, 0xfffffb01, 0xfffffb0c, 0xfffffb34,
  0xfffd9990, 0xfffffa01, 0xfffffa0e, 0xfffffa38,
  0xfffd9990, 0xfffffa01, 0xfffffa0e, 0xfffffa38,
  0xfffdfff8, 0xfffffb01, 0xfffffb0c, 0xfffffb34,
  0xfffeccc8, 0xfffffd01, 0xfffffd08, 0xfffffd2c,
  0x00053348, 0x00000d01, 0x00000ce8, 0x00000cec,
  0x00373410, 0x00008a01, 0x000088ee, 0x000087f8,
  0xffff3330, 0xfffffe01, 0xfffffe06, 0xfffffe28,
  0xfffeccc8, 0xfffffd01, 0xfffffd08, 0xfffffd2c,
  0xfffeccc8, 0xfffffd01, 0xfffffd08, 0xfffffd2c,
  0xffff3330, 0xfffffe01, 0xfffffe06, 0xfffffe28,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00066680, 0x00001001, 0x00000fe2, 0x00000fe0,
  0x00386748, 0x00008d01, 0x00008be8, 0x00008aec,
  0x006ace78, 0x00010b01, 0x000108ec, 0x000106f4,
  0xffff9998, 0xffffff01, 0xffffff04, 0xffffff24,
  0xffff9998, 0xffffff01, 0xffffff04, 0xffffff24,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000ccd0, 0x00000201, 0x000001fe, 0x00000218,
  0x00073350, 0x00001201, 0x000011de, 0x000011d8,
  0x00393418, 0x00008f01, 0x00008de4, 0x00008ce4,
  0x006b9b48, 0x00010d01, 0x00010ae8, 0x000108ec,
  0x009e68e0, 0x00018c01, 0x000188ea, 0x000185f0,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00006668, 0x00000101, 0x00000100, 0x0000011c,
  0x00013338, 0x00000301, 0x000002fc, 0x00000314,
  0x000799b8, 0x00001301, 0x000012dc, 0x000012d4,
  0x00399a80, 0x00009001, 0x00008ee2, 0x00008de0,
  0x006c01b0, 0x00010e01, 0x00010be6, 0x000109e8,
  0x009ecf48, 0x00018d01, 0x000189e8, 0x000186ec,
  0x1519ee00, 0x0034c001, 0x00345682, 0x0033ed20,
  0x00006668, 0x00000101, 0x00000100, 0x0000011c,
  0x00013338, 0x00000301, 0x000002fc, 0x00000314,
  0x000799b8, 0x00001301, 0x000012dc, 0x000012d4,
  0x00399a80, 0x00009001, 0x00008ee2, 0x00008de0,
  0x006c01b0, 0x00010e01, 0x00010be6, 0x000109e8,
  0x009ecf48, 0x00018d01, 0x000189e8, 0x000186ec,
  0x1519ee00, 0x0034c001, 0x00345682, 0x0033ed20,
  0x373c7688, 0x008a1501, 0x008900d8, 0x0087eccc,
  0x0000ccd0, 0x00000201, 0x000001fe, 0x00000218,
  0x00073350, 0x00001201, 0x000011de, 0x000011d8,
  0x00393418, 0x00008f01, 0x00008de4, 0x00008ce4,
  0x006b9b48, 0x00010d01, 0x00010ae8, 0x000108ec,
  0x009e68e0, 0x00018c01, 0x000188ea, 0x000185f0,
  0x15198798, 0x0034bf01, 0x00345584, 0x0033ec24,
  0x373c1020, 0x008a1401, 0x0088ffda, 0x0087ebd0,
  0x6a6edce8, 0x010a1101, 0x0107fce0, 0x0105e8dc,
  0x00066680, 0x00001001, 0x00000fe2, 0x00000fe0,
  0x00386748, 0x00008d01, 0x00008be8, 0x00008aec,
  0x006ace78, 0x00010b01, 0x000108ec, 0x000106f4,
  0x009d9c10, 0x00018a01, 0x000186ee, 0x000183f8,
  0x1518bac8, 0x0034bd01, 0x00345388, 0x0033ea2c,
  0x373b4350, 0x008a1201, 0x0088fdde, 0x0087e9d8,
  0x6a6e1018, 0x010a0f01, 0x0107fae4, 0x0105e6e4,
  0x7fffffff, 0x018a0d01, 0x0186f8e8, 0x0183e4ec,
  0x003200c8, 0x00007d01, 0x00007c08, 0x00007b2c,
  0x006467f8, 0x0000fb01, 0x0000f90c, 0x0000f734,
  0x00973590, 0x00017a01, 0x0001770e, 0x00017438,
  0x15125448, 0x0034ad01, 0x003443a8, 0x0033da6c,
  0x3734dcd0, 0x008a0201, 0x0088edfe, 0x0087da18,
  0x6a67a998, 0x0109ff01, 0x0107eb04, 0x0105d724,
  0x7fffffff, 0x0189fd01, 0x0186e908, 0x0183d52c,
  0x7fffffff, 0x0209fc01, 0x0205e80a, 0x0201d430,
  0x00326730, 0x00007e01, 0x00007d06, 0x00007c28,
  0x006534c8, 0x0000fd01, 0x0000fb08, 0x0000f92c,
  0x14e05380, 0x00343001, 0x0033c7a2, 0x00335f60,
  0x3702dc08, 0x00898501, 0x008871f8, 0x00875f0c,
  0x6a35a8d0, 0x01098201, 0x01076efe, 0x01055c18,
  0x7fffffff, 0x01898001, 0x01866d02, 0x01835a20,
  0x7fffffff, 0x02097f01, 0x02056c04, 0x02015924,
  0x4ccbffff, 0x01897f01, 0x01866c04, 0x01835924,
  0x0032cd98, 0x00007f01, 0x00007e04, 0x00007d24,
  0x14adec50, 0x0033b201, 0x00334a9e, 0x0032e358,
  0x36d074d8, 0x00890701, 0x0087f4f4, 0x0086e304,
  0x6a0341a0, 0x01090401, 0x0106f1fa, 0x0104e010,
  0x7fffffff, 0x01890201, 0x0185effe, 0x0182de18,
  0x7fffffff, 0x02090101, 0x0204ef00, 0x0200dd1c,
  0x4ccbffff, 0x01890101, 0x0185ef00, 0x0182dd1c,
  0x19986667, 0x01090201, 0x0106effe, 0x0104de18,
  0x147b1eb8, 0x00333301, 0x0032cc9c, 0x00326654,
  0x369da740, 0x00888801, 0x008776f2, 0x00866600,
  0x69d07408, 0x01088501, 0x010673f8, 0x0104630c,
  0x7fffffff, 0x01888301, 0x018571fc, 0x01826114,
  0x7fffffff, 0x02088201, 0x020470fe, 0x02006018,
  0x4ccbffff, 0x01888201, 0x018570fe, 0x01826018,
  0x19986667, 0x01088301, 0x010671fc, 0x01046114,
  0xf7757777, 0x00b32d01, 0x00b1c6a8, 0x00b0606c,
  0x22228888, 0x00555501, 0x0054aa58, 0x0053ffcc,
  0x55555550, 0x00d55201, 0x00d3a75e, 0x00d1fcd8,
  0x7fffffff, 0x01555001, 0x0152a562, 0x014ffae0,
  0x7fffffff, 0x01d54f01, 0x01d1a464, 0x01cdf9e4,
  0x4ccbffff, 0x01554f01, 0x0152a464, 0x014ff9e4,
  0x19986667, 0x00d55001, 0x00d3a562, 0x00d1fae0,
  0xf7757777, 0x007ffa01, 0x007efa0e, 0x007dfa38,
  0xe2f9f257, 0x004cc601, 0x004c2c76, 0x004b9308,
  0x3332ccc8, 0x007ffd01, 0x007efd08, 0x007dfd2c,
  0x6665fff8, 0x00fffb01, 0x00fdfb0c, 0x00fbfb34,
  0x7fffffff, 0x017ffa01, 0x017cfa0e, 0x0179fa38,
  0x4ccbffff, 0x00fffa01, 0x00fdfa0e, 0x00fbfa38,
  0x19986667, 0x007ffb01, 0x007efb0c, 0x007dfb34,
  0xf7757777, 0x002aa501, 0x002a4fb8, 0x0029fa8c,
  0xe2f9f257, 0xfff77101, 0xfff78220, 0xfff7935c,
  0xe2c6be57, 0xfff6f101, 0xfff70320, 0xfff7155c,
  0x33333330, 0x007ffe01, 0x007efe06, 0x007dfe28,
  0x6666ccc8, 0x00fffd01, 0x00fdfd08, 0x00fbfd2c,
  0x3332ccc8, 0x007ffd01, 0x007efd08, 0x007dfd2c,
  0xffff3330, 0xfffffe01, 0xfffffe06, 0xfffffe28,
  0xdddc4440, 0xffaaa801, 0xffab52b2, 0xffabfd80,
  0xc960bf20, 0xff777401, 0xff78851a, 0xff799650,
  0xc92d8b20, 0xff76f401, 0xff78061a, 0xff791850,
  0xc8fabd88, 0xff767501, 0xff778818, 0xff789b4c,
  0x33339998, 0x007fff01, 0x007eff04, 0x007dff24,
  0xffff9998, 0xffffff01, 0xffffff04, 0xffffff24,
  0xcccc0000, 0xff800001, 0xff810002, 0xff820020,
  0xaaa91110, 0xff2aaa01, 0xff2c54ae, 0xff2dff78,
  0x962d8bf0, 0xfef77601, 0xfef98716, 0xfefb9848,
  0x95fa57f0, 0xfef6f601, 0xfef90816, 0xfefb1a48,
  0x95c78a58, 0xfef67701, 0xfef88a14, 0xfefa9d44,
  0x95952328, 0xfef5f901, 0xfef80d10, 0xfefa213c,
  0xcccc0000, 0xff800001, 0xff810002, 0xff820020,
  0x99986668, 0xff000101, 0xff020100, 0xff04011c,
  0x80000000, 0xfeaaab01, 0xfead55ac, 0xfeb00074,
  0x80000000, 0xfe777701, 0xfe7a8814, 0xfe7d9944,
  0x80000000, 0xfe76f701, 0xfe7a0914, 0xfe7d1b44,
  0x80000000, 0xfe767801, 0xfe798b12, 0xfe7c9e40,
  0x80000000, 0xfe75fa01, 0xfe790e0e, 0xfe7c2238,
  0x80000000, 0xfe757d01, 0xfe789208, 0xfe7ba72c,
  0xcccc6668, 0xff800101, 0xff810100, 0xff82011c,
  0xaaa97778, 0xff2aab01, 0xff2c55ac, 0xff2e0074,
  0x962df258, 0xfef77701, 0xfef98814, 0xfefb9944,
  0x95fabe58, 0xfef6f701, 0xfef90914, 0xfefb1b44,
  0x95c7f0c0, 0xfef67801, 0xfef88b12, 0xfefa9e40,
  0x95958990, 0xfef5fa01, 0xfef80e0e, 0xfefa2238,
  0x956388c8, 0xfef57d01, 0xfef79208, 0xfef9a72c,
  0x955d2248, 0xfef56d01, 0xfef78228, 0xfef9976c,
  0xdddd1110, 0xffaaaa01, 0xffab54ae, 0xffabff78,
  0xc9618bf0, 0xff777601, 0xff788716, 0xff799848,
  0xc92e57f0, 0xff76f601, 0xff780816, 0xff791a48,
  0xc8fb8a58, 0xff767701, 0xff778a14, 0xff789d44,
  0xc8c92328, 0xff75f901, 0xff770d10, 0xff78213c,
  0xc8972260, 0xff757c01, 0xff76910a, 0xff77a630,
  0xc890bbe0, 0xff756c01, 0xff76812a, 0xff779670,
  0xc88f88a8, 0xff756901, 0xff767e30, 0xff77937c,
  0xeb847ae0, 0xffcccc01, 0xffcd326a, 0xffcd98f0,
  0xeb5146e0, 0xffcc4c01, 0xffccb36a, 0xffcd1af0,
  0xeb1e7948, 0xffcbcd01, 0xffcc3568, 0xffcc9dec,
  0xeaec1218, 0xffcb4f01, 0xffcbb864, 0xffcc21e4,
  0xeaba1150, 0xffcad201, 0xffcb3c5e, 0xffcba6d8,
  0xeab3aad0, 0xffcac201, 0xffcb2c7e, 0xffcb9718,
  0xeab27798, 0xffcabf01, 0xffcb2984, 0xffcb9424,
  0xeab1aac8, 0xffcabd01, 0xffcb2788, 0xffcb922c,
  0xffcccc00, 0xffff8001, 0xffff8102, 0xffff8220,
  0xff99fe68, 0xffff0101, 0xffff0300, 0xffff051c,
  0xff679738, 0xfffe8301, 0xfffe85fc, 0xfffe8914,
  0xff359670, 0xfffe0601, 0xfffe09f6, 0xfffe0e08,
  0xff2f2ff0, 0xfffdf601, 0xfffdfa16, 0xfffdfe48,
  0xff2dfcb8, 0xfffdf301, 0xfffdf71c, 0xfffdfb54,
  0xff2d2fe8, 0xfffdf101, 0xfffdf520, 0xfffdf95c,
  0xff2cc980, 0xfffdf001, 0xfffdf422, 0xfffdf860,
  0xffff8100, 0xffff81ff, 0xffff82fe, 0xffff841a,
  0xffff0300, 0xffff04fb, 0xffff06f6, 0xffff090e,
  0xfffe8600, 0xfffe88f5, 0xfffe8bea, 0xfffe8efc,
  0xfffe7600, 0xfffe7915, 0xfffe7c2a, 0xfffe7f5c,
  0xfffe7300, 0xfffe761b, 0xfffe7936, 0xfffe7c6e,
  0xfffe7100, 0xfffe741f, 0xfffe773e, 0xfffe7a7a,
  0xfffe7000, 0xfffe7321, 0xfffe7642, 0xfffe7980,
  0xfffe7000, 0xfffe7321, 0xfffe7642, 0xfffe7980,
  0xffff8200, 0xffff82fd, 0xffff83fa, 0xffff8514,
  0xffff0500, 0xffff06f7, 0xffff08ee, 0xffff0b02,
  0xfffef500, 0xfffef717, 0xfffef92e, 0xfffefb62,
  0xfffef200, 0xfffef41d, 0xfffef63a, 0xfffef874,
  0xfffef000, 0xfffef221, 0xfffef442, 0xfffef680,
  0xfffeef00, 0xfffef123, 0xfffef346, 0xfffef586,
  0xfffeef00, 0xfffef123, 0xfffef346, 0xfffef586,
  0xfffef000, 0xfffef221, 0xfffef442, 0xfffef680,
  0xffff8300, 0xffff83fb, 0xffff84f6, 0xffff860e,
  0xffff7300, 0xffff741b, 0xffff7536, 0xffff766e,
  0xffff7000, 0xffff7121, 0xffff7242, 0xffff7380,
  0xffff6e00, 0xffff6f25, 0xffff704a, 0xffff718c,
  0xffff6d00, 0xffff6e27, 0xffff6f4e, 0xffff7092,
  0xffff6d00, 0xffff6e27, 0xffff6f4e, 0xffff7092,
  0xffff6e00, 0xffff6f25, 0xffff704a, 0xffff718c,
  0xffff7000, 0xffff7121, 0xffff7242, 0xffff7380,
  0xfffff000, 0xfffff021, 0xfffff042, 0xfffff080,
  0xffffed00, 0xffffed27, 0xffffed4e, 0xffffed92,
  0xffffeb00, 0xffffeb2b, 0xffffeb56, 0xffffeb9e,
  0xffffea00, 0xffffea2d, 0xffffea5a, 0xffffeaa4,
  0xffffea00, 0xffffea2d, 0xffffea5a, 0xffffeaa4,
  0xffffeb00, 0xffffeb2b, 0xffffeb56, 0xffffeb9e,
  0xffffed00, 0xffffed27, 0xffffed4e, 0xffffed92,
  0xfffffd00, 0xfffffd07, 0xfffffd0e, 0xfffffd32,
  0xfffffd00, 0xfffffd07, 0xfffffd0e, 0xfffffd32,
  0xfffffb00, 0xfffffb0b, 0xfffffb16, 0xfffffb3e,
  0xfffffa00, 0xfffffa0d, 0xfffffa1a, 0xfffffa44,
  0xfffffa00, 0xfffffa0d, 0xfffffa1a, 0xfffffa44,
  0xfffffb00, 0xfffffb0b, 0xfffffb16, 0xfffffb3e,
  0xfffffd00, 0xfffffd07, 0xfffffd0e, 0xfffffd32,
  0x00000d00, 0x00000ce7, 0x00000cce, 0x00000cd2,
  0x00008a00, 0x000088ed, 0x000087da, 0x000086e4,
  0xfffffe00, 0xfffffe05, 0xfffffe0a, 0xfffffe2c,
  0xfffffd00, 0xfffffd07, 0xfffffd0e, 0xfffffd32,
  0xfffffd00, 0xfffffd07, 0xfffffd0e, 0xfffffd32,
  0xfffffe00, 0xfffffe05, 0xfffffe0a, 0xfffffe2c,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00001000, 0x00000fe1, 0x00000fc2, 0x00000fc0,
  0x00008d00, 0x00008be7, 0x00008ace, 0x000089d2,
  0x00010b00, 0x000108eb, 0x000106d6, 0x000104de,
  0xffffff00, 0xffffff03, 0xffffff06, 0xffffff26,
  0xffffff00, 0xffffff03, 0xffffff06, 0xffffff26,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000200, 0x000001fd, 0x000001fa, 0x00000214,
  0x00001200, 0x000011dd, 0x000011ba, 0x000011b4,
  0x00008f00, 0x00008de3, 0x00008cc6, 0x00008bc6,
  0x00010d00, 0x00010ae7, 0x000108ce, 0x000106d2,
  0x00018c00, 0x000188e9, 0x000185d2, 0x000182d8,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000100, 0x000000ff, 0x000000fe, 0x0000011a,
  0x00000300, 0x000002fb, 0x000002f6, 0x0000030e,
  0x00001300, 0x000012db, 0x000012b6, 0x000012ae,
  0x00009000, 0x00008ee1, 0x00008dc2, 0x00008cc0,
  0x00010e00, 0x00010be5, 0x000109ca, 0x000107cc,
  0x00018d00, 0x000189e7, 0x000186ce, 0x000183d2,
  0x0034c000, 0x00345681, 0x0033ed02, 0x003383a0,
  0x00000100, 0x000000ff, 0x000000fe, 0x0000011a,
  0x00000300, 0x000002fb, 0x000002f6, 0x0000030e,
  0x00001300, 0x000012db, 0x000012b6, 0x000012ae,
  0x00009000, 0x00008ee1, 0x00008dc2, 0x00008cc0,
  0x00010e00, 0x00010be5, 0x000109ca, 0x000107cc,
  0x00018d00, 0x000189e7, 0x000186ce, 0x000183d2,
  0x0034c000, 0x00345681, 0x0033ed02, 0x003383a0,
  0x008a1500, 0x008900d7, 0x0087ecae, 0x0086d8a2,
  0x00000200, 0x000001fd, 0x000001fa, 0x00000214,
  0x00001200, 0x000011dd, 0x000011ba, 0x000011b4,
  0x00008f00, 0x00008de3, 0x00008cc6, 0x00008bc6,
  0x00010d00, 0x00010ae7, 0x000108ce, 0x000106d2,
  0x00018c00, 0x000188e9, 0x000185d2, 0x000182d8,
  0x0034bf00, 0x00345583, 0x0033ec06, 0x003382a6,
  0x008a1400, 0x0088ffd9, 0x0087ebb2, 0x0086d7a8,
  0x010a1100, 0x0107fcdf, 0x0105e8be, 0x0103d4ba,
  0x00001000, 0x00000fe1, 0x00000fc2, 0x00000fc0,
  0x00008d00, 0x00008be7, 0x00008ace, 0x000089d2,
  0x00010b00, 0x000108eb, 0x000106d6, 0x000104de,
  0x00018a00, 0x000186ed, 0x000183da, 0x000180e4,
  0x0034bd00, 0x00345387, 0x0033ea0e, 0x003380b2,
  0x008a1200, 0x0088fddd, 0x0087e9ba, 0x0086d5b4,
  0x010a0f00, 0x0107fae3, 0x0105e6c6, 0x0103d2c6,
  0x018a0d00, 0x0186f8e7, 0x0183e4ce, 0x0180d0d2,
  0x00007d00, 0x00007c07, 0x00007b0e, 0x00007a32,
  0x0000fb00, 0x0000f90b, 0x0000f716, 0x0000f53e,
  0x00017a00, 0x0001770d, 0x0001741a, 0x00017144,
  0x0034ad00, 0x003443a7, 0x0033da4e, 0x00337112,
  0x008a0200, 0x0088edfd, 0x0087d9fa, 0x0086c614,
  0x0109ff00, 0x0107eb03, 0x0105d706, 0x0103c326,
  0x0189fd00, 0x0186e907, 0x0183d50e, 0x0180c132,
  0x0209fc00, 0x0205e809, 0x0201d412, 0x01fdc038,
  0x00007e00, 0x00007d05, 0x00007c0a, 0x00007b2c,
  0x0000fd00, 0x0000fb07, 0x0000f90e, 0x0000f732,
  0x00343000, 0x0033c7a1, 0x00335f42, 0x0032f700,
  0x00898500, 0x008871f7, 0x00875eee, 0x00864c02,
  0x01098200, 0x01076efd, 0x01055bfa, 0x01034914,
  0x01898000, 0x01866d01, 0x01835a02, 0x01804720,
  0x02097f00, 0x02056c03, 0x02015906, 0x01fd4626,
  0x01897f00, 0x01866c03, 0x01835906, 0x01804626,
  0x00007f00, 0x00007e03, 0x00007d06, 0x00007c26,
  0x0033b200, 0x00334a9d, 0x0032e33a, 0x00327bf4,
  0x00890700, 0x0087f4f3, 0x0086e2e6, 0x0085d0f6,
  0x01090400, 0x0106f1f9, 0x0104dff2, 0x0102ce08,
  0x01890200, 0x0185effd, 0x0182ddfa, 0x017fcc14,
  0x02090100, 0x0204eeff, 0x0200dcfe, 0x01fccb1a,
  0x01890100, 0x0185eeff, 0x0182dcfe, 0x017fcb1a,
  0x01090200, 0x0106effd, 0x0104ddfa, 0x0102cc14,
  0x00333300, 0x0032cc9b, 0x00326636, 0x0031ffee,
  0x00888800, 0x008776f1, 0x008665e2, 0x008554f0,
  0x01088500, 0x010673f7, 0x010462ee, 0x01025202,
  0x01888300, 0x018571fb, 0x018260f6, 0x017f500e,
  0x02088200, 0x020470fd, 0x02005ffa, 0x01fc4f14,
  0x01888200, 0x018570fd, 0x01825ffa, 0x017f4f14,
  0x01088300, 0x010671fb, 0x010460f6, 0x0102500e,
  0x00b32d00, 0x00b1c6a7, 0x00b0604e, 0x00aefa12,
  0x00555500, 0x0054aa57, 0x0053ffae, 0x00535522,
  0x00d55200, 0x00d3a75d, 0x00d1fcba, 0x00d05234,
  0x01555000, 0x0152a561, 0x014ffac2, 0x014d5040,
  0x01d54f00, 0x01d1a463, 0x01cdf9c6, 0x01ca4f46,
  0x01554f00, 0x0152a463, 0x014ff9c6, 0x014d4f46,
  0x00d55000, 0x00d3a561, 0x00d1fac2, 0x00d05040,
  0x007ffa00, 0x007efa0d, 0x007dfa1a, 0x007cfa44,
  0x004cc600, 0x004c2c75, 0x004b92ea, 0x004af97c,
  0x007ffd00, 0x007efd07, 0x007dfd0e, 0x007cfd32,
  0x00fffb00, 0x00fdfb0b, 0x00fbfb16, 0x00f9fb3e,
  0x017ffa00, 0x017cfa0d, 0x0179fa1a, 0x0176fa44,
  0x00fffa00, 0x00fdfa0d, 0x00fbfa1a, 0x00f9fa44,
  0x007ffb00, 0x007efb0b, 0x007dfb16, 0x007cfb3e,
  0x002aa500, 0x002a4fb7, 0x0029fa6e, 0x0029a542,
  0xfff77100, 0xfff7821f, 0xfff7933e, 0xfff7a47a,
  0xfff6f100, 0xfff7031f, 0xfff7153e, 0xfff7277a,
  0x007ffe00, 0x007efe05, 0x007dfe0a, 0x007cfe2c,
  0x00fffd00, 0x00fdfd07, 0x00fbfd0e, 0x00f9fd32,
  0x007ffd00, 0x007efd07, 0x007dfd0e, 0x007cfd32,
  0xfffffe00, 0xfffffe05, 0xfffffe0a, 0xfffffe2c,
  0xffaaa800, 0xffab52b1, 0xffabfd62, 0xffaca830,
  0xff777400, 0xff788519, 0xff799632, 0xff7aa768,
  0xff76f400, 0xff780619, 0xff791832, 0xff7a2a68,
  0xff767500, 0xff778817, 0xff789b2e, 0xff79ae62,
  0x007fff00, 0x007eff03, 0x007dff06, 0x007cff26,
  0xffffff00, 0xffffff03, 0xffffff06, 0xffffff26,
  0xff800000, 0xff810001, 0xff820002, 0xff830020,
  0xff2aaa00, 0xff2c54ad, 0xff2dff5a, 0xff2faa24,
  0xfef77600, 0xfef98715, 0xfefb982a, 0xfefda95c,
  0xfef6f600, 0xfef90815, 0xfefb1a2a, 0xfefd2c5c,
  0xfef67700, 0xfef88a13, 0xfefa9d26, 0xfefcb056,
  0xfef5f900, 0xfef80d0f, 0xfefa211e, 0xfefc354a,
  0xff800000, 0xff810001, 0xff820002, 0xff830020,
  0xff000100, 0xff0200ff, 0xff0400fe, 0xff06011a,
  0xfeaaab00, 0xfead55ab, 0xfeb00056, 0xfeb2ab1e,
  0xfe777700, 0xfe7a8813, 0xfe7d9926, 0xfe80aa56,
  0xfe76f700, 0xfe7a0913, 0xfe7d1b26, 0xfe802d56,
  0xfe767800, 0xfe798b11, 0xfe7c9e22, 0xfe7fb150,
  0xfe75fa00, 0xfe790e0d, 0xfe7c221a, 0xfe7f3644,
  0xfe757d00, 0xfe789207, 0xfe7ba70e, 0xfe7ebc32,
  0xff800100, 0xff8100ff, 0xff8200fe, 0xff83011a,
  0xff2aab00, 0xff2c55ab, 0xff2e0056, 0xff2fab1e,
  0xfef77700, 0xfef98813, 0xfefb9926, 0xfefdaa56,
  0xfef6f700, 0xfef90913, 0xfefb1b26, 0xfefd2d56,
  0xfef67800, 0xfef88b11, 0xfefa9e22, 0xfefcb150,
  0xfef5fa00, 0xfef80e0d, 0xfefa221a, 0xfefc3644,
  0xfef57d00, 0xfef79207, 0xfef9a70e, 0xfefbbc32,
  0xfef56d00, 0xfef78227, 0xfef9974e, 0xfefbac92,
  0xffaaaa00, 0xffab54ad, 0xffabff5a, 0xffacaa24,
  0xff777600, 0xff788715, 0xff79982a, 0xff7aa95c,
  0xff76f600, 0xff780815, 0xff791a2a, 0xff7a2c5c,
  0xff767700, 0xff778a13, 0xff789d26, 0xff79b056,
  0xff75f900, 0xff770d0f, 0xff78211e, 0xff79354a,
  0xff757c00, 0xff769109, 0xff77a612, 0xff78bb38,
  0xff756c00, 0xff768129, 0xff779652, 0xff78ab98,
  0xff756900, 0xff767e2f, 0xff77935e, 0xff78a8aa,
  0xffcccc00, 0xffcd3269, 0xffcd98d2, 0xffcdff58,
  0xffcc4c00, 0xffccb369, 0xffcd1ad2, 0xffcd8258,
  0xffcbcd00, 0xffcc3567, 0xffcc9dce, 0xffcd0652,
  0xffcb4f00, 0xffcbb863, 0xffcc21c6, 0xffcc8b46,
  0xffcad200, 0xffcb3c5d, 0xffcba6ba, 0xffcc1134,
  0xffcac200, 0xffcb2c7d, 0xffcb96fa, 0xffcc0194,
  0xffcabf00, 0xffcb2983, 0xffcb9406, 0xffcbfea6,
  0xffcabd00, 0xffcb2787, 0xffcb920e, 0xffcbfcb2,
  0xffff8000, 0xffff8101, 0xffff8202, 0xffff8320,
  0xffff0100, 0xffff02ff, 0xffff04fe, 0xffff071a,
  0xfffe8300, 0xfffe85fb, 0xfffe88f6, 0xfffe8c0e,
  0xfffe0600, 0xfffe09f5, 0xfffe0dea, 0xfffe11fc,
  0xfffdf600, 0xfffdfa15, 0xfffdfe2a, 0xfffe025c,
  0xfffdf300, 0xfffdf71b, 0xfffdfb36, 0xfffdff6e,
  0xfffdf100, 0xfffdf51f, 0xfffdf93e, 0xfffdfd7a,
  0xfffdf000, 0xfffdf421, 0xfffdf842, 0xfffdfc80,
};
const unsigned kExpectedCount_NEON_sqdmlsl_4S_4H_H = 4608;

#endif  // VIXL_SIM_SQDMLSL_4S_4H_H_TRACE_AARCH64_H_
