/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.extras.swt;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Transform;
import org.piccolo2d.extras.swt.SWTShapeManager;

public class SWTGraphics2D
extends Graphics2D {
    private static final int DEFAULT_FONT_SIZE = 12;
    private static final boolean DEFAULT_STRING_TRANSPARENCY = true;
    private static final float DEFAULT_TRANSPARENCY = 1.0f;
    protected static int CACHE_COUNT = 0;
    protected static final HashMap FONT_CACHE = new HashMap();
    protected static final HashMap COLOR_CACHE = new HashMap();
    protected static final HashMap SHAPE_CACHE = new HashMap();
    protected static final BufferedImage BUFFER = new BufferedImage(1, 1, 2);
    private static final java.awt.Point TEMP_POINT = new java.awt.Point();
    private static final Rectangle2D TEMP_RECT = new Rectangle2D.Double();
    private static final Rectangle2D TEMP_LINE_RECT = new Rectangle2D.Double();
    private static final org.eclipse.swt.graphics.Rectangle SWT_RECT = new org.eclipse.swt.graphics.Rectangle(0, 0, 0, 0);
    protected GC gc;
    protected Device device;
    protected AffineTransform transform = new AffineTransform();
    private final Transform swtTransform;
    protected Font curFont;
    protected double lineWidth = 1.0;
    private float transparency = 1.0f;

    public SWTGraphics2D(GC gc, Device device) {
        this.gc = gc;
        this.device = device;
        this.swtTransform = new Transform(device);
        gc.setAntialias(1);
    }

    public Rectangle getClipBounds() {
        org.eclipse.swt.graphics.Rectangle rect = this.gc.getClipping();
        Rectangle aRect = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        try {
            SWTShapeManager.transform(aRect, this.transform.createInverse());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return aRect;
    }

    public void clipRect(int x, int y, int width, int height) {
        TEMP_RECT.setRect(x, y, width, height);
        SWTShapeManager.transform(TEMP_RECT, this.transform);
        SWTShapeManager.awtToSWT(TEMP_RECT, SWT_RECT);
        org.eclipse.swt.graphics.Rectangle clip = this.gc.getClipping();
        clip = clip.intersection(SWT_RECT);
        this.gc.setClipping(clip);
    }

    public void setClip(int x, int y, int width, int height) {
        TEMP_RECT.setRect(x, y, width, height);
        SWTShapeManager.transform(TEMP_RECT, this.transform);
        SWTShapeManager.awtToSWT(TEMP_RECT, SWT_RECT);
        this.gc.setClipping(SWT_RECT);
    }

    public void clip(Shape s) {
        Rectangle2D clipBds = s.getBounds2D();
        SWTShapeManager.transform(clipBds, this.transform);
        SWTShapeManager.awtToSWT(clipBds, SWT_RECT);
        org.eclipse.swt.graphics.Rectangle clip = this.gc.getClipping();
        clip = clip.intersection(SWT_RECT);
        this.gc.setClipping(SWT_RECT);
    }

    public void setClip(Shape clip) {
        if (clip == null) {
            this.gc.setClipping((org.eclipse.swt.graphics.Rectangle)null);
        } else {
            Rectangle2D clipBds = clip.getBounds2D();
            SWTShapeManager.transform(clipBds, this.transform);
            SWTShapeManager.awtToSWT(clipBds, SWT_RECT);
            this.gc.setClipping(SWT_RECT);
        }
    }

    public Shape getClip() {
        org.eclipse.swt.graphics.Rectangle rect = this.gc.getClipping();
        Rectangle2D.Double aRect = new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height);
        try {
            SWTShapeManager.transform(aRect, this.transform.createInverse());
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e);
        }
        return aRect;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return ((Graphics2D)BUFFER.getGraphics()).getDeviceConfiguration();
    }

    public Paint getPaint() {
        return this.getColor();
    }

    public void setPaint(Paint paint) {
        if (paint instanceof Color) {
            this.setColor((Color)paint);
        }
    }

    public Color getColor() {
        org.eclipse.swt.graphics.Color color = this.gc.getForeground();
        Color awtColor = new Color(color.getRed(), color.getGreen(), color.getBlue());
        return awtColor;
    }

    public void setColor(Color c) {
        org.eclipse.swt.graphics.Color cachedColor = (org.eclipse.swt.graphics.Color)COLOR_CACHE.get(c);
        if (cachedColor == null) {
            cachedColor = new org.eclipse.swt.graphics.Color(this.device, c.getRed(), c.getGreen(), c.getBlue());
            COLOR_CACHE.put(c, cachedColor);
        }
        this.gc.setForeground(cachedColor);
    }

    public void setColor(org.eclipse.swt.graphics.Color foregroundColor) {
        this.gc.setForeground(foregroundColor);
    }

    public void setBackground(Color c) {
        org.eclipse.swt.graphics.Color cachedColor = (org.eclipse.swt.graphics.Color)COLOR_CACHE.get(c);
        if (cachedColor == null) {
            cachedColor = new org.eclipse.swt.graphics.Color(this.device, c.getRed(), c.getGreen(), c.getBlue());
            COLOR_CACHE.put(c, cachedColor);
        }
        this.gc.setBackground(cachedColor);
    }

    public void setBackground(org.eclipse.swt.graphics.Color backgroundColor) {
        this.gc.setBackground(backgroundColor);
    }

    public Color getBackground() {
        org.eclipse.swt.graphics.Color color = this.gc.getBackground();
        Color awtColor = new Color(color.getRed(), color.getGreen(), color.getBlue());
        return awtColor;
    }

    public Font getSWTFont() {
        return this.curFont;
    }

    public FontMetrics getSWTFontMetrics() {
        this.gc.setFont(this.curFont);
        return this.gc.getFontMetrics();
    }

    public java.awt.Font getFont() {
        if (this.curFont != null) {
            int style = 0;
            FontData[] fd = this.curFont.getFontData();
            if (fd.length > 0) {
                if ((fd[0].getStyle() & 1) != 0) {
                    style |= 1;
                }
                if ((fd[0].getStyle() & 2) != 0) {
                    style |= 2;
                }
                return new java.awt.Font(fd[0].getName(), style, fd[0].getHeight());
            }
            return null;
        }
        return null;
    }

    public void setFont(java.awt.Font font) {
        String fontString = "name=" + font.getFamily() + ";bold=" + font.isBold() + ";italic=" + font.isItalic() + ";size=" + font.getSize();
        this.curFont = this.getFont(fontString);
    }

    public void setFont(Font font) {
        this.curFont = font;
    }

    public Font getFont(String fontString) {
        Font cachedFont = (Font)FONT_CACHE.get(fontString);
        if (cachedFont == null) {
            int style = 0;
            if (fontString.indexOf("bold=true") != -1) {
                style |= 1;
            }
            if (fontString.indexOf("italic=true") != -1) {
                style |= 2;
            }
            String name = fontString.substring(0, fontString.indexOf(";"));
            String size = fontString.substring(fontString.lastIndexOf(";") + 1, fontString.length());
            int sizeInt = 12;
            try {
                sizeInt = Integer.parseInt(size.substring(size.indexOf("=") + 1, size.length()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            cachedFont = new Font(this.device, name.substring(name.indexOf("=") + 1, name.length()), sizeInt, style);
            FONT_CACHE.put(fontString, cachedFont);
        }
        return cachedFont;
    }

    public void translate(int x, int y) {
        this.transform.translate(x, y);
        this.updateSWTTransform();
    }

    public void translate(double tx, double ty) {
        this.transform.translate(tx, ty);
        this.updateSWTTransform();
    }

    public void rotate(double theta) {
        this.transform.rotate(theta);
        this.updateSWTTransform();
    }

    public void rotate(double theta, double x, double y) {
        this.transform.rotate(theta, x, y);
        this.updateSWTTransform();
    }

    public void scale(double sx, double sy) {
        this.transform.scale(sx, sy);
        this.updateSWTTransform();
    }

    public void shear(double shx, double shy) {
        this.transform.shear(shx, shy);
        this.updateSWTTransform();
    }

    public void transform(AffineTransform srcTransform) {
        this.transform.concatenate(srcTransform);
        this.updateSWTTransform();
    }

    public void setTransform(AffineTransform newTransform) {
        this.transform = (AffineTransform)newTransform.clone();
        this.updateSWTTransform();
    }

    public AffineTransform getTransform() {
        return (AffineTransform)this.transform.clone();
    }

    private void updateSWTTransform() {
        double[] m = new double[6];
        this.transform.getMatrix(m);
        this.swtTransform.setElements((float)m[0], (float)m[1], (float)m[2], (float)m[3], (float)m[4], (float)m[5]);
    }

    private Path pathIterator2Path(PathIterator iter) {
        float[] coords = new float[6];
        Path path = new Path(this.device);
        while (!iter.isDone()) {
            int type = iter.currentSegment(coords);
            switch (type) {
                case 0: {
                    path.moveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    path.lineTo(coords[0], coords[1]);
                    break;
                }
                case 4: {
                    path.close();
                    break;
                }
                case 2: {
                    path.quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    path.cubicTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
            }
            iter.next();
        }
        return path;
    }

    public void clearRect(int x, int y, int width, int height) {
        this.fillRect(x, y, width, height);
    }

    public void draw(Shape s) {
        if (s instanceof Rectangle2D) {
            Rectangle2D r2 = (Rectangle2D)s;
            this.drawRect(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
        } else if (s instanceof Ellipse2D) {
            Ellipse2D e2 = (Ellipse2D)s;
            this.drawOval(e2.getX(), e2.getY(), e2.getWidth(), e2.getHeight());
        } else if (s instanceof RoundRectangle2D) {
            RoundRectangle2D r2 = (RoundRectangle2D)s;
            this.drawRoundRect(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight(), r2.getArcWidth(), r2.getArcHeight());
        } else if (s instanceof Arc2D) {
            Arc2D a2 = (Arc2D)s;
            this.drawArc(a2.getX(), a2.getY(), a2.getWidth(), a2.getHeight(), a2.getAngleStart(), a2.getAngleExtent());
        } else {
            Path p = (Path)SHAPE_CACHE.get(s);
            if (p == null) {
                p = this.pathIterator2Path(s.getPathIterator(null));
                SHAPE_CACHE.put(s, p);
            }
            this.drawPath(p);
        }
    }

    public void fill(Shape s) {
        if (s instanceof Rectangle2D) {
            Rectangle2D r2 = (Rectangle2D)s;
            this.fillRect(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
        } else if (s instanceof Ellipse2D) {
            Ellipse2D e2 = (Ellipse2D)s;
            this.fillOval(e2.getX(), e2.getY(), e2.getWidth(), e2.getHeight());
        } else if (s instanceof RoundRectangle2D) {
            RoundRectangle2D r2 = (RoundRectangle2D)s;
            this.fillRoundRect(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight(), r2.getArcWidth(), r2.getArcHeight());
        } else if (s instanceof Arc2D) {
            Arc2D a2 = (Arc2D)s;
            this.fillArc(a2.getX(), a2.getY(), a2.getWidth(), a2.getHeight(), a2.getAngleStart(), a2.getAngleExtent());
        } else {
            Path p = (Path)SHAPE_CACHE.get(s);
            if (p == null) {
                p = this.pathIterator2Path(s.getPathIterator(null));
                SHAPE_CACHE.put(s, p);
            }
            this.fillPath(p);
        }
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        int[] ptArray = new int[2 * nPoints];
        for (int i = 0; i < nPoints; ++i) {
            TEMP_POINT.setLocation(xPoints[i], yPoints[i]);
            this.transform.transform(TEMP_POINT, TEMP_POINT);
            ptArray[2 * i] = xPoints[i];
            ptArray[2 * i + 1] = yPoints[i];
        }
        this.gc.setLineWidth(this.getTransformedLineWidth());
        this.gc.drawPolyline(ptArray);
    }

    public void drawPolyline(double[] pts) {
        int[] intPts = SWTShapeManager.transform(pts, this.transform);
        this.gc.drawPolyline(intPts);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        int[] ptArray = new int[2 * nPoints];
        for (int i = 0; i < nPoints; ++i) {
            TEMP_POINT.setLocation(xPoints[i], yPoints[i]);
            this.transform.transform(TEMP_POINT, TEMP_POINT);
            ptArray[2 * i] = xPoints[i];
            ptArray[2 * i + 1] = yPoints[i];
        }
        this.gc.drawPolygon(ptArray);
    }

    public void fillPolygon(double[] pts) {
        int[] intPts = SWTShapeManager.transform(pts, this.transform);
        this.gc.fillPolygon(intPts);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        int[] ptArray = new int[2 * nPoints];
        for (int i = 0; i < nPoints; ++i) {
            TEMP_POINT.setLocation(xPoints[i], yPoints[i]);
            this.transform.transform(TEMP_POINT, TEMP_POINT);
            ptArray[2 * i] = xPoints[i];
            ptArray[2 * i + 1] = yPoints[i];
        }
        this.gc.fillPolygon(ptArray);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.drawLine((double)x1, (double)y1, (double)x2, (double)y2);
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        TEMP_POINT.setLocation(x1, y1);
        this.transform.transform(TEMP_POINT, TEMP_POINT);
        double transformedX1 = (int)TEMP_POINT.getX();
        double transformedY1 = (int)TEMP_POINT.getY();
        TEMP_POINT.setLocation(x2, y2);
        this.transform.transform(TEMP_POINT, TEMP_POINT);
        double transformedX2 = (int)TEMP_POINT.getX();
        double transformedY2 = (int)TEMP_POINT.getY();
        this.gc.setLineWidth(this.getTransformedLineWidth());
        this.gc.drawLine((int)(transformedX1 + 0.5), (int)(transformedY1 + 0.5), (int)(transformedX2 + 0.5), (int)(transformedY2 + 0.5));
    }

    public void copyArea(org.eclipse.swt.graphics.Image img, double x, double y) {
        TEMP_POINT.setLocation(x, y);
        this.transform.transform(TEMP_POINT, TEMP_POINT);
        this.gc.copyArea(img, (int)(TEMP_POINT.getX() + 0.5), (int)(TEMP_POINT.getY() + 0.5));
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        TEMP_RECT.setRect(x, y, width, height);
        SWTShapeManager.transform(TEMP_RECT, this.transform);
        TEMP_POINT.setLocation(dx, dy);
        this.transform.transform(TEMP_POINT, TEMP_POINT);
        this.gc.copyArea((int)TEMP_RECT.getX(), (int)TEMP_RECT.getY(), (int)TEMP_RECT.getWidth(), (int)TEMP_RECT.getHeight(), (int)TEMP_POINT.getX(), (int)TEMP_POINT.getY());
    }

    public void drawString(String str, int x, int y, boolean isTransparent) {
        this.gc.setTransform(this.swtTransform);
        this.gc.drawString(str, x, y, isTransparent);
        this.gc.setTransform(null);
    }

    public void drawString(String str, int x, int y) {
        this.drawString(str, x, y, true);
    }

    public void drawString(String str, double x, double y) {
        this.drawString(str, (int)(x + 0.5), (int)(y + 0.5));
    }

    public void drawString(String str, double x, double y, boolean isTransparent) {
        this.drawString(str, (int)(x + 0.5), (int)(y + 0.5), isTransparent);
    }

    public void drawString(String str, float x, float y) {
        this.drawString(str, (int)((double)x + 0.5), (int)((double)y + 0.5));
    }

    public void drawText(String str, double x, double y) {
        this.drawString(str, (int)(x + 0.5), (int)(y + 0.5));
    }

    public void drawText(String str, double x, double y, int flags) {
        this.drawText(str, (int)(x + 0.5), (int)(y + 0.5), flags);
    }

    public void drawText(String str, int x, int y, int flags) {
        this.gc.setTransform(this.swtTransform);
        this.gc.drawText(str, x, y, flags);
        this.gc.setTransform(null);
    }

    public void drawRect(int x, int y, int width, int height) {
        this.drawRect((double)x, (double)y, (double)width, (double)height);
    }

    public void drawRect(double x, double y, double width, double height) {
        TEMP_RECT.setRect(x, y, width, height);
        SWTShapeManager.transform(TEMP_RECT, this.transform);
        SWTShapeManager.awtToSWT(TEMP_RECT, SWT_RECT);
        this.gc.setLineWidth(this.getTransformedLineWidth());
        this.gc.drawRectangle(SWT_RECT);
    }

    public void fillRect(int x, int y, int width, int height) {
        this.fillRect((double)x, (double)y, (double)width, (double)height);
    }

    public void fillRect(double x, double y, double width, double height) {
        TEMP_RECT.setRect(x, y, width, height);
        SWTShapeManager.transform(TEMP_RECT, this.transform);
        SWTShapeManager.awtToSWT(TEMP_RECT, SWT_RECT);
        this.gc.fillRectangle(SWT_RECT);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.drawRoundRect((double)x, (double)y, (double)width, (double)height, (double)arcWidth, (double)arcHeight);
    }

    public void drawRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        TEMP_RECT.setRect(x, y, width, height);
        SWTShapeManager.transform(TEMP_RECT, this.transform);
        double tx = TEMP_RECT.getX();
        double ty = TEMP_RECT.getY();
        double twidth = TEMP_RECT.getWidth();
        double theight = TEMP_RECT.getHeight();
        TEMP_RECT.setRect(0.0, 0.0, arcWidth, arcHeight);
        SWTShapeManager.transform(TEMP_RECT, this.transform);
        double tarcWidth = TEMP_RECT.getWidth();
        double tarcHeight = TEMP_RECT.getHeight();
        this.gc.setLineWidth(this.getTransformedLineWidth());
        this.gc.drawRoundRectangle((int)(tx + 0.5), (int)(ty + 0.5), (int)(twidth + 0.5), (int)(theight + 0.5), (int)(tarcWidth + 0.5), (int)(tarcHeight + 0.5));
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fillRoundRect((double)x, (double)y, (double)width, (double)height, (double)arcWidth, (double)arcHeight);
    }

    public void fillRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        TEMP_RECT.setRect(x, y, width, height);
        SWTShapeManager.transform(TEMP_RECT, this.transform);
        double tx = TEMP_RECT.getX();
        double ty = TEMP_RECT.getY();
        double twidth = TEMP_RECT.getWidth();
        double theight = TEMP_RECT.getHeight();
        TEMP_RECT.setRect(0.0, 0.0, arcWidth, arcHeight);
        SWTShapeManager.transform(TEMP_RECT, this.transform);
        double tarcWidth = TEMP_RECT.getWidth();
        double tarcHeight = TEMP_RECT.getHeight();
        this.gc.setLineWidth(this.getTransformedLineWidth());
        this.gc.fillRoundRectangle((int)(tx + 0.5), (int)(ty + 0.5), (int)(twidth + 0.5), (int)(theight + 0.5), (int)(tarcWidth + 0.5), (int)(tarcHeight + 0.5));
    }

    public void drawOval(int x, int y, int width, int height) {
        this.drawOval((double)x, (double)y, (double)width, (double)height);
    }

    public void drawOval(double x, double y, double width, double height) {
        TEMP_RECT.setRect(x, y, width, height);
        SWTShapeManager.transform(TEMP_RECT, this.transform);
        this.gc.setLineWidth(this.getTransformedLineWidth());
        this.gc.drawOval((int)(TEMP_RECT.getX() + 0.5), (int)(TEMP_RECT.getY() + 0.5), (int)(TEMP_RECT.getWidth() + 0.5), (int)(TEMP_RECT.getHeight() + 0.5));
    }

    public void fillOval(int x, int y, int width, int height) {
        this.fillOval((double)x, (double)y, (double)width, (double)height);
    }

    public void fillOval(double x, double y, double width, double height) {
        TEMP_RECT.setRect(x, y, width, height);
        SWTShapeManager.transform(TEMP_RECT, this.transform);
        this.gc.fillOval((int)(TEMP_RECT.getX() + 0.5), (int)(TEMP_RECT.getY() + 0.5), (int)(TEMP_RECT.getWidth() + 0.5), (int)(TEMP_RECT.getHeight() + 0.5));
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int extent) {
        this.drawArc((double)x, (double)y, (double)width, (double)height, (double)startAngle, (double)extent);
    }

    public void drawArc(double x, double y, double width, double height, double startAngle, double extent) {
        TEMP_RECT.setRect(x, y, width, height);
        SWTShapeManager.transform(TEMP_RECT, this.transform);
        this.gc.setLineWidth(this.getTransformedLineWidth());
        this.gc.drawArc((int)(TEMP_RECT.getX() + 0.5), (int)(TEMP_RECT.getY() + 0.5), (int)(TEMP_RECT.getWidth() + 0.5), (int)(TEMP_RECT.getHeight() + 0.5), (int)(startAngle + 0.5), (int)(startAngle + extent + 0.5));
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int extent) {
        this.drawArc((double)x, (double)y, (double)width, (double)height, (double)startAngle, (double)extent);
    }

    public void fillArc(double x, double y, double width, double height, double startAngle, double extent) {
        TEMP_RECT.setRect(x, y, width, height);
        SWTShapeManager.transform(TEMP_RECT, this.transform);
        this.gc.drawArc((int)(TEMP_RECT.getX() + 0.5), (int)(TEMP_RECT.getY() + 0.5), (int)(TEMP_RECT.getWidth() + 0.5), (int)(TEMP_RECT.getHeight() + 0.5), (int)(startAngle + 0.5), (int)(startAngle + extent + 0.5));
    }

    public void drawPath(Path p) {
        this.gc.setTransform(this.swtTransform);
        this.gc.drawPath(p);
        this.gc.setTransform(null);
    }

    public void fillPath(Path p) {
        this.gc.setTransform(this.swtTransform);
        this.gc.fillPath(p);
        this.gc.setTransform(null);
    }

    public void drawImage(org.eclipse.swt.graphics.Image image, double x, double y) {
        org.eclipse.swt.graphics.Rectangle bounds = image.getBounds();
        TEMP_RECT.setRect(x, y, bounds.width, bounds.height);
        SWTShapeManager.transform(TEMP_RECT, this.transform);
        SWTShapeManager.awtToSWT(TEMP_RECT, SWT_RECT);
        this.gc.drawImage(image, 0, 0, bounds.width, bounds.height, SWTGraphics2D.SWT_RECT.x, SWTGraphics2D.SWT_RECT.y, SWTGraphics2D.SWT_RECT.width, SWTGraphics2D.SWT_RECT.height);
    }

    public void drawImage(org.eclipse.swt.graphics.Image image, int srcX, int srcY, int srcW, int srcH, double destX, double destY, double destW, double destH) {
        TEMP_RECT.setRect(destX, destY, destW, destH);
        SWTShapeManager.transform(TEMP_RECT, this.transform);
        SWTShapeManager.awtToSWT(TEMP_RECT, SWT_RECT);
        this.gc.drawImage(image, srcX, srcY, srcW, srcH, SWTGraphics2D.SWT_RECT.x, SWTGraphics2D.SWT_RECT.y, SWTGraphics2D.SWT_RECT.width, SWTGraphics2D.SWT_RECT.height);
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
    }

    protected int getTransformedLineWidth() {
        TEMP_LINE_RECT.setRect(0.0, 0.0, this.lineWidth, this.lineWidth);
        SWTShapeManager.transform(TEMP_LINE_RECT, this.transform);
        return (int)(Math.max(TEMP_LINE_RECT.getWidth(), 1.0) + 0.5);
    }

    public float getTransparency() {
        return this.transparency;
    }

    public void setTransparency(float transparency) {
        if (transparency < 0.0f || transparency > 1.0f) {
            throw new IllegalArgumentException("transparency must be between 0.0f and 1.0f inclusive");
        }
        this.transparency = transparency;
        this.gc.setAlpha((int)(this.transparency * 255.0f));
    }

    public void fillGradientRectangle(double x, double y, double width, double height, boolean vertical) {
        TEMP_RECT.setRect(x, y, width, height);
        SWTShapeManager.transform(TEMP_RECT, this.transform);
        SWTShapeManager.awtToSWT(TEMP_RECT, SWT_RECT);
        this.gc.fillGradientRectangle(SWTGraphics2D.SWT_RECT.x, SWTGraphics2D.SWT_RECT.y, SWTGraphics2D.SWT_RECT.width, SWTGraphics2D.SWT_RECT.height, vertical);
    }

    public int getAdvanceWidth(char ch) {
        Font scaledFont = this.gc.getFont();
        this.gc.setFont(this.curFont);
        int width = this.gc.getAdvanceWidth(ch);
        this.gc.setFont(scaledFont);
        return width;
    }

    public int getCharWidth(char ch) {
        Font scaledFont = this.gc.getFont();
        this.gc.setFont(this.curFont);
        int width = this.gc.getCharWidth(ch);
        this.gc.setFont(scaledFont);
        return width;
    }

    public Point stringExtent(String str) {
        Font scaledFont = this.gc.getFont();
        this.gc.setFont(this.curFont);
        Point extent = this.gc.stringExtent(str);
        this.gc.setFont(scaledFont);
        return extent;
    }

    public Point textExtent(String str) {
        Font scaledFont = this.gc.getFont();
        this.gc.setFont(this.curFont);
        Point extent = this.gc.textExtent(str);
        this.gc.setFont(scaledFont);
        return extent;
    }

    public Point textExtent(String str, int flags) {
        Font scaledFont = this.gc.getFont();
        this.gc.setFont(this.curFont);
        Point extent = this.gc.textExtent(str, flags);
        this.gc.setFont(scaledFont);
        return extent;
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
    }

    public void drawGlyphVector(GlyphVector g, float x, float y) {
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return false;
    }

    public void setComposite(Composite comp) {
    }

    public void setStroke(Stroke s) {
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
    }

    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return null;
    }

    public void setRenderingHints(Map hints) {
    }

    public void addRenderingHints(Map hints) {
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public Composite getComposite() {
        return null;
    }

    public Stroke getStroke() {
        return null;
    }

    public FontRenderContext getFontRenderContext() {
        return null;
    }

    public Graphics create() {
        return null;
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color c1) {
    }

    public java.awt.FontMetrics getFontMetrics(java.awt.Font f) {
        return null;
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return false;
    }

    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return false;
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return false;
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return false;
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return false;
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return false;
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return false;
    }

    public void dispose() {
    }

    public static void incrementGCCount() {
        ++CACHE_COUNT;
    }

    public static void decrementGCCount() {
        if (--CACHE_COUNT == 0) {
            for (Font font : FONT_CACHE.values()) {
                font.dispose();
            }
            FONT_CACHE.clear();
            for (org.eclipse.swt.graphics.Color color : COLOR_CACHE.values()) {
                color.dispose();
            }
            COLOR_CACHE.clear();
            for (Path path : SHAPE_CACHE.values()) {
                path.dispose();
            }
            SHAPE_CACHE.clear();
        }
    }
}

