package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeNetworkAclAttributes invokes the vpc.DescribeNetworkAclAttributes API synchronously
func (client *Client) DescribeNetworkAclAttributes(request *DescribeNetworkAclAttributesRequest) (response *DescribeNetworkAclAttributesResponse, err error) {
	response = CreateDescribeNetworkAclAttributesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeNetworkAclAttributesWithChan invokes the vpc.DescribeNetworkAclAttributes API asynchronously
func (client *Client) DescribeNetworkAclAttributesWithChan(request *DescribeNetworkAclAttributesRequest) (<-chan *DescribeNetworkAclAttributesResponse, <-chan error) {
	responseChan := make(chan *DescribeNetworkAclAttributesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeNetworkAclAttributes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeNetworkAclAttributesWithCallback invokes the vpc.DescribeNetworkAclAttributes API asynchronously
func (client *Client) DescribeNetworkAclAttributesWithCallback(request *DescribeNetworkAclAttributesRequest, callback func(response *DescribeNetworkAclAttributesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeNetworkAclAttributesResponse
		var err error
		defer close(result)
		response, err = client.DescribeNetworkAclAttributes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeNetworkAclAttributesRequest is the request struct for api DescribeNetworkAclAttributes
type DescribeNetworkAclAttributesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	NetworkAclId         string           `position:"Query" name:"NetworkAclId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeNetworkAclAttributesResponse is the response struct for api DescribeNetworkAclAttributes
type DescribeNetworkAclAttributesResponse struct {
	*responses.BaseResponse
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	NetworkAclAttribute NetworkAclAttribute `json:"NetworkAclAttribute" xml:"NetworkAclAttribute"`
}

// CreateDescribeNetworkAclAttributesRequest creates a request to invoke DescribeNetworkAclAttributes API
func CreateDescribeNetworkAclAttributesRequest() (request *DescribeNetworkAclAttributesRequest) {
	request = &DescribeNetworkAclAttributesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DescribeNetworkAclAttributes", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeNetworkAclAttributesResponse creates a response to parse from DescribeNetworkAclAttributes response
func CreateDescribeNetworkAclAttributesResponse() (response *DescribeNetworkAclAttributesResponse) {
	response = &DescribeNetworkAclAttributesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
