C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE LFRAY2
C                       *****************
C
C      -----------------------------------------------
     * (NELRAY,NRFRAY,
     *  NFCFRA,NFTIRA,NFFIRA,NFPERA,NFMST,NFMSTE,
     *  NGFFIR,NGFTIR,NGFPER,NGFPEF,NGFMST,NGFMSE,ITYFAR)
C      -----------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C       GENERATION DES LISTES DE FACES POUR LE MAILLAGE RAYONNEMENT    *
C          - Faces equivalentes couples avec le fluide                 *
C          - Faces a temperature imposee                               *
C          - Faces a flux impose                                       *
C          - Faces equivalentes isolees                                *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NELRAY   !  E ! D  ! NOMBRE D'ELTS DU MAILLAGE RAYONNEMENT        !
C !  NRFRAY   ! TE ! R  ! TABLEAU DES REFERENCES ELTS MAILLAGE RAYT    !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /OPTCT/   !    !    !                                              !
C ! /DIVCT/   !    !    !                                              !
C ! /NLOFES/  !    !    !                                              !
C ! /NLOFCT/  !    !    !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : --- 
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
       IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "nlofct.h"
#include "xrefer.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NELRAY
      INTEGER NFCFRA,NFTIRA,NFFIRA,NFPERA,NFMST,NFMSTE
      INTEGER NRFRAY(NELRAY)
      INTEGER NGFFIR(NFFIRA),NGFTIR(NFTIRA),NGFPER(NFPERA)
      INTEGER NGFPEF(NFCFRA)
      INTEGER NGFMST(NFMST,2),NGFMSE(NFMSTE),ITYFAR(NELRAY)
C
C.. Variables internes
      INTEGER N,M,NFTI,NFFI,NFEF,NFER,NF,NFST,NFSTE,NFCS
C
C***********************************************************************
C
C     1- INITIALISATION 
C     =================
      NFEF  = 0
      NFFI  = 0
      NFTI  = 0
      NFER  = 0
      NFST  = 0
      NFSTE = 0
      NFCS  = 0
C
      DO N=1,NELRAY
       ITYFAR(N)=0
      ENDDO
C
C     2- GENERATION DES LISTES
C     ========================
C
      DO 200 N=1,NELRAY
C
        NF = NRFRAY(N)
C
        DO 210 M=1,NRFMAX
C
          IF (IRERCS(M).NE.0 .AND. NF.EQ.M) THEN
             NFCS = NFCS + 1
             ITYFAR(N)=1
          ENDIF
C
          IF (IRERCF(M).NE.0 .AND. NF.EQ.M) THEN
             NFEF = NFEF + 1
             NGFPEF(NFEF) = N
             ITYFAR(N)=4
          ENDIF

          IF (IRERTI(M).NE.0 .AND. NF.EQ.M) THEN 
             NFTI  = NFTI + 1
             NGFTIR(NFTI) = N
             ITYFAR(N)=2
          ENDIF
C
          IF (IRERFI(M).NE.0 .AND. NF.EQ.M) THEN 
             NFFI  = NFFI + 1
             NGFFIR(NFFI) = N
             ITYFAR(N)=3
          ENDIF
C
          IF (IRERPE(M).NE.0 .AND. NF.EQ.M) THEN  
             NFER  = NFER + 1
             NGFPER(NFER) = N
             ITYFAR(N)=9
          ENDIF
C
          IF (IRESTF(M).NE.0 .AND. NF.EQ.M) THEN  
             NFST  = NFST + 1
             NGFMST(NFST,1) = N
             ITYFAR(N)=5
          ENDIF
C
          IF (IRESTE(M).NE.0 .AND. NF.EQ.M) THEN  
             NFSTE = NFSTE + 1
             NFST  = NFST + 1
             NGFMST(NFST,1)  = N
             NGFMSE(NFSTE) = N
             ITYFAR(N)=6
          ENDIF
C
          IF (IRESTS(M).NE.0 .AND. NF.EQ.M) THEN  
             NFST  = NFST + 1
             NGFMST(NFST,1) = N
             ITYFAR(N)=7
          ENDIF
C
          IF (IRESTB(M).NE.0 .AND. NF.EQ.M) THEN  
             NFST  = NFST + 1
             NGFMST(NFST,1) = N
             ITYFAR(N)=8
          ENDIF
C
  210   CONTINUE
C
  200 CONTINUE 
C
C     4- IMPRESSIONS
C     ==============
C
      WRITE(NFECRA,4000) NFCS,NFTI,NFFI,NFEF,NFER,NFST
C
C
C--------
C FORMATS
C--------
C
 4000 FORMAT(//,' *** LFRAY2 : MAILLAGE RAYONNEMENT',/,
     * 8X,'- Nombre de faces couplees au solide     :',14X,I7,/,
     * 8X,'- Nombre de faces a temperature imposees :',14X,I7,/,
     * 8X,'- Nombre de faces a flux impose :',23X,I7,/,
     * 8X,'- Nombre de faces paroi equivalente couplees au fluide :',
     * I7,/,
     * 8X,'- Nombre de faces paroi equivalente isolee :',12X,I7,/,
     * 8X,'- Nombre de faces milieu semi-transparent solide :',6X,I7)
C
      END
