/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.StringTokenizer;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derby.iapi.services.info.ProductVersionHolder;

public class Configuration {
    public static int traceFileSuffixIndex__ = 0;
    public static int traceLevel__ = -1;
    public static String traceFile__ = null;
    public static String traceDirectory__ = null;
    public static boolean traceFileAppend__ = false;
    public static String jreLevel = "1.3.0";
    public static int jreLevelMajor = 1;
    public static int jreLevelMinor = 3;
    public static boolean traceSuspended__;
    public static boolean[] enableConnectivityToTargetServer__;
    public static boolean jvmSupportsMicrosClock__;
    public static ProductVersionHolder dncProductVersionHolder__;
    public static final String dncDriverName = "Apache Derby Network Client JDBC Driver";
    public static final byte[] dncPackageConsistencyToken;
    public static String dncPackageVersion;
    public static final boolean jdbcCompliant = true;
    public static final String[] dncCompatibleJREVersions;
    public static final String jdbcDerbyNETProtocol = "jdbc:derby://";
    public static final boolean enableNetConnectionPooling = true;
    static final boolean rangeCheckCrossConverters = true;
    static final int bugCheckLevel = 255;
    public static final int defaultIsolation = 2;
    public static final int defaultFetchSize = 64;
    public static final String cursorAttribute_SensitiveStatic = "SENSITIVE STATIC SCROLL ";
    public static final String cursorAttribute_SensitiveStaticRowset = "SENSITIVE STATIC SCROLL ";
    public static final String cursorAttribute_SensitiveDynamic = "SENSITIVE DYNAMIC SCROLL ";
    public static final String cursorAttribute_SensitiveDynamicRowset = "SENSITIVE DYNAMIC SCROLL WITH ROWSET POSITIONING ";
    public static final String cursorAttribute_Insensitive = "INSENSITIVE SCROLL ";
    public static final String cursorAttribute_InsensitiveRowset = "INSENSITIVE SCROLL ";
    public static final String cursorAttribute_ForUpdate = "FOR UPDATE ";
    public static final String cursorAttribute_ForReadOnly = "FOR READ ONLY ";
    public static final String cursorAttribute_WithHold = "WITH HOLD ";
    private static final String packageNameForDNC = "org.apache.derby.client";
    public static SqlException exceptionsOnLoadResources;

    private Configuration() {
    }

    public static ProductVersionHolder getProductVersionHolder() {
        return dncProductVersionHolder__;
    }

    private static void loadProductVersionHolder() throws SqlException {
        try {
            dncProductVersionHolder__ = Configuration.buildProductVersionHolder();
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new SqlException(null, new ClientMessageId("XJ095.S"), privilegedActionException.getException());
        }
        catch (IOException iOException) {
            throw SqlException.javaException(null, iOException);
        }
    }

    private static ProductVersionHolder buildProductVersionHolder() throws PrivilegedActionException, IOException {
        ProductVersionHolder productVersionHolder = null;
        productVersionHolder = (ProductVersionHolder)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                InputStream inputStream = this.getClass().getResourceAsStream("/org/apache/derby/info/dnc.properties");
                return ProductVersionHolder.getProductVersionHolderFromMyEnv(inputStream);
            }
        });
        return productVersionHolder;
    }

    public static boolean supportsJDBC40() {
        return JVMInfo.JDK_ID >= 7;
    }

    static {
        jvmSupportsMicrosClock__ = false;
        dncPackageConsistencyToken = new byte[]{83, 89, 83, 76, 86, 76, 48, 49};
        dncPackageVersion = null;
        dncCompatibleJREVersions = new String[]{"1.3", "1.4"};
        exceptionsOnLoadResources = null;
        try {
            Configuration.loadProductVersionHolder();
        }
        catch (SqlException sqlException) {
            exceptionsOnLoadResources = sqlException;
        }
        try {
            jreLevel = System.getProperty("java.version");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        StringTokenizer stringTokenizer = new StringTokenizer(jreLevel, ".");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            int n2;
            try {
                n2 = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            switch (n++) {
                case 0: {
                    jreLevelMajor = n2;
                    break;
                }
                case 1: {
                    jreLevelMinor = n2;
                    break;
                }
            }
        }
    }
}

