3.3 Estirando Samples

# Estirando Samples

Ahora que ya podemos tocar una variedad de synths y samples para crear
música, es tiempo de aprender a modificar tanto los synths como los samples
para hacer la música más interesante y única. Primero, exploremos la
habilidad de "estirar" y "aplastar" los samples.


## Representación de Sampleos

Los Samples son sonidos pregrabados guardados como números que representan
cómo mover los conos de los parlantes para reproducir sonidos, estos conos
se pueden mover hacia dentro y hacia afuera, así que los números sólo deben
representar ese movimiento en cada momento dado. Para poder reproducir 
fielmente un sonido, el sample debe guardar miles de números por segundo,
Sonic Pi toma esta lista de números y los alimenta a la velocidad correcta
para mover los parlantes de tu computadora a la velocidad correcta para
reproducir sonido. Sin embargo, también es divertido cambiar la velocidad a
la que los números son alimentados al parlante para cambiar el sonido


## Cambiando la Velocidad

Ejecutemos uno de los sonidos ambiente: `:ambi_choir`. Para tocarlo
con la velocidad predeterminada, puedes añadir `rate:` a `sample`:

```
sample :ambi_choir, rate: 1
```

Así lo ejecuta a tiempo normal (1), nada especial. Sin embargo, podemos
cambiar ese número a otros. ¿qué tal a `0.5` ?:

```
sample :ambi_choir, rate: 0.5
```

Woah! ¿qué sucedió? Bueno, dos cosas: Primero, el sample se ejecutó en el 
doble del tiempo; Segundo, sonó una octava más grave. Exploremos todo ello
en más detalle.


## Estiremos

Un sample que es divertido estirar y comprimir es el Amen Break. A velocidad
normal, podemos imaginar poner una pista de *drum 'n' bass* :

```
sample :loop_amen
```

Sin embargo, cambiando la velocidad podemos cambiar "géneros". Intenta con
la mitad de la velocidad para un "hip hop de vieja escuela":

```
sample :loop_amen, rate: 0.5
```

Si lo aceleramos, entramos al territorio estilístico de *jungle*: 

```
sample :loop_amen, rate: 1.5
```

Vamos a nuestro último truco - veamos qué sucede si utilizamos una velocidad
negativa:

```
sample :loop_amen, rate: -1
```

Ahaa! ¡Se toca al revés! Ahora intenta toca distintos samples y velocidades,
tales como rápidas y lentísimas, observa qué sucede.


## Velocidad de sampleo: una explicación sencilla

Una manera sencilla con los sampleos es pensando en ellos como resortes.
La velocidad de ejecución es como "estirar" o "comprimir" resortes.
Si tocas a velocidad 2 estás comprimiendo el resorte a la mitad de su 
tamaño, por tanto le toma la mitad del tiempo en ejecutarse, ya que es
más corto. Si ejecutas el sampleo a la mitad de velocidad, estás en efecto
alargándo el resorte, por tanto estás doblando su tamaño y toma el doble 
de tiempo el ejecutarse. Entre más comprimas (mayor velocidad), más corto se
vuelve el tiempo y viceversa.

Comprimiendo un resorte incremeta su densidad (el número de embobinados por
cm.), lo cual es similar a que el sampleo suene a tonos más altos. Estirándo
el resorte, decrece su densidad y simlarmente el sonido es más grave.


## La matemática de la velocidad de sampleo

(Esta sección es para aquellos interesados en los detalles. Eres libre de 
saltártela)


Como hemos visto, un sample está representado por una larga lista de números
representando adónde debe estar el parlante a través del tiempo. Podemos
tomar este listado de números y usarlo para dibujar un gráfico que sería
similar a:


![sample graph](../images/tutorial/sample.png)

Quizás hayas visto imágenes parecidas a esa. Se llaman "forma de onda" de 
un sampleo. Simplemente es la graficación de números. Típicamente una forma
de onda como ésta tendrá 44100 puntos por segundo de dato (esto debido al 
teorema de sampleo de Nyquist-Shannon) Así que si un sample dura 2 segundos,
la forma de onda será representada por 88200 números, alimentándo a los
parlantes a una velocidad de 44100 puntos por segundo. Claro, podemos
también alimentarlos a una velocidad doble, que sería de 88200 puntos por
segundo, lo cual tomaría sólo 1 segundo para ser tocado. También podríamos
tocarlo a la mitad de velocidad, lo que daría 22050 puntos por segundo
tomando 4 segundos de tiempo de ejecución.


La duración del sample es afectada por la velocidad de ejecución:

* doblándola, logramos reducir a la mitad el tiempo de ejecución,
* achicándola a la mitad, doblamos el tiempo de ejecución,
* usando una velocidad de ejecución de 1/4, cuadruplicamos el tiempo de
  ejecución, 
* Usando una velocidad de ejecución de 1/10, tomará 10 veces el tiempo de
  ejecución.

Esto lo representaremos con esta fórmula:

```
nuevo_sample_ = (1 / velocidad) * duración_sample 
```

Cambiando la velocidad de ejecución se afecta el tono del sampleo. La
frecuencia o tono de una forma de onda está determinada por cuán rápido
se mueve hacia arriba y hacia abajo. De alguna manera, nuestro cerebro
toma los movimientos rápidos de los parlantes a notas agudas, igualmente, 
torna movimientos lentos de los parlantes en notas graves. Por eso es que
puedes ver los parlantes de bajos moverse cuando están dando notas muy
bajas, porque en realidad sí se están moviendo adentro/afuera del parlante
mucho más lentamente que al producir notas altas.


Si tomas una forma de onda y la comprimes, se moverá más veces por segundo
hacia arriba y hacia abajo, lo que producirá un sonido más agudo. Significa
que doblando la cantidad de movimientos verticales (oscilaciones) dobla la 
frecuencia. Así:
 *ejecutar tu sampleo al doble de velocidad, doblará la frecuencia
 escuchada*. Asimismo, *reduciendo la velocidad a la mitad, también reduce
 la frecuencia a la mitad*. Otras velocidades afectarán la frecuencia en
 acordancia.
