#! /usr/bin/env perl

# Test HTMLGenerator

# Check function that forms subresource URIs.

use strict;
use warnings;
use utf8;
use Data::Dumper;

use lib 'lib';
use CGI qw(:standard -utf8);
use Database::Order;
use HTMLGenerator;

binmode( STDOUT, "utf8" );

my $img = { up => 'up.png', down => 'down.png' };
my @cases = (
    [ 'table', 'col', 'root', $img, '' ],
    [ 'table', 'col', 'root', $img, '' ],
    [ 'table', 'col', 'root', $img, 'col:a' ],
    # The following case imitates the situation when settings from previous
    # 'master' table are present and should not be considered as table's own:
    [ 'table', 'col', 'root', $img, 'master.col:a' ],
    [ 'table', 'col', 'root', $img, 'table.col:a' ],
    [ 'table', 'col', 'root#frag', $img, '' ],
    [ 'table', 'col', 'root#frag', $img, 'col:a' ],
);

print start_html;

my $n = 0;
for my $case (@cases) {

    print p( "test" . ++$n . ":" );
    
    eval {
        $case->[4] = Database::Order->new_from_string( $case->[4], $case->[0] );
        print &HTMLGenerator::make_sort_buttons( @{$case} );
    };
    if( $@ ) {
        print $@;
    }
}

print end_html;
