# Announce: Rakudo Perl 6 compiler, Release #120 (2018.02)

On behalf of the Rakudo development team, I’m very happy to announce the
February 2018 release of Rakudo Perl 6 #120. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo.

Upcoming releases in 2018 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] — it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The changes in this release are outlined below:

New in 2018.02:
  + Fixes:
    + Fixed `no worries` pragma [f5b4d89f]
    + Fixed IO::Socket::Async losing :$scheduler in .print-to [7c451514]
    + Fixed postconstraints in `my (...)` being ignored [3745eff1]
    + Fixed optimizer crashes in `map` with certain args [f3efe5e6]
    + Fixed IO::Handle.get on TTYs blocking after EOF [359efef7][af4dfe82]
    + Fixed crash with colonpaired variable declaration [a35cd4e6]
    + Fixed crashes in degenerate .tail(Callable) [ba675971]
    + Fixed crash in `temp`/`let` with parameterized hashes [0a32e51b]
    + Fixed Hash.clone and Array.clone losing descriptor [0d7c4fe8][45560ac9]
    + Fixed `let`/`temp` on hashes losing Nils [8c4c979e]
    + Fixed crash in Any.skip(Callable) [8efba3a8]
    + Fixed crashes with native types in conditionals [d1a48efc]
    + Fixed many issues with block migration in thunk gen [1ee89b54][31ab8683]
    + Fixed "No such method 'prefix'" when there's no HOME directory [b6a7d7f6]
    + Fixed buf8 punning happening at INIT time instead of BEGIN [c6cc673d]
    + Fixed type constraint in Str.split's Seq [8afd791c]
    + Fixed Iterator.Rotor when cycle contains Whatever or Inf [ba7b4571]
    + Fixed crash with ENTER nested inside LEAVE [58de239c]
    + Fixed wrong error in REPL with none Junctions [2c36ab2e]
    + Fixed semantics of :b quoter tweak [deffe54b]
    + Fixed error when throwing error during setting compilation [c820e4be]
    + Fixed crashes with compile time evaluation of Whatever curry [7c1f0b41]
    + Fixed crash in Proxy.perl [902f45f5]
    + Fixed encoding of ›˜œžŸ™š with windows-1252 (Latin) encoding [4507a565]
    + Fixed state vars in `do`-ed loops [299e8526]
    + Fixed whatever curry with regexes [d80fc376]
    + Fixed crashes with compile time evaluation of `where` thunks [95f23a56]
    + Fixed broken 2-arity sort of 2-el list [2e65de29]
    + Fixed postfix whatever curry with another curry inside [e8c6c259]
    + Fixed empty compiler version when the git repo has no tags [382024e6]
    + Fixed migration of in-regex blocks [c0c7756f]
    + Fixed missing decont in `cmp` [114e3735][25c5c488]
    + Fixed drift when reusing lazy iterables for indexing [f330d7fc]
    + Fixed crash in parameterized constraints on attrs with .= [562edfc5]
    + Fixed REPL adding empty lines to the history file [24fab707]
    + Fixed Parameter.usage-name to omit leading * and ! [3c73099c]
    + Fixed Any.tail(Callable) violating Iterator protocol [2cc7b631]
    + Fixed .perl of handled Failures [b2a21fa9]
    + Unified List.roll/pick invocant specification [311ef07f]
    + Fixed multi-threaded precompilation [ac87ea2a]
    + Fixed issues in constant type declarations [f559c6d8]
    + Fixed `if` with slurpies on its block [ef1d22f4][dfb6d951][59556c70]
        [4b7113fa][00af9ce2]
    + Improved SprintfHandler [d419afe4][4ac67e73][684b99ea][13406517]
    + Fixed unwanted curries with HyperWhatever type object [57a1aa7a]
    + Made Backtrace.gist more helpful [555db42a]
    + Fixed ($ = 42) vs ($ = "42").subst-mutate [e7af9a6a]
    + Fixed Cool.subst-mutate to only mutate if there's a match [61015526]
    + Made Str.subst-mutate always return a List on :g [77794a28]
    + Made Str.match(:x) consistently return a non-Slip List [829ea8e3]
    + Fixed return of multi-match options of Str.subst-mutate [e0d39321]
    + Fixed .Numeric/.Real on :U numerics and .Real on :D allomorphs [1dc1f038]
    + Various fixes for the JVM backend [a2499c90][1f223190][f2188e45]
    + Various improvements to produced messages [8ffbc43b][7f07f68f][34b3356f]
        [de2d8296][1c894e41][d419afe4]
  + Additions:
    + Added windows-1251 (Cyrillic) encoding to the list of possible encodings
        [c73cb78f][4507a565]
    + Added support for .= to init sigilless vars [8ba3c86e]
    + Added compile time LiteralType error for native vars [e930e253]
        [63a1d25a][30b82b98]
  + Efficiency:
    + Made `$ where Type1|Type2|Type…` typecheck ~8x faster [43b9c829][264a1a27]
    + Many compunit speedups [5bd33669][6fa1e78f][c268f55c][5be174bb]
        [b188cc82][838beab9][a9a9e1c9][00cde175][ed9b287c]
    + Made certain conditionals with natives 2.1x faster [d1a48efc]
    + Improved dynamic optimization of nativecast [3ed2fbd5]
    + Reduced startup overhead of file I/O and module loading [db1e067e]
    + Made `dispatch:<var>` call up to 43x faster [ff31f0a3]
    + Shaved off 10ms when loading a native library [86e926c7]
    + Made compilation up to 6% faster (for 3000-line files) [f4732164]
    + Made Whatever currier up to 2.2x faster [752bb8b3]
    + Made list assignment with roll up to 20% faster [65d6fe48]
    + Moved `$*PERL` initialization to BEGIN time to save runtime [bdb4d34d]
    + Made Version.new 82x faster [02d2e2ca]
    + Added native `num` post-inc/dec to pre- optimization [4a5cc2c2][13e6ed8c]
        [888328ef][971d17c4]
    + Made `.=` up to 63x faster [abea3242][01237782][2ba7634c]


The following people contributed to this release:

Zoffix Znet, JJ Merelo, Pawel Murias, Aleks-Daniel Jakimenko-Aleksejev,
Stefan Seifert, Luca Ferrari, Will "Coke" Coleda, Tom Browder,
Samantha McVey, Elizabeth Mattijsen, Christian Bartolomäus, Jeremy Studer,
Curt Tilmes, Jan-Olof Hendig, Timo Paulssen, Itsuki Toyota, Pepe Schwarz,
Jonathan Worthington, Moritz Lenz, Tobias Boege, Wenzel P. P. Peppmeyer,
Fernando Correa de Oliveira, Nick Logan, Andrew Shitov, Jonas Kramer,
Alberto Luaces, Ben Davies, 0racle

as well as

Bart Wiegmans, Daniel Green, Paweł Murias, cygx, wukgdu

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Perl 6 development: <https://donate.perlfoundation.org/>
(put “Perl 6 Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#121), is tentatively scheduled for 2018-03-17.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, Perl 6 introductory
documentation, and other software that can be used with the Rakudo
compiler to enhance its utility.
