# Announce: Rakudo Perl 6 compiler, Release #110 (2017.04)

On behalf of the Rakudo development team, I’m very happy to announce the
April 2017 release of Rakudo Perl 6 #110. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo, but no new features.

Upcoming releases in 2017 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The changes in this release are outlined below:

New in 2017.04:
 + SPECIAL NOTES:
    + There are two Upgrade Notifications for this release:
        - Part 1: http://rakudo.org/2017/04/02/upgrade
        - Part 2: http://rakudo.org/2017/04/03/part-2
        - Part 3: http://rakudo.org/2017/04/17/final-notes
    + Changes for Texas operators listed in this release also apply to their
        fancy Unicode alternatives. https://docs.perl6.org/language/unicode_texas.html
 + Fixes:
    + Fixed infinite loop due to wrong args in many Cool methods [8c88b0c]
    + Fixed failure to distinguish rw args in Capture.WHICH [4605d52]
    + Fixed regression in .rotor with negative gaps [5917b81]
    + Fixed a 1-arg-no-phasers path in .map stopping after 1 value [86dc997]
    + Fixed containerization issues in listinfix metaops [16f950b]
    + Fixed Inline::Perl5 detection in t/harness6 [b15cd20]
    + Fixed incorrect number of tests run in t/harness6 [8766370]
    + Fixed t/harness5 incorrectly failing NOTESTS runs [f28c515]
    + Fixed crash in S/// and s/// for some combinations of adverbs [43e0902]
    + Fixed crash when doing EVAL from multiple threads [218f8c4]
    + Fixed errors in concatenations of Hangul script with \r\n in it [a123eb3]
    + Fixed case insensitive string compare with synthetics in haystack [e87179d]
    + Fixed case insensitive regex with synthetics [666ce35]
    + Fixed issues with foreign lang cursor without a name [ffeb896]
    + Fixed introspection of attributes with explicitly typed keys [a6ba994]
    + Fixed spurious warnings in define_slang [666ce35]
    + Fixed issues in :exists with multidimensional hash slice lookup [a758c0b]
    + Fixed unwanted overflow when too-large values were *assigned* to native attributes [666ce35]
    + Fixed failure to set $/ by matching routines when used in loops [a62b221]
    + Fixed handling of Baggy (|) Mixy, Mixy (|) Baggy in dispatch [48619f8]
    + Fixed Allocations tab in --profile output [c16cdb2c]
    + Made `is equiv` to not propagate operator's `assoc` value [f9f0883]
    + Made Code.ACCEPTS pass take its parameter `is raw` [c0eb9bd]
    + Fixed SEGV in IO::Pipe.t [3e275dd]
    + Made `dynamic` default to False instead of Nil on Scalar/Hash/Array [28a6e80]
    + [IO] Fixed wrong results in IO::Path.resolve for paths with combiners on `/` [9d8e391]
    + [IO] Fixed a crash when using Whatever limit in in IO::Pipe.lines [0c62815]
    + [IO] Fixed crash in smartmatch of Cool ~~ IO::Path for some Cools [c360ac2]
    + [IO] Made IO::Path:: subclasses instantiate a subclass, not IO::Path [a0b82ed]
    + [IO] Fixed crash when very large files were read with IO::Path.slurp [d0924f1]
    + [IO] Ensured IO::Handle.Str coerced .path to Str [1f689a9]
    + [IO] Fixed crash when binary slurping large files with &slurp/IO::Path.slurp [756877e]
    + [IO] Fixed occasional zero byte read when binary slurping files [756877e]
    + [IO] IO::Handle.symlink/.link now take name of the link as argument;
        the invocant is the target [8c09c84]
    + Various improvements to warnings and error reporting [6a77cda][d90c6bf][f9968b3]
        [27f5469][41ac4b4][75c3f29][87fe800][7ba2fc5][093bb89][d3c93ad][6ee71c2][490ffd1][7112a08]
 + Additions:
    + Gave `Thread` a numeric representation [e5528dd]
    + Made Any.maxpairs/.minpairs use `cmp` and return Seq [5927186]
    + Made `Parameter` object available in bind error [0f9f000]
    + Added typed exception for parameter constraint failure [f1cd8e3]
    + Allowed nativesize to be unset in NativeHOW, but still compose [af4aae2][932b59f]
    + Made sure that Baggy and Setty handle bare objects [7433947][e660a57]
    + Added experimental coverage reporter tool with MoarVM backend (so far works with
        reports for core code; more work needed to expand for wider use) [932b59f][d0924f1]
    + Made it possible to assign to system dynamic vars on initialization [1b9d53c]
    + Broadened acceptance in `(<+)`/`(>+)`: all Quanthashes can be considered Settys
        and all Baggys can be considered Mixys [1ebeeb3]
    + Implemented `skip-all` option in &plan in Test.pm [14b6d5f]
    + Made it possible to use `.head(*-N)` (all but last N) [1fea495]
    + Made it possible to use `.tail(*-N)` (all but first N) [188b7b1]
    + Allowed `*` and `Inf` args to Array|List.tail [1b34ea6]
    + Made .Set, .SetHash, .Mix, .MixHash, .Bag, and .BagHash nodal [189615c][3e412b9][7025050]
    + Made `infix:<(&)>` a multi and added basic candidates [e8cb9a2]
    + Made `(-)` a multi [495f970]
    + Added default descriptions for Test.pm's `like`, `unlike`, and `use-ok` [4b915f7]
    + Made `is rw` on optional params throw a typed exception instead of generic one [8370675]
    + Made it possible to pass IO::Path to `is native` trait [9984080]
    + Implemented bypass of dependency resolution in the Staging repo
        via RAKUDO_RERESOLVE_DEPENDENCIES env var [5b862a3][d4d6a99][2a0a2d3]
    + Merged Cursor into Match; in preparation of for future removal of Cursor [b7c036c][cdd625b]
    + [IO] Added more powerful features to IO::Path.extension [b1e7a01][15a25da]
    + [IO] Added IO::Path.add [40217ed][0b5a41b]
    + [IO] Implemented IO::Path.sibling [8bacad8]
    + [IO] Implemented IO::Handle.lock [214198b]
    + [IO] Made IO::Path throw when path contains NUL byte [e681498]
    + [IO] Implemented `:completely` param in IO::Path.resolve [6a8d63d][51e4629]
    + [IO] Implemented IO::Handle.slurp [f1b4af7]
    + [IO] Made IO::Path.dir a `multi` method [fbe7ace]
    + [IO] `$*TMPDIR` now has a container, so it's possible to `temp` it [b62d1a7]
    + [IO] Allowed IO::Path.z to be called on directories, to mirror .s [b6838ee]
    + [IO] Implemented IO::Handle.spurt [a5800a1]
    + [IO] Implemented &indir [a0ef2ed][ca1acb7]
    + [IO] Implemented IO::Path.concat-with [966a7e3]
    + [IO] Made `&*chdir` return new `$*CWD` [5464b82]
    + [IO] Expanded accepted arguments from Cool to IO() in &spurt [099512b]
    + [IO] Implemented :parent in IO::Spec::Cygwin.canonpath [0c8bef5]
    + [IO] Made IO::Path.lines lazy again (reversal from last release) [90da80f]
    + [IO] Re-added :close param to IO::Handle.lines (reversal from last release) [90da80f]
    + [IO] IO::Handle.lines($limit, :close) now closes the handle when $limit is reached [90da80f]
    + [IO] Added IO::Pipe.path and .IO methods to return an IO::Path type object [d46e8df]
    + [IO] Made IO::Path.mkdir return invocant on success [c01ebea]
    + [IO] IO::Path now `does` role `IO`. This exists solely as a future compatibility feature with
        `IO()` coercer type check and provides no new methods [87987c2][c95c4a7][fd503f8]
    + [IO] &chdir and IO::Path.chdir now support :r, :w, :d, :x args for
        file tests and default to :d test only [a0ef2ed]
    + [IO] Changed coercers from Str() to IO() in `&*chdir`, &chdir, IO::Path.chdir, &rename, &move,
        &copy to avoid limitations of IO::Path.Str and race conditions with `$*CWD`
        [2483d68][a0ef2ed][ff97083]
    + [IO] Changed a Capture of remaining args to be passed to the delegate IO::Handle
        methods, instead of the internal .open call in IO::Path .lines, .words, .comb,
        .spurt, and .split [099512b][90da80f]
    + [IO] The following now return Failures instead of throwing: &chdir, `&*chdir`, &spurt,
        IO::Path.spurt, IO::Handle.spurt, IO::Path.slurp, &symlink, &link, &rename, &move, &copy
        [a0ef2ed][2483d68][5464b82][c13480c][da1dea2][ff97083]
 + Removals:
    + Removed unused $.pid from Proc [5b8d4c2]
    + [IO] Removed &mkdir candidate that creates multiple dirs [0d9ecae]
    + [IO] Removed IO::Path.abspath [cb323d5][a432b3d]
    + [IO] Made IO::Path.new-from-absolute-path a private method [7f73f92]
    + [IO] Removed vestigial IO::Path.pipe [a01d679]
    + [IO] Removed unused Capture in signatures of some .IO coercers [0c7e4a0]
    + [IO] Removed IO.umask method [87987c2][fd503f8][c95c4a7]
    + [IO] Removed :bin argument in IO::Handle.Supply; now uses handle's mode instead [184d499]
    + [IO] IO::Handle and IO::Socket no longer `does` role `IO` [87987c2]
    + [IO] Removed .chmod, .e, .d, .f, .s, .l, .r, .w, .x, .modifies, .accessed,
         .changed, .mode, and .watch methods from IO::Handle [36ad92a][50aea2b]
    + [IO] Removed &tmpdir and &homedir
    + [IO] :$test param on &chdir and IO::Path.chdir is now deprecated
        and will be removed in 6.d language [a0ef2ed]
 + Efficiency:
    + Made .Set/.SetHash.clone about 250x faster [d673ea7]
    + Make Baggy (&) Baggy about 80x faster [e9a3075]
    + Made Mixy (&) Mixy about 60x faster [03ef4be]
    + Made Str (elem) Map / Map (cont) Str 50x faster [a8c6eca]
    + Made Setty (&) Setty about 40x faster [89b5d65]
    + Made Setty (-) Setty about 40x faster [49c0ab6]
    + Made Baggy (|) Baggy at least 40x faster [4facf10]
    + Made Mix.BagHash and Mix.Bag coercions about 28x faster [2d8ac1e][af50e06]
    + Made Setty `(<+)`/`(>+)` Setty at least 25x faster [224e40f]
    + Made Mix.MixHash coercion about 25x faster [de983bc]
    + Made Map (|) Map 15x to 20x faster [9470d1c]
    + Made Setty (|) Setty about 25x faster [49807eb]
    + Made Object Hash.Set(Hash) coercion 12x faster [fb5d726]
    + Made .invert about 10x faster [7ea0f66]
    + Made Baggy coercion to Set|SetHash 10x faster [f947a19]
    + Made @a.first(Foo) 6x-10x faster (also affects many set operators) [9671ffe]
    + Made Iterable (|) Iterable about 9x faster [80062b0]
    + Made Set.WHICH about 8x faster for 50 elem Sets [167a0ed]
    + Made Set.SetHash coercion 12x faster [2731087]
    + Made coercion of Map to Set(|Hash) about 8x faster [4683e83]
    + Made Setty coercion to (Bag|Mix)Hash 7x faster [6686abb]
    + Made Map (&) Map about 7x faster [605e9e9]
    + Made Baggy `(<+)`/`(>+)` Baggy at least 6x faster [928a406][0672082]
    + Made Mixy `(<+)`/`(>+)` Mixy at least 5x faster [38b341a][0672082]
    + Made (cont)/(elem) 25% to 5x faster for QuantHashes [5b7ef3e]
    + Made Setty.hash about 4x faster [10fe02a]
    + Made Setty.pick/SetHash.(grab|grabpairs) 4x faster [6c9f31b]
    + Made Iterable.Set(|Hash) about 4x faster [f849df3]
    + Made m:i// regex matching 1.8x-3.3x faster [3e275dd]
    + Made Enum.ACCEPTS(Enum) 2.9x faster [17d34cd]
    + Made Iterable (&) Iterable about 2x faster [0fc3751]
    + Made internal nqp::index 2x faster, affecting many methods that work with strings [f1fc879]
    + Made case-insensitive regex 2x faster [822566f]
    + Made Baggy.new-from-pairs 1.5x faster and use less memory [ff52b74]
    + Made concatenation with control chars at end 30% faster [027aa54]
    + Made Baggy.new, bag(), and mix() about 25% faster [ae3ff5c]
    + Made Iterable.flat about 20% faster (also affects `*@foo` slurpy params) [f532f81]
    + Made Numeric.ACCEPTS(Any) about 15% faster [89457f8][e0e0800]
    + Made Hash.Bag about 15% faster [e7e97c7]
    + Made generic handling of `(<+)` and `(>+)` about 15% faster [5ae4549]
    + Made Set.new(42) about 8% faster and use less memory [fb60621][1471527]
    + Made Set.new-from-pairs about 4% faster for Pairs [213a72c]
    + Made Any.unique a few percent faster [6060bd3]
    + Streamlined tai/epoch conversion / leap-second check [dcebce4]
    + Added fastpath for `infix:<(|)>` with empty list of args [e24980f]
    + Made multiple memory use reductions in internals in MoarVM [d0924f1]
    + Made Grammars pre-compute their NFAs during precompilation [064b585]
    + Improved FSA which gives better multithreading performance [20af51f]
    + [IO] Made IO::Spec::Unix.split 36x faster [4fdebc9]
    + [IO] Made IO::Spec::Unix.catpath 9x faster [55abc6d]
    + [IO] Made IO::Spec::Unix.join 8.5x faster [55abc6d]
    + [IO] Made IO::Spec::Unix.is-absolute about 4.4x faster [4eef6db]
    + [IO] Made IO::Spec::Unix.catdir 3.9x Faster [0111f10]
    + [IO] Made IO::Pipe.lines 3.2x faster [0c62815]
    + [IO] Made IO::Spec::Win32!canon-cat 2.3x faster [0e36bb2]
    + [IO] Made IO::Path.child 2.1x faster on `*nix` [55abc6d]
    + [IO] Made .IO.slurp about 2x as fast [b4d80c0]
    + [IO] Made IO::Handle.open 75% faster [4032953]
    + [IO] Made IO::Spec::Unix.rel2abs 35% faster [dcf1bb2]
    + [IO] Made IO::Path.slurp 12%-35% faster (for small files) [c13480c]
    + [IO] Made IO::Path.new 7% faster when creating from Str [ae5e510]
    + Assorted internal improvements to CPU/memory use [1132b1a][a123eb3][1bacc61][c3c849e]
        [fa9aa47][666ce35][e7e97c7][213a72c][fab9f87][9671ffe][08a9735][8a4df162][b64f210][1277fb5]
        [463898a][3f36508][65037c3][e408e47][6ef7b59][a4b30dc][7875eaf][d793e21][bf63719][9a2446c]
        [0dbe451][1867099][2694f5d]


The following people contributed to this release:

Zoffix Znet, Elizabeth Mattijsen, Pawel Murias, Larry Wall, Samantha McVey, 
Timo Paulssen, Jonathan Worthington, Daniel Green, Christian Bartolomäus, 
Tom Browder, Gabor Szabo, Stefan Seifert, Aleks-Daniel Jakimenko-Aleksejev, 
Will "Coke" Coleda, Brian S. Julin, Fernando Correa de Oliveira, 
David Warring, Fernando Correa, Itsuki Toyota, Wenzel P. P. Peppmeyer, 
Moritz Lenz, Julien Simonet, LLFourn, Harrison Chienjo, Cuong Manh Le, 
Brad Gilbert, Brian Duggan, dmaestro, Sterling Hanenkamp, Jonathan Stowe, 
Jan-Olof Hendig, Lloyd Fournier

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Perl 6 development: <https://donate.perlfoundation.org/>
(put "Perl 6 Core Development Fund" in the 'Purpose' text field)

The next release of Rakudo (#111), is tentatively scheduled for 2017-05-20.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, Perl 6 introductory documentation, 
and other software that can be used with the Rakudo compiler to enhance its utility.

