# Normal Form Grapheme roundtrip tests, generated from NormalizationTests.txt in
# the Unicode database by S15-nfg/test-gen.p6. Check we can take a Uni, turn it
# into an NFG string, and then get codepoints back out of it in NFC.

use Test;

plan 500;

ok Uni.new(0x1E0A, 0x0323).Str.NFC.list ~~ (0x1E0C, 0x0307,), '1E0A 0323 -> Str -> 1E0C 0307';
ok Uni.new(0x0044, 0x0307, 0x0323).Str.NFC.list ~~ (0x1E0C, 0x0307,), '0044 0307 0323 -> Str -> 1E0C 0307';
ok Uni.new(0x0044, 0x0323, 0x0307).Str.NFC.list ~~ (0x1E0C, 0x0307,), '0044 0323 0307 -> Str -> 1E0C 0307';
ok Uni.new(0x1E0A, 0x031B, 0x0323).Str.NFC.list ~~ (0x1E0C, 0x031B, 0x0307,), '1E0A 031B 0323 -> Str -> 1E0C 031B 0307';
ok Uni.new(0x0044, 0x031B, 0x0307, 0x0323).Str.NFC.list ~~ (0x1E0C, 0x031B, 0x0307,), '0044 031B 0307 0323 -> Str -> 1E0C 031B 0307';
ok Uni.new(0x0044, 0x031B, 0x0323, 0x0307).Str.NFC.list ~~ (0x1E0C, 0x031B, 0x0307,), '0044 031B 0323 0307 -> Str -> 1E0C 031B 0307';
ok Uni.new(0x0045, 0x0300, 0x0304).Str.NFC.list ~~ (0x00C8, 0x0304,), '0045 0300 0304 -> Str -> 00C8 0304';
ok Uni.new(0x05B8, 0x05B9, 0x05B1, 0x0591, 0x05C3, 0x05B0, 0x05AC, 0x059F).Str.NFC.list ~~ (0x05B1, 0x05B8, 0x05B9, 0x0591, 0x05C3, 0x05B0, 0x05AC, 0x059F,), '05B8 05B9 05B1 0591 05C3 05B0 05AC 059F -> Str -> 05B1 05B8 05B9 0591 05C3 05B0 05AC 059F';
ok Uni.new(0x0592, 0x05B7, 0x05BC, 0x05A5, 0x05B0, 0x05C0, 0x05C4, 0x05AD).Str.NFC.list ~~ (0x05B0, 0x05B7, 0x05BC, 0x05A5, 0x0592, 0x05C0, 0x05AD, 0x05C4,), '0592 05B7 05BC 05A5 05B0 05C0 05C4 05AD -> Str -> 05B0 05B7 05BC 05A5 0592 05C0 05AD 05C4';
ok Uni.new(0x0344).Str.NFC.list ~~ (0x0308, 0x0301,), '0344 -> Str -> 0308 0301';
ok Uni.new(0x0958).Str.NFC.list ~~ (0x0915, 0x093C,), '0958 -> Str -> 0915 093C';
ok Uni.new(0x0959).Str.NFC.list ~~ (0x0916, 0x093C,), '0959 -> Str -> 0916 093C';
ok Uni.new(0x095A).Str.NFC.list ~~ (0x0917, 0x093C,), '095A -> Str -> 0917 093C';
ok Uni.new(0x095B).Str.NFC.list ~~ (0x091C, 0x093C,), '095B -> Str -> 091C 093C';
ok Uni.new(0x095C).Str.NFC.list ~~ (0x0921, 0x093C,), '095C -> Str -> 0921 093C';
ok Uni.new(0x095D).Str.NFC.list ~~ (0x0922, 0x093C,), '095D -> Str -> 0922 093C';
ok Uni.new(0x095E).Str.NFC.list ~~ (0x092B, 0x093C,), '095E -> Str -> 092B 093C';
ok Uni.new(0x095F).Str.NFC.list ~~ (0x092F, 0x093C,), '095F -> Str -> 092F 093C';
ok Uni.new(0x09DC).Str.NFC.list ~~ (0x09A1, 0x09BC,), '09DC -> Str -> 09A1 09BC';
ok Uni.new(0x09DD).Str.NFC.list ~~ (0x09A2, 0x09BC,), '09DD -> Str -> 09A2 09BC';
ok Uni.new(0x09DF).Str.NFC.list ~~ (0x09AF, 0x09BC,), '09DF -> Str -> 09AF 09BC';
ok Uni.new(0x0A33).Str.NFC.list ~~ (0x0A32, 0x0A3C,), '0A33 -> Str -> 0A32 0A3C';
ok Uni.new(0x0A36).Str.NFC.list ~~ (0x0A38, 0x0A3C,), '0A36 -> Str -> 0A38 0A3C';
ok Uni.new(0x0A59).Str.NFC.list ~~ (0x0A16, 0x0A3C,), '0A59 -> Str -> 0A16 0A3C';
ok Uni.new(0x0A5A).Str.NFC.list ~~ (0x0A17, 0x0A3C,), '0A5A -> Str -> 0A17 0A3C';
ok Uni.new(0x0A5B).Str.NFC.list ~~ (0x0A1C, 0x0A3C,), '0A5B -> Str -> 0A1C 0A3C';
ok Uni.new(0x0A5E).Str.NFC.list ~~ (0x0A2B, 0x0A3C,), '0A5E -> Str -> 0A2B 0A3C';
ok Uni.new(0x0B5C).Str.NFC.list ~~ (0x0B21, 0x0B3C,), '0B5C -> Str -> 0B21 0B3C';
ok Uni.new(0x0B5D).Str.NFC.list ~~ (0x0B22, 0x0B3C,), '0B5D -> Str -> 0B22 0B3C';
ok Uni.new(0x0F73).Str.NFC.list ~~ (0x0F71, 0x0F72,), '0F73 -> Str -> 0F71 0F72';
ok Uni.new(0x0F75).Str.NFC.list ~~ (0x0F71, 0x0F74,), '0F75 -> Str -> 0F71 0F74';
ok Uni.new(0x0F76).Str.NFC.list ~~ (0x0FB2, 0x0F80,), '0F76 -> Str -> 0FB2 0F80';
ok Uni.new(0x0F78).Str.NFC.list ~~ (0x0FB3, 0x0F80,), '0F78 -> Str -> 0FB3 0F80';
ok Uni.new(0x0F81).Str.NFC.list ~~ (0x0F71, 0x0F80,), '0F81 -> Str -> 0F71 0F80';
ok Uni.new(0x2ADC).Str.NFC.list ~~ (0x2ADD, 0x0338,), '2ADC -> Str -> 2ADD 0338';
ok Uni.new(0xFB1D).Str.NFC.list ~~ (0x05D9, 0x05B4,), 'FB1D -> Str -> 05D9 05B4';
ok Uni.new(0xFB1F).Str.NFC.list ~~ (0x05F2, 0x05B7,), 'FB1F -> Str -> 05F2 05B7';
ok Uni.new(0xFB2A).Str.NFC.list ~~ (0x05E9, 0x05C1,), 'FB2A -> Str -> 05E9 05C1';
ok Uni.new(0xFB2B).Str.NFC.list ~~ (0x05E9, 0x05C2,), 'FB2B -> Str -> 05E9 05C2';
ok Uni.new(0xFB2C).Str.NFC.list ~~ (0x05E9, 0x05BC, 0x05C1,), 'FB2C -> Str -> 05E9 05BC 05C1';
ok Uni.new(0xFB2D).Str.NFC.list ~~ (0x05E9, 0x05BC, 0x05C2,), 'FB2D -> Str -> 05E9 05BC 05C2';
ok Uni.new(0xFB2E).Str.NFC.list ~~ (0x05D0, 0x05B7,), 'FB2E -> Str -> 05D0 05B7';
ok Uni.new(0xFB2F).Str.NFC.list ~~ (0x05D0, 0x05B8,), 'FB2F -> Str -> 05D0 05B8';
ok Uni.new(0xFB30).Str.NFC.list ~~ (0x05D0, 0x05BC,), 'FB30 -> Str -> 05D0 05BC';
ok Uni.new(0xFB31).Str.NFC.list ~~ (0x05D1, 0x05BC,), 'FB31 -> Str -> 05D1 05BC';
ok Uni.new(0xFB32).Str.NFC.list ~~ (0x05D2, 0x05BC,), 'FB32 -> Str -> 05D2 05BC';
ok Uni.new(0xFB33).Str.NFC.list ~~ (0x05D3, 0x05BC,), 'FB33 -> Str -> 05D3 05BC';
ok Uni.new(0xFB34).Str.NFC.list ~~ (0x05D4, 0x05BC,), 'FB34 -> Str -> 05D4 05BC';
ok Uni.new(0xFB35).Str.NFC.list ~~ (0x05D5, 0x05BC,), 'FB35 -> Str -> 05D5 05BC';
ok Uni.new(0xFB36).Str.NFC.list ~~ (0x05D6, 0x05BC,), 'FB36 -> Str -> 05D6 05BC';
ok Uni.new(0xFB38).Str.NFC.list ~~ (0x05D8, 0x05BC,), 'FB38 -> Str -> 05D8 05BC';
ok Uni.new(0xFB39).Str.NFC.list ~~ (0x05D9, 0x05BC,), 'FB39 -> Str -> 05D9 05BC';
ok Uni.new(0xFB3A).Str.NFC.list ~~ (0x05DA, 0x05BC,), 'FB3A -> Str -> 05DA 05BC';
ok Uni.new(0xFB3B).Str.NFC.list ~~ (0x05DB, 0x05BC,), 'FB3B -> Str -> 05DB 05BC';
ok Uni.new(0xFB3C).Str.NFC.list ~~ (0x05DC, 0x05BC,), 'FB3C -> Str -> 05DC 05BC';
ok Uni.new(0xFB3E).Str.NFC.list ~~ (0x05DE, 0x05BC,), 'FB3E -> Str -> 05DE 05BC';
ok Uni.new(0xFB40).Str.NFC.list ~~ (0x05E0, 0x05BC,), 'FB40 -> Str -> 05E0 05BC';
ok Uni.new(0xFB41).Str.NFC.list ~~ (0x05E1, 0x05BC,), 'FB41 -> Str -> 05E1 05BC';
ok Uni.new(0xFB43).Str.NFC.list ~~ (0x05E3, 0x05BC,), 'FB43 -> Str -> 05E3 05BC';
ok Uni.new(0xFB44).Str.NFC.list ~~ (0x05E4, 0x05BC,), 'FB44 -> Str -> 05E4 05BC';
ok Uni.new(0xFB46).Str.NFC.list ~~ (0x05E6, 0x05BC,), 'FB46 -> Str -> 05E6 05BC';
ok Uni.new(0xFB47).Str.NFC.list ~~ (0x05E7, 0x05BC,), 'FB47 -> Str -> 05E7 05BC';
ok Uni.new(0xFB48).Str.NFC.list ~~ (0x05E8, 0x05BC,), 'FB48 -> Str -> 05E8 05BC';
ok Uni.new(0xFB49).Str.NFC.list ~~ (0x05E9, 0x05BC,), 'FB49 -> Str -> 05E9 05BC';
ok Uni.new(0xFB4A).Str.NFC.list ~~ (0x05EA, 0x05BC,), 'FB4A -> Str -> 05EA 05BC';
ok Uni.new(0xFB4B).Str.NFC.list ~~ (0x05D5, 0x05B9,), 'FB4B -> Str -> 05D5 05B9';
ok Uni.new(0xFB4C).Str.NFC.list ~~ (0x05D1, 0x05BF,), 'FB4C -> Str -> 05D1 05BF';
ok Uni.new(0xFB4D).Str.NFC.list ~~ (0x05DB, 0x05BF,), 'FB4D -> Str -> 05DB 05BF';
ok Uni.new(0xFB4E).Str.NFC.list ~~ (0x05E4, 0x05BF,), 'FB4E -> Str -> 05E4 05BF';
ok Uni.new(0x1D15E).Str.NFC.list ~~ (0x1D157, 0x1D165,), '1D15E -> Str -> 1D157 1D165';
ok Uni.new(0x1D15F).Str.NFC.list ~~ (0x1D158, 0x1D165,), '1D15F -> Str -> 1D158 1D165';
ok Uni.new(0x1D160).Str.NFC.list ~~ (0x1D158, 0x1D165, 0x1D16E,), '1D160 -> Str -> 1D158 1D165 1D16E';
ok Uni.new(0x1D161).Str.NFC.list ~~ (0x1D158, 0x1D165, 0x1D16F,), '1D161 -> Str -> 1D158 1D165 1D16F';
ok Uni.new(0x1D162).Str.NFC.list ~~ (0x1D158, 0x1D165, 0x1D170,), '1D162 -> Str -> 1D158 1D165 1D170';
ok Uni.new(0x1D163).Str.NFC.list ~~ (0x1D158, 0x1D165, 0x1D171,), '1D163 -> Str -> 1D158 1D165 1D171';
ok Uni.new(0x1D164).Str.NFC.list ~~ (0x1D158, 0x1D165, 0x1D172,), '1D164 -> Str -> 1D158 1D165 1D172';
ok Uni.new(0x1D1BB).Str.NFC.list ~~ (0x1D1B9, 0x1D165,), '1D1BB -> Str -> 1D1B9 1D165';
ok Uni.new(0x1D1BC).Str.NFC.list ~~ (0x1D1BA, 0x1D165,), '1D1BC -> Str -> 1D1BA 1D165';
ok Uni.new(0x1D1BD).Str.NFC.list ~~ (0x1D1B9, 0x1D165, 0x1D16E,), '1D1BD -> Str -> 1D1B9 1D165 1D16E';
ok Uni.new(0x1D1BE).Str.NFC.list ~~ (0x1D1BA, 0x1D165, 0x1D16E,), '1D1BE -> Str -> 1D1BA 1D165 1D16E';
ok Uni.new(0x1D1BF).Str.NFC.list ~~ (0x1D1B9, 0x1D165, 0x1D16F,), '1D1BF -> Str -> 1D1B9 1D165 1D16F';
ok Uni.new(0x1D1C0).Str.NFC.list ~~ (0x1D1BA, 0x1D165, 0x1D16F,), '1D1C0 -> Str -> 1D1BA 1D165 1D16F';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0300, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0300, 0x0315, 0x0062,), '0061 0315 0300 05AE 0300 0062 -> Str -> 00E0 05AE 0300 0315 0062';
ok Uni.new(0x0061, 0x0300, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0300, 0x0315, 0x0062,), '0061 0300 0315 0300 05AE 0062 -> Str -> 00E0 05AE 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0301, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0301, 0x0315, 0x0062,), '0061 0315 0300 05AE 0301 0062 -> Str -> 00E0 05AE 0301 0315 0062';
ok Uni.new(0x0061, 0x0301, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x00E1, 0x05AE, 0x0300, 0x0315, 0x0062,), '0061 0301 0315 0300 05AE 0062 -> Str -> 00E1 05AE 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0302, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0302, 0x0315, 0x0062,), '0061 0315 0300 05AE 0302 0062 -> Str -> 00E0 05AE 0302 0315 0062';
ok Uni.new(0x0061, 0x0302, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x1EA7, 0x05AE, 0x0315, 0x0062,), '0061 0302 0315 0300 05AE 0062 -> Str -> 1EA7 05AE 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0303, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0303, 0x0315, 0x0062,), '0061 0315 0300 05AE 0303 0062 -> Str -> 00E0 05AE 0303 0315 0062';
ok Uni.new(0x0061, 0x0303, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x00E3, 0x05AE, 0x0300, 0x0315, 0x0062,), '0061 0303 0315 0300 05AE 0062 -> Str -> 00E3 05AE 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0304, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0304, 0x0315, 0x0062,), '0061 0315 0300 05AE 0304 0062 -> Str -> 00E0 05AE 0304 0315 0062';
ok Uni.new(0x0061, 0x0304, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0101, 0x05AE, 0x0300, 0x0315, 0x0062,), '0061 0304 0315 0300 05AE 0062 -> Str -> 0101 05AE 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0305, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0305, 0x0315, 0x0062,), '0061 0315 0300 05AE 0305 0062 -> Str -> 00E0 05AE 0305 0315 0062';
ok Uni.new(0x0061, 0x0305, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0305, 0x0300, 0x0315, 0x0062,), '0061 0305 0315 0300 05AE 0062 -> Str -> 0061 05AE 0305 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0306, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0306, 0x0315, 0x0062,), '0061 0315 0300 05AE 0306 0062 -> Str -> 00E0 05AE 0306 0315 0062';
ok Uni.new(0x0061, 0x0306, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x1EB1, 0x05AE, 0x0315, 0x0062,), '0061 0306 0315 0300 05AE 0062 -> Str -> 1EB1 05AE 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0307, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0307, 0x0315, 0x0062,), '0061 0315 0300 05AE 0307 0062 -> Str -> 00E0 05AE 0307 0315 0062';
ok Uni.new(0x0061, 0x0307, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0227, 0x05AE, 0x0300, 0x0315, 0x0062,), '0061 0307 0315 0300 05AE 0062 -> Str -> 0227 05AE 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0308, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0308, 0x0315, 0x0062,), '0061 0315 0300 05AE 0308 0062 -> Str -> 00E0 05AE 0308 0315 0062';
ok Uni.new(0x0061, 0x0308, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x00E4, 0x05AE, 0x0300, 0x0315, 0x0062,), '0061 0308 0315 0300 05AE 0062 -> Str -> 00E4 05AE 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0309, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0309, 0x0315, 0x0062,), '0061 0315 0300 05AE 0309 0062 -> Str -> 00E0 05AE 0309 0315 0062';
ok Uni.new(0x0061, 0x0309, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x1EA3, 0x05AE, 0x0300, 0x0315, 0x0062,), '0061 0309 0315 0300 05AE 0062 -> Str -> 1EA3 05AE 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x030A, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x030A, 0x0315, 0x0062,), '0061 0315 0300 05AE 030A 0062 -> Str -> 00E0 05AE 030A 0315 0062';
ok Uni.new(0x0061, 0x030A, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x00E5, 0x05AE, 0x0300, 0x0315, 0x0062,), '0061 030A 0315 0300 05AE 0062 -> Str -> 00E5 05AE 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x030B, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x030B, 0x0315, 0x0062,), '0061 0315 0300 05AE 030B 0062 -> Str -> 00E0 05AE 030B 0315 0062';
ok Uni.new(0x0061, 0x030B, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x030B, 0x0300, 0x0315, 0x0062,), '0061 030B 0315 0300 05AE 0062 -> Str -> 0061 05AE 030B 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x030C, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x030C, 0x0315, 0x0062,), '0061 0315 0300 05AE 030C 0062 -> Str -> 00E0 05AE 030C 0315 0062';
ok Uni.new(0x0061, 0x030C, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x01CE, 0x05AE, 0x0300, 0x0315, 0x0062,), '0061 030C 0315 0300 05AE 0062 -> Str -> 01CE 05AE 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x030D, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x030D, 0x0315, 0x0062,), '0061 0315 0300 05AE 030D 0062 -> Str -> 00E0 05AE 030D 0315 0062';
ok Uni.new(0x0061, 0x030D, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x030D, 0x0300, 0x0315, 0x0062,), '0061 030D 0315 0300 05AE 0062 -> Str -> 0061 05AE 030D 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x030E, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x030E, 0x0315, 0x0062,), '0061 0315 0300 05AE 030E 0062 -> Str -> 00E0 05AE 030E 0315 0062';
ok Uni.new(0x0061, 0x030E, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x030E, 0x0300, 0x0315, 0x0062,), '0061 030E 0315 0300 05AE 0062 -> Str -> 0061 05AE 030E 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x030F, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x030F, 0x0315, 0x0062,), '0061 0315 0300 05AE 030F 0062 -> Str -> 00E0 05AE 030F 0315 0062';
ok Uni.new(0x0061, 0x030F, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0201, 0x05AE, 0x0300, 0x0315, 0x0062,), '0061 030F 0315 0300 05AE 0062 -> Str -> 0201 05AE 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0310, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0310, 0x0315, 0x0062,), '0061 0315 0300 05AE 0310 0062 -> Str -> 00E0 05AE 0310 0315 0062';
ok Uni.new(0x0061, 0x0310, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0310, 0x0300, 0x0315, 0x0062,), '0061 0310 0315 0300 05AE 0062 -> Str -> 0061 05AE 0310 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0311, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0311, 0x0315, 0x0062,), '0061 0315 0300 05AE 0311 0062 -> Str -> 00E0 05AE 0311 0315 0062';
ok Uni.new(0x0061, 0x0311, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0203, 0x05AE, 0x0300, 0x0315, 0x0062,), '0061 0311 0315 0300 05AE 0062 -> Str -> 0203 05AE 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0312, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0312, 0x0315, 0x0062,), '0061 0315 0300 05AE 0312 0062 -> Str -> 00E0 05AE 0312 0315 0062';
ok Uni.new(0x0061, 0x0312, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0312, 0x0300, 0x0315, 0x0062,), '0061 0312 0315 0300 05AE 0062 -> Str -> 0061 05AE 0312 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0313, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0313, 0x0315, 0x0062,), '0061 0315 0300 05AE 0313 0062 -> Str -> 00E0 05AE 0313 0315 0062';
ok Uni.new(0x0061, 0x0313, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0313, 0x0300, 0x0315, 0x0062,), '0061 0313 0315 0300 05AE 0062 -> Str -> 0061 05AE 0313 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0314, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0314, 0x0315, 0x0062,), '0061 0315 0300 05AE 0314 0062 -> Str -> 00E0 05AE 0314 0315 0062';
ok Uni.new(0x0061, 0x0314, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0314, 0x0300, 0x0315, 0x0062,), '0061 0314 0315 0300 05AE 0062 -> Str -> 0061 05AE 0314 0300 0315 0062';
ok Uni.new(0x0061, 0x035C, 0x0315, 0x0300, 0x0315, 0x0062).Str.NFC.list ~~ (0x00E0, 0x0315, 0x0315, 0x035C, 0x0062,), '0061 035C 0315 0300 0315 0062 -> Str -> 00E0 0315 0315 035C 0062';
ok Uni.new(0x0061, 0x0315, 0x035C, 0x0315, 0x0300, 0x0062).Str.NFC.list ~~ (0x00E0, 0x0315, 0x0315, 0x035C, 0x0062,), '0061 0315 035C 0315 0300 0062 -> Str -> 00E0 0315 0315 035C 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0316, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0316, 0x059A, 0x0062,), '0061 059A 0316 302A 0316 0062 -> Str -> 0061 302A 0316 0316 059A 0062';
ok Uni.new(0x0061, 0x0316, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0316, 0x059A, 0x0062,), '0061 0316 059A 0316 302A 0062 -> Str -> 0061 302A 0316 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0317, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0317, 0x059A, 0x0062,), '0061 059A 0316 302A 0317 0062 -> Str -> 0061 302A 0316 0317 059A 0062';
ok Uni.new(0x0061, 0x0317, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0317, 0x0316, 0x059A, 0x0062,), '0061 0317 059A 0316 302A 0062 -> Str -> 0061 302A 0317 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0318, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0318, 0x059A, 0x0062,), '0061 059A 0316 302A 0318 0062 -> Str -> 0061 302A 0316 0318 059A 0062';
ok Uni.new(0x0061, 0x0318, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0318, 0x0316, 0x059A, 0x0062,), '0061 0318 059A 0316 302A 0062 -> Str -> 0061 302A 0318 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0319, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0319, 0x059A, 0x0062,), '0061 059A 0316 302A 0319 0062 -> Str -> 0061 302A 0316 0319 059A 0062';
ok Uni.new(0x0061, 0x0319, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0319, 0x0316, 0x059A, 0x0062,), '0061 0319 059A 0316 302A 0062 -> Str -> 0061 302A 0319 0316 059A 0062';
ok Uni.new(0x0061, 0x035C, 0x0315, 0x0300, 0x031A, 0x0062).Str.NFC.list ~~ (0x00E0, 0x0315, 0x031A, 0x035C, 0x0062,), '0061 035C 0315 0300 031A 0062 -> Str -> 00E0 0315 031A 035C 0062';
ok Uni.new(0x0061, 0x031A, 0x035C, 0x0315, 0x0300, 0x0062).Str.NFC.list ~~ (0x00E0, 0x031A, 0x0315, 0x035C, 0x0062,), '0061 031A 035C 0315 0300 0062 -> Str -> 00E0 031A 0315 035C 0062';
ok Uni.new(0x0061, 0x302A, 0x031B, 0x1DCE, 0x031B, 0x0062).Str.NFC.list ~~ (0x0061, 0x1DCE, 0x031B, 0x031B, 0x302A, 0x0062,), '0061 302A 031B 1DCE 031B 0062 -> Str -> 0061 1DCE 031B 031B 302A 0062';
ok Uni.new(0x0061, 0x031B, 0x302A, 0x031B, 0x1DCE, 0x0062).Str.NFC.list ~~ (0x0061, 0x1DCE, 0x031B, 0x031B, 0x302A, 0x0062,), '0061 031B 302A 031B 1DCE 0062 -> Str -> 0061 1DCE 031B 031B 302A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x031C, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x031C, 0x059A, 0x0062,), '0061 059A 0316 302A 031C 0062 -> Str -> 0061 302A 0316 031C 059A 0062';
ok Uni.new(0x0061, 0x031C, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x031C, 0x0316, 0x059A, 0x0062,), '0061 031C 059A 0316 302A 0062 -> Str -> 0061 302A 031C 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x031D, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x031D, 0x059A, 0x0062,), '0061 059A 0316 302A 031D 0062 -> Str -> 0061 302A 0316 031D 059A 0062';
ok Uni.new(0x0061, 0x031D, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x031D, 0x0316, 0x059A, 0x0062,), '0061 031D 059A 0316 302A 0062 -> Str -> 0061 302A 031D 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x031E, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x031E, 0x059A, 0x0062,), '0061 059A 0316 302A 031E 0062 -> Str -> 0061 302A 0316 031E 059A 0062';
ok Uni.new(0x0061, 0x031E, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x031E, 0x0316, 0x059A, 0x0062,), '0061 031E 059A 0316 302A 0062 -> Str -> 0061 302A 031E 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x031F, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x031F, 0x059A, 0x0062,), '0061 059A 0316 302A 031F 0062 -> Str -> 0061 302A 0316 031F 059A 0062';
ok Uni.new(0x0061, 0x031F, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x031F, 0x0316, 0x059A, 0x0062,), '0061 031F 059A 0316 302A 0062 -> Str -> 0061 302A 031F 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0320, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0320, 0x059A, 0x0062,), '0061 059A 0316 302A 0320 0062 -> Str -> 0061 302A 0316 0320 059A 0062';
ok Uni.new(0x0061, 0x0320, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0320, 0x0316, 0x059A, 0x0062,), '0061 0320 059A 0316 302A 0062 -> Str -> 0061 302A 0320 0316 059A 0062';
ok Uni.new(0x0061, 0x1DCE, 0x0321, 0x0F74, 0x0321, 0x0062).Str.NFC.list ~~ (0x0061, 0x0F74, 0x0321, 0x0321, 0x1DCE, 0x0062,), '0061 1DCE 0321 0F74 0321 0062 -> Str -> 0061 0F74 0321 0321 1DCE 0062';
ok Uni.new(0x0061, 0x0321, 0x1DCE, 0x0321, 0x0F74, 0x0062).Str.NFC.list ~~ (0x0061, 0x0F74, 0x0321, 0x0321, 0x1DCE, 0x0062,), '0061 0321 1DCE 0321 0F74 0062 -> Str -> 0061 0F74 0321 0321 1DCE 0062';
ok Uni.new(0x0061, 0x1DCE, 0x0321, 0x0F74, 0x0322, 0x0062).Str.NFC.list ~~ (0x0061, 0x0F74, 0x0321, 0x0322, 0x1DCE, 0x0062,), '0061 1DCE 0321 0F74 0322 0062 -> Str -> 0061 0F74 0321 0322 1DCE 0062';
ok Uni.new(0x0061, 0x0322, 0x1DCE, 0x0321, 0x0F74, 0x0062).Str.NFC.list ~~ (0x0061, 0x0F74, 0x0322, 0x0321, 0x1DCE, 0x0062,), '0061 0322 1DCE 0321 0F74 0062 -> Str -> 0061 0F74 0322 0321 1DCE 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0323, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0323, 0x059A, 0x0062,), '0061 059A 0316 302A 0323 0062 -> Str -> 0061 302A 0316 0323 059A 0062';
ok Uni.new(0x0061, 0x0323, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x1EA1, 0x302A, 0x0316, 0x059A, 0x0062,), '0061 0323 059A 0316 302A 0062 -> Str -> 1EA1 302A 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0324, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0324, 0x059A, 0x0062,), '0061 059A 0316 302A 0324 0062 -> Str -> 0061 302A 0316 0324 059A 0062';
ok Uni.new(0x0061, 0x0324, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0324, 0x0316, 0x059A, 0x0062,), '0061 0324 059A 0316 302A 0062 -> Str -> 0061 302A 0324 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0325, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0325, 0x059A, 0x0062,), '0061 059A 0316 302A 0325 0062 -> Str -> 0061 302A 0316 0325 059A 0062';
ok Uni.new(0x0061, 0x0325, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x1E01, 0x302A, 0x0316, 0x059A, 0x0062,), '0061 0325 059A 0316 302A 0062 -> Str -> 1E01 302A 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0326, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0326, 0x059A, 0x0062,), '0061 059A 0316 302A 0326 0062 -> Str -> 0061 302A 0316 0326 059A 0062';
ok Uni.new(0x0061, 0x0326, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0326, 0x0316, 0x059A, 0x0062,), '0061 0326 059A 0316 302A 0062 -> Str -> 0061 302A 0326 0316 059A 0062';
ok Uni.new(0x0061, 0x1DCE, 0x0321, 0x0F74, 0x0327, 0x0062).Str.NFC.list ~~ (0x0061, 0x0F74, 0x0321, 0x0327, 0x1DCE, 0x0062,), '0061 1DCE 0321 0F74 0327 0062 -> Str -> 0061 0F74 0321 0327 1DCE 0062';
ok Uni.new(0x0061, 0x0327, 0x1DCE, 0x0321, 0x0F74, 0x0062).Str.NFC.list ~~ (0x0061, 0x0F74, 0x0327, 0x0321, 0x1DCE, 0x0062,), '0061 0327 1DCE 0321 0F74 0062 -> Str -> 0061 0F74 0327 0321 1DCE 0062';
ok Uni.new(0x0061, 0x1DCE, 0x0321, 0x0F74, 0x0328, 0x0062).Str.NFC.list ~~ (0x0061, 0x0F74, 0x0321, 0x0328, 0x1DCE, 0x0062,), '0061 1DCE 0321 0F74 0328 0062 -> Str -> 0061 0F74 0321 0328 1DCE 0062';
ok Uni.new(0x0061, 0x0328, 0x1DCE, 0x0321, 0x0F74, 0x0062).Str.NFC.list ~~ (0x0105, 0x0F74, 0x0321, 0x1DCE, 0x0062,), '0061 0328 1DCE 0321 0F74 0062 -> Str -> 0105 0F74 0321 1DCE 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0329, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0329, 0x059A, 0x0062,), '0061 059A 0316 302A 0329 0062 -> Str -> 0061 302A 0316 0329 059A 0062';
ok Uni.new(0x0061, 0x0329, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0329, 0x0316, 0x059A, 0x0062,), '0061 0329 059A 0316 302A 0062 -> Str -> 0061 302A 0329 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x032A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x032A, 0x059A, 0x0062,), '0061 059A 0316 302A 032A 0062 -> Str -> 0061 302A 0316 032A 059A 0062';
ok Uni.new(0x0061, 0x032A, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x032A, 0x0316, 0x059A, 0x0062,), '0061 032A 059A 0316 302A 0062 -> Str -> 0061 302A 032A 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x032B, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x032B, 0x059A, 0x0062,), '0061 059A 0316 302A 032B 0062 -> Str -> 0061 302A 0316 032B 059A 0062';
ok Uni.new(0x0061, 0x032B, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x032B, 0x0316, 0x059A, 0x0062,), '0061 032B 059A 0316 302A 0062 -> Str -> 0061 302A 032B 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x032C, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x032C, 0x059A, 0x0062,), '0061 059A 0316 302A 032C 0062 -> Str -> 0061 302A 0316 032C 059A 0062';
ok Uni.new(0x0061, 0x032C, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x032C, 0x0316, 0x059A, 0x0062,), '0061 032C 059A 0316 302A 0062 -> Str -> 0061 302A 032C 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x032D, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x032D, 0x059A, 0x0062,), '0061 059A 0316 302A 032D 0062 -> Str -> 0061 302A 0316 032D 059A 0062';
ok Uni.new(0x0061, 0x032D, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x032D, 0x0316, 0x059A, 0x0062,), '0061 032D 059A 0316 302A 0062 -> Str -> 0061 302A 032D 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x032E, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x032E, 0x059A, 0x0062,), '0061 059A 0316 302A 032E 0062 -> Str -> 0061 302A 0316 032E 059A 0062';
ok Uni.new(0x0061, 0x032E, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x032E, 0x0316, 0x059A, 0x0062,), '0061 032E 059A 0316 302A 0062 -> Str -> 0061 302A 032E 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x032F, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x032F, 0x059A, 0x0062,), '0061 059A 0316 302A 032F 0062 -> Str -> 0061 302A 0316 032F 059A 0062';
ok Uni.new(0x0061, 0x032F, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x032F, 0x0316, 0x059A, 0x0062,), '0061 032F 059A 0316 302A 0062 -> Str -> 0061 302A 032F 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0330, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0330, 0x059A, 0x0062,), '0061 059A 0316 302A 0330 0062 -> Str -> 0061 302A 0316 0330 059A 0062';
ok Uni.new(0x0061, 0x0330, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0330, 0x0316, 0x059A, 0x0062,), '0061 0330 059A 0316 302A 0062 -> Str -> 0061 302A 0330 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0331, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0331, 0x059A, 0x0062,), '0061 059A 0316 302A 0331 0062 -> Str -> 0061 302A 0316 0331 059A 0062';
ok Uni.new(0x0061, 0x0331, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0331, 0x0316, 0x059A, 0x0062,), '0061 0331 059A 0316 302A 0062 -> Str -> 0061 302A 0331 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0332, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0332, 0x059A, 0x0062,), '0061 059A 0316 302A 0332 0062 -> Str -> 0061 302A 0316 0332 059A 0062';
ok Uni.new(0x0061, 0x0332, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0332, 0x0316, 0x059A, 0x0062,), '0061 0332 059A 0316 302A 0062 -> Str -> 0061 302A 0332 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0333, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0333, 0x059A, 0x0062,), '0061 059A 0316 302A 0333 0062 -> Str -> 0061 302A 0316 0333 059A 0062';
ok Uni.new(0x0061, 0x0333, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0333, 0x0316, 0x059A, 0x0062,), '0061 0333 059A 0316 302A 0062 -> Str -> 0061 302A 0333 0316 059A 0062';
ok Uni.new(0x0061, 0x093C, 0x0334, 0x0334, 0x0062).Str.NFC.list ~~ (0x0061, 0x0334, 0x0334, 0x093C, 0x0062,), '0061 093C 0334 0334 0062 -> Str -> 0061 0334 0334 093C 0062';
ok Uni.new(0x0061, 0x0334, 0x093C, 0x0334, 0x0062).Str.NFC.list ~~ (0x0061, 0x0334, 0x0334, 0x093C, 0x0062,), '0061 0334 093C 0334 0062 -> Str -> 0061 0334 0334 093C 0062';
ok Uni.new(0x0061, 0x093C, 0x0334, 0x0335, 0x0062).Str.NFC.list ~~ (0x0061, 0x0334, 0x0335, 0x093C, 0x0062,), '0061 093C 0334 0335 0062 -> Str -> 0061 0334 0335 093C 0062';
ok Uni.new(0x0061, 0x0335, 0x093C, 0x0334, 0x0062).Str.NFC.list ~~ (0x0061, 0x0335, 0x0334, 0x093C, 0x0062,), '0061 0335 093C 0334 0062 -> Str -> 0061 0335 0334 093C 0062';
ok Uni.new(0x0061, 0x093C, 0x0334, 0x0336, 0x0062).Str.NFC.list ~~ (0x0061, 0x0334, 0x0336, 0x093C, 0x0062,), '0061 093C 0334 0336 0062 -> Str -> 0061 0334 0336 093C 0062';
ok Uni.new(0x0061, 0x0336, 0x093C, 0x0334, 0x0062).Str.NFC.list ~~ (0x0061, 0x0336, 0x0334, 0x093C, 0x0062,), '0061 0336 093C 0334 0062 -> Str -> 0061 0336 0334 093C 0062';
ok Uni.new(0x0061, 0x093C, 0x0334, 0x0337, 0x0062).Str.NFC.list ~~ (0x0061, 0x0334, 0x0337, 0x093C, 0x0062,), '0061 093C 0334 0337 0062 -> Str -> 0061 0334 0337 093C 0062';
ok Uni.new(0x0061, 0x0337, 0x093C, 0x0334, 0x0062).Str.NFC.list ~~ (0x0061, 0x0337, 0x0334, 0x093C, 0x0062,), '0061 0337 093C 0334 0062 -> Str -> 0061 0337 0334 093C 0062';
ok Uni.new(0x0061, 0x093C, 0x0334, 0x0338, 0x0062).Str.NFC.list ~~ (0x0061, 0x0334, 0x0338, 0x093C, 0x0062,), '0061 093C 0334 0338 0062 -> Str -> 0061 0334 0338 093C 0062';
ok Uni.new(0x0061, 0x0338, 0x093C, 0x0334, 0x0062).Str.NFC.list ~~ (0x0061, 0x0338, 0x0334, 0x093C, 0x0062,), '0061 0338 093C 0334 0062 -> Str -> 0061 0338 0334 093C 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0339, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0339, 0x059A, 0x0062,), '0061 059A 0316 302A 0339 0062 -> Str -> 0061 302A 0316 0339 059A 0062';
ok Uni.new(0x0061, 0x0339, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0339, 0x0316, 0x059A, 0x0062,), '0061 0339 059A 0316 302A 0062 -> Str -> 0061 302A 0339 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x033A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x033A, 0x059A, 0x0062,), '0061 059A 0316 302A 033A 0062 -> Str -> 0061 302A 0316 033A 059A 0062';
ok Uni.new(0x0061, 0x033A, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x033A, 0x0316, 0x059A, 0x0062,), '0061 033A 059A 0316 302A 0062 -> Str -> 0061 302A 033A 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x033B, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x033B, 0x059A, 0x0062,), '0061 059A 0316 302A 033B 0062 -> Str -> 0061 302A 0316 033B 059A 0062';
ok Uni.new(0x0061, 0x033B, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x033B, 0x0316, 0x059A, 0x0062,), '0061 033B 059A 0316 302A 0062 -> Str -> 0061 302A 033B 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x033C, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x033C, 0x059A, 0x0062,), '0061 059A 0316 302A 033C 0062 -> Str -> 0061 302A 0316 033C 059A 0062';
ok Uni.new(0x0061, 0x033C, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x033C, 0x0316, 0x059A, 0x0062,), '0061 033C 059A 0316 302A 0062 -> Str -> 0061 302A 033C 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x033D, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x033D, 0x0315, 0x0062,), '0061 0315 0300 05AE 033D 0062 -> Str -> 00E0 05AE 033D 0315 0062';
ok Uni.new(0x0061, 0x033D, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x033D, 0x0300, 0x0315, 0x0062,), '0061 033D 0315 0300 05AE 0062 -> Str -> 0061 05AE 033D 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x033E, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x033E, 0x0315, 0x0062,), '0061 0315 0300 05AE 033E 0062 -> Str -> 00E0 05AE 033E 0315 0062';
ok Uni.new(0x0061, 0x033E, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x033E, 0x0300, 0x0315, 0x0062,), '0061 033E 0315 0300 05AE 0062 -> Str -> 0061 05AE 033E 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x033F, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x033F, 0x0315, 0x0062,), '0061 0315 0300 05AE 033F 0062 -> Str -> 00E0 05AE 033F 0315 0062';
ok Uni.new(0x0061, 0x033F, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x033F, 0x0300, 0x0315, 0x0062,), '0061 033F 0315 0300 05AE 0062 -> Str -> 0061 05AE 033F 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0340, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0300, 0x0315, 0x0062,), '0061 0315 0300 05AE 0340 0062 -> Str -> 00E0 05AE 0300 0315 0062';
ok Uni.new(0x0061, 0x0340, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0300, 0x0315, 0x0062,), '0061 0340 0315 0300 05AE 0062 -> Str -> 00E0 05AE 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0341, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0301, 0x0315, 0x0062,), '0061 0315 0300 05AE 0341 0062 -> Str -> 00E0 05AE 0301 0315 0062';
ok Uni.new(0x0061, 0x0341, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x00E1, 0x05AE, 0x0300, 0x0315, 0x0062,), '0061 0341 0315 0300 05AE 0062 -> Str -> 00E1 05AE 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0342, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0342, 0x0315, 0x0062,), '0061 0315 0300 05AE 0342 0062 -> Str -> 00E0 05AE 0342 0315 0062';
ok Uni.new(0x0061, 0x0342, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0342, 0x0300, 0x0315, 0x0062,), '0061 0342 0315 0300 05AE 0062 -> Str -> 0061 05AE 0342 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0343, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0313, 0x0315, 0x0062,), '0061 0315 0300 05AE 0343 0062 -> Str -> 00E0 05AE 0313 0315 0062';
ok Uni.new(0x0061, 0x0343, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0313, 0x0300, 0x0315, 0x0062,), '0061 0343 0315 0300 05AE 0062 -> Str -> 0061 05AE 0313 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0344, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0308, 0x0301, 0x0315, 0x0062,), '0061 0315 0300 05AE 0344 0062 -> Str -> 00E0 05AE 0308 0301 0315 0062';
ok Uni.new(0x0061, 0x0344, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x00E4, 0x05AE, 0x0301, 0x0300, 0x0315, 0x0062,), '0061 0344 0315 0300 05AE 0062 -> Str -> 00E4 05AE 0301 0300 0315 0062';
ok Uni.new(0x0061, 0x0345, 0x035D, 0x0345, 0x0062).Str.NFC.list ~~ (0x0061, 0x035D, 0x0345, 0x0345, 0x0062,), '0061 0345 035D 0345 0062 -> Str -> 0061 035D 0345 0345 0062';
ok Uni.new(0x0061, 0x0345, 0x0345, 0x035D, 0x0062).Str.NFC.list ~~ (0x0061, 0x035D, 0x0345, 0x0345, 0x0062,), '0061 0345 0345 035D 0062 -> Str -> 0061 035D 0345 0345 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0346, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0346, 0x0315, 0x0062,), '0061 0315 0300 05AE 0346 0062 -> Str -> 00E0 05AE 0346 0315 0062';
ok Uni.new(0x0061, 0x0346, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0346, 0x0300, 0x0315, 0x0062,), '0061 0346 0315 0300 05AE 0062 -> Str -> 0061 05AE 0346 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0347, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0347, 0x059A, 0x0062,), '0061 059A 0316 302A 0347 0062 -> Str -> 0061 302A 0316 0347 059A 0062';
ok Uni.new(0x0061, 0x0347, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0347, 0x0316, 0x059A, 0x0062,), '0061 0347 059A 0316 302A 0062 -> Str -> 0061 302A 0347 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0348, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0348, 0x059A, 0x0062,), '0061 059A 0316 302A 0348 0062 -> Str -> 0061 302A 0316 0348 059A 0062';
ok Uni.new(0x0061, 0x0348, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0348, 0x0316, 0x059A, 0x0062,), '0061 0348 059A 0316 302A 0062 -> Str -> 0061 302A 0348 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0349, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0349, 0x059A, 0x0062,), '0061 059A 0316 302A 0349 0062 -> Str -> 0061 302A 0316 0349 059A 0062';
ok Uni.new(0x0061, 0x0349, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0349, 0x0316, 0x059A, 0x0062,), '0061 0349 059A 0316 302A 0062 -> Str -> 0061 302A 0349 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x034A, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x034A, 0x0315, 0x0062,), '0061 0315 0300 05AE 034A 0062 -> Str -> 00E0 05AE 034A 0315 0062';
ok Uni.new(0x0061, 0x034A, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x034A, 0x0300, 0x0315, 0x0062,), '0061 034A 0315 0300 05AE 0062 -> Str -> 0061 05AE 034A 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x034B, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x034B, 0x0315, 0x0062,), '0061 0315 0300 05AE 034B 0062 -> Str -> 00E0 05AE 034B 0315 0062';
ok Uni.new(0x0061, 0x034B, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x034B, 0x0300, 0x0315, 0x0062,), '0061 034B 0315 0300 05AE 0062 -> Str -> 0061 05AE 034B 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x034C, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x034C, 0x0315, 0x0062,), '0061 0315 0300 05AE 034C 0062 -> Str -> 00E0 05AE 034C 0315 0062';
ok Uni.new(0x0061, 0x034C, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x034C, 0x0300, 0x0315, 0x0062,), '0061 034C 0315 0300 05AE 0062 -> Str -> 0061 05AE 034C 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x034D, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x034D, 0x059A, 0x0062,), '0061 059A 0316 302A 034D 0062 -> Str -> 0061 302A 0316 034D 059A 0062';
ok Uni.new(0x0061, 0x034D, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x034D, 0x0316, 0x059A, 0x0062,), '0061 034D 059A 0316 302A 0062 -> Str -> 0061 302A 034D 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x034E, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x034E, 0x059A, 0x0062,), '0061 059A 0316 302A 034E 0062 -> Str -> 0061 302A 0316 034E 059A 0062';
ok Uni.new(0x0061, 0x034E, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x034E, 0x0316, 0x059A, 0x0062,), '0061 034E 059A 0316 302A 0062 -> Str -> 0061 302A 034E 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0350, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0350, 0x0315, 0x0062,), '0061 0315 0300 05AE 0350 0062 -> Str -> 00E0 05AE 0350 0315 0062';
ok Uni.new(0x0061, 0x0350, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0350, 0x0300, 0x0315, 0x0062,), '0061 0350 0315 0300 05AE 0062 -> Str -> 0061 05AE 0350 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0351, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0351, 0x0315, 0x0062,), '0061 0315 0300 05AE 0351 0062 -> Str -> 00E0 05AE 0351 0315 0062';
ok Uni.new(0x0061, 0x0351, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0351, 0x0300, 0x0315, 0x0062,), '0061 0351 0315 0300 05AE 0062 -> Str -> 0061 05AE 0351 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0352, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0352, 0x0315, 0x0062,), '0061 0315 0300 05AE 0352 0062 -> Str -> 00E0 05AE 0352 0315 0062';
ok Uni.new(0x0061, 0x0352, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0352, 0x0300, 0x0315, 0x0062,), '0061 0352 0315 0300 05AE 0062 -> Str -> 0061 05AE 0352 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0353, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0353, 0x059A, 0x0062,), '0061 059A 0316 302A 0353 0062 -> Str -> 0061 302A 0316 0353 059A 0062';
ok Uni.new(0x0061, 0x0353, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0353, 0x0316, 0x059A, 0x0062,), '0061 0353 059A 0316 302A 0062 -> Str -> 0061 302A 0353 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0354, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0354, 0x059A, 0x0062,), '0061 059A 0316 302A 0354 0062 -> Str -> 0061 302A 0316 0354 059A 0062';
ok Uni.new(0x0061, 0x0354, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0354, 0x0316, 0x059A, 0x0062,), '0061 0354 059A 0316 302A 0062 -> Str -> 0061 302A 0354 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0355, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0355, 0x059A, 0x0062,), '0061 059A 0316 302A 0355 0062 -> Str -> 0061 302A 0316 0355 059A 0062';
ok Uni.new(0x0061, 0x0355, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0355, 0x0316, 0x059A, 0x0062,), '0061 0355 059A 0316 302A 0062 -> Str -> 0061 302A 0355 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0356, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0356, 0x059A, 0x0062,), '0061 059A 0316 302A 0356 0062 -> Str -> 0061 302A 0316 0356 059A 0062';
ok Uni.new(0x0061, 0x0356, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0356, 0x0316, 0x059A, 0x0062,), '0061 0356 059A 0316 302A 0062 -> Str -> 0061 302A 0356 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0357, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0357, 0x0315, 0x0062,), '0061 0315 0300 05AE 0357 0062 -> Str -> 00E0 05AE 0357 0315 0062';
ok Uni.new(0x0061, 0x0357, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0357, 0x0300, 0x0315, 0x0062,), '0061 0357 0315 0300 05AE 0062 -> Str -> 0061 05AE 0357 0300 0315 0062';
ok Uni.new(0x0061, 0x035C, 0x0315, 0x0300, 0x0358, 0x0062).Str.NFC.list ~~ (0x00E0, 0x0315, 0x0358, 0x035C, 0x0062,), '0061 035C 0315 0300 0358 0062 -> Str -> 00E0 0315 0358 035C 0062';
ok Uni.new(0x0061, 0x0358, 0x035C, 0x0315, 0x0300, 0x0062).Str.NFC.list ~~ (0x00E0, 0x0358, 0x0315, 0x035C, 0x0062,), '0061 0358 035C 0315 0300 0062 -> Str -> 00E0 0358 0315 035C 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0359, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0359, 0x059A, 0x0062,), '0061 059A 0316 302A 0359 0062 -> Str -> 0061 302A 0316 0359 059A 0062';
ok Uni.new(0x0061, 0x0359, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0359, 0x0316, 0x059A, 0x0062,), '0061 0359 059A 0316 302A 0062 -> Str -> 0061 302A 0359 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x035A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x035A, 0x059A, 0x0062,), '0061 059A 0316 302A 035A 0062 -> Str -> 0061 302A 0316 035A 059A 0062';
ok Uni.new(0x0061, 0x035A, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x035A, 0x0316, 0x059A, 0x0062,), '0061 035A 059A 0316 302A 0062 -> Str -> 0061 302A 035A 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x035B, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x035B, 0x0315, 0x0062,), '0061 0315 0300 05AE 035B 0062 -> Str -> 00E0 05AE 035B 0315 0062';
ok Uni.new(0x0061, 0x035B, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x035B, 0x0300, 0x0315, 0x0062,), '0061 035B 0315 0300 05AE 0062 -> Str -> 0061 05AE 035B 0300 0315 0062';
ok Uni.new(0x0061, 0x035D, 0x035C, 0x0315, 0x035C, 0x0062).Str.NFC.list ~~ (0x0061, 0x0315, 0x035C, 0x035C, 0x035D, 0x0062,), '0061 035D 035C 0315 035C 0062 -> Str -> 0061 0315 035C 035C 035D 0062';
ok Uni.new(0x0061, 0x035C, 0x035D, 0x035C, 0x0315, 0x0062).Str.NFC.list ~~ (0x0061, 0x0315, 0x035C, 0x035C, 0x035D, 0x0062,), '0061 035C 035D 035C 0315 0062 -> Str -> 0061 0315 035C 035C 035D 0062';
ok Uni.new(0x0061, 0x0345, 0x035D, 0x035C, 0x035D, 0x0062).Str.NFC.list ~~ (0x0061, 0x035C, 0x035D, 0x035D, 0x0345, 0x0062,), '0061 0345 035D 035C 035D 0062 -> Str -> 0061 035C 035D 035D 0345 0062';
ok Uni.new(0x0061, 0x035D, 0x0345, 0x035D, 0x035C, 0x0062).Str.NFC.list ~~ (0x0061, 0x035C, 0x035D, 0x035D, 0x0345, 0x0062,), '0061 035D 0345 035D 035C 0062 -> Str -> 0061 035C 035D 035D 0345 0062';
ok Uni.new(0x0061, 0x0345, 0x035D, 0x035C, 0x035E, 0x0062).Str.NFC.list ~~ (0x0061, 0x035C, 0x035D, 0x035E, 0x0345, 0x0062,), '0061 0345 035D 035C 035E 0062 -> Str -> 0061 035C 035D 035E 0345 0062';
ok Uni.new(0x0061, 0x035E, 0x0345, 0x035D, 0x035C, 0x0062).Str.NFC.list ~~ (0x0061, 0x035C, 0x035E, 0x035D, 0x0345, 0x0062,), '0061 035E 0345 035D 035C 0062 -> Str -> 0061 035C 035E 035D 0345 0062';
ok Uni.new(0x0061, 0x035D, 0x035C, 0x0315, 0x035F, 0x0062).Str.NFC.list ~~ (0x0061, 0x0315, 0x035C, 0x035F, 0x035D, 0x0062,), '0061 035D 035C 0315 035F 0062 -> Str -> 0061 0315 035C 035F 035D 0062';
ok Uni.new(0x0061, 0x035F, 0x035D, 0x035C, 0x0315, 0x0062).Str.NFC.list ~~ (0x0061, 0x0315, 0x035F, 0x035C, 0x035D, 0x0062,), '0061 035F 035D 035C 0315 0062 -> Str -> 0061 0315 035F 035C 035D 0062';
ok Uni.new(0x0061, 0x0345, 0x035D, 0x035C, 0x0360, 0x0062).Str.NFC.list ~~ (0x0061, 0x035C, 0x035D, 0x0360, 0x0345, 0x0062,), '0061 0345 035D 035C 0360 0062 -> Str -> 0061 035C 035D 0360 0345 0062';
ok Uni.new(0x0061, 0x0360, 0x0345, 0x035D, 0x035C, 0x0062).Str.NFC.list ~~ (0x0061, 0x035C, 0x0360, 0x035D, 0x0345, 0x0062,), '0061 0360 0345 035D 035C 0062 -> Str -> 0061 035C 0360 035D 0345 0062';
ok Uni.new(0x0061, 0x0345, 0x035D, 0x035C, 0x0361, 0x0062).Str.NFC.list ~~ (0x0061, 0x035C, 0x035D, 0x0361, 0x0345, 0x0062,), '0061 0345 035D 035C 0361 0062 -> Str -> 0061 035C 035D 0361 0345 0062';
ok Uni.new(0x0061, 0x0361, 0x0345, 0x035D, 0x035C, 0x0062).Str.NFC.list ~~ (0x0061, 0x035C, 0x0361, 0x035D, 0x0345, 0x0062,), '0061 0361 0345 035D 035C 0062 -> Str -> 0061 035C 0361 035D 0345 0062';
ok Uni.new(0x0061, 0x035D, 0x035C, 0x0315, 0x0362, 0x0062).Str.NFC.list ~~ (0x0061, 0x0315, 0x035C, 0x0362, 0x035D, 0x0062,), '0061 035D 035C 0315 0362 0062 -> Str -> 0061 0315 035C 0362 035D 0062';
ok Uni.new(0x0061, 0x0362, 0x035D, 0x035C, 0x0315, 0x0062).Str.NFC.list ~~ (0x0061, 0x0315, 0x0362, 0x035C, 0x035D, 0x0062,), '0061 0362 035D 035C 0315 0062 -> Str -> 0061 0315 0362 035C 035D 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0363, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0363, 0x0315, 0x0062,), '0061 0315 0300 05AE 0363 0062 -> Str -> 00E0 05AE 0363 0315 0062';
ok Uni.new(0x0061, 0x0363, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0363, 0x0300, 0x0315, 0x0062,), '0061 0363 0315 0300 05AE 0062 -> Str -> 0061 05AE 0363 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0364, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0364, 0x0315, 0x0062,), '0061 0315 0300 05AE 0364 0062 -> Str -> 00E0 05AE 0364 0315 0062';
ok Uni.new(0x0061, 0x0364, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0364, 0x0300, 0x0315, 0x0062,), '0061 0364 0315 0300 05AE 0062 -> Str -> 0061 05AE 0364 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0365, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0365, 0x0315, 0x0062,), '0061 0315 0300 05AE 0365 0062 -> Str -> 00E0 05AE 0365 0315 0062';
ok Uni.new(0x0061, 0x0365, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0365, 0x0300, 0x0315, 0x0062,), '0061 0365 0315 0300 05AE 0062 -> Str -> 0061 05AE 0365 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0366, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0366, 0x0315, 0x0062,), '0061 0315 0300 05AE 0366 0062 -> Str -> 00E0 05AE 0366 0315 0062';
ok Uni.new(0x0061, 0x0366, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0366, 0x0300, 0x0315, 0x0062,), '0061 0366 0315 0300 05AE 0062 -> Str -> 0061 05AE 0366 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0367, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0367, 0x0315, 0x0062,), '0061 0315 0300 05AE 0367 0062 -> Str -> 00E0 05AE 0367 0315 0062';
ok Uni.new(0x0061, 0x0367, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0367, 0x0300, 0x0315, 0x0062,), '0061 0367 0315 0300 05AE 0062 -> Str -> 0061 05AE 0367 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0368, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0368, 0x0315, 0x0062,), '0061 0315 0300 05AE 0368 0062 -> Str -> 00E0 05AE 0368 0315 0062';
ok Uni.new(0x0061, 0x0368, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0368, 0x0300, 0x0315, 0x0062,), '0061 0368 0315 0300 05AE 0062 -> Str -> 0061 05AE 0368 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0369, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0369, 0x0315, 0x0062,), '0061 0315 0300 05AE 0369 0062 -> Str -> 00E0 05AE 0369 0315 0062';
ok Uni.new(0x0061, 0x0369, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0369, 0x0300, 0x0315, 0x0062,), '0061 0369 0315 0300 05AE 0062 -> Str -> 0061 05AE 0369 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x036A, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x036A, 0x0315, 0x0062,), '0061 0315 0300 05AE 036A 0062 -> Str -> 00E0 05AE 036A 0315 0062';
ok Uni.new(0x0061, 0x036A, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x036A, 0x0300, 0x0315, 0x0062,), '0061 036A 0315 0300 05AE 0062 -> Str -> 0061 05AE 036A 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x036B, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x036B, 0x0315, 0x0062,), '0061 0315 0300 05AE 036B 0062 -> Str -> 00E0 05AE 036B 0315 0062';
ok Uni.new(0x0061, 0x036B, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x036B, 0x0300, 0x0315, 0x0062,), '0061 036B 0315 0300 05AE 0062 -> Str -> 0061 05AE 036B 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x036C, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x036C, 0x0315, 0x0062,), '0061 0315 0300 05AE 036C 0062 -> Str -> 00E0 05AE 036C 0315 0062';
ok Uni.new(0x0061, 0x036C, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x036C, 0x0300, 0x0315, 0x0062,), '0061 036C 0315 0300 05AE 0062 -> Str -> 0061 05AE 036C 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x036D, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x036D, 0x0315, 0x0062,), '0061 0315 0300 05AE 036D 0062 -> Str -> 00E0 05AE 036D 0315 0062';
ok Uni.new(0x0061, 0x036D, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x036D, 0x0300, 0x0315, 0x0062,), '0061 036D 0315 0300 05AE 0062 -> Str -> 0061 05AE 036D 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x036E, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x036E, 0x0315, 0x0062,), '0061 0315 0300 05AE 036E 0062 -> Str -> 00E0 05AE 036E 0315 0062';
ok Uni.new(0x0061, 0x036E, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x036E, 0x0300, 0x0315, 0x0062,), '0061 036E 0315 0300 05AE 0062 -> Str -> 0061 05AE 036E 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x036F, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x036F, 0x0315, 0x0062,), '0061 0315 0300 05AE 036F 0062 -> Str -> 00E0 05AE 036F 0315 0062';
ok Uni.new(0x0061, 0x036F, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x036F, 0x0300, 0x0315, 0x0062,), '0061 036F 0315 0300 05AE 0062 -> Str -> 0061 05AE 036F 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0483, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0483, 0x0315, 0x0062,), '0061 0315 0300 05AE 0483 0062 -> Str -> 00E0 05AE 0483 0315 0062';
ok Uni.new(0x0061, 0x0483, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0483, 0x0300, 0x0315, 0x0062,), '0061 0483 0315 0300 05AE 0062 -> Str -> 0061 05AE 0483 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0484, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0484, 0x0315, 0x0062,), '0061 0315 0300 05AE 0484 0062 -> Str -> 00E0 05AE 0484 0315 0062';
ok Uni.new(0x0061, 0x0484, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0484, 0x0300, 0x0315, 0x0062,), '0061 0484 0315 0300 05AE 0062 -> Str -> 0061 05AE 0484 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0485, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0485, 0x0315, 0x0062,), '0061 0315 0300 05AE 0485 0062 -> Str -> 00E0 05AE 0485 0315 0062';
ok Uni.new(0x0061, 0x0485, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0485, 0x0300, 0x0315, 0x0062,), '0061 0485 0315 0300 05AE 0062 -> Str -> 0061 05AE 0485 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0486, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0486, 0x0315, 0x0062,), '0061 0315 0300 05AE 0486 0062 -> Str -> 00E0 05AE 0486 0315 0062';
ok Uni.new(0x0061, 0x0486, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0486, 0x0300, 0x0315, 0x0062,), '0061 0486 0315 0300 05AE 0062 -> Str -> 0061 05AE 0486 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0487, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0487, 0x0315, 0x0062,), '0061 0315 0300 05AE 0487 0062 -> Str -> 00E0 05AE 0487 0315 0062';
ok Uni.new(0x0061, 0x0487, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0487, 0x0300, 0x0315, 0x0062,), '0061 0487 0315 0300 05AE 0062 -> Str -> 0061 05AE 0487 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0591, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0591, 0x059A, 0x0062,), '0061 059A 0316 302A 0591 0062 -> Str -> 0061 302A 0316 0591 059A 0062';
ok Uni.new(0x0061, 0x0591, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0591, 0x0316, 0x059A, 0x0062,), '0061 0591 059A 0316 302A 0062 -> Str -> 0061 302A 0591 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0592, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0592, 0x0315, 0x0062,), '0061 0315 0300 05AE 0592 0062 -> Str -> 00E0 05AE 0592 0315 0062';
ok Uni.new(0x0061, 0x0592, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0592, 0x0300, 0x0315, 0x0062,), '0061 0592 0315 0300 05AE 0062 -> Str -> 0061 05AE 0592 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0593, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0593, 0x0315, 0x0062,), '0061 0315 0300 05AE 0593 0062 -> Str -> 00E0 05AE 0593 0315 0062';
ok Uni.new(0x0061, 0x0593, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0593, 0x0300, 0x0315, 0x0062,), '0061 0593 0315 0300 05AE 0062 -> Str -> 0061 05AE 0593 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0594, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0594, 0x0315, 0x0062,), '0061 0315 0300 05AE 0594 0062 -> Str -> 00E0 05AE 0594 0315 0062';
ok Uni.new(0x0061, 0x0594, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0594, 0x0300, 0x0315, 0x0062,), '0061 0594 0315 0300 05AE 0062 -> Str -> 0061 05AE 0594 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0595, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0595, 0x0315, 0x0062,), '0061 0315 0300 05AE 0595 0062 -> Str -> 00E0 05AE 0595 0315 0062';
ok Uni.new(0x0061, 0x0595, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0595, 0x0300, 0x0315, 0x0062,), '0061 0595 0315 0300 05AE 0062 -> Str -> 0061 05AE 0595 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0596, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0596, 0x059A, 0x0062,), '0061 059A 0316 302A 0596 0062 -> Str -> 0061 302A 0316 0596 059A 0062';
ok Uni.new(0x0061, 0x0596, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0596, 0x0316, 0x059A, 0x0062,), '0061 0596 059A 0316 302A 0062 -> Str -> 0061 302A 0596 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0597, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0597, 0x0315, 0x0062,), '0061 0315 0300 05AE 0597 0062 -> Str -> 00E0 05AE 0597 0315 0062';
ok Uni.new(0x0061, 0x0597, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0597, 0x0300, 0x0315, 0x0062,), '0061 0597 0315 0300 05AE 0062 -> Str -> 0061 05AE 0597 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0598, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0598, 0x0315, 0x0062,), '0061 0315 0300 05AE 0598 0062 -> Str -> 00E0 05AE 0598 0315 0062';
ok Uni.new(0x0061, 0x0598, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0598, 0x0300, 0x0315, 0x0062,), '0061 0598 0315 0300 05AE 0062 -> Str -> 0061 05AE 0598 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0599, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0599, 0x0315, 0x0062,), '0061 0315 0300 05AE 0599 0062 -> Str -> 00E0 05AE 0599 0315 0062';
ok Uni.new(0x0061, 0x0599, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0599, 0x0300, 0x0315, 0x0062,), '0061 0599 0315 0300 05AE 0062 -> Str -> 0061 05AE 0599 0300 0315 0062';
ok Uni.new(0x0061, 0x302E, 0x059A, 0x0316, 0x059A, 0x0062).Str.NFC.list ~~ (0x0061, 0x0316, 0x059A, 0x059A, 0x302E, 0x0062,), '0061 302E 059A 0316 059A 0062 -> Str -> 0061 0316 059A 059A 302E 0062';
ok Uni.new(0x0061, 0x059A, 0x302E, 0x059A, 0x0316, 0x0062).Str.NFC.list ~~ (0x0061, 0x0316, 0x059A, 0x059A, 0x302E, 0x0062,), '0061 059A 302E 059A 0316 0062 -> Str -> 0061 0316 059A 059A 302E 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x059B, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x059B, 0x059A, 0x0062,), '0061 059A 0316 302A 059B 0062 -> Str -> 0061 302A 0316 059B 059A 0062';
ok Uni.new(0x0061, 0x059B, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x059B, 0x0316, 0x059A, 0x0062,), '0061 059B 059A 0316 302A 0062 -> Str -> 0061 302A 059B 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x059C, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x059C, 0x0315, 0x0062,), '0061 0315 0300 05AE 059C 0062 -> Str -> 00E0 05AE 059C 0315 0062';
ok Uni.new(0x0061, 0x059C, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x059C, 0x0300, 0x0315, 0x0062,), '0061 059C 0315 0300 05AE 0062 -> Str -> 0061 05AE 059C 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x059D, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x059D, 0x0315, 0x0062,), '0061 0315 0300 05AE 059D 0062 -> Str -> 00E0 05AE 059D 0315 0062';
ok Uni.new(0x0061, 0x059D, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x059D, 0x0300, 0x0315, 0x0062,), '0061 059D 0315 0300 05AE 0062 -> Str -> 0061 05AE 059D 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x059E, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x059E, 0x0315, 0x0062,), '0061 0315 0300 05AE 059E 0062 -> Str -> 00E0 05AE 059E 0315 0062';
ok Uni.new(0x0061, 0x059E, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x059E, 0x0300, 0x0315, 0x0062,), '0061 059E 0315 0300 05AE 0062 -> Str -> 0061 05AE 059E 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x059F, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x059F, 0x0315, 0x0062,), '0061 0315 0300 05AE 059F 0062 -> Str -> 00E0 05AE 059F 0315 0062';
ok Uni.new(0x0061, 0x059F, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x059F, 0x0300, 0x0315, 0x0062,), '0061 059F 0315 0300 05AE 0062 -> Str -> 0061 05AE 059F 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x05A0, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x05A0, 0x0315, 0x0062,), '0061 0315 0300 05AE 05A0 0062 -> Str -> 00E0 05AE 05A0 0315 0062';
ok Uni.new(0x0061, 0x05A0, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x05A0, 0x0300, 0x0315, 0x0062,), '0061 05A0 0315 0300 05AE 0062 -> Str -> 0061 05AE 05A0 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x05A1, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x05A1, 0x0315, 0x0062,), '0061 0315 0300 05AE 05A1 0062 -> Str -> 00E0 05AE 05A1 0315 0062';
ok Uni.new(0x0061, 0x05A1, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x05A1, 0x0300, 0x0315, 0x0062,), '0061 05A1 0315 0300 05AE 0062 -> Str -> 0061 05AE 05A1 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x05A2, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x05A2, 0x059A, 0x0062,), '0061 059A 0316 302A 05A2 0062 -> Str -> 0061 302A 0316 05A2 059A 0062';
ok Uni.new(0x0061, 0x05A2, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x05A2, 0x0316, 0x059A, 0x0062,), '0061 05A2 059A 0316 302A 0062 -> Str -> 0061 302A 05A2 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x05A3, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x05A3, 0x059A, 0x0062,), '0061 059A 0316 302A 05A3 0062 -> Str -> 0061 302A 0316 05A3 059A 0062';
ok Uni.new(0x0061, 0x05A3, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x05A3, 0x0316, 0x059A, 0x0062,), '0061 05A3 059A 0316 302A 0062 -> Str -> 0061 302A 05A3 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x05A4, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x05A4, 0x059A, 0x0062,), '0061 059A 0316 302A 05A4 0062 -> Str -> 0061 302A 0316 05A4 059A 0062';
ok Uni.new(0x0061, 0x05A4, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x05A4, 0x0316, 0x059A, 0x0062,), '0061 05A4 059A 0316 302A 0062 -> Str -> 0061 302A 05A4 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x05A5, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x05A5, 0x059A, 0x0062,), '0061 059A 0316 302A 05A5 0062 -> Str -> 0061 302A 0316 05A5 059A 0062';
ok Uni.new(0x0061, 0x05A5, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x05A5, 0x0316, 0x059A, 0x0062,), '0061 05A5 059A 0316 302A 0062 -> Str -> 0061 302A 05A5 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x05A6, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x05A6, 0x059A, 0x0062,), '0061 059A 0316 302A 05A6 0062 -> Str -> 0061 302A 0316 05A6 059A 0062';
ok Uni.new(0x0061, 0x05A6, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x05A6, 0x0316, 0x059A, 0x0062,), '0061 05A6 059A 0316 302A 0062 -> Str -> 0061 302A 05A6 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x05A7, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x05A7, 0x059A, 0x0062,), '0061 059A 0316 302A 05A7 0062 -> Str -> 0061 302A 0316 05A7 059A 0062';
ok Uni.new(0x0061, 0x05A7, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x05A7, 0x0316, 0x059A, 0x0062,), '0061 05A7 059A 0316 302A 0062 -> Str -> 0061 302A 05A7 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x05A8, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x05A8, 0x0315, 0x0062,), '0061 0315 0300 05AE 05A8 0062 -> Str -> 00E0 05AE 05A8 0315 0062';
ok Uni.new(0x0061, 0x05A8, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x05A8, 0x0300, 0x0315, 0x0062,), '0061 05A8 0315 0300 05AE 0062 -> Str -> 0061 05AE 05A8 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x05A9, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x05A9, 0x0315, 0x0062,), '0061 0315 0300 05AE 05A9 0062 -> Str -> 00E0 05AE 05A9 0315 0062';
ok Uni.new(0x0061, 0x05A9, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x05A9, 0x0300, 0x0315, 0x0062,), '0061 05A9 0315 0300 05AE 0062 -> Str -> 0061 05AE 05A9 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x05AA, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x05AA, 0x059A, 0x0062,), '0061 059A 0316 302A 05AA 0062 -> Str -> 0061 302A 0316 05AA 059A 0062';
ok Uni.new(0x0061, 0x05AA, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x05AA, 0x0316, 0x059A, 0x0062,), '0061 05AA 059A 0316 302A 0062 -> Str -> 0061 302A 05AA 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x05AB, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x05AB, 0x0315, 0x0062,), '0061 0315 0300 05AE 05AB 0062 -> Str -> 00E0 05AE 05AB 0315 0062';
ok Uni.new(0x0061, 0x05AB, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x05AB, 0x0300, 0x0315, 0x0062,), '0061 05AB 0315 0300 05AE 0062 -> Str -> 0061 05AE 05AB 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x05AC, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x05AC, 0x0315, 0x0062,), '0061 0315 0300 05AE 05AC 0062 -> Str -> 00E0 05AE 05AC 0315 0062';
ok Uni.new(0x0061, 0x05AC, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x05AC, 0x0300, 0x0315, 0x0062,), '0061 05AC 0315 0300 05AE 0062 -> Str -> 0061 05AE 05AC 0300 0315 0062';
ok Uni.new(0x0061, 0x302E, 0x059A, 0x0316, 0x05AD, 0x0062).Str.NFC.list ~~ (0x0061, 0x0316, 0x059A, 0x05AD, 0x302E, 0x0062,), '0061 302E 059A 0316 05AD 0062 -> Str -> 0061 0316 059A 05AD 302E 0062';
ok Uni.new(0x0061, 0x05AD, 0x302E, 0x059A, 0x0316, 0x0062).Str.NFC.list ~~ (0x0061, 0x0316, 0x05AD, 0x059A, 0x302E, 0x0062,), '0061 05AD 302E 059A 0316 0062 -> Str -> 0061 0316 05AD 059A 302E 0062';
ok Uni.new(0x0061, 0x0300, 0x05AE, 0x1D16D, 0x05AE, 0x0062).Str.NFC.list ~~ (0x00E0, 0x1D16D, 0x05AE, 0x05AE, 0x0062,), '0061 0300 05AE 1D16D 05AE 0062 -> Str -> 00E0 1D16D 05AE 05AE 0062';
ok Uni.new(0x0061, 0x05AE, 0x0300, 0x05AE, 0x1D16D, 0x0062).Str.NFC.list ~~ (0x00E0, 0x1D16D, 0x05AE, 0x05AE, 0x0062,), '0061 05AE 0300 05AE 1D16D 0062 -> Str -> 00E0 1D16D 05AE 05AE 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x05AF, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x05AF, 0x0315, 0x0062,), '0061 0315 0300 05AE 05AF 0062 -> Str -> 00E0 05AE 05AF 0315 0062';
ok Uni.new(0x0061, 0x05AF, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x05AF, 0x0300, 0x0315, 0x0062,), '0061 05AF 0315 0300 05AE 0062 -> Str -> 0061 05AE 05AF 0300 0315 0062';
ok Uni.new(0x0061, 0x05B1, 0x05B0, 0x094D, 0x05B0, 0x0062).Str.NFC.list ~~ (0x0061, 0x094D, 0x05B0, 0x05B0, 0x05B1, 0x0062,), '0061 05B1 05B0 094D 05B0 0062 -> Str -> 0061 094D 05B0 05B0 05B1 0062';
ok Uni.new(0x0061, 0x05B0, 0x05B1, 0x05B0, 0x094D, 0x0062).Str.NFC.list ~~ (0x0061, 0x094D, 0x05B0, 0x05B0, 0x05B1, 0x0062,), '0061 05B0 05B1 05B0 094D 0062 -> Str -> 0061 094D 05B0 05B0 05B1 0062';
ok Uni.new(0x0061, 0x05B2, 0x05B1, 0x05B0, 0x05B1, 0x0062).Str.NFC.list ~~ (0x0061, 0x05B0, 0x05B1, 0x05B1, 0x05B2, 0x0062,), '0061 05B2 05B1 05B0 05B1 0062 -> Str -> 0061 05B0 05B1 05B1 05B2 0062';
ok Uni.new(0x0061, 0x05B1, 0x05B2, 0x05B1, 0x05B0, 0x0062).Str.NFC.list ~~ (0x0061, 0x05B0, 0x05B1, 0x05B1, 0x05B2, 0x0062,), '0061 05B1 05B2 05B1 05B0 0062 -> Str -> 0061 05B0 05B1 05B1 05B2 0062';
ok Uni.new(0x0061, 0x05B3, 0x05B2, 0x05B1, 0x05B2, 0x0062).Str.NFC.list ~~ (0x0061, 0x05B1, 0x05B2, 0x05B2, 0x05B3, 0x0062,), '0061 05B3 05B2 05B1 05B2 0062 -> Str -> 0061 05B1 05B2 05B2 05B3 0062';
ok Uni.new(0x0061, 0x05B2, 0x05B3, 0x05B2, 0x05B1, 0x0062).Str.NFC.list ~~ (0x0061, 0x05B1, 0x05B2, 0x05B2, 0x05B3, 0x0062,), '0061 05B2 05B3 05B2 05B1 0062 -> Str -> 0061 05B1 05B2 05B2 05B3 0062';
ok Uni.new(0x0061, 0x05B4, 0x05B3, 0x05B2, 0x05B3, 0x0062).Str.NFC.list ~~ (0x0061, 0x05B2, 0x05B3, 0x05B3, 0x05B4, 0x0062,), '0061 05B4 05B3 05B2 05B3 0062 -> Str -> 0061 05B2 05B3 05B3 05B4 0062';
ok Uni.new(0x0061, 0x05B3, 0x05B4, 0x05B3, 0x05B2, 0x0062).Str.NFC.list ~~ (0x0061, 0x05B2, 0x05B3, 0x05B3, 0x05B4, 0x0062,), '0061 05B3 05B4 05B3 05B2 0062 -> Str -> 0061 05B2 05B3 05B3 05B4 0062';
ok Uni.new(0x0061, 0x05B5, 0x05B4, 0x05B3, 0x05B4, 0x0062).Str.NFC.list ~~ (0x0061, 0x05B3, 0x05B4, 0x05B4, 0x05B5, 0x0062,), '0061 05B5 05B4 05B3 05B4 0062 -> Str -> 0061 05B3 05B4 05B4 05B5 0062';
ok Uni.new(0x0061, 0x05B4, 0x05B5, 0x05B4, 0x05B3, 0x0062).Str.NFC.list ~~ (0x0061, 0x05B3, 0x05B4, 0x05B4, 0x05B5, 0x0062,), '0061 05B4 05B5 05B4 05B3 0062 -> Str -> 0061 05B3 05B4 05B4 05B5 0062';
ok Uni.new(0x0061, 0x05B6, 0x05B5, 0x05B4, 0x05B5, 0x0062).Str.NFC.list ~~ (0x0061, 0x05B4, 0x05B5, 0x05B5, 0x05B6, 0x0062,), '0061 05B6 05B5 05B4 05B5 0062 -> Str -> 0061 05B4 05B5 05B5 05B6 0062';
ok Uni.new(0x0061, 0x05B5, 0x05B6, 0x05B5, 0x05B4, 0x0062).Str.NFC.list ~~ (0x0061, 0x05B4, 0x05B5, 0x05B5, 0x05B6, 0x0062,), '0061 05B5 05B6 05B5 05B4 0062 -> Str -> 0061 05B4 05B5 05B5 05B6 0062';
ok Uni.new(0x0061, 0x05B7, 0x05B6, 0x05B5, 0x05B6, 0x0062).Str.NFC.list ~~ (0x0061, 0x05B5, 0x05B6, 0x05B6, 0x05B7, 0x0062,), '0061 05B7 05B6 05B5 05B6 0062 -> Str -> 0061 05B5 05B6 05B6 05B7 0062';
ok Uni.new(0x0061, 0x05B6, 0x05B7, 0x05B6, 0x05B5, 0x0062).Str.NFC.list ~~ (0x0061, 0x05B5, 0x05B6, 0x05B6, 0x05B7, 0x0062,), '0061 05B6 05B7 05B6 05B5 0062 -> Str -> 0061 05B5 05B6 05B6 05B7 0062';
ok Uni.new(0x0061, 0x05B8, 0x05B7, 0x05B6, 0x05B7, 0x0062).Str.NFC.list ~~ (0x0061, 0x05B6, 0x05B7, 0x05B7, 0x05B8, 0x0062,), '0061 05B8 05B7 05B6 05B7 0062 -> Str -> 0061 05B6 05B7 05B7 05B8 0062';
ok Uni.new(0x0061, 0x05B7, 0x05B8, 0x05B7, 0x05B6, 0x0062).Str.NFC.list ~~ (0x0061, 0x05B6, 0x05B7, 0x05B7, 0x05B8, 0x0062,), '0061 05B7 05B8 05B7 05B6 0062 -> Str -> 0061 05B6 05B7 05B7 05B8 0062';
ok Uni.new(0x0061, 0x05B9, 0x05B8, 0x05B7, 0x05B8, 0x0062).Str.NFC.list ~~ (0x0061, 0x05B7, 0x05B8, 0x05B8, 0x05B9, 0x0062,), '0061 05B9 05B8 05B7 05B8 0062 -> Str -> 0061 05B7 05B8 05B8 05B9 0062';
ok Uni.new(0x0061, 0x05B8, 0x05B9, 0x05B8, 0x05B7, 0x0062).Str.NFC.list ~~ (0x0061, 0x05B7, 0x05B8, 0x05B8, 0x05B9, 0x0062,), '0061 05B8 05B9 05B8 05B7 0062 -> Str -> 0061 05B7 05B8 05B8 05B9 0062';
ok Uni.new(0x0061, 0x05BB, 0x05B9, 0x05B8, 0x05B9, 0x0062).Str.NFC.list ~~ (0x0061, 0x05B8, 0x05B9, 0x05B9, 0x05BB, 0x0062,), '0061 05BB 05B9 05B8 05B9 0062 -> Str -> 0061 05B8 05B9 05B9 05BB 0062';
ok Uni.new(0x0061, 0x05B9, 0x05BB, 0x05B9, 0x05B8, 0x0062).Str.NFC.list ~~ (0x0061, 0x05B8, 0x05B9, 0x05B9, 0x05BB, 0x0062,), '0061 05B9 05BB 05B9 05B8 0062 -> Str -> 0061 05B8 05B9 05B9 05BB 0062';
ok Uni.new(0x0061, 0x05BB, 0x05B9, 0x05B8, 0x05BA, 0x0062).Str.NFC.list ~~ (0x0061, 0x05B8, 0x05B9, 0x05BA, 0x05BB, 0x0062,), '0061 05BB 05B9 05B8 05BA 0062 -> Str -> 0061 05B8 05B9 05BA 05BB 0062';
ok Uni.new(0x0061, 0x05BA, 0x05BB, 0x05B9, 0x05B8, 0x0062).Str.NFC.list ~~ (0x0061, 0x05B8, 0x05BA, 0x05B9, 0x05BB, 0x0062,), '0061 05BA 05BB 05B9 05B8 0062 -> Str -> 0061 05B8 05BA 05B9 05BB 0062';
ok Uni.new(0x0061, 0x05BC, 0x05BB, 0x05B9, 0x05BB, 0x0062).Str.NFC.list ~~ (0x0061, 0x05B9, 0x05BB, 0x05BB, 0x05BC, 0x0062,), '0061 05BC 05BB 05B9 05BB 0062 -> Str -> 0061 05B9 05BB 05BB 05BC 0062';
ok Uni.new(0x0061, 0x05BB, 0x05BC, 0x05BB, 0x05B9, 0x0062).Str.NFC.list ~~ (0x0061, 0x05B9, 0x05BB, 0x05BB, 0x05BC, 0x0062,), '0061 05BB 05BC 05BB 05B9 0062 -> Str -> 0061 05B9 05BB 05BB 05BC 0062';
ok Uni.new(0x0061, 0x05BD, 0x05BC, 0x05BB, 0x05BC, 0x0062).Str.NFC.list ~~ (0x0061, 0x05BB, 0x05BC, 0x05BC, 0x05BD, 0x0062,), '0061 05BD 05BC 05BB 05BC 0062 -> Str -> 0061 05BB 05BC 05BC 05BD 0062';
ok Uni.new(0x0061, 0x05BC, 0x05BD, 0x05BC, 0x05BB, 0x0062).Str.NFC.list ~~ (0x0061, 0x05BB, 0x05BC, 0x05BC, 0x05BD, 0x0062,), '0061 05BC 05BD 05BC 05BB 0062 -> Str -> 0061 05BB 05BC 05BC 05BD 0062';
ok Uni.new(0x0061, 0x05BF, 0x05BD, 0x05BC, 0x05BD, 0x0062).Str.NFC.list ~~ (0x0061, 0x05BC, 0x05BD, 0x05BD, 0x05BF, 0x0062,), '0061 05BF 05BD 05BC 05BD 0062 -> Str -> 0061 05BC 05BD 05BD 05BF 0062';
ok Uni.new(0x0061, 0x05BD, 0x05BF, 0x05BD, 0x05BC, 0x0062).Str.NFC.list ~~ (0x0061, 0x05BC, 0x05BD, 0x05BD, 0x05BF, 0x0062,), '0061 05BD 05BF 05BD 05BC 0062 -> Str -> 0061 05BC 05BD 05BD 05BF 0062';
ok Uni.new(0x0061, 0x05C1, 0x05BF, 0x05BD, 0x05BF, 0x0062).Str.NFC.list ~~ (0x0061, 0x05BD, 0x05BF, 0x05BF, 0x05C1, 0x0062,), '0061 05C1 05BF 05BD 05BF 0062 -> Str -> 0061 05BD 05BF 05BF 05C1 0062';
ok Uni.new(0x0061, 0x05BF, 0x05C1, 0x05BF, 0x05BD, 0x0062).Str.NFC.list ~~ (0x0061, 0x05BD, 0x05BF, 0x05BF, 0x05C1, 0x0062,), '0061 05BF 05C1 05BF 05BD 0062 -> Str -> 0061 05BD 05BF 05BF 05C1 0062';
ok Uni.new(0x0061, 0x05C2, 0x05C1, 0x05BF, 0x05C1, 0x0062).Str.NFC.list ~~ (0x0061, 0x05BF, 0x05C1, 0x05C1, 0x05C2, 0x0062,), '0061 05C2 05C1 05BF 05C1 0062 -> Str -> 0061 05BF 05C1 05C1 05C2 0062';
ok Uni.new(0x0061, 0x05C1, 0x05C2, 0x05C1, 0x05BF, 0x0062).Str.NFC.list ~~ (0x0061, 0x05BF, 0x05C1, 0x05C1, 0x05C2, 0x0062,), '0061 05C1 05C2 05C1 05BF 0062 -> Str -> 0061 05BF 05C1 05C1 05C2 0062';
ok Uni.new(0x0061, 0xFB1E, 0x05C2, 0x05C1, 0x05C2, 0x0062).Str.NFC.list ~~ (0x0061, 0x05C1, 0x05C2, 0x05C2, 0xFB1E, 0x0062,), '0061 FB1E 05C2 05C1 05C2 0062 -> Str -> 0061 05C1 05C2 05C2 FB1E 0062';
ok Uni.new(0x0061, 0x05C2, 0xFB1E, 0x05C2, 0x05C1, 0x0062).Str.NFC.list ~~ (0x0061, 0x05C1, 0x05C2, 0x05C2, 0xFB1E, 0x0062,), '0061 05C2 FB1E 05C2 05C1 0062 -> Str -> 0061 05C1 05C2 05C2 FB1E 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x05C4, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x05C4, 0x0315, 0x0062,), '0061 0315 0300 05AE 05C4 0062 -> Str -> 00E0 05AE 05C4 0315 0062';
ok Uni.new(0x0061, 0x05C4, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x05C4, 0x0300, 0x0315, 0x0062,), '0061 05C4 0315 0300 05AE 0062 -> Str -> 0061 05AE 05C4 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x05C5, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x05C5, 0x059A, 0x0062,), '0061 059A 0316 302A 05C5 0062 -> Str -> 0061 302A 0316 05C5 059A 0062';
ok Uni.new(0x0061, 0x05C5, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x05C5, 0x0316, 0x059A, 0x0062,), '0061 05C5 059A 0316 302A 0062 -> Str -> 0061 302A 05C5 0316 059A 0062';
ok Uni.new(0x0061, 0x05B9, 0x05B8, 0x05B7, 0x05C7, 0x0062).Str.NFC.list ~~ (0x0061, 0x05B7, 0x05B8, 0x05C7, 0x05B9, 0x0062,), '0061 05B9 05B8 05B7 05C7 0062 -> Str -> 0061 05B7 05B8 05C7 05B9 0062';
ok Uni.new(0x0061, 0x05C7, 0x05B9, 0x05B8, 0x05B7, 0x0062).Str.NFC.list ~~ (0x0061, 0x05B7, 0x05C7, 0x05B8, 0x05B9, 0x0062,), '0061 05C7 05B9 05B8 05B7 0062 -> Str -> 0061 05B7 05C7 05B8 05B9 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0610, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0610, 0x0315, 0x0062,), '0061 0315 0300 05AE 0610 0062 -> Str -> 00E0 05AE 0610 0315 0062';
ok Uni.new(0x0061, 0x0610, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0610, 0x0300, 0x0315, 0x0062,), '0061 0610 0315 0300 05AE 0062 -> Str -> 0061 05AE 0610 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0611, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0611, 0x0315, 0x0062,), '0061 0315 0300 05AE 0611 0062 -> Str -> 00E0 05AE 0611 0315 0062';
ok Uni.new(0x0061, 0x0611, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0611, 0x0300, 0x0315, 0x0062,), '0061 0611 0315 0300 05AE 0062 -> Str -> 0061 05AE 0611 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0612, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0612, 0x0315, 0x0062,), '0061 0315 0300 05AE 0612 0062 -> Str -> 00E0 05AE 0612 0315 0062';
ok Uni.new(0x0061, 0x0612, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0612, 0x0300, 0x0315, 0x0062,), '0061 0612 0315 0300 05AE 0062 -> Str -> 0061 05AE 0612 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0613, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0613, 0x0315, 0x0062,), '0061 0315 0300 05AE 0613 0062 -> Str -> 00E0 05AE 0613 0315 0062';
ok Uni.new(0x0061, 0x0613, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0613, 0x0300, 0x0315, 0x0062,), '0061 0613 0315 0300 05AE 0062 -> Str -> 0061 05AE 0613 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0614, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0614, 0x0315, 0x0062,), '0061 0315 0300 05AE 0614 0062 -> Str -> 00E0 05AE 0614 0315 0062';
ok Uni.new(0x0061, 0x0614, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0614, 0x0300, 0x0315, 0x0062,), '0061 0614 0315 0300 05AE 0062 -> Str -> 0061 05AE 0614 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0615, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0615, 0x0315, 0x0062,), '0061 0315 0300 05AE 0615 0062 -> Str -> 00E0 05AE 0615 0315 0062';
ok Uni.new(0x0061, 0x0615, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0615, 0x0300, 0x0315, 0x0062,), '0061 0615 0315 0300 05AE 0062 -> Str -> 0061 05AE 0615 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0616, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0616, 0x0315, 0x0062,), '0061 0315 0300 05AE 0616 0062 -> Str -> 00E0 05AE 0616 0315 0062';
ok Uni.new(0x0061, 0x0616, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0616, 0x0300, 0x0315, 0x0062,), '0061 0616 0315 0300 05AE 0062 -> Str -> 0061 05AE 0616 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0617, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0617, 0x0315, 0x0062,), '0061 0315 0300 05AE 0617 0062 -> Str -> 00E0 05AE 0617 0315 0062';
ok Uni.new(0x0061, 0x0617, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0617, 0x0300, 0x0315, 0x0062,), '0061 0617 0315 0300 05AE 0062 -> Str -> 0061 05AE 0617 0300 0315 0062';
ok Uni.new(0x0061, 0x0619, 0x0618, 0x064D, 0x0618, 0x0062).Str.NFC.list ~~ (0x0061, 0x064D, 0x0618, 0x0618, 0x0619, 0x0062,), '0061 0619 0618 064D 0618 0062 -> Str -> 0061 064D 0618 0618 0619 0062';
ok Uni.new(0x0061, 0x0618, 0x0619, 0x0618, 0x064D, 0x0062).Str.NFC.list ~~ (0x0061, 0x064D, 0x0618, 0x0618, 0x0619, 0x0062,), '0061 0618 0619 0618 064D 0062 -> Str -> 0061 064D 0618 0618 0619 0062';
ok Uni.new(0x0061, 0x061A, 0x0619, 0x0618, 0x0619, 0x0062).Str.NFC.list ~~ (0x0061, 0x0618, 0x0619, 0x0619, 0x061A, 0x0062,), '0061 061A 0619 0618 0619 0062 -> Str -> 0061 0618 0619 0619 061A 0062';
ok Uni.new(0x0061, 0x0619, 0x061A, 0x0619, 0x0618, 0x0062).Str.NFC.list ~~ (0x0061, 0x0618, 0x0619, 0x0619, 0x061A, 0x0062,), '0061 0619 061A 0619 0618 0062 -> Str -> 0061 0618 0619 0619 061A 0062';
ok Uni.new(0x0061, 0x0651, 0x061A, 0x0619, 0x061A, 0x0062).Str.NFC.list ~~ (0x0061, 0x0619, 0x061A, 0x061A, 0x0651, 0x0062,), '0061 0651 061A 0619 061A 0062 -> Str -> 0061 0619 061A 061A 0651 0062';
ok Uni.new(0x0061, 0x061A, 0x0651, 0x061A, 0x0619, 0x0062).Str.NFC.list ~~ (0x0061, 0x0619, 0x061A, 0x061A, 0x0651, 0x0062,), '0061 061A 0651 061A 0619 0062 -> Str -> 0061 0619 061A 061A 0651 0062';
ok Uni.new(0x0061, 0x064C, 0x064B, 0xFB1E, 0x064B, 0x0062).Str.NFC.list ~~ (0x0061, 0xFB1E, 0x064B, 0x064B, 0x064C, 0x0062,), '0061 064C 064B FB1E 064B 0062 -> Str -> 0061 FB1E 064B 064B 064C 0062';
ok Uni.new(0x0061, 0x064B, 0x064C, 0x064B, 0xFB1E, 0x0062).Str.NFC.list ~~ (0x0061, 0xFB1E, 0x064B, 0x064B, 0x064C, 0x0062,), '0061 064B 064C 064B FB1E 0062 -> Str -> 0061 FB1E 064B 064B 064C 0062';
ok Uni.new(0x0061, 0x064D, 0x064C, 0x064B, 0x064C, 0x0062).Str.NFC.list ~~ (0x0061, 0x064B, 0x064C, 0x064C, 0x064D, 0x0062,), '0061 064D 064C 064B 064C 0062 -> Str -> 0061 064B 064C 064C 064D 0062';
ok Uni.new(0x0061, 0x064C, 0x064D, 0x064C, 0x064B, 0x0062).Str.NFC.list ~~ (0x0061, 0x064B, 0x064C, 0x064C, 0x064D, 0x0062,), '0061 064C 064D 064C 064B 0062 -> Str -> 0061 064B 064C 064C 064D 0062';
ok Uni.new(0x0061, 0x0618, 0x064D, 0x064C, 0x064D, 0x0062).Str.NFC.list ~~ (0x0061, 0x064C, 0x064D, 0x064D, 0x0618, 0x0062,), '0061 0618 064D 064C 064D 0062 -> Str -> 0061 064C 064D 064D 0618 0062';
ok Uni.new(0x0061, 0x064D, 0x0618, 0x064D, 0x064C, 0x0062).Str.NFC.list ~~ (0x0061, 0x064C, 0x064D, 0x064D, 0x0618, 0x0062,), '0061 064D 0618 064D 064C 0062 -> Str -> 0061 064C 064D 064D 0618 0062';
ok Uni.new(0x0061, 0x0619, 0x0618, 0x064D, 0x064E, 0x0062).Str.NFC.list ~~ (0x0061, 0x064D, 0x0618, 0x064E, 0x0619, 0x0062,), '0061 0619 0618 064D 064E 0062 -> Str -> 0061 064D 0618 064E 0619 0062';
ok Uni.new(0x0061, 0x064E, 0x0619, 0x0618, 0x064D, 0x0062).Str.NFC.list ~~ (0x0061, 0x064D, 0x064E, 0x0618, 0x0619, 0x0062,), '0061 064E 0619 0618 064D 0062 -> Str -> 0061 064D 064E 0618 0619 0062';
ok Uni.new(0x0061, 0x061A, 0x0619, 0x0618, 0x064F, 0x0062).Str.NFC.list ~~ (0x0061, 0x0618, 0x0619, 0x064F, 0x061A, 0x0062,), '0061 061A 0619 0618 064F 0062 -> Str -> 0061 0618 0619 064F 061A 0062';
ok Uni.new(0x0061, 0x064F, 0x061A, 0x0619, 0x0618, 0x0062).Str.NFC.list ~~ (0x0061, 0x0618, 0x064F, 0x0619, 0x061A, 0x0062,), '0061 064F 061A 0619 0618 0062 -> Str -> 0061 0618 064F 0619 061A 0062';
ok Uni.new(0x0061, 0x0651, 0x061A, 0x0619, 0x0650, 0x0062).Str.NFC.list ~~ (0x0061, 0x0619, 0x061A, 0x0650, 0x0651, 0x0062,), '0061 0651 061A 0619 0650 0062 -> Str -> 0061 0619 061A 0650 0651 0062';
ok Uni.new(0x0061, 0x0650, 0x0651, 0x061A, 0x0619, 0x0062).Str.NFC.list ~~ (0x0061, 0x0619, 0x0650, 0x061A, 0x0651, 0x0062,), '0061 0650 0651 061A 0619 0062 -> Str -> 0061 0619 0650 061A 0651 0062';
ok Uni.new(0x0061, 0x0652, 0x0651, 0x061A, 0x0651, 0x0062).Str.NFC.list ~~ (0x0061, 0x061A, 0x0651, 0x0651, 0x0652, 0x0062,), '0061 0652 0651 061A 0651 0062 -> Str -> 0061 061A 0651 0651 0652 0062';
ok Uni.new(0x0061, 0x0651, 0x0652, 0x0651, 0x061A, 0x0062).Str.NFC.list ~~ (0x0061, 0x061A, 0x0651, 0x0651, 0x0652, 0x0062,), '0061 0651 0652 0651 061A 0062 -> Str -> 0061 061A 0651 0651 0652 0062';
ok Uni.new(0x0061, 0x0670, 0x0652, 0x0651, 0x0652, 0x0062).Str.NFC.list ~~ (0x0061, 0x0651, 0x0652, 0x0652, 0x0670, 0x0062,), '0061 0670 0652 0651 0652 0062 -> Str -> 0061 0651 0652 0652 0670 0062';
ok Uni.new(0x0061, 0x0652, 0x0670, 0x0652, 0x0651, 0x0062).Str.NFC.list ~~ (0x0061, 0x0651, 0x0652, 0x0652, 0x0670, 0x0062,), '0061 0652 0670 0652 0651 0062 -> Str -> 0061 0651 0652 0652 0670 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0653, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0653, 0x0315, 0x0062,), '0061 0315 0300 05AE 0653 0062 -> Str -> 00E0 05AE 0653 0315 0062';
ok Uni.new(0x0061, 0x0653, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0653, 0x0300, 0x0315, 0x0062,), '0061 0653 0315 0300 05AE 0062 -> Str -> 0061 05AE 0653 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0654, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0654, 0x0315, 0x0062,), '0061 0315 0300 05AE 0654 0062 -> Str -> 00E0 05AE 0654 0315 0062';
ok Uni.new(0x0061, 0x0654, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0654, 0x0300, 0x0315, 0x0062,), '0061 0654 0315 0300 05AE 0062 -> Str -> 0061 05AE 0654 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0655, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0655, 0x059A, 0x0062,), '0061 059A 0316 302A 0655 0062 -> Str -> 0061 302A 0316 0655 059A 0062';
ok Uni.new(0x0061, 0x0655, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0655, 0x0316, 0x059A, 0x0062,), '0061 0655 059A 0316 302A 0062 -> Str -> 0061 302A 0655 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x0656, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x0656, 0x059A, 0x0062,), '0061 059A 0316 302A 0656 0062 -> Str -> 0061 302A 0316 0656 059A 0062';
ok Uni.new(0x0061, 0x0656, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0656, 0x0316, 0x059A, 0x0062,), '0061 0656 059A 0316 302A 0062 -> Str -> 0061 302A 0656 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0657, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0657, 0x0315, 0x0062,), '0061 0315 0300 05AE 0657 0062 -> Str -> 00E0 05AE 0657 0315 0062';
ok Uni.new(0x0061, 0x0657, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0657, 0x0300, 0x0315, 0x0062,), '0061 0657 0315 0300 05AE 0062 -> Str -> 0061 05AE 0657 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0658, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0658, 0x0315, 0x0062,), '0061 0315 0300 05AE 0658 0062 -> Str -> 00E0 05AE 0658 0315 0062';
ok Uni.new(0x0061, 0x0658, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0658, 0x0300, 0x0315, 0x0062,), '0061 0658 0315 0300 05AE 0062 -> Str -> 0061 05AE 0658 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x0659, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x0659, 0x0315, 0x0062,), '0061 0315 0300 05AE 0659 0062 -> Str -> 00E0 05AE 0659 0315 0062';
ok Uni.new(0x0061, 0x0659, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x0659, 0x0300, 0x0315, 0x0062,), '0061 0659 0315 0300 05AE 0062 -> Str -> 0061 05AE 0659 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x065A, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x065A, 0x0315, 0x0062,), '0061 0315 0300 05AE 065A 0062 -> Str -> 00E0 05AE 065A 0315 0062';
ok Uni.new(0x0061, 0x065A, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x065A, 0x0300, 0x0315, 0x0062,), '0061 065A 0315 0300 05AE 0062 -> Str -> 0061 05AE 065A 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x065B, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x065B, 0x0315, 0x0062,), '0061 0315 0300 05AE 065B 0062 -> Str -> 00E0 05AE 065B 0315 0062';
ok Uni.new(0x0061, 0x065B, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x065B, 0x0300, 0x0315, 0x0062,), '0061 065B 0315 0300 05AE 0062 -> Str -> 0061 05AE 065B 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x065C, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x065C, 0x059A, 0x0062,), '0061 059A 0316 302A 065C 0062 -> Str -> 0061 302A 0316 065C 059A 0062';
ok Uni.new(0x0061, 0x065C, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x065C, 0x0316, 0x059A, 0x0062,), '0061 065C 059A 0316 302A 0062 -> Str -> 0061 302A 065C 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x065D, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x065D, 0x0315, 0x0062,), '0061 0315 0300 05AE 065D 0062 -> Str -> 00E0 05AE 065D 0315 0062';
ok Uni.new(0x0061, 0x065D, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x065D, 0x0300, 0x0315, 0x0062,), '0061 065D 0315 0300 05AE 0062 -> Str -> 0061 05AE 065D 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x065E, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x065E, 0x0315, 0x0062,), '0061 0315 0300 05AE 065E 0062 -> Str -> 00E0 05AE 065E 0315 0062';
ok Uni.new(0x0061, 0x065E, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x065E, 0x0300, 0x0315, 0x0062,), '0061 065E 0315 0300 05AE 0062 -> Str -> 0061 05AE 065E 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x302A, 0x065F, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x0316, 0x065F, 0x059A, 0x0062,), '0061 059A 0316 302A 065F 0062 -> Str -> 0061 302A 0316 065F 059A 0062';
ok Uni.new(0x0061, 0x065F, 0x059A, 0x0316, 0x302A, 0x0062).Str.NFC.list ~~ (0x0061, 0x302A, 0x065F, 0x0316, 0x059A, 0x0062,), '0061 065F 059A 0316 302A 0062 -> Str -> 0061 302A 065F 0316 059A 0062';
ok Uni.new(0x0061, 0x0711, 0x0670, 0x0652, 0x0670, 0x0062).Str.NFC.list ~~ (0x0061, 0x0652, 0x0670, 0x0670, 0x0711, 0x0062,), '0061 0711 0670 0652 0670 0062 -> Str -> 0061 0652 0670 0670 0711 0062';
ok Uni.new(0x0061, 0x0670, 0x0711, 0x0670, 0x0652, 0x0062).Str.NFC.list ~~ (0x0061, 0x0652, 0x0670, 0x0670, 0x0711, 0x0062,), '0061 0670 0711 0670 0652 0062 -> Str -> 0061 0652 0670 0670 0711 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x06D6, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x06D6, 0x0315, 0x0062,), '0061 0315 0300 05AE 06D6 0062 -> Str -> 00E0 05AE 06D6 0315 0062';
ok Uni.new(0x0061, 0x06D6, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x06D6, 0x0300, 0x0315, 0x0062,), '0061 06D6 0315 0300 05AE 0062 -> Str -> 0061 05AE 06D6 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x06D7, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x06D7, 0x0315, 0x0062,), '0061 0315 0300 05AE 06D7 0062 -> Str -> 00E0 05AE 06D7 0315 0062';
ok Uni.new(0x0061, 0x06D7, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x06D7, 0x0300, 0x0315, 0x0062,), '0061 06D7 0315 0300 05AE 0062 -> Str -> 0061 05AE 06D7 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x06D8, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x06D8, 0x0315, 0x0062,), '0061 0315 0300 05AE 06D8 0062 -> Str -> 00E0 05AE 06D8 0315 0062';
ok Uni.new(0x0061, 0x06D8, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x06D8, 0x0300, 0x0315, 0x0062,), '0061 06D8 0315 0300 05AE 0062 -> Str -> 0061 05AE 06D8 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x06D9, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x06D9, 0x0315, 0x0062,), '0061 0315 0300 05AE 06D9 0062 -> Str -> 00E0 05AE 06D9 0315 0062';
ok Uni.new(0x0061, 0x06D9, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x06D9, 0x0300, 0x0315, 0x0062,), '0061 06D9 0315 0300 05AE 0062 -> Str -> 0061 05AE 06D9 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x06DA, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x06DA, 0x0315, 0x0062,), '0061 0315 0300 05AE 06DA 0062 -> Str -> 00E0 05AE 06DA 0315 0062';
ok Uni.new(0x0061, 0x06DA, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x06DA, 0x0300, 0x0315, 0x0062,), '0061 06DA 0315 0300 05AE 0062 -> Str -> 0061 05AE 06DA 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x06DB, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x06DB, 0x0315, 0x0062,), '0061 0315 0300 05AE 06DB 0062 -> Str -> 00E0 05AE 06DB 0315 0062';
ok Uni.new(0x0061, 0x06DB, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x06DB, 0x0300, 0x0315, 0x0062,), '0061 06DB 0315 0300 05AE 0062 -> Str -> 0061 05AE 06DB 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x06DC, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x06DC, 0x0315, 0x0062,), '0061 0315 0300 05AE 06DC 0062 -> Str -> 00E0 05AE 06DC 0315 0062';
ok Uni.new(0x0061, 0x06DC, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x06DC, 0x0300, 0x0315, 0x0062,), '0061 06DC 0315 0300 05AE 0062 -> Str -> 0061 05AE 06DC 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x06DF, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x06DF, 0x0315, 0x0062,), '0061 0315 0300 05AE 06DF 0062 -> Str -> 00E0 05AE 06DF 0315 0062';
ok Uni.new(0x0061, 0x06DF, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x06DF, 0x0300, 0x0315, 0x0062,), '0061 06DF 0315 0300 05AE 0062 -> Str -> 0061 05AE 06DF 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x06E0, 0x0062).Str.NFC.list ~~ (0x00E0, 0x05AE, 0x06E0, 0x0315, 0x0062,), '0061 0315 0300 05AE 06E0 0062 -> Str -> 00E0 05AE 06E0 0315 0062';
ok Uni.new(0x0061, 0x06E0, 0x0315, 0x0300, 0x05AE, 0x0062).Str.NFC.list ~~ (0x0061, 0x05AE, 0x06E0, 0x0300, 0x0315, 0x0062,), '0061 06E0 0315 0300 05AE 0062 -> Str -> 0061 05AE 06E0 0300 0315 0062';
