% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_umls.R
\name{get_umls_from_vocabulary}
\alias{get_umls_from_vocabulary}
\title{Retrieves mappings from different vocabularies associated to a disease, or list of diseases and generates an \code{DataGeNET.DGN}}
\usage{
get_umls_from_vocabulary(
  disease,
  vocabulary,
  api_key = NULL,
  allowed_vocabularies = c("UMLS", "OMIM", "NCI", "MESH", "ICD9CM", "ICD10", "EFO", "DO",
    "HPO", "ORDO", "NAME")
)
}
\arguments{
\item{disease}{A disease or a list of disease identifiers (CUIs, MeSH, OMIMs...)}

\item{vocabulary}{The vocabulary of the disease identifier(s)
Select one of the available:  \code{UMLS} (UMLS), \code{OMIM} (OMIM),
\code{MESH} (MeSH), \code{DO} (Disease Ontology),
\code{NCI} (NCI thesaurus), \code{ORDO} (Orphanet),
\code{ICD9CM} (ICD9-CM) or \code{EFO} (EFO). Default \code{'UMLS'}.}

\item{verbose}{By default \code{FALSE}. Change it to \code{TRUE} to get a
on-time log from the function.}

\item{warnings}{By default \code{TRUE}. Change it to \code{FALSE} to don't see
the warnings.}
}
\value{
An object of class \code{DataGeNET.DGN}
}
\description{
Given the disease identifier for one or multiple diseases retrieves the mappings to other vocabularies
from DisGeNET and creates an object of type \code{DataGeNET.DGN}.
}
\examples{
dis_res <- get_umls_from_vocabulary( "	D000130", vocabulary = "MESH"  )
}
