\name{wst2D}
\alias{wst2D}
\title{(Packet-ordered) 2D non-decimated wavelet transform.}
\description{
This function computes the (packet-ordered) 2D non-decimated wavelet transform
}
\usage{
wst2D(m, filter.number=10, family="DaubLeAsymm")
}
\arguments{
\item{m}{A matrix containing the image data that you wish to decompose. Each dimension of the matrix must be the same power of 2.}
\item{filter.number}{This selects the smoothness of wavelet that you want to use in the decomposition. By default this is 10, the Daubechies least-asymmetric orthonormal compactly supported wavelet with 10 vanishing moments.}
\item{family}{specifies the family of wavelets that you want to use. Two popular options are "DaubExPhase" and "DaubLeAsymm" but see the help for \code{\link{filter.select}} for more possibilities.}
}
\details{
The \code{wst2D} computes the (packet-ordered) 2D non-decimated discrete wavelet transform. Such a transform may be used in wavelet shrinkage of images using the \code{\link{AvBasis.wst2D}} function to perform an "average-basis" inverse. Such a transform was used to denoise images in the paper by Lang, Guo, Odegard, Burrus and Wells, 1995. 

The algorithm works by mixing the HH, GH, HG and GG image operators of the 2D (decimated) discrete wavelet transform (see Mallat, 1989 and the implementation in WaveThresh called \code{\link{imwd}}) with the shift operator S (as documented in Nason and Silverman, 1995) to form new operators (as given in the help to \code{\link{getpacket.wst2D}}). 

Subimages can be obtained and replaced using the \code{\link{getpacket.wst2D}} and \code{\link{putpacket.wst2D}} functions. 

This function is a 2D analogue of the (packet-ordered) non-decimated discrete wavelet transform implemented in WaveThresh as \code{\link{wst}}. 
}
\value{
An object of class \code{\link{wst2D}}. 
}
\section{RELEASE}{Version 3.9.5 Copyright Guy Nason 1998}
\seealso{
\code{\link{AvBasis.wst2D}}, \code{\link{getpacket.wst2D}}, \code{\link{imwd}}, \code{\link{plot.wst2D}}, \code{\link{print.wst2D}}, \code{\link{putpacket.wst2D}}, \code{\link{summary.wst2D}}, \code{\link{wst2D.object}}.
}
\examples{
#
# We shall use the lennon image.
#
data(lennon)
#
#
# Now let's apply the (packet-ordered) 2D non-decimated DWT to it...
# (using the default wavelets)
#
uawst2D <- wst2D(lennon)
#
# One can use the function plot.wst2D to get
# a picture of all the resolution levels. However, let's just look at them
# one at a time.
#
# How many levels does our uawst2D object have? 
#
nlevelsWT(uawst2D)
#[1] 8
#
# O.k. Let's look at resolution level 7
#
\dontrun{image(uawst2D$wst2D[8,,])}
#
#
# There are four main blocks here (each of 256x256 pixels) which themselves
# contain four sub-blocks. The primary blocks correspond to the no shift,
# horizontal shift, vertical shift and "horizontal and vertical" shifts
# generated by the shift S operator. Within each of the 256x256 blocks
# we have the "usual" Mallat smooth, horizontal, vertical and diagonal
# detail, with the smooth in the top left of each block.
#
# Let's extract the smooth, with no shifts at level 7 and display it
#
\dontrun{image(getpacket(uawst2D, level=7, index=0, type="S"))}
#
#
# Now if we go two more resolution levels deeper we have now 64x64 blocks
# which contain 32x32 subblocks corresponding to the smooth, horizontal,
# vertical and diagonal detail. 
#
#
# Groovy eh?
}
\keyword{math}
\keyword{smooth}
\keyword{nonlinear}
\author{G P Nason}
