% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stubs.R
\name{versionInfo}
\alias{versionInfo}
\title{RStudio version information}
\usage{
versionInfo()
}
\value{
An \R list with the following elements:

\tabular{ll}{
\code{version} \tab The version of RStudio. \cr
\code{mode} \tab \code{"desktop"} for RStudio Desktop, or \code{"server"} for RStudio Server. \cr
\code{citation} \tab Information on how RStudio can be cited in academic publications. \cr
}
}
\description{
Query information about the currently running instance of RStudio.
}
\note{
The \code{versionInfo} function was added in version 0.97.124 of
RStudio.
}
\examples{

\dontrun{
info <- rstudioapi::versionInfo()

# check what version of RStudio is in use
if (info$version >= "1.4") {
  # code specific to versions of RStudio 1.4 and newer
}

# check whether RStudio Desktop or RStudio Server is being used
if (info$mode == "desktop") {
  # code specific to RStudio Desktop
}

# Get the citation
info$citation

}

}
