% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.load.R
\name{list.load}
\alias{list.load}
\title{Load a list from file}
\usage{
list.load(
  file,
  type = tools::file_ext(file),
  ...,
  guess = c("json", "yaml", "rds", "rdata", "xml"),
  action = c("none", "merge", "ungroup"),
  progress = length(file) >= 5L
)
}
\arguments{
\item{file}{a \code{character} vector. The file as input.}

\item{type}{The type of input which, by default, is determined
by file extension. Currently supports RData, RDS, JSON, YAML.}

\item{...}{Additional parameters passed to the loader function}

\item{guess}{a \code{character} vector to guess iteratively if
\code{type} of \code{file} is unrecognized, \code{NA} or empty
string.}

\item{action}{The post-processing action if multiple files are
supplied. This parameter will be ignored if only a single file
is supplied.

\code{'none'} (default) to leave the resulted list as
a list of elements corresponding to elements in \code{file}
vector.

\code{'merge'} to merge the list elements iteratively,
the later lists always modify the former ones through
\code{modifyList}.

\code{'ungroup'} to ungroup the list elements, especially when
each file is a page of elements with identical structure.}

\item{progress}{\code{TRUE} to show a text progress bar in console
while loading files. By default, if \code{file} contains 5 elements,
then the progress bar will automatically be triggered to indicate
loading progress.}
}
\description{
Load a list from file
}
\examples{
\dontrun{
list.load('list.rds')
list.load('list.rdata')
list.load('list.yaml')
list.load('list.json')
}
}
