## Copyright 2010-2014 Sebastian Gibb
## <mail@sebastiangibb.de>
##
## This file is part of readBrukerFlexData for R and related languages.
##
## readBrukerFlexData is free software: you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation, either version 3 of the License, or
## (at your option) any later version.
##
## readBrukerFlexData is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with readBrukerFlexData. If not, see <http://www.gnu.org/licenses/>

#' The readBrukerFlexData Package
#'
#' The readBrukerFlexData package reads data files acquired by MALDI-TOF MS on
#' Bruker Daltonics machines of the *flex series. (autoflex,
#' microflex, ultraflex). \cr
#' The package was developed \emph{without} any knowledge nor even support by
#' Bruker Daltonics.
#' \cr \cr
#' All trademarks are owned by or licensed to Bruker Daltonics.
#'
#' \tabular{ll}{
#'
#' Package: \tab readBrukerFlexData \cr
#'
#' Version: \tab 1.8.2\cr
#'
#' Date: \tab 2014-12-15\cr
#'
#' License: \tab GPL (>= 3)\cr
#'
#' URL: \tab \url{https://github.com/sgibb/readBrukerFlexData}\cr
#'
#' }
#'
#' @docType package
#' @name readBrukerFlexData-package
#' @author Sebastian Gibb \email{mail@@sebastiangibb.de}
#' @references \url{https://github.com/sgibb/readBrukerFlexData}
#' @keywords package
#' @rdname readBrukerFlexData-package
#'
NULL

#' These functions are defunct and no longer available.
#'
#' \describe{
#'  \item{mqReadBrukerFlex:}{use
#'    \code{\link[MALDIquantForeign]{importBrukerFlex}} instead.}
#' }
#'
#' @title Removed functions in package \pkg{readBrukerFlexData}
#' @keywords internal
#' @name readBrukerFlexData-defunct
#' @aliases mqReadBrukerFlex
#' @rdname readBrukerFlexData-defunct
#'
NULL

