% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.r
\name{ms}
\alias{ms}
\alias{hm}
\alias{hms}
\title{Parse periods with \strong{h}our, \strong{m}inute, and \strong{s}econd components}
\usage{
ms(..., quiet = FALSE, roll = FALSE)

hm(..., quiet = FALSE, roll = FALSE)

hms(..., quiet = FALSE, roll = FALSE)
}
\arguments{
\item{...}{a character vector of hour minute second triples}

\item{quiet}{logical. When TRUE function evalueates without displaying
customary messages.}

\item{roll}{logical. When TRUE, smaller units are rolled over to higher units
if they exceed the conventional limit. For example,
\code{hms("01:59:120", roll=TRUE)} produces period "2H 1M 0S".}
}
\value{
a vector of period objects
}
\description{
Transforms a character or numeric vector into a period object with the
specified number of hours, minutes, and seconds. hms() recognizes all
non-numeric characters except '-' as separators ('-' is used for negative
durations).  After hours, minutes and seconds have been parsed, the
remaining input is ignored.
}
\examples{
ms(c("09:10", "09:02", "1:10"))
ms("7 6")
ms("6,5")
hm(c("09:10", "09:02", "1:10"))
hm("7 6")
hm("6,5")

x <- c("09:10:01", "09:10:02", "09:10:03")
hms(x)

hms("7 6 5", "3:23:::2", "2 : 23 : 33", "Finished in 9 hours, 20 min and 4 seconds")
}
\seealso{
\code{\link[=hm]{hm()}}, \code{\link[=ms]{ms()}}
}
\keyword{period}
