% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_circlepack.R
\name{layout_tbl_graph_circlepack}
\alias{layout_tbl_graph_circlepack}
\title{Calculate nodes as circles packed within their parent circle}
\usage{
layout_tbl_graph_circlepack(
  graph,
  weight = NULL,
  circular = FALSE,
  sort.by = NULL,
  direction = "out"
)
}
\arguments{
\item{graph}{An \code{tbl_graph} object}

\item{weight}{An optional node variable to use as weight. Will only affect
the weight of leaf nodes as the weight of non-leaf nodes are derived from
their children.}

\item{circular}{Logical. Should the layout be transformed to a circular
representation. Ignored.}

\item{sort.by}{The name of a node variable to sort the nodes by.}

\item{direction}{The direction of the tree in the graph. \code{'out'} (default)
means that parents point towards their children, while \code{'in'} means that
children point towards their parent.}
}
\value{
A data.frame with the columns \code{x}, \code{y}, \code{r}, \code{leaf},
\code{depth}, \code{circular} as well as any information stored as node
variables in the tbl_graph object.
}
\description{
The circle packing algorithm is basically a treemap using circles instead of
rectangles. Due to the nature of circles they cannot be packed as efficiently
leading to increased amount of "empty space" as compared to a treemap. This
can be beneficial though, as the added empty space can aid in visually
showing the hierarchy.
}
\details{
The circle packing is based on the algorithm developed by Weixin Wang and
collaborators which tries to find the most dense packing of circles as they
are added, one by one. This makes the algorithm very dependent on the order
in which circles are added and it is possible that layouts could sometimes
be optimized by choosing a different ordering. The algorithm for finding the
enclosing circle is the randomized incremental algorithm proposed by Emo
Welzl. Both of the above algorithms are the same as used in the D3.js
implementation of circle packing and their C++ implementation in ggraph is
inspired by Mike Bostocks JavaScript implementation.
}
\note{
Circle packing is a layout intended for trees, that is, graphs where nodes
only have one parent and zero or more children. If the provided graph does
not fit this format an attempt to convert it to such a format will be made.
}
\references{
Wang, W., Wang, H. H., Dai, G., & Wang, H. (2006). \emph{Visualization of
large hierarchical data by circle packing}. Chi, 517-520.

Welzl, E. (1991). \emph{Smallest enclosing disks (balls and ellipsoids)}. New
Results and New Trends in Computer Science, 359-370.
}
\seealso{
Other layout_tbl_graph_*: 
\code{\link{layout_tbl_graph_auto}()},
\code{\link{layout_tbl_graph_backbone}()},
\code{\link{layout_tbl_graph_centrality}()},
\code{\link{layout_tbl_graph_dendrogram}()},
\code{\link{layout_tbl_graph_eigen}()},
\code{\link{layout_tbl_graph_fabric}()},
\code{\link{layout_tbl_graph_focus}()},
\code{\link{layout_tbl_graph_hive}()},
\code{\link{layout_tbl_graph_igraph}()},
\code{\link{layout_tbl_graph_linear}()},
\code{\link{layout_tbl_graph_manual}()},
\code{\link{layout_tbl_graph_matrix}()},
\code{\link{layout_tbl_graph_partition}()},
\code{\link{layout_tbl_graph_pmds}()},
\code{\link{layout_tbl_graph_stress}()},
\code{\link{layout_tbl_graph_treemap}()},
\code{\link{layout_tbl_graph_unrooted}()}
}
\concept{layout_tbl_graph_*}
