% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encrypt.R
\name{encrypt}
\alias{encrypt}
\title{Encrypt or sign a message}
\usage{
encrypt(msg, encrypt = TRUE, sign = TRUE, public_key = TRUE)
}
\arguments{
\item{msg}{A message object.}

\item{encrypt}{Whether to encrypt the message. If \code{TRUE} then the entire
message will be encrypted using the private key of the sender.}

\item{sign}{Whether to sign the message. If \code{TRUE} then the entire message will be signed using the private key of the sender.}

\item{public_key}{Whether to attach a public key. If \code{TRUE} then the public key of the sender will be attached.}
}
\value{
A message object.
}
\description{
Specify whether the message should be encrypted, signed or have a public key attached.
}
\details{
If a recipient's email client is unable to decrypt an encrypted message then they will not be able to access the message contents.
}
\examples{
\dontrun{
msg <- envelope(
  to = "schunk@u-boat.com",
  subject = "Top Secret Message",
  text = "Immediate readiness. There are indications that the invasion has begun."
)
msg \%>\% encrypt()
}
}
