% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5I.R
\name{H5Iis_valid}
\alias{H5Iis_valid}
\title{Determine whether an identifier is valid}
\usage{
H5Iis_valid(h5identifier)
}
\arguments{
\item{h5identifier}{Object of class \linkS4class{H5IdComponent}.}
}
\value{
A logical of length 1.  \code{TRUE} is the identifier is valid,
\code{FALSE} if not.
}
\description{
An identifier is no longer valid after it has been closed.
}
\examples{

h5file <- system.file("testfiles", "h5ex_t_array.h5", package="rhdf5")
fid <- H5Fopen(h5file)

## test whether the identifer to the opened file is valid
H5Iis_valid(fid)

## the file ID is no longer valid after it has been closed
H5Fclose(fid)
H5Iis_valid(fid)

}
