% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveArray.R
\name{saveArray}
\alias{saveArray}
\alias{stageObject,array-method}
\alias{stageObject,Matrix-method}
\alias{saveObject,array-method}
\alias{saveObject,denseMatrix-method}
\title{Save a multi-dimensional array to disk}
\usage{
\S4method{saveObject}{array}(x, path, ...)

\S4method{saveObject}{denseMatrix}(x, path, ...)
}
\arguments{
\item{x}{An integer, numeric, logical or character array.
Alternatively, any of the \linkS4class{denseMatrix} subclasses from the \pkg{Matrix} package.}

\item{path}{String containing the path to a directory in which to save \code{x}.}

\item{...}{Further arguments, currently ignored.}
}
\value{
\code{x} is saved to \code{path} and \code{NULL} is invisibly returned.
}
\description{
Save a high-dimensional array to its on-disk representations.
}
\examples{
mat <- array(rpois(10000, 10), c(50, 20, 10))
dimnames(mat) <- list(
   paste0("GENE_", seq_len(nrow(mat))),
   letters[1:20],
   NULL
)

dir <- tempfile()
saveObject(mat, dir)
list.files(dir)

}
\seealso{
\code{\link{readArray}}, to read the directory contents back into the R session.
}
\author{
Aaron Lun
}
